/* Copyright (c) 2019 Synology Inc. All rights reserved. */

Ext.define("SYNO.SS.App.HomeMode.GeofenceGuidePanel",{extend:"SYNO.ux.Panel",parentWin:null,panelMain:null,panelContent:null,btnPrevPage:null,btnNextPage:null,dotList:[],PAGE_CNT:2,CONTENT_WIDTH:652,constructor:function(a){this.parentWin=a;this.Init();this.callParent([{cls:"hm-geofence-guide",border:false,layout:{type:"vbox",align:"stretch"},items:[this.panelMain],listeners:{afterrender:function(){this.GoPage(0)},scope:this}}])},Init:function(){var d;var f,c,b;var a,e;this.btnPrevPage=new Ext.BoxComponent({cls:"hm-geofence-prev-page",listeners:{afterrender:function(){this.mon(this.btnPrevPage.getEl(),"click",function(g,h){var j=this.GetCurPage();if(0<j){this.GoPage(j-1)}},this)},scope:this}});this.btnNextPage=new Ext.BoxComponent({cls:"hm-geofence-next-page",listeners:{afterrender:function(){this.mon(this.btnNextPage.getEl(),"click",function(g,h){var j=this.GetCurPage();if((this.dotList.size()-1)>j){this.GoPage(j+1)}},this)},scope:this}});this.dotList=[];for(d=0;d<this.PAGE_CNT;d++){b=this.CreatePageDot(d);this.dotList.push(b)}a=new Ext.Container({width:this.CONTENT_WIDTH,style:"padding-top:44px;",layout:{type:"vbox",align:"center",pack:"end"},items:[{xtype:"box",cls:"hm-geofence-intro"},{xtype:"syno_displayfield",cls:"hm-geofence-guide-label",width:510,hideLabel:true,value:_T("home_mode","geofence_guide_intro")}]});e=new Ext.Container({width:this.CONTENT_WIDTH,style:"padding-top:44px;",layout:{type:"vbox",align:"center",pack:"end"},items:[{xtype:"box",cls:"hm-geofence-mobile"},{xtype:"syno_displayfield",cls:"hm-geofence-guide-label",width:510,hideLabel:true,value:_T("home_mode","geofence_guide_mobile_setting")}]});this.panelContent=new Ext.Container({cls:"hm-geofence-guide-content",height:408,layout:{type:"hbox",align:"middle",pack:"center"},items:[a,e]});c=new Ext.Container({region:"center",layout:{type:"vbox",align:"center",pack:"end"},items:[this.panelContent]});f=new Ext.Container({cls:"hm-geofence-dot-panel",region:"south",height:90,layout:{type:"hbox",align:"middle",pack:"center",defaultMargins:{top:0,right:2,bottom:0,left:2}},items:this.dotList});this.panelMain=new SYNO.ux.Panel({layout:"border",flex:1,items:[{region:"west",xtype:"container",style:"padding-left: 21px",width:170,layout:{type:"hbox",align:"middle",pack:"start"},items:[this.btnPrevPage]},{region:"east",xtype:"container",style:"padding-right: 21px",width:170,layout:{type:"hbox",align:"middle",pack:"end"},items:[this.btnNextPage]},f,c]})},CreatePageDot:function(b){var a=new Ext.BoxComponent({cls:"hm-geofence-dot",listeners:{afterrender:function(){this.mon(a.getEl(),"click",function(c,d){this.GoPage(b)},this)},scope:this}});return a},GoPage:function(b){var a,c;for(a=0;a<this.dotList.size();a++){this.dotList[a].removeClass("active")}this.dotList[b].addClass("active");this.btnPrevPage.setDisabled(0>=b);this.btnNextPage.setDisabled((this.dotList.size()-1)<=b);if(true===this.panelContent.rendered){c=String.format("{0}px",(b*(-this.CONTENT_WIDTH)));this.panelContent.getLayout().innerCt.setStyle("left",c)}},GetCurPage:function(){if(!this.rendered){return -1}var a;for(a=0;a<this.dotList.size();a++){if(true===this.dotList[a].el.hasClass("active")){return a}}return 0}});Ext.define("SYNO.SS.App.HomeMode.GeofencePanel",{extend:"SYNO.ux.Panel",parentWin:null,btnShowMap:null,btnEditMap:null,labelBindingMobiles:null,labelSetting:null,labelAddr:null,panelGuide:null,panelMain:null,ctInfo:null,ctBtn:null,ctMap:null,geoMapId:null,geoMap:null,geoMapOption:null,geoHomeMarker:null,geoHomeCircle:null,mobileList:null,MAP_MIN_WIDTH:720,MAP_MIN_HEIGHT:405,FIELD_WIDTH:250,CLS_LINK:"hyperlink-bold",PAGE_INDEX:{MAIN:0,GUIDE:1},constructor:function(a){this.parentWin=a;this.Init();this.callParent([{border:false,layout:"card",items:[this.panelMain,this.panelGuide]}]);this.InitEventHandler()},Init:function(){this.InitMainPanel();this.InitGuidePanel()},GetCtInfoItemConfig:function(b,a){return{xtype:"container",layout:{type:"hbox",align:"middle"},items:[{xtype:"syno_displayfield",style:"padding-right: 6px; margin-bottom: 4px;",width:this.FIELD_WIDTH,value:b+":"},a]}},InitMainPanel:function(){this.labelBindingMobiles=new SYNO.ux.DisplayField({value:"--",minWidth:480,hidden:false,listeners:{afterrender:function(){this.mon(this.labelBindingMobiles.getEl(),"click",function(a,b){if("a"===b.tagName.toLowerCase()){SYNO.SS.App.HomeMode.MobileWin.OpenMobileWin(this.parentWin.getAppDSId())}}.createDelegate(this))},scope:this}});this.labelSetting=new SYNO.ux.DisplayField({height:28,minWidth:480,value:"--"});this.labelAddr=new SYNO.ux.DisplayField({cls:"hm-label-addr",height:28,minWidth:480,value:_T("ss_common","status_unknown")});this.ctInfo=new Ext.Container({height:92,style:"padding-bottom: 8px;",layout:{type:"vbox",align:"stretch"},items:[this.GetCtInfoItemConfig(_T("home_mode","binding_devices"),this.labelBindingMobiles),this.GetCtInfoItemConfig(_T("ss_common","setting"),this.labelSetting),this.GetCtInfoItemConfig(_T("home_mode","address"),this.labelAddr)]});this.btnShowMap=new SYNO.ux.Button({text:_T("ss_common","show_map"),disabled:(false===SYNO.SDS.GoogleMapLoaded),enableToggle:true,toggleHandler:function(b,a){if(true===a){this.ctMap.show();this.FitHeight();this.RefreshGeoMap();this.UpdateMapSize()}else{this.ctMap.hide();this.FitHeight()}},scope:this});this.btnEditMap=new SYNO.ux.Button({text:_T("home_mode","set_position"),disabled:(false===SYNO.SDS.GoogleMapLoaded),handler:function(){var a=new SYNO.SS.App.HomeMode.GeofenceEditPanel(this.parentWin.setting,this.parentWin,this.parentWin.getAppDSId());a.show()},scope:this});this.ctBtn=new Ext.Container({height:42,style:"padding-bottom: 4px;",items:[this.btnShowMap,this.btnEditMap]});this.geoMapId=String.format("geofence_map_{0}",Ext.id());this.ctMap=new Ext.Container({id:this.geoMapId,cls:"hm-geo-map-ct",hidden:true,minWidth:this.MAP_MIN_WIDTH,minHeight:this.MAP_MIN_HEIGHT,listeners:{resize:this.RefreshGeoMap,scope:this}});this.panelMain=new Ext.Container({layout:{type:"vbox",align:"stretch"},items:[this.ctInfo,this.ctBtn,this.ctMap]})},InitGuidePanel:function(){this.panelGuide=new Ext.Container({width:652,layout:{type:"vbox",align:"center"},items:[{xtype:"box",cls:"hm-geofence-intro"},{xtype:"syno_displayfield",cls:"hm-geofence-guide-label",width:510,hideLabel:true,value:_T("home_mode","geofence_guide_intro")}]})},InitEventHandler:function(){this.mon(this,"resize",function(){this.labelAddr.setWidth(this.getInnerWidth()-this.FIELD_WIDTH)})},UpdateUI:function(d){var b;var f;var a,e,g,h;var c=false;if(true===Ext.isDefined(d.geo_mobiles)){this.mobileList=d.geo_mobiles;if(1<this.mobileList.size()){f=this.mobileList.size()+" "+_T("home_mode","devices")}else{if(1===this.mobileList.size()){f=this.mobileList[0].name}else{f="No binding device"}}b=String.format('<a class="{0}">{1}</a>',this.CLS_LINK,f);this.labelBindingMobiles.setValue(b);if(0===this.mobileList.size()){this.GoPage(this.PAGE_INDEX.GUIDE)}else{this.GoPage(this.PAGE_INDEX.MAIN);c=this.mobileList.some(function(j){return j.bind_wifi})}}a=String.format("{0}: {1} {2}",_T("home_mode","radius"),d.geo_radius,_T("ss_common","meters"));if(60<=d.geo_delay_time){g=Math.round(d.geo_delay_time/60)+" "+_T("ss_common","common_minute")}else{if(0<d.geo_delay_time){g=d.geo_delay_time+" "+_T("ss_common","common_second")}else{g=_T("ss_common","common_none")}}e=String.format("{0}: {1}",_T("home_mode","trigger_delay"),g);h=String.format("{0} / {1}",a,e);if(true===c){h+=String.format(" / {0}: {1}",_T("home_mode","wifi_ssid"),d.wifi_ssid)}this.labelSetting.setValue(h);if(true===SYNO.SDS.GoogleMapLoaded){if(!this.geoMap){this.RenderGeoMap(d)}else{this.UpdateGeoMap(d)}}this.doLayout()},RenderGeoMap:function(c){if(false===this.ctMap.rendered){return}var a=function(){this.geoMap.panTo(this.geoHomeMarker.getPosition())}.createDelegate(this);var b=new google.maps.LatLng(c.geo_lat,c.geo_lng);this.geoMapOption={center:b,zoom:17};this.geoMap=new google.maps.Map(document.getElementById(this.geoMapId),this.geoMapOption);this.geoMap.addListener("resize",function(){Ext.defer(a,10,this)}.createDelegate(this));this.geoHomeMarker=new google.maps.Marker({position:b,map:this.geoMap,title:"Home"});this.geoHomeCircle=new google.maps.Circle({strokeColor:"#0079BC",strokeOpacity:0.3,strokeWeight:1,fillColor:"#0079BC",fillOpacity:0.3,map:this.geoMap,center:b,radius:c.geo_radius});this.geoHomeCircle.bindTo("center",this.geoHomeMarker,"position");this.UpdateAddress()},UpdateGeoMap:function(a){var b=new google.maps.LatLng(a.geo_lat,a.geo_lng);if((true===this.geoHomeMarker.getPosition().equals(b))&&(this.geoHomeCircle.getRadius()===a.geo_radius)){return}this.geoHomeMarker.setPosition(b);this.geoMap.panTo(b);this.geoHomeCircle.setRadius(a.geo_radius);this.UpdateAddress()},RefreshGeoMap:function(){if(this.geoMap&&this.ctMap.rendered){google.maps.event.trigger(this.geoMap,"resize")}},UpdateMapSize:function(){if(false===this.ctMap.rendered){return}var c=this.getInnerWidth();var b=this.parentWin.panelOverview.GetRemainingHeight();var a=0;var d=0;if(true===this.ctMap.isVisible()){b+=this.ctMap.getHeight()}if((c*9/16)>b){d=Math.max(b,this.MAP_MIN_HEIGHT);a=parseInt((d*16/9),10)}else{a=Math.max(c,this.MAP_MIN_WIDTH);d=parseInt((a*9/16),10)}this.ctMap.setSize(a,d);this.FitHeight()},UpdateAddress:function(){var b=this.geoHomeMarker.getPosition();var c=new google.maps.Geocoder();var a=function(e,d){if((google.maps.GeocoderStatus.OK===d)&&(true===Ext.isArray(e))&&(0<e.length)){this.labelAddr.setValue(e[0].formatted_address);Ext.QuickTips.register({target:this.labelAddr.getEl().getAttribute("id"),text:e[0].formatted_address})}}.createDelegate(this);c.geocode({latLng:b},a)},Activate:function(){},Deactivate:function(){},IsDirty:function(){return false},GoPage:function(a){this.getLayout().setActiveItem(a);this.FitHeight()},FitHeight:function(){var b;var d=this.getLayout().activeItem;if(!d){return}var a=d.items;var c=0;for(b=0;b<a.getCount();b++){c+=a.get(b).getHeight()}d.setHeight(c);this.setHeight(d.getHeight());this.parentWin.doLayout()}});Ext.define("SYNO.SS.App.HomeMode.GeofenceEditPanel",{extend:"SYNO.SDS.ModalWindow",TITLE:_T("home_mode","set_geofence"),WINDOW_WIDTH:662,WINDOW_HEIGHT:500,COMBO_WIDTH:407,NAME_MAX_LENGTH:256,MAP_MIN_WIDTH:620,MAP_MIN_HEIGHT:296,LABEL_WIDTH:208,btnSave:null,btnCancel:null,fieldPosition:null,dsRadius:null,comboRadius:null,dsDelay:null,comboDelay:null,origSettings:null,tempSettings:null,ctMap:null,geoMap:null,geoHomeMarker:null,geoMapOption:null,geoHomeCircle:null,blValidPos:true,blForceClose:false,searchPosTimer:null,dsId:LOCAL_DS_ID,constructor:function(d,b,a){this.origSettings=d;this.tempSettings=SYNO.SS.Utils.DeepCopy(d);this.dsId=a;this.Init();var c={owner:b,title:this.TITLE,width:this.WINDOW_WIDTH,height:this.WINDOW_HEIGHT,items:[{xtype:"syno_panel",layout:"form",style:"margin-top: 6px; margin-bottom: 6px;",width:this.WINDOW_WIDTH,labelWidth:this.LABEL_WIDTH,items:[this.fieldPosition,this.comboRadius,this.comboDelay]},this.ctMap],buttons:[this.btnSave,this.btnCancel],listeners:{beforeclose:this.OnBeforeClose,afterrender:function(){this.RenderGeoMap(this.origSettings);this.comboRadius.setValue(this.origSettings.geo_radius);this.comboDelay.setValue(this.origSettings.geo_delay_time)},scope:this}};this.callParent([c])},Init:function(){this.btnSave=new SYNO.ux.Button({name:"btnSave",text:_T("ss_common","common_ok"),btnStyle:"blue",handler:function(){if((false===this.blValidPos)||(false===this.fieldPosition.isValid())){this.setStatusError({text:_T("ss_common","forminvalid"),clear:true})}else{this.OnSave()}},scope:this});this.btnCancel=new SYNO.ux.Button({name:"btnCancel",text:_T("ss_common","common_cancel"),handler:this.close,scope:this});this.fieldPosition=new SYNO.ux.TextField({name:"geoPos",fieldLabel:_T("home_mode","address"),width:this.COMBO_WIDTH,maxLength:this.NAME_MAX_LENGTH,enableKeyEvents:true,listeners:{keyup:function(b,c,a){clearTimeout(this.searchPosTimer);this.searchPosTimer=setTimeout(this.SearchPosition.createDelegate(this),300)},keydown:function(b,c,a){clearTimeout(this.searchPosTimer)},blur:function(b,c,a){if(false===this.blValidPos){this.fieldPosition.markInvalid(_T("home_mode","search_position_failed"))}},scope:this}});this.dsRadius=new Ext.data.ArrayStore({autoDestroy:true,data:[[100,String.format("100 {0}",_T("ss_common","meters"))],[200,String.format("200 {0}",_T("ss_common","meters"))],[300,String.format("300 {0}",_T("ss_common","meters"))],[400,String.format("400 {0}",_T("ss_common","meters"))],[500,String.format("500 {0}",_T("ss_common","meters"))]],fields:["value","text"]});this.comboRadius=new SYNO.ux.ComboBox({name:"geoRadius",fieldLabel:_T("home_mode","radius"),store:this.dsRadius,valueField:"value",displayField:"text",width:this.COMBO_WIDTH,mode:"local",forceSelection:true,triggerAction:"all",editable:false,listeners:{select:function(c,a,b){this.tempSettings.geo_radius=this.comboRadius.getValue();this.UpdateGeoMap(this.tempSettings)},scope:this}});this.dsDelay=new Ext.data.ArrayStore({autoDestroy:true,data:[[0,_T("ss_common","common_none")],[30,String.format("30 {0}",_T("ss_common","common_second"))],[60,String.format("1 {0}",_T("ss_common","common_minute"))],[120,String.format("2 {0}",_T("ss_common","common_minute"))],[180,String.format("3 {0}",_T("ss_common","common_minute"))]],fields:["value","text"]});this.comboDelay=new SYNO.ux.ComboBox({name:"geoDelay",fieldLabel:_T("home_mode","trigger_delay"),store:this.dsDelay,valueField:"value",displayField:"text",width:this.COMBO_WIDTH,mode:"local",forceSelection:true,triggerAction:"all",editable:false,listeners:{select:function(c,a,b){this.tempSettings.geo_delay_time=this.comboDelay.getValue()},scope:this}});this.ctMap=new Ext.Container({cls:"hm-geo-map-ct",width:this.MAP_MIN_WIDTH,height:this.MAP_MIN_HEIGHT})},RenderGeoMap:function(b){if(false===this.ctMap.rendered){return}var a=new google.maps.LatLng(b.geo_lat,b.geo_lng);this.geoMapOption={center:a,zoom:17};this.geoMap=new google.maps.Map(this.ctMap.el.dom,this.geoMapOption);this.geoHomeMarker=new google.maps.Marker({draggable:true,animation:google.maps.Animation.DROP,position:a,map:this.geoMap,title:"Home"});google.maps.event.addListener(this.geoHomeMarker,"dragend",function(){this.UpdateAddress()}.createDelegate(this));this.geoHomeCircle=new google.maps.Circle({strokeColor:"#0079BC",strokeOpacity:0.3,strokeWeight:1,fillColor:"#0079BC",fillOpacity:0.3,map:this.geoMap,center:a,radius:b.geo_radius});this.geoHomeCircle.bindTo("center",this.geoHomeMarker,"position");this.UpdateAddress()},UpdateGeoMap:function(b,a){var c=new google.maps.LatLng(b.geo_lat,b.geo_lng);if((true===this.geoHomeMarker.getPosition().equals(c))&&(this.geoHomeCircle.getRadius()===b.geo_radius)){return}this.geoHomeMarker.setPosition(c);this.geoMap.panTo(c);this.geoHomeCircle.setRadius(b.geo_radius);this.UpdateAddress(a)},UpdateAddress:function(c){var b=this.geoHomeMarker.getPosition();var d=new google.maps.Geocoder();var a=function(f,e){if((google.maps.GeocoderStatus.OK===e)&&(true===Ext.isArray(f))&&(0<f.length)){if(true!==c){this.fieldPosition.setValue(f[0].formatted_address)}this.tempSettings.geo_lat=b.lat();this.tempSettings.geo_lng=b.lng();this.fieldPosition.clearInvalid();this.blValidPos=true}}.createDelegate(this);d.geocode({latLng:b},a)},SearchPosition:function(){if(false===this.fieldPosition.isValid()){return}var b=new google.maps.Geocoder();var a=function(d,c){if((google.maps.GeocoderStatus.OK===c)&&(true===Ext.isArray(d))&&(0<d.length)){this.tempSettings.geo_lat=d[0].geometry.location.lat();this.tempSettings.geo_lng=d[0].geometry.location.lng();this.UpdateGeoMap(this.tempSettings,true);this.fieldPosition.clearInvalid();this.blValidPos=true}else{this.fieldPosition.markInvalid(_T("home_mode","search_position_failed"));this.blValidPos=false}}.createDelegate(this);b.geocode({address:this.fieldPosition.getValue()},a)},IsDirty:function(){if((!this.origSettings)||(!this.tempSettings)){return false}return(0.000001<Math.abs(this.origSettings.geo_lat-this.tempSettings.geo_lat))||(0.000001<Math.abs(this.origSettings.geo_lng-this.tempSettings.geo_lng))||(this.origSettings.geo_radius!==this.tempSettings.geo_radius)||(this.origSettings.geo_delay_time!==this.tempSettings.geo_delay_time)},OnBeforeClose:function(){if((true===this.blForceClose)||(false===this.IsDirty())){clearTimeout(this.searchPosTimer);google.maps.event.clearListeners(this.geoHomeMarker,"dragend");return true}else{SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){this.blForceClose=true;this.close()},scope:this});return false}},OnSave:function(){var a={};if(false===this.IsDirty()){this.close()}else{this.setStatusBusy({text:_T("ss_common","common_saving")});Ext.apply(a,{geo_lat:this.tempSettings.geo_lat,geo_lng:this.tempSettings.geo_lng,geo_radius:this.tempSettings.geo_radius,geo_delay_time:this.tempSettings.geo_delay_time});this.sendWebAPI({api:"SYNO.SurveillanceStation.HomeMode",method:"SaveGeofence",version:1,params:a,dsId:this.dsId,callback:function(e,c,d,b){this.clearStatusBusy();if(e){this.blForceClose=true;if(LOCAL_DS_ID!==this.dsId){this.owner.RefreshUI(this.tempSettings)}this.close()}else{this.owner.getMsgBox().alert(_T("ss_common","common_edit"),SYNO.API.getErrorString(c.code))}},scope:this})}}});Ext.define("SYNO.SS.App.HomeMode.Overview",{extend:"SYNO.SDS.Utils.FormPanel",parentWin:null,switchReqObj:null,fldSetStatus:null,fldSetGeofence:null,constructor:function(a){this.parentWin=a;this.Init();this.callParent([{cls:"hm-overview",style:"padding-bottom: 10px;",border:false,items:[this.fldSetStatus,this.fldSetGeofence],scope:this}]);this.InitEventHandler()},Init:function(){var b=new Ext.BoxComponent({cls:"hm-status-icon"});var a=function(d,c){b.setDisabled(!c)};this.btnHomeModeOn=new SYNO.SS.Button.SwitchButton({blOn:_S("blHomeModeOn"),disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_SWITCH)),syncUIHandler:a,toggleHandler:this.ManualSwitchHint,scope:this});this.labelReasonTitle=new SYNO.ux.DisplayField({value:_T("home_mode","enable_reason"),style:"margin-top: 2px; margin-bottom: 2px;",maxWidth:250,hideLabel:false,hidden:false});this.labelReason=new SYNO.ux.DisplayField({value:_T("ss_common","common_none"),hideLabel:false,hidden:false});this.labelSwitchTimeTitle=new SYNO.ux.DisplayField({value:_T("home_mode","next_disable_time"),style:"margin-top: 2px; margin-bottom: 2px;",maxWidth:250,hideLabel:false,hidden:false});this.labelSwitchTime=new SYNO.ux.DisplayField({value:"--",hideLabel:false,hidden:false});this.fldSetStatus=new SYNO.ux.FieldSet({title:_T("ss_common","status"),autoHeight:true,collapsible:true,bodyStyle:"padding: 0px 10px 1px 4px;",layout:{type:"hbox",align:"middle"},items:[{xtype:"container",layout:"fit",style:"padding-top: 0px;",items:[b]},{xtype:"container",style:"padding-left: 30px;",layout:"table",layoutConfig:{rows:3,columns:2},items:[{xtype:"syno_displayfield",value:_T("ss_common","status"),style:"margin-top: 2px; margin-bottom: 2px;",width:280},{xtype:"container",layout:{type:"vbox",align:"left"},items:[this.btnHomeModeOn]},this.labelReasonTitle,this.labelReason,this.labelSwitchTimeTitle,this.labelSwitchTime]}]});this.panelGeofence=new SYNO.SS.App.HomeMode.GeofencePanel(this.parentWin);this.fldSetGeofence=new SYNO.ux.FieldSet({cls:"hm-fs-geofence",title:_T("home_mode","geofence"),collapsible:true,bodyStyle:"padding-left: 4px;",items:[this.panelGeofence]})},InitEventHandler:function(){this.mon(this,"resize",this.Resize,this)},Resize:function(){if(this.fldSetGeofence.rendered){this.panelGeofence.UpdateMapSize()}},GetRemainingHeight:function(){var a=0;if(this.fldSetGeofence.rendered){a=this.getInnerHeight()-(this.fldSetStatus.getHeight()+this.fldSetGeofence.getHeight()+10)}return a},UpdateUI:function(c){var a;var b;var d;if(true===c.on){a=_T("home_mode","enable_reason");b=_T("home_mode","next_disable_time")}else{a=_T("home_mode","disable_reason");b=_T("home_mode","next_enable_time")}this.labelReason.setValue(SYNO.SS.App.HomeMode.Utils.GetReasonString(c.reason));this.labelReasonTitle.setValue(a);this.labelSwitchTimeTitle.setValue(b);if((true===SYNO.SS.App.HomeMode.Utils.IsScheduleOn(c))&&(-1!==c.mode_schedule_next_time)){this.labelSwitchTime.setValue(SYNO.SS.App.HomeMode.Utils.GetNextSwitchTime(c))}else{this.labelSwitchTime.setValue("--")}if(c.on!==this.btnHomeModeOn.IsOn()){this.btnHomeModeOn.SetOn(c.on,true)}this.panelGeofence.UpdateUI(c);this.doLayout();SYNO.SS.Utils.SetHomeMode(c.on)},Activate:function(){},Deactivate:function(){},IsDirty:function(){return false},ManualSwitchHint:function(c,b){var d=SYNO.SDS.UserSettings.getProperty("Desktop","homeModeHintEnabled");var a=SYNO.SDS.Desktop.getMsgBox();if(false===Ext.isDefined(d)){d=true}if(true===d){a.show({closable:false,buttons:Ext.Msg.YESNO,icon:Ext.Msg.QUESTION,msg:_T("home_mode","manual_switch_hint"),fn:function(j,f,h,e,g){if("yes"===j){d=!g[0];this.SwitchHomeMode(c,b);SYNO.SDS.UserSettings.setProperty("Desktop","homeModeHintEnabled",d)}else{c.SetOn(!b,true)}},type:Ext.Msg.optType.CHECK_BOX,msgList:[_T("home_mode","no_hint_when_manual_switch")],scope:this});return}this.SwitchHomeMode(c,b)},SwitchHomeMode:function(b,a){var c={on:a};var d=function(e,f,g){this.switchReqObj=null;if(false===e){b.SetOn(!a,true)}};if(this.switchReqObj){Ext.Ajax.abort(this.switchReqObj)}this.switchReqObj=this.parentWin.WebAPIRequest("Switch",c,d,true)}});Ext.define("SYNO.SS.App.HomeMode.Schedule",{extend:"SYNO.SDS.Utils.TabPanel",parentWin:null,panelRecurrence:null,panelOneTime:null,tabIdx:{Recurrence:0,OneTime:1},constructor:function(a){this.parentWin=a;this.Init();this.callParent([{useDefaultBtn:false,activeTab:this.tabIdx.Recurrence,items:[this.panelRecurrence,this.panelOneTime],deferredRender:true,listeners:{beforetabchange:function(d,e,c){var b=function(){this.Reset();this.setActiveTab(e)}.createDelegate(this);if(true===this.parentWin.CheckDirty(b)){return false}return true},tabchange:function(b,c){c.Activate()},scope:this}}])},Init:function(){this.panelRecurrence=new SYNO.SS.App.HomeMode.Schedule.Recurrence(this.parentWin);this.panelOneTime=new SYNO.SS.App.HomeMode.Schedule.OneTime(this.parentWin)},UpdateUI:function(a){this.panelRecurrence.UpdateUI(a);this.panelOneTime.UpdateUI(a)},Activate:function(){this.getActiveTab().Activate()},Deactivate:function(){this.Reset()},IsDirty:function(){return this.getActiveTab().IsDirty()},Reset:function(){return this.getActiveTab().Reset()}});Ext.define("SYNO.SS.App.HomeMode.Schedule.Recurrence",{extend:"SYNO.SDS.Utils.FormPanel",parentWin:null,btnSave:null,btnReset:null,labelScheDirections:null,chkEnableSche:null,panelScheduler:null,panelModeSelection:null,schId:"",fldSetScheduleSetting:null,LABEL_WIDTH:240,constructor:function(a){this.parentWin=a;this.Init();this.callParent([{title:_T("axis_access_controller","recurrence"),border:false,trackResetOnLoad:true,buttons:[this.btnSave,this.btnReset],items:[this.fldSetScheduleSetting],scope:this}])},Init:function(){this.labelScheDirections=new SYNO.ux.DisplayField({value:_T("home_mode","sche_switch_directions"),hideLabel:false,hidden:false});this.chkEnableSche=new SYNO.SS.Form.Checkbox({boxLabel:_T("home_mode","enable_sche_switch"),hideLabel:false,disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),handler:function(a,b){this.panelScheduler.setDisabled(!b)},scope:this});this.schId=Ext.id();this.panelScheduler=new SYNO.SS.Panel.SchedulerPanel({disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),htmlSchedulerId:this.schId,scheduleMode:SYNO.SS.Schedule.Mode.HOME_MODE,blTwoColor:true,listeners:{afterrender:function(){this.panelScheduler.Activate()},scope:this}});this.panelModeSelection=new SYNO.SS.Panel.ScheduleModePanel({width:SYNO.SS.UTILSCHEDULER.GetTableWidth(),style:"padding: 10px 0px 10px 0px;",layout:"auto"});this.InitModeSelectionPanel();this.fldSetScheduleSetting=new SYNO.ux.FieldSet({title:_T("home_mode","sche_settings"),autoHeight:true,collapsible:true,bodyStyle:"padding-left: 4px;",layout:"vbox",items:[this.labelScheDirections,this.chkEnableSche,this.panelModeSelection,this.panelScheduler]});this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.Save,scope:this});this.btnReset=new SYNO.ux.Button({text:_T("ss_common","common_reset"),handler:this.Reset,scope:this})},InitModeSelectionPanel:function(){var a=this.panelScheduler.getId();this.panelModeSelection.removeAll();this.panelModeSelection.add({xtype:"container",layout:"column",items:[{xtype:"container",style:"width: 35px;",html:"<span id='"+this.schId+"icon_custom2' class='btn_custom2_inactive' onMouseOver=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'over', 'continue','"+a+"');\"onMouseOut=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'out', 'continue','"+a+"');\"onMousedown=\"javascript:SYNO.SS.UTILSCHEDULER.ChkLeftMouseDown(event, SYNO.SS.UTILSCHEDULER.ScheduleMouseAction, '"+this.schId+"', 'down', 'continue','"+a+"');\"></span>"},{xtype:"label",style:"width: 270px;",text:_T("home_mode","enter_home_mode"),cls:"x-form-item ss-schedule-label-normal"},{xtype:"container",style:"width: 35px;",html:"<span id='"+this.schId+"icon_erase' class='btn_erase_inactive' onMouseOver=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'over', 'erase','"+a+"');\"onMouseOut=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'out', 'erase','"+a+"');\"onMousedown=\"javascript:SYNO.SS.UTILSCHEDULER.ChkLeftMouseDown(event, SYNO.SS.UTILSCHEDULER.ScheduleMouseAction, '"+this.schId+"', 'down', 'erase','"+a+"');\"></span>"},{xtype:"label",style:"width: 270px;",text:_T("home_mode","leave_home_mode"),cls:"x-form-item ss-schedule-label-normal"}]});this.panelModeSelection.doLayout()},UpdateUI:function(a){this.chkEnableSche.setValue(a.mode_schedule_on);this.chkEnableSche.initValue();scheduleList=SYNO.SS.App.HomeMode.Utils.ScheStrToScheArray(a.mode_schedule);this.UpdateScheduleUI(scheduleList);this.panelScheduler.setDisabled(!a.mode_schedule_on)},UpdateScheduleUI:function(c){if(!c){return}var b,a;this.panelScheduler.UpdateScheduleData(c);for(b=0;b<7;b++){for(a=0;a<48;a++){if((0<c[b][a])){this.panelScheduler.SetCurrentAct("continue")}else{this.panelScheduler.SetCurrentAct("erase")}this.panelScheduler.ClickScheduleItem(this.schId,b,a)}}this.panelScheduler.DrawSelectAllItem(0);this.ResetScheduleBtnState()},ResetScheduleBtnState:function(){if(("inactive"===SYNO.SS.UTILSCHEDULER.GetActStatus(this.schId,"custom2"))&&("inactive"===SYNO.SS.UTILSCHEDULER.GetActStatus(this.schId,"erase"))){SYNO.SS.UTILSCHEDULER.ScheduleMouseAction(this.schId,"down","continue",this.panelScheduler.getId())}},ResetSchedule:function(){this.UpdateScheduleUI(this.panelScheduler.GetScheduleData())},Activate:function(){this.fldSetScheduleSetting.doLayout()},Deactivate:function(){this.Reset()},IsDirty:function(){return((true===this.getForm().isDirty())||(true===this.panelScheduler.IsDirty()))},ClearDirty:function(){var a=this.getForm().getFieldValues();this.getForm().setValues(a);this.panelScheduler.ClearDirty()},Save:function(){if(false===this.IsDirty()){this.setStatusNoChange();return}var a={mode_schedule_on:this.chkEnableSche.checked,mode_schedule:this.panelScheduler.GetSchedule()};var b=function(c,d,e){this.ClearDirty();this.clearStatusBusy();this.setStatusOK()}.createDelegate(this);this.setStatusSaving();this.parentWin.WebAPIRequest("SaveSchedule",a,b)},Reset:function(){this.getForm().reset();this.ResetSchedule()}});Ext.define("SYNO.SS.App.HomeMode.Schedule.OneTime",{extend:"SYNO.SDS.Utils.FormPanel",parentWin:null,btnSave:null,btnReset:null,chkEnterHomeMode:false,chkLeaveHomeMode:false,fieldEnterDate:null,fieldLeaveDate:null,fieldEnterTime:null,fieldLeaveTime:null,fldOneTime:null,LABEL_WIDTH:240,CHKBOX_WIDTH:240,DATE_FIELD_WIDTH:112,constructor:function(a){this.parentWin=a;this.Init();this.callParent([{title:_T("axis_access_controller","one_time"),border:false,trackResetOnLoad:true,buttons:[this.btnSave,this.btnReset],items:[this.fldOneTime],scope:this}]);this.InitEvent()},Init:function(){var a=new Date();this.chkEnterHomeMode=new SYNO.SS.Form.Checkbox({width:this.CHKBOX_WIDTH,boxLabel:_T("home_mode","enter_home_mode"),hideLabel:false,disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),handler:function(b,c){if(c&&SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)){this.fieldEnterDate.enable();this.fieldEnterTime.enable()}else{this.fieldEnterDate.disable();this.fieldEnterTime.disable()}},scope:this});this.fieldEnterDate=new SYNO.ux.DateField({width:this.DATE_FIELD_WIDTH,emptyText:"Select date",format:"Y/m/d",hideLabel:true,disabled:(false===this.chkEnterHomeMode.checked)||(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),editable:false,value:a,menu:new Ext.menu.DateMenu({hideOnClick:false,allowOtherMenus:true,ignoreParentClicks:true}),listeners:{select:function(){var c;var e=this.fieldEnterDate.getValue();var d=false;var b=this.fieldEnterTime.cmbboxHours.getValue();e.setHours(0,0,0,0);this.fieldEnterTime.CheckDaylightSaving(e);c=this.fieldEnterTime.cmbboxHours.getStore();if(24<=c.length){return}c.each(function(f){if(b===f.get("value")){d=true}},this);if(false===d){this.fieldEnterTime.cmbboxHours.setValue((b+1)%24)}this.CheckFormValid()},scope:this}});this.fieldEnterTime=new SYNO.SS.TimeFieldPanel({blShowSecond:false,style:"padding-left: 10px",disabled:(false===this.chkEnterHomeMode.checked)||(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT))});this.chkLeaveHomeMode=new SYNO.SS.Form.Checkbox({width:this.CHKBOX_WIDTH,boxLabel:_T("home_mode","leave_home_mode"),hideLabel:false,disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),handler:function(b,c){if(c&&SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)){this.fieldLeaveDate.enable();this.fieldLeaveTime.enable()}else{this.fieldLeaveDate.disable();this.fieldLeaveTime.disable()}},scope:this});this.fieldLeaveDate=new SYNO.ux.DateField({width:this.DATE_FIELD_WIDTH,emptyText:"Select date",format:"Y/m/d",hideLabel:true,disabled:(false===this.chkLeaveHomeMode.checked)||(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),editable:false,value:a,menu:new Ext.menu.DateMenu({hideOnClick:false,allowOtherMenus:true,ignoreParentClicks:true}),listeners:{select:function(){var c;var e=this.fieldLeaveDate.getValue();var d=false;var b=this.fieldLeaveTime.cmbboxHours.getValue();e.setHours(0,0,0,0);this.fieldLeaveTime.CheckDaylightSaving(e);c=this.fieldLeaveTime.cmbboxHours.getStore();if(24<=c.length){return}c.each(function(f){if(b===f.get("value")){d=true}},this);if(false===d){this.fieldLeaveTime.cmbboxHours.setValue((b+1)%24)}this.CheckFormValid()},scope:this}});this.fieldLeaveTime=new SYNO.SS.TimeFieldPanel({blShowSecond:false,style:"padding-left: 10px",disabled:(false===this.chkLeaveHomeMode.checked)||(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT))});this.fldOneTime=new SYNO.ux.FieldSet({title:_T("home_mode","one_time_change"),autoHeight:true,collapsible:true,bodyStyle:"padding-left: 4px;",layout:"vbox",items:[{xtype:"container",layout:"hbox",items:[this.chkEnterHomeMode,this.fieldEnterDate,this.fieldEnterTime]},{xtype:"container",layout:"hbox",style:"padding-top: 6px",items:[this.chkLeaveHomeMode,this.fieldLeaveDate,this.fieldLeaveTime]}]});this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.Save,scope:this});this.btnReset=new SYNO.ux.Button({text:_T("ss_common","common_reset"),handler:this.Reset,scope:this});this.fieldEnterDate.invalidText=_T("home_mode","onetime_invalid_text");this.fieldLeaveDate.invalidText=_T("home_mode","onetime_invalid_text");this.fieldEnterTime.cmbboxHours.invalidText=_T("home_mode","onetime_invalid_text");this.fieldEnterTime.cmbboxMinutes.invalidText=_T("home_mode","onetime_invalid_text");this.fieldLeaveTime.cmbboxHours.invalidText=_T("home_mode","onetime_invalid_text");this.fieldLeaveTime.cmbboxMinutes.invalidText=_T("home_mode","onetime_invalid_text")},InitEvent:function(){this.mon(this.fieldEnterTime.cmbboxHours,"blur",this.CheckFormValid,this);this.mon(this.fieldEnterTime.cmbboxMinutes,"blur",this.CheckFormValid,this);this.mon(this.fieldEnterTime.cmbboxHours,"select",this.CheckFormValid,this);this.mon(this.fieldEnterTime.cmbboxMinutes,"select",this.CheckFormValid,this);this.mon(this.fieldLeaveTime.cmbboxHours,"blur",this.CheckFormValid,this);this.mon(this.fieldLeaveTime.cmbboxMinutes,"blur",this.CheckFormValid,this);this.mon(this.fieldLeaveTime.cmbboxHours,"select",this.CheckFormValid,this);this.mon(this.fieldLeaveTime.cmbboxMinutes,"select",this.CheckFormValid,this);this.mon(this.fieldEnterDate,"blur",this.CheckFormValid,this);this.mon(this.fieldLeaveDate,"blur",this.CheckFormValid,this)},UpdateUI:function(e){var d;var a=(false===e.onetime_enable_on)&&(0===e.onetime_enable_time);var c=(false===e.onetime_disable_on)&&(0===e.onetime_disable_time);var b=function(f,j,h){var g,l,k={};if(true===f){g=new Date();g.setHours(0,0,0,0);k.date=new Date(g.getTime()+(h*25*60*60*TRANS_MILLISECOND));k.date.setHours(0,0,0,0);k.hour=0;k.minute="00"}else{l=GenLocalDateTime(j*TRANS_MILLISECOND);k.date=l.date;k.hour=parseInt(l.time.split(":")[0],10);k.minute=l.time.split(":")[1]}return k};this.chkEnterHomeMode.setValue(e.onetime_enable_on);this.chkEnterHomeMode.initValue();this.chkLeaveHomeMode.setValue(e.onetime_disable_on);this.chkLeaveHomeMode.initValue();d=b(a,e.onetime_enable_time,1);this.fieldEnterDate.setValue(d.date);this.fieldEnterDate.initValue();this.fieldEnterTime.CheckDaylightSaving(this.fieldEnterDate.getValue());this.fieldEnterTime.cmbboxHours.setValue(d.hour);this.fieldEnterTime.cmbboxHours.initValue();this.fieldEnterTime.cmbboxMinutes.setValue(d.minute);this.fieldEnterTime.cmbboxMinutes.initValue();d=b(c,e.onetime_disable_time,2);this.fieldLeaveDate.setValue(d.date);this.fieldLeaveDate.initValue();this.fieldLeaveTime.CheckDaylightSaving(this.fieldLeaveDate.getValue());this.fieldLeaveTime.cmbboxHours.setValue(d.hour);this.fieldLeaveTime.cmbboxHours.initValue();this.fieldLeaveTime.cmbboxMinutes.setValue(d.minute);this.fieldLeaveTime.cmbboxMinutes.initValue()},Activate:function(){this.fldOneTime.doLayout()},Deactivate:function(){this.Reset()},IsDirty:function(){return(true===this.getForm().isDirty())},ClearDirty:function(){var a=this.getForm().getFieldValues();this.getForm().setValues(a)},Save:function(){if(false===this.CheckFormValid()){this.setStatusError({text:_T("ss_common","forminvalid"),clear:true});return}if(false===this.IsDirty()){this.setStatusNoChange();return}var a={onetime_enable_on:this.chkEnterHomeMode.checked,onetime_disable_on:this.chkLeaveHomeMode.checked,onetime_enable_time:this.GetTime(this.fieldEnterDate,this.fieldEnterTime),onetime_disable_time:this.GetTime(this.fieldLeaveDate,this.fieldLeaveTime)};var b=function(c,d,e){this.ClearDirty();this.clearStatusBusy();this.setStatusOK()}.createDelegate(this);this.setStatusSaving();this.parentWin.WebAPIRequest("SaveOneTimeSwitch",a,b)},CheckFormValid:function(){if((true===this.chkEnterHomeMode.checked)&&(true===this.chkLeaveHomeMode.checked)&&(this.GetTime(this.fieldEnterDate,this.fieldEnterTime)===this.GetTime(this.fieldLeaveDate,this.fieldLeaveTime))){this.fieldEnterDate.markInvalid();this.fieldLeaveDate.markInvalid();this.fieldEnterTime.cmbboxHours.markInvalid();this.fieldEnterTime.cmbboxMinutes.markInvalid();this.fieldLeaveTime.cmbboxHours.markInvalid();this.fieldLeaveTime.cmbboxMinutes.markInvalid();return false}else{this.fieldEnterDate.clearInvalid();this.fieldLeaveDate.clearInvalid();this.fieldEnterTime.cmbboxHours.clearInvalid();this.fieldEnterTime.cmbboxMinutes.clearInvalid();this.fieldLeaveTime.cmbboxHours.clearInvalid();this.fieldLeaveTime.cmbboxMinutes.clearInvalid()}return true},Reset:function(){this.getForm().reset()},GetTime:function(d,a){var c=d.value+" "+a.cmbboxHours.getRawValue()+":"+a.cmbboxMinutes.getRawValue();var b=Date.parseDate(c,"Y/m/d H:i",true);return ConvertTimestamp(b/TRANS_MILLISECOND)}});Ext.define("SYNO.SS.App.HomeMode.ProfileGeneral",{extend:"SYNO.SDS.Utils.FormPanel",parentWin:null,parent:null,btnSave:null,btnReset:null,dsCamera:null,dsIOModule:null,cameraList:null,iomoduleList:null,fldCamera:null,fldIOModule:null,blDataReady:false,chkRecording:null,chkNotify:null,chkStreamProfile:null,chkActionRule:null,fldSetProfiles:null,fldSetAppliedDevice:null,LABEL_WIDTH:240,constructor:function(a){this.parent=a;this.parentWin=a.parentWin;this.Init();this.callParent([{title:_T("ss_common","general"),border:false,trackResetOnLoad:true,buttons:[this.btnSave,this.btnReset],items:[this.fldSetProfiles,this.fldSetAppliedDevice],scope:this}])},Init:function(){this.chkRecording=this.CreateProfileChk({boxLabel:_T("home_mode","enable_recording_setting")});this.chkNotify=this.CreateProfileChk({boxLabel:_T("home_mode","enable_notification_setting")});this.chkStreamProfile=this.CreateProfileChk({boxLabel:_T("home_mode","enable_stream_profile_setting")});this.chkActionRule=this.CreateProfileChk({boxLabel:_T("home_mode","enable_action_rule_setting")});this.dsCamera=new Ext.data.ArrayStore({autoDestroy:true,fields:["id","name"]});this.dsIOModule=new Ext.data.ArrayStore({autoDestroy:true,fields:["id","name"]});this.fldCamera=new SYNO.SS.Form.MultiSelectField({width:275,hidden:false,disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),hideLabel:true,editable:false,allowBlank:false,allowNoSelection:true,msgTarget:"title",strAllItems:_T("ss_common","common_all_cameras"),strNoneItem:_T("ss_common","common_none"),displayField:"name",store:this.dsCamera});this.fldIOModule=new SYNO.SS.Form.MultiSelectField({width:275,hidden:false,disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),hideLabel:true,editable:false,allowBlank:false,allowNoSelection:true,msgTarget:"title",strAllItems:_T("ss_privilege","iomodule_all"),strNoneItem:_T("ss_common","common_none"),displayField:"name",store:this.dsIOModule});this.fldSetProfiles=new SYNO.ux.FieldSet({title:_T("home_mode","enabled_custom_setting"),autoHeight:true,collapsible:true,bodyStyle:"padding-left: 4px;",items:[{xtype:"syno_displayfield",value:_T("home_mode","enabled_custom_setting_intro")},this.chkRecording,this.chkNotify,this.chkStreamProfile,this.chkActionRule]});this.fldSetAppliedDevice=new SYNO.ux.FieldSet({title:_T("home_mode","applied_devices"),autoHeight:true,collapsible:true,bodyStyle:"padding-left: 4px;",items:[{xtype:"syno_displayfield",value:_T("home_mode","applied_devices_info")},{xtype:"container",layout:"hbox",style:"padding-bottom: 4px;",items:[{xtype:"syno_displayfield",value:_T("ss_common","cameras")+":",width:this.LABEL_WIDTH},this.fldCamera]},{xtype:"container",layout:"hbox",items:[{xtype:"syno_displayfield",value:_T("ss_common","common_iomodule")+":",width:this.LABEL_WIDTH},this.fldIOModule]}]});this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.Save,scope:this});this.btnReset=new SYNO.ux.Button({text:_T("ss_common","common_reset"),handler:this.Reset,scope:this})},CreateProfileChk:function(a){return new SYNO.SS.Form.Checkbox(Ext.apply(a,{disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),scope:this}))},LoadCameras:function(){var a,b,c;this.cameraList=[];for(a=0;a<SYNO.SS.GblStore.dsCamera.data.items.length;a++){b=SYNO.SS.GblStore.dsCamera.data.items[a].data;if(this.parentWin.appDSId!==b.ownerDsId){continue}if((SYNO.SS.CamSts.DELETED===b.camStatus)||(SYNO.SS.CamSts.UNRECOGNIZED===b.camStatus)){continue}if(LOCAL_DS_ID===this.parentWin.appDSId){c=b.id}else{c=b.camIdOnRecServer}this.cameraList.push([c,b.name])}this.dsCamera.loadData(this.cameraList);this.fldCamera.setDisabled((false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT))||(0===this.dsCamera.getCount()))},LoadIOModules:function(){var b,a,c;this.iomoduleList=[];for(b=0;b<SYNO.SS.GblStore.dsIOModule.data.items.length;b++){a=SYNO.SS.GblStore.dsIOModule.data.items[b].data;if(this.parentWin.appDSId!==a.owner_ds_id){continue}if(LOCAL_DS_ID===this.parentWin.appDSId){c=a.id}else{c=a.id_on_rec_server}this.iomoduleList.push([c,a.name])}this.dsIOModule.loadData(this.iomoduleList);this.fldIOModule.setDisabled((false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT))||(0===this.dsIOModule.getCount()))},UpdateUI:function(a){this.chkRecording.setValue(a.rec_schedule_on);this.chkNotify.setValue(a.notify_on);this.chkStreamProfile.setValue(a.streaming_on);this.chkActionRule.setValue(a.actrule_on);this.chkRecording.initValue();this.chkNotify.initValue();this.chkStreamProfile.initValue();this.chkActionRule.initValue();if(false===this.blDataReady){this.LoadCameras();this.LoadIOModules();this.blDataReady=true}this.SetFieldValue(this.fldCamera,this.dsCamera,a.cameras);this.SetFieldValue(this.fldIOModule,this.dsIOModule,a.io_modules)},SetFieldValue:function(e,c,b){if("-1"===b){e.SelectAll();if(0===c.getCount()){e.value=e.strAllItems}e.initValue();return}var d,a;var f=[];var g=[];if(b){f=b.split(",")}for(d=0;d<f.size();d++){a=c.find("id",f[d]);if(-1!==a){g.push(a)}}e.setValue(g.join(","));e.initValue()},GetFieldValue:function(c,a){if(true===c.IsAllItemSelected()){return"-1"}if(0===a.getCount()){return""}if(!c.getValue()){return""}var b;var e=c.getValue().split(",");var d=[];for(b=0;b<e.size();b++){d.push(a.getAt(e[b]).data.id)}return d.join(",")},Activate:function(){},Deactivate:function(){this.Reset()},IsDirty:function(){return(true===this.getForm().isDirty())},Reset:function(){this.getForm().reset()},IsAllSettingOff:function(){var b=true;var a=[this.chkRecording,this.chkNotify,this.chkStreamProfile,this.chkActionRule];a.forEach(function(c){if(true===c.getValue()){b=false}});return b},ClearDirty:function(){var a=this.getForm().getFieldValues();this.getForm().setValues(a)},Save:function(){var b=_T("home_mode","at_least_enable_one_setting");var a=this.parentWin.getMsgBox();if(true===this.IsAllSettingOff()){a.alert(this.title,b);return}if(false===this.IsDirty()){this.setStatusNoChange();return}var c={rec_schedule_on:this.chkRecording.getValue(),notify_on:this.chkNotify.getValue(),streaming_on:this.chkStreamProfile.getValue(),actrule_on:this.chkActionRule.getValue(),cameras:this.GetFieldValue(this.fldCamera,this.dsCamera),io_modules:this.GetFieldValue(this.fldIOModule,this.dsIOModule)};var d=function(e,f,g){this.ClearDirty();this.clearStatusBusy();this.setStatusOK()}.createDelegate(this);this.setStatusSaving();this.parentWin.WebAPIRequest("SaveProfileGeneral",c,d)}});Ext.define("SYNO.SS.App.HomeMode.RecSchePanel",{extend:"SYNO.SDS.Utils.FormPanel",parentWin:null,parent:null,blMask:true,btnSave:null,btnReset:null,LABEL_WIDTH:240,SCHEDULE_TYPE_LABEL_WIDTH:170,SCHEDULE_COMBO_LABEL_WIDTH:237,IMAGE_ICON_SIZE:35,CUSTOM_DET_NONE:0,CUSTOM_DET_MD:1,CUSTOM_DET_TD:2,CUSTOM_DET_AD:4,CUSTOM_DET_PD:8,CUSTOM_DET_APP:(1<<12),strScheIdPrefix:"",detectionFields:["id","detection"],cmbFields:["id","text"],constructor:function(a){this.parent=a;this.parentWin=a.parentWin;this.Init();this.callParent([{title:_T("camera","recording"),trackResetOnLoad:true,buttons:[this.btnSave,this.btnReset],items:[this.panelLocalRecModeSel,this.panelScheduler]}]);this.InitEventHandler()},Init:function(){this.strScheIdPrefix=String.format("hm_rec_sche_{0}_",Ext.id());this.panelScheduler=new SYNO.SS.Panel.SchedulerPanel({disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),htmlSchedulerId:this.strScheIdPrefix,padding:"8px 0px 0px 0px",scheduleMode:SYNO.SS.Schedule.Mode.NORMAL,blTwoColor:false});this.imgContRecording=this.CreateModeImg("icon_continue","btn_continue_active","continue");this.imgMotionRecording=this.CreateModeImg("icon_motion","btn_motion_inactive","motion");this.imgCustomRecording1=this.CreateModeImg("icon_custom1","btn_custom1_inactive","custom1");this.imgCustomRecording2=this.CreateModeImg("icon_custom2","btn_custom2_inactive","custom2");this.imgEraseRecording=this.CreateModeImg("icon_erase","btn_erase_inactive","erase");this.labelContRecording=this.CreateModeLabel("txt_continuous",_T("camera","abbre_camera_continuous_recording"));this.labelMotionRecording=this.CreateModeLabel("txt_motion",_T("camera","abbre_camera_motion_recording"));this.labelCustomRecording1=this.CreateModeLabel("txt_custom1",_T("ss_common","common_customize")+" 1");this.labelCustomRecording2=this.CreateModeLabel("txt_custom2",_T("ss_common","common_customize")+" 2");this.labelEraseRecording=this.CreateModeLabel("txt_erase",_T("camera","camera_no_recording"));this.dsCustom1Detection=this.CreateArrayStore(this.detectionFields);this.dsCustom2Detection=this.CreateArrayStore(this.detectionFields);this.dsCustom1DI=this.CreateArrayStore(this.cmbFields);this.dsCustom2DI=this.CreateArrayStore(this.cmbFields);this.fieldCustom1Detection=this.CreateDetectionField({store:this.dsCustom1Detection,hidden:true,listeners:{afterrender:function(){SYNO.SS.Utils.AddTip(this.fieldCustom1Detection.getEl(),_T("camera","camera_setting_tip"),27)},scope:this}});this.fieldCustom2Detection=this.CreateDetectionField({store:this.dsCustom2Detection,hidden:true,listeners:{afterrender:function(){SYNO.SS.Utils.AddTip(this.fieldCustom2Detection.getEl(),_T("camera","camera_setting_tip"),27)},scope:this}});this.cmbCustom1DI=this.CreateCmb({store:this.dsCustom1DI,hidden:true});this.cmbCustom2DI=this.CreateCmb({store:this.dsCustom2DI,hidden:true});this.panelLocalRecModeSel=new SYNO.SS.Panel.ScheduleModePanel({style:"padding: 2px 0 0 0",layout:"auto",items:[{xtype:"syno_panel",layout:"column",items:[this.imgContRecording,this.labelContRecording,this.imgMotionRecording,this.labelMotionRecording]},{xtype:"syno_panel",layout:"column",padding:"4px 0 8px 0",items:[this.imgCustomRecording1,this.labelCustomRecording1,this.imgCustomRecording2,this.labelCustomRecording2,this.imgEraseRecording,this.labelEraseRecording]},{xtype:"syno_panel",layout:"form",padding:"4px 0 0 8px",labelWidth:this.SCHEDULE_COMBO_LABEL_WIDTH,items:[this.fieldCustom1Detection,this.fieldCustom2Detection,this.cmbCustom1DI,this.cmbCustom2DI]}]});this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.Save,scope:this});this.btnReset=new SYNO.ux.Button({text:_T("ss_common","common_reset"),handler:this.Reset,scope:this})},InitEventHandler:function(){this.mon(SYNO.SDS.StatusNotifier,"clickScheduleType",this.OnSelCustomScheduleChange,this)},UpdateUI:function(a){if(false===SYNO.SS.App.Camera.Utils.IsStoreLoaded()){Ext.defer(this.UpdateUI,300,this,[a]);return}var b=SYNO.SS.App.HomeMode.Utils.ScheStrToScheArray(a.rec_schedule);this.UpdateSchedule(b);this.UpdateCmbs(a);this.UpdateDetectionList(a);this.blMask=!a.rec_schedule_on},UpdateCmbs:function(a){this.dsCustom1DI.loadData([[1,_T("camera","all_digital_inputs")],[0,_T("ss_common","common_none")]]);this.dsCustom2DI.loadData([[1,_T("camera","all_digital_inputs")],[0,_T("ss_common","common_none")]]);this.cmbCustom1DI.setValue(a.custom1_di);this.cmbCustom2DI.setValue(a.custom2_di);this.cmbCustom1DI.initValue();this.cmbCustom2DI.initValue()},UpdateDetectionList:function(f){var a=SYNO.SS.App.Camera.Utils.dsCameraCap;var h=false;var c=false;var e=false;var d=false;a.each(function(j){if(0<j.data.TDCap){h=true}if(0<j.data.ADCap){c=true}if((0<j.data.PDCap)&&(DEPEND_NONE===j.data.PDDepend)){e=true}if(true===j.data.application){d=true}});this.detList=[];this.detList.push([this.CUSTOM_DET_MD,_T("camera","motion_detection")]);if(true===h){this.detList.push([this.CUSTOM_DET_TD,_T("ss_common","trigger_tampering")])}if(true===c){this.detList.push([this.CUSTOM_DET_AD,_T("ss_common","trigger_audio")])}if(true===e){this.detList.push([this.CUSTOM_DET_PD,"PIR"])}if(true===d){var b=this.GetAppTextPairList();var g=this.detList.map(function(j){return j[0]}).indexOf(this.CUSTOM_DET_MD);b.forEach(function(j){if(true===SYNO.SS.App.Camera.Utils.IsApplicationVMDTrigEvt(j[0],this.CUSTOM_DET_APP)){this.detList.splice(g+1,0,j)}else{this.detList.push(j)}},this)}this.dsCustom1Detection.loadData(this.detList);this.dsCustom2Detection.loadData(this.detList);this.fieldCustom1Detection.setValue(this.GetDetectionArray(f.custom1_det).join(","));this.fieldCustom2Detection.setValue(this.GetDetectionArray(f.custom2_det).join(","));this.fieldCustom1Detection.initValue();this.fieldCustom2Detection.initValue()},GetAppTextPairList:function(){var c=[];var b;var e=SYNO.SS.GblStore.dsCamera;var d;var a=function(g){var f=false;c.forEach(function(j,h){if(j[0]===g){f=true}else{if(true===SYNO.SS.App.Camera.Utils.IsApplicationVMDTrigEvt(g,this.CUSTOM_DET_APP)){f=(f||(true===SYNO.SS.App.Camera.Utils.IsApplicationVMDTrigEvt(j[0],this.CUSTOM_DET_APP)))}}},this);return f};e.each(function(f){if(LOCAL_DS_ID==f.data.ownerDsId){b=SYNO.SS.App.Camera.Utils.GetFlagAppTextPairList(f.data,this.CUSTOM_DET_APP);for(d=0;d<b.length;d++){if(false===a.call(this,b[d][0])){c.push(b[d])}}}},this);return c},GetDetectionFlag:function(c){var b;var a;var d=0;a=c.getValue().split(",");for(b=0;b<a.size();b++){if(false===Ext.isNumber(parseInt(a[b],10))){continue}d+=parseInt(this.detList[a[b]][0],10)}return d},GetDetectionArray:function(c){var a;var b=[];for(a=0;a<this.detList.size();a++){if(c&parseInt(this.detList[a][0],10)){b.push(a)}}return b},UpdateSchedule:function(a){this.panelScheduler.Activate({id:-1,detailInfo:{camSchedule:a}})},ResetSchedule:function(){this.UpdateSchedule(this.panelScheduler.GetScheduleData())},Activate:function(){this.parent.MaskTab(this,this.blMask)},Deactivate:function(){this.Reset()},OnSelCustomScheduleChange:function(){var a=this.panelScheduler.GetCurrentAct();if(a===this.schedulerAct){return}this.schedulerAct=a;this.fieldCustom1Detection.hide();this.cmbCustom1DI.hide();this.fieldCustom2Detection.hide();this.cmbCustom2DI.hide();switch(a){case"custom1":this.fieldCustom1Detection.show();this.cmbCustom1DI.show();break;case"custom2":this.fieldCustom2Detection.show();this.cmbCustom2DI.show();break;default:break}},CreateModeImg:function(b,a,d){var c=this.panelScheduler.getId();return new SYNO.ux.Panel({width:this.IMAGE_ICON_SIZE,html:"<span id='"+this.strScheIdPrefix+b+"' class='"+a+"'onMouseOver=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.strScheIdPrefix+"', 'over', '"+d+"','"+c+"');\"onMouseOut=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.strScheIdPrefix+"', 'out', '"+d+"','"+c+"');\"onMousedown=\"javascript:SYNO.SS.UTILSCHEDULER.ChkLeftMouseDown(event, SYNO.SS.UTILSCHEDULER.ScheduleMouseAction, '"+this.strScheIdPrefix+"', 'down', '"+d+"','"+c+"');\"></span>"})},CreateModeLabel:function(a,b){return new SYNO.ux.DisplayField({id:this.strScheIdPrefix+a,width:this.SCHEDULE_TYPE_LABEL_WIDTH,cls:"ss-schedule-label-normal",value:b})},CreateArrayStore:function(a){return new Ext.data.ArrayStore({autoDestroy:true,fields:a,data:[]})},CreateDetectionField:function(a){var b={fieldLabel:_T("camera","detection"),width:268,editable:false,allowBlank:false,allowNoSelection:true,msgTarget:"title",strAllItems:_T("camera","all_detections"),strNoneItem:_T("ss_common","common_none"),displayField:"detection",disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT))};return new SYNO.SS.Form.MultiSelectField(Ext.apply(b,a))},CreateCmb:function(a){var b={fieldLabel:_T("ss_common","trigger_digital_input"),width:275,valueField:"id",displayField:"text",mode:"local",forceSelection:true,triggerAction:"all",editable:false,disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT))};return new SYNO.ux.ComboBox(Ext.apply(b,a))},IsDirty:function(){return(this.panelScheduler.IsDirty()||this.fieldCustom1Detection.isDirty()||this.fieldCustom2Detection.isDirty()||this.cmbCustom1DI.isDirty()||this.cmbCustom2DI.isDirty())},ClearDirty:function(){var a=this.getForm().getFieldValues();this.getForm().setValues(a);this.panelScheduler.ClearDirty()},Save:function(){if(false===this.IsDirty()){this.setStatusNoChange();return}var a={save_rec_schedule:true,rec_schedule:this.panelScheduler.GetSchedule(),custom1_det:this.GetDetectionFlag(this.fieldCustom1Detection),custom2_det:this.GetDetectionFlag(this.fieldCustom2Detection),custom1_di:this.cmbCustom1DI.getValue(),custom2_di:this.cmbCustom2DI.getValue()};var b=function(c,d,e){this.clearStatusBusy();this.ClearDirty();if(false===c){return}this.setStatusOK()}.createDelegate(this);this.setStatusSaving();this.parentWin.WebAPIRequest("SaveSysSetting",a,b)},Reset:function(){this.ResetSchedule();this.fieldCustom1Detection.reset();this.fieldCustom2Detection.reset();this.cmbCustom1DI.reset();this.cmbCustom2DI.reset()}});Ext.define("SYNO.SS.App.HomeMode.NotifyPanel",{extend:"SYNO.SDS.Utils.FormPanel",parentWin:null,parent:null,blMask:true,panelEvent:null,btnSave:null,btnReset:null,LABEL_WIDTH:240,constructor:function(a){this.parent=a;this.parentWin=a.parentWin;this.Init();this.callParent([{title:_T("event","event_setting"),border:false,autoFlexcroll:false,trackResetOnLoad:true,buttons:[this.btnSave,this.btnReset],items:[this.panelEvent],scope:this}]);this.InitEventHandler()},Init:function(){this.panelEvent=new SYNO.SS.App.HomeMode.NotifyEventGrid({parentWin:this.parentWin,ctPanel:this,disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT))});this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.Save,scope:this});this.btnReset=new SYNO.ux.Button({text:_T("ss_common","common_reset"),handler:this.Reset,scope:this})},InitEventHandler:function(){this.mon(this,"resize",this.Resize,this)},UpdateUI:function(a){this.panelEvent.UpdateData(a.notify_event_list);this.blMask=!a.notify_on},Activate:function(){this.parent.MaskTab(this,this.blMask)},Deactivate:function(){this.Reset()},Resize:function(){this.panelEvent.setHeight(this.getInnerHeight())},IsDirty:function(){return this.panelEvent.IsFormDirty()},Save:function(){if(false===this.IsDirty()){this.setStatusNoChange();return}this.panelEvent.Save()},Reset:function(){this.panelEvent.ResetData()}});Ext.define("SYNO.SS.App.HomeMode.NotifyEventGrid",{extend:"SYNO.SS.App.Notification.SSEvtListGrid",constructor:function(a){this.callParent([Ext.apply(a,{notip:true,nobbar:true})])},UpdateData:function(a){var b={list:a};this.OnRefreshDone(true,b)},CommitChange:function(){this.dsNotifyEvt.commitChanges()},Save:function(){var a={};var b=function(c,d,e){this.ctPanel.clearStatusBusy();if(false===c){return}this.CommitChange();this.ctPanel.setStatusOK()}.createDelegate(this);this.dsNotifyEvt.each(function(c){a[c.data.eventType]=c.data.filter});this.ctPanel.setStatusSaving();this.parentWin.WebAPIRequest("SaveNotifyFilter",a,b)}});Ext.define("SYNO.SS.App.HomeMode.StreamProfilePanel",{extend:"SYNO.SDS.Utils.FormPanel",parentWin:null,parent:null,blMask:true,btnSave:null,btnReset:null,cmbLive:null,cmbMobile:null,cmbCont:null,cmbMD:null,cmbCustom1:null,cmbCustom2:null,fldSetLiveProfile:null,fldSetRecProfile:null,dsProfileType:null,COMBO_WIDTH:250,constructor:function(a){this.parent=a;this.parentWin=a.parentWin;this.Init();this.callParent([{title:_T("camera","stream_allocation"),border:false,padding:0,autoFlexcroll:false,trackResetOnLoad:true,buttons:[this.btnSave,this.btnReset],items:[this.fldSetLiveProfile,this.fldSetRecProfile],scope:this}])},Init:function(){this.InitProfileTypeStore();this.InitLiveProfile();this.InitRecProfile();this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.Save,scope:this});this.btnReset=new SYNO.ux.Button({text:_T("ss_common","common_reset"),handler:this.Reset,scope:this})},InitProfileTypeStore:function(){this.dsProfileType=new Ext.data.ArrayStore({autoDestroy:true,fields:["type","text"],data:[[SYNO.SS.App.Camera.Def.Profile.HIGH,_T("camera","profile_high_quality")],[SYNO.SS.App.Camera.Def.Profile.MEDIUM,_T("camera","profile_balanced")],[SYNO.SS.App.Camera.Def.Profile.LOW,_T("camera","profile_low_bandwidth")]]})},InitLiveProfile:function(){this.cmbLive=this.CreateProfileSelectorCmb({name:"camProfileLive",fieldLabel:_T("camera","stm_type_liveview")});this.cmbMobile=this.CreateProfileSelectorCmb({name:"camProfileMobile",fieldLabel:_T("camera","stm_type_mobile")});this.fldSetLiveProfile=new SYNO.ux.FieldSet({title:_T("rtsp","liveview_settings"),bodyStyle:"padding-left: 4px;",autoHeight:true,collapsible:true,items:[this.cmbLive,this.cmbMobile]})},InitRecProfile:function(){this.cmbCont=this.CreateProfileSelectorCmb({name:"camProfileScheConti",fieldLabel:"<span class='icon_continue' style='float: left'></span>"+_T("camera","abbre_camera_continuous_recording")});this.cmbMD=this.CreateProfileSelectorCmb({name:"camProfileScheMD",fieldLabel:"<span class='icon_motion' style='float: left'></span>"+_T("camera","abbre_camera_motion_recording")});this.cmbCustom1=this.CreateProfileSelectorCmb({name:"camProfileScheCustom1",fieldLabel:"<span class='icon_custom1' style='float: left'></span>"+_T("ss_common","common_customize")+" 1"});this.cmbCustom2=this.CreateProfileSelectorCmb({name:"camProfileScheCustom2",fieldLabel:"<span class='icon_custom2' style='float: left'></span>"+_T("ss_common","common_customize")+" 2"});this.fldSetRecProfile=new SYNO.ux.FieldSet({title:_T("camera","schedule_recording_type_header"),autoHeight:true,collapsible:true,items:[this.cmbCont,this.cmbMD,this.cmbCustom1,this.cmbCustom2]})},UpdateUI:function(a){var b=a.stream_profile;var c=b.split(",").map(function(d){return parseInt(d,10)});this.getForm().loadRecord(new Ext.data.Record({camProfileLive:c[SYNO.SS.App.HomeMode.Def.StmProfileIdx.LIVE],camProfileMobile:c[SYNO.SS.App.HomeMode.Def.StmProfileIdx.MOBILE],camProfileScheConti:c[SYNO.SS.App.HomeMode.Def.StmProfileIdx.CONT],camProfileScheMD:c[SYNO.SS.App.HomeMode.Def.StmProfileIdx.MD],camProfileScheCustom1:c[SYNO.SS.App.HomeMode.Def.StmProfileIdx.CUSTOM1],camProfileScheCustom2:c[SYNO.SS.App.HomeMode.Def.StmProfileIdx.CUSTOM2]}));this.blMask=!a.streaming_on},CreateProfileSelectorCmb:function(b){var a={disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),width:this.COMBO_WIDTH,store:this.dsProfileType,valueField:"type",displayField:"text",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,lastQuery:""};Ext.apply(a,b);return new SYNO.ux.ComboBox(a)},GetStmProfile:function(){var a=[];a.push(this.cmbLive.getValue());a.push(this.cmbMobile.getValue());a.push(this.cmbCont.getValue());a.push(this.cmbMD.getValue());a.push(this.cmbCustom1.getValue());a.push(this.cmbCustom2.getValue());return a.join(",")},Activate:function(){this.parent.MaskTab(this,this.blMask)},Deactivate:function(){this.Reset()},IsDirty:function(){return this.getForm().isDirty()},ClearDirty:function(){var a=this.getForm().getFieldValues();this.getForm().setValues(a)},Save:function(){if(false===this.IsDirty()){this.setStatusNoChange();return}var a={save_stream_profile:true,stream_profile:this.GetStmProfile()};var b=function(c,d,e){this.clearStatusBusy();this.ClearDirty();if(false===c){return}this.setStatusOK()}.createDelegate(this);this.setStatusSaving();this.parentWin.WebAPIRequest("SaveSysSetting",a,b)},Reset:function(){this.getForm().reset()}});Ext.namespace("SYNO.SS.App.HomeMode");Ext.define("SYNO.SS.App.HomeMode.ActionRuleListView",{extend:"SYNO.SS.App.ActionRule.ExpandableListView",chkboxTpl:"",SCHE_CONTENT_ID_PREFIX:"hm_actrule_content_",SCHE_ID_PREFIX:"hm_actrule_",ALL_ACTRULE_ID:-1,CHK_DIV_CLS:"hm-actrule-chkbox",LINK_CLS:"hyperlink-bold",constructor:function(a){this.callParent([a]);this.chkboxTpl=new Ext.XTemplate("{activeInHomeMode:this.RenderChkbox}");this.tpl=this.createTpl(a);this.AddTplRenderer();this.mon(this,"click",this.OnCellClick,this);this.mon(this,"updateRecord",this.RenderSche,this);this.mon(this,"beforeRestoreUI",this.RenderAllSche,this)},createTpl:function(a){var b=(this.viewStyleTpl)?this.viewStyleTpl.html:"";var c=String.format("{0}-{{1}}",this.getId(),a.store.idProperty);return new Ext.XTemplate('<tpl for=".">',"<div id="+c+' class="item-wrap">','<div class="item-summary">','<div class="'+this.CHK_DIV_CLS+'">'+this.chkboxTpl.html+"</div>",(this.iconTpl)?'<div class="hm-actrule-icon">'+this.iconTpl.html+(this.playMaskTpl?this.playMaskTpl.html:"")+"</div>":"",'<tpl if="multiRuleId != -1">','<table class="item-summary-table hm-actrule-summary">','<tr class="item-title">','<td class="item-title-left"'+b+">"+this.titleTpl.html+"</td>","</tr>",'<tr class="item-desc">','<td class="item-desc-left"'+b+">"+this.descTpl.html+"</td>","</tr>","</table>","</tpl>",'<tpl if="multiRuleId == -1">','<div class="hm-actrule-summary hm-actrule-all">',"{name}","</div>","</tpl>","</div>",'<div class="item-detail" style="display:none">','<tpl if="multiRuleId != -1">',(this.innerTpl)?this.innerTpl.html:"","</tpl>","</div>","</div>","</tpl>",'<div class="x-clear"></div>')},AddTplRenderer:function(){this.callParent(arguments);this.tpl.RenderChkbox=function(c,b){if((this.view.ALL_ACTRULE_ID!==b.multiRuleId)&&(true===this.view.IsAllChecked())){return IMG_CHECKED_DISABLE}else{return(true===c)?IMG_CHECKED:IMG_UNCHECKED}};var a=this.tpl.RenderStatusIcon.createDelegate(this.tpl);this.tpl.RenderStatusIcon=function(c,b){if(this.view.ALL_ACTRULE_ID===b.multiRuleId){return'<div class="action-rule-all-icon">&nbsp;</div>'}else{b.enabled=true;return a(c,b)}};this.tpl.RenderName=function(c,b){return String.format('<a class="{1}" ext:qtip="{0}">{0}</a>',c,this.view.LINK_CLS)}},RenderAllSche:function(){this.store.each(function(a){this.RenderSche(this,a)},this)},RenderSche:function(c,b){if(!b){return}var e=b.get("multiRuleId");var a=this.findAppWindow().getAppDSId();if(this.ALL_ACTRULE_ID===e){return}var d=new SYNO.SS.Panel.SchedulerPanel({renderTo:a+this.SCHE_CONTENT_ID_PREFIX+e,htmlSchedulerId:a+this.SCHE_ID_PREFIX+e,scheduleMode:SYNO.SS.Schedule.Mode.ACTRULE,blEditable:false,blTwoColor:true});this.scheObj[e]=d},OnCellClick:function(c,d,g,j,f){var h=j.target;if(!h){return false}if(true===h.hasClassName(this.LINK_CLS)){this.OpenActionRuleApp(this.store.getAt(d));return true}if(!h.hasClassName(this.CHK_DIV_CLS)&&!h.parentNode.hasClassName(this.CHK_DIV_CLS)){return false}var b=this.store.getAt(d);var a=!b.data.activeInHomeMode;if(this.ALL_ACTRULE_ID===b.data.multiRuleId){this.CheckAll(a);return true}if(false===this.IsAllChecked()){this.CheckRow(d,a)}return true},OpenActionRuleApp:function(b){var a=SYNO.SS.Module.InstanceNameMap[MODULE_ID_ACTION_RULE];var c={itemId:b.get("multiRuleId")};SYNO.SDS.AppLaunch(a,c,true)},CheckAll:function(a){var c;var b=this.store.getRange();for(c=0;c<b.length;c++){this.CheckRow(c,a)}},CheckRow:function(c,b){var a=this.store.getAt(c);a.set("activeInHomeMode",b);this.refreshNode(c)},IsAllChecked:function(){var a=this.store.getAt(0);if(this.ALL_ACTRULE_ID!==a.data.multiRuleId){return false}return a.data.activeInHomeMode},GetActiveActruleString:function(){if(true===this.IsAllChecked()){return"-1"}var b=[];var a=this.store.getRange();for(i=0;i<a.length;i++){if(this.ALL_ACTRULE_ID===a[i].data.multiRuleId){continue}if(true===a[i].data.activeInHomeMode){b.push(a[i].data.multiRuleId)}}return b.join(",")},IsDirty:function(){var a=this.store.getModifiedRecords();return(0<a.length)},CommitChanges:function(){this.store.commitChanges()},Reset:function(){this.store.rejectChanges()}});Ext.define("SYNO.SS.App.HomeMode.ActionRulePanel",{extend:"SYNO.SDS.Utils.FormPanel",parentWin:null,parent:null,blMask:true,actruleView:null,panelView:null,panelHeader:null,dsActRule:null,fields:null,blDataReady:false,strActRules:null,btnSave:null,btnReset:null,LABEL_WIDTH:240,constructor:function(a){this.parent=a;this.parentWin=a.parentWin;this.Init();this.callParent([{title:_T("action_rule","action_rule"),cls:"hm-action-rule",autoFlexcroll:false,border:false,trackResetOnLoad:true,buttons:[this.btnSave,this.btnReset],items:[this.panelHeader,this.panelView]}]);this.InitEventHandler()},Init:function(){this.fields=[{name:"ruleId",type:"int"},{name:"name"},{name:"status",type:"int"},{name:"ruleType",type:"int"},{name:"actType",type:"int"},{name:"evtMinIntvl",type:"int"},{name:"actions"},{name:"multiRuleId",type:"int"},{name:"actSchedule"},{name:"events"},{name:"multiEvtSetting",type:"int"},{name:"enabled"},{name:"activeInHomeMode",type:"boolean"}];this.dsActRule=new SYNO.API.JsonStore({appWindow:this.parentWin,api:"SYNO.SurveillanceStation.ActionRule",method:"List",version:3,baseParams:{start:0,limit:SYNO.SS.Pgls.MIN_PAGE_RECORDS},root:"actRule",idProperty:"multiRuleId",totalProperty:"total",fields:this.fields,listeners:{loadexception:function(){this.getMsgBox().alert(_T("home_mode","home_mode"),_T("ss_common","error_system"))},load:function(c,b,d){var a=new (Ext.data.Record.create(this.fields))({ruleId:-1,name:_T("home_mode","all_action_rules"),status:0,ruleType:-1,actType:-1,evtMinIntvl:-1,actions:[],multiRuleId:-1,actSchedule:"",events:[],multiEvtSetting:-1,enabled:true,activeInHomeMode:("-1"===this.strActRules)});c.insert(0,a);this.actruleView.CommitChanges();this.actruleView.refresh();this.actruleView.select(0);this.blDataReady=true},scope:this}});this.actruleView=new SYNO.SS.App.HomeMode.ActionRuleListView({owner:this,store:this.dsActRule,toggleOnDblClick:false});this.panelView=new SYNO.SS.ViewPanel({disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),view:this.actruleView,plugins:SYNO.SS.Pgls.CreatePglsPlugin({ptype:"synoSSPglsPlugin",store:this.dsActRule})});this.panelHeader=new SYNO.SS.Grid.GridPanel({disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),store:new Ext.data.Store(),border:false,viewConfig:{forceFit:true},cm:new Ext.grid.ColumnModel([{header:_T("action_rule","action_rule"),sortable:false,resizable:false},{header:_T("ss_common","common_enable"),sortable:false,resizable:false,align:"center",fixed:true,width:80}])});this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.Save,scope:this});this.btnReset=new SYNO.ux.Button({text:_T("ss_common","common_reset"),handler:this.Reset,scope:this})},InitEventHandler:function(){this.mon(this,"resize",this.Resize,this);this.mon(SYNO.SDS.StatusNotifier,"actruleUpdate",this.Refresh,this);this.mon(SYNO.SDS.StatusNotifier,"homeModeNeedLoad",function(a){if(this.parentWin.appDSId===a){this.blDataReady=false}},this)},Resize:function(){this.panelHeader.setHeight(24);this.panelView.setHeight(this.getInnerHeight()-this.panelHeader.getHeight())},UpdateUI:function(a){this.strActRules=a.actrules;if(false===this.blDataReady){this.dsActRule.load()}this.blMask=!a.actrule_on},Refresh:function(){this.setStatusBusy();this.dsActRule.load({callback:this.clearStatusBusy,scope:this})},Activate:function(){this.parent.MaskTab(this,this.blMask)},Deactivate:function(){this.Reset()},IsDirty:function(){return this.actruleView.IsDirty()},ClearDirty:function(){var a=this.getForm().getFieldValues();this.getForm().setValues(a)},Save:function(){if(false===this.IsDirty()){this.setStatusNoChange();return}var a={save_action_rule:true,actrules:this.actruleView.GetActiveActruleString()};var b=function(c,d,e){this.clearStatusBusy();this.ClearDirty();if(false===c){return}this.actruleView.CommitChanges();this.setStatusOK()}.createDelegate(this);this.setStatusSaving();this.parentWin.WebAPIRequest("SaveSysSetting",a,b)},Reset:function(){this.actruleView.Reset()}});Ext.define("SYNO.SS.App.HomeMode.Profile",{extend:"SYNO.SDS.Utils.TabPanel",parentWin:null,panelGeneral:null,panelRecording:null,panelNotify:null,panelStreamProfile:null,panelActionRule:null,tabIdx:{General:0,Recording:1,Notify:2,StreamProfile:3,ActionRule:4},constructor:function(a){this.parentWin=a;this.Init();this.callParent([{cls:"hm-profile",useDefaultBtn:false,activeTab:this.tabIdx.General,items:[this.panelGeneral,this.panelRecording,this.panelNotify,this.panelStreamProfile,this.panelActionRule],listeners:{beforetabchange:function(d,e,c){var b=function(){this.Reset();this.setActiveTab(e)}.createDelegate(this);if(true===this.parentWin.CheckDirty(b)){return false}return true},tabchange:function(b,c){c.Activate()},scope:this}}])},Init:function(){this.panelGeneral=new SYNO.SS.App.HomeMode.ProfileGeneral(this);this.panelRecording=new SYNO.SS.App.HomeMode.RecSchePanel(this);this.panelNotify=new SYNO.SS.App.HomeMode.NotifyPanel(this);this.panelStreamProfile=new SYNO.SS.App.HomeMode.StreamProfilePanel(this);this.panelActionRule=new SYNO.SS.App.HomeMode.ActionRulePanel(this)},UpdateUI:function(a){this.panelGeneral.UpdateUI(a);this.panelRecording.UpdateUI(a);this.panelNotify.UpdateUI(a);this.panelStreamProfile.UpdateUI(a);this.panelActionRule.UpdateUI(a)},Activate:function(){this.getActiveTab().Activate()},Deactivate:function(){this.Reset()},MaskTab:function(d,b){var f=_T("home_mode","profile_mask_hint");var a="syno-ux-empty-style-link";var e="syno-ux-style-mask-info";var c=d.body;f=SYNO.ux.EmptyStyle.CreateHrefString(f,this.BackToGeneral);if(true===b){if(true===c.isMasked()){return}SYNO.SS.Utils.MaskEl(c,f,e);this.mon(c,{click:function(g,h){if(true===Ext.fly(h).hasClass(a)){this.BackToGeneral()}},scope:this});this.mon(d,{resize:function(){var g=this.getActiveTab();if(g){this.MaskTab(g,g.blMask)}},scope:this})}else{if(false===c.isMasked()){return}SYNO.SS.Utils.UnmaskEl(c);this.mun(c,"click");this.mun(d,"resize")}},BackToGeneral:function(){this.setActiveTab(this.tabIdx.General)},IsDirty:function(){return this.getActiveTab().IsDirty()},Reset:function(){return this.getActiveTab().Reset()}});Ext.define("SYNO.SS.App.HomeMode.AdvancedPanel",{extend:"SYNO.SDS.Utils.FormPanel",parentWin:null,btnSave:null,btnReset:null,btnGoBack:null,labelScheDirections:null,chkEnableSche:null,panelScheduler:null,panelModeSelection:null,schId:"",dsCamera:null,dsIOModule:null,cameraList:null,iomoduleList:null,fldCamera:null,fldIOModule:null,blDataReady:false,panelFldSet:null,fldSetAppliedDevice:null,fldSetScheduleSetting:null,LABEL_WIDTH:240,constructor:function(a){this.parentWin=a;this.Init();this.callParent([{border:false,trackResetOnLoad:true,buttons:[this.btnSave,this.btnReset],tbar:{xtype:"syno_toolbar",items:[this.btnGoBack]},items:[this.panelFldSet],scope:this}]);this.InitEventHandler()},Init:function(){this.dsCamera=new Ext.data.ArrayStore({autoDestroy:true,fields:["id","name"]});this.dsIOModule=new Ext.data.ArrayStore({autoDestroy:true,fields:["id","name"]});this.fldCamera=new SYNO.SS.Form.MultiSelectField({width:275,hidden:false,disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),hideLabel:true,editable:false,allowBlank:false,allowNoSelection:true,msgTarget:"title",strAllItems:_T("ss_common","common_all_cameras"),strNoneItem:_T("ss_common","common_none"),displayField:"name",store:this.dsCamera});this.fldIOModule=new SYNO.SS.Form.MultiSelectField({width:275,hidden:false,disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),hideLabel:true,editable:false,allowBlank:false,allowNoSelection:true,msgTarget:"title",strAllItems:_T("ss_privilege","iomodule_all"),strNoneItem:_T("ss_common","common_none"),displayField:"name",store:this.dsIOModule});this.labelScheDirections=new SYNO.ux.DisplayField({value:_T("home_mode","sche_switch_directions"),hideLabel:false,hidden:false});this.chkEnableSche=new SYNO.SS.Form.Checkbox({boxLabel:_T("home_mode","enable_sche_switch"),hideLabel:false,disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.HOME_MODE_EDIT)),handler:function(a,b){this.panelScheduler.SetDisabled(!b)},scope:this});this.schId=Ext.id();this.panelScheduler=new SYNO.SS.Panel.SchedulerPanel({htmlSchedulerId:this.schId,scheduleMode:SYNO.SS.Schedule.Mode.HOME_MODE,blTwoColor:true,listeners:{afterrender:function(){this.panelScheduler.Activate()},scope:this}});this.panelModeSelection=new SYNO.SS.Panel.ScheduleModePanel({width:SYNO.SS.UTILSCHEDULER.GetTableWidth(),style:"padding: 10px 0px 10px 0px;",layout:"auto"});this.InitModeSelectionPanel();this.fldSetAppliedDevice=new SYNO.ux.FieldSet({title:_T("home_mode","applied_devices"),autoHeight:true,collapsible:false,bodyStyle:"padding-left: 4px;",layout:"form",items:[{xtype:"container",layout:"hbox",style:"padding-bottom: 4px;",items:[{xtype:"syno_displayfield",value:_T("ss_common","cameras")+":",width:this.LABEL_WIDTH},this.fldCamera]},{xtype:"container",layout:"hbox",items:[{xtype:"syno_displayfield",value:_T("ss_common","common_iomodule")+":",width:this.LABEL_WIDTH},this.fldIOModule]}],listeners:{afterrender:function(){var b=Ext.getDom(this.fldSetAppliedDevice.getEl());var a=b.childNodes[0].childNodes[1];SYNO.SS.Utils.AddTip(a,_T("home_mode","applied_devices_info"))},scope:this}});this.fldSetScheduleSetting=new SYNO.ux.FieldSet({title:_T("home_mode","sche_settings"),autoHeight:true,collapsible:false,bodyStyle:"padding-left: 4px;",layout:"vbox",items:[this.labelScheDirections,this.chkEnableSche,this.panelModeSelection,this.panelScheduler]});this.panelFldSet=new Ext.Container({autoFlexcroll:true,layout:"fit",items:[this.fldSetAppliedDevice,this.fldSetScheduleSetting]});this.btnGoBack=new SYNO.SS.Button.GoButton({disabled:false,text:_T("ss_common","go_back"),blBack:true,fnHandler:function(){this.parentWin.BackToMainPage()}.createDelegate(this),scope:this});this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.Save,scope:this});this.btnReset=new SYNO.ux.Button({text:_T("ss_common","common_reset"),handler:this.Reset,scope:this})},InitModeSelectionPanel:function(){var a=this.panelScheduler.getId();this.panelModeSelection.removeAll();this.panelModeSelection.add({xtype:"container",layout:"column",items:[{xtype:"container",style:"width: 35px;",html:"<span id='"+this.schId+"icon_custom2' class='btn_custom2_inactive' onMouseOver=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'over', 'continue','"+a+"');\"onMouseOut=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'out', 'continue','"+a+"');\"onMousedown=\"javascript:SYNO.SS.UTILSCHEDULER.ChkLeftMouseDown(event, SYNO.SS.UTILSCHEDULER.ScheduleMouseAction, '"+this.schId+"', 'down', 'continue','"+a+"');\"></span>"},{xtype:"label",style:"width: 270px;",text:_T("home_mode","enter_home_mode"),cls:"x-form-item ss-schedule-label-normal"},{xtype:"container",style:"width: 35px;",html:"<span id='"+this.schId+"icon_erase' class='btn_erase_inactive' onMouseOver=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'over', 'erase','"+a+"');\"onMouseOut=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'out', 'erase','"+a+"');\"onMousedown=\"javascript:SYNO.SS.UTILSCHEDULER.ChkLeftMouseDown(event, SYNO.SS.UTILSCHEDULER.ScheduleMouseAction, '"+this.schId+"', 'down', 'erase','"+a+"');\"></span>"},{xtype:"label",style:"width: 270px;",text:_T("home_mode","leave_home_mode"),cls:"x-form-item ss-schedule-label-normal"}]});this.panelModeSelection.doLayout()},InitEventHandler:function(){this.mon(this,"resize",this.Resize,this)},Resize:function(){this.panelFldSet.setSize(this.getInnerWidth(),this.getInnerHeight())},LoadCameras:function(){var a,b,c;this.cameraList=[];for(a=0;a<SYNO.SS.GblStore.dsCamera.data.items.length;a++){b=SYNO.SS.GblStore.dsCamera.data.items[a].data;if(this.parentWin.appDSId!==b.ownerDsId){continue}if(SYNO.SS.CamSts.DELETED===b.camStatus){continue}if(LOCAL_DS_ID===this.parentWin.appDSId){c=b.id}else{c=b.camIdOnRecServer}this.cameraList.push([c,b.name])}this.dsCamera.loadData(this.cameraList)},LoadIOModules:function(){var b,a,c;this.iomoduleList=[];for(b=0;b<SYNO.SS.GblStore.dsIOModule.data.items.length;b++){a=SYNO.SS.GblStore.dsIOModule.data.items[b].data;if(this.parentWin.appDSId!==a.owner_ds_id){continue}if(LOCAL_DS_ID===this.parentWin.appDSId){c=a.id}else{c=a.id_on_rec_server}this.iomoduleList.push([c,a.name])}this.dsIOModule.loadData(this.iomoduleList)},UpdateUI:function(a){this.chkEnableSche.setValue(a.mode_schedule_on);this.chkEnableSche.initValue();if(false===this.blDataReady){this.LoadCameras();this.LoadIOModules();this.blDataReady=true}this.SetFieldValue(this.fldCamera,this.dsCamera,a.cameras);this.SetFieldValue(this.fldIOModule,this.dsIOModule,a.io_modules);scheduleList=SYNO.SS.App.HomeMode.Utils.ScheStrToScheArray(a.mode_schedule);this.UpdateScheduleUI(scheduleList);this.panelScheduler.SetDisabled(!a.mode_schedule_on)},UpdateScheduleUI:function(c){if(!c){return}var b,a;this.panelScheduler.UpdateScheduleData(c);for(b=0;b<7;b++){for(a=0;a<48;a++){if((0<c[b][a])){this.panelScheduler.SetCurrentAct("continue")}else{this.panelScheduler.SetCurrentAct("erase")}this.panelScheduler.ClickScheduleItem(this.schId,b,a)}}this.panelScheduler.DrawSelectAllItem(0);this.ResetScheduleBtnState()},ResetScheduleBtnState:function(){SYNO.SS.UTILSCHEDULER.ScheduleMouseAction(this.schId,"down","continue",this.panelScheduler.getId())},ResetSchedule:function(){this.UpdateScheduleUI(this.panelScheduler.GetScheduleData())},SetFieldValue:function(e,c,b){if("-1"===b){e.SelectAll();e.initValue();return}var d,a;var f=[];var g=[];if(b){f=b.split(",")}for(d=0;d<f.size();d++){a=c.find("id",f[d]);if(-1!==a){g.push(a)}}e.setValue(g.join(","));e.initValue()},GetFieldValue:function(c,a){if(true===c.IsAllItemSelected()){return"-1"}if(0===a.getCount()){return""}if(!c.getValue()){return""}var b;var e=c.getValue().split(",");var d=[];for(b=0;b<e.size();b++){d.push(a.getAt(e[b]).data.id)}return d.join(",")},Activate:function(){},Deactivate:function(){this.Reset()},IsDirty:function(){return((true===this.getForm().isDirty())||(true===this.panelScheduler.IsDirty()))},Save:function(){if(false===this.IsDirty()){this.setStatusNoChange();return}var a={mode_schedule_on:this.chkEnableSche.checked,mode_schedule:this.panelScheduler.GetSchedule(),cameras:this.GetFieldValue(this.fldCamera,this.dsCamera),io_modules:this.GetFieldValue(this.fldIOModule,this.dsIOModule)};var b=function(c,d,e){this.clearStatusBusy();this.setStatusOK()}.createDelegate(this);this.setStatusSaving();this.parentWin.WebAPIRequest("SaveAdvanced",a,b)},Reset:function(){this.getForm().reset();this.ResetSchedule()}});Ext.namespace("SYNO.SS.App.HomeMode");Ext.define("SYNO.SS.App.HomeMode.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SS.App.HomeMode.MainWindow"});Ext.define("SYNO.SS.App.HomeMode.MainWindow",{extend:"SYNO.SDS.AppWindow",setting:null,infoReqObj:null,gridIconCls:["icon-overview","icon-schedule","icon-profile"],gridTitle:[_T("ss_common","overview"),_T("ss_common","schedule"),_T("ss_common","setting")],gridIdx:{Overview:0,Schedule:1,Profile:2},WIN_MIN_WIDTH:1017,WIN_MIN_HEIGHT:600,constructor:function(a){this.Init();this.callParent([Ext.apply({cls:SYNO.SS.Grid.Categ.CLS_CATEG_CONTAINER+" hm-main",width:this.WIN_MIN_WIDTH,height:this.WIN_MIN_HEIGHT,minWidth:this.WIN_MIN_WIDTH,minHeight:this.WIN_MIN_HEIGHT,resizable:true,maximizable:true,layout:{type:"hbox",align:"stretch"},items:[this.gridCateg,this.panelContent]},a)]);this.InitEventHandler();this.setStatusBusy()},Init:function(){this.dsCateg=new Ext.data.ArrayStore({autoDestroy:true,fields:["id"],data:[[this.gridIdx.Overview],[this.gridIdx.Schedule],[this.gridIdx.Profile]]});this.gridCateg=new SYNO.SS.Grid.GridPanel({cls:SYNO.SS.Grid.Categ.CLS_CATEG_GRID_PANEL,store:this.dsCateg,hideHeaders:true,viewConfig:{forceFit:true},sm:new Ext.grid.RowSelectionModel({singleSelect:true,listeners:{beforerowselect:function(e,d,c,b){var a=function(){this.GetView().Deactivate();this.gridCateg.getSelectionModel().selectRow(d)}.createDelegate(this);if(true===this.CheckDirty(a)){return false}return true},rowselect:function(b,a){this.SetView(a);this.GetView().Activate()},scope:this}}),cm:new Ext.grid.ColumnModel([{sortable:false,renderer:this.RenderCateg.createDelegate(this),dataIndex:"id"}]),listeners:{afterrender:function(a){a.getEl().createChild({cls:"x-splitbar-h grid-split-bar"})},viewready:function(a){var b=a.getSelectionModel();if(true===Ext.isEmpty(b.getSelected())){b.selectFirstRow()}},scope:this}});this.panelOverview=new SYNO.SS.App.HomeMode.Overview(this);this.panelSchedule=new SYNO.SS.App.HomeMode.Schedule(this);this.panelProfile=new SYNO.SS.App.HomeMode.Profile(this);this.panelContent=new SYNO.ux.Panel({style:"padding-left: 16px;",layout:"card",flex:1,activeItem:0,items:[this.panelOverview,this.panelSchedule,this.panelProfile]})},InitEventHandler:function(){this.mon(SYNO.SDS.StatusNotifier,"homeModeNeedLoad",function(){if(!this.infoReqObj){this.LoadSetting(false,true)}},this);this.mon(SYNO.SDS.StatusNotifier,"homeModeUpdate",function(a){if(LOCAL_DS_ID!==this.getAppDSId()){return}this.RefreshUI(a.homeModeInfo.updData.data)},this)},RenderCateg:function(a){return String.format('<div class="{0}"><div class="{1}"></div><div class="{2}">{3}</div></div>',SYNO.SS.Grid.Categ.CLS_CATEG_ENTRY,this.gridIconCls[a],SYNO.SS.Grid.Categ.CLS_ENTRY_NAME,this.gridTitle[a])},SetView:function(a){this.panelContent.getLayout().setActiveItem(a)},GetView:function(){var d=this.gridCateg.getSelectionModel();var c=d.getSelected();var a;var b;if(!c){return this.panelOverview}a=c.get("id");switch(a){case this.gridIdx.Overview:return this.panelOverview;case this.gridIdx.Schedule:return this.panelSchedule;case this.gridIdx.Profile:return this.panelProfile;default:return this.panelOverview}},CheckDirty:function(c){var a=this.GetView();var b=this.getMsgBox();if(!a){return false}if(true===a.IsDirty()){SYNO.SS.Utils.ConfirmLostChange({msgBox:b,fnYes:function(){c()},scope:this});return true}return false},Activate:function(){this.GetView().Activate()},Deactivate:function(){this.GetView().Deactivate()},LoadSetting:function(c,a){if(true===c){this.setStatusBusy()}var b={need_mobiles:(a?true:false)};if(this.infoReqObj){Ext.Ajax.abort(this.infoReqObj);this.infoReqObj=null}this.infoReqObj=this.WebAPIRequest("GetInfo",b,function(d,e,f){this.infoReqObj=null;if(true===c){this.clearStatusBusy()}this.RefreshUI(e)})},UpdateUI:function(){this.panelOverview.UpdateUI(this.setting);this.panelSchedule.UpdateUI(this.setting);this.panelProfile.UpdateUI(this.setting);SYNO.SS.App.HomeMode.Utils.SetupTimerToRefresh()},onBeforeDestroy:function(){this.callParent(arguments)},onOpen:function(a){this.callParent(arguments);this.Activate();this.LoadSetting(true,true)},onRequest:function(a){this.callParent(arguments)},onClose:function(){var a=function(){this.Deactivate();this.doClose()}.createDelegate(this);if(true===this.CheckDirty(a)){return false}this.Deactivate();return true},WebAPIRequest:function(d,b,c,a){if((true===a)&&(this.infoReqObj)){Ext.Ajax.abort(this.infoReqObj);this.infoReqObj=null}return this.sendWebAPI({api:"SYNO.SurveillanceStation.HomeMode",version:1,method:d,params:b,callback:function(h,f,g,e){this.OnWebAPIRequestDone(h,f,g,e,c)},scope:this})},OnWebAPIRequestDone:function(g,d,e,c,f){var b=_T("ss_common","error_system");var a=this.getMsgBox();if(g){if((f)&&(true===Ext.isFunction(f))){f.call(this,g,d,e,c)}}else{a.alert(this.title,b)}},RefreshUI:function(a){if(!this.infoReqObj){this.setting={};Ext.apply(this.setting,a);this.UpdateUI()}}});