/* Copyright (c) 2019 Synology Inc. All rights reserved. */

Ext.define("SYNO.SS.App.PersonalSettings.FormPanel",{extend:"SYNO.ux.FormPanel",LABEL_WIDTH:220,FIELD_WIDTH:260,DESC_MAX_LENGTH:64,constructor:function(a){a=Ext.applyIf(a,{trackResetOnLoad:true,labelWidth:this.LABEL_WIDTH});this.callParent([a])},ResetData:function(){this.getForm().reset()},IsFormDirty:function(){return this.getForm().isDirty()},ClearDirty:function(){this.getForm().setValues(this.getForm().getFieldValues())},GetMsgBox:function(){return this.findAppWindow().getMsgBox()},SetStatusBusy:function(){this.findAppWindow().setStatusBarBusy()},ClearStatusBusy:function(){this.findAppWindow().clearStatusBarBusy()},Close:function(a){var b=this.findAppWindow();if(true===a){b.blForceClose=true}b.close()}});Ext.define("SYNO.SS.App.PersonalSettings.Account",{extend:"SYNO.SS.App.PersonalSettings.FormPanel",DEFAULT_PWD:"12345678",DEFAULT_CONFIRM_PWD:"87654321",fldUserName:null,fldUserDesc:null,fldPwd:null,fldConfirmPwd:null,cmbDisplayLang:null,blInited:false,strongPassValidator:null,startValidate:false,constructor:function(){this.InitUI();this.callParent([{title:_T("options","account"),items:this.GetFormItems(),trackResetOnLoad:true,labelWidth:this.LABEL_WIDTH}]);this.on("afterrender",this.InitData,this)},destroy:function(){delete this.strongPassValidator},InitUI:function(){this.fldUserName=new SYNO.ux.DisplayField({name:"username",fieldLabel:_T("ss_common","common_name"),cls:"ellipsis_text",style:"cursor: default;"});if(SYNO.SS.UserAuthType.LOCAL===_S("USER_AUTH_TYPE")){this.fldUserDesc=new SYNO.ux.TextField({name:"fullname",fieldLabel:_T("ss_common","common_description"),width:this.FIELD_WIDTH,maxLength:this.DESC_MAX_LENGTH})}else{this.fldUserDesc=new SYNO.ux.DisplayField({name:"fullname",fieldLabel:_T("ss_common","common_description"),width:this.FIELD_WIDTH,maxLength:this.DESC_MAX_LENGTH})}this.fldPwd=new SYNO.ux.TextField({inputType:"password",name:"password",preventAutoFill:true,width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","password"),maxLength:USER_PWD_MAX_LENGTH,value:(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE"))?"":this.DEFAULT_PWD,disabled:(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE")),validator:(function(a){if(!this.startValidate||this.isFakePasswd()){return true}if(this.strongPassValidator){return this.strongPassValidator.validate(a)}return true}).createDelegate(this),validateOnBlur:true,validationEvent:"blur"});this.fldConfirmPwd=new SYNO.ux.TextField({inputType:"password",name:"password2",preventAutoFill:true,width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","confirm_pwd"),maxLength:USER_PWD_MAX_LENGTH,value:(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE"))?"":this.DEFAULT_CONFIRM_PWD,disabled:(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE")),validator:(function(a){if(false===this.blInited){return true}else{if((this.DEFAULT_CONFIRM_PWD===a)&&(this.DEFAULT_PWD===this.fldPwd.getValue())){return true}else{if(a===this.fldPwd.getValue()){return true}else{return _T("ss_common","error_repswd")}}}}).createDelegate(this),validateOnBlur:true,validationEvent:"blur"});this.cmbDisplayLang=new SYNO.ux.ComboBox({name:"lang",fieldLabel:_T("visualstation","lang_display"),width:this.FIELD_WIDTH,store:SYNO.SS.Utils.GetLangStore(),valueField:"value",displayField:"display",mode:"local",forceSelection:true,triggerAction:"all",editable:false});this.fldLdapRedirect=new SYNO.ux.DisplayField({})},InitData:function(){this.SetStatusBusy();this.sendWebAPI({api:"SYNO.SurveillanceStation.UserPrivilege",method:"LoadOptions",version:1,callback:function(d,b,c,a){this.ClearStatusBusy();if(d){this.SetFormValues(b)}else{this.GetMsgBox().alert(_T("ss_common","common_options"),_T("ss_common","error_system"),this.close,this)}},scope:this})},GetFormItems:function(){var a;if(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE")){a=[this.fldUserName,this.fldUserDesc,this.fldPwd,this.fldConfirmPwd,this.cmbDisplayLang,this.fldLdapRedirect]}else{a=[this.fldUserName,this.fldUserDesc,this.fldPwd,this.fldConfirmPwd,this.cmbDisplayLang]}return a},SetFormValues:function(a){var b;this.strongPassValidator=new SYNO.SDS.Utils.StrongPassValidator(a.passwdRules.strong_password,_S("user"));this.startValidate=true;this.getForm().setValues(a);this.fldUserName.getEl().dom.setAttribute("ext:qtip",this.fldUserName.getValue());if(false===a.editable){this.fldUserDesc.setDisabled(true);this.fldPwd.setDisabled(true);this.fldConfirmPwd.setDisabled(true)}else{if((SYNO.SS.UserAuthType.LDAP!==_S("USER_AUTH_TYPE"))||(""==a.pageUrl)){this.fldPwd.setDisabled(a.disallowchpasswd);this.fldConfirmPwd.setDisabled(a.disallowchpasswd);this.fldLdapRedirect.hide()}else{b=String.format(a.pageUrl,a.serverAddr);this.fldLdapRedirect.setValue(String.format(_T("options","change_password_desc"),String.format("<a href={0} target=_blank>{1}</a>",b,_T("ss_common","common_here"))));this.fldLdapRedirect.initValue();this.fldPwd.hide();this.fldConfirmPwd.hide()}}this.syncSize();this.blInited=true},Validate:function(){if(SYNO.SS.UserAuthType.LOCAL===_S("USER_AUTH_TYPE")){return(this.fldUserDesc.validate())&&(this.fldPwd.validate())&&(this.fldConfirmPwd.validate())}else{return true}},OnSubmit:function(){this.findWindow().setStatusBarBusy({text:_T("ss_common","common_saving")});var c={userName:this.fldUserName.getValue(),userDesc:this.fldUserDesc.getValue(),userPwd:this.fldPwd.getValue(),userConfirmPwd:this.fldConfirmPwd.getValue(),displayLang:this.cmbDisplayLang.getValue(),oriDisplayLang:_S("LANG")};var b=String.format("{0}<ul><br><li>{1}</li></ul>",_T("ss_common","refresh_confirm"),_T("ss_common","lang_changed"));var a=function(){SYNO.SDS.Desktop.getMsgBox().confirm(_T("ss_common","language"),b,function(e){if("yes"===e){location.reload()}},this)};var d=function(h,f,g,e){this.findWindow().clearStatusBarBusy();if(h){this.findWindow().setStatusOK();if(true===this.cmbDisplayLang.isDirty()){a.call()}this.ClearDirty()}else{this.findWindow().setStatusError({text:_T("ss_common","error_system")})}}.createDelegate(this);this.sendWebAPI({api:"SYNO.SurveillanceStation.UserPrivilege",method:"SaveOptions",params:c,encryption:["userPwd","userConfirmPwd"],version:1,callback:d})},isFakePasswd:function(){var a=this.fldPwd.getValue();var b=this.fldConfirmPwd.getValue();if(a==="12345678"&&b==="87654321"){return true}return false}});Ext.define("SYNO.SS.App.PersonalSettings.Desktop",{extend:"Ext.form.FormPanel",imageSelectId:null,newImage:false,wallpaperSelector:null,constructor:function(a){Ext.applyIf(a,{title:_T("ss_common","desktop"),cls:"ss-personal-desktop-form",trackResetOnLoad:true,listeners:{afterlayout:{single:true,scope:this,fn:this.OnAfterLayout}},layout:"table",layoutConfig:{columns:2},items:[{colspan:2,itemId:"customize_color",name:"customize_color",xtype:"syno_checkbox",boxLabel:_T("options","customize_color")},{indent:1,xtype:"syno_displayfield",value:_T("options","text_color")+_T("ss_common","common_colon")},{itemId:"text_color",name:"text_color",xtype:"syno_colorfield",width:190,value:"#FFFFFF"},{indent:1,xtype:"syno_displayfield",value:_T("options","background_color")+_T("ss_common","common_colon")},{itemId:"background_color",name:"background_color",xtype:"syno_colorfield",width:190,value:"#FFFFFF"},{colspan:2,itemId:"customize_wallpaper",name:"customize_wallpaper",xtype:"syno_checkbox",boxLabel:_T("options","customize_wallpaper")},{rowspan:4,indent:1,itemId:"wallpaper_thumbnail",xtype:"box",cls:"thumb-customize",autoEl:{tag:"img"}},{cellCls:"wallpaper-cell",itemId:"wallpaper_filename",name:"wallpaper_filename",xtype:"syno_displayfield",hidden:_S("diskless"),value:""},{cellCls:"wallpaper-cell",id:this.imageSelectId=Ext.id(),xtype:"syno_button",hidden:_S("diskless"),text:_T("options","select_image"),scope:this,handler:this.OnSelectWallpaper},{cellCls:"wallpaper-cell",itemId:"wallpaper_position",name:"wallpaper_position",xtype:"syno_combobox",hidden:_S("diskless"),value:"center",width:190,forceSelection:true,allowBlank:false,displayField:"display",valueField:"value",store:new Ext.data.ArrayStore({autoDestroy:true,fields:["display","value"],data:[[_T("options","login_background_position_center"),"center"],[_T("options","login_background_position_fill"),"fill"],[_T("options","login_background_position_fit"),"fit"],[_T("options","login_background_position_stretch"),"stretch"],[_T("options","login_background_position_tile"),"tile"]]}),listeners:{select:{fn:this.OnChangeSettings,scope:this,buffer:100}}},{cellCls:"wallpaper-cell-last",itemId:"wallpaper_path",name:"wallpaper_path",xtype:"hidden",value:""},{itemId:"wallpaper_ext",name:"wallpaper_ext",xtype:"hidden",value:""},{itemId:"wallpaper_type",name:"wallpaper_type",xtype:"hidden",value:""}]});this.callParent([a]);this.origConfig=Ext.apply({},SYNO.SDS.UserSettings.getProperty("Desktop","wallpaper")||{});this.customizeWallpaper=this.getComponent("customize_wallpaper");this.wallpaperPath=this.getComponent("wallpaper_path");this.wallpaperExt=this.getComponent("wallpaper_ext");this.wallpaperType=this.getComponent("wallpaper_type");this.wallpaperThumbnail=this.getComponent("wallpaper_thumbnail");this.wallpaperFileName=this.getComponent("wallpaper_filename")},OnAfterLayout:function(){var c,a=this.getForm();var b={api:"SYNO.SurveillanceStation.PersonalSettings.Image",method:"GetWallpaper",version:1};c=new SYNO.SDS.Utils.EnableCheckGroup(a,"customize_color",["text_color","background_color"]);c=new SYNO.SDS.Utils.EnableCheckGroup(a,"customize_wallpaper",[this.imageSelectId,"wallpaper_position"]);if("admin"===_S("user")){SYNO.SDS.Utils.DisplayField(this.getForm(),"email",false)}a.setValues(this.origConfig);this.origConfig.wallpaper=1+(this.origConfig.wallpaper||0);this.wallpaperThumbnail.getEl().dom.src=SYNO.API.currentManager.getBaseURL(b)+"&DummyTime="+Date.now();this.getComponent("customize_color").on("check",this.OnChangeSettings,this,{buffer:200});this.getComponent("customize_wallpaper").on("check",this.OnChangeSettings,this,{buffer:200});this.getComponent("text_color").on("valid",this.OnChangeSettings,this,{buffer:200});this.getComponent("background_color").on("valid",this.OnChangeSettings,this,{buffer:200})},ApplyForm:function(){var a=this.getForm();if(!this.wallpaperPath.getValue()){this.customizeWallpaper.setValue(false)}if(!a.isDirty()){return}if(!a.isValid()){return false}this.ApplySettings();this.ClearDirty()},ApplySettings:function(){var b={},c={},a={};Ext.apply(c,this.getForm().getValues());Ext.apply(a,SYNO.SDS.UserSettings.getProperty("Desktop","wallpaper")||{});if(!this.customizeWallpaper.getValue()){delete (c.wallpaper_path);delete (c.wallpaper_ext);delete (c.wallpaper_type)}c.newImage=this.newImage;Ext.apply(b,a);Ext.apply(b,c,{customize_color:false,customize_wallpaper:false});b.wallpaper=1+(b.wallpaper||0);b.customize_color=this.ParseBool(b.customize_color);b.customize_wallpaper=this.ParseBool(b.customize_wallpaper);SYNO.SDS.UserSettings.setProperty("Desktop","wallpaper",b);SYNO.SDS.UserSettings.save();this.findWindow().setStatusOK();this.origConfig=Ext.apply({},SYNO.SDS.UserSettings.getProperty("Desktop","wallpaper")||{})},OnChangeSettings:function(){var a=Ext.apply({},this.getForm().getValues());if(!this.customizeWallpaper.getValue()||!a.wallpaper_path){delete (a.wallpaper_path);delete (a.wallpaper_ext);delete (a.wallpaper_type);a.customize_wallpaper=false}if(!this.getComponent("text_color").isValid()){a.text_color="#FFFFFF"}if(!this.getComponent("background_color").isValid()){a.background_color="#FFFFFF"}a.newImage=this.newImage;a.wallpaper=1+(a.wallpaper||0);a.customize_color=this.ParseBool(a.customize_color);a.customize_wallpaper=this.ParseBool(a.customize_wallpaper);SYNO.SDS.Desktop.updateBackground(a);SYNO.SDS.Desktop.updateTextColor(a)},ParseBool:function(a){if(a==="true"||a==="on"||a===true){return true}return false},OnSelectWallpaper:function(){if(this.wallpaperSelector){this.wallpaperSelector.show()}else{this.wallpaperSelector=new SYNO.SS.App.Utils.ImageSelector({owner:this.module},"desktop","background");this.wallpaperSelector.mon(this.wallpaperSelector,"choose",this.OnSelectWallpaperDone,this);this.wallpaperSelector.open()}},OnSelectWallpaperDone:function(a){if("fromDS"!==a.data.apply_type){this.SetWallpaper(a)}else{this.sendWebAPI({api:"SYNO.SurveillanceStation.PersonalSettings.Image",version:1,method:"GetWallpaper",params:{path:SYNO.SDS.Utils.bin2hex(a.data.path)},callback:function(b,d,e,c){if(d.responseText){this.SetWallpaper(a)}else{this.wallpaperSelector.setStatusError({text:_T("ss_common","error_privilege_not_enough"),clear:true})}},scope:this})}},SetWallpaper:function(a){this.newImage=true;this.wallpaperPath.setValue(a.data.path);this.wallpaperExt.setValue(a.data.type);this.wallpaperType.setValue(a.data.apply_type);this.wallpaperFileName.setValue(Ext.util.Format.ellipsis(a.data.filename,30,true));this.wallpaperThumbnail.getEl().dom.src=a.data.url;this.wallpaperSelector.hide();this.OnChangeSettings()},RestoreOrigSettings:function(){SYNO.SDS.Desktop.updateBackground(this.origConfig);SYNO.SDS.Desktop.updateTextColor(this.origConfig)},IsFormDirty:function(){return this.getForm().isDirty()},ClearDirty:function(){this.getForm().setValues(this.getForm().getFieldValues())}});Ext.define("SYNO.SS.App.PersonalSettings.Others",{extend:"SYNO.SS.App.PersonalSettings.FormPanel",DEFAULT_APP_LIVE:"SYNO.SS.App.Liveview.Instance",DEFAULT_APP_LIVE_FULLSCREEN:"SYNO.SS.App.Liveview.Instance(fillscreen)",DEFAULT_APP_TIMELINE:"SYNO.SS.App.Timeline.Instance",DEFAULT_APP_EVENT:"SYNO.SS.App.Event.Instance",DEFAULT_APP_CAMERA:"SYNO.SS.App.Camera.Instance",TIME_SOURCE_FROM_CLIENT:0,TIME_SOURCE_FROM_SERVER:1,chkNoLogoutConfirm:null,chkResumeLoginSts:null,chkHelpOnLaunch:null,chkDefApp:null,cmbDefApp:null,cmbTimeSource:null,fldResetDesktop:null,btnResetDesktop:null,constructor:function(){this.InitUI();this.callParent([{hideMode:"offsets",title:_T("watermark","setting"),cls:"options-panel-others",labelWidth:150,items:[this.chkNoLogoutConfirm,this.chkResumeLoginSts,this.chkHelpOnLaunch,this.chkDefApp,this.cmbDefApp,this.cmbTimeSource,this.fldResetDesktop,this.btnResetDesktop]}]);this.InitData()},InitUI:function(){this.chkNoLogoutConfirm=new SYNO.ux.Checkbox({boxLabel:_T("options","disable_logout_confirm"),name:"disableLogoutConfirm"});this.chkResumeLoginSts=new SYNO.ux.Checkbox({boxLabel:_T("options","remember_window_state"),name:"rememberWindowState"});this.chkHelpOnLaunch=new SYNO.ux.Checkbox({boxLabel:_T("helpbrowser","no_auto_show"),name:"helpOnLaunch"});this.chkDefApp=new SYNO.ux.Checkbox({boxLabel:_T("options","enable_default_app"),name:"enableDefApp",listeners:{check:function(d,e){if(true===e){this.cmbDefApp.enable()}else{this.cmbDefApp.disable()}},scope:this}});var a=new Ext.data.ArrayStore({autoDestroy:true,fields:["defAppValue","defAppDisplay"],data:[[this.DEFAULT_APP_LIVE,_T("ss_common","common_liveview")],[this.DEFAULT_APP_LIVE_FULLSCREEN,_T("ss_common","common_liveview")+" - "+_T("ss_client","full_screen")],[this.DEFAULT_APP_TIMELINE,_T("event","event_timeline")],[this.DEFAULT_APP_EVENT,_T("event","recordings")],[this.DEFAULT_APP_CAMERA,_T("camera","ip_camera")]]});this.cmbDefApp=new SYNO.ux.ComboBox({fieldLabel:_T("ss_common","application"),labelWidth:150,indent:1,store:a,valueField:"defAppValue",displayField:"defAppDisplay",disabled:true,name:"defaultApp",listeners:{afterrender:function(){SYNO.SS.Utils.AddTip(this.cmbDefApp.getEl(),_T("options","liveview_fullscreen_hint"),27)},scope:this}});var b=new Ext.data.ArrayStore({autoDestroy:true,fields:["sourceValue","sourceDisplay"],data:[[this.TIME_SOURCE_FROM_CLIENT,_T("ss_common","from_client")],[this.TIME_SOURCE_FROM_SERVER,_T("ss_common","surveillance_server")]]});var c=SYNO.SDS.UserSettings.getProperty("Desktop","displayTimeFromClient");this.cmbTimeSource=new SYNO.ux.ComboBox({fieldLabel:_T("options","display_time_from"),labelWidth:150,indent:0,store:b,value:(true===c)?this.TIME_SOURCE_FROM_CLIENT:this.TIME_SOURCE_FROM_SERVER,valueField:"sourceValue",displayField:"sourceDisplay",disabled:false,name:"timeSource",listeners:{afterrender:function(){SYNO.SS.Utils.AddTip(this.cmbTimeSource.getEl(),_T("options","display_time_from_client_tip"),27);this.OnChangeTimeSource()},select:function(){this.OnChangeTimeSource()},scope:this}});this.fldResetDesktop=new SYNO.ux.DisplayField({labelWidth:480,itemCls:"fld-reset-desktop",fieldLabel:_T("options","reset_desktop_status")});this.btnResetDesktop=new SYNO.ux.Button({text:_T("options","reset_desktop"),handler:this.OnResetDestop,scope:this})},InitData:function(){this.SetFormValues()},SetFormValues:function(){var b=SYNO.SDS.UserSettings.getProperty("Desktop","disableLogoutConfirm");var c=SYNO.SDS.UserSettings.getProperty("Desktop","rememberWindowState");var e=SYNO.SDS.UserSettings.getProperty("Desktop","helpOnLaunch");var a=SYNO.SDS.UserSettings.getProperty("Desktop","enableDefApp");var f=SYNO.SDS.UserSettings.getProperty("Desktop","defaultApp");if((f)&&(f===this.DEFAULT_APP_LIVE)){var d=SYNO.SDS.UserSettings.getProperty("Desktop","defaultAppFullScreen");if(true===d){f=this.DEFAULT_APP_LIVE_FULLSCREEN}}this.getForm().setValues({disableLogoutConfirm:(false!==b),rememberWindowState:(c||false),helpOnLaunch:false===e,enableDefApp:(true===a),defaultApp:(f||this.DEFAULT_APP_LIVE)})},OnSubmit:function(){var f=(this.TIME_SOURCE_FROM_CLIENT===this.cmbTimeSource.getValue());var b=this.chkNoLogoutConfirm.getValue();var c=this.chkResumeLoginSts.getValue();var e=(false===this.chkHelpOnLaunch.getValue());var a=this.chkDefApp.getValue();var g=this.cmbDefApp.getValue();var d=(g===this.DEFAULT_APP_LIVE_FULLSCREEN)?true:false;if(g===this.DEFAULT_APP_LIVE_FULLSCREEN){g=this.DEFAULT_APP_LIVE}if(f!==SYNO.SDS.UserSettings.getProperty("Desktop","displayTimeFromClient")){this.OnSubmitTimeSource()}SYNO.SDS.UserSettings.setProperty("Desktop","displayTimeFromClient",f);SYNO.SDS.UserSettings.setProperty("Desktop","disableLogoutConfirm",b);SYNO.SDS.UserSettings.setProperty("Desktop","rememberWindowState",c);SYNO.SDS.UserSettings.setProperty("Desktop","helpOnLaunch",e);SYNO.SDS.UserSettings.setProperty("Desktop","enableDefApp",a);SYNO.SDS.UserSettings.setProperty("Desktop","defaultApp",g);SYNO.SDS.UserSettings.setProperty("Desktop","defaultAppFullScreen",d);this.findWindow().setStatusOK();this.ClearDirty()},OnResetDestop:function(){var a=function(b){if("yes"===b){this.SetStatusBusy();SYNO.SDS.UserSettings.reset({callback:this.OnResetDestopDone,scope:this})}};this.GetMsgBox().confirm(_T("options","others"),_T("options","reset_desktop_status_warn"),a,this)},OnResetDestopDone:function(a){this.ClearStatusBusy();if(true===a){SYNO.SDS.UserSettings.setProperty("Desktop","displayTimeFromClient",true);SYNO.SDS.UserSettings.setProperty("Desktop","disableLogoutConfirm",true);location.reload(true)}else{this.GetMsgBox().alert(_T("options","others"),_T("ss_common","error_system"))}},OnChangeTimeSource:function(){if(this.TIME_SOURCE_FROM_CLIENT===this.cmbTimeSource.getValue()){Ext.getDom(this.cmbTimeSource.getEl()).parentNode.lastChild.setAttribute("style","visibility: visible")}else{Ext.getDom(this.cmbTimeSource.getEl()).parentNode.lastChild.setAttribute("style","visibility: hidden")}},OnSubmitTimeSource:function(){var a=function(b){if("yes"===b){location.reload(true)}};this.GetMsgBox().confirm(_T("options","others"),_T("options","time_setting_refresh_confirm"),a,this)}});Ext.define("SYNO.SS.App.PersonalSettings.LocalDisplay",{extend:"SYNO.SS.App.PersonalSettings.FormPanel",fldSyncHint:null,chkEnableAutoLogin:null,fldUserName:null,fldPwd:null,panelTestPasswd:null,btnTestPasswd:null,panelTestPasswdLoading:null,panelTestPasswdOK:null,constructor:function(){this.InitUI();this.callParent([{title:_T("options","local_display_setting"),items:new SYNO.ux.FieldSet({title:_T("options","auto_login"),autoHeight:true,collapsible:true,items:[this.fldSyncHint,this.chkEnableAutoLogin,this.fldUserName,this.fldPwd,this.panelTestPasswd]}),trackResetOnLoad:true}]);this.on("afterrender",this.InitData,this)},InitUI:function(){this.fldSyncHint=new SYNO.ux.DisplayField({value:_T("options","sync_sld_auto_login")});this.fldUserName=new SYNO.ux.TextField({name:"userName",fieldLabel:_T("ss_common","common_name"),labelStyle:"padding-left: 31px; padding-right: 0px;",labelWidth:130,width:this.FIELD_WIDTH,invalidText:_T("extlang","fieldblank"),validator:(function(a){return((true===this.chkEnableAutoLogin.getValue())&&(false===Ext.isEmpty(a)))}).createDelegate(this),maxLength:this.DESC_MAX_LENGTH});this.fldPwd=new SYNO.ux.TextField({name:"password",inputType:"password",preventAutoFill:true,labelStyle:"padding-left: 31px; padding-right: 0px;",labelWidth:130,width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","password"),maxLength:USER_PWD_MAX_LENGTH,disabled:false,invalidText:_T("extlang","fieldblank"),validator:(function(a){return((true===this.chkEnableAutoLogin.getValue())&&(false===Ext.isEmpty(a)))}).createDelegate(this),validateOnBlur:true,validationEvent:"blur"});this.chkEnableAutoLogin=new SYNO.ux.Checkbox({boxLabel:_T("options","enable_auto_login"),listeners:{check:function(b,a){this.fldUserName.setDisabled(!a);this.fldUserName.validate();this.fldPwd.setDisabled(!a);this.btnTestPasswd.setDisabled(!a)},scope:this},checked:true,name:"staySignedIn"});this.btnTestPasswd=new SYNO.ux.Button({name:"btnTestPasswd",text:_T("options","test_password"),style:"margin-left: 225px",handler:this.OnTestPassword,scope:this});this.panelTestPasswdLoading=new SYNO.ux.Panel({hidden:true,width:32,style:"margin-left: 10px;",html:String.format('<img width="24" height="24" style="vertical-align:middle;" src="{0}">',_IMG(SYNO.SS.Image.Syncing)),listeners:{show:function(a){this.btnTestPasswd.disable()},hide:function(a){this.btnTestPasswd.enable()},scope:this}});this.panelTestPasswdOK=new SYNO.ux.Panel({hidden:true,width:32,style:"margin-left: 10px;",html:String.format('<img width="24" height="24" style="vertical-align:middle;" src="{0}" ext:qtip="{1}">',_IMG(SYNO.SS.Image.IconIndicatorSuccess),_T("camera","conn_test_ok"))});this.panelTestPasswd=new SYNO.ux.Panel({layout:"table",layoutConfig:{columns:5},defaults:{xtype:"syno_panel"},items:[this.btnTestPasswd,this.panelTestPasswdLoading,this.panelTestPasswdOK]})},InitData:function(){this.SetStatusBusy();this.sendWebAPI({api:"SYNO.SurveillanceStation.LocalDisplay",method:"GetAutoLogin",version:1,callback:function(d,b,c,a){this.ClearStatusBusy();if(d){this.SetFormValues(b)}else{this.GetMsgBox().alert(_T("ss_common","common_options"),_T("ss_common","error_system"),this.close,this)}},scope:this})},SetFormValues:function(a){this.getForm().setValues(a);this.chkEnableAutoLogin.setValue(a.staySignedIn);this.fldUserName.setValue(a.userName);this.fldPwd.setValue(a.password);this.chkEnableAutoLogin.initValue();this.fldUserName.initValue();this.fldPwd.initValue();this.syncSize()},Validate:function(){return((this.fldUserName.validate())&&(this.fldPwd.validate()))},OnSubmit:function(){this.findWindow().setStatusBarBusy({text:_T("ss_common","common_saving")});var a=function(e,c,d,b){this.findWindow().clearStatusBarBusy();if(e){this.GetMsgBox().confirm(_T("options","local_display_setting"),_T("options","suggest_restart_localdisplay"),function(f){if("yes"===f){this.RestartLocalDisplay()}},this);this.SetFormValues(this.getForm().getValues())}else{this.GetMsgBox().alert(_T("camera","conn_test_err_auth"),_T("camera","conn_test_err_auth"))}}.createDelegate(this);this.sendWebAPI({api:"SYNO.SurveillanceStation.LocalDisplay",method:"SetAutoLogin",params:{staySignedIn:this.chkEnableAutoLogin.getValue(),userName:this.fldUserName.getValue(),password:this.fldPwd.getValue()},encryption:["password"],version:1,callback:a})},RestartLocalDisplay:function(){this.sendWebAPI({api:"SYNO.SurveillanceStation.AddOns",method:"Restart",params:{service:SYNO.SS.Service.LOCAL_DISPLAY},version:1,callback:function(d,b,c,a){}})},OnTestPassword:function(){this.panelTestPasswdLoading.show();this.panelTestPasswdOK.hide();var a=this.getForm().getFieldValues();this.sendWebAPI({api:"SYNO.SurveillanceStation.LocalDisplay",version:1,method:"CheckLogin",params:{userName:this.fldUserName.getValue(),password:this.fldPwd.getValue()},encryption:["password"],callback:function(e,c,d,b){if(true===this.isDestroyed){return}if(true===e){this.panelTestPasswdOK.show();this.panelTestPasswdLoading.hide()}else{this.panelTestPasswdLoading.hide();this.GetMsgBox().alert(_T("camera","conn_test_err_auth"),_T("camera","conn_test_err_auth"))}},scope:this})}});Ext.define("SYNO.SS.App.PersonalSettings.Advanced",{extend:"SYNO.SS.App.PersonalSettings.FormPanel",cmbVideoBgColor:null,cmbVideoScale:null,chkPreservePlayRate:null,fldLogoutDisplay:null,chkEnableAutoLogout:null,chkFreshTimer:null,fldIdleDuration:null,chkDispSetting:null,cmbDispSetting:null,chkHideMouse:null,cmbHideMouse:null,constructor:function(){var a,b;this.InitUI();this.callParent([{hideMode:"offsets",title:_T("ss_common","advanced"),cls:"options-panel-advanced",labelWidth:300,items:[new SYNO.ux.FieldSet({title:_T("options","video_settings"),autoHeight:true,collapsible:true,items:[this.cmbVideoBgColor,this.cmbVideoScale,{xtype:"syno_panel",layout:"hbox",style:"margin-bottom: 4px",items:[this.chkDispSetting,this.cmbDispSetting]},{xtype:"syno_panel",layout:"hbox",style:"margin-bottom: 4px",items:[this.chkHideMouse,this.cmbHideMouse]},this.chkPreservePlayRate]}),new SYNO.ux.FieldSet({title:_T("options","auto_logout"),autoHeight:true,collapsible:true,items:[this.fldLogoutDisplay,this.chkEnableAutoLogout,this.fldIdleDuration,this.chkFreshTimer]})]}]);a=SYNO.SDS.UserSettings.getProperty("Desktop","dispSnapshot");this.chkDispSetting.setValue((false===Ext.isDefined(a))?true:a);b=SYNO.SDS.UserSettings.getProperty("Desktop","hideMouse");this.chkHideMouse.setValue((false===Ext.isDefined(b))?true:b)},InitUI:function(){var g=new Ext.data.ArrayStore({autoDestroy:true,fields:["colorValue","colorDisplay"],data:[[COLOR_LIGHT_GRAY,_T("options","color_light_gray")],[COLOR_BLACK,_T("options","color_black")]]});var f=SYNO.SDS.UserSettings.getProperty("Desktop","videoBgColor");this.cmbVideoBgColor=new SYNO.ux.ComboBox({fieldLabel:_T("options","video_background_color"),indent:0,store:g,value:f,valueField:"colorValue",displayField:"colorDisplay",disabled:false,name:"backgroundColor"});var a=new Ext.data.ArrayStore({autoDestroy:true,fields:["blUseFFmpeg","strDisplay"],data:[[false,_T("options","high_performance")],[true,_T("options","high_quality")]]});this.chkDispSetting=new SYNO.SS.Form.Checkbox({name:"dispSnapshot",boxLabel:_T("snapshot","last_duration")+" ("+_T("ss_common","common_second")+")",width:305,handler:function(h,i){this.cmbDispSetting.setDisabled(!i)},scope:this});var d=SYNO.SDS.UserSettings.getProperty("Desktop","dispDuration");this.cmbDispSetting=new SYNO.ux.ComboBox({name:"dispDuration",value:(false===Ext.isDefined(d))?SYNO.SS.App.Snapshot.Def.DispDuration.SHOW_15S:d,valueField:"id",displayField:"name",hideLable:true,disabled:true,mode:"local",boxMaxWidth:this.CMBBOX_WIDTH,store:new Ext.data.ArrayStore({autoDestroy:true,fields:["id","name"],data:[[SYNO.SS.App.Snapshot.Def.DispDuration.SHOW_5S,5],[SYNO.SS.App.Snapshot.Def.DispDuration.SHOW_10S,10],[SYNO.SS.App.Snapshot.Def.DispDuration.SHOW_15S,15],[SYNO.SS.App.Snapshot.Def.DispDuration.SHOW_20S,20],[SYNO.SS.App.Snapshot.Def.DispDuration.ALWAYS_SHOW,_T("action_rule","time_forever")]]})});this.chkHideMouse=new SYNO.SS.Form.Checkbox({name:"hideMouse",boxLabel:_T("options","hide_mouse_and_focus"),width:305,handler:function(h,i){this.cmbHideMouse.setDisabled(!i)},scope:this});var c=SYNO.SDS.UserSettings.getProperty("Desktop","hideMouseDuration");this.cmbHideMouse=new SYNO.ux.ComboBox({name:"hideMouseDuration",value:(false===Ext.isDefined(c))?10:c,valueField:"id",displayField:"id",hideLable:true,disabled:true,mode:"local",boxMaxWidth:this.CMBBOX_WIDTH,store:new Ext.data.ArrayStore({autoDestroy:true,fields:["id"],data:[[10],[30],[60],[180],[300]]})});var b=SYNO.SDS.UserSettings.getProperty("Desktop","useFFmpegScale")||false;this.cmbVideoScale=new SYNO.ux.ComboBox({fieldLabel:_T("options","video_scaling"),indent:0,store:a,value:b,valueField:"blUseFFmpeg",displayField:"strDisplay",disabled:false,name:"videoScale",listeners:{afterrender:function(j,h,i){SYNO.SS.Utils.AddTip(j.getEl(),_T("options","video_scaling_hint"),27)}}});var e=SYNO.SDS.UserSettings.getProperty("Desktop","preservePlayRate");this.chkPreservePlayRate=new SYNO.ux.Checkbox({boxLabel:_T("options","preserve_play_rate"),checked:(false===Ext.isDefined(e))?true:e,name:"preservePlayRate"});this.fldLogoutDisplay=new SYNO.ux.DisplayField({labelWidth:790,value:_T("options","auto_logout_description")});this.chkEnableAutoLogout=new SYNO.ux.Checkbox({boxLabel:_T("options","auto_logout_enable"),listeners:{check:function(j,i){var h=(false===i);this.fldIdleDuration.setDisabled(!i);this.chkFreshTimer.setDisabled(!i)},scope:this}});this.fldIdleDuration=new SYNO.ux.NumberField({fieldLabel:_T("options","auto_logout_idle_duration")+" ("+_T("ss_common","common_minute")+")",indent:1,value:10,disabled:true,maxValue:65535,minValue:1});this.chkFreshTimer=new SYNO.ux.Checkbox({boxLabel:_T("options","auto_logout_avoid_video_playing"),indent:1,disabled:true});this.SetAutoLogoutFormValues()},SetAutoLogoutFormValues:function(){var b=SYNO.SDS.UserSettings.getProperty("Desktop","autoLogoutEnable");var a=SYNO.SDS.UserSettings.getProperty("Desktop","autoLogoutIdleDuration");var c=SYNO.SDS.UserSettings.getProperty("Desktop","autoLogoutRefreshTimer");this.chkEnableAutoLogout.setValue(true===b);this.chkFreshTimer.setValue(true===c);if(true===Ext.isDefined(a)){this.fldIdleDuration.setValue(a)}},IsFormDirty:function(){return this.getForm().isDirty()},OnSubmit:function(){if(false===this.getForm().isValid()){this.findWindow().setStatusError({text:_T("ss_common","forminvalid"),clear:true});return}var d=this.cmbVideoBgColor.getValue();var m=this.cmbVideoScale.getValue();var f=this.chkPreservePlayRate.getValue();var l=SYNO.SDS.UserSettings.getProperty("Desktop","useFFmpegScale")||false;var e=SYNO.SDS.UserSettings.getProperty("Desktop","preservePlayRate");var h=this.chkEnableAutoLogout.getValue();var g=this.chkFreshTimer.getValue();var j=this.fldIdleDuration.getValue();var c=this.chkDispSetting.getValue();var i=this.cmbDispSetting.getValue();var b=this.chkHideMouse.getValue();var k=this.cmbHideMouse.getValue();var a=false;if(d!==SYNO.SDS.UserSettings.getProperty("Desktop","videoBgColor")){SYNO.SDS.UserSettings.setProperty("Desktop","videoBgColor",d);SYNO.SDS.StatusNotifier.fireEvent("updateVideoBgColor")}if(m!==l){SYNO.SDS.UserSettings.setProperty("Desktop","useFFmpegScale",m);SYNO.SDS.StatusNotifier.fireEvent("updateVideoScaleMethod")}if(c!==SYNO.SDS.UserSettings.getProperty("Desktop","dispSnapshot")){SYNO.SDS.UserSettings.setProperty("Desktop","dispSnapshot",c);a=true}if(i!==SYNO.SDS.UserSettings.getProperty("Desktop","dispDuration")){SYNO.SDS.UserSettings.setProperty("Desktop","dispDuration",i);a=true}if(b!==SYNO.SDS.UserSettings.getProperty("Desktop","hideMouse")){SYNO.SDS.UserSettings.setProperty("Desktop","hideMouse",b)}if(k!==SYNO.SDS.UserSettings.getProperty("Desktop","hideMouseDuration")){SYNO.SDS.UserSettings.setProperty("Desktop","hideMouseDuration",k)}if(true===a){SYNO.SS.App.Snapshot.Utils.UpdateSnapshotSetting();SYNO.SDS.StatusNotifier.fireEvent("snapshotUpdateSetting")}if(f!==e){SYNO.SDS.UserSettings.setProperty("Desktop","preservePlayRate",f);SYNO.SDS.StatusNotifier.fireEvent("updatePreservePlayRate")}if(h!==SYNO.SDS.UserSettings.getProperty("Desktop","autoLogoutEnable")){SYNO.SDS.UserSettings.setProperty("Desktop","autoLogoutEnable",h)}if(g!==SYNO.SDS.UserSettings.getProperty("Desktop","autoLogoutRefreshTimer")){SYNO.SDS.UserSettings.setProperty("Desktop","autoLogoutRefreshTimer",g)}if(j!==SYNO.SDS.UserSettings.getProperty("Desktop","autoLogoutIdleDuration")){SYNO.SDS.UserSettings.setProperty("Desktop","autoLogoutIdleDuration",j)}SYNO.SDS.UserSettings.save();SYNO.SS.Utils.RestartAutoLogout();this.findWindow().setStatusOK();this.ClearDirty()}});Ext.namespace("SYNO.SS.App.Personal");Ext.define("SYNO.SS.App.PersonalSettings.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SS.App.PersonalSettings.MainWindow"});Ext.define("SYNO.SS.App.PersonalSettings.MainWindow",{extend:"SYNO.SDS.TabPanelAppWindow",tabIndex:null,WIN_WIDTH:850,WIN_HEIGHT:500,blForceClose:false,btnOK:null,btnCancel:null,blOpenSldSetting:false,constructor:function(a){this.blOpenSldSetting=(null!==_S("DS_MODEL_NAME").toUpperCase().match(NVR_MODEL_NAME_PREFIX))&&(SYNO.SS.UserPrivType.ADMIN===_S("USER_PRIVILEGE"));this.InitUI();this.tabIndex={};this.tabIndex.NONE=-1;this.tabIndex.ACCOUNT=0;this.tabIndex.DESKTOP=1;this.tabIndex.OTHERS=2;this.SS_WEBAPI_ERR_LOGIN_PASSWORD_WEAK_DSM=3123;if(true===this.blOpenSldSetting){this.tabIndex.LD_SETTING=3;this.tabIndex.ADVANCED=4}else{this.tabIndex.LD_SETTING=-2;this.tabIndex.ADVANCED=3}this.callParent([Ext.apply({cls:"ss-personal-setting-window",title:_T("ss_common","user_setting"),resizable:false,maximizable:false,width:this.WIN_WIDTH,height:this.WIN_HEIGHT,layout:"fit",tabIndex:this.tabIndex,panelList:this.getTabList(),buttons:[this.btnSave,this.btnClose]},a)])},InitUI:function(){this.panelAccount=this.CreateTabItemForGblSearch("SYNO.SS.App.PersonalSettings.Account",[this]);this.panelDesktop=this.CreateTabItemForGblSearch("SYNO.SS.App.PersonalSettings.Desktop",[{module:this,baseURL:this.jsConfig.jsBaseURL}]);this.panelOthers=this.CreateTabItemForGblSearch("SYNO.SS.App.PersonalSettings.Others",[this]);if((true===this.blOpenSldSetting)){this.panelLocalDisplay=this.CreateTabItemForGblSearch("SYNO.SS.App.PersonalSettings.LocalDisplay",[this])}this.panelAdvanced=this.CreateTabItemForGblSearch("SYNO.SS.App.PersonalSettings.Advanced",[this]);this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),btnStyle:"blue",handler:this.OnCheckPassword,scope:this});this.btnClose=new SYNO.ux.Button({text:_T("ss_common","close"),scope:this,handler:this.close})},getTabList:function(){var a=[];a.push(this.panelAccount);a.push(this.panelDesktop);a.push(this.panelOthers);if(true===this.blOpenSldSetting){a.push(this.panelLocalDisplay)}a.push(this.panelAdvanced);return a},onOpen:function(a){this.callParent(arguments)},onClose:function(){if((true===this.blForceClose)||(false===this.IsDirty())){this.blForceClose=false;return true}SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){if(this.panelDesktop.IsFormDirty()){this.panelDesktop.RestoreOrigSettings()}this.blForceClose=true;this.close()},scope:this});return false},IsDirty:function(){return((true===this.panelAccount.IsFormDirty())||(true===this.panelDesktop.IsFormDirty())||((true===this.blOpenSldSetting)&&(true===this.panelLocalDisplay.IsFormDirty()))||(true===this.panelOthers.IsFormDirty())||(true===this.panelAdvanced.IsFormDirty()))},OnCheckPassword:function(){if(false===this.IsDirty()){this.setStatusError({text:_T("ss_common","setting_nochange"),clear:true});return}if(false===this.panelAccount.IsFormDirty()){this.OnSave();return}this.setStatusBarBusy({text:_T("ss_common","common_saving")});var a={name:this.panelAccount.fldUserName.getValue(),description:this.panelAccount.fldUserDesc.getValue(),password:this.panelAccount.fldPwd.getValue()};this.sendWebAPI({api:"SYNO.Core.User.PasswordPolicy",method:"check",params:a,encryption:["password"],version:1,callback:function(e,c,d,b){this.clearStatusBarBusy();if(e){this.OnSave()}else{if(this.SS_WEBAPI_ERR_LOGIN_PASSWORD_WEAK_DSM===c.code){this.getMsgBox().alert(_T("ss_common","common_edit"),_T("login","error_pwd_weak"))}else{this.getMsgBox().alert(_T("ss_common","common_options"),_T("ss_common","error_bad_field"))}}}})},OnSave:function(){if(true===this.panelOthers.IsFormDirty()){this.panelOthers.OnSubmit()}if((true===this.blOpenSldSetting)&&(true===this.panelLocalDisplay.IsFormDirty())){if(true===this.panelLocalDisplay.Validate()){this.panelLocalDisplay.OnSubmit()}else{this.tabPanel.setActiveTab(this.panelLocalDisplay);this.setStatusError({text:_T("ss_common","forminvalid"),clear:true})}}if(true===this.panelAdvanced.IsFormDirty()){this.panelAdvanced.OnSubmit()}if(false===this.panelDesktop.ApplyForm()){this.tabPanel.setActiveTab(this.panelDesktop);this.setStatusError({text:_T("ss_common","forminvalid"),clear:true});return}if(true===this.panelAccount.IsFormDirty()){if(true===this.panelAccount.Validate()){this.panelAccount.OnSubmit()}else{this.tabPanel.setActiveTab(this.panelAccount);this.setStatusError({text:_T("ss_common","forminvalid"),clear:true})}}},getHelpParam:function(){var a;switch(this.GetCurrentTabIndex()){case this.tabIndex.ACCOUNT:a="options_account.html";break;case this.tabIndex.DESKTOP:a="options_desktop.html";break;case this.tabIndex.OTHERS:a="options_others.html";break;case this.tabIndex.ADVANCED:a="options_advanced.html";break;case this.tabIndex.LD_SETTING:a="options_local_display.html";break;default:a="options.html"}return a}});