/* Copyright (c) 2019 Synology Inc. All rights reserved. */

Ext.namespace("SYNO.SS.App.TimeLapse.Recording");Ext.define("SYNO.SS.App.TimeLapse.Recording.ExpandableListView",{extend:"SYNO.ux.ExpandableListView",owner:null,selections:[],constructor:function(a){this.owner=a.owner;var b=Ext.apply({iconTpl:new Ext.XTemplate("{archived:this.RenderPreview}"),titleTpl:new Ext.XTemplate('{camera_name:this.RenderCamName}<span class="title-status">{archived:this.RenderStatus}</span>'),titleRightTpl:new Ext.XTemplate("{event_size_bytes:this.RenderDurationAndSize}"),descTpl:new Ext.XTemplate("{startTime:this.RenderDateTime}"),descRightTpl:new Ext.XTemplate("{rangeMinute:this.RenderRange}")},a);this.callParent([b]);this.AddTplRenderer()},AddTplRenderer:function(){this.tpl.owner=this.owner;this.tpl.RenderPreview=function(e,b){var d=SYNO.SS.MultiView.LIST_VIEW_IDX;var c=b.snapshot_medium?"data:image/jpeg;base64,"+b.snapshot_medium:SYNO.SS.CameraPage.IMG_DISABLED[d];var a=String.format('<img src="{0}" class="evt_list_snapshot" onerror="this.src=SYNO.SS.CameraPage.IMG_DISABLED[{1}];">',c,d);return'<div class="event_list_preview_ct">'+a+"</div>"};this.tpl.RenderCamName=function(c,a){var b=c;if(true===a.deleted){b+=" ("+_T("camera","camera_deleted")+")"}return String.format('<span ext:qtip="{0}">{0}</span>',b)};this.tpl.RenderStatus=function(b,a){var c=SYNO.SS.App.TimeLapse.Utils.GetEventStatusInfo(a);var d="";if(c.statusTip){d=String.format("&nbsp;-&nbsp;{0}",c.statusTip)}return String.format("<span>{0}</span>",d)};this.tpl.RenderDateTime=function(b,a){return SYNO.SS.Grid.GenDateAndTimeStr(b,a)};this.tpl.GetEvtSize=function(a){if(1024>=a){return Math.round(a)+" MB"}else{return(a/1024).toFixed(2)+" GB"}};this.tpl.RenderDurationAndSize=function(e,c){var b=GetTimeStr(c.stopTime-c.startTime);var d=this.GetEvtSize(e/(1<<20));var a=String.format("{0} ({1})",b,d);return this.GetSpanWithStatusColor(a,c)};this.tpl.GetSpanWithStatusColor=function(b,a){return String.format("<span>{0}</span>",b)};this.tpl.RenderRange=function(d,a){var c=_T("time_lapse","range")+": ";var b;if(SYNO.SS.App.TimeLapse.Def.MINUTE_PER_DAY<=d){b=(d/SYNO.SS.App.TimeLapse.Def.MINUTE_PER_DAY).toFixed(1)+" "+_T("ss_common","time_days")}else{if(0===d){d=1}b=(Math.ceil(d/6)*0.1).toFixed(1)+" "+_T("ss_common","time_hours")}return c+b}}});Ext.define("SYNO.SS.App.TimeLapse.Recording.Filter",{extend:"SYNO.SS.Form.FilterPanel",parentWin:null,dsTaskList:null,cmbboxTask:null,chkboxLock:null,cmbboxLock:null,chkTimeFrom:null,dateFrom:null,timeFrom:null,chkTimeTo:null,dateTo:null,timeTo:null,constructor:function(d){this.parentWin=d;this.Init();var c={xtype:"label",text:_T("ss_centralized","source")};var b={cls:"filter-panel-lhs",defaults:{cls:"filter-setting-group"},items:[{items:[c,this.cmbboxTask]},{items:[this.chkboxLock,this.cmbboxLock]},{items:[this.chkTimeFrom,{cls:"filter-date-and-time",layout:"hbox",items:[this.dateFrom,this.timeFrom]}]},{items:[this.chkTimeTo,{cls:"filter-date-and-time",layout:"hbox",items:[this.dateTo,this.timeTo]}]}]};var a={layout:"column",items:[b],blOneColumn:true,okHandler:this.OnOK,cancelHandler:this.OnCancel,btnHandlerScope:this};this.callParent([a]);this.mon(this,"show",this.OnShow,this)},OnShow:function(){this.InitStore()},Init:function(){this.InitStore();this.cmbboxTask=new SYNO.ux.ComboBox({blInFilterPanel:true,store:this.dsTaskList,valueField:"id",displayField:"name",value:-1,tpl:new Ext.XTemplate('<div style="background-color: #F0F5FA;"><tpl for="."><tpl if="xindex == 2"><span class="x-menu-sep" id='+Ext.id()+'></span></tpl><div ext:qtip="{name}" class="x-combo-list-item">{name}</div></tpl></div>')});this.chkboxLock=new SYNO.ux.Checkbox({boxLabel:_T("event","event_col_archive"),hideLabel:true,listeners:{check:function(d,c){if(c){this.cmbboxLock.enable()}else{this.cmbboxLock.disable()}},scope:this}});var b=[[SYNO.SS.App.Event.Def.FILE_LOCK,_T("event","archive_yes")],[SYNO.SS.App.Event.Def.FILE_NONLOCK,_T("event","archive_no")]];var a=new Ext.data.SimpleStore({autoDestroy:true,data:b,fields:[{name:"id"},{name:"lock"}]});this.cmbboxLock=new SYNO.ux.ComboBox({blInFilterPanel:true,hideLabel:true,store:a,valueField:"id",displayField:"lock",value:SYNO.SS.App.Event.Def.FILE_LOCK,mode:"local",editable:false,forceSelection:true,triggerAction:"all",disabled:true});this.chkTimeFrom=new SYNO.ux.Checkbox({boxLabel:_T("event","event_time_from"),hideLabel:true,listeners:{check:function(d,c){if(c){this.dateFrom.enable();this.timeFrom.enable()}else{this.dateFrom.disable();this.timeFrom.disable()}this.SetProperDateTo(this.dateFrom,this.dateFrom.getValue())},scope:this}});this.dateFrom=new SYNO.ux.DateField({emptyText:"Select date",blInFilterPanel:true,hideLabel:true,disabled:true,editable:false,format:"Y/m/d",value:new Date(),menu:new Ext.menu.DateMenu({hideOnClick:false,focusOnSelect:false,allowOtherMenus:true}),listeners:{select:this.SetProperDateTo,scope:this}});this.timeFrom=new SYNO.ux.TimeField({blInFilterPanel:true,hideLabel:true,emptyText:"Select time",format:"H:i",disabled:true,editable:false,value:"00:00",listeners:{select:this.SetProperTimeTo,scope:this}});this.chkTimeTo=new SYNO.ux.Checkbox({boxLabel:_T("event","event_time_to"),hideLabel:true,listeners:{check:function(d,c){if(c){this.dateTo.enable();this.timeTo.enable()}else{this.dateTo.disable();this.timeTo.disable()}this.SetProperDateFrom(this.dateTo,this.dateTo.getValue())},scope:this}});this.dateTo=new SYNO.ux.DateField({emptyText:"Select date",blInFilterPanel:true,hideLabel:true,disabled:true,editable:false,format:"Y/m/d",value:new Date(new Date().getTime()+DAY_MILLISECOND),menu:new Ext.menu.DateMenu({hideOnClick:false,focusOnSelect:false,allowOtherMenus:true}),listeners:{select:this.SetProperDateFrom,scope:this}});this.timeTo=new SYNO.ux.TimeField({name:"timeTo",blInFilterPanel:true,hideLabel:true,emptyText:"Select time",format:"H:i",disabled:true,editable:false,value:"00:00"})},InitStore:function(){this.parentWin.dsTask.clearFilter();this.dsTaskList=SYNO.SS.Utils.StoreCopy(this.parentWin.dsTask);this.dsTaskList.insert(0,new Ext.data.Record({id:SYNO.SS.App.TimeLapse.Def.ALL_TASK_ID,name:_T("time_lapse","task_all")}));if(this.cmbboxTask){this.cmbboxTask.bindStore(this.dsTaskList)}},ResetElements:function(){if(false===this.rendered){return}var b,d;var a=this.parentWin.filterSetting;if(true===this.parentWin.blOnFilter){this.cmbboxTask.setValue(this.curTask)}else{this.cmbboxTask.setValue(SYNO.SS.App.TimeLapse.Def.ALL_TASK_ID)}this.chkboxLock.setValue(a.chkLock);if(true===a.chkLock){this.cmbboxLock.setValue(a.Locked)}else{this.cmbboxLock.reset()}b=new Date();d=new Date(b.getTime()+DAY_MILLISECOND);this.dateFrom.setValue(b);this.dateFrom.clearInvalid();this.timeFrom.reset();this.dateTo.setValue(d);this.dateTo.clearInvalid();this.timeTo.reset();var c,e="",f="";this.chkTimeFrom.setValue(a.chkTimeFrom);if(true===a.chkTimeFrom){c=new Date(a.timestampClientDateFrom*TRANS_MILLISECOND);e=c.format("Y/m/d");f=c.format("H:i");this.dateFrom.setValue(e);this.timeFrom.setValue(f);this.SetProperDateTo(this.dateFrom,c)}this.chkTimeTo.setValue(a.chkTimeTo);if(true===a.chkTimeTo){c=new Date(a.timestampClientDateTo*TRANS_MILLISECOND);e=c.format("Y/m/d");f=c.format("H:i");this.dateTo.setValue(e);this.timeTo.setValue(f);this.SetProperDateFrom(this.dateTo,c)}},SetProperDateTo:function(c,b){if(true===c.disabled){this.dateTo.setMinValue(null)}else{this.dateTo.setMinValue(b)}var a=new Date();if(b.getTime()>this.dateTo.getValue().getTime()){a.setTime(b.getTime()+DAY_MILLISECOND);this.dateTo.setValue(a)}this.SetProperTimeTo()},SetProperDateFrom:function(c,b){if(true===c.disabled){this.dateFrom.setMaxValue(null)}else{this.dateFrom.setMaxValue(b)}var a=new Date();if(b.getTime()<this.dateFrom.getValue().getTime()){a.setTime(b.getTime()-DAY_MILLISECOND);this.dateFrom.setValue(a)}this.SetProperTimeTo()},SetProperTimeTo:function(){var b=Date.parseDate(this.timeFrom.getValue(),"H:i");var a;if(this.dateFrom.getValue().getTime()===this.dateTo.getValue().getTime()){a=(true===this.dateFrom.disabled)?"00:00":this.timeFrom.getValue();this.timeTo.setMinValue(a);if(Date.parseDate(this.timeFrom.getValue(),"H:i").getTime()>Date.parseDate(this.timeTo.getValue(),"H:i").getTime()){if(b.getHours()==23){this.timeTo.setValue("23:45")}else{this.timeTo.setValue((b.getHours()+1)+":"+((b.getMinutes()==0)?"00":b.getMinutes()))}}}else{this.timeTo.setMinValue("00:00")}},DateToTimestamp:function(d,e){var c=d.format("Y/m/d")+" "+e+":00";var b=new Date(c);var a=ConvertTimestamp((b.getTime()/TRANS_MILLISECOND),false);return{convertedTimestamp:a,cmbTimestamp:(b.getTime()/TRANS_MILLISECOND)}},OnOK:function(){var b=this.parentWin.filterSetting;var d;this.curTask=this.cmbboxTask.getValue();b.curTask=this.curTask;b.chkLock=this.chkboxLock.getValue();if(true===b.chkLock){b.Locked=this.cmbboxLock.getValue()}else{b.Locked=0}var c=null,f="",e;b.chkTimeFrom=this.chkTimeFrom.getValue();if(true===b.chkTimeFrom){c=this.dateFrom.getValue();f=this.timeFrom.getValue();e=this.DateToTimestamp(c,f);b.timestampFrom=e.convertedTimestamp;b.timestampClientDateFrom=e.cmbTimestamp}else{b.timestampFrom=0;b.timestampClientDateFrom=0}c=null;f="";b.chkTimeTo=this.chkTimeTo.getValue();if(true===b.chkTimeTo){c=this.dateTo.getValue();f=this.timeTo.getValue();e=this.DateToTimestamp(c,f);b.timestampTo=e.convertedTimestamp;b.timestampClientDateTo=e.cmbTimestamp}else{b.timestampTo=0;b.timestampClientDateTo=0}var a=((SYNO.SS.App.TimeLapse.Def.ALL_TASK_ID!==b.curTask)||(b.chkLock)||(b.chkTimeFrom)||(b.chkTimeTo));if(true===a){this.parentWin.ShowFilterPanel(true);this.parentWin.Filter()}else{this.parentWin.OnFilterCancel()}this.HideBox()},OnCancel:function(){this.HideBox()}});Ext.define("SYNO.SS.App.TimeLapse.RecordingListPanel",{extend:"SYNO.ux.Panel",LOG_ROW_PER_PAGE:50,owner:null,dsRecList:null,dsTask:null,gridRecList:null,panelGridContainer:null,dsCateg:null,gridCateg:null,btnSwitchCateg:null,panelCategContainer:null,filterSetting:null,btnPlay:null,btnDownload:null,btnDelete:null,menuItemLock:null,menuItemLockFilter:null,menuLock:null,menuItemUnLock:null,menuItemUnLockFilter:null,menuUnLock:null,btnLock:null,panelFilter:null,panelFilterInfo:null,panelEvtList:null,expandablePanel:null,blActivated:false,blOnFilter:false,blStoreLoadDone:false,constructor:function(a){this.owner=a.owner;this.dsTask=a.dsTask;this.Init();this.callParent([Ext.apply(a,{title:_T("event","recordings"),tbar:new SYNO.ux.Toolbar([this.btnPlay,this.btnDownload,this.btnDelete,this.btnLock,{xtype:"tbfill"},this.btnSwitchCateg,this.btnFilter]),items:[this.panelFilterInfo,this.panelCategContainer],listeners:{activate:this.Activate,resize:this.Resize,beforeshow:this.OnRefresh}})]);this.mon(SYNO.SDS.StatusNotifier,"timeLapseRecordingUpdate",this.OnWebSocketCallback,this)},Init:function(){this.InitFilterSettings();this.InitButtons();this.dsRecList=new SYNO.API.JsonStore({autoDestroy:true,appWindow:this,api:"SYNO.SurveillanceStation.TimeLapse.Recording",method:"List",version:1,baseParams:{lapseId:0,fromTime:0,toTime:0,locked:0,recording:0,blIncludeSnapshot:true},root:"events",totalProperty:"total",idProperty:"id",fields:SYNO.SS.App.TimeLapse.Def.lapseRecordingFields,listeners:{beforeload:function(c,d){var b=(false!==d.params.needMask);if(true===b){this.owner.setStatusBusy()}},load:this.OnDsLoad,scope:this}});this.dsCateg=new Ext.data.JsonStore({fields:["id","category","entryName","entryVal","recCnt","type"]});var a=[SYNO.SS.Grid.Categ.CATEG_TIME_LAPSE_REC_TASK];this.gridCateg=new SYNO.SS.Grid.CategoryGridPanel({enableDragDrop:false,category:a,firstCateg:a,fnShowFirstCateg:function(){return true},store:this.dsCateg,delegate:this});this.gridRecList=new SYNO.SS.App.TimeLapse.Recording.ExpandableListView({owner:this,store:this.dsRecList,toggleOnDblClick:false,playIconOnPreview:true,listeners:{selectionchange:this.ChgButtonStatus,contextmenu:this.OnContextMenu,dblclick:this.OnEventPlay,scope:this},fnPlay:this.OnEventPlay.createDelegate(this)});this.expandablePanel=new SYNO.SS.ViewPanel({view:this.gridRecList,plugins:SYNO.SS.Pgls.CreatePglsPlugin({ptype:"synoSSPglsCategPlugin",store:this.dsRecList,gridCateg:this.gridCateg,pageSize:SYNO.SS.Pgls.MIN_PAGE_RECORDS,preloadSize:this.LOG_ROW_PER_PAGE,divLoadingHeight:34,blPreloadAll:false,GetParams:this.GetFilterParams.createDelegate(this)})});this.panelEvtList=new SYNO.ux.Panel({region:"center",layout:"fit",deferredRender:false,border:false,items:[this.expandablePanel],bbar:new SYNO.SS.Pgls.BottomBar({panelRecord:this.gridRecList,refreshFunction:this.OnRefresh,refreshFunctionScope:this})});this.btnSwitchCateg=this.gridCateg.btnSwitch;this.panelCategContainer=new SYNO.SS.Pgls.PglsCategContainerPanel({items:[this.gridCateg,this.panelEvtList],gridCateg:this.gridCateg,panelRecord:this.expandablePanel,labelItemCnt:this.panelEvtList.getBottomToolbar().labelItemCnt,dsRecord:this.dsRecList,countMethod:"CountByCategory",countParams:{limit:0,needMask:false},GetCountParams:this.GetCountParams.createDelegate(this),GetParams:this.GetFilterParams.createDelegate(this),emptyStyleMonStore:this.dsRecList,emptyStyleTip:_T("time_lapse","no_event_tip"),fnNeedApplyEmptyStyle:this.HasNoRecord.createDelegate(this),plugins:SYNO.SS.AutoUpdate.CreatePluginWithDsId("dsId","",{blUpdAllDs:false,blFromWebsocket:(LOCAL_DS_ID===this.owner.appDSId),stableFieldList:["snapshot_medium"],GetRecCntParamMethod:this.GetCntParam,CheckRecIsAddedMethod:this.IsRecordAdded,CheckRecIsDeletedMethod:this.IsRecordDeleted,fnRefresh:this.OnRefresh.createDelegate(this),fnCompare:function(d,c){var e=-(d.data.startTime-c.data.startTime);if(0===e){if(d.id>c.id){e=-1}else{if(d.id<c.id){e=1}}}return e}})})},InitFilterSettings:function(){this.filterSetting={};this.ResetFilterSetting()},InitButtons:function(){this.btnPlay=new SYNO.ux.Button({text:_T("event","event_play"),cls:"btn_filter_tbar",handler:this.OnEventPlay,disabled:true,scope:this});this.btnDownload=new SYNO.ux.Button({text:_T("event","event_export"),cls:"btn_filter_tbar",handler:this.OnEventDownload,disabled:true,scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),cls:"btn_filter_tbar",disabled:true,menu:{items:[{itemId:"menuDelSelected",text:_T("event","delete_selected"),handler:this.DeletePreProcess,scope:this},{itemId:"menuDelCateg",text:_T("event","delete_category"),handler:this.DeleteFilterPreProcess,scope:this},{itemId:"menuDelAll",text:_T("ss_common","common_delete_all"),handler:this.DeleteAllPreProcess,scope:this}],listeners:{beforeshow:function(d){var c,b,a;c=((true===this.blOnFilter)&&(true!==this.blHideFilterInfo))?_T("event","delete_filtered_category"):_T("event","delete_category");b=d.items.itemAt(1);b.setText(c);a=(true===this.gridCateg.IsCurCategEntryAll());b.setDisabled(a);this.UpdateDelAllVisibility()},scope:this}},CheckAvailItems:function(){var a=0;this.menu.items.each(function(b){if((false===b.hidden)&&(false===b.disabled)){a++}});return a},GetMenuItem:function(a){if(!this.menu){return null}return this.menu.getComponent(a)}});this.menuItemLock=new Ext.menu.Item({text:_T("event","archive_lock_selected"),cls:"btn_filter_tbar",handler:this.OnEventLock.createDelegate(this,[true]),disabled:true});this.menuItemLockFilter=new Ext.menu.Item({text:_T("event","archive_lock_category"),cls:"btn_filter_tbar",handler:this.OnEventLockFiltered.createDelegate(this,[true]),disabled:true});this.menuLock=new Ext.menu.Item({text:_T("event","event_archive"),hideOnClick:false,menu:new SYNO.ux.Menu({items:[this.menuItemLock,this.menuItemLockFilter],listeners:{beforeshow:function(c){var b,a;b=((true===this.blOnFilter)&&(true!==this.blHideFilterInfo))?_T("event","archive_lock_filtered_category"):_T("event","archive_lock_category");a=c.items.itemAt(1);a.setText(b)},scope:this}}),disabled:true,scope:this});this.menuItemUnLock=new Ext.menu.Item({text:_T("event","archive_unlock_selected"),cls:"btn_filter_tbar",handler:this.OnEventLock.createDelegate(this,[false]),disabled:true});this.menuItemUnLockFilter=new Ext.menu.Item({text:_T("event","archive_unlock_category"),cls:"btn_filter_tbar",handler:this.OnEventLockFiltered.createDelegate(this,[false]),disabled:true});this.menuUnLock=new Ext.menu.Item({text:_T("event","event_unarchive"),hideOnClick:false,menu:new SYNO.ux.Menu({items:[this.menuItemUnLock,this.menuItemUnLockFilter],listeners:{beforeshow:function(c){var b,a;b=((true===this.blOnFilter)&&(true!==this.blHideFilterInfo))?_T("event","archive_unlock_filtered_category"):_T("event","archive_unlock_category");a=c.items.itemAt(1);a.setText(b)},scope:this}}),disabled:true,scope:this});this.btnLock=new SYNO.ux.Button({text:_T("ss_common","common_lock"),menu:{items:[this.menuLock,this.menuUnLock]}});this.panelFilter=new SYNO.SS.App.TimeLapse.Recording.Filter(this);this.btnFilter=new SYNO.SS.Form.FilterButton({iconCls:"icon_search",text:_T("ss_common","common_search"),tooltip:_T("ss_common","common_search"),panelFilterForm:this.panelFilter});this.panelFilter.SetToggleBtn(this.btnFilter);this.panelFilterInfo=new SYNO.ux.FilterInfo({fnCancel:this.OnFilterCancel,fnCancelScope:this,fnReload:this.panelFilter.OnOK,fnReloadScope:this.panelFilter})},Filter:function(){this.SetBaseParamFromFilterSetting();this.gridCateg.ScrollToTop();this.gridCateg.selModel.clearSelections();this.OnRefresh()},SetBaseParamFromFilterSetting:function(){this.dsRecList.setBaseParam("lapseId",this.filterSetting.curTask);this.dsRecList.setBaseParam("locked",this.filterSetting.Locked);this.dsRecList.setBaseParam("fromTime",this.filterSetting.timestampFrom);this.dsRecList.setBaseParam("toTime",this.filterSetting.timestampTo)},GetFilterParams:function(){var b=Ext.apply({},this.dsRecList.baseParams);var a=this.gridCateg.curEntry;b.from_start=this.filterSetting.timestampFrom;b.from_end=this.filterSetting.timestampTo;if((SYNO.SS.Grid.Categ.ENTRY_TIME_LAPSE_REC_TASK===a.type)&&(SYNO.SS.App.TimeLapse.Def.ALL_TASK_ID!==a.entryVal)){b.lapseId=a.entryVal}return b},OnFilterCancel:function(){this.ResetFilter();this.ChgButtonStatus()},ResetFilter:function(){this.ShowFilterPanel(false);this.ResetFilterSetting();this.panelFilter.ResetElements();this.Filter()},ShowFilterPanel:function(a){this.blOnFilter=a},ResetFilterSetting:function(){this.filterSetting.curTask=SYNO.SS.App.TimeLapse.Def.ALL_TASK_ID;this.filterSetting.chkLock=false;this.filterSetting.chkTimeTo=false;this.filterSetting.chkTimeFrom=false;this.filterSetting.Locked=0;this.filterSetting.timestampFrom=0;this.filterSetting.timestampTo=0;this.filterSetting.timestampClientFrom=0;this.filterSetting.timestampClientTo=0},SetFilterInfoText:function(){if(false===this.blOnFilter){return}var d={recCnt:this.gridCateg.GetTotalCount(),conditions:[]};if(SYNO.SS.App.TimeLapse.Def.ALL_TASK_ID!==this.filterSetting.curTask){var b=this.dsTask.getById(this.filterSetting.curTask);var a=(true===Ext.isDefined(b))?b.get("name"):_T("ss_common","status_unknown");d.conditions.push({header:_T("edge_storage","task"),text:a,fnCancel:function(){this.cmbboxTask.setValue(SYNO.SS.App.TimeLapse.Def.ALL_TASK_ID)},scope:this.panelFilter})}if(true===this.filterSetting.chkLock){d.conditions.push({header:_T("event","event_col_archive"),text:(SYNO.SS.App.Event.Def.FILE_LOCK===this.filterSetting.Locked)?_T("event","archive_yes"):_T("event","archive_no"),fnCancel:function(){this.chkboxLock.setValue(false)},scope:this.panelFilter})}if(true===this.filterSetting.chkTimeFrom){var c=new Date(this.filterSetting.timestampClientDateFrom*TRANS_MILLISECOND);d.conditions.push({header:_T("event","event_time_from"),text:c.format("Y/m/d")+" "+c.format("H:i"),fnCancel:function(){this.chkTimeFrom.setValue(false);this.dateFrom.setValue(new Date());if(true===this.parentWin.filterSetting.chkTimeTo){this.SetProperDateFrom(this.dateTo,this.dateTo.getValue())}else{this.dateTo.setValue(new Date())}},scope:this.panelFilter})}if(true===this.filterSetting.chkTimeTo){var e=new Date(this.filterSetting.timestampClientDateTo*TRANS_MILLISECOND);d.conditions.push({header:_T("event","event_time_to"),text:e.format("Y/m/d")+" "+e.format("H:i"),fnCancel:function(){this.chkTimeTo.setValue(false);this.dateTo.setValue(new Date());if(true===this.parentWin.filterSetting.chkTimeFrom){this.SetProperDateTo(this.dateFrom,this.dateFrom.getValue())}else{this.dateFrom.setValue(new Date())}},scope:this.panelFilter})}this.panelFilterInfo.SetInfo(d)},GetCountParams:function(){return Ext.apply({blTotalCntOnly:false},this.panelCategContainer.countParams,this.dsRecList.baseParams)},Activate:function(){if(false===this.blActivated){this.OnFilterCancel();this.blActivated=true}},Resize:function(){var c=this.getInnerWidth();var a=this.getInnerHeight();var b;if(true===this.blOnFilter){this.panelFilterInfo.setVisible(true);b=SYNO.SS.Ui.Height.FILTER_PANEL_DEFAULT}else{this.panelFilterInfo.setVisible(false);b=0}this.panelCategContainer.setSize(c,(a-b));this.panelCategContainer.syncSize()},OnDsLoad:function(c,b,d){var a=(false!==d.params.needMask);b.each(function(e){e.data.dsId=this.owner.appDSId}.createDelegate(this));if(true===a){this.SetFilterInfoText();this.gridCateg.ReloadDsCateg();this.owner.clearStatusBusy()}if(true===this.isVisible()){this.Resize()}if(0===this.gridRecList.getSelectedRecords().length){this.gridRecList.SelectFirst()}this.blStoreLoadDone=true},OnRefresh:function(){var a=Ext.applyIf({start:0,limit:this.LOG_ROW_PER_PAGE},this.GetFilterParams());this.dsRecList.load({params:a})},OnWebSocketCallback:function(b){var a=b.event;if(a){this.UpdateStoreByEvent(a)}},ChgButtonStatus:function(){var c=this.gridRecList.getSelectedRecords();var d=c.length;var e=c.some(function(f){return(true===f.get("archived"))});var b=c.some(function(f){return(false===f.get("archived"))});var a=c.some(function(f){return(true===f.get("recording"))});this.ChangePlayBtnSts(d);this.ChangeDownloadBtnSts(d);this.ChangeDeleteBtnSts(d,e,b);this.ChangeLockBtnSts(d,e,b,a)},ChangePlayBtnSts:function(a){this.btnPlay.disable();if((1<=a)&&(true===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.PLAYBACK))){this.btnPlay.enable()}},ChangeDownloadBtnSts:function(a){this.btnDownload.disable();if((1==a)&&(true===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.REC_DOWNLOAD))){this.btnDownload.enable()}},ChangeDeleteBtnSts:function(e,f,d){var c=this.btnDelete.GetMenuItem("menuDelSelected");var b=this.btnDelete.GetMenuItem("menuDelCateg");var a=this.btnDelete.GetMenuItem("menuDelAll");this.UpdateDelAllVisibility();b.disable();a.disable();if(0!==this.dsRecList.getCount()){this.btnDelete.enable();if(false===this.gridCateg.IsCurCategEntryAll()){b.enable()}a.enable()}if(0===e){c.disable()}else{if(1<=e){if(true===f){c.disable()}if(true===d){c.enable()}}}if(0==this.btnDelete.CheckAvailItems()||(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.REC_DEL))){this.btnDelete.disable()}},ChangeLockBtnSts:function(d,e,c,a){var b=(0<this.dsRecList.getCount())&&(false===this.gridCateg.IsCurCategEntryAll());this.menuItemLock.disable();this.menuItemLockFilter.disable();this.menuItemUnLock.disable();this.menuItemUnLockFilter.disable();if(0===d){this.menuItemLock.disable();this.menuItemUnLock.disable()}else{if((1<=d)&&(false===a)){if(true===e){this.menuItemUnLock.enable()}if(true===c){this.menuItemLock.enable()}}}if(true===b){this.menuItemLockFilter.enable();this.menuItemUnLockFilter.enable()}else{this.menuItemLockFilter.disable();this.menuItemUnLockFilter.disable()}if((true===this.menuItemLock.disabled)&&(true===this.menuItemLockFilter.disabled)){this.menuLock.disable()}else{this.menuLock.enable()}if((true===this.menuItemUnLock.disabled)&&(true===this.menuItemUnLockFilter.disabled)){this.menuUnLock.disable()}else{this.menuUnLock.enable()}if((true===this.menuLock.disabled)&&(true===this.menuUnLock.disabled)){this.btnLock.disable()}else{this.btnLock.enable()}if(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.REC_LOCK)){this.menuItemLock.disable();this.menuItemLockFilter.disable();this.menuLock.disable();this.menuItemUnLock.disable();this.menuItemUnLockFilter.disable();this.menuUnLock.disable();this.btnLock.disable()}},UpdateDelAllVisibility:function(){var a=this.btnDelete.GetMenuItem("menuDelAll");var b=(false===this.blOnFilter);if(a){a.setVisible(b)}},OnContextMenu:function(b,a,c,d){if(false===b.isSelected(a)){b.select(a)}this.ShowContextMenu(d)},ShowContextMenu:function(b){if(!this.contextMenu){this.InitContextMenu()}this.contextMenu.getComponent("cmLockEvent").hide();this.contextMenu.getComponent("cmUnockEvent").hide();if(!this.menuLock.disabled){if(!this.menuItemLock.disabled){this.contextMenu.getComponent("cmLockEvent").show()}}if(!this.menuUnLock.disabled){if(!this.menuItemUnLock.disabled){this.contextMenu.getComponent("cmUnockEvent").show()}}this.contextMenu.getComponent("cmPlayEvent").setVisible(!this.btnPlay.disabled);this.contextMenu.getComponent("cmDownloadEvent").setVisible(!this.btnDownload.disabled);if((this.btnDelete.disabled)||(this.btnDelete.menu.getComponent("menuDelSelected").disabled)){this.contextMenu.getComponent("cmDeleteEvent").hide()}else{this.contextMenu.getComponent("cmDeleteEvent").show()}b.stopEvent();for(var a=0;a<this.contextMenu.items.getCount();++a){if(false===this.contextMenu.items.get(a).hidden){this.contextMenu.showAt(b.getXY());break}}},InitContextMenu:function(){this.contextMenu=new SYNO.ux.Menu({items:[{itemId:"cmPlayEvent",text:_T("event","event_play"),scope:this,handler:this.OnEventPlay},{itemId:"cmDownloadEvent",text:_T("event","event_export"),scope:this,handler:this.OnEventDownload},{itemId:"cmDeleteEvent",text:_T("ss_common","common_delete"),scope:this,handler:this.DeletePreProcess},{itemId:"cmLockEvent",text:_T("ss_common","common_lock"),scope:this,handler:this.OnEventLock.createDelegate(this,[true])},{itemId:"cmUnockEvent",text:_T("ss_common","common_unlock"),scope:this,handler:this.OnEventLock.createDelegate(this,[false])}]});this.addManagedComponent(this.contextMenu)},HasNoRecord:function(){return((true===this.blStoreLoadDone)&&(false===this.blOnFilter)&&(0===this.gridCateg.GetTotalCount()))},GetCategEntryName:function(b,c){var a;if(SYNO.SS.Grid.Categ.CATEG_TIME_LAPSE_REC_TASK===b){if(SYNO.SS.App.TimeLapse.Def.ALL_TASK_ID===c){return _T("time_lapse","task_all")}a=this.dsTask.getById(c);return(a)?a.get("name"):c}else{return SYNO.SS.Grid.Categ.GetCategEntryName(b,c)}},OnEventLock:function(a){var b=this.gridRecList.getSelectedRecords().map(function(d){return d.get("id")});var c=(true===a)?"Lock":"Unlock";this.WebAPIRequest(c,1,{idList:b.join(",")})},OnEventPlay:function(b,a){if((SYNO.SS.UserPrivType.MANAGER===_S("USER_PRIVILEGE"))&&(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.PLAYBACK))){this.owner.getMsgBox().alert(this.title,_T("ss_privilege","no_permission_play_video"));return}var c=[];if((0<=a)&&(false===this.gridRecList.isSelected(a))){this.gridRecList.select(a)}else{c=this.gridRecList.getSelectedIndexes();a=c[0];if(1>=c.length){c=[]}}SYNO.SS.App.TimeLapse.Utils.OnPlay(this,a,"TimeLapseEventPlayer",c)},OnEventDownload:function(){var a=this.gridRecList.getSelectedRecords()[0];SYNO.SS.App.Event.Utils.DoEventDownload(a,this)},DeletePreProcess:function(){this.owner.getMsgBox().confirm(this.title,_T("event","event_del_warning"),this.OnEventDeleted,this)},OnEventDeleted:function(a){if("yes"!==a){return}var b=this.gridRecList.getSelectedRecords().map(function(c){return c.get("id")});this.WebAPIRequest("Delete",1,{idList:b.join(",")})},OnEventLockFiltered:function(a){var b=(true===a)?"LockFilter":"UnlockFilter";this.WebAPIRequest(b,1,this.GetFilterParams())},DeleteFilterPreProcess:function(){this.owner.getMsgBox().confirm(this.title,_T("event","event_del_all_warning"),this.OnFilterEventDelete,this)},OnFilterEventDelete:function(a){if("yes"!==a){return}this.WebAPIRequest("DeleteFilter",1,this.GetFilterParams())},DeleteAllPreProcess:function(){this.owner.getMsgBox().confirm(this.title,_T("event","event_del_all_confirm_msg"),this.OnEventDeleteAll,this)},OnEventDeleteAll:function(a){if("yes"!==a){return}this.WebAPIRequest("DeleteAll",1,this.GetFilterParams());this.panelCategContainer.auplugin.ResetTimestamp()},WebAPIRequest:function(d,a,b,c){this.owner.setStatusBusy();this.sendWebAPI({api:"SYNO.SurveillanceStation.TimeLapse.Recording",version:a,method:d,params:b,callback:function(h,f,g,e){this.OnWebAPIRequestDone(h,f,g,e,c)},scope:this})},OnWebAPIRequestDone:function(e,b,c,a,d){this.owner.clearStatusBusy();if(true===e){if(true===Ext.isFunction(d)){d.call(this,e,b,c,a)}else{this.OnRefresh()}}else{this.owner.getMsgBox().alert(this.title,SYNO.API.getErrorString(b.code))}},UpdateStoreByEvent:function(b){var e,a;var d=this.panelCategContainer.auplugin.AT_DELETE_BY_RECORD_ID;var h={},g={};var c=[],f=[];g[d]={};g[d].data=[];for(e=0;e<b.length;e++){if(true===Array.isArray(b[e])){for(a=0;a<b[e].length;a++){if(true===b[e][a].refresh){this.OnRefresh();return}this.PrepareEvent(b[e][a],c,g,f)}}else{this.PrepareEvent(b[e],c,g,f)}}h.auInfo=g;h.events=c;h.categCntData=f;this.panelCategContainer.auplugin.dsAutoUpdate.loadData(h);this.panelCategContainer.UpdateEmptyStyle()},PrepareEvent:function(a,c,e,d){var b=this.panelCategContainer.auplugin.AT_DELETE_BY_RECORD_ID;if(true===this.CheckFilterParams(a)){if(true===a.markAsDel){e[b].data.push({id:a.recordId});d.push(a)}else{this.CheckToRelaceOrAddEvent(c,a);this.CheckToRelaceOrAddEvent(d,a)}}},CheckToRelaceOrAddEvent:function(d,b){for(var c=0;c<d.length;c++){if(true===d[c].markAsDel){continue}if((d[c].id===b.id)&&(true===d[c].blNew)){var a=d[c].snapshot_medium;d[c]=b;d[c].snapshot_medium=a;d[c].blNew=true;return}}d.push(b)},CheckFilterParams:function(c){var b=this.GetFilterParams();if(SYNO.SS.App.TimeLapse.Def.ALL_TASK_ID!==b.lapseId){if(b.lapseId!==c.taskId){return false}}if(0<b.from_start){if(b.from_start>c.startTime){return false}}if(0<b.from_end){if(b.from_end<c.startTime){return false}}if(0!==b.locked){var a=(SYNO.SS.App.Event.Def.FILE_LOCK===b.locked);if(c.archived!==a){return false}}return true},IsRecordAdded:function(a){return(true===a.blNew)},IsRecordDeleted:function(a){return(true===a.markAsDel)},GetCntParam:function(b,a){var c={};if(SYNO.SS.Grid.Categ.CATEG_TIME_LAPSE_REC_TASK===b){c.key=a.taskId}return c}});