/* Copyright (c) 2019 Synology Inc. All rights reserved. */

Ext.define("SYNO.SS.App.VideoAnalytics.ExpandableListView",{extend:"SYNO.ux.ExpandableListView",owner:null,fieldServer:[{name:"name"},{name:"ds_model"},{name:"ip"}],selections:[],scheObj:null,constructor:function(a){this.owner=a.owner;this.dsCamera=a.dsCamera;var b=Ext.apply({iconTpl:new Ext.XTemplate("{snapshot_path:this.RenderTaskIcon}"),titleTpl:new Ext.XTemplate('<span ext:qtip="{0}">{name}</span><span class="title-status">{archived:this.RenderStatus}</span>'),titleRightTpl:new Ext.XTemplate("{camera_name:this.RenderCamName}"),descTpl:new Ext.XTemplate("{ip:this.RenderTypeName}"),descRightTpl:new Ext.XTemplate("{dsId:this.RenderServerName}"),innerTpl:new Ext.XTemplate("{id:this.RenderTaskDetail}")},a);this.callParent([b]);this.scheObj={};this.on("beforeExpand",function(d,e,c){if(true==d){var g=c.get("id");var f=this.scheObj[g];if(f){f.Activate(this.FillScheduleData(g,c.get("schedule")))}}},this);this.mon(this,"updateRecord",this.RenderSche,this);this.mon(this,"beforeRestoreUI",this.RenderAllSche,this);this.AddTplRenderer()},StoreUIState:function(){this.selections=this.getSelectedItemIds()},RestoreUIState:function(){this.clearSelections();this.restoreUIState(this.selections,[]);this.ScrollToSelectedNode()},RenderModel:function(b,c,a){return String.format("<span>{0}</span>",b)},RenderIp:function(b,c,a){return String.format("<span>{0}</span>",b)},AddTplRenderer:function(){this.tpl.owner=this.owner;this.tpl.expView=this;this.tpl.dsCamera=this.dsCamera;this.tpl.RenderTaskDetail=function(f,a){var e=SYNO.SS.App.VideoAnalytics.Def;var b=[{key:_T("video_analytics","stream_profile"),value:this.RenderStmProfile(a.stream_profile,a)}];if(e.AnalyticsType.PEOPLE_COUNTING===a.analyze_type){b.push({key:_T("video_analytics","accumulative_mode"),value:e.PeopleMode[a.people_mode][1]});b.push({key:_T("video_analytics","staying_people_limit"),value:this.RenderOptionalParam(a.people_enable_stay_max,a.people_stay_max,_T("video_analytics","people"))})}else{switch(a.analyze_type){case e.AnalyticsType.OBJECT_TRACKING:break;case e.AnalyticsType.MOTION_DETECTION:b.push({key:_T("video_analytics","minimum_object_size"),value:this.RenderOptionalParam((e.OBJ_SIZE_OPTION.CUSTOMIZED===a.min_obj_size_option),SYNO.SS.App.VideoAnalytics.Utils.CorrectObjSize(a.min_obj_size),"%")});b.push({key:_T("video_analytics","ignore_background_events"),value:this.RenderByStore(a.ignore_bg_event,e.BgEvent)});break;case e.AnalyticsType.ZONE_DETECTION:case e.AnalyticsType.FOREIGN_OBJECT:case e.AnalyticsType.MISSING_OBJECT:b.push({key:_T("camera","minimum_duration"),value:this.RenderString(a.min_duration)+" ("+_T("ss_common","common_second")+")"});break}b.push({key:_T("video_analytics","ignore_background_objects"),value:this.RenderByStore(a.ignore_bg_obj,e.DetectedObj)})}b.push({key:_T("ss_common","schedule"),value:""});var d=this.expView.getInnerKeyValTableTpl(b);var c="<div>"+d.html+'<div id="'+e.EXP_SCHED_DIV_PREFIX+a.id+'"></div></div>';return c};this.tpl.RenderTaskIcon=function(k,g){var d;var h=g.id;var m=g.camera_id;var e=SYNO.SS.MultiView.LIST_VIEW_IDX;var f=SYNO.SS.App.VideoAnalytics.SnapshotUtils.MakeSnapshotID(e,h);var a=this.dsCamera.getById(g.camera_id);if((!a)||(false===g.enable)||(false===(g.scheduleOn))){var b=(!a)?_IMG(SYNO.SS.Image.Camera.IconThumbError):_IMG(SYNO.SS.Image.Camera.IconThumbDisabled);d=String.format('<div style="position: relative;"><img class="cam_list_snapshot" id="{0}" src="{1}" style="{2}"></div>',f,b,"");return d}var l="";var c=(undefined===this.owner.snapshotPreloadMap[f])?"display: none;":"";if(undefined!==this.owner.snapshotMap[e][m]){l=this.owner.snapshotMap[e][m].strUrl}d=String.format('<div style="position: relative;"><img class="cam_list_snapshot" id="{0}" src="{1}" style="{2}"><img class="cam_list_loading" id="{3}" src="{4}" style="{5}"></div>',f,l,((""===l)?"display: none;":""),SYNO.SS.App.VideoAnalytics.SnapshotUtils.MakeLoadingID(e,m),SYNO.SS.CameraPage.IMG_PREVIEW_LOADING[e],c);return d};this.tpl.RenderCamName=function(c,a){var d=SYNO.SS.GblStore.dsCamera.getById(a.camera_id);var b=(d)?d.get("name"):"";return String.format('<span ext:qtip="{0}">{0}</span>',b)};this.tpl.RenderTypeName=function(b,a){var c=SYNO.SS.App.VideoAnalytics.Utils.GetTypeName(a.analyze_type);return String.format("<span>{0}</span>",c)};this.tpl.RenderStmProfile=function(f,a){var e,c,d="",h="";var b=SYNO.SS.Color.NORMAL_BLACK;var g=SYNO.SS.GblStore.dsCamera.getById(a.camera_id);if(g){e=g.get("stm_info");c=e[a.stream_profile];d=c.resolution;h=c.fps;return String.format("<span style='color:{0}'>{1}</span>",b,d+", "+h+_T("camera","stm_info_fps"))}else{return"--"}};this.tpl.RenderStatus=function(f,c){var e="",b="";var g,d;var a=c.owner_ds_id;g=(LOCAL_DS_ID===a)?true:SYNO.SS.Utils.IsSlaveDsOnline(a);if(false===g){b=(false===g)?_T("ss_common","status_unknown"):"";d=(false===g)?SYNO.SS.Color.ALERT_RED:SYNO.SS.Color.NORMAL_GRAY;e=SYNO.SS.Utils.GenAbnormalStsIcon(_T("ss_centralized","msg_connect_failed"))}else{if(false===c.enable){b=_T("ss_common","status_disabled");d=SYNO.SS.Color.NORMAL_GRAY}else{if(false===c.scheduleOn){b=_T("archive","pending_dueto_schedule");d=SYNO.SS.Color.NORMAL_GRAY}}}if(true===Ext.isEmpty(b)){return""}else{return String.format("&nbsp;-&nbsp;<span style='color:{0}'>{1}</span>{2}",d,b,e)}};this.tpl.RenderString=function(b,a){return(false===Ext.isEmpty(b))?b:"--"};this.tpl.RenderServerName=function(b,a){a.serverName=SYNO.SS.GblStore.GetDsName(a.owner_ds_id);var c="["+a.serverName+"]";return String.format('<span ext:qtip="{0}">{0}</span>',c)};this.tpl.RenderOptionalParam=function(b,c,a){if(true===b){return _T("ss_common","common_activate")+", "+c.toString()+" ("+a+")"}return _T("ss_common","common_disable")};this.tpl.RenderByStore=function(c,b){if(0<c){var a=[];b.forEach(function(d){if(c&d[0]){a.push(d[1])}});return a.join(", ")}return _T("ss_common","common_disable")}},RenderAllSche:function(){this.store.each(function(a){this.RenderSche(this,a)},this)},RenderSche:function(b,a){var d=a.get("id");var c=new SYNO.SS.Panel.SchedulerPanel({renderTo:SYNO.SS.App.VideoAnalytics.Def.EXP_SCHED_DIV_PREFIX+d,htmlSchedulerId:SYNO.SS.App.VideoAnalytics.Def.EXP_SCHED_DIV_PREFIX_HTML+d,scheduleMode:SYNO.SS.Schedule.Mode.VIDEO_ANALYTICS,blEditable:false,blTwoColor:true});this.scheObj[d]=c},FillScheduleData:function(g,f){var e;var d,b,a,c=[];for(d=0;d<7;d++){a=[];for(b=0;b<48;b++){a[b]=("1"===f.charAt(d*48+b))?1:0}c[d]=a}e={id:g,detailInfo:{camSchedule:c}};return e}});Ext.namespace("SYNO.SS.App.VideoAnalytics");Ext.define("SYNO.SS.App.VideoAnalytics.Information",{extend:"SYNO.SDS.Utils.FormPanel",FLD_WIDTH:370,COMBO_WIDTH:370,CHKBOX_HEIGHT:28,LABEL_OFFSET:30,NAME_LENGTH_LIMIT:64,fldName:null,cmbStreamProfile:null,cmbApp:null,config:null,parentWin:null,pageDevice:null,constructor:function(a){this.config=a;this.parentWin=a.parentWin;this.Init();Ext.apply(a,{title:_T("ss_common","general"),owner:a.parentWin,layout:"border",style:(true===this.config.blEditMode)?"margin-left: 10px;":"",trackResetOnLoad:true,items:[{xtype:"syno_panel",region:"center",layout:"form",items:[this.fldName,this.cmbServer,this.cmbCamera,this.cmbStreamProfile,this.cmbApp]}],listeners:{activate:this.Activate,scope:this}});this.callParent([a])},Init:function(){var b=SYNO.SS.App.VideoAnalytics.Def;this.dsTasks=SYNO.SS.GblStore.LoadFromVideoAnalyticsTaskStore({params:{}},true);this.fldName=new SYNO.SS.Form.NameTextField({name:"name",fieldLabel:_T("ss_common","common_name"),width:this.FLD_WIDTH,maxLength:this.NAME_LENGTH_LIMIT,enableKeyEvents:true,validator:this.IsTaskNameValid.createDelegate(this)});this.cmbServer=new SYNO.ux.ComboBox({name:"owner_ds_id",fieldLabel:_T("ss_centralized","source"),width:this.COMBO_WIDTH,valueField:"id",displayField:"name",mode:"local",editable:false,forceSelection:true,triggerAction:"all",value:LOCAL_DS_ID,store:SYNO.SS.GblStore.GetSlaveDSStoreCopy(),hidden:(false===IsCMSHost()),disabled:(true===this.config.blEditMode),listeners:{select:function(e,c,d){if(e.getValue()!==this.oriServer){this.ReloadCamStore();this.oriServer=e.getValue()}},scope:this}});this.dsCamera=new Ext.data.JsonStore({autoDestroy:true,root:"cameras",fields:SYNO.SS.GblStore.fieldCamera});this.cmbCamera=new SYNO.ux.ComboBox({name:"camera_id",fieldLabel:_T("video_analytics","camera"),width:this.COMBO_WIDTH,valueField:"id",displayField:"name",mode:"local",editable:false,forceSelection:true,triggerAction:"all",emptyText:_T("ss_common","common_select"),store:this.dsCamera,disabled:false,listeners:{select:function(e,c,d){this.ReloadStmProfile()},scope:this}});this.InitDsProfileType();this.cmbStreamProfile=new SYNO.ux.ComboBox({name:"stream_profile",store:this.dsProfileType,width:this.COMBO_WIDTH,valueField:"type",displayField:"text",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,lastQuery:"",value:SYNO.SS.App.Camera.Def.Profile.MEDIUM,fieldLabel:_T("video_analytics","stream_profile")});var a=new Ext.data.ArrayStore({fields:["id","name"],data:[[b.AnalyticsType.OBJECT_TRACKING,_T("video_analytics","object_detection")],[b.AnalyticsType.MOTION_DETECTION,_T("smartsearch","search_type_motion")],[b.AnalyticsType.ZONE_DETECTION,_T("smartsearch","search_type_loitering_detection")],[b.AnalyticsType.PEOPLE_COUNTING,_T("video_analytics","people_counting")],[b.AnalyticsType.FOREIGN_OBJECT,_T("smartsearch","search_type_foreign_object")],[b.AnalyticsType.MISSING_OBJECT,_T("smartsearch","search_type_missing_object")],[b.AnalyticsType.TEST_DETECTION,"Object Detection Engine (debug only)"]]});this.cmbApp=new SYNO.ux.ComboBox({name:"analyze_type",store:a,fieldLabel:_T("video_analytics","rule"),width:this.COMBO_WIDTH,valueField:"id",displayField:"name",value:b.AnalyticsType.MOTION_DETECTION,mode:"local",editable:false,forceSelection:true,triggerAction:"all",emptyText:_T("ss_common","common_select"),listeners:{select:function(f,c,e){var d=c.get("id");this.parentWin.pageSetting.hiddenAnalyzeType.setValue(d);this.parentWin.pageSetting.UpdDefaultParam()},scope:this}})},InitDsProfileType:function(){this.dsProfileType=new Ext.data.ArrayStore({autoDestroy:true,fields:["type","text"],data:[[SYNO.SS.App.Camera.Def.Profile.HIGH,_T("camera","profile_high_quality")],[SYNO.SS.App.Camera.Def.Profile.MEDIUM,_T("camera","profile_balanced")],[SYNO.SS.App.Camera.Def.Profile.LOW,_T("camera","profile_low_bandwidth")]]})},ReloadStmProfile:function(d){var a=this.cmbCamera.getValue();if(0<a){var c=SYNO.SS.GblStore.dsCamera.getById(a);var e=[];var b=c.get("stm_info");e.push([SYNO.SS.App.Camera.Def.Profile.HIGH,_T("camera","profile_high_quality")+this.GetProfileInfo(b,SYNO.SS.App.Camera.Def.Profile.HIGH)]);e.push([SYNO.SS.App.Camera.Def.Profile.MEDIUM,_T("camera","profile_balanced")+this.GetProfileInfo(b,SYNO.SS.App.Camera.Def.Profile.MEDIUM)]);if(true===c.get("blThirdStream")){e.push([SYNO.SS.App.Camera.Def.Profile.LOW,_T("camera","profile_low_bandwidth")+this.GetProfileInfo(b,SYNO.SS.App.Camera.Def.Profile.LOW)])}this.dsProfileType.loadData(e);if(true===d){this.cmbStreamProfile.setValue(this.cmbStreamProfile.getValue())}else{this.cmbStreamProfile.setValue(SYNO.SS.App.Camera.Def.Profile.MEDIUM)}}},GetProfileInfo:function(a,b){if(!a||a.length<=b){return""}var c=a[b];return" ("+_T("ss_common","stream")+c.stmNo+", "+c.resolution+", "+c.fps+_T("camera","stm_info_fps")+")"},IsStreamOverSpec:function(){var a=this.cmbCamera.getValue();var e=this.cmbStreamProfile.getValue();var d=SYNO.SS.GblStore.dsCamera.getById(a);var b=d.get("stm_info")[e];var f=SYNO.SS.Utils.Camera.GetCamResolution(b.resolution);var c=f.split("x");return((10<b.fps)||(2!==c.length)||(640*480<c[0]*c[1]))},OnCommit:function(){this.getForm().items.each(function(a){a.initValue()})},ResetSetting:function(){this.getForm().reset()},IsDirty:function(){return this.getForm().isDirty()},LoadRecord:function(a){this.getForm().loadRecord(a);if(true===this.blEditMode){this.ReloadStmProfile(true)}},GetFormData:function(){var a={camera_id:this.cmbCamera.getValue(),owner_ds_id:this.cmbServer.getValue()};return Ext.apply(a,this.getForm().getValues())},ReloadCamStore:function(){var a=this.GetDsId();var e=[];var b="";var c=false;if(false===this.config.blEditMode){SYNO.SS.GblStore.dsCamera.each(function(f){if(LOCAL_DS_ID===a){e.push(f.get("id"))}else{e.push(f.get("camIdOnRecServer"))}},this);b=e.join(",");c=true}var d=SYNO.SS.GblStore.LoadFromCamStore({params:{blServerChecked:true,ownerDsId:a,camIdList:b,blCameraIdChecked:c}},true);this.dsCamera.loadData(d)},Activate:function(){this.ReloadCamStore();if(false===this.config.blEditMode){this.getForm().clearInvalid()}},GetDsId:function(){return this.cmbServer.getValue()},GenIpCameraHyperLink:function(){var b=[];var a=function(c){return String.format("SYNO.SDS.AppLaunch('SYNO.SS.App.{0}.Instance');",c)};b.push(a("Camera"));return String.format('<a href="javascript:{0}">',b.join(""))},IsFormValid:function(){return((true!==Ext.isEmpty(this.cmbCamera.getValue()))&&(true===this.getForm().isValid()))},Validate:function(){if(true===Ext.isEmpty(this.cmbCamera.getValue())){this.cmbCamera.markInvalid()}else{this.cmbCamera.clearInvalid()}},IsTaskNameValid:function(a){return SYNO.SS.Utils.IsValidName({name:a,fnValidator:function(b){return true},scope:this})}});Ext.namespace("SYNO.SS.App.VideoAnalytics");Ext.define("SYNO.SS.App.VideoAnalytics.CanvasWidget",{data:[],originalPos:null,draggingVertex:null,draggingRegion:null,vertexWidth:2,nearestVertexThreshold:64,panelWidth:SYNO.SS.App.VideoAnalytics.Def.SIMULATE_PANEL_WIDTH,panelHeight:SYNO.SS.App.VideoAnalytics.Def.SIMULATE_PANEL_HEIGHT,blPreviewMode:false,delegate:null,constructor:function(a){Ext.applyIfExist(this,a)},GetFormData:function(){return{}},GetScaledData:function(f,d){var c=1/this.panelWidth;var b=1/this.panelHeight;var e=(d)?d:this.data;var a=e.map(function(g){return[Number((g[0]*c).toFixed(4)),Number((g[1]*b).toFixed(4))]},this);if(true===f){a=a.join(",")}return a},AddVertex:function(){},DeleteVertex:function(){this.data.splice(1,1)},Resize:function(e,b){var d=this.panelWidth;var f=this.panelHeight;var a=e/d;var c=b/f;this.panelWidth=e;this.panelHeight=b;this.data.forEach(function(g){g[0]*=a;g[1]*=c},this)},Draw:function(a){if(!a){return false}return true},DrawBySize:function(b,c,a){if((c!==this.panelWidth)||(a!==this.panelHeight)){var d,e;d=this.panelWidth;e=this.panelHeight;this.Resize(c,a);this.Draw(b);this.Resize(d,e)}else{this.Draw(b)}},DrawRegion:function(a,c,b){if(!a){return}a.lineWidth=4;a.strokeStyle="rgb(255, 252, 0)";a.fillStyle="rgba(0, 0, 255, .3)";Ext.applyIfExist(a,b);a.moveTo(c[0][0],c[0][1]);a.beginPath();c.each(function(d){a.lineTo(d[0],d[1])},this);a.closePath();a.stroke();a.fill()},DrawBoundary:function(a,c,b){if(!a){return}a.lineWidth=4;a.strokeStyle="yellow";Ext.applyIfExist(a,b);a.moveTo(c[0][0],c[0][1]);a.beginPath();c.each(function(d){a.lineTo(d[0],d[1])},this);a.closePath();a.stroke()},DrawBorderLine:function(b,f,e,d,c){if(!b){return}var a=[{width:2,style:c},{width:1,style:d}];a.forEach(function(g){b.lineWidth=g.width;b.strokeStyle=g.style;b.beginPath();b.moveTo(f[0],f[1]);b.lineTo(e[0],e[1]);b.stroke()})},ClearRegion:function(a,b){if(!a){return}a.globalCompositeOperation="destination-out";a.fillStyle="rgba(0, 0, 0, 1)";a.moveTo(b[0][0],b[0][1]);a.beginPath();b.each(function(c){a.lineTo(c[0],c[1])},this);a.closePath();a.fill();a.globalCompositeOperation="source-over"},DrawVertex:function(a,f,d,c){var b=c||8;var e=[f[0]-b/2,f[1]-b/2,b,b];a.lineWidth=1;a.fillStyle="#1AA1FF";a.strokeStyle="rgba(0, 0, 0, 1)";Ext.applyIfExist(a,d);a.fillRect(e[0],e[1],e[2],e[3]);if(1==a.lineWidth%2){e[0]+=0.5;e[1]+=0.5}e[2]-=a.lineWidth;e[3]-=a.lineWidth;a.beginPath();a.rect(e[0],e[1],e[2],e[3]);a.stroke()},DrawCircle:function(b,d,a,c){a=a||4;Ext.applyIfExist(b,c);b.beginPath();b.arc(d[0],d[1],a,0,2*Math.PI);b.fill();b.stroke()},DrawRoundedRect:function(b,g,e,a,h,c,k){if(typeof c==="undefined"){c=5}if(typeof c==="number"){c={tl:c,tr:c,br:c,bl:c}}else{var f={tl:0,tr:0,br:0,bl:0};for(var d in f){c[d]=c[d]||f[d]}}b.beginPath();b.moveTo(g+c.tl,e);b.lineTo(g+a-c.tr,e);b.quadraticCurveTo(g+a,e,g+a,e+c.tr);b.lineTo(g+a,e+h-c.br);b.quadraticCurveTo(g+a,e+h,g+a-c.br,e+h);b.lineTo(g+c.bl,e+h);b.quadraticCurveTo(g,e+h,g,e+h-c.bl);b.lineTo(g,e+c.tl);b.quadraticCurveTo(g,e,g+c.tl,e);b.closePath();if(true===k){b.fill()}b.stroke()},DrawArrow:function(f,g,l,e,a){var d=this.RotateVector(l,Math.PI/2);var k=Math.max(e,0);var b=g.map(function(n,m){return n+l[m]*(7+k)},this);var c=g.map(function(n,m){return n+d[m]*(8+k)-l[m]*(3+k)},this);var h=g.map(function(n,m){return n-d[m]*(8+k)-l[m]*(3+k)},this);Ext.applyIfExist(f,a);f.beginPath();f.moveTo(b[0],b[1]);f.lineTo(h[0],h[1]);f.lineTo(c[0],c[1]);f.closePath();f.fill();f.stroke()},MouseDown:function(d,c,a){if(MOUSE_EVENT_LEFT_BUTTON!==a){return false}if(true===this.blPreviewMode){return false}var b=this.data;var e=this.FindNearestVertex(d,c,b);if(!e){return false}this.draggingRegion=b;this.draggingVertex=e;this.originalPos=e.clone();return true},MouseMove:function(o,n){if(!this.draggingVertex||!this.draggingRegion){return false}var v,u,s;var q=Math.min(Math.max(o,0),this.panelWidth);var p=Math.min(Math.max(n,0),this.panelHeight);var m=[q,p];var d=this.originalPos;var f=this.draggingRegion;var c=this.draggingVertex;var r=f.indexOf(c);var l,b,y;var e=this.GetEdges(f,r);var x=this.GetAdjacentVertex(f,c,true);var w=this.GetAdjacentVertex(f,c,false);var g=[];var a=[];var t=[[m,x],[m,w]];t.forEach(function(k){e.forEach(function(z){l=this.GetCrossPoint(k,z,false,true);if(false===l){return}g.push(z)},this)},this);g.forEach(function(k){y=this.GetVerticalUnitVector(m,k[0],k[1]);b=m.map(function(A,z){return A+y[z]},this);l=this.GetCrossPoint(k,[b,m],true);if(true===Ext.isArray(l)){l=l.map(function(A,z){return A+y[z]*2},this);a.push(l)}},this);var h=(0===a.length);a.forEach(function(A){var z=[[A,x],[A,w]].concat(e);var k=true;for(v=0;v<z.length;v++){for(u=0;u<z.length;u++){if(false===this.GetCrossPoint(z[v],z[u],false,true)){continue}k=false}}if(true===k){m=A;h=true}},this);if(false===h){return false}c[0]=m[0];c[1]=m[1];return true},MouseUp:function(b,a){this.draggingRegion=null;this.draggingVertex=null;this.originalPos=null},FindNearestVertex:function(f,e,c,a){var b;if(!a){b=this.nearestVertexThreshold}else{b=a}if(0===c.length){return false}var d=null;c.forEach(function(l,h){var g=f-l[0],m=e-l[1];var k=Math.pow(g,2)+Math.pow(m,2);if(b>k){b=k;d=l}},this);return d},GetNearestEdge:function(d,b){var a=10000000000;var c=0;b.forEach(function(f,e){var g=Math.abs(this.GetDirectedVerticalDistanceToLine(d,f[0],f[1]));if(g<a){a=g;c=e}},this);return b[c]},GetUnitDirectionVector:function(d,a){var b=[(a[0]-d[0]),(a[1]-d[1])];var c=Math.sqrt(Math.pow(b[0],2)+Math.pow(b[1],2));return b.map(function(e){return e/c},this)},RotateVector:function(a,b){return[(Math.cos(b)*a[0]-Math.sin(b)*a[1]),(Math.sin(b)*a[0]+Math.cos(b)*a[1])]},CrossVector:function(b,a){return(b[0]*a[1]-b[1]*a[0])},GetVerticalUnitVector:function(d,b,c){var e=this.GetDirectedVerticalDistanceToLine(d,b,c);var f=this.GetUnitDirectionVector(b,c);var a=this.RotateVector(f,(0<e)?Math.PI/2:-Math.PI/2);return a},GetDirectedVerticalDistanceToLine:function(f,c,e){var b=e.map(function(h,g){return h-c[g]},this);var a=f.map(function(h,g){return h-c[g]},this);var d=Math.sqrt(b[0]*b[0]+b[1]*b[1]);return this.CrossVector(a,b)/d},GetExtendedLine:function(e,a,d){var b=this.GetUnitDirectionVector(e,a);var c=a.map(function(g,f){return g+b[f]*d},this);return[e,c]},GetCrossPoint:function(t,p,r,d){var u=t[0],q=t[1],o=p[0],n=p[1];var m=q.map(function(b,a){return b-u[a]},this);var k=n.map(function(b,a){return b-o[a]},this);var v=o.map(function(b,a){return b-u[a]},this);var f=this.CrossVector(m,k);if(0===f){return false}var c=this.CrossVector(v,k);var l=Number((u[0]+m[0]*c/f).toFixed(4));var h=Number((u[1]+m[1]*c/f).toFixed(4));if(!r){if((l<Math.min(u[0],q[0]))||(l>Math.max(u[0],q[0]))||(l<Math.min(o[0],n[0]))||(l>Math.max(o[0],n[0]))||(h<Math.min(u[1],q[1]))||(h>Math.max(u[1],q[1]))||(h<Math.min(o[1],n[1]))||(h>Math.max(o[1],n[1]))){return false}}if(true===d){var e=function(w,s){var x=0.001;return(Math.abs(w[0]-s[0])<x)&&(Math.abs(w[1]-s[1])<x)};var g=[l,h];if((true===e(g,u))||(true===e(g,q))||(true===e(g,o))||(true===e(g,n))){return false}}return[l,h]},GetAngle:function(e,c,a){var d=c.map(function(h,g){return h-e[g]},this);var b=a.map(function(h,g){return h-e[g]},this);var f=Math.atan2((d[0]*b[1]-d[1]*b[0]),(d[1]*b[1]+d[0]*b[0]))*180/Math.PI;return f},GetAdjacentVertex:function(e,d,c){if(false===Ext.isArray(e)){return false}var a=e.indexOf(d);if(0>a){return false}var b=(true===c)?(a-1):(a+1);if(e.length<=b){b=0}else{if(0>b){b=e.length-1}}return e[b]},GetDistance:function(c,b){var a=[(b[0]-c[0]),(b[1]-c[1])];return Math.sqrt(a[0]*a[0]+a[1]*a[1])},GetEdges:function(b,c){var a=[];for(i=0;i<b.length;i++){j=i+1;if(b.length<=j){j=0}if((i===c)||(j===c)){continue}a.push([b[i],b[j]])}return a},GetInnerAngleSum:function(b){var a=0;b.forEach(function(c){var e=this.GetAdjacentVertex(b,c,true);var d=this.GetAdjacentVertex(b,c,false);a+=this.GetAngle(c,e,d)},this);return a},IsConvexPolygon:function(c){var b=180*(c.length-2);var a=this.GetInnerAngleSum(c);return(Math.abs(a-b)<0.001)||(Math.abs(a+b)<0.001)},IsInRect:function(a,b){if(!a||!b){return false}if((a[0]>b[0])&&(a[0]<(b[0]+b[2]))&&(a[1]>b[1])&&(a[1]<(b[1]+b[3]))){return true}return false},GetCenterPoint:function(a){var b=[0,0];a.forEach(function(c){b[0]+=c[0];b[1]+=c[1]},this);b=b.map(function(c){return c/a.length},this);return b},ShouldChgCursorToPointer:function(){return false}});Ext.define("SYNO.SS.App.VideoAnalytics.CanvasWidget.Line",{extend:"SYNO.SS.App.VideoAnalytics.CanvasWidget",maxVertexCnt:2,constructor:function(a){this.callParent([a]);while(this.maxVertexCnt<this.data.length){this.DeleteVertex()}},GetFormData:function(a){return{area_line:this.GetScaledData(a)}},Draw:function(b){if(!this.callParent([b])){return false}var a=this.data;if(2>a.length){return false}b.lineWidth=4;b.strokeStyle="green";b.moveTo(a[0][0],a[0][1]);b.beginPath();a.forEach(function(c){b.lineTo(c[0],c[1])},this);b.stroke();return true}});Ext.define("SYNO.SS.App.VideoAnalytics.CanvasWidget.Region",{extend:"SYNO.SS.App.VideoAnalytics.CanvasWidget",constructor:function(a){this.callParent([a])},GetFormData:function(a){return{area_region:this.GetScaledData(a)}},Draw:function(a){if(!this.callParent([a])){return false}var b=this.data;this.DrawRegion(a,b);b.forEach(function(c){this.DrawVertex(a,c)},this);return true}});Ext.define("SYNO.SS.App.VideoAnalytics.CanvasWidget.MultiRegion",{extend:"SYNO.SS.App.VideoAnalytics.CanvasWidget",regionCnt:1,regionType:SYNO.SS.App.VideoAnalytics.Def.RegionType.INCLUDE_REGION,displayInfo:SYNO.SS.App.VideoAnalytics.Def.DisplayInfoType.NONE,EDGE_MARGIN:8,addVertexIdx:-1,addRegionIdx:-1,panelRegion:[],HoverRegionVertex:null,blTrigger:false,constructor:function(a){this.callParent([a]);this.panelRegion=[[0,0],[this.panelWidth,0],[this.panelWidth,this.panelHeight],[0,this.panelHeight]]},GetFormData:function(a){return{det_region:this.GetScaledData(a)}},GetScaledData:function(e){var c=1/this.panelWidth;var b=1/this.panelHeight;var a=this.data.map(function(f){return f.map(function(g){return[Number((g[0]*c).toFixed(4)),Number((g[1]*b).toFixed(4))]},this)},this);if(true===e){for(var d=0;d<a.length;++d){a[d]=a[d].join(",")}a=a.join(";")}return a},Draw:function(g){var f;if(!this.callParent([g])){return false}var e=this.data;var c=this.regionCnt;var h=this.regionType;var b=false;var l=false;var a=SYNO.SS.App.VideoAnalytics.Def;if(h===SYNO.SS.App.VideoAnalytics.Def.RegionType.EXCLUDE_REGION){regionColor="rgba(89, 84, 83, 0.5)";boundaryColor="rgb(221, 133, 0)"}else{if(true===this.blPreviewMode){regionColor="rgba(248, 231, 28, 0.3)";boundaryColor="rgba(253, 162, 44, 1)"}else{regionColor="rgba(0, 121, 188, 0.3)";boundaryColor="#FFFC00"}}if(true===this.blPreviewMode){if(0===(SYNO.SS.App.VideoAnalytics.Def.DisplayInfoType.DISPLAY_REGION&this.displayInfo)){regionColor="rgba(0,0,0,0)"}if(0===(SYNO.SS.App.VideoAnalytics.Def.DisplayInfoType.DISPLAY_BORDER&this.displayInfo)){boundaryColor="rgba(0,0,0,0)"}}for(f=0;(f<e.length)&&(f<c);f++){this.DrawRegion(g,e[f],{lineWidth:2,strokeStyle:boundaryColor,fillStyle:regionColor})}if(false===this.blPreviewMode){for(var d=0;(d<e.length)&&(d<c);d++){e[d].forEach(function(k){strFillStyle=(h===SYNO.SS.App.VideoAnalytics.Def.RegionType.INCLUDE_REGION)?"#1AA1FF":"rgb(223, 33, 52)";b=(k===this.HoverRegionVertex);l=(k===this.draggingVertex);if(true===l){strFillStyle="#F5E70B"}else{if(true===b){strFillStyle=(h===SYNO.SS.App.VideoAnalytics.Def.RegionType.INCLUDE_REGION)?"#3DBDFF":"rgb(250, 40, 52)"}}this.DrawVertex(g,k,{lineWidth:1,strokeStyle:"black",fillStyle:strFillStyle,shadowOffsetX:0,shadowOffsetY:0,shadowBlur:0})},this)}}return true},IsOnEdge:function(e,d){var b=false;var f=this.data;var a=this.regionCnt;var c=[e,d];f.forEach(function(l,g){if(g>=a){return}for(var k=0;k<l.length;k++){var h=k+1;if(l.length<=h){h=0}var m=this.GetDirectedVerticalDistanceToLine(c,l[k],l[h]);if(Math.abs(m)<this.EDGE_MARGIN){b=true;this.addVertexIdx=h;this.addRegionIdx=g;break}}},this);return b},MouseDown:function(k,h,c){if(true===this.blPreviewMode){return}var e=this.data;var d=this.regionCnt;var b=[];var g=0;var a=null;for(var f=0;f<e.length;f++){a=this.FindNearestVertex(k,h,e[f]);if(a){g=f;break}}if(a){if(MOUSE_EVENT_LEFT_BUTTON===c){this.draggingVertex=a;this.draggingRegion=e[g];this.originalPos=a.clone()}else{if(MOUSE_EVENT_RIGHT_BUTTON===c){if(3<e[g].length){e[g].remove(a)}}}return true}if(true===this.IsOnEdge(k,h)){if(MOUSE_EVENT_LEFT_BUTTON===c){e[this.addRegionIdx].splice(this.addVertexIdx,0,[k,h]);this.draggingVertex=e[this.addRegionIdx][this.addVertexIdx];this.draggingRegion=e[this.addRegionIdx];this.originalPos=this.draggingVertex.clone();return true}}return false},MouseUp:function(f,e){if(this.draggingRegion&&this.draggingVertex){var b=this.GetAdjacentVertex(this.draggingRegion,this.draggingVertex,true);var a=this.GetAdjacentVertex(this.draggingRegion,this.draggingVertex,false);var d=this.GetDistance(this.draggingVertex,b);var c=this.GetDistance(this.draggingVertex,a);if((d<6)||(c<6)){this.draggingRegion.remove(this.draggingVertex)}}this.draggingRegion=null;this.draggingVertex=null;this.originalPos=null},MouseMove:function(c,b){if((false===this.blPreviewMode)&&(!this.draggingRegion&&!this.draggingVertex)){var d=null;for(var a=0;a<this.data.length;a++){d=this.FindNearestVertex(c,b,this.data[a]);if(d){break}}if(this.HoverRegionVertex!==d){this.HoverRegionVertex=d}}this.callParent([c,b])},Resize:function(e,b){var d=this.panelWidth;var f=this.panelHeight;var a=e/d;var c=b/f;this.panelWidth=e;this.panelHeight=b;this.data.forEach(function(g){g.forEach(function(h){h[0]*=a;h[1]*=c})})},ShouldChgCursorToPointer:function(){if(false===this.blPreviewMode&&this.HoverRegionVertex){return true}else{return false}}});Ext.define("SYNO.SS.App.VideoAnalytics.CanvasWidget.SizeIndicator",{extend:"SYNO.SS.App.VideoAnalytics.CanvasWidget.Region",HINT_WIDTH:60,HINT_HEIGHT:20,HINT_MARGIN:3,constructor:function(a){this.callParent([a])},Draw:function(a){if(!a){return false}this.data.forEach(function(b){this.DoDrawRect(a,b);this.DoDrawHint(a,b)},this)},DoDrawHint:function(d,f){var g=f[0][0];var e=f[0][1];var h=f[1][0]-f[0][0];var k=f[2][1]-f[0][1];var a=this.GetSize(f).toString()+"%";var c=g+0.5*h;var b=e+k+this.HINT_MARGIN;if(this.panelHeight<b+this.HINT_HEIGHT+this.HINT_MARGIN){b=e-this.HINT_HEIGHT-this.HINT_MARGIN}d.fillStyle="rgba(0, 0, 0, 0.6)";d.fillRect(c-0.5*this.HINT_WIDTH,b,this.HINT_WIDTH,this.HINT_HEIGHT);d.fillStyle="rgba(255, 255, 255, 1)";d.font="bold 15px Verdana";d.textBaseline="top";d.textAlign="center";d.fillText(a,c,b)},DoDrawRect:function(a,b){this.DrawRegion(a,b,{lineWidth:2,strokeStyle:"rgba(182, 255, 0, 1)",fillStyle:"rgba(255, 255, 255, 0.05)"})},GetSize:function(b){var a=b[1][0]-b[0][0];var c=b[2][1]-b[0][1];return SYNO.SS.App.VideoAnalytics.Utils.CorrectObjSize(100*a*c/(this.panelWidth*this.panelHeight))}});Ext.define("SYNO.SS.App.VideoAnalytics.CanvasWidget.SizeEditor",{extend:"SYNO.SS.App.VideoAnalytics.CanvasWidget.SizeIndicator",MIN_SIZE:0.002,MAX_SIZE:0.25,ORIGIN_MARGIN:0.15,draggingVertex:null,diagonalVertex:null,indicatorOffset:null,constructor:function(a){var b=Math.sqrt(a.size/100);this.owner=a.owner;this.ratio=[b,b];this.originVertex=[a.panelWidth*this.ORIGIN_MARGIN,a.panelHeight*(1-this.ORIGIN_MARGIN-this.ratio[1])];this.callParent([a]);this.UpdateData()},UpdateData:function(){var a=this.panelWidth*this.ratio[0];var b=this.panelHeight*this.ratio[1];var d=this.originVertex[0];var c=this.originVertex[1];this.data=[[this.originVertex,[d+a,c],[d+a,c+b],[d,c+b]]]},Draw:function(a){this.callParent([a]);this.data.forEach(function(b){b.forEach(function(c){this.DrawVertex(a,c,{fillStyle:"rgba(230, 5, 255, 1)"},7)},this)},this)},ComputeOffset:function(c,b){var a=this.data.first();if((c>=a[0][0])&&(c<=a[2][0])&&(b>=a[0][1])&&(b<=a[2][1])){return[(c-a[0][0]),(b-a[0][1])]}return null},MouseDown:function(e,d,b){if(MOUSE_EVENT_LEFT_BUTTON!==b){return false}var c=this.data.first();this.draggingVertex=this.FindNearestVertex(e,d,c);if(null!==this.draggingVertex){var a=c.indexOf(this.draggingVertex);this.diagonalVertex=c[(a+2)%4];return true}this.indicatorOffset=this.ComputeOffset(e,d);if(null!==this.indicatorOffset){return true}return false},MouseMove:function(h,g){var b=2;var l,c,e,f,k;if(this.draggingVertex&&this.diagonalVertex){h=h.constrain(b,this.panelWidth-b);g=g.constrain(b,this.panelHeight-b);c=Math.min(h,this.diagonalVertex[0]);e=Math.min(g,this.diagonalVertex[1]);f=Math.max(Math.max(h,this.diagonalVertex[0])-c,1);k=Math.max(Math.max(g,this.diagonalVertex[1])-e,1);l=f*k/(this.panelWidth*this.panelHeight);if(this.MAX_SIZE<l||this.MIN_SIZE>l){var a=(this.MAX_SIZE<l)?this.MAX_SIZE:this.MIN_SIZE;var d=Math.sqrt(l/a);f/=d;k/=d;if(c<this.diagonalVertex[0]){c=this.diagonalVertex[0]-f}if(e<this.diagonalVertex[1]){e=this.diagonalVertex[1]-k}}this.originVertex=[c,e];this.ratio=[f/this.panelWidth,k/this.panelHeight];this.UpdateData();this.owner.fireEvent("sizeChanged",this.GetSize());return true}else{if(this.indicatorOffset){f=this.panelWidth*this.ratio[0];k=this.panelHeight*this.ratio[1];c=(h-this.indicatorOffset[0]).constrain(b,(this.panelWidth-f-b));e=(g-this.indicatorOffset[1]).constrain(b,(this.panelHeight-k-b));this.originVertex=[c,e];this.UpdateData();return true}}return false},MouseUp:function(b,a){this.draggingVertex=null;this.diagonalVertex=null;this.indicatorOffset=null},GetSize:function(){return SYNO.SS.App.VideoAnalytics.Utils.CorrectObjSize(this.ratio[0]*this.ratio[1]*100)}});Ext.define("SYNO.SS.App.VideoAnalytics.CanvasWidget.PplRegion",{extend:"SYNO.SS.App.VideoAnalytics.CanvasWidget.Region",STYLE:{PREVIEW_TRIGGER_REGION:"rgba(248, 231, 28, 0.3)",PREVIEW_STATIC_REGION:"rgba(126, 211, 33, 0.3)",EDIT_STATIC_REGION:"rgba(0, 121, 188, 0.3)",PREVIEW_TRIGGER_TUNNEL_BORDER:"rgba(253, 162, 44, {0})",PREVIEW_STATIC_TUNNEL_BORDER:"rgba(29, 211, 33, {0})",EDIT_TUNNEL_BORDER:"#FFFC00",EDIT_TUNNEL_FILL:"#C2BF1D"},minLengthToDrawLabel:100,blBinarizedRegion:true,enterIdx:0,exitIdx:2,enterPoint:null,exitPoint:null,centerPoint:null,pplAccMode:null,enterHintPos:null,exitHintPos:null,enterLabelRect:null,exitLabelRect:null,enterRegion:null,exitRegion:null,enterTunnelIdx:null,exitTunnelIdx:null,resetRect:null,resetImgId:null,resetImg:null,resetTimeoutId:null,blResetting:false,blConvexPolygon:false,blCustomizedHintPoints:false,status:null,blHoldingEnterPoint:false,blHoldingExitPoint:false,blHoldingEnterHint:false,blHoldingExitHint:false,blHoldingRegionVertex:false,blHoveringEnterPoint:false,blHoveringExitPoint:false,blHoverEnterLabel:false,blHoverExitLabel:false,blHoverResetRect:false,HoverRegionVertex:null,strFont:"12px Verdana",constructor:function(a){this.resetRect=[0,0,16,16];this.status={pplIn:0,pplOut:0,blPplInChange:false,blPplOutChange:false,blPplInEnterRegion:false,blPplInExitRegion:false,blTrigger:false,timestamp:0};this.callParent([a]);this.InitImage();this.UpdatePoints()},Resize:function(d,b){var a=d/this.panelWidth;var c=b/this.panelHeight;this.enterHintPos=[this.enterHintPos[0]*a,this.enterHintPos[1]*c];this.exitHintPos=[this.exitHintPos[0]*a,this.exitHintPos[1]*c];this.callParent([d,b]);this.UpdatePoints()},GetImagePath:function(b){var a="modules/VideoAnalytics/images/";var c=(true===SYNO.SS.Image.IsRetinaSupport())?"2x/":"1x/";return a+c+b},InitImage:function(){var c=this.GetImagePath("icon_btn_reset.png?v=5847");var a=function(){this.resetImg=document.getElementById(this.resetImgId)}.createDelegate(this);var b=SYNO.SS.Utils.AsyncImageLoad(c,a,Ext.emptyFn,10);this.resetImgId=SYNO.SS.Utils.AsyncImageLoad.PREFIX+b},UpdatePoints:function(){var l=this.data;var g=this.enterIdx;var b=this.exitIdx;var f=this.GetEdges(l);var h,m;var a;var d,c,k;var e=this.IsConvexPolygon(l);if(true===e){h=this.GetCenterPoint(l)}else{d=this.GetExcellantAngle(l);h=this.GetCenterPoint([l[d],l[(d+2)%4]])}this.blConvexPolygon=e;this.centerPoint=h;this.enterPoint=this.GetHintPoint(g,14);this.exitPoint=this.GetHintPoint(b,6)},UpdateResult:function(a){if(!a.timestamp||(this.status.timestamp>=a.timestamp)||(true===this.blResetting)){return}Ext.apply(this.status,a)},GetExcellantAngle:function(e){var a;var b=0;var c=0;var f,d;e.forEach(function(h,g){var l=this.GetAdjacentVertex(e,h,true);var k=this.GetAdjacentVertex(e,h,false);var m=this.GetAngle(h,l,k);if(0>=m){a=g;b++}else{c=g}},this);if(1<b){a=c}return a},GetFormData:function(a){return{people_enter:this.enterIdx,people_exit:this.exitIdx,people_region:this.GetScaledData(a),people_hint_pos:this.GetScaledData(a,[this.enterHintPos,this.exitHintPos])}},GetHintPoint:function(e,m){var c=this.panelWidth;var k=this.panelHeight;var l=this.data;var f=this.GetEdges(l);var h=this.centerPoint;var g=l[e];var b;var n=this.GetAdjacentVertex(l,g);var d=this.GetVerticalUnitVector(h,f[e][0],f[e][1]);var a=this.GetCenterPoint([g,n]);if(!m){m=6}g=a.map(function(p,o){return p+d[o]*20},this);b=g.map(function(p,o){return p+d[o]*m},this);if(0>b[0]){g[0]-=b[0]}else{if(c<b[0]){g[0]-=(b[0]-c)}}if(0>b[1]){g[1]-=b[1]}else{if(k<b[1]){g[1]-=(b[1]-k)}}return g},GetTextPos:function(b,c){var d;var a=this.RotateVector(c,Math.PI/2);d=b.map(function(f,e){return f+c[e]*15+a[e]*30},this);return d},UpdateLabelRect:function(d,e,b){var h=8;var m=2;var o=6;var a=this.panelWidth;var g=this.panelHeight;var f=this.centerPoint;var p;var k;var l=20;var c;var n=function(q,s){var r=this.GetUnitDirectionVector(f,q);var v=this.GetTextPos(q,r);var u=[v[0]-s/2,v[1]-l/2];var t;if(0>u[0]){u[0]=0}else{if(a<=u[0]+s){u[0]=a-s}}if(0>u[1]){u[1]=0}else{if(g<=u[1]+l){u[1]=g-l}}t=[u[0],u[1],s,l];return t}.createDelegate(this);d.font=this.strFont;p=d.measureText(e).width+h*2;exitHintWidth=d.measureText(b).width+h*2;if((false===this.blPreviewMode)&&(false===this.blCustomizedHintPoints)){c=this.GetHintPoint(this.enterIdx);this.enterLabelRect=n(c,p);c=this.GetHintPoint(this.exitIdx);this.exitLabelRect=n(c,exitHintWidth);this.enterHintPos=this.enterLabelRect.slice(0,2);this.exitHintPos=this.exitLabelRect.slice(0,2)}else{this.enterLabelRect=[this.enterHintPos[0],this.enterHintPos[1],p,l];this.exitLabelRect=[this.exitHintPos[0],this.exitHintPos[1],exitHintWidth,l]}if(true===this.blPreviewMode){if(true===this.blHoverEnterLabel){this.resetRect[0]=this.enterLabelRect[0]+this.enterLabelRect[2];this.resetRect[1]=this.enterLabelRect[1]+m;this.enterLabelRect[2]+=this.resetRect[2]+o}else{if(true===this.blHoverExitLabel){this.resetRect[0]=this.exitLabelRect[0]+this.exitLabelRect[2];this.resetRect[1]=this.exitLabelRect[1]+m;this.exitLabelRect[2]+=this.resetRect[2]+o}}}},IsTwoEntryAdjacent:function(){var a=Math.abs(this.enterIdx-this.exitIdx);return(a===1||a===3)},UpdateBinarizedRegions:function(){var e=this.data;var v=this.IsConvexPolygon(e);var k=this.IsTwoEntryAdjacent();if(true===k){var o=((this.enterIdx+1)%4===this.exitIdx);var c=(o)?this.exitIdx:this.enterIdx;var l=e[c];var h=e[(c+2)%4];var a=(o)?e[this.enterIdx]:e[(this.enterIdx+1)%4];var g=!(o)?e[this.exitIdx]:e[(this.exitIdx+1)%4];if(true===v){this.enterRegion=[l,h,a];this.exitRegion=[l,h,g];this.enterTunnelIdx=[1];this.exitTunnelIdx=[1]}else{this.enterRegion=[this.centerPoint,h,a,l];this.exitRegion=[this.centerPoint,h,g,l];this.enterTunnelIdx=[1];this.exitTunnelIdx=[1]}}else{if(true===v){var p=e[this.enterIdx];var f=this.GetAdjacentVertex(e,p,true);var m=[(p[0]+f[0])/2,(p[1]+f[1])/2];var r=e[this.exitIdx];var b=this.GetAdjacentVertex(e,r,true);var t=[(r[0]+b[0])/2,(r[1]+b[1])/2];this.enterRegion=[p,this.GetAdjacentVertex(e,p),t,m];this.exitRegion=[r,this.GetAdjacentVertex(e,r),m,t];this.enterTunnelIdx=[1,3];this.exitTunnelIdx=[1,3]}else{var s=this.GetExcellantAngle(e);var n=(s+2)%4;var d=[s,n];var q=(this.enterIdx+1)%4;var u=(this.exitIdx+1)%4;this.enterRegion=Ext.unique([this.enterIdx,q].concat(d)).map(function(w){return e[w]});this.exitRegion=Ext.unique([this.exitIdx,u].concat(d)).map(function(w){return e[w]});this.enterTunnelIdx=(0<=d.indexOf(this.enterIdx))?[1]:[2];this.exitTunnelIdx=(0<=d.indexOf(this.exitIdx))?[1]:[2]}}},DrawLabel:function(g,k,a,h,m){var o=(IS_FIREFOX_BROWSER)?5:3;var d=8;var p=this.enterLabelRect;var e=this.exitLabelRect;var f=this.resetRect;var n=null;var c=(SYNO.SS.App.VideoAnalytics.Def.PeopleModeType.LEAVE!==this.pplAccMode);var l=(SYNO.SS.App.VideoAnalytics.Def.PeopleModeType.ENTER!==this.pplAccMode);g.font=this.strFont;g.lineWidth=2;g.textBaseline="top";g.textAlign="left";if(true===c){g.fillStyle=(h)?"rgba(217, 49, 0, 0.6)":(this.blHoldingEnterHint&&!this.blPreviewMode)?"rgba(0, 0, 0, 1)":"rgba(0, 0, 0, 0.6)";g.fillRect(p[0],p[1],p[2],p[3]);g.fillStyle="rgba(255, 255, 255, 1)";g.fillText(k,p[0]+d,p[1]+o)}if(true===l){g.fillStyle=(m)?"rgba(217, 49, 0, 0.6)":(this.blHoldingExitHint&&!this.blPreviewMode)?"rgba(0, 0, 0, 1)":"rgba(0, 0, 0, 0.6)";g.fillRect(e[0],e[1],e[2],e[3]);g.fillStyle="rgba(255, 255, 255, 1)";g.fillText(a,e[0]+d,e[1]+o)}if(true===this.blPreviewMode){if((true===c)&&(true===this.blHoverEnterLabel)){n=p}else{if((true===l)&&(true===this.blHoverExitLabel)){n=e}}if(n){var b=0;if(true===this.blResetting){b=32}else{if(true===this.blHoverResetRect){b=16}}g.drawImage(this.resetImg,0,b,16,16,f[0],f[1],f[2],f[3])}}},DrawTunnels:function(a,f,e,b){if(!a){return}var d=25;var c=this.IsConvexPolygon(f);e.forEach(function(p,t){var l,g;var o=(p+1)%f.length;var n=f[p];var h=f[o];var u=this.GetVerticalUnitVector(h,n,h);if(true===c){l=this.GetUnitDirectionVector(n,this.GetAdjacentVertex(f,n,true));g=this.GetUnitDirectionVector(h,this.GetAdjacentVertex(f,h))}else{var q=this.GetExcellantAngle(f);if(q===p){l=this.GetUnitDirectionVector(n,this.centerPoint)}else{l=this.GetUnitDirectionVector(n,this.GetAdjacentVertex(f,n,true))}if(q===o){g=this.GetUnitDirectionVector(h,this.centerPoint)}else{g=this.GetUnitDirectionVector(h,this.GetAdjacentVertex(f,h))}}var m=Math.abs(Math.sin(this.GetAngle(n,this.GetAdjacentVertex(f,n,true),h)));var s=Math.abs(Math.sin(this.GetAngle(h,this.GetAdjacentVertex(f,h),n)));var k=[n,[n[0]+d*l[0]/m,n[1]+d*l[1]/m],[h[0]+d*g[0]/s,h[1]+d*g[1]/s],h];var r=a.createLinearGradient(n[0]-d*u[0],n[1]-d*u[1],n[0]+d*u[0],n[1]+d*u[1]);r.addColorStop(0.2,String.format(b,0));r.addColorStop(0.45,String.format(b,0.2));r.addColorStop(0.5,String.format(b,0.8));r.addColorStop(0.55,String.format(b,0.2));r.addColorStop(0.8,String.format(b,0));a.fillStyle=r;a.moveTo(k[0][0],k[0][1]);a.beginPath();k.each(function(v){a.lineTo(v[0],v[1])},this);a.closePath();a.fill()},this)},Draw:function(m){if(!m){return false}m.save();var p=this.blPreviewMode;var g=this.data;var d=this.GetEdges(g);var r=this.enterPoint;var n=this.exitPoint;var u=this.centerPoint;var z,x,e;var w=[0,1,2,3].remove(this.enterIdx).remove(this.exitIdx);var v=this.status;var a,c;var C,B;var h;var t=false;var o=false;var l=false;var b=false;var s=false;if(true===p){if(true===this.blBinarizedRegion){var f=(true===v.blPplInEnterRegion)?this.STYLE.PREVIEW_TRIGGER_REGION:this.STYLE.PREVIEW_STATIC_REGION;var k=(true===v.blPplInExitRegion)?this.STYLE.PREVIEW_TRIGGER_REGION:this.STYLE.PREVIEW_STATIC_REGION;var y=(true===v.blPplInEnterRegion)?this.STYLE.PREVIEW_TRIGGER_TUNNEL_BORDER:this.STYLE.PREVIEW_STATIC_TUNNEL_BORDER;var A=(true===v.blPplInExitRegion)?this.STYLE.PREVIEW_TRIGGER_TUNNEL_BORDER:this.STYLE.PREVIEW_STATIC_TUNNEL_BORDER;this.UpdateBinarizedRegions();this.DrawRegion(m,this.enterRegion,{lineWidth:1,strokeStyle:f,fillStyle:f});this.DrawRegion(m,this.exitRegion,{lineWidth:1,strokeStyle:k,fillStyle:k});this.DrawTunnels(m,this.enterRegion,this.enterTunnelIdx,y);this.DrawTunnels(m,this.exitRegion,this.exitTunnelIdx,A)}else{t=(true===v.blPplInEnterRegion||true===v.blPplInExitRegion);C=(true===t)?this.STYLE.PREVIEW_TRIGGER_REGION:this.STYLE.PREVIEW_STATIC_REGION;this.DrawRegion(m,g,{lineWidth:1,strokeStyle:C,fillStyle:C});C=(true===t)?this.STYLE.PREVIEW_TRIGGER_TUNNEL_BORDER:this.STYLE.PREVIEW_STATIC_TUNNEL_BORDER;B=(true===t)?this.STYLE.PREVIEW_TRIGGER_TUNNEL_FILL:this.STYLE.PREVIEW_STATIC_TUNNEL_FILL;w.forEach(function(D){this.DrawBorderLine(m,d[D][0],d[D][1],B,C)},this)}}else{this.DrawRegion(m,g,{lineWidth:1,strokeStyle:this.STYLE.EDIT_STATIC_REGION,fillStyle:this.STYLE.EDIT_STATIC_REGION});w.forEach(function(D){this.DrawBorderLine(m,d[D][0],d[D][1],this.STYLE.EDIT_TUNNEL_FILL,this.STYLE.EDIT_TUNNEL_BORDER)},this)}if(false===p){if((true===this.blHoldingEnterPoint)||(true===this.blHoldingExitPoint)){[0,1,2,3].forEach(function(D){var E=this.GetHintPoint(D);m.lineWidth=1.5;m.strokeStyle="#FFFFFF";m.fillStyle="rgba(255, 255, 255, 0.3)";this.DrawCircle(m,E)},this)}m.lineWidth=2;m.strokeStyle="#FFFFFF";m.shadowColor="rgba(0, 0, 0, 0.5)";m.shadowBlur=4;m.shadowOffsetX=0;m.shadowOffsetY=1;m.beginPath();m.moveTo(r[0],r[1]);m.bezierCurveTo(u[0],u[1],u[0],u[1],n[0],n[1]);m.stroke();if(true===this.blHoldingExitPoint){B="#BF10CC";h=5}else{if(true===this.blHoveringExitPoint){B="#EF12FF";h=5}else{B="#D110DF";h=4}}m.lineWidth=1.5;m.strokeStyle="#FFFFFF";m.fillStyle=B;this.DrawCircle(m,n,h);var q=0;if(true===this.blHoldingEnterPoint){B="#BF10CC"}else{if(true===this.blHoveringEnterPoint){q=1;B="#EF12FF"}else{B="#D110DF"}}m.fillStyle=B;z=this.GetUnitDirectionVector(u,r);this.DrawArrow(m,r,z,q)}if(false===p){g.forEach(function(D){B="#1AA1FF";o=(D===this.HoverRegionVertex);l=(D===this.draggingVertex);if(true===l){B="#F5E70B"}else{if(true===o){B="#3DBDFF"}}this.DrawVertex(m,D,{lineWidth:1,strokeStyle:"black",fillStyle:B,shadowOffsetX:0,shadowOffsetY:0,shadowBlur:0})},this)}if((this.minLengthToDrawLabel<this.panelWidth)&&(this.minLengthToDrawLabel<this.panelHeight)){a=_T("ss_common","common_enter");c=_T("ss_common","common_exit");if(true===p){a+=": "+v.pplIn;c+=": "+v.pplOut;b|=(true===v.blPplInChange);s|=(true===v.blPplOutChange)}this.UpdateLabelRect(m,a,c);this.DrawLabel(m,a,c,b,s)}m.restore();return true},MouseDown:function(g,f,a){if(MOUSE_EVENT_LEFT_BUTTON!==a){return false}if(true===this.blPreviewMode){var c=this.IsInRect([g,f],this.enterLabelRect);var e=this.IsInRect([g,f],this.exitLabelRect);var b=this.IsInRect([g,f],this.resetRect);if(((true===c)||(true===e))&&(true===b)){this.resetTimeoutId=setTimeout((function(){this.blResetting=false;this.resetTimeoutId=null}).createDelegate(this),2000);this.blResetting=true;this.delegate.SendWebAPI({blPeopleResetIn:c,blPeopleResetOut:e},function(n,l,m,k){if(true===n){this.status.timestamp=l.timestamp}this.blResetting=false;if(!this.resetTimeoutId){clearTimeout(this.resetTimeoutId);this.resetTimeoutId=null}},this);if(true===c){this.status.pplIn=0}else{if(true===e){this.status.pplOut=0}}return true}}else{var d=this.data;var h=this.FindNearestVertex(g,f,d);if(h){this.draggingRegion=d;this.draggingVertex=h;this.originalPos=h.clone();this.blHoldingRegionVertex=true;return true}h=this.FindNearestVertex(g,f,[this.enterPoint],100);if(h){this.blHoldingEnterPoint=true;return true}h=this.FindNearestVertex(g,f,[this.exitPoint]);if(h){this.blHoldingExitPoint=true;return true}h=this.FindNearestVertex(g,f,[[this.enterLabelRect[0]+0.5*this.enterLabelRect[2],this.enterLabelRect[1]+0.5*this.enterLabelRect[3]]],300);if(h){this.blHoldingEnterHint=true;return true}h=this.FindNearestVertex(g,f,[[this.exitLabelRect[0]+0.5*this.exitLabelRect[2],this.exitLabelRect[1]+0.5*this.exitLabelRect[3]]],300);if(h){this.blHoldingExitHint=true;return true}}return false},MouseMove:function(f,d){var c=this.data;var g;var b=this.blHoverEnterLabel;var a=this.blHoverExitLabel;var e=this.blHoverResetRect;this.blHoverEnterLabel=this.IsInRect([f,d],this.enterLabelRect);this.blHoverExitLabel=this.IsInRect([f,d],this.exitLabelRect);if(true===this.blPreviewMode){this.blHoverResetRect=this.IsInRect([f,d],this.resetRect);return(b!==this.blHoverEnterLabel)||(a!==this.blHoverExitLabel)||(e!==this.blHoverResetRect)}else{if(true===this.blHoldingRegionVertex){this.blCustomizedHintPoints=false;this.callParent([f,d]);this.UpdatePoints();return true}else{g=this.FindNearestVertex(f,d,c);if(this.HoverRegionVertex!==g){this.HoverRegionVertex=g;return true}}if(true===this.blHoldingEnterPoint){this.enterPoint=[f,d];return true}if(true===this.blHoldingExitPoint){this.exitPoint=[f,d];return true}if(true===this.blHoldingEnterHint){this.blCustomizedHintPoints=true;this.enterHintPos=[(f-0.5*this.enterLabelRect[2]).constrain(0,this.panelWidth-this.enterLabelRect[2]),(d-0.5*this.enterLabelRect[3]).constrain(0,this.panelHeight-this.enterLabelRect[3])];return true}if(true===this.blHoldingExitHint){this.blCustomizedHintPoints=true;this.exitHintPos=[(f-0.5*this.exitLabelRect[2]).constrain(0,this.panelWidth-this.exitLabelRect[2]),(d-0.5*this.exitLabelRect[3]).constrain(0,this.panelHeight-this.exitLabelRect[3])];return true}g=this.FindNearestVertex(f,d,[this.enterPoint],100);this.blHoveringEnterPoint=(!g)?false:true;g=this.FindNearestVertex(f,d,[this.exitPoint],100);this.blHoveringExitPoint=(!g)?false:true}return false},MouseUp:function(f,e){if(true===this.blHoldingRegionVertex){this.blHoldingRegionVertex=false;this.callParent([f,e]);this.UpdatePoints();return true}var d=[f,e];var c=this.data;var g=this.centerPoint;var a=this.GetEdges(c);var b=-1;a.forEach(function(k,h){var l=this.GetExtendedLine(g,d,500);var m=this.GetCrossPoint(l,k);if(!m){return}b=h},this);if(0<=b){if(true===this.blHoldingEnterPoint){if(b===this.exitIdx){this.exitIdx=this.enterIdx}if(this.enterIdx!==b){this.enterIdx=b;this.blCustomizedHintPoints=false}}else{if(true===this.blHoldingExitPoint){if(b===this.enterIdx){this.enterIdx=this.exitIdx}if(this.exitIdx!==b){this.exitIdx=b;this.blCustomizedHintPoints=false}}}}this.UpdatePoints();this.blHoldingEnterPoint=false;this.blHoldingExitPoint=false;this.blHoldingEnterHint=false;this.blHoldingExitHint=false},ShouldChgCursorToPointer:function(){var a=(SYNO.SS.App.VideoAnalytics.Def.PeopleModeType.LEAVE!==this.pplAccMode);var b=(SYNO.SS.App.VideoAnalytics.Def.PeopleModeType.ENTER!==this.pplAccMode);return(false===this.blPreviewMode)&&((false===Ext.isEmpty(this.HoverRegionVertex))||(true===a&&true===this.blHoverEnterLabel)||(true===b&&true===this.blHoverExitLabel)||(true===this.blHoveringEnterPoint)||(true===this.blHoveringExitPoint))}});Ext.define("SYNO.SS.App.VideoAnalytics.CanvasWidget.ForbiddenLine",{extend:"SYNO.SS.App.VideoAnalytics.CanvasWidget.Line",strLeftText:"B",strRightText:"A",DIR_INDICATOR_OFFSET:20,constructor:function(a){this.callParent([a])},GetFormData:function(a){return{area_line:this.GetScaledData(a)}},Draw:function(g){if(!this.callParent([g])){return false}var f=this.strRightText;var m=this.strLeftText;var n=this.data;var d=n[0];var l=n[1];var k=[(d[0]+l[0])/2,(d[1]+l[1])/2];var e=this.GetUnitDirectionVector(d,l);var h=this.RotateVector(e,Math.PI/2);var c=this.RotateVector(e,-Math.PI/2);var b=[k[0]+h[0]*this.DIR_INDICATOR_OFFSET,k[1]+h[1]*this.DIR_INDICATOR_OFFSET];var a=[k[0]+c[0]*this.DIR_INDICATOR_OFFSET,k[1]+c[1]*this.DIR_INDICATOR_OFFSET];g.fillStyle="rgba(255, 255, 255, 1)";g.font="bold 15px Verdana";g.textBaseline="middle";g.textAlign="center";g.fillText(f,b[0],b[1]);g.fillText(m,a[0],a[1]);n.forEach(function(o){this.DrawVertex(g,o)},this)},MouseDown:function(d,c,b){if(MOUSE_EVENT_LEFT_BUTTON!==b){return false}var a=this.data;var e=this.FindNearestVertex(d,c,a);if(e){this.draggingVertex=e;return true}return false},MouseMove:function(b,a){if(this.draggingVertex){this.draggingVertex[0]=b;this.draggingVertex[1]=a}else{return false}},MouseUp:function(b,a){this.draggingVertex=null}});Ext.namespace("SYNO.SS.App.VideoAnalytics");Ext.define("SYNO.SS.App.VideoAnalytics.AnalyticsSimulator",{extend:"Ext.Container",DET_LIST_WIDTH:114,DET_LIST_MARGIN:2,def:SYNO.SS.App.VideoAnalytics.Def,videoPanelWidth:SYNO.SS.App.VideoAnalytics.Def.SIMULATE_PANEL_WIDTH,videoPanelHeight:SYNO.SS.App.VideoAnalytics.Def.SIMULATE_PANEL_HEIGHT,numCellPerRow:40,numCellPerCol:30,gridCellWidth:11,gridCellHeight:9,gridOffsetX:0.5,gridOffsetY:0.5,LINE_UPPER_BOUND:3,LINE_LOWER_BOUND:2,REGION_UPPER_BOUND:6,REGION_LOWER_BOUND:4,fldTitleHeight:21,gridStartCell:{},gridEndCell:{},areaType:SYNO.SS.App.VideoAnalytics.Def.AreaSetting.USE_REGION,analyticsType:SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.ZONE_DETECTION,parentWin:null,camId:null,taskId:null,wsPreview:null,panelPlayer:null,canvasObj:null,areaData:null,area_grid:null,det_region:null,det_region_cnt:1,min_obj_size:10,people_size:10,blMouseDown:false,blLeaveCanvas:false,blAddMode:true,blShowTitle:true,blPreviewMode:false,blConstraintDetInterval:false,lastDetTimeStamp:0,minDetInterval:500,lastMouseOffset:null,lastMouseScreen:null,DEFAULT_LINE:[[1/4,2/3],[2/4,1/3],[3/4,2/3]],DEFAULT_PEOPLE_REGION:[[3/10,3/10],[3/10,7/10],[7/10,7/10],[7/10,3/10]],DEFAULT_PEOPLE_HINT_POS:[[9/10,1/10],[9/10,2/10]],DEFAULT_DET_REGION:[[[1/10,1/10],[1/10,9/10],[9/10,9/10],[9/10,1/10]],[[2/10,2/10],[2/10,8/10],[8/10,8/10],[8/10,2/10]],[[3/10,3/10],[3/10,7/10],[7/10,7/10],[7/10,3/10]]],constructor:function(a){this.Init(a);Ext.apply(a,{width:535,height:370,style:"position: relative;",items:[this.panelContainer]});this.callParent([a]);this.RealizeDefaultRegion();this.addListener("beforedestroy",this.DestroyWS,this);this.area_grid="1".repeat(this.numCellPerRow*this.numCellPerCol)},Init:function(a){this.widgets=[];this.canvasId=Ext.id();this.blEditMode=a.blEditMode;this.displayWidth=a.width+this.DET_LIST_WIDTH+this.DET_LIST_MARGIN;this.taskId=(a.blEditMode)?a.parentWin.task.get("id"):0;this.blShowTitle=(undefined!==a.blShowTitle)?a.blShowTitle:true;this.blConstraintDetInterval=this.IsNeedConstrainDetInterval(a.type);this.videoPanelHeight=(this.blShowTitle)?this.videoPanelHeight-this.fldTitleHeight:this.videoPanelHeight;this.panelDetList=new SYNO.SS.App.VideoAnalytics.DetListPanel({hidden:!this.blEditMode,width:this.DET_LIST_WIDTH,height:a.height,parentWin:a.parentWin,style:"margin-left: "+this.DET_LIST_MARGIN+"px;"});this.fldTitle=new SYNO.SS.App.WebPlayer.Banner({hidden:!this.blShowTitle});this.fldTitle.SetTitle(_T("ss_common","common_liveview"));this.ctPlayer=new Ext.Container({width:a.width,height:a.height,html:'<canvas id="'+this.canvasId+'" style="position: absolute; top: 0;"></canvas>',items:[this.fldTitle]});this.ctPreview=new Ext.Container({layout:"hbox",width:this.displayWidth,height:a.height,items:[this.ctPlayer,this.panelDetList]});this.btnPreview=new SYNO.ux.Button({enableToggle:true,hidden:!this.blEditMode,text:_T("video_analytics","save_and_preview"),handler:this.PreSaveAndPreview,scope:this});this.panelContainer=new SYNO.ux.Panel({bodyBorder:false,border:false,width:this.displayWidth,height:370,items:[this.ctPreview,{layout:{type:"hbox",defaultMargins:{top:8,right:10,bottom:0,left:156}},border:false,items:[this.btnPreview]}]})},RealizeDefaultRegion:function(){var a=function(c){c[0]*=this.videoPanelWidth;c[1]*=this.videoPanelHeight};var b=function(c){c.forEach(a,this)};this.defaultLine=SYNO.SDS.Utils.clone(this.DEFAULT_LINE,true);this.defaultPeopleRegion=SYNO.SDS.Utils.clone(this.DEFAULT_PEOPLE_REGION,true);this.defaultPeopleHintPos=SYNO.SDS.Utils.clone(this.DEFAULT_PEOPLE_HINT_POS,true);this.defaultDetRegion=SYNO.SDS.Utils.clone(this.DEFAULT_DET_REGION,true);this.defaultLine.forEach(a,this);this.defaultPeopleRegion.forEach(a,this);this.defaultPeopleHintPos.forEach(a,this);this.defaultDetRegion.forEach(b,this)},Activate:function(){var a=this.parentWin.pageInformation.cmbCamera.getValue();var b=SYNO.SS.GblStore.dsVideoAnalyticsTask.getById(this.taskId);this.LAYER_MAX_X=this.videoPanelWidth-1;this.LAYER_MAX_Y=this.videoPanelHeight-1;this.LAYER_MIN_X=0;this.LAYER_MIN_Y=0;if(!this.canvasObj){this.canvasObj=this.ctPlayer.el.dom.querySelector("canvas#"+this.canvasId);this.canvasObj.width=this.videoPanelWidth;this.canvasObj.height=this.videoPanelHeight;this.canvasObj.style.top=(this.blShowTitle)?this.fldTitleHeight+"px":"0px";this.canvasContext=this.canvasObj.getContext("2d");this.canvasObj.addEventListener("mousedown",this.canvasMouseDown.bind(this));this.canvasObj.addEventListener("mouseup",this.canvasMouseUp.bind(this));this.canvasObj.addEventListener("mousemove",this.canvasMouseMove.bind(this));this.canvasObj.addEventListener("mouseleave",this.canvasMouseLeave.bind(this))}if(!this.blPreviewMode){this.Draw()}if(this.camId!==a){this.camId=a;this.ResetPanelPlayer()}this.panelDetList.Refresh()},Configure:function(c){if(true===this.blPreviewMode){return}var d=SYNO.SS.App.VideoAnalytics.Def;var k=1;var a=0;var e=2;var l=this.defaultLine;var b=this.defaultPeopleRegion;var g=this.defaultPeopleHintPos;var h=this.defaultDetRegion;var f=function(m){return[m[0]*this.videoPanelWidth,m[1]*this.videoPanelHeight]};if(false===Ext.isEmpty(c.min_obj_size)){this.min_obj_size=Number(c.min_obj_size)}if(false===Ext.isEmpty(c.people_size)){this.people_size=Number(c.people_size)}if(false===Ext.isEmpty(c.area_grid)){this.area_grid=c.area_grid}if((false===Ext.isEmpty(c.area_line))&&(true===Ext.isArray(c.area_line))){l=c.area_line.map(f,this)}if(false===Ext.isEmpty(c.det_region_cnt)){k=Number(c.det_region_cnt)}if(false===Ext.isEmpty(c.region_type)){regionType=Number(c.region_type)}if((false===Ext.isEmpty(c.det_region))&&(true===Ext.isArray(c.det_region))){h=c.det_region.map(function(m){return m.map(f,this)},this)}if(false===Ext.isEmpty(c.people_enter)){a=Number(c.people_enter)}if(false===Ext.isEmpty(c.people_exit)){e=Number(c.people_exit)}if((false===Ext.isEmpty(c.people_region))&&(true===Ext.isArray(c.people_region))){b=c.people_region.map(f,this)}if((false===Ext.isEmpty(c.people_hint_pos))&&(true===Ext.isArray(c.people_hint_pos))){g=c.people_hint_pos.map(f,this)}if(false===Ext.isEmpty(c.analyze_type)){this.analyze_type=Number(c.analyze_type);this.widgets.clear();if(true===c.blObjSizeEditor){this.sizeIndicatorWidget=new SYNO.SS.App.VideoAnalytics.CanvasWidget.SizeEditor({owner:this,size:this.min_obj_size,panelWidth:this.videoPanelWidth,panelHeight:this.videoPanelHeight});this.widgets.push(this.sizeIndicatorWidget)}else{if(d.AnalyticsType.OBJECT_TRACKING===this.analyze_type){this.detRegionWidget=new SYNO.SS.App.VideoAnalytics.CanvasWidget.MultiRegion({data:h,regionCnt:k,regionType:regionType,panelWidth:this.videoPanelWidth,panelHeight:this.videoPanelHeight});this.widgets.push(this.detRegionWidget)}else{if(d.AnalyticsType.MOTION_DETECTION===this.analyze_type){this.detRegionWidget=new SYNO.SS.App.VideoAnalytics.CanvasWidget.MultiRegion({data:h,regionCnt:k,regionType:regionType,panelWidth:this.videoPanelWidth,panelHeight:this.videoPanelHeight});this.widgets.push(this.detRegionWidget)}else{if((d.AnalyticsType.FOREIGN_OBJECT===this.analyze_type)||(d.AnalyticsType.MISSING_OBJECT===this.analyze_type)){this.detRegionWidget=new SYNO.SS.App.VideoAnalytics.CanvasWidget.MultiRegion({data:h,regionCnt:k,regionType:regionType,panelWidth:this.videoPanelWidth,panelHeight:this.videoPanelHeight});this.widgets.push(this.detRegionWidget)}else{if(d.AnalyticsType.ZONE_DETECTION===this.analyze_type){this.regionWidget=new SYNO.SS.App.VideoAnalytics.CanvasWidget.MultiRegion({data:h,regionCnt:k,regionType:regionType,panelWidth:this.videoPanelWidth,panelHeight:this.videoPanelHeight});this.widgets.push(this.regionWidget)}else{if(d.AnalyticsType.PEOPLE_COUNTING===this.analyze_type){this.regionWidget=new SYNO.SS.App.VideoAnalytics.CanvasWidget.PplRegion({data:b,enterIdx:a,exitIdx:e,blCustomizedHintPoints:this.blEditMode,enterHintPos:g[0],exitHintPos:g[1],pplAccMode:c.people_mode,panelWidth:this.videoPanelWidth,panelHeight:this.videoPanelHeight});this.widgets.push(this.regionWidget)}}}}}}}this.Draw()},ResetCanvas:function(){if(!this.canvasObj){return}this.canvasContext.clearRect(0,0,this.videoPanelWidth,this.videoPanelHeight);if(false===this.blPreviewMode){this.canvasObj.width=this.videoPanelWidth;this.widgets.forEach(function(a){a.Resize(this.videoPanelWidth,this.videoPanelHeight)},this);this.Draw()}},ResetPanelPlayer:function(){if(this.panelPlayer){this.ctPlayer.remove(this.panelPlayer);this.panelPlayer=null}this.DestroyWS();if(true===this.blPreviewMode){this.wsPreview=new SYNO.SS.App.CameraPreview.LiveviewForm(this.parentWin,{dsId:LOCAL_DS_ID,camId:this.camId,camInfo:SYNO.SS.GblStore.dsCamera.getById(this.camId).data,ivaTaskId:this.taskId,mode:SYNO.SS.App.WebPlayer.Def.PreviewMode.IVA});this.panelPlayer=this.wsPreview.panelPlayer;this.panelPlayer.ShowCamInfoLabel(false);this.panelPlayer.panelVideoAnalytics.EnableDetList(true);this.mon(this.panelPlayer.panelVideoAnalytics,"onUpdateDetList",this.OnUpdateDetList,this);this.mon(this.panelPlayer,"afterrender",function(){this.panelPlayer.setSize(this.videoPanelWidth,this.videoPanelHeight)},this);this.wsPreview.UpdateVideoAnalytics()}else{this.panelPlayer=new SYNO.SS.App.WebPlayer.Html5PlayerPanel({viewType:SYNO.SS.App.WebPlayer.OsdPanelUtils.VIEW_TYPE.BASEVIEW,width:this.videoPanelWidth,height:this.videoPanelHeight,blShowCamInfoLabel:false,blSupportAudio:false,blFocused:false,blSuspendMouseEvent:true,camIdOnHost:this.camId})}this.ctPlayer.add(this.panelPlayer);this.ctPlayer.doLayout()},Draw:function(){if(!this.canvasContext){return}this.canvasContext.clearRect(0,0,this.videoPanelWidth,this.videoPanelHeight);this.widgets.forEach(function(a){a.Draw(this.canvasContext)},this)},DrawGrid:function(c){this.canvasContext.fillStyle="rgba(0, 128, 255, .3)";this.canvasContext.fillRect(0,0,this.videoPanelWidth,this.videoPanelHeight);for(var b=0,a=c.length;b<a;b++){if("0"===c[b]){var d=this.TransferGridIdxToXY(b);this.canvasContext.clearRect(d.x+this.gridOffsetX,d.y+this.gridOffsetY,this.gridCellWidth,this.gridCellHeight)}}},DrawSelectGrid:function(){var b={x:Math.min(this.gridStartCell.x,this.gridEndCell.x),y:Math.min(this.gridStartCell.y,this.gridEndCell.y)};var a={x:Math.max(this.gridStartCell.x,this.gridEndCell.x),y:Math.max(this.gridStartCell.y,this.gridEndCell.y)};b.x=Math.floor(b.x/(2*this.gridOffsetX+this.gridCellWidth))*(2*this.gridOffsetX+this.gridCellWidth);b.y=Math.floor(b.y/(2*this.gridOffsetY+this.gridCellHeight))*(2*this.gridOffsetY+this.gridCellHeight);a.x=Math.ceil(a.x/(2*this.gridOffsetX+this.gridCellWidth))*(2*this.gridOffsetX+this.gridCellWidth);a.y=Math.ceil(a.y/(2*this.gridOffsetY+this.gridCellHeight))*(2*this.gridOffsetY+this.gridCellHeight);this.canvasContext.lineWidth="2";this.canvasContext.strokeStyle="blue";this.canvasContext.strokeRect(b.x,b.y,a.x-b.x,a.y-b.y)},EditGridData:function(){var e={x:Math.min(this.gridStartCell.x,this.gridEndCell.x),y:Math.min(this.gridStartCell.y,this.gridEndCell.y)};var d={x:Math.max(this.gridStartCell.x,this.gridEndCell.x),y:Math.max(this.gridStartCell.y,this.gridEndCell.y)};e.x=Math.min(Math.max(e.x,this.LAYER_MIN_X),this.LAYER_MAX_X);e.y=Math.min(Math.max(e.y,this.LAYER_MIN_X),this.LAYER_MAX_X);d.x=Math.min(Math.max(d.x,this.LAYER_MIN_X),this.LAYER_MAX_X);d.x=Math.min(Math.max(d.x,this.LAYER_MIN_X),this.LAYER_MAX_X);e.x=Math.floor(e.x/(2*this.gridOffsetX+this.gridCellWidth));e.y=Math.floor(e.y/(2*this.gridOffsetY+this.gridCellHeight));d.x=Math.ceil(d.x/(2*this.gridOffsetX+this.gridCellWidth));d.y=Math.ceil(d.y/(2*this.gridOffsetY+this.gridCellHeight));var a=this.areaData.split("");for(var b=e.y;b<d.y;b++){for(var c=e.x;c<d.x;c++){a[b*this.numCellPerRow+c]=(true===this.blAddMode)?"1":"0"}}this.areaData=a.join("");this.area_grid=a.join("")},TransferGridIdxToXY:function(a){var d=a%this.numCellPerRow;var c=Math.floor(a/this.numCellPerRow);var b={x:d*(2*this.gridOffsetX+this.gridCellWidth),y:c*(2*this.gridOffsetY+this.gridCellHeight)};return b},cursorBoundaryCheck:function(a,d,c){var b=SYNO.SS.App.VideoAnalytics.Def.PANEL_MOUSE_MOVEING_MARGIN;d=Math.max(d,b);c=Math.max(c,b);d=Math.min(d,this.canvasObj.width-b);c=Math.min(c,this.canvasObj.height-b);return[d,c]},canvasMouseDown:function(c){var a=SYNO.SS.Utils.GetMouseButtonType(c);var d=c.layerX;var b=c.layerY;this.OnMouseAction(d,b,"Down",a);this.blMouseDown=true},canvasMouseMove:function(b){var c=b.layerX;var a=b.layerY;if(true===this.blLeaveCanvas){this.blLeaveCanvas=false}this.OnMouseAction(c,a,"Move")},canvasMouseUp:function(b){var c=b.layerX;var a=b.layerY;this.OnMouseAction(c,a,"Up");this.blMouseDown=false;document.onmouseup=null;document.onmousemove=null},canvasMouseLeave:function(a){this.lastMouseOffset=[a.offsetX,a.offsetY];this.lastMouseScreen=[a.x,a.y];this.blLeaveCanvas=true;document.onmouseup=this.OnMouseUp.createDelegate(this);document.onmousemove=this.OnMouseMove.createDelegate(this)},OnMouseUp:function(b){if(false===this.blMouseDown){return}var c=this.lastMouseOffset[0]+(b.x-this.lastMouseScreen[0]);var a=this.lastMouseOffset[1]+(b.y-this.lastMouseScreen[1]);this.OnMouseAction(c,a,"Up");this.blMouseDown=false;document.onmouseup=null;document.onmousemove=null},OnMouseMove:function(b){if((false===this.blMouseDown)||(false===this.blLeaveCanvas)){return}var c=this.lastMouseOffset[0]+(b.x-this.lastMouseScreen[0]);var a=this.lastMouseOffset[1]+(b.y-this.lastMouseScreen[1]);this.OnMouseAction(c,a,"Move")},OnMouseAction:function(m,l,h,b){if(true===this.blPreviewMode){return}var a=this.cursorBoundaryCheck(this.canvasObj,m,l);m=a[0];l=a[1];var k=this.widgets;var d=("Down"===h);var g=("Move"===h);var c=("Up"===h);var f=(true===g)&&(true===this.blMouseDown);if(true===d){for(var e=0;e<k.length;e++){if(true===k[e].MouseDown(m,l,b)){this.holdingWidget=k[e];break}}}else{if(true===g){k.forEach(function(n){n.MouseMove(m,l)},this)}else{if(true===c){if(this.holdingWidget){this.holdingWidget.MouseUp(m,l);this.holdingWidget=null}}else{if(true===f){if(this.holdingWidget){this.holdingWidget.MouseMove(m,l)}}}}}this.ChgCursorStyle(k);this.Draw()},GetDetectAreas:function(a){var b={};this.widgets.forEach(function(c){Ext.apply(b,c.GetFormData(a))},this);return b},IsNeedConstrainDetInterval:function(a){return !(SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.PEOPLE_COUNTING===a)},PreSaveAndPreview:function(c){var b=SYNO.SS.GblStore.dsVideoAnalyticsTask.getById(this.taskId);var a;if(b){if(true===b.get("enable")){this.OnSaveAndPreivew(c)}else{a=this.parentWin.getMsgBox();a.confirm(_T("ss_common","video_analytics"),_T("video_analytics","simulator_preview_hint"),this.OnSaveAndPreviewConfirm,this)}}},OnSaveAndPreviewConfirm:function(b,d,a,c){if("yes"===b){this.parentWin.pageSetting.hiddenEnable.setValue(true);this.OnSaveAndPreivew(this.btnPreview)}else{this.btnPreview.toggle(false)}},OnSaveAndPreivew:function(a){this.blPreviewMode=a.pressed;if(true===this.blPreviewMode){this.parentWin.setStatusBarBusy({text:_T("ss_common","common_saving")});this.mon(SYNO.SS.GblStore.dsVideoAnalyticsTask,"storeupdate",this.RefreshSimulator,this,{single:true});this.parentWin.OnSave();this.panelDetList.Refresh();this.panelDetList.bottombar.SetRecCount(0);a.setText(_T("camera","camera_stop_preview"));a.ownerCt.doLayout()}else{a.setText(_T("video_analytics","save_and_preview"));a.ownerCt.doLayout();this.RefreshSimulator()}},RefreshSimulator:function(){this.parentWin.clearStatusBusy();this.fireEvent("changePreviewStatus",this.blPreviewMode);this.ResetPanelPlayer();this.ResetCanvas()},OnUpdateDetList:function(b,c){if(false===this.blPreviewMode){return}if(this.camId!==c.camId||this.taskId!==c.taskId){return}if(true===this.blConstraintDetInterval){var a=GetCurrentTimeMs();if(a-this.lastDetTimeStamp<this.minDetInterval){return}else{this.lastDetTimeStamp=a}}this.panelDetList.AddRecord(b,c)},ResetSimulator:function(){this.parentWin.pageSetting.InitSimulator()},DestroyWS:function(){if(this.wsPreview){this.wsPreview.DestroyWS();this.wsPreview.destroy()}},ChgCursorStyle:function(a){var b=false;a.forEach(function(c){if(true===c.ShouldChgCursorToPointer()){b=true;return false}},this);if(true===b){this.canvasObj.style.cursor="pointer"}else{this.canvasObj.style.cursor=""}}});Ext.define("SYNO.SS.App.VideoAnalytics.DetListPanel",{extend:"SYNO.ux.Panel",MAX_NUMBER:20,recordCnt:0,constructor:function(a){this.Init(a);Ext.apply(a,{items:[this.alertPanel]});this.callParent([a])},Init:function(a){this.dsDetResult=this.GetStore(a.parentWin);this.Detlist=new SYNO.SS.App.VideoAnalytics.DetListExpandableView({store:this.dsDetResult,width:this.DET_LIST_WIDTH,height:50,fnPlay:this.OnPlay.createDelegate(this),playIconOnPreview:true,emptyStyleMonStore:this.dsDetResult,emptyStyleTip:" ",emptyStyleCls:"det_empty_style",blExtraListeners:true,fnNeedApplyEmptyStyle:function(){return(0===this.store.getCount())}});this.bottombar=new SYNO.SS.App.VideoAnalytics.BottomBar({});this.panelGridContainer=new SYNO.SS.Pgls.PglsGridContainerPanel({blbbar:false,showTotalCnt:false,bbar:this.bottombar,grid:this.Detlist});this.ctBanner=new SYNO.SS.App.WebPlayer.Banner({});this.ctBanner.SetTitle(_T("camera","detection"));this.alertPanel=new SYNO.ux.Panel({bodyBorder:false,style:"margin-top: 0px;",layout:"fit",width:this.DET_LIST_WIDTH,height:a.height,tbar:this.ctBanner,defaults:{border:false},items:[this.panelGridContainer]})},AddRecord:function(b,c){if(this.MAX_NUMBER<=this.dsDetResult.getCount()){for(var a=this.MAX_NUMBER-1;a<this.dsDetResult.getCount();a++){this.dsDetResult.removeAt(a)}}this.dsDetResult.addSorted(new Ext.data.Record({id:this.recordCnt,snapshot:b.medium,snapshotSmall:b.small,taskId:c.taskId,width:c.imgWidth,height:c.imgHeight,result:c.result}));this.recordCnt+=1;this.bottombar.SetRecCount(this.dsDetResult.getCount())},GetStore:function(b){var a=[{name:"id"}];return new Ext.data.JsonStore({root:"detList",idProperty:"id",fields:a,autoDestroy:true,sortInfo:{field:"id",direction:"DESC"}})},Refresh:function(){this.dsDetResult.removeAll()},OnPlay:function(a){var b=new SYNO.SS.App.VideoAnalytics.DetResultViewer({blShowSizeHint:this.IsNeedShowObjSizeHint(a),record:a});b.show()},IsNeedShowObjSizeHint:function(a){var d=SYNO.SS.App.VideoAnalytics.Def;var b=SYNO.SS.GblStore.dsVideoAnalyticsTask.getById(a.get("taskId"));if(b){var c=b.get("analyze_type");return((d.AnalyticsType.MOTION_DETECTION===c)||(d.AnalyticsType.FOREIGN_OBJECT===c)||(d.AnalyticsType.MISSING_OBJECT===c))}return false}});Ext.define("SYNO.SS.App.VideoAnalytics.BottomBar",{extend:"Ext.Toolbar",count:0,constructor:function(a){this.labelText=new Ext.form.Label({text:("string"===typeof a.text)?a.text:"",style:"line-height: 27px"});this.labelItemCnt=new Ext.form.Label({text:"0",style:"line-height: 27px; padding-right: 2px; color: #0079BC;"});this.labelItemCntTxt=new Ext.form.Label({text:" "+_T("ss_common","items"),style:"line-height: 27px; padding-right: 4px"});Ext.apply(a,{ctCls:"iva_det_bbar",cls:("string"===typeof a.cls)?"pgls-bbar "+a.cls:"pgls-bbar",style:"border: 1px solid #D4D4D4; border-top-width: 0px; border-bottom-width: 0px;",items:[this.labelText,"->",this.labelItemCnt,this.labelItemCntTxt]});this.callParent(arguments)},SetRecCount:function(a){this.count=a;this.labelItemCnt.setText(this.count.toString())}});Ext.define("SYNO.SS.App.VideoAnalytics.DetListExpandableView",{extend:"SYNO.ux.ExpandableIconView",owner:null,constructor:function(a){this.owner=a.owner;var b=Ext.apply({cls:"iva_list_iconview",iconTpl:new Ext.XTemplate("{#:this.RenderIconTpl}"),descTpl:new Ext.XTemplate("{camera_name:this.RenderDescTpl}"),playMaskTpl:new Ext.XTemplate("{#:this.RenderMask}")},a);this.callParent([b]);this.AddTplRenderer()},AddTplRenderer:function(){this.tpl.owner=this.owner;this.tpl.CLS_PREVIEW=this.CLS_PREVIEW;this.tpl.CLS_RECT=this.CLS_RECT;this.tpl.CLS_PLAY_ICON_MASK=this.CLS_PLAY_ICON_MASK;this.tpl.CLS_SNAPSHOT_WIMG=this.CLS_SNAPSHOT_WIMG;this.tpl.CLS_SNAPSHOT_WIMG_BG=this.CLS_SNAPSHOT_WIMG_BG;this.tpl.RenderIconTpl=function(e,a){var f=a.id;var d=SYNO.SS.MultiView.ICON_VIEW_IDX;var c=SYNO.SS.CameraPage.IMG_DISABLED[d];var b=a.snapshotSmall||a.snapshot||c;return String.format('<img src={0} class="{1} {2} {3}">',b,this.CLS_PREVIEW,this.CLS_RECT,(IS_IE10_MINUS_BROWSER?this.CLS_PLAY_ICON_MASK:""))};this.tpl.RenderDescTpl=function(b,a){return""};this.tpl.RenderMask=function(b,a){return SYNO.SS.Utils.CreateHtml({cls:"play-icon-mask",children:{cls:"play-icon-active-zone",children:{cls:"play-icon-img"}}})}}});Ext.define("SYNO.SS.App.VideoAnalytics.DetResultViewer",{extend:"SYNO.SDS.BaseWindow",WIDTH:580,HEIGHT:440,IMAGE_WIDTH:540,IMAGE_HEIGHT:345,HINT_WIDTH:60,HINT_HEIGHT:20,HINT_MARGIN:3,blShowSizeHint:false,constructor:function(a){this.Init(a);Ext.apply(a,{title:_T("video_analytics","detection_results"),layout:"fit",items:this.panelContainer,width:this.WIDTH,height:this.HEIGHT,minimizable:false,buttons:[this.btnClose]});this.callParent([a]);this.LoadImage(a.record)},Init:function(a){this.canvasId=Ext.id();this.blShowSizeHint=a.blShowSizeHint;this.panelSnapshot=new SYNO.ux.Panel({cls:SYNO.SS.Utils.GetVdoBgCls(),width:this.IMAGE_WIDTH,height:this.IMAGE_HEIGHT,html:'<canvas id="'+this.canvasId+'"></canvas>'});this.panelContainer=new SYNO.ux.Panel({layout:"vbox",defautls:{border:false},items:[this.panelSnapshot]});this.btnClose=new SYNO.ux.Button({text:_T("ss_common","close"),handler:this.close,scope:this})},LoadImage:function(c){var f=new Image();var e=document.getElementById(this.canvasId);var b=e.getContext("2d");f.src=c.get("snapshot");e.width=this.IMAGE_WIDTH;e.height=this.IMAGE_HEIGHT;var a=function(){b.drawImage(f,0,0,this.IMAGE_WIDTH,this.IMAGE_HEIGHT);this.DrawSizeHint(c)}.createDelegate(this);var d=SYNO.SS.Utils.AsyncImageLoad(c.get("snapshot"),a,Ext.emptyFn,10)},DrawSizeHint:function(b){if(false===this.blShowSizeHint){return}var g=[];var f=b.get("result");var e=document.getElementById(this.canvasId);var a=e.getContext("2d");var d=this.IMAGE_WIDTH/b.get("width");var h=this.IMAGE_HEIGHT/b.get("height");g=f.map(function(k){if(SYNO.SS.App.VideoAnalytics.Def.ResultType.POLYGON===k.type){return k.vertexs.map(function(l){return[l.x*d,l.y*h]})}else{return[]}},this);var c=new SYNO.SS.App.VideoAnalytics.CanvasWidget.SizeIndicator({data:g,DoDrawRect:Ext.emptyFn,panelWidth:this.IMAGE_WIDTH,panelHeight:this.IMAGE_HEIGHT});c.Draw(a);this.SetToolTips(g)},SetToolTips:function(a){a.forEach(function(e){var c=e[0][0];var h=e[0][1];var b=e[1][0]-e[0][0];var g=e[2][1]-e[0][1];var f=SYNO.SS.App.VideoAnalytics.Utils.CorrectObjSize(100*b*g/(this.IMAGE_WIDTH*this.IMAGE_HEIGHT));var d=_T("camera","camera_event_objsize")+":"+f+"%";this.panelSnapshot.add(new Ext.Component({style:String.format("position:absolute; left: {0}px; top: {1}px; width: {2}px; height:{3}px;",c,h,b,g),listeners:{afterrender:function(k){k.getEl().dom.setAttribute("ext:qtip",d)}}}))},this);this.panelSnapshot.doLayout()}});Ext.namespace("SYNO.SS.App.VideoAnalytics");Ext.define("SYNO.SS.App.VideoAnalytics.Setting",{extend:"SYNO.SDS.Utils.FormPanel",config:null,videoPanelWidth:SYNO.SS.App.VideoAnalytics.Def.SIMULATE_PANEL_WIDTH,videoPanelHeight:SYNO.SS.App.VideoAnalytics.Def.SIMULATE_PANEL_HEIGHT,COMBO_WIDTH:305,COMBO_WITH_TIPS_WIDTH:280,OBJSIZE_OPTION_WIDTH:150,CHKBOX_HEIGHT:28,SIDE_WIDTH:325,marginBottomCmb:12,NO_IDLE_ZONE_CMB_VAL:0,MISSING_OBJECT_CMB_VAL:1,FOREIGN_OBJECT_CMB_VAL:2,ENTER_REGION_CMB_VAL:3,LEAVE_REGION_CMB_VAL:4,CLOCKWISE_CROSSING_CMB_VAL:0,CNTR_CLOCKWISE_CROSSINIG_CMB_VAL:1,MOTION_DETECTED_CMB_VAL:0,PEOPLE_COUNTED_CMB_VAL:0,INDOOR_CROWDED_CMB_VAL:1,OBJECT_DETECTION_CMB_VAL_DUMMY:0,panelContainer:null,pageInfo:null,constructor:function(a){this.config=a;this.Init();Ext.apply(a,{trackResetOnLoad:true,style:(true===this.config.blEditMode)?"margin-left: 10px;":"",title:_T("ss_common","setting"),items:this.panelContainer,listeners:{activate:this.Activate,scope:this}});this.callParent([a])},Init:function(){var d=SYNO.SS.App.VideoAnalytics.Def;var b=640;var l=400;var g=function(o,n){return{xtype:"container",style:"padding: 2px 0px 2px 0px",items:[{xtype:"label",text:o,listeners:{afterrender:function(p){SYNO.SS.Utils.AddTip(p.getEl(),n)},scope:this}}]}};this.marginBottomCmb=(IS_IE_BROWSER)?6:12;this.cmbRegionType=new SYNO.ux.ComboBox({name:"region_type",style:"margin-bottom: 4px;",width:this.COMBO_WIDTH,store:new Ext.data.ArrayStore({autoDestroy:true,data:SYNO.SS.App.VideoAnalytics.Def.RegionTypeUI,fields:["type","text"]}),valueField:"type",displayField:"text",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,value:SYNO.SS.App.VideoAnalytics.Def.RegionType.INCLUDE_REGION,listeners:{select:function(n){this.ConfigureSimulator()},scope:this}});this.ctRegionType=new Ext.Container({items:[{xtype:"syno_displayfield",value:_T("video_analytics","region_type")},this.cmbRegionType]});this.cmbRegionCnt=new SYNO.ux.ComboBox({name:"det_region_cnt",style:"margin-bottom: 4px;",width:this.COMBO_WIDTH,store:new Ext.data.ArrayStore({autoDestroy:true,data:SYNO.SS.App.VideoAnalytics.Def.RegionCnt,fields:[{name:"regionCnt"}]}),valueField:"regionCnt",displayField:"regionCnt",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,value:1,listeners:{select:function(n){this.ConfigureSimulator()},scope:this}});this.ctRegionCnt=new Ext.Container({items:[{xtype:"syno_displayfield",value:_T("video_analytics","region_count")},this.cmbRegionCnt]});this.InitDsBgEvents();this.fieldIgnoreBgEvents=new SYNO.SS.Form.MultiSelectField({store:this.dsBgEvents,style:"margin-bottom: 4px;",width:this.COMBO_WIDTH,editable:false,allowBlank:false,allowNoSelection:true,msgTarget:"title",strAllItems:_T("video_analytics","all_background_events"),strNoneItem:_T("ss_common","common_disable"),valueField:"type",displayField:"text",bitValue:d.BgEventType.ALL,listeners:{afterrender:function(n){this.SetFieldBitValue(n,d.BgEventType.NONE)},scope:this}});this.ctIgnoreBgEvents=new Ext.Container({items:[g(_T("video_analytics","ignore_background_events"),_T("video_analytics","ignore_bg_events_tip")),this.fieldIgnoreBgEvents]});this.InitDsBgObjs();this.fieldIgnoreBgObjs=new SYNO.SS.Form.MultiSelectField({store:this.dsBgObjs,style:"margin-bottom: 4px;",width:this.COMBO_WIDTH,editable:false,allowBlank:false,allowNoSelection:true,msgTarget:"title",strAllItems:_T("video_analytics","all_background_objects"),strNoneItem:_T("ss_common","common_disable"),valueField:"type",displayField:"text",bitValue:d.DetectedObjType.NONE,listeners:{afterrender:function(n){this.SetFieldBitValue(n,d.DetectedObjType.NONE)},scope:this}});this.ctIgnoreBgObjs=new Ext.Container({items:[g(_T("video_analytics","ignore_background_objects"),_T("video_analytics","ignore_bg_objects_tip")),this.fieldIgnoreBgObjs]});this.InitDsFgObjs();this.fieldFgObjs=new SYNO.SS.Form.MultiSelectField({store:this.dsfgObjs,style:"margin-bottom: 4px;",width:this.COMBO_WIDTH,editable:false,allowBlank:false,allowNoSelection:false,msgTarget:"title",strAllItems:_T("video_analytics","all_objects"),valueField:"type",displayField:"text",bitValue:d.DetectedObjType.ALL,listeners:{afterrender:function(n){this.SetFieldBitValue(n,d.DetectedObjType.ALL)},scope:this}});this.ctFgObjs=new Ext.Container({items:[{xtype:"syno_displayfield",value:_T("video_analytics","detected_objects")},this.fieldFgObjs]});this.cmbPeopleMode=new SYNO.ux.ComboBox({name:"people_mode",width:this.COMBO_WIDTH,style:"margin-bottom: 4px;",store:new Ext.data.ArrayStore({autoDestroy:true,data:SYNO.SS.App.VideoAnalytics.Def.PeopleMode,fields:["type","text"]}),valueField:"type",displayField:"text",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,value:0,listeners:{select:function(n){this.ConfigureSimulator();this.ctPeopleEventSetting.setVisible((d.PeopleModeType.ENTER_AND_LEAVE===this.cmbPeopleMode.getValue()))},scope:this}});this.ctPeopleMode=new Ext.Container({items:[{xtype:"syno_displayfield",value:_T("video_analytics","accumulative_mode")},this.cmbPeopleMode]});this.chkEnableStayMax=new SYNO.ux.Checkbox({name:"people_enable_stay_max",boxLabel:_T("camera","camera_event_threshold")+"("+_T("video_analytics","number_of_people")+")",style:"margin-bottom: 4px;",width:200,listeners:{check:function(o,n){this.fldPeopleStayMax.setDisabled(!n)},scope:this}});var c=String.format(_T("event_detection","enter_value_between"),1,1000);this.fldPeopleStayMax=new SYNO.ux.TextField({name:"people_stay_max",style:"position: absolute",hideLabel:true,width:80,maxLength:4,disabled:true,allowBlank:false,value:100,vtype:"integer",invalidText:c,listeners:{afterrender:function(n){SYNO.SS.Utils.AddTip(n.getEl(),c,278,-2)}},validator:function(o){var n=parseInt(o,10);if((0>=n)||(1000<n)){return false}return true},validateOnBlur:true,validationEvent:"blur",scope:this});this.ctPeopleStayMax=new Ext.Container({layout:{type:"hbox"},items:[this.chkEnableStayMax,this.fldPeopleStayMax]});this.ctPeopleEventSetting=new Ext.Container({items:[g(_T("video_analytics","crowded_detection"),_T("video_analytics","crowed_detection_tips")),this.ctPeopleStayMax]});this.InitDsSensitivity();this.cmbAnalyticsSensitivity=new SYNO.ux.ComboBox({name:"sensitivity",store:this.dsSensitivity,valueField:"type",displayField:"text",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,value:SYNO.SS.App.VideoAnalytics.Def.Sensitivity.MEDIUM});this.ctSensitivity=new Ext.Container({items:[{xtype:"syno_displayfield",value:_T("liveview_analytics","sensitivity")},this.cmbAnalyticsSensitivity]});var m=String.format(_T("event_detection","enter_value_between"),5,60);this.fieldMinDuration=new SYNO.ux.TextField({name:"min_duration",hideLabel:true,width:this.COMBO_WIDTH,maxLength:2,value:10,allowBlank:false,vtype:"integer",validateOnBlur:true,validationEvent:"blur",validator:function(o){var n=parseInt(o,10);if((5>n)||(60<n)){return false}return true},invalidText:m});this.ctObjMinDuration=new Ext.Container({items:[g(_T("camera","minimum_duration")+" ("+_T("ss_common","common_second")+")",m),this.fieldMinDuration],listeners:{}});this.chkMinObjSizeOption=new SYNO.ux.Checkbox({name:"min_obj_size_option",style:"margin-bottom: 4px;",boxLabel:_T("video_analytics","minimum_object_size"),SetSize:function(n){this.boxlabelEl.dom.innerHTML='<span style="font-size: 12px;">'+_T("video_analytics","minimum_object_size")+": "+n.toString()+"%</span>"},listeners:{afterrender:function(){this.SetSize(1)}}});this.btnMinObjSizeEdit=new SYNO.ux.Button({disabled:true,text:_T("ss_common","common_edit"),handler:this.OnEditObjSize,scope:this});this.ctObjMinSize=new Ext.Container({items:[{xtype:"syno_displayfield",value:_T("video_analytics","object_size_limit")},{xtype:"syno_toolbar",width:313,items:[this.chkMinObjSizeOption,{xtype:"tbfill"},this.btnMinObjSizeEdit]}]});this.chkMinObjSizeOption.on("check",function(n,o){this.btnMinObjSizeEdit.setDisabled(!o)},this);this.cmbPeopleSize=new SYNO.ux.ComboBox({name:"people_size",store:new Ext.data.ArrayStore({autoDestroy:true,data:SYNO.SS.App.VideoAnalytics.Def.PeopleSize,fields:[{name:"peopleSize"}]}),valueField:"peopleSize",displayField:"peopleSize",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,value:5,listeners:{select:function(n){this.ConfigureSimulator()},scope:this}});this.ctPeopleSize=new Ext.Container({items:[{xtype:"syno_displayfield",value:_T("video_analytics","people_size")},this.cmbPeopleSize]});this.fieldPeopleCnt=new SYNO.ux.TextField({name:"people_cnt",hideLabel:true,width:this.COMBO_WIDTH,maxLength:6,value:10,allowBlank:false,vtype:"integer",validateOnBlur:true,validationEvent:"blur",validator:function(o){var n=parseInt(o,10);if((1>n)||(999999<n)){return false}return true},invalidText:String.format(_T("event_detection","enter_value_between"),1,999999)});this.ctPeopleCnt=new Ext.Container({items:[{xtype:"syno_displayfield",value:_T("video_analytics","trigger_people_cnt")+SYNO.SS.Utils.GenTipHtml(_T("video_analytics","trigger_cnt_desc"),0)},this.fieldPeopleCnt]});this.cmbResetFreq=new SYNO.ux.ComboBox({style:"margin-bottom: 4px;",width:this.COMBO_WIDTH,name:"reset_cnt_frequency",store:new Ext.data.ArrayStore({autoDestroy:true,data:SYNO.SS.App.VideoAnalytics.Def.CountingResetFrequency,fields:["frequency","text"]}),valueField:"frequency",displayField:"text",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,value:SYNO.SS.App.VideoAnalytics.Def.Frequency.DAILY,listeners:{select:function(o,n){this.ctPeopleResetCnt.updateContent.call(this)},scope:this}});this.cmbWeekDays=new SYNO.ux.ComboBox({name:"reset_weekday",style:"margin-bottom: 4px;",width:this.COMBO_WIDTH,hidden:true,store:new Ext.data.ArrayStore({autoDestroy:true,data:[[0,_T("extlang","sunday")],[1,_T("extlang","monday")],[2,_T("extlang","tuesday")],[3,_T("extlang","wednesday")],[4,_T("extlang","thursday")],[5,_T("extlang","friday")],[6,_T("extlang","saturday")]],fields:["weekday","text"]}),valueField:"weekday",displayField:"text",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,value:0});var e=[];var h,a;for(i=1;i<=27;i++){switch(i%10){case 1:a="st";break;case 2:a="nd";break;case 3:a="rd";break;default:a="th";break}h=String.format("{0}{1}",i,a);e.push([i,h])}e.push([28,"The last day"]);this.cmbDate=new SYNO.ux.ComboBox({name:"reset_date",style:"margin-bottom: 4px;",width:this.COMBO_WIDTH,hidden:true,hideLabel:true,width:this.COMBO_WIDTH,store:new Ext.data.ArrayStore({autoDestroy:true,fields:["dateId","dateText"],data:e}),value:1,valueField:"dateId",displayField:"dateText",mode:"local",editable:false,forceSelection:true,triggerAction:"all"});var f=[];for(i=0;i<24;i++){f.push([i,SYNO.SDS.Utils.Pad(i,2)])}this.cmbTimeHour=new SYNO.ux.ComboBox({name:"reset_time_hour",hideLabel:true,width:146,store:new Ext.data.ArrayStore({autoDestroy:true,fields:["hourId","hourText"],data:f}),valueField:"hourId",displayField:"hourText",value:0,mode:"local",editable:false,forceSelection:true,triggerAction:"all"});var k=[];for(i=0;i<60;i++){k.push([i,SYNO.SDS.Utils.Pad(i,2)])}this.cmbTimeMinute=new SYNO.ux.ComboBox({name:"reset_time_minute",hideLabel:true,width:145,store:new Ext.data.ArrayStore({autoDestroy:true,fields:["minuteId","minuteText"],data:k}),valueField:"minuteId",displayField:"minuteText",value:0,mode:"local",editable:false,forceSelection:true,triggerAction:"all"});this.ctResetTime=new Ext.Container({layout:{type:"hbox"},items:[this.cmbTimeHour,{xtype:"label",width:14,cls:"colon_txt_label",text:":"},this.cmbTimeMinute]});this.ctPeopleResetCnt=new Ext.Container({style:"margin-bottom: 4px;",items:[{xtype:"syno_displayfield",value:_T("video_analytics","reset_people_count")},this.cmbResetFreq,this.cmbWeekDays,this.cmbDate,this.ctResetTime],updateContent:function(){var n=this.cmbResetFreq.value;this.cmbWeekDays.hide();this.cmbDate.hide();switch(n){case SYNO.SS.App.VideoAnalytics.Def.Frequency.WEEKLY:this.cmbWeekDays.show();break;case SYNO.SS.App.VideoAnalytics.Def.Frequency.MONTHLY:this.cmbDate.show();break;default:break}},listeners:{show:function(){this.ctPeopleResetCnt.updateContent.call(this)},scope:this}});this.fieldPeopleDisplayInfo=new SYNO.SS.Form.MultiSelectField({store:new Ext.data.ArrayStore({autoDestroy:true,fields:["type","text"],data:SYNO.SS.App.VideoAnalytics.Def.PeopleDisplayInfo}),width:this.COMBO_WIDTH,editable:false,allowBlank:false,allowNoSelection:true,msgTarget:"title",strAllItems:_T("notification","show_all"),strNoneItem:_T("ss_common","common_none"),valueField:"type",displayField:"text",listeners:{afterrender:function(n){this.SetFieldBitValue(n,d.DisplayInfoType.HINT_WHEN_PASS)},scope:this}});this.ctPeopleDisplayInfo=new Ext.Container({style:"margin-bottom: 4px;",items:[{xtype:"syno_displayfield",value:_T("video_analytics","display_information")},this.fieldPeopleDisplayInfo]});this.fieldNormalDisplayInfo=new SYNO.SS.Form.MultiSelectField({store:new Ext.data.ArrayStore({autoDestroy:true,fields:["type","text"],data:SYNO.SS.App.VideoAnalytics.Def.NormalDisplayInfo}),width:this.COMBO_WIDTH,editable:false,allowBlank:false,allowNoSelection:true,msgTarget:"title",strAllItems:_T("notification","show_all"),strNoneItem:_T("ss_common","common_none"),valueField:"type",displayField:"text",listeners:{afterrender:function(n){this.SetFieldBitValue(n,d.DisplayInfoType.NONE)},scope:this}});this.ctNormalDisplayInfo=new Ext.Container({style:"margin-bottom: 4px;",items:[{xtype:"syno_displayfield",value:_T("video_analytics","display_information")},this.fieldNormalDisplayInfo]});this.InitHiddenForm();this.panelSide=new SYNO.ux.Panel({width:this.SIDE_WIDTH,height:l,layout:"form",items:[this.ctHidden,this.ctRegionType,this.ctRegionCnt,this.ctObjMinSize,this.ctIgnoreBgEvents,this.ctIgnoreBgObjs,this.ctFgObjs,this.ctPeopleMode,this.ctSensitivity,this.ctObjMinDuration,this.ctPeopleResetCnt,this.ctPeopleDisplayInfo,this.ctNormalDisplayInfo,this.ctPeopleEventSetting]});this.panelSimulator=new SYNO.SS.App.VideoAnalytics.AnalyticsSimulator({parentWin:this.config.parentWin,width:this.videoPanelWidth,height:this.videoPanelHeight,type:this.GetAnalyzeType(),blEditMode:this.config.blEditMode,listeners:{changePreviewStatus:function(n){this.cmbRegionType.setDisabled(n);this.cmbRegionCnt.setDisabled(n);this.fieldIgnoreBgEvents.setDisabled(n);this.fieldIgnoreBgObjs.setDisabled(n);this.fieldFgObjs.setDisabled(n);this.cmbPeopleMode.setDisabled(n);this.chkEnableStayMax.setDisabled(n);this.fldPeopleStayMax.setDisabled(!this.chkEnableStayMax.checked||n);this.cmbAnalyticsSensitivity.setDisabled(n);this.fieldMinDuration.setDisabled(n);this.chkMinObjSizeOption.setDisabled(n);this.btnMinObjSizeEdit.setDisabled(!this.chkMinObjSizeOption.checked||n);this.cmbPeopleSize.setDisabled(n);this.cmbResetFreq.setDisabled(n);this.cmbWeekDays.setDisabled(n);this.cmbDate.setDisabled(n);this.cmbTimeHour.setDisabled(n);this.cmbTimeMinute.setDisabled(n);this.fieldPeopleDisplayInfo.setDisabled(n);this.fieldNormalDisplayInfo.setDisabled(n)},scope:this}});this.panelContainer=new SYNO.ux.Panel({layout:"hbox",defautls:{border:false},height:l,items:[this.panelSide,this.panelSimulator]})},InitDsBgEvents:function(){var a=SYNO.SS.App.VideoAnalytics.Def;this.dsBgEvents=new Ext.data.ArrayStore({autoDestroy:true,fields:["type","text"],data:a.BgEvent})},InitDsBgObjs:function(){var a=SYNO.SS.App.VideoAnalytics.Def;this.dsBgObjs=new Ext.data.ArrayStore({autoDestroy:true,fields:["type","text"],data:a.DetectedObj})},InitDsFgObjs:function(){var a=SYNO.SS.App.VideoAnalytics.Def;this.dsfgObjs=new Ext.data.ArrayStore({autoDestroy:true,fields:["type","text"],data:a.DetectedObj})},InitDsSensitivity:function(){this.dsSensitivity=new Ext.data.ArrayStore({autoDestroy:true,fields:["type","text"],data:[[SYNO.SS.App.VideoAnalytics.Def.Sensitivity.HIGH,_T("liveview_analytics","sensitivity_high")],[SYNO.SS.App.VideoAnalytics.Def.Sensitivity.MEDIUM,_T("liveview_analytics","sensitivity_medium")],[SYNO.SS.App.VideoAnalytics.Def.Sensitivity.LOW,_T("liveview_analytics","sensitivity_low")]]})},InitHiddenForm:function(){this.hiddenAnalyzeType=new Ext.form.Hidden({name:"analyze_type",value:SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.MOTION_DETECTION});this.hiddenEnable=new Ext.form.Hidden({name:"enable",value:true,getValue:function(){return this.value}});this.hiddenGrid=new Ext.form.Hidden({name:"area_grid",value:"1".repeat(this.numCellPerRow*this.numCellPerCol)});this.hiddenLine=new Ext.form.Hidden({name:"area_line",value:[[0.25,0.6],[0.75,0.6]]});this.hiddenRegion=new Ext.form.Hidden({name:"area_region",value:[[0.25,0.333],[0.25,0.667],[0.5,0.833],[0.75,0.667],[0.75,0.333],[0.5,0.167]]});this.hiddenPeopleEnter=new Ext.form.Hidden({name:"people_enter",value:0});this.hiddenPeopleExit=new Ext.form.Hidden({name:"people_exit",value:2});this.hiddenPeopleRegion=new Ext.form.Hidden({name:"people_region",value:[[0.3,0.3],[0.3,0.7],[0.7,0.7],[0.7,0.3]]});this.hiddenPeopleHintPos=new Ext.form.Hidden({name:"people_hint_pos",value:[[0.9,0.1],[0.9,0.2]]});this.hiddenDetRegion=new Ext.form.Hidden({name:"det_region",value:[[[0.1,0.1],[0.1,0.9],[0.9,0.9],[0.9,0.1]],[[0.2,0.2],[0.2,0.8],[0.8,0.8],[0.8,0.2]],[[0.3,0.3],[0.3,0.7],[0.7,0.7],[0.7,0.3]]]});this.hiddenMinObjSize=new Ext.form.Hidden({name:"min_obj_size",value:1,isDirty:function(){return(this.getValue()===SYNO.SS.App.VideoAnalytics.Utils.CorrectObjSize(this.originalValue))}});this.ctHidden=new Ext.Container({hidden:true,items:[this.hiddenAnalyzeType,this.hiddenEnable,this.hiddenGrid,this.hiddenLine,this.hiddenRegion,this.hiddenDetRegion,this.hiddenPeopleEnter,this.hiddenPeopleExit,this.hiddenPeopleRegion,this.hiddenPeopleHintPos,this.hiddenMinObjSize]})},Activate:function(){this.UpdElmHiddenSts();this.ConfigureSimulator();this.panelSimulator.Activate()},SetSaveHint:function(){this.parent.SetSaveHint()},CheckFormValid:function(){return true},OnCommit:function(){var a=this.panelSimulator.GetDetectAreas(true);if(true===Ext.isDefined(a.area_grid)){this.hiddenGrid.setValue(a.area_grid)}if(true===Ext.isDefined(a.area_line)){this.hiddenLine.setValue(a.area_line)}if(true===Ext.isDefined(a.area_region)){this.hiddenRegion.setValue(a.area_region)}if(true===Ext.isDefined(a.people_enter)){this.hiddenPeopleEnter.setValue(a.people_enter)}if(true===Ext.isDefined(a.people_exit)){this.hiddenPeopleExit.setValue(a.people_exit)}if(true===Ext.isDefined(a.people_region)){this.hiddenPeopleRegion.setValue(a.people_region)}if(true===Ext.isDefined(a.people_hint_pos)){this.hiddenPeopleHintPos.setValue(a.people_hint_pos)}if(true===Ext.isDefined(a.det_region)){this.hiddenDetRegion.setValue(a.det_region)}this.getForm().items.each(function(b){b.initValue()})},ResetSetting:function(){this.getForm().reset()},IsDirty:function(){var a=this.getForm().isDirty();var b=this.panelSimulator.GetDetectAreas(true);if(true===Ext.isDefined(b.area_grid)){a=a||(this.hiddenGrid.getValue()!==b.area_grid)}if(true===Ext.isDefined(b.area_line)){a=a||(this.hiddenLine.getValue()!==b.area_line)}if(true===Ext.isDefined(b.area_region)){a=a||(this.hiddenRegion.getValue()!==b.area_region)}if(true===Ext.isDefined(b.people_enter)){a=a||(Number(this.hiddenPeopleEnter.getValue())!==b.people_enter)}if(true===Ext.isDefined(b.people_exit)){a=a||(Number(this.hiddenPeopleExit.getValue())!==b.people_exit)}if(true===Ext.isDefined(b.people_region)){a=a||(this.hiddenPeopleRegion.getValue()!==b.people_region)}if(true===Ext.isDefined(b.people_hint_pos)){a=a||(this.hiddenPeopleHintPos.getValue()!==b.people_hint_pos)}if(true===Ext.isDefined(b.det_region)){a=a||(this.hiddenDetRegion.getValue()!==b.det_region)}return a},LoadRecord:function(a){this.getForm().loadRecord(a);this.SetFieldBitValue(this.fieldIgnoreBgEvents,a.get("ignore_bg_event"),true);this.SetFieldBitValue(this.fieldIgnoreBgObjs,a.get("ignore_bg_obj"),true);this.SetFieldBitValue(this.fieldFgObjs,a.get("det_fg_obj"),true);this.SetFieldBitValue(this.fieldPeopleDisplayInfo,a.get("people_display_info"),true);this.SetFieldBitValue(this.fieldNormalDisplayInfo,a.get("people_display_info"),true);this.SetMinObjSize(a.get("min_obj_size"));this.InitSimulator()},GetFieldBitValue:function(b){var a=b.GetValueFromStore();return(0===a.length)?0:a.reduce(function(c,d){return c+d})},SetFieldBitValue:function(e,c,d){var b=0;var a=[];while(0<c){if(1===(c&1)){a.push(1<<b)}b++;c=(c>>1)}e.SetValueByStore(a);if(true===d){e.initValue()}},SetMinObjSize:function(a){a=SYNO.SS.App.VideoAnalytics.Utils.CorrectObjSize(a);this.hiddenMinObjSize.setValue(a);this.chkMinObjSizeOption.SetSize(a)},GetFormData:function(a){var b=this.getForm().getValues();b.ignore_bg_event=this.GetFieldBitValue(this.fieldIgnoreBgEvents);b.ignore_bg_obj=this.GetFieldBitValue(this.fieldIgnoreBgObjs);b.det_fg_obj=this.GetFieldBitValue(this.fieldFgObjs);b.people_display_info=this.GetFieldBitValue(this.fieldPeopleDisplayInfo)|this.GetFieldBitValue(this.fieldNormalDisplayInfo);Ext.apply(b,this.panelSimulator.GetDetectAreas(a));return b},UpdElmHiddenSts:function(){var a=SYNO.SS.App.VideoAnalytics.Def;var c=this.GetAnalyzeType();var b=(a.PeopleModeType.ENTER_AND_LEAVE===this.cmbPeopleMode.getValue());this.ctRegionType.hide();this.ctRegionCnt.hide();this.ctIgnoreBgEvents.hide();this.ctIgnoreBgObjs.hide();this.ctFgObjs.hide();this.ctPeopleMode.hide();this.ctPeopleEventSetting.hide();this.ctPeopleDisplayInfo.hide();this.ctNormalDisplayInfo.hide();this.ctSensitivity.hide();this.ctObjMinDuration.hide();this.ctObjMinSize.hide();this.ctPeopleResetCnt.hide();if(a.AnalyticsType.ZONE_DETECTION===c){this.ctRegionType.show();this.ctRegionCnt.show();this.ctObjMinDuration.show();this.ctFgObjs.show();this.ctNormalDisplayInfo.show()}else{if(a.AnalyticsType.PEOPLE_COUNTING===c){this.ctPeopleMode.show();this.ctPeopleResetCnt.show();this.ctPeopleDisplayInfo.show();this.ctPeopleEventSetting.setVisible(b)}else{if(a.AnalyticsType.MOTION_DETECTION===c){this.ctRegionType.show();this.ctRegionCnt.show();this.ctObjMinSize.show();this.ctIgnoreBgEvents.show();this.ctIgnoreBgObjs.show();this.ctNormalDisplayInfo.show()}else{if(a.AnalyticsType.OBJECT_TRACKING===c){this.ctRegionType.show();this.ctRegionCnt.show();this.ctFgObjs.show();this.ctNormalDisplayInfo.show()}else{if((a.AnalyticsType.FOREIGN_OBJECT===c)||(a.AnalyticsType.MISSING_OBJECT===c)){this.ctRegionType.show();this.ctRegionCnt.show();this.ctObjMinSize.show();this.ctObjMinDuration.show();this.ctIgnoreBgObjs.show();this.ctNormalDisplayInfo.show()}}}}}},UpdDefaultParam:function(){var a=SYNO.SS.App.VideoAnalytics.Def;this.SetFieldBitValue(this.fieldFgObjs,a.DetectedObjType.PEDESTRIAN)},OnSimulate:function(){},OnTypeChange:function(a){this.UpdElmHiddenSts();this.ConfigureSimulator()},OnEditObjSize:function(){if(!this.dlgObjSizeEditor){this.dlgObjSizeEditor=new SYNO.SS.App.VideoAnalytics.ObjectSizeEditor({parentWin:this,owner:this.parentWin,minObjSize:this.hiddenMinObjSize.getValue(),videoPanelWidth:480,videoPanelHeight:275,analyzeType:this.GetAnalyzeType()});this.dlgObjSizeEditor.on("beforeclose",function(){this.dlgObjSizeEditor=null},this);this.dlgObjSizeEditor.Activate();this.dlgObjSizeEditor.show()}},InitSimulator:function(){var a=SYNO.SS.App.VideoAnalytics.Utils;var b=this.GetFormData(false);Ext.apply(b,{area_grid:this.hiddenGrid.value,area_line:a.String2VertexArray(this.hiddenLine.value),area_region:a.String2VertexArray(this.hiddenRegion.value),det_region:a.String2RegionArray(this.hiddenDetRegion.value),people_enter:this.hiddenPeopleEnter.value,people_exit:this.hiddenPeopleExit.value,people_region:a.String2VertexArray(this.hiddenPeopleRegion.value),people_hint_pos:a.String2VertexArray(this.hiddenPeopleHintPos.value)});this.panelSimulator.Configure(b)},ConfigureSimulator:function(){this.panelSimulator.Configure(this.GetFormData(false))},GetAnalyzeType:function(){return Number(this.hiddenAnalyzeType.getValue())}});Ext.define("SYNO.SS.App.VideoAnalytics.ObjectSizeEditor",{extend:"SYNO.SDS.ModalWindow",WIDTH:520,HEIGHT:420,constructor:function(a){this.Init(a);Ext.apply(a,{title:_T("video_analytics","edit_minimum_objsize"),layout:"fit",items:this.panelContainer,width:this.WIDTH,height:this.HEIGHT,minimizable:false,buttons:[this.btnConfirm,this.btnCancel],listeners:{}});this.callParent([a]);this.panelSimulator.Activate();this.fieldObjMinSize.setValue(a.minObjSize);this.RoundAndDrawObjSize(a.minObjSize)},Init:function(a){this.fieldObjMinSize=new SYNO.ux.TextField({width:80,value:1,maxLength:4,allowBlank:false,validateOnBlur:true,validationEvent:"blur",vtype:"objSize",invalidText:_T("video_analytics","obj_size_hint"),style:"margin-left: 200px;",listeners:{change:function(b,c){this.RoundAndDrawObjSize(c)},afterrender:function(b){SYNO.SS.Utils.AddTip(b.getEl(),_T("video_analytics","obj_size_hint"))},scope:this}});this.panelSimulator=new SYNO.SS.App.VideoAnalytics.AnalyticsSimulator({parentWin:a.parentWin.parentWin,width:a.videoPanelWidth,height:a.videoPanelHeight,videoPanelWidth:a.videoPanelWidth,videoPanelHeight:a.videoPanelHeight,type:a.analyzeType,blShowTitle:false,listeners:{sizeChanged:function(b){this.fieldObjMinSize.setValue(b)},scope:this}});this.panelContainer=new SYNO.ux.Panel({layout:"vbox",defautls:{border:false},items:[{xtype:"container",layout:"hbox",items:[{xtype:"syno_displayfield",value:_T("video_analytics","minimum_object_size")+"(%):"},this.fieldObjMinSize]},{xtype:"container",layout:"fit",style:"margin-top: 10px",items:this.panelSimulator}]});this.btnConfirm=new SYNO.ux.Button({text:_T("ss_common","common_ok"),btnStyle:"blue",handler:this.OnClose,scope:this});this.btnCancel=new SYNO.ux.Button({text:_T("ss_common","common_cancel"),handler:this.close,scope:this})},Activate:function(){},RoundAndDrawObjSize:function(a){a=SYNO.SS.App.VideoAnalytics.Utils.CorrectObjSize(a);this.fieldObjMinSize.setValue(a);if(true===this.fieldObjMinSize.isValid()){this.panelSimulator.Configure({blObjSizeEditor:true,analyze_type:this.analyzeType,min_obj_size:this.fieldObjMinSize.value})}},OnClose:function(){if(true===this.fieldObjMinSize.isValid()){this.parentWin.SetMinObjSize(this.fieldObjMinSize.value);this.close()}}});Ext.namespace("SYNO.SS.App.VideoAnalytics");Ext.define("SYNO.SS.App.VideoAnalytics.Schedule",{extend:"SYNO.SDS.Utils.FormPanel",panelScheduler:null,panelModeSelection:null,schId:"",constructor:function(a){this.schId=Ext.id();this.config=a;this.parentWin=a.parentWin;this.Init();Ext.apply(a,{owner:a.parentWin,trackResetOnLoad:true,style:(true===this.config.blEditMode)?"margin-left: 10px;":"",title:_T("camera","camera_schedule"),bodyStyle:"padding-bottom: 15px;",items:[this.panelModeSelection,this.panelScheduler]});this.callParent([a])},Init:function(){this.panelModeSelection=new SYNO.SS.Panel.ScheduleModePanel({width:SYNO.SS.UTILSCHEDULER.GetTableWidth(),style:"margin-bottom: 10px;"});this.panelScheduler=new SYNO.SS.Panel.SchedulerPanel({htmlSchedulerId:this.schId,scheduleMode:SYNO.SS.Schedule.Mode.VIDEO_ANALYTICS,blTwoColor:true,listeners:{afterrender:function(){this.panelScheduler.Activate();var a=SYNO.SS.App.VideoAnalytics.Utils.ScheStrToScheArray("1".repeat(336));this.UpdateScheduleUI(a)},scope:this}});this.InitModeSelectionPanel()},InitModeSelectionPanel:function(){var a=this.panelScheduler.getId();this.panelModeSelection.removeAll();this.panelModeSelection.add({xtype:"syno_panel",layout:"column",items:[{xtype:"syno_panel",style:"width: 35px;",html:"<span id='"+this.schId+"icon_custom2' class='btn_custom2_inactive' onMouseOver=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'over', 'continue','"+a+"');\"onMouseOut=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'out', 'continue','"+a+"');\"onMousedown=\"javascript:SYNO.SS.UTILSCHEDULER.ChkLeftMouseDown(event, SYNO.SS.UTILSCHEDULER.ScheduleMouseAction, '"+this.schId+"', 'down', 'continue','"+a+"');\"></span>"},{xtype:"label",style:"width: 270px;",text:_T("ss_common","common_activate"),cls:"x-form-item ss-schedule-label-normal"},{xtype:"syno_panel",style:"width: 35px;",html:"<span id='"+this.schId+"icon_erase' class='btn_erase_inactive' onMouseOver=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'over', 'erase','"+a+"');\"onMouseOut=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.schId+"', 'out', 'erase','"+a+"');\"onMousedown=\"javascript:SYNO.SS.UTILSCHEDULER.ChkLeftMouseDown(event, SYNO.SS.UTILSCHEDULER.ScheduleMouseAction, '"+this.schId+"', 'down', 'erase','"+a+"');\"></span>"},{xtype:"label",style:"width: 270px;",text:_T("ss_common","common_delete"),cls:"x-form-item ss-schedule-label-normal"}]});this.panelModeSelection.doLayout()},UpdElmEnableSts:function(){},UpdElmValue:function(){},SetSaveHint:function(){this.parent.SetSaveHint()},CheckFormValid:function(){return true},OnCommit:function(){this.panelScheduler.ClearDirty()},LoadRecord:function(a){var b=a.get("schedule");var c=SYNO.SS.App.VideoAnalytics.Utils.ScheStrToScheArray(b);this.UpdateScheduleUI(c)},UpdateScheduleUI:function(c){if(!c){return}var b,a;this.panelScheduler.UpdateScheduleData(c);for(b=0;b<7;b++){for(a=0;a<48;a++){if((0<c[b][a])){this.panelScheduler.SetCurrentAct("continue")}else{this.panelScheduler.SetCurrentAct("erase")}this.panelScheduler.ClickScheduleItem(this.schId,b,a)}}this.panelScheduler.DrawSelectAllItem(0);this.ResetScheduleBtnState()},ResetScheduleBtnState:function(){SYNO.SS.UTILSCHEDULER.ScheduleMouseAction(this.schId,"down","continue",this.panelScheduler.getId())},ResetSetting:function(){this.UpdateScheduleUI(this.panelScheduler.GetScheduleData())},ResetDefault:function(){this.panelScheduler.SelectAllSchedule()},IsDirty:function(){return(true===this.panelScheduler.IsDirty())},GetFormData:function(){var a={schedule:this.panelScheduler.GetSchedule()};return a},UpdElmHiddenSts:function(){},UpdElmEnableSts:function(){}});Ext.namespace("SYNO.SS.App.VideoAnalytics");Ext.define("SYNO.SS.App.VideoAnalytics.Wizard",{extend:"SYNO.SDS.Wizard.ModalWindow",steps:null,parentWin:null,pageInformation:null,pageSetting:null,pageSchedule:null,constructor:function(a){this.parentWin=a.parentWin;this.parentPanel=a.parentPanel;this.InitSteps();Ext.apply(a,{owner:a.parentWin,title:_T("video_analytics","add_video_analytics_wizard"),banner:false,width:770,height:535,bodyCssClass:"ss_wizard",steps:this.steps,useStatusBar:true});this.callParent([a])},InitSteps:function(){this.pageInformation=new SYNO.SS.App.VideoAnalytics.Information({blEditMode:false,nextId:"setting",parentWin:this,getNext:function(){if(false===this.IsFormValid()){this.Validate();this.parentWin.setStatusBarError({text:_T("ss_common","forminvalid"),clear:true});return false}this.parentWin.OnCommitInform();return this.nextId}});this.pageSetting=new SYNO.SS.App.VideoAnalytics.Setting({blEditMode:false,itemId:"setting",nextId:"schedule",parentWin:this,getNext:function(){if(false===this.getForm().isValid()){this.parentWin.setStatusBarError({text:_T("ss_common","forminvalid"),clear:true});return false}return this.nextId}});this.pageSchedule=new SYNO.SS.App.VideoAnalytics.Schedule({blEditMode:false,itemId:"schedule",parentWin:this,getNext:function(){if(false===this.getForm().isValid()){this.parentWin.setStatusBarError({text:_T("ss_common","advanced"),clear:true});return false}this.parentWin.OnSubmit();return false}});this.steps=[this.pageInformation,this.pageSetting,this.pageSchedule]},OnCommitInform:function(){this.pageSetting.UpdDefaultParam()},OnSubmit:function(){var a={blEditMode:false,enable:true};this.setStatusBarBusy({text:_T("ss_common","common_saving")});Ext.apply(a,SYNO.SS.App.VideoAnalytics.Utils.GetTaskSaveParam(this.pageInformation,this.pageSetting,this.pageSchedule));this.parentWin.OnSaveTask({params:a,callback:this.OnSubmitDone,scope:this})},OnSubmitDone:function(e,c,d,b){var a;this.clearStatusBusy();if(false===e){a=SYNO.API.getErrorString(c);this.getMsgBox().alert(this.title,a);return}this.close()}});Ext.namespace("SYNO.SS.App.VideoAnalytics");Ext.define("SYNO.SS.App.VideoAnalytics.EditWizard",{extend:"SYNO.SDS.Window",btnSave:null,btnClose:null,tabPanel:null,blForceClose:false,constructor:function(a){this.task=a.task;this.parentWin=a.parentWin;this.parentPanel=a.parentPanel;this.Init();Ext.apply(a,{id:a.id,title:_T("video_analytics","edit_video_analytics_task")+" - "+this.task.get("name"),width:875,height:535,owner:a.parentWin,maximizable:true,minimizable:false,useStatusBar:true,buttons:[this.btnSave,this.btnClose],items:this.tabPanel});this.callParent([a]);this.InitTaskData()},Init:function(){this.btnSave=new SYNO.ux.Button({name:"btnSave",btnStyle:"blue",text:_T("ss_common","common_save"),handler:this.CheckDirtyAndSave,scope:this});this.btnClose=new SYNO.ux.Button({name:"btnClose",text:_T("ss_common","close"),handler:this.close,scope:this});this.pageInformation=new SYNO.SS.App.VideoAnalytics.Information({blEditMode:true,parentWin:this});this.pageSetting=new SYNO.SS.App.VideoAnalytics.Setting({blEditMode:true,task:this.task,parentWin:this});this.pageSchedule=new SYNO.SS.App.VideoAnalytics.Schedule({blEditMode:true,parentWin:this});this.tabPanel=new SYNO.SDS.Utils.TabPanel({activeTab:0,useDefaultBtn:false,deferredRender:false,height:494,items:[this.pageInformation,this.pageSetting,this.pageSchedule]})},InitTaskData:function(){this.setStatusBusy();this.pageInformation.LoadRecord(this.task);this.pageSetting.LoadRecord(this.task);this.pageSchedule.LoadRecord(this.task);this.clearStatusBusy()},CheckDirtyAndSave:function(){if(true===this.IsFormDirty()){this.OnPreSave()}else{this.setStatusError({text:_T("ss_common","setting_nochange"),clear:true})}},OnPreSave:function(){this.OnSave()},OnSave:function(){var b={id:this.task.get("id"),blEditMode:true,enable:this.task.get("enable")};var a=SYNO.SS.App.VideoAnalytics.Utils.GetTaskSaveParam(this.pageInformation,this.pageSetting,this.pageSchedule);Ext.apply(b,a);this.setStatusBarBusy({text:_T("ss_common","common_saving")});this.parentWin.OnSaveTask({params:b,callback:this.OnSubmitDone,scope:this})},OnSubmitDone:function(e,c,d,b){var a;this.clearStatusBusy();this.setStatusOK({text:_T("ss_common","setting_applied"),clear:true});if(false===e){a=SYNO.API.getErrorString(c);this.getMsgBox().alert(this.title,a);return}this.pageInformation.OnCommit();this.pageSetting.OnCommit();this.pageSchedule.OnCommit();this.setTitle(_T("video_analytics","edit_video_analytics_task")+" - "+this.pageInformation.fldName.getValue())},onClose:function(){if(true===this.blForceClose){return true}if(true===this.IsFormDirty()){this.ConfirmLostChange(function(a){if(a==="yes"){this.blForceClose=true;this.close()}},this);return false}return true},ConfirmLostChange:function(b,a){this.getMsgBox().confirm("",_T("ss_common","confirm_lostchange"),b,a)},IsFormDirty:function(){return((true===this.pageInformation.IsDirty())||(true===this.pageSetting.IsDirty())||(true===this.pageSchedule.IsDirty()))}});Ext.define("SYNO.SS.App.VideoAnalytics.TaskList",{extend:"SYNO.ux.Panel",INVALID_CAM_COUNT:-1,INVALID_MAX_CAM_NUMBER:-1,SERVER_UPDATE_INTVAL_SHORT_MS:5000,SERVER_UPDATE_INTVAL_MS:10000,SNAPSHOT_ID_PREFIX:"preview_cam_iva_",SNAPSHOT_MASK_ID_PREFIX:"mask_cam_iva_",parentWin:null,title:null,dsIVATask:null,dsCateg:null,gridCateg:null,SERVER_CATEG_ALL_CATEGORIES:[],gridTaskList:null,panelTaskList:null,panelCategContainer:null,btnAdd:null,btnDelete:null,btnEdit:null,menuItemEnable:null,menuItemDisable:null,btnEnable:null,btnSwitchCateg:null,dlgTaskWizard:null,dlgTaskEdit:null,strStoreSnapshot:null,contextMenu:null,categContextMenu:null,blCheckIncompatiable:true,blActivate:false,sortType:null,sortOrder:null,RecIconRenderMap:[],snapshotMap:[],snapshotPreloadMap:{},snapshotReplaceMap:{},snapshotTimerQuery:null,constructor:function(a){this.Init();SYNO.SS.App.VideoAnalytics.winInst=this;this.callParent([{title:_T("edge_storage","task"),parentWin:a,layout:"fit",tbar:new SYNO.ux.Toolbar({items:[this.btnAdd,this.btnDelete,this.btnEdit,this.btnEnable,this.btnResetPplCount,{xtype:"tbfill"},this.btnSwitchCateg]}),items:[this.panelCategContainer],listeners:{activate:this.Activate,deactivate:this.Deactivate,afterrender:function(){this.strStoreSnapshot=this.GetStoreSnapshot();this.OnRefresh()},scope:this}}]);this.InitEventHandler()},Activate:function(){this.blActivate=true;this.gridCateg.Reset();this.dsCamera.load();if(false===this.parentWin.isStatusBusy()){this.panelCategContainer.UpdateEmptyStyle()}this.AutoUpdateSnapshot();this.gridTaskList.refresh()},Deactivate:function(){this.blActivate=false;for(key in this.snapshotReplaceMap){clearInterval(this.snapshotReplaceMap[key]);delete this.snapshotReplaceMap[key]}if(this.RecIconRenderMap){delete this.RecIconRenderMap}this.ClearSnapshotTimerQuery()},GetStoreSnapshot:function(){var a="";this.dsIVATask.each(function(b){a+=JSON.stringify(b.json)});return a},GetMSgBox:function(){return this.parentWin.getMsgBox()},Mask:function(a){if(true===a){this.parentWin.setStatusBusy()}else{this.parentWin.clearStatusBusy()}},Init:function(){this.snapshotMap[SYNO.SS.MultiView.LIST_VIEW_IDX]=[];this.dsCamera=new SYNO.SS.CameraCacheStore({cmp:this,needSort:true,saveSortInfo:true,fnRefresh:this.OnRefresh.createDelegate(this),baseParams:{start:0,blFromCamList:true,blIncludeDeletedCam:true,blExcludeUnrecog:false,blGetMulticastInfo:true,privCamType:(SYNO.SS.CamPriv.LIVEVIEW|SYNO.SS.CamPriv.PLAYBACK),streamInfo:true,blGetSortInfo:true},fields:SYNO.SS.GblStore.fieldCamera});this.dsIVATask=new SYNO.SS.VideoAnalyticsTaskCacheStore({cmp:this,needSort:true,saveSortInfo:true,sortInfoModNm:SYNO.SS.Sort.VIDEO_ANALYTICS,fnRefresh:this.OnRefresh.createDelegate(this),baseParams:{},fields:SYNO.SS.GblStore.fieldVideoAnalyticsTask,listeners:{beforeload:this.OnTaskBeforeLoad,load:this.OnTaskLoad,update:this.OnTaskUpdate,scope:this}});this.btnAdd=new SYNO.ux.Button({text:_T("ss_common","common_add"),handler:this.OnTaskAdd,scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),handler:this.DeletePreProcess,scope:this});this.btnEdit=new SYNO.ux.Button({text:_T("ss_common","common_edit"),handler:this.OnTaskEdit,scope:this});this.menuItemEnable=new Ext.menu.Item({text:_T("ss_common","common_enable"),handler:this.OnTaskEnable,scope:this});this.menuItemDisable=new Ext.menu.Item({text:_T("ss_common","common_disable"),handler:this.OnTaskDisable,scope:this});this.btnEnable=new SYNO.ux.Button({text:_T("ss_common","common_enable"),menu:{items:[this.menuItemEnable,this.menuItemDisable]}});this.btnResetPplCount=new SYNO.ux.Button({text:_T("video_analytics","reset_people_count"),handler:this.OnResetPplCount,scope:this});this.gridTaskList=new SYNO.SS.App.VideoAnalytics.ExpandableListView({owner:this,store:this.dsIVATask,prepareData:this.PrepareExpListData.createDelegate(this),dsCamera:this.dsCamera,pageSize:3,toggleOnDblClick:false,playIconOnPreview:true,allowMultiPlay:SYNO.SS.Utils.IsSupportStreaming(),fnPlay:this.OnPlay.createDelegate(this),IsReadyToPlay:this.IsReadyToPlay.createDelegate(this),listeners:{selectionchange:function(b,c){this.ChgButtonStatus()},contextmenu:this.OnContextMenu,dblclick:this.OnTaskEdit,scope:this}});this.SERVER_CATEG_ALL_CATEGORIES=[SYNO.SS.Grid.Categ.CATEG_IVA_ANALYZE_TYPE,SYNO.SS.Grid.Categ.CATEG_IVA_TASK_STATUS];this.dsCateg=new Ext.data.JsonStore({fields:["id","category","entryName","entryVal","recCnt","type"]});this.gridCateg=new SYNO.SS.Grid.CategoryGridPanel({border:false,enableDragDrop:true,tabInfo:SYNO.SS.App.CMS.Def.SLAVE_MODE_FAILOVER,category:this.SERVER_CATEG_ALL_CATEGORIES,store:this.dsCateg,ShowContextMenu:this.ShowCategContextMenu.createDelegate(this),sortInfo:{defaultSortItem:SYNO.SS.Sort.ID,sortItems:[SYNO.SS.Sort.ID,SYNO.SS.Sort.NAME],fnList:function(c,b){this.sortType=c;this.sortOrder=b;this.OnRefresh()},fnListScope:this},listeners:{beforereloadcateg:this.gridTaskList.StoreUIState,afterreloadcateg:this.gridTaskList.RestoreUIState,scope:this.gridTaskList},delegate:this});var a=new SYNO.SS.Pgls.BottomBar({panelRecord:this.gridTaskList,refreshFunction:this.OnRefresh,refreshFunctionScope:this});this.panelTaskList=new SYNO.ux.Panel({region:"center",layout:"fit",items:[this.gridTaskList],bbar:a});this.panelCategContainer=new SYNO.SS.Grid.CategContainerPanel({items:[this.gridCateg,this.panelTaskList],gridCateg:this.gridCateg,panelRecord:this.gridTaskList,labelItemCnt:a.labelItemCnt,dsRecord:this.dsIVATask,GetParams:this.GetFilterParams.createDelegate(this),fnCountByCateg:this.CountByCateg.createDelegate(this),emptyStyleMonStore:this.dsIVATask,emptyStyleTip:_T("video_analytics","no_task_tip"),emptyStyleTipFunc:this.OnTaskAdd.createDelegate(this),fnNeedApplyEmptyStyle:this.HasNoRecord.createDelegate(this),plugins:SYNO.SS.AutoUpdate.CreateWebSocketAUPlugin({blStable:false,fnCompare:function(d,c){return SYNO.SS.Sort.fnCompCam(d,c,this.sortOrder,this.sortType)}.createDelegate(this)})});this.btnSwitchCateg=this.gridCateg.btnSwitch;this.panelCategContainer.setVisible(true)},InitEventHandler:function(){this.panelCategContainer.mon(SYNO.SDS.StatusNotifier,"addonsStatusChange",this.OnRefresh,this);this.mon(SYNO.SDS.StatusNotifier,"serverListRefresh",this.OnRefresh,this);this.mon(this.dsIVATask,"srcStoreUpdate",this.OnTaskStoreUpdate,this);this.mon(this.dsCamera,"srcStoreUpdate",this.OnRefresh,this)},OnTaskStoreUpdate:function(b,a){if(false===this.blActivate){return}this.gridTaskList.refresh();this.panelCategContainer.UpdateEmptyStyle()},GetTaskIdList:function(f,g,c){var d=this.gridTaskList.getSelectedRecords();var b=[];var a,e;for(e=0;e<d.length;e++){a=d[e];if((true!==c)&&(false===this.IsOpAllowed(a.data))){continue}if("normal"===f){b.push(a.get("id"))}else{if(("enable"===f)&&(a.data.enable!==g)){b.push(a.get("id"))}}}return b},GetSelectedTaskIdString:function(b,d,a){var c=this.GetTaskIdList(b,d,a);return(0<c.length)?c.join(","):null},HasNoRecord:function(){return(0===this.gridCateg.GetTotalCount())},OnTaskAdd:function(){this.dlgTaskWizard=new SYNO.SS.App.VideoAnalytics.Wizard({dsTasks:this.dsIVATask,parentWin:this.parentWin,parentPanel:this});this.dlgTaskWizard.open()},CheckBeforeEdit:function(a){if(!a){return false}if(false===this.IsOpAllowed(a.data)){return false}return true},OnTaskEdit:function(){var a=this.gridTaskList.getSelectedRecords()[0];var b="ivaEditDig-"+a.get("id");if(false===this.CheckBeforeEdit(a)){return}if(Ext.getCmp(b)){Ext.getCmp(b).show();return}this.dlgTaskEdit=new SYNO.SS.App.VideoAnalytics.EditWizard({id:b,parentWin:this.parentWin,parentPanel:this,dsTasks:this.dsIVATask,task:a});this.dlgTaskEdit.show();this.addManagedComponent(this.dlgTaskEdit)},DeletePreProcess:function(){var b=this.GetTaskIdList("normal",null,true);var a;if(!b){return}a=this.GetMSgBox();a.confirm(_T("ss_common","surveillance_server"),_T("video_analytics","delete_task_tip"),this.OnTaskDelete,this)},OnTaskDelete:function(c,e,b,d){var a;if("yes"===c){a=this.GetSelectedTaskIdString("normal",null,true);this.SendWebAPIRequest({method:"DeleteTask",params:{ids:a}})}},OnTaskEnable:function(){var a=this.GetSelectedTaskIdString("enable",true);if(null!==a){this.SendWebAPIRequest({method:"EnableTask",params:{ids:a}})}},OnTaskDisable:function(){var a=this.GetSelectedTaskIdString("enable",false);if(null!==a){this.SendWebAPIRequest({method:"DisableTask",params:{ids:a}})}},OnResetPplCount:function(){var a=this.gridTaskList.getSelectedRecords()[0];this.sendWebAPI({api:"SYNO.SurveillanceStation.IVA",method:"ExecCommand",version:1,params:{taskId:a.get("id"),analyzeType:a.get("analyze_type"),blPeopleResetIn:true,blPeopleResetOut:true}})},OnRefresh:function(){if(true===this.isDestroyed){return}this.dsCamera.load();this.dsIVATask.load({params:{sortInfo:SYNO.SS.Sort.GetSortInfo(this.sortType,this.sortOrder)},callback:function(){this.panelCategContainer.UpdateEmptyStyle();this.parentWin.fireEvent("shortcutDataReady")},scope:this});for(camId in this.snapshotMap[SYNO.SS.MultiView.LIST_VIEW_IDX]){if(true===this.snapshotMap[SYNO.SS.MultiView.LIST_VIEW_IDX].hasOwnProperty(camId)){this.snapshotMap[SYNO.SS.MultiView.LIST_VIEW_IDX][camId].blDirty=true}}},CloseVideoAnalyticsApp:function(a){},OnContextMenu:function(a,d,b,c){if(!this.contextMenu){this.contextMenu=new SYNO.ux.Menu({items:[{id:"cmTaskEdit",text:_T("ss_common","common_edit"),handler:this.OnTaskEdit,scope:this},{id:"cmTaskEnable",text:_T("ss_common","common_enable"),handler:this.OnTaskEnable,scope:this},{id:"cmTaskDisable",text:_T("ss_common","common_disable"),handler:this.OnTaskDisable,scope:this},{id:"cmTaskDelete",text:_T("ss_common","common_delete"),handler:this.DeletePreProcess,scope:this}]});this.addManagedComponent(this.contextMenu)}if(false===a.isSelected(b)){a.select(b)}Ext.getCmp("cmTaskEdit").setVisible(false===this.btnEdit.disabled);Ext.getCmp("cmTaskEnable").setVisible(false===this.menuItemEnable.disabled);Ext.getCmp("cmTaskDisable").setVisible(false===this.menuItemDisable.disabled);Ext.getCmp("cmTaskDelete").setVisible(false===this.btnDelete.disabled);c.stopEvent();this.contextMenu.showAt(c.getXY())},ShowCategContextMenu:function(a){if(!this.categContextMenu){this.categContextMenu=new SYNO.ux.Menu({items:[{itemId:"cmFailoverAddDesktopShortcut",text:_T("desktop","add_desktop_shortcut"),handler:function(){this.parentWin.fireEvent("shortcutOnAddCateg")},scope:this}]});this.addManagedComponent(this.categContextMenu)}this.categContextMenu.showAt(a.getXY())},OnTaskBeforeLoad:function(a,b){if(true===b.blMask){this.Mask(true)}},OnTaskLoad:function(d,c,e){if(true===this.isDestroyed){return}var b=false;var g=this.GetStoreSnapshot();if(g!==this.strStoreSnapshot){b=true;this.strStoreSnapshot=g}if(0===this.gridTaskList.getSelectedRecords().length){this.SelectDefaultTask()}this.gridTaskList.RenderAllSche();var f;var a=d.GetSortCond();if(false===Ext.isEmpty(a)){this.gridCateg.sortMenu.SetSortInfo(a);f=SYNO.SS.Sort.ParseSortInfo(a);this.sortType=f[0];this.sortOrder=f[1]}this.parentWin.fireEvent("shortcutDataReady");this.ChgButtonStatus();if(true===e.blMask){this.Mask(false)}},OnTaskUpdate:function(b,a,c){if(Ext.data.Record.COMMIT===c){this.ChgButtonStatus()}},GetCategEntryName:function(b,c){var a=SYNO.SS.Grid.Categ.GetCategEntryNameLocalStr(b,c);return SYNO.SDS.Utils.GetLocalizedString(a)},IncreaseEntryCntOfCateg:function(d,b,c){var a=(d[b][c]!==undefined);d[b][c]=(a)?(d[b][c]+1):1},CountByCateg:function(){var a=this.dsIVATask;var e=Ext.apply(this.GetFilterParams(false),{limit:0});var c=a.GetDataFromSrcStore(e);var b=c.task;var d=c[a.totalProperty];var f={};Ext.each(this.SERVER_CATEG_ALL_CATEGORIES,function(g){f[g]={};if(g==SYNO.SS.Grid.Categ.CATEG_IVA_TASK_STATUS){f[g][SYNO.SS.Grid.Categ.VALUE_ALL]=d;f[g][SYNO.SS.VideoAnalytics.TaskSts.Normal]=0;f[g][SYNO.SS.VideoAnalytics.TaskSts.Disabled]=0;f[g][SYNO.SS.VideoAnalytics.TaskSts.Abnormal]=0}else{if(g==SYNO.SS.Grid.Categ.CATEG_IVA_ANALYZE_TYPE){f[g][SYNO.SS.Grid.Categ.VALUE_ALL]=d;f[g][SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.MOTION_DETECTION]=0;f[g][SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.OBJECT_TRACKING]=0;f[g][SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.ZONE_DETECTION]=0;f[g][SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.PEOPLE_COUNTING]=0;f[g][SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.FOREIGN_OBJECT]=0;f[g][SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.MISSING_OBJECT]=0}}},this);Ext.each(b,function(g){this.IncreaseEntryCntOfCateg(f,SYNO.SS.Grid.Categ.CATEG_IVA_TASK_STATUS,this.ParseStatus(g));this.IncreaseEntryCntOfCateg(f,SYNO.SS.Grid.Categ.CATEG_IVA_ANALYZE_TYPE,g.analyze_type)},this);f.total=d;return f},ParseStatus:function(c){var a=c.owner_ds_id;var b=(LOCAL_DS_ID===a)?true:SYNO.SS.Utils.IsSlaveDsOnline(a);if(false===b){return SYNO.SS.VideoAnalytics.TaskSts.Abnormal}else{if(true===c.enable){return SYNO.SS.VideoAnalytics.TaskSts.Normal}else{if(false===c.enable){return SYNO.SS.VideoAnalytics.TaskSts.Disabled}}}return SYNO.SS.VideoAnalytics.TaskSts.Abnormal},GetFilterParams:function(){return Ext.apply({},this.dsIVATask.baseParams)},IsTransientSts:function(a){return false},IsOpAllowed:function(a){return(false===this.IsTransientSts(a))},ChgButtonStatus:function(){var b=this.gridTaskList.getSelectedRecords();var d=b.length;var e=false;var c=false;var a;for(i=0;i<d;i++){a=b[i];if(false===this.IsOpAllowed(a.data)){continue}if(true===a.get("enable")){e=true}else{c=true}if((true===a.get("enable"))&&(true===SYNO.SS.Utils.IsDsOnlineSts(a.get("status")))){if(true===a.get("cms_locked")){}else{}}}this.btnDelete.disable();this.btnEnable.disable();this.btnEdit.disable();this.btnResetPplCount.disable();this.menuItemEnable.disable();this.menuItemDisable.disable();if(1<=d){this.menuItemEnable.setDisabled(false===c);this.menuItemDisable.setDisabled(false===e);if((true===e)||(true===c)){this.btnEnable.enable()}this.btnDelete.enable();if(1===d){if(true===this.IsOpAllowed(a.data)){this.btnEdit.enable()}if(SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.PEOPLE_COUNTING===a.get("analyze_type")){this.btnResetPplCount.enable()}}}},SelectDefaultTask:function(){var a=this.parentWin.appInstance.appParams;if((a)&&(a.defaultSelectIvaTask)){var b=this.dsIVATask.findExact("id",a.defaultSelectIvaTask);this.gridTaskList.select(b)}else{this.gridTaskList.select(0)}},Alert:function(b){var a=(b)?b:_T("ss_common","error_system");this.GetMSgBox().alert(_T("ss_common","surveillance_server"),a)},UpdateTransSts:function(c,b){var a;switch(c){case"Delete":a=SYNO.SS.SlaveDsStsFlag.DELETING;break;case"Enable":a=SYNO.SS.SlaveDsStsFlag.ENABLING;break;case"Disable":a=SYNO.SS.SlaveDsStsFlag.DISABLING;break;default:return}if(b){this.SetTaskStsFlag(b,a)}},SendWebAPIRequest:function(a){if(true===a.blMask){this.Mask(true)}var b=(a.params)?a.params.camIds:null;this.UpdateTransSts(a.method,b);this.sendWebAPI({api:"SYNO.SurveillanceStation.IVA",method:a.method,version:1,params:a.params,timeout:(true===a.blMask)?120000:1800000,callback:function(c,e,f,d){if(true===a.blMask){this.Mask(false)}this.OnSendWebAPIRequestDone(c,e,d,a.callback)},scope:this})},OnSendWebAPIRequestDone:function(a,d,c,e){var b;if(true===a){if((e)&&("function"===(typeof e))){e.call(this,c,a)}}else{b=SYNO.API.getErrorString(d.code);this.Alert(b)}},SetTaskStsFlag:function(c,a){var b=this.dsIVATask;c=(true===Ext.isString(c))?c.split(","):[c];Ext.each(c,function(d){var e=b.getById(d);var f;if(e){f=e.get("status_flags");e.set("status_flags",(f|a));e.commit()}},this);this.dsIVATask.abortLoad()},ClearSnapshotTimerQuery:function(){if(this.snapshotTimerQuery){window.clearTimeout(this.snapshotTimerQuery);delete this.snapshotTimerQuery;this.snapshotTimerQuery=null}},AutoUpdateSnapshot:function(){this.ClearSnapshotTimerQuery();this.snapshotTimerQuery=setTimeout(function(){this.dsCamera.each(function(c){var a=c.get("id");if(false===c.get("enabled")){return}var b=SYNO.SS.App.VideoAnalytics.Utils.GetTaskIdList(a);b.forEach(function(d){if(true===SYNO.SS.App.VideoAnalytics.Utils.IsTaskRunning(d)){SYNO.SS.App.VideoAnalytics.SnapshotUtils.UpdateSnapshot(a,d)}})},this);this.AutoUpdateSnapshot()}.createDelegate(this),15*60*1000)},PrepareExpListData:function(f,e,g){var k=f.id;var c=SYNO.SS.MultiView.LIST_VIEW_IDX;var a=this.dsCamera.getById(f.camera_id);var b=((0>=a.get("recStatus"))?false:true);var h=this.snapshotMap[c][f.camera_id];f.preview="";if(undefined!==h){f.preview=h.strUrl}f.snapshotID=SYNO.SS.App.VideoAnalytics.SnapshotUtils.MakeSnapshotID(c,k);f.loadingID=SYNO.SS.App.VideoAnalytics.SnapshotUtils.MakeLoadingID(c,k);f.recIconID=SYNO.SS.App.VideoAnalytics.SnapshotUtils.MakeRecIconID(c,k);f.previewDisplay=((f.preview==="")?"none":"");f.loadingDisplay="none";if((undefined===this.snapshotMap[c][f.camera_id])||(true===this.snapshotMap[c][f.camera_id].blIsSnapshot)){if(undefined!==this.snapshotPreloadMap[f.snapshotID]){f.loadingDisplay=""}}if((SYNO.SS.CamSts.NORMAL===a.get("camStatus"))&&(false===SYNO.SS.CamStsFlag.IsTransientSts(a.get("status_flags")))&&(true===b)){a.data.isRecording=true;f.display="block"}else{a.data.isRecording=false;f.display="none"}var d=SYNO.SS.App.Camera.Utils.GetCamConnStatus(a);f.connStatusText=d.strStatus;f.connStatusColor=d.color;if(undefined===this.snapshotReplaceMap[f.snapshotID]){this.snapshotReplaceMap[f.snapshotID]=setInterval(function(l,m,n){if(null===document.getElementById(m)){return}SYNO.SS.App.VideoAnalytics.SnapshotUtils.DoReplaceSnapshot(l,n);clearInterval(this.snapshotReplaceMap[m]);delete this.snapshotReplaceMap[m]}.createDelegate(this,[g.data.camera_id,f.snapshotID,k]),100)}return f},CameraUpdateAttr:function(a,e,c){var b=this.dsCamera;var d=b.getById(a);if(d){if(d.data[e]!==c){d.data[e]=c;return 1}else{return 0}}return -1},OnPlay:function(a){var b=SYNO.SS.GblStore.dsCamera.getById(a.get("camera_id"));if(true===this.CheckCamStatusNormal(b)){if(true===b.get("blLiveviewPriv")){var c={dsId:LOCAL_DS_ID,blHeader:true,mode:SYNO.SS.App.WebPlayer.Def.PreviewMode.IVA,appWinId:SYNO.SDS.Utils.GetAppWinId(MODULE_ID_VIDEO_ANALYTICS,b.get("ownerDsId"),a.get("id")),camId:b.get("id"),ivaTaskId:a.get("id"),recCamInfo:{camId:(LOCAL_DS_ID===b.get("ownerDsId"))?b.get("id"):b.get("camIdOnRecServer"),dsId:b.get("ownerDsId")}};SYNO.SDS.AppLaunch(SYNO.SS.Module.InstanceNameMap[MODULE_ID_CAMERA_PREVIEW],c,true)}else{this.Alert(_T("ss_privilege","no_privilege_watch_liveview"))}}},IsReadyToPlay:function(b){var c=b.get("id");var a=b.get("camera_id");var d=SYNO.SS.GblStore.dsCamera.getById(a);return((true===this.CheckCamStatusNormal(d))&&(true===SYNO.SS.App.VideoAnalytics.Utils.IsTaskRunning(c)))},CheckCamStatusNormal:function(a){if(undefined!==a){if((true===a.get("enabled"))&&(CAM_CONN_STATUS_NORMAL===a.get("status"))&&(SYNO.SS.CamSts.SERVER_DISCONN!==a.get("camStatus"))){return true}}return false}});Ext.namespace("SYNO.SS.App.VideoAnalytics");Ext.define("SYNO.SS.App.VideoAnalytics.HistoryExpandableListView",{extend:"SYNO.ux.ExpandableListView",owner:null,constructor:function(a){this.owner=a.owner;var b=Ext.apply({iconTpl:new Ext.XTemplate("{#:this.RenderPreview}"),titleTpl:new Ext.XTemplate('{camera_name:this.RenderCamName}<span class="title-status">{archived:this.RenderStatus}</span>'),titleRightTpl:new Ext.XTemplate("{eventSize:this.RenderDuration}"),descTpl:new Ext.XTemplate("{startTime:this.RenderDateTime}"),descRightTpl:new Ext.XTemplate("{reason:this.RenderTypeName}"),viewStyleTpl:new Ext.XTemplate("{blViewed:this.RenderViewed}")},a);this.callParent([b]);this.AddTplRenderer()},AddTplRenderer:function(){var a=" style='color: #11AAE6 !important;'";this.tpl.owner=this.owner;this.tpl.RenderPreview=function(f,c){var e=SYNO.SS.MultiView.LIST_VIEW_IDX;var g=c.id;var d=c.snapshot_medium?"data:image/jpeg;base64,"+c.snapshot_medium:SYNO.SS.CameraPage.IMG_DISABLED[e];var b=String.format('<img src="{0}" class="analytics_list_snapshot" onerror="this.src=SYNO.SS.CameraPage.IMG_DISABLED[{1}];">',d,e);return'<div class="analytics_list_preview_ct">'+b+"</div>"};this.tpl.RenderCamName=function(d,b){var c=(""!==b.taskName)?b.taskName:_T("ss_common","status_unknown");return String.format('<span ext:qtip="{0}">{0}</span>',c)};this.tpl.RenderStatus=function(d,b){var c,e="";if(true===b.archived){c=_T("event","event_status_locked")}else{if(true===b.recording){c=_T("event","event_status_recording")}}if(c){e=String.format("&nbsp;-&nbsp;{0}",c)}return String.format("<span>{0}</span>",e)};this.tpl.RenderDateTime=function(c,b){var d=SYNO.SS.Grid.GenDateAndTimeStr(c,b);return String.format("<span>{0}</span>",d)};this.tpl.RenderDuration=function(f,d){var c=GetTimeStr(d.stopTime-d.startTime);var e=Math.round(d.event_size_bytes/(1<<20))+" MB";var b=String.format("{0} ({1})",c,e);return String.format("<span>{0}</span>",b)};this.tpl.RenderTypeName=function(c,b){var d=SYNO.SS.App.VideoAnalytics.Utils.GetTypeName(b.analyzeType);return String.format("<span>{0}</span>",d)};this.tpl.RenderViewed=function(c,b){return true}},IsReadyToPlay:function(a){return true}});Ext.define("SYNO.SS.App.VideoAnalytics.AlertFilter",{extend:"SYNO.SS.Form.FilterPanel",CAMERA_CHECK_INDEX:0,NO_FILTER_VALUE:0,owner:null,detClass:"",cmbServer:null,dsServer:null,chkAnalyzeType:null,fieldAnalyzeType:null,chkboxLock:null,cmbboxLock:null,chkboxDateFrom:null,dateFrom:null,timeFrom:null,chkboxDateTo:null,dateTo:null,timeTo:null,chkboxTask:null,dsIVATask:null,panelCamGrid:null,btnOK:null,btnCancel:null,constructor:function(a){this.owner=a.owner;this.Init();var c={cls:"filter-panel-lhs",defaults:{cls:"filter-setting-group"},items:[{items:[{xtype:"label",text:_T("ss_centralized","source")},this.cmbServer]},{items:[this.chkAnalyzeType,this.fieldAnalyzeType]},{items:[this.chkboxLock,this.cmbboxLock]},{items:[this.chkboxDateFrom,{cls:"filter-date-and-time",layout:"hbox",items:[this.dateFrom,this.timeFrom]}]},{items:[this.chkboxDateTo,{cls:"filter-date-and-time",layout:"hbox",items:[this.dateTo,this.timeTo]}]}]};var b={cls:"filter-panel-rhs filter-setting-group",items:[this.chkboxTask,this.panelCamGrid]};Ext.apply(a,{cls:"filter-panel-full-width",layout:"column",items:[c,b],buttons:[this.btnOK,this.btnCancel]});this.callParent([a]);this.on("show",function(d){this.panelCamGrid.show()},this);this.on("hide",function(d){this.panelCamGrid.hide()},this)},Init:function(){var c={hideLabel:true,blInFilterPanel:true,disabled:true,displayField:"text",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false};this.cmbServer=new SYNO.SS.Form.SourceComboBox({blShowAllCamGroups:false,blShowCamGroup:false,blShowMounted:false,blShowArchive:false,blOnlineDsOnly:true,listeners:{select:this.OnRecSrcSelect,scope:this},GetDsObj:function(){return this.store.getAt(this.store.findExact("idx",this.getValue()))},GetDsId:function(){return this.GetDsObj().get("dsId")}});this.dsServer=this.cmbServer.getStore();this.chkAnalyzeType=new SYNO.ux.Checkbox({boxLabel:_T("ss_common","application"),hideLabel:true,listeners:{check:function(e,d){this.fieldAnalyzeType.setDisabled(false===d)},scope:this}});this.fieldAnalyzeType=new SYNO.SS.Form.MultiSelectField(Ext.applyIf({strAllItems:_T("ss_common","categ_all_types"),store:new Ext.data.ArrayStore({autoDestroy:true,fields:["text"],data:[[_T("video_analytics","object_detection")],[_T("smartsearch","search_type_motion")],[_T("smartsearch","search_type_loitering_detection")],[_T("video_analytics","people_counting")],[_T("smartsearch","search_type_foreign_object")],[_T("smartsearch","search_type_missing_object")]]}),listeners:{disable:function(){this.initField()},invalid:function(){this.initField()}}},c));this.chkboxLock=new SYNO.ux.Checkbox({boxLabel:_T("event","event_col_archive"),hideLabel:true,listeners:{check:function(e,d){if(d){this.cmbboxLock.enable()}else{this.cmbboxLock.disable()}},scope:this}});var a=new Ext.data.SimpleStore({autoDestroy:true,data:[[SYNO.SS.App.Event.Def.FILE_LOCK,_T("event","archive_yes")],[SYNO.SS.App.Event.Def.FILE_NONLOCK,_T("event","archive_no")]],fields:[{name:"id"},{name:"lock"}]});this.cmbboxLock=new SYNO.ux.ComboBox({blInFilterPanel:true,hideLabel:true,store:a,valueField:"id",displayField:"lock",value:SYNO.SS.App.Event.Def.FILE_LOCK,mode:"local",editable:false,forceSelection:true,triggerAction:"all",disabled:true});this.chkboxDateFrom=new SYNO.ux.Checkbox({boxLabel:_T("event","event_time_from"),hideLabel:true,listeners:{check:function(e,d){if(d){this.dateFrom.enable();this.timeFrom.enable()}else{this.dateFrom.disable();this.timeFrom.disable()}this.SetProperDateTo(this.dateFrom,this.dateFrom.getValue())},scope:this}});this.dateFrom=new SYNO.ux.DateField({emptyText:"Select date",blInFilterPanel:true,hideLabel:true,disabled:true,editable:false,format:"Y/m/d",value:new Date(),menu:new Ext.menu.DateMenu({hideOnClick:false,focusOnSelect:false,allowOtherMenus:true}),listeners:{select:this.SetProperDateTo,scope:this}});this.timeFrom=new SYNO.ux.TimeField({blInFilterPanel:true,hideLabel:true,emptyText:"Select time",format:"H:i",disabled:true,editable:false,value:"00:00",listeners:{select:this.SetProperTimeTo,scope:this}});this.chkboxDateTo=new SYNO.ux.Checkbox({boxLabel:_T("event","event_time_to"),hideLabel:true,listeners:{check:function(e,d){if(d){this.dateTo.enable();this.timeTo.enable()}else{this.dateTo.disable();this.timeTo.disable()}this.SetProperDateFrom(this.dateTo,this.dateTo.getValue())},scope:this}});this.dateTo=new SYNO.ux.DateField({emptyText:"Select date",blInFilterPanel:true,hideLabel:true,disabled:true,editable:false,format:"Y/m/d",value:new Date(new Date().getTime()+DAY_MILLISECOND),menu:new Ext.menu.DateMenu({hideOnClick:false,focusOnSelect:false,allowOtherMenus:true}),listeners:{select:this.SetProperDateFrom,scope:this}});this.timeTo=new SYNO.ux.TimeField({name:"timeTo",blInFilterPanel:true,hideLabel:true,emptyText:"Select time",format:"H:i",disabled:true,editable:false,value:"00:00"});this.chkboxTask=new SYNO.SS.Form.Checkbox({boxLabel:_T("edge_storage","task"),hideLabel:true,ctCls:"event_filter_chkbox_camera_ct",listeners:{check:function(e,d){this.EnableTaskGridPanel(d)},scope:this}});var b={};if(false===IsCMSHost()){Ext.apply(b,{blServerChecked:true,owner_ds_id:LOCAL_DS_ID})}this.dsIVATask=new SYNO.SS.VideoAnalyticsTaskCacheStore({cmp:this,needSort:true,baseParams:b,fields:SYNO.SS.GblStore.fieldVideoAnalyticsTask});this.panelCamGrid=new SYNO.SS.Grid.GridPanel({height:284,border:true,selModel:new Ext.grid.RowSelectionModel({singleSelect:true}),store:this.dsIVATask,viewConfig:{forceFit:true,markDirty:false},colModel:SYNO.SS.Grid.CreateCheckColumnModel([{width:36,dataIndex:"check"},{id:"name",header:_T("edge_storage","task"),dataIndex:"name",renderer:this.RenderName.createDelegate(this)}],this.CAMERA_CHECK_INDEX),autoExpandColumn:"name"});this.panelCamGrid.regCheckEvent("check",this.CAMERA_CHECK_INDEX);this.btnOK=new SYNO.ux.Button({text:_T("ss_common","common_ok"),minWidth:75,btnStyle:"blue",handler:this.OnOK,scope:this});this.btnCancel=new SYNO.ux.Button({text:_T("ss_common","common_cancel"),minWidth:75,handler:this.OnCancel,scope:this});this.cmbServer.InitSource()},Activate:function(a){this.owner=a;this.OnRecSrcSelect();this.ResetElements()},ResetCamGrid:function(d){if(false===this.rendered){return}if(0===this.dsIVATask.getCount()){this.panelCamGrid.updateColHeaderCheck(false);return}var c,a;var b=[];if(true===d){this.panelCamGrid.setAllChecked(true,true)}else{this.panelCamGrid.setAllChecked(false,true);b=this.owner.filterSetting.taskList;Ext.each(b,function(e){c=this.dsIVATask.findBy(function(f){if(e.id===f.data.id){return true}return false},this);a=this.dsIVATask.getAt(c);if(undefined!==a){a.set("check",true)}},this);this.panelCamGrid.getView().refresh();this.panelCamGrid.updateColHeaderCheck(this.panelCamGrid.isAllChecked())}},EnableTaskGridPanel:function(a){var b=(0<this.dsIVATask.getTotalCount());this.panelCamGrid.setCheckColEnable(a);this.panelCamGrid.setAllChecked(b,true)},RenderName:function(c,e,a){var d=this.chkboxTask.checked;var b=(!d)?' class="disable_filter_font_color"':"";e.css=e.css+((!d)?" disable_filter_font_color":"");return'<span ext:qtip="'+c+'" onselectstart="return false;"'+b+">"+c+"</span>"},ResetElements:function(){if(false===this.rendered){return}var b=this.owner.filterSetting;var a=this.owner.blFilterShow;this.btnOK.setDisabled(false);this.chkboxTask.setValue(b.chkTask);this.panelCamGrid.setCheckColEnable(b.chkTask);if(b.srcId!==this.cmbServer.GetDsId()){this.cmbServer.SetValueByDsId(b.srcId);this.OnRecSrcSelect()}else{this.ResetCamGrid(false)}this.chkAnalyzeType.setValue(b.chkAnalyzeType);if(true===b.chkAnalyzeType){this.fieldAnalyzeType.setValue(b.analyzeType)}else{this.fieldAnalyzeType.setValue("")}this.chkboxLock.setValue(b.chkLocked);if(true===b.chkLocked){this.cmbboxLock.setValue(b.lockVal)}else{this.cmbboxLock.setValue(SYNO.SS.App.Event.Def.FILE_LOCK)}todayDate=new Date();tomDate=new Date(todayDate.getTime()+DAY_MILLISECOND);this.dateFrom.setValue(todayDate);this.dateFrom.clearInvalid();this.timeFrom.reset();this.dateTo.setValue(tomDate);this.dateTo.clearInvalid();this.timeTo.reset();var c,d="",e="";this.chkboxDateFrom.setValue(b.chkTimeFrom);if(true===b.chkTimeFrom){c=new Date(b.timestampClientDateFrom*TRANS_MILLISECOND);d=c.format("Y/m/d");e=c.format("H:i");this.dateFrom.setValue(d);this.timeFrom.setValue(e);this.SetProperDateTo(this.dateFrom,c)}this.chkboxDateTo.setValue(b.chkTimeTo);if(true===b.chkTimeTo){c=new Date(b.timestampClientDateTo*TRANS_MILLISECOND);d=c.format("Y/m/d");e=c.format("H:i");this.dateTo.setValue(d);this.timeTo.setValue(e);this.SetProperDateFrom(this.dateTo,c)}b.taskList=this.GetTaskList()},OnOK:function(m){var l=((true===IsCMSHost())||(this.owner.DEFAULT_SERVER!=this.cmbServer.GetDsId()));var e=this.chkAnalyzeType.getValue();var g=this.chkboxLock.getValue();var k=this.chkboxDateFrom.getValue();var a=this.chkboxDateTo.getValue();var c=(l||e||g||k||a||this.chkboxTask.getValue());var f=this.cmbServer.GetDsObj();this.owner.filterSetting.srcId=f.get("dsId");this.owner.filterSetting.srcName=f.get("name");this.owner.filterSetting.chkAnalyzeType=e;this.owner.filterSetting.analyzeType=(true===e)?this.fieldAnalyzeType.getValue():"";this.owner.filterSetting.chkLocked=g;this.owner.filterSetting.lockVal=(true===g)?this.cmbboxLock.getValue():0;var b=null,h="",d;this.owner.filterSetting.chkTimeFrom=k;if(true===k){b=this.dateFrom.getValue();h=this.timeFrom.getValue();d=this.DateToTimestamp(b,h);this.owner.filterSetting.timestampFrom=d.convertedTimestamp;this.owner.filterSetting.timestampClientDateFrom=d.cmbTimestamp}else{this.owner.filterSetting.timestampFrom=0;this.owner.filterSetting.timestampClientDateFrom=0}b=null;h="";this.owner.filterSetting.chkTimeTo=a;if(true===a){b=this.dateTo.getValue();h=this.timeTo.getValue();d=this.DateToTimestamp(b,h);this.owner.filterSetting.timestampTo=d.convertedTimestamp;this.owner.filterSetting.timestampClientDateTo=d.cmbTimestamp}else{this.owner.filterSetting.timestampTo=0;this.owner.filterSetting.timestampClientDateTo=0}this.owner.filterSetting.chkTask=this.chkboxTask.getValue();this.owner.filterSetting.taskList=this.GetTaskList();if(false===c){this.owner.OnFilterCancel()}else{this.owner.blFilterShow=(true===Ext.isBoolean(m))?!m:true;this.owner.PreFilter();this.owner.SetFilterInfoText();this.owner.ShowFilterPanel(this.owner.blFilterShow)}if(true===this.isVisible()){this.HideBox()}},GetTaskList:function(){var e=false;var c=[];var b=[];var d=[];var a=this.cmbServer.GetDsId();if(true===this.owner.filterSetting.chkTask){c=this.dsIVATask.query("check",true);if(ALL_SERVERS!==a){c=c.filterBy(function(f){return(a===f.get("owner_ds_id"))?true:false})}c.each(function(f){d.push({id:f.get("id"),idOnRec:(LOCAL_DS_ID===f.get("owner_ds_id"))?f.get("id"):f.get("camIdOnRecServer"),name:f.get("name")})})}else{b=this.dsIVATask.getRange();for(i=0;i<b.length;i++){recTask=b[i];d.push({id:recTask.get("id"),idOnRec:(LOCAL_DS_ID===recTask.get("owner_ds_id"))?recTask.get("id"):recTask.get("camIdOnRecServer"),name:recTask.data.name})}}return d},OnRecSrcSelect:function(){this.dsIVATask.load({owner_ds_id:this.cmbServer.GetDsId(),callback:function(){this.ResetCamGrid(true)},scope:this})},OnCancel:function(){this.HideBox()},SetDetectRegionByClass:function(a){this.detClass=a},SetProperDateTo:function(c,b){if(true===c.disabled){this.dateTo.setMinValue(null)}else{this.dateTo.setMinValue(b)}var a=new Date();if(b.getTime()>this.dateTo.getValue().getTime()){a.setTime(b.getTime()+DAY_MILLISECOND);this.dateTo.setValue(a)}this.SetProperTimeTo()},SetProperDateFrom:function(c,b){if(true===c.disabled){this.dateFrom.setMaxValue(null)}else{this.dateFrom.setMaxValue(b)}var a=new Date();if(b.getTime()<this.dateFrom.getValue().getTime()){a.setTime(b.getTime()-DAY_MILLISECOND);this.dateFrom.setValue(a)}this.SetProperTimeTo()},SetProperTimeTo:function(){var b=Date.parseDate(this.timeFrom.getValue(),"H:i");var a;if(this.dateFrom.getValue().getTime()===this.dateTo.getValue().getTime()){a=(true===this.dateFrom.disabled)?"00:00":this.timeFrom.getValue();this.timeTo.setMinValue(a);if(Date.parseDate(this.timeFrom.getValue(),"H:i").getTime()>Date.parseDate(this.timeTo.getValue(),"H:i").getTime()){if(b.getHours()==23){this.timeTo.setValue("23:45")}else{this.timeTo.setValue((b.getHours()+1)+":"+((b.getMinutes()==0)?"00":b.getMinutes()))}}}else{this.timeTo.setMinValue("00:00")}},DateToTimestamp:function(d,e){var c=d.format("Y/m/d")+" "+e+":00";var b=new Date(c);var a=ConvertTimestamp((b.getTime()/TRANS_MILLISECOND),false);return{convertedTimestamp:a,cmbTimestamp:(b.getTime()/TRANS_MILLISECOND)}}});Ext.define("SYNO.SS.App.VideoAnalytics.AlertHistory",{extend:"SYNO.ux.Panel",CLEAR_SELECTED:0,CLEAR_FILTERED:1,DEFAULT_SERVER:LOCAL_DS_ID,MAX_INT_BIT:32,blFilterShow:false,blServerCateg:false,filterSetting:null,defaultFilterSetting:null,searchStr:"",blActivated:false,owner:null,dsEvent:null,dsRecording:null,btnFilter:null,toolBtnList:null,panelFilter:null,panelFilterInfo:null,btnLock:null,menuLock:null,menuUnLock:null,btnDelete:null,btnPlay:null,btnDownload:null,btnSwitchView:null,menuDelSel:null,menuDelAll:null,contextMenu:null,dsCateg:null,gridCateg:null,gridEvtList:null,panelView:null,panelEvtList:null,panelCategContainer:null,constructor:function(b){this.owner=b;this.blServerCateg=IsCMSHost()?false:true;this.defaultFilterSetting={srcId:this.DEFAULT_SERVER,srcName:"",chkAnalyzeType:false,analyzeType:"",chkLocked:false,lockVal:0,chkTimeFrom:false,chkTimeTo:false,timestampFrom:0,timestampTo:0,timestampClientDateFrom:0,timestampClientDateTo:0,taskList:[]};this.filterSetting=SYNO.SS.Utils.DeepCopy(this.defaultFilterSetting);this.Init();var a={border:false,title:_T("video_analytics","detection_results"),tbar:new SYNO.ux.Toolbar([this.toolBtnList]),items:[this.panelFilterInfo,this.panelCategContainer]};this.callParent([a]);this.InitHandler()},Init:function(){this.dsRecording=SYNO.SS.App.VideoAnalytics.Utils.GetDsHistory(this.owner);this.menuDelSel=new Ext.menu.Item({text:_T("event","delete_selected"),handler:this.OnDeleteSelected,scope:this});this.menuDelAll=new Ext.menu.Item({text:_T("ss_common","common_delete_all"),handler:function(){if(true===this.blFilterShow){this.OnDeleteFiltered()}else{this.OnDeleteAll()}},scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),menu:{items:[this.menuDelSel,this.menuDelAll],listeners:{beforeshow:function(){var d=(true===this.blFilterShow)?_T("event","delete_filtered"):_T("ss_common","common_delete_all");this.menuDelAll.setText(d)},scope:this}},scope:this});this.menuLock=new Ext.menu.Item({text:_T("ss_common","common_lock"),handler:function(){this.OnLock(true)},scope:this});this.menuUnLock=new Ext.menu.Item({text:_T("ss_common","common_unlock"),handler:function(){this.OnLock(false)},scope:this});this.btnLock=new SYNO.ux.Button({text:_T("ss_common","common_lock"),menu:{items:[this.menuLock,this.menuUnLock]}});this.btnReport=new SYNO.ux.Button({text:_T("video_analytics","people_counting_report"),handler:this.OnReport,scope:this});this.panelFilter=new SYNO.SS.App.VideoAnalytics.AlertFilter({owner:this});this.panelFilter.SetDetectRegionByClass("x-form-field-wrap-center-img");this.btnFilter=new SYNO.SS.Form.FilterButton({iconCls:"icon_search",text:_T("ss_common","common_search"),tooltip:_T("ss_common","common_search"),panelFilterForm:this.panelFilter});this.panelFilter.SetToggleBtn(this.btnFilter);this.btnPlay=new SYNO.ux.Button({name:"btnPlay",text:_T("event","event_play"),handler:this.PrePlay,scope:this});this.btnDownload=new SYNO.ux.Button({name:"btnDownload",text:_T("event","event_export"),handler:function(){this.OnDownload()},scope:this});this.panelFilterInfo=new SYNO.ux.FilterInfo({fnCancel:this.OnFilterCancel,fnCancelScope:this,fnReload:this.panelFilter.OnOK,fnReloadScope:this.panelFilter});this.dsCateg=new Ext.data.JsonStore({autoDestroy:true,fields:["id","type","category","entryName","entryVal","recCnt","date","grpHdrName","dsId"]});var c,a,b;if(true===IsCMSHost()){a=[SYNO.SS.Grid.Categ.CATEG_SERVER];b=[SYNO.SS.Grid.Categ.CATEG_DATE];c=a.concat(b)}else{a=[SYNO.SS.Grid.Categ.CATEG_DATE];c=a}this.gridCateg=new SYNO.SS.Grid.CategoryGridPanel({cls:"flexcroll_extra_left",enableDragDrop:true,category:c,firstCateg:a,secondCateg:b,useGoBackTbar:true,useSplitSwitchBtn:false,fnShowGoBackTbar:this.ShowGoBackTbar.createDelegate(this),fnShowFirstCateg:this.ShowEvtByDs.createDelegate(this),categWithDetail:[SYNO.SS.Grid.Categ.CATEG_SERVER],store:this.dsCateg,blCategSubMenu:false,viewConfig:{forceFit:true},ShowContextMenu:this.ShowGridCategContextMenu.createDelegate(this)});this.btnSwitchView=this.gridCateg.btnSwitch;this.gridEvtList=new SYNO.SS.App.VideoAnalytics.HistoryExpandableListView({owner:this,store:this.dsRecording,gridCateg:this.gridCateg,pageSize:SYNO.SS.App.VideoAnalytics.Def.HISTORY_PAGE_SIZE,playIconOnPreview:true,allowMultiPlay:SYNO.SS.Utils.IsSupportStreaming(),fnPlay:this.OnPlay.createDelegate(this),listeners:{selectionchange:this.ChgButtonStatus,contextmenu:this.OnContextMenuListView,scope:this}});this.panelView=new SYNO.SS.ViewPanel({view:this.gridEvtList,height:100,plugins:SYNO.SS.Pgls.CreatePglsPlugin({ptype:"synoSSPglsCategPlugin",store:this.dsRecording,idProp:"id",gridCateg:this.gridCateg,pageSize:SYNO.SS.App.VideoAnalytics.Def.HISTORY_PAGE_SIZE,preloadSize:100,blPreloadAll:false,GetParams:this.GetFilterParams.createDelegate(this),divLoadingHeight:64,sortCfg:[{field:"id",direction:"DESC"}]})});this.panelEvtList=new SYNO.ux.Panel({region:"center",layout:"fit",items:[this.panelView],bbar:new SYNO.SS.Pgls.BottomBar({refreshFunction:this.Refresh,refreshFunctionScope:this})});this.panelCategContainer=new SYNO.SS.Pgls.PglsCategContainerPanel({items:[this.gridCateg,this.panelEvtList],gridCateg:this.gridCateg,panelRecord:this.panelView,labelItemCnt:this.panelEvtList.getBottomToolbar().labelItemCnt,dsRecord:this.dsRecording,noCacheEntries:[SYNO.SS.Grid.Categ.ENTRY_DS],countMethod:"CountByCategory",countVersion:1,countParams:{},GetCountParams:this.GetCountParams.createDelegate(this),GetParams:this.GetFilterParams.createDelegate(this),emptyStyleMonStore:this.dsRecording,emptyStyleTip:_T("video_analytics","no_history_tip"),emptyStyleTipFunc:this.OnClickHyperLink,fnNeedApplyEmptyStyle:this.HasNoRecord.createDelegate(this),plugins:SYNO.SS.AutoUpdate.CreatePluginWithDsId("dsId","",{blUpdAllDs:false,blFromWebsocket:true,GetRecCntParamMethod:this.GetCntParam,CheckRecIsAddedMethod:this.IsRecordAdded,CheckRecIsDeletedMethod:this.IsRecordDeleted,fnRefresh:this.Refresh.createDelegate(this),fnCompare:function(e,d){if(e.data.startTime>d.data.startTime){return -1}else{if(e.data.startTime<d.data.startTime){return 1}else{if(e.id>d.id){return -1}else{if(e.id<d.id){return 1}else{return 0}}}}},storeSortCfg:[{field:"id",direction:"DESC"}]})});this.toolBtnList=[this.btnPlay,this.btnDownload,this.btnDelete,this.btnLock,this.btnReport,{xtype:"tbfill"},this.btnSwitchView,this.btnFilter]},InitHandler:function(){this.dsRecording.on("load",function(){this.gridCateg.ReloadDsCateg()},this);this.dsRecording.on("exception",function(){this.owner.getMsgBox().alert(this.title,_T("ss_common","error_system"))},this);if(true===IsCMSHost()){this.mon(this.gridCateg,"enterdetail",function(c,b){var a=b.get("entryVal");var d=this.panelFilter.dsServer.findExact("id",a);this.blServerCateg=true;this.panelFilter.cmbServer.setValue(d);this.panelFilter.OnOK(true);this.gridCateg.SetGoBackTbarTxt(SYNO.SS.GblStore.GetDsName(a))},this);this.mon(this.gridCateg,"gobacklinkclick",function(){var a=this.filterSetting.srcId;this.blServerCateg=false;this.gridCateg.SelEntryByValAfterReload(a);this.OnFilterCancel(a)},this)}this.mon(SYNO.SDS.StatusNotifier,"ivaRecordingUpdate",this.OnWebSocketCallback,this)},Resize:function(){var a=this.owner.getInnerWidth();var d=this.owner.getInnerHeight();var c=d-78;var b=0;if(true===this.blFilterShow){b=SYNO.SS.Ui.Height.FILTER_PANEL_DEFAULT;c=c-b}this.panelCategContainer.setSize(a,c);this.panelCategContainer.syncSize();this.panelFilterInfo.setVisible(this.blFilterShow)},InitContextMenu:function(){this.contextMenu=new SYNO.ux.Menu({items:[{itemId:"cmPlayEvent",text:_T("event","event_play"),scope:this,handler:this.PrePlay},{itemId:"cmDownloadEvent",text:_T("event","event_export"),scope:this,handler:this.OnDownload},{itemId:"cmDeleteEvent",text:_T("ss_common","common_delete"),scope:this,handler:this.OnDeleteSelected},{itemId:"cmLockEvent",text:_T("ss_common","common_lock"),scope:this,handler:function(){this.OnLock(true)}},{itemId:"cmUnockEvent",text:_T("ss_common","common_unlock"),scope:this,handler:function(){this.OnLock(false)}}]});this.addManagedComponent(this.contextMenu)},OnContextMenuListView:function(b,a,c,d){if(false===b.isSelected(a)){b.select(a)}this.ShowContextMenu(d)},ShowContextMenu:function(b){var a;if(!this.contextMenu){this.InitContextMenu()}this.contextMenu.getComponent("cmLockEvent").hide();this.contextMenu.getComponent("cmUnockEvent").hide();if(!this.menuLock.disabled){this.contextMenu.getComponent("cmLockEvent").show()}if(!this.menuUnLock.disabled){this.contextMenu.getComponent("cmUnockEvent").show()}this.contextMenu.getComponent("cmPlayEvent").setVisible(!this.btnPlay.disabled);this.contextMenu.getComponent("cmDownloadEvent").setVisible(!this.btnDownload.disabled);if((this.btnDelete.disabled)||(this.menuDelSel.disabled)){this.contextMenu.getComponent("cmDeleteEvent").hide()}else{this.contextMenu.getComponent("cmDeleteEvent").show()}b.stopEvent();for(a=0;a<this.contextMenu.items.getCount();++a){if(false===this.contextMenu.items.get(a).hidden){this.contextMenu.showAt(b.getXY());break}}},Activate:function(){if(true===this.blActivated){return}this.blActivated=true;this.ActivateFilterForm()},ActivateFilterForm:function(){this.MaskGrid(true);this.ResetFilterSetting();this.panelFilter.Activate(this);this.UpdateBaseParams();this.Refresh(false);this.MaskGrid(false)},Deactivate:function(){this.blActivated=false;this.panelFilter.destroy()},ChgButtonStatus:function(){if(false===this.blActivated){return}var d=this.gridEvtList.getSelectedRecords();var b=d.length;this.btnPlay.disable();this.btnDownload.disable();this.menuLock.disable();this.menuUnLock.disable();this.menuDelSel.disable();this.btnDelete.disable();var e=false;var c=false;var a=false;Ext.each(d,function(f){if(true===f.get("archived")){e=true}else{c=true}if(true===f.get("recording")){a=true}});if(1<=this.dsRecording.getCount()){this.btnDelete.enable()}if(1<=b){if((1<b)||((1==b)&&(false===e))){this.menuDelSel.enable()}if(1===b){this.btnPlay.enable();this.btnDownload.enable()}if(false==a){if(true===e){this.menuUnLock.enable()}if(true===c){this.menuLock.enable()}}}if((true===this.menuLock.disabled)&&(true===this.menuUnLock.disabled)){this.btnLock.disable()}else{this.btnLock.enable()}},CheckEmptyRecord:function(){return(0===this.dsRecording.getCount())},ShowGridCategContextMenu:function(c){this.ChgButtonStatus();var b=!this.btnDelete.disabled&&(false===this.ShowEvtByDs()&&(false===this.gridCateg.IsCurCategEntryAll()));var a=[];var d;if(true===b){a.push({text:_T("ss_common","common_delete"),scope:this,handler:this.OnDeleteSelected})}if(0<a.length){a.push({itemId:"cmShortcutSeparator",xtype:"menuseparator"})}a.push({itemId:"cmAddDesktopShortcut",text:_T("desktop","add_desktop_shortcut"),handler:function(){this.fireEvent("shortcutOnAddCateg")},scope:this});d=new SYNO.ux.Menu({items:a});d.showAt(c.getXY())},PrePlay:function(){var a=this.gridEvtList.getSelectedRecords()[0];if(a){this.OnPlay(a)}},OnPlay:function(a){if((SYNO.SS.UserPrivType.MANAGER===_S("USER_PRIVILEGE"))&&(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.PLAYBACK))){this.owner.getMsgBox().alert(this.title,_T("ss_privilege","no_permission_play_video"));return}SYNO.SS.App.VideoAnalytics.Utils.DoPlay(this.dsRecording,a)},OnDeleteSelected:function(){var a=this.owner.getMsgBox();a.confirm(this.title,_T("liveview_analytics","history_clear_confirm"),function(b){if("yes"===b){this.DoDeleteBySelected()}},this)},OnDeleteFiltered:function(){var a=this.owner.getMsgBox();a.confirm(this.title,_T("liveview_analytics","history_clear_filtered_confirm"),function(b){if("yes"===b){this.DoDeleteByFilter()}},this)},OnDeleteAll:function(){this.owner.getMsgBox().confirm(this.title,_T("liveview_analytics","history_clear_all_confirm_msg"),function(a){if("yes"===a){this.DoDeleteAll()}},this)},DoDeleteBySelected:function(){var a=this.gridEvtList.getSelectedRecords();var c,b=[];a.each(function(d){b.push(d.get("id"))});c={deleteMethod:SYNO.SS.App.VideoAnalytics.Def.DELETE_METHOD.FILTER,dsId:a.first().get("dsId"),idList:b.join(",")};this.MaskGrid(true);this.owner.sendWebAPI({api:"SYNO.SurveillanceStation.IVA.Recording",version:1,method:"Delete",params:c,callback:this.OnDeleteDone,scope:this})},DoDeleteByFilter:function(){var a=this.GetFilterParams(true);a.deleteMethod=SYNO.SS.App.VideoAnalytics.Def.DELETE_METHOD.FILTER;this.MaskGrid(true);this.owner.sendWebAPI({api:"SYNO.SurveillanceStation.IVA.Recording",version:1,method:"Delete",params:a,callback:this.OnDeleteDone,scope:this})},DoDeleteAll:function(a){this.MaskGrid(true);this.owner.sendWebAPI({api:"SYNO.SurveillanceStation.IVA.Recording",version:1,method:"Delete",params:{deleteMethod:SYNO.SS.App.VideoAnalytics.Def.DELETE_METHOD.ALL},callback:this.OnDeleteDone,scope:this})},OnDeleteDone:function(c,b){var a="";if(true===c){this.Refresh(false)}else{a=(b&&b.code)?SYNO.API.getErrorString(b.code):_T("ss_common","error_system");this.owner.getMsgBox().alert(this.title,a)}this.MaskGrid(false)},OnDownload:function(){var a=this.gridEvtList.getSelectedRecords()[0];if(undefined===a){return}a.set("blSetPrefix",true);a.set("filePrefix",a.get("taskName"));SYNO.SS.App.Event.Utils.DoEventDownload(a,this)},OnLock:function(b){var a=this.gridEvtList.getSelectedRecords();SYNO.SS.App.VideoAnalytics.Utils.OnLock(b,a,this)},OnLockDone:function(b,a){this.dsRecording.load({params:this.GetFilterParams(true),scope:this});this.ChgButtonStatus()},GetFilterAnalyzeType:function(b){if(true===b.empty()){return""}var a=[];b.split(",").each(function(c){a.push(parseInt(c,10))});return a.join(",")},PreFilter:function(){this.UpdateBaseParams();this.Refresh(false)},Refresh:function(a){if(false===a){this.MaskGrid(true)}this.dsRecording.load({params:this.GetFilterParams(true),callback:function(e,b,d,c){if(false===this.blActivated){return}this.OnSearchField();if(false===a){this.MaskGrid(false)}},scope:this})},UpdateBaseParams:function(){this.dsRecording.setBaseParam("dsId",this.filterSetting.srcId);this.dsRecording.setBaseParam("taskIdList",this.GetTaskIdList());this.dsRecording.setBaseParam("analyzeType",this.GetFilterAnalyzeType(this.filterSetting.analyzeType));this.dsRecording.setBaseParam("locked",this.filterSetting.lockVal);this.dsRecording.setBaseParam("startTime",this.filterSetting.timestampFrom);this.dsRecording.setBaseParam("endTime",this.filterSetting.timestampTo);this.gridCateg.ScrollToTop();this.gridCateg.selModel.clearSelections()},GetFilterParams:function(b){var d=Ext.apply({},this.dsRecording.baseParams);d.limit=SYNO.SS.App.VideoAnalytics.Def.HISTORY_PAGE_SIZE;var a=this.gridCateg.curEntry;if(true===b){switch(a.type){case SYNO.SS.Grid.Categ.ENTRY_DS:d.dsId=a.entryVal;break;case SYNO.SS.Grid.Categ.ENTRY_IVA_ANALYZE_TYPE:d.analyzeType=a.entryVal.toString();break;case SYNO.SS.Grid.Categ.ENTRY_DAY:case SYNO.SS.Grid.Categ.ENTRY_AM:case SYNO.SS.Grid.Categ.ENTRY_PM:var c=SYNO.SS.Grid.Categ.GetTimeInSec(a.entryVal);d.startTime=c.start;d.endTime=c.end;break;default:break}}return d},MaskGrid:function(a){this.owner.MaskGrid(a)},IsMasked:function(){return this.owner.IsMasked()},IsDirty:function(){return false},Reset:function(){},GetEventParamByHistory:function(a){return{includeAllCam:false,cameraIds:a.get("cameraId").toString(),overlappingTimeList:a.get("timestamp").toString(),evtSrcId:a.get("dsId")}},OnReport:function(){this.dlgReport=new SYNO.SS.App.VideoAnalytics.Report({dsId:0,camId:0,camName:"camName",analyzeType:0,parentWin:this.owner});this.dlgReport.show();this.dlgReport.Activate()},ShowEvtByDs:function(){return((!this.blServerCateg)&&(!this.blFilterShow))},ShowGoBackTbar:function(){return((true==IsCMSHost())&&(this.blServerCateg))},GetCountParams:function(){return{dsId:this.filterSetting.srcId,totalCountOnly:this.ShowEvtByDs(),timezone:GetTimezoneOffset(true),taskIdList:this.GetTaskIdList(),analyzeType:this.GetFilterAnalyzeType(this.filterSetting.analyzeType),locked:this.filterSetting.lockVal,startTime:this.filterSetting.timestampFrom,endTime:this.filterSetting.timestampTo}},HasNoRecord:function(){return((false===this.blFilterShow)&&(0===this.gridCateg.GetTotalCount()))},GetTaskIdList:function(){var a=[];this.filterSetting.taskList.each(function(b){a.push(b.id)});return a.join(",")},ResetFilterSetting:function(){this.blFilterShow=false;this.filterSetting=SYNO.SS.Utils.DeepCopy(this.defaultFilterSetting);this.panelFilter.ResetElements();this.panelFilterInfo.hide()},OnFilterCancel:function(){this.ResetFilterSetting();this.panelFilter.ResetElements();this.ShowFilterPanel(false);this.PreFilter()},SetFilterInfoText:function(){if(false===this.blFilterShow){return}var h={recCnt:this.gridCateg.GetTotalCount(),conditions:[]};if((true===IsCMSHost())&&(ALL_SERVERS!==this.filterSetting.srcId)){h.conditions.push({header:_T("ss_centralized","label_server"),text:this.filterSetting.srcName,blForceSelSrc:true,fnCancel:function(){this.cmbServer.setValue(this.owner.DEFAULT_SERVER)},scope:this.panelFilter})}if(true===this.filterSetting.chkAnalyzeType){h.conditions.push({header:_T("ss_common","common_type"),text:this.panelFilter.fieldAnalyzeType.GetDisplayedString(this.filterSetting.analyzeType),fnCancel:function(){this.chkAnalyzeType.setValue(false)},scope:this.panelFilter})}if(true===this.filterSetting.chkLocked){h.conditions.push({header:_T("event","event_col_archive"),text:(SYNO.SS.App.Event.Def.FILE_LOCK===this.filterSetting.lockVal)?_T("event","archive_yes"):_T("event","archive_no"),fnCancel:function(){this.chkboxLock.setValue(false)},scope:this.panelFilter})}var b,f,g;if(true===this.filterSetting.chkTimeFrom){b=new Date(this.filterSetting.timestampClientDateFrom*TRANS_MILLISECOND);f=b.format("Y/m/d H:i");h.conditions.push({header:_T("event","event_time_from"),text:f,fnCancel:function(){this.chkboxDateFrom.setValue(false);this.dateFrom.setValue(new Date());this.timeFrom.reset();if(true===this.chkTimeTo){var k=new Date(this.timestampTo*TRANS_MILLISECOND);this.SetProperDateFrom(this.dateTo,k)}else{var l=new Date(new Date().getTime()+DAY_MILLISECOND);this.dateTo.setValue(l);this.timeTo.reset()}},scope:this.panelFilter})}if(true===this.filterSetting.chkTimeTo){b=new Date(this.filterSetting.timestampClientDateTo*TRANS_MILLISECOND);f=b.format("Y/m/d H:i");h.conditions.push({header:_T("event","event_time_to"),text:f,fnCancel:function(){this.chkboxDateTo.setValue(false);var l=new Date(new Date().getTime()+DAY_MILLISECOND);this.dateTo.setValue(l);this.timeTo.reset();if(true===this.chkTimeFrom){var k=new Date(this.timestampFrom*TRANS_MILLISECOND);this.SetProperDateTo(this.dateFrom,k)}else{this.dateFrom.setValue(new Date());this.timeFrom.reset()}},scope:this.panelFilter})}var e=this.filterSetting.taskList.length;var d=0,c=[],a=_T("ss_common","common_none");if(true===this.filterSetting.chkTask){if(0<e){for(d=0;d<e;d++){c.push(this.filterSetting.taskList[d].name)}a=c.join(", ")}h.conditions.push({header:_T("menu","menu_device"),text:a,fnCancel:function(){this.chkboxTask.setValue(false)},scope:this.panelFilter})}this.panelFilterInfo.SetInfo(h)},ShowFilterPanel:function(a){this.blFilterShow=a;this.Resize()},CheckFilterParams:function(c,b){if(ALL_SERVERS!==c.dsId){if(c.dsId!==b.dsId){return false}}if(""!==c.taskIdList){if(-1===(c.taskIdList).split(",").indexOf(b.id.toString())){return false}}if(0<c.startTime){if(c.startTime>b.timestamp){return false}}if(0<c.endTime){if(c.endTime<b.timestamp){return false}}if(""!==c.analyzeType){if(-1===(c.analyzeType).split(",").indexOf(b.analyze_type.toString())){return false}}if(0!==c.locked){var a=(SYNO.SS.App.Event.Def.FILE_LOCK===c.locked);if(b.archived!==a){return false}}return true},OnSearchField:function(){if(this.blFilterShow){this.SetFilterInfoText()}this.ChgButtonStatus()},OnClickHyperLink:function(){SYNO.SDS.StatusNotifier.fireEvent("GoToIVATaskList")},OnWebSocketCallback:function(b){if(b){if(b.reload){this.Refresh();return}var a=this.PrepareAutoUpdateData(b.event);this.panelCategContainer.auplugin.dsAutoUpdate.loadData(a)}},PrepareAutoUpdateData:function(a){var b=this.panelCategContainer.auplugin.AT_DELETE_BY_RECORD_ID;var f=[],d=[];var e=this.GetFilterParams(true);var c={};c[b]={};c[b].data=[];a.each(function(g){if(true===Array.isArray(g)){for(j=0;j<g.length;j++){this.PrepareData(g[j],e,c[b],f,d)}}else{this.PrepareData(g,e,c[b],f,d)}},this);return{events:f,auInfo:c,categCntData:d}},PrepareData:function(a,d,c,e,b){if(true===this.CheckFilterParams(d,a)){if(true===a.markAsDel){c.data.push({id:a.id.toString()})}else{e.push(a)}}b.push(a)},IsRecordAdded:function(a){return(true===a.blNew)},IsRecordDeleted:function(a){return(true===a.markAsDel)},GetCntParam:function(b,a){var c={};if(SYNO.SS.Grid.Categ.CATEG_DATE===b){c.time=a.startTime}else{if(SYNO.SS.Grid.Categ.CATEG_IVA_ANALYZE_TYPE===b){c.key=a.analyze_type}else{if(SYNO.SS.Grid.Categ.CATEG_SERVER===b){c.key=a.dsId}}}return c}});Ext.define("SYNO.SS.App.VideoAnalytics.Report",{extend:"SYNO.SDS.BaseWindow",MIN_HEIGHT:545,MIN_WIDTH:1000,COMBO_WIDTH:177,FIELDSET_WIDTH:190,SIDE_WIDTH:200,REPORT_HEIGHT:500,REPORT_WIDTH:760,BOUNDARY_MARGIN:10,START_BOUNDARY_X:0,END_BOUNDARY_X:0.98,START_BOUNDARY_Y:0.02,END_BOUNDARY_Y:0.98,HORIZON_WIDTH:0.9,VERTICAL_SPEC:[{WIDTH:0.4,X:[0.3]},{WIDTH:0.25,X:[0.225,0.525]}],TIPS_SPEC:{X:0.87,Y:0.03,WIDTH:0.11,HEIGHT:0.07},HORIZON_NUM:15,STANDARD_SET:[[14],[28],[70]],VERTICAL_STYLE:["#00B3BF","#FC9F54"],BLACK_STYLE:"#595F6D",WHITE_STYLE:"rgb(255, 255, 255)",TEXT_COLOR:"#595F6D",LINE_COLOR:"#E0E0E0",TEXT_FONT:"10px sans-serif",dsId:0,camName:"",recordPerBin:0,analyzeType:SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.NONE,standard:75,interval:SYNO.SS.App.VideoAnalytics.Def.Frequency.DAILY,reportType:SYNO.SS.App.VideoAnalytics.Def.REPORT_TYPE.HISTOGRAM,bInited:false,targetHistogram:null,canvas:null,canvasContext:null,dsStatistics:null,btnExport:null,fldDate:null,ctCanvas:null,ctReport:null,panelSide:null,panelContainer:null,dsReportHorizon:null,dsReportVertical:null,horizonIntercept:28,fsSource:null,fsDisplay:null,fsControl:null,constructor:function(a){this.dsId=a.dsId;this.taskId=a.taskId;this.camName=a.camName;this.analyzeType=a.analyzeType;this.recordPerBin=this.GetNumOfRecordPerBin();this.parentWin=a.parentWin;this.targetHistogram=[-1,-1];this.Init();var b={title:_T("video_analytics","people_counting_report"),layout:"fit",items:this.panelContainer,width:this.MIN_WIDTH,height:this.MIN_HEIGHT,minimizable:false,listeners:{afterlayout:this.OnRelayout,scope:this}};this.callParent([b])},Init:function(){if(true===this.bInited){return}this.dsIVATask=new SYNO.SS.VideoAnalyticsTaskCacheStore({cmp:this,fields:SYNO.SS.GblStore.fieldVideoAnalyticsTask,baseParams:{analyzeType:SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.PEOPLE_COUNTING},listeners:{load:function(){if(0===this.dsIVATask.data.length){this.cmbIVATask.emptyText=_T("video_analytics","no_available_task")}else{this.cmbIVATask.emptyText=_T("ss_common","common_select");this.cmbIVATask.setValue(this.dsIVATask.getAt(0).get("id"));this.cmbIVATask.fireEvent("select",this.cmbIVATask)}this.cmbIVATask.applyEmptyText()},scope:this}});this.dsReportVertical=new SYNO.API.JsonStore({autoDestroy:true,appWindow:this,api:"SYNO.SurveillanceStation.IVA.Report",method:"GetReport",version:1,dsId:this.dsId,baseParams:{timezone:GetTimezoneOffset(true),interval:SYNO.SS.App.VideoAnalytics.Def.Frequency.DAILY},root:"report",totalProperty:"total",idProperty:"id",fields:["id","time","count0","count1"]});this.cmbIVATask=new SYNO.ux.ComboBox({name:"task_id",width:this.COMBO_WIDTH,hideLabel:true,valueField:"id",displayField:"name",mode:"local",editable:false,forceSelection:true,triggerAction:"all",emptyText:_T("ss_common","common_select"),store:this.dsIVATask,disabled:false,listeners:{select:function(e){this.taskId=e.getValue();this.OnReportParamsChange()},scope:this}});this.calendar=new SYNO.SS.App.VideoAnalytics.ReportDatePicker({parentWin:this,disabledDatesText:_T("event","no_event_to_play"),showToday:false,disabled:false});var d=new Ext.menu.DateMenu({hideOnClick:false,focusOnSelect:false,allowOtherMenus:true,cls:"ss-datefield-menu",picker:this.calendar,listeners:{select:this.OnSelectedDateChange,scope:this}});this.dateField=new SYNO.ux.DateField({emptyText:"Select date",format:"Y/m/d",width:this.COMBO_WIDTH,hideLabel:true,disabled:false,editable:false,value:new Date(),menu:d});this.fsSource=new SYNO.ux.FieldSet({title:_T("ss_common","source"),collapsible:true,width:this.FIELDSET_WIDTH,items:[this.cmbIVATask,this.dateField]});this.cmbReportType=new SYNO.ux.ComboBox({name:"report_type",width:this.COMBO_WIDTH,hideLabel:true,valueField:"type",displayField:"text",mode:"local",editable:false,forceSelection:true,triggerAction:"all",disabled:false,value:SYNO.SS.App.VideoAnalytics.Def.REPORT_TYPE.HISTOGRAM,store:new Ext.data.ArrayStore({autoDestroy:true,data:SYNO.SS.App.VideoAnalytics.Def.ReportType,fields:["type","text"]}),listeners:{select:function(e){this.reportType=e.getValue();this.OnReportParamsChange()},scope:this}});this.cmbInterval=new SYNO.ux.ComboBox({name:"interval",width:this.COMBO_WIDTH,hideLabel:true,valueField:"type",displayField:"text",mode:"local",editable:false,forceSelection:true,triggerAction:"all",disabled:false,value:SYNO.SS.App.VideoAnalytics.Def.Frequency.DAILY,store:new Ext.data.ArrayStore({autoDestroy:true,data:SYNO.SS.App.VideoAnalytics.Def.ReportInterval,fields:["type","text"]}),listeners:{select:function(e){this.interval=e.getValue();this.ReloadIntervalUnit();this.OnReportParamsChange()},scope:this}});this.cmbIntervalUnit=new SYNO.ux.ComboBox({name:"intervalUnit",width:this.COMBO_WIDTH,hideLabel:true,valueField:"type",displayField:"text",mode:"local",editable:false,forceSelection:true,triggerAction:"all",disabled:false,value:SYNO.SS.App.VideoAnalytics.Def.IntervalUnit.ONE_HOUR,store:new Ext.data.ArrayStore({autoDestroy:true,data:SYNO.SS.App.VideoAnalytics.Def.IntervalUnitDaily,fields:["type","text"]}),listeners:{select:function(e){this.OnReportParamsChange()},scope:this}});this.cmbPeopleMode=new SYNO.ux.ComboBox({name:"people_mode",width:this.COMBO_WIDTH,hideLabel:true,valueField:"type",displayField:"text",mode:"local",editable:false,forceSelection:true,triggerAction:"all",disabled:false,value:SYNO.SS.App.VideoAnalytics.Def.PeopleModeType.ENTER_AND_LEAVE,store:new Ext.data.ArrayStore({autoDestroy:true,data:SYNO.SS.App.VideoAnalytics.Def.PeopleMode,fields:["type","text"]}),listeners:{select:this.OnReportParamsChange,scope:this}});this.fsDisplay=new SYNO.ux.FieldSet({title:_T("ss_common","display"),collapsible:true,width:this.FIELDSET_WIDTH,items:[this.cmbReportType,this.cmbInterval,this.cmbIntervalUnit,this.cmbPeopleMode]});this.btnExport=new SYNO.ux.Button({text:_T("video_analytics","export"),width:this.COMBO_WIDTH,handler:this.OnExport,scope:this});this.fsControl=new SYNO.ux.FieldSet({title:_T("ss_common","operation"),collapsible:true,width:this.FIELDSET_WIDTH,items:[this.btnExport]});var a=Math.max(this.MIN_WIDTH,GetDisplayWidth());var c=Math.max(this.MIN_HEIGHT,GetDisplayHeight());this.panelSide=new SYNO.ux.Panel({region:"west",bodyBorder:false,border:true,width:this.SIDE_WIDTH,hegiht:c,layout:"form",items:[this.fsSource,this.fsDisplay,this.fsControl],listeners:{afterrender:function(e){e.getEl().createChild({cls:"x-splitbar-h grid-split-bar"})}}});this.ctCanvas=new Ext.Container({html:"<canvas></canvas>",height:this.REPORT_HEIGHT,border:true});this.bottombar=new SYNO.SS.App.VideoAnalytics.Report.BottomBar({store:this.dsReportVertical,refreshFunction:this.OnRefresh,refreshFunctionScope:this,showTotalCnt:true});var b=new Ext.grid.ColumnModel([{header:_T("event","date"),align:"center",dataIndex:"time",renderer:this.RenderText.createDelegate(this)},{header:_T("ss_common","common_enter"),align:"center",dataIndex:"count0",renderer:this.RenderText.createDelegate(this)},{header:_T("ss_common","common_exit"),align:"center",dataIndex:"count1",renderer:this.RenderText.createDelegate(this)}]);this.gridTable=new SYNO.SS.Grid.GridPanel({cls:"grid_row_height_fixed",width:786,style:"padding-top: 14px; padding-left: 16px",store:this.dsReportVertical,border:false,cm:b,viewConfig:{forceFit:true}});this.panelTable=new SYNO.ux.Panel({layout:"fit",height:this.REPORT_HEIGHT,flex:1,cls:"ss-list-container",items:this.gridTable,bbar:this.bottombar});this.ctReport=new Ext.Container({region:"center",items:[this.ctCanvas,this.panelTable]});this.panelContainer=new SYNO.ux.Panel({layout:"border",bodyBorder:false,border:false,cls:"cms-wrap-panel "+SYNO.SS.Grid.Categ.CLS_CATEG_CONTAINER,width:a,height:c,items:[this.panelSide,this.ctReport]});this.bInited=true},Activate:function(){if(!this.canvasObj){this.canvasObj=this.el.dom.querySelector("canvas");this.canvasObj.addEventListener("mousemove",this.CanvasMouseMove.bind(this))}this.dsIVATask.load();this.OnRefresh()},OnRefresh:function(){this.OnReportParamsChange()},OnReportParamsChange:function(){this.ChgButtonStatus();if(false===Ext.isEmpty(this.taskId)){this.dsReportVertical.load({params:{taskId:this.taskId,interval:this.interval,intervalUnit:this.cmbIntervalUnit.getValue(),timestamp:this.calendar.GetUTCTime()},callback:this.DrawReport,scope:this})}else{this.DrawReport()}},ChgButtonStatus:function(){var a=Ext.isEmpty(this.cmbIVATask.getValue());this.dateField.setDisabled(a);this.cmbReportType.setDisabled(a);this.cmbInterval.setDisabled(a);this.cmbIntervalUnit.setDisabled(a);this.cmbPeopleMode.setDisabled(a||(SYNO.SS.App.VideoAnalytics.Def.REPORT_TYPE.HISTOGRAM!==this.reportType));this.btnExport.setDisabled(a)},ReloadIntervalUnit:function(){var d=this.cmbInterval.getValue();var c=SYNO.SS.App.VideoAnalytics.Def;var a;if(c.Frequency.DAILY===d){a=c.IntervalUnitDaily}else{if(c.Frequency.MONTHLY===d){a=c.IntervalUnitMonthly}else{a=c.IntervalUnitYearly}}this.cmbIntervalUnit.store.loadData(a);var b=a.first()[0];this.cmbIntervalUnit.setValue(b)},OnExport:function(){var a={userId:_S("USER_ID"),taskId:this.taskId,rawData:this.canvas.toDataURL()};this.sendWebAPI({api:"SYNO.SurveillanceStation.IVA.Report",version:1,method:"UploadReportImgData",params:a,callback:function(b,d,f,c){if(b){var e={userId:_S("USER_ID"),taskId:this.taskId,interval:this.interval,intervalUnit:this.cmbIntervalUnit.getValue(),timezone:GetTimezoneOffset(true),timestamp:this.calendar.GetUTCTime(),filename:d.filename};this.parentWin.downloadWebAPI({webapi:{api:"SYNO.SurveillanceStation.IVA.Report",version:1,method:"Download",params:e},scope:this.parentWin})}else{this.getMsgBox().alert(this.alertTitle,_T("ss_common","error_system"))}},scope:this})},OnSelectedDateChange:function(b,a){this.OnReportParamsChange()},InitCanvas:function(){this.canvas=this.el.dom.querySelector("canvas");this.canvas.width=this.ctCanvas.getWidth();this.canvas.height=this.ctCanvas.getHeight();this.canvasContext=this.canvas.getContext("2d");this.canvasContext.lineWidth=1.5;this.canvasContext.strokeStyle="rgb(200, 200, 200)";this.canvasContext.textAlign="center"},CountToHeight:function(a){return a/this.standard*this.horizonIntercept*(this.HORIZON_NUM-1)},OnRelayout:function(){if(this.canvas){var a=this.ctReport.getHeight()-this.BOUNDARY_MARGIN;this.ctCanvas.setHeight(a);this.panelTable.setHeight(a);this.DrawReport()}},GetNumOfRecordPerBin:function(){switch(this.analyzeType){case SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.MOTION_DETECTION:return 1;case SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.PEOPLE_COUNTING:return 2;default:return 2}},CanvasMouseMove:function(b){var d=b.layerX;var a=b.layerY;var c=this.CheckIfMouseInHistograms(d,a);if((c[0]!==this.targetHistogram[0])||(c[1]!==this.targetHistogram[1])){this.targetHistogram=c;this.DrawReport()}},CheckIfMouseInHistograms:function(d,c){var e=[-1,-1];var a=this.cmbPeopleMode.getValue();var b=SYNO.SS.App.VideoAnalytics.Def;this.dsReportVertical.each(function(m){for(var k=0;k<this.recordPerBin;k+=1){if((b.PeopleModeType.ENTER===this.cmbPeopleMode.getValue()&&1==k)||(b.PeopleModeType.LEAVE===this.cmbPeopleMode.getValue()&&0==k)){continue}var g=m.get("x"+k.toString());var h=m.get("width");var l=m.get("height"+k.toString());var f=m.get("y")-l;if(true===this.IsInRectangle(g,f,h,l,d,c)){e=[m.get("id"),k]}}},this);return e},IsInRectangle:function(b,a,c,d,f,e){return(f<=b+c)&&(f>=b)&&(e<=a+d)&&(e>=a)},DrawHoverTips:function(){var c=this.targetHistogram[0],b=this.targetHistogram[1];if(-1===c||-1===b){return}var a=this.dsReportVertical.getAt(c);var k=a.get("x"+b.toString());var l=a.get("width");var e=a.get("height"+b.toString());var g=a.get("y")-0.9*e;var d=a.get("count"+b.toString());var h=d.toString()+" "+_T("video_analytics","people");var f=this.canvasContext.measureText(h).width+10;this.canvasContext.strokeStyle="rgb(59, 150, 200)";this.canvasContext.fillStyle="rgba(59, 150, 200, 0.8)";this.canvasContext.lineWidth=2;if(0===b){this.canvasContext.fillRect(k-6,g,-f,24);this.canvasContext.strokeRect(k-6,g,-f,24);this.DrawText(k-6-f/2,g+12,h,"center","middle","#FFFFFF")}else{this.canvasContext.fillRect(k+l+6,g,f,24);this.canvasContext.strokeRect(k+l+6,g,f,24);this.DrawText(k+l+6+f/2,g+12,h,"center","middle","#FFFFFF")}},DrawTips:function(){var e=this.dsReportHorizon.data.last();var g=e.get("y")+60;var a=e.get("x1");var d=this.canvasContext.measureText(_T("ss_common","common_enter")).width;var f=this.canvasContext.measureText(_T("ss_common","common_exit")).width;var c=16;var b=c+8+20+20+d;this.DrawText(c,g,_T("ss_common","common_enter"),"left");this.DrawText(b,g,_T("ss_common","common_exit"),"left");this.canvasContext.fillStyle=this.VERTICAL_STYLE[0];this.canvasContext.fillRect(c+8+d,g-6,20,8);this.canvasContext.fillStyle=this.VERTICAL_STYLE[1];this.canvasContext.fillRect(b+8+f,g-6,20,8)},DrawHorizon:function(a){this.DrawLine(a.get("x1"),a.get("x2"),a.get("y"),a.get("y"));this.DrawText(a.get("x1")-6,a.get("y"),a.get("label"),"end")},DrawHistogram:function(c,b,a,d){this.canvasContext.fillStyle=b;this.dsReportVertical.each(function(e){if(e.get("id")===this.targetHistogram[0]&&(c===this.targetHistogram[1])){this.canvasContext.shadowColor="rgba(0, 0, 0, 0.3)";this.canvasContext.shadowBlur=3;this.canvasContext.fillRect(e.get(a)+1,e.get("y")-1,e.get("width")-1,-e.get(d)+1)}else{this.canvasContext.shadowBlur=0;this.canvasContext.fillRect(e.get(a),e.get("y"),e.get("width"),-e.get(d))}},this)},DrawLineChart:function(a,b){this.canvasContext.strokeStyle=a;this.canvasContext.beginPath();this.dsReportVertical.each(function(c){this.canvasContext.lineTo(c.get("labelX"),c.get("y")-c.get(b))},this);this.canvasContext.stroke()},DrawLabel:function(a){this.canvasContext.save();this.canvasContext.translate(a.get("labelX"),a.get("y"));this.canvasContext.rotate(-45*Math.PI/180);var b=_S("lang");if(("cht"===b||"chs"===b)&&(SYNO.SS.App.VideoAnalytics.Def.IntervalUnit.ONE_MONTH===this.cmbIntervalUnit.getValue())){this.DrawText(-20,20,a.get("time"),"","","#000000","bold 10px sans-serif")}else{this.DrawText(-20,20,a.get("time"))}this.canvasContext.restore()},DrawReport:function(){if(SYNO.SS.App.VideoAnalytics.Def.REPORT_TYPE.TABLE==this.reportType){this.ctCanvas.hide();this.panelTable.show()}else{var a;if(this.canvas){this.canvasContext.clearRect(0,0,this.canvas.width,this.canvas.height)}this.ctCanvas.show();this.panelTable.hide();this.InitCanvas();this.UpdateStandard();this.horizonIntercept=(this.canvas.height-100)/(this.HORIZON_NUM-1);this.InitHorizonStore();this.InitVerticalStore();this.dsReportHorizon.each(this.DrawHorizon,this);if(SYNO.SS.App.VideoAnalytics.Def.REPORT_TYPE.HISTOGRAM==this.reportType){if(SYNO.SS.App.VideoAnalytics.Def.PeopleModeType.ENTER_AND_LEAVE===this.cmbPeopleMode.getValue()){for(a=0;a<this.recordPerBin;a++){this.DrawHistogram(a,this.VERTICAL_STYLE[a],"x"+a.toString(),"height"+a.toString())}}else{if(SYNO.SS.App.VideoAnalytics.Def.PeopleModeType.ENTER===this.cmbPeopleMode.getValue()){this.DrawHistogram(0,this.VERTICAL_STYLE[0],"x0","height0")}else{this.DrawHistogram(1,this.VERTICAL_STYLE[1],"x1","height1")}}}else{if(SYNO.SS.App.VideoAnalytics.Def.REPORT_TYPE.LINECHART==this.reportType){for(a=0;a<this.recordPerBin;a++){this.DrawLineChart(this.VERTICAL_STYLE[a],"height"+a.toString())}}}this.DrawHoverTips();this.DrawTips();this.canvasContext.fillStyle=this.BLACK_STYLE;this.dsReportVertical.each(this.DrawLabel,this)}},InitHorizonStore:function(){var h=[];var a=this.HORIZON_NUM-1;var f=this.canvasContext.measureText(this.standard.toString()).width;var c=16+f+6;var b=this.canvas.width-12;var e=(this.START_BOUNDARY_Y+0.04)*this.canvas.height;var g;for(var d=0;d<this.HORIZON_NUM;d++){g=e+(this.horizonIntercept*d);h[d]=[c,b,g,((a-d)*this.standard/a).toString()]}this.dsReportHorizon=new Ext.data.SimpleStore({autoDestroy:true,data:h,fields:[{name:"x1"},{name:"x2"},{name:"y"},{name:"label"}]})},InitVerticalStore:function(){var b=this.VERTICAL_SPEC[this.recordPerBin-1];var g=this.dsReportVertical.getCount();var e=this.dsReportHorizon.data.last();var f=e.get("y");var d=e.get("x1");var a=(this.canvas.width-d-12)/g;var c=b.WIDTH*a;this.dsReportVertical.each(function(k,h){k.set("y",f);k.set("width",c);k.set("labelX",d+(a*(h+0.5)));for(var l=0;l<this.recordPerBin;l++){k.set("x"+l.toString(),d+(a*(h+b.X[l])));k.set("height"+l.toString(),this.CountToHeight(k.get("count"+l.toString())))}},this)},UpdateStandard:function(){var b=0;this.dsReportVertical.each(function(d){b=Math.max(b,d.get("count0"),d.get("count1"))});var c=1,a=0;while(b>c*this.STANDARD_SET[a]){a+=1;if(a==this.STANDARD_SET.length){c*=10;a=0}}this.standard=c*this.STANDARD_SET[a]},GetTableHtml:function(){var b=function(c){return"<td>"+c+"</td>"};var a="<table><tbody>";switch(this.analyzeType){case SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.MOTION_DETECTION:break;case SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.PEOPLE_COUNTING:a+="<tr>"+b(_T("event","date"))+b(_T("smartsearch","in"))+b(_T("smartsearch","out"))+"</tr>";this.dsReportVertical.each(function(c){a+="<tr>"+b(c.get("time"))+b(c.get("count0"))+b(c.get("count1"))+"</tr>"},this);break;default:break}a+="</tbody></table>";return a},GetTableCSV:function(){var a="data:text/csv;charset=utf-8,";switch(this.analyzeType){case SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.MOTION_DETECTION:break;case SYNO.SS.App.VideoAnalytics.Def.AnalyticsType.PEOPLE_COUNTING:a+=_T("event","date")+","+_T("smartsearch","in")+","+_T("smartsearch","out")+"\n";this.dsReportVertical.each(function(b){a+=b.get("time")+","+b.get("count0").toString()+","+b.get("count1").toString()+"\n"},this);break;default:break}return a},RenderText:function(b,c,a){var d=b;return Ext.util.Format.htmlEncode(d)},DrawLine:function(b,a,d,c){this.canvasContext.strokeStyle=this.LINE_COLOR;this.canvasContext.beginPath();this.canvasContext.moveTo(b,d);this.canvasContext.lineTo(a,c);this.canvasContext.closePath();this.canvasContext.stroke()},DrawRect:function(b,d,c,a){this.canvasContext.strokeRect(b,d,c,a)},DrawText:function(a,g,e,f,d,c,b){this.canvasContext.fillStyle=(false===Ext.isEmpty(c))?c:this.TEXT_COLOR;this.canvasContext.font=(false===Ext.isEmpty(b))?b:this.TEXT_FONT;this.canvasContext.textAlign=(false===Ext.isEmpty(f))?f:"center";this.canvasContext.textBaseline=(false===Ext.isEmpty(d))?d:"alphabetic";this.canvasContext.fillText(e,a,g)}});Ext.define("SYNO.SS.App.VideoAnalytics.ReportDatePicker",{extend:"SYNO.ux.DatePicker",parentWin:null,lastDate:null,constructor:function(a){this.parentWin=a.parentWin;this.callParent([a])},UpdateCalendar:function(){this.sendWebAPI({api:"SYNO.SurveillanceStation.IVA.Report",version:1,method:"GetNoRecordDate",params:{dsId:this.parentWin.dsId,taskId:this.parentWin.taskId,timestamp:this.GetActivateTime(),timezone:GetTimezoneOffset(true)},callback:function(a,d,e,b){if(a){var c=[];c=d.dayList.map(function(f){return new Date(f)});this.setDisabledDates(c)}},scope:this})},GetSeletedDateStr:function(){var a=new Date(this.getValue());return a.toLocaleDateString()},GetUTCTime:function(){var a=new Date(this.getValue());return(a.getTime()/1000)-(a.getTimezoneOffset()*60)},GetActivateTime:function(){if(this.lastDate){return(this.lastDate.getTime()/1000)-(this.lastDate.getTimezoneOffset()*60)}else{return this.GetUTCTime()}},IsAnotherMonthView:function(a){if(this.lastDate){return((a.getYear()!==this.lastDate.getYear())||(a.getMonth()!==this.lastDate.getMonth()))}else{return true}},update:function(a,b){this.callParent(arguments);if(true==this.IsAnotherMonthView(a)){this.lastDate=a;this.UpdateCalendar()}return this}});Ext.define("SYNO.SS.App.VideoAnalytics.ReportBanner",{extend:"Ext.Container",containerLeft:null,containerCenter:null,containerRight:null,constructor:function(b){var a={setValue:function(c){this.el.dom.innerHTML=c}};this.InitUI(a);Ext.applyIf(b,{cls:SYNO.SS.Utils.GetVdoInfoBarCls()+" player_banner",items:[this.containerLeft,this.containerCenter,this.containerRight]});this.callParent([b])},InitUI:function(a){this.containerLeft=new Ext.Container(Ext.apply({cls:"player_banner_left"},a));this.containerCenter=new Ext.Container(Ext.apply({cls:"player_banner_center"},a));this.containerRight=new Ext.Container(Ext.apply({cls:"player_banner_right"},a))},SetLeft:function(a){this.containerLeft.setValue(a)},SetCenter:function(a){this.containerCenter.setValue(a)},SetRight:function(a){this.containerRight.setValue(a)}});Ext.define("SYNO.SS.App.VideoAnalytics.Report.BottomBar",{extend:"SYNO.SS.Pgls.BottomBar",constructor:function(a){this.callParent(arguments)},UpdateLabelItemCnt:function(){var c;if(this.store){c=(true===this.showTotalCnt)?this.store.getTotalCount():this.store.getCount();var b=0;var a=0;this.store.each(function(d){b+=d.get("count0");a+=d.get("count1")});this.labelItemCnt.setText(c+" "+_T("ss_common","items")+", "+_T("ss_common","common_enter")+": "+b+", "+_T("ss_common","common_exit")+": "+a)}}});Ext.define("SYNO.SS.App.VideoAnalytics.CmsArchivePanel",{extend:"SYNO.SS.CmsWrapPanel",constructor:function(a){this.panelArch=new SYNO.SS.App.VideoAnalytics.Archive(a);this.callParent([{title:_T("ss_log","arch_settings"),disabled:(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.TRANS_ARCHIVE_EDIT)),appWin:a.appWin,panelContent:this.panelArch,fnIsDirty:this.IsDirty,fnReset:this.Reset,fnRefresh:this.Refresh,fnAllowSwitch:this.IsStorageValid}]);this.panelArch.mon(this.panelArch,"aftersave",function(){this.fireEvent("aftersave",this)},this)},NeedConfirmChange:function(){return(true===this.IsFormDirty())},IsFormDirty:function(){return this.IsDirty()},IsDirty:function(){return this.panelArch.IsFormDirty()},Reset:function(){return this.panelArch.Reset()},IsStorageValid:function(){var a=true;if((this.gridServer)&&(true===this.gridServer.getSelectionModel().hasSelection())){Ext.each(this.findBy(function(b){return"shareId"===b.name}),function(b){if((true!==b.validator(b.getValue()))||(true!==b.validator(b.originalValue))){a=false}})}return a},Refresh:function(a){if(true===this.panelArch.rendered){Ext.each(this.findBy(function(b){return"shareId"===b.name}),function(b){b.store.loaded=false;b.store.load()});this.panelArch.LoadSettings()}},Activate:function(){this.OnActivate()}});Ext.define("SYNO.SS.App.VideoAnalytics.Archive",{extend:"SYNO.SS.LogArchive.ArchivePanel",FIELD_LABEL_WIDTH:300,PADDING_LEFT:0,UPDATE_POLLING_INTVAL_MS:5000,blForceClose:false,blForceChgTab:false,bInited:false,cmbboxRotOption:null,cmbboxSharelist:null,fieldSharePath:null,fldArchive:null,fldHistoryRotate:null,fldHistory:null,chkLimitHistory:null,dsLimitDay:null,fldLimitSize:null,ctLimitDay:null,progressCheckTask:null,constructor:function(b){this.parentWin=b;this.InitUI();var a={};a.fsRule=this.fldHistory;a.fsDest=this.fldArchive;Ext.apply(a,{title:_T("ss_log","arch_settings"),apiParam:{apiName:"SYNO.SurveillanceStation.IVA.Archive",apiVersion:1,saveMethod:"SetSettings",loadMethod:"GetSettings"},OnWebAPIRequestDone:function(c,d,e,f){this.clearStatusBusy();if(true!==c){this.setStatusError({text:_T("ss_common","forminvalid"),clear:true});this.Alert(SYNO.API.getErrorString(d.code))}else{if(true===Ext.isFunction(f)){f.call(this,c,d,e)}}},Alert:function(d){var c=(d)?d:_T("ss_common","error_system");this.findAppWindow().getMsgBox().alert(_T("ss_common","advanced"),c)}});this.callParent([a])},InitUI:function(){if(true===this.bInited){return}this.cmbboxRotOption=new SYNO.ux.ComboBox({name:"rotateOption",fieldLabel:_T("camera","rotation_condition"),labelStyle:"padding-left: "+this.PADDING_LEFT+"px;",labelWidth:this.FIELD_LABEL_WIDTH,store:new Ext.data.ArrayStore({autoDestroy:true,fields:["id","text"],data:[[SYNO.SS.App.Camera.Def.Wizard.ROT_OPTION_ROTATE,_T("camera","rotate_condition_remove")],[SYNO.SS.App.Camera.Def.Wizard.ROT_OPTION_STOP,_T("camera","rotate_condition_stop")]]}),valueField:"id",displayField:"text",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false});this.dsRecShareList=new SYNO.API.JsonStore({appWindow:this,api:"SYNO.SurveillanceStation.Share",method:"ListRecShare",version:1,autoDestroy:true,dsId:this.parentWin.ownerDsId,root:"sharelist",id:"shareId",baseParams:{blIncldMigrating:true,blIncldEncUnmount:true,blIncldRemoteAbnormal:true},fields:[{name:"shareId"},{name:"shareIdOnRec"},{name:"shareName"},{name:"sharePath"},{name:"shareVolume"},{name:"displayName"},{name:"mountType"},{name:"quota"}],listeners:{load:function(b,a,c){this.parentWin.clearStatusBusy();SYNO.SS.Utils.PatchRecShareConcatName(a,this.parentWin.ownerDsId);this.cmbboxSharelist.setValue(this.cmbboxSharelist.getValue())},loadexception:function(){this.parentWin.clearStatusBusy()},scope:this}});this.cmbboxSharelist=new SYNO.ux.ComboBox({name:"storagePath",fieldLabel:_T("camera","recording_storage_header"),labelStyle:"padding-left: "+this.PADDING_LEFT+"px;",cls:"ellipsis_text",store:this.dsRecShareList,valueField:"sharePath",displayField:"concat_display_name",forceSelection:true,labelWidth:this.FIELD_LABEL_WIDTH,allowBlank:false,editable:false,WAITING_IMG_ID:"SNAPSHOT_ADVANCE_WAITING_IMG",WAITING_TEXT_ID:"SNAPSHOT_ADVANCE_WAITING_TEXT",listeners:{afterrender:function(e){var d=document.createElement("a");var b=SYNO.SS.Utils.CreateNonDraggableImg();var a=document.createElement("a");var c=document.createTextNode(_T("camera","migrating"));b.setAttribute("src",_IMG(SYNO.SS.Image.Syncing));b.setAttribute("style",SYNO.SS.Utils.GetTipImgStyle(30,0));b.setAttribute("id",e.WAITING_IMG_ID);d.appendChild(b);a.setAttribute("id",e.WAITING_TEXT_ID);a.setAttribute("class","snapshot-advance-waiting-text");a.appendChild(c);Ext.getDom(e.getEl()).parentNode.appendChild(d);Ext.getDom(e.getEl()).parentNode.appendChild(a);e.ShowTip(false)}.createDelegate(this)},ShowTip:function(a){var c=Ext.getDom(this.cmbboxSharelist.WAITING_IMG_ID);var b=Ext.getDom(this.cmbboxSharelist.WAITING_TEXT_ID);if(a){if(c){c.style.display=""}if(b){b.style.display=""}}else{if(c){c.style.display="none"}if(b){b.style.display="none"}}}.createDelegate(this),setValue:function(a){SYNO.ux.ComboBox.superclass.setValue.apply(this.cmbboxSharelist,arguments);this.SetPathLabel(a)}.createDelegate(this)});this.fieldSharePath=new SYNO.ux.DisplayField({cls:"ellipsis_text",style:"margin-left: "+this.PADDING_LEFT+"px;",isDirty:function(){return false}});this.fldArchive=new SYNO.ux.FieldSet({title:_T("camera","camera_recording"),autoHeight:true,collapsible:true,items:[this.cmbboxRotOption,this.cmbboxSharelist,this.fieldSharePath]});this.fldHistoryRotate=new SYNO.ux.NumberField({name:"daysKeepHistory",fieldLabel:_T("video_analytics","history_kept_days")+" ("+_T("camera","days")+")",labelWidth:this.FIELD_LABEL_WIDTH,labelStyle:"padding-left: "+this.PADDING_LEFT+"px;",allowBlank:false,minValue:1,maxValue:1000});this.chkLimitHistory=new SYNO.ux.Checkbox({name:"blLimitRecSize",boxLabel:_T("liveview_alert","rec_rot_by_space")+" (GB)",width:this.FIELD_LABEL_WIDTH,listeners:{check:function(a,b){this.fldLimitSize.setDisabled(!b)},scope:this}});this.fldLimitSize=new SYNO.ux.NumberField({name:"recLimitSizeGB",disabled:true,value:10,minValue:1,maxValue:2048});this.ctLimitDay=new Ext.Container({style:"margin-left: "+this.PADDING_LEFT+"px;",layout:"column",cls:"archive_config_size_limit",items:[this.chkLimitHistory,this.fldLimitSize]});this.fldHistory=new SYNO.ux.FieldSet({title:_T("video_analytics","history_rotation_rule"),cls:"archive_cfg_fldset",collapsible:true,items:[this.fldHistoryRotate,this.ctLimitDay]});this.cmbboxSharelist.mon(SYNO.SDS.StatusNotifier,"shareInfoUpdate",function(){this.dsRecShareList.load()}.createDelegate(this));this.dsRecShareList.load();this.bInited=true},Activate:function(){this.OnRefresh()},Deactivate:function(){this.getForm().reset()},OnRefresh:function(){this.WebAPIRequest({},"GetSettings",1,this.OnLoadDone)},OnLoadDone:function(a,b){if(b){this.getForm().setValues(b);this.fldLimitSize.setValue(b.limitRecSize/1024);this.fldLimitSize.originalValue=this.fldLimitSize.getValue()}},OnLimitDayChange:function(){},OnSave:function(){if(false===this.getForm().isValid()){this.setStatusError({text:_T("ss_common","forminvalid"),clear:true});return}if(false===this.IsFormDirty()){this.setStatusError({text:_T("ss_common","setting_nochange"),clear:true});return}this.WebAPIRequest(this.getForm().getAllFieldValues(),"SaveSettings",1,this.OnSaveDone)},OnSaveDone:function(a,b,c){if(true===a){this.setStatusOK({text:_T("ss_common","setting_applied"),clear:true})}if(c){this.getForm().setValues(c)}this.CheckMigrating()},OnBeforeClose:function(a){if(true===this.blForceClose){this.blForceClose=false;return true}if(true===this.IsFormDirty()){SYNO.SS.Utils.ConfirmLostChange({title:this.title,msgBox:this.findAppWindow().getMsgBox(),fnYes:function(b){this.blForceClose=true;a.close()},scope:this});return false}return true},OnClose:function(){this.findAppWindow().close()},IsFormDirty:function(){return this.getForm().isDirty()},SetPathLabel:function(b){var a="";if(""==b){this.fieldSharePath.getEl().dom.removeAttribute("ext:qtip");this.fieldSharePath.hide()}else{b+="/@VideoAnalytics";b='<span class="snapshot-advance-share-location">'+b+"</span>";a=String.format(_T("camera","share_location"),b);this.fieldSharePath.setValue(a);this.fieldSharePath.originalValue=this.fieldSharePath.getValue();this.fieldSharePath.getEl().dom.setAttribute("ext:qtip",b);this.fieldSharePath.show()}},CheckMigrating:function(){this.RemoveProgressCheckTask();var a={api:"SYNO.SurveillanceStation.IVA.Archive",version:1,method:"MigratingStatus",dsId:this.GetDsId(),params:{},callback:function(e,c,d,b){this.CheckMigratingDone(e,c)},scope:this};this.sendWebAPI(a)},CheckMigratingDone:function(b,a){if(b&&a&&(true===a.blMigrating)){this.cmbboxSharelist.ShowTip(true);this.cmbboxSharelist.setDisabled(true);this.PollingMigratingStatus()}else{this.cmbboxSharelist.ShowTip(false);this.cmbboxSharelist.setDisabled(false)}},RemoveProgressCheckTask:function(){if(this.progressCheckTask){this.progressCheckTask.cancel();this.progressCheckTask=null}},PollingMigratingStatus:function(){if(!this.progressCheckTask){this.progressCheckTask=new Ext.util.DelayedTask(this.CheckMigrating,this);this.progressCheckTask.delay(this.UPDATE_POLLING_INTVAL_MS)}}});Ext.define("SYNO.SS.App.VideoAnalytics.License",{extend:"SYNO.ux.Panel",bInited:false,blKeyShown:false,parentWin:null,btnAdd:null,btnDelete:null,btnShow:null,panelCategContainer:null,grid:null,constructor:function(a){this.parentWin=a;this.Init();this.callParent([{title:_T("ss_common","common_license"),tbar:[this.btnAdd,this.btnDelete,this.btnShow],layout:"fit",items:this.panelCategContainer}])},Init:function(){if(true===this.bInited){return}this.btnAdd=new SYNO.ux.Button({text:_T("ss_common","common_add"),handler:this.OnAdd,scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),handler:this.OnDelete,scope:this});this.btnShow=new SYNO.ux.Button({text:_T("license","show_full_key_dlg_title"),handler:this.OnShow,scope:this});this.store=new Ext.data.JsonStore({autoDestroy:true,root:"license",totalProperty:"license_num",remoteSort:true,sortInfo:{field:"id",direction:"ASC"},fields:[{name:"id",type:"int"},{name:"key"},{name:"quota",type:"int"},{name:"ownerDsId"},{name:"install_date"},{name:"expired_date"},{name:"isExpired"}]});var a=new Ext.grid.ColumnModel([{id:"key",header:_T("license","license_key"),align:"center",width:200,sortable:false,dataIndex:"key",renderer:this.RenderKey.createDelegate(this)},{id:"quota",header:_T("license","license_quota"),align:"center",width:100,sortable:false,dataIndex:"quota",renderer:function(c,d,b){if(0>=c){return String.format("<span valign='center' style='color:{0}' ext:qtip='{1}'> {2} </span>",SYNO.SS.Color.ALERT_RED,_T("license","invalid_license"),c)}else{return c}}},{id:"install_date",header:_T("license","license_install_date"),align:"center",width:100,sortable:false,dataIndex:"install_date",renderer:this.RenderInstallTime.createDelegate(this)},{id:"expired_date",header:_T("license","license_expired_date"),align:"center",width:100,sortable:false,dataIndex:"expired_date",renderer:this.RenderExpireTime.createDelegate(this)},{id:"source",header:_T("ss_centralized","source"),align:"center",width:100,sortable:false,dataIndex:"ownerDsId",renderer:this.RenderSource.createDelegate(this)}]);this.selectionModel=new Ext.grid.RowSelectionModel();this.selectionModel.on("selectionchange",this.OnSelectChange,this);this.grid=new SYNO.SS.Grid.GridPanel({cls:"grid_row_height_fixed categ_dv_panel_height_fixed",title:"",store:this.store,border:false,viewConfig:{forceFit:true},autoExpandColumn:"quota",loadMask:true,cm:a,sm:this.selectionModel});this.panelGridContainer=new SYNO.SS.Pgls.PglsGridContainerPanel({region:"center",grid:this.grid,store:this.store,refreshFunction:function(){this.OnRefresh(false,true)},refreshFunctionScope:this});this.dsCateg=new Ext.data.JsonStore({autoDestroy:true,fields:["id","category","entryName","entryVal","recCnt","type"]});this.gridCateg=new SYNO.SS.Grid.CategoryGridPanel({cls:"categ_label_fixed_height",border:false,category:["iva_license_quota"],store:this.dsCateg});this.panelCategContainer=new SYNO.SS.Grid.CategContainerPanel({items:[this.gridCateg,this.panelGridContainer],labelItemCnt:this.panelGridContainer.getBottomToolbar().labelItemCnt,gridCateg:this.gridCateg,fnCountByCateg:this.CountByCateg.createDelegate(this),panelRecord:this.grid,dsRecord:this.store});this.bInited=true},Activate:function(){this.OnRefresh()},OnRefresh:function(){this.WebAPIRequest(null,"List",null)},OnAdd:function(){},OnDelete:function(){},OnShow:function(){},OnSelectChange:function(){},LoadDataToStore:function(a){this.store.loadData(a)},CountByCateg:function(){var b=this.store.getRange();var h=b.length;var g;var d,e;var a=SYNO.SS.Grid.Categ.CATEG_IVA_LICENSE_QUOTA;var f={};f[a]={};f[a][SYNO.SS.Grid.Categ.VALUE_ALL]=h;f[a][SYNO.SS.App.VideoAnalytics.Def.LICENSE_DEFAULT]=0;f[a][SYNO.SS.App.VideoAnalytics.Def.LICENSE_1]=0;f[a][SYNO.SS.App.VideoAnalytics.Def.LICENSE_4]=0;f[a][SYNO.SS.App.VideoAnalytics.Def.LICENSE_8]=0;f[a][SYNO.SS.App.VideoAnalytics.Def.LICENSE_UNRECOGNIZED]=0;var c=function(n,l,m){var k=(n[l][m]!==undefined);n[l][m]=(k)?(n[l][m]+1):1};for(d=0;d<h;d++){if("default"===b[d].data.key){e=SYNO.SS.App.VideoAnalytics.Def.LICENSE_DEFAULT}else{e=b[d].data.quota}e=SYNO.SS.App.VideoAnalytics.Utils.IsUnrecognizedLicense(e)?SYNO.SS.App.VideoAnalytics.Def.LICENSE_UNRECOGNIZED:e;c.apply(this,[f,a,e])}f.total=h;return f},WebAPIRequest:function(b,c,a){this.sendWebAPI({api:"SYNO.SurveillanceStation.IVA.License",version:1,method:c,params:b,callback:function(d,f,g,e){if(a){a(d,f,g,e)}else{this.OnWebAPIRequestDone(d,f,g,e)}},scope:this})},OnWebAPIRequestDone:function(a,c,d,b){if(a){this.LoadDataToStore(c)}else{this.getMsgBox().alert(this.alertTitle,_T("ss_common","error_system"))}},RenderKey:function(b,c,a){if(b==SYNO.SS.App.VideoAnalytics.Def.LICENSE_DEFAULT){return _T("license","default_license")}else{if(false===this.blKeyShown){return b.substr(0,5)+"-*****-*****-"+b.substr(15,5)}else{return SYNO.SS.Utils.AddDashToLicenseKey(b)}}},RenderTime:function(a){return GenLocalDateTimeStr(a).split(" ")[0]},RenderInstallTime:function(b,c,a){if(0==b){return"-"}return this.RenderTime(b*TRANS_MILLISECOND)},RenderExpireTime:function(c,d,b){if(0>=b.data.quota){var a=SYNO.SS.GblStore.GetDsStatus(b.data.ownerDsId);if(SYNO.SS.CmsDsSts.NORMAL!==a){return String.format("<span valign='center' style='color:{0}' ext:qtip='{1}'> {2} </span>",SYNO.SS.Color.ALERT_RED,_T("license","rec_abnormal_tooltip"),_T("ss_common","status_unknown"))}else{if(true===b.data.isExpired){return String.format("<span valign='center' style='color:{0}' ext:qtip='{1}{2}'> {3} </span>",SYNO.SS.Color.ALERT_RED,_T("license","expired_license_tooltip"),_T("license","purchase_license"),_T("ss_common","status_expired"))}else{return String.format("<span valign='center' style='color:{0}' ext:qtip='{1}'> {2} </span>",SYNO.SS.Color.ALERT_RED,_T("license","invalid_license"),_T("license","license_invalid"))}}}else{if(("default"===b.data.key)||(0===c)){return _T("ss_common","common_infinite")}}return this.RenderTime(c*TRANS_MILLISECOND)},RenderSource:function(d,e,b){if("default"===b.data.key){return"-"}var a=SYNO.SS.GblStore.GetDsStatus(b.data.ownerDsId);if(SYNO.SS.CmsDsSts.NORMAL===a){return SYNO.SS.GblStore.GetDsName(b.data.ownerDsId)}else{var c=(SYNO.SS.CmsDsSts.DISABLE===a)?SYNO.SS.Color.DISABLED_GRAY:SYNO.SS.Color.ALERT_RED;return String.format("<span valign='center' style='color:{0}'> {1} </span>",c,SYNO.SDS.Utils.GetLocalizedString(SYNO.SS.CmsDsStsMap[a]))}}});Ext.namespace("SYNO.SS.App.VideoAnalytics");Ext.define("SYNO.SS.App.VideoAnalytics.AppPanel",{extend:"SYNO.SS.Panel.AppPanel",skipQuery:false,prevServiceList:[],serviceList:[],constructor:function(a){this.callParent([Ext.apply({appType:"VideoAnalyticsApp"},a)]);this.mon(this,"activate",this.QueryAppList,this)},GetAppList:function(){var b=[];var a=SYNO.SDS.AppUtil.systemApps;var c;for(c in SYNO.SDS.Config.FnMap){if((true===Ext.isDefined(SYNO.SDS.Config.FnMap[c]))&&(true===Ext.isDefined(SYNO.SDS.Config.FnMap[c].config))&&(true===SYNO.SDS.Config.FnMap[c].config.videoAnalyticsApp)){b.push([c])}}b.sort(function(e,d){return a.indexOf(e[0])-a.indexOf(d[0])});return b},SetInfo:function(a){if(false===Ext.isDefined(a)){if(true===Ext.isDefined(this.transactionId)){Ext.Ajax.abort(this.transactionId);this.transactionId=undefined;this.Unmask()}this.curItemRecord=undefined;this.dsApp.filterBy(function(){return false});this.Mask(_T("ss_common","no_avaliable_items"));return}var b=this.curItemRecord?(JSON.stringify(this.curItemRecord.data)!==JSON.stringify(a.data)):true;this.curItemRecord=a;if(false===b){return}this.QueryAppList();if(true===a.data.enable){this.Unmask()}else{this.Mask()}},QueryAppListIfSkip:function(){if(true===this.skipQuery){this.QueryAppList()}},QueryAppList:function(){if(false===this.isVisible()){this.skipQuery=true;return}this.skipQuery=false;var a=(function(){this.transactionId=undefined;this.Unmask()}).createDelegate(this);if(true===Ext.isDefined(this.transactionId)){Ext.Ajax.abort(this.transactionId);a()}if(false===Ext.isDefined(this.curItemRecord)){return}return},FilterByserviceList:function(){this.dsApp.filterBy(function(b){var a=SYNO.SS.Service.GetServiceType(b.id);if(SYNO.SS.Service.UNDEFINED===a){return true}return this.IsServiceEnabled(a)},this)},IsServiceEnabled:function(a){var b=false;var c;for(c=0;c<this.serviceList.length;c++){if(a===this.serviceList[c].service){b=this.serviceList[c].info.blEnabled;break}}return !!b},LaunchApp:function(e){var c=e.appId;var d=this.GetName({appId:c});var b=SYNO.SS.Service.GetServiceType(c);var a=e.itemRec.get("id");var g=e.itemRec.get("name");var f=function(k){if(false===Ext.isDefined(k)){return}var h=function(n,m,l){if(true===m){return}else{if((l===k.instances[0].appDSId)&&(b===n)){this.destroy()}}};k.mon(SYNO.SDS.StatusNotifier,"addonsStatusChange",h,k)};SYNO.SDS.AppLaunch(c,{title:d+" - "+g,instanceName:String.format(this.instanceName,c,a),appParams:{dsId:a},videoAnalyticsApp:true},true,f)}});Ext.namespace("SYNO.SS.App.VideoAnalytics");Ext.define("SYNO.SS.App.VideoAnalytics.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SS.App.VideoAnalytics.MainWindow"});Ext.define("SYNO.SS.App.VideoAnalytics.MainWindow",{extend:"SYNO.SDS.TabPanelAppWindow",WIN_MIN_WIDTH:1010,WIN_MIN_HEIGHT:600,GRID_PADDING_BOTTOM:20,maskCnt:0,title:null,tabIndex:SYNO.SS.App.VideoAnalytics.Def.APP_WIN_TABINDEX,tabPanelList:null,panelTask:null,panelHistory:null,panelArchive:null,panelLicense:null,constructor:function(a){this.Init();this.callParent([Ext.apply({title:"VideoAnalytics-HC",width:this.WIN_MIN_WIDTH,height:this.WIN_MIN_HEIGHT,minWidth:this.WIN_MIN_WIDTH,minHeight:this.WIN_MIN_HEIGHT,layout:"fit",blNoPadding:true,panelList:this.tabPanelList,tabIndex:this.tabIndex},a)]);this.InitEventHandler()},onOpen:function(){this.callParent(arguments);this.OnResize()},onClose:function(){if(this.panelHistory.dlgReport){this.panelHistory.dlgReport.close()}},onMinimize:function(){this.callParent()},getHelpParam:function(){var a;switch(this.GetCurrentTabIndex()){case this.tabIndex.HISTORY:a="video_analytics_hostory.html";break;case this.tabIndex.REPORT:a="video_analytics.html";break;case this.tabIndex.ARCHIVE:case this.tabIndex.LICENSE:a="video_analytics.html";break;case this.tabIndex.NONE:a="video_analytics.html";break;default:a="video_analytics.html";break}return a},Init:function(){this.panelTask=this.CreateTabItemForGblSearch("SYNO.SS.App.VideoAnalytics.TaskList",[this]);this.panelHistory=this.CreateTabItemForGblSearch("SYNO.SS.App.VideoAnalytics.AlertHistory",[this]);var a=(true===IsCMSHost())?"SYNO.SS.App.VideoAnalytics.CmsArchivePanel":"SYNO.SS.App.VideoAnalytics.Archive";this.panelArchive=this.CreateTabItemForGblSearch(a,[this]);this.panelLicense=this.CreateTabItemForGblSearch("SYNO.SS.App.VideoAnalytics.License",[this]);this.tabPanelList=[this.panelTask,this.panelHistory,this.panelArchive]},InitEventHandler:function(){this.mon(this,"resize",this.OnResize,this);this.mon(this.tabPanel,"beforetabchange",this.OnBeforeTabChange,this);this.mon(this.tabPanel,"tabchange",this.OnTabChange,this);this.mon(SYNO.SDS.StatusNotifier,"GoToIVATaskList",this.OnGoToIVATaskList,this)},OnResize:function(){var b=this.getInnerWidth();var a=this.getInnerHeight();this.tabPanel.setSize(b,a);this.tabPanel.syncSize();this.panelHistory.Resize()},NeedConfirmChange:function(){var a=this.tabPanel.getActiveTab();return(a&&(true===Ext.isFunction(a.NeedConfirmChange))&&(true===a.NeedConfirmChange()))},OnBeforeTabChange:function(a,c,b){if(true===this.NeedConfirmChange()){SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){this.tabPanel.getActiveTab().Reset();this.tabPanel.setActiveTab(c.getItemId())},scope:this});return false}return true},OnTabChange:function(a,b){this.tabPanelList[this.GetCurrentTabIndex()].Activate();this.OnResize()},MaskGrid:function(a){if(false===this.rendered){return}if(true===a){this.maskCnt+=1}else{this.maskCnt-=1}if(0<this.maskCnt){SYNO.SS.Utils.MaskEl(this.getEl())}else{SYNO.SS.Utils.UnmaskEl(this.getEl())}},OnSaveTask:function(a){this.sendWebAPI({api:"SYNO.SurveillanceStation.IVA",version:1,method:"SaveTask",params:a.params,callback:a.callback,scope:a.scope})},OnGoToIVATaskList:function(){this.tabPanel.setActiveTab(this.tabIndex.TASK)}});