#!/bin/sh

PKG_STR_WIZARD_UPGRADE_TITLE="執行前請注意"
PKG_STR_WIZARD_UPGRADE_NOTE="升級至 Surveillance Station 需轉換資料庫系統，因此可能會耗費一段時間 (實際狀況視資料庫中的錄影檔數量而定)。升級過程中，請耐心等候，並且不要將系統關機或解除安裝套件。"
PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE="此版 Surveillance Station 僅相容於 VisualStation {0} 或更新版本。此版 Surveillance Station 將不再支援 VisualStation VS60 及 VS80 機種。"
PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE="VS360HD 升級至 4.0 或更新版本後，原配對功能將由新的登入機制取代。您將可透過 Synology VisualStation VS360HD 直接登入 Surveillance Station。此外，VS360HD 將支援 Surveillance Station 提供的所有網路監控功能。<br><br>當前版本的 Surveillance Station 可同時相容 VisualStation 3.0.5 版原先的配對功能以及 Visual Station 4.0 版新的登入機制。但原配對功能即將在日後更新時停止支援。"
PKG_STR_WIZARD_UPGRADE_PSIA_NOTE="此版本開始，Surveillance Station 已停止支援 PSIA。您無法在 Surveillance Station 中使用以 PSIA 架設的攝影機。"
PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL="我了解此相容性限制，並願意繼續更新。"
PKG_STR_WIZARD_UPGRADE_DOOR_LICENSE="此版本的 Surveillance Station 將套用新的門禁控制器授權規則。<br><br>每一台新增的門禁控制器皆將視為一個監控裝置，且如同網路攝影機及 I/O 模組，須使用一組監控裝置授權。但先前已安裝的門禁控制器在此版本更新後仍可繼續使用，不須另外使用授權。"
PKG_STR_WIZARD_DOOR_LICENSE_CHECK_LABEL="我了解新的門禁控制器授權規則，並同意繼續更新。"
PKG_STR_WIZARD_DOOR_PRIVILEGE_CHECK_NOTE="升級至此版本後，門禁控制器的權限管理將移至使用者頁面中的權限設定檔。"
PKG_STR_WIZARD_UPGRADE_LABEL="我了解此變動，並同意繼續安裝此更新。"

# Copyright (c) 2015 Synology Inc. All rights reserved.

SS_PKG_PATH="/var/packages/SurveillanceStation/"
SS_INFO_FILE=${SS_PKG_PATH}"INFO"
SS_SYSTEM_DB_FILE=${SS_PKG_PATH}"target/system.db"
SS_AXISDOOR_DB_FILE=${SS_PKG_PATH}"target/axisacsctrl.db"
SS_AXISDOORLOG_DB_FILE=${SS_PKG_PATH}"target/@surveillance/axisacsevtlog.db"
SS_VER_KEY="version"
SS_SQLITE3_VER="6.3"
SS_THUMBNAIL_ISSUE_BUILD_VER="3312"
SS_THUMBNAIL_FIXED_BUILD_VER="3352"
SS_ADD_DOORLOG_INDEX_BUILD_VER="5372"
VS_MODELS_60_80="'VS60', 'VS80'"
VS_MODELS_360HD="'VS360HD'"
VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION="'4.0'"
SS_UNSUPPORT_VENDOR="('PSIA')"
SS_MIN_VS_60_80_VERSION="2.2-1413"
SS_MIN_VS_360_VERSION="3.1-2500"
SS_SQLITE3="${SS_PKG_PATH}target/bin/sqlite3"
DEF_SQLITE3="/usr/syno/bin/sqlite3"
SS_MIN_DOOR_LICENSE_VERSION="8.0.0-5090"
SS_MIN_DOOR_PRIVILEGE_VERSION="8.1.0-5323"
FN_CHECK_BOX_VALIDATOR="{ var blChecked = arguments[0]; return true === blChecked; }"

UPGRADE_VS_60_80_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "$(echo $PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE | sed "s/{0}/${SS_MIN_VS_60_80_VERSION}/g")",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_VS_360_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"items": [{
		"desc": "$PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE"
	}]
}
EOF`

UPGRADE_PSIA_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "${PKG_STR_WIZARD_UPGRADE_PSIA_NOTE}",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_DB_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"desc": "${PKG_STR_WIZARD_UPGRADE_NOTE}"
	}]
}
EOF`

UPGRADE_DOOR_LICENSE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "$PKG_STR_WIZARD_UPGRADE_DOOR_LICENSE",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_DOOR_LICENSE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_DOOR_PRIVILEGE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "${PKG_STR_WIZARD_DOOR_PRIVILEGE_CHECK_NOTE}",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_UPGRADE_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

Sqlite3Exec()
{
	local sqlite_bin=""
	if [ -f "$SS_SQLITE3" ]; then
		sqlite_bin=$SS_SQLITE3
	else
		sqlite_bin=$DEF_SQLITE3
	fi

	$sqlite_bin -init /dev/null -cmd ".timeout 300000" "$@"
}

IsUpgradeToSqlite3()
{
	local PreSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 1)

	if [ ${SS_SQLITE3_VER} \> ${PreSSVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeToDoorLicense()
{
	local TargetSSVer=$(echo ${SS_MIN_DOOR_LICENSE_VERSION} | sed 's/\.//g' | sed 's/-//g')
	local CurrentSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}")

	CurrentSSVer=$(echo ${CurrentSSVer} | sed 's/\.//g' | sed 's/-//g')

	if [ "${TargetSSVer}" -gt "${CurrentSSVer}" ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeThumbnailToFile()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 2)

	if [ ${SS_THUMBNAIL_ISSUE_BUILD_VER} -le ${PreSSBuildVer} ] && [ ${SS_THUMBNAIL_FIXED_BUILD_VER} -gt ${PreSSBuildVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeToDoorPrivilege()
{
	local TargetSSVer=$(echo ${SS_MIN_DOOR_PRIVILEGE_VERSION} | sed 's/\.//g' | sed 's/-//g')
	local CurrentSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}")

	CurrentSSVer=$(echo ${CurrentSSVer} | sed 's/\.//g' | sed 's/-//g')

	if [ "${TargetSSVer}" -ge "${CurrentSSVer}" ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasVS()
{
	local Models="$1"
	local MinVersion="$2"
	local SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"

	if [ -n "$MinVersion" ]; then
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models) AND version < $MinVersion"
	else
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"
	fi

	CheckSystemDBItemExist "${SqlCmd}"
}

HasPsiaCam()
{
	local SqlCmd="SELECT COUNT(*) FROM camera WHERE vendor IN ${SS_UNSUPPORT_VENDOR}"

	CheckSystemDBItemExist "${SqlCmd}"
}

HasDoor()
{
	local DoorCount=$(sqlite3 $SS_AXISDOOR_DB_FILE "SELECT COUNT (id) FROM axisacsctrler where id IS NOT NULL")

	if [ $DoorCount -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasLargeDoorLog()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 2)
	local DoorLogCount=$(sqlite3 $SS_AXISDOORLOG_DB_FILE "SELECT COUNT (*) FROM axisacsevtlog")

	if [ ${SS_ADD_DOORLOG_INDEX_BUILD_VER} -gt ${PreSSBuildVer} ] && [ ${DoorLogCount} -gt 60000 ]; then
		echo "true"
	else
		echo "false"
	fi
}

CheckSystemDBItemExist()
{
	local SqlCmd="$1"
	local Cnt=$(Sqlite3Exec $SS_SYSTEM_DB_FILE "$SqlCmd")

	if [ -z "${Cnt}" ]; then
		if [ -f /usr/syno/pgsql/bin/psql ]; then
			Cnt=$(/usr/syno/pgsql/bin/psql -A -t -U postgres surveillance -c "${SqlCmd}")
		else
			Cnt=0
		fi
	fi

	if [ ${Cnt} -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

GetUpgradeNotePages()
{
	local Pages=""

	if [ "true" == $(HasPsiaCam) ]; then
		Pages="${UPGRADE_PSIA_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_60_80") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_60_80_NOTE_PAGE}" \
						|| Pages="${Pages},${UPGRADE_VS_60_80_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_360HD" "$VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_360_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_VS_360_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToSqlite3) ] || [ "true" == $(IsUpgradeThumbnailToFile) ] || [ "true" == $(HasLargeDoorLog) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DB_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DB_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToDoorLicense) ] && [ "true" == $(HasDoor) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DOOR_LICENSE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DOOR_LICENSE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToDoorPrivilege) ] && [ "true" == $(HasDoor) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DOOR_PRIVILEGE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DOOR_PRIVILEGE_PAGE}"
	fi

	echo "[$Pages]"
}

main()
{
	local UpgradeNotePages="$(GetUpgradeNotePages)"

	if [ "[]" == "$UpgradeNotePages" ]; then
		exit 0
	fi

	echo "$UpgradeNotePages" > $SYNOPKG_TEMP_LOGFILE

	exit 0
}

main "$@"
