#!/bin/sh

PKG_STR_WIZARD_UPGRADE_TITLE="開始前にお読みください"
PKG_STR_WIZARD_UPGRADE_NOTE="Surveillance Station にアップグレードするにはデータベースの変換が必要になるため、データベースにある録画の数によっては時間がかかる場合があります。アップグレードが完了するまでお待ちになり、アップグレード中にシステムの電源を切ったり、パッケージをアンインストールしたりしないでください。"
PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE="このバージョンの Surveillance Station は、VisualStation {0} およびそれ以降のバージョンとしか互換性がありません。VisualStation VS60 および VS80 モデルは、このバージョンの Surveillance Station ではサポートされていません。"
PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE="VS360HD をバージョン 4.0 以降にアップグレードすると、Visual Station の元のペアリング機能は新しいログイン メカニズムに置き換えられます。Synology VisualStation VS360HD から直接 Surveillance Station にログインできるようになります。さらに、Surveillance Station が提供するネットワーク ビデオ録画機能はすべて VS360HD でサポートされます。<br><br>Surveillance Station の現バージョンは、VisualStation バージョン 3.0.5 の元のペアリング機能と、VisualStation バージョン 4.0 の新しいログイン メカニズムの両方と互換性があります。ただし、元のペアリング機能は今後のアップデートでは終了します。"
PKG_STR_WIZARD_UPGRADE_PSIA_NOTE="このバージョンから、Surveillance Station は PSIA に対応しません。PSIA で設定したカメラは、Surveillance Station で使用することはできません。"
PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL="互換性の制限について理解した上で、更新を希望します。"
PKG_STR_WIZARD_UPGRADE_DOOR_LICENSE="このバージョンの Surveillance Station は、新しいライセンス ポリシーをアクセス コントローラーに適用します。<br><br>新しく追加されたアクセス コントローラーはそれぞれ、1つの監視デバイスとしてカウントされ、IP カメラおよび I/O モジュールとして監視デバイス ライセンスを使用します。ただし、この更新後でも、以前にインストールしたアクセス コントローラーはライセンスなしで依然として使用できます。"
PKG_STR_WIZARD_DOOR_LICENSE_CHECK_LABEL="アクセス コントローラーの新しいライセンス ポリシーについて理解した上で、この更新の続行を希望します。"
PKG_STR_WIZARD_DOOR_PRIVILEGE_CHECK_NOTE="このバージョンにアップグレード後、ドア コントローラの権限管理は [ユーザー] ページの [権限プロファイル] に移動されます。"
PKG_STR_WIZARD_UPGRADE_LABEL="私はこれから行われる変更を理解し、アップデートに進むことに同意します。"

# Copyright (c) 2015 Synology Inc. All rights reserved.

SS_PKG_PATH="/var/packages/SurveillanceStation/"
SS_INFO_FILE=${SS_PKG_PATH}"INFO"
SS_SYSTEM_DB_FILE=${SS_PKG_PATH}"target/system.db"
SS_AXISDOOR_DB_FILE=${SS_PKG_PATH}"target/axisacsctrl.db"
SS_AXISDOORLOG_DB_FILE=${SS_PKG_PATH}"target/@surveillance/axisacsevtlog.db"
SS_VER_KEY="version"
SS_SQLITE3_VER="6.3"
SS_THUMBNAIL_ISSUE_BUILD_VER="3312"
SS_THUMBNAIL_FIXED_BUILD_VER="3352"
SS_ADD_DOORLOG_INDEX_BUILD_VER="5372"
VS_MODELS_60_80="'VS60', 'VS80'"
VS_MODELS_360HD="'VS360HD'"
VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION="'4.0'"
SS_UNSUPPORT_VENDOR="('PSIA')"
SS_MIN_VS_60_80_VERSION="2.2-1413"
SS_MIN_VS_360_VERSION="3.1-2500"
SS_SQLITE3="${SS_PKG_PATH}target/bin/sqlite3"
DEF_SQLITE3="/usr/syno/bin/sqlite3"
SS_MIN_DOOR_LICENSE_VERSION="8.0.0-5090"
SS_MIN_DOOR_PRIVILEGE_VERSION="8.1.0-5323"
FN_CHECK_BOX_VALIDATOR="{ var blChecked = arguments[0]; return true === blChecked; }"

UPGRADE_VS_60_80_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "$(echo $PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE | sed "s/{0}/${SS_MIN_VS_60_80_VERSION}/g")",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_VS_360_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"items": [{
		"desc": "$PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE"
	}]
}
EOF`

UPGRADE_PSIA_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "${PKG_STR_WIZARD_UPGRADE_PSIA_NOTE}",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_DB_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"desc": "${PKG_STR_WIZARD_UPGRADE_NOTE}"
	}]
}
EOF`

UPGRADE_DOOR_LICENSE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "$PKG_STR_WIZARD_UPGRADE_DOOR_LICENSE",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_DOOR_LICENSE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_DOOR_PRIVILEGE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "${PKG_STR_WIZARD_DOOR_PRIVILEGE_CHECK_NOTE}",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_UPGRADE_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

Sqlite3Exec()
{
	local sqlite_bin=""
	if [ -f "$SS_SQLITE3" ]; then
		sqlite_bin=$SS_SQLITE3
	else
		sqlite_bin=$DEF_SQLITE3
	fi

	$sqlite_bin -init /dev/null -cmd ".timeout 300000" "$@"
}

IsUpgradeToSqlite3()
{
	local PreSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 1)

	if [ ${SS_SQLITE3_VER} \> ${PreSSVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeToDoorLicense()
{
	local TargetSSVer=$(echo ${SS_MIN_DOOR_LICENSE_VERSION} | sed 's/\.//g' | sed 's/-//g')
	local CurrentSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}")

	CurrentSSVer=$(echo ${CurrentSSVer} | sed 's/\.//g' | sed 's/-//g')

	if [ "${TargetSSVer}" -gt "${CurrentSSVer}" ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeThumbnailToFile()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 2)

	if [ ${SS_THUMBNAIL_ISSUE_BUILD_VER} -le ${PreSSBuildVer} ] && [ ${SS_THUMBNAIL_FIXED_BUILD_VER} -gt ${PreSSBuildVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeToDoorPrivilege()
{
	local TargetSSVer=$(echo ${SS_MIN_DOOR_PRIVILEGE_VERSION} | sed 's/\.//g' | sed 's/-//g')
	local CurrentSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}")

	CurrentSSVer=$(echo ${CurrentSSVer} | sed 's/\.//g' | sed 's/-//g')

	if [ "${TargetSSVer}" -ge "${CurrentSSVer}" ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasVS()
{
	local Models="$1"
	local MinVersion="$2"
	local SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"

	if [ -n "$MinVersion" ]; then
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models) AND version < $MinVersion"
	else
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"
	fi

	CheckSystemDBItemExist "${SqlCmd}"
}

HasPsiaCam()
{
	local SqlCmd="SELECT COUNT(*) FROM camera WHERE vendor IN ${SS_UNSUPPORT_VENDOR}"

	CheckSystemDBItemExist "${SqlCmd}"
}

HasDoor()
{
	local DoorCount=$(sqlite3 $SS_AXISDOOR_DB_FILE "SELECT COUNT (id) FROM axisacsctrler where id IS NOT NULL")

	if [ $DoorCount -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasLargeDoorLog()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 2)
	local DoorLogCount=$(sqlite3 $SS_AXISDOORLOG_DB_FILE "SELECT COUNT (*) FROM axisacsevtlog")

	if [ ${SS_ADD_DOORLOG_INDEX_BUILD_VER} -gt ${PreSSBuildVer} ] && [ ${DoorLogCount} -gt 60000 ]; then
		echo "true"
	else
		echo "false"
	fi
}

CheckSystemDBItemExist()
{
	local SqlCmd="$1"
	local Cnt=$(Sqlite3Exec $SS_SYSTEM_DB_FILE "$SqlCmd")

	if [ -z "${Cnt}" ]; then
		if [ -f /usr/syno/pgsql/bin/psql ]; then
			Cnt=$(/usr/syno/pgsql/bin/psql -A -t -U postgres surveillance -c "${SqlCmd}")
		else
			Cnt=0
		fi
	fi

	if [ ${Cnt} -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

GetUpgradeNotePages()
{
	local Pages=""

	if [ "true" == $(HasPsiaCam) ]; then
		Pages="${UPGRADE_PSIA_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_60_80") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_60_80_NOTE_PAGE}" \
						|| Pages="${Pages},${UPGRADE_VS_60_80_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_360HD" "$VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_360_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_VS_360_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToSqlite3) ] || [ "true" == $(IsUpgradeThumbnailToFile) ] || [ "true" == $(HasLargeDoorLog) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DB_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DB_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToDoorLicense) ] && [ "true" == $(HasDoor) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DOOR_LICENSE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DOOR_LICENSE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToDoorPrivilege) ] && [ "true" == $(HasDoor) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DOOR_PRIVILEGE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DOOR_PRIVILEGE_PAGE}"
	fi

	echo "[$Pages]"
}

main()
{
	local UpgradeNotePages="$(GetUpgradeNotePages)"

	if [ "[]" == "$UpgradeNotePages" ]; then
		exit 0
	fi

	echo "$UpgradeNotePages" > $SYNOPKG_TEMP_LOGFILE

	exit 0
}

main "$@"
