#!/bin/sh

PKG_STR_WIZARD_UPGRADE_TITLE="Leia antes de prosseguir"
PKG_STR_WIZARD_UPGRADE_NOTE="A atualização para o Surveillance Station requer a conversão do banco de dados e pode demorar um pouco, dependendo do número de gravações no banco de dados. Aguarde e não desligue o sistema ou desinstale o pacote durante esse processo."
PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE="Esta versão do Surveillance Station é compatível apenas com o VisualStation {0} e superior. Os modelos VisualStation VS60 e VS80 não são mais suportados por esta versão do Surveillance Station."
PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE="Depois que o VS360HD for atualizado para a versão 4.0 ou posterior, a função de emparelhamento original do Visual Station será substituída pelo novo mecanismo de login. Você poderá fazer login no Surveillance Station diretamente do Synology VisualStation VS360HD. Além disso, todos os recursos de gravação de vídeo em rede oferecidos pelo Surveillance Station serão suportados no VS360HD.<br><br>A versão atual do Surveillance Station é compatível com a função de emparelhamento original do VisualStation 3.0.5 e também com o novo mecanismo de login do VisualStation 4.0. No entanto, a função de emparelhamento original será descontinuada em atualizações futuras."
PKG_STR_WIZARD_UPGRADE_PSIA_NOTE="O Surveillance Station não suporta mais PSIA a partir desta versão. Você não pode usar as câmeras que foram configuradas com PSIA no Surveillance Station."
PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL="Eu entendo as restrições de compatibilidade e desejo prosseguir com a atualização."
PKG_STR_WIZARD_UPGRADE_DOOR_LICENSE="Esta versão do Surveillance Station aplicará a nova política de licença a controladores de acesso.<br><br>Cada controlador de acesso recém-adicionado será contado como um dispositivo de vigilância e usará uma licença de dispositivo de vigilância, assim como câmeras IP e módulos de E/S. No entanto, os controladores de acesso instalados anteriormente ainda poderão ser usados sem licenças após essa atualização."
PKG_STR_WIZARD_DOOR_LICENSE_CHECK_LABEL="Entendo a nova política de licença para controladores de acesso e desejo prosseguir com a atualização."
PKG_STR_WIZARD_DOOR_PRIVILEGE_CHECK_NOTE="Após a atualização para esta versão, o gerenciamento de privilégios para controladores de porta será movido para o Perfil privilegiado na página Usuários."
PKG_STR_WIZARD_UPGRADE_LABEL="Eu compreendo as alterações que serão feitas e concordo para continuar com a atualização."

# Copyright (c) 2015 Synology Inc. All rights reserved.

SS_PKG_PATH="/var/packages/SurveillanceStation/"
SS_INFO_FILE=${SS_PKG_PATH}"INFO"
SS_SYSTEM_DB_FILE=${SS_PKG_PATH}"target/system.db"
SS_AXISDOOR_DB_FILE=${SS_PKG_PATH}"target/axisacsctrl.db"
SS_AXISDOORLOG_DB_FILE=${SS_PKG_PATH}"target/@surveillance/axisacsevtlog.db"
SS_VER_KEY="version"
SS_SQLITE3_VER="6.3"
SS_THUMBNAIL_ISSUE_BUILD_VER="3312"
SS_THUMBNAIL_FIXED_BUILD_VER="3352"
SS_ADD_DOORLOG_INDEX_BUILD_VER="5372"
VS_MODELS_60_80="'VS60', 'VS80'"
VS_MODELS_360HD="'VS360HD'"
VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION="'4.0'"
SS_UNSUPPORT_VENDOR="('PSIA')"
SS_MIN_VS_60_80_VERSION="2.2-1413"
SS_MIN_VS_360_VERSION="3.1-2500"
SS_SQLITE3="${SS_PKG_PATH}target/bin/sqlite3"
DEF_SQLITE3="/usr/syno/bin/sqlite3"
SS_MIN_DOOR_LICENSE_VERSION="8.0.0-5090"
SS_MIN_DOOR_PRIVILEGE_VERSION="8.1.0-5323"
FN_CHECK_BOX_VALIDATOR="{ var blChecked = arguments[0]; return true === blChecked; }"

UPGRADE_VS_60_80_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "$(echo $PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE | sed "s/{0}/${SS_MIN_VS_60_80_VERSION}/g")",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_VS_360_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"items": [{
		"desc": "$PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE"
	}]
}
EOF`

UPGRADE_PSIA_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "${PKG_STR_WIZARD_UPGRADE_PSIA_NOTE}",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_DB_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"desc": "${PKG_STR_WIZARD_UPGRADE_NOTE}"
	}]
}
EOF`

UPGRADE_DOOR_LICENSE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "$PKG_STR_WIZARD_UPGRADE_DOOR_LICENSE",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_DOOR_LICENSE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_DOOR_PRIVILEGE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "${PKG_STR_WIZARD_DOOR_PRIVILEGE_CHECK_NOTE}",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_UPGRADE_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

Sqlite3Exec()
{
	local sqlite_bin=""
	if [ -f "$SS_SQLITE3" ]; then
		sqlite_bin=$SS_SQLITE3
	else
		sqlite_bin=$DEF_SQLITE3
	fi

	$sqlite_bin -init /dev/null -cmd ".timeout 300000" "$@"
}

IsUpgradeToSqlite3()
{
	local PreSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 1)

	if [ ${SS_SQLITE3_VER} \> ${PreSSVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeToDoorLicense()
{
	local TargetSSVer=$(echo ${SS_MIN_DOOR_LICENSE_VERSION} | sed 's/\.//g' | sed 's/-//g')
	local CurrentSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}")

	CurrentSSVer=$(echo ${CurrentSSVer} | sed 's/\.//g' | sed 's/-//g')

	if [ "${TargetSSVer}" -gt "${CurrentSSVer}" ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeThumbnailToFile()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 2)

	if [ ${SS_THUMBNAIL_ISSUE_BUILD_VER} -le ${PreSSBuildVer} ] && [ ${SS_THUMBNAIL_FIXED_BUILD_VER} -gt ${PreSSBuildVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeToDoorPrivilege()
{
	local TargetSSVer=$(echo ${SS_MIN_DOOR_PRIVILEGE_VERSION} | sed 's/\.//g' | sed 's/-//g')
	local CurrentSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}")

	CurrentSSVer=$(echo ${CurrentSSVer} | sed 's/\.//g' | sed 's/-//g')

	if [ "${TargetSSVer}" -ge "${CurrentSSVer}" ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasVS()
{
	local Models="$1"
	local MinVersion="$2"
	local SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"

	if [ -n "$MinVersion" ]; then
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models) AND version < $MinVersion"
	else
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"
	fi

	CheckSystemDBItemExist "${SqlCmd}"
}

HasPsiaCam()
{
	local SqlCmd="SELECT COUNT(*) FROM camera WHERE vendor IN ${SS_UNSUPPORT_VENDOR}"

	CheckSystemDBItemExist "${SqlCmd}"
}

HasDoor()
{
	local DoorCount=$(sqlite3 $SS_AXISDOOR_DB_FILE "SELECT COUNT (id) FROM axisacsctrler where id IS NOT NULL")

	if [ $DoorCount -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasLargeDoorLog()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 2)
	local DoorLogCount=$(sqlite3 $SS_AXISDOORLOG_DB_FILE "SELECT COUNT (*) FROM axisacsevtlog")

	if [ ${SS_ADD_DOORLOG_INDEX_BUILD_VER} -gt ${PreSSBuildVer} ] && [ ${DoorLogCount} -gt 60000 ]; then
		echo "true"
	else
		echo "false"
	fi
}

CheckSystemDBItemExist()
{
	local SqlCmd="$1"
	local Cnt=$(Sqlite3Exec $SS_SYSTEM_DB_FILE "$SqlCmd")

	if [ -z "${Cnt}" ]; then
		if [ -f /usr/syno/pgsql/bin/psql ]; then
			Cnt=$(/usr/syno/pgsql/bin/psql -A -t -U postgres surveillance -c "${SqlCmd}")
		else
			Cnt=0
		fi
	fi

	if [ ${Cnt} -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

GetUpgradeNotePages()
{
	local Pages=""

	if [ "true" == $(HasPsiaCam) ]; then
		Pages="${UPGRADE_PSIA_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_60_80") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_60_80_NOTE_PAGE}" \
						|| Pages="${Pages},${UPGRADE_VS_60_80_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_360HD" "$VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_360_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_VS_360_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToSqlite3) ] || [ "true" == $(IsUpgradeThumbnailToFile) ] || [ "true" == $(HasLargeDoorLog) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DB_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DB_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToDoorLicense) ] && [ "true" == $(HasDoor) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DOOR_LICENSE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DOOR_LICENSE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToDoorPrivilege) ] && [ "true" == $(HasDoor) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DOOR_PRIVILEGE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DOOR_PRIVILEGE_PAGE}"
	fi

	echo "[$Pages]"
}

main()
{
	local UpgradeNotePages="$(GetUpgradeNotePages)"

	if [ "[]" == "$UpgradeNotePages" ]; then
		exit 0
	fi

	echo "$UpgradeNotePages" > $SYNOPKG_TEMP_LOGFILE

	exit 0
}

main "$@"
