#!/bin/sh

PKG_STR_WIZARD_UPGRADE_TITLE="Devam etmeden önce okuyun"
PKG_STR_WIZARD_UPGRADE_NOTE="Surveillance Station yükseltme veritabanı dönüşümünü içerir ve bu yüzden veritabanındaki kayıtlara bağlı olarak bir süre alabilir. Lütfen sabırla bekleyin ve bu işlem sırasında sistemi kapatmayın ya da paketi kaldırmayın."
PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE="Bu Surveillance Station sürümü sadece VisualStation {0} ve sonrası ile uyumludur. VisualStation VS60 ve VS80 modelleri artık bu Surveillance Station sürümü tarafından desteklenmez."
PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE="VS360HD sürüm 4.0 ve sonrasına yükseltildikten sonra, Visual Station'un orijinal eşleme fonksiyonunun yerini yeni oturum açma mekanizması alacaktır. Surveillance Station'da doğrudan Synology VisualStation VS360HD'nizden oturum açabileceksiniz. Ayrıca, Surveillance Station tarafından desteklenen tüm ağ video kaydı özellikleri VS360HD'de desteklenecektir.<br><br>Surveillance Station'un mevcut sürümü hem VisualStation sürüm 3.0.5'in orijinal eşleme fonksiyonu hem de VisualStation sürüm 4.0'ın yeni oturum açma mekanizması ile uyumludur. Ancak, orijinal eşleme fonksiyonu gelecek güncellemelerde sona erecektir."
PKG_STR_WIZARD_UPGRADE_PSIA_NOTE="Surveillance Station bu sürümden itibaren PSIA desteklemez. PSIA ile Surveillance Station'da kurulmuş olan kameraları kullanamazsınız."
PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL="Uyumluluk sınırlamalarını anlıyorum ve güncellemeye devam etmek istiyorum."
PKG_STR_WIZARD_UPGRADE_DOOR_LICENSE="Bu Surveillance Station sürümü erişim kontrolörlerine yeni lisans politikasını uygulayacaktır.<br><br>Her yeni eklenen erişim kontrolörü bir gözetleme cihazı olarak sayılacaktır ve IP kameralar ve I/O modülleri ile aynı gözetleme cihazı lisansını kullanacaktır. Ancak, önceden kurulu erişim kontrolörleriniz yine de bu güncelleme sonrasında lisanslar olmadan kullanılabilir."
PKG_STR_WIZARD_DOOR_LICENSE_CHECK_LABEL="Erişim kontrolörleri için yeni lisans politikasını anlıyorum ve güncellemeye devam etmek istiyorum."
PKG_STR_WIZARD_DOOR_PRIVILEGE_CHECK_NOTE="Bu sürüme yükselttikten sonra kapı kontrolörleri için ayrıcalık yönetimi Kullanıcılar sayfasındaki Ayrıcalık Profili'ne taşınacaktır."
PKG_STR_WIZARD_UPGRADE_LABEL="Yapılması gereken değişiklikleri anlıyorum ve güncellemeye devam etmeyi kabul ediyorum."

# Copyright (c) 2015 Synology Inc. All rights reserved.

SS_PKG_PATH="/var/packages/SurveillanceStation/"
SS_INFO_FILE=${SS_PKG_PATH}"INFO"
SS_SYSTEM_DB_FILE=${SS_PKG_PATH}"target/system.db"
SS_AXISDOOR_DB_FILE=${SS_PKG_PATH}"target/axisacsctrl.db"
SS_AXISDOORLOG_DB_FILE=${SS_PKG_PATH}"target/@surveillance/axisacsevtlog.db"
SS_VER_KEY="version"
SS_SQLITE3_VER="6.3"
SS_THUMBNAIL_ISSUE_BUILD_VER="3312"
SS_THUMBNAIL_FIXED_BUILD_VER="3352"
SS_ADD_DOORLOG_INDEX_BUILD_VER="5372"
VS_MODELS_60_80="'VS60', 'VS80'"
VS_MODELS_360HD="'VS360HD'"
VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION="'4.0'"
SS_UNSUPPORT_VENDOR="('PSIA')"
SS_MIN_VS_60_80_VERSION="2.2-1413"
SS_MIN_VS_360_VERSION="3.1-2500"
SS_SQLITE3="${SS_PKG_PATH}target/bin/sqlite3"
DEF_SQLITE3="/usr/syno/bin/sqlite3"
SS_MIN_DOOR_LICENSE_VERSION="8.0.0-5090"
SS_MIN_DOOR_PRIVILEGE_VERSION="8.1.0-5323"
FN_CHECK_BOX_VALIDATOR="{ var blChecked = arguments[0]; return true === blChecked; }"

UPGRADE_VS_60_80_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "$(echo $PKG_STR_WIZARD_UPGRADE_VS_60_80_NOTE | sed "s/{0}/${SS_MIN_VS_60_80_VERSION}/g")",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_VS_360_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"items": [{
		"desc": "$PKG_STR_WIZARD_UPGRADE_VS_360HD_NOTE"
	}]
}
EOF`

UPGRADE_PSIA_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "${PKG_STR_WIZARD_UPGRADE_PSIA_NOTE}",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_INCOMPATIBLE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_DB_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"desc": "${PKG_STR_WIZARD_UPGRADE_NOTE}"
	}]
}
EOF`

UPGRADE_DOOR_LICENSE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "$PKG_STR_WIZARD_UPGRADE_DOOR_LICENSE",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_DOOR_LICENSE_CHECK_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

UPGRADE_DOOR_PRIVILEGE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"invalid_next_disabled": true,
	"items": [{
		"type": "multiselect",
		"desc": "${PKG_STR_WIZARD_DOOR_PRIVILEGE_CHECK_NOTE}",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_UPGRADE_LABEL}",
			"validator": {
				"fn": "$FN_CHECK_BOX_VALIDATOR"
			}
		}]
	}]
}
EOF`

Sqlite3Exec()
{
	local sqlite_bin=""
	if [ -f "$SS_SQLITE3" ]; then
		sqlite_bin=$SS_SQLITE3
	else
		sqlite_bin=$DEF_SQLITE3
	fi

	$sqlite_bin -init /dev/null -cmd ".timeout 300000" "$@"
}

IsUpgradeToSqlite3()
{
	local PreSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 1)

	if [ ${SS_SQLITE3_VER} \> ${PreSSVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeToDoorLicense()
{
	local TargetSSVer=$(echo ${SS_MIN_DOOR_LICENSE_VERSION} | sed 's/\.//g' | sed 's/-//g')
	local CurrentSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}")

	CurrentSSVer=$(echo ${CurrentSSVer} | sed 's/\.//g' | sed 's/-//g')

	if [ "${TargetSSVer}" -gt "${CurrentSSVer}" ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeThumbnailToFile()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 2)

	if [ ${SS_THUMBNAIL_ISSUE_BUILD_VER} -le ${PreSSBuildVer} ] && [ ${SS_THUMBNAIL_FIXED_BUILD_VER} -gt ${PreSSBuildVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeToDoorPrivilege()
{
	local TargetSSVer=$(echo ${SS_MIN_DOOR_PRIVILEGE_VERSION} | sed 's/\.//g' | sed 's/-//g')
	local CurrentSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}")

	CurrentSSVer=$(echo ${CurrentSSVer} | sed 's/\.//g' | sed 's/-//g')

	if [ "${TargetSSVer}" -ge "${CurrentSSVer}" ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasVS()
{
	local Models="$1"
	local MinVersion="$2"
	local SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"

	if [ -n "$MinVersion" ]; then
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models) AND version < $MinVersion"
	else
		SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ($Models)"
	fi

	CheckSystemDBItemExist "${SqlCmd}"
}

HasPsiaCam()
{
	local SqlCmd="SELECT COUNT(*) FROM camera WHERE vendor IN ${SS_UNSUPPORT_VENDOR}"

	CheckSystemDBItemExist "${SqlCmd}"
}

HasDoor()
{
	local DoorCount=$(sqlite3 $SS_AXISDOOR_DB_FILE "SELECT COUNT (id) FROM axisacsctrler where id IS NOT NULL")

	if [ $DoorCount -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasLargeDoorLog()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | cut -d '-' -f 2)
	local DoorLogCount=$(sqlite3 $SS_AXISDOORLOG_DB_FILE "SELECT COUNT (*) FROM axisacsevtlog")

	if [ ${SS_ADD_DOORLOG_INDEX_BUILD_VER} -gt ${PreSSBuildVer} ] && [ ${DoorLogCount} -gt 60000 ]; then
		echo "true"
	else
		echo "false"
	fi
}

CheckSystemDBItemExist()
{
	local SqlCmd="$1"
	local Cnt=$(Sqlite3Exec $SS_SYSTEM_DB_FILE "$SqlCmd")

	if [ -z "${Cnt}" ]; then
		if [ -f /usr/syno/pgsql/bin/psql ]; then
			Cnt=$(/usr/syno/pgsql/bin/psql -A -t -U postgres surveillance -c "${SqlCmd}")
		else
			Cnt=0
		fi
	fi

	if [ ${Cnt} -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

GetUpgradeNotePages()
{
	local Pages=""

	if [ "true" == $(HasPsiaCam) ]; then
		Pages="${UPGRADE_PSIA_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_60_80") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_60_80_NOTE_PAGE}" \
						|| Pages="${Pages},${UPGRADE_VS_60_80_NOTE_PAGE}"
	fi

	if [ "true" == $(HasVS "$VS_MODELS_360HD" "$VS_360HD_NEW_LOGIN_MECHANISM_MIN_VERSION") ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_VS_360_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_VS_360_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToSqlite3) ] || [ "true" == $(IsUpgradeThumbnailToFile) ] || [ "true" == $(HasLargeDoorLog) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DB_NOTE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DB_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToDoorLicense) ] && [ "true" == $(HasDoor) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DOOR_LICENSE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DOOR_LICENSE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToDoorPrivilege) ] && [ "true" == $(HasDoor) ]; then
		[ -z "$Pages" ] && Pages="${UPGRADE_DOOR_PRIVILEGE_PAGE}" \
				        || Pages="${Pages},${UPGRADE_DOOR_PRIVILEGE_PAGE}"
	fi

	echo "[$Pages]"
}

main()
{
	local UpgradeNotePages="$(GetUpgradeNotePages)"

	if [ "[]" == "$UpgradeNotePages" ]; then
		exit 0
	fi

	echo "$UpgradeNotePages" > $SYNOPKG_TEMP_LOGFILE

	exit 0
}

main "$@"
