-- search history table
CREATE TABLE IF NOT EXISTS search_history
(
	id              INTEGER	       PRIMARY KEY AUTOINCREMENT,
	uid             bigint         NOT NULL DEFAULT 0,
	keyword         text           NOT NULL DEFAULT '',
	create_time     bigint         NOT NULL DEFAULT (strftime('%s', 'now')),
	UNIQUE(uid, keyword)
);

-- bookmark table
CREATE TABLE IF NOT EXISTS bookmark
(
	id              INTEGER	       PRIMARY KEY AUTOINCREMENT,
	uid             bigint         NOT NULL DEFAULT 0,
	name            text           NOT NULL DEFAULT '',
	keyword         text           NOT NULL DEFAULT '',
	criteria        text           NOT NULL DEFAULT '',
	UNIQUE(uid, name)
);

-- update config version
INSERT INTO config(version) VALUES(1);
