#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       NITEMS, SHARE_NAME_X, SHARE_OP_RESULT_X
###############################################################

#At begining, acquire package settings
FILEINDEX_TOOL_PATH=/var/packages/SynoFinder/target/tool/fileindex

PKG_NAME="SynoFinder"
PKG_VERSION="1.0"
PKG_VENDOR="Synology Inc."
SDK_MODVER="2.0"

PauseAllShare() {
	INDEX=1;
	NITEMS=$((NITEMS + 1))
	while [ "${INDEX}" != "${NITEMS}" ]
	do
		eval "FILEINDEX_SHARE_NAME=\$SHARE_NAME_$INDEX"
		${FILEINDEX_TOOL_PATH} -a share_pause -n "${FILEINDEX_SHARE_NAME}" -d "share_delete hook: share_pause"
		INDEX=$((INDEX + 1))
	done
}

CheckShareDeleted() {
	# Only hooked when shares are deleted successfully
	INDEX=1;
	NITEMS=$((NITEMS + 1))
	while [ "${INDEX}" != "${NITEMS}" ]
	do
		eval "SHARE_OP_RESULT=\$SHARE_OP_RESULT_$INDEX"
		eval "FILEINDEX_SHARE_NAME=\$SHARE_NAME_$INDEX"
		eval "FILEINDEX_SHARE_PATH=\$SHARE_PATH_$INDEX"
		if [ "0x0000" = "${SHARE_OP_RESULT}" ]; then
			${FILEINDEX_TOOL_PATH} -a share_clear_paused -n "${FILEINDEX_SHARE_NAME}" -p "${FILEINDEX_SHARE_PATH}" -d "share_delete hook: share_clear_paused"
		else
			${FILEINDEX_TOOL_PATH} -a share_resume -n "${FILEINDEX_SHARE_NAME}" -d "share_delete hook: share_resume"
		fi
		INDEX=$((INDEX + 1))
	done
}

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${PKG_VENDOR}
	;;
	--pre)
		#Actions before share delete
		PauseAllShare
	;;
	--post)
		#Actions after share delete
		CheckShareDeleted
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
