#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareEncShareMount & SYNOShareEncShareUnmount
#   Usable environment variable:
#       SHARE_NAME, ENC_ACTION={encrypt|decrypt}, RESULT
###############################################################

#At begining, acquire package settings
FILEINDEX_TOOL_PATH=/var/packages/SynoFinder/target/tool/fileindex

PKG_NAME="SynoFinder"
PKG_VERSION="1.0"
PKG_VENDOR="Synology Inc."
SDK_MODVER="2.0"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${PKG_VENDOR}
	;;
	--pre)
		#Actions before share encrypt action
		if [ "encrypt" = "${ENC_ACTION}" ]; then
			${FILEINDEX_TOOL_PATH} -a share_pause  -n "${SHARE_NAME}" -d "share_encryption_action encrypt pre: share_pause"
		fi
	;;
	--post)
		#Actions after share encrypt action
		if [ "encrypt" = "${ENC_ACTION}" ]; then
			if [ "0" != "${RESULT}" ]; then
				${FILEINDEX_TOOL_PATH} -a share_resume -n "${SHARE_NAME}" -d "share_encryption_action encrypt post: share_resume"
			fi
		elif [ "decrypt" = "${ENC_ACTION}" ]; then
			if [ "0" = "${RESULT}" ]; then
				${FILEINDEX_TOOL_PATH} -a share_resume -n "${SHARE_NAME}" -d "share_encryption_action decrypt post: share_resume"
				${FILEINDEX_TOOL_PATH} -a share_autoclean -n "${SHARE_NAME}" -d "share_encryption_action decrypt post: share_autoclean"
			fi
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
