#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareCreate, SYNOShareRename, SYNOShareMove, SYNOShareUpdate
#   Usable environment variable:
#       ORIGIN_SHARE_NAME, SHARE_NAME,
#       ORIGIN_SHARE_PATH, SHARE_PATH,
#       ORIGIN_SHARE_STATUS (encrypt/decrypt/normal),
#       SHARE_STATUS (encrypt/decrypt/normal),
#       ORIGIN_SHARE_ENCRYPTION, SHARE_ENCRYPTION (encrypted/decrypted/no),
#       ORIGIN_SHARE_FORBIDDEN, SHARE_FORBIDDEN (1/0 means true/false),
#       PERMISSION_CHANGE (0 when permission not change, 1 when changed)
#       RESULT
###############################################################

#At begining, acquire package settings
FILEINDEX_TOOL_PATH=/var/packages/SynoFinder/target/tool/fileindex

PKG_NAME="SynoFinder"
PKG_VERSION="1.0"
PKG_VENDOR="Synology Inc."
SDK_MODVER="2.0"

IS_RENAME=0
IS_MIGRATE=0

CheckHookType() {
	if [ -n "${ORIGIN_SHARE_NAME}" ] && [ "${ORIGIN_SHARE_NAME}" != "${SHARE_NAME}" ]; then
		IS_RENAME=1
	elif [ -n "${ORIGIN_SHARE_PATH}" ] && [ "${ORIGIN_SHARE_PATH}" != "${SHARE_PATH}" ]; then
		IS_MIGRATE=1
	fi;
}

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${PKG_VENDOR}
	;;
	--pre)
		CheckHookType
		if [ "1" = "${IS_RENAME}" ] || [ "1" = "${IS_MIGRATE}" ]; then
			${FILEINDEX_TOOL_PATH} -a share_pause -n "${ORIGIN_SHARE_NAME}" -d "share_set rename / migrate pre: share_pause"
		fi
	;;
	--post)
		CheckHookType
		if [ "0" = "${RESULT}" ]; then
			if [ "1" = "${IS_RENAME}" ]; then
				${FILEINDEX_TOOL_PATH} -a share_rename -f "${ORIGIN_SHARE_NAME}" -t "${SHARE_NAME}" -d "share_set rename post: share_rename"
				${FILEINDEX_TOOL_PATH} -a share_resume -n "${SHARE_NAME}" -d "share_set rename post: share_resume"
			elif [ "1" = "${IS_MIGRATE}" ]; then
				${FILEINDEX_TOOL_PATH} -a share_migrate -n "${SHARE_NAME}" -f "${ORIGIN_SHARE_PATH}" -t "${SHARE_PATH}" -d "share_set migrate post: share_migrate"
				${FILEINDEX_TOOL_PATH} -a share_resume -n "${SHARE_NAME}" -d "share_set migrate post: share_resume"
				${FILEINDEX_TOOL_PATH} -a reindex -p "/${SHARE_NAME}" -d "share_set migrate post: reindex"
			fi
		fi
		${FILEINDEX_TOOL_PATH} -a share_check_recycle -n "${SHARE_NAME}" -d "share_set post: share_check_recycle"
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
