#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareSnapXXXX()
#   XXXX: Create, Restore, Clone
#   Usable environment variable:
#       SHARE_NAME, SHARE_PATH, NEW_SHARE_NAME, NEW_SHARE_PATH, SNAPSHOT, ACTION, ENC_STATUS, RESULT
###############################################################

#At begining, acquire package settings
FILEINDEX_TOOL_PATH=/var/packages/SynoFinder/target/tool/fileindex

PKG_NAME="SynoFinder"
PKG_VERSION="1.0"
PKG_VENDOR="Synology Inc."
PKG_MODVER="2.0"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version. Right now, Share module is 2.0
		echo ${PKG_MODVER}
	;;
	--name)
		#Print name
		echo ${PKG_NAME}
	;;
	--pkg-ver)
		echo ${PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${PKG_VENDOR}
	;;
	--pre)
		#Actions before share restore
		case $ACTION in
		CREATE)
			;;
		RESTORE)
			${FILEINDEX_TOOL_PATH} -a share_pause -n "${SHARE_NAME}" -d "share_snapshot restore pre: share_pause"
			;;
		CLONE_SHARE)
			;;
		CLONE_SNAP)
			;;
		*)
			;;
		esac
	;;
	--post)
		#Actions after share restore
		case $ACTION in
		CREATE)
			;;
		RESTORE)
			${FILEINDEX_TOOL_PATH} -a share_rebuild -n "${SHARE_NAME}" -d "share_snapshot restore post: share_rebuild"
			;;
		CLONE_SHARE)
			;;
		CLONE_SNAP)
			;;
		*)
			;;
		esac
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
