#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareTransform
#   Usable environment variable:
#       SHARE_NAME, TRANS_DIRECT={encryption|decryption}, RESULT
###############################################################

#At begining, acquire package settings
FILEINDEX_TOOL_PATH=/var/packages/SynoFinder/target/tool/fileindex

PKG_NAME="SynoFinder"
PKG_VERSION="1.0"
PKG_VENDOR="Synology Inc."
SDK_MODVER="2.0"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${PKG_VENDOR}
	;;
	--pre)
		#Actions before share transform action
		${FILEINDEX_TOOL_PATH} -a share_pause  -n "${SHARE_NAME}" -d "share_transform pre: share_pause"
	;;
	--post)
		#Actions after share transform action
		${FILEINDEX_TOOL_PATH} -a reindex -p "/${SHARE_NAME}" -d "share_transform post: reindex"
		${FILEINDEX_TOOL_PATH} -a share_resume -n "${SHARE_NAME}" -d "share_transform post: share_resume"
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
