#!/bin/sh

FILEINDEX_TOOL_PATH=/var/packages/SynoFinder/target/tool/fileindex

PKG_NAME="SynoFinder"
PKG_VERSION="1.0"
PKG_VENDOR="Synology Inc."
SDK_MODVER="1.0"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
		;;
	--name)
		#Print package name
		echo ${PKG_NAME}
		;;
	--pkg-ver)
		#Print package version
		echo ${PKG_VERSION}
		;;
	--vendor)
		#Print package vendor
		echo ${PKG_VENDOR}
		;;
	--pre)
		for INDEX in $(seq 1 1 $NITEMS); do
			eval "USER_ID=\$UID_$INDEX"
			${FILEINDEX_TOOL_PATH} -a user_remember -u "${USER_ID}" -d "user_delete pre: user_remember"
		done
		;;
	--post)
		for INDEX in $(seq 1 1 $NITEMS); do
			eval "USER_OP_RESULT=\$USER_OP_RESULT_$INDEX"
			eval "USER_ID=\$UID_$INDEX"
			if [ "0x0000" = "${USER_OP_RESULT}" ]; then
				${FILEINDEX_TOOL_PATH} -a user_delete -u "${USER_ID}" -d "user_delete post: user_delete"
			fi
		done
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
