#! /bin/sh

FILEINDEX_TOOL_PATH=/var/packages/SynoFinder/target/tool/fileindex

PKG_NAME="SynoFinder"
PKG_VERSION="1.0"
PKG_VENDOR="Synology Inc."
SDK_MODVER="1.0"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${PKG_VENDOR}
	;;
	--pre)
		#Actions before share delete
	;;
	--post)
		#Actions after share delete
		if [ "$RESULT" -eq 0 ]; then
			if [ "$SYNO_HOME_ACTION" == "disable" ]; then
				${FILEINDEX_TOOL_PATH} -a "home_disable" -A ${SYNO_AUTH_TYPE} -d "user_home_service disable post: home_disable"
			else
				${FILEINDEX_TOOL_PATH} -a "home_enable" -A ${SYNO_AUTH_TYPE} -d "user_home_service enable post: home_enable"
			fi
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
