#!/bin/sh

FILEINDEX_TOOL_PATH=/var/packages/SynoFinder/target/tool/fileindex

PKG_NAME="SynoFinder"
PKG_VERSION="1.0"
PKG_VENDOR="Synology Inc."
SDK_MODVER="1.0"

# 0: rename, -1: other action
CheckRename() {
	for INDEX in $(seq 1 1 $NTIMES); do
		eval "ORIGIN_USER_NAME=\$ORIGIN_USER_NAME_$INDEX"
		eval "USER_NAME=\$USER_NAME_$INDEX"
		if [ ! -z "${ORIGIN_USER_NAME}" ] && [ "${ORIGIN_USER_NAME}" != "${USER_NAME}" ]; then
			return 0;
		fi
	done

	return -1
}

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${PKG_VENDOR}
	;;
	--pre)
		CheckRename
		RET=$?
		if [ "0" = "${RET}" ]; then
			${FILEINDEX_TOOL_PATH} -a share_pause -n homes -d "user_set pre: share_pause"
		fi
	;;
	--post)
		CheckRename
		RET=$?
		if [ "0" = "${RET}" ]; then
			for INDEX in $(seq 1 1 $NTIMES); do
				eval "USER_OP_RESULT=\$USER_OP_RESULT_$INDEX"
				eval "ORIGIN_USER_NAME=\$ORIGIN_USER_NAME_$INDEX"
				eval "USER_NAME=\$USER_NAME_$INDEX"
				if [ "0x0000" = "${USER_OP_RESULT}" ]; then
					${FILEINDEX_TOOL_PATH} -a user_rename -f "${ORIGIN_USER_NAME}" -t "${USER_NAME}" -d "user_set post: user_rename"
				fi
			done
			${FILEINDEX_TOOL_PATH} -a share_resume -n homes -d "user_set post: share_resume"
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
