#!/bin/sh

FILEINDEX_TOOL_PATH=/var/packages/SynoFinder/target/tool/fileindex

PKG_NAME="SynoFinder"
PKG_VERSION="1.0"
PKG_VENDOR="Synology Inc."
SDK_MODVER="1.0"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${PKG_VENDOR}
	;;
	--pre)
		#Actions before share create
	;;
	--post)
		#Actions after share create
		${FILEINDEX_TOOL_PATH} -a update_log_location -v "NON"
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
