#!/bin/sh

FILEINDEX_TOOL_PATH=/var/packages/SynoFinder/target/tool/fileindex

PKG_NAME="SynoFinder"
PKG_VERSION="1.0"
PKG_VENDOR="Synology Inc."
SDK_MODVER="1.0"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${PKG_VENDOR}
	;;
	--pre)
		#Actions before share delete
		${FILEINDEX_TOOL_PATH} -a volume_pause -v "${MOUNTPOINT}" -d "volume_delete pre: volume_pause"
		${FILEINDEX_TOOL_PATH} -a update_log_location -v "${MOUNTPOINT}"
	;;
	--post)
		#Actions after share delete
		if [ "$RESULT" = 0 ]; then
			${FILEINDEX_TOOL_PATH} -a volume_clear_paused -v "${MOUNTPOINT}" -d "volume_delete success post: volume_clear_paused"
		else
			${FILEINDEX_TOOL_PATH} -a volume_resume -v "${MOUNTPOINT}" -d "volume_delete failed post: volume_resume"
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
