/* Copyright (c) 2019 Synology Inc. All rights reserved. */

Ext.define("SYNO.Finder.Package.PluginWrapper",{extend:"Ext.util.Observable",constructor:function(t){Ext.apply(this,t||{}),this.callParent(arguments)},getPluginId:function(){return this.pluginId},launchApp:function(t){var e=!1;return this.plugin&&Ext.isFunction(this.plugin.launchApp)&&(e=this.plugin.launchApp(t)),e||!1},getEntryIconCls:function(){var t="";return this.plugin&&Ext.isFunction(this.plugin.getEntryIconCls)&&(t=this.plugin.getEntryIconCls()),t||""},getIconCls:function(){var t="";return this.plugin&&Ext.isFunction(this.plugin.getIconCls)&&(t=this.plugin.getIconCls()),t||""},getText:function(){var t="";return this.plugin&&Ext.isFunction(this.plugin.getText)&&(t=this._getText(this.plugin.getText())),t||""},isEnablePreview:function(){var t=!1;return this.plugin&&Ext.isFunction(this.plugin.isEnablePreview)&&(t=this.plugin.isEnablePreview()),t||!1},getPreviewPanel:function(){var t=[];return this.plugin&&Ext.isFunction(this.plugin.getPreviewPanel)&&(t=this.plugin.getPreviewPanel()),Ext.isArray(t)||(t=[t]),t},getPreviewMeta:function(t){var e=[];return this.plugin&&Ext.isFunction(this.plugin.getPreviewMeta)&&(e=this.plugin.getPreviewMeta(t)),e||[]},getSearchAPI:function(){var t={};return this.plugin&&Ext.isFunction(this.plugin.getSearchAPI)&&(t=this.plugin.getSearchAPI()),t||{}},getSearchParam:function(t,e,i,n){var r={};return this.plugin&&Ext.isFunction(this.plugin.getSearchParam)&&(r=this.plugin.getSearchParam(t,e,i,n)),Ext.isEmpty(r)?{}:r},getSearchResults:function(t){var e=[];return this.plugin&&Ext.isFunction(this.plugin.getSearchResults)&&(e=this.plugin.getSearchResults(t)),e||[]},isAllowRTS:function(){var t=!1;return this.plugin&&Ext.isFunction(this.plugin.isAllowRTS)&&(t=this.plugin.isAllowRTS()),t||!1},isEnableViewMode:function(t){var e=!1;return this.plugin&&Ext.isFunction(this.plugin.isEnableViewMode)&&(e=this.plugin.isEnableViewMode(t)),e||!1},hasCustomViewMode:function(){var t=!1;return this.plugin&&Ext.isFunction(this.plugin.hasCustomViewMode)&&(t=this.plugin.hasCustomViewMode()),t||!1},getCustomViewMode:function(){var t=[];return this.plugin&&Ext.isFunction(this.plugin.getCustomViewMode)&&(t=this.plugin.getCustomViewMode()),t||[]},_getText:function(t){try{return t=t.split(":"),_TT(this.ownerApp,t[0],t[1])||_T(t[0],t[1])}catch(t){SYNO.Debug.error(t)}return""}}),Ext.define("SYNO.Finder.Package.PluginMgr",{extend:"Ext.Component",constructor:function(t){this.idMap={},this.appMap={},this.inner_plugins=[],this.callParent(arguments),this.loadPlugins(),this.mon(SYNO.SDS.StatusNotifier,"servicechanged",this.updatePlugin,this),this.mon(SYNO.SDS.StatusNotifier,"appprivilegechanged",this.updatePlugin,this),this.mon(SYNO.SDS.StatusNotifier,"jsconfigLoaded",this.reloadPlugins,this)},loadPlugins:function(){Ext.iterate(SYNO.SDS.Config.FnMap,function(t){this.loadPlugin(t)},this)},reloadPlugins:function(){this._cleanResource(),this.loadPlugins()},updatePlugin:function(t,e){e?this.loadPlugin(t):this.removeByApp(t)},loadPlugin:function(t){var e=SYNO.SDS.Config.FnMap[t];if(e&&e.config&&Ext.isArray(e.config.finder_plugin)&&SYNO.SDS.StatusNotifier.isAppEnabled(t))try{Ext.each(e.config.finder_plugin,function(e){SYNO.SDS.JSLoad(e,function(){var i=Ext.getClassByName(e);this.add(new SYNO.Finder.Package.PluginWrapper({plugin:new i,pluginId:e.replace(/\./g,"-"),ownerApp:t}),t)},this)},this)}catch(t){SYNO.Debug.error(t)}},add:function(t,e){var i=t.getPluginId();this.idMap[i]=this.inner_plugins.length,this.appMap[e]||(this.appMap[e]=[]),this.appMap[e].push(i),this.inner_plugins.push(t),this.fireEvent("pluginadd",t)},getPlugins:function(){return this.inner_plugins},getAt:function(t){return t>=this.inner_plugins.length?null:this.inner_plugins[t]},getById:function(t){return this.idMap.hasOwnProperty(t)?this.inner_plugins[this.idMap[t]]:null},removeById:function(t){this.idMap.hasOwnProperty(t)&&(this.fireEvent("pluginremove",t),this.inner_plugins.splice(this.idMap[t],1),delete this.idMap[t])},removeByApp:function(t){Ext.isArray(this.appMap[t])&&(Ext.each(this.appMap[t],function(t){this.removeById(t)},this),this.appMap[t]=[])},_cleanResource:function(){Ext.each(this.inner_plugins,function(t){this.fireEvent("pluginremove",t.getPluginId())},this),this.idMap={},this.appMap={},this.inner_plugins=[]}}),Ext.namespace("SYNO.Finder.Preference.FileIndex"),Ext.define("SYNO.Finder.Preference.FileIndex.FolderEditDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(t){this.mode=t.mode,this.store=t.store,this.parent=t.parent,this.panel=this.createPanel(),this.defaultLabelWidth=100;var e=Ext.apply({defaultLabelWidth:100,title:"add"===this.mode?SYNO.Finder.Utils._T("common","index_folder_create"):SYNO.Finder.Utils._T("common","index_folder_edit"),width:760,layout:"fit",resizable:!0,items:[this.panel],buttons:[{xtype:"syno_button",btnStyle:"blue",text:_T("common","alt_apply"),scope:this,id:this.btnApplyId=Ext.id(),handler:"add"===this.mode?this.createHandler:this.editHandler},{xtype:"syno_button",text:_T("common","alt_cancel"),scope:this,handler:function(){this.panel.getForm().isDirty()?this.getMsgBox().confirm("",_T("common","confirm_lostchange"),function(t,e){if("yes"!=t)return!1;this.close()},this):this.close()}}]},t);this.callParent([e]),this.btnApply=Ext.getCmp(this.btnApplyId),this.btnEditPath=Ext.getCmp(this.editPathBtnId),this.textFolderPath=Ext.getCmp(this.textFolderPathId),this.textName=Ext.getCmp(this.textNameId),this.checkPhoto=Ext.getCmp(this.checkPhotoId),this.checkMusic=Ext.getCmp(this.checkMusicId),this.checkVideo=Ext.getCmp(this.checkVideoId),this.checkDocument=Ext.getCmp(this.checkDocumentId),"edit"===this.mode&&(this.origPath=this.parent.getSelectionModel().getSelected().get("path")),this.textFolderPath.getEl().on("mouseup",this.editPathBtnHandler,this)},onOpen:function(){if("edit"===this.mode){var t=this.panel.getForm(),e=this.parent.getSelectionModel().getSelected();t.setValues({name:e.get("name"),path:e.get("path"),photo:e.get("photo"),audio:e.get("audio"),document:e.get("document"),video:e.get("video")}),this.btnEditPath.setDisabled(!0),t.clearInvalid(),this.rule_owner=e.get("owner")}this.show()},createPanel:function(){var t=[{xtype:"syno_displayfield",value:SYNO.Finder.Utils._T("common","fileindex_desc")},{xtype:"syno_textfield",fieldLabel:_T("common","name"),name:"name",width:260,itemId:"name",id:this.textNameId=Ext.id(),maxlength:255,allowBlank:!1,blankText:SYNO.Finder.Utils._T("common","error_empty_rule_name")},{xtype:"syno_compositefield",items:[{xtype:"syno_textfield",fieldLabel:_T("common","folder"),width:260,name:"path",id:this.textFolderPathId=Ext.id(),readOnly:!0,allowBlank:!1,blankText:SYNO.Finder.Utils._T("common","error_empty_path")},{xtype:"syno_button",id:this.editPathBtnId=Ext.id(),text:_T("common","choose"),scope:this,handler:this.editPathBtnHandler}]}],e={xtype:"syno_fieldset",title:SYNO.Finder.Utils._T("common","title_indexed_folder"),labelWidth:this.defaultLabelWidth,items:t},i={xtype:"syno_fieldset",title:SYNO.Finder.Utils._T("common","index_folder_index_type"),items:[{xtype:"syno_displayfield",value:SYNO.Finder.Utils._T("common","enable_content_index_desc")},{xtype:"syno_compositefield",hideLabel:!0,items:[{xtype:"syno_checkbox",boxLabel:SYNO.Finder.Utils._T("common","type_photo"),width:100,name:"photo",id:this.checkPhotoId=Ext.id(),checked:!1},{xtype:"syno_checkbox",boxLabel:SYNO.Finder.Utils._T("common","type_music"),width:100,name:"audio",id:this.checkMusicId=Ext.id(),checked:!1},{xtype:"syno_checkbox",boxLabel:SYNO.Finder.Utils._T("common","type_video"),width:100,name:"video",id:this.checkVideoId=Ext.id(),checked:!1},{xtype:"syno_checkbox",boxLabel:SYNO.Finder.Utils._T("common","type_document"),width:160,name:"document",id:this.checkDocumentId=Ext.id(),checked:!1}]}]},n={trackResetOnLoad:!0,border:!1,items:[e,i]};return new SYNO.ux.FormPanel(n)},collectData:function(){var t=this.panel.getForm().findField("path"),e=this.panel.getForm().findField("name"),i=[];if(t.isValid()&&e.isValid())return i.push({path:this.textFolderPath.getValue(),name:this.textName.getValue(),photo:this.checkPhoto.getValue(),audio:this.checkMusic.getValue(),video:this.checkVideo.getValue(),document:this.checkDocument.getValue(),owner:this.rule_owner,group:this.rule_group}),i},createHandler:function(){this.doIndexFolderAction("add",{folder:this.collectData()})},editHandler:function(){this.doIndexFolderAction("set",{folder:this.collectData()})},editPathBtnHandler:function(){"edit"!=this.mode&&(Ext.isDefined(this.dialog)||(this.dialog=new SYNO.SDS.Utils.FileChooser.Chooser({parent:this,owner:this,closeOwnerWhenNoShare:!0,closeOwnerNumber:2,enumRecycle:!1,superuser:!0,usage:{type:"chooseDir"},title:SYNO.Finder.Utils._T("common","select_folder"),folderToolbar:!0,treeFilter:function(t,e){return!e||!("/home"===e.spath||"remote"===e.mountType||"iso"===e.mountType||Ext.isString(e.path)&&0===e.path.indexOf("/volumeUSB")||Ext.isString(e.path)&&0===e.path.indexOf("/volumeSATA")||-1!==this.parent.parent.getPrivilegedPaths().indexOf(e.spath))},listeners:{scope:this,choose:function(t,e,i){if(this.textFolderPath.setValue(e.path),""===this.textName.getValue()){var n=e.path.split("/");this.textName.setValue(n[n.length-1])}t.close()},close:function(){delete this.dialog}}})),this.dialog.show())},doIndexFolderAction:function(t,e){if(!this.panel.getForm().isDirty())return void this.close();this.setStatusBusy({text:_T("common","saving")}),this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Folder",params:e,method:t,version:1,callback:function(t,e,i){if(this.clearStatusBusy(),!t)return void this.setStatusError({text:SYNO.Finder.Utils.getWebAPIErrStr(e)});this.setStatusOK(),this.close()},scope:this})}}),Ext.namespace("SYNO.Finder.Preference.FileIndex"),Ext.define("SYNO.Finder.Preference.FileIndex.FolderList.TabPanel",{extend:"SYNO.SDS.Utils.TabPanel",constructor:function(t){var e=Ext.apply({activeTab:0,useDefaultBtn:!1},t);this.callParent([e])}}),Ext.define("SYNO.Finder.Preference.FileIndex.FolderList.Panel",{extend:"SYNO.ux.GridPanel",PAGE_SIZE:50,constructor:function(t){this.appWin=t.owner.findAppWindow(),this.store=this.createStore(t),this.columnModel=this.createColumnModel();var e=Ext.apply({title:SYNO.Finder.Utils._T("common","title_index_folder"),store:this.store,enableColumnMove:!1,enableHdMenu:!1,hideMode:"offsets",allow_create:!0,allow_edit:!0,allow_delete:!0,colModel:this.columnModel,selModel:new Ext.grid.RowSelectionModel({singleSelect:!1,listeners:{selectionchange:{fn:this.updateActionGroup,buffer:50,scope:this}}}),tbar:new Ext.Toolbar({defaultType:"syno_button",items:this.getActionGroup().getArray().concat("->",new SYNO.ux.TextFilter({queryAction:"list",enumAction:"list",queryParam:"pattern",emptyText:SYNO.Finder.Utils._T("common","search"),store:this.store,pageSize:this.PAGE_SIZE}))}),bbar:new SYNO.ux.PagingToolbar({store:this.store,pageSize:this.PAGE_SIZE,displayButtons:!0,displayInfo:!0}),listeners:{rowdblclick:function(t,e){"invalid_path"==this.store.data.itemAt(e).data.status.desc||this.store.data.itemAt(e).data.privileged||this.openIndexFolderEditDialog("edit")},beforeshow:function(){this.store.load()},rowcontextmenu:this.onRowContextMenu,containercontextmenu:this.onContainerContextMenu,scope:this}},t);this.callParent([e])},getContextMenuItem:function(){var t=[],e=["edit","delete","refresh","reindex"];return Ext.each(e,function(e){t.push(this.actionGroup.get(e))},this),t},onRowContextMenu:function(t,e,i){var n=new SYNO.ux.Menu({autoDestroy:!0,items:this.getContextMenuItem()}),r=this.getSelectionModel();r.selectRow(e,r.isSelected(e)),n.showAt(i.getXY()),i.preventDefault()},onContainerContextMenu:function(t,e){var i=new SYNO.ux.Menu({items:this.getContextMenuItem()});this.getSelectionModel().hasSelection()&&i.showAt(e.getXY()),e.preventDefault()},getActionGroup:function(){if(this.actionGroup)return this.actionGroup;var t=new Ext.Action({text:_T("common","create"),itemId:"create",scope:this,handler:function(t,e){this.openIndexFolderEditDialog("add")}}),e=new Ext.Action({text:_T("common","alt_edit"),itemId:"edit",disabled:!0,scope:this,handler:function(t,e){this.openIndexFolderEditDialog("edit")}}),i=new Ext.Action({text:_T("common","delete"),itemId:"delete",disabled:!0,scope:this,handler:function(t,e){this.owner.folderListDialog.getMsgBox().confirmDelete(SYNO.Finder.Utils._T("common","title_indexed_folder"),_T("common","remove_cfrmrmv"),function(t,e){if("yes"!==t)return!1;var i,n,r=[],s=this.getSelectionModel().getSelections();for(i=0,n=s.length;i<n;++i)r.push(s[i].get("path"));this.deleteIndexFolder(r)},this)}}),n=new Ext.Action({text:_T("common","refresh"),itemId:"refresh",scope:this,handler:this.refreshHandler}),r=new Ext.Action({text:SYNO.Finder.Utils._T("common","reindex"),itemId:"reindex",disabled:!0,scope:this,handler:this.reindexHandler});return this.actionGroup=new SYNO.SDS.Utils.ActionGroup([t,e,i,n,r]),this.actionGroup},createStore:function(t){return new SYNO.API.JsonStore({autoDestroy:!0,appWindow:this.appWin,api:"SYNO.Finder.FileIndexing.Folder",method:"list",version:1,root:"folder",idProperty:"path",remoteSort:!0,fields:["path",{name:"name",sortType:"asNaturalUCString"},"document","audio","video","photo","privileged","plugin","owner",{name:"status",mapping:"additional.status"}],paramNames:{dir:"direction"},baseParams:{direction:"asc",sort_by:"name",offset:0,limit:this.PAGE_SIZE,group:t.group,additional:["status"]},listeners:{beforeload:this.onBeforeLoad,load:this.onLoad,exception:this.onStoreException,scope:this}})},onLoad:function(t,e){this.findWindow().clearStatusBusy(),this.updateActionGroup()},onBeforeLoad:function(t,e){this.findWindow().setStatusBusy()},onStoreException:function(t,e,i,n,r,s){this.findWindow().clearStatusBusy(),this.findWindow().setStatusError({text:SYNO.API.getErrorString(r)})},createColumnModel:function(){var t=[{id:"name",header:_T("common","name"),tooltip:_T("common","name"),dataIndex:"name",sortable:!0,width:100,renderer:this.qtipRenderer,align:"left"},{id:"path",header:_T("common","folder"),tooltip:_T("common","folder"),dataIndex:"path",sortable:!0,width:50,renderer:this.qtipRenderer,align:"left"},{id:"scope",header:SYNO.Finder.Utils._T("common","indexed_scope"),tooltip:SYNO.Finder.Utils._T("common","indexed_scope"),width:180,align:"left",renderer:this.indexTypeRenderer},{id:"group",dataIndex:"group",hidden:!0,groupRenderer:function(t,e,i){return i.data.group?Ext.util.Format.htmlEncode(SYNO.Finder.Utils.getString(i.data.group)):SYNO.Finder.Utils._T("common","user_defined")}}];return t.push({id:"status",header:SYNO.Finder.Utils._T("common","indexing_status"),tooltip:SYNO.Finder.Utils._T("common","indexing_status"),dataIndex:"status",width:60,renderer:this.indexStatusRenderer}),new Ext.grid.ColumnModel({defaults:{scope:this,align:"center"},columns:t})},getColumnById:function(t){return this.getColumnModel().getColumnById(t)},qtipRenderer:function(t,e,i,n,r,s){return String.format('<span ext:qtip="{0}">{1}</span>',SYNO.Finder.Utils.doubleHtmlEncode(t),Ext.util.Format.htmlEncode(t))},indexTypeRenderer:function(t,e,i,n,r,s){var a=i.get("photo")||i.get("audio")||i.get("video")||i.get("document"),o="";return o+=i.get("photo")?", "+SYNO.Finder.Utils._T("common","type_photo"):"",o+=i.get("audio")?", "+SYNO.Finder.Utils._T("common","type_music"):"",o+=i.get("video")?", "+SYNO.Finder.Utils._T("common","type_video"):"",o+=i.get("document")?", "+SYNO.Finder.Utils._T("common","type_document"):"",String.format('<span ext:qtip="{0}">{0}</span>',a?String.format(SYNO.Finder.Utils._T("common","scope_filename_content"),o.substr(2)):SYNO.Finder.Utils._T("common","scope_filename"))},indexStatusRenderer:function(t,e,i,n,r,s){var a=SYNO.Finder.Utils._T("common","status_"+t.text);switch(t.text){case SYNO.Finder.Preference.FileIndex.Utils.StatusChecker.FINISHED:case SYNO.Finder.Preference.FileIndex.Utils.StatusChecker.PROCESSING:case SYNO.Finder.Preference.FileIndex.Utils.StatusChecker.PAUSED:case SYNO.Finder.Preference.FileIndex.Utils.StatusChecker.CHECKING:return String.format('<span ext:qtip="{0}">{1}</span>',Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(a)),Ext.util.Format.htmlEncode(a));case SYNO.Finder.Preference.FileIndex.Utils.StatusChecker.NEED_REINDEX:return String.format('<span ext:qtip="{0}" class="red-status">{1}</span>',Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(a)),Ext.util.Format.htmlEncode(a));case SYNO.Finder.Preference.FileIndex.Utils.StatusChecker.ERROR:return String.format('<span ext:qtip="{0}" class="red-status">{1}</span>',Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(SYNO.Finder.Utils._T("error",t.desc))),Ext.util.Format.htmlEncode(a))}},pluginRenderer:function(t,e,i,n,r,s){var a=e.id,o=!1;return Ext.each(t,function(t){if(t.name===a)return o=!0===t.value.enable,!1},this),this.indexTypeRenderer(o,e,i,n,r,s)},getPrivilegedPaths:function(){var t=[];return this.store.each(function(e){e.data.privileged&&t.push(e.data.path)}),t},updateActionGroup:function(){var t=!1,e=!1,i=!1,n=this.getActionGroup(),r=this.getSelectionModel().getCount();Ext.each(this.getSelectionModel().getSelections(),function(n){"invalid_path"===n.data.status.desc?t=!0:e=!0,"checking"===n.data.status.text&&(i=!0)}),n.disableAll(),i||(1===r&&n.enable("edit"),0<r&&(n.enable("delete"),n.enable("reindex")),!0===t&&(n.disable("reindex"),n.disable("edit")),this.allow_edit||n.disable("edit"),this.allow_delete||!0===e&&n.disable("delete")),n.enable("refresh"),n.enable("create"),this.allow_create||n.disable("create")},openIndexFolderEditDialog:function(t){var e=new SYNO.Finder.Preference.FileIndex.FolderEditDialog({minHeight:240,height:400,owner:this.owner.folderListDialog,store:this.store,fileIndexPlugins:this.fileIndexPlugins,rule_group:this.group,parent:this,mode:t});this.mon(e,"close",function(){this.store.load()},this),e.open()},reindexHandler:function(){var t=this,e=t.getSelectionModel(),i=e.getSelections(),n=[];0!==i.length&&(Ext.each(i,function(t){n.push(t.get("path"))},this),this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Folder",method:"reindex",params:{path:n},version:1,scope:this,callback:function(t,e,i){t?this.store.load():this.owner.folderListDialog.setStatusError({text:SYNO.API.getErrorString(e)})}}))},refreshHandler:function(t,e){this.store.load()},deleteIndexFolder:function(t){Ext.isArray(t)||(t=[t]),this.owner.folderListDialog.setStatusBusy({text:_T("common","saving")}),this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Folder",params:{path:t},method:"delete",version:1,callback:function(t,e,i){this.owner.folderListDialog.clearStatusBusy(),t?(this.store.load(),this.owner.folderListDialog.setStatusOK()):this.owner.folderListDialog.setStatusError({text:SYNO.API.getErrorString(e)})},scope:this})}}),Ext.define("SYNO.Finder.Preference.FileIndex.SummaryPanel",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(t){var e=this,i=Ext.apply({itemId:"fileIndex",title:_T("fileindex","fileindex_title"),items:e.getFileIndexingCfg(),listeners:{activate:e.activate,deactivate:e.deactivate}},t);e.polling_id=null,e.callParent([i]),e.nameListField=Ext.getCmp(e.nameList),e.indexStatusField=Ext.getCmp(e.indexStatus)},getFileIndexingCfg:function(){return[{xtype:"syno_displayfield",htmlEncode:!1,value:String.format(SYNO.Finder.Utils._T("common","fileindex_folder_list_desc"),"<b>"+SYNO.Finder.Utils._T("common","indexed_folder_list")+"</b>")},{xtype:"syno_displayfield",htmlEncode:!1,value:String.format(SYNO.Finder.Utils._T("common","check_index_database_desc"),"<b>"+SYNO.Finder.Utils._T("common","check_index_database")+"</b>")},{xtype:"syno_displayfield",indent:0,htmlEncode:!1,value:'<span class="syno-ux-note">'+_T("common","note")+_T("common","colon")+" </span>"+SYNO.Finder.Utils._T("common","check_index_database_note"),listeners:{render:function(t){Ext.each(t.el.query("a.link-font"),function(t){Ext.get(t).on("click",function(t){t.preventDefault(),SYNO.SDS.AppLaunch("SYNO.SDS.AdminCenter.Application",{fn:"SYNO.SDS.AdminCenter.FileService.Main",tab:"win"})})})},scope:this,single:!0,buffer:80}},{xtype:"syno_displayfield",height:12},{xtype:"syno_displayfield",htmlEncode:!1,value:SYNO.Finder.Utils._T("common","calculating"),id:this.nameList=Ext.id(),fieldLabel:SYNO.Finder.Utils._T("common","title_indexed_folder")},{xtype:"syno_displayfield",htmlEncode:!1,value:SYNO.Finder.Utils._T("common","calculating"),id:this.indexStatus=Ext.id(),fieldLabel:SYNO.Finder.Utils._T("common","indexing_status")},{xtype:"syno_displayfield",htmlEncode:!1,id:this.pauseNote=Ext.id(),hidden:!0,value:'<span class="syno-ux-note">'+_T("common","note")+_T("common","colon")+"</span>"+SYNO.Finder.Utils._T("common","fileindex_pause_note")},{xtype:"syno_displayfield",style:"height: 8px; padding: 0; margin-bottom: -8px",value:""},{xtype:"syno_button",text:SYNO.Finder.Utils._T("common","indexed_folder_list"),itemId:"indexing_folder_btn",name:"indexing_folder_btn",scope:this,handler:this.onClickIndexFolderBtn},{xtype:"syno_button",text:SYNO.Finder.Utils._T("common","check_index_database"),itemId:"database_check_start_btn",name:"database_check_start_btn",scope:this,handler:this.onClickDatabaseCheckStart},{xtype:"syno_button",text:SYNO.Finder.Utils._T("common","cancel_checking"),itemId:"database_check_cancel_btn",name:"database_check_cancel_btn",hidden:!0,scope:this,handler:this.onClickDatabaseCheckCancel}]},onClickIndexFolderBtn:function(t){var e=this,i=function(i){var n=[new SYNO.Finder.Preference.FileIndex.FolderList.Panel({owner:e,group:"",title:SYNO.Finder.Utils._T("common","user_defined")})],r=0;Ext.each(i,function(i,s){i===t&&(r=s+1),n.push(new SYNO.Finder.Preference.FileIndex.FolderList.Panel({owner:e,group:i,allow_create:!1,allow_edit:!0,allow_delete:!1,title:SYNO.Finder.Utils.getString(i)}))}),e.folderListDialog=new SYNO.SDS.ModalWindow({owner:e.findWindow(),layout:"fit",minHeight:240,height:450,width:760,title:SYNO.Finder.Utils._T("common","title_indexed_folder"),items:new SYNO.Finder.Preference.FileIndex.FolderList.TabPanel({items:n,activeTab:r}),buttons:[{text:_T("common","alt_close"),handler:function(){e.folderListDialog.close()}}],listeners:{show:function(){e.stopPolling()},close:function(){e.startPolling()}}}),e.folderListDialog.open()};this.findWindow().setStatusBusy(),this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Folder",appWindow:!1,method:"list_group",version:1,scope:this,callback:function(t,e){t?(this.findWindow().clearStatusBusy(),i(e)):this.findWindow().setStatusError({text:SYNO.API.getErrorString(e)})}})},onClickDatabaseCheckStart:function(){this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Folder",appWindow:!1,method:"check",version:1,scope:this,callback:function(t,e){t?this.startPolling():this.findWindow().setStatusError({text:SYNO.API.getErrorString(e),clear:!1})}}),this.onDatabaseCheckPerforming()},onDatabaseCheckPerforming:function(){this.getComponent("database_check_start_btn").hide(),this.getComponent("database_check_cancel_btn").show()},onClickDatabaseCheckCancel:function(){this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Folder",appWindow:!1,method:"stop_check",version:1,scope:this,callback:function(t,e){t?this.startPolling():this.findWindow().setStatusError({text:SYNO.API.getErrorString(e),clear:!1})}}),this.onDatabaseCheckNotPerforming()},onDatabaseCheckNotPerforming:function(){this.getComponent("database_check_cancel_btn").hide(),this.getComponent("database_check_start_btn").show()},setData:function(t){var e,i=[],n=!1,r=SYNO.Finder.Preference.FileIndex.Utils.StatusChecker;Ext.each(t.items,function(t){var e=t.group?SYNO.Finder.Utils.getString(t.name):t.name;r.IsChecking(t.text)&&(n=!0),r.IsError(t.text)||r.IsNeedReindex(t.text)?i.push(String.format('<span ext:qtip="{0}" class="red-status"><a data-group="{1}">{2}</a></span>',Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(SYNO.Finder.Utils._T("common","status_"+t.text))),t.group?t.name:"",Ext.util.Format.htmlEncode(e))):i.push(Ext.util.Format.htmlEncode(e))}),0===t.items.length?(this.nameListField.setValue(this.wrapStatusMsg(SYNO.Finder.Utils._T("common","status_no_shared_folder"))),e=this.wrapStatusMsg("-")):(this.nameListField.setValue(i.join(", ")),e=this.wrapStatusMsg(r.GetString(t.status),r.IsError(t.status)||r.IsNeedReindex(t.status)),this.nameListField.el.select("a").on("click",function(t,e,i){this.onClickIndexFolderBtn(e.getAttribute("data-group"))},this)),this.indexStatusField.getValue()!==e&&this.indexStatusField.setValue(e),this.setPauseNote(r.IsPaused(t.status)),n?this.onDatabaseCheckPerforming():this.onDatabaseCheckNotPerforming(),this.doLayout()},wrapStatusMsg:function(t,e){return e?'<span class="red-status">'+t+"</span>":'<span class="blue-status">'+t+"</span>"},setPauseNote:function(t){t?Ext.getCmp(this.pauseNote).show():Ext.getCmp(this.pauseNote).hide()},polling_callback:function(t,e,i,n){t?this.setData(e):this.findWindow().setStatusError({text:SYNO.API.getErrorString(e),clear:!1})},stopPolling:function(){var t=this;null!==t.polling_id&&(t.pollUnreg(this.polling_id),t.polling_id=null)},startPolling:function(){var t=this;t.stopPolling(),t.polling_id=this.pollReg({interval:5,immediate:!0,scope:this,webapi:{api:"SYNO.Finder.FileIndexing.Folder",method:"summary",params:{direction:"asc",sort_by:"path",offset:0,additional:["status"]},version:1},status_callback:t.polling_callback})},activate:function(){this.startPolling()},deactivate:function(){this.stopPolling()},destroy:function(){var t=this;t.callParent(arguments),t.stopPolling()}}),Ext.define("SYNO.Finder.Preference.FileIndex.Utils.StatusChecker",{statics:{FINISHED:"finished",PROCESSING:"processing",PAUSED:"paused",CHECKING:"checking",NEED_REINDEX:"need_reindex",ERROR:"error",GetString:function(t){switch(t.toLowerCase()){case this.ERROR:return SYNO.Finder.Utils._T("common","status_error");case this.NEED_REINDEX:return SYNO.Finder.Utils._T("common","status_need_reindex");case this.PAUSED:return SYNO.Finder.Utils._T("common","status_paused");case this.PROCESSING:return SYNO.Finder.Utils._T("common","status_processing");case this.CHECKING:return SYNO.Finder.Utils._T("common","status_checking");case this.FINISHED:default:return SYNO.Finder.Utils._T("common","status_finished")}},IsError:function(t){return this.ERROR===t.toLowerCase()},IsNeedReindex:function(t){return this.NEED_REINDEX===t.toLowerCase()},IsChecking:function(t){return this.CHECKING===t.toLowerCase()},IsFinished:function(t){return this.FINISHED===t.toLowerCase()},IsPaused:function(t){return this.PAUSED===t.toLowerCase()},IsProcessing:function(t){return this.PROCESSING===t.toLowerCase()}}}),Ext.define("SYNO.Finder.Preference.General.SearchHistoryDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(t){this.panel=this.createPanel();var e={width:600,height:440,resizable:!1,cls:"syno-finder-history-dialog",title:SYNO.Finder.Utils._T("common","search_history"),layout:"fit",items:this.panel,buttons:[{text:SYNO.Finder.Utils._T("common","close"),scope:this,handler:this.onCloseClick}]};this.callParent([Ext.apply(e,t)])},createPanel:function(){this.columnModel=this.createColumnModel(),this.store=this.createStore();var t={header:!1,cm:this.columnModel,ds:this.store,loadMask:!0,enableHdMenu:!1,tbar:{items:[new SYNO.ux.Button({itemId:"delete",text:_T("common","delete"),handler:this.onDeleteHistory,scope:this}),"->",new SYNO.ux.TextFilter({itemId:"search",iconStyle:"filter",queryParam:"substr",emptyText:_T("common","filter_label_text"),store:this.store,pageSize:50})]},view:new SYNO.ux.FleXcroll.grid.BufferView({scrollDelay:!1,forceFit:!0}),bbar:new SYNO.ux.PagingToolbar({store:this.store,displayInfo:!0,pageSize:50,showRefreshBtn:!0,doRefresh:function(){this.store.rejectChanges(),SYNO.ux.PagingToolbar.prototype.doRefresh.call(this)}}),plugins:[this.enableColumn]};return new SYNO.ux.GridPanel(t)},createEnableColumn:function(){return new SYNO.ux.EnableColumn({header:"",dataIndex:"enabled",width:40,menuDisabled:!0,enableFastSelectAll:!0})},createColumnModel:function(){return this.enableColumn=this.createEnableColumn(),new Ext.grid.ColumnModel([this.enableColumn,{header:SYNO.Finder.Utils._T("common","keyword"),dataIndex:"keyword",sortable:!0,width:270},{header:SYNO.Finder.Utils._T("common","ctime"),dataIndex:"create_time",width:250,sortable:!0,renderer:this.timeRenderer}])},timeRenderer:function(t,e,i,n,r,s){return new Date(1e3*t).toLocaleString()},createStore:function(){return new SYNO.API.JsonStore({autoLoad:!0,autoDestroy:!0,appWindow:!1,api:"SYNO.Finder.Elastic.SearchHistory",method:"get",version:1,root:"historys",remoteSort:!0,fields:["id","keyword","create_time",{name:"enabled",mapping:function(){return!1}}],baseParams:{offset:0,limit:50,sort_by:"create_time",sort_direction:"asc"},paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},listeners:{scope:this,beforeload:this.onBeforeStoreLoad,load:this.onStoreLoad}})},onBeforeStoreLoad:function(){this.findWindow().setStatusBusy()},onStoreLoad:function(t,e,i){this.findWindow().clearStatusBusy()},onDeleteHistory:function(){var t=[],e=this.store.getModifiedRecords();Ext.isEmpty(e)||(Ext.iterate(e,function(e){t.push(e.get("id"))}),this.sendWebAPI({api:"SYNO.Finder.Elastic.SearchHistory",method:"delete",version:1,scope:this,params:{id:t},callback:function(t,e){t?(this.store.load(),this.store.commitChanges()):this.setStatusError({text:SYNO.API.getErrorString(e)})}}))},onCloseClick:function(){var t=this.store.getModifiedRecords();if(Ext.isEmpty(t))return void this.close();this.getMsgBox().confirm("",SYNO.Finder.Utils._T("common","confirm_lostchange"),function(t){"yes"===t&&this.close()},this)}}),Ext.define("SYNO.Finder.Preference.General.GeneralPanel",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(t){var e=SYNO.Finder.Mgr.statusMgr.getData("preference",{}),i={title:SYNO.Finder.Utils._T("common","pref_general"),labelWidth:320,items:[{xtype:"syno_checkbox",name:"enable_history",boxLabel:SYNO.Finder.Utils._T("common","pref_enable_history"),checked:e.enable_history},{xtype:"syno_numberfield",name:"max_history_num",fieldLabel:SYNO.Finder.Utils._T("common","pref_max_hist_num"),disabled:!0,value:e.max_history_num,indent:1,width:80,minValue:0,maxValue:200},{xtype:"syno_button",id:"view_search_history",name:"view_search_history",text:_JSLIBSTR("uicommon","browse"),indent:1,handler:this.onViewSearchHistory,scope:this},{xtype:"syno_displayfield"},{xtype:"syno_numberfield",name:"max_fragment_num",fieldLabel:SYNO.Finder.Utils._T("common","pref_max_fragment_num"),disabled:!0,value:e.max_fragment_num,width:80,minValue:1,maxValue:250}],listeners:{afterrender:this.onAfterRender}};this.callParent([Ext.apply(i,t)])},onAfterRender:function(){new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_history",["max_history_num","view_search_history"]),this.find("name","max_fragment_num")[0].enable()},isDirty:function(){return this.getForm().isDirty()},isValid:function(){return this.getForm().isValid()},onViewSearchHistory:function(){new SYNO.Finder.Preference.General.SearchHistoryDialog({owner:this.ownerCt.ownerCt}).show()},getPreferenceJSON:function(){return{enable_history:this.find("name","enable_history")[0].getValue(),max_history_num:this.find("name","max_history_num")[0].getValue(),max_fragment_num:this.find("name","max_fragment_num")[0].getValue()}}}),Ext.define("SYNO.Finder.Preference.Settings.SettingsPanel",{extend:"SYNO.SDS.Utils.FormPanel",constructor:function(t){var e=SYNO.Finder.Mgr.statusMgr.getData("settings",{}),i=String.format('<span class="syno-ux-note">{0}:</span> {1}',SYNO.Finder.Utils._T("common","note"),SYNO.Finder.Utils._T("common","keyword_filter_desc")),n={title:SYNO.Finder.Utils._T("common","pref_settings"),labelWidth:320,items:[{xtype:"syno_checkbox",name:"enable_keyword_filter",itemId:"enable_keyword_filter",boxLabel:SYNO.Finder.Utils._T("common","enable_keyword_filter"),checked:e.enable_keyword_filter,listeners:{check:this.onNeedReindexCheck,scope:this}},{xtype:"syno_displayfield",value:i,htmlEncode:!1,indent:1},{xtype:"syno_checkbox",name:"enable_cppjieba_dict",itemId:"enable_cppjieba_dict",boxLabel:SYNO.Finder.Utils._T("common","pref_cppjieba_dict"),
checked:e.enable_cppjieba_dict,listeners:{check:this.onNeedReindexCheck,scope:this}},{xtype:"syno_fieldset",title:SYNO.Finder.Utils._T("common","performance"),collapsible:!0,items:[{xtype:"syno_checkbox",name:"enable_preload_indices",itemId:"enable_preload_indices",boxLabel:SYNO.Finder.Utils._T("common","enable_preload_indices"),checked:e.enable_preload_indices},{xtype:"syno_checkbox",name:"enable_vmtouch",itemId:"enable_vmtouch",boxLabel:SYNO.Finder.Utils._T("common","enable_vmtouch"),checked:e.enable_vmtouch,listeners:{check:this.onVMTouchCheck,scope:this}},{xtype:"syno_numberfield",name:"vmtouch_reserve_mem",itemId:"vmtouch_reserve_mem",indent:1,minValue:10,maxValue:90,width:80,fieldLabel:SYNO.Finder.Utils._T("common","vmtouch_reserve_mem"),disabled:!e.enable_vmtouch},{xtype:"syno_checkbox",name:"enable_mlock",itemId:"enable_mlock",indent:1,checked:e.enable_mlock,boxLabel:SYNO.Finder.Utils._T("common","enable_mlock"),disabled:!e.enable_vmtouch}]}],listeners:{afterrender:this.onAfterRender,activate:this.onActivate,scope:this}};this.callParent([Ext.apply(n,t)]),this.find("name","vmtouch_reserve_mem")[0].setValue(e.vmtouch_reserve_mem)},onAfterRender:function(){this.checkDisableNeedReindexCheckbox()},onActivate:function(){this.checkDisableNeedReindexCheckbox()},onNeedReindexCheck:function(t,e){var i=SYNO.Finder.Mgr.statusMgr.getData("settings",{})[t.getItemId()];e!==i&&this.findWindow().getMsgBox().confirm("Universal Search",SYNO.Finder.Utils._T("common","pref_reindex_warning"),function(e,n){"yes"!==e&&(t.checked=i,t.updateCheckAttr(),t.setCheckedDisabledClass())})},onVMTouchCheck:function(t,e){this.find("name","enable_mlock")[0].setDisabled(!e),this.find("name","vmtouch_reserve_mem")[0].setDisabled(!e)},checkDisableNeedReindexCheckbox:function(){this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Status",method:"get",version:1,scope:this,callback:function(t,e){var i=SYNO.Finder.Preference.FileIndex.Utils.StatusChecker,n=!t||!i.IsFinished(e.status.index)||!i.IsFinished(e.status.term);this.getComponent("enable_cppjieba_dict").setDisabled(n),this.getComponent("enable_keyword_filter").setDisabled(n)}})},isDirty:function(){return this.getForm().isDirty()},isValid:function(){return this.getForm().isValid()},getSettingsJSON:function(){return{enable_keyword_filter:this.find("name","enable_keyword_filter")[0].getValue(),enable_preload_indices:this.find("name","enable_preload_indices")[0].getValue(),enable_cppjieba_dict:this.find("name","enable_cppjieba_dict")[0].getValue(),enable_vmtouch:this.find("name","enable_vmtouch")[0].getValue(),enable_mlock:this.find("name","enable_mlock")[0].getValue(),vmtouch_reserve_mem:this.find("name","vmtouch_reserve_mem")[0].getValue()}}}),Ext.define("SYNO.Finder.Preference.MainDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(t){this.tabPanel=new SYNO.Finder.Preference.TabPanel(t);var e={cls:"syno-finder",width:625,height:480,resizable:!1,title:SYNO.Finder.Utils._T("dsmsetting","uioptions"),layout:"fit",items:this.tabPanel,buttons:[{text:SYNO.Finder.Utils._T("common","ok"),btnStyle:"blue",scope:this,handler:this.onSaveClick},{text:SYNO.Finder.Utils._T("common","cancel"),scope:this,handler:this.onCancelClick}],listeners:{afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},onAfterRender:function(){this.tabPanel.getComponent(this.launchAction)&&(this.tabPanel.layout.setActiveItem(this.launchAction),"fileindex"==this.launchAction&&this.tabPanel.layout.activeItem.onClickIndexFolderBtn(this.launchData&&this.launchData.tab))},onSaveClick:function(){if(!this.tabPanel.isValid())return void this.getMsgBox().alert("",SYNO.Finder.Utils._T("common","forminvalid"));this.savePreferences()},onCancelClick:function(){if(!this.tabPanel.isDirty())return void this.close();this.getMsgBox().confirm("",SYNO.Finder.Utils._T("common","confirm_lostchange"),function(t){"yes"===t&&this.close()},this)},savePreferences:function(){if(!this.tabPanel.isDirty())return void this.close();var t,e=null,i=null,n=null,r=[];this.tabPanel.generalPanel.isDirty()&&(e=this.tabPanel.getPreferenceJSON(),i=SYNO.Finder.Mgr.statusMgr.getData("preference",{}),r.push({api:"SYNO.Finder.Preference",version:1,method:"set",params:{data:e}})),this.tabPanel.settingsPanel.isDirty()&&(n=this.tabPanel.getSettingsJSON(),t=SYNO.Finder.Mgr.statusMgr.getData("settings",{}),r.push({api:"SYNO.Finder.Settings",version:1,method:"set",params:{data:n}})),this.sendWebAPI({compound:{params:r},scope:this,callback:function(r,s){r&&(e&&(SYNO.Finder.Mgr.statusMgr.applyData({preference:e}),i.max_fragment_num!==e.max_fragment_num&&SYNO.Finder.Mgr.statusMgr.fireEvent("prefMaxFragmentNumChanged")),n&&(SYNO.Finder.Mgr.statusMgr.applyData({settings:n}),t.enable_cppjieba_dict===n.enable_cppjieba_dict&&t.enable_keyword_filter===n.enable_keyword_filter||this.reindexAll())),this.close()}})},reindexAll:function(){this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Folder",method:"list",version:1,params:{direction:"asc",sort_by:"path",offset:0,additional:["status"]},scope:this,callback:function(t,e){t&&this.sendReIndexAPI(e)}})},sendReIndexAPI:function(t){var e=[];Ext.each(t.folder,function(t){"error"!==t.additional.status.text&&e.push(t.path)}),this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Folder",method:"reindex",params:{path:e},version:1,scope:this})}}),Ext.define("SYNO.Finder.Preference.TabPanel",{extend:"SYNO.ux.TabPanel",constructor:function(t){this.generalPanel=new SYNO.Finder.Preference.General.GeneralPanel({itemId:"general"}),this.fileIndexPanel=new SYNO.Finder.Preference.FileIndex.SummaryPanel({itemId:"fileindex"}),this.settingsPanel=new SYNO.Finder.Preference.Settings.SettingsPanel({itemId:"settings"});var e={items:[this.generalPanel],activeTab:0};_S("is_admin")&&(e.items.unshift(this.fileIndexPanel),e.items.push(this.settingsPanel)),this.callParent([Ext.apply(e,t)])},isDirty:function(){return this.generalPanel.isDirty()||this.settingsPanel.isDirty()},isValid:function(){return this.generalPanel.isValid()&&this.settingsPanel.isValid()},getPreferenceJSON:function(){return this.generalPanel.getPreferenceJSON()},getSettingsJSON:function(){return this.settingsPanel.getSettingsJSON()}}),Ext.define("SYNO.Finder.Utils",{statics:{_T:function(t,e){try{return _TT("SYNO.Finder.Application",t,e)||_T(t,e)||t+":"+e}catch(i){return _T(t,e)||t+":"+e}},DateTimeFormatter:function(t,e){var i=_S("version")>=24885?SYNO.SDS.DateTimeFormatter:function(t,e){if(!t||"[object Date]"!==Object.prototype.toString.call(t))return"";var i,n=e&&e.type;return i="date"===n?"m/d/Y":"time"===n?"h:i a":"m/d/Y h:i a",t.format(i)};return e&&"datetime_accurate"===e.type?i(t,{type:"date"})+" "+t.format("h:i:s"):i(t,e)},getString:function(t){var e,i=t.split(":"),n={"SYNO.SDS.Drive.Application":{drive:{displayname:_TT("SYNO.Finder.Application","common","drive_displayname"),displayname_teamfolder:_TT("SYNO.Finder.Application","common","drive_displayname_teamfolder")}}};switch(i.length){case 2:e=0===_T(i[0],i[1]).length?_JSLIBSTR(i[0],i[1]):_T(i[0],i[1]);break;case 3:e=_TT(i[0],i[1],i[2])}if(e)return e;try{return n[i[0]][i[1]][i[2]]}catch(e){return t}},debug:function(){var t=window.console;return Ext.urlDecode(location.search.substr(1)).jsDebug?t.log.bind(window.console):Ext.emptyFn}(),error:function(){var t=window.console;return Ext.urlDecode(location.search.substr(1)).jsDebug?t.error.bind(window.console):Ext.emptyFn}(),alert:function(t,e){var i=t.getMsgBox().alert("Universal Search",e),n=function(t,e){try{var i=JSON.parse(e.getAttribute("sus-applaunch-cfg"));SYNO.SDS.AppLaunch(i.className,i.param,i.newInstance)}catch(t){SYNO.Finder.Utils.error(t)}};Ext.each(i.el.query(".sus-applaunch-btn"),function(t){Ext.get(t).on("click",n)})},getRandomString:function(){for(var t="",e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",i=0;i<16;i+=1)t+=e.charAt(Math.floor(Math.random()*e.length));return t},getWebAPIErrStr:function(t){if(!Ext.isObject(t))return _T("common","error_system");var e={className:"SYNO.SDS.HelpBrowser.Application",param:{anchor:"search-operator",topic:"SYNO.Finder.Application:universalsearch_search.html"},newInstance:!1};switch(t.code){case 1001:return String.format(this._T("error","invalid_search_query"),'<a class="sus-applaunch-btn" sus-applaunch-cfg='+Ext.util.Format.htmlEncode(JSON.stringify(e))+">","</a>");case 901:return this._T("common","error_duplicate_path");case 1003:return this._T("error","share_space_not_enough");default:return SYNO.API.getErrorString(t)}},doubleHtmlEncode:function(t){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(t))},ConstructQuery:function(t){return{bool:{should:[{match:{SYNOMDTextContent:t}},{term:{SYNOMDSearchFileName:t}}]}}},ConvertDateStringToSecTimeStamp:function(t){return t?(new Date(t).getTime()/1e3).toFixed(0):""},ConvertDateStringToTimeStamp:function(t){return t?new Date(t).getTime().toFixed(0):""},getFileIDFromRecord:function(t){return t.data.detailItemSubtitle+"/"+t.data.detailItemTitle},getFileIDFromData:function(t){return t.detailItemSubtitle+"/"+t.detailItemTitle},getThumbnailURL:function(t,e,i,n){if(i)return"";var r=t.split(".").pop().toLowerCase();if(-1!==SYNO.Finder.Utils.SupportDocumentViewerThumbnailExt.indexOf(r)&&SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.DocumentViewer.Application"))return Ext.urlAppend(SYNO.API.currentManager.getBaseURL("SYNO.DocumentViewer.Thumbnail","get",1),Ext.urlEncode({path:t}));if(-1!==SYNO.Finder.Utils.SupportThumnailExt.indexOf(r)){var s=this.EntryType(t);return SYNO.API.GetBaseURL({api:"audio"===s?"SYNO.Finder.File.Cover":"SYNO.Finder.File.Thumbnail",method:"get",version:1,params:{full_path:t,size:e||"small",animate:n||!1}})}return""},EntryType:function(t){var e=t.lastIndexOf(".");if(-1!==e){var i=t.substr(e+1).toLowerCase();for(var n in SYNO.Finder.Utils.EntryMap)if(SYNO.Finder.Utils.EntryMap.hasOwnProperty(n)&&0<=SYNO.Finder.Utils.EntryMap[n].indexOf(i))return String(n)}},EntryTypeIsInBlackList:function(t,e){var i=e.lastIndexOf(".");if(-1===i)return!1;var n=e.substr(i+1).toLowerCase();return!!(SYNO.Finder.Utils.PreviewCardIDBlackList.hasOwnProperty(t)&&0<=SYNO.Finder.Utils.PreviewCardIDBlackList[t].indexOf(n))},ConstructKeyword:function(t){return Ext.each([this.RemoveLeadingWildCard,this.RemoveColon],function(e){t=e(t)}),t},ConstructQueryString:function(t,e){var i=[];return t=this.RemoveLeadingWildCard(t),Ext.isEmpty(t)||i.push(String.format("+(SYNOMDWildcard:({0}) OR SYNOMDTextContent:({0}) OR SYNOMDSearchFileName:({0})^8.5)",t)),Ext.each(e,function(t){i.push(t.json.clause)}),{query:i.join(" AND ")}},ConstructSearchCriteriaList:function(t){var e=[];return Ext.each(t,function(t){e.push({field:t.json.fieldName,value:t.json.clause})}),e},RemoveLeadingWildCard:function(t){var e=[];return Ext.each(t.split(" "),function(t){(t=t.replace(/^\*+/,""))&&e.push(t)}),e.join(" ")},RemoveColon:function(t){return t.replace(":"," ")},PreviewCardIDBlackList:{document:["xlsx","xlsm","xlsb","xltm","xlam","xls","osheet","xla","xlb","xlc","xld","xlk","xll","xlm","xlt","xlv","xlw","numbers"],image:[],audio:[],video:[]},EntryMap:{document:["docx","wri","rtf","pptx","pps","ppsx","pdf","txt","doc","ppt","odt","ods","odp","odg","odc","odf","odb","odi","odm","ott","ots","otp","otg","otc","otf","oti","oth","potx","pptm","ppsm","potm","dotx","dot","pot","ppa","docm","dotm","eml","msgc","c","cc","cpp","cs","cxx","ada","coffee","cs","css","js","json","lisp","markdown","ocaml","pl","py","rb","sass","scala","r","tex","conf","csv","sub","srt","md","log","mobi","azw3","pdb","epub","chm","lit","xlsx","xlsm","xlsb","xltm","xlam","xls","xla","xlb","xlc","xld","xlk","xll","xlm","xlt","xlv","xlw","odoc","osheet","oslides","pages","numbers","key","prc","rar","7z","bz2","gz","zip","tgz","tbz","tar","slk","gnumeric","msg","7","abap","as","ada","s","ahk","bat","c","cpp","clj","edn","cbl","coffee","cfm","cs","css","d","dart","diff","ejs","erl","f","fth","forth","ftl","glsl","go","groovy","haml","handlebars","hs","hx","ht3","htm","html","htmls","ini","jack","jade","java","jsp","jsx","jl","latex","less","liquid","ls","lsl","lua","mk","m","mysql","nix","pascal","perl","php","rhtml","rbw","rs","scad","scm","ss","scss","sh","sjs","sql","styl","svg","tcl","textile","vb","v","vhdl","xml","xq","xqy","xquery","yml","yaml","$00","$01","$02","$04","$05","$o1","$ol","1","12da","1st","82t","92t","abl","ac","adiumhtmllog","adiumlog","adl","adt","adw","aiml","alx","aml","android","annot","ans","ansi","application","aprj","apx","aqt","arff","artask","asc","ascii","asl","asp","ass","assoc","atc","att","awa","awb","awd","awh","awp","axt","ba1","bad","bas","bbs","bbxt","bcr","bdp","bdr","bea","bel","bep","big","big5","bk","blm","bln","blw","bmtp","bna","bnx","bog","box","bpdx","brf","bsdl","bss","bt","bzw","cag","cas","cascii","cd2","charset","cho","chord","cif","cil","ckn","clg","cli","clix","cmd","cmtx","cof","coo","crash","crd","csassembly","csmanifest","ctd","ctf","ctl","ctx","dcd","dce","ddd","ddt","de","dectest","des","desc","dfe","dfm","dii","diskdefines","diz","dk","dkz","dmr","dne","dok","dp","dpv","dqy","drp","dsc","dsml","dtd","dwl","ecsv","edml","edt","efm","eia","emulecollection","en","enc","enf","eng","err","es","esw","etf","etx","euc","ext","extra","faq","fff","ffp","fin","first","flr","fmr","fnx","fon","fr","fra","frm","fsa","full","gbf","gdt","gen","ger","gnu","gpl","gs","gthr","gtx","guide","hdr","hhc","hhs","hlm","hlx","hp8","hsk","htx","hvc","hwl","hz","id31","id32","idc","idt","idx","iem","igv","igy","iif","ill","inc","inuse","ion","ipr","iqy","isr","it","ivp","ja","jad","jam","jeb","jis","jp1","jss","jtx","kahl","kar","kch","kix","klg","kor","la","label","las","lay","lin","linux","linx","lnc","lo_","lrc","lst","ltr","ltt","ltx","lue","luf","lwd","lxfml","lyr","lyt","man","manifest","map","mar","mathml","maxfr","mcw","mdl","mdle","mdown","mdtext","mdtxt","mdwn","me","mez","mf","mib","mit","mkd","mkdn","mno","mnu","modd","mpsub","mss","mtx","mtxt","mvg","mw","nbr","nclk","ncm","new","nfo","nlc","nmbd","nokogiri","not","notes","now","npdt","nt","nwctxt","ocr","oh","ojp","omn","oogl","oot","opc","openbsd","opml","ort","osi","p3x","panic","pbd","pc5","pcl","pd","pdu","pfs","pgw","pjs","pla","plf","plg","plist","plk","pln","pml","pmo","pod","prc","prn","pro","prr","ps","psb","psi2","pt3","pts","pvj","pvw","q&a","qdt","qud","rbdf","rdf","rea","readme","reg","rel","rep","resp","rest","rff","ris","rml","rqy","rst","rt","rtl","rtx","ru","rus","rzk","rzn","s19","s2k","sami","sbv","sct","sdnf","sen","seq","set","sfb","sgp","sha1","sha512","skcard","skv","sls","smali","smf","smi","sms","snw","soap","soundscript","spa","spec","spg","spn","spx","srx","ssa","ssf","st1","stf","stq","strings","syn","t","t2t","tab","tbd","tbl","tbx","tce","tcm","tdf","ted","text","textclipping","tfw","tgf","thml","thp","tlb","tle","tlx","tm","tml","tmprtf","tmx","tnef","tph","tpl","trn","trt","tsv","tt","ttbl","tte","ttpl","ttxt","tx8","tx?","txa","txd","txe","txh","u3i","uax","uhtml","uk","unauth","uni","unx","us","usa","user","usf","usg","utf8","utx","utxt","ver","vet","vfk","vhd","vis","vkp","vmg","vmsg","vna","vsmproj","vw","vw3","vxml","wer","wir","wkf","wn","wrd","wrl","wsc","wst","wtf","wtl","wtx","x20","x60","x70","x80","x90","xb0","xc0","xct","xd0","xdl","xdp","xfd","xff","xhtm","xlf","xsd","xsl","xslt","xsr","xwp","xy","xy3","xyp","xyw","xyz","zanebug","zed","zhp","zib","zw","zxe","_me"],image:["3fr","arw","bmp","cr2","crw","dcr","dng","erf","gif","ico","jpe","jpeg","jpg","k25","kdc","mef","mos","mrw","nef","orf","pef","png","psd","ptx","raf","raw","rw2","sr2","srf","tif","tiff","ufo","x3f"],audio:["aac","ac3","aif","aiff","ape","cue","dff","dsf","flac","m3u","m4a","m4b","m4p","mp1","mp2","mp3","mpa","ogg","pcm","pls","ra","ram","wav","wma","wpl"],video:["3g2","3gp","asf","avi","dat","divx","dvr-ms","f4v","flv","ifo","iso","m2t","m2ts","m4v","mkv","mov","mp4","mpeg","mpg","mts","qt","rm","rmvb","swf","tp","trp","ts","vdr","vob","wmv","xvid"]},ExtensionMap:{pptx:"ppt",ppt:"ppt",docx:"doc",doc:"doc",docm:"doc",dot:"doc",dotm:"doc",odt:"doc",xps:"doc",xlsx:"xls",xls:"xls",xlsm:"xls",xlt:"xls",xltm:"xls",xltx:"xls",xlw:"xls",mobi:"txt",azw3:"txt",prc:"txt",pdb:"txt",hpp:"txt",h:"txt",cgi:"txt",php4:"txt",php5:"txt",jsp:"txt",jspx:"txt",txt:"txt",js:"js",css:"js",actproj:"js",ad:"js",aakp:"js",applescript:"js",as:"js",asax:"js",asc:"js",ascx:"js",asm:"js",asmx:"js",asp:"js",aspx:"js",asr:"js",c:"js",cc:"js",php:"js",ksx:"js",mhtml:"js",cpp:"js",cs:"js",cxx:"js",htm:"htm",html:"htm",xml:"htm",xhtm:"htm",xhtml:"htm",rhtml:"htm",shtml:"htm",html5:"htm",avi:"video",rmvb:"video",mpg:"video",mpeg:"video",m4v:"video",mp4:"video",mkv:"video",flv:"video",wmv:"video",yuv:"video",vob:"video",asf:"video","3gp":"video",ani:"image",bmp:"image",cal:"image",fax:"image",img:"image",jpg:"image",jpe:"image",jpeg:"image",gif:"image",mac:"image",pbm:"image",pcd:"image",pcx:"image",pct:"image",pgm:"image",png:"image",ppm:"image",ras:"image",tga:"image",tiff:"image",wmf:"image",aac:"audio",ac3:"audio",aif:"audio",aiff:"audio",ape:"audio",cue:"audio",dff:"audio",dsf:"audio",flac:"audio",m3u:"audio",m4a:"audio",m4b:"audio",m4p:"audio",mp1:"audio",mp2:"audio",mp3:"audio",mpa:"audio",ogg:"audio",pcm:"audio",pls:"audio",ra:"audio",ram:"audio",wav:"audio",wma:"audio",wpl:"audio",pdf:"pdf",psd:"psd",exe:"exe",ai:"ai",iso:"iso",zip:"zip",rar:"zip","7z":"zip",indd:"idn",indt:"idn",swf:"swf",fla:"fla",acc:"acc",bkpi:"bkpi",osheet:"synosheet",oslides:"synoslide",odoc:"synodoc"},SupportThumnailExt:["jpg","jpeg","jpe","bmp","png","tif","tiff","gif","arw","srf","sr2","dcr","k25","kdc","cr2","crw","nef","mrw","ptx","pef","raf","3fr","erf","mef","mos","orf","rw2","dng","x3f","raw","3gp","3g2","asf","dat","divx","dvr-ms","m2t","m2ts","m4v","mkv","mp4","mts","mov","qt","tp","trp","ts","vob","wmv","xvid","ac3","amr","rm","rmvb","ifo","mpeg","mpg","mpe","m1v","m2v","mpeg1","mpeg2","mpeg4","ogv","webm","flv","f4v","avi","swf","vdr","iso","aac","flac","m4a","m4b","aif","ogg","pcm","wav","cda","mid","mp2","mka","mpc","ape","ra","ac3","dts","wma","mp3","mp1","mp2","mpa","ram","m4p","aiff","dsf","dff"],SupportDocumentViewerThumbnailExt:["pdf","odm","odt","ott","sxw","stw","fodt","docx","docm","dotx","dotm","doc","dot","wps","rtf","odc","ods","ots","sxc","stc","fods","xlsx","xlsm","xltm","xltx","xlsb","xls","xlc","xlm","xlw","xlk","xlt","odp","otp","sti","sxd","fodp","pptx","pptm","ppsx","potm","potx","ppt","pps","pot","odg","otg","sxd","std","cdr","cmx","vdx","vsd","vsdm","vsdx","epub","mobi"],NormalizeExtension:function(t){var e=t.toLowerCase();return""===e?"xxx":e=SYNO.Finder.Utils.ExtensionMap.hasOwnProperty(e)?SYNO.Finder.Utils.ExtensionMap[e]:"xxx"},ParseDurationSecond:function(t){var e=Math.floor(t/3600),i=Math.floor(t%3600/60),n=t%60;return(e?e+":":"")+("0"+i+":").slice(-3)+("0"+n).slice(-2)},escapeLucene:function(t){var e="";return Ext.each(t.split(""),function(t){-1!=='\\+-!():^[]"{}~*?|& '.indexOf(t)&&(e+="\\"),e+=t}),e},escapeHighlight:function(t){return Ext.util.Format.htmlEncode(t||"").replace(/(3dd2fc93591338387e3f9e8f06fe0e34)|(92e78cb96015fb30b3d910376e32825d)/g,function(t,e,i){return e?'<span class="highlight">':"</span>"})},regexHighlight:function(t,e){var i=t.match(/\w+/g);if(!i)return Ext.util.Format.htmlEncode(e);var n=i.map(function(t){return"("+t+")"}).join("|"),r=new RegExp(n,"gi");return this.escapeHighlight((e||"").replace(r,"3dd2fc93591338387e3f9e8f06fe0e34$&92e78cb96015fb30b3d910376e32825d"))},checkSupportPDFViewer:function(){return SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.PDFViewer.Application")},checkEnableDocumentViewerBtn:function(t){return SYNO.SDS.DocumentViewer&&(SYNO.SDS.DocumentViewer.FBExt.avaiThumbTypes.indexOf(t)>=0||SYNO.SDS.DocumentViewer.FBExt.avaiPartialTypes.indexOf(t)>=0)||SYNO.SDS.PDFViewer&&SYNO.SDS.PDFViewer.FBExt.avaiViewTypes.indexOf(t)>=0},checkIsValidBookmark:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword",""),e=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCriteria",[]);return!!t||e.length},getFilePreviewMeta:function(t,e){switch(SYNO.Finder.Utils.EntryType(t.SYNOMDFSName)){default:case"document":return[{name:SYNO.Finder.Utils._T("common","meta_filename"),content:e?"":t.SYNOMDFSName},{name:SYNO.Finder.Utils._T("common","meta_author"),content:t.SYNOMDAuthors},{name:SYNO.Finder.Utils._T("common","meta_size"),content:Ext.util.Format.fileSize(t.SYNOMDFSSize)},{name:SYNO.Finder.Utils._T("common","meta_filetype"),content:"y"===t.SYNOMDIsDir?SYNO.Finder.Utils._T("common","folder"):t.SYNOMDExtension},{name:SYNO.Finder.Utils._T("common","meta_mod_date"),content:Ext.isEmpty(t.SYNOMDContentModificationDate)?"":SYNO.Finder.Utils.DateTimeFormatter(new Date(1e3*t.SYNOMDContentModificationDate),{type:"datetime"})},{name:SYNO.Finder.Utils._T("common","meta_created_date"),content:Ext.isEmpty(t.SYNOMDFSCreationDate)?"":SYNO.Finder.Utils.DateTimeFormatter(new Date(1e3*t.SYNOMDFSCreationDate),{type:"datetime"})},{name:SYNO.Finder.Utils._T("common","meta_last_accessed_date"),content:Ext.isEmpty(t.SYNOMDLastUsedDate)?"":SYNO.Finder.Utils.DateTimeFormatter(new Date(1e3*t.SYNOMDLastUsedDate),{type:"datetime"})},{name:SYNO.Finder.Utils._T("common","meta_creator"),content:t.SYNOMDCreator},{name:SYNO.Finder.Utils._T("common","meta_owner"),content:t.SYNOMDOwnerUserName}];case"image":return[{name:SYNO.Finder.Utils._T("common","meta_filename"),content:e?"":t.SYNOMDFSName},{name:SYNO.Finder.Utils._T("common","meta_resolution"),content:t.SYNOMDResolutionWidthDPI&&t.SYNOMDResolutionHeightDPI&&t.SYNOMDResolutionWidthDPI+" x "+t.SYNOMDResolutionHeightDPI||""},{name:SYNO.Finder.Utils._T("common","meta_size"),content:Ext.util.Format.fileSize(t.SYNOMDFSSize)},{name:SYNO.Finder.Utils._T("common","meta_image_date"),content:SYNO.Finder.Utils.DateTimeFormatter(new Date(1e3*t.SYNOMDContentCreationDate),{type:"datetime"})},{name:SYNO.Finder.Utils._T("common","meta_created_date"),content:SYNO.Finder.Utils.DateTimeFormatter(new Date(1e3*t.SYNOMDFSCreationDate),{type:"datetime"})},{name:SYNO.Finder.Utils._T("common","meta_mod_date"),content:SYNO.Finder.Utils.DateTimeFormatter(new Date(1e3*t.SYNOMDContentModificationDate),{type:"datetime"})},{name:SYNO.Finder.Utils._T("common","meta_acquisition_make"),content:t.SYNOMDAcquisitionMake},{name:SYNO.Finder.Utils._T("common","meta_acquisition_model"),content:t.SYNOMDAcquisitionModel},{name:SYNO.Finder.Utils._T("common","meta_exposure"),content:t.SYNOMDExposureTimeString},{name:SYNO.Finder.Utils._T("common","meta_aperture"),content:t.SYNOMDAperture},{name:SYNO.Finder.Utils._T("common","meta_ISO"),content:t.SYNOMDISOSpeed}];case"video":return[{name:SYNO.Finder.Utils._T("common","meta_filename"),content:e?"":t.SYNOMDFSName},{name:SYNO.Finder.Utils._T("common","meta_duration"),content:t.SYNOMDDurationSecond?SYNO.Finder.Utils.ParseDurationSecond(t.SYNOMDDurationSecond):""},{name:SYNO.Finder.Utils._T("common","meta_size"),content:Ext.util.Format.fileSize(t.SYNOMDFSSize)},{name:SYNO.Finder.Utils._T("common","meta_resolution"),content:t.SYNOMDResolutionWidthDPI&&t.SYNOMDResolutionHeightDPI&&t.SYNOMDResolutionWidthDPI+" x "+t.SYNOMDResolutionHeightDPI||""},{name:SYNO.Finder.Utils._T("common","meta_container"),content:t.SYNOMDMediaTypes},{name:SYNO.Finder.Utils._T("common","meta_mod_date"),content:SYNO.Finder.Utils.DateTimeFormatter(new Date(1e3*t.SYNOMDContentModificationDate),{type:"datetime"})},{name:SYNO.Finder.Utils._T("common","meta_created_date"),content:SYNO.Finder.Utils.DateTimeFormatter(new Date(1e3*t.SYNOMDFSCreationDate),{type:"datetime"})},{name:SYNO.Finder.Utils._T("common","meta_video_codec"),content:t.SYNOMDCodecs.split(" ")[0]},{name:SYNO.Finder.Utils._T("common","meta_audio_codec"),content:t.SYNOMDCodecs.split(" ")[1]},{name:SYNO.Finder.Utils._T("common","meta_video_bitrate"),content:t.SYNOMDVideoBitRate}];case"audio":return[{name:SYNO.Finder.Utils._T("common","meta_filename"),content:e?"":t.SYNOMDFSName},{name:SYNO.Finder.Utils._T("common","meta_container"),content:t.SYNOMDMediaTypes},{name:SYNO.Finder.Utils._T("common","meta_artist"),content:t.SYNOMDCreator},{name:SYNO.Finder.Utils._T("common","meta_album"),content:t.SYNOMDAlbum},{name:SYNO.Finder.Utils._T("common","meta_genre"),content:t.SYNOMDMusicalGenre},{name:SYNO.Finder.Utils._T("common","meta_duration"),content:t.SYNOMDDurationSecond?SYNO.Finder.Utils.ParseDurationSecond(t.SYNOMDDurationSecond):""},{name:SYNO.Finder.Utils._T("common","meta_year"),content:t.SYNOMDRecordingYear},{name:SYNO.Finder.Utils._T("common","meta_size"),content:Ext.util.Format.fileSize(t.SYNOMDFSSize)},{name:SYNO.Finder.Utils._T("common","meta_track"),content:t.SYNOMDAudioTrackNumber},{name:SYNO.Finder.Utils._T("common","meta_title"),content:t.SYNOMDTitle},{name:SYNO.Finder.Utils._T("common","meta_audio_bitrate"),content:t.SYNOMDAudioBitRate}]}}}}),Ext.define("SYNO.Finder.Tray.FileIndex.Instance",{extend:"SYNO.SDS.AppInstance",trayItem:[],initInstance:function(t){this.trayItem[0]=new SYNO.Finder.Tray.FileIndex.Tray({AppInstance:this}),this.addInstance(this.trayItem[0]),this.trayItem[0].open(t)}}),Ext.define("SYNO.Finder.Tray.FileIndex.Tray",{extend:"SYNO.SDS.Tray.ArrowTray",initPanel:function(){var t=this;return new SYNO.Finder.Tray.FileIndex.Panel({module:t})},onMouseDown:function(t){var e=this.panel.combobox.list;if(void 0===e||!t.within(e.dom))return this.callParent(arguments)}}),Ext.define("SYNO.Finder.Tray.FileIndex.Panel",{extend:"SYNO.SDS.Tray.Panel",RUNNING:"running",PAUSED:"paused",FINISHED:"finished",show_status:{index:this.FINISHED,term:this.FINISHED},statusDelayedTask:{index:null,term:null},constructor:function(t){this.module=t.module,this.pauseIconCls="sds-tray-item-pause-file-indexing",this.startIconCls="sds-tray-item-start-file-indexing",this.comboboxId=Ext.id(),this.actionBtnId=Ext.id(),this.statusInfoId=Ext.id(),this.statusBulidInfoId=Ext.id(),this.statusIconId=Ext.id(),this.navigateLinkId=Ext.id();var e=Ext.apply({module:t.module,cls:"syno-file-indexing-tray",title:SYNO.Finder.Utils._T("common","indexing_progress"),width:360,autoHeight:!0,renderTo:document.body,defaults:{width:340},tpl:this.createTpl(),data:this.getTplData(),listeners:{afterrender:function(){this.createComboBox(),this.actionBtn=new SYNO.ux.Button({renderTo:this.actionBtnId,enableToggle:!0,toggleHandler:function(t,e){t.disable(),e?this.sendPauseReq():this.sendResumeReq()},scope:this}),this.navigateLink=Ext.get(this.navigateLinkId),this.navigateLink.on("click",function(){SYNO.SDS.AppLaunch("SYNO.Finder.Application",{fn:"preference"}),this.hide()},this)},scope:this}},t);this.callParent([e]),SYNO.SDS.StatusNotifier.isAppHasPrivilege("SYNO.Finder.Application")&&this.startPollingTask()},createComboBox:function(){var t=new Ext.data.ArrayStore({fields:["value","display"],data:[[1,String.format(SYNO.Finder.Utils._T("common","delay_hours"),1)],[3,String.format(SYNO.Finder.Utils._T("common","delay_hours"),3)],[6,String.format(SYNO.Finder.Utils._T("common","delay_hours"),6)],[0,String.format(SYNO.Finder.Utils._T("common","delay_forever"))]]});this.combobox=new SYNO.ux.ComboBox({renderTo:this.comboboxId,store:t,displayField:"display",valueField:"value",value:1,width:290})},getTplData:function(){return{navigateLink:SYNO.Finder.Utils._T("common","view_index_list"),navigateLinkId:this.navigateLinkId,termSuggBuilding:SYNO.Finder.Utils._T("common","status_term_building"),termSuggSubtitle:SYNO.Finder.Utils._T("common","status_term_sugg_db"),note:SYNO.Finder.Utils._T("common","resource_note"),noteLabel:_T("common","note")+_T("common","colon")+" ",termSuggNote:SYNO.Finder.Utils._T("common","status_term_building_desc"),comboboxId:this.comboboxId,actionBtnId:this.actionBtnId,statusInfoId:this.statusInfoId,statusIconId:this.statusIconId,statusBulidInfoId:this.statusBulidInfoId}},createTpl:function(){return new Ext.XTemplate('<div class="status-section index">','<div class="status-wrap">','<div id="{statusIconId}" class="status-icon"></div>','<div class="status-info-wrap">','<div id="{statusInfoId}" class="status-info">Indexing</div>','<div id="{navigateLinkId}" class="navigate-link link-font">{navigateLink}</div>',"</div>","</div>",'<div class="action-wrap">','<div id={comboboxId} class="delay-combobox"></div>','<div id={actionBtnId} class="action-btn"></div>','<div class="clear"></div>',"</div>",'<div class="note-wrap normal-font">','<div ><span class="note-font">{noteLabel}</span>{note}</div>',"</div>","</div>",'<div class="status-section term">','<div class="status-wrap term">','<div class="status-icon term"></div>','<div class="status-info-wrap">','<div id="{statusBulidInfoId}" class="status-info">{termSuggBuilding}</div>','<div class="link-font">{termSuggSubtitle}</div>',"</div>","</div>",'<div class="note-wrap normal-font">','<div ><span class="note-font">{noteLabel}</span>{termSuggNote}</div>',"</div>","</div>")},textAnimate:function(t,e,i){switch(i){case 1:t.innerHTML=e+".&nbsp;&nbsp;";break;case 2:t.innerHTML=e+"..&nbsp;";break;case 3:t.innerHTML=e+"...";break;default:t.innerHTML=e+"&nbsp;&nbsp;&nbsp;"}this.delay(500,null,null,[t,e,(i+1)%4])},toIndexing:function(t){if(this.RUNNING!==this.show_status[t]){var e="index"===t?SYNO.Finder.Utils._T("common","indexingwithoutdot"):SYNO.Finder.Utils._T("common","status_term_building"),i=Ext.get("index"===t?this.statusInfoId:this.statusBulidInfoId).dom;this.statusDelayedTask[t]||(this.statusDelayedTask[t]=new Ext.util.DelayedTask(this.textAnimate)),this.statusDelayedTask[t].delay(0,null,this.statusDelayedTask[t],[i,e,0]),Ext.fly(this.statusIconId).removeClass("pause"),"index"===t&&this.combobox.enable(),this.module.setIconClass(this.startIconCls),this.show_status[t]=this.RUNNING}},toPause:function(){if(this.FINISHED!==this.show_status.index){var t=SYNO.Finder.Utils._T("common","status_paused"),e=Ext.get(this.statusInfoId).dom;this.statusDelayedTask.index&&this.statusDelayedTask.index.cancel(),e.innerHTML=t,Ext.fly(this.statusIconId).addClass("pause"),this.combobox.disable(),this.module.setIconClass(this.pauseIconCls),this.show_status.index=this.PAUSED}},startPollingTask:function(){this.pollingTask=this.addWebAPITask({api:"SYNO.Finder.FileIndexing.Status",method:"get",version:1,scope:this,callback:function(t,e,i,n){if(!t)return void(160===e.code&&this.pollingTask.stop());this.onIndexStatusChange(e.status.index),this.onTermStatusChange(e.status.term)},interval:5e3}),this.pollingTask.start(!0)},onIndexStatusChange:function(t){"processing"===t?(this.module.setTaskButtonVisible(!0),this.actionBtn.toggle(!1,!0),this.toIndexing("index"),this.updateTemplate()):"finished"===t?this.onClose("index"):(this.module.setTaskButtonVisible(!0),this.actionBtn.toggle(!0,!0),this.toPause(),this.updateTemplate())},onTermStatusChange:function(t){"processing"===t?(window.a=this.module,this.module.setTaskButtonVisible(!0),this.toIndexing("term")):this.onClose("term"),this.updateTemplate()},onClose:function(t){this.show_status[t]=this.FINISHED,this.FINISHED===this.show_status.index&&this.FINISHED===this.show_status.term&&(this.module.setTaskButtonVisible(!1),this.module.onClose())},updateTemplate:function(){Ext.fly(this.el.query(".status-section.index")[0])[this.FINISHED===this.show_status.index?"addClass":"removeClass"]("hide"),Ext.fly(this.el.query(".status-section.term")[0])[this.FINISHED===this.show_status.term?"addClass":"removeClass"]("hide")},sendPauseReq:function(){this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Status",method:"pause",version:1,params:{length:this.combobox.getValue()},scope:this,callback:function(t,e,i,n){this.actionBtn.enable(),t&&this.toPause()}})},sendResumeReq:function(){this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Status",method:"resume",version:1,scope:this,callback:function(t,e,i,n){this.actionBtn.enable(),t&&this.toIndexing("index")}})}}),Ext.define("SYNO.Finder.BookmarkPrompt",{extend:"SYNO.SDS.ModalWindow",BOOKMARK_MODAL_WIDTH:380,BOOKMARK_MODAL_HEIGHT:214,constructor:function(t){var e={title:SYNO.Finder.Utils._T("common","facet_modal_title"),layout:{type:"vbox",align:"stretch"},width:this.BOOKMARK_MODAL_WIDTH,
height:this.BOOKMARK_MODAL_HEIGHT,padding:20,items:[{xtype:"syno_displayfield",value:SYNO.Finder.Utils._T("common","facet_save_prompt")},{xtype:"syno_textfield",name:"bookmark_name",allowBlank:!1,validateOnBlur:!0,invalidText:SYNO.Finder.Utils._T("common","empty_bookmark_warning"),validator:this.fieldValidator,emptyText:SYNO.Finder.Utils._T("common","facet_text_name")}],buttons:[{text:_T("common","save"),btnStyle:"blue",scope:this,handler:this.onSaveClick},{text:_T("common","cancel"),scope:this,handler:this.onCancelClick}],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},onAfterRender:function(){this.focusEl.on("focus",this.onFocus,this)},onFocus:function(){this.find("name","bookmark_name")[0].focus()},onSaveClick:function(){var t=this.find("name","bookmark_name")[0];t.isValid()&&(SYNO.Finder.Mgr.statusMgr.fireEvent("bookmarksave",t.getValue()),this.close())},onCancelClick:function(){this.close()},fieldValidator:function(t){if(!t.trim())return!1;var e=!0;return SYNO.Finder.Mgr.bookmarkMgr.getStore().each(function(i){if(i.get("name")===t.trim())return e=SYNO.Finder.Utils._T("common","bookmark_name_dup"),!1}),e}}),Ext.define("SYNO.Finder.LoadMore",{extend:"Ext.BoxComponent",constructor:function(t){var e={cls:"load-more",data:{content:SYNO.Finder.Utils._T("common","list_load_more")},tpl:new Ext.XTemplate("<a>{content}</a>")};this.callParent([Ext.apply(e,t)]),this._listeners=t.listeners,this.on("afterrender",this.onAfterRender,this)},onAfterRender:function(){this.bindEvents()},bindEvents:function(t){this.getEl().on("click",this._listeners.click,this._listeners.scope)},hideText:function(){this.addClass("no-load-more")},showText:function(){this.removeClass("no-load-more")}}),Ext.reg("finder_loadmore",SYNO.Finder.LoadMore),Ext.define("SYNO.Finder.Spotlight.Core",{extend:"Ext.util.Observable",currentItem:null,appWindow:null,state:null,INIT_STATE_CLS:"spotlight-init",WINDOW_DEFAULT_HEIGHT:444,WINDOW_DEFAULT_WIDTH:690,MINIMAL_HEIGHT:50,PROMPT_HEIGHT:null,constructor:function(t){this.appWindow=t,this.callParent(),this.initEvents()},initEvents:function(){SYNO.Finder.Spotlight.Mgr.statusMgr.on("searchbarclear",this.onSearchBarClear.createDelegate(this)),SYNO.Finder.Spotlight.Mgr.statusMgr.on("showall",this.showAllInFinder),SYNO.Finder.Spotlight.Mgr.statusMgr.on("promptHide",this.onPromptHide.createDelegate(this)),SYNO.Finder.Spotlight.Mgr.statusMgr.on("searchBarInput",this.onSearchBarInput.createDelegate(this))},onSearchBarInput:function(){"indexprompt"===this.state&&this.setState("init")},onSearchBarClear:function(){this.setState("init")},onPromptHide:function(){this.setState("init")},openItem:function(){if(this.currentItem){var t=!1,e=this.currentItem.get("launchAppData");if(e)return SYNO.SDS.AppLaunch(e.className,e.params),void SYNO.SDS.SearchBox.toggleBox();Ext.each(SYNO.Finder.Spotlight.Mgr.actionMgr.getActions(),function(e){if(e.check([this.currentItem],"all")&&e.dbclick([this.currentItem],"all"))return e.doAction([this.currentItem],"all"),SYNO.SDS.SearchBox.toggleBox(),this.recordSpotlightOpen(this.currentItem),t=!0,!1},this),t||this.showAllInFinder()}},recordSpotlightOpen:function(t){t.data.extraData.highlightFullPath},setCurrentItem:function(t){return this.currentItem=t,this},getCurrentItem:function(){return this.currentItem},createKeyMap:function(){this.navMap||(this.navMap=new Ext.KeyMap(SYNO.SDS.Desktop.el,[{key:[Ext.EventObject.UP,Ext.EventObject.DOWN,Ext.EventObject.LEFT,Ext.EventObject.RIGHT],scope:this,fn:this.onNavKey},{key:[Ext.EventObject.ENTER],scope:this,fn:this.onFnKey},{key:[Ext.EventObject.TAB],scope:this,fn:this.onTabKey},{key:[Ext.EventObject.ESC],scope:this,fn:this.onEscKey},{key:"f",ctrl:!0,scope:this,fn:this.onTypeHotKey},{key:"dpmv",alt:!0,scope:this,fn:this.onTypeHotKey}])),this.navMap.enable()},enableKeyMap:function(){this.navMap&&this.navMap.enable()},disableKeyMap:function(){this.navMap.disable()},addInitState:function(){this.appWindow&&(this.appWindow.addClass(this.INIT_STATE_CLS),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("initStateAdd"))},removeInitState:function(){this.appWindow.removeClass(this.INIT_STATE_CLS),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("initStateRemove")},setState:function(t,e){switch(this.state=t,t){case"indexprompt":this.appWindow.removeClass(this.INIT_STATE_CLS),!this.PROMPT_HEIGHT&&e&&(this.PROMPT_HEIGHT=e),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("initStateRemove",t,this.MINIMAL_HEIGHT+this.PROMPT_HEIGHT);break;case"normal":this.appWindow.removeClass(this.INIT_STATE_CLS),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("initStateRemove",t,this.WINDOW_DEFAULT_HEIGHT);break;default:case"init":this.state="init",this.appWindow.addClass(this.INIT_STATE_CLS),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("initStateAdd")}},centerWindow:function(){this.setState("normal");var t=(SYNO.SDS.Desktop.el.getHeight()-this.appWindow.getHeight())/6;this.appWindow.alignTo(SYNO.SDS.Desktop.el,"c-c",[0,-t])},restoreState:function(){SYNO.Finder.Utils.debug("Restore state",this.state);var t=this.state;this.state?(this.setState("normal"),this.centerWindow(),this.setState(t,this.MINIMAL_HEIGHT+this.PROMPT_HEIGHT)):this.centerWindow()},onNavKey:function(t,e){t===e.UP?(SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("spotlightPressUp"),e.stopEvent()):t===e.DOWN&&(SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("spotlightPressDown"),e.stopEvent()),e.altKey&&(t===e.RIGHT?SYNO.Finder.Spotlight.previewMgr.goNextSnippet():t===e.LEFT&&SYNO.Finder.Spotlight.previewMgr.goPrevSnippet())},onFnKey:function(t,e){t!==e.ENTER||SYNO.Finder.Spotlight.Mgr.statusMgr.isSearching()||this.openItem()},onTabKey:function(t,e){t===e.TAB&&SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("searchbarCompletion"),e.preventDefault()},onEscKey:function(){""===SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchKeyword","")?SYNO.SDS.SearchBox.toggleBox():SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("escPress")},onTypeHotKey:function(t,e){var i,n=SYNO.Finder.Spotlight.Mgr.statusMgr.getData("searchType","all");switch(e.stopPropagation(),e.preventDefault(),t){case e.D:i="document";break;case e.P:i="image";break;case e.V:i="video";break;case e.M:i="audio";break;default:i="all"}i!==n?(SYNO.Finder.Spotlight.Mgr.statusMgr.applyData({searchType:i}).fireEvent("changeSearchType",i),""!==SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchKeyword","")&&SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("searchNeeded")):SYNO.SDS.SearchBox.toggleBox()},showAllInFinder:function(){SYNO.SDS.AppLaunch("SYNO.Finder.Application",{keyword:SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchKeyword",""),type:SYNO.Finder.Spotlight.Mgr.statusMgr.getData("searchType","all")}),SYNO.SDS.SearchBox.toggleBox()}}),Ext.ns("SYNO.Finder.Mgr"),Ext.define("SYNO.Finder.Mgr.Status",{extend:"Ext.Component",BOARD_FADE_OUT_DELAY:50,defaultData:{currentViewMode:"welcome",currentSearchCategory:"all"},constructor:function(){this.data={},this._data={searching:{},indicating:{},indicator:{}},Ext.apply(this.data,this.defaultData),this.callParent(arguments)},getData:function(t,e){return Ext.isDefined(this.data[t])?this.data[t]:e},delData:function(t){delete this.data[t]},applyData:function(t){return Ext.apply(this.data,t),this},isSearching:function(t){var e;if(t)return Ext.isDefined(this._data.searching[t]);for(e in this._data.searching)if(this._data.searching.hasOwnProperty(e))return!0;return!1},registerSearching:function(t){return this._data.searching[t]=!0,this},unregisterSearching:function(t){return delete this._data.searching[t],this},isIndicating:function(t){var e;if(t)return Ext.isDefined(this._data.indicating[t]);for(e in this._data.indicating)if(this._data.indicating.hasOwnProperty(e))return!0;return!1},registerIndicating:function(t){return this._data.indicating[t]=!0,this},unregisterIndicating:function(t){return delete this._data.indicating[t],this},applyIndicator:function(t,e){return Ext.isDefined(this._data.indicator[t])||(this._data.indicator[t]=!!e),this._data.indicator[t]+=!!e,this},getIndicator:function(t){return this._data.indicator.hasOwnProperty(t)&&this._data.indicator[t]},resetIndicator:function(t){return t?delete this._data.indicator[t]:this._data.indicator={},this}}),Ext.define("SYNO.Finder.Parser.TimeParser",{constructor:function(t){Ext.apply(this,t||{}),this._init()},parse:function(t){var e=this.parser.parse(t.keyword),i=0;return Ext.each(e,function(e){var n="[{0} TO {1}]",r=e.start?(e.start.date().getTime()/1e3).toFixed(0):2147483647,s=e.end?(e.end.date().getTime()/1e3).toFixed(0):2147483647;n=String.format(n,r,s),e.text=e.text.trim(),t.keyword=t.keyword.substr(0,e.index-i)+t.keyword.substr(e.index-i).replace(e.text,""),this._addCriteriaList(t,n,e.text),this._addPluginCriteriaList(t,r,s,e.text),i+=e.index+e.text.length-1},this),t},_init:function(){this.parser=new chrono.Chrono(chrono.options.casualOption()),this.parser.parsers.unshift((new SYNO.Finder.Parser.YearFormatParser).getParser()),this.parser.refiners.pop(),this.parser.refiners.push((new SYNO.Finder.Parser.DefaultTimeRefiner).getRefiner())},_addCriteriaList:function(t,e,i){t.criteria_list&&Ext.isArray(t.criteria_list)||(t.criteria_list=[]),t.criteria_list.push({compound:[{field:"SYNOMDContentModificationDate",value:e},{field:"SYNOMDFSCreationDate",value:e},{field:"SYNOMDLastUsedDate",value:e},{field:"SYNOMDSearchFileName",value:i},{field:"SYNOMDWildcard",value:i}]})},_addPluginCriteriaList:function(t,e,i,n){t.plugin_criteria&&Ext.isArray(t.plugin_criteria)||(t.plugin_criteria=[]),e*=1e3,i*=1e3,t.plugin_criteria.push({compound:[{type:"SYNOMDContentModificationDate",from:e,to:i},{type:"SYNOMDFSCreationDate",from:e,to:i},{type:"SYNOMDLastUsedDate",from:e,to:i},{type:"SYNOMDSearchFileName",value:n},{field:"SYNOMDWildcard",value:n}]})}}),Ext.define("SYNO.Finder.Parser.DefaultTimeRefiner",{constructor:function(){this.refiner=new chrono.Refiner,this.refiner.refine=function(t,e,i){return Ext.each(e,function(t){t.start&&(t.start.imply("hour",0),t.end||(t.end=t.start.clone(),t.end.imply("hour",23),t.end.imply("minute",59),t.end.imply("second",59))),t.end&&(t.end.imply("hour",23),t.end.imply("minute",59),t.end.imply("second",59))}),e}},getRefiner:function(){return this.refiner}}),Ext.define("SYNO.Finder.Parser.YearFormatParser",{PATTERN:/(?:\W|^)([0-9]{4})\s*(?:(?:-|~|to)\s*([0-9]{4}))?(?:\W|$)/i,START_YEAR_GROUP:1,END_YEAR_GROUP:2,constructor:function(){var t=this;this.parser=new chrono.Parser,this.parser.pattern=function(){return t.PATTERN},this.parser.extract=function(e,i,n,r){var s=n[0],a=n[t.START_YEAR_GROUP],o=n[t.END_YEAR_GROUP],l=(new Date).getFullYear();return a&&(4!=a.length||a<1920||a>l)?null:o&&(4!=o.length||o<1920||a>o)?null:new chrono.ParsedResult({ref:i,text:s,index:n.index,start:{year:parseInt(a||l,10),month:1,day:1},end:{year:parseInt(o||a,10),month:12,day:31,hour:23,minute:59,second:59},tags:{YearFormatParser:!0}})}},getParser:function(){return this.parser}}),Ext.define("SYNO.Finder.Parser.QueryParser",{timeParser:!0,constructor:function(t){Ext.apply(this,t||{}),this.parsers=[],this.timeParser&&this.parsers.push(new SYNO.Finder.Parser.TimeParser(this.timeParser))},parse:function(t){var e=t;return Ext.each(this.parsers,function(t){e=t.parse(e)}),e}}),Ext.ns("SYNO.Finder.Searcher"),Ext.define("SYNO.Finder.Searcher.Base",{extend:"Ext.Component",BASIC_LOAD_ENTRIES:11,LOAD_MORE_ENTRIES:11,reachEnd:!1,constructor:function(t){this.apiRequest=null,Ext.apply(this,t||{}),this.callParent(arguments),this.initEvents()},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,{searchNeeded:this.onSearchNeeded,loadMore:this.onLoadMore,searchFieldCleared:this.onSearchFieldCleared,scope:this})},onSearchNeeded:function(t){SYNO.Finder.Mgr.statusMgr.isSearching(this.getName())&&this.abortAPIRequest(),SYNO.Finder.Mgr.statusMgr.registerSearching(this.getName()),this.search(t)},onSearchFieldCleared:function(){SYNO.Finder.Mgr.statusMgr.isSearching(this.getName())&&this.abortAPIRequest()},onLoadMore:function(t){return t==this.getName()&&this.isSearchNeeded()?SYNO.Finder.Mgr.statusMgr.isSearching(this.getName())?void SYNO.Finder.Utils.debug("abort load more because is searching"):(SYNO.Finder.Mgr.statusMgr.registerSearching(this.getName()),void this.loadMore()):void SYNO.Finder.Utils.debug("abort load more because wrong searchername or not needed")},isSearchNeeded:function(){return!0},resetSearch:function(){this.from=0,this.reachEnd=!1},search:function(t){this.resetSearch(),this.sendSearchWebAPI(this.getSearchParams(),!1,t)},sendSearchWebAPI:function(t,e,i){if(SYNO.Finder.Mgr.statusMgr.fireEvent("doSearch",this.getName(),e),e||i||this.resetIndicatorStatus(),!1===t)return void window.setTimeout(function(){this.onSearchDone([],0,e)}.createDelegate(this),0);var n={scope:this,callback:function(t,n){var r;if(SYNO.Finder.Mgr.statusMgr){if(!t){var s=SYNO.Finder.Mgr.statusMgr.getData("appWin",null);if(s)switch(!0===n.isTimeout?SYNO.Finder.Utils.alert(s,SYNO.Finder.Utils._T("common","search_timeout")):SYNO.Finder.Utils.alert(s,SYNO.Finder.Utils.getWebAPIErrStr(n)),n.code){case 1001:SYNO.Finder.Mgr.statusMgr.applyData({currentSearchKeyword:""}).fireEvent("searchKeywordChanged","")}return void this.onSearchDone([],0,e,i)}r=this.processSearchResp(n),this.onSearchDone(r,r.length?n.total:0,e,i,n.unavail,n.has_error)}}};Ext.isArray(t)?n.compound={params:t}:(n.api=this.apiName,n.method=this.apiMethod,n.version=this.apiVersion,n.params=t,n.timeout=3e5),this.apiRequest=this.sendWebAPI(n)},onSearchDone:function(t,e,i,n,r,s){SYNO.Finder.Mgr.statusMgr.unregisterSearching(this.getName()),this.needToUpdateResultList()&&SYNO.Finder.Mgr.statusMgr.fireEvent("searchDone",this.getName(),t,i,r,s),i||this.updateIndicatorStatus(t,e)},loadMore:function(){SYNO.Finder.Utils.debug(this.getName(),this.from,this.reachEnd),this.reachEnd||(SYNO.Finder.Utils.debug(this.getName()+" load more"),this.sendSearchWebAPI(this.getSearchParams(),!0))},abortAPIRequest:function(){try{this.apiRequest&&this.apiRequest.conn&&this.apiRequest.conn.abort()}catch(t){SYNO.Debug.error(t)}},updateIndicatorStatus:function(t,e){var i=!!t.length;SYNO.Finder.Mgr.statusMgr.applyIndicator("all",i).applyIndicator(this.getName(),t.length).fireEvent("indicatorUpdated",this.getName()),SYNO.Finder.Mgr.statusMgr.fireEvent("searchTotalAdd",this.getName(),e)},resetIndicatorStatus:function(){SYNO.Finder.Mgr.statusMgr.resetIndicator(this.getName()).fireEvent("indicatorUpdated")},needToUpdateResultList:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory",null);return["all",this.getName()].indexOf(t)>=0},getSearchParams:Ext.emptyFn,getSearchWeights:Ext.emptyFn,processSearchResp:Ext.emptyFn,getName:Ext.emptyFn,getAppName:Ext.emptyFn}),Ext.ns("SYNO.Finder.Searcher"),Ext.define("SYNO.Finder.Searcher.File",{extend:"SYNO.Finder.Searcher.Base",apiName:"SYNO.Finder.FileIndexing.Search",apiMethod:"search",apiVersion:1,getName:function(){return"file"},onSearchNeeded:function(t){if(!this.isSearchNeeded()&&!t)return void this.updateIndicatorStatus([],!0);SYNO.Finder.Mgr.statusMgr.isIndicating(this.getName())&&!t&&this.abortIndRequest(),this.callParent(arguments)},isSearchNeeded:function(){return-1!==["all","file","document","audio","video","image"].indexOf(SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory"))},processSearchResp:function(t){var e=[];return Ext.each(t.hits,function(t){try{e.push({listItemIconCls:this.getIconCls(t),listItemTitle:this.getBasename(t),listItemSubtitle:this.getDirname(t),detailItemIconCls:this.getIconCls(t),detailItemTitle:this.getBasename(t),detailItemSubtitle:this.getDirname(t),detailItemLeftInfo:this.getDetailLeftInfo(t),detailItemRightInfo:this.getDetailRightInfo(t),detailItemTitleQTip:this.getDetailItemTitleQTip(t),detailItemSubtitleQTip:this.getDetailItemSubtitleQTip(t),detailItemLeftInfoQTip:this.getDetailItemLeftInfoQTip(t),detailItemRightInfoQTip:this.getDetailItemRightInfoQTip(t),contextItemIconCls:this.getIconCls(t),contextItemTitle:this.getBasename(t),contextItemSnippet:this.getTextContent(t),thumbnailItemTitle:this.getBasename(t),thumbnailItemDefaultIcon:this.getThumbnailDefaultIcon(t),thumbnailItemSrc:this.getThumbnailSrc(t),previewCardID:this.getPreviewCardID(t),previewMeta:this.getPreviewMeta(t),previewItemSrc:this.getPreviewImteSrc(t),extraData:this.getExtraData(t)})}catch(t){SYNO.Finder.Utils.error("processSearchResp error:",t)}},this),this.BASIC_LOAD_ENTRIES>e.length?(this.reachEnd=!0,SYNO.Finder.Mgr.statusMgr.fireEvent("searchReachEnd",this.getName())):(e.splice(this.BASIC_LOAD_ENTRIES-1,1),this.from+=e.length),e},getSearchParams:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword",""),e=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCriteria",[]),i=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory",""),n=this.parser.parse({keyword:SYNO.Finder.Utils.ConstructKeyword(t),criteria_list:SYNO.Finder.Utils.ConstructSearchCriteriaList(e)}),r={agent:"sus",query_id:SYNO.Finder.Mgr.searcherMgr.getQueryID(),query_serial:SYNO.Finder.Mgr.searcherMgr.getQuerySerial(),indice:[],keyword:n.keyword,orig_keyword:t,criteria_list:n.criteria_list,from:this.from,size:this.BASIC_LOAD_ENTRIES,fields:this.getSearchFields(),file_type:this.getSearchFileType(),search_weight_list:this.getSearchWeights()||[]};return"document"!==i?r:Ext.apply(r,{highlight:[{field:"SYNOMDTextContent",num_fragments:10,frag_length:100}]})},getSearchWeights:function(){return[{field:"SYNOMDWildcard",weight:1},{field:"SYNOMDTextContent",weight:1},{field:"SYNOMDSearchFileName",weight:8.5}]},getSearchFields:function(){switch(SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory","all")){case"document":return["SYNOMDFSName","SYNOMDAuthors","SYNOMDFSSize","SYNOMDExtension","SYNOMDContentModificationDate","SYNOMDFSCreationDate","SYNOMDLastUsedDate","SYNOMDCreator","SYNOMDOwnerUserID","SYNOMDOwnerUserName","SYNOMDIsEncrypted"];case"image":return["SYNOMDFSName","SYNOMDResolutionHeightDPI","SYNOMDResolutionWidthDPI","SYNOMDFSSize","SYNOMDContentCreationDate","SYNOMDFSCreationDate","SYNOMDContentModificationDate","SYNOMDAcquisitionMake","SYNOMDAcquisitionModel","SYNOMDExposureTimeString","SYNOMDAperture","SYNOMDISOSpeed"];case"video":return["SYNOMDFSName","SYNOMDDurationSecond","SYNOMDFSSize","SYNOMDResolutionWidthDPI","SYNOMDResolutionHeightDPI","SYNOMDMediaTypes","SYNOMDContentModificationDate","SYNOMDFSCreationDate","SYNOMDCodecs","SYNOMDVideoBitRate"];case"audio":return["SYNOMDFSName","SYNOMDMediaTypes","SYNOMDCreator","SYNOMDAlbum","SYNOMDMusicalGenre","SYNOMDDurationSecond","SYNOMDRecordingYear","SYNOMDFSSize","SYNOMDAudioTrackNumber","SYNOMDTitle","SYNOMDAudioBitRate"];default:case"all":case"files":return["SYNOMDAcquisitionMake","SYNOMDAcquisitionModel","SYNOMDAlbum","SYNOMDAperture","SYNOMDAudioBitRate","SYNOMDAudioTrackNumber","SYNOMDAuthors","SYNOMDCodecs","SYNOMDContentCreationDate","SYNOMDContentModificationDate","SYNOMDCreator","SYNOMDDurationSecond","SYNOMDExposureTimeString","SYNOMDExtension","SYNOMDFSCreationDate","SYNOMDFSName","SYNOMDFSSize","SYNOMDISOSpeed","SYNOMDLastUsedDate","SYNOMDMediaTypes","SYNOMDMusicalGenre","SYNOMDOwnerUserID","SYNOMDOwnerUserName","SYNOMDRecordingYear","SYNOMDResolutionHeightDPI","SYNOMDResolutionWidthDPI","SYNOMDTitle","SYNOMDVideoBitRate","SYNOMDIsEncrypted"]}},getSearchFileType:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory","all");switch(t){case"all":case"file":return"";default:return t}},getIconCls:function(t){if("y"!==t.SYNOMDIsDir){var e=SYNO.Finder.Utils.NormalizeExtension(t.SYNOMDExtension);return"y"===t.SYNOMDIsEncrypted&&(e+="_encrypted"),e}return!0===t.additional.is_mount_point?"remotemountpoint":"folder"},getBasename:function(t){return t.SYNOMDFSName},getDirname:function(t){return t.SYNOMDSharePath.substr(0,t.SYNOMDSharePath.lastIndexOf("/"))},getDetailLeftInfo:function(t){var e=SYNO.Finder.Utils.EntryType(t.SYNOMDFSName);return"document"===e?t.SYNOMDAuthors:"video"===e||"audio"===e?t.SYNOMDDurationSecond?SYNO.Finder.Utils.ParseDurationSecond(t.SYNOMDDurationSecond):"":Ext.util.Format.uppercase(t.SYNOMDExtension)},getDetailItemLeftInfoQTip:function(t){var e=SYNO.Finder.Utils.EntryType(t.SYNOMDFSName);return("document"===e?SYNO.Finder.Utils._T("common","meta_author"):"audio"===e||"video"===e?SYNO.Finder.Utils._T("common","meta_duration"):SYNO.Finder.Utils._T("common","meta_filetype"))+": "+this.getDetailLeftInfo(t)},getDetailRightInfo:function(t){var e=SYNO.Finder.Utils.EntryType(t.SYNOMDFSName);return"document"===e?SYNO.Finder.Utils.DateTimeFormatter(new Date(1e3*t.SYNOMDContentModificationDate),{type:"datetime"}):"image"===e||"video"===e?t.SYNOMDResolutionWidthDPI&&t.SYNOMDResolutionHeightDPI&&t.SYNOMDResolutionWidthDPI+" x "+t.SYNOMDResolutionHeightDPI||"":t.SYNOMDMusicalGenre},getDetailItemRightInfoQTip:function(t){var e=SYNO.Finder.Utils.EntryType(t.SYNOMDFSName);return("document"===e?SYNO.Finder.Utils._T("common","meta_mod_date"):"image"===e||"video"===e?SYNO.Finder.Utils._T("common","meta_resolution"):SYNO.Finder.Utils._T("common","meta_genre"))+": "+this.getDetailRightInfo(t)},getDetailItemTitleQTip:function(t){return SYNO.Finder.Utils._T("common","meta_filename")+": "+this.getBasename(t)},getDetailItemSubtitleQTip:function(t){return SYNO.Finder.Utils._T("common","detail_dirname")+": "+this.getDirname(t)},getTextContent:function(t){return t.highlight&&t.highlight.SYNOMDTextContent||""},getThumbnailDefaultIcon:function(t){var e;return"y"===t.SYNOMDIsDir?e=!0===t.additional.is_mount_point?"remotemountpoint":"folder":(e=SYNO.Finder.Utils.NormalizeExtension(t.SYNOMDExtension),"y"===t.SYNOMDIsEncrypted&&(e+="_encrypted")),String.format("webman/3rdparty/SynoFinder/images/filetype/{0}/"+e+".png",128*(1+SYNO.SDS.UIFeatures.test("isRetina")))},getThumbnailSrc:function(t){return SYNO.Finder.Utils.getThumbnailURL(t.SYNOMDSharePath,"medium","y"===t.SYNOMDIsDir)},getPreviewCardID:function(t){var e=SYNO.Finder.Utils.EntryType(t.SYNOMDFSName);return"document"!==e&&"audio"!==e||!1!==SYNO.Finder.Utils.EntryTypeIsInBlackList(e,t.SYNOMDFSName)?"thumbnail":e},getPreviewMeta:function(t){return SYNO.Finder.Utils.getFilePreviewMeta(t)},getPreviewImteSrc:function(t){return SYNO.Finder.Utils.getThumbnailURL(t.SYNOMDSharePath,"large","y"===t.SYNOMDIsDir,!0)},getExtraData:function(t){return{isDir:"y"===t.SYNOMDIsDir,path:t.SYNOMDPath,sharePath:t.SYNOMDSharePath,readable:t.readable,size:t.SYNOMDFSSize,highlightFullPath:t.SYNOMDPath,highlightDocId:t.additional.doc_id,highlightKeyword:t.additional.keyword,highlightExtension:t.SYNOMDExtension}},updateIndicatorStatus:function(t,e){e&&this.resetIndicatorStatus(),SYNO.Finder.Mgr.statusMgr.isIndicating(this.getName())&&this.abortIndRequest(),SYNO.Finder.Mgr.statusMgr.registerIndicating(this.getName());var i=this.parser.parse({keyword:SYNO.Finder.Utils.ConstructKeyword(SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword","")),criteria_list:SYNO.Finder.Utils.ConstructSearchCriteriaList(SYNO.Finder.Mgr.statusMgr.getData("currentSearchCriteria",[]))});this.indRequest=this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Indicate",method:"indicate",version:1,scope:this,params:this.parser.parse({file_type:["file","document","audio","image","video"],keyword:i.keyword,criteria_list:i.criteria_list,search_weight_list:this.getSearchWeights()||[]}),callback:function(t,e){if(SYNO.Finder.Mgr.statusMgr&&!Ext.isEmpty(e)){var i=0;SYNO.Finder.Mgr.statusMgr.unregisterIndicating(this.getName());for(var n in e)e.hasOwnProperty(n)&&(SYNO.Finder.Mgr.statusMgr.applyIndicator(n,!!e[n]),i+=!!e[n]);SYNO.Finder.Mgr.statusMgr.applyIndicator("all",i).fireEvent("indicatorUpdated",this.getName());var r=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory","all");"all"===r&&(r="file"),!1===e.success?SYNO.Finder.Mgr.statusMgr.fireEvent("searchTotalAdd",this.getName(),0):Ext.isDefined(e[r])&&SYNO.Finder.Mgr.statusMgr.fireEvent("searchTotalAdd",this.getName(),e[r])}}})},resetIndicatorStatus:function(){SYNO.Finder.Mgr.statusMgr.resetIndicator("file").resetIndicator("document").resetIndicator("audio").resetIndicator("image").resetIndicator("video").fireEvent("indicatorUpdated")},needToUpdateResultList:function(){return["all","file","document","image","audio","video"].indexOf(SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory",null))>=0},abortIndRequest:function(){try{this.indRequest&&this.indRequest.conn&&this.indRequest.conn.abort()}catch(t){SYNO.Debug.error(t)}},onSearchFieldCleared:function(){this.abortIndRequest(),SYNO.Finder.Mgr.statusMgr.resetIndicator(),SYNO.Finder.Mgr.statusMgr.fireEvent("indicatorUpdated",this.getName()),this.callParent(arguments)}}),Ext.ns("SYNO.Finder.Searcher"),Ext.define("SYNO.Finder.Searcher.Help",{extend:"SYNO.Finder.Searcher.Base",apiName:"SYNO.Core.UISearch",apiMethod:"uisearch",apiVersion:1,getName:function(){return"help"},processSearchResp:function(t){var e=[];return Ext.each(t.items,function(t){try{e.push({listItemIconCls:this.getIconCls(t),listItemTitle:this.getTitle(t),listItemSubtitle:this.getSubtitle(t),previewCardID:this.getPreviewCardID(t),previewMeta:this.getPreviewMeta(t),previewItemSrc:this.getPreviewItemSrc(t),launchAppData:this.getLaunchAppData(t),extraData:this.getExtraData(t)})}catch(t){SYNO.Finder.Utils.error("processSearchResp error:",t)}},this),this.BASIC_LOAD_ENTRIES>e.length||this.from+this.BASIC_LOAD_ENTRIES===t.total?(this.reachEnd=!0,SYNO.Finder.Mgr.statusMgr.fireEvent("searchReachEnd",this.getName())):this.from+=e.length,e},getSearchParams:function(){return{query:SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword",""),type:"help",lang:_S("lang"),offset:this.from,limit:this.BASIC_LOAD_ENTRIES}},getIconCls:function(t){return"txt"},getTitle:function(t){return t.topic},getSubtitle:function(t){return SYNO.SDS.Utils.GetAppTitle(t.owner)},getPreviewCardID:function(t){return"thumbnail"},getPreviewMeta:function(t){return[{name:SYNO.Finder.Utils._T("common","meta_title"),content:t.topic},{name:SYNO.Finder.Utils._T("common","help_category"),content:SYNO.SDS.Utils.GetAppTitle(t.owner)}]},getPreviewItemSrc:function(t){return"webman/3rdparty/SynoFinder/images/filetype/128/txt.png"},getLaunchAppData:function(t){return{className:"SYNO.SDS.HelpBrowser.Application",params:{topic:t.id}}},getExtraData:function(t){return{type:"help"}}}),Ext.ns("SYNO.Finder.Searcher"),Ext.define("SYNO.Finder.Searcher.Application",{extend:"SYNO.Finder.Searcher.Base",apiName:"SYNO.Finder.AppIndexing.Search",apiMethod:"search",apiVersion:1,getName:function(){return"app"},processSearchResp:function(t){var e=[];return Ext.each(t.hits,function(t){try{e.push({listItemIconSrc:this.getIconSrc(t),listItemTitle:this.getTitle(t),listItemSubtitle:this.getSubtitle(t),contextItemIconSrc:this.getIconSrc(t),contextItemTitle:this.getTitle(t),contextItemSnippet:this.getDescription(t),previewCardID:this.getPreviewCardID(t),previewMeta:this.getPreviewMeta(t),previewItemSrc:this.getPreviewItemSrc(t),launchAppData:this.getLaunchAppData(t),extraData:this.getExtraData(t)})}catch(t){SYNO.Finder.Utils.error("processSearchResp error:",t)}},this),this.BASIC_LOAD_ENTRIES>e.length||this.from+this.BASIC_LOAD_ENTRIES===t.total?(this.reachEnd=!0,SYNO.Finder.Mgr.statusMgr.fireEvent("searchReachEnd",this.getName())):this.from+=e.length,e},getSearchParams:function(){return{keyword:SYNO.Finder.Utils.ConstructKeyword(SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword","")),lang:_S("lang"),from:this.from,size:this.BASIC_LOAD_ENTRIES,search_weight_list:this.getSearchWeights()||[]}},getSearchWeights:function(){return[{field:"SYNOMDWildcard",weight:1},{field:"keywords",weight:5},{field:"search_title",weight:10}]},getIconSrc:function(t){return SYNO.SDS.Utils.GetAppIcon(t.owner||SYNO.SDS.Utils.ParseSearchID(t.id).className,"TreeIcon")},getTitle:function(t){return t.title},getSubtitle:function(t){return SYNO.SDS.Utils.GetAppTitle(t.owner)},getDescription:function(t){return String.format(t.desc,_D("product"))},getPreviewCardID:function(t){return"thumbnail"},getPreviewMeta:function(t){return[{name:SYNO.Finder.Utils._T("common","name"),content:t.title},{name:SYNO.Finder.Utils._T("common","meta_owner"),content:SYNO.SDS.Utils.GetAppTitle(t.owner)},{name:SYNO.Finder.Utils._T("common","meta_description"),content:String.format(t.desc,_D("product"))},{name:SYNO.Finder.Utils._T("common","installed_pkg_version"),content:SYNO.SDS.Config.FnMap[t.id.match(/([^?]*)/)[0]].config.version}]},getPreviewItemSrc:function(t){return SYNO.SDS.Utils.GetAppIcon(t.owner||SYNO.SDS.Utils.ParseSearchID(t.id).className,"FinderPreview")},getLaunchAppData:function(t){return SYNO.SDS.Utils.ParseSearchID(t.id)},getExtraData:function(t){return{type:"app"}}}),Ext.define("SYNO.Finder.Searcher.Package",{extend:"SYNO.Finder.Searcher.Base",constructor:function(t){Ext.apply(this,t||{});var e=this.inner_plugin.getSearchAPI();this.apiName=e.api,this.apiMethod=e.method,this.apiVersion=e.version,this.callParent(arguments)},getSearchParams:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword",""),e=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCriteria",[]),i=[];Ext.iterate(e,function(t){i.push(t.json.value)});var n=this.parser.parse({keyword:t,plugin_criteria:i});return this.inner_plugin.getSearchParam(n.keyword,this.from,this.BASIC_LOAD_ENTRIES,n.plugin_criteria)},processSearchResp:function(t){var e=this.inner_plugin.getSearchResults(t);return this.from+=e.length,this.reachEnd=e.length<this.BASIC_LOAD_ENTRIES||this.from>=t.total,this.reachEnd&&SYNO.Finder.Mgr.statusMgr.fireEvent("searchReachEnd",this.getName()),SYNO.Finder.Utils.debug("search results:",this.getName(),e),e},getName:function(){return this.inner_plugin.getPluginId()}}),Ext.ns("SYNO.Finder.Spotlight.Searcher"),Ext.define("SYNO.Finder.Spotlight.Searcher.Base",{extend:"SYNO.Finder.Searcher.Base",BASIC_LOAD_ENTRIES:5,constructor:function(t){Ext.apply(this,t||{}),this.callParent(arguments),this.apiRequest=null},initEvents:function(){this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"searchNeeded",this.onSearchNeeded,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"searchbarclear",this.abortAPIRequest,this)},isSearchNeeded:function(){return!0},onSearchNeeded:function(){this.isSearchNeeded()&&(SYNO.Finder.Spotlight.Mgr.statusMgr.isSearching(this.getName())&&this.abortAPIRequest(),SYNO.Finder.Spotlight.Mgr.statusMgr.registerSearching(this.getName()),this.search())},sendSearchWebAPI:function(t,e){SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("doSearch");var i={scope:this,callback:function(t,i){SYNO.Finder.Spotlight.Mgr.statusMgr&&(t?i=this.topHitProcess(i):(i.isTimeout?SYNO.Finder.Utils.alert(SYNO.Finder.Spotlight.core.appWindow,SYNO.Finder.Utils._T("common","search_timeout")):SYNO.Finder.Utils.alert(SYNO.Finder.Spotlight.core.appWindow,SYNO.Finder.Utils.getWebAPIErrStr(i)),i=[]),SYNO.Finder.Spotlight.Mgr.statusMgr.unregisterSearching(this.getName()).fireEvent("searchDone",this.getName(),this.processSearchResp(i),e))}};Ext.isArray(t)?i.compound={params:t}:(i.api=this.apiName,i.method=this.apiMethod,i.version=this.apiVersion,i.params=t,i.timeout=3e5),this.apiRequest=this.sendWebAPI(i)},topHitProcess:Ext.emptyFn,getName:Ext.emptyFn}),Ext.ns("SYNO.Finder.Spotlight.Searcher"),Ext.define("SYNO.Finder.Spotlight.Searcher.File",{extend:"SYNO.Finder.Spotlight.Searcher.Base",apiName:"SYNO.Finder.FileIndexing.Search",apiMethod:"search",apiVersion:1,getName:function(){return"spotlight-file"},initEvents:function(){this.callParent(arguments),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,{changeSearchType:this.onChangeSearchType,scope:this})},onChangeSearchType:function(){"all"===SYNO.Finder.Spotlight.Mgr.statusMgr.getData("searchType","all")?this.BASIC_LOAD_ENTRIES=5:this.BASIC_LOAD_ENTRIES=10},processSearchResp:function(t){var e=[];return Ext.each(t.hits,function(t){try{e.push({listItemIconCls:this.getIconCls(t),listItemTitle:this.getBasename(t),filetypeDefaultIcon:this.getThumbnailDefaultIcon(t),audioCoverSrc:this.getAudioCoverSrc(t),previewMeta:this.getPreviewMeta(t),
extraData:this.getExtraData(t)})}catch(t){SYNO.Finder.Utils.error("processSearchResp error:",t)}},this),this.BASIC_LOAD_ENTRIES>e.length?this.reachEnd=!0:this.from+=e.length,e},topHitProcess:function(t){var e=t.hits,i=[];return i=e.splice(1,e.length-1),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("addTophit",this.processSearchResp({hits:e})),{hits:i}},getSearchParams:function(){var t=SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchKeyword",""),e=SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchCriteria",[]),i=this.parser.parse({keyword:SYNO.Finder.Utils.ConstructKeyword(t),criteria_list:SYNO.Finder.Utils.ConstructSearchCriteriaList(e)});return{agent:"search_now",query_id:SYNO.Finder.Spotlight.Mgr.searchMgr.getQueryID(),query_serial:SYNO.Finder.Spotlight.Mgr.searchMgr.getQuerySerial(),indice:[],keyword:i.keyword,orig_keyword:t,criteria_list:i.criteria_list,from:this.from,size:this.BASIC_LOAD_ENTRIES,fields:this.getSearchFields(),file_type:this.getSearchFileType(),search_weight_list:this.getSearchWeights()||[]}},getSearchFileType:function(){var t=SYNO.Finder.Spotlight.Mgr.statusMgr.getData("searchType","all");switch(t){case"all":return"";default:return t}},getSearchWeights:function(){return[{field:"SYNOMDWildcard",weight:1},{field:"SYNOMDTextContent",weight:1},{field:"SYNOMDSearchFileName",weight:8.5}]},getSearchFields:function(){return["SYNOMDAcquisitionMake","SYNOMDAcquisitionModel","SYNOMDAlbum","SYNOMDAperture","SYNOMDAudioBitRate","SYNOMDAudioTrackNumber","SYNOMDAuthors","SYNOMDCodecs","SYNOMDContentCreationDate","SYNOMDContentModificationDate","SYNOMDCreator","SYNOMDDurationSecond","SYNOMDExposureTimeString","SYNOMDExtension","SYNOMDFSCreationDate","SYNOMDFSName","SYNOMDFSSize","SYNOMDISOSpeed","SYNOMDLastUsedDate","SYNOMDMediaTypes","SYNOMDMusicalGenre","SYNOMDOwnerUserID","SYNOMDOwnerUserName","SYNOMDRecordingYear","SYNOMDResolutionHeightDPI","SYNOMDResolutionWidthDPI","SYNOMDTitle","SYNOMDVideoBitRate","SYNOMDIsEncrypted"]},getIconCls:function(t){if("y"!==t.SYNOMDIsDir){var e=SYNO.Finder.Utils.NormalizeExtension(t.SYNOMDExtension);return"y"===t.SYNOMDIsEncrypted&&(e+="_encrypted"),e}return!0===t.additional.is_mount_point?"remotemountpoint":"folder"},getBasename:function(t){return t.SYNOMDFSName},getThumbnailDefaultIcon:function(t){var e;return"y"===t.SYNOMDIsDir?e=!0===t.additional.is_mount_point?"remotemountpoint":"folder":(e=SYNO.Finder.Utils.NormalizeExtension(t.SYNOMDExtension),"y"===t.SYNOMDIsEncrypted&&(e+="_encrypted")),String.format("webman/3rdparty/SynoFinder/images/filetype/{0}/"+e+".png",128*(1+SYNO.SDS.UIFeatures.test("isRetina")))},getPreviewMeta:function(t){return SYNO.Finder.Utils.getFilePreviewMeta(t,!0)},getAudioCoverSrc:function(t){return SYNO.Finder.Utils.getThumbnailURL(t.SYNOMDSharePath,"large")},getExtraData:function(t){return{isDir:"y"===t.SYNOMDIsDir,path:t.SYNOMDPath,sharePath:t.SYNOMDSharePath,readable:t.readable,previewItemSrc:SYNO.Finder.Utils.getThumbnailURL(t.SYNOMDSharePath,"large"),highlightFullPath:t.SYNOMDPath,highlightDocId:t.additional.doc_id,highlightKeyword:t.additional.keyword,highlightExtension:t.SYNOMDExtension}}}),Ext.ns("SYNO.Finder.Mgr"),Ext.define("SYNO.Finder.Mgr.Search",{extend:"Ext.Component",constructor:function(){this.callParent(arguments),this.initSearcherList(),this.createPluginSearchController(),this.initEvents()},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,"searchKeywordChanged",this.fireSearchEvent,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchKeywordPressEnter",this.fireSearchEvent,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchCategoryChanged",this.onSearchCategoryChanged,this),this.mon(SYNO.Finder.Mgr.statusMgr,"bookmarkapply",this.onBookmarkApply,this),this.mon(SYNO.Finder.Mgr.pluginMgr,"pluginadd",this.onAddPlugin,this),this.mon(SYNO.Finder.Mgr.pluginMgr,"pluginremove",this.onRemovePlugin,this)},initSearcherList:function(){this.searcherList={file:new SYNO.Finder.Searcher.File({parser:new SYNO.Finder.Parser.QueryParser}),help:new SYNO.Finder.Searcher.Help,app:new SYNO.Finder.Searcher.Application}},onSearchCategoryChanged:function(){(SYNO.Finder.Mgr.statusMgr.getData("currentSearchCriteria",[]).length||SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword",""))&&SYNO.Finder.Mgr.statusMgr.fireEvent("searchNeeded",!0)},fireSearchEvent:function(){(SYNO.Finder.Mgr.statusMgr.getData("currentSearchCriteria",[]).length||SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword",""))&&(SYNO.Finder.Mgr.statusMgr.resetIndicator("all"),SYNO.Finder.Mgr.statusMgr.fireEvent("searchNeeded"))},createPluginSearchController:function(){Ext.each(SYNO.Finder.Mgr.pluginMgr.getPlugins(),function(t){this.onAddPlugin(t)},this)},onBookmarkApply:function(t){SYNO.Finder.Mgr.statusMgr.applyData({currentSearchKeyword:t.get("keyword"),currentSearchCriteria:t.get("criteria")}).fireEvent("searchNeeded")},onAddPlugin:function(t){var e=t.getPluginId();this.searcherList.hasOwnProperty(e)||(this.searcherList[e]=new SYNO.Finder.Searcher.Package({parser:new SYNO.Finder.Parser.QueryParser,inner_plugin:t}))},onRemovePlugin:function(t){this.searcherList.hasOwnProperty(t)&&delete this.searcherList[t]},getQueryID:function(){return Ext.isEmpty(this.queryID)&&(this.queryID=SYNO.Finder.Utils.getRandomString()),this.queryID},getQuerySerial:function(){return this.querySerial||(this.querySerial=0),this.querySerial+=1,this.querySerial},getTotalSearcherCount:function(){var t=0;for(var e in this.searcherList)this.searcherList.hasOwnProperty(e)&&t++;return t},getTotalNeededSearcherCount:function(){var t=0;for(var e in this.searcherList)this.searcherList.hasOwnProperty(e)&&(t+=this.searcherList[e].needToUpdateResultList());return t},mapCategoryToSearcherName:function(t){return 0<=["file","document","image","audio","video"].indexOf(t)?"file":t}}),Ext.define("SYNO.Finder.Action.Base",{check:function(t,e){return!1},dbclick:function(t,e){return!1},doAction:function(t,e,i){},getText:function(t){return this.text||""},getIconCls:function(){return this.iconCls||""},getItemId:function(){return this.itemId||""}}),Ext.define("SYNO.Finder.Action.Wrapper",{constructor:function(t){Ext.apply(this,t||{}),this.callParent(arguments)},check:function(t,e){return!(!this.action||!Ext.isFunction(this.action.check))&&(this.action.check(t,e)||!1)},dbclick:function(t,e){return!(!this.action||!Ext.isFunction(this.action.dbclick))&&this.action.dbclick(t,e)},doAction:function(t,e,i){return!(!this.action||!Ext.isFunction(this.action.doAction))&&this.action.doAction(t,e,i)},getText:function(){return this.action&&Ext.isFunction(this.action.getText)?this.action.getText():""},getIconCls:function(){return this.action&&Ext.isFunction(this.action.getIconCls)?this.action.getIconCls():""},getItemId:function(){return this.action&&Ext.isFunction(this.action.getItemId)?this.action.getItemId():""}}),Ext.define("SYNO.Finder.Action.OpenFileStation",{extend:"SYNO.Finder.Action.Base",constructor:function(t){this.text=SYNO.Finder.Utils._T("action","open_filestation"),this.iconCls="",this.actionId="open_filestation"},check:function(t,e){if(!SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.App.FileStation3.Instance"))return!1;if(!Ext.isArray(t)||1!==t.length||-1===["all","file","document","image","audio","video"].indexOf(e))return!1;var i=t[0].get("extraData");return!(!i||!i.sharePath)},dbclick:function(t,e){return!0},doAction:function(t,e){var i=t[0].get("extraData");SYNO.SDS.AppLaunch("SYNO.SDS.App.FileStation3.Instance",i.isDir?{opendir:i.sharePath}:{openfile:i.sharePath})}}),Ext.define("SYNO.Finder.Action.Download",{extend:"SYNO.Finder.Action.Base",constructor:function(t){this.text=SYNO.Finder.Utils._T("action","download"),this.iconCls="",this.itemId="download"},getIconCls:function(){return""},check:function(t,e){if(!Ext.isArray(t)||1!==t.length||-1===["all","file","document","image","audio","video"].indexOf(e))return!1;var i=t[0].get("extraData");return!!(i&&i.sharePath&&i.readable)&&!t[0].get("extraData").isDir},doAction:function(t,e,i){var n=t[0].get("extraData").sharePath,r=n.split("/").pop(),s={api:"SYNO.Finder.File",method:"get",version:1,params:{path:[n]}},a=SYNO.API.GetBaseURL(s,!1,r);SYNO.SDS.Utils.IFrame.request(a,function(t){"timeout"!==t&&i.getMsgBox().alert("",SYNO.Finder.Utils._T("error","error_privilege_not_enough"))},this)}}),Ext.define("SYNO.Finder.Action.OpenInNewWin",{extend:"SYNO.Finder.Action.Base",constructor:function(t){this.text=SYNO.Finder.Utils._T("action","open_in_new_window"),this.iconCls="",this.itemId="open_in_new_winow"},getIconCls:function(){return""},check:function(t,e){if(!Ext.isArray(t)||1!==t.length||-1===["all","file","document","image","audio","video"].indexOf(e))return!1;var i=t[0].get("extraData");return!!(i&&i.sharePath&&i.readable)&&!t[0].get("extraData").isDir},replaceDLNameSpecChars:function(t){var e=Ext.isWindows?/[\/\\\:\?\>\<\*\"\|]/g:/[\/\\\:]/g;return t.replace(e,"-")},bin2hex:function(t){t=SYNO.webfm.utils.utfencode(t);var e,i=0,n=[];for(t+="",i=t.length,e=0;e<i;e++)n[e]=t.charCodeAt(e).toString(16).replace(/^([\da-f])$/,"0$1");return n.join("")},doAction:function(t,e,i){var n,r,s=t[0].get("extraData").sharePath,a=s.split("/").pop();n=this.replaceDLNameSpecChars(a);r=String.format('fbdownload/{0}?_sid="{1}"&mode=open&dlink="{2}"&stdhtml=true',encodeURIComponent(n),encodeURIComponent(Ext.util.Cookies.get("id")),this.bin2hex(s)),r=Ext.urlAppend(r),window.open(r)}}),Ext.define("SYNO.Finder.Action.LaunchApplication",{extend:"SYNO.Finder.Action.Base",constructor:function(){this.text=SYNO.Finder.Utils._T("action","launch_app"),this.iconCls="",this.itemId="launch_app"},check:function(t,e){if(!Ext.isArray(t)&&1!==t.length)return!1;var i=t[0].get("launchAppData");return!!(i&&i.className&&i.params)&&("app"===t[0].get("extraData").type||"app"===e)},dbclick:function(t,e){return this.check.apply(this,arguments)},doAction:function(t,e){var i=t[0].get("launchAppData");SYNO.SDS.AppLaunch(i.className,i.params)},getText:function(t){return Ext.isEmpty(t)?this.text:String.format(t[0].get("extraData")&&t[0].get("extraData").launchText||this.text,t[0].get("listItemTitle"))}}),Ext.define("SYNO.Finder.Action.OpenHelpManager",{extend:"SYNO.Finder.Action.Base",constructor:function(){this.text=SYNO.Finder.Utils._T("action","launch_help"),this.iconCls="",this.itemId="launch_help"},check:function(t,e){if(!Ext.isArray(t)&&1!==t.length)return!1;var i=t[0].get("launchAppData");return!!(i&&i.className&&i.params)&&("help"===t[0].get("extraData").type&&"all"===e||"help"===e)},dbclick:function(t,e){return this.check.apply(this,arguments)},doAction:function(t,e){var i=t[0].get("launchAppData");SYNO.SDS.AppLaunch(i.className,i.params)}}),Ext.define("SYNO.Finder.Action.ExternViewer",{extend:"SYNO.Finder.Action.Base",supportedExt:{},constructor:function(){SYNO.SDS.QuickConnect.Utils.getPortalUrl(SYNO.SDS.QuickConnect.Utils.TYPES.DIRECT,this.onGetPortalUrlDone,this)},onGetPortalUrlDone:function(t,e){t&&(this.portalUrl=e)},check:function(t,e){if(1!==t.length)return!1;var i=t[0].get("listItemTitle");return i&&i.substr(i.lastIndexOf(".")+1)in this.supportedExt},dbclick:function(t,e){return!1},checkFileSize:function(t){var e=t.get("listItemTitle"),i=e.substr(e.lastIndexOf(".")+1);return t.get("extraData")&&t.get("extraData").size<=this.supportedExt[i]},doAction:function(t,e,i){var n=this.getDownloadLink(t[0].get("extraData").sharePath,t[0].get("listItemTitle"));return n?this.checkFileSize(t[0])?void window.open(this.externURL+encodeURIComponent(n)):void this.showExceedMaxFileSizePrompt(i):void this.showQuickConnectPrompt(i)},showQuickConnectPrompt:function(t){var e=_S("standalone")||!_S("is_admin")?_T("error","quickcnt_warning"):_T("error","quickcnt_alert");t.getMsgBox().alert(_T("filebrowser","oviewer"),e,_S("standalone")?function(){}:function(t){"ok"==t&&SYNO.SDS.AppLaunch("SYNO.SDS.AdminCenter.Application",{fn:"SYNO.SDS.AdminCenter.QuickConnect.Main"})},t)},showExceedMaxFileSizePrompt:function(t){var e=t.getMsgBox().confirm();e.fbButtons.yes.handler=function(){e.close()},e.confirm(_T("filebrowser","gviewer"),_T("filebrowser","gviewer_bigsize"),function(t){},t)},getDownloadLink:function(t,e){var i,n,r,s;if(i=SYNO.SDS.Utils.Network.getExternalHostName(!0),SYNO.SDS.Utils.Network.checkExternalIP(i))r=window.location.protocol+"//"+i,n=window.location.port,_S("rewrite_mode")||(n="https:"===window.location.protocol?_S("external_port_dsm_https")&&""!==_S("external_port_dsm_https")?_S("external_port_dsm_https"):window.location.port:_S("external_port_dsm_http")&&""!==_S("external_port_dsm_http")?_S("external_port_dsm_http"):window.location.port),n&&(r+=":"+n),s=this.getDownloadLinkByHostName(r,t,e);else{if(!this.portalUrl)return!1;s=this.getDownloadLinkByHostName(this.portalUrl,t,e)}return s},getDownloadLinkByHostName:function(t,e,i){var n,r;return n=Ext.util.Cookies.get("id"),r=String.format("{0}/viewer/{1}/{2}/{3}/{4}",t,SYNO.SDS.Utils.bin2hex(e),encodeURIComponent(n),_S("SynoToken")||"token",encodeURIComponent(i)),r=r.replace("//viewer","/viewer")}}),Ext.define("SYNO.Finder.Action.GoogleViewer",{extend:"SYNO.Finder.Action.ExternViewer",supportedExt:{doc:26214400,docx:26214400,ppt:26214400,pptx:26214400,xls:26214400,xlsx:26214400,pdf:26214400,tif:26214400,tiff:26214400,svg:26214400,ai:26214400,eps:26214400},externURL:"https://docs.google.com/viewer?url=",getText:function(){return _T("filebrowser","opendocmenu")},getItemId:function(){return"syno-finder-action-googleviewer"},getIconCls:function(){}}),Ext.define("SYNO.Finder.Action.OfficeViewer",{extend:"SYNO.Finder.Action.ExternViewer",supportedExt:{doc:10485760,docx:10485760,dotx:10485760,pptx:10485760,ppt:10485760,pps:10485760,ppsx:10485760,xls:5242880,xlsx:5242880,xlsb:5242880,xlsm:5242880},externURL:"https://view.officeapps.live.com/op/view.aspx?src=",getText:function(){return _T("filebrowser","openofficemenu")},getItemId:function(){return"syno-finder-action-officeviewer"},getIconCls:function(){}}),Ext.define("SYNO.Finder.Action.PDFViewer",{constructor:function(){SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.DocumentViewer.Application")?SYNO.SDS.JSLoad("SYNO.SDS.DocumentViewer.Application",function(t){this.isDocumentViewer=!0},this):SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.PDFViewer.Application")&&SYNO.SDS.JSLoad("SYNO.SDS.PDFViewer.Application",function(t){this.isPDFViewer=!0},this)},getText:function(){return this.isDocumentViewer&&_TT("SYNO.SDS.DocumentViewer.Application","general","open_by_docviewer")||_TT("SYNO.SDS.PDFViewer.Application","pdfviewer","open_by_pdfviewer")},getItemId:function(){return"pdfviewer-finder-action-open"},getIconCls:function(){return""},check:function(t,e){if(!SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.PDFViewer.Application")||1!==t.length)return!1;var i=t[0].get("extraData");if(Ext.isEmpty(i)||Ext.isEmpty(i.sharePath))return!1;var n=i.sharePath.split(".").pop().toLowerCase();return"pdf"===n||this.isDocumentViewer&&SYNO.Finder.Utils.SupportDocumentViewerThumbnailExt.indexOf(n)>=0},dbclick:function(t,e){return!1},doAction:function(t,e,i){var n=SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword","").split(" ");SYNO.SDS.AppLaunch("SYNO.SDS.PDFViewer.Application",Ext.apply({path:t[0].get("extraData").sharePath.replace(/^\/home\//,"/homes/"+_S("user")+"/")},n.length?{query:n[0]}:{}))}}),Ext.define("SYNO.Finder.Action.AudioPlayerPlay",{extend:"SYNO.Finder.Action.Base",supportedExt:["mp3","m4a","m4b","aac","ogg","wav","flac","ape","aiff","aif","wma","m3u"],getText:function(){return _T("audio_player","menu_play")},getItemId:function(){return"audio-player-finder-action-play"},getIconCls:function(){},check:function(t,e){var i=!0;return Ext.each(t,function(t){var e=t.get("extraData");if(Ext.isEmpty(e)||Ext.isEmpty(e.sharePath)||Ext.isEmpty(e.path)||this.supportedExt.indexOf(e.sharePath.split(".").pop().toLowerCase())<0)return i=!1,!1},this),i},dbclick:function(t,e){return!1},doAction:function(t,e,i){if(SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.AudioPlayer.Application")){var n=[];Ext.each(t,function(t){n.push(new Ext.data.Record({filename:t.get("listItemTitle"),file_id:t.get("extraData").sharePath,type:"file"}))},this),SYNO.SDS.AppLaunch("SYNO.SDS.AudioPlayer.Application",{fb_recs:n})}}}),Ext.define("SYNO.Finder.Action.AddtoAudioPlayer",{extend:"SYNO.Finder.Action.AudioPlayerPlay",getText:function(){return _T("audio_player","add_file")},getItemId:function(){return"audio-player-finder-action-addtoqueue"},getIconCls:function(){},doAction:function(t,e,i){if(SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.AudioPlayer.Application")){var n=[];Ext.each(t,function(t){n.push(new Ext.data.Record({filename:t.get("listItemTitle"),file_id:t.get("extraData").sharePath,type:"file"}))},this),SYNO.SDS.AppLaunch("SYNO.SDS.AudioPlayer.Application",{fb_param:"add",fb_recs:n})}}}),Ext.define("SYNO.Finder.Action.TextEditorAction",{extend:"SYNO.Finder.Action.Base",constructor:function(){SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.TextEditor.Application")&&SYNO.SDS.JSLoad("SYNO.TextEditor.Utils")},getText:function(){return _TT("SYNO.TextEditor.Application","common","OpenWithTextEditor")},getItemId:function(){return"text-editor-finder-action"},check:function(t,e){if(!SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.TextEditor.Application")||1!==t.length)return!1;var i=t[0].get("extraData");if(Ext.isEmpty(i)||Ext.isEmpty(i.sharePath)||i.isDir)return!1;var n=i.sharePath.split(".");return 1===n.length||SYNO.TextEditor.Utils.TextFileExtensions.hasOwnProperty(n.pop().toLowerCase())},dbclick:function(t,e){return!1},doAction:function(t,e,i){SYNO.SDS.AppLaunch("SYNO.TextEditor.Application",{fb_recs:{path:t[0].get("extraData").sharePath}})},getIconCls:function(){return""}}),Ext.define("SYNO.Finder.Action.VideoPlayerAction",{extend:"SYNO.Finder.Action.Base",supportedExt:["avi","dat","mkv","vob","asf","wmv","mov","qt","divx","flv","f4v","swf","rm","rmvb","mpg","mpeg","mpeg1","m1v","mpeg2","m2v","mp2","dvr-ms","m2ts","mts","m2t","ts","tp","trp","mpeg4","m4v","mp4","3g2","3gp","3gp2","ogv","webm","mpe","xvid"],getText:function(){return _T("video_player","menu_play")},getItemId:function(){return"video-player2-finder-actionplay"},getIconCls:function(){return""},check:function(t,e){if(1!==t.length)return!1;var i=t[0].get("extraData");return!(Ext.isEmpty(i)||Ext.isEmpty(i.sharePath)||Ext.isEmpty(i.path))&&this.supportedExt.indexOf(i.sharePath.split(".").pop().toLowerCase())>=0},dbclick:function(t,e){return!1},doAction:function(t,e,i){var n=t[0].get("extraData");Ext.isDefined(SYNO.SDS.Config.FnMap["SYNO.VideoController2.SupportFileVideo"])&&!0===SYNO.SDS.StatusNotifier.isAppEnabled("SYNO.SDS.VideoStation.AppInstance")?SYNO.SDS.WindowLaunch("SYNO.VideoController2.Application",{player_id:"streaming",path:n.path,browse_type:"filevideo",video_type:"filevideo"}):SYNO.SDS.WindowLaunch("SYNO.SDS.VideoPlayer2.Application",{ieMode:9,path:n.sharePath,file_id:n.sharePath})}}),Ext.define("SYNO.Finder.Mgr.Action",{extend:"Ext.Component",actions:null,constructor:function(t){this.callParent(arguments),this.actions=[new SYNO.Finder.Action.OpenFileStation,new SYNO.Finder.Action.Download,new SYNO.Finder.Action.OpenInNewWin,new SYNO.Finder.Action.OpenHelpManager,new SYNO.Finder.Action.LaunchApplication,new SYNO.Finder.Action.GoogleViewer,new SYNO.Finder.Action.OfficeViewer,new SYNO.Finder.Action.PDFViewer,new SYNO.Finder.Action.AddtoAudioPlayer,new SYNO.Finder.Action.AudioPlayerPlay,new SYNO.Finder.Action.VideoPlayerAction,new SYNO.Finder.Action.TextEditorAction],this.loadExternActions()},loadExternActions:function(){Ext.iterate(SYNO.SDS.Config.FnMap,function(t){this.loadExternAction(t)},this)},getActions:function(){return this.actions},loadExternAction:function(t){var e=SYNO.SDS.Config.FnMap[t];if(e&&e.config&&Ext.isArray(e.config.finder_action))try{Ext.each(e.config.finder_action,function(t){SYNO.SDS.JSLoad(t,function(){var e=Ext.getClassByName(t);this.actions.unshift(new SYNO.Finder.Action.Wrapper({action:new e}))},this)},this)}catch(t){SYNO.Debug.error(t)}}}),Ext.ns("SYNO.Finder.Spotlight"),Ext.define("SYNO.Finder.Spotlight.SearchBar",{extend:"SYNO.ux.Panel",HEIGHT:48,BUFFER_TIME:100,emptyText:SYNO.Finder.Utils._T("common","search_now_placeholder"),constructor:function(t){this.magnifier=new SYNO.Finder.Spotlight.Magnifier({owner:this,width:70}),this.textField=new SYNO.ux.TextField({flex:1,height:48,enableKeyEvents:!0,margins:"0 16px 0 0",cls:"text-field",listeners:{scope:this,afterRender:this.onTextFieldAfterRender,keyup:this.onKeyUp,buffer:this.BUFFER_TIME}}),this.loadingIcon=new Ext.Container({margins:"0 16px 0 0",cls:"loading-icon",width:24,height:48});var e={floating:!0,shadow:!1,height:this.HEIGHT,width:this.WIDTH,cls:"search-bar",layout:"hbox",layoutConfig:{align:"stretch"},items:[this.magnifier,this.textField,this.loadingIcon]};this.callParent([Ext.apply(e,t)]),this.createMonitorTask(),this.createDelayTask()},initEvents:function(){this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,{updatePreview:this.onUpdatePreview,searchbarCompletion:this.onSearchBarCompletion,spotlightActivate:this.onSpotlightActivate,promptHide:this.onPromptHide,escPress:this.onEscPress,doSearch:this.onDoSearch,allSearchDone:this.onAllSearchDone,changeSearchType:this.onChangeSearchType,scope:this}),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,{updateARIA:this.onUpdateARIA,buffer:450,scope:this})},onChangeSearchType:function(t){this.emptyText="string"==typeof t&&"all"!==t?SYNO.Finder.Utils._T("common",String.format("search_{0}_now_placeholder",t)):SYNO.Finder.Utils._T("common","search_now_placeholder"),this.dummyMgr&&""===this.textField.getValue()&&this.dummyMgr.setContent(this.emptyText),this.textField.focus(),this.textField.el.setARIA({label:this.emptyText,haspopup:!1})},onUpdateARIA:function(t){this.textField.el.setARIA({activedescendant:t,haspopup:!0})},onDoSearch:function(){this.loadingIcon.addClass("searching")},onAllSearchDone:function(){this.loadingIcon.removeClass("searching")},onPromptHide:function(){this.textField.focus()},onTextFieldAfterRender:function(){this.dummyMgr||(this.dummyMgr=new SYNO.Finder.Spotlight.DummyMgr({height:this.textField.container.getHeight(),width:this.textField.el.getWidth(),renderTo:this.textField.container,alignTargetEl:this.textField.el}),this.dummyMgr.setContent(this.emptyText),this.addClass("search-now-placeholder"),Ext.ComponentMgr.register(this.dummyMgr)),this.mon(this.textField.el,"input",this.onInput,this),this.textField.focus(!1,200)},onDestroy:function(){this.monitorTask.stop(),this.monitorTask=null},onUpdatePreview:function(t){t&&this.updateContent(t.data)},onSearchBarCompletion:function(){var t=SYNO.Finder.Spotlight.core.getCurrentItem();if(t&&t.get&&t.get("listItemTitle")){var e=t.get("listItemTitle");this.textField.setValue(e),this.dummyMgr.updateContent(e,""),SYNO.Finder.Spotlight.Mgr.statusMgr.applyData({currentSearchKeyword:e}).fireEvent("searchKeywordChanged",e)}},onSpotlightActivate:function(){this.monitorTask.start(),this.textField.focus(!0,200)},onInput:function(t,e){if(SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("searchBarInput"),this.delayedTask.cancel(),""===this.textField.getValue().trim())return void this.handleSearchBarEmpty();this.removeClass("search-now-placeholder"),this.updateDummy(e.value)},onKeyUp:function(t,e){if(e.keyCode&&(!e.isSpecialKey()||e.keyCode===e.BACKSPACE||e.keyCode===e.DELETE)){var i=t.getValue().trim();if(this.delayedTask.cancel(),!i)return void this.handleSearchBarEmpty();this.updateDummy(i),this.removeClass("search-now-placeholder"),i!==SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchKeyword","")&&this.fireSearchKeywordChangedEvent(i)}},onMonitorKeyword:function(){var t=this.textField.getValue().trim();t&&t!==SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchKeyword","")&&this.delayedTask.delay(250,this.fireSearchKeywordChangedEvent,this,[t])},onEscPress:function(){SYNO.Finder.Spotlight.Mgr.statusMgr.applyData({currentSearchKeyword:""}),this.textField.el.setARIA({haspopup:!1,label:this.emptyText,activedescendant:!1}),this.textField.blur(),this.textField.reset(),this.textField.focus(),this.onInput()},createMonitorTask:function(){this.monitorTask=this.addTask({id:"monitor_task",interval:300,run:this.onMonitorKeyword,scope:this})},createDelayTask:function(){this.delayedTask=new Ext.util.DelayedTask(this.fireSearchKeywordChangedEvent,this)},fireSearchKeywordChangedEvent:function(t){SYNO.Finder.Spotlight.Mgr.statusMgr.applyData({currentSearchKeyword:t}).fireEvent("searchKeywordChanged",t),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("hideCatMenu")},updateContent:function(t){t&&this.dummyMgr&&this.dummyMgr.updateContent(this.textField.getValue(),t)},handleSearchBarEmpty:function(){SYNO.Finder.Spotlight.Mgr.statusMgr.applyData({currentSearchKeyword:""}).fireEvent("searchbarclear"),this.addClass("search-now-placeholder"),this.loadingIcon.removeClass("searching"),this.dummyMgr.setContent(this.emptyText)},updateDummy:function(t){this.dummyMgr.updateContent(t)},clearDummy:function(){this.dummyMgr.clearContent()},getFiletypeTemplate:function(){return new Ext.XTemplate('<tpl if="listItemIconCls">','<div class="{listItemIconCls:htmlEncode}"></div>',"</tpl>",'<tpl if="filetypeIndicatorIconSrc">','<span class="helper"></span><img src="{filetypeIndicatorIconSrc:htmlEncode}">',"</tpl>")},getValue:function(){return this.textField.getValue()}}),Ext.define("SYNO.Finder.Spotlight.DummyMgr",{extend:"Ext.Container",constructor:function(t){this.suggestion=new SYNO.Finder.Spotlight.DummySuggestion({itemId:"suggestion"});var e={layout:"card",activeItem:0,cls:"dummy-searchfield",items:[this.suggestion],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},onAfterRender:function(){this.el.alignTo(this.alignTargetEl,"tl-tl")},switchTo:function(t){"suggestion"!==t&&"detail"!==t||this.getLayout().setActiveItem(t)},setContent:function(t){this.suggestion.updateContent("",t)},updateContent:function(t,e){var i=e&&e.listItemTitle||"";i=0===i.toLowerCase().indexOf(t.toLowerCase().trim())?i.substr(t.trim().length):"",this.suggestion.updateContent(t,i)},clearContent:function(){this.suggestion.updateContent("","")}}),Ext.define("SYNO.Finder.Spotlight.DummyBase",{extend:"Ext.Container",constructor:function(t){var e={tpl:this.getTemplate()};this.callParent([Ext.apply(e,t)])},updateContent:Ext.emptyFn,setDummy:function(t){this.update({dummy:t})}}),Ext.define("SYNO.Finder.Spotlight.DummySuggestion",{extend:"SYNO.Finder.Spotlight.DummyBase",constructor:function(t){var e={cls:"suggestion"};this.callParent([Ext.apply(e,t)])},getTemplate:function(){return new Ext.XTemplate('<span class="dummy">{dummy:htmlEncode}</span>{content:htmlEncode}')},updateContent:function(t,e){this.update({dummy:t,content:e})}}),Ext.define("SYNO.Finder.Spotlight.Magnifier",{extend:"Ext.Container",CAT_MENU_WIDTH:200,catStore:null,constructor:function(t){var e={cls:"magnifier "+this.convertTypeToCls(SYNO.Finder.Spotlight.Mgr.statusMgr.getData("searchType","all")),listeners:{afterrender:this.onAfterRender,scope:this}};this.callParent([Ext.apply(e,t)]),this.initEvents()},initEvents:function(){this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,{hideCatMenu:this.onHideCatMenu,changeSearchType:this.onChangeSearchType,scope:this}),this.mon(Ext.getBody(),"mousedown",this.onBodyMouseDown,this)},onBodyMouseDown:function(t){t.within(this.owner.findAppWindow().el)&&!t.within(this.el)&&this.hidePanel()},onDestroy:function(){this.el.removeAnchor(),this.callParent(arguments)},onHideCatMenu:function(){this.hidePanel()},onChangeSearchType:function(t){this.removeClass(["everything","document","photo","audio","video"]).addClass([this.convertTypeToCls(t)])},onClick:function(){this.menuPanel&&this.getMenu().el.isVisible()?this.hidePanel():this.showPanel()},onMouseDown:function(){this.addClass("active")},onMouseUp:function(){this.removeClass("active")},onCatMenuClick:function(t,e){var i=this.getCatStore().getAt(e),n=SYNO.Finder.Spotlight.Mgr.statusMgr.getData("searchType","all"),r=i.get("search_type");n!==r&&(SYNO.Finder.Spotlight.Mgr.statusMgr.applyData({searchType:r}).fireEvent("changeSearchType",r),""!==SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchKeyword","")&&SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("searchNeeded")),this.hidePanel()},onAfterRender:function(){this.el.on("click",this.onClick,this),this.el.on("mousedown",this.onMouseDown,this),this.el.on("mouseup",this.onMouseUp,this)},showPanel:function(){this.getMenu().show(),this.getMenu().el.anchorTo(this.el,"tl-tl",[11,43]);var t=SYNO.Finder.Spotlight.Mgr.statusMgr.getData("searchType","all");this.getMenu().el.query(".cat-wrapper").find(function(e){t===e.getAttribute("data-type")?Ext.get(e).addClass("current"):Ext.get(e).removeClass("current")})},hidePanel:function(){this.getMenu().hide()},convertTypeToCls:function(t){switch(t){case"document":return"document";case"image":return"photo";case"video":return"video";case"audio":return"audio";default:return"everything"}},createTemplate:function(){return new Ext.XTemplate('<tpl for=".">','<div class="cat-wrapper" data-type="{search_type}">','<span class="icon {cls}"></span>',"{display}","</div>","</tpl>")},getCatStore:function(){return this.catStore||(this.catStore=new Ext.data.ArrayStore({fields:["display","search_type","cls"],data:[[SYNO.Finder.Utils._T("common","type_document"),"document","document"],[SYNO.Finder.Utils._T("common","type_photo"),"image","photo"],[SYNO.Finder.Utils._T("common","type_music"),"audio","audio"],[SYNO.Finder.Utils._T("common","type_video"),"video","video"],[SYNO.Finder.Utils._T("common","search_now_dropdown_panel_everything"),"all","everything"]]})),this.catStore},getMenu:function(){return this.menuPanel||(this.menuPanel=new SYNO.ux.Panel({cls:"syno-finder-spotlight-menu",width:this.CAT_MENU_WIDTH,layout:"fit",items:{xtype:"dataview",itemSelector:".cat-wrapper",singleSelect:!0,store:this.getCatStore(),tpl:this.createTemplate(),listeners:{click:this.onCatMenuClick,scope:this}},renderTo:Ext.getBody(),floating:!0,shadow:!1}),this.addManagedComponent(this.menuPanel)),this.menuPanel}}),Ext.define("SYNO.Finder.ResultDataView",{extend:"SYNO.ux.FleXcroll.DataView",constructor:function(t){this.callParent(arguments),this.initEvents()},initEvents:function(){this.on({click:this.onEntryClick,contextmenu:this.onShowContextMenu,dblclick:this.onDbClick,flexcroll:this.onHideMenu,selectionchange:this.onSelectionChange,scope:this})},initKeyNav:function(){this.callParent(arguments);new Ext.KeyNav(this.el,{enter:this.onEnter,scope:this})},onEnter:function(t){var e=this.getSelectedIndexes();0===e.length||Ext.isEmpty(e[0])||this.onDbClick(this,e[0])},onSelectionChange:function(t,e){if(!Ext.isEmpty(e)){var i=this.indexOf(e[0]);i<0||SYNO.Finder.Mgr.statusMgr.fireEvent("searchRecordClicked",this.store.getAt(i).data,e[0])}},onHideMenu:function(){this.contextMenu&&this.contextMenu.hide()},onEntryClick:function(t,e,i){this.onSelectEntry(this.store.getAt(e),i)},onSelectEntry:function(t,e){this.select(t,!0),SYNO.Finder.Mgr.statusMgr.applyData({currentSelectedFile:SYNO.Finder.Utils.getFileIDFromRecord(t),currentSelectedRecordIdx:this.indexOf(t)})},onShowContextMenu:function(t,e,i,n){this.contextMenu||(this.menuItems=[],Ext.each(SYNO.Finder.Mgr.actionMgr.getActions(),function(t){this.menuItems.push(new Ext.menu.Item({itemId:t.getItemId(),iconCls:t.getIconCls(),text:t.getText(),action:t,listeners:{click:this.onMenuItemClick,scope:this}}))},this),this.contextMenu=new SYNO.ux.Menu({items:this.menuItems})),this.select(e),this.onUpdateMenuItems()&&(this.onSelectEntry(this.store.getAt(e),i),this.contextMenu.showAt(n.xy))},onUpdateMenuItems:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory"),e=this.getSelectedRecords(),i=!1;return Ext.each(this.menuItems,function(n){n.action.check(e,t)?(n.setText(n.action.getText(e)),n.show(),i=!0):n.hide()},this),i},onMenuItemClick:function(t){var e=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory"),i=this.getSelectedRecords();t.action.doAction(i,e,this.findAppWindow())},
onDbClick:function(t,e){var i=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory"),n=this.getSelectedRecords(),r=n[0].get("launchAppData");if(r)return void SYNO.SDS.AppLaunch(r.className,r.params);Ext.each(SYNO.Finder.Mgr.actionMgr.getActions(),function(t){if(t.check(n,i)&&t.dbclick(n,i))return t.doAction(n,i,this.findAppWindow()),!1},this)},onUpdateFleXcroll:function(){this.el.getWidth()<=10||this.callParent(arguments)}}),Ext.define("SYNO.Finder.ViewBase",{extend:"SYNO.ux.Panel",INFINITE_LOAD_THRESHOLD:200,INFINITE_LOAD_BUFFER:500,infiniteMode:!0,infEl:null,clearStoreTimeout:null,constructor:function(t){this.dataview=new SYNO.Finder.ResultDataView({trackResetOnLoad:!1,store:this.getStore(t.itemId),singleSelect:!0,itemSelector:t.itemSelector,tpl:t.dataViewTpl,flex:1});var e={cls:t.panelCls,layout:{type:"vbox",align:"stretch"},items:[{xtype:"finder_section_title",itemId:t.itemId},this.dataview],listeners:{afterrender:this.onAfterRender,scope:this}};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.callParent(arguments),this.mon(SYNO.Finder.Mgr.statusMgr,{searchNeeded:this.onSearchNeeded,searchDone:this.onSearchDone,searchCategoryChanged:this.onSearchCategoryChanged,scope:this}),this.on("activate",this.onActivate,this),this.mon(this.dataview,"flexcroll",this.onScroll,this),this.mon(this.getStore(),"load",this.onStoreLoad,this)},onAfterRender:Ext.emptyFn,onActivate:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSelectedRecordIdx");t>=0&&this.dataview.select(t,!1,!0)},onSearchNeeded:function(){this.clearStorePoolDelay(.8*SYNO.Finder.Mgr.statusMgr.BOARD_FADE_OUT_DELAY)},onSearchDone:function(t,e,i){this.maybeClearStorePool(),this.getStore().loadData(e,i),this.isVisible()&&"file"===t&&0===this.dataview.getSelectionCount()&&this.dataview.store.findBy(function(t,e){if(SYNO.Finder.Utils.getFileIDFromRecord(t)===SYNO.Finder.Mgr.statusMgr.getData("currentSelectedFile",""))return this.dataview.onSelectEntry(t),!1},this)},onSearchCategoryChanged:function(){SYNO.Finder.Mgr.statusMgr.applyData({currentSelectedRecordIdx:-1})},onScroll:function(){var t=this.el.query("."+this.panelCls+" "+this.itemSelector+":last-child")[0];this.infiniteMode&&t&&t.offsetParent&&t.offsetParent.offsetHeight-(this.dataview.getHeight()-t.offsetParent.offsetTop)<=this.INFINITE_LOAD_THRESHOLD&&(SYNO.Finder.Mgr.statusMgr.fireEvent("loadMore",SYNO.Finder.Mgr.viewModeMgr.getSearcherNameByCategory(SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory",""))),SYNO.Finder.Utils.debug("LOAD MORE !!!"))},findInStore:function(t,e){var i,n=null;for(var r in this.storePool)if(this.storePool.hasOwnProperty(r)&&(i=this.storePool[r].find(t,e))>=0){n=this.storePool[r].getAt(i);break}return n},clearStorePool:function(){Ext.iterate(this.storePool,function(t,e){e.removeAll()})},clearStorePoolDelay:function(t){this.clearStoreTimeout=window.setTimeout(function(){this.clearStorePool()}.createDelegate(this),t||0)},maybeClearStorePool:function(){this.clearStoreTimeout&&(window.clearTimeout(this.clearStoreTimeout),this.clearStoreTimeout=null,this.clearStorePool())},getJsonStoreFields:function(){return["listItemIconSrc","listItemIconCls","listItemTitle","listItemSubtitle","detailItemIconSrc","detailItemIconCls","detailItemTitle","detailItemSubtitle","detailItemLeftInfo","detailItemRightInfo","detailItemTitleQTip","detailItemSubtitleQTip","detailItemLeftInfoQTip","detailItemRightInfoQTip","contextItemIconSrc","contextItemIconCls","contextItemTitle","contextItemSnippet","thumbnailItemTitle","thumbnailItemClassName","thumbnailItemDefaultIcon","thumbnailItemSrc","previewCardID","previewMeta","previewItemSrc","launchAppData","extraData"]},getStore:function(t){return t=t||this.itemId,this.storePool||(this.storePool={}),Ext.isDefined(this.storePool[t])||(this.storePool[t]=new Ext.data.JsonStore({fields:this.getJsonStoreFields()})),this.storePool[t]},onStoreLoad:Ext.emptyFn,onMyResize:Ext.emptyFn}),Ext.define("SYNO.Finder.ViewSectionTitle",{extend:"SYNO.ux.Panel",constructor:function(t){var e={tpl:new Ext.XTemplate('<div class="view-section-title">{title} <span class="count">{count}</span></div>'),listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)]),this.countingRunner=new Ext.util.TaskRunner,this.countString="",this.countingTask={run:this.updateCountingProgress,scope:this,interval:400}},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,{searchTotalAdd:this.onSearchTotalAdd,searchCategoryChanged:this.onSearchCategoryChanged,searchNeeded:this.onSearchNeeded,searchDone:this.onSearchDone,doSearch:this.onDoSearch,scope:this})},stopRunningTask:function(){this.runningTask&&(this.countingRunner.stop(this.runningTask),this.runningTask=null)},updateCountingProgress:function(){if(this.countString+=".",3<this.countString.length&&(this.countString=""),this.update({title:this.title,count:this.countString}),this.itemId!==SYNO.Finder.Mgr.statusMgr.getData("currentViewMode"))return!1},onDoSearch:function(t,e){e||window.setTimeout(function(){this.runningTask||this.itemId===SYNO.Finder.Mgr.statusMgr.getData("currentViewMode")&&(this.runningTask=this.countingRunner.start(this.countingTask))}.createDelegate(this),0)},onSearchNeeded:function(){this.el.setStyle({visibility:"hidden"})},onSearchDone:function(t,e,i){this.el.setStyle({visibility:"visible"})},onSearchTotalAdd:function(t,e){var i=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory","");if(SYNO.Finder.Mgr.searcherMgr.mapCategoryToSearcherName(i)===t)return this.el.isVisible(!0)&&!e?void SYNO.Finder.Mgr.statusMgr.fireEvent("noResultFound"):void(this.el.isVisible(!0)&&(this.stopRunningTask(),this.update({title:this.title,count:"("+e+")"})))},onAfterRender:function(){this.updateTitle()},onSearchCategoryChanged:function(t){this.el.setStyle({visibility:"hidden"}),this.updateTitle()},updateTitle:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory");this.title=SYNO.Finder.Mgr.viewModeMgr.getCategoryDetails()[t].title,this.update({title:this.title})},updateNumResults:function(){}}),Ext.reg("finder_section_title",SYNO.Finder.ViewSectionTitle),Ext.ns("SYNO.Finder.Spotlight"),Ext.define("SYNO.Finder.Spotlight.ResultList",{extend:"SYNO.Finder.ViewBase",WIDTH:288,BUILT_IN_SECTION:4,resultDivList:[],currentIdx:0,totalItem:0,loadedSections:0,storeCleared:!1,constructor:function(t){var e={cls:"result-list panel-gradient",width:this.WIDTH,autoFlexcroll:!0,items:this.fillItems(t),layout:"auto",bubbleEvents:["add","remove"]};this.callParent([Ext.apply(e,t)]),this.onCreatePlugins()},initEvents:function(){this.mon(this.items.get(0),"itemclick",this.select,this),this.mon(this.items.get(1),"itemclick",this.select,this),this.mon(this.items.get(2),"itemclick",this.select,this),this.mon(this.items.get(3),"itemclick",this.select,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,{dataAllLoaded:this.onDataAllLoaded,spotlightPressUp:this.onSpotlightPressUp,spotlightPressDown:this.onSpotlightPressDown,pluginremove:this.onRemovePlugin,searchNeeded:this.onSearchNeeded,scope:this}),this.mon(SYNO.Finder.Spotlight.Mgr.pluginMgr,"pluginadd",this.onAddPlugin,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"changeSearchType",this.onChangeSearchType,this)},fillItems:function(t){return[{xtype:"spotlight_section",title:SYNO.Finder.Utils._T("common","section_tophit"),cls:"section tophit-section",store:this.getStore("spotlight-tophit")},{xtype:"spotlight_section",itemId:"file_section",title:SYNO.Finder.Utils._T("common","category_all_files"),cls:"section",store:this.getStore("spotlight-file")},{xtype:"spotlight_section",title:SYNO.Finder.Utils._T("common","category_app"),cls:"section",store:this.getStore("spotlight-application")},{xtype:"spotlight_section",title:SYNO.Finder.Utils._T("common","category_help"),cls:"section",store:this.getStore("spotlight-help")},{xtype:"spotlight_showall"}]},onChangeSearchType:function(t){var e=SYNO.Finder.Utils._T("common","category_all_files");switch(t){case"document":case"video":case"photo":e=SYNO.Finder.Utils._T("common","type_"+t);break;case"audio":e=SYNO.Finder.Utils._T("common","type_music")}this.get("file_section").setTitle(e)},onSearchNeeded:function(){this.loadedSections=0,this.storeCleared=!1},onCreatePlugins:function(){Ext.each(SYNO.Finder.Spotlight.Mgr.pluginMgr.getPlugins(),function(t){this.onAddPlugin(t)},this)},onAddPlugin:function(t){var e=new SYNO.Finder.Spotlight.SectionBase({itemId:t.getPluginId(),title:t.getText(),cls:"section",store:this.getStore(t.getPluginId())});this.insert(this.items.getCount()-1,e),this.mon(e,"itemclick",this.select,this)},onRemovePlugin:function(t){this.remove(t)},onDataAllLoaded:function(t,e,i){SYNO.Finder.Utils.debug("data all loaded",t,e),this.loadedSections++,this.loadedSections>=1&&e.length&&!1===this.storeCleared&&(this.storeCleared=!0,SYNO.Finder.Spotlight.core.setState("normal"),this.clearStorePool()),this.storeCleared&&this.getStore(t).loadData(e,i),this.resultDivList=this.el.query(".syno-list-select"),this.totalItems=this.resultDivList.length,this.moveSelectionTo(0),"spotlight-tophit"===t&&(0===this.getStore(t).getCount()?this.items.get(0).hide():this.items.get(0).show()),this.checkSeparationLine();var n=this.el.query(".flexcrollactive")[0];n&&n.fleXcroll&&(n.fleXcroll.setScrollPos(0,0),this.updateFleXcroll(),this.doLayout())},onSpotlightPressUp:function(){this.moveSelection(-1)},onSpotlightPressDown:function(){this.moveSelection(1)},animatedScrollTo:function(t,e){var i=this.el.query(".flexcrollactive")[0];if(i&&i.fleXcroll&&i.fleXdata){var n=i.fleXdata.scrollPosition[1][0],r=function(){i.fleXcroll.setScrollPos(0,-1,!0)};if(n>=e)for(var s=n;s>=e;s--)setTimeout(r,100*(n-s)/(n-e))}},clearStorePool:function(t){Ext.iterate(this.storePool,function(e,i){e!==t&&i.removeAll()})},checkSeparationLine:function(){var t=!0;Ext.iterate(this.storePool,function(e,i){"spotlight-tophit"!==e&&(t=t&&!i.getCount())}),this.items.get(0)[t?"addClass":"removeClass"]("hide-separation-line")},getJsonStoreFields:function(){return["listItemIconSrc","listItemIconCls","listItemTitle","filetypeDefaultIcon","filetypeIndicatorIconSrc","audioCoverSrc","previewCardID","previewItemSrc","previewMeta","thumbnailItemDefaultIcon","extraData","launchAppData"]},adjustFlexScrollPosition:function(t){if(t.offsetParent&&t.offsetParent.parentNode){if(t.offsetTop+t.offsetParent.offsetTop<0)return void this.fleXcrollTo(t);if(t.offsetTop+t.offsetParent.offsetTop+t.offsetHeight>t.offsetParent.parentNode.offsetHeight){var e=this.el.query(".flexcrollactive")[0];if(!e)return;e.fleXcroll.scrollContent(0,t.offsetTop+t.offsetParent.offsetTop+t.offsetHeight-t.offsetParent.parentNode.offsetHeight)}}},select:function(t){if(t){var e=this,i=this.resultDivList.find(function(i,n){return(i.dataset&&i.dataset.id||i.getAttribute("data-id"))===t.get("id")&&(e.currentIdx=n,!0)});i&&(this.resultDivList.each(function(t){Ext.fly(t).removeClass("x-view-selected")}),Ext.fly(i).addClass("x-view-selected")),SYNO.Finder.Spotlight.core.setCurrentItem(t),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("updatePreview",t)}},moveSelectionTo:function(t){if(this.currentIdx=t,this.currentIdx<0)return void(this.currentIdx=0);if(this.currentIdx>=this.totalItems)return void(this.currentIdx=this.totalItems-1);if(this.resultDivList.length){this.resultDivList.each(function(t){Ext.fly(t).removeClass("x-view-selected")});var e=this.resultDivList[this.currentIdx];if(SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("updateARIA",e.id),Ext.fly(e).addClass("x-view-selected"),this.adjustFlexScrollPosition(e),e.className.indexOf("show-all-in-finder")>=0)return void SYNO.Finder.Spotlight.core.setCurrentItem(new Ext.data.Record({actionType:"showall",extraData:{sharePath:"",path:""}}));var i=this.findInStore("id",e.getAttribute("data-id"));SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("updatePreview",i),SYNO.Finder.Spotlight.core.setCurrentItem(i)}},moveSelection:function(t){this.moveSelectionTo(this.currentIdx+t)}}),Ext.define("SYNO.Finder.Spotlight.SectionBase",{extend:"Ext.Container",constructor:function(t){var e={items:[{xtype:"dataview",itemSelector:"div.list-entry",tpl:this.getTemplate(),store:t.store,singleSelect:!0,onItemClick:Ext.emptyFn,listeners:{scope:this,click:this.onItemClick,dblclick:this.onDblClick}}],bubbleEvent:["add","remove","itemclick"]};this.callParent([Ext.apply(e,t)])},onItemClick:function(t,e){this.fireEvent("itemclick",this.store.getAt(e))},onDblClick:function(t,e){SYNO.Finder.Spotlight.core.setCurrentItem(this.store.getAt(e)).openItem()},setTitle:function(t){this.title=t},getTemplate:function(){var t=this;return new Ext.XTemplate('<div class="section-title">{[this.getTitle()]}</div>','<tpl for=".">','<div id="{[this.getId(values)]}" role="option" aria-label="{[SYNO.Finder.Utils.doubleHtmlEncode(this.getTitle() + "-" + values.listItemTitle)]}" aria-selected="true" class="list-entry syno-list-select ellipsis" data-id="{id}">','<tpl if="listItemIconCls">','<div class="{listItemIconCls:htmlEncode}"></div>',"</tpl>",'<tpl if="listItemIconSrc">','<div class="icon"><img src="{listItemIconSrc:htmlEncode}"></div>',"</tpl>",'<span ext:qtip="{[SYNO.Finder.Utils.doubleHtmlEncode(values.listItemTitle)]}" class="title">{listItemTitle:htmlEncode}</span>',"</div>","</tpl>",{getTitle:function(){return Ext.util.Format.htmlEncode(t.title)},getId:function(t){return t.id=Ext.id()}})}}),Ext.define("SYNO.Finder.Spotlight.Showall",{extend:"Ext.Container",constructor:function(t){var e={cls:"syno-list-select show-all-in-finder",html:String.format("<div>{0}</div>",Ext.util.Format.htmlEncode(SYNO.Finder.Utils._T("common","show_all_in_app"))),listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},onAfterRender:function(){this.el.on("click",this.onClick,this),this.el.setARIA({label:Ext.util.Format.htmlEncode(SYNO.Finder.Utils._T("common","show_all_in_app")),role:"option"})},onClick:function(){SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("showall")}}),Ext.reg("spotlight_section",SYNO.Finder.Spotlight.SectionBase),Ext.reg("spotlight_showall",SYNO.Finder.Spotlight.Showall),Ext.ns("SYNO.Finder.Spotlight.Preview"),Ext.define("SYNO.Finder.Spotlight.Preview.Meta",{extend:"SYNO.ux.Panel",constructor:function(t){var e={cls:"preview-meta spotlight",tpl:this.createTemplate()};this.callParent([Ext.apply(e,t)])},createTemplate:function(){return new Ext.XTemplate("<div>",'<div class="title">{listItemTitle:htmlEncode}</div>','<tpl for="previewMeta">','<div class="field-name meta-item">{name:htmlEncode}</div>','<div class="field-content meta-item">{content:htmlEncode}</div>',"</tpl>",'<div class="x-clear"></div>',"</div>")},getContentHeight:function(){return this.el.query(".title")[0].offsetHeight+20+20*this.el.query(".field-name").length},updateContent:function(t){var e=[];Ext.each(t.previewMeta,function(t,i,n){t.content&&t.content.trim()&&e.push(t)}),t.previewMeta=e.splice(0,4),this.update(t),this.updateQTips(t)},updateQTips:function(t){var e=Ext.get(this.el.query(".title")[0]);e.getTextWidth()/2>290?Ext.QuickTips.register({target:e,text:t.listItemTitle}):Ext.QuickTips.unregister(e),Ext.each(this.el.query(".field-content"),function(t){var e=Ext.get(t);e.getTextWidth()>145?Ext.QuickTips.register({target:e,text:t.textContent}):Ext.QuickTips.unregister(e)})}}),Ext.ns("SYNO.Finder.Component.Preview.Upper"),Ext.define("SYNO.Finder.Component.Preview.Upper.Base",{extend:"SYNO.ux.Panel",updateContent:Ext.emptyFn}),Ext.ns("SYNO.Finder.Component.Preview.Upper"),Ext.define("SYNO.Finder.Component.Preview.Upper.Thumbnail",{extend:"SYNO.Finder.Component.Preview.Upper.Base",docData:null,FRACTION_WIDTH:null,FRACTION_HEIGHT:null,isStretchable:!1,constructor:function(t){this.thumbnail=new Ext.Container({tpl:this.createThumbnailTemplate()});var e={ctCls:"preview-box-wrapper",layout:"fit",items:this.thumbnail,listeners:{scope:this,resize:this.onMyResize}};this.callParent([Ext.apply(e,t)])},onMyResize:function(t,e,i){this.adjustThumbnailSize(e,i)},onThumbnailLoadSuccess:function(t,e){if(this&&this.el&&this.el.dom&&this.el.dom.parentNode){this.docData.extraData&&["app","help"].indexOf(this.docData.extraData.type)>=0&&"custom"!=this.docData.extraData.thumbnailType&&e.parentNode.removeClassName("not-default"),e.parentNode.removeClassName("loading");var i=SYNO.Finder.Utils.EntryType(this.docData.listItemTitle);"audio"===i&&(this.isStretchable=!0,e.parentNode.style.backgroundImage="url('"+e.src+"')",e.parentNode.addClassName("audio-cover"),e.parentNode.removeChild(e)),"audio"===i?this.FRACTION_HEIGHT=this.FRACTION_WIDTH=1:"video"===i&&(this.FRACTION_HEIGHT=3,this.FRACTION_WIDTH=4),this.adjustThumbnailSize(this.getWidth(),this.getHeight())}},onThumbnailLoadError:function(t,e){this&&this.el&&this.el.dom&&this.el.dom.parentNode&&(e.src=this.docData.thumbnailItemDefaultIcon,e.parentNode.removeClassName("not-default"),e.parentNode.removeClassName("loading"),Ext.fly(e).un("load",this.onThumbnailLoadSuccess,this),SYNO.Finder.Mgr.statusMgr&&SYNO.Finder.Mgr.statusMgr.fireEvent("fallbackPreview"))},adjustThumbnailSize:function(t,e){var i=this.el.select(".outline-image-container",!0);if(i.elements.length){if(!this.isStretchable||!this.FRACTION_HEIGHT||!this.FRACTION_WIDTH){var n=i.item(0).select("img",!0);return void(n.elements&&n.elements.length&&n.elements[0].dom.complete&&(n=n.elements[0].dom,i.item(0).dom.style.height=Math.min(t/n.naturalWidth<1?n.naturalHeight*t/n.naturalWidth:n.naturalHeight,e)+"px",i.item(0).dom.style.width=Math.min(e/n.naturalHeight<1?n.naturalWidth*e/n.naturalHeight:n.naturalWidth,t)+"px"))}t>=e/this.FRACTION_HEIGHT*this.FRACTION_WIDTH?(i.setHeight(e),i.setWidth(e/this.FRACTION_HEIGHT*this.FRACTION_WIDTH)):(i.setHeight(t/this.FRACTION_WIDTH*this.FRACTION_HEIGHT),i.setWidth(t))}},updateContent:function(t){this.docData=t,this.isStretchable=!1,this.thumbnail.update(t),Ext.Element.select(".preview-thumbnail img").each(function(t){t.dom.getAttribute("src")?(t.on("error",this.onThumbnailLoadError,this),t.on("load",this.onThumbnailLoadSuccess,this)):this.onThumbnailLoadError(void 0,t.dom)},this)},createThumbnailTemplate:function(){return new Ext.XTemplate('<div class="preview-thumbnail">','<span class="helper"></span><div class="not-default outline-image-container loading"><img data-load-fail="0" src="{[values.previewItemSrc]}"></div>',"</div>")}}),Ext.define("SYNO.Finder.Component.Preview.Upper.AudioPlayer",{extend:"SYNO.Finder.Component.Preview.Upper.Thumbnail",moduleID:"synofinder_audio_player",soundPlayer:null,isInit:null,currentProgress:0,constructor:function(t){var e={listeners:{deactivate:this.onDeactivate,resize:this.onMyResize,scope:this}};this.soundPlayer=new SYNO.SDS.AudioPlayer.SoundPlayer({moduleID:this.moduleID,baseURL:SYNO.SDS.Config.FnMap["SYNO.SDS.AudioPlayer.MiniPlayer"].config.jsBaseURL}),this.urlHandler=new SYNO.Finder.Component.Upper.AudioURL({soundPlayer:this.soundPlayer}),this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(this.soundPlayer,{updateDuration:this.onUpdateDuration,whileplaying:this.onUpdateProgress,onfinish:this.onFinish,scope:this}),this.mon(SYNO.Finder.Mgr.statusMgr,{searchCategoryChanged:this.onSearchCriteriaChanged,searchFieldCleared:this.onSearchFieldCleared,scope:this})},onSearchCriteriaChanged:function(){this.resetSoundPlayer()},onSearchFieldCleared:function(){this.resetSoundPlayer()},createThumbnailTemplate:function(){return new Ext.XTemplate('<div class="preview-thumbnail">','<span class="helper"></span>','<div class="not-default outline-image-container loading"><img data-load-fail="0" src="{[values.previewItemSrc]}">','<div class="audio-player-panel">','<span class="helper"></span>','<div class="filetype-hover">','<span class="helper"></span>','<a class="play-pause-btn">','<span class="helper"></span>','<span class="play-pause-btn-bg">',"</span>","</a>","</div>","</div>",'<div class="progress-info"></div>',"</div>","</div>")},onDestroy:function(){this.soundPlayer.destroy()},onDeactivate:function(){this.resetSoundPlayer()},onFinish:function(){this.setPlayBtnStatus(!1),this.el.query(".progress-info")[0].innerText=""},onPlayPause:function(){},onUpdateDuration:function(t){this.el.query(".progress-info")[0].innerText="00:00 / "+SYNO.Finder.Utils.ParseDurationSecond(t)},onUpdateProgress:function(t){this.el.query(".progress-info")[0].innerText=SYNO.Finder.Utils.ParseDurationSecond(this.soundPlayer.getPosition())+" / "+SYNO.Finder.Utils.ParseDurationSecond(this.soundPlayer.getDuration())},onThumbnailLoadSuccess:function(t,e){this.callParent(arguments),this&&this.el&&this.el.dom&&this.el.dom.parentNode&&(this.thumbnail.el.query(".preview-thumbnail")[0].addClassName("cover-player"),this.thumbnail.el.query(".preview-thumbnail")[0].removeClassName("filetype-player"))},onThumbnailLoadError:function(t,e){this.callParent(arguments),this&&this.el&&this.el.dom&&this.el.dom.parentNode&&(this.thumbnail.el.query(".preview-thumbnail")[0].removeClassName("cover-player"),this.thumbnail.el.query(".preview-thumbnail")[0].addClassName("filetype-player"))},resetSoundPlayer:function(){this.soundPlayer.reset()},checkIsPlayable:function(){if(this.docData&&this.docData.extraData){var t=this.docData.extraData.sharePath;this.soundPlayer.canPlay(t)||this.soundPlayer.canTranscode(t)?this.thumbnail.el.query(".preview-thumbnail")[0].addClassName("playable"):this.thumbnail.el.query(".preview-thumbnail")[0].removeClassName("playable")}},setPlayBtnStatus:function(t){t?this.el.select(".play-pause-btn-bg").removeClass("pause"):this.el.select(".play-pause-btn-bg").addClass("pause")},bindPlayBtnEvent:function(){this.el.select(".play-pause-btn").on("click",this.playpause,this)},playpause:function(){var t;if(!this.soundPlayer.isReady)return t=this.soundPlayer.flashLoaded()?String.format(_T("audio_player","err_failed_to_play"),this.docData.listItemTitle):_T("audio_player","error_no_flash"),void this.findAppWindow().getMsgBox().alert("Universal Search",t);if(this.docData){var e=this.docData.extraData.sharePath,i=this.urlHandler.getSoundURL(e);Ext.isEmpty(i)||this.setPlayBtnStatus(this.soundPlayer.play(i,e))}},stop:function(){this.soundPlayer.reset(),this.setPlayBtnStatus(!1)},updateContent:function(){this.callParent(arguments),this.resetSoundPlayer(),this.checkIsPlayable(),this.setPlayBtnStatus(!0),this.bindPlayBtnEvent()}}),Ext.define("SYNO.Finder.Component.Upper.AudioURL",{extend:"Ext.util.Observable",soundPlayer:null,constructor:function(t){this.soundPlayer=t&&t.soundPlayer,this.callParent([t])},getFileExt:function(t){return t.substr(t.lastIndexOf("."))},getTranscodeURL:function(t,e){var i=this.soundPlayer.getTranscodeFormat(t);return this.composeURL({method:"transcode",format:i,path:t,position:e||0})},getDirectURL:function(t){return this.composeURL({method:"stream",path:t})},getSoundURL:function(t){var e;return e=this.soundPlayer.canPlay(t),this.soundPlayer&&this.soundPlayer.isURLinput?e?t:null:e?this.getDirectURL(t):this.soundPlayer.canTranscode(t)?this.getTranscodeURL(t):null},getOrigin:function(){var t=window.location.origin,e=window.location.port?":"+window.location.port:"";return _S("rewriteApp")?t=window.location.origin+window.location.pathname.replace("index.cgi",""):t||(t=window.location.protocol+"//"+window.location.hostname+e),t},composeURL:function(t){var e;e=this.getFileExt(t.path),".m4a"!==e.toLowerCase()&&"transcode"!==t.method||(e="."+this.soundPlayer.getTranscodeFormat());var i=this.getOrigin()+String.format("/webapi/entry.cgi/{0}?",e),n={api:"SYNO.AudioPlayer.Stream",version:2};return Ext.apply(t,n),_S("SynoToken")&&(t.SynoToken=_S("SynoToken")),Ext.urlEncode(t,i)}}),Ext.ns("SYNO.Finder.Spotlight.Preview"),Ext.define("SYNO.Finder.Spotlight.PreviewPanel",{extend:"SYNO.ux.Panel",constructor:function(t){var e={};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.Finder.Spotlight.Preview.Base",{extend:"SYNO.ux.Panel",constuctor:function(t){var e={};this.callParent([Ext.apply(e,t)])},updateContent:Ext.emptyFn}),Ext.define("SYNO.Finder.Spotlight.Preview.Document",{extend:"SYNO.Finder.Spotlight.Preview.Base",hlOffset:0,hlTotal:0,hlDocData:null,pageNum:null,firstMatchTerm:null,constructor:function(t){this.apiRequest=null,this.hlPanel=new Ext.Container({cls:"highlight-wrapper",tpl:this.getHighlightTemplate(),flex:1}),this.ctrlBar=new SYNO.Finder.Spotlight.Preview.ControllerBar({});var e={layout:"vbox",layoutConfig:{align:"stretch"},cls:"preview-document",items:[this.hlPanel,this.ctrlBar]};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(SYNO.Finder.Spotlight.previewMgr,"goprev",this.onGoPrev,this),this.mon(SYNO.Finder.Spotlight.previewMgr,"gonext",this.onGoNext,this),this.mon(SYNO.Finder.Spotlight.previewMgr,"openPDFViewer",this.onOpenPDFViewer,this)},onGoPrev:function(){this.isVisible()&&(this.hlOffset--,this.requestHighlightFromWebAPI())},onGoNext:function(){this.isVisible()&&(this.hlOffset++,this.requestHighlightFromWebAPI())},onOpenPDFViewer:function(){SYNO.SDS.WindowLaunch("SYNO.SDS.PDFViewer.Application",{path:this.hlDocData.extraData.sharePath,query:this.firstMatchTerm||"",pageNum:this.pageNum||1})},abortAPIRequest:function(){try{this.apiRequest&&this.apiRequest.conn&&this.apiRequest.conn.abort()}catch(t){SYNO.Debug.error(t)}},getHighlightTemplate:function(){return new Ext.XTemplate('<div class="highlight-body">{[SYNO.Finder.Utils.escapeHighlight(values.highlight.text)]}</div>')},setDoc:function(t){this.hlDocData=t,t&&this.ctrlBar.disableOpenBtn(!SYNO.Finder.Utils.checkEnableDocumentViewerBtn(t.extraData.highlightExtension))},preUpdateHighlight:function(t){t&&(this.hlOffset=0),this.abortAPIRequest(),this.ctrlBar.preUpdateHighlight()},updateContent:function(t){this.setDoc(t),this.requestHighlightFromWebAPI(!0)},requestHighlightFromWebAPI:function(t){if(!t){if(this.hlOffset>=this.hlTotal)return void(this.hlOffset=this.hlTotal-1);if(this.hlOffset<0)return void(this.hlOffset=0)}this.preUpdateHighlight(t),this.hlPanel.update({highlight:{text:SYNO.Finder.Utils._T("common","highlight_loading")}}),this.apiRequest=this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Highlight",version:1,method:"highlight",params:{full_path:this.hlDocData.extraData.highlightFullPath,doc_id:this.hlDocData.extraData.highlightDocId,keyword:this.hlDocData.extraData.highlightKeyword,highlight:{field:"SYNOMDTextContent",offset:this.hlOffset,num_fragments:SYNO.Finder.Spotlight.Mgr.statusMgr.getData("preference",{}).max_fragment_num,frag_length:350}},scope:this,callback:this.requestHighlightCb.createDelegate(this,[t],3)})},requestHighlightCb:function(t,e,i,n){t?(n&&(this.hlOffset=0),this.getHighlightMsg(e).then(function(t){this.hlPanel&&this.hlPanel.el&&this.hlPanel.el.dom&&this.ctrlBar&&this.ctrlBar.el&&this.ctrlBar.el.dom&&(e.highlight.text=t,this.hlTotal=Math.min(e.total||1,SYNO.Finder.Spotlight.Mgr.statusMgr.getData("preference",{}).max_fragment_num||1),this.hlPanel.update(e),this.pageNum=e.highlight.page+1,this.firstMatchTerm=e.highlight.term,this.ctrlBar.updateDisplay({offset:this.hlOffset+1,total:this.hlTotal}))}.createDelegate(this))):(this.hlOffset=-1,this.hlTotal=0,this.pageNum=1,this.firstMatchTerm="",this.hlPanel.update({highlight:{text:SYNO.Finder.Utils._T("common","highlight_unavailable")}}),this.ctrlBar.updateDisplay({offset:this.hlOffset+1,total:this.hlTotal}))},getHighlightMsg:function(t){if(!this.hlDocData||!this.hlDocData.extraData||!this.hlDocData.extraData.highlightFullPath)return Promise.resolve(SYNO.Finder.Utils._T("common","highlight_unavailable"));if(!Ext.isEmpty(t.highlight.text.trim()))return Promise.resolve(t.highlight.text.trim());if(!_S("is_admin"))return Promise.resolve(SYNO.Finder.Utils._T("common","highlight_unavailable"));var e=this.hlDocData.extraData.highlightFullPath+"/",i=e.substr(1).indexOf("/"),n=e.substr(1+i);return new Promise(function(t,e){this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Folder",method:"list",params:{direction:"asc",sort_by:"path",offset:0},version:1,scope:this,callback:function(e,i,r){var s={path:""};if(!e)return void t(SYNO.Finder.Utils._T("common","highlight_unavailable"));Ext.each(i.folder,function(t){0===n.indexOf(t.path)&&t.path.length>s.path.length&&(s=t)}),t(!0===s.document?SYNO.Finder.Utils._T("common","highlight_unavailable"):SYNO.Finder.Utils._T("common","highlight_unavailable_unindexed"))}})}.createDelegate(this))}}),Ext.define("SYNO.Finder.Spotlight.Preview.ControllerBar",{extend:"SYNO.ux.Panel",CONTROLLER_BAR_HEIGHT:65,constructor:function(t){var e={height:this.CONTROLLER_BAR_HEIGHT,layout:"hbox",layoutConfig:{align:"stretch"},cls:"controller-bar",items:this.fillItems(),bubbleEvents:["add","remove"]};this.callParent([Ext.apply(e,t)])},fillItems:function(t){this.paragraphInfo=new Ext.Container({tpl:this.getTemplate(),flex:1}),this.openBtn=new SYNO.ux.Button({iconCls:"open-btn",width:26,margins:"0 8 0 0",scope:this,handler:this.onOpenBtnClick});var e=new Ext.Container({cls:"separator",width:1,margins:"3 10 3 0"});return this.prevBtn=new SYNO.ux.Button({width:26,margins:"0 6 0 8",iconCls:"prev-btn",scope:this,handler:this.onPrevClick}),this.nextBtn=new SYNO.ux.Button({width:26,iconCls:"next-btn",scope:this,handler:this.onNextClick}),SYNO.Finder.Utils.checkSupportPDFViewer()?[this.openBtn,e,this.paragraphInfo,this.prevBtn,this.nextBtn]:[this.paragraphInfo,this.prevBtn,this.nextBtn]},onPrevClick:function(){SYNO.Finder.Spotlight.previewMgr.fireEvent("goprev")},onNextClick:function(){SYNO.Finder.Spotlight.previewMgr.fireEvent("gonext")},onOpenBtnClick:function(){SYNO.Finder.Spotlight.previewMgr.fireEvent("openPDFViewer")},getTemplate:function(){return new Ext.XTemplate('<div class="info {[this.supportPDF()]}"><span class="now">{offset}</span> / {total}</div>',{supportPDF:function(){return SYNO.Finder.Utils.checkSupportPDFViewer()?"":"no-pdf-viewer"}})},preUpdateHighlight:function(){this.prevBtn.setDisabled(!0),this.nextBtn.setDisabled(!0)},updateCtrlBtnState:function(t){this.prevBtn.setDisabled(t.offset<=1),this.nextBtn.setDisabled(t.offset>=t.total)},updateDisplay:function(t){this.paragraphInfo.update(t),this.updateCtrlBtnState(t)},disableOpenBtn:function(t){this.openBtn.setDisabled(t)}}),Ext.reg("preview_controller_bar",SYNO.Finder.Spotlight.Preview.ControllerBar),Ext.define("SYNO.Finder.Spotlight.Preview.Image",{extend:"SYNO.Finder.Spotlight.Preview.Base",constructor:function(t){var e={cls:"preview-image",tpl:this.getTemplate()};this.callParent([Ext.apply(e,t)])},onImgLoadSuccess:function(){this&&this.removeClass("loading")},onImgLoadError:function(){this&&SYNO.Finder.Spotlight.Mgr.statusMgr&&(this.removeClass("loading"),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("fallbackPreview"))},updateContent:function(t){this.addClass("loading"),this.update(t),this.bindImgEvents()},bindImgEvents:function(){var t=this.el.query(".thumbnail-body img")[0];t&&(Ext.get(t).on("load",this.onImgLoadSuccess,this),Ext.get(t).on("error",this.onImgLoadError,this))},getTemplate:function(){return new Ext.XTemplate('<div class="thumbnail-body">','<span class="helper"></span>','<div class="outline-image-container">','<img src="{[values.extraData.previewItemSrc || values.previewItemSrc]}">',"</div>","</div>")}}),Ext.define("SYNO.Finder.Spotlight.Preview.Filetype",{extend:"SYNO.Finder.Spotlight.Preview.Base",constructor:function(t){this.filetypePart=new SYNO.ux.Panel({tpl:this.getFiletypeTemplate(),cls:"filetype",height:128,margins:"0 0 8 0"}),this.metaPart=new SYNO.Finder.Spotlight.Preview.Meta({cls:"preview-meta spotlight"}),this.mainContent=new Ext.Container({cls:"preview-filetype",layout:"vbox",layoutConfig:{align:"stretch"},items:[this.filetypePart,this.metaPart]});var e={layout:"vbox",layoutConfig:{align:"stretch"},items:[{flex:1,border:!1},this.mainContent,{flex:1,border:!1}]};this.callParent([Ext.apply(e,t)])},getFiletypeTemplate:function(){return new Ext.XTemplate('<div class="wrapper">','<img src="{[this.getImg(values)]}">',"</div>",{getImg:function(t){return t.filetypeDefaultIcon||t.previewItemSrc||t.thumbnailItemDefaultIcon}})},updateContent:function(t){this.filetypePart.update(t),
this.metaPart.updateContent(t);var e=this.metaPart.getContentHeight();this.metaPart.setHeight(e),this.mainContent.setHeight(136+e),this.doLayout()}}),Ext.define("SYNO.Finder.Spotlight.Preview.Audio",{extend:"SYNO.Finder.Spotlight.Preview.Base",moduleID:"synofinder_spotlight_audio_player",constructor:function(t){var e={cls:"preview-audio",tpl:this.getTemplate(),listeners:{deactivate:this.onDeactivate,scope:this}};this.soundPlayer=new SYNO.SDS.AudioPlayer.SoundPlayer({moduleID:this.moduleID,baseURL:SYNO.SDS.Config.FnMap["SYNO.SDS.AudioPlayer.MiniPlayer"].config.jsBaseURL}),this.urlHandler=new SYNO.Finder.Component.Upper.AudioURL({soundPlayer:this.soundPlayer}),this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(this.soundPlayer,"finish",this.onFinish,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"pausemusic",this.onPauseMusic,this)},onPauseMusic:function(){this.isPlaying&&this.playpause()},onDestroy:function(){this.soundPlayer.destroy()},onDeactivate:function(){this.resetSoundPlayer()},onFinish:function(){this.setPlayBtnStatus(!0)},onImgLoadSuccess:function(t,e){this.removeClass("loading");var i=e.parentNode;i.removeChild(e),i.style.backgroundImage=String.format("url('{0}')",e.src)},onImgLoadError:function(){this.removeClass("loading"),SYNO.Finder.Spotlight.Mgr.statusMgr&&this.el.isVisible(!0)&&SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("fallbackPreviewAudio")},getTemplate:function(){return new Ext.XTemplate('<div class="wrapper"><span class="helper"></span>','<div class="outline-image-container"><img src={[Ext.util.Format.htmlEncode(values.extraData.previewItemSrc)]}>','<div class="audio-player-panel">','<span class="helper"></span>','<a class="play-pause-btn">','<span class="helper"></span>','<span class="play-pause-btn-bg">',"</span>","</a>","</div>","</div>","</div>")},bindImgEvents:function(){var t=this.el.query("img")[0];Ext.get(t).on("load",this.onImgLoadSuccess,this),Ext.get(t).on("error",this.onImgLoadError,this)},updateContent:function(t){this.addClass("loading"),this.update(t),this.docData=t,this.bindImgEvents(),this.resetSoundPlayer(),this.checkIsPlayable(),this.setPlayBtnStatus(!0),this.bindPlayBtnEvent()},checkIsPlayable:function(){if(this.docData&&this.docData.extraData){var t=this.docData.extraData.sharePath;this.soundPlayer.canPlay(t)||this.soundPlayer.canTranscode(t)?this.el.addClass("playable"):this.el.removeClass("playable")}},resetSoundPlayer:function(){this.soundPlayer.reset()},setPlayBtnStatus:function(t){t?this.el.select(".play-pause-btn-bg").removeClass("pause"):this.el.select(".play-pause-btn-bg").addClass("pause")},bindPlayBtnEvent:function(){this.el.select(".play-pause-btn").on("click",this.playpause,this)},playpause:function(){var t;if(this.docData){if(!this.soundPlayer.isReady)return t=this.soundPlayer.flashLoaded()?String.format(_T("audio_player","err_failed_to_play"),this.docData.listItemTitle):_T("audio_player","error_no_flash"),void this.findAppWindow().getMsgBox().alert("Search Now",t);var e=this.docData.extraData.sharePath,i=this.urlHandler.getSoundURL(e);if(!Ext.isEmpty(i)){var n=this.soundPlayer.play(i,e);this.isPlaying=!n,this.setPlayBtnStatus(n)}}}}),Ext.define("SYNO.Finder.Spotlight.Preview.FiletypeAudioPlayer",{extend:"SYNO.Finder.Spotlight.Preview.Filetype",moduleID:"synofinder_spotlight_filetype_audio_player",constructor:function(t){var e={cls:"preview-filetype playable",listeners:{deactivate:this.onDeactivate,scope:this}};this.soundPlayer=new SYNO.SDS.AudioPlayer.SoundPlayer({moduleID:this.moduleID,baseURL:SYNO.SDS.Config.FnMap["SYNO.SDS.AudioPlayer.MiniPlayer"].config.jsBaseURL}),this.urlHandler=new SYNO.Finder.Component.Upper.AudioURL({soundPlayer:this.soundPlayer}),this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(this.soundPlayer,"finish",this.onFinish,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"pausemusic",this.onPauseMusic,this)},onPauseMusic:function(){this.isPlaying&&this.playpause()},onDestroy:function(){this.soundPlayer.destroy()},onFinish:function(){this.setPlayBtnStatus(!0)},onDeactivate:function(){this.resetSoundPlayer()},getFiletypeTemplate:function(){return new Ext.XTemplate('<div class="wrapper">','<img src="{[this.getImg(values)]}">','<div class="audio-player-panel">','<a class="play-pause-btn">','<span class="helper"></span>','<span class="play-pause-btn-bg">',"</span>","</a>","</div>","</div>",{getImg:function(t){return t.filetypeDefaultIcon||t.previewItemSrc||t.thumbnailItemDefaultIcon}})},updateContent:function(t){this.callParent(arguments),this.docData=t,this.resetSoundPlayer(),this.setPlayBtnStatus(!0),this.bindPlayBtnEvent()},resetSoundPlayer:function(){this.soundPlayer.reset()},setPlayBtnStatus:function(t){t?this.el.select(".play-pause-btn-bg").removeClass("pause"):this.el.select(".play-pause-btn-bg").addClass("pause")},bindPlayBtnEvent:function(){this.el.select(".play-pause-btn").on("click",this.playpause,this)},playpause:function(){var t;if(this.docData){if(!this.soundPlayer.isReady)return t=this.soundPlayer.flashLoaded()?String.format(_T("audio_player","err_failed_to_play"),this.docData.listItemTitle):_T("audio_player","error_no_flash"),void this.findAppWindow().getMsgBox().alert("Search Now",t);var e=this.docData.extraData.sharePath,i=this.urlHandler.getSoundURL(e);if(!Ext.isEmpty(i)){var n=this.soundPlayer.play(i,e);this.isPlaying=!n,this.setPlayBtnStatus(n)}}}}),Ext.define("SYNO.Finder.Spotlight.Preview.Video",{extend:"SYNO.Finder.Spotlight.Preview.Base",constructor:function(t){var e={cls:"preview-video",tpl:this.getTemplate()};this.callParent([Ext.apply(e,t)])},onImgLoadSuccess:function(t,e){this.removeClass("loading");var i=e.parentNode;i.removeChild(e),i.style.backgroundImage=String.format("url('{0}')",e.src)},onImgLoadError:function(){this.removeClass("loading"),SYNO.Finder.Spotlight.Mgr.statusMgr&&SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("fallbackPreview")},getTemplate:function(){return new Ext.XTemplate('<div class="wrapper"><span class="helper"></span>','<div class="outline-image-container"><img src={[Ext.util.Format.htmlEncode(values.extraData.previewItemSrc)]}></div>',"</div>")},updateContent:function(t){this.addClass("loading"),this.update(t),this.bindImgEvents()},bindImgEvents:function(){var t=this.el.query("img")[0];Ext.get(t).on("load",this.onImgLoadSuccess,this),Ext.get(t).on("error",this.onImgLoadError,this)}}),Ext.ns("SYNO.Finder.Spotlight"),Ext.define("SYNO.Finder.Spotlight.PreviewMgr",{extend:"Ext.Component",previewPanel:null,_viewsFactory:null,constructor:function(){this.callParent(),this._viewsFactory=[],this.loadBuiltInPreviews(),this.loadPluginPreviews(),this.initEvents()},initEvents:function(){SYNO.Finder.Utils.debug("initEvents of preview_mgr"),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,{fallbackPreview:this.fallbackPreviewPanel,fallbackPreviewAudio:this.fallbackPreviewAudioPanel,scope:this}),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,{updatePreview:this.updatePanel,buffer:150,scope:this}),this.bindPluginMgrEvents()},onDestory:function(){this._views=[],this.previewPanel=null},getPreviewPanel:function(){return this.previewPanel||(this.previewPanel=new SYNO.Finder.Spotlight.PreviewPanel({cls:"preview-panel spotlight-preview-panel",layout:"card",activeItem:0,items:this._viewsFactory.map(function(t){return new t.ctor({itemId:t.itemId})}),flex:1})),this.previewPanel},getCurrentView:function(){return this.previewPanel.getLayout().activeItem},updatePanel:function(t){if(t&&t.data){var e=t.get("extraData")&&"custom"===t.get("extraData").thumbnailType&&"image"||t.get("previewCardID")||SYNO.Finder.Utils.EntryType(t.data.listItemTitle)||"misc";this.previewPanel.items.containsKey(e)&&!SYNO.Finder.Utils.EntryTypeIsInBlackList(e,t.get("listItemTitle"))||(e="misc"),this.setViewById(e),this.getCurrentView().updateContent(t.data)}},fallbackPreviewPanel:function(){this.setViewById("misc");var t=SYNO.Finder.Spotlight.core.getCurrentItem();t&&t.data&&this.getCurrentView().updateContent(t.data)},fallbackPreviewAudioPanel:function(){this.setViewById("filetype_audio");var t=SYNO.Finder.Spotlight.core.getCurrentItem();t&&t.data&&this.getCurrentView().updateContent(t.data)},setViewById:function(t){this.previewPanel.getLayout().setActiveItem(t),this.getCurrentView().doLayout()},goNextSnippet:function(){this.fireEvent("gonext")},goPrevSnippet:function(){this.fireEvent("goprev")},loadBuiltInPreviews:function(){this._viewsFactory.push({itemId:"document",ctor:SYNO.Finder.Spotlight.Preview.Document}),this._viewsFactory.push({itemId:"image",ctor:SYNO.Finder.Spotlight.Preview.Image}),this._viewsFactory.push({itemId:"audio",ctor:SYNO.Finder.Spotlight.Preview.Audio}),this._viewsFactory.push({itemId:"filetype_audio",ctor:SYNO.Finder.Spotlight.Preview.FiletypeAudioPlayer}),this._viewsFactory.push({itemId:"video",ctor:SYNO.Finder.Spotlight.Preview.Video}),this._viewsFactory.push({itemId:"misc",ctor:SYNO.Finder.Spotlight.Preview.Filetype})},loadPluginPreviews:function(){},bindPluginMgrEvents:function(){},onPluginAdd:function(){},onPluginRemove:function(){}}),Ext.ns("SYNO.Finder.Searcher"),Ext.define("SYNO.Finder.Spotlight.Searcher.Application",{extend:"SYNO.Finder.Spotlight.Searcher.Base",apiName:"SYNO.Finder.AppIndexing.Search",apiMethod:"search",apiVersion:1,getName:function(){return"spotlight-application"},processSearchResp:function(t){var e=[];return Ext.each(t.hits,function(t){try{e.push({listItemIconSrc:this.getIconSrc(t),listItemTitle:this.getTitle(t),filetypeDefaultIcon:this.getPreviewItemSrc(t),filetypeIndicatorIconSrc:this.getFiletypeIndicatorSrc(t),audioCoverSrc:this.getAudioCoverSrc(t),previewCardID:this.getPreviewCardID(t),previewMeta:this.getPreviewMeta(t),extraData:this.getExtraData(t),launchAppData:this.getLaunchAppData(t)})}catch(t){SYNO.Finder.Utils.error("processSearchResp error:",t)}},this),this.BASIC_LOAD_ENTRIES>e.length?this.reachEnd=!0:this.from+=e.length,e},isSearchNeeded:function(){return"all"===SYNO.Finder.Spotlight.Mgr.statusMgr.getData("searchType","all")},topHitProcess:function(t){var e=t.hits,i=[];return Ext.each(t.hits,function(t){SYNO.Finder.Utils.debug(t.title,t.additional.score)}),i=e.splice(1,e.length-1),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("addTophit",this.processSearchResp({hits:e})),{hits:i}},getSearchParams:function(){return{keyword:SYNO.Finder.Utils.ConstructKeyword(SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchKeyword","")),lang:_S("lang"),from:this.from,size:this.BASIC_LOAD_ENTRIES,search_weight_list:this.getSearchWeights()||[]}},getSearchWeights:function(){return[{field:"SYNOMDWildcard",weight:1},{field:"keywords",weight:5},{field:"search_title",weight:10}]},getIconSrc:function(t){return SYNO.SDS.Utils.GetAppIcon(t.owner||SYNO.SDS.Utils.ParseSearchID(t.id).className,"TreeIcon")},getTitle:function(t){return t.title},getSubtitle:function(t){return SYNO.SDS.Utils.GetAppTitle(t.owner)},getDescription:function(t){return String.format(t.desc,_D("product"))},getPreviewCardID:function(t){return"misc"},getPreviewMeta:function(t){return[{name:SYNO.Finder.Utils._T("common","meta_owner"),content:SYNO.SDS.Utils.GetAppTitle(t.owner)},{name:SYNO.Finder.Utils._T("common","meta_description"),content:String.format(t.desc,_D("product"))},{name:SYNO.Finder.Utils._T("common","installed_pkg_version"),content:SYNO.SDS.Config.FnMap[t.id.match(/([^?]*)/)[0]].config.version}]},getPreviewItemSrc:function(t){return SYNO.SDS.Utils.GetAppIcon(t.owner||SYNO.SDS.Utils.ParseSearchID(t.id).className,"FinderPreview")},getFiletypeIndicatorSrc:function(t){return SYNO.SDS.Utils.GetAppIcon(t.owner||SYNO.SDS.Utils.ParseSearchID(t.id).className,"StandaloneHeader")},getAudioCoverSrc:function(t){return{}},getLaunchAppData:function(t){return SYNO.SDS.Utils.ParseSearchID(t.id)},getExtraData:function(t){return{type:"app"}}}),Ext.ns("SYNO.Finder.Searcher"),Ext.define("SYNO.Finder.Spotlight.Searcher.Help",{extend:"SYNO.Finder.Spotlight.Searcher.Base",apiName:"SYNO.Core.UISearch",apiMethod:"uisearch",apiVersion:1,getName:function(){return"spotlight-help"},isSearchNeeded:function(){return"all"===SYNO.Finder.Spotlight.Mgr.statusMgr.getData("searchType","all")},processSearchResp:function(t){var e=[];return Ext.each(t.items,function(t){try{e.push({listItemIconCls:this.getIconCls(t),listItemTitle:this.getTitle(t),filetypeDefaultIcon:this.getThumbnailDefaultIcon(t),filetypeIndicatorIconSrc:this.getFiletypeIndicatorSrc(t),audioCoverSrc:this.getAudioCoverSrc(t),previewCardID:this.getPreviewCardID(t),previewMeta:this.getPreviewMeta(t),extraData:this.getExtraData(t),launchAppData:this.getLaunchAppData(t)})}catch(t){SYNO.Finder.Utils.error("processSearchResp error:",t)}},this),this.BASIC_LOAD_ENTRIES>e.length?this.reachEnd=!0:this.from+=e.length,e},topHitProcess:function(t){return t},getSearchParams:function(){return{query:SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchKeyword",""),type:"help",lang:_S("lang"),offset:0,limit:this.BASIC_LOAD_ENTRIES}},getThumbnailDefaultIcon:function(t){return this.getPreviewItemSrc(t)},getIconCls:function(t){return"txt"},getTitle:function(t){return t.topic},getSubtitle:function(t){return SYNO.SDS.Utils.GetAppTitle(t.owner)},getPreviewMeta:function(t){return[{name:SYNO.Finder.Utils._T("common","meta_title"),content:t.topic},{name:SYNO.Finder.Utils._T("common","help_category"),content:SYNO.SDS.Utils.GetAppTitle(t.owner)}]},getAudioCoverSrc:function(){return{}},getPreviewCardID:function(t){return"misc"},getPreviewItemSrc:function(t){return"webman/3rdparty/SynoFinder/images/filetype/128/txt.png"},getFiletypeIndicatorSrc:function(t){return SYNO.SDS.Utils.GetAppIcon(t.owner||SYNO.SDS.Utils.ParseSearchID(t.id).className,"StandaloneHeader")},getLaunchAppData:function(t){return{className:"SYNO.SDS.HelpBrowser.Application",params:{topic:t.id}}},getExtraData:function(t){return{type:"help",previewItemSrc:this.getPreviewItemSrc(t)}}}),Ext.define("SYNO.Finder.Spotlight.Searcher.Package",{extend:"SYNO.Finder.Spotlight.Searcher.Base",constructor:function(t){Ext.apply(this,t||{});var e=this.inner_plugin.getSearchAPI();this.apiName=e.api,this.apiMethod=e.method,this.apiVersion=e.version,this.callParent(arguments)},getSearchParams:function(){var t=SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchKeyword",""),e=SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchCriteria",[]),i=[];return Ext.iterate(e,function(t){i.push(t.json.value)}),this.inner_plugin.getSearchParam(t,this.from,this.BASIC_LOAD_ENTRIES,i)},isSearchNeeded:function(){return"all"===SYNO.Finder.Spotlight.Mgr.statusMgr.getData("searchType","all")},topHitProcess:function(t){return t},processSearchResp:function(t){var e=this.inner_plugin.getSearchResults(t);return this.from+=e.length,this.reachEnd=e.length<this.BASIC_LOAD_ENTRIES||this.from>=t.total,this.reachEnd&&SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("searchReachEnd",this.getName()),Ext.each(e,function(t){var e=[];Ext.each(t.previewMeta,function(t,i){if(t.content.trim()&&e.push(t),e.length>=4)return!1}),t.previewMeta=e}),e},getName:function(){return this.inner_plugin.getPluginId()}}),Ext.ns("SYNO.Finder.Spotlight.Mgr"),Ext.define("SYNO.Finder.Spotlight.Mgr.Search",{extend:"SYNO.Finder.Mgr.Search",numSearchNeeded:0,constructor:function(){this.callParent(arguments)},initEvents:function(){this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"searchKeywordChanged",this.fireSearchEvent,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"searchKeywordPressEnter",this.fireSearchEvent,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"searchNeeded",this.onSearchNeeded,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"searchDone",this.onSearchDone,this),this.mon(SYNO.Finder.Spotlight.Mgr.pluginMgr,"pluginadd",this.onAddPlugin,this),this.mon(SYNO.Finder.Spotlight.Mgr.pluginMgr,"pluginremove",this.onRemovePlugin,this)},initSearcherList:function(){this.searcherList={"spotlight-tophit":null,"spotlight-file":new SYNO.Finder.Spotlight.Searcher.File({parser:new SYNO.Finder.Parser.QueryParser}),"spotlight-application":new SYNO.Finder.Spotlight.Searcher.Application,"spotlight-help":new SYNO.Finder.Spotlight.Searcher.Help}},onSearchNeeded:function(){this.setNeededSearchers()},onSearchDone:function(t,e){this.numSearchNeeded<=0||(this._searchingIDList||this.setNeededSearchers(),this._searchingIDList.hasOwnProperty(t)&&(this._searchingIDList[t].data=e||[],SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("dataAllLoaded",t,this._searchingIDList[t].data),this.numSearchNeeded--),this.numSearchNeeded<=0&&SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("allSearchDone"))},onAddPlugin:function(t){var e=t.getPluginId();this.searcherList.hasOwnProperty(e)||(this.searcherList[e]=new SYNO.Finder.Spotlight.Searcher.Package({parser:new SYNO.Finder.Parser.QueryParser,inner_plugin:t}))},setNeededSearchers:function(){this.searcherList||this.initSearcherList(),this._searchingIDList={};for(var t in this.searcherList)this.searcherList.hasOwnProperty(t)&&(this._searchingIDList[t]={});return this.numSearchNeeded=this.getNumSearchNeeded(),this._searchingIDList},getNumSearchNeeded:function(){this.searcherList||this.initSearcherList();var t=0;for(var e in this.searcherList)this.searcherList.hasOwnProperty(e)&&(t+=null===this.searcherList[e]||this.searcherList[e].isSearchNeeded());return t},fireSearchEvent:function(){SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("searchNeeded")},createPluginSearchController:function(){Ext.each(SYNO.Finder.Spotlight.Mgr.pluginMgr.getPlugins(),function(t){this.onAddPlugin(t)},this)}}),Ext.ns("SYNO.Finder.Spotlight.Tophit"),Ext.define("SYNO.Finder.Spotlight.Tophit.Collector",{extend:"Ext.Component",_searcherIDList:[],searchNeededTotal:0,searchDoneCnt:0,constructor:function(){this.callParent(arguments),this.initEvents()},initEvents:function(){this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"addTophit",this.onAddTophit,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"searchDone",this.onSearchDone,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"searchNeeded",this.onSearchNeeded,this)},onAddTophit:function(t){[].push.apply(this._data,t)},onSearchDone:function(){++this.searchDoneCnt===this.searchNeededTotal&&SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("searchDone","spotlight-tophit",this._data)},onSearchNeeded:function(){this.reset()},reset:function(){this.searchNeededTotal=SYNO.Finder.Spotlight.Mgr.searchMgr.getNumSearchNeeded()-1,this.searchDoneCnt=0,this._data=[]}}),Ext.ns("SYNO.Finder.Spotlight"),Ext.ns("SYNO.Finder.Spotlight.Mgr"),Ext.define("SYNO.Finder.Spotlight.Application",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.Finder.Spotlight.MainWindow"}),Ext.define("SYNO.Finder.Spotlight.MainWindow",{extend:"SYNO.SDS.AppWindow",constructor:function(t){this.initMgr(),SYNO.Finder.Spotlight.Mgr.statusMgr.on("dataAllLoaded",this.onDataAllLoaded),this.mainPanel=new SYNO.Finder.Spotlight.MainPanel({});var e={toggleMinimizable:!1,width:SYNO.Finder.Spotlight.core.WINDOW_DEFAULT_WIDTH,height:SYNO.Finder.Spotlight.core.WINDOW_DEFAULT_HEIGHT,layout:"fit",items:this.mainPanel,resizable:!1,cls:"syno-finder spotlight-main-window"};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.callParent(arguments),this.mon(SYNO.SDS.StatusNotifier,"toggleFinderSpotlight",this.onFinderSpotlightHide,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"initStateRemove",this.onInitStateRemove,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"initStateAdd",this.onInitStateAdd,this),this.on("focus",this.onFocus),Ext.EventManager.onWindowResize(this.onWindowResize,this)},initMgr:function(){this.addManagedComponent(SYNO.Finder.Spotlight.Mgr.pluginMgr=new SYNO.Finder.Package.PluginMgr),this.addManagedComponent(SYNO.Finder.Spotlight.Mgr.actionMgr=new SYNO.Finder.Mgr.Action),this.addManagedComponent(SYNO.Finder.Spotlight.Mgr.statusMgr=new SYNO.Finder.Mgr.Status),this.addManagedComponent(SYNO.Finder.Spotlight.Mgr.searchMgr=new SYNO.Finder.Spotlight.Mgr.Search),this.addManagedComponent(SYNO.Finder.Spotlight.Tophit.collector=new SYNO.Finder.Spotlight.Tophit.Collector),this.addManagedComponent(SYNO.Finder.Spotlight.previewMgr=new SYNO.Finder.Spotlight.PreviewMgr),SYNO.Finder.Spotlight.core=new SYNO.Finder.Spotlight.Core(this)},onDestroy:function(){SYNO.Finder.Spotlight.Mgr.pluginMgr=null,SYNO.Finder.Spotlight.Mgr.actionMgr=null,SYNO.Finder.Spotlight.Mgr.statusMgr=null,SYNO.Finder.Spotlight.Mgr.searchMgr=null,SYNO.Finder.Spotlight.Tophit.collector=null,SYNO.Finder.Spotlight.core=null,SYNO.Finder.Spotlight.previewMgr=null,this.callParent(arguments)},onInitStateAdd:function(){this.setHeight(SYNO.Finder.Spotlight.core.MINIMAL_HEIGHT)},onInitStateRemove:function(t,e){e&&this.setHeight(e)},onShow:function(){this.callParent(arguments),SYNO.Finder.Spotlight.core.restoreState()},onActivate:function(){this.callParent(arguments),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("spotlightActivate"),SYNO.Finder.Spotlight.core.enableKeyMap()},onWindowResize:function(){SYNO.Finder.Spotlight.core.restoreState()},onRequest:function(t){this.callParent();var e=SYNO.Finder.Spotlight.Mgr.statusMgr.getData("searchType","all");if(SYNO.Finder.Spotlight.Mgr.statusMgr.applyData({searchType:t.type}).fireEvent("changeSearchType",t.type),e!==t.type){SYNO.Finder.Spotlight.Mgr.statusMgr.getData("currentSearchKeyword","")&&SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("searchKeywordChanged")}},onOpen:function(t){if(this.callParent(),SYNO.Finder.Spotlight.core.addInitState(),SYNO.Finder.Spotlight.Mgr.statusMgr.applyData({searchType:t.type}).fireEvent("changeSearchType",t.type),!_S("is_admin"))return SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("appready"),void this.sendWebAPI({api:"SYNO.Finder.Preference",method:"get",version:1,scope:this,callback:function(t,e){t&&SYNO.Finder.Spotlight.Mgr.statusMgr&&SYNO.Finder.Spotlight.Mgr.statusMgr.applyData({preference:e})}});this.sendWebAPI({compound:{params:[{api:"SYNO.Finder.FileIndexing.Folder",method:"list",version:1,params:{direction:"asc",sort_by:"path",offset:0,additional:[]}},{api:"SYNO.Finder.Preference",method:"get",version:1}]},scope:this,callback:function(t,e){if(t&&!e.has_fail&&SYNO.Finder.Spotlight.Mgr.statusMgr){var i=!e.result[1].data.hide_searchnow_index_prompt&&!e.result[0].data.folder.length;SYNO.Finder.Spotlight.Mgr.statusMgr.applyData({preference:e.result[1].data}),SYNO.Finder.Utils.debug("Need to show prompt",i),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("appready",i)}}})},onEsc:Ext.emptyFn,onHide:function(){SYNO.Finder.Spotlight.core.disableKeyMap(),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("pausemusic"),SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("hideCatMenu")},onClose:function(){SYNO.Finder.Spotlight.core.disableKeyMap(),this.callParent(arguments),SYNO.SDS.StatusNotifier.fireEvent("spotlightclose")},onFinderSpotlightHide:function(){this.close()},onDataAllLoaded:function(){}}),Ext.define("SYNO.Finder.Spotlight.MainPanel",{extend:"SYNO.ux.Panel",hasTriggerSearch:!1,constructor:function(t){this.mainPanel=new SYNO.ux.Panel({cls:"main-panel",layout:"hbox",layoutConfig:{align:"stretch"},items:[new SYNO.Finder.Spotlight.ResultList({padding:"2px 0 0 0"}),SYNO.Finder.Spotlight.previewMgr.getPreviewPanel()]}),this.indexPrompt=new SYNO.Finder.Spotlight.IndexPrompt({});var e={layout:"vbox",layoutConfig:{align:"stretch"},items:[new SYNO.Finder.Spotlight.SearchBar,{border:!1,flex:1,layout:"card",activeItem:1,items:[this.mainPanel,this.indexPrompt]}],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"initStateRemove",this.onInitStateRemove,this),this.mon(SYNO.Finder.Spotlight.Mgr.statusMgr,"appready",this.onAppReady,this)},onAppReady:function(t){t?(this.items.get(1).getLayout().setActiveItem(1),SYNO.Finder.Spotlight.core.setState("indexprompt",this.indexPrompt.getContentHeight())):(this.items.get(1).getLayout().setActiveItem(0),SYNO.Finder.Spotlight.core.setState("init"))},onAfterRender:function(){SYNO.Finder.Spotlight.core.createKeyMap()},onInitStateRemove:function(t){"normal"===t?this.items.get(1).getLayout().setActiveItem(0):"indexprompt"===t&&this.items.get(1).getLayout().setActiveItem(1)}}),Ext.define("SYNO.Finder.Spotlight.IndexPrompt",{extend:"SYNO.ux.Panel",constructor:function(t){var e={cls:"index-prompt",layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"container",cls:"magnifier",width:108,margins:"0 34 0 0"},{border:!1,layout:"auto",flex:1,items:[{xtype:"container",html:SYNO.Finder.Utils._T("common","prompt_search_now")},{xtype:"syno_button",cls:"add-now-btn",text:SYNO.Finder.Utils._T("common","prompt_add_now"),scope:this,handler:this.onAddNowClick},{height:26,border:!1,margins:"24 0 0 0",layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"syno_checkbox",boxLabel:SYNO.Finder.Utils._T("common","prompt_searchnow_dont_show_again"),scope:this,handler:this.onCheck},{xtype:"container",cls:"progress-indicator",width:24,margins:"0 0 0 22"}]}]}]};this.callParent([Ext.apply(e,t)])},onCheck:function(){var t=SYNO.Finder.Spotlight.Mgr.statusMgr.getData("preference",{});this.addClass("syncing"),this.sendWebAPI({api:"SYNO.Finder.Preference",version:1,method:"set",params:{data:Ext.apply(t,{hide_searchnow_index_prompt:!0})},scope:this,callback:function(){this.removeClass("syncing"),this.addClass("done"),window.setTimeout(function(){SYNO.Finder.Spotlight.Mgr.statusMgr&&SYNO.Finder.Spotlight.Mgr.statusMgr.fireEvent("promptHide")},600)}})},onAddNowClick:function(){SYNO.SDS.AppLaunch("SYNO.Finder.Application",{fn:"preference"}),SYNO.SDS.SearchBox.toggleBox()},getContentHeight:function(){return 16+this.items.get(1).items.get(0).getHeight()+10+28+24+26+20}}),Ext.define("SYNO.Finder.ContextView",{extend:"SYNO.Finder.ViewBase",constructor:function(t){var e={panelCls:"context-view",itemSelector:"div.context-entry",dataViewTpl:this.createTemplate()};this.callParent([Ext.apply(e,t)])},createTemplate:function(){return new Ext.XTemplate('<tpl for=".">','<div class="context-entry">',"{[this.getIconHtml(values)]}",'<div class="info-wrapper">',"<span ext:qtip=\"{[Ext.util.Format.htmlEncode(SYNO.Finder.Utils.escapeHighlight(values.contextItemTitle || '-'))]}\" class=\"title\">{[SYNO.Finder.Utils.escapeHighlight(values.contextItemTitle || '-')]}</span>","<div ext:qtip=\"{[Ext.util.Format.htmlEncode(SYNO.Finder.Utils.escapeHighlight(values.contextItemSnippet || '-'))]}\" class=\"snippet\">{[SYNO.Finder.Utils.escapeHighlight(values.contextItemSnippet || '-')]}</div>","</div>","</div>","</tpl>",{getIconHtml:function(t){return t.contextItemIconSrc?String.format('<div class="icon"><img src="{0}"></div>',Ext.util.Format.htmlEncode(t.contextItemIconSrc)):String.format('<span class="{0}"></span>',Ext.util.Format.htmlEncode(t.contextItemIconCls))}})}}),Ext.define("SYNO.Finder.ResultList",{extend:"SYNO.Finder.ViewBase",constructor:function(t){var e={panelCls:"list-view",itemSelector:"div.list-entry",dataViewTpl:this.createTemplate()};this.callParent([Ext.apply(e,t)])},createTemplate:function(){return new Ext.XTemplate('<tpl for=".">','<div class="list-entry">','<div class="left-col">',"{[this.getIconHtml(values)]}","<span ext:qtip=\"{[SYNO.Finder.Utils.doubleHtmlEncode(values.listItemTitle || '-')]}\" class=\"title\">{[Ext.util.Format.htmlEncode(values.listItemTitle || '-')]}</span>","</div>",'<div class="right-col">',"<span class=\"subtitle ellipsis reverse-ellipsis\"><span ext:qtip=\"{[SYNO.Finder.Utils.doubleHtmlEncode(values.listItemSubtitle || '-')]}\">{[Ext.util.Format.htmlEncode(values.listItemSubtitle || '-')]}</span></span>","</div>","</div>","</tpl>",{getIconHtml:function(t){return t.listItemIconSrc?String.format('<div class="icon float-icon"><img src="{0}"></div>',Ext.util.Format.htmlEncode(t.listItemIconSrc)):String.format('<span class="{0} float-icon"></span>',Ext.util.Format.htmlEncode(t.listItemIconCls))}})}}),Ext.define("SYNO.Finder.ThumbnailView",{extend:"SYNO.Finder.ViewBase",ENTRY_WIDTH:130,MININUM_THUMBNAIL_INTERVAL:28,constructor:function(t){var e={panelCls:"thumbnail-view",itemSelector:"div.thumbnail-entry",dataViewTpl:this.getTemplate(),listeners:{scope:this,afterlayout:this.onAfterLayout}};this._data=[],this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,"changeViewMode",this.onChangeViewMode,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchCategoryChanged",this.onCleanStore,this),this.callParent(arguments)},onAfterLayout:function(){this.adjustIcons(),setTimeout(this.adjustFlexScrollPosition.createDelegate(this),200)},onActivate:function(){this.adjustIcons(),this.callParent(arguments)},onChangeViewMode:function(t){this.itemId===t&&(this.onUpdateStore(),this.superclass().onActivate.call(this))},onCleanStore:function(){this._data=[],this.getStore().removeAll()},onSearchDone:function(t,e,i){this.maybeClearStorePool(),i?this._data=this._data.concat(e):(this.onCleanStore(),this._data=e),this.itemId===SYNO.Finder.Mgr.statusMgr.getData("currentViewMode")&&this.onUpdateStore(t,i)},onUpdateStore:function(t,e){this.getStore().loadData(this._data,!0),this._data=[],!this.isVisible()||"file"!==t||e&&0!==this.dataview.getSelectionCount()||this.dataview.store.findBy(function(t,e){if(SYNO.Finder.Utils.getFileIDFromRecord(t)===SYNO.Finder.Mgr.statusMgr.getData("currentSelectedFile",""))return this.dataview.onSelectEntry(t),!1},this)},onStoreLoad:function(t,e){this.rendered&&(e.length&&this.bindImgLoadEvents(e.length),this.isVisible()&&this.adjustIcons()),this.callParent(arguments)},onMyResize:function(t,e,i,n,r){this.dataview.rendered&&this.adjustIcons()},onThumbnailLoadDefaultError:function(t,e){e.parentNode&&this&&this.el&&this.el.dom&&this.el.dom.parentNode&&(Ext.get(e).un("error",this.onThumbnailLoadDefaultError,this),e.src="",e.parentNode&&e.parentNode.parentNode.removeClassName("show-loading"))},onThumbnailLoadError:function(t,e){e.parentNode&&this&&this.el&&this.el.dom&&this.el.dom.parentNode&&(Ext.get(e).un("error",this.onThumbnailLoadError,this).un("load",this.onThumbnailLoadSuccess,this).on("load",this.onThumbnailLoadSuccess,this).on("error",this.onThumbnailLoadDefaultError,this),e.src=e.getAttribute("data-default-icon"))},onAudioCoverLoadSuccess:function(t,e,i,n){if(this&&this.el&&this.el.dom&&this.el.dom.parentNode){var r=e.parentNode;e.src.indexOf(e.getAttribute("data-default-icon"))<0&&(r.addClassName("success").removeChild(e),r.style.backgroundImage="url('"+e.src+"')",r.addClassName("syno-audio"),"file"===SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory")&&r.addClassName("show-after-filetype "+n))}},onVideoCoverLoadSuccess:function(t,e,i,n){if(this&&this.el&&this.el.dom&&this.el.dom.parentNode){var r=e.parentNode;e.src.indexOf(e.getAttribute("data-default-icon"))<0&&(r.addClassName("success").removeChild(e),r.style.backgroundImage="url('"+e.src+"')",r.addClassName("syno-video"),"file"===SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory")&&r.addClassName("show-after-filetype "+n))}},onDocumentThumbLoadSuccess:function(t,e,i,n){if(this&&this.el&&this.el.dom&&this.el.dom.parentNode){var r,s=e.parentNode;e.src.indexOf(e.getAttribute("data-default-icon"))<0&&(r=e.naturalHeight>e.naturalWidth?"syno-document-portrait":"syno-document-landscape",s.addClassName("success").removeChild(e),s.style.backgroundImage="url('"+e.src+"')",s.addClassName(r),"file"===SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory")&&s.addClassName("show-after-filetype "+n))}},onThumbnailLoadSuccess:function(t,e,i,n){this&&this.el&&this.el.dom&&this.el.dom.parentNode&&window.setTimeout(function(){n&&n.removeClass("show-loading");var t=e.parentNode;t&&(e.src.indexOf(e.getAttribute("data-default-icon"))<0?t.addClassName("success"):t.addClassName("success-default"))},0)},adjustFlexScrollPosition:function(){var t=this.el.query(".x-view-selected")[0];if(t&&t.offsetParent&&t.offsetParent.parentNode){if(t.offsetTop+t.offsetParent.offsetTop<0)return void this.fleXcrollTo(t);if(t.offsetTop+t.offsetParent.offsetTop+t.offsetHeight>t.offsetParent.parentNode.offsetHeight){
var e=this.el.query(".flexcrollactive")[0];if(!e)return;e.fleXcroll.scrollContent(0,t.offsetTop+t.offsetParent.offsetTop+t.offsetHeight-t.offsetParent.parentNode.offsetHeight)}}},bindImgLoadEvents:function(t){var e=this.getStore().getCount();Ext.each(this.el.query(this.itemSelector),function(i,n){if(e-n>t)return!0;var r=this.getStore().getAt(n),s=SYNO.Finder.Utils.EntryType(r.get("listItemTitle")),a=r.get("listItemIconCls"),o=Ext.get(i.querySelector(".thumbnail-wrapper")),l=Ext.get(i.querySelector("img"));if(""===l.dom.getAttribute("src"))return void this.onThumbnailLoadError.call(this,null,l.dom);l.on("load",this.onThumbnailLoadSuccess.createDelegate(this,[o],!0)),"audio"===s?l.on("load",this.onAudioCoverLoadSuccess.createDelegate(this,[a],!0)):"video"===s?l.on("load",this.onVideoCoverLoadSuccess.createDelegate(this,[a],!0)):"document"===s&&l.on("load",this.onDocumentThumbLoadSuccess.createDelegate(this,[a],!0)),l.on("error",this.onThumbnailLoadError,this)},this)},getTemplate:function(){return new Ext.XTemplate('<tpl for=".">','<div id="{[this.getId(values)]}" class="thumbnail-entry">','<div class="thumbnail-wrapper show-loading">','<span class="helper"></span>','<div class="outline-image-container"><img data-failed="0" ext:qtip="{[SYNO.Finder.Utils.doubleHtmlEncode(values.thumbnailItemTitle || \'-\')]}" data-default-icon="{values.thumbnailItemDefaultIcon:htmlEncode}" src="{values.thumbnailItemSrc:htmlEncode}"></div>',"</div>","<div ext:qtip=\"{[SYNO.Finder.Utils.doubleHtmlEncode(values.thumbnailItemTitle || '-')]}\" class=\"title\">{[Ext.util.Format.htmlEncode(values.thumbnailItemTitle || '-')]}</div>","</div>","</tpl>",{getId:function(t){return t.extid=Ext.id()}})},adjustIcons:function(){SYNO.Finder.Utils.debug("Adjust icons: "+this.dataview.getWidth());var t=this.dataview.getWidth()-16,e=Math.floor(t/this.ENTRY_WIDTH),i=(t-this.ENTRY_WIDTH*e)/(e+1);i<this.MININUM_THUMBNAIL_INTERVAL&&(e--,i=(t-this.ENTRY_WIDTH*e)/(e+1)),SYNO.Finder.Utils.debug(e),this.getStore().each(function(t,n){var r=Ext.getDom(t.get("extid"));r&&(n%e==0?r.setStyle({"margin-left":i-1+"px","margin-right":i/2+"px"}):n%e==e-1?r.setStyle({"margin-left":i/2+"px","margin-right":i-1+"px"}):r.setStyle({"margin-left":i/2+"px","margin-right":i/2+"px"}))})}}),Ext.define("SYNO.Finder.DetailView",{extend:"SYNO.Finder.ViewBase",constructor:function(t){var e={panelCls:"detail-view",dataViewTpl:this.createTemplate(),itemSelector:"div.detail-entry"};this.callParent([Ext.apply(e,t)])},createTemplate:function(){return new Ext.XTemplate('<tpl for=".">','<div class="detail-entry">','<div class="main-info">','<div class="left-col ellipsis">',"{[this.getIconHtml(values)]}","<span ext:qtip=\"{[SYNO.Finder.Utils.doubleHtmlEncode(values.detailItemTitleQTip || values.detailItemTitle || '-')]}\" class=\"title\">{[Ext.util.Format.htmlEncode(values.detailItemTitle || '-')]}</span>","</div>",'<div class="right-col">',"<span class=\"subtitle ellipsis reverse-ellipsis\"><span ext:qtip=\"{[SYNO.Finder.Utils.doubleHtmlEncode(values.detailItemSubtitleQTip || values.detailItemSubtitle ||  '-')]}\">{[Ext.util.Format.htmlEncode(values.detailItemSubtitle || '-')]}</span></span>","</div>",'<div class="x-clear"></div>',"</div>",'<div class="sub-info">','<div class="left-col ellipsis">',"<span ext:qtip=\"{[SYNO.Finder.Utils.doubleHtmlEncode(values.detailItemLeftInfoQTip || values.detailItemLeftInfo || '-')]}\" class=\"left-info\">{[Ext.util.Format.htmlEncode(values.detailItemLeftInfo.trim() || '-')]}</span>","</div>","<div>","<span ext:qtip=\"{[SYNO.Finder.Utils.doubleHtmlEncode(values.detailItemRightInfoQTip || values.detailItemRightInfo || '-')]}\" class=\"right-info\">{[Ext.util.Format.htmlEncode(values.detailItemRightInfo.trim() || '-')]}</span>","</div>",'<div class="x-clear"></div>',"</div>","</div>","</tpl>",{getIconHtml:function(t){return t.detailItemIconSrc?String.format('<div class="icon float-icon"><img src="{0}"></div>',Ext.util.Format.htmlEncode(t.detailItemIconSrc)):String.format('<span class="{0} float-icon"></span>',Ext.util.Format.htmlEncode(t.detailItemIconCls))}})}}),Ext.define("SYNO.Finder.AllResultView",{extend:"SYNO.Finder.ViewBase",infiniteMode:!1,searchTotalCount:0,constructor:function(t){var e={cls:"list-view",layout:"auto",items:[this.fileSection=new SYNO.Finder.Component.View.AllResult.Section({title:SYNO.Finder.Utils._T("common","category_all_files"),itemId:"file",searcherName:"file",store:this.getStore("file")}),new SYNO.Finder.Component.View.AllResult.Section({title:SYNO.Finder.Utils._T("common","category_help"),itemId:"help",searcherName:"help",store:this.getStore("help")}),new SYNO.Finder.Component.View.AllResult.Section({title:SYNO.Finder.Utils._T("common","category_app"),itemId:"app",searcherName:"app",store:this.getStore("app")})],fbar:{cls:"total-bar",items:[{xtype:"container",data:{count:0},tpl:new Ext.XTemplate(SYNO.Finder.Utils._T("common","total_bar_items"))}]}};this.callParent([Ext.apply(e,t)]),this.onCreatePlugins()},initEvents:function(){this.callParent(arguments),this.mon(this,"resize",this.onMyResize,this),this.mon(SYNO.Finder.Mgr.statusMgr,"doSearch",this.onDoSearch,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchTotalAdd",this.onSearchTotalAdd,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchRecordClicked",this.onSearchRecordClicked,this),this.mon(SYNO.Finder.Mgr.pluginMgr,"pluginadd",this.onAddPlugin,this),this.mon(SYNO.Finder.Mgr.pluginMgr,"pluginremove",this.onRemovePlugin,this)},onAfterRender:function(){this.items.each(function(t){t.hide()})},onSearchDone:function(t,e,i){this.maybeClearStorePool(),this.getStore(t).loadData(e,i),this.isVisible()&&"file"===t&&0===this.fileSection.dataview.getSelectionCount()&&this.fileSection.dataview.store.findBy(function(t,e){if(SYNO.Finder.Utils.getFileIDFromRecord(t)===SYNO.Finder.Mgr.statusMgr.getData("currentSelectedFile",""))return this.fileSection.dataview.onSelectEntry(t),!1},this);var n=this.getComponent(t);n&&(e.length?n.show():n.hide());var r=null;this.items.each(function(t){t.isVisible()&&(r=t),t.setLastSection(!1)}),r&&r.setLastSection(!0),this.updateFleXcroll()},onCreatePlugins:function(){Ext.each(SYNO.Finder.Mgr.pluginMgr.getPlugins(),function(t){this.onAddPlugin(t)},this)},onDoSearch:function(){this.searchTotalCount=0,this.searchTotalEmptyCount=0},onSearchTotalAdd:function(t,e){this.searchTotalCount+=e,this.searchTotalEmptyCount+=!e,this.getFooterToolbar().items.get(0).update({count:this.searchTotalCount||"..."}),this.searchTotalEmptyCount===this.items.getCount()&&SYNO.Finder.Mgr.statusMgr.fireEvent("noResultFound")},onSearchRecordClicked:function(t,e){e&&Ext.each(this.items.items,function(t){t.el&&!t.el.contains(e)&&t.dataview.clearSelections()})},onAddPlugin:function(t){var e=t.getPluginId(),i=new SYNO.Finder.Component.View.AllResult.Section({itemId:e,title:t.getText(),searcherName:e,store:this.getStore(e),renderTo:this.el});this.add(i),this.doLayout(),i.hide()},onRemovePlugin:function(t){this.remove(t),this.updateFleXcroll()},onMyResize:function(t,e){e>10&&this.updateFleXcroll()}}),Ext.define("SYNO.Finder.Component.View.AllResult.Section",{extend:"SYNO.ux.Panel",constructor:function(t){this.loadMoreBut=new SYNO.Finder.LoadMore({listeners:{scope:this,click:this.onLoadMoreClick}}),this.dataview=new SYNO.Finder.ResultDataView({store:t.store,singleSelect:!0,autoFlexcroll:!1,tpl:this.createTemplate(),itemSelector:"div.list-entry"}),this.countString="";var e={items:[{border:!1,tpl:new Ext.XTemplate('<div class="view-section-title">{title:htmlEncode} <span class="count">{count:htmlEncode}</span></div>'),data:{title:t.title,count:"(0)"}},this.dataview,this.loadMoreBut],listeners:{afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},onAfterRender:function(){this.countingTask={run:this.updateCountingProgress.createDelegate(this),interval:400},this.countingRunner=new Ext.util.TaskRunner},updateCountingProgress:function(){this.countString+=".",3<this.countString.length&&(this.countString=""),this.items.items[0].update({title:this.title,count:this.countString})},initEvents:function(){this.callParent(arguments),this.mon(SYNO.Finder.Mgr.statusMgr,{searchReachEnd:this.onSearchReachEnd,doSearch:this.onDoSearch,searchTotalAdd:this.onSearchTotalAdd,scope:this})},setLastSection:function(t){t?this.loadMoreBut.addClass("last"):this.loadMoreBut.removeClass("last")},onDestroy:function(){this.callParent(arguments),this.runningTask&&(SYNO.Finder.Utils.debug("destroy remaining background task"),this.countingRunner.stop(this.runningTask))},onSearchTotalAdd:function(t,e){t===this.searcherName&&(this.items.items[0].update({title:this.title,count:"("+e+")"}),this.runningTask&&this.countingRunner.stop(this.runningTask),this.runningTask=null)},onSearchReachEnd:function(t){t===this.searcherName&&this.loadMoreBut.hideText()},onDoSearch:function(t,e){if(t===this.searcherName&&"all"===SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory","")){if(e)return;this.runningTask&&this.countingRunner.stop(this.runningTask),this.runningTask=this.countingRunner.start(this.countingTask),window.setTimeout(function(){this.loadMoreBut.showText()}.createDelegate(this),SYNO.Finder.Mgr.statusMgr.BOARD_FADE_OUT_DELAY)}},onLoadMoreClick:function(t){SYNO.Finder.Mgr.statusMgr.fireEvent("loadMore",this.searcherName)},createTemplate:function(){return new Ext.XTemplate('<tpl for=".">','<div class="list-entry">','<div class="left-col">',"{[this.getIconHtml(values)]}","<span ext:qtip=\"{[SYNO.Finder.Utils.doubleHtmlEncode(values.listItemTitle || '-')]}\" class=\"title\">{[Ext.util.Format.htmlEncode(values.listItemTitle || '-')]}</span>","</div>",'<div class="right-col">',"<span class=\"subtitle ellipsis reverse-ellipsis\"><span ext:qtip=\"{[SYNO.Finder.Utils.doubleHtmlEncode(values.listItemSubtitle || '-')]}\">{[Ext.util.Format.htmlEncode(values.listItemSubtitle || '-')]}</span></span>","</div>",'<div class="x-clear"></div>',"</div>","</tpl>",{getIconHtml:function(t){return t.listItemIconSrc?String.format('<div class="float-icon icon"><img src="{0}"></div>',Ext.util.Format.htmlEncode(t.listItemIconSrc)):String.format('<span class="{0} float-icon"></span>',Ext.util.Format.htmlEncode(t.listItemIconCls))}})}}),Ext.ns("SYNO.Finder.Mgr"),Ext.define("SYNO.Finder.Mgr.ViewMode",{extend:"Ext.Component",FINDER_VIEW_ID_LIST:"list",FINDER_VIEW_ID_DETAIL:"detail",FINDER_VIEW_ID_THUMBNAIL:"thumbnail",FINDER_VIEW_ID_SNIPPET:"snippet",FINDER_VIEW_ID_ALLRESULTS:"allresults",FINDER_VIEW_ID_WELCOME:"welcome",FINDER_VIEW_ID_NORESULT:"noresult",LIST_VIEW_MENU_BTN_ICON_CLS:"finder-view-list",DETAIL_VIEW_MENU_BTN_ICON_CLS:"finder-view-detail",THUMBNAIL_VIEW_MENU_BTN_ICON_CLS:"finder-view-thumbnail",SNIPPET_VIEW_MENU_BTN_ICON_CLS:"finder-view-snippet",constructor:function(){this.viewModeMap={},this.categoryDetailMap={},this.callParent(arguments),this.initEvents(),this.initBuiltIn(),this.initPluginView()},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,"searchDone",this.onSearchDone,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchCategoryChanged",this.onSearchCategoryChanged,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchFieldCleared",this.onSearchFieldCleared,this),this.mon(SYNO.Finder.Mgr.statusMgr,"noResultFound",this.onNoResultFound,this),this.mon(SYNO.Finder.Mgr.pluginMgr,"pluginadd",this.onAddPlugin,this),this.mon(SYNO.Finder.Mgr.pluginMgr,"pluginremove",this.onRemovePlugin,this)},initBuiltIn:function(){this.initViewModeMap(),this.initCategoryDetailMap()},initViewModeMap:function(){this.initBuiltInView(),this.viewModeMap[this.FINDER_VIEW_ID_LIST]={iconCls:this.LIST_VIEW_MENU_BTN_ICON_CLS,viewComp:this.listView,title:SYNO.Finder.Utils._T("common","view_list")},this.viewModeMap[this.FINDER_VIEW_ID_DETAIL]={iconCls:this.DETAIL_VIEW_MENU_BTN_ICON_CLS,viewComp:this.detailView,title:SYNO.Finder.Utils._T("common","view_detail")},this.viewModeMap[this.FINDER_VIEW_ID_THUMBNAIL]={iconCls:this.THUMBNAIL_VIEW_MENU_BTN_ICON_CLS,viewComp:this.iconView,title:SYNO.Finder.Utils._T("common","view_thumbnail")},this.viewModeMap[this.FINDER_VIEW_ID_SNIPPET]={iconCls:this.SNIPPET_VIEW_MENU_BTN_ICON_CLS,viewComp:this.contextView,title:SYNO.Finder.Utils._T("common","view_snippet")},this.viewModeMap[this.FINDER_VIEW_ID_ALLRESULTS]={iconCls:this.LIST_VIEW_MENU_BTN_ICON_CLS,viewComp:this.allResultsView,hidden:!0,disableChangeViewBtn:!0},this.viewModeMap[this.FINDER_VIEW_ID_WELCOME]={iconCls:null,viewComp:this.welcomeView,hidden:!0,disableChangeViewBtn:!0},this.viewModeMap[this.FINDER_VIEW_ID_NORESULT]={iconCls:null,viewComp:this.noResultView,hidden:!0,disableChangeViewBtn:!0},this.defaultViewID=[this.FINDER_VIEW_ID_SNIPPET,this.FINDER_VIEW_ID_DETAIL,this.FINDER_VIEW_ID_THUMBNAIL]},initCategoryDetailMap:function(){this.categoryDetailMap={all:{title:SYNO.Finder.Utils._T("common","category_all_results"),views:[this.FINDER_VIEW_ID_ALLRESULTS]},file:{title:SYNO.Finder.Utils._T("common","category_all_files"),searcherName:"file",views:[this.FINDER_VIEW_ID_LIST,this.FINDER_VIEW_ID_DETAIL,this.FINDER_VIEW_ID_THUMBNAIL]},document:{title:SYNO.Finder.Utils._T("common","type_document"),searcherName:"file",views:[this.FINDER_VIEW_ID_SNIPPET,this.FINDER_VIEW_ID_LIST,this.FINDER_VIEW_ID_DETAIL,this.FINDER_VIEW_ID_THUMBNAIL]},audio:{title:SYNO.Finder.Utils._T("common","type_music"),searcherName:"file",views:[this.FINDER_VIEW_ID_DETAIL,this.FINDER_VIEW_ID_THUMBNAIL,this.FINDER_VIEW_ID_LIST]},image:{title:SYNO.Finder.Utils._T("common","type_photo"),searcherName:"file",views:[this.FINDER_VIEW_ID_THUMBNAIL,this.FINDER_VIEW_ID_LIST,this.FINDER_VIEW_ID_DETAIL]},video:{title:SYNO.Finder.Utils._T("common","type_video"),searcherName:"file",views:[this.FINDER_VIEW_ID_THUMBNAIL,this.FINDER_VIEW_ID_LIST,this.FINDER_VIEW_ID_DETAIL]},help:{title:SYNO.Finder.Utils._T("common","category_help"),searcherName:"help",views:[this.FINDER_VIEW_ID_LIST]},app:{title:SYNO.Finder.Utils._T("common","category_app"),searcherName:"app",views:[this.FINDER_VIEW_ID_LIST,this.FINDER_VIEW_ID_SNIPPET]}}},initBuiltInView:function(){this.allResultsView=new SYNO.Finder.AllResultView({itemId:this.FINDER_VIEW_ID_ALLRESULTS}),this.listView=new SYNO.Finder.ResultList({itemId:this.FINDER_VIEW_ID_LIST}),this.iconView=new SYNO.Finder.ThumbnailView({itemId:this.FINDER_VIEW_ID_THUMBNAIL}),this.contextView=new SYNO.Finder.ContextView({itemId:this.FINDER_VIEW_ID_SNIPPET}),this.detailView=new SYNO.Finder.DetailView({itemId:this.FINDER_VIEW_ID_DETAIL}),this.welcomeView=new SYNO.ux.Panel({itemId:this.FINDER_VIEW_ID_WELCOME,cls:"finder-welcome",layout:{type:"vbox",align:"stretch"},items:[{xtype:"syno_panel",flex:2},{xtype:"container",height:212,html:'<div class="magnify-glass"></div><div class="welcome-msg">'+SYNO.Finder.Utils._T("common","search_prompt_msg")+"</div>"},{xtype:"syno_panel",flex:3}]}),this.noResultView=new SYNO.ux.Panel({itemId:this.FINDER_VIEW_ID_NORESULT,cls:"finder-noresult",layout:{type:"vbox",align:"stretch"},items:[{xtype:"syno_panel",flex:2},{xtype:"container",height:144,html:'<span class="helper"></span><div class="wrapper"><h1>'+SYNO.Finder.Utils._T("common","no_result_title")+'</h1><div class="msg">'+SYNO.Finder.Utils._T("common","no_result_content")+"</div></div>"},{xtype:"syno_panel",flex:3}]}),this.addManagedComponent(this.allResultsView),this.addManagedComponent(this.listView),this.addManagedComponent(this.iconView),this.addManagedComponent(this.contextView),this.addManagedComponent(this.detailView),this.addManagedComponent(this.welcomeView),this.addManagedComponent(this.noResultView)},initPluginView:function(){Ext.each(SYNO.Finder.Mgr.pluginMgr.getPlugins(),function(t){this.onAddPlugin(t)},this)},onSearchDone:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory","");[SYNO.Finder.Mgr.viewModeMgr.FINDER_VIEW_ID_WELCOME,SYNO.Finder.Mgr.viewModeMgr.FINDER_VIEW_ID_NORESULT].indexOf(SYNO.Finder.Mgr.statusMgr.getData("currentViewMode"))>=0&&this.changeViewMode(t)},onSearchCategoryChanged:function(t){[SYNO.Finder.Mgr.viewModeMgr.FINDER_VIEW_ID_WELCOME,SYNO.Finder.Mgr.viewModeMgr.FINDER_VIEW_ID_NORESULT].indexOf(SYNO.Finder.Mgr.statusMgr.getData("currentViewMode"))>=0||this.changeViewMode(t)},onAddPlugin:function(t){if(!this.categoryDetailMap.hasOwnProperty(t.getPluginId())){var e=[this.FINDER_VIEW_ID_LIST];if(Ext.each(this.defaultViewID,function(i){t.isEnableViewMode(i)&&e.push(i)},this),t.hasCustomViewMode())try{Ext.each(t.getCustomViewMode(),function(t){this.viewModeMap[t.getId()]={iconCls:t.getIconCls(),title:t.getText(),viewComp:this.onCreatePluginViewComp(t)},e.push(t.getId()),SYNO.Finder.Mgr.statusMgr.fireEvent("updateViewMode",t.getId(),this.viewModeMap[t.getId()])},this)}catch(t){SYNO.Debug.error(t)}this.categoryDetailMap[t.getPluginId()]={title:t.getText(),searcherName:t.getPluginId(),views:e}}},onCreatePluginViewComp:function(t){var e=new SYNO.Finder.ViewBase({panelCls:t.getPanelCls(),itemId:t.getId(),itemSelector:t.getItemSelector(),dataViewTpl:t.getTemplate()});return this.addManagedComponent(e),e},onRemovePlugin:function(t){this.categoryDetailMap.hasOwnProperty(t)&&(Ext.each(this.categoryDetailMap[t].views,function(t){-1===this.defaultViewID.indexOf(t)&&delete this.viewModeMap[t]},this),delete this.categoryDetailMap[t])},onSearchFieldCleared:function(){SYNO.Finder.Mgr.statusMgr.applyData({currentViewMode:this.FINDER_VIEW_ID_WELCOME}).fireEvent("changeViewMode",this.FINDER_VIEW_ID_WELCOME)},onNoResultFound:function(){SYNO.Finder.Mgr.statusMgr.applyData({currentViewMode:this.FINDER_VIEW_ID_NORESULT}).fireEvent("changeViewMode",this.FINDER_VIEW_ID_NORESULT)},changeViewMode:function(t){var e=SYNO.Finder.Mgr.viewModeMgr.getCategoryDetails();SYNO.Finder.Mgr.statusMgr.applyData({currentViewMode:e[t].views[0]}).fireEvent("changeViewMode",e[t].views[0])},getIconClsByViewMode:function(t){return this.viewModeMap[t].iconCls},getIconClsByCategory:function(t){return this.viewModeMap[this.categoryDetailMap[t].views[0]].iconCls},getViewModeMap:function(){return this.viewModeMap},getSearcherNameByCategory:function(t){return this.categoryDetailMap.hasOwnProperty(t)?this.categoryDetailMap[t].searcherName:""},getCategoryDetails:function(){return this.categoryDetailMap},getAllViewComp:function(){var t=[];return Ext.iterate(this.viewModeMap,function(e,i){t.push(i.viewComp)}),t}}),Ext.ns("SYNO.Finder.Mgr"),Ext.define("SYNO.Finder.Mgr.Bookmark",{extend:"Ext.Component",constructor:function(){this.callParent(),this.initEvents()},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,"bookmarksave",this.sendAddBookmarkWebAPI,this),this.mon(SYNO.Finder.Mgr.statusMgr,"bookmarkremove",this.sendDelBookmarkWebAPI,this),this.mon(SYNO.Finder.Mgr.statusMgr,"bookmarkloaded",this.onBookmarkLoad,this)},onBookmarkLoad:function(t){this.getStore().loadData(t)},getStore:function(){return Ext.isDefined(this.store)||(this.store=new Ext.data.JsonStore({fields:["name","keyword","criteria"]})),this.store},sendAddBookmarkWebAPI:function(t){var e={name:t,keyword:SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword",""),criteria:SYNO.Finder.Mgr.statusMgr.getData("currentSearchCriteria",[])};this.sendWebAPI({api:"SYNO.Finder.Bookmark",appWindow:!1,method:"add",version:1,scope:this,params:e,callback:function(t,i){t&&(this.getStore().loadData([e],!0),SYNO.Finder.Mgr.statusMgr.fireEvent("bookmarksavesuccess",e))}})},sendGetBookmarkWebAPI:function(){this.sendWebAPI({api:"SYNO.Finder.Bookmark",appWindow:!1,method:"get",version:1,scope:this,callback:function(t,e){t&&(e&&this.getStore().loadData(e),SYNO.Finder.Mgr.statusMgr.fireEvent("bookmarkloaded",e.data.bookmarks))}})},sendDelBookmarkWebAPI:function(t){if(!(t<0)){var e=this.getStore().getAt(t).get("name");this.getStore().removeAt(t),this.sendWebAPI({api:"SYNO.Finder.Bookmark",appWindow:!1,method:"del",version:1,params:{name:e},scope:this,callback:function(t,i){t&&(SYNO.Finder.Mgr.statusMgr.fireEvent("bookmarkremoved",e),SYNO.Finder.Mgr.statusMgr.fireEvent("bookmarkCheckDisable",this.getStore().getCount()))}})}}}),Ext.ns("SYNO.Finder.Mgr"),Ext.define("SYNO.Finder.Mgr.Facet",{extend:"Ext.Component",criteriaList:[[SYNO.Finder.Utils._T("common","meta_created_date"),"twindate","SYNOMDFSCreationDate","y"],[SYNO.Finder.Utils._T("common","meta_mod_date"),"twindate","SYNOMDContentModificationDate","y"],[SYNO.Finder.Utils._T("common","meta_last_accessed_date"),"twindate","SYNOMDLastUsedDate","y"],[SYNO.Finder.Utils._T("common","meta_extension"),"combofield","SYNOMDExtension","y"],[SYNO.Finder.Utils._T("common","meta_size_mb"),"sizefield","SYNOMDFSSize","y"],[SYNO.Finder.Utils._T("common","meta_owner"),"combobox","SYNOMDOwnerUserID","y"],[SYNO.Finder.Utils._T("common","meta_group"),"combobox","SYNOMDOwnerGroupID","y"],[SYNO.Finder.Utils._T("common","meta_author"),"textfield","SYNOMDAuthors","y"],[SYNO.Finder.Utils._T("common","meta_title"),"textfield","SYNOMDTitle","y"],[SYNO.Finder.Utils._T("common","meta_album"),"textfield","SYNOMDAlbum","y"],[SYNO.Finder.Utils._T("common","meta_record_year"),"numberfield","SYNOMDRecordingYear","y"],[SYNO.Finder.Utils._T("common","meta_creator"),"textfield","SYNOMDCreator","y"],[SYNO.Finder.Utils._T("common","meta_genre"),"textfield","SYNOMDMusicalGenre","y"],[SYNO.Finder.Utils._T("common","meta_composer"),"textfield","SYNOMDComposer","y"],[SYNO.Finder.Utils._T("common","meta_duration_min"),"timefield","SYNOMDDurationSecond","y"],[SYNO.Finder.Utils._T("common","meta_audio_bitrate"),"numberfield","SYNOMDAudioBitRate","y"],[SYNO.Finder.Utils._T("common","meta_audio_sample_rate"),"numberfield","SYNOMDAudioSampleRate","y"],[SYNO.Finder.Utils._T("common","meta_video_bitrate"),"numberfield","SYNOMDVideoBitRate","y"],[SYNO.Finder.Utils._T("common","meta_video_codec"),"combofield","SYNOMDCodecs","y"],[SYNO.Finder.Utils._T("common","meta_description"),"textfield","SYNOMDDescription","y"],[SYNO.Finder.Utils._T("common","meta_rating"),"combofield","SYNOMDStarRating","y"],[SYNO.Finder.Utils._T("common","meta_ISO"),"combofield","SYNOMDISOSpeed","y"],[SYNO.Finder.Utils._T("common","meta_acquisition_make"),"textfield","SYNOMDAcquisitionMake","y"],[SYNO.Finder.Utils._T("common","meta_acquisition_model"),"textfield","SYNOMDAcquisitionModel","y"],[SYNO.Finder.Utils._T("common","meta_exposure"),"twincombo","SYNOMDExposureTimeString","y"],[SYNO.Finder.Utils._T("common","meta_aperture"),"twincombo","SYNOMDAperture","y"],[SYNO.Finder.Utils._T("common","meta_resolution_width"),"sizefield","SYNOMDResolutionWidthDPI","y"],[SYNO.Finder.Utils._T("common","meta_resolution_height"),"sizefield","SYNOMDResolutionHeightDPI","y"]],constructor:function(){this.callParent(arguments)},registerInUse:function(t){SYNO.Finder.Utils.debug("register criteria",t),this.store.clearFilter();var e=this.store.find("SYNOMDFieldName",t);if(!(e<0)){var i=this.store.getAt(e);i.set("idle","n"),i.commit()}},unregisterInUse:function(t,e){SYNO.Finder.Utils.debug("unregister criteria",t),this.store.clearFilter(e);var i=this.store.findBy(function(e){return e.get("SYNOMDFieldName")===t||e.get("name")===t});if(!(i<0)){var n=this.store.getAt(i);n.set("idle","y"),n.commit()}},getFirstIdleValue:function(){var t=this.getCriteriaNameStore().find("idle","y");return t<0&&(t=0),this.getCriteriaNameStore().getAt(t).get("SYNOMDFieldName")},getSelectorArr:function(){return Ext.isDefined(this.selectorsArray)||(this.selectorsArray=this.createSelectorArray()),this.selectorsArray},getCriteriaNameStore:function(){return Ext.isDefined(this.store)||(this.store=new Ext.data.ArrayStore({fields:["name","type","SYNOMDFieldName","idle"],data:this.criteriaList})),this.store},getUsedCriteriaIndices:function(){var t=[];return this.items.each(function(e){t.push(e.getCriteriaIndex())}),t},getCriteriaIdxByFieldName:function(t){var e=-1;return Ext.each(this.criteriaList,function(i,n){if(i[2]===t)return e=n,!1}),e},getCriteriaTotalCount:function(){return this.criteriaList.length},createSelectorArray:function(){var t=[];return Ext.each(this.criteriaList,function(e){t.push(this.createSelector(e))},this),t},createSelector:function(t){return"twindate"===t[1]?this.createTwinDateSelector(t):"twincombo"==t[1]?this.createTwinComboSelector(t):"combobox"==t[1]?this.createComboboxSelector(t):"combofield"===t[1]?this.createComboFieldSelector(t):"textfield"===t[1]?this.createTextFieldSelector(t):"numberfield"===t[1]?this.createNumberFieldSelector(t):"sizefield"===t[1]?this.createSizeFieldSelector(t):"timefield"===t[1]?this.createTimeFieldSelector(t):void 0},createSelectorByIdx:function(t){return this.createSelector(this.criteriaList[t])},createSelectorByFieldName:function(t){var e;return Ext.each(this.criteriaList,function(i){if(i[0]===t||i[2]===t)return e=i,!1}),this.createSelector(e)},createTwinDateSelector:function(t){return new SYNO.Finder.Component.Facet.Criteria.TwinDateChooser({name:t[0],fieldName:t[2],itemId:t[2]})},createTwinComboSelector:function(t){var e,i=t[2],n={name:t[0],fieldName:t[2],itemId:t[2]},r=new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:[["equal",SYNO.Finder.Utils._T("search","size_equal")],["greater",SYNO.Finder.Utils._T("search","size_greater")],["less",SYNO.Finder.Utils._T("search","size_less")]]});return"SYNOMDAperture"===i?(e=new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:[["f/1.0","f/1.0"],["f/1.4","f/1.4"],["f/2.0","f/2.0"],["f/2.8","f/2.8"],["f/4.0","f/4.0"],["f/5.6","f/5.6"],["f/8.0","f/8"],["f/11.0","f/11"],["f/16.0","f/16"],["f/22.0","f/22"]]}),new SYNO.Finder.Component.Facet.Criteria.TwinComboboxChooser(Ext.apply(n,{lstore:r,rstore:e}))):"SYNOMDExposureTimeString"===i?(e=new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:[['"60 sec."',"60 sec"],['"30 sec."',"30 sec"],['"15 sec."',"15 sec"],['"8 sec."',"8 sec"],['"4 sec."',"4 sec"],['"2 sec."',"2 sec"],['"1 sec."',"1 sec"],['"1/2 sec."',"1/2 sec"],['"1/4 sec."',"1/4 sec"],['"1/8 sec."',"1/8 sec"],['"1/15 sec."',"1/15 sec"],['"1/30 sec."',"1/30 sec"],['"1/60 sec."',"1/60 sec"],['"1/125 sec."',"1/125 sec"],['"1/250 sec."',"1/250 sec"],['"1/500 sec."',"1/500 sec"]]}),new SYNO.Finder.Component.Facet.Criteria.TwinComboboxChooser(Ext.apply(n,{lstore:r,rstore:e}))):null},createTextFieldSelector:function(t){return new SYNO.Finder.Component.Facet.Criteria.TextFieldChooser({name:t[0],fieldName:t[2],itemId:t[2]})},createNumberFieldSelector:function(t){return new SYNO.Finder.Component.Facet.Criteria.NumberFieldChooser({name:t[0],fieldName:t[2],itemId:t[2]})},createComboboxSelector:function(t){var e,i,n=t[2];if("SYNOMDOwnerUserID"===n)e=new SYNO.API.JsonStore({autoDestroy:!0,appWindow:!1,api:"SYNO.Finder.UserGrp",method:"list_user",version:1,root:"users",idProperty:"name",fields:[{name:"name"},{name:"uid"}],baseParams:{type:"all"}}),i="uid";else{if("SYNOMDOwnerGroupID"!==n)return null;e=new SYNO.API.JsonStore({autoDestroy:!0,appWindow:!1,api:"SYNO.Finder.UserGrp",method:"list_group",version:1,root:"groups",idProperty:"name",fields:[{name:"name"},{name:"gid"}],baseParams:{type:"all",name_only:!0}}),i="gid"}return new SYNO.Finder.Component.Facet.Criteria.ComboboxChooser({name:t[0],fieldName:t[2],store:e,mode:"remote",pageSize:50,minChars:1,displayField:"name",valueField:i,editable:!0,tpyeAhead:!0,itemId:t[2]})},createTimeFieldSelector:function(t){var e=t[2],i=1,n="",r=new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:[["equal",SYNO.Finder.Utils._T("search","size_equal")],["greater",SYNO.Finder.Utils._T("search","size_greater")],["less",SYNO.Finder.Utils._T("search","size_less")]]});return"SYNOMDDurationSecond"!==e?null:(i=60,n="Min",new SYNO.Finder.Component.Facet.Criteria.TimeComboboxFieldChooser({name:t[0],fieldName:t[2],store:r,defaultValue:r.getAt(0).get("display"),disableTextField:!1,unit:i,unitText:n,itemId:t[2]}))},createSizeFieldSelector:function(t){var e=1,i="",n=new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:[["equal",SYNO.Finder.Utils._T("search","size_equal")],["greater",SYNO.Finder.Utils._T("search","size_greater")],["less",SYNO.Finder.Utils._T("search","size_less")]]});return"SYNOMDFSSize"===t[2]&&(e=1048576,i="MB"),new SYNO.Finder.Component.Facet.Criteria.SizeComboboxFieldChooser({name:t[0],fieldName:t[2],store:n,unit:e,unitText:i,disableTextField:!1,itemId:t[2]})},createComboFieldSelector:function(t){var e,i=t[2],n={name:t[0],fieldName:t[2],disableTextField:!0,noCustomization:!1,itemId:t[2]};return"SYNOMDExtension"===i?(e=new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:[["dir",SYNO.Finder.Utils._T("search","folder")],["file",SYNO.Finder.Utils._T("search","file")],["document",SYNO.Finder.Utils._T("report","reportUI_file_type_document")],["video",SYNO.Finder.Utils._T("report","reportUI_file_type_video")],["image",SYNO.Finder.Utils._T("report","reportUI_file_type_image")],["audio",SYNO.Finder.Utils._T("report","reportUI_file_type_audio")],["type",SYNO.Finder.Utils._T("search","extension")]]}),new SYNO.Finder.Component.Facet.Criteria.ExtensionFieldChooser(Ext.apply(n,{store:e,textType:"text"}))):"SYNOMDISOSpeed"===i?(e=new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:[["100","100"],["200","200"],["400","400"],["800","800"],["1000","1000"],["1600","1600"],["2000","2000"],["3200","3200"],["6400","6400"],["custom",_T("common","customization")]]}),new SYNO.Finder.Component.Facet.Criteria.ComboboxFieldChooser(Ext.apply(n,{store:e,textType:"number"}))):"SYNOMDCodecs"===i?(e=new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:[["h265","H.265"],["h264","H.264"],["h263","H.263"],["wmv","WMV"],["mp3","MP3"],["custom",_T("common","customization")]]}),new SYNO.Finder.Component.Facet.Criteria.ComboboxFieldChooser(Ext.apply(n,{store:e,textType:"text"}))):"SYNOMDStarRating"===i?(e=new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:[["1","1"],["2","2"],["3","3"],["4","4"],["5","5"]]}),new SYNO.Finder.Component.Facet.Criteria.ComboboxFieldChooser(Ext.apply(n,{store:e,disableTextField:!1,noCustomization:!0,textType:"text"}))):null}}),Ext.ns("SYNO.Finder.Component.Toolkit"),Ext.define("SYNO.Finder.Component.Toolkit.AdvancedSearchButton",{extend:"Ext.Container",TOOLKIT_HEIGHT:24,TOOLKIT_WIDTH:24,constructor:function(t){var e={layout:"fit",cls:"advanced-search-button",width:this.TOOLKIT_WIDTH,height:this.TOOLKIT_HEIGHT,margins:"0px 6px",listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},onAfterRender:function(){this.mon(this.el,"click",function(){SYNO.Finder.Mgr.statusMgr.fireEvent("facetSearchToggled")},this)}}),Ext.ns("SYNO.Finder.Component.Toolkit"),Ext.define("SYNO.Finder.Component.Toolkit.BookmarkIndicator",{extend:"Ext.Container",TOOLKIT_WIDTH:24,TOOLKIT_HEIGHT:24,constructor:function(t){this.currentBookmarkName="";var e={layout:"fit",html:'<a class="bookmark-indicator"></a>',width:this.TOOLKIT_WIDTH,height:this.TOOLKIT_HEIGHT,margins:"0px 4px 0px 5px",listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},onAfterRender:function(){this.el.on("click",this.onClick,this),this.mon(SYNO.Finder.Mgr.statusMgr,"bookmarkapply",this.onBookmarkApply,this),this.mon(SYNO.Finder.Mgr.statusMgr,"bookmarksavesuccess",this.onBookmarkSaveSuccess,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchCriteriaChanged",this.checkMatch,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchKeywordChanged",this.checkMatch,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchKeywordPressEnter",this.checkMatch,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchFieldCleared",this.onSearchFieldCleared,this),Ext.QuickTips.register({target:this.el,text:SYNO.Finder.Utils._T("common","add_to_bookmark")})},onBookmarkApply:function(t){this.setMatchState(t.get("name"))},onBookmarkSaveSuccess:function(t){this.setMatchState(t.name)},onSearchFieldCleared:function(){this.removeMatchState()},checkMatch:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCriteria",[]),e=SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword",[]),i={};Ext.each(t,function(t){i[t.json.fieldName]=t.json.clause})
;var n=SYNO.Finder.Mgr.bookmarkMgr.getStore().findBy(function(n){if(e===n.get("keyword")&&t.length===n.get("criteria").length){var r=!0;return Ext.each(n.get("criteria"),function(t){return i.hasOwnProperty(t.json.fieldName)?t.json.clause!==i[t.json.fieldName]?(r=!1,!1):void 0:(r=!1,!1)}),r}});return n>=0?(this.setMatchState(SYNO.Finder.Mgr.bookmarkMgr.getStore().getAt(n).get("name")),"y"):(this.removeMatchState(),"n")},setMatchState:function(t){Ext.QuickTips.unregister(this.el),Ext.QuickTips.register({target:this.el,text:Ext.util.Format.htmlEncode(String.format(SYNO.Finder.Utils._T("common","bookmark_match"),t))}),this.el.select("a").addClass("match"),this.currentBookmarkName=t},removeMatchState:function(){Ext.QuickTips.unregister(this.el),Ext.QuickTips.register({target:this.el,text:SYNO.Finder.Utils._T("common","add_to_bookmark")}),this.el.select("a").removeClass("match"),this.currentBookmarkName=""},onClick:function(){if(Ext.isEmpty(this.currentBookmarkName))SYNO.Finder.Utils.checkIsValidBookmark()?new SYNO.Finder.BookmarkPrompt({owner:Ext.getCmp(this.ownerCt.el.parent().id).findAppWindow()}).show():Ext.getCmp(this.ownerCt.el.parent().id).findAppWindow().getMsgBox().alert("",SYNO.Finder.Utils._T("common","bookmark_no_criteria_no_search"));else{var t=SYNO.Finder.Mgr.bookmarkMgr.getStore().findExact("name",this.currentBookmarkName);this.removeMatchState(),SYNO.Finder.Mgr.statusMgr.fireEvent("bookmarkremove",t)}}}),Ext.ns("SYNO.Finder.Component.Toolkit"),Ext.define("SYNO.Finder.Component.Toolkit.ClearSearchButton",{extend:"Ext.Container",TOOLKIT_WIDTH:24,TOOLKIT_HEIGHT:24,constructor:function(t){var e={layout:"fit",cls:"clearsearch-button",width:this.TOOLKIT_WIDTH,height:this.TOOLKIT_HEIGHT,margins:"0 6 0 0",listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},onAfterRender:function(){this.el.on("mousedown",this.onMouseDown,this),this.el.on("mouseup",this.onMouseUp,this),this.el.on("mouseleave",this.onMouseLeave,this),this.el.on("click",this.onClick,this)},onMouseDown:function(){this.addClass("active")},onMouseUp:function(){this.removeClass("active")},onMouseLeave:function(){this.removeClass("active")},onClick:function(){SYNO.Finder.Mgr.statusMgr.applyData({currentSearchKeyword:""}),SYNO.Finder.Mgr.statusMgr.fireEvent("searchFieldCleared"),this.hide()}}),Ext.ns("SYNO.Finder.Component.Toolkit"),Ext.define("SYNO.Finder.Component.Toolkit.Main",{extend:"SYNO.ux.Panel",constructor:function(t){this.clSearchBtn=new SYNO.Finder.Component.Toolkit.ClearSearchButton({}),this.bmIndicator=new SYNO.Finder.Component.Toolkit.BookmarkIndicator({});var e={height:28,width:63,floating:!0,shadow:!1,cls:"search-toolkit",layout:{type:"hbox",align:"stretch"},items:[this.clSearchBtn,this.bmIndicator]};this.callParent([Ext.apply(e,t)]),this.clSearchBtn.hide()},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,{searchNeeded:this.onSearchNeeded,searchFieldDeleteToEmpty:this.onSearchFieldDeleteToEmpty,scope:this})},onSearchNeeded:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword",null),e=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCriteria",null);t||e?this.clSearchBtn.show():this.clSearchBtn.hide()},onSearchFieldDeleteToEmpty:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCriteria",null);Ext.isEmpty(t)&&this.clSearchBtn.hide()}}),Ext.ns("SYNO.Finder.Component.SearchField"),Ext.define("SYNO.Finder.Component.SearchField.AutoCompletion",{extend:"SYNO.ux.Panel",currentSelectIdx:-1,keyword:"",constructor:function(t){this.completionListStore=this.createStore(),this.completionListTpl=this.getTemplate(),this.actionList=this.createActionList();var e={floating:!0,shadow:!1,cls:"dsmsearch-autocompletion",layout:"fit",items:{xtype:"syno_flexcroll_dataview",itemSelector:"div.autocompletion-item",emptyText:"Nooooo",store:this.completionListStore,tpl:this.completionListTpl,listeners:{scope:this,click:this.chooseCompletionItem,afterrender:this.hidePanel}}};this.callParent([Ext.apply(e,t)]),this.initEvents()},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,{searchKeywordPressEnter:this.onSearchKeywordPressEnter,searchKeywordPressUp:this.onSearchKeywordPressUp,searchKeywordPressDown:this.onSearchKeywordPressDown,searchKeywordPressEsc:this.onSearchKeywordPressEsc,scope:this}),this.mon(SYNO.Finder.Mgr.statusMgr,"searchFieldChanged",this.onSearchFieldChanged,this,{buffer:100}),this.mon(Ext.getDoc(),"mousedown",this.onMouseDown,this)},onMouseDown:function(t){!this.isVisible()||t.within(this.getEl())||t.within(this.textField.getEl())||this.hidePanel()},onSearchFieldChanged:function(t){if(this.abortRequest(),this.keyword=t.trim(),""===this.keyword)return void this.hidePanel();this.retrieveCompletionList(t)},onSearchKeywordPressEnter:function(){this.abortBufferEvent(),this.abortRequest(),this.hidePanel()},onSearchKeywordPressUp:function(){this.moveSelection(-1)},onSearchKeywordPressDown:function(){this.moveSelection(1)},onSearchKeywordPressEsc:function(t){this.abortBufferEvent(),this.abortRequest(),this.hidePanel()},abortBufferEvent:function(){Ext.each(SYNO.Finder.Mgr.statusMgr.events.searchfieldchanged.listeners,function(t){if(t.fn===this.onSearchFieldChanged)return t.task.cancel(),!1},this)},abortRequest:function(){this.actionList&&Ext.each(this.actionList,function(t){t.abort()})},getTemplate:function(){return new Ext.XTemplate('<tpl for=".">','<div class="autocompletion-item">','<div class="autocompletion-inner-wrapper">','<span class="icon {values.type}"></span>{[this.decorateTerm(values)]}',"</div>","</div>","</tpl>",{decorateTerm:function(t){if("history"===t.type)return'<span class="history-keyword">'+Ext.util.Format.htmlEncode(t.term)+"</span>";if("criteria"===t.type)return'<span class="history-keyword">'+Ext.util.Format.htmlEncode(t.term)+'</span><span class="criteria"> - <i>'+SYNO.Finder.Utils._T("common","advanced_search")+"</i></span>";var e=t.term;return'<span class="keyword">'+Ext.util.Format.htmlEncode(e.substr(0,this.keyword.length))+'</span><span class="suitable">'+Ext.util.Format.htmlEncode(e.substr(this.keyword.length))+"</span>"}.createDelegate(this)})},showPanel:function(){!1===this.isVisible()&&(this.el.alignTo(this.alignTargetEl,"tl-bl"),this.setVisible(!0).expand(!0),this.setWidth(this.searchBanner.getWidth()+this.textField.getWidth()))},hidePanel:function(){this.setVisible(!1)},chooseCompletionItem:function(t,e){var i=this.completionListStore.getAt(e);"criteria"!==i.get("type")?SYNO.Finder.Mgr.statusMgr.fireEvent("setCompletionKeyword",i.get("term")):SYNO.Finder.Mgr.statusMgr.fireEvent("clickCompletionCriteria",i),this.hidePanel()},createStore:function(){return new Ext.data.JsonStore({fields:["term","type","data"]})},createActionList:function(){return this.actionList||(this.actionList=[new SYNO.Finder.Component.SearchField.Action.SearchCriteria,new SYNO.Finder.Component.SearchField.Action.Suggest],Ext.each(this.actionList,function(t){this.addManagedComponent(t)},this)),this.actionList},retrieveCompletionList:function(t){var e=[];Ext.each(this.actionList,function(i){e.push(i.doTask(t))}),Promise.all(e).then(function(t){var e=[],i=[],n=[];Ext.each([].concat.apply([],t),function(t){"history"===t.type?e.push(t):"criteria"===t.type?i.push(t):n.push(t)}),this.completionListStore.loadData([].concat.call(e,i,n).slice(0,10)),this.showPanel(),this.resultDiv=this.el.query(".autocompletion-item"),this.adjustPanelHeight(),this.currentSelectIdx=-1}.createDelegate(this)).catch(function(){SYNO.Finder.Utils.debug(arguments)})},moveSelection:function(t){!1!==this.isVisible()&&(t=t||0,this.currentSelectIdx+t>=this.completionListStore.getCount()||this.currentSelectIdx+t<0||(this.currentSelectIdx>=0&&Ext.fly(this.resultDiv[this.currentSelectIdx]).removeClass("autocompletion-item-selected"),this.currentSelectIdx+=t,Ext.fly(this.resultDiv[this.currentSelectIdx]).addClass("autocompletion-item-selected"),SYNO.Finder.Mgr.statusMgr.fireEvent("setCompletionCandidate",this.completionListStore.getAt(this.currentSelectIdx))))},adjustPanelHeight:function(){if(!this.resultDiv||!this.resultDiv.length)return void this.hidePanel();this.setHeight(4+28*this.resultDiv.length+4)}}),Ext.define("SYNO.Finder.Component.SearchField.Action.Base",{extend:"Ext.Component",keyword:null,rejectFn:null,constructor:function(){this.callParent(arguments)},abort:function(){this.rejectFn&&this.rejectFn()},doTask:function(t){return this.keyword=t,new Promise(this.doTaskImpl.createDelegate(this))},doTaskImpl:Ext.emptyFn}),Ext.define("SYNO.Finder.Component.SearchField.Action.Suggest",{extend:"SYNO.Finder.Component.SearchField.Action.Base",constructor:function(t){this.callParent()},doTask:function(){return this.abortRequest(),this.callParent(arguments)},doTaskImpl:function(t,e){if(!_S("is_admin"))return void t([]);this.rejectFn=e,this.sendWebAPI({api:"SYNO.Finder.Elastic.Term",version:1,appWindow:!1,method:"suggest",params:{suggest_num:10,terms:this.keyword,suggester:SYNO.Finder.Mgr.statusMgr.getData("preference",{}).enable_history?[]:["prefix_doc_freq"]},scope:this,callback:function(i,n,r){i?Ext.isEmpty(this.keyword)||r.terms!==this.keyword?e():t(n.suggestions||[]):e({msg:SYNO.Finder.Utils.getWebAPIErrStr(n)})}})},abortRequest:function(){try{this.request&&this.request.conn&&this.request.conn.abort()}catch(t){SYNO.Debug.error(t)}}}),Ext.define("SYNO.Finder.Component.SearchField.Action.SearchCriteria",{extend:"SYNO.Finder.Component.SearchField.Action.Base",CRITERIA_MAX_MATCH_NUM:2,constructor:function(t){this.callParent()},doTaskImpl:function(t,e){var i=[];SYNO.Finder.Mgr.facetMgr.getCriteriaNameStore().each(function(t){if(this.matchCriteria(t.get("name"))&&i.push({term:t.get("name"),type:"criteria",data:{fieldName:t.get("SYNOMDFieldName"),idle:t.get("idle")}}),i.length>=this.CRITERIA_MAX_MATCH_NUM)return!1},this),t(i)},matchCriteria:function(t){var e=!1;if(!(this.keyword.length<2))return Ext.each(t.split(" "),function(t){return 0!==t.toLowerCase().lastIndexOf(this.keyword.toLowerCase(),0)||(e=!0,!1)},this),e}}),Ext.ns("SYNO.Finder.Component.SearchField"),Ext.define("SYNO.Finder.Component.SearchField.Banner",{extend:"SYNO.ux.Panel",interval:null,BANNER_WIDTH:48,BANNER_HEIGHT:26,ANGLE_DIFF:1.5,constructor:function(t){var e={cls:"finder-banner",layout:"fit",width:this.BANNER_WIDTH,height:this.BANNER_HEIGHT,html:'<div class="true"></div>',margins:"0 0 0 12",listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,{searchDone:this.onSearchDone,searchNeeded:this.onSearchNeeded,scope:this}),this.callParent(arguments)},onAfterRender:function(){this.el.on("mousedown",this.onMouseDown,this),this.el.on("mouseup",this.onMouseUp,this),this.el.on("click",this.onClick,this),this.el.on("mouseleave",this.onMouseLeave,this),Ext.QuickTips.register({target:this.el,text:SYNO.Finder.Utils._T("common","advanced_search")})},onClick:function(){SYNO.Finder.Mgr.statusMgr.fireEvent("facetSearchToggled")},onMouseDown:function(){this.addClass("active")},onMouseUp:function(){this.removeClass("active")},onMouseLeave:function(){this.removeClass("active")},onSearchNeeded:function(){if(this.searcherCounter=SYNO.Finder.Mgr.searcherMgr.getTotalNeededSearcherCount(),this.addClass("show-loading"),!this.interval){var t=0,e=this.el.query(".true")[0];this.interval=window.setInterval(function(){t+=this.ANGLE_DIFF,this.setAngle(e,t)}.createDelegate(this),1)}},onSearchDone:function(){--this.searcherCounter>0||(this.removeClass("show-loading"),window.clearInterval(this.interval),this.interval=null,this.setAngle(this.el.query(".true")[0],0))},setAngle:function(t,e){Ext.isDefined(t.style.msTransform)?t.style.msTransform=String.format("rotate({0}deg)",e):Ext.isDefined(t.style.transform)&&(t.style.transform=String.format("rotate({0}deg)",e))}}),Ext.ns("SYNO.Finder.Component.SearchField"),Ext.define("SYNO.Finder.Component.SearchField.Main",{extend:"SYNO.ux.Panel",constructor:function(t){this.searchBanner=new SYNO.Finder.Component.SearchField.Banner,this.textField=new SYNO.Finder.Component.SearchField.TextField({flex:1,enableKeyEvents:!0,cls:"dsmsearch-search-textfield"});var e={name:"search_keyword",flex:1,layout:{type:"hbox",align:"stretch"},items:[this.searchBanner,this.textField],listeners:{scope:this,resize:this.onMyResize}};this.callParent([Ext.apply(e,t)]),this.mon(this.textField,"afterrender",this.createAddons,this)},initEvents:function(){this.callParent(arguments)},getValue:function(){return this.textField.getValue()},onMyResize:function(t,e){this.autoCompPanel.setWidth(this.searchBanner.getWidth()+this.textField.getWidth()),this.criteriaField.alignField(),this.criteriaField.setWidth(this.textField.getWidth())},createAddons:function(){this.autoCompPanel=new SYNO.Finder.Component.SearchField.AutoCompletion({textField:this.textField,searchBanner:this.searchBanner,renderTo:this.findAppWindow().el,alignTargetEl:this.searchBanner.el}),this.criteriaField=new SYNO.Finder.Component.SearchField.CriteriaField({renderTo:this.textField.container,height:this.textField.el.getHeight(!0),width:this.textField.getWidth(),alignTargetEl:this.textField.el}),this.addManagedComponent(this.autoCompPanel),this.addManagedComponent(this.criteriaField)}}),Ext.define("SYNO.Finder.Component.SearchField.TextField",{extend:"SYNO.ux.TextField",constructor:function(t){var e={listeners:{scope:this,keyup:{fn:this.onKeyUp},specialkey:{fn:this.onSearchFieldSpecialKey}}};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,"bookmarkapply",this.onBookmarkApply,this),this.mon(SYNO.Finder.Mgr.statusMgr,"setCompletionKeyword",this.onSetCompletionKeyword,this),this.mon(SYNO.Finder.Mgr.statusMgr,"setCompletionCandidate",this.onSetCompletionCandidate,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchFieldCleared",this.onSearchFieldCleared,this),this.mon(SYNO.Finder.Mgr.statusMgr,"facetSearchBtnClick",this.onFacetSearchBtnClick,this),this.mon(SYNO.Finder.Mgr.statusMgr,"clickCompletionCriteria",this.onClickCompletionCriteria,this),this.mon(this.el,"input",this.onTextFieldInput,this),this.mon(this.el,"click",this.onClick,this),this.callParent(arguments)},onClick:function(){this.selectText()},onBookmarkApply:function(t){this.setValue(t.get("keyword"))},onFacetSearchBtnClick:function(){SYNO.Finder.Mgr.statusMgr.applyData({currentSearchKeyword:this.getValue()}).fireEvent("searchKeywordPressEnter")},onSetCompletionKeyword:function(t){this.setValue(t),this.focus(!1,200),this.fireSearchKeywordChangedEvent()},onSetCompletionCandidate:function(t){this.suggest=t,"criteria"!==t.get("type")&&this.setValue(t.get("term"))},onClickCompletionCriteria:function(t){this.reset(),SYNO.Finder.Mgr.statusMgr.fireEvent("setCompletionCriteria",t),SYNO.Finder.Mgr.statusMgr.fireEvent("searchFieldDeleteToEmpty"),SYNO.Finder.Mgr.statusMgr.fireEvent("searchKeywordPressEsc","a")},onSearchFieldCleared:function(){this.reset(),this.fireSearchKeywordChangedEvent()},onTextFieldInput:function(){SYNO.Finder.Mgr.statusMgr.fireEvent("searchFieldChanged",this.getValue())},onSearchFieldSpecialKey:function(t,e){var i;switch(e.getKey()){case e.ENTER:if(!this.suggest||"criteria"!==this.suggest.get("type")){this.suggest=null,!SYNO.Finder.Mgr.statusMgr.getData("currentSearchCriteria",[]).length&&Ext.isEmpty(this.getValue().trim())||SYNO.Finder.Mgr.statusMgr.applyData({currentSearchKeyword:this.getValue()}).fireEvent("searchKeywordPressEnter");break}this.onClickCompletionCriteria(this.suggest),this.suggest=null;break;case e.DOWN:SYNO.Finder.Mgr.statusMgr.fireEvent("searchKeywordPressDown"),e.preventDefault();break;case e.UP:SYNO.Finder.Mgr.statusMgr.fireEvent("searchKeywordPressUp"),e.preventDefault();break;case e.ESC:i=this.getValue().trim(),this.reset(),SYNO.Finder.Mgr.statusMgr.fireEvent("searchFieldChanged",""),SYNO.Finder.Mgr.statusMgr.fireEvent("searchFieldDeleteToEmpty"),SYNO.Finder.Mgr.statusMgr.fireEvent("searchKeywordPressEsc",i)}},onKeyUp:function(t){switch(t.getKey()){case t.BACKSPACE:case t.DELETE:this.getValue().trim()||SYNO.Finder.Mgr.statusMgr.fireEvent("searchFieldDeleteToEmpty")}t.isSpecialKey()||SYNO.Finder.Mgr.statusMgr.fireEvent("searchFieldChanged",this.getValue())},fireSearchKeywordChangedEvent:function(){this.getValue()!==SYNO.Finder.Mgr.statusMgr.getData("currentSearchKeyword")&&SYNO.Finder.Mgr.statusMgr.applyData({currentSearchKeyword:this.getValue()}).fireEvent("searchKeywordChanged",this.getValue())}}),Ext.define("SYNO.Finder.Component.SearchField.CriteriaField",{extend:"SYNO.ux.Panel",dummyContentDiv:null,contentDiv:null,constructor:function(t){this.dataview=new SYNO.Finder.Component.SearchField.CriteriaDataView({owner:this,tpl:this.createTemplate(),store:this.getStore(),itemSelector:"span.entry"});var e={floating:!0,shadow:!1,cls:"criteria-field",data:{dummy:""},items:[this.dataview],tpl:this.createOuterTemplate()};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,"setCompletionCandidate",this.onSetCompletionCandidate,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchKeywordChanged",this.onSearchKeywordChanged,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchCriteriaChanged",this.onSearchCriteriaChanged,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchFieldChanged",this.onSearchFieldChanged,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchFieldCleared",this.onSearchFieldCleared,this),this.mon(SYNO.Finder.Mgr.statusMgr,"bookmarkapply",this.onBookmarkApply,this),this.callParent(arguments)},onBookmarkApply:function(t){this.setDummyContent(t.get("keyword"))},onSetCompletionCandidate:function(t){this.setDummyContent(t)},onSearchKeywordChanged:function(t){this.setDummyContent(t)},onSearchCriteriaChanged:function(t){this.getStore().loadData(t)},onSearchFieldCleared:function(){this.getStore().removeAll(),this.setDummyContent("")},onSearchFieldChanged:function(t){this.setDummyContent(t)},getStore:function(){return Ext.isDefined(this.store)||(this.store=new Ext.data.JsonStore({fields:["title","desc"]})),this.store},createOuterTemplate:function(){return new Ext.XTemplate('<div class="wrapper ellipsis">','<div class="dummy-content">{dummy:htmlEncode}</div>','<div class="content">',"</div>","</div>")},createTemplate:function(){return new Ext.XTemplate('<tpl for=".">','<span class="entry">({title:htmlEncode}: {desc:htmlEncode})</span>',"</tpl>")},alignField:function(){this.el.alignTo(this.alignTargetEl,"tl-tl",[0,1])},setDummyContent:function(t){this.el.query(".dummy-content")[0].innerHTML=Ext.util.Format.htmlEncode(t)}}),Ext.define("SYNO.Finder.Component.SearchField.CriteriaDataView",{extend:"Ext.DataView",getTemplateTarget:function(){return this.owner.el.child(".content")}}),Ext.ns("SYNO.Finder.Component.Preview.Upper"),Ext.define("SYNO.Finder.Component.Preview.Upper.Highlight",{extend:"SYNO.Finder.Component.Preview.Upper.Base",DISPLAY_MODE_TEXT:"text",DISPLAY_MODE_HTML:"html",docData:null,firstMatchTerm:null,highlightDisplayMode:"text",pageNum:1,highlightOffset:0,highlightTotal:1e3,constructor:function(t){this.apiRequest=null,this.previewPart=new Ext.Container({cls:"highlight-body",tpl:this.getPreviewTemplate(),flex:1});var e=[this.previewPart,{xtype:"container",layout:"hbox",height:65,cls:"highlight-control",layoutConfig:{align:"stretch"},items:this.fillItems()}],i={ctCls:"preview-box-wrapper",items:{xtype:"syno_panel",cls:"highlight-content",width:268,height:343,layout:"vbox",layoutConfig:{align:"stretch"},items:e}};this.callParent([Ext.apply(i,t)])},fillItems:function(){this.paragraphInfoPart=new Ext.Container({tpl:this.getInfoTemplate(),flex:1}),this.openBtn=new SYNO.ux.Button({iconCls:"open-btn",width:26,margins:"0 8 0 0",scope:this,handler:this.onOpenBtnClick});var t=new Ext.Container({cls:"separator",width:1,margins:"3 10 3 0"}),e=new SYNO.ux.Button({width:26,margins:"0 6 0 8",iconCls:"prev-btn",scope:this,name:"prev-btn",handler:this.onPrevClick}),i=new SYNO.ux.Button({width:26,iconCls:"next-btn",scope:this,name:"next-btn",handler:this.onNextClick});return SYNO.Finder.Utils.checkSupportPDFViewer()?[this.openBtn,t,this.paragraphInfoPart,e,i]:[this.paragraphInfoPart,e,i]},initEvents:function(){this.callParent(arguments),this.mon(SYNO.Finder.Mgr.statusMgr,{prefMaxFragmentNumChanged:this.onPrefMaxFragmentNumChanged,searchCategoryChanged:this.onResetPreview,scope:this})},onPrefMaxFragmentNumChanged:function(){this.updateHighlight(!0)},onResetPreview:function(){this.setDoc(null)},onOpenBtnClick:function(){SYNO.SDS.WindowLaunch("SYNO.SDS.PDFViewer.Application",{path:this.docData.extraData.sharePath,query:this.firstMatchTerm||"",pageNum:this.pageNum||1})},updateContent:function(t){this.setDoc(t),this.updateHighlight(!0)},getPreviewTemplate:function(){return new Ext.XTemplate("{[this.showPromptorHighlight(values)]}",{showPromptorHighlight:function(t){return this.DISPLAY_MODE_TEXT==this.highlightDisplayMode?SYNO.Finder.Utils.escapeHighlight(t.highlight.text):'<div class="display-prompt">'+t.highlight.text+"</div>"}.createDelegate(this)})},getInfoTemplate:function(){var t=this;return new Ext.XTemplate('<tpl if="this.toShow()">','<div class="info {[this.supportPDFClass()]}"><span class="now">{[this.offset()]}</span><span> of {[this.total()]}</span></div>',"</tpl>",{toShow:function(){return this.DISPLAY_MODE_HTML!==this.highlightDisplayMode}.createDelegate(this),offset:function(){return t.highlightOffset+1},supportPDFClass:function(){return SYNO.Finder.Utils.checkSupportPDFViewer()?"":"no-pdf-viewer"},total:function(){return t.highlightTotal}})},setDoc:function(t){this.docData=t,t&&this.openBtn.setDisabled(!SYNO.Finder.Utils.checkEnableDocumentViewerBtn(t.extraData.highlightExtension))},bindPromptAction:function(){var t=this.previewPart.el.query(".action");Ext.isEmpty(t)||t[0].on("click",function(){SYNO.Finder.Mgr.statusMgr&&SYNO.Finder.Mgr.statusMgr.fireEvent("launchFolderList")})},updateTextContent:function(t){this.previewPart.update(t),this.bindPromptAction(),this.paragraphInfoPart.update()},updateControllerClass:function(){this.find("name","prev-btn")[0].setDisabled(this.highlightOffset<=0),this.find("name","next-btn")[0].setDisabled(this.highlightOffset>=this.highlightTotal-1)},preUpdateHighlight:function(t){t&&(this.highlightOffset=0),this.abortAPIRequest(),this.highlightDisplayMode=this.DISPLAY_MODE_TEXT,this.previewPart.update({highlight:{text:SYNO.Finder.Utils._T("common","highlight_loading")}}),this.find("name","prev-btn")[0].setDisabled(!0),this.find("name","next-btn")[0].setDisabled(!0)},updateHighlight:function(t){Ext.isEmpty(this.docData)||(this.highlightOffset>=this.highlightTotal&&(this.highlightOffset=this.highlightTotal-1),this.highlightOffset<0&&(this.highlightOffset=0),this.preUpdateHighlight(t),this.apiRequest=this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Highlight",version:1,method:"highlight",params:{full_path:this.docData.extraData.highlightFullPath,doc_id:this.docData.extraData.highlightDocId,keyword:this.docData.extraData.highlightKeyword,highlight:{field:"SYNOMDTextContent",offset:this.highlightOffset,num_fragments:SYNO.Finder.Mgr.statusMgr.getData("preference",{}).max_fragment_num,frag_length:350}},callback:this.updateHighlightCallback.createDelegate(this,[t],3)}))},updateHighlightCallback:function(t,e,i,n){t?(n&&(this.highlightOffset=0),this.getHighlightMsg(e).then(function(t){e.highlight.text=t,this.highlightTotal=Math.min(e.total||1,SYNO.Finder.Mgr.statusMgr.getData("preference").max_fragment_num),this.pageNum=e.highlight.page+1,this.firstMatchTerm=e.highlight.term,this.updateTextContent(e),this.updateControllerClass()}.createDelegate(this))):(this.highlightOffset=-1,this.highlightTotal=0,this.pageNum=1,this.firstMatchTerm="",this.updateTextContent({highlight:{text:SYNO.Finder.Utils._T("common","highlight_unavailable")}}),this.updateControllerClass())},getHighlightMsg:function(t){if(!this.docData||!this.docData.extraData||!this.docData.extraData.highlightFullPath)return Promise.resolve(SYNO.Finder.Utils._T("common","highlight_unavailable"));var e=this.docData.extraData.highlightFullPath+"/",i=e.substr(1).indexOf("/"),n=e.substr(1+i);return new Promise(function(e,i){return Ext.isEmpty(t.highlight.text.trim())?_S("is_admin")?(this.highlightDisplayMode=this.DISPLAY_MODE_HTML,void this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Folder",method:"list",params:{direction:"asc",sort_by:"path",offset:0},version:1,scope:this,callback:function(t,i,r){var s={path:""};if(!t)return void e(SYNO.Finder.Utils._T("common","highlight_unavailable"));Ext.each(i.folder,function(t){0===n.indexOf(t.path)&&t.path.length>s.path.length&&(s=t)}),e(!0===s.document?SYNO.Finder.Utils._T("common","highlight_unavailable"):SYNO.Finder.Utils._T("common","highlight_unavailable_unindexed")+'<div class="action">'+SYNO.Finder.Utils._T("common","prompt_enable_content_indexing")+"</div>")}})):(this.highlightDisplayMode=this.DISPLAY_MODE_TEXT,void e(SYNO.Finder.Utils._T("common","highlight_unavailable"))):(this.highlightDisplayMode=this.DISPLAY_MODE_TEXT,void e(t.highlight.text.trim()))}.createDelegate(this))},onPrevClick:function(){this.highlightOffset--,this.updateHighlight()},onNextClick:function(){this.highlightOffset++,this.updateHighlight()},abortAPIRequest:function(){try{this.apiRequest&&this.apiRequest.conn&&this.apiRequest.conn.abort()}catch(t){SYNO.Debug.error(t)}}}),Ext.ns("SYNO.Finder.Component.Preview"),Ext.define("SYNO.Finder.Component.Preview.Meta",{extend:"SYNO.ux.Panel",constructor:function(t){this.dataview=new SYNO.ux.FleXcroll.DataView({tpl:this.createTemplate(),store:this.getStore()});var e={items:this.dataview,layout:"fit"};this.callParent([Ext.apply(e,t)])},createTemplate:function(){return new Ext.XTemplate("<div>",'<tpl for=".">','<tpl if="content.trim().length &gt; 0">',"<div>",'<div class="field-name meta-item">{name:htmlEncode}</div>','<div class="field-content meta-item">{content:htmlEncode}</div>','<div class="x-clear"></div>',"</div>","</tpl>","</tpl>","</div>")},getStore:function(){return Ext.isDefined(this.store)||(this.store=new Ext.data.JsonStore({fields:["name","content"]})),this.store},updateContent:function(t){this.getStore().loadData(t.previewMeta),this.dataview.updateFleXcroll()}}),Ext.ns("SYNO.Finder.Component.Preview"),Ext.define("SYNO.Finder.Component.Preview.Main",{extend:"SYNO.ux.Panel",TOGGLE_PANEL_ANIMATION:!1,DEFAULT_CONTENT_HEIGHT:343,PREVIEW_MAIN_ID_EMPTY:"empty",PREVIEW_MAIN_ID_NORMAL:"normal",PREVIEW_UPPER_ID_HIGHLIGHT:"document",PREVIEW_UPPER_ID_THUMBNAIL:"thumbnail",PREVIEW_UPPER_ID_AUDIO:"audio",constructor:function(t){this.highlightPart=new SYNO.Finder.Component.Preview.Upper.Highlight({itemId:this.PREVIEW_UPPER_ID_HIGHLIGHT}),this.thumbnailPart=new SYNO.Finder.Component.Preview.Upper.Thumbnail({itemId:this.PREVIEW_UPPER_ID_THUMBNAIL}),this.audioPart=new SYNO.Finder.Component.Preview.Upper.AudioPlayer({itemId:this.PREVIEW_UPPER_ID_AUDIO}),this.contentPart=new Ext.Container({height:this.DEFAULT_CONTENT_HEIGHT+52,layout:"card",deferredRender:!0,items:[this.highlightPart,this.thumbnailPart,this.audioPart]}),this.metaPart=new SYNO.Finder.Component.Preview.Meta({flex:1,cls:"preview-meta",margins:"0 12 0 12"});var e={hideCollapseTool:!0,layout:"card",minWidth:318,activeItem:this.PREVIEW_MAIN_ID_EMPTY,cls:"preview-panel",items:[{itemId:this.PREVIEW_MAIN_ID_EMPTY,xtype:"syno_panel",cls:"empty-preview",layout:{type:"vbox",align:"stretch"},items:[{xtype:"syno_panel",flex:2},{xtype:"container",html:'<div class="icons"></div><div class="prompt-msg">'+SYNO.Finder.Utils._T("common","preview_prompt_msg")+"</div>"},{xtype:"syno_panel",flex:3},{xtype:"container",height:12}]},{itemId:this.PREVIEW_MAIN_ID_NORMAL,xtype:"syno_panel",layout:{type:"vbox",align:"stretch"},items:[this.contentPart,this.metaPart]}]};this.callParent([Ext.apply(e,t)]),this.pluginPreviewPanelMap={},this.onCreatePlugins()},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,"searchRecordClicked",this.onSearchRecordClicked,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchFieldCleared",this.onSearchFieldCleared,this),this.mon(SYNO.Finder.Mgr.statusMgr,"previewToggled",this.onPreviewToggled,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchCategoryChanged",this.onResetPreview,this),this.mon(SYNO.Finder.Mgr.statusMgr,"fallbackPreview",this.onFallbackPreview,this),this.mon(SYNO.Finder.Mgr.pluginMgr,"pluginadd",this.onAddPlugin,this),this.mon(SYNO.Finder.Mgr.pluginMgr,"pluginremove",this.onRemovePlugin,this),this.callParent(arguments)},onSearchFieldCleared:function(){this.isVisible()&&SYNO.Finder.Mgr.statusMgr.fireEvent("previewToggled")},onCreatePlugins:function(){Ext.each(SYNO.Finder.Mgr.pluginMgr.getPlugins(),function(t){this.onAddPlugin(t)},this)},onFallbackPreview:function(){delete this.contentPart.flex,this.contentPart.height=this.DEFAULT_CONTENT_HEIGHT+52,this.doLayout()},onAddPlugin:function(t){if(!this.pluginPreviewPanelMap.hasOwnProperty(t.getPluginId())){this.pluginPreviewPanelMap[t.getPluginId()]=[];try{Ext.each(t.getPreviewPanel(),function(e){this.contentPart.add(e),this.pluginPreviewPanelMap[t.getPluginId()].push(e.itemId)},this)}catch(t){SYNO.Debug.error(t)}}},onRemovePlugin:function(t){this.pluginPreviewPanelMap.hasOwnProperty(t)&&(Ext.each(this.pluginPreviewPanelMap[t],function(t){this.contentPart.remove(t)},this),delete this.pluginPreviewPanelMap[t])},onResetPreview:function(){this.getLayout().setActiveItem(this.PREVIEW_MAIN_ID_EMPTY)},onSearchRecordClicked:function(t){this.getLayout().setActiveItem(this.PREVIEW_MAIN_ID_NORMAL);var e=t.previewCardID||this.PREVIEW_UPPER_ID_THUMBNAIL;this.contentPart.getLayout().setActiveItem(e),e===this.PREVIEW_UPPER_ID_THUMBNAIL||e===this.PREVIEW_UPPER_ID_AUDIO?(delete this.contentPart.height,this.contentPart.flex=3,this.doLayout()):(delete this.thumbnailPart.flex,this.contentPart.height=this.DEFAULT_CONTENT_HEIGHT+52,this.doLayout()),this.contentPart.getComponent(e).updateContent(t),this.metaPart.updateContent(t),this.collapsed&&SYNO.Finder.Mgr.statusMgr.fireEvent("previewToggled")},onPreviewToggled:function(){this.toggleCollapse(this.TOGGLE_PANEL_ANIMATION)}}),Ext.define("SYNO.Finder.Component.Facet.Criteria.ChooserBase",{extend:"SYNO.ux.Panel",constructor:function(t){var e=this.getItems(t),i={height:28,layout:{type:"hbox",align:"stretch"},items:e,bubbleEvents:["add","remove","criteriaAdd"]};Ext.apply(this,t||{}),this.callParent([i])},onAddBtnClick:function(){this.isValid()&&this.fireEvent("criteriaAdd",this.name,this.fieldName,this.getCriteria())},getCriteria:function(){return{value:this.getCriteriaValue(),text:this.getCriteriaText(),clause:this.getCriteriaClause()}},clear:function(){Ext.each(this.items.items,function(t){Ext.isFunction(t.reset)&&t.reset()})},getItems:function(t){return[]},getCriteriaValue:function(){},getCriteriaText:function(){return""},getCriteriaClause:function(){return""},isValid:function(){return!0},inEl:function(t){return!1},setContent:function(t){},getFieldName:function(){return this.fieldName}}),Ext.define("SYNO.Finder.Component.Facet.Criteria.ComboboxChooser",{extend:"SYNO.Finder.Component.Facet.Criteria.ChooserBase",constructor:function(t){this.callParent(arguments)},getItems:function(t){var e={width:328,flex:1,validator:function(t){return!Ext.isEmpty(t)}};return Ext.apply(e,t||{}),this.combobox=new SYNO.ux.ComboBox(e),[this.combobox]},getCriteriaValue:function(){return{type:this.fieldName,value:""+this.combobox.getValue()}},getCriteriaText:function(){return this.combobox.getRawValue()},getCriteriaClause:function(){return""+this.combobox.getValue()},isValid:function(){return!Ext.isEmpty(this.combobox.getValue())&&this.combobox.isValid()},inEl:function(t){return t.within(this.combobox.list)},setContent:function(t){this.combobox.setValue(t.text)}}),Ext.define("SYNO.Finder.Component.Facet.Criteria.ComboboxFieldChooser",{extend:"SYNO.Finder.Component.Facet.Criteria.ChooserBase",constructor:function(t){this.textType=t.textType,this.defaultAnimation=["888888",1,{duration:.35}],this.callParent(arguments)},getItems:function(t){this.combobox=new SYNO.ux.ComboBox({
store:t.store,mode:"local",displayField:"display",valueField:"value",value:t.store.getAt(0).get("value"),width:160,listeners:{select:this.onSelect,scope:this}});var e={width:160,disabled:t.disableTextField||t.noCustomization,allowBlank:!1,validateOnBlur:!0,validationEvent:"blur"};return"number"===this.textType?this.textfield=new SYNO.ux.NumberField(Ext.apply(e,{maxLength:8})):this.textfield=new SYNO.ux.TextField(e),[this.combobox,{xtype:"container",margins:"0 0 0 8",flex:1,items:this.textfield}]},getCriteriaValue:function(){return{type:this.fieldName,combo:this.combobox.getValue(),value:this.textfield.disabled?this.combobox.getValue():this.textfield.getValue()}},getCriteriaText:function(){return this.textfield.disabled?this.combobox.getRawValue():this.textfield.getValue()},getCriteriaClause:function(){var t=this.textfield.disabled?this.combobox.getValue():this.textfield.getValue();return"number"===this.textType?"["+t+" TO "+t+"]":"("+SYNO.Finder.Utils.escapeLucene(t)+")"},frameAnimation:function(t,e){t&&t.isVisible()&&Ext.Element.prototype.frame.apply(t,e)},onSelect:function(t,e,i){if(this.textfield.reset(),this.disableTextField&&!this.noCustomization){var n=i!==t.getStore().getCount()-1;n||this.frameAnimation(this.textfield.el,this.defaultAnimation),this.textfield.setDisabled(n)}},isValid:function(){return this.textfield.isValid()},inEl:function(t){return t.within(this.combobox.list)},setContent:function(t){this.combobox.getStore().findExact("value",t.value.value)>=0?this.combobox.setValue(t.value.value):(this.combobox.setValue("custom"),this.textfield.setDisabled(!1),this.textfield.setValue(t.value.value))}}),Ext.define("SYNO.Finder.Component.Facet.Criteria.ExtensionFieldChooser",{extend:"SYNO.Finder.Component.Facet.Criteria.ComboboxFieldChooser",getCriteriaValue:function(){return{combo:this.combobox.getValue(),value:this.textfield.getValue()}},getCriteriaClause:function(){var t=this.combobox.getValue();if("dir"===t)return"Y";if("file"===t)return"N";if("type"===t)return SYNO.Finder.Utils.escapeLucene(this.textfield.getValue());var e=SYNO.Finder.Utils.EntryMap[t];return Ext.isArray(e)?e.join(" OR "):""},getFieldName:function(){return"dir"===this.combobox.getValue()||"file"===this.combobox.getValue()?"SYNOMDIsDir":this.fieldName},setContent:function(t){var e="type"!==t.value.combo;this.combobox.setValue(t.value.combo),this.textfield.setDisabled(e),this.textfield.setValue(e?"":t.value.value)}}),Ext.define("SYNO.Finder.Component.Facet.Criteria.TextFieldChooser",{extend:"SYNO.Finder.Component.Facet.Criteria.ChooserBase",getItems:function(t){return this.textfield=new SYNO.ux.TextField({flex:1,allowBlank:!1,validateOnBlur:!0,validationEvent:"blur"}),[this.textfield]},getCriteriaValue:function(){return{type:this.fieldName,value:this.textfield.getValue()}},getCriteriaText:function(){return this.textfield.getValue()},getCriteriaClause:function(){return SYNO.Finder.Utils.escapeLucene(this.textfield.getValue())},isValid:function(){return this.textfield.isValid()},setContent:function(t){this.textfield.setValue(t.value.value)}}),Ext.define("SYNO.Finder.Component.Facet.Criteria.NumberFieldChooser",{extend:"SYNO.Finder.Component.Facet.Criteria.TextFieldChooser",getItems:function(t){return this.textfield=new SYNO.ux.NumberField({flex:1,allowBlank:!1,validateOnBlur:!0,validationEvent:"blur",maxLength:8}),[this.textfield]},getCriteriaClause:function(){var t=this.textfield.getValue();return"["+t+" TO "+t+"]"}}),Ext.define("SYNO.Finder.Component.Facet.Criteria.TwinDateChooser",{extend:"SYNO.Finder.Component.Facet.Criteria.ChooserBase",constructor:function(t){this.callParent(arguments)},getItems:function(t){return this.fromDatePicker=new SYNO.ux.DateTimeField({width:160,editable:!1,emptyText:_T("log","date_from"),validator:this.twinDateFieldValidator,listeners:{select:this.onFromSelect,scope:this}}),this.toDatePicker=new SYNO.ux.DateTimeField({width:160,editable:!1,emptyText:_T("log","date_to"),validator:this.twinDateFieldValidator,margins:"0 0 0 6",listeners:{select:this.onToSelect,scope:this}}),[this.fromDatePicker,this.toDatePicker]},onFromSelect:function(t,e){this.toDatePicker.setMinValue(e)},onToSelect:function(t,e){this.fromDatePicker.setMaxValue(e)},getCriteriaValue:function(){return{type:this.fieldName,from:SYNO.Finder.Utils.ConvertDateStringToTimeStamp(this.fromDatePicker.getValue())||0,to:SYNO.Finder.Utils.ConvertDateStringToTimeStamp(this.toDatePicker.getValue())||0}},getCriteriaText:function(){return SYNO.Finder.Utils.DateTimeFormatter(this.fromDatePicker.getValue(),{type:"datetime"})+" ~ "+SYNO.Finder.Utils.DateTimeFormatter(this.toDatePicker.getValue(),{type:"datetime"})},getCriteriaClause:function(){var t=this.toDatePicker.getValue();return"["+(SYNO.Finder.Utils.ConvertDateStringToSecTimeStamp(this.fromDatePicker.getValue())||0)+" TO "+(t?SYNO.Finder.Utils.ConvertDateStringToSecTimeStamp(t.add(Date.DAY,1).add(Date.SECOND,-1)):2147483647)+"]"},isValid:function(){return!Ext.isEmpty(this.fromDatePicker.getValue())||!Ext.isEmpty(this.toDatePicker.getValue())},inEl:function(t){return!(!this.fromDatePicker.menu||!t.within(this.fromDatePicker.menu.getEl()))||!(!this.toDatePicker.menu||!t.within(this.toDatePicker.menu.getEl()))},setContent:function(t){t.value.from?this.fromDatePicker.setValue(new Date(parseInt(t.value.from,10))):this.fromDatePicker.reset(),t.value.to?this.toDatePicker.setValue(new Date(parseInt(t.value.to,10))):this.toDatePicker.reset()}}),Ext.define("SYNO.Finder.Component.Facet.Criteria.TwinComboboxChooser",{extend:"SYNO.Finder.Component.Facet.Criteria.ChooserBase",getItems:function(t){return this.lcombobox=new SYNO.ux.ComboBox({store:t.lstore,mode:"local",displayField:"display",valueField:"value",value:t.lstore.getAt(0).get("value"),width:160}),this.rcombobox=new SYNO.ux.ComboBox({width:160,store:t.rstore,mode:"local",displayField:"display",valueField:"value",value:t.rstore.getAt(0).get("value")}),[this.lcombobox,{xtype:"container",flex:1,margins:"0 0 0 8",items:this.rcombobox}]},getCriteriaValue:function(){return{type:this.fieldName,operator:this.lcombobox.getValue(),value:this.rcombobox.getValue()}},getCriteriaText:function(){return this.lcombobox.getRawValue()+" "+this.rcombobox.getRawValue()},getCriteriaClause:function(){var t=this.rcombobox.getValue(),e=this.lcombobox.getValue();return"equal"===e?"["+t+" TO "+t+"]":"greater"===e?"["+t+" TO *]":"[* TO "+t+"]"},isValid:function(){return this.rcombobox.isValid()},inEl:function(t){return t.within(this.lcombobox.list)||t.within(this.rcombobox.list)},setContent:function(t){this.lcombobox.setValue(t.value.operator),this.rcombobox.setValue(t.value.value)}}),Ext.define("SYNO.Finder.Component.Facet.Criteria.SizeComboboxFieldChooser",{extend:"SYNO.Finder.Component.Facet.Criteria.ComboboxFieldChooser",constructor:function(t){t.textType="number",this.unit=t.unit,this.unitText=t.unitText,this.callParent(arguments)},getCriteriaValue:function(){return{type:this.fieldName,operator:this.combobox.getValue(),size:this.textfield.getValue(),unit:this.unit,unitText:this.unitText}},getCriteriaText:function(){return this.combobox.getRawValue()+" "+this.textfield.getValue()+this.unitText},getCriteriaClause:function(){var t=this.textfield.getValue()*this.unit,e=this.combobox.getValue();if("equal"===e){var i=t/20;i=i>0?i:1;return"["+Math.floor(t>i?t-i:0)+" TO "+Math.ceil(t+i)+"]"}return"greater"===e?"["+t+" TO *]":"[0 TO "+t+"]"},setContent:function(t){var e=this.combobox.getStore().findExact("value",t.value.operator);this.combobox.setValue(e>=0?t.value.operator:""),this.textfield.setValue(t.value.size)}}),Ext.define("SYNO.Finder.Component.Facet.Criteria.TimeComboboxFieldChooser",{extend:"SYNO.Finder.Component.Facet.Criteria.ComboboxFieldChooser",constructor:function(t){this.unit=t.unit,this.unitText=t.unitText,t.textType="number",this.callParent(arguments)},getCriteriaValue:function(){return{type:this.fieldName,operator:this.combobox.getValue(),duration:this.textfield.getValue(),unit:this.unit,unitText:this.unitText}},getCriteriaText:function(){return this.combobox.getRawValue()+" "+this.textfield.getValue()+this.unitText},getCriteriaClause:function(){var t=this.textfield.getValue()*this.unit,e=this.combobox.getValue();if("equal"===e){var i=t/20;i=i>0?i:1;return"["+Math.floor(t>i?t-i:0)+" TO "+Math.ceil(t+i)+"]"}return"greater"===e?"["+t+" TO *]":"[0 TO "+t+"]"},setContent:function(t){this.combobox.setValue(t.value.operator),this.textfield.setValue(t.value.duration)}}),Ext.define("SYNO.Finder.Component.Facet.SearchCriteriaChooser",{extend:"SYNO.ux.Panel",isDirty:!1,constructor:function(t){this.chooserCombo=new SYNO.Finder.Component.Facet.ComboBox({anchor:"100%",listeners:{scope:this,select:this.onComboboxSelect}}),this.selectorPanel=new SYNO.ux.Panel({width:328,margins:"0 0 0 8",layout:"fit",items:SYNO.Finder.Mgr.facetMgr.createSelectorByFieldName(this.chooserCombo.getValue())});var e={layout:{type:"hbox",align:"stretch"},cls:"criteria-chooser",height:28,items:[this.chooserCombo,this.selectorPanel]};this.callParent([Ext.apply(e,t)])},onDestroy:function(){SYNO.Finder.Mgr.facetMgr.unregisterInUse(this.chooserCombo.getValue()),this.callParent(arguments)},onComboboxSelect:function(t,e,i){var n=e.get("SYNOMDFieldName");this.selectorPanel.removeAll(),this.selectorPanel.add(SYNO.Finder.Mgr.facetMgr.createSelectorByFieldName(n)),this.selectorPanel.doLayout(),this.chooserCombo.updateRegistry(n)},setContent:function(t){this.selectorPanel.items.get(0).setContent(t)},setView:function(t){this.selectorPanel.removeAll(),this.selectorPanel.add(SYNO.Finder.Mgr.facetMgr.createSelectorByFieldName("SYNOMDIsDir"==t?"SYNOMDExtension":t)),this.selectorPanel.doLayout()},getCriteria:function(){return this.selectorPanel.items.get(0).getCriteria()},getName:function(){return this.selectorPanel.items.get(0).name},getFieldName:function(){return this.selectorPanel.items.get(0).getFieldName()},getCriteriaIndex:function(){return this.selectorPanel.items.get(0).fieldName},isValid:function(){return this.selectorPanel.items.get(0).isValid()},inEl:function(t){return!!t.within(this.chooserCombo.list)||this.selectorPanel.items.get(0).inEl(t)}}),Ext.define("SYNO.Finder.Component.Facet.ComboBox",{extend:"SYNO.ux.ComboBox",constructor:function(t){this.oldVal=SYNO.Finder.Mgr.facetMgr.getFirstIdleValue(),SYNO.Finder.Mgr.facetMgr.registerInUse(this.oldVal);var e={autoDestroy:!0,store:SYNO.Finder.Mgr.facetMgr.getCriteriaNameStore(),value:this.oldVal,width:280,editable:!0,displayField:"name",valueField:"SYNOMDFieldName",listeners:{blur:this.onBlur,scope:this}};this.callParent([Ext.apply(e,t)]),this.oldRawVal=this.getRawValue()},initEvents:function(){this.callParent(arguments),this.el.on("click",this.onClick,this),this.keyNav.esc=this.onEsc},onBlur:function(){this.superclass().setValue.call(this,this.oldRawVal)},onKeyUp:function(t,e,i){if(!t.isSpecialKey()||t.getKey()===t.BACKSPACE){this.store.clearFilter(!0);var n=[{property:"idle",value:"y"}];this.getRawValue().trim()&&n.push({property:"name",value:this.getRawValue(),caseSensitive:!1}),this.store.filter(n),this.selectedIndex=-1,this.onLoad()}},onClick:function(){this.selectText()},doQuery:function(){this.selectedIndex=-1,this.store.filter("idle","y"),this.onLoad()},onEsc:function(){this.collapse(),this.onBlur()},setValue:function(t){this.updateRegistry(t),this.callParent(arguments),this.oldRawVal=this.getRawValue()},updateRegistry:function(t){t!==this.getValue()&&t!==this.getRawValue()&&(this.oldVal&&SYNO.Finder.Mgr.facetMgr.unregisterInUse(this.oldVal),SYNO.Finder.Mgr.facetMgr.registerInUse(t),this.oldVal=t)}}),Ext.define("SYNO.Finder.Component.Facet.Entry",{extend:"SYNO.ux.Panel",placeholder:!1,constructor:function(t){this.criteriaChooser=new SYNO.Finder.Component.Facet.SearchCriteriaChooser({width:616}),this.addBtn=new SYNO.ux.Button({iconCls:"criteria-add-btn",width:24,scope:this,handler:this.onAddBtnClick}),this.delBtn=new SYNO.ux.Button({iconCls:"criteria-del-btn",width:24,height:28,scope:this,handler:this.onDelBtnClick});var e={height:28,cls:"entry",layout:"hbox",layoutConfig:{align:"strecth"},items:[this.criteriaChooser,{xtype:"container",width:24,height:28,margins:"0 6 0 6",items:this.delBtn},this.addBtn],bubbleEvents:["add","remove","criteriaadd","criteriadel"]};this.callParent([Ext.apply(e,t)])},onAddBtnClick:function(){this.fireEvent("criteriaadd")},onDelBtnClick:function(){this.fireEvent("criteriadel",this)},isPlaceholder:function(){return this.placeholder},unsetPlaceholder:function(){return this.placeholder=!1,this},getCriteria:function(){return this.criteriaChooser.getCriteria()},getFieldName:function(){return this.criteriaChooser.getFieldName()},getName:function(){return this.criteriaChooser.getName()},getValue:function(){return this.criteriaChooser.chooserCombo.getValue()},setContent:function(t){return this.criteriaChooser.setContent(t)},setView:function(t){return this.criteriaChooser.setView(t),this},setValue:function(t){return this.criteriaChooser.chooserCombo.setValue("SYNOMDIsDir"===t?"SYNOMDExtension":t),this},setDelDisabled:function(t){this.delBtn.setDisabled(t)},setAddDisabled:function(t){this.addBtn.setDisabled(t)},isValid:function(){return this.criteriaChooser.isValid()},inEl:function(t){return this.criteriaChooser.inEl(t)}}),Ext.ns("SYNO.Finder.Component.Facet"),Ext.define("SYNO.Finder.Component.Facet.List",{extend:"SYNO.ux.Panel",indicesInUse:[],constructor:function(t){var e={layout:"auto",items:[],bubbleEvents:["add","remove","criteriaentryadd","criteriaentrydel"]};this.indicesInUse={},this.callParent([Ext.apply(e,t)])},onCriteriaAdd:function(t){var e=new SYNO.Finder.Component.Facet.Entry({id:Ext.id(),placeholder:t||!1});return this.add(e),this.checkDisableDelAdd(),this.mon(e,"criteriaadd",this.onCriteriaAdd,this),this.mon(e,"criteriadel",this.onCriteriaDel,this),this.fireEvent("criteriaentryadd"),this.updateFleXcroll(),e},onCriteriaDel:function(t){this.remove(t),this.checkDisableDelAdd(),this.fireEvent("criteriaentrydel")},applyBookmark:function(t){if(this.removeAll(),!t.length)return void this.onCriteriaAdd(!0);Ext.each(t,function(t,e){this.onCriteriaAdd().setValue(t.json.fieldName).setView(t.json.fieldName).setContent(t.json)},this)},addEntryByFieldName:function(t){if(this.items.get(0).isPlaceholder())return void this.items.get(0).unsetPlaceholder().setValue(t).setView(t);this.onCriteriaAdd().setValue(t).setView(t)},scrollToEntryByFieldName:function(t){var e;if(this.items.each(function(i){if(i.getFieldName()===t)return e=i,!1}),e){var i=this.el.query(".flexcrollactive")[0];i&&i.fleXcroll.setScrollPos()}},checkDisableDelAdd:function(){var t=this.items.getCount();this.items.get(0).setDelDisabled(1===t),this.items.each(function(e){e.setAddDisabled(t===SYNO.Finder.Mgr.facetMgr.getCriteriaTotalCount())})},getAllCriteriaJson:function(){var t=[];return this.items.each(function(e){if(!e.isValid())return t=[],!1;var i=e.getCriteria();i.fieldName=e.getFieldName(),t.push({title:e.getName(),desc:i.text,json:i})}),t},deleteAll:function(){this.removeAll()},inEl:function(t){var e=!1;return this.items.each(function(i){e=e||i.inEl(t)}),e}}),Ext.define("SYNO.Finder.Component.Facet.Main",{extend:"SYNO.ux.Panel",FACET_PANEL_WIDTH:767,FACET_PANEL_HEIGHT:86,MAX_SHOWN_CRITERIA:4,constructor:function(t){this.searchCriteriaList=new SYNO.Finder.Component.Facet.List({});var e={floating:!0,cls:"facet-panel",shadow:!1,width:this.FACET_PANEL_WIDTH,height:this.FACET_PANEL_HEIGHT,items:this.searchCriteriaList,buttonAlign:"left",fbar:{items:[{xtype:"syno_button",text:SYNO.Finder.Utils._T("common","facet_reset"),handler:this.onResetBtnClick,scope:this},"->",{xtype:"syno_button",text:SYNO.Finder.Utils._T("helptoc","search"),btnStyle:"blue",handler:this.onSearchBtnClick,scope:this}]},listeners:{afterrender:this.onAfterRender,criteriaentryadd:this.onCriteriaEntryAdd,criteriaentrydel:this.onCriteriaEntryDel}};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,{facetSearchToggled:this.onFacetSearchToggled,bookmarkapply:this.onBookmarkApply,searchFieldCleared:this.resetList,searchFieldChanged:this.onSearchFieldChanged,searchNeeded:this.onSearchNeeded,setCompletionCriteria:this.onSetCompletionCriteria,scope:this}),this.mon(Ext.getDoc(),"mousedown",this.onMouseDown,this),this.callParent(arguments)},onCriteriaEntryAdd:function(){this.adjustHeight()},onCriteriaEntryDel:function(){this.adjustHeight()},onSetCompletionCriteria:function(t){this.showPanel(),"y"===t.get("data").idle?this.searchCriteriaList.addEntryByFieldName(t.get("data").fieldName):this.searchCriteriaList.scrollToEntryByFieldName(t.get("data").fieldName),this.adjustHeight()},onFacetSearchToggled:function(){this.isVisible()?this.hidePanel():this.showPanel()},onSearchFieldChanged:function(){this.hidePanel()},onSearchNeeded:function(){this.hidePanel()},onBookmarkApply:function(t){this.searchCriteriaList.applyBookmark(t.get("criteria")),this.adjustHeight(),this.fireSearchCriteriaChangedEvent()},onMouseDown:function(t){try{var e=this.ownerCt.searchField.textField.getEl(),i=this.ownerCt.searchField.searchBanner.getEl();if(!this.isVisible()||t.within(this.getEl())||t.within(e)||this.searchCriteriaList.inEl(t)||t.within(i))return;this.hidePanel()}catch(t){SYNO.Debug.error(t)}},onAfterRender:function(){this.alignPanel(),this.hidePanel(),this.searchCriteriaList.onCriteriaAdd(!0),this.adjustHeight()},onResetBtnClick:function(){this.resetList(),SYNO.Finder.Mgr.statusMgr.fireEvent("facetSearchBtnClick")},onSearchBtnClick:function(){this.fireSearchCriteriaChangedEvent()&&(SYNO.Finder.Mgr.statusMgr.fireEvent("facetSearchBtnClick"),this.hidePanel())},resetList:function(){this.searchCriteriaList.deleteAll(),this.searchCriteriaList.onCriteriaAdd(),this.adjustHeight(),this.fireSearchCriteriaChangedEvent()},fireSearchCriteriaChangedEvent:function(){var t=this.searchCriteriaList.getAllCriteriaJson();return SYNO.Finder.Mgr.statusMgr.applyData({currentSearchCriteria:t}).fireEvent("searchCriteriaChanged",t),!!t.length},alignPanel:function(){return this.el.alignTo(this.findAppWindow().el,"tl-tl",[12,64]),this},hidePanel:function(){this.setVisible(!1)},showPanel:function(){this.setVisible(!0).alignPanel().doLayout()},adjustHeight:function(){var t=Math.min(this.searchCriteriaList.items.getCount(),this.MAX_SHOWN_CRITERIA);this.setHeight(this.FACET_PANEL_HEIGHT+28*t+8*(t-1)),this.searchCriteriaList.setHeight(28*t+8*(t-1)).doLayout()}}),Ext.ns("SYNO.Finder.Component.Bookmark"),Ext.define("SYNO.Finder.Component.Bookmark.Quicklist",{extend:"SYNO.ux.Panel",QUICK_LIST_WIDTH:260,constructor:function(t){this.dataview=new SYNO.ux.FleXcroll.DataView({tpl:this.getTemplate(),store:SYNO.Finder.Mgr.bookmarkMgr.getStore(),itemSelector:"div.bookmark-entry",singleSelect:!0,listeners:{scope:this,click:this.onBookmarkClick}});var e={floating:!0,shadow:!1,layout:"fit",cls:"quicklist",items:this.dataview,width:this.QUICK_LIST_WIDTH,height:0,listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.callParent(arguments),this.mon(SYNO.Finder.Mgr.statusMgr,{bookmarksavesuccess:this.onBookmarkSaveSuccess,bookmarkloaded:this.onBookmarkLoad,scope:this}),this.mon(Ext.getDoc(),"mousedown",this.onDocMouseDown,this)},onAfterRender:function(){this.el.alignTo(this.alignTargetEl,"tr-br"),this.hidePanel(),this.bindDelBtnEvents()},onDocMouseDown:function(t,e){this.isVisible()&&!this.el.contains(e)&&!this.alignTargetEl.contains(e)&&Ext.getCmp(this.alignTargetEl.id).findAppWindow().el.contains(e)&&this.hidePanel()},onBookmarkSaveSuccess:function(t){this.adjustPanelHeight(),this.bindDelBtnEvents()},onBookmarkLoad:function(){this.adjustPanelHeight(),this.bindDelBtnEvents()},onBookmarkClick:function(t,e){var i=SYNO.Finder.Mgr.bookmarkMgr.getStore().getAt(e);i&&(this.hidePanel(),SYNO.Finder.Mgr.statusMgr.fireEvent("bookmarkapply",i))},onDelBtnClick:function(t){var e=this.dataview.indexOf(t.target.parentNode);SYNO.Finder.Mgr.statusMgr.fireEvent("bookmarkremove",e),this.adjustPanelHeight(),t.stopPropagation()},adjustPanelHeight:function(){var t=Math.min(SYNO.Finder.Mgr.bookmarkMgr.getStore().getCount(),10);return SYNO.Finder.Mgr.statusMgr.fireEvent("bookmarkCheckDisable",t),t?(this.setHeight(t?28*t+5+5:0),this.isVisible()&&this.dataview.updateFleXcroll(),this):(this.hidePanel(),this)},bindDelBtnEvents:function(){var t=this.el.query("a.del-btn");t&&Ext.each(t,function(t){"false"===t.getAttribute("data-binded")&&(Ext.get(t).on("click",this.onDelBtnClick,this),t.setAttribute("data-binded","true"))},this)},getTemplate:function(){return new Ext.XTemplate('<tpl for=".">','<div class="bookmark-entry">','<div class="wrapper" ext:qtip="{[this.getToolTip(values.criteria)]}">{name:htmlEncode}&nbsp;','<span class="keyword">{[this.processKeyword(values.keyword)]}</span>',"</div>",'<a class="del-btn" data-binded="false"></a>',"</div>","</tpl>",{getToolTip:function(t){var e=[];return Ext.each(t,function(t){e.push(SYNO.Finder.Utils.doubleHtmlEncode(String.format("{0}: {1}",t.title,t.desc)))}),Ext.isEmpty(e)?SYNO.Finder.Utils._T("common","no_search_criteria"):SYNO.Finder.Utils._T("common","facet_title")+":<br> "+e.join(",<br>")},processKeyword:function(t){return t.trim().length?Ext.util.Format.htmlEncode(String.format('"{0}"',t)):SYNO.Finder.Utils._T("common","no_keyword")}})},showPanel:function(){this.show().alignPanel().adjustPanelHeight()},hidePanel:function(){this.hide()},alignPanel:function(){return this.el.alignTo(this.alignTargetEl,"tr-br"),this},togglePanel:function(){this.isVisible()?this.hidePanel():this.showPanel()}}),Ext.ns("SYNO.Finder.Component"),Ext.define("SYNO.Finder.Component.ChangeViewBtn",{extend:"SYNO.ux.SplitButton",constructor:function(t){var e={cls:"finder-view-btn",margins:"0 0 0 6",disabled:!0,iconCls:SYNO.Finder.Mgr.viewModeMgr.getIconClsByCategory("all"),menu:this.getMenu(),scope:this,handler:this.advanceViewMode};this.callParent([Ext.apply(e,t)]),this.initEvents()},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,{searchCategoryChanged:this.onSearchCategoryChanged,changeViewMode:this.onChangeViewMode,updateViewMode:this.onUpdateMenuItem,scope:this})},onSearchCategoryChanged:function(t){var e=0,i=this.getMenu(),n=SYNO.Finder.Mgr.viewModeMgr.getCategoryDetails();Ext.each(i.items.items,function(i){-1!==n[t].views.indexOf(i.itemId)?(e+=1,i.show()):i.hide()},this);var r=1>=e||SYNO.Finder.Mgr.viewModeMgr.FINDER_VIEW_ID_WELCOME===SYNO.Finder.Mgr.statusMgr.getData("currentViewMode");this.setDisabled(r),r&&this.clearTip(),i.doLayout()},onChangeViewMode:function(t){var e=SYNO.Finder.Mgr.viewModeMgr.getIconClsByViewMode(t);e&&this.setIconClass(e);var i=SYNO.Finder.Mgr.viewModeMgr.getViewModeMap()[t].disableChangeViewBtn||SYNO.Finder.Mgr.viewModeMgr.FINDER_VIEW_ID_WELCOME===SYNO.Finder.Mgr.statusMgr.getData("currentViewMode");this.setDisabled(i),i?this.clearTip():this.setTooltip({text:SYNO.Finder.Mgr.viewModeMgr.getViewModeMap()[t].title})},onClickMenuItem:function(t){SYNO.Finder.Mgr.statusMgr.applyData({currentViewMode:t.itemId}).fireEvent("changeViewMode",t.itemId)},getMenu:function(){var t=[];return Ext.isDefined(this.menu)||(Ext.iterate(SYNO.Finder.Mgr.viewModeMgr.getViewModeMap(),function(e,i){if(i.hidden)return!0;t.push({itemId:e,iconCls:i.iconCls,text:i.title,scope:this,handler:this.onClickMenuItem})},this),this.menu=new Ext.menu.Menu({cls:"syno-finder",items:t})),this.menu},onUpdateMenuItem:function(t,e){this.getMenu().add({itemId:t,iconCls:e.iconCls,text:e.title,scope:this,handler:this.onClickMenuItem})},advanceViewMode:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("currentViewMode"),e=SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory"),i=SYNO.Finder.Mgr.viewModeMgr.getCategoryDetails()[e].views,n=i.indexOf(t);n=(n+1)%i.length,SYNO.Finder.Mgr.statusMgr.applyData({currentViewMode:i[n]}).fireEvent("changeViewMode",i[n])}}),Ext.define("SYNO.Finder.Component.CategorySideBar",{extend:"SYNO.ux.Panel",BUILT_IN_CATEGORIES:8,constructor:function(t){this.dataView=new SYNO.ux.FleXcroll.DataView({useDefaultKeyNav:!1,itemSelector:"div.finder-category",singleSelect:!0,store:this.createStore(),tpl:this.getTemplate(),doSingleSelection:this.onDataviewSingleSelection.createDelegate(this),listeners:{scope:this,click:this.onClickCategory,selectionchange:this.onSelectionChange,containerclick:this.onContainerClick,afterrender:this.onAfterRender}});var e={cls:"finder-categorybar syno-ux-modulelist scroll-at-top",layout:"fit",items:this.dataView};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(SYNO.Finder.Mgr.pluginMgr,"pluginadd",this.onAddPlugin,this),this.mon(SYNO.Finder.Mgr.pluginMgr,"pluginremove",this.onRemovePlugin,this),this.mon(SYNO.Finder.Mgr.statusMgr,"indicatorUpdated",this.onIndicatorUpdated,this)},onIndicatorUpdated:function(){this.store.data.each(function(t){var e=this.el.query("#"+t.get("search_category_name"))[0];if(!e)return!0;SYNO.Finder.Mgr.statusMgr.getIndicator(t.get("search_category_name"))?Ext.fly(e).addClass("indicator-on"):Ext.fly(e).removeClass("indicator-on")},this)},onContainerClick:function(){return!1},onDataviewSingleSelection:function(t,e,i){this.dataView.select(e,!1)},createStore:function(){return this.store=new Ext.data.ArrayStore({fields:["section","name","search_category_name","icon_cls","key"],data:[["",SYNO.Finder.Utils._T("common","category_all_results"),"all","c_all_results","'0"],[SYNO.Finder.Utils._T("common","category_section_files"),SYNO.Finder.Utils._T("common","category_all_files"),"file","c_all_files","'1"],[SYNO.Finder.Utils._T("common","category_section_files"),SYNO.Finder.Utils._T("common","type_document"),"document","c_document","'2"],[SYNO.Finder.Utils._T("common","category_section_files"),SYNO.Finder.Utils._T("common","type_photo"),"image","c_photo","'3"],[SYNO.Finder.Utils._T("common","category_section_files"),SYNO.Finder.Utils._T("common","type_music"),"audio","c_audio","'4"],[SYNO.Finder.Utils._T("common","category_section_files"),SYNO.Finder.Utils._T("common","type_video"),"video","c_video","'5"],[SYNO.Finder.Utils._T("common","category_section_others"),SYNO.Finder.Utils._T("common","category_help"),"help","c_help","'6"],[SYNO.Finder.Utils._T("common","category_section_others"),SYNO.Finder.Utils._T("common","category_app"),"app","c_application","'7"]]}),Ext.each(SYNO.Finder.Mgr.pluginMgr.getPlugins(),function(t){this.store.add(new this.store.recordType({section:SYNO.Finder.Utils._T("common","category_section_packages"),name:t.getText(),search_category_name:t.getPluginId(),icon_cls:t.getIconCls(),key:t.getText()}))},this),this.store},getTemplate:function(){return new Ext.XTemplate('<tpl for=".">','<tpl if="this.checkSection(values.section)">','<div class="section-title">{section:uppercase}</div>',"</tpl>",'<div id="{search_category_name}" class="finder-category">','<div class="finder-category-inner-wrapper">','<span class="cat-icon-{icon_cls}">',"</span>",'<span class="title">{name}</span>',"</div>","</div>","</tpl>",{lastSection:"",checkSection:function(t){return this.lastSection!=t&&!Ext.isEmpty(t)&&(this.lastSection=t,!0)}})},refreshDataView:function(){var t=this.dataView.getSelectedRecords();this.store.sort("key","ASC"),this.dataView.refresh(),this.el.query(".section-title").each(function(t){var e=Ext.get(t);e.getTextWidth()>150?Ext.QuickTips.register({target:e,text:t.textContent}):Ext.QuickTips.unregister(e)}),this.el.query(".finder-category .title").each(function(t){var e=Ext.get(t);e.getTextWidth()>110?Ext.QuickTips.register(e,{target:e,text:t.textContent}):Ext.QuickTips.unregister(e)}),0===t.length||t[0]>=this.store.getCount()?this.dataView.select(0):this.dataView.select(t[0])},onAddPlugin:function(t){-1===this.store.find("search_category_name",t.getPluginId())&&(this.store.add(new this.store.recordType({section:SYNO.Finder.Utils._T("common","category_section_packages"),name:t.getText(),search_category_name:t.getPluginId(),icon_cls:t.getIconCls(),key:t.getText()})),this.refreshDataView())},onRemovePlugin:function(t){var e=this.store.find("search_category_name",t);this.store.removeAt(e),this.refreshDataView()},onAfterRender:function(){this.dataView.select(0)},onSelectionChange:function(t){Ext.each(t.getSelectedIndexes(),function(e){var i=t.store.getAt(e).get("search_category_name");i!==SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory","all")&&SYNO.Finder.Mgr.statusMgr.applyData({currentSearchCategory:i}).fireEvent("searchCategoryChanged",i)},this)},onClickCategory:function(t,e,i,n){var r=this.store.getAt(e).get("search_category_name");r!==SYNO.Finder.Mgr.statusMgr.getData("currentSearchCategory","all")&&SYNO.Finder.Mgr.statusMgr.applyData({currentSearchCategory:r}).fireEvent("searchCategoryChanged",r)}}),Ext.namespace("SYNO.Finder.Component.Board"),Ext.define("SYNO.Finder.Component.Board.Main",{extend:"SYNO.ux.Panel",CATEGORY_BAR_WIDTH:198,PREVIEW_WIDTH:363,RESULT_WIDTH:292,constructor:function(t){this.categorySideBar=new SYNO.Finder.Component.CategorySideBar({width:this.CATEGORY_BAR_WIDTH,region:"west"}),this.resultLister=new SYNO.Finder.Component.Board.Result({region:"center",minWidth:this.RESULT_WIDTH}),this.previewPanel=new SYNO.Finder.Component.Preview.Main({region:"east",width:this.PREVIEW_WIDTH,minWidth:this.PREVIEW_WIDTH,split:!0,collapsible:!0,collapsed:!0,floatable:!1});var e={layout:"border",cls:"result-section-panel",flex:1,margins:"8 0 0 0",defaults:{margin:0},items:[this.categorySideBar,this.resultLister,this.previewPanel],listeners:{scope:this,resize:this.onMyResize,afterlayout:{scope:this,single:!0,fn:this.onAfterLayout}}};this.callParent([Ext.apply(e,t)])},onAfterLayout:function(){var t=this.getLayout().east.getSplitBar();t.el.un("dblclick",this.getLayout().east.onCollapseClick,this.getLayout().east),t.el.on("dblclick",this.onSplitBarClick,this)},onSplitBarClick:function(){SYNO.Finder.Mgr.statusMgr.fireEvent("previewToggled")},onMyResize:function(t,e){e-this.RESULT_WIDTH-this.CATEGORY_BAR_WIDTH<=this.previewPanel.getWidth()&&(this.previewPanel.setWidth(e-this.CATEGORY_BAR_WIDTH-this.RESULT_WIDTH),this.doLayout())}}),Ext.define("SYNO.Finder.Component.Board.Result",{extend:"SYNO.ux.Panel",maskPromise:null,rejectFn:null,constructor:function(t){var e={layout:"card",cls:"result-list-section",activeItem:SYNO.Finder.Mgr.viewModeMgr.FINDER_VIEW_ID_WELCOME,items:SYNO.Finder.Mgr.viewModeMgr.getAllViewComp()};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,{changeViewMode:this.onChangeViewMode,updateViewMode:this.onUpdateViewMode,searchNeeded:this.onSearchNeeded,searchDone:this.onSearchDone,scope:this}),this.callParent(arguments)},onSearchNeeded:function(t){this.transitionMask()},onSearchDone:function(t,e,i){i||this.unmasking||this.maskPromise.then(function(){var t=function(){this.el.unmask(),this.unmasking=!1}.createDelegate(this),e=Ext.Element.data(this.el.dom,"mask");e&&(this.unmasking=!0,e.animate({opacity:{to:0,from:1}},.25,t,"easeIn"))}.createDelegate(this))},onChangeViewMode:function(t){this.setViewMode(t)},onUpdateViewMode:function(t,e){this.add(e.viewComp),this.doLayout()},setViewMode:function(t){this.getLayout().setActiveItem(t),this.doLayout()},transitionMask:function(){this.maskPromise&&this.rejectFn&&this.rejectFn(),this.el.mask();var t=Ext.Element.data(this.el.dom,"mask");this.maskPromise=new Promise(function(e,i){t&&t.animate({opacity:{to:1,from:0}},SYNO.Finder.Mgr.statusMgr.BOARD_FADE_OUT_DELAY/1e3,e,"easeOut")})}}),Ext.ns("SYNO.Finder.Component"),Ext.define("SYNO.Finder.Component.ToastBase",{extend:"SYNO.ux.Panel",WIDTH:340,timeout:null,timeoutBegin:null,timeoutRemain:null,isSlideInDone:null,isCollapsed:!0,constructor:function(t){var e={cls:"index-prompt-toast",width:this.WIDTH,floating:!0,shadow:!1,layout:"auto",items:this.fillItems(),slideInDirection:"left",noTimeout:!1,noCloseBtn:!1,listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},fillItems:function(){return[{border:!1,cls:"prompt",tpl:this.createContentTemplate()}]},initEvents:function(){
this.mon(SYNO.Finder.Mgr.statusMgr,"toastshow",this.showPanel,this)},onAddNowClick:function(){throw"Not implemented"},onCloseBtnClick:function(){this.setDisabled(!0),this.hidePanel()},onMouseEnter:function(){this.timeout&&(this.timeoutRemain=this.timeoutRemain-(new Date-this.timeoutBegin),window.clearTimeout(this.timeout))},onMouseLeave:function(){this.timeoutRemain>0&&(this.timeout=window.setTimeout(function(){this.hidePanel()}.createDelegate(this),this.timeoutRemain))},onDestroy:function(){window.clearTimeout(this.timeout),this.callParent(arguments)},onAfterRender:function(){this.el.on("mouseenter",this.onMouseEnter,this),this.el.on("mouseleave",this.onMouseLeave,this),this.el.select("a").on("click",this.onAddNowClick,this),this.noCloseBtn||(this.closeBtn=new SYNO.ux.Panel({renderTo:this.el,floating:!0,shadow:!1,width:24,height:24,items:{xtype:"syno_button",iconCls:"close-btn",scope:this,handler:this.onCloseBtnClick}}),this.closeBtn.el.alignTo(this.el,"tr-tr",[-3,3]),this.addManagedComponent(this.closeBtn))},showPanel:function(){throw"Not implemented"},slideOutCb:function(){this.isCollapsed=!0},hidePanel:function(){this&&this.el&&this.el.animate(this.animation.slideOutOption,.5,this.slideOutCb.createDelegate(this),"easeOut")},alignShownPanel:function(){this.el.alignTo(this.alignTargetEl,"br-br",[-12,-12])},alignHiddenPanel:function(){"up"==this.slideInDirection?this.el.alignTo(this.alignTargetEl,"tr-br",[-12,0]):"left"==this.slideInDirection&&this.el.alignTo(this.alignTargetEl,"bl-br",[0,-12])},alignPanel:function(){this.alignHiddenPanel()},slideInCb:function(){this&&this.el&&this.alignTargetEl&&this.alignTargetEl.dom&&(this.alignShownPanel(),this.isSlideInDone=!0,this.noTimeout||(this.timeoutRemain=5e3,this.timeoutBegin=new Date,this.timeout=window.setTimeout(function(){this.hidePanel()}.createDelegate(this),this.timeoutRemain)))},slideIn:function(){this.animation={slideInOption:"up"==this.slideInDirection?{opacity:{from:0,to:1},top:{by:-12-this.getHeight(),unit:"px"}}:{opacity:{from:0,to:1},left:{by:-12-this.getWidth(),unit:"px"}},slideOutOption:"up"==this.slideInDirection?{opacity:{from:1,to:0},top:{by:12+this.getHeight(),unit:"px"}}:{opacity:{from:1,to:0},left:{by:12+this.getWidth(),unit:"px"}}},this.isCollapsed=!1,this.el.animate(this.animation.slideInOption,.5,this.slideInCb.createDelegate(this),"easeOut")},createContentTemplate:function(){throw"Not implemented"}}),Ext.ns("SYNO.Finder.Component"),Ext.define("SYNO.Finder.Component.IndexPromptToast",{extend:"SYNO.Finder.Component.ToastBase",WIDTH:340,timeout:null,timeoutBegin:null,timeoutRemain:null,isSlideInDone:null,constructor:function(t){this.callParent([t])},fillItems:function(){return this.progressIndicator=new Ext.Container({cls:"progress-indicator",width:24,margins:"0 12 0 10"}),[{border:!1,cls:"prompt",data:{},tpl:this.createContentTemplate()},{xtype:"container",height:40,cls:"info",layout:"hbox",layoutConfig:{align:"stretch"},items:[{xtype:"syno_checkbox",boxLabel:SYNO.Finder.Utils._T("common","prompt_sus_dont_show_again"),flex:1,scope:this,handler:this.onCheck},this.progressIndicator]}]},onCheck:function(t){this.progressIndicator.removeClass("done"),this.progressIndicator.removeClass("done-fading"),this.progressIndicator.addClass("syncing");var e=SYNO.Finder.Mgr.statusMgr.getData("preference",{});this.sendWebAPI({api:"SYNO.Finder.Preference",version:1,method:"set",params:{data:Ext.apply(e,{hide_finder_index_prompt:!0})},scope:this,callback:function(){this.progressIndicator.removeClass("syncing"),this.progressIndicator.addClass("done"),this.progressIndicator.addClass("done-fading")}})},onAddNowClick:function(){SYNO.Finder.Mgr.statusMgr.fireEvent("prefDialogShow")},createContentTemplate:function(){return new Ext.XTemplate('<div class="tip">'+SYNO.Finder.Utils._T("common","index_prompt_tip")+"</div>",String.format('<div class="content">{0} <a>{1}</a></div>',SYNO.Finder.Utils._T("common","prompt_sus"),SYNO.Finder.Utils._T("common","prompt_add_now")))},showPanel:function(){var t=SYNO.Finder.Mgr.statusMgr.getData("preference",{});_S("is_admin")&&!t.hide_finder_index_prompt&&this.sendWebAPI({api:"SYNO.Finder.FileIndexing.Folder",method:"list",version:1,params:{direction:"asc",sort_by:"path",offset:0,additional:[]},scope:this,callback:function(t,e){t&&e.folder.length||window.setTimeout(function(){this.alignPanel(),this.slideIn()}.createDelegate(this),1e3)}})}}),Ext.ns("SYNO.Finder.Component"),Ext.define("SYNO.Finder.Component.DBCrashedToast",{extend:"SYNO.Finder.Component.ToastBase",WIDTH:380,constructor:function(t){var e={fbar:{items:["->",{xtype:"syno_button",text:SYNO.Finder.Utils._T("common","close"),handler:this.onCloseBtnClick.createDelegate(this)}]}};this.callParent([Ext.apply(e,t)]),this.lastSearchCrashed=!1},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,"searchDone",this.onSearchDone,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchTotalAdd",this.onSearchTotalAdd,this)},fillItems:function(){return[{border:!1,cls:"prompt error",itemId:"body",data:{str:"abc"},tpl:this.createContentTemplate()}]},createContentTemplate:function(){return new Ext.XTemplate('<div class="error-icon"></div><div class="tip error">'+SYNO.Finder.Utils._T("common","database_error_detected_title")+"</div>",'<div class="content">{str} <a>'+SYNO.Finder.Utils._T("common","check_index_database")+"</a></div>")},onCheckNowClick:function(){SYNO.Finder.Mgr.statusMgr.fireEvent("prefDialogShow"),this.onCloseBtnClick()},onSearchDone:function(t,e,i,n,r){"file"!==t||i||(Ext.isEmpty(n)&&!r?this.lastSearchCrashed=!1:this.lastSearchCrashed=!0)},onSearchTotalAdd:function(t){"file"===t&&this.lastSearchCrashed&&this.showPanel()},showPanel:function(){this.getComponent("body").update({str:SYNO.Finder.Utils._T("common","database_error_detected_desc")}),this.el.select("a").on("click",this.onCheckNowClick,this),!0===this.isCollapsed&&(this.alignPanel(),this.setDisabled(!1),this.slideIn())}}),Ext.namespace("SYNO.Finder"),Ext.define("SYNO.Finder.Application",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.Finder.MainWindow"}),Ext.define("SYNO.Finder.MainWindow",{extend:"SYNO.SDS.AppWindow",WINDOW_DEFAULT_WIDTH:1e3,WINDOW_DEFAULT_HEIGHT:600,constructor:function(t){this.initMgr(),this.mainPanel=new SYNO.Finder.MainPanel({flex:1,parent:this,appWin:this});var e={width:this.WINDOW_DEFAULT_WIDTH,height:this.WINDOW_DEFAULT_HEIGHT,minWidth:1e3,minHeight:600,layout:{type:"fit"},items:[this.mainPanel],cls:"syno-finder"};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,{searchKeywordPressEsc:this.onSearchKeywordPressEsc,scope:this}),this.callParent(arguments)},onSearchKeywordPressEsc:function(t){""===t&&this.close()},onRequest:function(t){SYNO.Finder.MainWindow.superclass.onRequest.apply(this,arguments),t&&"preference"===t.fn&&this.mainPanel.onPreferencesClick(t.data),t&&t.type&&this.mainPanel.board.categorySideBar.dataView.select(t.type),t&&t.keyword&&SYNO.Finder.Mgr.statusMgr.fireEvent("setCompletionKeyword",t.keyword)},onOpen:function(t){SYNO.Finder.MainWindow.superclass.onOpen.apply(this,arguments),this.setStatusBusy(),this.sendWebAPI({api:"SYNO.Entry.Request",version:1,method:"request",params:{compound:[{api:"SYNO.Finder.Bookmark",method:"get",version:1},{api:"SYNO.Finder.Preference",method:"get",version:1},{api:"SYNO.Finder.Settings",method:"get",version:1}]},scope:this,callback:function(e,i){this.clearStatusBusy(),e&&(SYNO.Finder.Mgr.statusMgr.fireEvent("bookmarkloaded",i.result[0].data.bookmarks),SYNO.Finder.Mgr.statusMgr.applyData({preference:i.result[1].data,settings:i.result[2].data})),t&&t.type&&this.mainPanel.board.categorySideBar.dataView.select(t.type),t&&t.keyword?SYNO.Finder.Mgr.statusMgr.fireEvent("setCompletionKeyword",t.keyword):t.fn||SYNO.Finder.Mgr.statusMgr.fireEvent("setCompletionKeyword"),SYNO.Finder.Mgr.statusMgr.fireEvent("toastshow"),t&&"preference"===t.fn&&this.mainPanel.onPreferencesClick(t.data)}})},initMgr:function(){this.addManagedComponent(SYNO.Finder.Mgr.pluginMgr=new SYNO.Finder.Package.PluginMgr({})),this.addManagedComponent(SYNO.Finder.Mgr.actionMgr=new SYNO.Finder.Mgr.Action({})),this.addManagedComponent(SYNO.Finder.Mgr.statusMgr=new SYNO.Finder.Mgr.Status({})),this.addManagedComponent(SYNO.Finder.Mgr.searcherMgr=new SYNO.Finder.Mgr.Search({})),this.addManagedComponent(SYNO.Finder.Mgr.viewModeMgr=new SYNO.Finder.Mgr.ViewMode({})),this.addManagedComponent(SYNO.Finder.Mgr.bookmarkMgr=new SYNO.Finder.Mgr.Bookmark({})),this.addManagedComponent(SYNO.Finder.Mgr.facetMgr=new SYNO.Finder.Mgr.Facet({})),SYNO.Finder.Mgr.statusMgr.applyData({appWin:this})},onDestroy:function(){SYNO.Finder.Mgr.statusMgr=null,SYNO.Finder.Mgr.viewModeMgr=null,SYNO.Finder.Mgr.pluginMgr=null,SYNO.Finder.Mgr.actionMgr=null,SYNO.Finder.Mgr.searcherMgr=null,SYNO.Finder.Mgr.bookmarkMgr=null,SYNO.Finder.Mgr.facetMgr=null},onEsc:function(t,e){this.activeGhost&&this.unghost(),e.stopEvent(),e.target!==this.mainPanel.searchField.textField.el.dom&&this.close()}}),Ext.define("SYNO.Finder.MainPanel",{extend:"SYNO.ux.Panel",PREVIEW_CLOSED_CLS:"preview-closed",constructor:function(t){this.searchField=new SYNO.Finder.Component.SearchField.Main({}),this.facetPanel=new SYNO.Finder.Component.Facet.Main({}),this.changeViewButton=new SYNO.Finder.Component.ChangeViewBtn({width:51}),this.board=new SYNO.Finder.Component.Board.Main({}),this.bookmarkBtn=new SYNO.ux.Button({margins:"0 0 0 10",width:32,scope:this,name:"quicklist_btn",tooltip:SYNO.Finder.Utils._T("common","quick_list"),iconCls:"bookmark-button",handler:this.onBookmarkClick}),this.previewBtn=new SYNO.ux.Button({margins:"0 12 0 6",width:32,scope:this,iconCls:"preview-button",tooltip:SYNO.Finder.Utils._T("common","toggle_preview"),disabled:!0,handler:this.onPreviewButtonClick}),this.searchToolbar=new SYNO.ux.Panel({cls:"finder-top-toolbar",height:28,layout:{type:"hbox",align:"stretch"},items:[this.searchField,this.bookmarkBtn,{xtype:"syno_button",margins:"0 0 0 6",width:32,scope:this,iconCls:"pref-button",tooltip:SYNO.Finder.Utils._T("dsmsetting","uioptions"),handler:this.onPreferencesClick},this.changeViewButton,this.previewBtn]});var e={cls:this.PREVIEW_CLOSED_CLS,layout:{type:"vbox",align:"stretch"},items:[this.searchToolbar,this.facetPanel,this.board],listeners:{afterrender:this.onAfterRender,resize:this.onMyResize,scope:this}};this.callParent([Ext.apply(e,t)])},initEvents:function(){this.mon(SYNO.Finder.Mgr.statusMgr,"previewToggled",this.onPreviewToggled,this),this.mon(SYNO.Finder.Mgr.statusMgr,"bookmarkCheckDisable",this.onBookmarkCheckDisable,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchFieldCleared",this.onSearchFieldCleared,this),this.mon(SYNO.Finder.Mgr.statusMgr,"searchDone",this.onSearchDone,this),this.mon(SYNO.Finder.Mgr.statusMgr,"prefDialogShow",this.onPreferencesClick,this),this.mon(SYNO.Finder.Mgr.statusMgr,"launchFolderList",this.onLaunchFolderList,this)},onLaunchFolderList:function(){this.onPreferencesClick({tab:"fileindex"})},onSearchFieldCleared:function(){this.previewBtn.setDisabled(!0)},onSearchDone:function(){this.previewBtn.setDisabled(!1)},onBookmarkCheckDisable:function(t){this.bookmarkBtn.setDisabled(0===t)},onMyResize:function(){SYNO.Finder.Utils.debug("main panel resize"),SYNO.Finder.Mgr.statusMgr.fireEvent("mainPanelResized"),this.alignToolkit(),this.alignToastMessage()},onAfterRender:function(){this.mon(this.searchField,"afterlayout",function(){this.alignToolkit()},this),this.mon(this.searchField,"afterrender",function(){this.toolkit=new SYNO.Finder.Component.Toolkit.Main({renderTo:this.searchField.el}),this.addManagedComponent(this.toolkit)},this);var t=this.find("name","quicklist_btn")[0];this.mon(t,"afterrender",function(){this.quicklist=new SYNO.Finder.Component.Bookmark.Quicklist({alignTargetEl:t.el||t,renderTo:this.findAppWindow().el})},this),this.indexPromptToastMessage=new SYNO.Finder.Component.IndexPromptToast({renderTo:this.el,alignTargetEl:this.el}),this.dbCrashedMessage=new SYNO.Finder.Component.DBCrashedToast({renderTo:this.el,alignTargetEl:this.el,slideInDirection:"up",style:"z-index: 20002",noTimeout:!0,noCloseBtn:!0}),this.addManagedComponent(this.indexPromptToastMessage),this.addManagedComponent(this.dbCrashedMessage)},onBookmarkClick:function(t){this.quicklist.togglePanel()},onPreferencesClick:function(t){this.findAppWindow().maskCnt||new SYNO.Finder.Preference.MainDialog({owner:this.findWindow(),launchAction:t&&t.tab,launchData:t&&t.data}).show()},onPreviewButtonClick:function(){SYNO.Finder.Mgr.statusMgr.fireEvent("previewToggled")},onPreviewToggled:function(){this.el.toggleClass(this.PREVIEW_CLOSED_CLS)},alignToolkit:function(){this.toolkit&&this.toolkit.el.alignTo(this.searchField.el,"tr-tr",[-1,0])},alignToastMessage:function(){this.indexPromptToastMessage&&this.indexPromptToastMessage.isSlideInDone&&this.indexPromptToastMessage.el.alignTo(this.el,"br-br",[-12,-12]),this.termSuggPromptToastMessage&&this.termSuggPromptToastMessage.isSlideInDone&&this.termSuggPromptToastMessage.el.alignTo(this.el,"br-br",[-12,-12])}});
