#!/bin/sh

. /var/packages/VideoStation/scripts/common

SYNODTV_BIN="${PACKAGE_DIR}/target/sbin/synodtvd"

if [ -e "/usr/syno/sbin/syno_dvb_admin.sh" ]; then
	DVB_ADMIN="/usr/syno/sbin/syno_dvb_admin.sh"
else
	DVB_ADMIN="${PACKAGE_DIR}/target/scripts/DVB_Admin.sh"
fi

start()
{
	[ -e "${DVB_ADMIN}" ] && ${DVB_ADMIN} "start" "${PACKAGE_DIR}"

	# synodtv daemon
	${SYNODTV_BIN} start
}

stop()
{
	# synodtv daemon
	${SYNODTV_BIN} stop

	[ -e "${DVB_ADMIN}" ] && ${DVB_ADMIN} "stop" "${PACKAGE_DIR}"
}

# exit when synodtvd not exists
if [ ! -e ${SYNODTV_BIN} ]; then
	exit 0
fi

# exit when platform is applepie
if [ "yes" == "`/bin/get_key_value /etc.defaults/synoinfo.conf support_dual_head`" ]; then
	exit
fi

# exit when ddsm
/usr/syno/bin/synoddsmtool --is-ddsm
if [ "0" == "$?" ]; then
	exit
fi

# exit when vdsm
if [ "kvmx64" == "`/bin/get_key_value /etc.defaults/synoinfo.conf synobios`" ]; then
	exit
fi

case $1 in
	start)
		start
		exit 0
	;;
	stop)
		stop
		exit 0
	;;
esac
