#!/usr/bin/php
<?php

require_once(dirname(__FILE__) . '/../search.inc.php');
require_once(dirname(__FILE__) . '/dbmgr/synomovie.php');
require_once(dirname(__FILE__) . '/dbmgr/atmovie.php');

define('PLUGINID', 			'com.synology.AtMovie');

$DEFAULT_TYPE = 'movie';
$DEFAULT_LANG = 'cht';

$SUPPORTED_TYPE = array('movie');
$SUPPORTED_PROPERTIES = array('title');

function ConvertToAPILang($lang)
{
	static $map = array(
		'cht' => 'cht'
	);

	$ret = isset($map[$lang]) ? $map[$lang] : NULL;
	return $ret;
}

function RecognizePrefix($id) {
	$prefix = substr($id, 0, 3);
	switch ($prefix) {
	case 'im_':
		return 'imdb';
	case 'at_':
		return 'atmovie';
	}
}

function Process($input, $lang, $type, $limit, $search_properties, $allowguess)
{
	global $DATA_TEMPLATE;

	//Init
	$title 	= $input['title'];
	$year 	= ParseYear($input['original_available']);
	$season  = $input['season'];
	$episode = $input['episode'];
	if ($lang != 'cht') {
		return array();
	}

	//year
	if (isset($input['extra']) && count($input['extra']) > 0) {
		$pluginid = array_shift($input['extra']);
		if (!empty($pluginid['tvshow']['original_available'])) {
			$year = ParseYear($pluginid['tvshow']['original_available']);
		}
	}

	//Set
	$cache_dir = GetPluginDataDirectory(PLUGINID);

	if ("movie" == $type) {
		//Get videodb
		$videodb = new Synomovie();
		$videodb->Init(PLUGINID, $cache_dir);

		//Search
		$query_data = array();
		$titles = GetGuessingList($title, $allowguess);
		foreach ($titles as $query) {
			if (empty($query)) {
				continue;
			}
			if ($year) {
				$query = "{$query} {$year}";
			}
			$query_data = $videodb->Query($query, $lang, $limit);
			if (0 < count($query_data)) {
				break;
			}
		}

		//Get metadata
		if (count($query_data) > 0) {

			//If id comes from atmovie, we should get metadata from atmovie website directly
			$dbname = RecognizePrefix($query_data[0]['id']);
			if ('atmovie' == $dbname) {
				$videodb = new Atmovie();
				$videodb->Init(PLUGINID, $cache_dir);
				return $videodb->GetMovieMetadata($query_data, $lang, $DATA_TEMPLATE);
			}
		}
	}
		return array();
}

PluginRun('Process');

?>
