#!/bin/sh

BASEDIR=$(dirname $0)
ARGV=""

escape()
{
	local ARG=$(echo -E $@ | sed "s/'/'\\\\''/g")
	echo \'$ARG\'
}

# set IFS to empty, to avoid multiple whitespaces to be explained as one
ORIGINAL_IFS=$IFS
IFS=""

i=1
while [ $i -le $# ]; do
	eval ARG=\$\(escape \${$i}\)
	ARGV="$ARGV $ARG"
	i=`expr $i + 1`
done

TZ=`cat /etc/php/php.ini | grep timezone | cut -d' ' -f3`

eval "/usr/bin/php -n -d open_basedir= "\
"-d date.timezone=\"$TZ\" "\
"-d extension_dir=/lib/php/modules "\
"-d extension=curl.so "\
"-d extension=json.so "\
"$BASEDIR/search.php $ARGV"

IFS=$ORIGINAL_IFS
