<?php
define('EA_METADATA', 'SYNOVIDEO_TV_RECORD');
define('EA_METADATA_DEPRECATED', 'SYNOVIDEO:TV_RECORD');

/* list($title, $tagline, $original_available, $summary) */
function GetTVInfo($path)
{
	$pathinfo = pathinfo($path);
	$metafile = $pathinfo['dirname'] . '/@eaDir/' . $pathinfo['basename']. '/' . EA_METADATA;

	$title = 'Unknown';
	list($tagline) = CleanName($pathinfo['filename']);
	@$original_available = date('Y-m-d H:i:s', @filemtime($path));
	$summary = null;

	if (!file_exists($metafile)) {
		$metafile = $pathinfo['dirname'] . '/@eaDir/' . $pathinfo['basename']. '/' . EA_METADATA_DEPRECATED;
	}

	if (!file_exists($metafile)) {
		return array($title, $tagline, $original_available, $summary);
	}

	$data = file_get_contents($metafile);
	$data = json_decode($data, true);

	if (isSet($data['channel'])) {
		$title = $data['channel'];
	}
	if (isSet($data['title'])) {
		$tagline = $data['title'];
	}
	if (isSet($data['start'])) {
		@$original_available = date('Y-m-d H:i:s', $data['start']);
	}
	if (isSet($data['description'])) {
		$summary = $data['description'];
	}

	return array($title, $tagline, $original_available, $summary);
}
?>
