#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       NITEMS, SHARE_NAME_X
###############################################################

BIN_SYNOSHARE=/usr/syno/sbin/synoshare

DeleteIndexSharePath() {
	INDEX=1
	NITEMS=$((NITEMS + 1))
	while [ "${INDEX}" != "${NITEMS}" ]
	do
		eval "SHARE_NAME=\$SHARE_NAME_$INDEX"
		SHARE_PATH=`${BIN_SYNOSHARE} --get ${SHARE_NAME} | awk '$1 == "Path" {print $2}' | sed 's/^\.*\[//g' | sed 's/\]$//g'`
		php -d open_basedir="/var/packages/VideoStation/etc:/var/run" /var/packages/VideoStation/target/scripts/DoIndex.php -a d -s "$SHARE_NAME" -o "$SHARE_PATH" &
		INDEX=$((INDEX + 1))
	done
}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "2.0"
	;;
	--name)
	#Print package name
	echo "VideoStation"
	;;
	--pkg-ver)
	#Print package version
	echo "1.0"
	;;
	--vendor)
	#Print package vendor
	echo "Synology Inc."
	;;
	--pre)
	#Actions before share delete
	DeleteIndexSharePath
	;;
	--post)
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
