#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareSet()
#   Usable environment variable:
#       ORIGIN_SHARE_NAME, SHARE_NAME, ORIGIN_SHARE_PATH, SHARE_PATH,
#       STATUS, RESULT
#
#   Note: The script should bear to be invoked multiple times
###############################################################

PHPPath=/var/packages/VideoStation/target/scripts/DoIndex.php
OPEN_BASEDIR=/tmp:/var/packages/VideoStation/etc
MOVE_CONF=/var/packages/VideoStation/etc/move_volume.conf
MOVE_CONF_TMP=/var/packages/VideoStation/etc/move_volume.conf.tmp

CheckShareNameChange() {
	# Only hooked when share name are changed
	if [ "" != "${ORIGIN_SHARE_NAME}" ] &&
	   [ "${ORIGIN_SHARE_NAME}" != "${SHARE_NAME}" ]; then
		IS_RENAME=1
	fi
	if [ "" != "${ORIGIN_SHARE_NAME}" ] &&
	   [ "${ORIGIN_SHARE_NAME}" == "${SHARE_NAME}" ] &&
           [ "${ORIGIN_SHARE_PATH}" != "${SHARE_PATH}" ]; then
		IS_MOVE=1
	fi
}

CreateMoveVolumeConf() {
	input="{ \"from\":\"${ORIGIN_SHARE_PATH}/\", \"to\":\"${SHARE_PATH}/\" }"
	if [ -f "$MOVE_CONF" ]; then
		jq ". += [${input}]"  ${MOVE_CONF} > ${MOVE_CONF_TMP} && mv ${MOVE_CONF_TMP} ${MOVE_CONF}
		logger -p user.err -t "VideoStation" "Add record to move.conf"
	else
		echo ${input} | jq '[.]' > ${MOVE_CONF}
		logger -p user.err -t "VideoStation" "Create move.conf"
	fi
	chown VideoStation:VideoStation ${MOVE_CONF}
}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "2.0"
	;;
	--name)
	#Print package name
	echo "VideoStation"
	;;
	--pkg-ver)
	#Print package version
	echo "1.0"
	;;
	--vendor)
	#Print package vendor
	echo "Synology Inc."
	;;
	--pre)
	#Actions before share set
	;;
	--post)
	#Actions after share set
	IS_RENAME=0
	IS_MOVE=0

	if [ "0" != "${RESULT}" ]; then
		return
	fi

	#Check hook condition
	CheckShareNameChange

	if [ "1" = "${IS_RENAME}" ]; then
		php -d open_basedir="/var/packages/VideoStation/etc:/var/run" /var/packages/VideoStation/target/scripts/DoIndex.php -a r -s "$ORIGIN_SHARE_NAME" -o "$ORIGIN_SHARE_PATH" -n "$SHARE_NAME" -p "$SHARE_PATH" &
	elif [ "1" = "${IS_MOVE}" ]; then
		synoservicecfg --is-enabled pkgctl-VideoStation
		package_status=$?
		if [ $package_status = "0" ]; then
			CreateMoveVolumeConf
		fi
		php -d open_basedir="/var/packages/VideoStation/etc:/var/run" /var/packages/VideoStation/target/scripts/DoIndex.php -a m -s "$ORIGIN_SHARE_NAME" -o "$ORIGIN_SHARE_PATH" -n "$SHARE_NAME" -p "$SHARE_PATH" &
	fi
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

