BEGIN;

CREATE TABLE vsuser (
	uid bigint NOT NULL,
	default_library_visibility int NOT NULL DEFAULT 15,

	CONSTRAINT vsuser_pkey PRIMARY KEY (uid)
)
WITHOUT OIDS;

CREATE TABLE user_hide_library (
	uid bigint NOT NULL,
	library_id int NOT NULL,

	CONSTRAINT user_hide_library_uid_fkey FOREIGN KEY (uid)
		REFERENCES vsuser (uid) MATCH FULL
		ON UPDATE CASCADE ON DELETE CASCADE,
	CONSTRAINT user_hide_library_library_id_fkey FOREIGN KEY (library_id)
		REFERENCES library (id) MATCH FULL
		ON UPDATE CASCADE ON DELETE CASCADE
)
WITHOUT OIDS;

CREATE INDEX user_hide_library_uid_idx ON user_hide_library USING btree (uid);
CREATE INDEX user_hide_library_library_id_idx ON user_hide_library USING btree (library_id);

CREATE VIEW library_view AS
	SELECT id, title, CAST(type AS VARCHAR(32)) AS type, is_public FROM library;

UPDATE config SET value='4' WHERE key='version';

COMMIT;
