BEGIN;

ALTER TABLE vsuser ADD COLUMN parental_enabled boolean NOT NULL DEFAULT false;
ALTER TABLE vsuser ADD COLUMN parental_pin varchar(64) NOT NULL DEFAULT '';
ALTER TABLE vsuser ADD COLUMN setting text NOT NULL DEFAULT '' ;

CREATE TABLE parental_control_setting(
	uid bigint NOT NULL,
	video_type integer NOT NULL,
	certificate varchar(255) NOT NULL,
	CONSTRAINT parental_control_setting_uid_fkey FOREIGN KEY (uid)
	    REFERENCES vsuser(uid) MATCH SIMPLE
		ON UPDATE RESTRICT ON DELETE CASCADE
)
WITHOUT OIDS;

CREATE INDEX parental_setting_movie_idx ON parental_control_setting(certificate) WHERE (video_type = 1);
CREATE INDEX parental_setting_tvshow_episode_idx ON parental_control_setting(certificate) WHERE (video_type = 2);
CREATE INDEX parental_setting_home_video_idx ON parental_control_setting(certificate) WHERE (video_type = 3);

CREATE VIEW parental_movie_view AS SELECT parental_control_setting.*, movie.id, movie.mapper_id FROM parental_control_setting JOIN movie ON parental_control_setting.certificate = movie.certificate WHERE video_type = 1;
CREATE VIEW parental_tvshow_episode_view AS SELECT parental_control_setting.*, tvshow_episode.id, tvshow_episode.mapper_id FROM parental_control_setting JOIN tvshow_episode ON parental_control_setting.certificate = tvshow_episode.certificate WHERE video_type = 2;
CREATE VIEW parental_home_video_view AS SELECT parental_control_setting.*, home_video.id, home_video.mapper_id FROM parental_control_setting JOIN home_video ON parental_control_setting.certificate = home_video.certificate WHERE video_type = 3;
CREATE VIEW parental_tv_record_view AS SELECT parental_control_setting.*, tv_record.id, tv_record.mapper_id FROM parental_control_setting JOIN (SELECT id, mapper_id, '!@#$SYNO_CERTIFICATE$#@!'::varchar AS certificate FROM tv_record) AS tv_record ON parental_control_setting.certificate = tv_record.certificate WHERE video_type = 4;


CREATE TABLE preprocess_video_queue (
	video_file_id int NOT NULL,
	status int NOT NULL,
	CONSTRAINT preprocess_video_queue_pkey PRIMARY KEY (video_file_id),
	CONSTRAINT preprocess_video_queue_video_file_id_fkey FOREIGN KEY (video_file_id)
		REFERENCES video_file (id) MATCH FULL
		ON UPDATE CASCADE ON DELETE CASCADE
)
WITHOUT OIDS;

CREATE INDEX preprocess_video_queue_status_idx ON preprocess_video_queue(status);

ALTER TABLE watch_status ADD COLUMN subtitle_id varchar(4096) DEFAULT '' NOT NULL;
ALTER TABLE watch_status ADD COLUMN audio_track integer DEFAULT -1 NOT NULL;

UPDATE config SET value = '6' WHERE key = 'version';

COMMIT;
