#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

PSQL="/usr/bin/psql"

ExecSqlCommand()
{
	${PSQL} -U VideoStation video_metadata -c "$1" > /dev/null 2>&1
}

DATABASE="video_metadata"
TABLE="movie"
COLUMN="certificate"

echo "test $TABLE table has colum in $DATABASE DB"
ExecSqlCommand "SELECT $COLUMN FROM $TABLE LIMIT 1"
Ret=$?
if [ $Ret = 1 ]; then
	echo "Add $COLUMN column in $DATABASE DB"
	Script="/var/packages/VideoStation/target/scripts/sql/upgrade/007_add_certificate_column.pgsql"
	${PSQL} -U VideoStation ${DATABASE} < ${Script}
	if [ $? != 0 ]; then
		echo "Failed to add $COLUMN column in $DATABASE DB"
		exit
	fi
fi
