BEGIN;

CREATE OR REPLACE FUNCTION lo_unlink_non_raise(oid OID) RETURNS VOID AS
$$
BEGIN
	PERFORM lo_unlink(oid) WHERE oid != 0;
EXCEPTION
	WHEN others THEN
		-- Do nothing
END;
$$
LANGUAGE plpgsql;

CREATE OR REPLACE RULE backdrop_propagate_on_deletes_to_lob AS
	ON DELETE TO backdrop
	DO ALSO (SELECT lo_unlink_non_raise(old.lo_oid));

CREATE OR REPLACE RULE backdrop_propagate_on_update_to_lob AS
	ON UPDATE TO backdrop
	DO ALSO (SELECT lo_unlink_non_raise(old.lo_oid));

CREATE OR REPLACE RULE propagate_deletes_to_lob AS
	ON DELETE TO poster
	DO ALSO (SELECT lo_unlink_non_raise(old.lo_oid));

CREATE OR REPLACE RULE propagate_update_to_lob AS
	ON UPDATE TO poster
	DO ALSO (SELECT lo_unlink_non_raise(old.lo_oid));

COMMIT;
