#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

PSQL="/usr/bin/psql"

ExecSqlCommand()
{
	${PSQL} -U VideoStation video_metadata -X -c "$1" > /dev/null 2>&1
}

DATABASE="video_metadata"

echo "test if function lo_unlink_non_raise is defined"
ExecSqlCommand "SELECT 'lo_unlink_non_raise'::regproc"
Ret=$?
if [ $Ret = 1 ]; then
	echo "Replace rule XX_propagate_on_deletes_to_log and XX_propagate_on_update_to_log in backdrop and poster"
	Script="/var/packages/VideoStation/target/scripts/sql/upgrade/008_ignore_raise_when_lo_unlink.pgsql"
	${PSQL} -U VideoStation ${DATABASE} < ${Script}
	if [ $? != 0 ]; then
		echo "Failed to add $COLUMN column in $DATABASE DB"
		exit
	fi
fi
