import time, os, json, re, subprocess, syslog

LOGDEBUG = 'LOGDEBUG'
ISO_639_2 = 'ISO_639_2'
VIDEO_INFO = json.loads(os.environ['VIDEO_INFO']) if 'VIDEO_INFO' in os.environ else {}

def sleep(microseconds):
    time.sleep(microseconds/1000)

def translatePath(path):
    return '%s'%path.encode('utf-8')

def log(msg, level):
    # print msg
    pass

def getInfoLabel(key):
    if key == 'VideoPlayer.Year':
        return VIDEO_INFO['year'] if 'year' in VIDEO_INFO else ''
    if key == 'VideoPlayer.Season':
        return VIDEO_INFO['season'] if 'season' in VIDEO_INFO else ''
    if key == 'VideoPlayer.Episode':
        return VIDEO_INFO['episode'] if 'episode' in VIDEO_INFO else ''

    tmp = ''
    if key == 'VideoPlayer.TVshowtitle' and 'tvshow_title' in VIDEO_INFO:
        tmp = VIDEO_INFO['tvshow_title']
    if key == 'VideoPlayer.OriginalTitle' and 'original_title' in VIDEO_INFO:
        tmp = VIDEO_INFO['original_title']
    if key == 'VideoPlayer.Title' and 'title' in VIDEO_INFO:
        tmp = VIDEO_INFO['title']
    return '%s'%tmp.encode('utf-8')

def convertLanguage(lang, code):
    if 'English' in lang:
        return 'eng'
    if 'Chinese' in lang:
        if 'Traditional' in lang:
            return 'zho'
        else:
            return 'chi'
    return lang

def try_encoding_to_unicode(string):
    encodings = ['utf-8', 'gbk', 'big5']

    if isinstance(string, unicode):
        return string

    for enc in encodings:
        unicode_str = string.decode(enc, 'replace')
        enc_str = unicode_str.encode(enc, 'replace')
        if string == enc_str:
            return unicode_str

    # shall not go to here
    return None

def executebuiltin(cmd, unknow=True):
    if "XBMC.Extract" in cmd:
        matches = re.search('XBMC\.Extract\(\"(?P<zip_file>.+)\",\"(?P<destination>.+)\"\)', cmd, re.DOTALL)
        zip_file = matches.group('zip_file')
        destination = matches.group('destination')
        try:
            import zipfile
            import shutil
            z = zipfile.ZipFile(zip_file, "r")
            for fileinfo in z.infolist():
                if fileinfo.file_size == 0:
                    # skip dir entry
                    continue
                src = fileinfo.filename
                dst = try_encoding_to_unicode(os.path.basename(src))
                if not dst:
                    syslog.syslog(syslog.LOG_ERR, "Failed to convert encoding of [%s]", src)
                    continue
                output = open(os.path.join(destination, dst).encode('utf-8'), 'wb')
                shutil.copyfileobj(z.open(src), output)
        except Exception as detail:
            subprocess.check_output(["unrar", "e", zip_file, destination])
    else:
        print 'EXECUTEBUILTIN: %s'%cmd

def getCleanMovieTitle(title):
    return [title, '']

class VideoInfo(object):
    def __init__(self):
        pass
    def getIMDBNumber(self):
        return ''

class Player(object):
    def __init__(self):
        self.video_info = VideoInfo()
    def getPlayingFile(self):
        return VIDEO_INFO['file'] if 'file' in VIDEO_INFO else ''
    def getVideoInfoTag(self):
        return self.video_info
