import inspect
import xml.etree.cElementTree as ET
import os, xbmcvfs, shutil, uuid
TEMP_PATH = os.environ['TEMP_PATH'] if 'TEMP_PATH' in os.environ else ''

class Addon():
    def __init__(self):
        addon_found = False
        frm = inspect.stack()[1]
        mod = inspect.getmodule(frm[0])
        src = os.path.abspath(mod.__file__)
        while(src != '/' and src != '' and not addon_found):
            src = os.path.dirname(src)
            xml = "%s/addon.xml"%src
            if os.path.exists(xml):
                addon_found = True

        tree = ET.ElementTree(file=xml)
        self.path = src
        self.info = tree.getroot()
        pass

    def getAddonInfo(self, key):
        if key == 'path':
            return self.path

        root = self.info
        root_attrib = root.attrib
        if key == 'profile' and 'id' in root_attrib:
            if len(TEMP_PATH) > 0:
                return TEMP_PATH
            return '/tmp/VideoStation/addon/%s/%s'%(root_attrib['id'], uuid.uuid4())
        if key == 'author' and 'author' in root_attrib:
            return root_attrib['author']
        if key == 'id' and 'id' in root_attrib:
            return root_attrib['id']
        if key == 'name' and 'name' in root_attrib:
            return root_attrib['name']
        if key == 'version' and 'version' in root_attrib:
            return root_attrib['version']
        return ''

    def getLocalizedString(self, code):
        return code

    def getSetting(self, key):
        return ''
