import os, shutil, pwd, grp

def listdir(path):
    return [
        [d for d in os.listdir(path) if os.path.isdir(os.path.join(path, d))],
        [f for f in os.listdir(path) if os.path.isfile(os.path.join(path, f))]
    ]

def exists(path):
    return os.path.isdir(path) or os.path.isfile(path)

def mkdirs(path):
    if not os.path.isdir(path):
        os.makedirs(path)

    uid = pwd.getpwnam("VideoStation").pw_uid
    gid = grp.getgrnam("VideoStation").gr_gid
    os.chown('/tmp/VideoStation', uid, gid)
    pass

def rmdir(path):
    shutil.rmtree(path)

def delete(path):
    os.remove(path)

def rename(src, dst):
    os.rename(src, dst)

class File():
    def __init__(self, path, mode='rb'):
        self.file = open(path, mode)

    def read(self, size):
        return self.file.read(size)

    def write(self, content):
        return self.file.write(content)

    def seek(self, offset, length):
        return self.file.seek(offset, length)

    def size(self):
        return os.fstat(self.file.fileno()).st_size

    def close(self):
        return self.file.close()
        pass
