/* Copyright (c) 2019 Synology Inc. All rights reserved. */

function _VST(t,e){var i="";try{i=_TT("SYNO.SDS.VideoStation.AppInstance",t,e)}catch(o){i=_T(t,e)}finally{return i||String.format("{0}:{1}",t,e)}}Ext.define("SYNO.SDS.VideoStation2.Capability",{extend:"Ext.util.Observable",statics:{EVENT_CAPABILITY_READY:"capabilityready",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Capability.instance)||(SYNO.SDS.VideoStation2.Capability.instance=new SYNO.SDS.VideoStation2.Capability),SYNO.SDS.VideoStation2.Capability.instance}},constructor:function(){this.callParent(arguments)},loadCapability:function(t){var e=t||{},i=e.privilege||{},o=e.transcoding_capability||{};this.remux=!0===o.remux,this.transcode=!0===o.transcode,this.software_transcode=!0===o.software_transcode,this.hardware_transcode=!0===o.hardware_transcode,this.dtv_transcode=!0===o.dtv_transcode,this.dtv=!0===i.dtv,this.renderer=!0===i.renderer,this.sharing=!0===i.sharing,this.offline_conversion=!0===i.offline_conversion,this.fireEvent(SYNO.SDS.VideoStation2.Capability.EVENT_CAPABILITY_READY)},ableToRemux:function(){return this.remux},ableToTranscode:function(){return this.transcode},ableToSoftwareTranscode:function(){return this.software_transcode},ableToHardwareTranscode:function(){return this.hardware_transcode},ableToControlDTV:function(){return this.dtv},ableToPlayDTV:function(){return this.dtv_transcode||SYNO.VideoController2.Util.isVLCSupported()},ableToControlRenderer:function(){return this.renderer},ableToControlSharing:function(){return this.sharing},ableToControlOfflineConversion:function(){return this.offline_conversion},remux:!1,transcode:!1,software_transcode:!1,hardware_transcode:!1,dtv:!1,renderer:!1,sharing:!1}),Ext.define("SYNO.SDS.VideoStation2.Button",{extend:"SYNO.ux.Button",xtype:"syno_vs_button",constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-button")}}),Ext.define("SYNO.SDS.VideoStation2.MessageBox",{extend:"SYNO.SDS.MessageBoxV5",constructor:function(){this.callParent(arguments),this.addClass("syno-vs2-msgbox")},onRender:function(){this.callParent(arguments),this.progressBar.addClass("syno-vs2-progress")},getButtons:function(){var t=this.callParent(arguments);return t.each(function(t){t.addClass("syno-vs2-button")}),t}}),Ext.define("SYNO.SDS.VideoStation2.Dialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(t){t=t||{},t.owner=t.owner||SYNO.SDS.VideoStation2.Window;var e=Ext.isString(t.cls)?t.cls+" syno-vs2-dialog":"syno-vs2-dialog";t.cls=e,this.callParent([t])},getMsgBox:function(t){if(!this.msgBox||this.msgBox.isDestroyed){var e=t&&t.owner||this;e=e.isDestroyed?null:e,this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:e})}return this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Error",{singleton:!0,VIDEO_STATION_ERROR:{400:_VST("error","download_failed"),417:_VST("error","image_format"),418:String.format(_VST("error","image_too_big"),4),431:_VST("playlist","error_name_duplicated"),800:_VST("error","download_failed"),801:_VST("error","image_format"),803:String.format(_VST("error","image_too_big"),4),804:String.format(_VST("error","image_too_big"),10),903:_VST("playlist","error_name_duplicated"),1152:_VST("controller","download_subtitle_fail_retry_later"),1153:_VST("error","unsupported_subtitle_format"),1500:_VST("error","dtv_request_dongle"),1502:_VST("error","error_someone_scaning"),1503:_VST("action","scan_fail"),1505:_VST("error","error_someone_scaning"),1506:_VST("error","dtv_channeltable_not_found"),1510:_VST("error","record_program_not_exist"),1511:_VST("error","update_recording"),1512:_VST("error","update_streaming"),1513:_VST("error","dtv_device_busy"),1517:_T("error","error_file_exist"),1520:_VST("error","dtv_folder_not_found"),1521:_VST("error","recorde_duplicate"),1522:_VST("error","no_data"),1526:_VST("action","dvbs_scan_fail")},DTV_CHANNEL_FILE_NOT_FOUND:1506,DTV_INDEX_FOLDER_NOT_FOUND:1520,getAPIErrorString:function(t){var e=100;if(Ext.isNumber(t))e=t;else if(Ext.isObject(t)){var i=SYNO.API.Util.GetFirstError(t)||t;e=Ext.isNumber(i.code)?i.code:100}return e<400?SYNO.API.Errors.common[e]||_T("error","error_error_system"):SYNO.SDS.VideoStation2.Error.VIDEO_STATION_ERROR[e]||_T("error","error_error_system")},getErrorInfoString:function(t,e){if(!Ext.isObject(t))return e;if(!0===t.success)return"";var i,o=t.errinfo||{};return i=o.sec&&o.key?_VST(o.sec,o.key):_T("error","error_error_system"),Ext.isNumber(o.line)&&(i=String.format("{0} ({1})",i,o.line)),i}}),Ext.define("SYNO.SDS.VideoStation2.Filter",{statics:{EVENT_FILTER_CHANGE:"filterchange",FILTER_ACTOR:"actor",FILTER_DIRECTOR:"director",FILTER_GENRE:"genre",FILTER_WRITER:"writer",FILTER_CERTIFICATE:"certificate",FILTER_RATING:"rating",FILTER_YEAR:"year",FILTER_RESOLUTION:"resolution",FILTER_WATCHED_STATUS:"watchedstatus",FILTER_FILE_COUNT:"filecount",FILTER_CONTAINER:"container",FILTER_DURATION:"duration",FILTER_DATE:"date",FILTER_CHANNEL_NAME:"channel_name",FILTER_TITLE:"title",FILTER_KEYWORD:"keyword",DATA_RATING:[{key:_VST("filter","star_0"),value:{from:-1,to:14}},{key:_VST("filter","star_1"),value:{from:15,to:34}},{key:_VST("filter","star_2"),value:{from:35,to:54}},{key:_VST("filter","star_3"),value:{from:55,to:74}},{key:_VST("filter","star_4"),value:{from:75,to:94}},{key:_VST("filter","star_5"),value:{from:95,to:100}}],DATA_RESOLUTION:[{key:_VST("filter","resolution_sd"),value:{x_from:-1,x_to:1024,y_from:-1,y_to:576}},{key:"720p",value:{x_from:1024,x_to:1280,y_from:576,y_to:720}},{key:"1080p",value:{x_from:1280,x_to:1920,y_from:720,y_to:1080}},{key:String.format(_VST("filter","andabove"),"4K"),value:{x_from:1920,x_to:-1,y_from:1080,y_to:-1}}],DATA_WATCHED_STATUS:[{key:_VST("advanced","unwatched"),value:"unwatched"},{key:_VST("advanced","watching"),value:"watching"},{key:_VST("advanced","watched"),value:"watched"}],DATA_FILE_COUNT:[{key:_VST("filter","singlefile"),value:"single"},{key:_VST("filter","multiplefile"),value:"multiple"}],DATA_DURATION:[{key:String.format(_VST("filter","andbelow"),"10 "+_VST("common","minutes")),value:{from:0,to:10}},{key:String.format("{0} ~ {1} {2}","10","30",_VST("common","minutes")),value:{from:10,to:30}},{key:String.format("{0} ~ {1} {2}","30","60",_VST("common","minutes")),value:{from:30,to:60}},{key:String.format("{0} ~ {1} {2}","60","120",_VST("common","minutes")),value:{from:60,to:120}},{key:String.format(_VST("filter","andabove"),"120 "+_VST("common","minutes")),value:{from:120,to:-1}}],instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Filter.instance)||(SYNO.SDS.VideoStation2.Filter.instance=new SYNO.SDS.VideoStation2.Filter),SYNO.SDS.VideoStation2.Filter.instance},getLocalFilterData:function(t){switch(t){case SYNO.SDS.VideoStation2.Filter.FILTER_RATING:return SYNO.SDS.VideoStation2.Filter.DATA_RATING;case SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION:return SYNO.SDS.VideoStation2.Filter.DATA_RESOLUTION;case SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS:return SYNO.SDS.VideoStation2.Filter.DATA_WATCHED_STATUS;case SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT:return SYNO.SDS.VideoStation2.Filter.DATA_FILE_COUNT;case SYNO.SDS.VideoStation2.Filter.FILTER_DURATION:return SYNO.SDS.VideoStation2.Filter.DATA_DURATION;default:throw String.format("no such local filter {0}",t)}}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.addEvents(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE),this.current_filter={},this.current_keyword=""},addFilter:function(t,e){this.hasFilter(t,e)||(this.current_filter[t]=this.current_filter[t]||[],this.current_filter[t].push(e),this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,t))},deleteFilter:function(t,e){this.hasFilter(t,e)&&(this.current_filter[t]=this.current_filter[t].filter(function(t){return t.key!==e.key}),0===this.current_filter[t].length&&delete this.current_filter[t],this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,t))},toggleFilter:function(t,e){this.hasFilter(t,e)?this.deleteFilter(t,e):this.addFilter(t,e)},hasFilter:function(t,e){if(!this.current_filter[t])return!1;var i=!1;return Ext.each(this.current_filter[t],function(t){if(t.key===e.key)return i=!0,!1}),i},setKeyword:function(t){this.current_keyword!==t&&(this.current_keyword=t,this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD))},hasKeyword:function(){return!Ext.isEmpty(this.current_keyword)},clearFilter:function(t){if(t===SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)return void(this.hasKeyword()&&(this.current_keyword="",this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)));this.current_filter[t]&&(delete this.current_filter[t],this.fireEvent(SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,t))},clearAllFilter:function(){Object.keys(this.current_filter).each(function(t){this.clearFilter(t)},this),this.clearFilter(SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)},isFilterEmpty:function(){return 0===Object.keys(this.current_filter).length},getFilter:function(t){return this.current_filter[t]},getFilterOption:function(){var t={};return Ext.iterate(this.current_filter,function(e,i){t[e]=i.map(function(t){return t.value})}),t},getKeywordOption:function(){var t={};return this.hasKeyword()&&(t[SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD]=this.getKeyword()),t},getKeyword:function(){return this.current_keyword},current_filter:null,current_keyword:null}),Ext.define("SYNO.SDS.VideoStation2.Constant",{singleton:!0,CLASS:{UNWATCHED:"unwatched",LASTWATCHED:"lastwatched"},EVENT:{PLAYLIST_CHANGE:"playlistchange",SHARING_STATUS_LOAD:"sharingstatusload",VIDEO_LOAD:"videoload",VIEW_LOADING:"viewloading",VIEW_LOADED:"viewloaded",VIEW_NOVIDEO:"viewnovideo",VIEW_NOTUNER:"viewnotuner",VIEW_CHANNEL_SCAN:"viewchannelscan",LOAD_PLAYER_OPTION:"loadplayeroption",VIDEO_INFO_UPDATE:"videoinfoupdate"},EXTRA:{KEY_RATING:"rating",KEY_REFERENCE:"reference",KEY_TMDB:"themoviedb",KEY_IMDB:"imdb",KEY_ATMOVIE:"atmovie"},PLAYLIST_TYPE:{ORIGINAL:"original",SMART:"smart"},REFRESH_INFO:{VIDEO:"video",SUBTITLE:"subtitle",NEXT_PREV_BTN:"next_prev_btn"},PLAYER_STREAMING:"streaming",TITLE_FAVORITE:"syno_favorite",TITLE_WATCHLIST:"syno_watchlist",COLLECTION:"collection",PLAYLIST:"playlist",PLAYLIST_VIDEOLIST:"playlistvideolist",MOVIE:"movie",TVSHOW:"tvshow",TVSHOW_EPISODE:"tvshow_episode",HOME_VIDEO:"home_video",TV_RECORDING:"tv_record",GETINFO_ADDITIONAL:["summary","file","actor","writer","director","extra","genre","collection","poster_mtime","watched_ratio","backdrop_mtime"],ADDITIONAL_DICT:{movie:["summary","poster_mtime","backdrop_mtime","file","collection","watched_ratio","conversion_produced","actor","director","genre","writer","extra"],home_video:["summary","poster_mtime","backdrop_mtime","file","collection","watched_ratio","conversion_produced","actor","director","genre","writer","extra"],tvshow:["summary","poster_mtime","backdrop_mtime"],tvshow_episode:["summary","poster_mtime","backdrop_mtime","file","collection","watched_ratio","conversion_produced","actor","director","genre","writer","extra","tvshow_summary"],tv_record:["summary","poster_mtime","backdrop_mtime","file","collection","watched_ratio","conversion_produced"]},CHANNEL:"channel",PROGRAM:"program",FOLDER:"folder",SQUARE:"square",FILE:"file",LIBRARY:"library",CATEGORY:"category",DTV:"dtv",FILTER:"filter",SEASON:"season",VIDEO:"video",PAGE:"page",RECORDING_SPECIFIC:"recording_specific",VIDEO_PROFILE_ORIGINAL:"original",VIDEO_PROFILE_HIGH:"high",VIDEO_PROFILE_MEDIUM:"medium",VIDEO_PROFILE_LOW:"low",RESOLUTION_DEFINITION:{SD:{x_from:-1,x_to:640,y_from:-1,y_to:480},"480p":{x_from:640,x_to:1024,y_from:480,y_to:576},"720p":{x_from:1024,x_to:1280,y_from:576,y_to:720},"1080p":{x_from:1280,x_to:1920,y_from:720,y_to:1080},"4K":{x_from:1920,x_to:-1,y_from:1080,y_to:-1}},PROGRAM_STATUS:{STATUS_NONE:"none",STATUS_PASS:"pass",STATUS_STREAMING:"streaming",STATUS_RECORDING:"recording",STATUS_SCHEDULED:"scheduled",STATUS_REPEAT_SCHEDULED:"repeatscheduled"},SCHEDULE_STATUS:{STATUS_ERROR:"error",STATUS_WAIT:"wait",STATUS_STREAMING:"streaming",STATUS_RECORDING:"recording",STATUS_DONGLE_NOT_FOUND:"nodonglenotfound",STATUS_RECORDING_INTERRUPT:"recordinginterrupt",STATUS_DONE:"done",STATUS_NO_PERMISSION:"nopermission",STATUS_USER_INVALID:"userinvalid",STATUS_NO_QUOTA:"noquota",STATUS_VOLUME_FULL:"volumefull",STATUS_CREATE_FILE_ERROR:"createfileerror",STATUS_WEEKLY_SCHEDULE:"weeklyschedule",STATUS_DAILY_SCHEDULE:"dailyschedule",STATUS_VLC_INTERRUPT:"vlcinterrupt",STATUS_SKIP:"skip"},RECORDING_ACTION_KEY:{RECORDING_CREATE:"record",RECORDING_CANCEL:"cancel_recording",RECORDING_CREATE_REPEAT:"repeat_record",RECORDING_CREATE_USERDEFINE:"user_define_schedule"},TUNER_TYPE:{TYPE_QPSK:0,TYPE_QAM:1,TYPE_OFDM:2,TYPE_ATSC:3,TYPE_HDHOMERUN:99},STORE_UNLIMIT:5e5,MAX_NUMBER_OF_RECOMMENDATION:{movie:50,tvshow_episode:5e5,home_video:10,tv_record:10},MAX_LENGTH:{PLAYLIST_NAME:255,DVB_LNB_NAME:32,DVB_SATELLITE_NAME:32,DVB_CHANNEL_NAME:110,DVB_PROGRAM_NAME:110,VIDEO_METADATA_CERTIFICATE:255,VIDEO_METADATA_COMMON_FIELD:255,VIDEO_METADATA_SUMMARY:4096,VIDEO_METADATA_TAGLINE:255,VIDEO_METADATA_TITLE:255}}),Ext.define("SYNO.SDS.VideoStation2.Util",{singleton:!0,applyCallback:function(t){Ext.isObject(t)&&Ext.isFunction(t.fn)&&t.fn.apply(t.scope||window,t.args||[])},convertCollectionID:function(t){return Ext.isArray(t)?t.map(function(t){var e=parseInt(t.id,10),i=t.title;return SYNO.SDS.VideoStation2.Constant.TITLE_FAVORITE===i?e=-1:SYNO.SDS.VideoStation2.Constant.TITLE_WATCHLIST===i&&(e=-2),{id:e,title:t.title}}):t},getVideoActionString:function(t){var e=["view_video_info","edit_metadata","correct_metadata","set_watched","set_unwatched","del_file","del_video"],i=["search_subtitle"],o=["public_sharing"],n=["offline_conversion"];return-1!==e.indexOf(t)?_VST("action",t):-1!==i.indexOf(t)?_VST("controller",t):-1!==o.indexOf(t)?_VST("advanced",t):-1!==n.indexOf(t)?_VST(t,"action"):void 0},getFilterCategoryString:function(t){switch(t){case SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR:return _VST("actor","title");case SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR:return _VST("director","title");case SYNO.SDS.VideoStation2.Filter.FILTER_GENRE:return _VST("genre","title");case SYNO.SDS.VideoStation2.Filter.FILTER_WRITER:return _VST("writer","title");case SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE:return _VST("metadata","rating_classification");case SYNO.SDS.VideoStation2.Filter.FILTER_RATING:return _VST("metadata","rating");case SYNO.SDS.VideoStation2.Filter.FILTER_YEAR:return _VST("year","title");case SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION:return _VST("video_info","resolution");case SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS:return _VST("common","watch_status");case SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT:return _VST("filter","file_count");case SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER:return _VST("video_info","container");case SYNO.SDS.VideoStation2.Filter.FILTER_DURATION:return _VST("duration","title");case SYNO.SDS.VideoStation2.Filter.FILTER_DATE:return _VST("classification","bydate");case SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME:return _VST("classification","bychannel");case SYNO.SDS.VideoStation2.Filter.FILTER_TITLE:return _VST("classification","byprogram");case SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD:return _VST("search","keyword");default:return""}},getRecordingActionString:function(t){return t===SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CREATE_USERDEFINE?_VST("schedule",t):_VST("action",t)},getAPIName:function(t){switch(t){case SYNO.SDS.VideoStation2.Constant.MOVIE:return"SYNO.VideoStation2.Movie";case SYNO.SDS.VideoStation2.Constant.TVSHOW:return"SYNO.VideoStation2.TVShow";case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:return"SYNO.VideoStation2.TVShowEpisode";case SYNO.SDS.VideoStation2.Constant.HOME_VIDEO:return"SYNO.VideoStation2.HomeVideo";case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:return"SYNO.VideoStation2.TVRecording";default:throw String.format("unexpected type {0}",t)}},getVideoRoot:function(t){switch(t){case SYNO.SDS.VideoStation2.Constant.MOVIE:return"movie";case SYNO.SDS.VideoStation2.Constant.TVSHOW:return"tvshow";case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:return"episode";case SYNO.SDS.VideoStation2.Constant.HOME_VIDEO:return"video";case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:return"recording";default:throw String.format("unexpected type {0}",t)}},getWebAPIURL:function(t){return String.format("{0}/{1}","webapi/VideoStation",t)},getCGIURL:function(t){return String.format("webman/3rdparty/VideoStation/cgi/{0}",t)},getImageURL:function(t){return t=Ext.apply(t||{},{api:"SYNO.VideoStation2.Poster",method:"get",version:"1"}),SYNO.SDS.UIFeatures.test("isRetina")&&Ext.apply(t,{resolution:Ext.encode("2x")}),Ext.urlAppend("webapi/entry.cgi",Ext.urlEncode(t))},getImageURLByRecord:function(t,e){return SYNO.SDS.VideoStation2.Util.getImageURL({type:Ext.isString(e)?e:t.type,id:t.id,mtime:t.additional?t.additional.poster_mtime||"":""})},getBackdropURL:function(t){return t=Ext.apply(t||{},{api:"SYNO.VideoStation2.Backdrop",method:"get",version:"1"}),Ext.urlAppend("webapi/entry.cgi",Ext.urlEncode(t))},getVideoDate:function(t){var e="";return Ext.isString(t.original_available)&&!Ext.isEmpty(t.original_available)?e="0"===t.original_available?"":t.original_available.split("-")[0]:Ext.isString(t.record_date)&&!Ext.isEmpty(t.record_date)&&(e="0"===t.record_date?"":t.record_date.split(" ")[0]),""!==e&&SYNO.SDS.DateTimeFormatter&&(e=SYNO.SDS.DateTimeFormatter(Date.parseDate(e,"Y-m-d"),{type:"date"})),e},getYMDFormatedDate:function(t){return SYNO.SDS.DateTimeUtils&&""!==t?Date.parseDate(t,SYNO.SDS.DateTimeUtils.GetDateFormat()).format("Y-m-d"):t},hideDTVUI:function(){return SYNO.SDS.isNSM||"yes"===_D("support_dual_head")||SYNO.SDS.Utils.isInVirtualDSM()||"yes"===_D("dockerdsm")},isWatched:function(t){return Ext.isNumber(t)&&1===t},isUnwatched:function(t){return Ext.isNumber(t)&&0===Math.floor(100*t)},classifyVideos:function(t){var e={};return t.each(function(t){e[t.type]=e[t.type]||[],e[t.type].push(t)}),e},formatBitrate:function(t){var e=parseInt(t,10),i=(e/1024).toFixed(1);return String.format("{0} Kbps",i)},extractFileName:function(t){return t.substring(t.lastIndexOf("/")+1)},getShareData:function(t){var e=t,i=e.indexOf("/",1),o="";return e=e.substr(1),i>0&&(o=e.substr(i),e=e.substr(0,i-1)),{share:Ext.util.Format.lowercase(e),orishare:e,subpath:o}},getLangStore:function(){var t=SYNO.SDS.Utils.getSupportedLanguage();return new Ext.data.SimpleStore({fields:["value","display"],data:t,autoDestroy:!0})},onProxyBeforeLoad:function(t,e){var i=t.activeRequest.read;i&&Ext.Ajax.abort(i)},getCombinationPosterDiv:function(t,e){return Ext.isArray(t)&&Ext.isFunction(e)?1===t.length?String.format('<div class="center loading" url="{0}"></div>',e(t[0])):2===t.length?[String.format('<div class="top loading" url="{0}"></div>',e(t[0])),String.format('<div class="bottom loading" url="{0}"></div>',e(t[1]))].join(""):3===t.length?[String.format('<div class="top loading" url="{0}"></div>',e(t[0])),String.format('<div class="bottom-left loading" url="{0}"></div>',e(t[1])),String.format('<div class="bottom-right loading" url="{0}"></div>',e(t[2]))].join(""):4<=t.length?[String.format('<div class="top-left loading" url="{0}"></div>',e(t[0])),String.format('<div class="top-right loading" url="{0}"></div>',e(t[1])),String.format('<div class="bottom-left loading" url="{0}"></div>',e(t[2])),String.format('<div class="bottom-right loading" url="{0}"></div>',e(t[3]))].join(""):"":""},getWatchStatusDiv:function(t){var e=t.additional||{};if(Ext.isDefined(e.total_seasons))return"";var i=e.watched_ratio||0;return i=0===i?0:Math.floor(100*i),100===i?"":['<div class="watch-status-wrap">','<div class="grey-bar"></div>',String.format('<div class="blue-bar" style="width:{0}%"></div>',i),"</div>"].join("")},mask:function(t,e,i,o,n){var a;if(t&&(a=t.getEl())){a.delayedUnmask&&(a.delayedUnmask.cancel(),a.delayedUnmask=null),a.mask.apply(a,Array.prototype.slice.call(arguments,1,3));var S=a.down(".ext-el-mask");if(S.addClass("syno-vs2-el-mask"),Ext.isFunction(o)){var s=a.down(".ext-el-mask-msg div");s.addClass("clickable"),s.on("click",o)}a.delayedMask&&(a.delayedMask.cancel(),a.delayedMask=null),a.delayedMask=new Ext.util.DelayedTask(function(){S&&S.dom&&S.addClass("mask"),a.delayedMask=null}),a.delayedMask.delay(n||1)}},delayMask:function(t,e,i,o){SYNO.SDS.VideoStation2.Util.mask(t,e,i,o,500)},unmask:function(t){var e;if(t&&(e=t.getEl())){e.delayedMask&&(e.delayedMask.cancel(),e.delayedMask=null);var i=e.down(".ext-el-mask");i&&(e.delayedUnmask||(i.addClass("unmask"),e.delayedUnmask=new Ext.util.DelayedTask(function(){e.unmask(),e.delayedUnmask=null})),e.delayedUnmask.delay(300))}},maskLoading:function(t,e){var i=_T("common","loading");SYNO.SDS.VideoStation2.Util.maskLoadingMsg(t,i,e)},maskLoadingMsg:function(t,e,i){SYNO.SDS.VideoStation2.Util[i?"delayMask":"mask"](t,e,"x-mask-loading syno-vs2-mask-loading")},maskInfo:function(t,e,i,o){SYNO.SDS.VideoStation2.Util[o?"delayMask":"mask"](t,e,"syno-ux-mask-info syno-vs2-mask-info",i)},findValueInObject:function(t,e){var i;return Ext.iterate(t,function(t,o){if(t===e)return i=o,!1;if(Ext.isObject(o)){var n=SYNO.SDS.VideoStation2.Util.findValueInObject(o,e);if(Ext.isDefined(n))return i=n,!1}}),i},launchHelp:function(){SYNO.SDS.WindowLaunch("SYNO.SDS.HelpBrowser.Application",{topic:"SYNO.SDS.VideoStation.AppInstance"})},getPathTitleForEpisode:function(t,e){var i=[t>0?String.format(_VST("episode","title"),t):_VST("metadata","unknown")];return Ext.isEmpty(e)||i.push(e),i.join(" - ")},getPathTitleForOfflineEpisode:function(t){var e=[t.title],i="";return 0<t.season&&(i=String.format("S{0}",t.season)),0<t.episode&&(i+=String.format("E{0}",t.episode)),Ext.isEmpty(i)||e.push(i),Ext.isEmpty(t.tagline)||e.push(t.tagline),e.join(" - ")},getLibraryTypeByVideoType:function(t){return t===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE?SYNO.SDS.VideoStation2.Constant.TVSHOW:t},getTVShowEpisodeTitle:function(t){var e=t.episode>0?String.format(_VST("episode","title"),t.episode):_VST("metadata","unknown");return Ext.isString(t.tagline)&&!Ext.isEmpty(t.tagline)?t.tagline:e},getTVShowEpisodeDescription:function(t){return t.episode>0?String.format(_VST("episode","title"),t.episode):""},parseLazyDate:function(t,e,i){e=e||"-",i=i||":";var o=t.split(" "),n=[],a=[];return 1<=o.length&&(n=o[0].split(e)),2<=o.length&&(a=o[1].split(i)),{year:1<=n.length?parseInt(n[0],10):1970,month:2<=n.length?parseInt(n[1],10):1,day:3<=n.length?parseInt(n[2],10):1,hour:1<=a.length?parseInt(a[0],10):0,minute:2<=a.length?parseInt(a[1],10):0,second:3<=a.length?parseInt(a[2],10):0}},lengthValidator:function(t,e){return window.unescape(encodeURIComponent(t)).length<=e}}),Ext.define("SYNO.SDS.VideoStation2.FilteringBaseProxy",{extend:"SYNO.API.Proxy",constructor:function(t){this.callParent([t])},onRequestAPI:function(t,e,i,o,n,a,S,s,r){try{var l=n.getRoot(e);Ext.each(l,function(t){Ext.isObject(t.additional)&&(t.additional.collection&&(t.additional.collection=SYNO.SDS.VideoStation2.Util.convertCollectionID(t.additional.collection)),t.additional.extra&&(t.additional.extra=Ext.decode(t.additional.extra)),t.additional.tvshow_extra&&(t.additional.tvshow_extra=Ext.decode(t.additional.tvshow_extra)))},this),this.callParent(arguments)}catch(t){return this.fireEvent("loadexception",this,s,e,t),void this.fireEvent("exception",this,"response",r,s,e,t)}}}),Ext.define("SYNO.SDS.VideoStation2.ByFolderProxy",{extend:"SYNO.API.Proxy",constructor:function(t){this.callParent([t])},onRequestAPI:function(t,e,i,o,n,a,S,s,r){try{var l=0,d=n.getRoot(e);Ext.each(d,function(t){t.additional&&t.additional.collection&&(t.additional.collection=SYNO.SDS.VideoStation2.Util.convertCollectionID(t.additional.collection)),SYNO.SDS.VideoStation2.Constant.FOLDER===t.type&&(l+=1)},this),0<l&&(d[l-1].last_folder=!0),this.callParent(arguments)}catch(t){return this.fireEvent("loadexception",this,s,e,t),void this.fireEvent("exception",this,"response",r,s,e,t)}}}),Ext.define("SYNO.SDS.VideoStation2.FilterMetadataProxy",{extend:"SYNO.API.Proxy",constructor:function(t){this.callParent([t])},onRequestAPI:function(t,e,i,o,n,a,S,s,r){e.metadata=e.metadata.map(function(t){return{key:t,value:t}}),this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Util.Styles",{singleton:!0,updateMarginBySelector:function(t,e,i,o,n){var a,S,s=SYNO.SDS.VideoStation2.Util.Styles;if(s.styleRules||(s.styleRules={}),S=s.getVideoStyleRule(t)){var r=i-32+n;r=0>=r?i:r,a=Math.floor(r/(o+n)),a<1&&(a=1),S.style[e]=String.format("calc(99% / {0} - {1}px)",a,o)}},getVideoStyleRule:function(t){var e,i=SYNO.SDS.VideoStation2.Util.Styles;if(i.styleRules[t])return i.styleRules[t];if(!document.styleSheets)return null;for(e=document.styleSheets.length-1;e>=0;e--)if(Ext.isString(document.styleSheets[e].href)&&document.styleSheets[e].href.indexOf("/VideoStation/style.css")>=0)return i.styleRules[t]=i.getRuleBySelector(document.styleSheets[e],t),i.styleRules[t];return null},getRuleBySelector:function(t,e){var i,o,n;if(!t.rules)return null;for(i=0,o=t.rules.length;i<o;i++)if(n=t.rules[i],Ext.isString(n.selectorText)&&n.selectorText===e)return n;return null}}),Ext.define("SYNO.SDS.VideoStation2.Library",{statics:{EVENT_LIBRARY_LOAD:"libraryload",EVENT_LIBRARY_CHANGED:"librarychanged",DEFAULT_LIBRARY:[{id:0,title:_VST("playlist","title"),type:SYNO.SDS.VideoStation2.Constant.PLAYLIST,visible:!0}],instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Library.instance)||(SYNO.SDS.VideoStation2.Library.instance=new SYNO.SDS.VideoStation2.Library),SYNO.SDS.VideoStation2.Library.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.addEvents(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED),this.prepareDefaultLibrary(),this.cursor=this.default_library[0].get("opid"),this.current_id=this.default_library[0].get("id"),this.current_type=this.default_library[0].get("type")},getLibraryStore:function(){return this.store=this.store||new SYNO.SDS.VideoStation2.LibraryStore({appWindow:SYNO.SDS.VideoStation2.Window,listeners:{scope:this,load:this.onLibraryLoad}}),this.store},loadLibrary:function(){this.getLibraryStore().load()},onLibraryLoad:function(){this.store.insert(0,this.default_library),this.store.commitChanges(),this.updateCurrentDataByCursor(),this.fireEvent(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD)},prepareDefaultLibrary:function(){if(Ext.isEmpty(this.default_library)){var t=SYNO.SDS.VideoStation2.Library.DEFAULT_LIBRARY.filter(function(t){return!(t.type===SYNO.SDS.VideoStation2.Constant.TV_RECORDING&&SYNO.SDS.VideoStation2.Util.hideDTVUI())});this.default_library=t.map(function(t){return new SYNO.SDS.VideoStation2.LibraryStore.Record(Ext.apply(t,{opid:SYNO.SDS.VideoStation2.LibraryStore.convertOPID(t)}))})}},updateCurrentDataByCursor:function(){this.current_id=null,this.current_type=null;var t=this.cursor||this.tmp_cursor;this.store.each(function(e,i,o){return e.get("opid")!==t||(this.current_id=e.get("id"),this.current_type=e.get("type"),!1)},this)},activate:function(t){SYNO.Assert(Ext.isString(t),String.format("unexpceted library opid {0}",t)),this.cursor=t,this.tmp_cursor=null,this.updateCurrentDataByCursor(),this.fireEvent(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED)},activateTemporary:function(t){SYNO.Assert(Ext.isString(t),String.format("unexpceted library opid {0}",t)),this.tmp_cursor=t,this.updateCurrentDataByCursor(),this.fireEvent(SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED)},activateFromTemporary:function(){this.activate(this.tmp_cursor)},isDeactivated:function(){return Ext.isEmpty(this.cursor)},getCurrentID:function(){return this.current_id},getCurrentType:function(){return this.current_type},getLibraryByFn:function(t){var e=null;return this.store.each(function(i){if(t(i))return e=SYNO.Util.copy(i.data),!1}),e},getLibraryByOPID:function(t){return this.getLibraryByFn(function(e){return e.get("opid")===t})},getLibraryByIDAndType:function(t,e){return this.getLibraryByFn(function(i){return i.get("id")===t&&i.get("type")===e})},getAllLibraries:function(){var t=[];return this.store.each(function(e){var i=e.get("type");i!==SYNO.SDS.VideoStation2.Constant.PLAYLIST&&i!==SYNO.SDS.VideoStation2.Constant.TV_RECORDING&&t.push(SYNO.Util.copy(e.data))}),t},getCurrentVideoType:function(){var t=this.getCurrentType();return t===SYNO.SDS.VideoStation2.Constant.TVSHOW?SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:t},cursor:null,tmp_cursor:null,current_id:null,current_type:null}),Ext.define("SYNO.SDS.VideoStation2.LibraryStore",{statics:{defaultLibraryTitle:function(t){switch(t){case SYNO.SDS.VideoStation2.Constant.MOVIE:return _VST("type","movie");case SYNO.SDS.VideoStation2.Constant.TVSHOW:return _VST("type","tv_show");case SYNO.SDS.VideoStation2.Constant.HOME_VIDEO:return _VST("type","home_video");case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:return _VST("type","tv_recorder");default:return""}},convertOPID:function(t){return String.format("{0}-{1}",t.type,t.id)},Record:Ext.data.Record.create([{name:"id",type:"int"},{name:"title",type:"string",convert:function(t,e){return 0===e.id?SYNO.SDS.VideoStation2.LibraryStore.defaultLibraryTitle(e.type):t}},{name:"type",type:"string"},{name:"is_public",type:"boolean"},{name:"visible",type:"boolean"},{name:"opid",type:"string",convert:function(t,e){return SYNO.SDS.VideoStation2.LibraryStore.convertOPID(e)}}])},extend:"SYNO.API.Store",constructor:function(t){var e={api:"SYNO.VideoStation2.Library",method:"list",version:1,reader:new Ext.data.JsonReader({root:"library",idProperty:"opid"},SYNO.SDS.VideoStation2.LibraryStore.Record)};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.Stores",{extend:"SYNO.API.Store",proxyClass:"SYNO.API.Proxy",readerClass:"Ext.data.JsonReader",paramNames:{start:"offset",limit:"limit",sort:"sort_by",dir:"sort_direction"},synoAPI:null,synoMethod:null,synoVersion:1,constructor:function(t){t=t||{};var e=SYNO.Util.copy(this.baseConfigs.reader);e=Ext.apply(e,t.readerCfg);var i={method:"POST",proxy:this._getProxy(t),baseParams:Ext.apply({},this.baseConfigs.baseParams),reader:new(Ext.getClassByName(this.readerClass))(e)};t.baseParams&&Ext.applyIf(t.baseParams,this.baseConfigs.baseParams),Ext.apply(i,t),this.callParent([i])},_getProxy:function(t){return this._proxy=this._proxy||new(Ext.getClassByName(t.proxyClass||this.proxyClass))({appWindow:SYNO.SDS.VideoStation2.Window,api:t.synoAPI||this.synoAPI,method:t.synoMethod||this.synoMethod,version:t.synoVersion||this.synoVersion,listeners:{scope:this,beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),this._proxy}}),Ext.define("SYNO.SDS.VideoStation2.Stores.movie",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.Movie",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{additional:["poster_mtime","summary","watched_ratio","collection"]},reader:{id:"id",root:"movie",totalProperty:"total",fields:["id","mapper_id","title","certificate","rating","original_available","metadata_locked","additional","type","path","sharepath","file_count","last_watched","create_time","library_id"]}},constructor:function(){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Stores.tvshow",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.TVShow",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{additional:["poster_mtime","summary","backdrop_mtime"]},reader:{id:"id",root:"tvshow",totalProperty:"total",fields:["id","mapper_id","title","original_available","metadata_locked","additional","mapper_id","sort_title","last_watched","create_time","library_id"]}},constructor:function(){this.callParent(arguments)}}),
Ext.define("SYNO.SDS.VideoStation2.Stores.tvshow_episode",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.TVShowEpisode",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT,additional:["summary","collection","poster_mtime","watched_ratio"]},reader:{id:"id",root:"episode",totalProperty:"total",fields:["id","mapper_id","season","last_watched","episode","tagline","certificate","rating","original_available","metadata_locked","additional","mapper_id","sort_title","create_time","max_last_watched","library_id"]}},constructor:function(){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Stores.home_video",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.HomeVideo",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{additional:["summary","collection","poster_mtime","watched_ratio"]},reader:{id:"id",root:"video",totalProperty:"total",fields:["id","mapper_id","title","certificate","rating","record_date","additional","type","path","sharepath","file_count","last_watched","create_time","library_id"]}},constructor:function(){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Stores.tv_record",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.TVRecording",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{additional:["summary","collection","poster_mtime","watched_ratio"]},reader:{id:"id",root:"recording",totalProperty:"total",fields:["id","mapper_id","title","channel_name","certificate","rating","record_date","additional","last_watched","create_time"]}},constructor:function(){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Stores.playlist",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.Collection",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{offset:0,limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT,sort_direction:"asc",preview_video:4,additional:["sharing_info","filter_info"]},reader:{id:"id",root:"collection",totalProperty:"total",fields:["id","title","additional","type","preview_video"]}},constructor:function(){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Stores.folder",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.Folder",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.ByFolderProxy",baseConfigs:{baseParams:{preview_video:4,additional:["poster_mtime","summary","watched_ratio","collection"]},reader:{id:"id",root:"object",totalProperty:"total",fields:["id","title","additional","type","path","sharepath","file_count","preview_video","last_folder"]}},constructor:function(){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Stores.playlistvideolist",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.Collection",synoMethod:"list_video",proxyClass:"SYNO.SDS.VideoStation2.FilteringBaseProxy",baseConfigs:{baseParams:{sort_by:"title",sort_direction:"asc",additional:["summary","poster_mtime","watched_ratio","collection"]},reader:{id:"mapper_id",root:"video",totalProperty:"total",fields:["id","mapper_id","title","type","metadata_locked","additional","season","episode","tagline","library_id","original_available","record_date","date"]}},constructor:function(){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Stores.filter",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.Metadata",synoMethod:"list",proxyClass:"SYNO.SDS.VideoStation2.FilterMetadataProxy",baseConfigs:{baseParams:{limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT,sort_direction:"asc"},reader:{id:"key",root:"metadata",totalProperty:"total",fields:["key","value"]}},constructor:function(){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Stores.localfilter",{extend:"Ext.data.JsonStore",constructor:function(t){var e={id:"key",fields:["key","value"]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.Stores.internet_search",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.PluginSearch",synoMethod:"list",baseConfigs:{baseParams:{sort_direction:"asc"},reader:{id:"id",root:"result",totalProperty:"total",fields:["title","certificate","tag_line","original_available","actor","director","genre","writer","summary","extra","tvshow_original_available",{name:"episode",sortType:"asInt"},{name:"season",sortType:"asInt"},"tvshow_extra","tvshow_summary","tvshow_index"]}},sortInfo:{field:"title",direction:"asc"},remoteSort:!0,constructor:function(){this.callParent(arguments)},createSortFunction:function(t,e){e=e||"asc";var i="desc"==e.toLowerCase()?-1:1,o=this.fields.get(t).sortType;return function(e,n){if(Ext.isEmpty(e.data[t])&&Ext.isEmpty(n.data[t]))return 0;if(Ext.isEmpty(e.data[t]))return 1*i;if(Ext.isEmpty(n.data[t]))return-1*i;var a=o(e.data[t]),S=o(n.data[t]);return i*(a>S?1:a<S?-1:0)}}}),Ext.define("SYNO.SDS.VideoStation2.Stores.schedule",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.DTV.Schedule",synoMethod:"list",baseConfigs:{reader:{id:"id",root:"schedule",totalProperty:"total",fields:["channel_name","description","duration","channel_id","is_userdefine","id","start_date","start_time","status","title"]}},constructor:function(){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Stores.channel",{extend:"Ext.data.JsonStore",constructor:function(t){var e={id:"id",fields:["id","program","is_scrambled","title","is_streaming"]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.Stores.program",{extend:"Ext.data.JsonStore",constructor:function(t){var e={id:"id",fields:["id","start_time","title","status","description","duration","schedule","channel_id","channel_name","start_date_time"],sortInfo:{field:"start_time",direction:"asc"}};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.Stores.bychannel",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.TVRecording",synoMethod:"list_channel",baseConfigs:{baseParams:{offset:0,limit:120,preview_video:4},reader:{root:"channel",totalProperty:"total",fields:["title","preview_video"]}}}),Ext.define("SYNO.SDS.VideoStation2.Stores.byprogram",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.TVRecording",synoMethod:"list_program",baseConfigs:{baseParams:{offset:0,limit:120,preview_video:4},reader:{root:"program",totalProperty:"total",fields:["title","preview_video"]}}}),Ext.define("SYNO.SDS.VideoStation2.Stores.time_line",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.HomeVideo",synoMethod:"time_line",synoVersion:2,baseConfigs:{baseParams:{},reader:{root:"time_line",fields:["date","id"]}}}),Ext.define("SYNO.SDS.VideoStation2.Playlist",{statics:{EVENT_PLAYLIST_LOADED:"playlistloaded",EVENT_PLAYLIST_CHANGED:"playlistchanged",EVENT_PLAYLIST_CLEARED:"playlistcleared",TYPE_ORIGIONAL:"original",TYPE_SMART:"smart",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Playlist.instance)||(SYNO.SDS.VideoStation2.Playlist.instance=new SYNO.SDS.VideoStation2.Playlist),SYNO.SDS.VideoStation2.Playlist.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.addEvents(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED)},getStore:function(){return this.playlist_store=this.playlist_store||new SYNO.SDS.VideoStation2.Stores.playlist({listeners:{scope:this,load:function(t,e){var i=e.map(function(t){var e=t.data;switch(e.id){case-1:e.playlist_title=_VST("playlist","favorite");break;case-2:e.playlist_title=_VST("playlist","watchlist");break;case-3:e.playlist_title=_VST("playlist","default_shared");break;default:e.playlist_title=e.title}return e});this.current_playlists=i,this.dirty=!1,this.fireEvent(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED)}}}),this.playlist_store},loadPlaylists:function(){this.isDirty()?this.getStore().load():this.fireEvent(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED)},selectPlaylist:function(t,e){SYNO.Assert(Ext.isNumber(t)&&t>=-3,String.format("unexpceted playlist info {0}",t)),this.current_id=t,this.current_path_title=e,this.fireEvent(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CHANGED)},clearSelection:function(){this.current_id=null,this.current_path_title=null,this.fireEvent(SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CLEARED)},markDirty:function(){this.dirty=!0},isSet:function(){return Ext.isNumber(this.current_id)},getCurrentPlaylists:function(){return this.current_playlists},getCurrentID:function(){return this.current_id},getCurrentPathTitle:function(){return this.current_path_title},getPlaylistByID:function(t){if(this.current_playlists)return this.current_playlists.filter(function(e){return e.id===t})[0]},isDirty:function(){return this.dirty},current_id:null,current_path_title:null,current_playlists:null,dirty:!0,playlist_store:null}),Ext.define("SYNO.SDS.VideoStation2.OP",{statics:{defaultFailureCallback:function(t,e,i){var o=SYNO.SDS.VideoStation2.Error.getAPIErrorString(t);SYNO.SDS.VideoStation2.Window.getMsgBox().alert("",o)},sendRequest:function(t,e,i,o,n,a,S){var s=SYNO.API.Request({api:t,method:e,version:i,params:o,callback:function(t,e,i,o){if(!t)return void(Ext.isFunction(s.failure_callback)?s.failure_callback.call(this,e,i,o):SYNO.SDS.VideoStation2.OP.defaultFailureCallback(e,i,o));Ext.isFunction(s.success_callback)&&s.success_callback.call(this,e,i,o)},scope:S});return s.success_callback=n,s.failure_callback=a,s},compound:function(t,e,i,o){e=Ext.isFunction(e)?e:Ext.emptyFn,i=Ext.isFunction(i)?i:Ext.emptyFn,o=o||window;var n=0,a=0,S=function(){n===t.length&&(0===a?e.apply(o):i.apply(o))};t.each(function(t){var e=Ext.isFunction(t.success_callback)?t.success_callback:Ext.emptyFn,i=Ext.isFunction(t.failure_callback)?t.failure_callback:Ext.emptyFn;t.success_callback=function(){e.apply(this,arguments),n+=1,S()},t.failure_callback=function(){i.apply(this,arguments),n+=1,a+=1,S()}})},abort:function(t){Ext.Ajax.abort(t)},classifyRequest:function(t,e,i,o,n){e=Ext.isFunction(e)?e:Ext.emptyFn,i=Ext.isFunction(i)?i:Ext.emptyFn,o=Ext.isFunction(o)?o:Ext.emptyFn,n=n||window;var a=SYNO.SDS.VideoStation2.Util.classifyVideos(t),S=Object.keys(a),s=S.map(function(t){return e.call(n,a,t)}).filter(function(t){return t});SYNO.SDS.VideoStation2.OP.compound(s,i,o,n)},pollingRequest:function(t,e,i,o,n){var a=null,S=function(){a&&(SYNO.SDS.VideoStation2.OP.abort(a),a=null),a=SYNO.SDS.VideoStation2.OP.get()[t](s.params,i,n)},s=SYNO.SDS.VideoStation2.Window.addTask({interval:o,run:S}),r=s.stop;return s.stop=function(){a&&(Ext.Ajax.abort(a),a=null),r.apply(s,arguments)},s.params=e,s.start(!0),s},instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.OP.instance)||(SYNO.SDS.VideoStation2.OP.instance=new SYNO.SDS.VideoStation2.OP),SYNO.SDS.VideoStation2.OP.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);var t={getInfo:[SYNO.SDS.VideoStation2.Util.getAPIName,"getinfo",1],addVideoToPlaylist:["SYNO.VideoStation2.Collection","add_video",1],removeVideoFromPlaylist:["SYNO.VideoStation2.Collection","delete_video",1],setVideoWatched:[SYNO.SDS.VideoStation2.Util.getAPIName,"set_watched",1],setVideoRating:[SYNO.SDS.VideoStation2.Util.getAPIName,"set_rating",1],deleteVideo:[SYNO.SDS.VideoStation2.Util.getAPIName,"delete",1],deleteFile:["SYNO.VideoStation2.File","delete",1],getFileTrackInfo:["SYNO.VideoStation2.File","get_track_info",1],getPublicSharing:["SYNO.VideoStation2.Sharing","get",1],setPublicSharing:["SYNO.VideoStation2.Sharing","set",1],createPlaylist:["SYNO.VideoStation2.Collection","create",1],createSmartPlaylist:["SYNO.VideoStation2.Collection","create_smart",1],deletePlaylist:["SYNO.VideoStation2.Collection","delete",1],editPlaylist:["SYNO.VideoStation2.Collection","edit",1],editSmartPlaylist:["SYNO.VideoStation2.Collection","edit_smart",1],listPlayer:["SYNO.VideoStation2.Controller.Device","list",1],listMetadata:["SYNO.VideoStation.Metadata","list",2],searchSubtitle:["SYNO.VideoStation2.Subtitle","search",1],downloadSubtitle:["SYNO.VideoStation2.Subtitle","download",1],listAudioTrack:["SYNO.VideoStation.AudioTrack","list",1],setPoster:["SYNO.VideoStation2.Poster","set",1],deletePoster:["SYNO.VideoStation2.Poster","delete",1],setBackdrop:["SYNO.VideoStation2.Backdrop","add",1],deleteAllBackdrop:["SYNO.VideoStation2.Backdrop","delete_all",1],editMetadata:[SYNO.SDS.VideoStation2.Util.getAPIName,"edit",1],editMetadataAdv:["SYNO.VideoStation2.TVShowEpisode","edit_adv",1],startSearchMetadata:["SYNO.VideoStation2.PluginSearch","start",1],listSearchMetadata:["SYNO.VideoStation2.PluginSearch","list",1],querySearchMetadata:["SYNO.VideoStation2.PluginSearch","query",1],stopSearchMetadata:["SYNO.VideoStation2.PluginSearch","stop",1],listChannel:["SYNO.VideoStation2.DTV.Channel","list",1],editChannel:["SYNO.VideoStation2.DTV.Channel","edit",1],listProgram:["SYNO.VideoStation2.DTV.Program","list",1],searchProgram:["SYNO.VideoStation2.DTV.Program","search",1],liveStreaming:["SYNO.VideoStation2.DTV.StreamController","set_streaming",1],createRecording:["SYNO.VideoStation2.DTV.Schedule","create",1],createRepeatRecording:["SYNO.VideoStation2.DTV.Schedule","create_repeat",1],createUserDefinedRecording:["SYNO.VideoStation2.DTV.Schedule","create_userdefine",1],deleteSchedule:["SYNO.VideoStation2.DTV.Schedule","delete",1],deleteRepeatSchedule:["SYNO.VideoStation2.DTV.Schedule","delete_repeat",1],deleteUserDefinedSchedule:["SYNO.VideoStation2.DTV.Schedule","delete_userdefine",1],deletePassSchedule:["SYNO.VideoStation2.DTV.Schedule","delete_passed",1],getUserDefinedScheduleInfo:["SYNO.VideoStation2.DTV.Schedule","getinfo_userdefine",1],getRepeatScheduleInfo:["SYNO.VideoStation2.DTV.Schedule","getinfo_repeat",1],editUserDefinedSchedule:["SYNO.VideoStation2.DTV.Schedule","edit_userdefine",1],editRepeatSchedule:["SYNO.VideoStation2.DTV.Schedule","edit_repeat",1],getChannelScanInfo:["SYNO.VideoStation2.DTV.ChannelScan","getinfo",1],getSatelliteScanInfo:["SYNO.VideoStation2.DTV.DVBSScan","getinfo",1],getChannelScanCountry:["SYNO.VideoStation2.DTV.ChannelScan","get_country",1],getChannelScanRegion:["SYNO.VideoStation2.DTV.ChannelScan","get_region",1],getSatelliteScanSatellite:["SYNO.VideoStation2.DTV.DVBSScan","get_satellite",1],getSatelliteScanLNB:["SYNO.VideoStation2.DTV.DVBSScan","get_lnb",1],startChannelScan:["SYNO.VideoStation2.DTV.ChannelScan","start",1],startSatelliteScan:["SYNO.VideoStation2.DTV.DVBSScan","start",1],stopChannelScan:["SYNO.VideoStation2.DTV.ChannelScan","stop",1],stopSatelliteScan:["SYNO.VideoStation2.DTV.DVBSScan","stop",1],getChannelScanStatus:["SYNO.VideoStation2.DTV.ChannelScan","status",1],getSatelliteScanStatus:["SYNO.VideoStation2.DTV.DVBSScan","status",1],createSatellite:["SYNO.VideoStation2.DTV.DVBSScan","create_satellite",1],editSatellite:["SYNO.VideoStation2.DTV.DVBSScan","edit_satellite",1],deleteSatellite:["SYNO.VideoStation2.DTV.DVBSScan","delete_satellite",1],createLNB:["SYNO.VideoStation2.DTV.DVBSScan","create_lnb",1],editLNB:["SYNO.VideoStation2.DTV.DVBSScan","edit_lnb",1],deleteLNB:["SYNO.VideoStation2.DTV.DVBSScan","delete_lnb",1],getTransponder:["SYNO.VideoStation2.DTV.DVBSScan","get_tp",1],getDefaultTransponder:["SYNO.VideoStation2.DTV.DVBSScan","get_default_tp",1],editTransponder:["SYNO.VideoStation2.DTV.DVBSScan","edit_tp",1],updateProgramGuide:["SYNO.VideoStation2.DTV.Program","update",1],getTunerInfo:["SYNO.VideoStation2.DTV.Tuner","getinfo",1],getDTVChannel:["SYNO.VideoStation2.DTV.StreamController","getinfo",1],stopDTVStreaming:["SYNO.VideoStation2.DTV.StreamController","stop_streaming",1],getDTVChannelInfo:["SYNO.VideoStation2.DTV.Channel","getinfo",1],getDTVStatistic:["SYNO.VideoStation2.DTV.Statistic","getinfo",1],listTuner:["SYNO.VideoStation2.DTV.Tuner","list",1],stopOfflineConversionTask:["SYNO.VideoStation.OfflineConversion","stop",1],restartOfflineConversionTask:["SYNO.VideoStation.OfflineConversion","restart",1],deleteOfflineConversionTask:["SYNO.VideoStation.OfflineConversion","delete",1],setLibraryVisibility:["SYNO.VideoStation2.Library","set_visibility",1],getPreAnalysisInfo:["SYNO.VideoStation2.Setting.PreAnalysis","get",1],setPreAnalysisInfo:["SYNO.VideoStation2.Setting.PreAnalysis","set",1],triggerPreAnalysis:["SYNO.VideoStation2.Setting.PreAnalysis","trigger",1],getPersonalSetting:["SYNO.VideoStation2.Setting.Personal","get",1],setPersonalSetting:["SYNO.VideoStation2.Setting.Personal","set",1],getParentalControl:["SYNO.VideoStation2.ParentalControl","get",1],setParentalControl:["SYNO.VideoStation2.ParentalControl","set",1],deleteParentalControl:["SYNO.VideoStation2.ParentalControl","delete",1]};Ext.iterate(t,function(t,e,i){this[t]=function(t,i,o){var n=Ext.isFunction(e[0])?e[0](o):e[0],a=e[1],S=e[2];return SYNO.SDS.VideoStation2.OP.sendRequest(n,a,S,t,i.success,i.failure,i.scope)}},this)}}),Ext.define("SYNO.SDS.VideoStation2.PlaylistController",{statics:{loadPlaylists:function(){SYNO.SDS.VideoStation2.Playlist.get().loadPlaylists()},doPlaylistRequest:function(t,e,i,o,n){i=Ext.isFunction(i)?i:Ext.emptyFn,o=Ext.isFunction(o)?o:Ext.emptyFn,n=n||window;var a=function(t){i.call(n,t),SYNO.SDS.VideoStation2.Playlist.get().markDirty(),SYNO.SDS.VideoStation2.PlaylistController.loadPlaylists()};SYNO.SDS.VideoStation2.OP.get()[t](e,{success:a,failure:o,scope:n})},addVideoToPlaylist:function(t,e,i){SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist(t,e,!0,i)},removeVideoFromPlaylist:function(t,e,i){SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist(t,e,!1,i)},setVideoWithPlaylist:function(t,e,i,o){var n=t.map(function(t){return{video_id:t.id,video_type:t.type}});SYNO.SDS.VideoStation2.OP.get()[i?"addVideoToPlaylist":"removeVideoFromPlaylist"]({id:e,video:n},{success:function(){SYNO.SDS.VideoStation2.Playlist.get().markDirty(),o()}})},applyPlaylistChangeToVideo:function(t,e,i){t.each(function(t){if(t.record){var o=t.record.get("additional");o.collection=o.collection||[],i?o.collection.push({id:e.id,title:e.title}):o.collection=o.collection.filter(function(t){return t.id!==e.id}),t.record.set("additional",o)}}),SYNO.SDS.VideoStation2.Playlist.get().markDirty()},createPlaylistActions:function(t,e){var i=Ext.isFunction(t.clsFn)?t.clsFn:Ext.emptyFn,o=Ext.isFunction(t.hideOnClickFn)?t.hideOnClickFn:Ext.emptyFn,n=Ext.isFunction(t.createPlaylistFn)?t.createPlaylistFn:Ext.emptyFn,a=Ext.isFunction(t.clickPlaylistFn)?t.clickPlaylistFn:Ext.emptyFn,S=function(t){return-3!==t.id&&SYNO.SDS.VideoStation2.Constant.PLAYLIST_TYPE.ORIGINAL===t.type},s=Ext.isFunction(t.filterPlaylistFn)?t.filterPlaylistFn:S,r=[new Ext.Action({text:_VST("playlist","action_create"),scope:e,handler:n})],l=SYNO.SDS.VideoStation2.Playlist.get().getCurrentPlaylists().filter(s);return l?r.concat(l.map(function(t){return new Ext.menu.Item({text:t.playlist_title,scope:e,itemId:t.id.toString(),cls:i.call(e,t)||"",hideOnClick:o.call(e,t)||!1,disabled:!1,handler:a})})):r}}}),Ext.define("SYNO.SDS.VideoStation2.Checkbox",{extend:"SYNO.ux.Checkbox",xtype:"syno_vs_checkbox",checkIconCls:"syno-vs2-checkbox syno-ux-checkbox-icon",constructor:function(t){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.DateField",{extend:"SYNO.ux.DateField",xtype:"syno_vs_datefield",constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-datefield")},onTriggerClick:function(){this.callParent(arguments),this.menu&&!this.menu.el.hasClass("syno-vs2-datefield-menu")&&this.menu.addClass("syno-vs2-datefield-menu")}}),Ext.define("SYNO.SDS.VideoStation2.FormPanel",{extend:"SYNO.ux.FormPanel",xtype:"syno_vs_form",constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-form")}}),Ext.define("SYNO.SDS.VideoStation2.TextField",{extend:"SYNO.ux.TextField",xtype:"syno_vs_textfield",constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-textfield"),this.addClass("syno-vs2-base-textfield")}}),Ext.define("SYNO.SDS.VideoStation2.PlaylistSharingDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",playlist:null,editable:null,constructor:function(t){var e={layout:"fit",width:450,height:t.editable?230:120,buttons:[this.doneBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("common","done"),btnStyle:"blue",scope:this,handler:this.onDoneBtn}),this.openLinkBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","open_link"),scope:this,handler:this.onOpenLinkBtn})],items:[this.panel=new SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel(t)],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)]),this.mon(this.panel,SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_CHANGED,this.onPlaylistSharingChanged,this)},onAfterRender:function(){this.setTitle(String.format(_VST("playlist","link_to"),this.playlist.playlist_title)),this.firePlaylistLoaded()},onDoneBtn:function(){if(this.panel.isValid()){if(!this.panel.isDirty())return void this.close();this.isFinalRequest=!0,this.onPlaylistSharingChanged()}},onOpenLinkBtn:function(){window.open(this.panel.getPublicSharingURL())},onPlaylistSharingChanged:function(){if(this.panel.isValid()){this.setStatusBusy();var t=this.panel.getValues();t.id=this.playlist.id,SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("editPlaylist",t,this.onPlaylistSharing,this.onPlaylistSharingFail,this)}},onPlaylistSharing:function(){this.waitingPlaylist||this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this),this.waitingPlaylist=this.playlist.id},onPlaylistSharingFail:function(t,e,i){this.clearStatusBusy(),this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(t)})},onPlaylistLoaded:function(){if(this.clearStatusBusy(),this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this),this.isFinalRequest)return void this.close();this.playlist=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(this.waitingPlaylist),this.waitingPlaylist=null,this.firePlaylistLoaded()},firePlaylistLoaded:function(){var t=SYNO.Util.copy(this.playlist.additional.sharing_info);this.openLinkBtn.setDisabled(!t.enable_sharing),this.panel.fireEvent(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_LOADED,t)}}),Ext.define("SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel",{statics:{EVENT_PLAYLIST_SHARING_CHANGED:"playlistsharingchanged",EVENT_PLAYLIST_SHARING_LOADED:"playlistsharingloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e={defaults:{anchor:"100%"},updateFormForScrollbar:!0,items:[{xtype:"syno_vs_checkbox",boxLabel:_VST("playlist","action_share"),name:"enable_sharing",itemId:"enable_sharing",hidden:!t.editable,listeners:{scope:this,check:this.onEnableSharingChecked}},this.urlTextfield=new SYNO.SDS.VideoStation2.TextField({name:"url",cls:"selectabletext",itemId:"url",disabled:!0,readOnly:!0,selectOnFocus:!0,hideLabel:!0}),this.enableCustomizeDurationCheckbox=new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("playlist","customize_duration"),name:"enable_customize_duration",itemId:"enable_customize_duration",disabled:!0,hidden:!t.editable}),this.customizeDurationFields=new SYNO.ux.CompositeField({hideLabel:!0,disabled:!0,indent:1,hidden:!t.editable,itemId:"customize_duration",items:[this.dateAvailableField=new SYNO.SDS.VideoStation2.DateField({name:"date_available",itemId:"date_available",editable:!1,format:SYNO.SDS.DateTimeUtils?void 0:"Y-m-d",value:new Date}),{xtype:"syno_vs_displayfield",value:"-",hideLabel:!0},this.dateExpiredField=new SYNO.SDS.VideoStation2.DateField({name:"date_expired",itemId:"date_expired",editable:!1,format:SYNO.SDS.DateTimeUtils?void 0:"Y-m-d",minValue:new Date,value:(new Date).add(Date.DAY,7),validator:this.customizeDurationValidator.createDelegate(this)})]})]};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_CHANGED),this.addEvents(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_LOADED),this.mon(this,SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_LOADED,this.onPlaylistSharingLoaded,this),this.initEnableCheckGroup()},initEnableCheckGroup:function(){return[new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_sharing",["url","enable_customize_duration"]),new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_customize_duration",["customize_duration"])]},customizeDurationValidator:function(t){return!(this.dateAvailableField.getValue()>this.dateExpiredField.getValue())||_VST("playlist","error_exp_before_avail")},isValid:function(){return this.getForm().isValid()},isDirty:function(){return!SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},getPublicSharingURL:function(){return this.getForm().getValues().url},getValues:function(){var t=this.getForm().getValues();return"true"!==t.enable_customize_duration?(delete t.date_available,delete t.date_expired):(t.date_available=SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.date_available),t.date_expired=SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.date_expired)),t.enable_sharing="true"===t.enable_sharing,delete t.enable_customize_duration,t},onPlaylistSharingLoaded:function(t){t.date_available&&"0"!==t.date_available&&t.date_expired&&"0"!==t.date_expired?t.enable_customize_duration=!0:(t.enable_customize_duration=!1,delete t.date_available,delete t.date_expired),this.getForm().setValues(t),this.oriValue=this.getValues()},onEnableSharingChecked:function(t,e){this.fireEvent(SYNO.SDS.VideoStation2.PlaylistSharingDialog.Panel.EVENT_PLAYLIST_SHARING_CHANGED)}}),Ext.define("SYNO.SDS.VideoStation2.CreatePlaylistDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",forcePublicSharing:null,smartPlaylist:null,videos:null,constructor:function(t){var e={layout:"fit",width:560,height:280,title:t.smartPlaylist?_VST("playlist","action_create_smart"):t.forcePublicSharing?_VST("advanced","public_sharing"):_VST("playlist","action_create"),buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.CreatePlaylistDialog.Panel(t)]};this.callParent([Ext.apply(e,t)])},onOKBtn:function(){if(this.panel.isValid()){this.setStatusBusy();var t=this.panel.getValues();if(this.smartPlaylist){var e=Ext.apply({type:SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType(),library_id:[SYNO.SDS.VideoStation2.Library.get().getCurrentID()]},SYNO.SDS.VideoStation2.Filter.get().getFilterOption());Ext.apply(e,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption()),t.filter_info=e,SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("createSmartPlaylist",t,this.onCreatePlaylist,this.onCreatePlaylistFail,this)}else SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("createPlaylist",t,this.onCreatePlaylist,this.onCreatePlaylistFail,this)}},onCreatePlaylist:function(t){this.waitingPlaylist||this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this),this.waitingPlaylist=t.id},onCreatePlaylistFail:function(t,e,i){this.clearStatusBusy(),this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(t)})},onPlaylistLoaded:function(){this.clearStatusBusy(),this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this);var t=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(this.waitingPlaylist);if(this.waitingPlaylist=null,this.smartPlaylist||SYNO.SDS.VideoStation2.PlaylistController.addVideoToPlaylist(this.videos,t.id,this.onVideoAdded.createDelegate(this,[t])),this.forcePublicSharing){new SYNO.SDS.VideoStation2.PlaylistSharingDialog({owner:this.owner,playlist:t}).open()}this.close()},onVideoAdded:Ext.emptyFn}),Ext.define("SYNO.SDS.VideoStation2.CreatePlaylistDialog.Panel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e=SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing(),i={defaults:{anchor:"100%"},updateFormForScrollbar:!0,items:[{xtype:"syno_vs_displayfield",value:_VST("playlist","share_desc"),hideLabel:!0,hidden:!t.forcePublicSharing||!e},this.titleTextField=new SYNO.SDS.VideoStation2.TextField({fieldLabel:_VST("playlist","playlist_name"),name:"title",itemId:"title",validator:SYNO.SDS.VideoStation2.Util.lengthValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.PLAYLIST_NAME],!0)}),{xtype:"syno_vs_checkbox",boxLabel:_VST("playlist","action_share"),name:"enable_sharing",hidden:t.forcePublicSharing||!e,checked:t.forcePublicSharing&&e},{xtype:"syno_vs_checkbox",boxLabel:_VST("playlist","customize_duration"),hidden:!e,name:"enable_customize_duration",itemId:"enable_customize_duration"},this.customizeDurationFields=new SYNO.ux.CompositeField({hidden:!e,hideLabel:!0,disabled:!0,indent:1,itemId:"customize_duration",items:[this.dateAvailableField=new SYNO.SDS.VideoStation2.DateField({name:"date_available",itemId:"date_available",editable:!1,format:SYNO.SDS.DateTimeUtils?void 0:"Y-m-d",value:new Date}),{xtype:"syno_vs_displayfield",value:"-",hideLabel:!0},this.dateExpiredField=new SYNO.SDS.VideoStation2.DateField({name:"date_expired",itemId:"date_expired",editable:!1,minValue:new Date,format:SYNO.SDS.DateTimeUtils?void 0:"Y-m-d",value:(new Date).add(Date.DAY,7),validator:this.customizeDurationValidator.createDelegate(this)})]})],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(i,t)]),this.initEnableCheckGroup()},initEnableCheckGroup:function(){return[new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_customize_duration",["customize_duration"])]},customizeDurationValidator:function(t){return!(this.dateAvailableField.getValue()>this.dateExpiredField.getValue())||_VST("playlist","error_exp_before_avail")},getValues:function(){var t=this.getForm().getValues();return"true"!==t.enable_customize_duration?(delete t.date_available,delete t.date_expired):(t.date_available=SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.date_available),t.date_expired=SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.date_expired)),t.enable_sharing="true"===t.enable_sharing,delete t.enable_customize_duration,t},isValid:function(){return this.getForm().isValid()},onAfterRender:function(){var t=_VST("playlist","untitled_name"),e=SYNO.SDS.VideoStation2.Playlist.get().getCurrentPlaylists(),i=e.filter(function(e){return e.title.substr(0,t.length)===t}).length;i>0&&(t+=String.format(" ({0})",i)),this.titleTextField.setValue(t)}}),Ext.define("SYNO.SDS.VideoStation2.SuperBox",{statics:{CLASS_MENU_EXPANDED:"menu-expanded"},extend:"SYNO.ux.SuperBoxSelect",xtype:"syno_vs_superbox",listClass:"syno-vs2-combobox-list",extraItemCls:"syno-vs2-superbox-item",ctCls:"syno-vs2-superbox",constructor:function(){this.callParent(arguments),this.mon(this,"expand",this.addExpandedClass,this),this.mon(this,"collapse",this.removeExpandedClass,this)},addExpandedClass:function(){this.addClass(SYNO.SDS.VideoStation2.SuperBox.CLASS_MENU_EXPANDED)},removeExpandedClass:function(){this.removeClass(SYNO.SDS.VideoStation2.SuperBox.CLASS_MENU_EXPANDED)},onDestroy:function(){this.mun(this,"expand",this.addExpandedClass,this),this.mun(this,"collapse",this.removeExpandedClass,this),this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",playlist:null,constructor:function(t){this.playlist=t.playlist;var e=[this.panel=new SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel(Ext.apply({anchor:"100%"},t))]
;this.isSmart()&&e.push(this.smartPanel=new SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel(Ext.apply({anchor:"100% -35",hidden:!0},t)));var i={layout:"anchor",width:560,height:280,padding:"0 20",buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:e,listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(i,t)])},onClose:function(){return SYNO.SDS.BaseWindow.superclass.destroy.call(this),!1},isSmart:function(){return this.playlist.type===SYNO.SDS.VideoStation2.Playlist.TYPE_SMART},isValid:function(){var t=this.panel.isValid();return this.isSmart()&&(t=this.smartPanel.isValid()&&t),t},isDirty:function(){var t=this.panel.isDirty();return this.isSmart()&&(t=this.smartPanel.isDirty()||t),t},getValues:function(){var t=this.panel.getValues();if(t.id=parseInt(t.id,10),this.isSmart()){var e=this.playlist.additional.filter_info,i=this.smartPanel.getValues();i.type=e.type,i.library_id=e.library_id,t.filter_info=i}return t},onOKBtn:function(){if(this.isValid()){if(!this.isDirty())return void this.close();this.setStatusBusy(),this.isSmart()?SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("editSmartPlaylist",this.getValues(),this.onEditPlaylist,this.onEditPlaylistFail,this):SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("editPlaylist",this.getValues(),this.onEditPlaylist,this.onEditPlaylistFail,this)}},onAfterRender:function(){this.panel.fireEvent(SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel.EVENT_PLAYLIST_LOADED,this.playlist),this.isSmart()?(this.smartPanel.fireEvent(SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel.EVENT_PLAYLIST_LOADED,this.playlist),this.smartPanel.show(),this.setTitle(_VST("playlist","action_edit_smart"))):this.setTitle(_VST("playlist","action_edit"))},onEditPlaylist:function(){this.clearStatusBusy(),this.close()},onEditPlaylistFail:function(t,e,i){this.clearStatusBusy(),this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(t)})}}),Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel",{statics:{EVENT_PLAYLIST_LOADED:"playlistloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e={height:35,defaults:{anchor:"100%"},updateFormForScrollbar:!0,items:[{xtype:"syno_vs_numberfield",name:"id",itemId:"id",hidden:!0},this.titleTextField=new SYNO.SDS.VideoStation2.TextField({fieldLabel:_VST("playlist","playlist_name"),name:"title",itemId:"title",validator:SYNO.SDS.VideoStation2.Util.lengthValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.PLAYLIST_NAME],!0)})]};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel.EVENT_PLAYLIST_LOADED),this.mon(this,SYNO.SDS.VideoStation2.EditPlaylistDialog.Panel.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this)},getValues:function(){return this.getForm().getValues()},isValid:function(){return this.getForm().isValid()},isDirty:function(){return!SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},onPlaylistLoaded:function(t){this.getForm().setValues(t),this.oriValue=this.getValues()}}),Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel",{statics:{EVENT_PLAYLIST_LOADED:"playlistloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e=t.playlist.additional.filter_info.type,i=e===SYNO.SDS.VideoStation2.Constant.TV_RECORDING?this.getTVRecordItems():this.getNormalLibraryItems();i.push({xtype:"syno_vs_textfield",itemId:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,name:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,fieldLabel:SYNO.SDS.VideoStation2.Util.getFilterCategoryString(SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD)});var o={defaults:{anchor:"100%"},updateFormForScrollbar:!0,items:i};this.callParent([Ext.apply(o,t)]),this.addEvents(SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel.EVENT_PLAYLIST_LOADED),this.mon(this,SYNO.SDS.VideoStation2.EditPlaylistDialog.SmartPlaylistPanel.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this)},getValues:function(){var t={};return this.items.each(function(e){var i=e.getValue();!i||Ext.isArray(i)&&0===i.length||(t[e.name]=i)}),t},isValid:function(){return this.getForm().isValid()},isDirty:function(){return!SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},getFilterOption:function(){var t={};return Ext.iterate(this.getValues(),function(e,i){"keyword"!==e&&(t[e]=i)}),Ext.apply(t,{type:this.type,library_id:this.library_id}),t},createOptionItem:function(t){var e=[SYNO.SDS.VideoStation2.Filter.FILTER_RATING,SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION,SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS,SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT,SYNO.SDS.VideoStation2.Filter.FILTER_DURATION],i={category:t,itemId:t,name:t,getFilterOption:this.getFilterOption.createDelegate(this),listeners:{scope:this,valuechanged:this.doLayout}};return-1!==e.indexOf(t)?new SYNO.SDS.VideoStation2.EditPlaylistDialog.LocalOption(i):new SYNO.SDS.VideoStation2.EditPlaylistDialog.Option(i)},getNormalLibraryItems:function(){return[SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE,SYNO.SDS.VideoStation2.Filter.FILTER_RATING,SYNO.SDS.VideoStation2.Filter.FILTER_YEAR,SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION,SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS,SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT,SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER,SYNO.SDS.VideoStation2.Filter.FILTER_DURATION].map(function(t){return this.createOptionItem(t)},this)},getTVRecordItems:function(){return[SYNO.SDS.VideoStation2.Filter.FILTER_DATE,SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME,SYNO.SDS.VideoStation2.Filter.FILTER_TITLE,SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION,SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS,SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT,SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER,SYNO.SDS.VideoStation2.Filter.FILTER_DURATION].map(function(t){return this.createOptionItem(t)},this)},onPlaylistLoaded:function(t){var e=t.additional.filter_info;this.type=e.type,this.library_id=e.library_id,Ext.iterate(e,function(t,e){if("type"!==t&&"library_id"!==t&&"keyword"!==t){var i=this.getComponent(t);i&&!i.local&&e.each(function(t){i.addNewItem({key:t,value:t})})}},this),this.getForm().setValues(e),this.oriValue=this.getValues()}}),Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.Option",{extend:"SYNO.SDS.VideoStation2.SuperBox",category:null,type:null,library_id:null,local:!1,getFilterOption:Ext.emptyFn,constructor:function(t){var e=t.local||this.local,i=t.category||this.category,o={valueField:"value",displayField:"key",triggerAction:"all",mode:e?"local":"remote",minChars:2,allowQueryAll:!0,pageSize:300,editable:!0,grow:!0,typeAhead:!0,allowAddNewData:!0,addNewDataOnBlur:!0,fieldLabel:SYNO.SDS.VideoStation2.Util.getFilterCategoryString(i),store:this.getStore(t)};this.callParent([Ext.apply(o,t)])},getStore:function(t){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.filter({listeners:{scope:this,beforeload:this.onBeforeLoadStore}}),this._store},onBeforeLoadStore:function(t,e){var i=e.params;Ext.apply(i,{category:this.category}),Ext.apply(i,this.getFilterOption()),delete i[this.category]},getValue:function(){var t=[];return this.items.each(function(e){t.push(e.value)}),t},findRecord:function(t,e){var i;return this.store.getCount()>0&&this.store.each(function(o){if(SYNO.ux.Utils.checkObjectConsistency(o.data[t],e))return i=o,!1}),i}}),Ext.define("SYNO.SDS.VideoStation2.EditPlaylistDialog.LocalOption",{extend:"SYNO.SDS.VideoStation2.EditPlaylistDialog.Option",local:!0,constructor:function(t){this.callParent(arguments)},getStore:function(t){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.getLocalFilterData(t.category)}),this._store}}),Ext.define("SYNO.SDS.VideoStation2.PlaylistActionController",{statics:{ACTION_DELETE:"action_delete",ACTION_SHARE:"action_share",ACTION_EDIT:"action_edit",getAllActions:function(){return[SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_DELETE,SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_SHARE,SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT]},doPlaylistAction:function(t,e){switch(t){case SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_DELETE:return SYNO.SDS.VideoStation2.PlaylistActionController.deletePlaylist(e);case SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_SHARE:return SYNO.SDS.VideoStation2.PlaylistActionController.sharePlaylist(e);case SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT:return SYNO.SDS.VideoStation2.PlaylistActionController.editPlaylist(e);default:SYNO.Debug.error(String.format("unknown playlist action {0}",t))}},deletePlaylist:function(t){var e=_VST("playlist","delete_confirm");SYNO.SDS.VideoStation2.Window.getMsgBox().confirmDelete("",e,function(e){"yes"===e&&SYNO.SDS.VideoStation2.PlaylistActionController.doDeletePlaylist(t)})},doDeletePlaylist:function(t){SYNO.SDS.VideoStation2.PlaylistController.doPlaylistRequest("deletePlaylist",{id:t})},sharePlaylist:function(t){var e=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(t);new SYNO.SDS.VideoStation2.PlaylistSharingDialog({owner:SYNO.SDS.VideoStation2.Window,playlist:e,editable:!0}).open()},editPlaylist:function(t){var e=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(t);new SYNO.SDS.VideoStation2.EditPlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,playlist:e}).open()},createSmartPlaylist:function(){new SYNO.SDS.VideoStation2.CreatePlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,smartPlaylist:!0}).open()}}}),Ext.define("SYNO.SDS.VideoStation2.SourceDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(t){var e={title:_VST("video_info","source"),layout:"fit",cls:"source-dialog",width:460,height:480,minWidth:300,minHeight:280,padding:24,buttons:[{xtype:"syno_vs_button",text:_T("common","close"),scope:this,handler:this.close}],items:[this.panel=new SYNO.SDS.VideoStation2.SourceDialog.Panel]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.SourceDialog.Panel",{extend:"Ext.DataView",constructor:function(t){var e={tpl:this.getTpl(),store:this.getStore(),cls:"source-list",itemSelector:"div.source-wrap"};this.callParent([Ext.apply(e,t)])},getTpl:function(){return this.tpl=this.tpl||new Ext.XTemplate('<tpl for=".">','<div class="source-wrap {id}">',"{[this.getLink(values)]}","</div>","</tpl>",'<div class="desc">{[_VST("video_info", "source_description")]}</div>',{getLink:function(t){var e=String.format('<a target="_blank" class="link" href="{0}">{1}</a>',t.link,t.title);return String.format(_VST("video_info","license_under"),e)}}),this.tpl},getStore:function(){return this.store=this.store||new Ext.data.JsonStore({id:"id",fields:["id","link","title"],data:[{id:"atmovies",link:"http://www.atmovies.com.tw/home/",title:_VST("video_info","source_atmovies")},{id:"tmdb",link:"https://www.themoviedb.org/",title:_VST("video_info","tmdb")},{id:"freebase",link:"http://creativecommons.org/licenses/by/2.5/",title:_VST("video_info","cc_by")},{id:"TVDB",link:"http://creativecommons.org/licenses/by/3.0/us/",title:_VST("video_info","cc_by")},{id:"allocine",link:"http://www.allocine.fr/",title:_VST("video_info","allocine")}]}),this.store}}),Ext.define("SYNO.SDS.VideoStation2.ImageSelector",{extend:"SYNO.SDS.Utils.ImageSelector",constructor:function(t){var e={state:"fromDS"};this.callParent([Ext.apply(e,t)]),this.addClass("syno-vs2-dialog"),this.addClass("syno-vs2-imageselector"),this.tree_myimage.hide(),this.tree_myimage.getSelectionModel().clearSelections(),this.centerPanel.layout.setActiveItem(this.view),Ext.each(this.buttons,function(t){t.addClass("syno-vs2-button")})},getMsgBox:function(t){if(!this.msgBox||this.msgBox.isDestroyed){var e=t&&t.owner||this;e=e.isDestroyed?null:e,this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:e})}return this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetailUtil",{singleton:!0,processVideoData:function(t){t.additional&&t.additional.collection&&(t.additional.collection=SYNO.SDS.VideoStation2.Util.convertCollectionID(t.additional.collection));var e={};try{e=Ext.decode(t.additional&&t.additional.extra)}catch(t){}var i=new SYNO.SDS.VideoStation2.ViewDetailUtil.PlusInfoHandler({plus_info:e});t.rating=t.rating/10,t.reference=i.collectReference(),SYNO.SDS.VideoStation2.ViewDetailUtil.chooseDefaultFile(t)},chooseDefaultFile:function(t){t.default_file=Ext.max(t.additional.file,function(t,e){return t.filesize>e.filesize?1:-1})},getRatingTpl:function(t){if(Ext.isString(t.channel_name))return"";var e="base";(!Ext.isNumber(t.rating)||t.rating<0)&&(e="none");var i=t.rating>=0?t.rating.toString():_VST("metadata","unknown"),o=Ext.util.Format.round(t.rating,0);return[0,1,2,3,4].map(function(t){var n,a=String.format("star_{0}",t+1),S=o-2*t;return S<1?n="":1===S?n='<div class="rating {0} half"></div>':S>=2&&(n='<div class="rating {0}"></div>'),n=String.format(n,a),String.format('<td ext:qtip="{0}"><div class="rating {1} {2}">{3}</div></td>',i,a,e,n)}).join("")}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetailUtil.PlusInfoHandler",{extend:"Ext.util.Observable",constructor:function(t){this.plus_info=t.plus_info||{},this.callParent(arguments)},collect:function(t,e){Ext.iterate(this.plus_info,function(i,o){Ext.iterate(o,function(i,o){t(i)&&Ext.iterate(o,function(t,i){e(t,i)})})})},collectReference:function(){var t={},e=[],i=function(t){return t===SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_REFERENCE},o=function(i,o){if(!Ext.isEmpty(o)){var n=i.toLowerCase(),a=String.format("{0}:{1}",n,o);a in t||Ext.each(SYNO.SDS.VideoStation2.ViewDetailUtil.ReferenceHandler.REFERENCE_SOURCE,function(i){n===i.key&&(t[a]=!0,e.push({title:i.title,url:SYNO.SDS.VideoStation2.ViewDetailUtil.ReferenceHandler[i.url_fn](o)}))})}};return this.collect(i,o),Ext.isEmpty(e)?null:e},calculateMaxRating:function(){var t=-1,e=function(t){return t===SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_RATING},i=function(e,i){t=Ext.max([t,i])};return this.collect(e,i),t<0?null:t}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetailUtil.ReferenceHandler",{singleton:!0,REFERENCE_SOURCE:[{key:SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_IMDB,title:_VST("imdb","title"),url_fn:"getIMDBURL"},{key:SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_ATMOVIE,title:_VST("video_info","source_atmovies"),url_fn:"getATMovieURL"},{key:SYNO.SDS.VideoStation2.Constant.EXTRA.KEY_TMDB,title:_VST("video_info","tmdb"),url_fn:"getTMDBURL"}],getIMDBURL:function(t){return String.format("http://www.imdb.com/title/{0}",t)},getATMovieURL:function(t){return String.format("http://synology.atmovies.com.tw:8088/film/?sid={0}",t)},getTMDBURL:function(t){return String.format("https://www.themoviedb.org/movie/{0}",t)}}),Ext.define("SYNO.SDS.VideoStation2.GridPanel",{extend:"SYNO.ux.GridPanel",xtype:"syno_vs_gridpanel",constructor:function(){this.callParent(arguments),this.addClass("syno-vs2-gridpanel")}}),Ext.define("SYNO.SDS.VideoStation2.PagingToolbar",{extend:"SYNO.ux.PagingToolbar",xtype:"syno_vs_paging",constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-paging")}}),Ext.define("SYNO.SDS.VideoStation2.InternetSearchDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",type:null,defaultQuery:null,onVideoMetadataSelected:Ext.emptyFn,constructor:function(t){var e=t.type||this.type,i={title:_VST("action","search_correct"),layout:"border",cls:"internet-search-dialog",width:800,height:400,minWidth:200,minHeight:200,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",disabled:!0,scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancelBtn})],items:[this.form=new SYNO.SDS.VideoStation2.InternetSearchDialog.Form({enableEpisodeField:SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE===e,region:"north"}),this.grid=new SYNO.SDS.VideoStation2.InternetSearchDialog.Grid({enableEpisodeField:SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE===e,store:this.getStore(),region:"center"})],listeners:{scope:this,afterrender:this.onAfterRender,beforedestroy:this.onBeforeDestory,show:{fn:this.onShow,single:!0}}};this.callParent([Ext.apply(i,t)]),this.mon(this.form,SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SEARCH,this.onSearch,this),this.mon(this.grid,SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_CHOOSE,this.onOKBtn,this),this.mon(this.grid,SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_SELECTION_CHANGE,this.onSelectionChange,this)},getStore:function(){return this.store=this.store||new SYNO.SDS.VideoStation2.Stores.internet_search({remoteSort:!1,listeners:{scope:this,load:this.onLoadStore}}),this.store},clearPollingTask:function(){this.currentPollingTask&&(SYNO.SDS.VideoStation2.OP.abort(this.currentPollingTask),SYNO.SDS.VideoStation2.OP.get().stopSearchMetadata({task_id:this.currentPollingTask.params.task_id},{}),this.start_time=0,this.currentPollingTask=null)},clearMetaRequest:function(){this.metaRequest&&(SYNO.SDS.VideoStation2.OP.abort(this.metaRequest),this.metaRequest=null)},getStoreState:function(){return this.grid.getStoreState()},updateStore:function(t,e){var i=this.getStore();i.storeOptions({params:e});var o=i.reader.readRecords(t);i.loadRecords(o,{add:!1,params:e},!0)},showStatusBusy:function(){this.setStatus({text:_T("common","loading"),iconCls:"syno-ux-statusbar-loading"})},hideStatusBusy:function(){this.clearStatus()},formMetadata:function(t){var e=new SYNO.SDS.VideoStation2.ViewDetailUtil.PlusInfoHandler({plus_info:t.extra});return{additional:{actor:t.actor,director:t.director,genre:t.genre,writer:t.writer,summary:t.summary,extra:t.extra,tvshow_extra:t.tvshow_extra,tvshow_summary:t.tvshow_summary},title:t.title,certificate:t.certificate,rating:10*e.calculateMaxRating(),tagline:t.tag_line,original_available:t.original_available,tvshow_original_available:t.tvshow_original_available,episode:parseInt(t.episode,10),season:parseInt(t.season,10),update_tvshow:this.form.getValues().preferlanguage,from_internet:!0}},correctTVShowMetadata:function(t){this.setStatusBusy(),SYNO.SDS.VideoStation2.OP.get().querySearchMetadata({id:this.getStore().baseParams.id,type:this.type,data:t},{scope:this,success:this.onCorrectTVShowMetadata,failure:this.onRequestFail})},onBeforeDestory:function(){this.getStore().destroy()},onAfterRender:function(){this.form.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SET_QUERY,this.defaultQuery)},onShow:function(){SYNO.SDS.VideoStation2.Util.maskInfo(this.grid,_VST("search","desc"))},onCancelBtn:function(){this.clearMetaRequest(),this.clearPollingTask(),this.close()},onOKBtn:function(){var t=this.grid.getSelected();if(t){if(this.type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE)return void this.correctTVShowMetadata(t.data);this.onVideoMetadataSelected(this.formMetadata(t.data)),this.clearMetaRequest(),this.clearPollingTask(),this.close()}},onSearch:function(){SYNO.SDS.VideoStation2.Util.unmask(this.grid),this.setStatusBusy(),this.clearMetaRequest(),this.clearPollingTask(),this.metaRequest=SYNO.SDS.VideoStation2.OP.get().startSearchMetadata(Ext.apply({type:this.type},{query:this.form.getValues().title,prefer_lang:this.form.getValues().preferlanguage,season:parseInt(this.form.getValues().season,10),episode:parseInt(this.form.getValues().episode,10)}),{scope:this,success:this.onStartSearchMetadata,failure:this.onRequestFail})},onStartSearchMetadata:function(t,e,i){this.getStore().baseParams.task_id=t.id,this.startPolling(),this.clearStatusBusy(),this.showStatusBusy()},startPolling:function(){this.start_time=(new Date).getTime(),this.currentPollingTask=SYNO.SDS.VideoStation2.OP.get().listSearchMetadata(this.getStoreState(),{scope:this,success:this.onPollingSuccess,failure:this.onRequestFail}),this.currentPollingTask.params=this.getStoreState()},onPollingSuccess:function(t,e,i){var o=(new Date).getTime();if(this.updateStore(t,e),"updated"===t.status)return void this.hideStatusBusy();setTimeout(this.startPolling.createDelegate(this),this.getPollingDelayTime(this.start_time,o,3e3))},onRequestFail:function(t,e,i){this.clearStatusBusy(),this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(t)}),this.clearMetaRequest(),this.clearPollingTask()},onLoadStore:function(){var t=this.getStore(),e=this.grid.enableEpisodeField?["title","season","episode","summary"]:["title","summary"];t.sort(e.map(function(t){return{field:t,direction:"asc"}}),"asc")},onCorrectTVShowMetadata:function(t,e,i){this.clearStatusBusy(),this.onVideoMetadataSelected(this.formMetadata(t.result)),this.clearMetaRequest(),this.clearPollingTask(),this.close()},onSelectionChange:function(t){this.okBtn.setDisabled(!t)},getPollingDelayTime:function(t,e,i){var o=e-t;return o>i?0:i-o}}),Ext.define("SYNO.SDS.VideoStation2.InternetSearchDialog.Form",{statics:{EVENT_SEARCH:"search",EVENT_SET_QUERY:"setquery"},extend:"SYNO.SDS.VideoStation2.FormPanel",enableEpisodeField:!1,constructor:function(t){var e=t.enableEpisodeField||this.enableEpisodeField,i={defaults:{anchor:"100%"},updateFormForScrollbar:!0,height:40,items:[{xtype:"syno_compositefield",hideLabel:!0,items:[{xtype:"container",height:32,layout:"fit",flex:2,items:[{xtype:"syno_vs_textfilter",name:"title",itemId:"title",hideLabel:!0,allowBlank:!1,listeners:{scope:this,keypress:this.onFieldKeypress,invalid:this.onInvalid,valid:this.onValid}}]},{xtype:"syno_vs_displayfield",margins:"0 3 0 3",hideLabel:!0,value:_VST("language","title")+": "},{xtype:"syno_vs_combobox",name:"preferlanguage",itemId:"preferlanguage",hideLabel:!0,displayField:"display",valueField:"value",store:SYNO.SDS.VideoStation2.Util.getLangStore(),value:SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","search_lang")||"enu",flex:1,listeners:{scope:this,change:function(t,e,i){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","search_lang",e)}}},{xtype:"syno_vs_displayfield",margins:"0 3 0 3",hideLabel:!0,value:_VST("season","season_title")+": ",hidden:!e},{xtype:"syno_vs_numberfield",name:"season",itemId:"season",hideLabel:!0,allowBlank:!0,allowNegative:!1,allowDecimals:!1,disabled:!e,hidden:!e,flex:1,enableKeyEvents:!0,listeners:{scope:this,keypress:this.onFieldKeypress}},{xtype:"syno_vs_displayfield",margins:"0 3 0 3",hideLabel:!0,value:_VST("episode","episode_title")+": ",hidden:!e},{xtype:"syno_vs_numberfield",name:"episode",itemId:"episode",hideLabel:!0,allowBlank:!0,allowNegative:!1,allowDecimals:!1,disabled:!e,hidden:!e,flex:1,enableKeyEvents:!0,listeners:{scope:this,keypress:this.onFieldKeypress}},this.getSearchBtn()]}]};this.callParent([Ext.apply(i,t)]),this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SEARCH),this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SET_QUERY),this.mon(this,SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SET_QUERY,this.onSetQuery,this)},onInvalid:function(t,e){this.searchBtn.setDisabled(!0)},onValid:function(){this.searchBtn.setDisabled(!1)},onFieldKeypress:function(t,e){e.getKey()===Ext.EventObject.ENTER&&(e.stopEvent(),this.fireSearch())},onSetQuery:function(t){this.getForm().setValues(t)},getSearchBtn:function(){return this.searchBtn=this.searchBtn||new SYNO.SDS.VideoStation2.Button({text:_VST("search","title"),scope:this,handler:this.fireSearch}),this.searchBtn},getValues:function(){return this.getForm().getValues()},fireSearch:function(){this.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Form.EVENT_SEARCH)}}),Ext.define("SYNO.SDS.VideoStation2.InternetSearchDialog.Grid",{statics:{EVENT_SELECTION_CHANGE:"selectionchange",EVENT_CHOOSE:"choose"},extend:"SYNO.SDS.VideoStation2.GridPanel",pageSize:500,enableEpisodeField:!1,constructor:function(t){var e=t.enableEpisodeField||this.enableEpisodeField,i={enableHdMenu:!1,viewConfig:{trackResetOnLoad:!1},bbar:new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:this.pageSize,store:t.store,displayInfo:!0,showRefreshBtn:!0}),colModel:new Ext.grid.ColumnModel({columns:[{header:_VST("common","title"),dataIndex:"title",sortable:!0},{header:e?String.format("{0} ({1})",_VST("original_available","title"),_VST("type","tv_show")):_VST("original_available","title"),dataIndex:e?"tvshow_original_available":"original_available",sortable:!0},{header:_VST("episode","name_title"),dataIndex:"tag_line",sortable:!0,hidden:!e},{header:_VST("season","season_title"),dataIndex:"season",sortable:!0,hidden:!e},{header:_VST("episode","episode_title"),dataIndex:"episode",sortable:!0,hiddne:!e},{header:e?String.format("{0} ({1})",_VST("summary","title"),_VST("episode","episode_title")):_VST("summary","title"),sortable:!0,dataIndex:"summary"}]}),selModel:new Ext.grid.RowSelectionModel({singleSelect:!0,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,rowdblclick:this.onRowDBLClick}};this.callParent([Ext.apply(i,t)]),this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_SELECTION_CHANGE),this.addEvents(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_CHOOSE)},getSelected:function(){return this.getSelectionModel().getSelected()},getStoreState:function(){var t=this.getStore(),e=t.getSortState(),i={};return i[t.paramNames.start]=this.getBottomToolbar().cursor,i[t.paramNames.limit]=this.getBottomToolbar().pageSize,e&&(i[t.paramNames.sort]="tvshow_original_available"==e.field.toLowerCase()?"original_available":e.field.toLowerCase(),i[t.paramNames.dir]=e.direction.toLowerCase()),i.task_id=t.baseParams.task_id,i},onRowSelectionChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_SELECTION_CHANGE,this.getSelected())},onRowDBLClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.InternetSearchDialog.Grid.EVENT_CHOOSE)}}),Ext.define("SYNO.SDS.VideoStation2.VideoMetadataChooseDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",type:null,library_id:null,defaultQuery:null,pageSize:500,onVideoMetadataSelected:Ext.emptyFn,constructor:function(t){t.type=SYNO.SDS.VideoStation2.Util.getLibraryTypeByVideoType(t.type);var e={title:_VST("action","select_db"),layout:"border",cls:"video-metadata-choose-dialog",width:800,height:400,minWidth:200,minHeight:200,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",disabled:!0,scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.form=new SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form({region:"north"}),this.grid=new SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid({pageSize:this.pageSize,store:this.getStore(t),region:"center"})],listeners:{scope:this,beforedestroy:this.onBeforeDestory}};this.callParent([Ext.apply(e,t)]),this.mon(this.form,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SEARCH,this.onSearch,this),this.mon(this.grid,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_CHOOSE,this.onOKBtn,this),this.mon(this.grid,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_SELECTION_CHANGE,this.onSelectionChange,this)},getStore:function(t){if(!this.store){var e=t.type||this.type;this.store=new SYNO.SDS.VideoStation2.Stores[e]({autoLoad:!0,listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}}),this.store.on("beforeload",this.onFirstBeforeLoadStore,this,{single:!0})}return this.store},onBeforeDestory:function(){this.getStore().destroy()},onFirstBeforeLoadStore:function(){this.form.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SET_QUERY,this.defaultQuery)},onOKBtn:function(){var t=this.grid.getSelected();t&&(this.onVideoMetadataSelected(t.data),this.close())},onSearch:function(){this.getStore().load()},onBeforeLoadStore:function(t,e){this.setStatusBusy();var i=e.params;i.additional=SYNO.SDS.VideoStation2.Constant.ADDITIONAL_DICT[this.type],i.library_id=this.library_id,Ext.apply(i,this.form.getValues());var o={};o[t.paramNames.start]=0,o[t.paramNames.limit]=this.pageSize,Ext.applyIf(i,o)},onLoadStore:function(){this.clearStatusBusy()},onSelectionChange:function(t){this.okBtn.setDisabled(!t)}}),Ext.define("SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form",{statics:{EVENT_SEARCH:"search",EVENT_SET_QUERY:"setquery"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e={defaults:{anchor:"100%"},updateFormForScrollbar:!0,height:40,items:[{xtype:"syno_compositefield",hideLabel:!0,items:[{xtype:"container",height:32,layout:"fit",flex:1,items:[{xtype:"syno_vs_textfilter",name:"keyword",itemId:"keyword",hideLabel:!0,listeners:{scope:this,keypress:this.onFieldKeypress}}]},{xtype:"syno_vs_button",text:_VST("search","title"),scope:this,handler:this.fireSearch}]}]};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SEARCH),this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SET_QUERY),this.mon(this,SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SET_QUERY,this.onSetQuery,this)},onFieldKeypress:function(t,e){e.getKey()===Ext.EventObject.ENTER&&this.fireSearch()},onSetQuery:function(t){this.getForm().setValues({keyword:t.title})},getValues:function(){var t=this.getForm().getValues();return Ext.isEmpty(t.keyword)&&delete t.keyword,t},fireSearch:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Form.EVENT_SEARCH)}}),Ext.define("SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid",{statics:{EVENT_SELECTION_CHANGE:"selectionchange",EVENT_CHOOSE:"choose"},extend:"SYNO.SDS.VideoStation2.GridPanel",constructor:function(t){var e={enableHdMenu:!1,viewConfig:{trackResetOnLoad:!1},bbar:new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:t.pageSize,store:t.store,displayInfo:!0,showRefreshBtn:!0}),colModel:new Ext.grid.ColumnModel({defaultSortable:!0,columns:[{header:_VST("common","title"),dataIndex:"title"},{header:_VST("original_available","title"),dataIndex:"original_available"},{header:_VST("summary","title"),dataIndex:"additional",renderer:function(t,e){var i=t.summary||"";return e.attr=String.format('ext:qtip="{0}"',Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(i))),Ext.util.Format.htmlEncode(i)}}]}),selModel:new Ext.grid.RowSelectionModel({singleSelect:!0,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,rowdblclick:this.onRowDBLClick}};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_SELECTION_CHANGE),this.addEvents(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_CHOOSE)},getSelected:function(){return this.getSelectionModel().getSelected()},onRowSelectionChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_SELECTION_CHANGE,this.getSelected())},onRowDBLClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoMetadataChooseDialog.Grid.EVENT_CHOOSE)}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadata.Toolbar",{statics:{EVENT_RESET:"reset",EVENT_IMPORT_METADATA:"importmetadata",EVENT_INTERNET_SEARCH:"internetsearch"},extend:"SYNO.ux.Toolbar",video:null,disableInternetSearch:!1,disableSelectFromExisting:!1,onBeforeOpenDialog:Ext.emptyFn,constructor:function(t){var e=t.disableInternetSearch||this.disableInternetSearch,i=t.disableSelectFromExisting||this.disableSelectFromExisting,o={items:[this.internetSearchBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","search_correct"),handler:this.onInternetSearchBtnClick,scope:this,hidden:e}),this.videoMetadataChooseBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","select_db"),
handler:this.onVideoMetadataChooseBtnClick,scope:this,hidden:i}),this.resetBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","reset"),handler:this.onResetBtnClick,scope:this})]};this.callParent([Ext.apply(o,t)]),this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_RESET),this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_IMPORT_METADATA),this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_INTERNET_SEARCH),e||this.mon(this,SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_INTERNET_SEARCH,this.onInternetSearchBtnClick,this)},onResetBtnClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_RESET)},onInternetSearchBtnClick:function(){new SYNO.SDS.VideoStation2.InternetSearchDialog({type:this.video.type,owner:this.owner,defaultQuery:this.onBeforeOpenDialog(),onVideoMetadataSelected:this.onVideoMetadataSelected.createDelegate(this)}).open()},onVideoMetadataChooseBtnClick:function(){new SYNO.SDS.VideoStation2.VideoMetadataChooseDialog({type:this.video.type,library_id:this.video.library_id,owner:this.owner,defaultQuery:this.onBeforeOpenDialog(),onVideoMetadataSelected:this.onVideoMetadataSelected.createDelegate(this)}).open()},onVideoMetadataSelected:function(t){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_IMPORT_METADATA,t)}}),Ext.define("SYNO.SDS.VideoStation2.Radio",{extend:"SYNO.ux.Radio",xtype:"syno_vs_radio",checkIconCls:"syno-vs2-radio syno-ux-radio-icon",constructor:function(t){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.RadioGroup",{extend:"SYNO.ux.RadioGroup",xtype:"syno_vs_radiogroup",defaultType:"syno_vs_radio",constructor:function(t){this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadata.Source",{extend:"SYNO.SDS.VideoStation2.Button",constructor:function(t){var e={text:_VST("video_info","source"),scope:this,handler:this.onClick};this.callParent([Ext.apply(e,t)])},onClick:function(){new SYNO.SDS.VideoStation2.SourceDialog({owner:this.owner}).open()}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadata.FileSelect",{statics:{EVENT_FILE_CHOOSE:"filechoose"},extend:"SYNO.SDS.VideoStation2.Button",gotoPath:null,constructor:function(t){var e={text:_VST("common","select"),scope:this,handler:this.onFileButtonClick};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.FileSelect.EVENT_FILE_CHOOSE)},setGotoPath:function(t){this.gotopath=t},onFileButtonClick:function(){var t={owner:SYNO.SDS.VideoStation2.Window};this.gotopath&&(t.gotoPath=this.gotopath);var e=new SYNO.SDS.VideoStation2.ImageSelector(t);e.mon(e,"choose",function(t){this.onImageChoose(t),e.close()},this),e.open()},onImageChoose:function(t){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.FileSelect.EVENT_FILE_CHOOSE,t)}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadata.MetaSelector",{extend:"SYNO.SDS.VideoStation2.SuperBox",type:null,library_id:null,category:null,owner:null,constructor:function(t){var e=t.category||this.category,i={valueField:"key",displayField:"key",triggerAction:"all",mode:"remote",minChars:1,allowQueryAll:!0,pageSize:300,editable:!0,grow:!0,queryParam:"match",allowAddNewData:!0,addNewDataOnBlur:!0,valueDelimiter:"|",fieldLabel:SYNO.SDS.VideoStation2.Util.getFilterCategoryString(e),store:this.getStore()};this.callParent([Ext.apply(i,t)]),this.mon(this,"newitem",this.onNewItem,this)},getStore:function(t){return this.store=this.store||new SYNO.SDS.VideoStation2.Stores.filter({listeners:{scope:this,beforeload:this.onBeforeLoadStore}}),this.store},onBeforeLoadStore:function(t,e){var i=e.params;Ext.apply(i,{type:this.type,library_id:[this.library_id],category:this.category,sort_by:this.category,sort_direction:"asc"})},onNewItem:function(t,e){t.addNewItem({key:e},!0)}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",{statics:{EVENT_META_LOADED:"metaloaded",EVENT_IMAGE_CHANGE:"imagechange",EVENT_POSTER_SET:"posterset",EVENT_BACKDROP_SET:"backdropset"},extend:"SYNO.SDS.VideoStation2.FormPanel",disableToolbar:!1,disableInternetSearch:!1,disableSelectFromExisting:!1,allowSeasonEpisodeBlank:!1,video:null,constructor:function(t){var e=t.video||this.video,i=this.disableToolbar?null:new SYNO.SDS.VideoStation2.EditMetadata.Toolbar({video:e,owner:t.owner,disableInternetSearch:this.disableInternetSearch,disableSelectFromExisting:this.disableSelectFromExisting,onBeforeOpenDialog:this.onBeforeOpenToolbarDialog.createDelegate(this)}),o={bodyCssClass:"edit-metadata-meta-panel-body",title:Ext.isNumber(e.file)?_VST("action","correct_metadata"):_VST("metadata","title"),tbar:i,defaults:{anchor:"100%"},updateFormForScrollbar:!0};this.callParent([Ext.apply(o,t)]),this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED),this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_IMAGE_CHANGE),this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_SET),this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_BACKDROP_SET),this.mon(this,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED,this.onMetaLoaded,this),i&&(this.mon(i,SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_RESET,this.onReset,this),this.mon(i,SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_IMPORT_METADATA,this.onImportMetadata,this))},getFileFieldConfig:function(t){var e=t.video||this.video;return[{xtype:"syno_vs_displayfield",fieldLabel:_VST("file","file_name"),name:"filename",itemId:"filename",hidden:!Ext.isNumber(e.file)},{xtype:"syno_vs_displayfield",fieldLabel:_VST("file","file_path"),name:"sharepath",itemId:"sharepath",hidden:!Ext.isNumber(e.file)}]},getChannelFieldConfig:function(t){return[{xtype:"syno_vs_textfield",fieldLabel:_VST("schedule","channel"),name:"channel_name",itemId:"channel_name",readOnly:!0}]},getTitleFieldConfig:function(t){var e=t.video||this.video,i=_VST("common","title");switch(e.type){case SYNO.SDS.VideoStation2.Constant.TVSHOW:case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:i=_VST("tvshow","title");break;case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:i=_VST("programguide","title")}return[{xtype:"syno_vs_textfield",fieldLabel:i,name:"title",itemId:"title",allowBlank:!1,validator:SYNO.SDS.VideoStation2.Util.lengthValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.VIDEO_METADATA_TITLE],!0)}]},getTaglineFieldConfig:function(t){return[{xtype:"syno_vs_textfield",fieldLabel:(t.video||this.video).type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE?_VST("episode","name_title"):_VST("tagline","title"),name:"tagline",itemId:"tagline",validator:SYNO.SDS.VideoStation2.Util.lengthValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.VIDEO_METADATA_TAGLINE],!0)}]},getOriginalAvailableFieldConfig:function(t){return[{xtype:"syno_vs_datefield",fieldLabel:(t.video||this.video).type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE?String.format("{0} ({1})",_VST("original_available","title"),_VST("episode","episode_title")):_VST("original_available","title"),format:SYNO.SDS.DateTimeUtils?void 0:"Y-m-d",name:"original_available",itemId:"original_available",editable:!1}]},getTVShowOriginalAvailableFieldConfig:function(t){return[{xtype:"syno_vs_datefield",fieldLabel:String.format("{0} ({1})",_VST("original_available","title"),_VST("type","tv_show")),format:SYNO.SDS.DateTimeUtils?void 0:"Y-m-d",name:"tvshow_original_available",itemId:"tvshow_original_available",editable:!1}]},getSeasonFieldConfig:function(t){return[{xtype:"syno_vs_numberfield",fieldLabel:_VST("season","season_title"),name:"season",itemId:"season",allowDecimals:!1,allowNegative:!1,allowBlank:this.allowSeasonEpisodeBlank}]},getEpisodeFieldConfig:function(t){return[{xtype:"syno_vs_numberfield",fieldLabel:_VST("episode","episode_title"),name:"episode",itemId:"episode",allowDecimals:!1,allowNegative:!1,allowBlank:this.allowSeasonEpisodeBlank}]},getRecordDateFieldConfig:function(t){return[{xtype:"syno_compositefield",fieldLabel:_VST("video_info","record_time"),itemId:"record_date",items:[{xtype:"syno_vs_datefield",name:"record_date_date",itemId:"record_date_date",format:SYNO.SDS.DateTimeUtils?void 0:"Y-m-d",editable:!1,allowBlank:!1,flex:1},{xtype:"syno_vs_timefield",name:"record_date_time",itemId:"record_date_time",format:"H:i:s",editable:!1,allowBlank:!1,increment:1,flex:1}]}]},getCertificateFieldConfig:function(t){return[{xtype:"syno_vs_textfield",fieldLabel:_VST("metadata","rating_classification"),name:"certificate",itemId:"certificate",validator:SYNO.SDS.VideoStation2.Util.lengthValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.VIDEO_METADATA_CERTIFICATE],!0)}]},getRatingFieldConfig:function(t){return[{xtype:"syno_vs_textfield",fieldLabel:_VST("metadata","rating"),name:"rating",itemId:"rating",validator:this.ratingValidator.createDelegate(this)}]},getMetaSelectors:function(t){if(!this.metaSelectors){var e=t.video||this.video,i={type:e.type,library_id:e.library_id,validator:SYNO.SDS.VideoStation2.Util.lengthValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.VIDEO_METADATA_COMMON_FIELD],!0),listeners:{scope:this,valuechanged:this.doLayout}};this.metaSelectors=[new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,name:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE},i)),new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,name:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR},i)),new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,name:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER},i)),new SYNO.SDS.VideoStation2.EditMetadata.MetaSelector(Ext.apply({category:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,name:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR},i))]}return this.metaSelectors},getMetadataLockFieldConfig:function(t){return[{xtype:"radiogroup",vertical:!1,labelHtmlEncode:!1,fieldLabel:String.format('{0}<img src="webman/resources/images/components/icon_information_mini.png" style="vertical-align:bottom;" border="0" ext:qtip="{1}">',_VST("lock","status"),Ext.util.Format.htmlEncode(_VST("lock","desc"))),itemId:"metadata_locked",items:[{xtype:"syno_vs_radio",boxLabel:_VST("lock","status_lock"),name:"metadata_locked",itemId:"metadata_locked_true",inputValue:"true"},{xtype:"syno_vs_radio",boxLabel:_VST("lock","status_unlock"),name:"metadata_locked",itemId:"metadata_locked_false",inputValue:"false"}]}]},getSummaryFieldConfig:function(t){return[{xtype:"syno_vs_textarea",fieldLabel:_VST("summary","title"),grow:!0,growMax:200,name:"summary",itemId:"summary",validator:SYNO.SDS.VideoStation2.Util.lengthValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.VIDEO_METADATA_SUMMARY],!0),listeners:{scope:this,autosize:this.doLayout}}]},getUpdateTVShowFieldConfig:function(t){return[{xtype:"syno_vs_textfield",name:"update_tvshow",itemId:"update_tvshow",hidden:!0}]},getExtraFieldConfig:function(t){return[{xtype:"syno_vs_textfield",name:"extra",itemId:"extra",hidden:!0}]},getTVShowExtraFieldConfig:function(t){return[{xtype:"syno_vs_textfield",name:"tvshow_extra",itemId:"tvshow_extra",hidden:!0}]},getSourceField:function(t){return this.sourceField||(this.sourceField=new SYNO.ux.CompositeField({hideLabel:!0,itemId:"source",items:[this.getSourceBtn(t)]}),this.sourceField.innerCt.layoutConfig={pack:"end"}),this.sourceField},getSourceBtn:function(t){return this.sourceBtn=this.sourceBtn||new SYNO.SDS.VideoStation2.EditMetadata.Source(t),this.sourceBtn},getBackdropFieldConfig:function(t){return[{xtype:"syno_vs_radiogroup",hideLabel:!0,vertical:!0,itemId:"backdrop",listeners:{scope:this,change:this.fireImageChange},items:[this.getImageOriginalRadio(t),this.getImageOriginalURLHiddenField(t),this.getImageClearRadio(t),this.getImageURLRadio(t),this.getImageURLField(t),this.getImageFileRadio(t),this.getImageFileSelectField(t),this.getImageFileField(t)]}]},getPosterFieldConfig:function(t){return[{xtype:"syno_vs_radiogroup",hideLabel:!0,vertical:!0,itemId:"poster",listeners:{scope:this,change:this.fireImageChange},items:[this.getImageOriginalRadio(t),this.getImageOriginalURLHiddenField(t),this.getImageClearRadio(t),this.getImageURLRadio(t),this.getImageURLField(t),this.getImageFileRadio(t),this.getImageFileSelectField(t),this.getImageFileField(t),{xtype:"syno_vs_displayfield",value:_VST("poster","set_image_desc"),hideLabel:!0}]}]},getImageOriginalRadio:function(t){return this.imageOriginalRadio=this.imageOriginalRadio||new SYNO.SDS.VideoStation2.Radio({boxLabel:_VST("poster","original"),name:"image",itemId:"image_original",inputValue:"original",checked:!0}),this.imageOriginalRadio},getImageURLRadio:function(t){return this.imageURLRadio=this.imageURLRadio||new SYNO.SDS.VideoStation2.Radio({boxLabel:_VST("poster","url"),name:"image",itemId:"image_url",inputValue:"url",listeners:{scope:this,check:function(t,e){this.getImageURLField().setDisabled(!e)}}}),this.imageURLRadio},getImageFileRadio:function(t){return this.imageFileRadio=this.imageFileRadio||new SYNO.SDS.VideoStation2.Radio({boxLabel:_VST("poster","select_existed_image"),name:"image",itemId:"image_file",inputValue:"file",listeners:{scope:this,check:function(t,e){this.getImageFileField().setDisabled(!e),this.getFileSelectTextField().setDisabled(!e),this.getFileSelectBtn().setDisabled(!e)}}}),this.imageFileRadio},getImageClearRadio:function(t){return this.imageClearRadio=this.imageClearRadio||new SYNO.SDS.VideoStation2.Radio({boxLabel:_VST("poster","no_image"),name:"image",itemId:"image_clear",inputValue:"clear"}),this.imageClearRadio},getImageOriginalURLHiddenField:function(t){return this.imageOriginalURLHiddenField=this.imageOriginalURLHiddenField||new SYNO.SDS.VideoStation2.TextField({name:"original_url",itemId:"original_url",vtype:"url",hidden:!0,listeners:{scope:this,change:this.fireImageChange}}),this.imageOriginalURLHiddenField},getImageURLField:function(t){return this.imageURLField=this.imageURLField||new SYNO.SDS.VideoStation2.TextField({name:"url",itemId:"url",indent:1,vtype:"url",allowBlank:!1,disabled:!0,listeners:{scope:this,change:this.fireImageChange}}),this.imageURLField},getImageFileSelectField:function(t){return this.imageFileSelectField=this.imageFileSelectField||new SYNO.ux.CompositeField({hideLabel:!0,name:"file_select",itemId:"file_select",indent:1,items:[this.getFileSelectTextField(t),this.getFileSelectBtn(t)]}),this.imageFileSelectField},getFileSelectTextField:function(t){return this.fileSelectTextField=this.fileSelectTextField||new SYNO.SDS.VideoStation2.TextField({name:"sharepath",itemId:"sharepath",allowBlank:!1,disabled:!0,readOnly:!0,flex:1,listeners:{scope:this,change:this.fireImageChange}}),this.fileSelectTextField},getImageFileField:function(t){return this.imageFileField=this.imageFileField||new SYNO.SDS.VideoStation2.TextField({name:"file",itemId:"file",allowBlank:!1,disabled:!0,readOnly:!0,hidden:!0}),this.imageFileField},getFileSelectBtn:function(t){return this.fileSelectBtn||(this.fileSelectBtn=new SYNO.SDS.VideoStation2.EditMetadata.FileSelect({disabled:!0}),this.fileSelectBtn.mon(this.fileSelectBtn,SYNO.SDS.VideoStation2.EditMetadata.FileSelect.EVENT_FILE_CHOOSE,this.onDSMFileChoose,this)),this.fileSelectBtn},setMetaSelectorsValue:function(t){this.getMetaSelectors().each(function(e){var i=t.additional[e.itemId]||[];e.clearValue(),i.each(function(t){e.addNewItem({key:t})})},this)},maybeSetFileValue:function(t){if(Ext.isNumber(this.video.file)){var e=this.findFileFromData(t);e&&this.getForm().setValues({filename:e.sharepath.substr(e.sharepath.lastIndexOf("/")+1),sharepath:e.sharepath})}},setImageFieldValue:function(t){switch(this.getImageOriginalRadio().setValue(!1),this.getImageURLRadio().setValue(!1),this.getImageFileRadio().setValue(!1),this.getImageClearRadio().setValue(!1),t.image){case"original":this.getImageOriginalRadio().setValue(!0),Ext.isDefined(t.url)&&this.getImageOriginalURLHiddenField().setValue(t.url);break;case"url":this.getImageURLRadio().setValue(!0),this.getImageURLField().setValue(t.url);break;case"file":this.getImageFileRadio().setValue(!0),this.getFileSelectTextField().setValue(t.sharepath),this.getImageFileField().setValue(t.file);break;case"clear":this.getImageClearRadio().setValue(!0)}},getImageFieldValue:function(){var t={};return this.getImageOriginalRadio().getValue()?(t.image=this.getImageOriginalRadio().inputValue,t.url=this.getImageOriginalURLHiddenField().getValue()):this.getImageURLRadio().getValue()?(t.image=this.getImageURLRadio().inputValue,t[this.getImageURLField().name]=this.getImageURLField().getValue()):this.getImageFileRadio().getValue()?(t.image=this.getImageFileRadio().inputValue,t[this.getFileSelectTextField().name]=this.getFileSelectTextField().getValue(),t[this.getImageFileField().name]=this.getImageFileField().getValue()):t.image=this.getImageClearRadio().inputValue,t},findFileFromData:function(t){var e;return Ext.each(t.additional.file,function(t){if(t.id===this.video.file)return e=t,!1},this),e},correctOriginalAvailable:function(t){return Ext.isString(t)?-1===t.indexOf("-")?t+"-01-01":t:""},getRatingSaveValue:function(t){return Ext.isEmpty(t)||t<0||t>100?-1:10*t},getRatingValue:function(t){return t/=10,t<0||t>10?"":t},ratingValidator:function(t){return!!Ext.isEmpty(t)||t>=-1&&t<=10&&/^(10(\.0)?|[0-9](\.[0-9])?)$/.test(t)},fireImageChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_IMAGE_CHANGE)},isDirty:function(){return!SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},isValid:function(){return this.getForm().isValid()},getImportMetadata:function(){return{raw:this.importRaw,value:this.importValue}},getOriValues:function(){return this.oriValue},getValues:Ext.emptyFn,setValues:Ext.emptyFn,isVideoChanged:function(){return!1},hideMetadataLocked:function(){this.getComponent("metadata_locked").hide()},onMetaLoaded:function(t){this.setValues(t),this.oriRaw=t,this.oriValue=this.getValues(),t.hasOwnProperty("metadata_locked")||this.hideMetadataLocked()},onReset:function(){this.setValues(this.oriRaw)},parseImageURL:function(t,e){var i=t.additional.extra,o=SYNO.SDS.VideoStation2.Util.findValueInObject(i,e);if(Ext.isDefined(o)&&(o=o.filter(function(t){return!Ext.isEmpty(t)}),!Ext.isEmpty(o)))return o[0]},onImportMetadata:function(t){this.setValues(t),this.importRaw=t,this.importValue=this.getValues();var e=Ext.isDefined(t.from_internet)&&t.from_internet,i=this.parseImageURL(t,"poster"),o={image:e?Ext.isString(i)?"url":"clear":"original",url:e?Ext.isString(i)?i:"":SYNO.SDS.VideoStation2.Util.getImageURL({type:this.video.type,id:t.id})};this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_SET,o);var n=this.parseImageURL(t,"backdrop"),a={image:e?Ext.isString(n)?"url":"clear":"original",url:e?Ext.isString(n)?n:"":SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:t.mapper_id})};this.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_BACKDROP_SET,a)},onImageError:function(){switch(this.getValues().image){case"url":this.getImageURLField().markInvalid(_VST("error","image_format"));break;case"file":this.getFileSelectTextField().markInvalid(_VST("error","image_format")),this.getImageFileField().markInvalid(_VST("error","image_format"))}},onDSMFileChoose:function(t){this.getFileSelectTextField().setValue(t.get("path")),this.getImageFileField().setValue(t.get("real_path")),this.fireImageChange()},onBeforeOpenToolbarDialog:function(){return this.getValues()}}),Ext.define("SYNO.SDS.VideoStation2.OverwritePolicyDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",statics:{POLICY_SKIP:"skip",POLICY_OVERWRITE:"overwrite"},video:null,onPolicyChoosed:Ext.emptyFn,constructor:function(t){var e=t.video||this.video,i={title:_VST("action","edit_metadata"),layout:"fit",cls:"overwrite-policy-dialog",width:475,height:280,minWidth:475,minHeight:280,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.OverwritePolicyDialog.Panel({video:e})]};this.callParent([Ext.apply(i,t)])},onOKBtn:function(){Ext.isFunction(this.onPolicyChoosed)&&this.onPolicyChoosed.call(this,this.panel.getValues().policy),this.close()}}),Ext.define("SYNO.SDS.VideoStation2.OverwritePolicyDialog.Panel",{video:null,extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e=t.video||this.video,i=e.library_id,o=SYNO.SDS.VideoStation2.Util.getLibraryTypeByVideoType(e.type),n=SYNO.SDS.VideoStation2.Library.get().getLibraryByIDAndType(i,o)||{},a={defaults:{anchor:"100%"},updateFormForScrollbar:!0,items:[{xtype:"syno_vs_displayfield",hideLabel:!0,itemId:"desc",value:String.format(_VST("metadata","duplicate_desc"),n.title)},{xtype:"syno_vs_radiogroup",hideLabel:!0,itemId:"policy",items:[{boxLabel:_VST("metadata","duplicate_keep"),name:"policy",itemId:"policy_skip",inputValue:"skip",checked:!0},{boxLabel:_VST("metadata","duplicate_replace"),name:"policy",itemId:"policy_overwrite",inputValue:"overwrite"}]}]};this.callParent([Ext.apply(a,t)])},getValues:function(){return this.getForm().getValues()}}),Ext.define("SYNO.SDS.VideoStation2.TVShow",{statics:{EVENT_TVSHOW_CHANGED:"tvshowchanged",EVENT_SEASON_CHANGED:"seasonchanged",EVENT_AVAIL_SEASONS_LOADED:"availseasonsloaded",EVENT_TVSHOW_CLEARED:"tvshowcleared",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.TVShow.instance)||(SYNO.SDS.VideoStation2.TVShow.instance=new SYNO.SDS.VideoStation2.TVShow),SYNO.SDS.VideoStation2.TVShow.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.addEvents(SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CHANGED),this.addEvents(SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED),this.addEvents(SYNO.SDS.VideoStation2.TVShow.EVENT_AVAIL_SEASONS_LOADED)},selectTVShow:function(t){SYNO.Assert(Ext.isObject(t),["unexpceted tvshow",t]);var e=this.current_tvshow;this.current_tvshow=t,this.avail_seasons=null,this.current_season=null,this.fireEvent(SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CHANGED,e,t)},updateTVShow:function(t){SYNO.Assert(Ext.isObject(t),["unexpceted tvshow",t]),this.current_tvshow=t},selectSeason:function(t){if(SYNO.Assert(Ext.isNumber(t),String.format("unexpceted season {0}",t)),t!==this.current_season){var e=this.current_season;this.current_season=t,this.fireEvent(SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,e,t)}},setAvailableSeasons:function(t){SYNO.Assert(Ext.isArray(t),["unexpceted seasons",t]),SYNO.ux.Utils.checkObjectConsistency(this.avail_seasons,t)||(this.avail_seasons=t,-1===this.avail_seasons.indexOf(this.current_season)&&(this.current_season=null),null!==this.default_season&&-1!==this.avail_seasons.indexOf(this.default_season)?(this.selectSeason(this.default_season),this.default_season=null):this.selectSeason(t[0]),this.fireEvent(SYNO.SDS.VideoStation2.TVShow.EVENT_AVAIL_SEASONS_LOADED))},setDefaultSeason:function(t){this.default_season=t},getCurrentTVShow:function(){return this.current_tvshow},getCurrentID:function(){SYNO.Assert(Ext.isObject(this.current_tvshow),["unexpceted tvshow",this.current_tvshow]);var t=this.current_tvshow.id;return SYNO.Assert(Ext.isNumber(t),String.format("unexpceted tvshow id {0}",t)),t},getCurrentSeason:function(){return this.current_season},getTotalSeasons:function(){SYNO.Assert(Ext.isObject(this.current_tvshow),["unexpceted tvshow",this.current_tvshow]);var t=this.current_tvshow.additional;SYNO.Assert(Ext.isObject(t),["unexpceted tvshow additional",t]);var e=this.current_tvshow.additional.total_seasons;return SYNO.Assert(Ext.isNumber(e),String.format("unexpceted total seasons {0}",e)),e},getAvailableSeasons:function(){return this.avail_seasons},clearTVShow:function(){this.current_tvshow=null,this.current_season=null,this.default_season=null,this.avail_seasons=null,this.fireEvent(SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CLEARED)},current_tvshow:null,current_season:null,default_season:null,avail_seasons:null}),Ext.define("SYNO.SDS.VideoStation2.File",{statics:{EVENT_FILE_CHANGE:"filechange",EVENT_FILE_LOAD:"fileload",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.File.instance)||(SYNO.SDS.VideoStation2.File.instance=new SYNO.SDS.VideoStation2.File),SYNO.SDS.VideoStation2.File.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments)},loadFile:function(t){SYNO.Assert(Ext.isArray(t)&&!Ext.isEmpty(t),String.format("bad file object array {0}",t)),this.files=t,this.current_idx=null,this.fireEvent(SYNO.SDS.VideoStation2.File.EVENT_FILE_LOAD)},selectFile:function(t){SYNO.Assert(Ext.isNumber(t)&&t>0,"bad file id");try{if(this.getCurrentID()===t)return}catch(t){}this.audiotrack=null,this.subtitle=null,this.current_idx=this.getFileIndexByID(t),this.fireEvent(SYNO.SDS.VideoStation2.File.EVENT_FILE_CHANGE)},selectAudiotrack:function(t){SYNO.Assert(Ext.isNumber(t),String.format("bad audiotrack id ({0})",t)),this.audiotrack=t},selectSubtitle:function(t){SYNO.Assert(Ext.isString(t),String.format("bad subtitle id ({0})",t)),this.subtitle=t},checkSetting:function(t){return Ext.isEmpty(t.subtitle_id)&&(t.subtitle_id=Ext.isString(t.subtitle_id)?"none":""),t},selectSetting:function(t){var e=this.checkSetting(t);this.selectSubtitle(e.subtitle_id),this.selectAudiotrack(e.audio_track)},setPreSelectFile:function(t){this.pre_select_file=t},getFileIndexByID:function(t){var e=null;return Ext.each(this.files||[],function(i,o){if(i.id===t)return e=o,!1}),e},resetSubtitle:function(){this.subtitle=null},resetAudiotrack:function(){this.audiotrack=null},hasMultipleFile:function(){return this.files.length>1},getCurrentID:function(){return SYNO.Assert(Ext.isNumber(this.current_idx)&&Ext.isArray(this.files)&&!Ext.isEmpty(this.files),"file not set"),this.files[this.current_idx].id},getFileByID:function(t){var e=this.getFileIndexByID(t);return Ext.isNumber(e)?SYNO.Util.copy(this.files[e]):null},getAllFiles:function(){return SYNO.Util.copy(this.files)},getPreSelectFile:function(){return this.pre_select_file},getAudiotrack:function(){return this.audiotrack},getSubtitle:function(){return this.subtitle},files:null,current_idx:null,audiotrack:null,pre_select_file:null,subtitle:null}),Ext.define("SYNO.SDS.VideoStation2.Video",{statics:{EVENT_VIDEO_SELECTION_CHANGED:"videoselectionchanged",EVENT_VIDEO_SELECT_MODE_CHANGED:"videoselectmodechanged",EVENT_SELECT_VIDEO:"selectvideo",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Video.instance)||(SYNO.SDS.VideoStation2.Video.instance=new SYNO.SDS.VideoStation2.Video),SYNO.SDS.VideoStation2.Video.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.current_video_selection=[],this.current_videolist=[],this.select_mode=!1},selectVideo:function(t){SYNO.Assert(Ext.isObject(t)&&Ext.isNumber(t.id)&&t.id>0&&Ext.isString(t.type),String.format("bad video object {0}",t)),this.video=t,this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_SELECT_VIDEO)},clearVideo:function(){this.video={},this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_SELECT_VIDEO)},addVideoSelection:function(t,e,i,o,n,a,S){SYNO.Assert(Ext.isNumber(t)&&t>0&&Ext.isString(i),String.format("unexpceted video info {0}:{1}",t,i)),this.hasVideoSelection(t,e,i,o)||(this.current_video_selection.push({id:t,type:i,mapper_id:e,file:o,playlists:n,season_episode:a,library_id:S}),this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED))},removeVideoSelection:function(t,e,i,o){SYNO.Assert(Ext.isNumber(t)&&t>0&&Ext.isString(i),String.format("unexpceted video info {0}:{1}",t,i)),this.hasVideoSelection(t,e,i,o)&&(this.current_video_selection=this.current_video_selection.filter(function(n){return n.id!==t||n.type!==i||n.mapper_id!==e||n.file!==o}),this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED))},hasVideoSelection:function(t,e,i,o){SYNO.Assert(Ext.isNumber(t)&&t>0&&Ext.isString(i),String.format("unexpceted video info {0}:{1}",t,i));var n=!1;return Ext.each(this.current_video_selection,function(a){if(a.id===t&&a.type===i&&a.mapper_id===e&&a.file===o)return n=!0,!1}),n},toggleVideoSelection:function(t,e,i,o,n,a,S){SYNO.Assert(Ext.isNumber(t)&&t>0&&Ext.isString(i),String.format("unexpceted video info {0}:{1}",t,i)),this.hasVideoSelection(t,e,i,o)?this.removeVideoSelection(t,e,i,o):this.addVideoSelection(t,e,i,o,n,a,S)},clearVideoSelection:function(){0!==this.current_video_selection.length&&(this.current_video_selection=[],this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED))},enterSelectMode:function(){this.select_mode||(this.select_mode=!0,this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED))},leaveSelectMode:function(){this.select_mode&&(this.select_mode=!1,this.fireEvent(SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED))},setVideoListProxy:function(t){SYNO.Assert(Ext.isObject(t),["unexpceted videoListProxy",t]),this.videoListProxy=t,this.setVideolist(this.videoListProxy.videolist)},setVideolist:function(t){SYNO.Assert(Ext.isArray(t),["unexpceted video list",t]),this.current_videolist=t},clearVideolist:function(){this.videoListProxy=null,this.current_videolist=[]},getCurrentID:function(){return this.video.id},getCurrentType:function(){return this.video.type},getCurrentVideo:function(){return SYNO.Util.copy(this.video)},getIdxInVideolist:function(t,e,i){var o=-1;return Ext.each(this.current_videolist,function(n,a){if(n.id===t&&n.type===e&&(!Ext.isDefined(n.file)||n.file===i))return o=a,!1}),o},getNextFromVideolist:function(){var t=SYNO.SDS.VideoStation2.File.get().getPreSelectFile(),e=this.getIdxInVideolist(this.video.id,this.video.type,t);if(-1!==e)return e===this.current_videolist.length-1?void this.videoListProxy.expandRight():this.current_videolist[e+1]},getPrevFromVideolist:function(){var t=SYNO.SDS.VideoStation2.File.get().getPreSelectFile(),e=this.getIdxInVideolist(this.video.id,this.video.type,t);if(-1!==e)return 0===e?void this.videoListProxy.expandLeft():this.current_videolist[e-1]},getCurrentPathTitle:function(){return this.video.pathTitle},getCurrentVideoSelection:function(){return this.current_video_selection},isVideoSelectionEmpty:function(){return Ext.isEmpty(this.current_video_selection)},isInSelectMode:function(){return this.select_mode},video:{},current_video_selection:null,select_mode:null,current_videolist:null}),Ext.define("SYNO.SDS.VideoStation2.TabPanel",{extend:"SYNO.ux.TabPanel",xtype:"syno_vs_tabpanel",constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-tabpanel")}}),Ext.define("SYNO.SDS.VideoStation2.ActivablePanel",{extend:"SYNO.ux.Panel",constructor:function(t){var e=Ext.apply({},t);e.listeners=Ext.apply({scope:this,activate:this.onActivate.createDelegate(this),deactivate:this.onDeactivate.createDelegate(this)},t.listeners),this.callParent([e]),this.items&&this.items.each(function(t){t.relayEvents(this,["activate","deactivate"])},this)},onActivate:Ext.emptyFn,onDeactivate:Ext.emptyFn}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",video:null,multipleTVShowEpisodes:!1,onVideoMetadataEdited:Ext.emptyFn,constructor:function(t){var e=this.video=t.videos[0]||this.video;this.multipleTVShowEpisodes=e.type===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE&&t.videos.length>1,this.correct_info=Ext.isNumber((e||{}).file);var i={title:this.correct_info?_VST("action","correct_metadata"):_VST("action","edit_metadata"),layout:"fit",cls:"edit-meta-dialog",width:690,height:580,minWidth:400,minHeight:280,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({
text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancelBtn})],listeners:{scope:this,afterrender:this.onAfterRender},items:[this.panel=new SYNO.SDS.VideoStation2.EditMetadataDialog.Panel({video:e,multipleTVShowEpisodes:this.multipleTVShowEpisodes,owner:this})]};this.callParent([Ext.apply(i,t)])},maybeShowApplyConfirm:function(){if(this.multipleTVShowEpisodes)return void(this.panel.isVideoChanged()&&this.applyMultipleEpisodes());if(!this.correct_info)return void this.maybeApplyMetadata();if(this.panel.isVideoChanged())return void this.maybeApplyMetadata();var t=this.panel.getOriValues(),e=String.format(_VST("metadata","correct_metadata_confirm"),t.meta.title);this.getMsgBox().confirm(this.title,e,function(t){"yes"===t&&this.maybeApplyMetadata()},this)},applyMultipleEpisodes:function(){this.setStatusBusy();var t=this.panel.getValues().meta,e=this.videos,i=[];Ext.each(e,function(o,n){var a=Ext.copyTo({id:o.id},t,"title,tvshow_original_available,original_available,metadata_locked");a.season=""===t.season.trim()?e[n].season_episode.season:parseInt(t.season,10),a.episode=""===t.episode.trim()?e[n].season_episode.episode:parseInt(t.episode,10),i.push(a)},this),SYNO.SDS.VideoStation2.OP.get().editMetadataAdv({library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID(),episode:i},{scope:this,success:this.onEditMetadata,failure:this.onRequestFail})},maybeApplyMetadata:function(){this.setStatusBusy();var t=this.panel.getValues();if(!t.meta)return void this.maybeApplyPoster();var e=this.panel.getImportMetadata().meta,i=e.raw,o=e.value;if(i&&!i.from_internet&&SYNO.ux.Utils.checkObjectConsistency(o,t.meta))return void this.applyMetadataWithOverwrite(SYNO.SDS.VideoStation2.OverwritePolicyDialog.POLICY_SKIP);var n=Ext.apply(this.getIDParameter(),t.meta);SYNO.SDS.VideoStation2.OP.get().editMetadata(n,{scope:this,success:this.maybeApplyPoster,failure:this.onApplyMetadataFail},this.video.type)},applyMetadataWithOverwrite:function(t){this.setStatusBusy();var e=this.panel.getValues(),i=Ext.apply(this.getIDParameter(),e.meta,{overwrite:t});SYNO.SDS.VideoStation2.OP.get().editMetadata(i,{scope:this,success:this.maybeApplyPoster,failure:this.onRequestFail},this.video.type)},maybeApplyPoster:function(t){t&&(this.correct_info?this.video.file=t.id:this.video.id=t.id);var e=this.panel.getValues();if(!e.poster||"original"===e.poster.image)return void this.maybeApplyBackdrop();var i=this.getPosterParameter(e.poster),o="clear"===e.poster.image?"deletePoster":"setPoster";SYNO.SDS.VideoStation2.OP.get()[o](i,{scope:this,success:this.maybeApplyBackdrop,failure:this.onRequestFail})},maybeApplyBackdrop:function(){var t=this.panel.getValues();if(!t.backdrop||"original"===t.backdrop.image)return void this.onEditMetadata();var e=Ext.apply(this.getBackdropParameter(),t.backdrop);Ext.apply(e,{keep_one:!0});var i;"clear"!==t.backdrop.image?i="setBackdrop":(i="deleteAllBackdrop",Ext.apply(e,{mapper_id:this.video.mapper_id})),SYNO.SDS.VideoStation2.OP.get()[i](e,{scope:this,success:this.onEditMetadata,failure:this.onRequestFail})},getIDParameter:function(){var t={library_id:this.video.library_id};return this.correct_info?(t.target="file",t.file_id=this.video.file):(t.target="video",t.id=this.video.id),t},getBackdropParameter:function(){return{id:this.correct_info?this.video.file:this.video.id,type:this.correct_info?"video":this.video.type}},getPosterParameter:function(t){var e={id:this.correct_info?this.video.file:this.video.id,type:this.correct_info?"video":this.video.type};return"url"==t.image&&(e.target="url",e.url=t.url),"file"==t.image&&(e.target="file",e.sharepath=t.file),e},onOKBtn:function(){this.panel.isValid()&&(this.panel.isDirty()||this.close(),this.maybeShowApplyConfirm())},onCancelBtn:function(){if(!this.panel.isDirty())return void this.close();this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(t){"yes"===t&&this.close()},this)},onApplyMetadataFail:function(t,e,i){if(600!==t.code)return void this.onRequestFail(t,e,i);this.clearStatusBusy(),new SYNO.SDS.VideoStation2.OverwritePolicyDialog({owner:this,video:this.video,onPolicyChoosed:this.applyMetadataWithOverwrite.createDelegate(this)}).open()},onEditMetadata:function(){this.clearStatusBusy(),Ext.isFunction(this.onVideoMetadataEdited)&&this.onVideoMetadataEdited(),SYNO.SDS.VideoStation2.Video.get().isInSelectMode()&&(SYNO.SDS.VideoStation2.Video.get().clearVideoSelection(),SYNO.SDS.VideoStation2.Video.get().leaveSelectMode()),this.close()},onAfterRender:function(){this.multipleTVShowEpisodes?this.panel.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED,this.getMultipleVideoInfo()):this.loadSingleVideoInfo()},getMultipleVideoInfo:function(){var t=SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow(),e={season:"",episode:"",type:SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE,tvshow_original_available:t.original_available,title:t.title},i=Ext.pluck(this.videos,"season_episode");return 1===Ext.unique(Ext.pluck(i,"season")).length&&(e.season=this.video.season_episode.season),1===Ext.unique(Ext.pluck(i,"episode")).length&&(e.episode=this.video.season_episode.episode),e},loadSingleVideoInfo:function(){this.setStatusBusy(),SYNO.SDS.VideoStation2.OP.get().getInfo({id:[this.video.id],additional:SYNO.SDS.VideoStation2.Constant.ADDITIONAL_DICT[this.video.type]},{scope:this,success:this.onInfoLoaded,failure:this.onRequestFail},this.video.type)},onInfoLoaded:function(t,e,i){var o=t[SYNO.SDS.VideoStation2.Util.getVideoRoot(this.video.type)][0];Ext.isObject(o.additional)&&(o.additional.extra&&(o.additional.extra=Ext.decode(o.additional.extra)),o.additional.tvshow_extra&&(o.additional.tvshow_extra=Ext.decode(o.additional.tvshow_extra))),this.clearStatusBusy(),this.panel.fireEvent(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED,o)},onRequestFail:function(t,e,i){this.clearStatusBusy(),this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(t)})}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.Panel",{extend:"SYNO.SDS.VideoStation2.TabPanel",video:null,multipleTVShowEpisodes:!1,constructor:function(t){var e=t.video||this.video,i=t.multipleTVShowEpisodes||this.multipleTVShowEpisodes,o=[],n=[],a=[];switch(e.type){case SYNO.SDS.VideoStation2.Constant.MOVIE:o=new SYNO.SDS.VideoStation2.EditMetadataDialog.MovieMetaPanel({video:e,owner:t.owner,itemId:"meta"});break;case SYNO.SDS.VideoStation2.Constant.TVSHOW:o=new SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowMetaPanel({video:e,owner:t.owner,itemId:"meta"});break;case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:o=i?new SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowMultipleEpisodeMetaPanel({video:e,owner:t.owner,itemId:"meta"}):new SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowEpisodeMetaPanel({video:e,owner:t.owner,itemId:"meta"});break;case SYNO.SDS.VideoStation2.Constant.HOME_VIDEO:o=new SYNO.SDS.VideoStation2.EditMetadataDialog.HomeVideoMetaPanel({video:e,owner:t.owner,itemId:"meta"});break;case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:o=new SYNO.SDS.VideoStation2.EditMetadataDialog.TVRecordingMetaPanel({video:e,owner:t.owner,itemId:"meta"})}e.type===SYNO.SDS.VideoStation2.Constant.TV_RECORDING||i||(n=new SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel({video:e,owner:t.owner,itemId:"poster"}),n.mon(o,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_POSTER_SET,n.onImageSet,n)),e.type!==SYNO.SDS.VideoStation2.Constant.MOVIE&&e.type!==SYNO.SDS.VideoStation2.Constant.TVSHOW||(a=new SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel({video:e,owner:t.owner,itemId:"backdrop"}),a.mon(o,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_BACKDROP_SET,a.onImageSet,a));var S={activeTab:0,items:[o,n,a]};this.callParent([Ext.apply(S,t)]),this.addEvents(SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED),this.items.each(function(t){t.relayEvents(this,[SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED])},this)},isValid:function(){var t,e=!0;return this.items.each(function(i){(t=i.isValid())||this.setActiveTab(i),e=t&&e},this),e},isDirty:function(){var t=!1;return this.items.each(function(e){return!(t=t||e.isDirty())},this),t},isVideoChanged:function(){var t=!1;return this.items.each(function(e){return!(t=t||e.isVideoChanged())},this),t},getImportMetadata:function(){var t={};return this.items.each(function(e){t[e.itemId]=e.getImportMetadata()},this),t},getValues:function(){var t={};return this.items.each(function(e){e.isDirty()&&(t[e.itemId]=this.serializedValues(e.getValues()))},this),t},getOriValues:function(){var t={};return this.items.each(function(e){t[e.itemId]=e.getOriValues()},this),t},serializedValues:function(t){if(!Ext.isObject(t))return t;var e={};return Ext.iterate(t,function(t,i){Ext.isArray(i)||"actor"!==t&&"genre"!==t&&"writer"!==t&&"director"!==t?e[t]=i:e[t]=[i]}),e}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.MovieMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(t){var e={items:[this.getFileFieldConfig(t),this.getTitleFieldConfig(t),this.getTaglineFieldConfig(t),this.getOriginalAvailableFieldConfig(t),this.getCertificateFieldConfig(t),this.getRatingFieldConfig(t),this.getMetaSelectors(t),this.getMetadataLockFieldConfig(t),this.getSummaryFieldConfig(t),this.getExtraFieldConfig(t),this.getSourceField(t)]};this.callParent([Ext.apply(e,t)])},getValues:function(){var t=this.getForm().getValues();return t.original_available=SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.original_available),t.rating=this.getRatingSaveValue(t.rating),t.metadata_locked="true"===t.metadata_locked,t},setValues:function(t){this.getForm().setValues({title:t.title,tagline:t.tagline,original_available:this.correctOriginalAvailable(t.original_available),certificate:t.certificate,rating:this.getRatingValue(t.rating),metadata_locked:!t.hasOwnProperty("metadata_locked")||t.metadata_locked,summary:t.additional.summary,extra:Ext.encode(t.additional.extra)}),this.setMetaSelectorsValue(t),this.maybeSetFileValue(t)},isVideoChanged:function(){var t=this.getValues();return this.oriValue.title!==t.title||this.oriValue.original_available!==t.original_available}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(t){var e={items:[this.getTitleFieldConfig(t),this.getOriginalAvailableFieldConfig(t),this.getMetadataLockFieldConfig(t),this.getSummaryFieldConfig(t),this.getExtraFieldConfig(t),this.getUpdateTVShowFieldConfig(t),this.getSourceField(t)]};this.callParent([Ext.apply(e,t)])},getValues:function(){var t=this.getForm().getValues();return t.original_available=SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.original_available),t.metadata_locked="true"===t.metadata_locked,t},setValues:function(t){this.getForm().setValues({title:t.title,original_available:this.correctOriginalAvailable(t.original_available),metadata_locked:!t.hasOwnProperty("metadata_locked")||t.metadata_locked,summary:t.additional.summary,extra:Ext.encode(t.additional.extra),update_tvshow:t.update_tvshow})},isVideoChanged:function(){var t=this.getValues();return this.oriValue.title!==t.title||this.oriValue.original_available!==t.original_available}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowEpisodeMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(t){var e={items:[this.getFileFieldConfig(t),this.getTitleFieldConfig(t),this.getTVShowOriginalAvailableFieldConfig(t),this.getTaglineFieldConfig(t),this.getSeasonFieldConfig(t),this.getEpisodeFieldConfig(t),this.getOriginalAvailableFieldConfig(t),this.getCertificateFieldConfig(t),this.getRatingFieldConfig(t),this.getMetaSelectors(t),this.getMetadataLockFieldConfig(t),this.getSummaryFieldConfig(t),this.getExtraFieldConfig(t),this.getTVShowExtraFieldConfig(t),this.getSourceField(t)]};this.callParent([Ext.apply(e,t)])},getValues:function(){var t=this.getForm().getValues();return t.rating=this.getRatingSaveValue(t.rating),t.original_available=SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.original_available),t.tvshow_original_available=SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.tvshow_original_available),t.metadata_locked="true"===t.metadata_locked,t.season=parseInt(t.season,10),t.episode=parseInt(t.episode,10),t},setValues:function(t){this.getForm().setValues({title:t.title,tagline:t.tagline,original_available:this.correctOriginalAvailable(t.original_available),tvshow_original_available:this.correctOriginalAvailable(t.tvshow_original_available),episode:t.episode,season:t.season,certificate:t.certificate,rating:this.getRatingValue(t.rating||-1),metadata_locked:!t.hasOwnProperty("metadata_locked")||t.metadata_locked,extra:Ext.encode(t.additional.extra),tvshow_extra:Ext.encode(t.additional.tvshow_extra),summary:t.additional.summary}),this.setMetaSelectorsValue(t),this.maybeSetFileValue(t)},isVideoChanged:function(){var t=this.getValues();return this.oriValue.title!==t.title||this.oriValue.tvshow_original_available!==t.tvshow_original_available||this.oriValue.season!==t.season||this.oriValue.episode!==t.episode},onImportMetadata:function(t){t.from_internet||(t.tvshow_original_available=t.original_available,delete t.original_available),this.callParent(arguments);var e=this.getValues();if(e.title!==this.oriValue.title&&e.tvshow_original_available!==this.oriValue.tvshow_original_available&&!t.from_internet){var i=_VST("metadata","title"),o=_VST("metadata","research_msg");this.owner.getMsgBox().confirm(i,o,function(t){"yes"===t&&this.getTopToolbar().fireEvent(SYNO.SDS.VideoStation2.EditMetadata.Toolbar.EVENT_INTERNET_SEARCH)},this)}}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.TVShowMultipleEpisodeMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",disableInternetSearch:!0,disableSelectFromExisting:!0,allowSeasonEpisodeBlank:!0,constructor:function(t){var e={items:[this.getTitleFieldConfig(t),this.getTVShowOriginalAvailableFieldConfig(t),this.getSeasonFieldConfig(t),this.getEpisodeFieldConfig(t),this.getMetadataLockFieldConfig(t)]};this.callParent([Ext.apply(e,t)])},getValues:function(){var t=this.getForm().getValues();return t.tvshow_original_available=SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.tvshow_original_available),t.metadata_locked="true"===t.metadata_locked,t},setValues:function(t){this.getForm().setValues({title:t.title,tvshow_original_available:this.correctOriginalAvailable(t.tvshow_original_available),season:t.season,episode:t.episode,metadata_locked:!t.hasOwnProperty("metadata_locked")||t.metadata_locked})},isVideoChanged:function(){var t=this.getValues();return this.oriValue.title!==t.title||this.oriValue.tvshow_original_available!==t.tvshow_original_available||this.oriValue.season!==t.season||this.oriValue.episode!==t.episode}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.HomeVideoMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",disableInternetSearch:!0,constructor:function(t){var e={items:[this.getFileFieldConfig(t),this.getTitleFieldConfig(t),this.getRecordDateFieldConfig(t),this.getCertificateFieldConfig(t),this.getRatingFieldConfig(t),this.getMetaSelectors(t),this.getSummaryFieldConfig(t)]};this.callParent([Ext.apply(e,t)])},getValues:function(){var t=this.getForm().getValues();return t.rating=this.getRatingSaveValue(t.rating),t.record_date_date=SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.record_date_date),t.record_date=String.format("{0} {1}",t.record_date_date,t.record_date_time),t},setValues:function(t){var e=(t.record_date||" ").split(" ");this.getForm().setValues({title:t.title,record_date_date:e[0],record_date_time:e[1],certificate:t.certificate,rating:this.getRatingValue(t.rating),summary:t.additional.summary}),this.setMetaSelectorsValue(t),this.maybeSetFileValue(t)},isVideoChanged:function(){var t=this.getValues();return this.oriValue.title!==t.title||this.oriValue.record_date!==t.record_date},hideMetadataLocked:Ext.emptyFn}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.TVRecordingMetaPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",disableToolbar:!0,constructor:function(t){var e={items:[this.getChannelFieldConfig(t),this.getTitleFieldConfig(t),this.getSummaryFieldConfig(t)]};this.callParent([Ext.apply(e,t)])},getValues:function(){return this.getForm().getValues()},setValues:function(t){this.getForm().setValues({title:t.title,channel_name:t.channel_name,summary:t.additional.summary})},isVideoChanged:function(){return!0},hideMetadataLocked:Ext.emptyFn}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){var e={bodyCssClass:"image-panel-body",items:[{xtype:"container",cls:"image-form-wrapper",layout:"border",items:[this.image=this.getImageBox({region:"west",owner:t.owner,video:t.video}),this.panel=this.getFormPanel({region:"center",owner:t.owner,video:t.video})]}]};this.callParent([Ext.apply(e,t)]),this.mon(this.panel,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_IMAGE_CHANGE,this.loadImage,this),this.mon(this,SYNO.SDS.VideoStation2.EditMetadata.MetaPanel.EVENT_META_LOADED,this.onMetaLoaded,this),this.mon(this.image,SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image.EVENT_IMAGE_ERROR,this.onImageError,this),this.mon(this,"activate",this.loadImage,this,{single:!0})},getImageBox:Ext.emptyFn,getFormPanel:Ext.emptyFn,loadImage:function(){this.image.setImage(this.getValues())},isDirty:function(){return!SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},isValid:function(){return this.panel.isValid()},getValues:function(){return this.panel.getValues()},getOriValues:function(){return this.panel.getOriValues()},getImportMetadata:function(){return this.panel.getImportMetadata()},isVideoChanged:function(){return this.panel.isVideoChanged()},onMetaLoaded:function(t){this.setValues(t),this.oriRaw=t,this.oriValue=this.getValues()},onImageError:function(){this.panel.fireEvent(SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Form.EVENT_IMAGE_ERROR)},onImageSet:function(t){this.panel.setValues(t)}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image",{statics:{EVENT_IMAGE_ERROR:"imageerror"},extend:"Ext.Container",video:null,mtime:null,constructor:function(t){var e={cls:"image",margins:"0 14 0 20"};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image.EVENT_IMAGE_ERROR)},setImageMtime:function(t){this.mtime=t},setImage:function(t){var e=this.getImageURL(t);if(!Ext.isEmpty(e)){var i=new Image;i.onerror=this.setDefaultImage.createDelegate(this),i.onload=this.setImageImage.createDelegate(this,[e]),i.src=e}},getImageURL:function(t){switch(t.image){case"original":return t.url?t.url:this.getOriginalImageURL();case"url":return t.url;case"file":return Ext.isEmpty(t.file)?t.file:this.getBaseURL({api:"SYNO.Core.File.Thumbnail",method:"get",version:1,params:{path:SYNO.API.EscapeStr(t.sharepath),size:"medium"}});default:return this.getNoneImageURL({type:this.video.type,id:0})}},getNoneImageURL:Ext.emptyFn,getOriginalImageURL:Ext.emptyFn,setDefaultImage:function(){var t=this.getImageURL({});this.setImageImage(t),this.fireEvent(SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image.EVENT_IMAGE_ERROR)},setImageImage:function(t){var e=this.getEl();e&&e.setStyle("background-image",String.format("url('{0}')",t))}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Form",{statics:{EVENT_IMAGE_ERROR:"imageerror"},disableToolbar:!0,extend:"SYNO.SDS.VideoStation2.EditMetadata.MetaPanel",constructor:function(t){this.callParent([t]),this.mon(this,SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Form.EVENT_IMAGE_ERROR,this.onImageError,this)},getValues:function(){return this.getImageFieldValue()},setValues:function(t){if(t.image)return void this.setImageFieldValue(t);if(t.additional.file){var e=this.correct_info?this.findFileFromData(t):t.additional.file[0],i=e.sharepath;this.getFileSelectBtn().setGotoPath(i.substring(0,i.lastIndexOf("/")))}},isValid:function(){var t=this.getForm().isValid();return t=this.getImageURLField().isValid()&&t,t=this.getImageFileField().isValid()&&t}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel",constructor:function(t){var e={cls:"poster",title:_VST("poster","title")};this.callParent([Ext.apply(e,t)])},getImageBox:function(t){return new SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Image(t)},getFormPanel:function(t){return new SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Form(t)},setValues:function(t){this.image.setImageMtime((t.additional||{}).poster_mtime),this.panel.setValues(t)}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Image",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image",constructor:function(t){this.callParent([t])},getOriginalImageURL:function(){return SYNO.SDS.VideoStation2.Util.getImageURL({type:this.video.type,id:this.video.id,mtime:this.mtime||""})},getNoneImageURL:function(t){return SYNO.SDS.VideoStation2.Util.getImageURL(t)}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.PosterPanel.Form",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Form",constructor:function(t){var e={items:[this.getPosterFieldConfig(t)]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel",constructor:function(t){var e={cls:"backdrop",title:_VST("backdrop","title")};this.callParent([Ext.apply(e,t)])},getImageBox:function(t){return new SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel.Image(t)},getFormPanel:function(t){return new SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel.Form(t)},setValues:function(t){this.image.setImageMtime((t.additional||{}).backdrop_mtime),this.panel.setValues(t)}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel.Image",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Image",constructor:function(t){this.callParent([t])},getOriginalImageURL:function(){return SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:this.video.mapper_id,mtime:this.mtime||""})},getNoneImageURL:function(t){return SYNO.SDS.VideoStation2.Util.getImageURL(Ext.apply(t,{type:"tvshow_episode"}))}}),Ext.define("SYNO.SDS.VideoStation2.EditMetadataDialog.BackdropPanel.Form",{extend:"SYNO.SDS.VideoStation2.EditMetadataDialog.ImagePanel.Form",constructor:function(t){var e={items:[this.getBackdropFieldConfig(t)]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.BasicMenu",{extend:"SYNO.ux.Menu",constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-basic-menu"),this.mon(this,"show",this.onBasicMenuShow,this)},onScroll:function(){this.callParent(arguments),this.toggleScrollerTopBottom()},onBasicMenuShow:function(){this.toggleScrollerTopBottom()},toggleScrollerTopBottom:function(){if(this.scroller){var t=this.ul.dom;t.scrollTop<=0?this.scroller.top.addClass("hide-icon"):this.scroller.top.removeClass("hide-icon"),t.scrollTop+this.activeMax>=t.scrollHeight?this.scroller.bottom.addClass("hide-icon"):this.scroller.bottom.removeClass("hide-icon")}}}),Ext.define("SYNO.SDS.VideoStation2.DropdownMenu",{extend:"SYNO.SDS.VideoStation2.BasicMenu",constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-dropdown-menu"),this.addClass(!0===t.noicon?"no-icon":"with-icon")}}),Ext.define("SYNO.SDS.VideoStation2.OneTimeDropdownMenu",{extend:"SYNO.SDS.VideoStation2.DropdownMenu",hide:function(){this.destroy()}}),Ext.define("SYNO.SDS.VideoStation2.OfflineConversionUtil",{singleton:!0,getVideoProfiles:function(){return[SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL,SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH,SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_MEDIUM,SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_LOW]},isFileSupportRemux:function(t){return("mp4"===t.container_type||"matroska,webm"===t.container_type)&&"h264"===t.video_codec&&(1920>=t.resolutionx&&1080>=t.resolutiony||1080>=t.resolutionx&&1920>=t.resolutiony)},videoProfileToString:function(t){switch(t){case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL:return _VST("offline_conversion","orignal_quality");case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH:return _VST("controller","quality_high");case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_MEDIUM:return _VST("controller","quality_medium");case SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_LOW:return _VST("controller","quality_low")}return""},audioCodecToString:function(t){return String.format("#{0} - {1}({2})",t.id,t.language,t.codec)}}),Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionDataView",{extend:"SYNO.SDS.Utils.DataView.LazyDataView",statics:{TITLE_WRAP_HEIGHT:28,OPTION_WRAP_HEIGHT:26},constructor:function(t){var e={tpl:this.getTpl(),cls:"offline-conversion-action-dataview",itemSelector:"div.offline-conversion-wrap",overClass:"x-view-over",singleSelect:!0};this.callParent([Ext.apply(e,t)])},prepareData:function(t,e,i){return t.index=e,t},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="offline-conversion-wrap"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr class="align-top">','<td class="fit-minimum"><div class="rearrange"></div></td>','<td class="fit-minimum"><div class="thumb" style="background-image: url({[this.getImageURL(values)]})"></div></td>','<td><div class="info-wrap"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr class="align-top">','<td class="fit-minimum">','<div class="counter">{values.index + 1} - </div>',"</td>","<td>",'<div class="info">','<div class="title-wrap">',"{[this.getTitleBtnTpl(values)]}","</div>",'<div class="video-profile-wrap">','<div class="field">{[_VST("offline_conversion", "video_pofile")]}</div>',"{[this.getVideoProfileBtnTpl(values)]}","</div>",'<div class="audio-track-wrap">','<div class="field">{[_VST("offline_conversion", "original_audio_track")]}</div>',"{[this.getAudioTrackBtnTpl(values)]}","</div>","</div>","</td>","</tr></tbody></table></div></td>",'<td class="fit-minimum"><div class="delete"></div></td>',"</tr></tbody></table></div>","</tpl>",'<div class="x-clear"></div>',{getImageURL:this.getImageURL.createDelegate(this),getTitleBtnTpl:this.getTitleBtnTpl.createDelegate(this),getVideoProfileBtnTpl:this.getVideoProfileBtnTpl.createDelegate(this),getAudioTrackBtnTpl:this.getAudioTrackBtnTpl.createDelegate(this)})},getImageURL:function(t){var e=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType();return SYNO.SDS.VideoStation2.Util.getImageURL({type:e,id:t.id,mtime:t.poster_mtime})},getBtnTpl:function(t,e){return[String.format('<div class="dropdown-btn {0}">',t),String.format("<span>{0}</span>",e),"</div>"].join("")},getTitleBtnTpl:function(t){var e=t.file[t.selectedFileIndex],i=Ext.util.Format.htmlEncode(SYNO.SDS.VideoStation2.Util.extractFileName(e.sharepath));return this.getBtnTpl("title",i)},getVideoProfileBtnTpl:function(t){var e=SYNO.SDS.VideoStation2.OfflineConversionUtil.videoProfileToString(t.selectedVideoProfile);return this.getBtnTpl("video-profile",e)},getAudioTrackBtnTpl:function(t){var e=t.file[t.selectedFileIndex],i="";if(0>t.selectedAudioIndex||!Ext.isArray(e.audio_codecs))i=_VST("offline_conversion","default_audio_track");else{var o=e.audio_codecs[t.selectedAudioIndex];i=SYNO.SDS.VideoStation2.OfflineConversionUtil.audioCodecToString(o)}return this.getBtnTpl("audio-track",i)},getMenu:function(){return this._menu=this._menu||new SYNO.SDS.VideoStation2.DropdownMenu({noicon:!0}),this._menu},showMenu:function(t,e){var i=this.getMenu();i.removeAll(),Ext.each(t,function(t){i.add(t)},this),i.showAt(e)},onTitleClick:function(t,e){var i=function(e){t.data.selectedFileIndex=e.fileIndex,t.data.selectedAudioIndex=-1;var i=t.get("file")[t.get("selectedFileIndex")];SYNO.SDS.VideoStation2.OfflineConversionUtil.isFileSupportRemux(i)?t.data.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL:t.data.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH,t.commit()},o=t.get("file"),n=[];Ext.each(o,function(t,e){n.push(new Ext.menu.Item({text:SYNO.SDS.VideoStation2.Util.extractFileName(t.sharepath),fileIndex:e,scope:this,handler:i}))},this),this.showMenu(n,e)},onVideoProfileClick:function(t,e){var i=function(e){t.data.selectedVideoProfile=e.itemId,t.commit()},o=t.get("file")[t.get("selectedFileIndex")],n=SYNO.SDS.VideoStation2.OfflineConversionUtil.isFileSupportRemux(o),a=[];Ext.each(SYNO.SDS.VideoStation2.OfflineConversionUtil.getVideoProfiles(),function(t){(n||SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL!==t)&&a.push({xtype:"menuitem",text:SYNO.SDS.VideoStation2.OfflineConversionUtil.videoProfileToString(t),itemId:t,scope:this,handler:i})},this),this.showMenu(a,e)},onAudioTrackClick:function(t,e){var i=function(e){t.data.selectedAudioIndex=e.audioIndex,t.commit()},o=this,n=function(t){var n=[];Ext.each(t,function(t,e){n.push(new Ext.menu.Item({text:SYNO.SDS.VideoStation2.OfflineConversionUtil.audioCodecToString(t),audioIndex:e,scope:this,handler:i}))},this),o.showMenu(n,e)},a=t.get("file")[t.get("selectedFileIndex")];if(Ext.isArray(a.audio_codecs))n(a.audio_codecs);else{var S={success:function(e,i,o){t.data.file[t.get("selectedFileIndex")].audio_codecs=e.trackinfo,n(a.audio_codecs)},scope:this};SYNO.SDS.VideoStation2.OP.get().listAudioTrack({id:a.id},S)}},onDeleteClick:function(t){this.store.remove(t)},onClick:function(t,e,i){var o=Ext.get(e),n=t.getTarget(this.itemSelector,this.getTemplateTarget());if(!o||!n)return void this.callParent(arguments);var a=this.getRecord(n);o.hasClass("title")||o.parent(".title")?this.onTitleClick(a,[o.getLeft(),o.getTop()+SYNO.SDS.VideoStation2.OfflineConversionActionDataView.TITLE_WRAP_HEIGHT]):o.hasClass("video-profile")||o.parent(".video-profile")?this.onVideoProfileClick(a,[o.getLeft(),o.getTop()+SYNO.SDS.VideoStation2.OfflineConversionActionDataView.OPTION_WRAP_HEIGHT]):o.hasClass("audio-track")||o.parent(".audio-track")?this.onAudioTrackClick(a,[o.getLeft(),o.getTop()+SYNO.SDS.VideoStation2.OfflineConversionActionDataView.OPTION_WRAP_HEIGHT]):(o.hasClass("delete")||o.parent(".delete"))&&this.onDeleteClick(a),this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(t){var e={layout:"fit",width:586,height:540,title:_VST("offline_conversion","action"),buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.OfflineConversionActionPanel(t)]};this.callParent([Ext.apply(e,t)])},onOKBtn:function(){var t=[];this.panel.getStore().each(function(e){var i=e.get("file")[e.get("selectedFileIndex")],o=e.get("selectedAudioIndex"),n={file_id:i.id,video_profile:e.get("selectedVideoProfile")};0<=o&&Ext.apply(n,{audio_id:parseInt(i.audio_codecs[o].id,10)}),t.push({api:"SYNO.VideoStation.OfflineConversion",method:"create",version:1,params:n})},this);var e={params:t,stopwhenerror:!0};this.setStatusBusy(),SYNO.API.Request({compound:e,callback:function(t,e,i,o){this.clearStatusBusy(),!t||e.has_fail?this.setStatusError():this.close()},scope:this})}}),Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionPanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this.videos=t.videos,this.video_type=this.videos[0].type,this.callback=this.callback||{};var e={autoFlexcroll:!0,layout:"fit",items:[this.getDataView()]};this.callParent([Ext.apply(e,t)]),this.loadView()},loadView:function(){var t=[]
;Ext.each(this.videos,function(e){t.push(e.id)},this),this.getStore().load({params:{id:t}})},getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores[this.video_type]({synoMethod:"getinfo",baseParams:{additional:["poster_mtime","file","conversion_produced"]},proxyClass:"SYNO.SDS.VideoStation2.OfflineConversionActionProxy",readerCfg:{fields:["id","title","poster_mtime","type","selectedFileIndex","selectedAudioIndex","selectedVideoProfile","file"]}}),this._store},getDataView:function(){return this._dataView=this._dataView||new SYNO.SDS.VideoStation2.OfflineConversionActionDataView({store:this.getStore()}),this._dataView}}),Ext.define("SYNO.SDS.VideoStation2.OfflineConversionActionProxy",{extend:"SYNO.API.Proxy",constructor:function(t){this.callParent([t])},onRequestAPI:function(t,e,i,o,n,a,S,s,r){try{var l=n.getRoot(e);Ext.each(l,function(t){SYNO.Assert(Ext.isDefined(t.additional)&&Ext.isArray(t.additional.file)&&0<t.additional.file.length,"OfflineConversionActionHttpProxy parser file failed"),t.poster_mtime=t.additional.poster_mtime||"",t.selectedFileIndex=0,t.selectedAudioIndex=-1,t.file=t.additional.file.filter(function(t){return!t.conversion_produced}),SYNO.SDS.VideoStation2.OfflineConversionUtil.isFileSupportRemux(t.file[t.selectedFileIndex])?t.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_ORIGINAL:t.selectedVideoProfile=SYNO.SDS.VideoStation2.Constant.VIDEO_PROFILE_HIGH},this),this.callParent(arguments)}catch(t){return this.fireEvent("loadexception",this,s,e,t),void this.fireEvent("exception",this,"response",r,s,e,t)}}}),Ext.define("SYNO.SDS.VideoStation2.PublicSharingDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",video:null,constructor:function(t){var e={layout:"fit",title:_VST("advanced","public_sharing"),width:450,height:160,buttons:[this.doneBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("common","done"),btnStyle:"blue",scope:this,handler:this.close}),this.openLinkBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","open_link"),disabled:!0,scope:this,handler:this.onOpenLinkBtn})],items:[this.panel=new SYNO.SDS.VideoStation2.PublicSharingDialog.Panel],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)]),this.mon(this.panel,SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_CHANGED,this.onPublicSharingChanged,this)},onAfterRender:function(){this.setStatusBusy(),SYNO.SDS.VideoStation2.OP.get().getPublicSharing({video_id:this.video.id,video_type:this.video.type,need_url:!0},{scope:this,success:this.onPublicSharingLoaded,failure:this.onRequestFail})},onPublicSharingLoaded:function(t,e,i){this.clearStatusBusy(),this.openLinkBtn.setDisabled(!t.enable),this.panel.fireEvent(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_LOADED,t)},onRequestFail:function(t,e,i){this.clearStatusBusy(),this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(t)})},onPublicSharingChanged:function(t){this.setStatusBusy(),this.openLinkBtn.setDisabled(!t),SYNO.SDS.VideoStation2.OP.get().setPublicSharing({enable:t,video_id:this.video.id,video_type:this.video.type},{scope:this,success:this.onUpdatePublicSharing,failure:this.onRequestFail})},onUpdatePublicSharing:function(t,e,i){SYNO.SDS.VideoStation2.Playlist.get().markDirty(),this.clearStatusBusy(),this.onEnableChanged(e.enable)},onOpenLinkBtn:function(){window.open(this.panel.getPublicSharingURL())},onEnableChanged:Ext.emptyFn}),Ext.define("SYNO.SDS.VideoStation2.PublicSharingDialog.Panel",{statics:{EVENT_PUBLIC_SHARING_CHANGED:"publicsharingchanged",EVENT_PUBLIC_SHARING_LOADED:"publicsharingloaded"},extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e={defaults:{anchor:"100%"},updateFormForScrollbar:!0,items:[this.enableCheckbox=new SYNO.SDS.VideoStation2.Checkbox({name:"enable",itemId:"enable",boxLabel:_VST("advanced","public_sharing"),listeners:{scope:this,check:this.onPublicSharingChecked}}),this.urlTextfield=new SYNO.SDS.VideoStation2.TextField({name:"url",itemId:"url",cls:"selectabletext",disabled:!0,readOnly:!0,selectOnFocus:!0,hideLabel:!0})]};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_CHANGED),this.addEvents(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_LOADED),this.mon(this,SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_LOADED,this.onPublicSharingLoaded,this),this.initEnableCheckGroup()},initEnableCheckGroup:function(){return[new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable",["url"])]},getPublicSharingURL:function(){return this.getForm().getValues().url},onPublicSharingLoaded:function(t){this.getForm().setValues(t)},onPublicSharingChecked:function(t,e){this.fireEvent(SYNO.SDS.VideoStation2.PublicSharingDialog.Panel.EVENT_PUBLIC_SHARING_CHANGED,e)}}),Ext.define("SYNO.SDS.VideoStation2.SearchSubtitleDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",file:null,onSubtitleDownloaded:Ext.emptyFn,constructor:function(t){var e={layout:"fit",title:_VST("controller","search_subtitle"),width:600,height:500,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),disabled:!0,btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel(t)],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)]),this.addClass("search-subtitle-dialog"),this.mon(this.panel,SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SELECTION_CHANGE,this.onSelectionChange,this)},onSelectionChange:function(t){this.okBtn.setDisabled(0===t.length)},onOKBtn:function(){var t=this.panel.getSelections();if(0!==t.length){this.setStatusBusy(),this.errors=[];var e=t.map(function(t){if(!t.get("downloaded"))return SYNO.SDS.VideoStation2.OP.get().downloadSubtitle({id:this.file.id,plugin_id:t.get("plugin_id"),download_id:t.get("id")},{failure:function(t,e,i){SYNO.Debug("fail resp:",t),this.errors.push(SYNO.SDS.VideoStation2.Error.getAPIErrorString(t))}.bind(this)})},this).filter(function(t){return Ext.isObject(t)});if(0===e.length)return void this.close();SYNO.SDS.VideoStation2.OP.compound(e,this.onDownloadRequestDone,this.onDownloadRequestFail,this)}},onAfterRender:function(){this.setStatusBusy(),SYNO.SDS.VideoStation2.OP.get().searchSubtitle({id:this.file.id},{scope:this,success:this.onSubtitleLoaded,failure:this.onRequestFail})},onSubtitleLoaded:function(t,e,i){this.clearStatusBusy(),this.panel.fireEvent(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SUBTITLE_LOADED,t.subtitle)},onDownloadRequestDone:function(){this.clearStatusBusy(),this.onSubtitleDownloaded(),this.close()},onRequestFail:function(t,e,i){this.clearStatusBusy(),this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(t)})},onDownloadRequestFail:function(){this.clearStatusBusy(),this.errors.push(_VST("controller","download_subtitle_fail")),this.setStatusError({text:this.errors[0]})}}),Ext.define("SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel",{extend:"SYNO.SDS.VideoStation2.GridPanel",statics:{EVENT_SUBTITLE_LOADED:"subtitleloaded",EVENT_SELECTION_CHANGE:"selectionchange"},constructor:function(t){var e={enableHdMenu:!1,store:this.getStore(),viewConfig:{trackResetOnLoad:!1,emptyText:_T("search","no_search_result")},colModel:new Ext.grid.ColumnModel({columns:[this.getSelectionModel(),{header:_VST("language","title"),dataIndex:"language"},{header:_VST("file","file_name"),dataIndex:"filename"},{header:_VST("video_info","source"),dataIndex:"plugin_title"}]}),selModel:this.getSelectionModel()};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SUBTITLE_LOADED),this.addEvents(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SELECTION_CHANGE),this.mon(this,SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SUBTITLE_LOADED,this.onSubtitleLoaded,this)},getStore:function(){return this.store=this.store||new Ext.data.JsonStore({autoDestroy:!0,id:"id",fields:["id","downloaded","filename","language","language_id","plugin_id","plugin_title","subtitle_id"]}),this.store},getSelectionModel:function(){return this.selection_model=this.selection_model||new Ext.grid.CheckboxSelectionModel({width:34,checkOnly:!0,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),this.selection_model},getSelections:function(){return this.getSelectionModel().getSelections()},onSubtitleLoaded:function(t){this.getStore().loadData(t)},onRowSelectionChange:function(){this.getSelections().length===this.store.getTotalCount()?Ext.fly(this.selection_model.grid.view.innerHd).child(".x-grid3-hd-checker").addClass("x-grid3-hd-checker-on"):Ext.fly(this.selection_model.grid.view.innerHd).child(".x-grid3-hd-checker").removeClass("x-grid3-hd-checker-on"),this.fireEvent(SYNO.SDS.VideoStation2.SearchSubtitleDialog.Panel.EVENT_SELECTION_CHANGE,this.getSelections())}}),Ext.define("SYNO.SDS.VideoStation2.PromiseOP",{statics:{defaultFailureCallback:function(t,e,i){var o=SYNO.SDS.VideoStation2.Error.getAPIErrorString(t);SYNO.SDS.VideoStation2.Window.getMsgBox().alert("",o)},getPromise:function(t,e,i,o,n){return new Promise(function(a,S){SYNO.API.Request({api:t,method:e,version:i,params:o,callback:function(t,e,i,o){t?a(e):Ext.isObject(n)&&n.catch?S(e):SYNO.SDS.VideoStation2.PromiseOP.defaultFailureCallback(e,i,o)}})})},getStoreLoad:function(t,e,i){return new Promise(function(o,n){t.load({params:e,callback:function(t,e,a){a?o(t):Ext.isObject(i)&&i.empty_on_error?o([]):n(e)}})})},all:function(t,e,i){return Promise.all(t).then(e).catch(Ext.isFunction(i)?i:SYNO.SDS.VideoStation2.PromiseOP.defaultFailureCallback)},instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.PromiseOP.instance)||(SYNO.SDS.VideoStation2.PromiseOP.instance=new SYNO.SDS.VideoStation2.PromiseOP),SYNO.SDS.VideoStation2.PromiseOP.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments);var t={getVideoStationInfo:["SYNO.VideoStation2.Info","get",1],getPlaybackSetting:["SYNO.VideoStation2.File","get_playback_setting",2],getPreferredInterface:["SYNO.VideoStation2.Setting.Network","get_preferred_interface",1],setPreferredInterface:["SYNO.VideoStation2.Setting.Network","set_preferred_interface",1],getPreAnalysisInfo:["SYNO.VideoStation2.Setting.PreAnalysis","get",1],setPreAnalysisInfo:["SYNO.VideoStation2.Setting.PreAnalysis","set",1],deleteParentalControl:["SYNO.VideoStation2.ParentalControl","delete",1],listIndexFolder:["SYNO.VideoStation2.Setting.Folder","list",1],getDSMTimezone:["SYNO.Core.Region.NTP","listzone",1]};Ext.iterate(t,function(t,e,i){this[t]=function(t,i){var o=e[0],n=e[1],a=e[2];return SYNO.SDS.VideoStation2.PromiseOP.getPromise(o,n,a,t,i)}},this)}}),Ext.define("SYNO.SDS.VideoStation2.VideoFileChooseDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",video:null,onVideoChoosed:Ext.emptyFn,files:null,constructor:function(t){var e={layout:"fit",title:_VST("error","select_one_video"),width:600,height:500,minWidth:400,minHeight:300,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),disabled:!0,btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel(t)],listeners:{scope:this,beforeshow:{single:!0,fn:this.onBeforeShow}}};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_UPDATE_SCROLLER),this.mon(this.panel,SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_SELECTION_CHANGE,this.onSelectionChange,this),this.mon(this.panel,SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_CHOOSE,this.onOKBtn,this)},getFileByID:function(t){var e;return Ext.each(this.files,function(i){if(i.id===t)return e=i,!1}),e},callVideoChoosed:function(t){this.onVideoChoosed.call(this,t),this.close()},onSelectionChange:function(t){if(this.okBtn.setDisabled(!t),t){this.setStatusBusy();(this.need_playback_setting?SYNO.SDS.VideoStation2.PromiseOP.get().getPlaybackSetting({id:t.id}):Promise.resolve()).then(function(t){t&&SYNO.SDS.VideoStation2.File.get().selectSetting(t),this.clearStatusBusy()}.bind(this))}},onOKBtn:function(){var t=this.panel.getSelected();t&&Ext.each(this.files,function(e){if(e.id===t.get("id"))return this.callVideoChoosed(e),!1},this)},onBeforeShow:function(){return SYNO.SDS.VideoStation2.OP.get().getInfo({id:[this.video.id],additional:["file"]},{scope:this,success:this.onInfoLoaded,failure:this.onRequestFail},this.video.type),!1},onInfoLoaded:function(t,e,i){this.files=t[SYNO.SDS.VideoStation2.Util.getVideoRoot(this.video.type)][0].additional.file;var o;if(Ext.isNumber(this.video.file)?o=this.getFileByID(this.video.file):1===this.files.length&&(o=this.files[0]),o)return void this.callVideoChoosed(o);this.panel.fireEvent(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_INFO_LOADED,this.files),this.show(),this.panel.fireEvent(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_UPDATE_SCROLLER)},onRequestFail:function(t,e,i){SYNO.SDS.VideoStation2.OP.defaultFailureCallback(t,e,i),this.close()}}),Ext.define("SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel",{extend:"SYNO.SDS.VideoStation2.GridPanel",statics:{EVENT_INFO_LOADED:"infoloaded",EVENT_SELECTION_CHANGE:"selectionchange",EVENT_CHOOSE:"choose",EVENT_UPDATE_SCROLLER:"updatescroller"},constructor:function(t){var e={enableHdMenu:!1,viewConfig:{trackResetOnLoad:!1,forceFit:!1},store:this.getStore(),colModel:new Ext.grid.ColumnModel({columns:[{header:_VST("file","file_name"),dataIndex:"sharepath",id:"sharepath",resizable:!1,renderer:function(t,e){var i=t.substr(t.lastIndexOf("/")+1);return i=Ext.util.Format.htmlEncode(i),e.attr=String.format('ext:qtip="{0}"',Ext.util.Format.htmlEncode(t)),i}},{header:_VST("duration","title"),dataIndex:"duration",width:120,fixed:!0,renderer:function(t,e){return e.attr=String.format('ext:qtip="{0}"',t),t}},{header:_T("common","size"),dataIndex:"filesize",width:120,fixed:!0,renderer:function(t,e){var i=Ext.util.Format.fileSize(t);return e.attr=String.format('ext:qtip="{0}"',i),i}}]}),autoExpandColumn:"sharepath",selModel:new Ext.grid.RowSelectionModel({singleSelect:!0,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,rowdblclick:this.onRowDBLClick}};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_INFO_LOADED),this.addEvents(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_SELECTION_CHANGE),this.addEvents(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_CHOOSE),this.mon(this,SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_INFO_LOADED,this.onInfoLoaded,this),this.mon(this,SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_UPDATE_SCROLLER,this.onUpdateScroller,this)},getStore:function(){return this.store=this.store||new Ext.data.JsonStore({id:"id",fields:["id","sharepath","duration","filesize"],autoDestroy:!0}),this.store},getSelected:function(){return this.getSelectionModel().getSelected()},onInfoLoaded:function(t){this.store.loadData(t)},onRowSelectionChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_SELECTION_CHANGE,this.getSelected())},onRowDBLClick:function(){this.fireEvent(SYNO.SDS.VideoStation2.VideoFileChooseDialog.Panel.EVENT_CHOOSE)},onUpdateScroller:function(){this.getView().updateScroller()}}),Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",statics:{EVENT_FILE_CHANGE:"filechange"},files:[],index:0,constructor:function(t){var e={cls:"video-info-dialog",layout:"fit",title:_VST("action","view_video_info"),width:680,height:500,useStatusBar:!1,buttonAlign:"left",fbar:new SYNO.ux.Toolbar({cls:"x-statusbar",items:[{xtype:"tbspacer",width:10},this.getPrevButton(),this.getNextButton(),"->",this.getCloseButton()]}),items:[this.panel=new SYNO.SDS.VideoStation2.VideoInfoDialog.TabPanel({})],listeners:{scope:this,afterrender:{fn:this.onAfterRender,single:!0}}};this.callParent([Ext.apply(e,t)]),this.mon(this,SYNO.SDS.VideoStation2.VideoInfoDialog.EVENT_FILE_CHANGE,this.onFileChange,this),this.getPrevButton().setVisible(this.files.length>1),this.getNextButton().setVisible(this.files.length>1)},onAfterRender:function(){this.onFileChange(this.index)},onFileChange:function(t){this.getPrevButton().setDisabled(t<=0),this.getNextButton().setDisabled(t+1>=this.files.length),this.panel.fireEvent(SYNO.SDS.VideoStation2.VideoInfoDialog.TabPanel.EVENT_LOAD_FILE,this.files[t])},getPrevButton:function(){return this._prev_btn=this._prev_btn||new SYNO.SDS.VideoStation2.Button({cls:"action prev",scope:this,handler:this.goPrevious}),this._prev_btn},getNextButton:function(){return this._next_btn=this._next_btn||new SYNO.SDS.VideoStation2.Button({cls:"action next",scope:this,handler:this.goNext}),this._next_btn},getCloseButton:function(){return this._close_btn=this._close_btn||new SYNO.SDS.VideoStation2.Button({text:_T("common","close"),scope:this,handler:this.close}),this._close_btn},goPrevious:function(){SYNO.Assert(this.index>0,"unable to go previous"),this.index--,this.fireEvent(SYNO.SDS.VideoStation2.VideoInfoDialog.EVENT_FILE_CHANGE,this.index)},goNext:function(){SYNO.Assert(this.index+1<this.files.length,"unable to go next"),this.index++,this.fireEvent(SYNO.SDS.VideoStation2.VideoInfoDialog.EVENT_FILE_CHANGE,this.index)}}),Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.TabPanel",{extend:"SYNO.SDS.VideoStation2.TabPanel",statics:{EVENT_LOAD_FILE:"loadfile"},constructor:function(t){var e={border:!1,items:[]};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.VideoInfoDialog.TabPanel.EVENT_LOAD_FILE),this.mon(this,SYNO.SDS.VideoStation2.VideoInfoDialog.TabPanel.EVENT_LOAD_FILE,this.loadFile,this)},loadFile:function(t){Ext.isObject(this._load_track_request)&&Ext.Ajax.abort(this._load_track_request),this.removeAll(),this._file=SYNO.Util.copy(t),this.add(new SYNO.SDS.VideoStation2.VideoInfoDialog.GeneralPanel({data:this._file,itemId:"general"})),this.setActiveTab("general"),this.loadTrackInfo()},loadTrackInfo:function(){this._load_track_request=SYNO.SDS.VideoStation2.OP.get().getFileTrackInfo({id:this._file.id},{scope:this,success:this.updateTrackInfo,failure:Ext.emptyFn})},updateTrackInfo:function(t,e,i){var o=SYNO.Util.copy((t.video||[])[0]||{});o.resolution=String.format("{0} x {1}",o.resolutionx,o.resolutiony),this._video=o,this._audio=SYNO.Util.copy(t.audio)||[],this.add(new SYNO.SDS.VideoStation2.VideoInfoDialog.VideoPanel({data:this._video})),this.add(new SYNO.SDS.VideoStation2.VideoInfoDialog.AudioPanel({data:this._audio}))}}),Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.Panel",{extend:"SYNO.ux.Panel",constructor:function(t){var e={title:(t||{}).title||"Title",autoFlexcroll:!0,items:new SYNO.SDS.VideoStation2.VideoInfoDialog.InnerPanel(Ext.apply(t,{computeData:this.computeData,getFields:this.getFields}))};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.InnerPanel",{extend:"Ext.Panel",constructor:function(t){Ext.apply(this,t);var e={border:!1,header:!1,cls:"info-panel",layout:"table",layoutConfig:{columns:2},items:this.getItems(t)};this.callParent([Ext.apply(e,t)])},getItems:function(t){var e=this.computeData((t||{}).data);return this.getFields().map(function(t){var i=Ext.isDefined(e[t.name])?Ext.util.Format.htmlEncode(e[t.name]):"";return[{xtype:"box",cls:"label",html:Ext.util.Format.htmlEncode(t.label)},{xtype:"box",cls:"value allowDefCtxMenu selectabletext",html:i}]}).reduce(function(t,e){return t.concat(e)},[])},computeData:function(){return{}},getFields:function(){return[]}}),Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.GeneralPanel",{extend:"SYNO.SDS.VideoStation2.VideoInfoDialog.Panel",statics:{FIELDS:[{name:"filename",label:_VST("file","file_name")},{name:"sharepath",label:_VST("file","file_path")},{name:"duration",label:_VST("duration","title")},{name:"formated_filesize",label:_T("common","size")},{name:"resolution",label:_VST("video_info","resolution")},{name:"container_type",label:_VST("video_info","container")},{name:"video_codec",label:_VST("video_info","video_codec")},{name:"audio_codec",label:_VST("video_info","audio_codec")},{name:"video_bitrate",label:_VST("video_info","video_bitrate")}]},constructor:function(t){var e={title:_VST("video_info","general")};this.callParent([Ext.apply(e,t)])},computeData:function(t){var e=SYNO.Util.copy(t);return Ext.apply(e,{filename:t.sharepath.split("/").pop(),formated_filesize:Ext.util.Format.fileSize(t.filesize),resolution:String.format("{0} x {1}",t.resolutionx,t.resolutiony),video_bitrate:SYNO.SDS.VideoStation2.Util.formatBitrate(t.frame_bitrate)})},getFields:function(){return SYNO.SDS.VideoStation2.VideoInfoDialog.GeneralPanel.FIELDS}}),Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.VideoPanel",{extend:"SYNO.SDS.VideoStation2.VideoInfoDialog.Panel",statics:{FIELDS:[{name:"codec_raw",label:_VST("video_info","video_codec")},{name:"resolution",label:_VST("video_info","resolution")},{name:"rotate",label:_VST("video_info","rotation")},{name:"framerate",label:_VST("video_info","fps")},{name:"profile",label:_VST("video_info","profile")},{name:"level",label:_VST("video_info","level")}]},constructor:function(t){var e={title:_VST("video_info","video")};this.callParent([Ext.apply(e,t)])},computeData:function(t){var e=SYNO.Util.copy(t);return Ext.apply(e,{resolution:String.format("{0} x {1}",t.resolutionx,t.resolutiony),framerate:(t.framerate||0).toFixed(3),rotate:String.format("{0}{1}",t.rotate,String.fromCharCode(176))})},getFields:function(){return SYNO.SDS.VideoStation2.VideoInfoDialog.VideoPanel.FIELDS}}),Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.AudioPanel",{extend:"SYNO.ux.Panel",constructor:function(t){var e={title:_VST("video_info","audio"),autoFlexcroll:!0,items:new SYNO.SDS.VideoStation2.VideoInfoDialog.AudioPanelInner(t)};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.VideoInfoDialog.AudioPanelInner",{extend:"Ext.Panel",statics:{FIELDS:[{name:"codec_raw",label:_VST("video_info","audio_codec")},{name:"channel_layout",label:_VST("video_info","audio_channel")},{name:"sample_rate",label:_VST("video_info","sample_rate")},{name:"language",label:_VST("language","title")}]},constructor:function(t){var e=(t||{}).data||[],i={border:!1,header:!1,cls:"info-panel",tpl:this.getTpl(),listeners:{afterrender:{fn:function(){this.update(e)},scope:this,single:!0}}};this.callParent([Ext.apply(i,t)])},getTpl:function(){var t=SYNO.SDS.VideoStation2.VideoInfoDialog.AudioPanelInner.FIELDS.map(function(t){return["<tr>",String.format('<td class="x-table-layout-cell"><div class="label">{0}</div></td>',Ext.util.Format.htmlEncode(t.label)),String.format('<td class="x-table-layout-cell"><div class="value allowDefCtxMenu selectabletext">{values.{0}:htmlEncode}</div></td>',t.name),"</tr>"].join("")}).join("");return new Ext.XTemplate('<tpl for=".">','<div class="track-title {[this.getIndexClass(xindex)]}">{[this.getTrackTitle(values)]}</div>','<table class="x-table-layout" cellspacing="0"><tbody>',t,"</tbody></table>","</tpl>",{getIndexClass:function(t){return t>1?"non-first":""},getTrackTitle:function(t){var e=(t||{}).track||-1;return String.format("{0}{1}",_VST("video_info","audio"),e<0?"":" - #"+e)}})}}),Ext.define("SYNO.SDS.VideoStation2.VideoActionController",{statics:{ACTION_VIEW_VIDEO_INFO:"view_video_info",ACTION_EDIT_METADATA:"edit_metadata",ACTION_EDIT_MULTIPLE_EPISODE_METADATA:"edit_multiple_episode_metadata",ACTION_CORRECT_METADATA:"correct_metadata",ACTION_SEARCH_SUBTITLE:"search_subtitle",ACTION_PUBLIC_SHARING:"public_sharing",ACTION_SET_WATCHED:"set_watched",ACTION_SET_UNWATCHED:"set_unwatched",ACTION_DEL_VIDEO:"del_video",ACTION_DEL_FILE:"del_file",ACTION_OFFLINE_CONVERSION:"offline_conversion",getAllActions:function(){return[SYNO.SDS.VideoStation2.VideoActionController.ACTION_VIEW_VIDEO_INFO,SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_SEARCH_SUBTITLE,SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING,SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED,SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE,SYNO.SDS.VideoStation2.VideoActionController.ACTION_OFFLINE_CONVERSION]},doVideoAction:function(t,e,i){switch(t){case SYNO.SDS.VideoStation2.VideoActionController.ACTION_VIEW_VIDEO_INFO:return SYNO.SDS.VideoStation2.VideoActionController.viewVideoInfo(e);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA:return SYNO.SDS.VideoStation2.VideoActionController.correctMetadata(e,i);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_MULTIPLE_EPISODE_METADATA:return SYNO.SDS.VideoStation2.VideoActionController.editMetadata(e,i);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SEARCH_SUBTITLE:return SYNO.SDS.VideoStation2.VideoActionController.searchSubtitle(e,i);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING:return SYNO.SDS.VideoStation2.VideoActionController.publicSharing(e,i);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED:return SYNO.SDS.VideoStation2.VideoActionController.setWatched(e,i);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED:return SYNO.SDS.VideoStation2.VideoActionController.setUnwatched(e,i);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO:return SYNO.SDS.VideoStation2.VideoActionController.delVideo(e,i);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE:return SYNO.SDS.VideoStation2.VideoActionController.delFile(e,i);case SYNO.SDS.VideoStation2.VideoActionController.ACTION_OFFLINE_CONVERSION:return SYNO.SDS.VideoStation2.VideoActionController.offlineConversion(e,i);default:SYNO.Debug.error(String.format("unknown video action {0}",t))}},createPlaylist:function(t,e){new SYNO.SDS.VideoStation2.CreatePlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,videos:t,onVideoAdded:e}).open()},getOneVideoFileInfo:function(t,e,i){new SYNO.SDS.VideoStation2.VideoFileChooseDialog({owner:SYNO.SDS.VideoStation2.Window,video:t,onVideoChoosed:e,need_playback_setting:i||!1}).open()},viewVideoInfo:function(t){SYNO.Assert(1===t.length,"viewVideoInfo only allow one video");var e=t[0],i=function(t,i,o){new SYNO.SDS.VideoStation2.VideoInfoDialog({owner:SYNO.SDS.VideoStation2.Window,files:t[SYNO.SDS.VideoStation2.Util.getVideoRoot(e.type)][0].additional.file||[]}).open()};SYNO.SDS.VideoStation2.OP.get().getInfo({id:[e.id],additional:["file"]},{scope:this,success:i},e.type)},correctMetadata:function(t,e){SYNO.Assert(1===t.length,"correctMetadata only allow one video");var i=t[0];Ext.isNumber(i.file)?SYNO.SDS.VideoStation2.VideoActionController.doCorrectMetadata(i,e):SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(i,function(t){i.file=t.id,SYNO.SDS.VideoStation2.VideoActionController.doCorrectMetadata(i,e)})},editMetadata:function(t,e){SYNO.Assert(t.length>0,"editMetadata only allow at least one video"),new SYNO.SDS.VideoStation2.EditMetadataDialog({owner:SYNO.SDS.VideoStation2.Window,videos:t,onVideoMetadataEdited:e}).open()},searchSubtitle:function(t,e){SYNO.Assert(1===t.length,"searchSubtitle only allow one video"),SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(t[0],function(t){new SYNO.SDS.VideoStation2.SearchSubtitleDialog({owner:SYNO.SDS.VideoStation2.Window,file:t,onSubtitleDownloaded:e}).open()})},publicSharing:function(t,e){var i;e=Ext.isFunction(e)?e:Ext.emptyFn;var o={};t.each(function(t){o[t.id.toString()+","+t.type]=!0}),o=Object.keys(o).map(function(t){var e=t.split(",");return{id:parseInt(e[0],10),type:e[1]}}),i=1===o.length?new SYNO.SDS.VideoStation2.PublicSharingDialog({owner:SYNO.SDS.VideoStation2.Window,video:o[0],onEnableChanged:e}):new SYNO.SDS.VideoStation2.CreatePlaylistDialog({owner:SYNO.SDS.VideoStation2.Window,forcePublicSharing:!0,videos:o,onVideoAdded:e}),i.open()},setWatched:function(t,e){SYNO.SDS.VideoStation2.VideoActionController.setWatchStatus(t,!0,e)},setUnwatched:function(t,e){SYNO.SDS.VideoStation2.VideoActionController.setWatchStatus(t,!1,e)},setWatchStatus:function(t,e,i){var o=function(t,i){var o=t[i].map(function(t){return t.id}).uniq();return SYNO.SDS.VideoStation2.OP.get().setVideoWatched({id:o,watched:!!e},{},i)};SYNO.SDS.VideoStation2.OP.classifyRequest(t,o,i)},offlineConversion:function(t,e){new SYNO.SDS.VideoStation2.OfflineConversionActionDialog({videos:t,callback:e}).open()},confirmDelete:function(t,e){var i=String.format(_VST("action","delete_video_confirm"),e);SYNO.SDS.VideoStation2.Window.getMsgBox().confirmDelete("",i,function(e){"yes"===e&&t()})},delFile:function(t,e){SYNO.Assert(1===t.length,"delete file only allow one video"),SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(t[0],function(t){var i=function(){SYNO.SDS.VideoStation2.VideoActionController.doDelFile([t.id],e)};SYNO.SDS.VideoStation2.VideoActionController.confirmDelete(i,1)})},delVideo:function(t,e){var i=function(){SYNO.SDS.VideoStation2.VideoActionController.doDelVideo(t,e)};SYNO.SDS.VideoStation2.VideoActionController.confirmDelete(i,t.length)},doCorrectMetadata:function(t,e){new SYNO.SDS.VideoStation2.EditMetadataDialog({owner:SYNO.SDS.VideoStation2.Window,videos:[t],onVideoMetadataEdited:e}).open()},doDelVideo:function(t,e){if(Ext.isNumber(t[0].file)){var i=t.map(function(t){return t.file});SYNO.SDS.VideoStation2.VideoActionController.doDelFile(i,e)}else{var o=function(t,e){var i=t[e].map(function(t){return t.id}).uniq();return SYNO.SDS.VideoStation2.OP.get().deleteVideo({id:i},{},e)};SYNO.SDS.VideoStation2.OP.classifyRequest(t,o,e)}},doDelFile:function(t,e){SYNO.SDS.VideoStation2.OP.get().deleteFile({id:t},{success:e})},applyWatchStatusChangeToVideo:function(t,e){t.each(function(t){var i=t.record.get("additional")||{};i.watched_ratio=e?1:0,t.record.set("additional",i),t.record.commit()})}}}),Ext.define("SYNO.SDS.VideoStation2.ActionUtil",{singleton:!0,isAdminAction:function(t){return-1!==[SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE].indexOf(t)},getAvailablePlaylistActions:function(){return SYNO.SDS.VideoStation2.PlaylistActionController.getAllActions().filter(function(t){return!(t===SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_SHARE&&!SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing())})},getAvailableVideoActions:function(){return SYNO.SDS.VideoStation2.VideoActionController.getAllActions().filter(function(t){return!(!_S("is_admin")&&SYNO.SDS.VideoStation2.ActionUtil.isAdminAction(t)||t===SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING&&!SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing()||t===SYNO.SDS.VideoStation2.VideoActionController.ACTION_OFFLINE_CONVERSION&&!SYNO.SDS.VideoStation2.Capability.get().ableToControlOfflineConversion())})}}),Ext.define("SYNO.SDS.VideoStation2.AboutWindow",{extend:"SYNO.SDS.AboutWindow",constructor:function(){this.callParent(arguments),this.addClass("syno-vs2-about-window")}}),Ext.define("SYNO.SDS.VideoStation2.AccordionPanel",{extend:"SYNO.ux.Panel",header:!0,constructor:function(){this.callParent(arguments),this.addClass("syno-vs2-accordion-panel"),this.mon(this,"activate",this.addExpandedClass,this),
this.mon(this,"deactivate",this.removeExpandedClass,this),this.mon(this,"afterrender",this.initExpandedClass,this,{single:!0})},initExpandedClass:function(){this.header&&!this.collapsed&&this.addExpandedClass()},addExpandedClass:function(){this.header&&this.header.addClass("expanded")},removeExpandedClass:function(){this.header&&this.header.removeClass("expanded")}}),Ext.define("SYNO.SDS.VideoStation2.ActionButton",{extend:"SYNO.ux.Button",constructor:function(t){this.callParent([t]),this.addClass("syno-vs2-action-button")}}),Ext.define("SYNO.SDS.VideoStation2.MenuActionButton",{extend:"SYNO.SDS.VideoStation2.ActionButton",constructor:function(t){t=t||{};var e=!0===t.noicon,i=t.menuBeforeShow||{},o={handler:Ext.emptyFn,menu:t.menu||new SYNO.SDS.VideoStation2.DropdownMenu({noicon:e,items:[],listeners:{beforeshow:{scope:i.scope||this,fn:i.fn||Ext.emptyFn}}})};delete t.beforeshow,delete t.noicon,this.callParent([Ext.apply(o,t)]),this.addClass("menu-action-button")}}),Ext.define("SYNO.SDS.VideoStation2.BrowsingAction",{statics:{EVENT_BROWSING_ACTION_CHANGED:"browsingactionchanged",ACTION_NONE:"none",ACTION_SELECT:"select",ACTION_DETAIL:"detail",ACTION_LIST:"list",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.BrowsingAction.instance)||(SYNO.SDS.VideoStation2.BrowsingAction.instance=new SYNO.SDS.VideoStation2.BrowsingAction),SYNO.SDS.VideoStation2.BrowsingAction.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.addEvents(SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED),this.toNone()},selectAction:function(t){SYNO.Assert(Ext.isString(t),String.format("unexpceted action {0}",t)),this.current_action!==t&&(this.current_action=t,this.fireEvent(SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED))},toNone:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_NONE)},toSelect:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_SELECT)},toDetail:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_DETAIL)},toList:function(){this.selectAction(SYNO.SDS.VideoStation2.BrowsingAction.ACTION_LIST)},getCurrentAction:function(){return SYNO.Assert(Ext.isString(this.current_action),String.format("unexpceted action {0}",this.current_action)),this.current_action},current_action:null}),Ext.define("SYNO.SDS.VideoStation2.Category",{statics:{instance:null,EVENT_CATEGORY_CHANGED:"categorychanged",EVENT_CATEGORY_CLEARED:"categorycleared",CATEGORY_RECENTLY_ADDED:"recently_added",CATEGORY_RECENTLY_WATCHED:"recently_watched",CATEGORY_RECENTLY_RELEASED:"recently_released",CATEGORY_ALL:"all",CATEGORY_FOLDER:"folder",CATEGORY_BY_CHANNEL:"bychannel",CATEGORY_BY_PROGRAM:"byprogram",CATEGORY_TIME_LINE:"time_line",CATEGORY_NONE:"none",get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Category.instance)||(SYNO.SDS.VideoStation2.Category.instance=new SYNO.SDS.VideoStation2.Category),SYNO.SDS.VideoStation2.Category.instance},getAllCategories:function(){return[SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Category.CATEGORY_ALL,SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM,SYNO.SDS.VideoStation2.Category.CATEGORY_TIME_LINE]},isAvilableCategoryWithType:function(t,e){var i=[];return i=t===SYNO.SDS.VideoStation2.Constant.TV_RECORDING?[SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED,SYNO.SDS.VideoStation2.Category.CATEGORY_ALL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM]:t===SYNO.SDS.VideoStation2.Constant.HOME_VIDEO?[SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Category.CATEGORY_ALL,SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER,SYNO.SDS.VideoStation2.Category.CATEGORY_TIME_LINE]:[SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED,SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Category.CATEGORY_ALL,SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER],-1!==i.indexOf(e)},isRecordingSpecificCategory:function(t){return-1!==[SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM].indexOf(t)},isSpecialCategory:function(t){return-1!==[SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM,SYNO.SDS.VideoStation2.Category.CATEGORY_TIME_LINE].indexOf(t)},isSortAdjustableCategory:function(t){return-1!==[SYNO.SDS.VideoStation2.Category.CATEGORY_ALL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL,SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM].indexOf(t)}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.addEvents(SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED),this.current_category=SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED},selectCategory:function(t){if(SYNO.Assert(Ext.isString(t),String.format("unexpceted category {0}",t)),this.current_category!==t){var e=this.current_category;this.current_category=t,this.fireEvent(SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,e,t)}},toNone:function(){this.current_category=SYNO.SDS.VideoStation2.Category.CATEGORY_NONE,this.fireEvent(SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CLEARED)},getCurrentCategory:function(){return SYNO.Assert(Ext.isString(this.current_category),String.format("unexpceted category {0}",this.current_category)),this.current_category},getSortOption:function(){var t={};switch(this.current_category){case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED:t.sort_by="added";break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED:t.sort_by="watched";break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED:t.sort_by="date"}return t.sort_by&&(t.sort_direction="desc"),t},getDefaultCategory:function(){return SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED},isCurrentRecordingSpecific:function(){return SYNO.SDS.VideoStation2.Category.isRecordingSpecificCategory(this.current_category)},current_category:null}),Ext.define("SYNO.SDS.VideoStation2.DTV",{statics:{EVENT_DTV_LOAD:"dtvload",EVENT_DISABLE_DTV:"disable_dtv",EVENT_DTV_CHANGED:"dtvchanged",DEFAULT_DTV:[{tuner_id:-1,title:_VST("schedule","schedule_recording"),type:0,signal:0,additional:0}],instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.DTV.instance)||(SYNO.SDS.VideoStation2.DTV.instance=new SYNO.SDS.VideoStation2.DTV),SYNO.SDS.VideoStation2.DTV.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.addEvents(SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,SYNO.SDS.VideoStation2.DTV.EVENT_DISABLE_DTV,SYNO.SDS.VideoStation2.DTV.EVENT_DTV_CHANGED),this.prepareDefaultDTV()},getDTVStore:function(){return this.store=this.store||new SYNO.SDS.VideoStation2.DTVStore({appWindow:SYNO.SDS.VideoStation2.Window,listeners:{scope:this,load:this.onDTVLoad,exception:this.onDTVLoadException}}),this.store},loadDTV:function(){if(this.fireEvent(SYNO.SDS.VideoStation2.DTV.EVENT_DISABLE_DTV,this.disable_dtv),this.disable_dtv)return void this.fireEvent(SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,!1,[]);this.getDTVStore().load()},onDTVLoad:function(t,e,i){this.tuners=e||[],Ext.isEmpty(this.tuners)&&this.store.removeAll();var o=!0;Ext.each(this.tuners,function(t){if(t.get("tuner_id")===this.current_id)return o=!1,!1},this),this.current_id===SYNO.SDS.VideoStation2.DTV.DEFAULT_DTV[0].tuner_id&&(o=!1),SYNO.SDS.VideoStation2.Capability.get().ableToControlDTV()||(this.store.removeAll(),this.default_dtv[0].set("display","none"),o=!1),this.store.insert(0,this.default_dtv),this.store.commitChanges(),this.fireEvent(SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,o,this.tuners),this.loadDTV.defer(8e3,this)},onDTVLoadException:function(){this.loadDTV.defer(8e3,this)},prepareDefaultDTV:function(){Ext.isEmpty(this.default_dtv)&&(this.default_dtv=SYNO.SDS.VideoStation2.DTV.DEFAULT_DTV.map(function(t){return new SYNO.SDS.VideoStation2.DTVStore.Record(t,t.tuner_id)}))},selectDTV:function(t){t!==this.current_id&&(this.current_id=t,this.fireEvent(SYNO.SDS.VideoStation2.DTV.EVENT_DTV_CHANGED))},setTimezoneOffset:function(t){this.timezone_offset=t/60},getCurrentID:function(){return this.current_id},getCurrentDTV:function(){return(this.store.getById(this.current_id)||{}).data},getTuner:function(){return this.tuners},getDSMDate:function(t){var e=t?new Date(1e3*t):new Date;return Ext.isEmpty(this.timezone_offset)||e.setTime(e.getTime()+60*e.getTimezoneOffset()*1e3+60*this.timezone_offset*1e3),e},setDTVDisabled:function(t){this.disable_dtv=!0===t},isDTVDisabled:function(){return this.disable_dtv},tuners:[],disable_dtv:!1,current_id:null,timezone_offset:null}),Ext.define("SYNO.SDS.VideoStation2.DTVStore",{statics:{Record:Ext.data.Record.create([{name:"tuner_id",type:"int"},{name:"title",type:"string"},{name:"type",type:"int"},{name:"signal",type:"int"},{name:"additional"}])},extend:"SYNO.API.Store",constructor:function(t){var e={api:"SYNO.VideoStation2.DTV.Tuner",method:"list",version:1,baseParams:{additional:["channel_status"],limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT},reader:new Ext.data.JsonReader({root:"tuner",idProperty:"tuner_id"},SYNO.SDS.VideoStation2.DTVStore.Record)};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.Channel",{statics:{EVENT_CHANNEL_CHANGE:"channelchange",EVENT_DATE_CHANGE:"datechange",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Channel.instance)||(SYNO.SDS.VideoStation2.Channel.instance=new SYNO.SDS.VideoStation2.Channel),SYNO.SDS.VideoStation2.Channel.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.addEvents(SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE)},selectChannel:function(t,e){t!==this.current_id&&(this.current_id=t,this.current_title=e,this.remain_days=null,Ext.isEmpty(t)?this.current_date=null:this.current_date=Date.parseDate(SYNO.SDS.VideoStation2.DTV.get().getDSMDate().format("Ymd"),"Ymd"),this.fireEvent(SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE))},selectDate:function(t){t.valueOf()!==this.current_date.valueOf()&&(this.current_date=t,this.fireEvent(SYNO.SDS.VideoStation2.Channel.EVENT_DATE_CHANGE))},setRemainDays:function(t){this.remain_days=t},clearChannel:function(){this.selectChannel(null,"")},getCurrentID:function(){return this.current_id},getCurrentTitle:function(){return this.current_title},getCurrentDate:function(){return this.current_date},getRemainDays:function(){return this.remain_days},current_id:null,current_title:null,current_date:null,remain_days:null}),Ext.define("SYNO.SDS.VideoStation2.Folder",{statics:{EVENT_FOLDER_CHANGED:"folderchanged",FOLDER_NULL:null,instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Folder.instance)||(SYNO.SDS.VideoStation2.Folder.instance=new SYNO.SDS.VideoStation2.Folder),SYNO.SDS.VideoStation2.Folder.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.resetData()},resetData:function(){this.current_folder=[],this.fireEvent(SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED)},selectFolder:function(t,e){SYNO.Assert(Ext.isString(t),String.format("unexpceted FolderPath {0}",t)),this.current_folder.push({id:t,pathTitle:e}),this.fireEvent(SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED)},thrinkFolderStackTo:function(t){if(t===SYNO.SDS.VideoStation2.Folder.FOLDER_NULL)return void this.resetData();var e=-1;Ext.each(this.current_folder,function(i,o){if(i.id===t.id)return e=o,!1}),-1!==e&&(this.current_folder=this.current_folder.slice(0,e+1)),this.fireEvent(SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED)},isSet:function(){return!Ext.isEmpty(this.current_folder)},getCurrentID:function(){return 0===this.current_folder.length?null:this.current_folder.last().id},getCurrentPathTitle:function(){return 0===this.current_folder.length?null:this.current_folder.last().pathTitle},getCurrentFolderStack:function(){return SYNO.Util.copy(this.current_folder)},current_folder:[]}),Ext.define("SYNO.SDS.VideoStation2.RecordingSpecific",{extend:"Ext.util.Observable",statics:{EVENT_RECORDING_SPECIFIC_SET:"recordingspecificset",EVENT_RECORDING_SPECIFIC_CLEAR:"recordingspecificclear",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.RecordingSpecific.instance)||(SYNO.SDS.VideoStation2.RecordingSpecific.instance=new SYNO.SDS.VideoStation2.RecordingSpecific),SYNO.SDS.VideoStation2.RecordingSpecific.instance}},constructor:function(){this.callParent(arguments),this.resetData()},resetData:function(){this.clearChannel(),this.clearProgram()},getCurrentChannel:function(){return SYNO.Assert(Ext.isString(this.current_channel),"channel unset"),this.current_channel},getCurrentProgram:function(){return SYNO.Assert(Ext.isString(this.current_program),"program unset"),this.current_program},clearChannel:function(){Ext.isString(this.current_channel)&&(this.current_channel=null,this.fireEvent(SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR))},clearProgram:function(){Ext.isString(this.current_program)&&(this.current_program=null,this.fireEvent(SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR))},selectChannel:function(t){SYNO.Assert(Ext.isString(t),String.format("unexpceted channel {0}",t)),this.current_channel!==t&&(this.current_channel=t,this.fireEvent(SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET))},selectProgram:function(t){SYNO.Assert(Ext.isString(t),String.format("unexpceted program {0}",t)),this.current_program!==t&&(this.current_program=t,this.fireEvent(SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET))},getFilterOption:function(){var t={};return Ext.isString(this.current_channel)?t[SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME]=[this.current_channel]:Ext.isString(this.current_program)&&(t[SYNO.SDS.VideoStation2.Filter.FILTER_TITLE]=[this.current_program]),t},getValue:function(){return this.current_channel||this.current_program},isSet:function(){return Ext.isString(this.current_channel)||Ext.isString(this.current_program)},current_channel:null,current_program:null}),Ext.define("SYNO.SDS.VideoStation2.View",{statics:{VIEW_HOMEPAGE:"view_homepage",VIEW_PLAYLIST:"view_playlist",VIEW_POSTER:"view_poster",VIEW_DETAIL:"view_detail",VIEW_TVSHOW:"view_tvshow",VIEW_SCHEDULE:"view_schedule",VIEW_DTV:"view_dtv",TYPE_THUMBNAIL:"thumbnail",TYPE_TILE:"tile",TYPE_LIST:"list",EVENT_VIEW_CHANGED:"viewchanged",EVENT_VIEWTYPE_CHANGED:"viewtypechanged",EVENT_VIEW_REFRESH:"viewrefresh",EVENT_VIEW_REFRESH_INFO:"viewrefreshinfo",EVENT_VIEWPAGE_CHANGED:"viewpagechanged",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.View.instance)||(SYNO.SDS.VideoStation2.View.instance=new SYNO.SDS.VideoStation2.View),SYNO.SDS.VideoStation2.View.instance},getAllTypes:function(){return[SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL,SYNO.SDS.VideoStation2.View.TYPE_TILE,SYNO.SDS.VideoStation2.View.TYPE_LIST]}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED),this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED),this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH),this.addEvents(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO),this.viewType=SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL},setPageView:function(t){this.view!==t?(this.view=t,this.fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED)):this.fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH)},toHomePageView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE),this.setPage(null,!1)},toPlaylistView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST),this.setPage(null,!1)},toPosterView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_POSTER)},toDetailView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_DETAIL),this.setPage(null,!1)},toTVShowView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_TVSHOW),this.setPage(null,!1)},toScheduleView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE),this.setPage(null,!1)},toDTVView:function(){this.setPageView(SYNO.SDS.VideoStation2.View.VIEW_DTV),this.setPage(null,!1)},toEmptyView:function(){this.setPageView(null)},setViewType:function(t){SYNO.Assert(Ext.isString(t),String.format("unexpceted viewtype {0}",t)),this.viewType!==t&&(this.viewType=t,this.fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED))},toThumbnailType:function(){this.setViewType(SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL)},toTileType:function(){this.setViewType(SYNO.SDS.VideoStation2.View.TYPE_TILE)},toListType:function(){this.setViewType(SYNO.SDS.VideoStation2.View.TYPE_LIST)},setPage:function(t,e){e||this.view===SYNO.SDS.VideoStation2.View.VIEW_POSTER||(t=null),this.pageFromURL=e,this.page=t,this.fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEWPAGE_CHANGED,t)},getPage:function(){return this.pageFromURL?this.page:null},getView:function(){return this.view},getViewType:function(){return SYNO.Assert(Ext.isString(this.viewType),String.format("unexpceted viewtype {0}",this.viewType)),this.viewType},view:null,viewType:null,page:null,pageFromURL:!1}),Ext.define("SYNO.SDS.VideoStation2.Hash",{statics:{EVENT_HASH_CHANGED:"hashchanged",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Hash.instance)||(SYNO.SDS.VideoStation2.Hash.instance=new SYNO.SDS.VideoStation2.Hash),SYNO.SDS.VideoStation2.Hash.instance}},extend:"Ext.Component",constructor:function(){this.callParent(arguments),this.lockStack={},this.options={},this.replaceState=!1,this.arm()},arm:function(){this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChanged,this),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChanged,this),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CLEARED,this.onCategoryCleared,this),this.mon(SYNO.SDS.VideoStation2.Folder.get(),SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED,this.onFolderChanged,this),this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CHANGED,this.onPlaylistChanged,this),this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CLEARED,this.onPlaylistCleared,this),this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CHANGED,this.onTVShowChanged,this),this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CLEARED,this.onTVShowCleared,this),this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this),this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_SELECT_VIDEO,this.onSelectVideo,this),this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_CHANGED,this.onDTVChanged,this),this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChanged,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWPAGE_CHANGED,this.onViewPageChanged,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.onViewChanged,this),this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET,this.onRecordingSpecificChanged,this),this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR,this.onRecordingSpecificChanged,this)},disarm:function(){this.mun(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChanged,this),this.mun(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChanged,this),this.mun(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CLEARED,this.onCategoryCleared,this),this.mun(SYNO.SDS.VideoStation2.Folder.get(),SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED,this.onFolderChanged,this),this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CHANGED,this.onPlaylistChanged,this),this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CLEARED,this.onPlaylistCleared,this),this.mun(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CHANGED,this.onTVShowChanged,this),this.mun(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_TVSHOW_CLEARED,this.onTVShowCleared,this),this.mun(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this),this.mun(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_SELECT_VIDEO,this.onSelectVideo,this),this.mun(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_CHANGED,this.onDTVChanged,this),this.mun(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChanged,this),this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWPAGE_CHANGED,this.onViewPageChanged,this),this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.onViewChanged,this),this.mun(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET,this.onRecordingSpecificChanged,this),this.mun(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR,this.onRecordingSpecificChanged,this)},onLibraryChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.LIBRARY,SYNO.SDS.VideoStation2.Library.get().cursor),this.updatePath()},onCategoryChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.CATEGORY,SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()),this.lockStack[SYNO.SDS.VideoStation2.Constant.PAGE]=SYNO.SDS.VideoStation2.Constant.PAGE},onCategoryCleared:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.CATEGORY,null),this.updatePath()},onPlaylistChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.PLAYLIST,{id:SYNO.SDS.VideoStation2.Playlist.get().getCurrentID(),title:SYNO.SDS.VideoStation2.Playlist.get().getCurrentPathTitle()}),this.updatePath()},onPlaylistCleared:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.PLAYLIST,null),this.updatePath()},onFolderChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.FOLDER,SYNO.SDS.VideoStation2.Folder.get().getCurrentFolderStack()),this.lockStack[SYNO.SDS.VideoStation2.Constant.PAGE]=SYNO.SDS.VideoStation2.Constant.PAGE},onTVShowChanged:function(){var t=SYNO.SDS.VideoStation2.TVShow.get(),e={id:t.getCurrentID()};t.getCurrentTVShow().hasOwnProperty("library_id")&&Ext.apply(e,{library_id:t.getCurrentTVShow().library_id}),this.setOptions(SYNO.SDS.VideoStation2.Constant.TVSHOW,e),this.lockStack[SYNO.SDS.VideoStation2.Constant.SEASON]=SYNO.SDS.VideoStation2.Constant.SEASON},onTVShowCleared:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.TVSHOW,null),this.setOptions(SYNO.SDS.VideoStation2.Constant.SEASON,null),this.updatePath()},onSeasonChanged:function(){this.options.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.SEASON)&&(this.replaceState=!0),this.setOptions(SYNO.SDS.VideoStation2.Constant.SEASON,SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason()),this.updatePath(SYNO.SDS.VideoStation2.Constant.SEASON)},onSelectVideo:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.VIDEO,SYNO.SDS.VideoStation2.Video.get().getCurrentVideo()),this.updatePath()},onDTVChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.DTV,SYNO.SDS.VideoStation2.DTV.get().getCurrentID()),this.updatePath()},onFilterChanged:function(){var t=SYNO.SDS.VideoStation2.Filter.get(),e=Ext.apply(SYNO.Util.copy(t.getKeywordOption()),t.getFilterOption());this.options.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.FILTER)&&!SYNO.ux.Utils.checkObjectConsistency(e,{})&&(this.replaceState=!0),this.setOptions(SYNO.SDS.VideoStation2.Constant.FILTER,e),this.updatePath()},onViewPageChanged:function(t){this.setOptions(SYNO.SDS.VideoStation2.Constant.PAGE,t),this.updatePath(SYNO.SDS.VideoStation2.Constant.PAGE)},onViewChanged:function(){this.lockStack[SYNO.SDS.VideoStation2.Constant.PAGE]=SYNO.SDS.VideoStation2.Constant.PAGE},onRecordingSpecificChanged:function(){this.setOptions(SYNO.SDS.VideoStation2.Constant.RECORDING_SPECIFIC,SYNO.SDS.VideoStation2.RecordingSpecific.get().getValue()),this.lockStack[SYNO.SDS.VideoStation2.Constant.PAGE]=SYNO.SDS.VideoStation2.Constant.PAGE},setOptions:function(t,e){if(SYNO.ux.Utils.checkObjectConsistency(e,{})||Ext.isEmpty(e))return void(this.options.hasOwnProperty(t)&&delete this.options[t]);this.options[t]=e},getPath:function(){var t="",e={};if(this.options.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.DTV))t="DTV",e=Ext.copyTo({},this.options,SYNO.SDS.VideoStation2.Constant.DTV);else{if(this.options.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.LIBRARY)){var i=SYNO.SDS.VideoStation2.Library.get().getLibraryByOPID(this.options[SYNO.SDS.VideoStation2.Constant.LIBRARY]);t=0===i.id?encodeURIComponent(i.title):"lib"+encodeURIComponent(i.title)}else t="Home";e=this.options}return SYNO.ux.Utils.checkObjectConsistency(e,{})?t:t+"/"+LZString.compressToEncodedURIComponent(Ext.encode(e))},getOptions:function(){return this.options},setOptionsByURL:function(t){if(this.resetData(),-1===t.search("/"))return!1;var e=t.substring(t.search("/")+1,t.length),i=LZString.decompressFromEncodedURIComponent(e);if(Ext.isEmpty(i))return!1;try{this.options=Ext.decode(i,[!0])}catch(t){return!1}return!0},resetData:function(){this.options={}},updatePath:function(t){t&&delete this.lockStack[t],SYNO.ux.Utils.checkObjectConsistency(this.lockStack,{})&&(this.fireEvent(SYNO.SDS.VideoStation2.Hash.EVENT_HASH_CHANGED,this.replaceState),this.replaceState=!1)},unUpdatePath:function(t){void 0!==t&&(this.lockStack[t]=t)}}),Ext.define("SYNO.SDS.VideoStation2.Navigation",{statics:{EVENT_NAVIGATION_PATH_CHANGED:"navpathchanged",EVENT_NAVIGATION_TYPE_CHANGED:"navtypechanged",EVENT_NAVIGATION_GOBACK:"navgoback",TYPE_PATH:"path",TYPE_CATEGORY:"category",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Navigation.instance)||(SYNO.SDS.VideoStation2.Navigation.instance=new SYNO.SDS.VideoStation2.Navigation),SYNO.SDS.VideoStation2.Navigation.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.addEvents(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_PATH_CHANGED),this.addEvents(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_TYPE_CHANGED),this.addEvents(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_GOBACK),this.toCategory()},setNavigation:function(t,e){t&&(SYNO.Assert(Ext.isString(t),String.format("unexpceted type {0}",t)),this.current_type!==t&&(this.current_type=t,this.fireEvent(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_TYPE_CHANGED))),Ext.isArray(e)&&Ext.isArray(this.current_path)&&SYNO.ux.Utils.checkObjectConsistency(this.current_path,e)||(this.current_path=e,this.fireEvent(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_PATH_CHANGED))},toPath:function(t){this.setNavigation(SYNO.SDS.VideoStation2.Navigation.TYPE_PATH,t)},toCategory:function(){this.setNavigation(SYNO.SDS.VideoStation2.Navigation.TYPE_CATEGORY,null)},goback:function(){this.fireEvent(SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_GOBACK)},getCurrentPath:function(){return this.current_path},getCurrentType:function(){return SYNO.Assert(Ext.isString(this.current_type),String.format("unexpceted nav type {0}",this.current_type)),this.current_type},current_path:null,current_type:null}),Ext.define("SYNO.SDS.VideoStation2.RecordingSpecificController",{extend:"Ext.Component",statics:{instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.RecordingSpecificController.instance)||(SYNO.SDS.VideoStation2.RecordingSpecificController.instance=new SYNO.SDS.VideoStation2.RecordingSpecificController),SYNO.SDS.VideoStation2.RecordingSpecificController.instance}},constructor:function(){this.callParent(arguments),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChanged,this),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CLEARED,this.onCategoryChanged,this)},onCategoryChanged:function(){SYNO.SDS.VideoStation2.Category.get().isCurrentRecordingSpecific()||SYNO.SDS.VideoStation2.RecordingSpecific.get().resetData()},handleRecordingSpecific:function(t,e){var i=SYNO.SDS.VideoStation2.RecordingSpecific.get();SYNO.SDS.VideoStation2.Constant.CHANNEL===t?i.selectChannel(e):SYNO.SDS.VideoStation2.Constant.PROGRAM===t?i.selectProgram(e):i.resetData()}}),Ext.define("SYNO.SDS.VideoStation2.Sort",{statics:{instance:null,EVENT_SORT_CHANGED:"sortchanged",SORT_RECENTLY_ADDED:"recently_added",SORT_RECENTLY_RELEASED:"recently_released",SORT_TITLE:"title",DIR_DESC:"desc",DIR_ASC:"asc",get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Sort.instance)||(SYNO.SDS.VideoStation2.Sort.instance=new SYNO.SDS.VideoStation2.Sort),SYNO.SDS.VideoStation2.Sort.instance},getAllSorts:function(){return[SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Sort.SORT_TITLE]},getAllDirections:function(){return[SYNO.SDS.VideoStation2.Sort.DIR_ASC,SYNO.SDS.VideoStation2.Sort.DIR_DESC]}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments),this.resetSort()},setSort:function(t,e){var i=!1;null!==t&&(SYNO.Assert(Ext.isString(t),String.format("unexpceted sort {0}",t)),this.current_sort!==t&&(this.current_sort=t,i=!0)),null!==e&&(SYNO.Assert(Ext.isString(e),String.format("unexpceted dir {0}",e)),this.current_dir!==e&&(this.current_dir=e,i=!0)),i&&(SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL&&this.saveSortPreference(),this.fireEvent(SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED))},resetSort:function(){this.setSort(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Sort.DIR_DESC)},setSortType:function(t){this.setSort(t,null)},setSortDir:function(t){this.setSort(null,t)},saveSortPreference:function(){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance",this.getPreferenceKey(),{sort_by:this.current_sort,sort_direction:this.current_dir})},loadSortPreference:function(){var t=SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance",this.getPreferenceKey());Ext.isObject(t)?(this.current_sort=t.sort_by,this.current_dir=t.sort_direction):(this.current_sort=SYNO.SDS.VideoStation2.Sort.SORT_TITLE,this.current_dir=SYNO.SDS.VideoStation2.Sort.DIR_ASC),this.fireEvent(SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED)},getCurrentSort:function(){return SYNO.Assert(Ext.isString(this.current_sort),String.format("unexpceted sort {0}"),this.current_sort),this.current_sort},getCurrentSortDir:function(){return SYNO.Assert(Ext.isString(this.current_dir),String.format("unexpceted sort dir {0}"),this.current_dir),this.current_dir},getSortOption:function(){
var t={};switch(this.current_sort){case SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED:t.sort_by="added";break;case SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_RELEASED:t.sort_by="date";break;case SYNO.SDS.VideoStation2.Sort.SORT_TITLE:t.sort_by="title"}return this.current_dir&&(t.sort_direction=this.current_dir),t},getPreferenceKey:function(){return SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType()+"sortstate"},current_sort:null,current_dir:null}),Ext.define("SYNO.SDS.VideoStation2.VideoListController",{statics:{toNone:function(){SYNO.SDS.VideoStation2.Category.get().toNone(),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1)},toAvailableCategory:function(t){var e=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory(),i=e===SYNO.SDS.VideoStation2.Category.CATEGORY_NONE,o=SYNO.SDS.VideoStation2.Category.isAvilableCategoryWithType(t,e);!i&&o||SYNO.SDS.VideoStation2.VideoListController.toRecentlyAddedCategory()},toRecentlyAddedCategory:function(){SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.Sort.get().setSort(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED,SYNO.SDS.VideoStation2.Sort.DIR_DESC)},toRecentlyWatchCategory:function(){SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1)},toRecentlyReleasedCategory:function(){SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.Sort.get().setSort(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_RELEASED,SYNO.SDS.VideoStation2.Sort.DIR_DESC)},toAllCategory:function(){SYNO.SDS.VideoStation2.Folder.get().resetData(),SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_ALL),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.Sort.get().loadSortPreference()},toFolderCategory:function(){SYNO.SDS.VideoStation2.Folder.get().resetData(),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER)},toChannelCategory:function(){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL),SYNO.SDS.VideoStation2.VideoListController.toAvailableSort(SYNO.SDS.VideoStation2.Constant.TV_RECORDING)},toProgramCategory:function(){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM),SYNO.SDS.VideoStation2.VideoListController.toAvailableSort(SYNO.SDS.VideoStation2.Constant.TV_RECORDING)},toTimeLineCategory:function(){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.CATEGORY_TIME_LINE)},toAvailableSort:function(t){var e=t===SYNO.SDS.VideoStation2.Constant.PLAYLIST,i=SYNO.SDS.VideoStation2.Category.get().isCurrentRecordingSpecific(),o=e&&SYNO.SDS.VideoStation2.Sort.get().getCurrentSort()===SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED;(i||o)&&SYNO.SDS.VideoStation2.VideoListController.toSortType(SYNO.SDS.VideoStation2.Sort.SORT_TITLE)},toSortType:function(t){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.Sort.get().setSortType(t)},toSortDirection:function(t){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.Sort.get().setSortDir(t)},toSelectMode:function(t,e){var i=SYNO.SDS.VideoStation2.Video.get();i.clearVideoSelection(),t?i.enterSelectMode():i.leaveSelectMode(),e&&(t?SYNO.SDS.VideoStation2.BrowsingAction.get().toSelect():SYNO.SDS.VideoStation2.BrowsingAction.get().toList())}}}),Ext.define("SYNO.SDS.VideoStation2.Controller",{statics:{setBackdrop:function(t){var e=String.format('url("{0}")',t);SYNO.SDS.VideoStation2.Window.getEl().select(".background-poster").each(function(t){t.setStyle("background-image",e)})},switchLibrary:function(t){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.LIBRARY),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1);var e=SYNO.SDS.VideoStation2.Library.get(),i=SYNO.SDS.VideoStation2.View.get();if(i.toEmptyView(),SYNO.SDS.VideoStation2.Folder.get().resetData(),SYNO.SDS.VideoStation2.Filter.get().clearAllFilter(),SYNO.SDS.VideoStation2.Video.get().clearVideo(),SYNO.SDS.VideoStation2.TVShow.get().clearTVShow(),SYNO.SDS.VideoStation2.Playlist.get().clearSelection(),SYNO.SDS.VideoStation2.RecordingSpecific.get().resetData(),SYNO.SDS.VideoStation2.DTV.get().selectDTV(null),Ext.isString(t)&&e.activate(t),SYNO.SDS.VideoStation2.VideoListController.toAvailableSort(e.getCurrentType()),SYNO.SDS.VideoStation2.Constant.PLAYLIST===e.getCurrentType())return SYNO.SDS.VideoStation2.VideoListController.toNone(),SYNO.SDS.VideoStation2.Controller.intoPlaylistView(),void SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.LIBRARY);SYNO.SDS.VideoStation2.Sort.get().loadSortPreference(),SYNO.SDS.VideoStation2.VideoListController.toAvailableCategory(e.getCurrentType()),SYNO.SDS.VideoStation2.BrowsingAction.get().toList(),i.toPosterView(),SYNO.SDS.VideoStation2.Controller.updatePath(),SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.LIBRARY)},switchLibraryTemporary:function(t){SYNO.SDS.VideoStation2.Library.get().activateTemporary(t)},switchDTV:function(t){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.DTV),SYNO.SDS.VideoStation2.Navigation.get().toPath(null),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.View.get().toEmptyView(),SYNO.SDS.VideoStation2.Filter.get().clearAllFilter(),SYNO.SDS.VideoStation2.Channel.get().clearChannel(),SYNO.SDS.VideoStation2.Library.get().activate(""),SYNO.SDS.VideoStation2.DTV.get().selectDTV(t),t<0?SYNO.SDS.VideoStation2.View.get().toScheduleView():SYNO.SDS.VideoStation2.View.get().toDTVView(),SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.DTV)},refreshView:function(){SYNO.SDS.VideoStation2.View.get().fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH)},refreshViewInfo:function(t){SYNO.SDS.VideoStation2.View.get().fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,t)},intoHomePage:function(t){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.VideoListController.toNone(),SYNO.SDS.VideoStation2.BrowsingAction.get().toNone(),!0!==t&&(SYNO.SDS.VideoStation2.View.get().toEmptyView(),SYNO.SDS.VideoStation2.Filter.get().clearAllFilter()),SYNO.SDS.VideoStation2.Sort.get().resetSort(),SYNO.SDS.VideoStation2.DTV.get().selectDTV(null),SYNO.SDS.VideoStation2.Library.get().activate(""),SYNO.SDS.VideoStation2.Playlist.get().clearSelection(),SYNO.SDS.VideoStation2.Folder.get().resetData(),SYNO.SDS.VideoStation2.Video.get().clearVideo(),SYNO.SDS.VideoStation2.TVShow.get().clearTVShow(),SYNO.SDS.VideoStation2.View.get().toHomePageView(),SYNO.SDS.VideoStation2.Controller.updatePath(),SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE)},intoPlaylistView:function(){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.PLAYLIST),SYNO.SDS.VideoStation2.View.get().getViewType()===SYNO.SDS.VideoStation2.View.TYPE_TILE&&SYNO.SDS.VideoStation2.View.get().toThumbnailType(),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.BrowsingAction.get().toList(),SYNO.SDS.VideoStation2.View.get().toPlaylistView(),SYNO.SDS.VideoStation2.Video.get().clearVideo(),SYNO.SDS.VideoStation2.Playlist.get().clearSelection(),SYNO.SDS.VideoStation2.Controller.updatePath(),SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.PLAYLIST)},intoPosterView:function(t,e,i){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.View.VIEW_POSTER),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),Ext.isDefined(t)&&(SYNO.SDS.VideoStation2.View.get().toEmptyView(),SYNO.SDS.VideoStation2.Constant.PLAYLIST===t?SYNO.SDS.VideoStation2.Playlist.get().selectPlaylist(e,i):SYNO.SDS.VideoStation2.Constant.FOLDER===t&&SYNO.SDS.VideoStation2.Folder.get().selectFolder(e,i)),SYNO.SDS.VideoStation2.Category.get().isCurrentRecordingSpecific()&&SYNO.SDS.VideoStation2.RecordingSpecificController.get().handleRecordingSpecific(t,i),SYNO.SDS.VideoStation2.BrowsingAction.get().toList(),SYNO.SDS.VideoStation2.View.get().toPosterView(),SYNO.SDS.VideoStation2.Video.get().clearVideo(),SYNO.SDS.VideoStation2.TVShow.get().clearTVShow(),SYNO.SDS.VideoStation2.Controller.updatePath(),SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.View.VIEW_POSTER)},setupVideoDetail:function(t){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.BrowsingAction.get().toDetail(),Ext.isObject(t)&&(SYNO.SDS.VideoStation2.Video.get().selectVideo(t),SYNO.SDS.VideoStation2.Controller.preSelectFile(Ext.isNumber(t.file)?t.file:null))},intoVideoDetailFromOfflineVideo:function(t){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.View.VIEW_DETAIL),SYNO.SDS.VideoStation2.Controller.setupVideoDetail(t),SYNO.SDS.VideoStation2.Category.get().selectCategory(SYNO.SDS.VideoStation2.Category.get().getDefaultCategory()),SYNO.SDS.VideoStation2.View.get().toDetailView(),SYNO.SDS.VideoStation2.DTV.get().selectDTV(null),SYNO.SDS.VideoStation2.Library.get().activate(""),SYNO.SDS.VideoStation2.Playlist.get().clearSelection(),SYNO.SDS.VideoStation2.TVShow.get().clearTVShow(),SYNO.SDS.VideoStation2.Controller.updatePath();var e=SYNO.SDS.VideoStation2.Util.getLibraryTypeByVideoType(t.type),i=String.format("{0}-{1}",e,Ext.isDefined(t.library_id)?t.library_id:0);SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(i),e===SYNO.SDS.VideoStation2.Constant.TVSHOW&&(SYNO.SDS.VideoStation2.TVShow.get().selectTVShow({id:t.tvshow_id}),SYNO.SDS.VideoStation2.TVShow.get().selectSeason(t.season)),SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.View.VIEW_DETAIL)},intoVideoDetail:function(t,e){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.VIDEO),Ext.isObject(t)&&SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(String.format("{0}-{1}",SYNO.SDS.VideoStation2.Util.getLibraryTypeByVideoType(t.type),t.library_id)),SYNO.SDS.VideoStation2.Controller.setupVideoDetail(t),Ext.isObject(e)&&SYNO.SDS.VideoStation2.Video.get().setVideoListProxy(e),SYNO.SDS.VideoStation2.View.get().toDetailView(),SYNO.SDS.VideoStation2.Controller.updatePath(),SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.VIDEO)},updateVideoInfo:function(t){SYNO.SDS.VideoStation2.Video.get().selectVideo({id:t.id,type:t.type,pathTitle:t.pathTitle,mapper_id:t.mapper_id,library_id:t.library_id}),SYNO.SDS.VideoStation2.Controller.updatePath()},intoTVShow:function(t){SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.TVSHOW),SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.BrowsingAction.get().toList(),SYNO.SDS.VideoStation2.Video.get().clearVideo(),Ext.isDefined(t)&&SYNO.SDS.VideoStation2.TVShow.get().selectTVShow(t),SYNO.SDS.VideoStation2.View.get().toTVShowView(),SYNO.SDS.VideoStation2.Controller.updatePath(),SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.TVSHOW)},loadFile:function(t){SYNO.SDS.VideoStation2.File.get().loadFile(t)},switchFile:function(t){SYNO.SDS.VideoStation2.File.get().selectFile(t)},preSelectFile:function(t){SYNO.SDS.VideoStation2.File.get().setPreSelectFile(t)},resetSubtitleAndAudiotrack:function(){SYNO.SDS.VideoStation2.File.get().resetSubtitle(),SYNO.SDS.VideoStation2.File.get().resetAudiotrack()},setFilter:function(t,e){if(SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.FILTER),SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST){var i=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo(),o=SYNO.SDS.VideoStation2.Util.getLibraryTypeByVideoType(i.type),n=Ext.isNumber(i.library_id)?i.library_id:0,a=String.format("{0}-{1}",o,n);SYNO.SDS.VideoStation2.Controller.switchLibrary(a)}SYNO.SDS.VideoStation2.Video.get().clearVideo(),SYNO.SDS.VideoStation2.TVShow.get().clearTVShow(),SYNO.SDS.VideoStation2.Playlist.get().clearSelection();var S=SYNO.SDS.VideoStation2.Library.get();SYNO.SDS.VideoStation2.View.get().toEmptyView(),t===SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD?SYNO.SDS.VideoStation2.Filter.get().setKeyword(e):(SYNO.SDS.VideoStation2.Filter.get().clearAllFilter(),SYNO.SDS.VideoStation2.Filter.get().addFilter(t,e),S.isDeactivated()&&S.activateFromTemporary());var s=SYNO.SDS.VideoStation2.DTV.get().getCurrentID();Ext.isNumber(s)?(SYNO.SDS.VideoStation2.Channel.get().clearChannel(),SYNO.SDS.VideoStation2.View.get().toDTVView()):(S.isDeactivated()?(SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.BrowsingAction.get().toNone(),SYNO.SDS.VideoStation2.View.get().toHomePageView()):(SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1),SYNO.SDS.VideoStation2.BrowsingAction.get().toList(),SYNO.SDS.VideoStation2.VideoListController.toAllCategory(),SYNO.SDS.VideoStation2.View.get().toPosterView()),SYNO.SDS.VideoStation2.Controller.updatePath()),SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.FILTER)},goback:function(){SYNO.SDS.VideoStation2.Navigation.get().goback()},getClassificationString:function(t,e){var i="";return i=e===SYNO.SDS.VideoStation2.Constant.HOME_VIDEO&&t===SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED?"recently_recoded":t,_VST("classification",i)},getFolderPath:function(t,e){return t!==SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER?null:SYNO.SDS.VideoStation2.Folder.get().getCurrentFolderStack().map(function(t){return{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:t.pathTitle,folder:t}})},getRecordingSpecificPath:function(t,e){var i=SYNO.SDS.VideoStation2.RecordingSpecific.get();if(!SYNO.SDS.VideoStation2.Category.isRecordingSpecificCategory(t)||!i.isSet())return null;var o=t===SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL;return[{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:e},{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:o?i.getCurrentChannel():i.getCurrentProgram(),recording_specific:o?SYNO.SDS.VideoStation2.Constant.CHANNEL:SYNO.SDS.VideoStation2.Constant.PROGRAM}]},updatePath:function(){var t=SYNO.SDS.VideoStation2.Category.get(),e=SYNO.SDS.VideoStation2.Library.get(),i=SYNO.SDS.VideoStation2.View.get(),o=SYNO.SDS.VideoStation2.TVShow.get(),n=SYNO.SDS.VideoStation2.Video.get(),a=SYNO.SDS.VideoStation2.Navigation.get(),S=SYNO.SDS.VideoStation2.Playlist.get(),s=SYNO.SDS.VideoStation2.Controller.getClassificationString(t.getCurrentCategory(),e.getCurrentType()),r=null,l=SYNO.SDS.VideoStation2.Controller.getFolderPath(t.getCurrentCategory(),s),d=SYNO.SDS.VideoStation2.Controller.getRecordingSpecificPath(t.getCurrentCategory(),s);switch(i.getView()){case SYNO.SDS.VideoStation2.View.VIEW_TVSHOW:r=[{view:e.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:e.isDeactivated()?_VST("common","homepage"):s},{view:SYNO.SDS.VideoStation2.View.VIEW_TVSHOW,value:o.getCurrentTVShow().title}];break;case SYNO.SDS.VideoStation2.View.VIEW_DETAIL:r=e.getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST?[{view:SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST,value:_VST("playlist","title")},{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:S.getCurrentPathTitle()},{view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:n.getCurrentPathTitle()}]:Ext.isArray(l)?[].concat({view:e.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:e.isDeactivated()?_VST("common","homepage"):s,folder:SYNO.SDS.VideoStation2.Folder.FOLDER_NULL}).concat(l).concat({view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:n.getCurrentPathTitle()}):Ext.isArray(d)?d.concat({view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:n.getCurrentPathTitle()}):e.getCurrentType()!==SYNO.SDS.VideoStation2.Constant.TVSHOW||Ext.isEmpty(o.getCurrentTVShow())||Ext.isEmpty(o.getCurrentTVShow().title)?[{view:e.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:e.isDeactivated()?_VST("common","homepage"):s},{view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:n.getCurrentPathTitle()}]:[{view:e.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:e.isDeactivated()?_VST("common","homepage"):s},{view:SYNO.SDS.VideoStation2.View.VIEW_TVSHOW,value:o.getCurrentTVShow().title},{view:SYNO.SDS.VideoStation2.View.VIEW_DETAIL,value:n.getCurrentPathTitle()}];break;case SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST:r=[{view:SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST,value:_VST("playlist","title")}];break;case SYNO.SDS.VideoStation2.View.VIEW_POSTER:e.getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST?r=[{view:SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST,value:_VST("playlist","title")},{view:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:S.getCurrentPathTitle()}]:Ext.isArray(l)&&l.length>0?r=[].concat({view:e.isDeactivated()?SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.View.VIEW_POSTER,value:e.isDeactivated()?_VST("common","homepage"):s,folder:SYNO.SDS.VideoStation2.Folder.FOLDER_NULL}).concat(l):Ext.isArray(d)&&(r=d)}r?a.toPath(r):a.toCategory()}}}),Ext.define("SYNO.SDS.VideoStation2.DTVUtil",{singleton:!0,bandwidthValidator:function(t){return Ext.isNumber(t)||(t=parseInt(t,10)),0===t||2e4>=t&&3e3<=t},lengthAndEmptyValidator:function(t,e){return SYNO.SDS.VideoStation2.Util.lengthValidator(t,e)&&!Ext.isEmpty(t.trim())},getWeekdayString:function(t){switch(Ext.isString(t)&&(t=parseInt(t,10)),t){case 0:return _VST("repeat","schedule_sun");case 1:return _VST("repeat","schedule_mon");case 2:return _VST("repeat","schedule_tue");case 3:return _VST("repeat","schedule_wed");case 4:return _VST("repeat","schedule_thu");case 5:return _VST("repeat","schedule_fri");case 6:return _VST("repeat","schedule_sat")}},getProgramStatus:function(t){switch(t){case 0:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_NONE;case 1:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_PASS;case 2:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_STREAMING;case 3:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_RECORDING;case 4:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_SCHEDULED;case 22:return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_REPEAT_SCHEDULED}},getScheduleStatus:function(t){switch(t){case 0:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_ERROR;case 1:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WAIT;case 2:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_STREAMING;case 3:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_RECORDING;case 4:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DONGLE_NOT_FOUND;case 5:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_RECORDING_INTERRUPT;case 6:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DONE;case 7:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_NO_PERMISSION;case 8:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_USER_INVALID;case 9:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_NO_QUOTA;case 10:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_VOLUME_FULL;case 11:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_CREATE_FILE_ERROR;case 12:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WEEKLY_SCHEDULE;case 13:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DAILY_SCHEDULE;case 14:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_VLC_INTERRUPT;case 15:return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_SKIP}},getScheduleStatusString:function(t){switch(t){case 0:return _T("error","error_error");case 1:return _VST("record","task_waiting");case 2:return _VST("streaming","streaming_for_someone");case 3:return _VST("action","recording");case 4:return _VST("error","no_dtv_dongle");case 5:return _VST("record","record_interrupt");case 6:return _VST("record","task_finished");case 7:return _VST("error","record_dest_deny");case 8:return _VST("error","invalid_user");case 9:return _VST("error","record_quota_reached");case 10:return _VST("error","record_no_volume");case 11:return _VST("error","record_dest_not_exist");case 12:return _VST("repeat","repeat_weekly");case 13:return _VST("repeat","repeat_daily");case 14:return _VST("record","record_interrupt");case 15:return _VST("record","skip")}},getTunerPort:function(t){return 9025+t%16},getStreamingURL:function(t){var e=window.location;return String.format("{0}//{1}{2}VideoStation/livestreaming/{3}",e.protocol,e.host,e.pathname.substr(0,e.pathname.lastIndexOf("/")+1),t)},isScheduleStatusRepeatSchedule:function(t){var e=SYNO.SDS.VideoStation2.DTVUtil.getScheduleStatus(t);return SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WEEKLY_SCHEDULE===e||SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DAILY_SCHEDULE===e},isProgramStatusRepeatSchedule:function(t){var e=SYNO.SDS.VideoStation2.DTVUtil.getProgramStatus(t);return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_REPEAT_SCHEDULED===e||SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_DAILY_SCHEDULED===e},isDailySchedule:function(t){var e=SYNO.SDS.VideoStation2.DTVUtil.getProgramStatus(t);return SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_DAILY_SCHEDULED===e},durationFormatter:function(t){var e=t%86400;return[("00"+Math.floor(e/3600)).substr(-2),("00"+Math.floor(e%3600/60)).substr(-2),("00"+Math.floor(e%60)).substr(-2)].join(":")},durationParser:function(t){var e=t.match(/^(\d{2}):(\d{2})$/);return e?3600*parseInt(e[1],10)+60*parseInt(e[2],10):-1},scheduleStatusIconRenderer:function(t){var e=SYNO.SDS.VideoStation2.DTVUtil.getScheduleStatus(t);return SYNO.SDS.VideoStation2.DTVUtil.getDTVStatusIcon(e)},programStatusIconRenderer:function(t){var e=SYNO.SDS.VideoStation2.DTVUtil.getProgramStatus(t);return SYNO.SDS.VideoStation2.DTVUtil.getDTVStatusIcon(e)},getDTVStatusIcon:function(t){var e="";switch(t){case SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_RECORDING:e="recording";break;case SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_SCHEDULED:case SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WAIT:e="time";break;case SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_REPEAT_SCHEDULED:case SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WEEKLY_SCHEDULE:case SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DAILY_SCHEDULE:e="loop"}return Ext.isEmpty(e)?"":String.format('<div class="status {0}"></div>',e)}}),Ext.define("SYNO.SDS.VideoStation2.Player",{statics:{EVENT_PLAYER_LOAD:"playerload",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.Player.instance)||(SYNO.SDS.VideoStation2.Player.instance=new SYNO.SDS.VideoStation2.Player),SYNO.SDS.VideoStation2.Player.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments)},loadPlayer:function(t){if(SYNO.Assert(Ext.isArray(t),String.format("bad player object array {0}",t)),this.players=[],SYNO.VideoController2.ChromecastPlayer.isCastAvailable()){var e={title:_VST("controller","chromecast_mode"),id:SYNO.VideoController2.Util.CHROMECAST_ID};this.players=this.players.concat(e)}this.players=this.players.concat(t),this.current_idx=null,this.streaming=!0,this.fireEvent(SYNO.SDS.VideoStation2.Player.EVENT_PLAYER_LOAD)},selectPlayer:function(t){SYNO.Assert(Ext.isString(t),"bad player id"),this.current_idx=null,this.streaming=!0,Ext.each(this.players,function(e,i){if(e.id===t)return this.current_idx=i,this.streaming=!1,!1},this)},getCurrentID:function(){return this.streaming?SYNO.SDS.VideoStation2.Constant.PLAYER_STREAMING:(SYNO.Assert(Ext.isNumber(this.current_idx)&&Ext.isArray(this.players)&&!Ext.isEmpty(this.players),"player not set"),this.players[this.current_idx].id)},getAllPlayers:function(){return SYNO.Util.copy(this.players)},players:null,current_idx:null,streaming:!0}),Ext.define("SYNO.SDS.VideoStation2.PlaybackController",{statics:{loadPlayer:function(){var t={success:function(t,e,i){SYNO.SDS.VideoStation2.Player.get().loadPlayer(t.device)},failure:function(){SYNO.SDS.VideoStation2.Player.get().loadPlayer([])}};SYNO.SDS.VideoStation2.OP.get().listPlayer({limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT},t)},selectPlayer:function(t){SYNO.SDS.VideoStation2.Player.get().selectPlayer(t)},selectSubtitle:function(t){SYNO.SDS.VideoStation2.File.get().selectSubtitle(t)},selectAudiotrack:function(t){SYNO.SDS.VideoStation2.File.get().selectAudiotrack(t)},launchVideoPlayer:function(t,e,i){var o=null,n=SYNO.SDS.VideoStation2.Library.get().getCurrentType();if(n===SYNO.SDS.VideoStation2.Constant.PLAYLIST)n=SYNO.SDS.VideoStation2.Constant.COLLECTION,o=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID();else if(n===SYNO.SDS.VideoStation2.Constant.TVSHOW){var a=SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow();o=Ext.isObject(a)?a.id:null}var S={file_id:t.file_id,player_id:SYNO.SDS.VideoStation2.Player.get().getCurrentID(),title:"",browse_type:n,type_id:o,sort_info:SYNO.SDS.VideoStation2.Sort.get().getSortOption(),video_id:t.video_id,video_type:t.video_type,subtitle_id:t.subtitle_id||null,audiotrack_id:t.audiotrack_id||null},s=function(t){var e=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();e.id===t.video_id&&e.type===t.type||SYNO.SDS.VideoStation2.Controller.intoVideoDetail({id:t.video_id,type:t.type})},r=function(t){t=t||SYNO.SDS.WindowMgr.front,SYNO.SDS.VideoStation2.Window.mon(t,"close",function(){SYNO.SDS.VideoStation2.Util.applyCallback(e),SYNO.SDS.VideoStation2.Window.mun(t,"videochange",s)},{single:!0}),SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_DETAIL&&SYNO.SDS.VideoStation2.Window.mon(t,"videochange",s)},l=new Promise(function(t,e){return S.player_id!==SYNO.VideoController2.Util.CHROMECAST_ID?t():SYNO.VideoController2.ChromecastPlayer.init().then(function(){SYNO.VideoController2.ChromecastPlayer.launchCast().then(t)})});i=i||!1;var d=new Promise(function(t,e){if(!i)return t({});var o=function(e){return t({subtitle_id:e.subtitle_id||SYNO.VideoController2.Util.SUBTITLE_NONE,audiotrack_id:e.audio_track})};return SYNO.SDS.VideoStation2.PromiseOP.get().getPlaybackSetting({id:S.file_id}).then(o)});Promise.all([l,d]).then(function(t){var e=t[1];SYNO.SDS.AppLaunch("SYNO.VideoController2.Application",Ext.apply(S,e),!1,r)})},launchVideoPlayerWithDTV:function(t){var e={dtv_url:SYNO.SDS.VideoStation2.DTVUtil.getStreamingURL(t.tuner)};SYNO.SDS.AppLaunch("SYNO.VideoController2.Application",e,!1)}}}),Ext.define("SYNO.SDS.VideoStation2.ActionDataView",{extend:"SYNO.SDS.Utils.DataView.LazyDataView",statics:{ACTION_ADD:"add",ACTION_PLAY:"play",ACTION_MORE:"more",ACTION_PLAYLIST_EDIT:"playlist-edit",ACTION_PLAYLIST_MORE:"playlist-more"},disableAction:!1,enableSelectMode:!1,videoType:null,trackResetOnLoad:!1,constructor:function(){this.callParent(arguments),this.addClass("action-dataview"),this.disableAction&&this.addClass("hide-action"),this.enableSelectMode&&(this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED,this.onVideoSelectModeChange,this),this.onVideoSelectModeChange(),this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED,this.onVideoSelectionChange,this)),this.mon(this,"beforedestroy",this.onBeforeDestroy,this),this.mon(this,"activate",this.onActivate,this),this.mon(this,"deactivate",this.onDeactivate,this)},hideAction:function(){this.disableAction||this.addClass("hide-action")},showAction:function(){this.disableAction||this.removeClass("hide-action")},getVideoData:function(t){return{id:this.getVideoID(t),type:this.getVideoType(t),pathTitle:this.getVideoTitle(t),mapper_id:this.getVideoMapperID(t),library_id:this.getLibraryID(t)}},getLibraryID:function(t){return t.get("library_id")||0},getVideoType:function(t){return t.get("type")||this.videoType||SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType()},getVideoID:function(t){return t.get("id")},getVideoMapperID:function(t){return t.get("mapper_id")},getVideoTitle:function(t){return t.get("title")},getVideoPlaylists:function(t){return t.get("additional")&&t.get("additional").collection?t.get("additional").collection:null},getSeasonEpisode:function(t){return Ext.isNumber(t.get("season"))&&Ext.isNumber(t.get("episode"))?{season:t.get("season"),episode:t.get("episode")}:null},getVideoFile:function(t){return null},getRecordBySelection:function(t){var e,i=this.getStore();if(-1!==(e=SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST?i.findExact("mapper_id",t.mapper_id):i.findExact("id",t.id))){var o=i.getAt(e);if(this.getVideoType(o)===t.type)return o}},formRelatedSelections:function(t){var e=this.getRecordBySelection(t);return t.record=e,[t]},startVideoAction:function(t){this.clearVideoSelection(),this.addVideoSelection(t)},clearVideoSelection:function(){SYNO.SDS.VideoStation2.Video.get().clearVideoSelection()},addVideoSelection:function(t){SYNO.SDS.VideoStation2.Video.get().addVideoSelection(this.getVideoID(t),this.getVideoMapperID(t),this.getVideoType(t),this.getVideoFile(t),this.getVideoPlaylists(t),this.getSeasonEpisode(t),this.getLibraryID(t))},removeVideoSelection:function(t){SYNO.SDS.VideoStation2.Video.get().removeVideoSelection(this.getVideoID(t),this.getVideoMapperID(t),this.getVideoType(t),this.getVideoFile(t),this.getVideoPlaylists(t))},toggleVideoSelection:function(t){SYNO.SDS.VideoStation2.Video.get().toggleVideoSelection(this.getVideoID(t),this.getVideoMapperID(t),this.getVideoType(t),this.getVideoFile(t),this.getVideoPlaylists(t),this.getSeasonEpisode(t))},hasVideoSelection:function(t){return SYNO.SDS.VideoStation2.Video.get().hasVideoSelection(this.getVideoID(t),this.getVideoMapperID(t),this.getVideoType(t),this.getVideoFile(t))},isVideoSelectionEmpty:function(){return SYNO.SDS.VideoStation2.Video.get().isVideoSelectionEmpty()},onActivate:function(){var t=this.getStore();this.bindStore(t),this.mon(t,"load",this.onVideoSelectionChange,this),this.onVideoSelectionChange()},onDeactivate:function(){var t=this.getStore();this.mun(t,"load",this.onVideoSelectionChange,this),this.bindStore(null)},onVideoSelectModeChange:function(){this.enableSelectMode&&(SYNO.SDS.VideoStation2.Video.get().isInSelectMode()?this.hideAction():(this.lastSelect=null,this.showAction()))},onVideoSelectionChange:function(){if(this.enableSelectMode&&!this.hidden&&SYNO.SDS.VideoStation2.Video.get().isInSelectMode()){var t=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();this.getNodes().each(function(t){Ext.fly(t).removeClass("x-view-selected")}),t.each(function(t){var e=this.getRecordBySelection(t);if(e){var i=this.getNode(e);Ext.fly(i).addClass("x-view-selected")}},this)}},onStoreLoad:function(){this.updateScrollbar(this.trackResetOnLoad),this.fireEvent("afterUpdateScrollbar",this)},onClick:function(t,e,i){var o=Ext.fly(e),n=t.getTarget(this.itemSelector,this.getTemplateTarget()),a=null;n&&(a=this.getRecord(n));var S=SYNO.SDS.VideoStation2.Video.get().isInSelectMode()
;o.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_ADD)?this.onActionAddClick(this,t,a):o.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_PLAY)?this.onActionPlayClick(this,t,a):o.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_MORE)?this.onActionMoreClick(this,t,a):o.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_PLAYLIST_EDIT)?this.onActionPlaylistEditClick(this,t,a):o.hasClass(SYNO.SDS.VideoStation2.ActionDataView.ACTION_PLAYLIST_MORE)?this.onActionPlaylistMoreClick(this,t,a):this.enableSelectMode&&a?(!t.ctrlKey&&!t.shiftKey||S||(SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!0,!0),S=!0),S?this.onSelect(this,t,a):this.callParent(arguments)):this.callParent(arguments)},onActionAddClick:function(t,e,i){this.startVideoAction(i);var o=this.getVideoPlaylists(i);o&&(o=o.map(function(t){return t.id}));var n=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID(),a=function(t){return o&&-1!==o.indexOf(t.id)?"checked":""},S=function(t){return n===t.id},s=SYNO.SDS.VideoStation2.PlaylistController.createPlaylistActions({clsFn:a,hideOnClickFn:S,createPlaylistFn:this.onCreatePlaylist,clickPlaylistFn:this.onPlaylistClick},this);new SYNO.SDS.VideoStation2.OneTimeDropdownMenu({items:s}).showAt(e.getXY())},onActionPlayClick:function(t,e,i){this.onActionPlayClickImp(t,e,i,SYNO.SDS.VideoStation2.Controller.refreshView)},onActionPlayClickImp:function(t,e,i,o){this.startVideoAction(i);var n=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(n,function(t){SYNO.SDS.VideoStation2.PlaybackController.selectPlayer(SYNO.SDS.VideoStation2.Constant.PLAYER_STREAMING),SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayer({file_id:t.id,video_id:n.id,video_type:n.type},{fn:o},!0)},!0)},onActionMoreClick:function(t,e,i){this.startVideoAction(i);var o=this.filterNotAllowedAction(SYNO.SDS.VideoStation2.ActionUtil.getAvailableVideoActions(),i),n=o.map(function(t){return new Ext.Action({text:SYNO.SDS.VideoStation2.Util.getVideoActionString(t),itemId:t,scope:this,handler:this.onVideoAction})},this);new SYNO.SDS.VideoStation2.OneTimeDropdownMenu({noicon:!0,items:n}).showAt(e.getXY())},onActionPlaylistEditClick:function(t,e,i){Ext.fly(e.target).hasClass("x-item-disabled")||SYNO.SDS.VideoStation2.PlaylistActionController.doPlaylistAction(SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT,i.id)},onActionPlaylistMoreClick:function(t,e,i){if(!Ext.fly(e.target).hasClass("x-item-disabled")){var o=i.id,n=[];SYNO.SDS.VideoStation2.ActionUtil.getAvailablePlaylistActions().each(function(t){t!==SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_EDIT&&n.push(new Ext.Action({text:_VST("playlist",t),itemId:t,disabled:t===SYNO.SDS.VideoStation2.PlaylistActionController.ACTION_DELETE&&o<0,handler:SYNO.SDS.VideoStation2.PlaylistActionController.doPlaylistAction.createDelegate(this,[t,o])}))},this);new SYNO.SDS.VideoStation2.OneTimeDropdownMenu({noicon:!0,items:n}).showAt(e.getXY())}},onCreatePlaylist:function(t){var e=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];if(this.getRecordBySelection(e)){var i=this.formRelatedSelections(e),o=function(t){SYNO.SDS.VideoStation2.PlaylistController.applyPlaylistChangeToVideo(i,t,!0)};SYNO.SDS.VideoStation2.VideoActionController.createPlaylist([e],o)}},onPlaylistClick:function(t){var e=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];if(this.getRecordBySelection(e)){var i=this.formRelatedSelections(e),o=!t.getEl().hasClass("checked"),n=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(parseInt(t.itemId,10)),a=Ext.emptyFn;a=n.id===SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()?SYNO.SDS.VideoStation2.Controller.refreshView:this.onPlaylistAddRemove.createDelegate(this,[i,n,o,t]),SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist([e],n.id,o,a)}},onPlaylistAddRemove:function(t,e,i,o){o&&!o.isDestroyed&&o.getEl()[i?"addClass":"removeClass"]("checked"),SYNO.SDS.VideoStation2.PlaylistController.applyPlaylistChangeToVideo(t,e,i)},onVideoAction:function(t){var e=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()[0];if(this.getRecordBySelection(e)){var i=this.formRelatedSelections(e),o=Ext.emptyFn;switch(t.itemId){case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED:o=SYNO.SDS.VideoStation2.VideoActionController.applyWatchStatusChangeToVideo(i,!0);break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED:o=SYNO.SDS.VideoStation2.VideoActionController.applyWatchStatusChangeToVideo(i,!1);break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA:o=SYNO.SDS.VideoStation2.Controller.refreshView}SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(t.itemId,[e],o)}},onBeforeDestroy:function(){this.getStore().destroy()},onSelect:function(t,e,i){if(Ext.isNumber(this.getVideoID(i))){var o=this.getStore();if(e.shiftKey&&this.lastSelect){this.clearVideoSelection();for(var n=[o.indexOf(this.lastSelect),o.indexOf(i)].sortBy(function(t){return t}),a=n[0];a<=n[1];++a){var S=o.getAt(a);Ext.isNumber(this.getVideoID(S))&&this.addVideoSelection(S)}}else this.hasVideoSelection(i)||(this.lastSelect=i),this.toggleVideoSelection(i),this.lastSelect&&!this.hasVideoSelection(this.lastSelect)&&(this.lastSelect=null),e.ctrlKey&&this.isVideoSelectionEmpty()&&SYNO.SDS.VideoStation2.VideoListController.toSelectMode(!1,!0)}},filterNotAllowedAction:function(t,e){var i=e.get("additional")?e.get("additional").watched_ratio:0,o=e.get("type")===SYNO.SDS.VideoStation2.Constant.FILE;return t.filter(function(t){return(t!==SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA||!o)&&(!(t===SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA&&!o)&&((t!==SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED||!SYNO.SDS.VideoStation2.Util.isWatched(i))&&((t!==SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED||!SYNO.SDS.VideoStation2.Util.isUnwatched(i))&&t!==SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE)))})},getTitle:function(t){return Ext.isString(t.title)?t.title:""},getWatchedInfo:function(t){var e=!0===SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","show_unwatched_dot"),i=0===(t.additional?t.additional.watched_ratio:0),o=Ext.isNumber(t.additional&&t.additional.total_seasons),n=Ext.isArray(t.preview_video);return e&&i&&!o&&!n?SYNO.SDS.VideoStation2.Constant.CLASS.UNWATCHED:""},getStore:function(){SYNO.Debug.error("need to implement interface getStore")},getImageURL:function(){SYNO.Debug.error("need to implement interface getImageURL")}}),Ext.define("SYNO.SDS.VideoStation2.CompositeMenu",{extend:"SYNO.SDS.VideoStation2.BasicMenu",alignTarget:null,constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-composite-menu")},show:function(t,e,i){this.callParent(arguments),this.alignTarget&&(t=this.alignTarget.getEl()||t),this.items.each(function(t){t.fireEvent("activate")})}}),Ext.define("SYNO.SDS.VideoStation2.EditorGridPanel",{extend:"SYNO.ux.EditorGridPanel",xtype:"syno_vs_editorgrid",constructor:function(){this.callParent(arguments),this.addClass("syno-vs2-editorgridpanel")}}),Ext.define("SYNO.SDS.VideoStation2.EnableColumn",{extend:"SYNO.ux.EnableColumn",constructor:function(){this.callParent(arguments)},isIgnore:function(t,e){return Ext.isEmpty(this.ignoreKey)?this.callParent(arguments):!0===e.get(this.ignoreKey)},renderer:function(t,e,i,o,n,a){var S=this.scope;return Ext.isString(S.ignoreKey)&&!0===i.get(S.ignoreKey)?SYNO.SDS.VideoStation2.EnableColumn.superclass.renderer.call(this,"gray",e,i,o,n,a):SYNO.SDS.VideoStation2.EnableColumn.superclass.renderer.apply(this,arguments)}}),Ext.define("SYNO.SDS.VideoStation2.FileChooser",{extend:"SYNO.SDS.Utils.FileChooser.Chooser",constructor:function(t){var e={usage:{type:"chooseDir"},folderToolbar:!0,treeFilter:function(t,e){return!e||"/home"!==e.spath&&"/homes"!==e.spath&&"remote"!==e.mountType},listeners:{afterrender:this.addButtonClass}};this.callParent([Ext.apply(e,t)]),this.addClass("syno-vs2-filechooser"),this.addClass("syno-vs2-dialog")},addButtonClass:function(){Ext.each(["","-blue","-default"],function(t){this.getEl().select(String.format("span.x-btn.syno-ux-button{0}",t)).each(function(e){e.addClass(String.format("syno-vs2-button{0}",t))})},this)},getMsgBox:function(t){if(!this.msgBox||this.msgBox.isDestroyed){var e=t&&t.owner||this;e=e.isDestroyed?null:e,this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:e})}return this.callParent(arguments)},createFolder:function(){return this.crtDialog&&!this.crtDialog.isDestroyed||(this.crtDialog=new SYNO.SDS.VideoStation2.FileChooser.CrtFdrDialog({RELURL:this.RELURL,owner:this,cls:this.initialConfig.cls})),this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.FileChooser.CrtFdrDialog",{extend:"SYNO.SDS.Utils.FileChooser.CrtFdrDialog",constructor:function(){this.callParent(arguments),this.addClass(["syno-vs2-dialog","syno-vs2-filechooser-crtfdrdialog"]),this.buttons.each(function(t){t.addClass("syno-vs2-button")});var t=this.items.get(0);t.addClass(["syno-ux-formpanel","syno-vs2-form"]),t.getComponent("name").addClass(["syno-vs2-textfield","syno-vs2-base-textfield"])}}),Ext.define("SYNO.SDS.VideoStation2.ComboBox",{statics:{CLASS_MENU_EXPANDED:"menu-expanded"},extend:"SYNO.ux.ComboBox",xtype:"syno_vs_combobox",listClass:"syno-vs2-combobox-list",constructor:function(){this.callParent(arguments),this.addClass("syno-vs2-combobox"),this.mon(this,"expand",this.addExpandedClass,this),this.mon(this,"collapse",this.removeExpandedClass,this)},addExpandedClass:function(){this.addClass(SYNO.SDS.VideoStation2.ComboBox.CLASS_MENU_EXPANDED)},removeExpandedClass:function(){this.removeClass(SYNO.SDS.VideoStation2.ComboBox.CLASS_MENU_EXPANDED)},onDestroy:function(){this.mun(this,"expand",this.addExpandedClass,this),this.mun(this,"collapse",this.removeExpandedClass,this),this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.DisplayField",{extend:"SYNO.ux.DisplayField",xtype:"syno_vs_displayfield",constructor:function(){this.callParent(arguments),this.addClass("syno-vs2-displayfield")}}),Ext.define("SYNO.SDS.VideoStation2.FieldSet",{extend:"SYNO.ux.FieldSet",xtype:"syno_vs_fieldset",constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-fieldset")}}),Ext.define("SYNO.SDS.VideoStation2.NumberField",{extend:"SYNO.ux.NumberField",xtype:"syno_vs_numberfield",constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-numberfield"),this.addClass("syno-vs2-base-textfield")}}),Ext.define("SYNO.SDS.VideoStation2.TextArea",{extend:"SYNO.ux.TextArea",xtype:"syno_vs_textarea",constructor:function(){this.callParent(arguments),this.addClass("syno-vs2-textarea"),this.addClass("syno-vs2-base-textfield")}}),Ext.define("SYNO.SDS.VideoStation2.TimeField",{extend:"SYNO.ux.TimeField",xtype:"syno_vs_timefield",listClass:"syno-vs2-combobox-list",constructor:function(t){this.callParent(arguments),this.addClass("syno-vs2-timefield")}}),Ext.define("SYNO.SDS.VideoStation2.ListView",{extend:"SYNO.SDS.VideoStation2.ActionDataView",constructor:function(t){this.callParent([this.fillConfig(t)])},fillConfig:function(t){Ext.apply(this,t.decorator);var e={tpl:this.getTpl(),cls:"list-view",store:this.getStore(),itemSelector:"div.list-wrap",overClass:"x-view-over",singleSelect:!0};return Ext.apply(e,t),delete e.decorator,e},getTemplateTarget:function(){if(this.el.dom)return this.scrollBar=this.scrollBar||this.el.createChild({tag:"div",style:"display:inline-block;width:100%;"}),this.scrollBar},getTpl:function(){var t=this.decoratorConfig?this.decoratorConfig.thumbCls||"poster":"poster";return new Ext.XTemplate('<tpl for=".">','<div class="list-wrap '+t+'">','<div class="select-mark"></div>',"{[this.getListThumbDiv(values)]}",'<div class="title sds-ellipsis">','<tpl if="this.hasEpisode(values)">{[this.getEpisodeDiv(values)]}</tpl>',"{[this.singleEncode(this.getTitle(values))]}","{[this.getTitleDecorateDiv(values)]}","</div>",'<div class="action">',"{[this.getActionDiv(values)]}","</div>","</div>","</tpl>",'<div class="x-clear"></div>',{getTitle:this.getTitle.createDelegate(this),getEpisodeDiv:function(t){return t.episode?String.format('<span class="episode sds-ellipsis">{0}</span>',String.format(_VST("episode","title"),t.episode)):""},hasEpisode:function(t){return void 0!==t.episode},singleEncode:function(t){return Ext.util.Format.htmlEncode(t)},doubleEncode:function(t){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(t))},getListThumbDiv:this.getListThumbDiv.createDelegate(this),getActionDiv:this.getActionDiv.createDelegate(this),getTitleDecorateDiv:this.getTitleDecorateDiv.createDelegate(this)})},getListThumbDiv:function(t){return""},getTitleDecorateDiv:function(t){return""},getImageStyle:function(t){return""},getDate:function(t){var e=SYNO.SDS.VideoStation2.Util.getVideoDate(t);return Ext.isEmpty(e)?"- -":e},getActionDiv:function(t){return-1!==this.getImageStyle(t).indexOf(SYNO.SDS.VideoStation2.Constant.FOLDER)?"":['<div class="date">'+this.getDate(t)+"</div>",'<div class="watched-info-dot '+this.getWatchedInfo(t)+'"></div>','<div class="add action-btn"></div>','<div class="play action-btn"></div>','<div class="more action-btn"></div>'].join("")}}),Ext.define("SYNO.SDS.VideoStation2.NavigationToolbar",{extend:"SYNO.ux.Toolbar",constructor:function(t){this.callParent(arguments),this.addClass("nav-toolbar")}}),Ext.define("SYNO.SDS.VideoStation2.SlidableDataView",{extend:"SYNO.ux.Panel",statics:{POSITION:{left:-1,center:0,right:1}},dataViewMargin:20,constructor:function(t){SYNO.Assert(Ext.isFunction(t.getView),"need to implement getView");var e=SYNO.SDS.VideoStation2.SlidableDataView.POSITION,i={floating:!0,hidden:!0,shadow:!1};this.views={},this.views[e.center]=t.getView(i),this.views[e.left]=t.getView(i),this.views[e.right]=t.getView(i);var o={cls:"slidable-viewport",layout:"fit",items:Object.values(this.views)};Ext.apply(o,t),this.callParent([o]),this.mon(this,"activate",this.onActivate,this),this.mon(this,"deactivate",this.onDeactivate,this),this.mon(this,"resize",this._onResize,this),this.mon(this,"afterlayout",this._onAfterLayout,this),this.items.each(function(t){this.mon(t,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,function(){t===this.views[e.center]&&this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING)},this),this.mon(t,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,function(){t===this.views[e.center]&&this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},this)},this)},prepareView:function(t,e){var i=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;SYNO.Assert(-1!==Object.values(i).indexOf(t),String.format("unexpected position {0}",t));var o=this.views[t];this._setViewPosition(o,t),o.show(),e||o.fireEvent("activate",t)},intoLeft:function(t){var e=SYNO.SDS.VideoStation2.SlidableDataView.POSITION,i=this._getOriginView();t||this.prepareView(e.left),this._clearSlideClass(),this.views[e.center].addClass("slidable-out"),this.views[e.left].addClass("slidable-in"),this._setViewPosition(this.views[e.center],e.right),this._setViewPosition(this.views[e.left],e.center),this.views[e.right].hide(),this._setViewPosition(this.views[e.right],e.left),this.views[e.right].fireEvent("deactivate"),this.views[e.left]=i[e.right],this.views[e.center]=i[e.left],this.views[e.right]=i[e.center],this._delayClearSlideClass()},intoRight:function(t){var e=SYNO.SDS.VideoStation2.SlidableDataView.POSITION,i=this._getOriginView();t||this.prepareView(e.right),this._clearSlideClass(),this.views[e.center].addClass("slidable-out"),this.views[e.right].addClass("slidable-in"),this._setViewPosition(this.views[e.center],e.left),this._setViewPosition(this.views[e.right],e.center),this.views[e.left].hide(),this._setViewPosition(this.views[e.left],e.right),this.views[e.left].fireEvent("deactivate"),this.views[e.right]=i[e.left],this.views[e.center]=i[e.right],this.views[e.left]=i[e.center],this._delayClearSlideClass()},getLeftView:function(){var t=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;return this.views[t.left]},getRightView:function(){var t=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;return this.views[t.right]},getCenterView:function(){var t=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;return this.views[t.center]},_delayClearSlideClass:function(){this._delayClearSlideClassTask=this._delayClearSlideClassTask||new Ext.util.DelayedTask(this._clearSlideClass,this),this._delayClearSlideClassTask.cancel(),this._delayClearSlideClassTask.delay(800)},_clearSlideClass:function(){Ext.iterate(this.views,function(t,e){e.removeClass(["slidable-in","slidable-out"])})},_setViewPosition:function(t,e){t.setPosition(this._getLeft(e),0)},_getOriginView:function(){var t=SYNO.SDS.VideoStation2.SlidableDataView.POSITION,e={};return e[t.center]=this.views[t.center],e[t.left]=this.views[t.left],e[t.right]=this.views[t.right],e},_onResize:function(){var t=this.getWidth(),e=this.getHeight();Object.values(this.views).each(function(i){i.setSize(t,e)})},_onAfterLayout:function(){var t=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this._setViewPosition(this.views[t.center],t.center),this._setViewPosition(this.views[t.left],t.left),this._setViewPosition(this.views[t.right],t.right)},onActivate:function(){var t=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this.prepareView(t.center)},onDeactivate:function(){this.getCenterView().fireEvent("deactivate")},_getLeft:function(t){return(this.getWidth()+this.dataViewMargin)*t},getView:function(t){SYNO.Debug.error("need to implement getView")}}),Ext.define("SYNO.SDS.VideoStation2.VideoListProxy",{statics:{copyStoreParams:function(t){SYNO.Assert(Ext.isObject(t),["unexpceted params",t]);var e={},i=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();if(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST)Ext.apply(e,SYNO.SDS.VideoStation2.Sort.get().getSortOption()),Ext.apply(e,{id:SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()});else if(i===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL){var o=SYNO.SDS.VideoStation2.Filter.get().getFilterOption();Ext.apply(o,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption()),Ext.apply(e,o),Ext.apply(e,SYNO.SDS.VideoStation2.Sort.get().getSortOption())}else Ext.apply(e,SYNO.SDS.VideoStation2.Category.get().getSortOption());return i===SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER?Ext.apply(e,{id:SYNO.SDS.VideoStation2.Folder.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Library.get().getCurrentType()}):Ext.apply(e,{library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID()}),e.offset=t.offset||0,e.limit=t.limit||100,e}},constructor:function(t){this.callParent(arguments);var e=SYNO.SDS.VideoStation2.Library.get().getCurrentType(),i=e===SYNO.SDS.VideoStation2.Constant.TVSHOW,o=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER,n=t.baseParams;if(this.videolist=t.videolist,Ext.isFunction(t.toVideos)&&(!i||o)){var a=o?SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER:e;a=a===SYNO.SDS.VideoStation2.Constant.PLAYLIST?SYNO.SDS.VideoStation2.Constant.PLAYLIST_VIDEOLIST:a,this.pageSize=n.limit,this.lowBound=n.offset,this.upBound=n.offset+n.limit,this.toVideos=t.toVideos,this.totalCount=t.totalCount,this.store=new SYNO.SDS.VideoStation2.Stores[a]({baseParams:n,listeners:{scope:this,load:function(t,e,i){var o=i.params,n=this.toVideos(e);this.totalCount=t.getTotalCount(),this.lowBound>o.offset?(Array.prototype.unshift.apply(this.videolist,n),this.lowBound=o.offset):(Array.prototype.push.apply(this.videolist,n),this.upBound=o.offset+this.pageSize),SYNO.SDS.VideoStation2.Controller.refreshViewInfo(SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.NEXT_PREV_BTN)}}})}},expandLeft:function(){Ext.isObject(this.store)&&this.lowBound>0&&this.store.load({params:{offset:this.lowBound-this.pageSize}})},expandRight:function(){Ext.isObject(this.store)&&this.upBound<this.totalCount-1&&this.store.load({params:{offset:this.upBound}})}}),Ext.define("SYNO.SDS.VideoStation2.ImageLoadManager",{extend:"Ext.Component",MAX_CONCURRENT:3,running:0,jobs:null,preemptJobs:null,delegate:null,statics:{instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.ImageLoadManager.instance)||(SYNO.SDS.VideoStation2.ImageLoadManager.instance=new SYNO.SDS.VideoStation2.ImageLoadManager),SYNO.SDS.VideoStation2.ImageLoadManager.instance}},constructor:function(){this.callParent(arguments),this.jobs=[],this.preemptJobs=[],this.delayedPreemptJob=new Ext.util.DelayedTask(this.preemptJob,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.clear,this),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.clear,this),this.mon(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.clear,this),this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.clear,this)},clear:function(){this.jobs=[],this.preemptJobs=[]},appendJob:function(t){-1===this.jobs.indexOf(t)&&(this.jobs.push(t),this.dispatch())},insertJob:function(t){this.preemptJobs.push(t),this.delayedPreemptJob.delay(100)},preemptJob:function(){Ext.each(this.preemptJobs,function(t){this.jobs.remove(t)},this),this.jobs.unshift.apply(this.jobs,this.preemptJobs),this.preemptJobs=[],this.dispatch()},dispatch:function(){for(;this.MAX_CONCURRENT>this.running;){var t=this.jobs.shift();if(!t)break;this.running++,this.setImgURL(t)}},setImgURL:function(t){var e=Ext.fly(t).getAttribute("url");if(!e)return this.running--,void this.dispatch.defer(0,this);var i=document.createElement("img");Ext.fly(i).on({load:this.onImageLoad.createDelegate(this,[t,i,e]),error:this.onImageError.createDelegate(this,[t,i,e])}),t.removeAttribute("url"),i.src=e},finalizedImageLoad:function(){this.running--,this.dispatch.defer(0,this)},onImageLoad:function(t,e,i){this.finalizedImageLoad(),this.delegate&&this.delegate.onImageLoad(e);var o=Ext.fly(t);o.setStyle("background-image",String.format("url({0})",i)),o.removeClass("loading"),e=null},onImageError:function(t,e,i){this.finalizedImageLoad(),this.delegate&&this.delegate.onImageError(t,e)}}),Ext.define("SYNO.SDS.VideoStation2.ThumbDataView",{extend:"SYNO.SDS.VideoStation2.ActionDataView",constructor:function(t){this.loader=SYNO.SDS.VideoStation2.ImageLoadManager.get(),this.callParent([this.fillConfig(t)])},fillConfig:function(t){Ext.apply(this,t.decorator);var e={tpl:this.getTpl(),cls:"thumb-dataview",store:this.getStore(),itemSelector:"div.thumb-wrap",overClass:"x-view-over",singleSelect:!0};return Ext.apply(e,t),delete e.decorator,e},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="thumb-wrap {[this.getImageStyle(values)]}">',"{[this.getThumbDiv(values)]}",'<div class="title sds-ellipsis" ext:qtip="{[this.doubleEncode(this.getTitle(values))]}">{[this.singleEncode(this.getTitle(values))]}',"{[this.getTitleDecorateDiv(values)]}","</div>",'<div class="description sds-ellipsis" ext:qtip="{[this.doubleEncode(this.getDescription(values))]}">{[this.singleEncode(this.getDescription(values))]}</div>',"{[this.getWatchedInfoDot(values)]}","</div>","{[this.getAfterThumbDiv(values)]}","</tpl>",'<div class="x-clear"></div>',{getImageStyle:this.getImageStyle.createDelegate(this),getThumbDiv:this.getThumbDiv.createDelegate(this),getTitle:this.getTitle.createDelegate(this),getTitleDecorateDiv:this.getTitleDecorateDiv.createDelegate(this),getDescription:this.getDescription.createDelegate(this),getWatchedInfoDot:this.getWatchedInfoDot.createDelegate(this),getAfterThumbDiv:this.getAfterThumbDiv.createDelegate(this),singleEncode:function(t){return Ext.util.Format.htmlEncode(t)},doubleEncode:function(t){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(t))}})},getImageStyle:function(t){return this.decoratorConfig?this.decoratorConfig.thumbCls||"poster":"poster"},getTitleDecorateDiv:function(){return""},getDescription:function(t){return SYNO.SDS.VideoStation2.Util.getVideoDate(t)},getIconDiv:function(t){var e;if(-1!==this.getImageStyle(t).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE))e='<div class="thumb">';else{var i=this.getImageURL(t);e=String.format('<div class="thumb loading" url="{0}">',Ext.util.Format.htmlEncode(i))}return[e,Ext.isFunction(this.getAdditionalThumbDiv)?this.getAdditionalThumbDiv(t):"",this.getOnScreenBtnDiv(t),"</div>"].join("")},getThumbDiv:function(t){var e=[this.getIconDiv(t),this.getWatchStatusDiv(t),'<div class="select-mark"></div>','<div class="border"></div>'].join("");return-1!==this.getImageStyle(t).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE)&&(e=String.format('<div class="background-shadow">{0}</div>',e)),e},getWatchStatusDiv:function(t){return-1!==this.getImageStyle(t).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE)?"":SYNO.SDS.VideoStation2.Util.getWatchStatusDiv(t)},getOnScreenBtnDiv:function(t){return['<div class="gradient"></div>','<div class="left-btn add"></div>','<div class="center-btn play"></div>','<div class="right-btn more"></div>'].join("")},getAfterThumbDiv:function(t){return""},refresh:function(){this.callParent(arguments),this.preloadItems()},preloadItems:function(){var t=this.getNodes();this.getImageItems(t,this.loader.appendJob.createDelegate(this.loader))},onLoadItem:function(t){this.getImageItems([t],this.loader.insertJob.createDelegate(this.loader))},getImageItems:function(t,e){Ext.each(t,function(t,i,o){var n=Ext.fly(t).select(".loading");Ext.each(n.elements,e)})},getWatchedInfoDot:function(t){return String.format('<div class="watched-info-dot {0}"></div>',this.getWatchedInfo(t))}}),Ext.define("SYNO.SDS.VideoStation2.RowSlidingDataView",{statics:{EVENT_CURSOR_CHANGE:"cursorchange",EVENT_AFTER_LOAD:"afterload",EVENT_ACTIVE_NEARBY:"activenearby",EVENT_SHOWHIDE_TOGGLE:"showhidetoggle",DATA_VIEW_PADDING_TOP:4},extend:"SYNO.ux.Panel",constructor:function(t){this.callParent([this.fillConfig(t)]),this.mon(this,SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_CURSOR_CHANGE,this.updatePagingBar,this),this.mon(this,SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_AFTER_LOAD,this.onDataViewAfterLoad,this),this.mon(this,SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_ACTIVE_NEARBY,this.onActiveNearby,this),this.slideview.relayEvents(this,["resize"])},fillConfig:function(t){this.libraryType=t.decorator.libraryType,this.libraryId=t.decorator.libraryId,this.videoType=t.decorator.videoType,this.imageStyle=this.isPoster()?"poster":"landscape";var e=t.decorator.iconCls||"library",i=t.decorator.hiddenIcon||!1,o=t.decorator.expandPagingBtn||!1,n="library"===e?t.decorator.title:this.getTitle(e);delete t.decorator,this.slideview=new SYNO.SDS.VideoStation2.SlidableDataView({getView:this.getDataView.createDelegate(this),height:("poster"===this.imageStyle?238:176)+SYNO.SDS.VideoStation2.RowSlidingDataView.DATA_VIEW_PADDING_TOP,dataViewMargin:0});var a={cls:String.format("{0} {1}","sliding-view",this.imageStyle),tbar:[{xtype:"tbspacer",width:2,hidden:i},{xtype:"box",cls:String.format("{0} {1}","library-icon",e),hidden:i},{xtype:"tbspacer",width:6,hidden:i},{xtype:"button",cls:"library-title",html:Ext.util.Format.htmlEncode(n),scope:this,handler:this.onTitleClick},"->",this.prevBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"prev-button",scope:this,handler:this.intoPrevPage}),{xtype:"tbspacer",width:16+(o?2:0)},this.nextBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"next-button",scope:this,handler:this.intoNextPage}),{xtype:"tbspacer",width:6,hidden:!o}],items:[this.slideview]};return Ext.apply(a,t),a},getTitle:function(t){switch(t){case"tvshow":return _VST("type","tv_show");case"movie":return _VST("type","movie");case"home_video":return _VST("type","home_video");case"tv_record":return _VST("type","tv_recorder");default:return""}},onActivate:function(){this.mon(this,"resize",this.onResizeEvent,this),this.setupView(),this.slideview.onActivate()},onDeactivate:function(){this.mun(this,"resize",this.onResizeEvent,this)},show:function(){var t=this.getVisibilityEl();t&&t.removeClass(["x-hide-display","x-hide-visibility"]),this.callParent(arguments)},hide:function(){var t=this.getVisibilityEl();t&&t.removeClass(["x-hide-display","x-hide-visibility"]),this.callParent(arguments)},setupView:function(){this.hideMode="visibility",this.hide(),this.updatePageSize(),Ext.iterate(this.slideview.views,function(t,e){e.pagingData={offset:0,limit:this.pageSize}},this)},updatePageSize:function(){var t="poster"===this.imageStyle?120:180,e="poster"===this.imageStyle?20:17,i=t+e,o=this.pageSize;this.pageSize=Math.floor(this.getInnerWidth()/i),o!==this.pageSize&&this.setCursor(this.cursor?this.cursor-this.cursor%this.pageSize:0)},setCursor:function(t){SYNO.Assert(Ext.isNumber(t)&&t>=0,String.format("unexpceted cursor {0}",t)),this.cursor=t,this.fireEvent(SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_CURSOR_CHANGE)},updatePagingBar:function(){var t=Math.ceil((this.cursor+this.pageSize)/this.pageSize),e=this.getTotal()<this.pageSize?1:Math.ceil(this.getTotal()/this.pageSize);1===e?(this.prevBtn.hide(),this.nextBtn.hide()):(this.prevBtn.show(),this.nextBtn.show()),this.prevBtn.setDisabled(1===t),this.nextBtn.setDisabled(t===e)},onResizeEvent:function(){this.updatePageSize(),this.dataViewLoadData(this.slideview.getCenterView(),this.cursor)},dataViewLoadData:function(t,e){t.pagingData.offset===e&&t.pagingData.limit===this.pageSize||(t.pagingData.offset=e,t.pagingData.limit=this.pageSize,t.fireEvent("activate"))},onDataViewAfterLoad:function(){if(0===this.getTotal())return this.hideMode="display",this.hide(),this.fireEvent(SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_SHOWHIDE_TOGGLE),!1;this.isVisible()||(this.show(),this.fireEvent(SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_SHOWHIDE_TOGGLE))},onActiveNearby:function(){this.updatePagingBar(),this.prepareView()},prepareView:function(){var t=this.cursor-this.pageSize;t>=0&&this.dataViewLoadData(this.slideview.getLeftView(),t),(t=this.cursor+this.pageSize)<this.getTotal()&&this.dataViewLoadData(this.slideview.getRightView(),t)},intoPrevPage:function(){var t=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this.setCursor(Math.max(this.cursor-this.pageSize,0)),this.slideview.prepareView(t.left,!0),this.slideview.intoLeft(!0),this.prepareView()},intoNextPage:function(){var t=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;this.setCursor(Math.min(this.cursor+this.pageSize,this.getTotal())),this.slideview.prepareView(t.right,!0),this.slideview.intoRight(!0),this.prepareView()},getDataView:function(t){return new SYNO.SDS.VideoStation2.RowSlidingWrapperDataView(Ext.apply(t,{childCfg:{decorator:this.getDataViewDecorator(this.getDefaultDataviewDecorator()),disableAction:this.isDisableVideoAction(),videoType:this.videoType}}))},getDefaultDataviewDecorator:function(){var t=this;return{decoratorConfig:{thumbCls:t.imageStyle},startVideoAction:function(e){this.clearVideoSelection(),this.addVideoSelection(e);var i=SYNO.SDS.VideoStation2.Library.get().getLibraryByIDAndType(t.libraryId,t.libraryType);SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(i.opid)},listeners:{scope:t,click:this.onViewItemClick}}},onViewItemClick:function(t,e,i,o){var n=String.format("{0}-{1}",this.libraryType,this.libraryId),a=t.getRecord(i);SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(n),this.isGetIntoTVShow()?SYNO.SDS.VideoStation2.Controller.intoTVShow(a.data):SYNO.SDS.VideoStation2.Controller.intoVideoDetail(t.getVideoData(a),new SYNO.SDS.VideoStation2.VideoListProxy(this.getVideoListProxySetting(t)))},isDisableVideoAction:function(){return this.libraryType===SYNO.SDS.VideoStation2.Constant.TVSHOW},isGetIntoTVShow:function(){return this.libraryType===SYNO.SDS.VideoStation2.Constant.TVSHOW},isPoster:function(){
SYNO.Debug.error("need to implement isPoster")},onTitleClick:Ext.emptyFn,getTotal:function(){SYNO.Debug.error("need to implement getTotal")},getDataViewDecorator:function(t){return t},getVideoListProxySetting:function(t){SYNO.Debug.error("need to implement getVideoListProxySetting")}}),Ext.define("SYNO.SDS.VideoStation2.RowSlidingWrapperDataView",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this.callParent([this.fillConfig(t)])},fillConfig:function(t){this.dataView=new SYNO.SDS.VideoStation2.ThumbDataView(t.childCfg);var e={layout:"fit",items:[this.dataView]};return delete t.childCfg,Ext.apply(e,t),e},onActivate:function(){var t=this.dataView.getStore();t.setBaseParam("offset",this.pagingData.offset),t.setBaseParam("limit",this.pagingData.limit),t.load()}}),Ext.define("SYNO.SDS.VideoStation2.PreloadSlidingView",{extend:"SYNO.SDS.VideoStation2.RowSlidingDataView",constructor:function(t){this.callParent(arguments),Ext.iterate(this.slideview.views,function(t,e){this.mon(e,SYNO.SDS.VideoStation2.PreloadDataviewWrapper.EVENT_FETCH_DATA,this.fetchFromBaseStore,this),this.mon(e,SYNO.SDS.VideoStation2.PreloadDataviewWrapper.EVENT_AFTER_LOAD,this.dataViewAfterLoad,this)},this)},onActivate:function(){this.mon(this,"resize",this.onResizeEvent,this),this.setupView(),this.getBaseStore().load()},onDeactivate:function(){this.mun(this,"resize",this.onResizeEvent,this)},getBaseStore:function(){return this._baseStore=this._baseStore||new SYNO.SDS.VideoStation2.Stores[this.videoType]({listeners:{scope:this,beforeload:this.onBeforeLoadBaseStore,load:this.onAfterLoadBaseStore}}),this._baseStore},onBeforeLoadBaseStore:function(t,e){var i=e.params;Ext.apply(i,this.getBaseStoreParams()),Ext.applyIf(i,t.baseParams)},onAfterLoadBaseStore:function(){!1!==this.fireEvent(SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_AFTER_LOAD)&&this.slideview.onActivate()},fetchFromBaseStore:function(t,e,i){t.removeAll(),t.add(this.getBaseStore().getRange(e,e+i-1<0?0:e+i-1))},dataViewAfterLoad:function(){this.fireEvent(SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_ACTIVE_NEARBY)},getDataView:function(t){return new SYNO.SDS.VideoStation2.PreloadDataviewWrapper(Ext.apply(t,{childCfg:{decorator:this.getDataViewDecorator(this.getDefaultDataviewDecorator()),disableAction:this.isDisableVideoAction(),videoType:this.videoType}}))},onTitleClick:Ext.emptyFn,getTotal:function(){return this.getBaseStore().getCount()},getDataViewDecorator:function(t){var e=this;return Ext.apply(t,{getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores[e.videoType]({}),this._store},getImageURL:function(t){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(t,e.videoType)}}),t},getBaseStoreParams:function(){SYNO.Debug.error("need to implement getBaseStoreParams")}}),Ext.define("SYNO.SDS.VideoStation2.PreloadDataviewWrapper",{extend:"SYNO.SDS.VideoStation2.RowSlidingWrapperDataView",statics:{EVENT_FETCH_DATA:"fetchdata",EVENT_AFTER_LOAD:"afterload"},onActivate:function(){this.fireEvent(SYNO.SDS.VideoStation2.PreloadDataviewWrapper.EVENT_FETCH_DATA,this.dataView.getStore(),this.pagingData.offset,this.pagingData.limit),this.fireEvent(SYNO.SDS.VideoStation2.PreloadDataviewWrapper.EVENT_AFTER_LOAD)}}),Ext.define("SYNO.SDS.VideoStation2.SearchField",{extend:"SYNO.ux.TextFilter",constructor:function(t){var e={emptyText:_VST("search","keyword"),enableKeyEvents:!0};this.callParent([Ext.apply(e,t)]),this.mon(this,"render",function(t){t.container.addClass("syno-vs2-searchfield"),t.wrap.addClassOnOver("over")})}}),Ext.define("SYNO.SDS.VideoStation2.TileDataView",{extend:"SYNO.SDS.VideoStation2.ActionDataView",constructor:function(t){this.loader=SYNO.SDS.VideoStation2.ImageLoadManager.get(),this.callParent([this.fillConfig(t)])},fillConfig:function(t){Ext.apply(this,t.decorator);var e={tpl:this.getTpl(),cls:"tile-dataview",store:this.getStore(),itemSelector:"div.tile-wrap",overClass:"x-view-over",singleSelect:!0};return Ext.apply(e,t),delete e.decorator,e},getTemplateTarget:function(){if(this.el.dom)return this.scrollBar=this.scrollBar||this.el.createChild({tag:"div",style:"display:inline-block;width:100%;"}),this.scrollBar},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="tile-wrap {[this.getImageStyle(values)]}">','<div class="tile-img">',"{[this.getIconDiv(values)]}","{[this.getWatchStatusDiv(values)]}",'<div class="select-mark"></div>','<div class="border"></div>',"</div>",'<div class="tile-desc">','<div class="title sds-ellipsis">',"{[this.singleEncode(this.getTitle(values))]}","{[this.getEpisodeDiv(values)]}","{[this.getDateDiv(values)]}","{[this.getWatchedInfoDot(values)]}","</div>","{[this.getSummaryDiv(values)]}","</div>",'<div class="x-clear"></div>',"</div>","</tpl>",'<div class="x-clear"></div>',{getTitle:this.getTitle.createDelegate(this),getImageStyle:this.getImageStyle.createDelegate(this),getIconDiv:this.getIconDiv.createDelegate(this),getWatchStatusDiv:this.getWatchStatusDiv.createDelegate(this),getDateDiv:this.getDateDiv.createDelegate(this),getWatchedInfoDot:this.getWatchedInfoDot.createDelegate(this),getSummaryDiv:this.getSummaryDiv.createDelegate(this),getEpisodeDiv:function(t){return t.episode?String.format('<span class="episode">{0}</span>',String.format(_VST("episode","title"),t.episode)):""},singleEncode:function(t){return Ext.util.Format.htmlEncode(t)},doubleEncode:function(t){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(t))}})},getImageStyle:function(t){return this.decoratorConfig?this.decoratorConfig.thumbCls||"poster":"poster"},getIconDiv:function(t){var e;if(-1!==this.getImageStyle(t).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE))e='<div class="thumb">';else{var i=this.getImageURL(t);e=String.format('<div class="thumb loading" url="{0}">',Ext.util.Format.htmlEncode(i))}return[e,this.getOnScreenBtnDiv(t),"</div>"].join("")},getOnScreenBtnDiv:function(t){return['<div class="gradient"></div>','<div class="left-btn add"></div>','<div class="center-btn play"></div>','<div class="right-btn more"></div>'].join("")},getWatchStatusDiv:function(t){return-1!==this.getImageStyle(t).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE)?"":SYNO.SDS.VideoStation2.Util.getWatchStatusDiv(t)},getSummaryDiv:function(t){return-1!==this.getImageStyle(t).indexOf(SYNO.SDS.VideoStation2.Constant.SQUARE)?"":String.format('<div class="summary">{0}</div>',Ext.util.Format.htmlEncode(t.additional.summary||""))},getDateDiv:function(t){var e=SYNO.SDS.VideoStation2.Util.getVideoDate(t);return Ext.isEmpty(e)?"":'<span class="date">'+e+"</span>"},refresh:function(){this.callParent(arguments),this.preloadItems()},preloadItems:function(){var t=this.getNodes();this.getImageItems(t,this.loader.appendJob.createDelegate(this.loader))},onLoadItem:function(t){this.getImageItems([t],this.loader.insertJob.createDelegate(this.loader))},getImageItems:function(t,e){Ext.each(t,function(t,i,o){var n=Ext.fly(t).select(".loading");Ext.each(n.elements,e)})},getWatchedInfoDot:function(t){return String.format('<div class="watched-info-dot {0}"></div>',this.getWatchedInfo(t))}}),Ext.define("SYNO.SDS.VideoStation2.SwitchableDataView",{enablePagingToolbar:!1,pageSize:0,extend:"SYNO.ux.Panel",statics:{AVAILABLE_DECORATORS:["Season","Common","Byfolder","Playlist","PlaylistPoster","RecordingSpecific"]},constructor:function(t,e){this.decorator=this.getDecorator(t),this.applyDecorator(),this.applyDecoratorToChild(t),Ext.isObject(e)&&Ext.isObject(e.decoration)&&(Ext.apply(this,e.decoration),Ext.apply(t.decorator,e.decoration)),this.views={},this.views[SYNO.SDS.VideoStation2.View.TYPE_THUMBNAIL]=new SYNO.SDS.VideoStation2.ThumbDataView(t),this.views[SYNO.SDS.VideoStation2.View.TYPE_TILE]=new SYNO.SDS.VideoStation2.TileDataView(t),this.views[SYNO.SDS.VideoStation2.View.TYPE_LIST]=new SYNO.SDS.VideoStation2.ListView(t);var i={layout:"card",items:Object.values(this.views),listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,beforedestroy:this.onBeforeDestroy}};this.enablePagingToolbar&&(this._paging=new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:this.pageSize,store:this.getDataviewStore(),displayInfo:!0,showRefreshBtn:!0}),i.bbar=this._paging),Ext.apply(i,e||{}),this.callParent([i]),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO)},getDecorator:function(t){var e=SYNO.SDS.VideoStation2.SwitchableDataView.AVAILABLE_DECORATORS;return SYNO.Assert(-1!==e.indexOf(t.decorator),String.format("unexpceted decorator {0}",t.decorator)),SYNO.SDS.VideoStation2.DataViewDecorator[t.decorator]},applyDecoratorToChild:function(t){t.decorator={getStore:function(){return this.owner.getDataviewStore()}},this.decorator.decorations.each(function(e){t.decorator[e]=this.decorator[e]},this),t.decorator.owner=this},applyDecorator:function(t){this.decorator.switchableDecorations.each(function(t){this[t]=this.decorator[t]},this)},onViewTypeChange:function(){if(this.hidden)return void SYNO.Debug("view is hidden, by pass");this.loadView()},loadView:function(){var t=SYNO.SDS.VideoStation2.View.get().getViewType(),e=this.layout.activeItem,i=this.views[t];SYNO.Assert(i,String.format("unexpceted viewType {0}",t)),e!==i?this.layout.setActiveItem(i):e&&e.fireEvent("activate")},getActiveView:function(){return this.layout.activeItem},clearActiveItem:function(){var t=this.layout.activeItem;if(t){if(t.hide(),!t.hidden)return!1;t.fireEvent("deactivate",t),this.layout.activeItem=null}},resetPaging:function(){this.enablePagingToolbar&&this._paging.moveFirst()},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED,this.onViewTypeChange,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this),Ext.isObject(this.resizeEvantCallback)&&this.mon(this,"resize",this.resizeEvantCallback.fn,this.resizeEvantCallback.scope);var t=this.getDataviewStore();this.mon(t,"beforeload",this.onDataviewBeforeLoad,this),this.mon(t,"load",this.onDataviewStoreLoad,this),this.loadView();var e;this.enablePagingToolbar&&(e=this._paging.cursor,this._paging.bindStore(t)),this.isNeedLoadStore()?(this.enablePagingToolbar?this.isNeedMovePagingToFirst()?this._paging.moveFirst():(this.keepScrollOnce=!0,this._paging.cursor=e,this._paging.doRefresh()):(this.isNeedMovePagingToFirst()||(this.keepScrollOnce=!0),t.load()),this.getActiveView().getTemplateTarget().update("")):(this.getActiveView().updateScrollbar(!0),this.getActiveView().onStoreLoad())},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED,this.onViewTypeChange,this),this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this),Ext.isObject(this.resizeEvantCallback)&&this.mun(this,"resize",this.resizeEvantCallback.fn,this.resizeEvantCallback.scope);var t=this.getDataviewStore();this.mun(t,"beforeload",this.onDataviewBeforeLoad,this),this.mun(t,"load",this.onDataviewStoreLoad,this),this.enablePagingToolbar&&this._paging.bindStore(null),this.clearActiveItem(),this.keepScrollOnce=!1,SYNO.SDS.VideoStation2.View.get().getView()!==SYNO.SDS.VideoStation2.View.VIEW_TVSHOW&&t.removeAll()},onViewRefresh:function(){this.enablePagingToolbar?this._paging.doRefresh():this.getDataviewStore().load()},onBeforeDestroy:function(){this.getDataviewStore().destroy()},onDataviewBeforeLoad:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,this)},onDataviewStoreLoad:function(){if(this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),0===this.getDataviewStore().getTotalCount()?this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,this):0===this.getDataviewStore().getCount()&&this.enablePagingToolbar&&this._paging.movePrevious(),this.keepScrollOnce)return void(this.keepScrollOnce=!1);this.getActiveView().updateScrollbar(!0)},getDataviewStore:function(){SYNO.Debug.error("need to implement interface getDataviewStore")},isNeedLoadStore:function(){return!0},isNeedMovePagingToFirst:function(){return!0},getPagingParam:function(){var t={},e=SYNO.SDS.VideoStation2.View.get().getPage();return Ext.isNumber(e)&&Ext.apply(t,{offset:(e-1)*this.pageSize,limit:this.pageSize}),t}}),Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Common",{singleton:!0,switchableDecorations:["getDataviewStore","onBeforeLoadStore","onLoadStore","enablePagingToolbar","pageSize","isNeedMovePagingToFirst"],decorations:["decoratorConfig","getImageStyle","getImageURL","enableSelectMode"],enablePagingToolbar:!0,pageSize:120,getDataviewStore:function(){this.stores=this.stores||{};var t=SYNO.SDS.VideoStation2.Library.get().getCurrentType();return this.stores[t]||(SYNO.Assert(SYNO.SDS.VideoStation2.Stores[t],String.format("unexpceted library type {0}",t)),this.stores[t]=new SYNO.SDS.VideoStation2.Stores[t]({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}})),this.stores[t]},onBeforeLoadStore:function(t,e){var i=e.params,o=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory(),n=SYNO.SDS.VideoStation2.Category.isSortAdjustableCategory(o)?SYNO.SDS.VideoStation2.Sort.get().getSortOption():SYNO.SDS.VideoStation2.Category.get().getSortOption(),a=null;o===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL?(a=SYNO.SDS.VideoStation2.Filter.get().getFilterOption(),Ext.apply(a,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption())):SYNO.SDS.VideoStation2.Category.isRecordingSpecificCategory(o)&&(a=SYNO.SDS.VideoStation2.RecordingSpecific.get().getFilterOption()),Ext.apply(i,this.getPagingParam()),Ext.apply(i,n),Ext.apply(i,a),Ext.apply(i,{library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID()})},onLoadStore:function(t,e,i){SYNO.SDS.VideoStation2.View.get().setPage(Math.floor(i.params.offset/i.params.limit)+1,!1)},isNeedMovePagingToFirst:function(){return!Ext.isNumber(SYNO.SDS.VideoStation2.Video.get().getCurrentID())&&Ext.isEmpty(SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow())},enableSelectMode:!0,decoratorConfig:{thumbCls:"poster"},getImageStyle:function(t){var e=SYNO.SDS.VideoStation2.Library.get().getCurrentType();return e===SYNO.SDS.VideoStation2.Constant.MOVIE||e===SYNO.SDS.VideoStation2.Constant.TVSHOW?"poster":"landscape"},getImageURL:function(t){var e=SYNO.SDS.VideoStation2.Library.get().getCurrentType();return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(t,e)}}),Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Season",{singleton:!0,switchableDecorations:["getDataviewStore","onBeforeLoadStore","onLoadStore","filterStore","isNeedLoadStore","clearLoadedInfo","isNeedMovePagingToFirst"],decorations:["decoratorConfig","getDescription","getImageURL","enableSelectMode","getVideoTitle","getTitle","getWatchedInfo"],getDataviewStore:function(){if(!this._store){var t=SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE;this._store=new SYNO.SDS.VideoStation2.Stores[t]({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}})}return this._store},onBeforeLoadStore:function(t,e){var i=e.params,o={};SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL&&(o=SYNO.SDS.VideoStation2.Filter.get().getFilterOption(),Ext.apply(o,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption())),Ext.apply(i,o),Ext.apply(i,{library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID(),tvshow_id:SYNO.SDS.VideoStation2.TVShow.get().getCurrentID()})},onLoadStore:function(t,e,i){this.loadedLibrary=i.params.library_id,this.loadedTVShow=i.params.tvshow_id;var o=e.reduce(function(t,e){return t[e.get("season")]=!0,t},{});if(o=Object.keys(o).map(function(t){return parseInt(t,10)}).sortBy(function(t){return t}),Ext.isEmpty(o))return void SYNO.SDS.VideoStation2.Controller.goback();var n=null,a=e.reduce(function(t,e){return Math.max(t,e.get("last_watched"))},0);0<a&&Ext.each(e,function(t){t.get("last_watched")===a&&(t.set("max_last_watched",!0),n=t.get("season"),t.commit(!0))},this),Ext.isNumber(n)&&SYNO.SDS.VideoStation2.TVShow.get().setDefaultSeason(n),SYNO.SDS.VideoStation2.TVShow.get().setAvailableSeasons(o),this.filterStore()},filterStore:function(){var t=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this._store.filter({property:"season",value:t,exactMatch:!0})},isNeedLoadStore:function(){var t=SYNO.SDS.VideoStation2.Library.get().getCurrentID(),e=SYNO.SDS.VideoStation2.TVShow.get();return this.loadedLibrary!==t||this.loadedTVShow!==e.getCurrentID()||null===e.getAvailableSeasons()},clearLoadedInfo:function(){this.loadedLibrary=null,this.loadedTVShow=null},isNeedMovePagingToFirst:function(){return!Ext.isNumber(SYNO.SDS.VideoStation2.Video.get().getCurrentID())},enableSelectMode:!0,decoratorConfig:{thumbCls:"landscape"},getDescription:SYNO.SDS.VideoStation2.Util.getTVShowEpisodeDescription,getImageURL:function(t){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(t,SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE)},getVideoTitle:function(t){return SYNO.SDS.VideoStation2.Util.getPathTitleForEpisode(t.get("episode"),t.get("tagline"))},getTitle:SYNO.SDS.VideoStation2.Util.getTVShowEpisodeTitle,getWatchedInfo:function(t){var e=!0===SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","show_unwatched_dot"),i=0===(t.additional?t.additional.watched_ratio:0);return!0===t.max_last_watched?SYNO.SDS.VideoStation2.Constant.CLASS.LASTWATCHED:e&&i?SYNO.SDS.VideoStation2.Constant.CLASS.UNWATCHED:""}}),Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Byfolder",{singleton:!0,switchableDecorations:["getDataviewStore","onBeforeLoadStore","onLoadStore","equalToLastId","isNeedMovePagingToFirst","enablePagingToolbar","pageSize"],decorations:["getImageStyle","getListThumbDiv","getOnScreenBtnDiv","getAdditionalThumbDiv","getImageURL","enableSelectMode","getVideoData","getVideoID","getVideoMapperID","getVideoType","getVideoFile","getLibraryID","getRecordBySelection","getRelatedVideoRecordsBySelection","getAfterThumbDiv","formRelatedSelections","isFolder"],enablePagingToolbar:!0,pageSize:120,getDataviewStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.folder({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}}),this._store},onBeforeLoadStore:function(t,e){var i=e.params;this.equalToLastId()||Ext.apply(i,{offset:0}),Ext.apply(i,this.getPagingParam()),Ext.apply(i,{path:SYNO.SDS.VideoStation2.Folder.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Library.get().getCurrentType(),library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID()})},onLoadStore:function(t,e,i){this.lastParams=i.params,SYNO.SDS.VideoStation2.View.get().setPage(Math.floor(i.params.offset/i.params.limit)+1,!1)},equalToLastId:function(){if(Ext.isEmpty(this.lastParams))return!1;var t=SYNO.SDS.VideoStation2.Folder.get().getCurrentID(),e=SYNO.SDS.VideoStation2.Library.get().getCurrentType(),i=SYNO.SDS.VideoStation2.Library.get().getCurrentID();return this.lastParams.path===t&&this.lastParams.type===e&&this.lastParams.library_id===i},isNeedMovePagingToFirst:function(){return!this.equalToLastId()},enableSelectMode:!0,getVideoData:function(t){return{id:this.getVideoID(t),type:this.getVideoType(t),pathTitle:this.getVideoTitle(t),mapper_id:this.getVideoMapperID(t),library_id:this.getLibraryID(t),file:this.getVideoFile(t)}},getVideoID:function(t){var e=(t.get("additional")||{}).metadata;if(e)return e.id},getVideoMapperID:function(t){var e=(t.get("additional")||{}).metadata;if(e)return e.mapper_id},getVideoType:function(t){return SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType()},getVideoFile:function(t){return parseInt(t.get("id"),10)},getLibraryID:function(t){var e=(t.get("additional")||{}).metadata;if(e)return e.library_id},getRecordBySelection:function(t){return this.getStore().getById(t.file.toString())},getRelatedVideoRecordsBySelection:function(t){var e=[];return this.getStore().each(function(i){t.mapper_id===this.getVideoMapperID(i)&&e.push(i)},this),e},formRelatedSelections:function(t){return this.getRelatedVideoRecordsBySelection(t).map(function(t){return{id:this.getVideoID(t),type:this.getVideoType(t),mapper_id:this.getVideoMapperID(t),file:this.getVideoFile(t),record:t}},this)},getAdditionalThumbDiv:function(t){if(!this.isFolder(t))return"";var e=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType(),i=function(t){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(t,e)};return SYNO.SDS.VideoStation2.Util.getCombinationPosterDiv(t.preview_video,i)},isFolder:function(t){return SYNO.SDS.VideoStation2.Constant.FOLDER===t.type},getImageStyle:function(t){return this.isFolder(t)?String.format("{0} {1}",SYNO.SDS.VideoStation2.Constant.SQUARE,SYNO.SDS.VideoStation2.Constant.FOLDER):SYNO.SDS.VideoStation2.Constant.MOVIE===SYNO.SDS.VideoStation2.Library.get().getCurrentType()?"poster":"landscape"},getListThumbDiv:function(t){var e="";return e=t.type===SYNO.SDS.VideoStation2.Constant.FOLDER?t.type:this.getVideoType(),String.format('<div class="thumb-icon {0}"></div>',e)},getOnScreenBtnDiv:function(t){return this.isFolder(t)?"":['<div class="gradient"></div>','<div class="left-btn add"></div>','<div class="center-btn play"></div>','<div class="right-btn more"></div>'].join("")},getAfterThumbDiv:function(t){return t.last_folder?'<div class="x-clear"></div>':""},getImageURL:function(t){var e=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType();return SYNO.SDS.VideoStation2.Util.getImageURL({type:e,id:t.additional.metadata.id,mtime:t.additional?t.additional.poster_mtime||"":""})}}),Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.Playlist",{singleton:!0,switchableDecorations:["getDataviewStore","isNeedLoadStore"],decorations:["getImageURL","onActivate","decoratorConfig","getActionDiv","getListThumbDiv","getTitle","getTitleDecorateDiv","getAdditionalThumbDiv","getAfterThumbDiv","getOnScreenBtnDiv"],getDataviewStore:function(){return this._store=this._store||new Ext.data.JsonStore({id:"id",fields:["id","title","additional","type","playlist_title","preview_video"]}),this._store},isNeedLoadStore:function(){return!1},getImageURL:function(t){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(t)},onActivate:function(){this.bindStore(this.getStore())},onDeactivate:function(){this.bindStore(null)},decoratorConfig:{thumbCls:SYNO.SDS.VideoStation2.Constant.SQUARE},getActionDiv:function(t){return[String.format('<div class="playlist-edit action-btn {0}"></div>',t.id<0?"x-item-disabled":""),String.format('<div class="playlist-more action-btn {0}"></div>',-3===t.id?"x-item-disabled":"")].join("")},getListThumbDiv:function(t){var e=t.type;return-1===t.id?e="favorite":-2===t.id?e="watchlist":-3===t.id&&(e="shared"),String.format('<div class="thumb-icon {0}"></div>',e)},getTitle:function(t){return Ext.isString(t.playlist_title)?t.playlist_title:""},getTitleDecorateDiv:function(t){var e=(t.additional||{}).sharing_info;return e&&e.status&&"none"!==e.status?-3===t.id?"":String.format('<div class="share-icon {0}"></div>',e.status):""},getAdditionalThumbDiv:function(t){var e=SYNO.SDS.VideoStation2.Util.getCombinationPosterDiv(t.preview_video,this.getImageURL.createDelegate(this)),i="",o="";return-1===t.id?i="favorite":-2===t.id?i="watchlist":-3===t.id&&(i="shared"),Ext.isEmpty(i)||(o=String.format('{0}<div class="playlist-icon {1} {2}"></div>',Ext.isEmpty(e)?"":'<div class="playlist-mask"></div>',i,Ext.isEmpty(e)?"":"has_contain")),e+o},getAfterThumbDiv:function(t){return-3===t.id?'<div class="x-clear"></div>':""},getOnScreenBtnDiv:function(t){return['<div class="gradient"></div>','<div class="left-btn playlist-edit larger ',t.id<0?"x-item-disabled":"",'"></div>','<div class="right-btn playlist-more larger ',-3===t.id?"x-item-disabled":"",'"></div>'].join("")}}),Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.PlaylistPoster",{singleton:!0,switchableDecorations:["getDataviewStore","onBeforeLoadStore","onLoadStore","onExceptionStore","enablePagingToolbar","pageSize","isNeedMovePagingToFirst"],decorations:["getImageStyle","getImageURL","enableSelectMode"],enablePagingToolbar:!0,pageSize:200,getDataviewStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.playlistvideolist({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore,exception:this.onExceptionStore}}),this._store},onBeforeLoadStore:function(t,e){var i=e.params;Ext.apply(i,this.getPagingParam()),Ext.apply(i,SYNO.SDS.VideoStation2.Sort.get().getSortOption()),Ext.apply(i,{id:SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()})},onLoadStore:function(t,e,i){SYNO.SDS.VideoStation2.View.get().setPage(Math.floor(i.params.offset/i.params.limit)+1,!1)},onExceptionStore:function(t,e,i){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,this)},isNeedMovePagingToFirst:function(){return!Ext.isNumber(SYNO.SDS.VideoStation2.Video.get().getCurrentID())},enableSelectMode:!0,getImageStyle:function(t){return"poster"},getImageURL:function(t){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(t)}}),Ext.define("SYNO.SDS.VideoStation2.DataViewDecorator.RecordingSpecific",{singleton:!0,switchableDecorations:["enablePagingToolbar","pageSize","getDataviewStore","onBeforeLoadStore","onLoadStore","onViewRefresh","tvrecordType"],decorations:["enableSelectMode","getImageStyle","getAdditionalThumbDiv","getOnScreenBtnDiv","getActionDiv"],enablePagingToolbar:!0,pageSize:120,getDataviewStore:function(){var t=this.specialTVRecordType||"";return SYNO.Assert(SYNO.SDS.VideoStation2.Stores[t],String.format("unexpceted category type {0}",t)),this._store=this._store||new SYNO.SDS.VideoStation2.Stores[t]({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}}),this._store},onBeforeLoadStore:function(t,e){var i=e.params;Ext.apply(i,this.getPagingParam()),Ext.apply(i,SYNO.SDS.VideoStation2.Sort.get().getSortOption())},onLoadStore:function(t,e,i){SYNO.SDS.VideoStation2.View.get().setPage(Math.floor(i.params.offset/i.params.limit)+1,!1)},onViewRefresh:function(){this.getDataviewStore().load()},enableSelectMode:!1,getImageStyle:function(t){return String.format("{0} {1}",SYNO.SDS.VideoStation2.Constant.SQUARE,this.specialTVRecordType)},getAdditionalThumbDiv:function(t){var e=function(t){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(t,SYNO.SDS.VideoStation2.Constant.TV_RECORDING)};return SYNO.SDS.VideoStation2.Util.getCombinationPosterDiv(t.preview_video||[],e)},getOnScreenBtnDiv:function(){return""},getActionDiv:function(){return""}}),Ext.define("SYNO.SDS.VideoStation2.TextFilter",{extend:"SYNO.ux.TextFilter",xtype:"syno_vs_textfilter",constructor:function(t){var e={emptyText:_VST("search","keyword"),enableKeyEvents:!0};this.callParent([Ext.apply(e,t)]),this.mon(this,"render",function(t){t.container.addClass("syno-vs2-textfilter"),t.wrap.addClass("syno-vs2-base-textfield"),t.wrap.addClassOnOver("over")})}}),Ext.define("SYNO.SDS.VideoStation2.TransparentButton",{extend:"SYNO.ux.Button",constructor:function(t){this.callParent([t]),this.addClass("syno-vs2-transparent-button")}}),Ext.define("SYNO.SDS.VideoStation2.AddEditDialog",{statics:{MODE_ADD:"add",MODE_EDIT:"edit"},extend:"SYNO.SDS.VideoStation2.Dialog",addAction:"create",editAction:"modify",constructor:function(t){t=t||{},this.mode=t.mode;var e={title:this.isAddMode()?_T("common","add"):_T("common","alt_edit"),width:500,height:350,layout:"fit",items:[this.getFormPanel()],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","alt_apply"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",btnStyle:"grey",text:_T("common","alt_cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(e,t)])},isAddMode:function(){return this.mode===SYNO.SDS.VideoStation2.AddEditDialog.MODE_ADD},isDirty:Ext.emptyFn,isValid:Ext.emptyFn,getFormPanel:function(){return this.form_panel=this.form_panel||new SYNO.SDS.VideoStation2.FormPanel(this.getFormConfig()),this.form_panel},getInvalidError:Ext.emptyFn,getParameter:Ext.emptyFn,onApply:function(t){if(!this.isValid())return void this.getMsgBox().alert(this.title,this.getInvalidError());var e=this.isAddMode()?this.addAction:this.editAction;this.setStatusBusy({text:_T("common","loading")}),this.addAjaxTask({url:SYNO.SDS.VideoStation2.Util.getCGIURL(this.cgi),method:"POST",single:!0,autoJsonDecode:!0,params:Ext.apply(this.getParameter(),{action:e}),scope:this,callback:this.onRequestDone.createDelegate(this)},this).start(!0)},onCancel:function(){if(this.isAddMode()||!this.isDirty())return void this.close();var t=function(t){"yes"===t&&this.close()};this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),t,this)},onRequestDone:function(t,e,i){if(this.clearStatusBusy(),i&&i.success)this.onRequestSuccess(t,i),this.close();else{var o=SYNO.SDS.VideoStation2.Error.getErrorInfoString(i,_T("common","commfail"));this.getMsgBox().alert(_VST("library","title"),o)}},onRequestSuccess:function(t,e){SYNO.SDS.VideoStation2.Util.applyCallback(Ext.apply(this.callback,{args:[t,e]}))}}),Ext.define("SYNO.SDS.VideoStation2.FolderDialog",{extend:"SYNO.SDS.VideoStation2.AddEditDialog",cgi:"folder_manage.cgi",constructor:function(t){this.library=SYNO.Util.copy(t.library),this.folder=SYNO.Util.copy(t.folder),this.callback=t.callback||{};var e={height:400,resizable:!1,listeners:{scope:this,afterrender:this.initEnableCheckGroup}};this.callParent([Ext.apply(e,t)])},onOpen:function(){var t=this.isAddMode()?"enu":this.folder.preferlang,e=this.isAddMode()?"":this.folder.path,i=this.getFormPanel().getForm();i.findField("library").setValue(this.library.opid),i.findField("preferlanguage").setValue(t),i.findField("path").setValue(e),SYNO.SDS.VideoStation2.Constant.HOME_VIDEO===this.library.type?i.findField("enable_search_online_metadata").setValue(!1):i.findField("enable_search_online_metadata").setValue(!!this.isAddMode()||this.folder.search_metadata),this.original_values=i.getValues(),this.callParent(arguments)},getFormConfig:function(){return{trackResetOnLoad:!0,border:!1,items:[{xtype:"syno_vs_fieldset",title:_VST("videofolder","title"),labelWidth:100,items:[{xtype:"syno_compositefield",fieldLabel:_T("common","folder"),defaults:{hideLabel:!0},items:[{xtype:"syno_vs_textfield",width:200,name:"path",readOnly:!0,allowBlank:!1,blankText:_VST("videofolder","specify_path"),validationEvent:"afterrender"},{xtype:"syno_vs_button",text:_VST("common","select"),btnStyle:"blue",scope:this,handler:this.editPathHandler}]}]},{xtype:"syno_vs_fieldset",title:_VST("library","title"),items:[{disabled:!this.isAddMode(),xtype:"syno_vs_combobox",name:"library",fieldLabel:_VST("library","title"),displayField:"title",valueField:"opid",store:this.getLibraryStore(),listeners:{scope:this,select:this.onLibrarySelect}}]},{xtype:"syno_vs_fieldset",title:_VST("videofolder","video_info_search"),items:[{xtype:"syno_vs_checkbox",disabled:SYNO.SDS.VideoStation2.Constant.HOME_VIDEO===this.library.type,name:"enable_search_online_metadata",boxLabel:_VST("videofolder","search_online_metadta")},{xtype:"syno_vs_combobox",disabled:SYNO.SDS.VideoStation2.Constant.HOME_VIDEO===this.library.type,name:"preferlanguage",fieldLabel:_VST("language","title"),displayField:"display",valueField:"value",store:this.addManagedComponent(SYNO.SDS.VideoStation2.Util.getLangStore())}]}]}},initEnableCheckGroup:function(){new SYNO.ux.Utils.EnableCheckGroup(this.getFormPanel().getForm(),"enable_search_online_metadata",["preferlanguage"])},getLibraryStore:function(){return this.library_store=this.library_store||new Ext.data.JsonStore({autoLoad:!1,autoDestroy:!0,root:"data",idProperty:"opid",fields:["id","opid","title","type"],data:{data:SYNO.SDS.VideoStation2.Library.get().getAllLibraries()}}),this.library_store},editPathHandler:function(){var t=new SYNO.SDS.VideoStation2.FileChooser({owner:this,title:this.title})
;t.mon(t,"choose",this.onChooserSelect,this),t.open()},isDirty:function(){return!(!Ext.isObject(this.folder)||!Ext.isObject(this.library))&&!SYNO.ux.Utils.checkObjectConsistency(this.getFormPanel().getForm().getValues(),this.original_values)},isValid:function(){return this.getFormPanel().getForm().isValid()},getInvalidError:function(){return _VST("videofolder","specify_path")},getParameter:function(){var t=this.getFormPanel().getForm(),e=t.findField("path").getValue(),i=SYNO.SDS.VideoStation2.Library.get().getLibraryByOPID(t.findField("library").getValue()),o=SYNO.SDS.VideoStation2.Util.getShareData(e),n={share:o.orishare,subpath:o.subpath,section:i.type,search_metadata:t.findField("enable_search_online_metadata").getValue(),preferlang:t.findField("preferlanguage").getValue()};return i.id>0&&(n.library_id=i.id),this.isAddMode()||Ext.apply(n,{old_share:this.folder.share,old_subpath:this.folder.subpath}),n},onChooserSelect:function(t,e){if(e&&Ext.isString(e.path)){this.getFormPanel().getForm().findField("path").setValue(e.path)}t.close()},onLibrarySelect:function(t,e,i){var o=["enable_search_online_metadata","preferlanguage"];Ext.each(o,function(t){this.getFormPanel().getForm().findField(t).setDisabled(e.get("type")===SYNO.SDS.VideoStation2.Constant.HOME_VIDEO)},this)}}),Ext.define("SYNO.SDS.VideoStation2.SettingController",{statics:{instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.SettingController.instance)||(SYNO.SDS.VideoStation2.SettingController.instance=new SYNO.SDS.VideoStation2.SettingController),SYNO.SDS.VideoStation2.SettingController.instance}},extend:"Ext.Component",constructor:function(){this.callParent(arguments)},launchFolderDialog:function(t,e,i){var o=new SYNO.SDS.VideoStation2.FolderDialog({owner:this.getActiveWindow(),library:e,mode:SYNO.SDS.VideoStation2.AddEditDialog[t?"MODE_ADD":"MODE_EDIT"],callback:i});this.openDialog(o)},openDialog:function(t){this.activeDialog.push(t),this.mon(t,"close",this.onDialogClosed,this,{single:!0}),t.open()},getActiveWindow:function(){return Ext.isEmpty(this.activeDialog)?SYNO.SDS.VideoStation2.Window:this.activeDialog.last()},onDialogClosed:function(t){this.activeDialog.last()===t&&this.activeDialog.splice(-1),Ext.isEmpty(this.activeDialog)&&SYNO.SDS.VideoStation2.Window.unmask()},confirm:function(t,e,i,o){this.getActiveWindow().getMsgBox().confirm(t,e,i,o)},alert:function(t,e){this.getActiveWindow().getMsgBox().alert(t,e)},confirmAction:function(t,e,i,o){var n=function(t){"yes"===t&&SYNO.SDS.VideoStation2.Util.applyCallback({fn:i,scope:o})};this.confirm(t,e,n)},confirmPromise:function(t,e){return new Promise(function(i,o){this.confirm(t,e,function(t){"yes"===t&&i()})}.bind(this))},sendRequestPromise:function(t){return new Promise(function(e,i){this.addAjaxTask({url:t.url,method:"POST",single:!0,autoJsonDecode:!0,params:t.params,callback:function(t,o,n){n&&n.success?e(n.data):i()}},this).start(!0)}.bind(this))},sendRequest:function(t){var e=function(e,i,o){if(this.getActiveWindow().clearStatusBusy(),o&&o.success)SYNO.SDS.VideoStation2.Util.applyCallback(Ext.apply(t.callback,{args:[e,o]}));else{var n=SYNO.SDS.VideoStation2.Error.getErrorInfoString(o,_T("common","commfail"));this.alert("",n)}};this.getActiveWindow().setStatusBusy({text:t.loading_text||_T("common","saving")}),this.addAjaxTask({url:t.url,method:"POST",single:!0,autoJsonDecode:!0,params:t.params,scope:this,callback:e},this).start(!0)},deleteFolder:function(t,e){this.sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("folder_manage.cgi"),params:{action:"delete",share:t.share,subpath:t.subpath},callback:e})},deleteLibrary:function(t,e){this.sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("library_manage.cgi"),params:{action:"delete",id:t.id,type:t.type},callback:e})},exportMetadata:function(t,e){Ext.isObject(t)&&Ext.isString(t.type)&&Ext.isNumber(t.id)&&this.sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("library_manage.cgi"),params:{action:"export_metadata",id:t.id>0?t.id:0,type:t.type},callback:e})},activeDialog:[]}),Ext.define("SYNO.SDS.VideoStation2.Setting.SubtitleSourceOrderDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(t){this.north_panel=new SYNO.SDS.VideoStation2.FormPanel({region:"north",margins:"0 20",height:50,items:[{xtype:"syno_vs_displayfield",htmlEncode:!1,value:_VST("advanced","subtitle_source_order_descriptiotn")}]}),this.center_panel=new SYNO.SDS.VideoStation2.Setting.SubtitleSourceOrderDialogGrid({region:"center",margins:"0 20",flex:1});var e={title:_VST("advanced","set_subtitle_source_order"),width:600,height:360,layout:"border",items:[this.north_panel,this.center_panel],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","alt_apply"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",btnStyle:"grey",text:_T("common","alt_cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(e,t)])},onApply:function(){this.center_panel.save().then(function(){this.close()}.bind(this))},onCancel:function(){this.close()}}),Ext.define("SYNO.SDS.VideoStation2.Setting.SubtitleSourceOrderDialogGrid",{extend:"SYNO.ux.DDGridPanel",statics:{SOURCE_MAPPING:{Shooter:"Shooter.cn",OpenSubtitles:"OpenSubtitles.org",Subscene:"Subscene"}},constructor:function(t){var e={cls:"syno-vs2-gridpanel",viewConfig:{ddGroup:"NtSettingGridDD",forceFit:!1},cm:this.getCM(),store:this.getDS(t),enableDragDrop:!0,enableColumnMove:!1,autoFlexScroll:!0};this.callParent([Ext.apply(e,t)]),this.load()},load:function(){SYNO.SDS.VideoStation2.SettingController.get().sendRequestPromise({url:SYNO.SDS.VideoStation2.Util.getCGIURL("advanced_manage.cgi"),params:{action:"load"}}).then(function(t){var e=t.subtitle_source_order.split(",");this.getDS().loadData(e.map(function(e){var i=SYNO.SDS.VideoStation2.Setting.SubtitleSourceOrderDialogGrid.SOURCE_MAPPING[e],o=String.format("{0}_enable",e.toLowerCase());return[e,i,t[o]]}))}.bind(this))},save:function(){var t=[];return this.getDS().each(function(e){t.push(e.id)}),SYNO.SDS.VideoStation2.SettingController.get().sendRequestPromise({url:SYNO.SDS.VideoStation2.Util.getCGIURL("advanced_manage.cgi"),params:{action:"save",subtitle_source_order:t.join(",")}})},getDS:function(){return this.store=this.store||new Ext.data.ArrayStore({autoDestroy:!0,idIndex:0,fields:["id","name","status"]}),this.store},getCM:function(){return new Ext.grid.ColumnModel([{header:_VST("advanced","subtitle_source"),dataIndex:"name",editable:!1,sortable:!1,menuDisabled:!0},{header:_VST("common","status"),dataIndex:"status",editable:!1,sortable:!1,menuDisabled:!0,renderer:function(t){return _VST("common",t?"enabled":"disabled")}}])}}),Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e={title:_VST("advanced","panel_title"),labelWidth:200,trackResetOnLoad:!0,items:[new SYNO.SDS.VideoStation2.Setting.AdvancedPanel.TranscodingSet,new SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet,new SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet,this._remote=new SYNO.SDS.VideoStation2.Setting.AdvancedPanel.RemoteSet,new SYNO.SDS.VideoStation2.Setting.AdvancedPanel.PreAnalysisSet],listeners:{scope:this,afterrender:{fn:this.initCheckGroup,single:!0},activate:{fn:this.loadData}}};this.callParent([Ext.apply(e,t)]),this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.Event.EVENT_HEIGHT_CHANGE),this.items.each(function(t){this.relayEvents(t,[SYNO.SDS.VideoStation2.Setting.AdvancedPanel.Event.EVENT_HEIGHT_CHANGE])},this)},isDirty:function(){return!SYNO.ux.Utils.checkObjectConsistency(this.oriValues,this.getForm().getValues())},initCheckGroup:function(){this.initEnableCheckGroup(),this.initHiddenCheckGroup()},initEnableCheckGroup:function(){new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"cmzvideo_cover",["cmzvideo_cover_rule"]),new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"opensubtitles_enable",["opensubtitles_username","opensubtitles_password","opensubtitles_language"]),new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"subscene_enable",["subscene_language"])},initHiddenCheckGroup:function(){this.hiddenCheckGroup("opensubtitles_enable",["opensubtitles_username","opensubtitles_password","opensubtitles_language"]),this.hiddenCheckGroup("subscene_enable",["subscene_language"])},hiddenCheckGroup:function(t,e){var i=SYNO.SDS.Utils.FieldFind(this.getForm(),t),o=function(t,i){for(var o=0;o<e.length;o++){SYNO.SDS.Utils.FieldFind(this.getForm(),e[o]).setVisible(i)}}.bind(this);i.mon(i,"check",o),o(i,i.getValue())},loadData:function(){var t=SYNO.SDS.VideoStation2.SettingController.get();t.getActiveWindow().setStatusBusy({text:_T("common","saving")}),Promise.all([t.sendRequestPromise({url:SYNO.SDS.VideoStation2.Util.getCGIURL("advanced_manage.cgi"),params:{action:"load"}}),SYNO.SDS.VideoStation2.PromiseOP.get().getPreAnalysisInfo({}),this._remote.getPreferredInterface(),this._remote.loadStore()]).then(function(e){t.getActiveWindow().clearStatusBusy(),this.applyValuesToForm(e)}.bind(this))},saveChanges:function(t){if(this.getForm().isValid()){var e=SYNO.SDS.VideoStation2.SettingController.get();e.getActiveWindow().setStatusBusy({text:_T("common","saving")}),Promise.all([this.saveAdvancedSetting(),this.saveNetworkSetting(),this.savePreAnalysisSetting()]).then(function(i){e.getActiveWindow().clearStatusBusy(),SYNO.SDS.VideoStation2.Util.applyCallback(t)}.bind(this)).catch(function(){e.getActiveWindow().setStatusError()})}},saveAdvancedSetting:function(){var t=this.getForm(),e=t.findField("cmzvideo_cover_rule");Ext.isEmpty(e.getValue().trim())&&e.setValue(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet.DEFAULT_COVER_RULE);var i=t.getValues();if(delete i.pre_analysis_enable,delete i.interface,!Object.keys(i).some(function(t){return!SYNO.ux.Utils.checkObjectConsistency(i[t],this.oriValues[t])},this))return Promise.resolve(i);var o=SYNO.Util.copy(i);return o.opensubtitles_password&&-1!==o.opensubtitles_password.indexOf("\t")&&(o.opensubtitles_password="\t\t\t\t\t\t\t\t"),Ext.isArray(o.opensubtitles_language)&&(o.opensubtitles_language=o.opensubtitles_language.join(",")),Ext.isArray(o.subscene_language)&&(o.subscene_language=o.subscene_language.join(",")),SYNO.SDS.VideoStation2.SettingController.get().sendRequestPromise({url:SYNO.SDS.VideoStation2.Util.getCGIURL("advanced_manage.cgi"),params:Ext.apply({action:"save"},o)})},saveNetworkSetting:function(){var t=this.getForm().findField("interface").getValue();return t===this.oriValues.interface?Promise.resolve():SYNO.SDS.VideoStation2.PromiseOP.get().setPreferredInterface({interface:t})},savePreAnalysisSetting:function(){var t=this.getForm().findField("pre_analysis_enable").getValue().toString(),e="true"===t;return t.toString()===this.oriValues.pre_analysis_enable?Promise.resolve():SYNO.SDS.VideoStation2.PromiseOP.get().setPreAnalysisInfo({enabled:e})},rejectChanges:function(){this.getForm().reset()},applyValuesToForm:function(t){var e=SYNO.Util.copy(t[0]);e.pre_analysis_enable=t[1].enabled,e.interface=this._remote.findAvailableInterface(t[2]),this.getForm().setValues(e),this.oriValues=this.getForm().getValues()}}),Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.Event",{statics:{EVENT_HEIGHT_CHANGE:"heightchange"}}),Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.TranscodingSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={title:_VST("advanced","transcoding_settings"),collapsible:!0,labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(e,t)])},getItems:function(){var t=["getEnableAC3Passthrough","getEnableHardwareTranscode","getSharingTranscodeOption"],e=[];return Ext.each(t,function(t){var i=this[t]();Ext.isObject(i)&&e.push(i)},this),e},getEnableAC3Passthrough:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("advanced","pass_through_ac3"),name:"not_trans_audio_ac3_to_mp3"})},getEnableHardwareTranscode:function(){return SYNO.SDS.VideoStation2.Capability.get().ableToHardwareTranscode()&&SYNO.SDS.VideoStation2.Capability.get().ableToSoftwareTranscode()?new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("advanced","enable_hardware_accelerate"),name:"hardware_transcode"}):null},getSharingTranscodeOption:function(){if(!SYNO.SDS.VideoStation2.Capability.get().ableToRemux())return null;var t=[["disable",_VST("advanced","disallow_transcode")],["remux",_VST("advanced","allow_remux")],["transcode",_VST("advanced","allow_transcode")]];return SYNO.SDS.VideoStation2.Capability.get().ableToTranscode()||t.splice(-1),new SYNO.SDS.VideoStation2.ComboBox({fieldLabel:_VST("advanced","public_sharing"),displayField:"display",valueField:"value",name:"public_sharing_transcode_option",width:325,store:new Ext.data.ArrayStore({fields:["value","display"],data:t})})}}),Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",statics:{DEFAULT_COVER_RULE:"cover.jpg;Cover.jpg;COVER.jpg;folder.jpg;Folder.jpg;FOLDER.jpg"},constructor:function(t){var e={title:_VST("advanced","video_cover_settings"),collapsible:!0,labelWidth:250,items:[this.getEnableCoverRule(),this.getCoverRuleDescription(),this.getCustomizedCoverRule()]};this.callParent([Ext.apply(e,t)])},getEnableCoverRule:function(){return new SYNO.SDS.VideoStation2.Checkbox({name:"cmzvideo_cover",boxLabel:_VST("advanced","customized_video_cover")})},getCoverRuleDescription:function(){return{xtype:"syno_vs_displayfield",indent:1,name:"video_cover_note",htmlEncode:!1,value:String.format('<span class="syno-ux-note">{0}: </span>{1} {2}',_T("common","note"),_VST("advanced","only_apply_to"),_VST("advanced","same_filename_high_priority"))}},getCustomizedCoverRule:function(){return new SYNO.SDS.VideoStation2.TextField({indent:1,width:300,name:"cmzvideo_cover_rule",fieldLabel:_VST("advanced","filename"),validator:this.coverRuleValidator})},coverRuleValidator:function(t){if(Ext.isEmpty(t.trim()))return!0;var e=null,i=t.split(";");return Ext.each(i,function(t){if(-1===t.search(/.+\.([jJ][pP][gG]|[jJ][pP][eE][gG])$/))return e=String.format(_VST("advanced","cover_format_error"),SYNO.SDS.VideoStation2.Setting.AdvancedPanel.CoverRuleSet.DEFAULT_COVER_RULE),!1}),e||!0}}),Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",statics:{LANGUAGE_MAPPING:{csy:"cze",dan:"dan",enu:"eng",fre:"fre",ger:"ger",hun:"hun",ita:"ita",jpn:"jpn",krn:"kor",nld:"dut",nor:"nor",plk:"pol",ptb:"pob",ptg:"por",rus:"rus",spn:"spa",sve:"swe",tha:"tha",trk:"tur"},SUBSCENE_LANGUAGE_MAPPING:{enu:"eng",dan:"dan",fre:"fre",ita:"ita",nld:"nld",nor:"nor",ptb:"por",spn:"spa",sve:"swe",tha:"tha"},EXTRA_LANGUAGE:[["chi",_VST("language","chinese")],["fin",_VST("language","finnish")],["ara",_VST("language","arabic")],["heb",_VST("language","hebrew")],["ell",_VST("language","greek")],["rum",_VST("language","romanian")],["scc",_VST("language","serbian")],["hrv",_VST("language","croatian")],["bul",_VST("language","bulgarian")],["slv",_VST("language","slovenian")],["bos",_VST("language","bosnian")]]},constructor:function(t){var e={title:_VST("advanced","subtitle_settings"),collapsible:!0,labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(e,t)])},getItems:function(){return[{xtype:"syno_vs_checkbox",name:"opensubtitles_enable",boxLabel:_VST("advanced","opensubtitles_enable"),listeners:{scope:this,check:this.notifyHeightChange}},{xtype:"syno_vs_textfield",name:"opensubtitles_username",emptyText:_T("common","optional"),fieldLabel:_VST("advanced","opensubtitles_username"),indent:1},{xtype:"syno_vs_textfield",textType:"password",maxLength:"32",name:"opensubtitles_password",autoCreate:{tag:"input",type:"text",size:"20",autocomplete:"new-password"},emptyText:_T("common","optional"),fieldLabel:_VST("advanced","opensubtitles_password"),indent:1},new SYNO.SDS.VideoStation2.SuperBox({name:"opensubtitles_language",fieldLabel:_VST("advanced","opensubtitles_language"),store:this.getOpenSubtitlesLanguageStore(),allowBlank:!1,allowAddNewData:!1,editable:!1,mode:"local",indent:1,navigateItemsWithTab:!1,listeners:{scope:this,additem:this.notifyHeightChange,removeitem:this.notifyHeightChange}}),{xtype:"syno_vs_checkbox",name:"shooter_enable",boxLabel:_VST("advanced","shooter_enable")},{xtype:"syno_vs_checkbox",name:"subscene_enable",boxLabel:_VST("advanced","subscene_enable"),listeners:{scope:this,check:this.notifyHeightChange}},new SYNO.SDS.VideoStation2.SuperBox({name:"subscene_language",fieldLabel:_VST("advanced","subscene_language"),store:this.getSubsceneLanguageStore(),allowBlank:!1,allowAddNewData:!1,editable:!1,mode:"local",indent:1,navigateItemsWithTab:!1,listeners:{scope:this,additem:this.notifyHeightChange,removeitem:this.notifyHeightChange,beforeselect:function(t,e,i,o){if(t.getValue().split(",").length>=3)return!1}}}),{xtype:"syno_vs_button",btnStyle:"blue",indent:1,text:_VST("advanced","set_subtitle_source_order"),handler:this.getSubtitleSourceOrderDialog,scope:this}]},getOpenSubtitlesLanguageStore:function(){var t=SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet.LANGUAGE_MAPPING;return SYNO.SDS.Utils.getSupportedLanguage().map(function(e){return Ext.isEmpty(t[e[0]])?null:[t[e[0]],e[1]]}).filter(function(t){return!Ext.isEmpty(t)}).concat(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet.EXTRA_LANGUAGE)},getSubsceneLanguageStore:function(){var t=SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet.SUBSCENE_LANGUAGE_MAPPING;return SYNO.SDS.Utils.getSupportedLanguage().map(function(e){return Ext.isEmpty(t[e[0]])?null:[t[e[0]],e[1]]}).filter(function(t){return!Ext.isEmpty(t)}).concat(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.SubtitleSet.EXTRA_LANGUAGE)},getSubtitleSourceOrderDialog:function(){var t=SYNO.SDS.VideoStation2.SettingController.get(),e=new SYNO.SDS.VideoStation2.Setting.SubtitleSourceOrderDialog({owner:t.getActiveWindow()});t.openDialog(e)},notifyHeightChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.AdvancedPanel.Event.EVENT_HEIGHT_CHANGE)}}),Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.PreAnalysisSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={title:_VST("advanced","pre_analysis_setting"),collapsible:!0,labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(e,t)])},getItems:function(){return[{xtype:"syno_vs_checkbox",boxLabel:_VST("advanced","pre_analysis_enable_description"),name:"pre_analysis_enable"},{xtype:"syno_vs_button",btnStyle:"blue",text:_VST("advanced","pre_analysis_trigger"),tooltip:_VST("advanced","pre_analysis_trigger_description"),scope:this,handler:this.onClickTriggerPreAnalysis}]},onClickTriggerPreAnalysis:function(){SYNO.SDS.VideoStation2.OP.get().triggerPreAnalysis({},{})}}),Ext.define("SYNO.SDS.VideoStation2.Stores.Interface",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.Setting.Network",synoMethod:"list",baseConfigs:{baseParams:{},reader:{id:"interface",root:"interface",totalProperty:"total",fields:["interface","display_name"]}}}),Ext.define("SYNO.SDS.VideoStation2.Setting.AdvancedPanel.RemoteSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={title:_VST("advanced","remote_player_settings"),collapsible:!0,labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(e,t)])},getItems:function(){return[this.getCombobox()]},getCombobox:function(){return this._combo=this._combo||new SYNO.SDS.VideoStation2.ComboBox({name:"interface",fieldLabel:_VST("advanced","network_interface"),allowBlank:!1,autoSelect:!0,forceSelection:!0,displayField:"display_name",mode:"local",valueField:"interface",store:this.getInterfaceStore()}),this._combo},getInterfaceStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.Interface({}),this._store},findAvailableInterface:function(t){return-1===this.getInterfaceStore().findExact("interface",t)?_T("common","default"):t},loadStore:function(){return new Promise(function(t,e){!1===this.getInterfaceStore().load({callback:t})&&e()}.bind(this))},getPreferredInterface:function(){return this._get_preferred=this._get_preferred||SYNO.SDS.VideoStation2.PromiseOP.get().getPreferredInterface().then(function(t){return t.interface}),this._get_preferred}}),Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e={cls:"dtv-panel",title:_VST("dtv","title"),itemId:"dtv_settings",labelWidth:200,trackResetOnLoad:!0,items:this.getItems(),listeners:{scope:this,afterrender:{fn:this.initEnableCheckGroup,single:!0},activate:this.loadData}};this.callParent([Ext.apply(e,t)]),this.mon(this._folder,SYNO.SDS.VideoStation2.Setting.DTVPanel.Event.EVENT_RELOAD_DATA,this.loadData,this)},getItems:function(){return[this._folder=new SYNO.SDS.VideoStation2.Setting.DTVPanel.FolderSet,new SYNO.SDS.VideoStation2.Setting.DTVPanel.StreamingSet,new SYNO.SDS.VideoStation2.Setting.DTVPanel.RecordingSet,new SYNO.SDS.VideoStation2.Setting.DTVPanel.TVGuideSet,new SYNO.SDS.VideoStation2.Setting.DTVPanel.ScanSet,new SYNO.SDS.VideoStation2.FieldSet({collapsible:!0,title:_T("common","advanced"),items:[this._enable_dtv_checkbox=new SYNO.SDS.VideoStation2.Setting.DTVDisableCheckbox]})]},initEnableCheckGroup:function(){var t=this.getForm();new SYNO.ux.Utils.EnableCheckGroup(t,"enableauth",["account","passwd","password_confirm"]),new SYNO.ux.Utils.EnableCheckGroup(t,"enable_viewer_limit",["streaming_limit"]),new SYNO.ux.Utils.EnableCheckGroup(t,"disable_dtv",[],["dtv_destination","enableauth","enable_viewer_limit","closestreaming","pre_recording","post_recording","epg_update_frequency","non_dvbs_scan_clear","dvbs_scan_clear"])},loadData:function(){SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("dtv_manage.cgi"),params:{action:"load"},callback:{scope:this,fn:function(t,e){var i=e.data;this.getForm().setValues(i),this._folder.checkComponentStatus(i),this._enable_dtv_checkbox.setDVBLinkIsRunning(i.DVB_conflict)}}})},isDirty:function(){return this.getForm().isDirty()},saveChanges:function(t){var e=this.getForm();if(e.isValid()){var i=e.getValues(),o=i.dtv_destination;if(!Ext.isEmpty(o)){var n=SYNO.SDS.VideoStation2.Util.getShareData(o);Ext.apply(i,{share:n.orishare,subpath:n.subpath})}SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("dtv_manage.cgi"),params:Ext.apply({action:"save"},i),callback:{fn:function(o,n){if(e.setValues(i),SYNO.SDS.VideoStation2.DTV.get().setDTVDisabled("true"===i.disable_dtv),SYNO.SDS.VideoStation2.DTV.get().isDTVDisabled()){var a=SYNO.SDS.VideoStation2.View.get().getView();a!==SYNO.SDS.VideoStation2.View.VIEW_DTV&&a!==SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE||SYNO.SDS.VideoStation2.Controller.intoHomePage()}SYNO.SDS.VideoStation2.DTV.get().loadDTV(),SYNO.SDS.VideoStation2.Util.applyCallback(t)}}})}},rejectChanges:function(){this.getForm().reset()}}),Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.Event",{statics:{EVENT_RELOAD_DATA:"reloaddata"}}),Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.FolderSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={collapsible:!0,title:_VST("dtvfolder","title"),labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(e,t)])},getItems:function(){return[{xtype:"hidden",name:"share"},{xtype:"hidden",name:"subpath"},{xtype:"syno_compositefield",fieldLabel:_VST("dtvfolder","dtv_destination"),defaults:{hideLabel:!0},items:[this.getDestination(),this.getFolderButton(),this.getExportButton()]}]},getExportButton:function(){return this._export=this._export||new SYNO.SDS.VideoStation2.ActionButton({cls:"export-button",disabled:!0,scope:this,handler:this.onClickExportMetadata}),this._export},getDestination:function(){return this._destination=this._destination||new SYNO.SDS.VideoStation2.TextField({name:"dtv_destination",postBlur:this.checkDestValid.createDelegate(this),readOnly:!0,width:157,listeners:{scope:this,enable:this.updateFolderButtonStatus,disable:this.updateFolderButtonStatus}}),this._destination},getFolderButton:function(){return this._folder=this._folder||new SYNO.SDS.VideoStation2.Button({btnStyle:"blue",text:_VST("common","select"),scope:this,handler:this.onDTVFolderChoose}),this._folder},forEachButtonDo:function(t){t(this.getFolderButton()),t(this.getExportButton())},updateFolderButtonStatus:function(){var t=this.getDestination();if(!0===t.disabled)return void this.forEachButtonDo(function(t){t.disable()});if(this.getExportButton().setDisabled(this.destinationExporting||t.isDirty()||this.destInvalid||Ext.isEmpty(t.getValue())),this.getFolderButton().setDisabled(this.destinationExporting),this.destinationExporting){var e=Ext.util.Format.htmlEncode(_VST("library","metadata_exporting"));this.forEachButtonDo(function(t){t.setTooltip(e)})}else this.forEachButtonDo(function(t){t.setTooltip("")}),this.getExportButton().setTooltip(_VST("action","export_metadata"))},onDTVFolderChoose:function(){var t=SYNO.SDS.VideoStation2.SettingController.get(),e=new SYNO.SDS.VideoStation2.FileChooser({owner:t.getActiveWindow(),title:this.title});e.mon(e,"choose",this.onChooserSelect,this),t.openDialog(e)},onChooserSelect:function(t,e){e&&Ext.isString(e.path)&&(this.destInvalid=!1,this.getDestination().setValue(e.path),this.updateFolderButtonStatus()),t.close()},checkComponentStatus:function(t){this.destinationExporting=t.dtv_destination_exporting,t.dtv_destination_exists||""===t.dtv_destination||(this.destInvalid=!0),this.checkDestValid(),this.checkPollingExportStatus(),this.updateFolderButtonStatus()},checkDestValid:function(){!0===this.destInvalid&&this.getDestination().markInvalid(_VST("error","record_dest_not_exist"))},checkPollingExportStatus:function(){this.destinationExporting?this.getPollingExportingTask().delay(5e3):this.stopPollingExportingTask()},onClickExportMetadata:function(){var t=function(){var t={type:"tv_record",id:0};SYNO.SDS.VideoStation2.SettingController.get().exportMetadata(t,{fn:function(){this.destinationExporting=!0,this.updateFolderButtonStatus(),this.getPollingExportingTask().delay(5e3)},scope:this})};SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("action","settings"),_VST("library","export_metadata_desc"),t,this)},getPollingExportingTask:function(){return Ext.isEmpty(this.pollingExportingTask)?(this.pollingExportingTask=new Ext.util.DelayedTask(function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.DTVPanel.Event.EVENT_RELOAD_DATA)},this),this.pollingExportingTask):this.pollingExportingTask},stopPollingExportingTask:function(){Ext.isEmpty(this.pollingExportingTask)||this.pollingExportingTask.cancel()}}),Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.StreamingSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={collapsible:!0,title:_VST("programguide","broadcast_streaming"),labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(e,t)])},getItems:function(){var t=[{xtype:"syno_vs_checkbox",boxLabel:_VST("streaming","enable_streaming_auth"),name:"enableauth"}];return t.push(this.getAccountField()),t.push(this.getPasswordField()),t.push(this.getPasswordConfirmField()),t.push({xtype:"syno_vs_checkbox",boxLabel:_VST("streaming","enable_stream_limit"),name:"enable_viewer_limit"}),t.push(this.getStreamingLimitField()),t},getAccountField:function(){return this._account=this._account||new SYNO.SDS.VideoStation2.TextField({name:"account",fieldLabel:_VST("streaming","stream_auth_user"),validator:this.accountValidator.createDelegate(this),width:160,indent:1}),this._account},getPasswordField:function(){return this._passwd=this._passwd||new SYNO.SDS.VideoStation2.TextField({name:"passwd",textType:"password",fieldLabel:_T("common","password"),validator:this.passwordValidator.createDelegate(this),width:160,indent:1}),this._passwd},getPasswordConfirmField:function(){return this._confirm=this._confirm||new SYNO.SDS.VideoStation2.TextField({name:"password_confirm",textType:"password_confirm",fieldLabel:_VST("streaming","pass_confirm"),validator:this.confirmValidator.createDelegate(this),width:160,indent:1}),this._confirm},getStreamingLimitField:function(){return this._limit=this._limit||new SYNO.SDS.VideoStation2.NumberField({name:"streaming_limit",fieldLabel:_VST("streaming","streaming_limit_viewer"),width:160,indent:1,decimalPrecision:0,minValue:1,maxlength:6}),this._limit},accountValidator:function(t){return!Ext.isEmpty(t)||_VST("streaming","msg_invalid_user")},passwordValidator:function(t){return!Ext.isEmpty(t)||_VST("streaming","error_empty_password")},confirmValidator:function(t){var e=this.getPasswordField().getValue();return t===e||"87654321"===t&&"12345678"===e||_VST("streaming","nzb_confirmpass")}}),Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.RecordingSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={collapsible:!0,title:_VST("record","record_setting"),labelWidth:250,items:this.getItems()};this.callParent([Ext.apply(e,t)])},getItems:function(){var t=[{xtype:"syno_vs_checkbox",boxLabel:_VST("record","record_first_stream"),name:"closestreaming"}];return t.push(this.getPreRecordingField()),t.push(this.getPostRecordingField()),t},getPreRecordingField:function(){return this._pre=this._pre||new SYNO.SDS.VideoStation2.NumberField({name:"pre_recording",fieldLabel:_VST("record","pre_recording_interval"),indent:1,width:160,minValue:0,maxValue:3600,maxlength:4,emptyText:_T("common","time_seconds")}),this._pre},getPostRecordingField:function(){return this._post=this._post||new SYNO.SDS.VideoStation2.NumberField({name:"post_recording",fieldLabel:_VST("record","post_recording_interval"),indent:1,width:160,minValue:0,maxValue:3600,maxlength:4,emptyText:_T("common","time_seconds")}),this._post}}),Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.TVGuideSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={collapsible:!0,title:_VST("programguide","setting"),labelWidth:250,items:[this.getFrequencyCombo()]};this.callParent([Ext.apply(e,t)])},getFrequencyCombo:function(){return this._frequency=this._frequency||new SYNO.SDS.VideoStation2.ComboBox({name:"epg_update_frequency",fieldLabel:_VST("programguide","update_frequency"),displayField:"display",valueField:"value",value:"daily",store:this.getFrequencyStore()}),this._frequency},getFrequencyStore:function(){return this._store=this._store||new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:[["twiceaday",_VST("programguide","frequency_twice_a_day")],["daily",_VST("programguide","frequency_daily")],["3days",_VST("programguide","frequency_3_day")],["weekly",_VST("programguide","frequency_weekly")],["never",_VST("programguide","frequency_never")]]}),this._store}}),Ext.define("SYNO.SDS.VideoStation2.Setting.DTVPanel.ScanSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={collapsible:!0,title:_VST("dtv","scan_setting"),labelWidth:250,items:[{xtype:"syno_vs_checkbox",boxLabel:_VST("dtv","non_dvbs_scan_clear"),name:"non_dvbs_scan_clear"},{xtype:"syno_vs_checkbox",boxLabel:_VST("dtv","dvbs_scan_clear"),name:"dvbs_scan_clear"}]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.Setting.DTVDisableCheckbox",{extend:"SYNO.SDS.VideoStation2.Checkbox",constructor:function(t){var e={boxLabel:_VST("dtv","disable_dtv"),name:"disable_dtv"};this.callParent([Ext.apply(e,t)])},onClick:function(){!0===this.getValue()&&!0===this._is_dvblink_running?SYNO.SDS.VideoStation2.SettingController.get().alert("",_VST("dtv","enable_conflict")):this.callParent(arguments)},setDVBLinkIsRunning:function(t){this._is_dvblink_running=t}}),Ext.define("SYNO.SDS.VideoStation2.Setting.GeneralPanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e={title:_VST("options","title"),
items:[new SYNO.SDS.VideoStation2.Setting.GeneralPanel.HomepageSet,new SYNO.SDS.VideoStation2.Setting.GeneralPanel.SubtitleSet,new SYNO.SDS.VideoStation2.Setting.GeneralPanel.ChromecastSet,new SYNO.SDS.VideoStation2.Setting.GeneralPanel.StatusDotSet],listeners:{scope:this,activate:{fn:this.loadData},afterrender:{fn:this.initEnableCheckGroup,single:!0}}};this.callParent([Ext.apply(e,t)])},isDirty:function(){var t=this.getForm().getValues();return"true"===t.hide_slide_show!==this.oriHideSlideShow||"true"===t.disable_slide_show!==this.oriDisableSlideShow||"true"===t.enable_discover!==this.oriEnableDiscover||"true"===t.convert_simplified_to_traditional!==this.orgConvertSimplifiedToTraditional||"true"===t.enable_ac3_passthrough!==this.oriEnableAc3Passthrough||"true"===t.show_unwatched_dot!==this.oriShowWatchStatusDot},initEnableCheckGroup:function(){new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"hide_slide_show",[],["disable_slide_show"])},loadData:function(){this.oriHideSlideShow=!0===SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","hide_slide_show"),this.oriDisableSlideShow=!0===SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","disable_slide_show"),this.oriEnableDiscover=!0===SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","enable_discover"),this.oriEnableAc3Passthrough=!0===SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","enable_ac3_passthrough"),this.oriShowWatchStatusDot=!0===SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","show_unwatched_dot"),this.getForm().setValues({hide_slide_show:this.oriHideSlideShow,disable_slide_show:this.oriDisableSlideShow,enable_discover:this.oriEnableDiscover,enable_ac3_passthrough:this.oriEnableAc3Passthrough,show_unwatched_dot:this.oriShowWatchStatusDot}),SYNO.SDS.VideoStation2.OP.get().getPersonalSetting({},{scope:this,success:function(t,e,i){var o=this.getForm().findField("convert_simplified_to_traditional");this.orgConvertSimplifiedToTraditional=t.convert_simplified_to_traditional,o.setValue(this.orgConvertSimplifiedToTraditional)}})},saveChanges:function(t){var e=this.getForm();if(e.isValid()){var i=e.getValues();SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","hide_slide_show","true"===i.hide_slide_show),SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","disable_slide_show","true"===i.disable_slide_show),SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","enable_discover","true"===i.enable_discover),SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","enable_ac3_passthrough","true"===i.enable_ac3_passthrough),SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","show_unwatched_dot","true"===i.show_unwatched_dot);var o=SYNO.SDS.VideoStation2.View.get(),n="true"===i.show_unwatched_dot!==this.oriShowWatchStatusDot;(o.view===SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE||n)&&SYNO.SDS.VideoStation2.Controller.refreshView(),"true"===i.convert_simplified_to_traditional!==this.orgConvertSimplifiedToTraditional&&SYNO.SDS.VideoStation2.OP.get().setPersonalSetting({convert_simplified_to_traditional:"true"===i.convert_simplified_to_traditional},{}),SYNO.SDS.VideoStation2.Util.applyCallback(t)}},rejectChanges:function(){this.getForm().setValues({hide_slide_show:this.oriHideSlideShow,disable_slide_show:this.oriDisableSlideShow,enable_discover:this.oriEnableDiscover,convert_simplified_to_traditional:this.orgConvertSimplifiedToTraditional,enable_ac3_passthrough:this.oriEnableAc3Passthrough,show_unwatched_dot:this.oriShowWatchStatusDot})}}),Ext.define("SYNO.SDS.VideoStation2.Setting.GeneralPanel.HomepageSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={title:_VST("options","homepage_setting"),collapsible:!0,labelWidth:250,items:[this.getHideSlideShow(),this.getDisableSlideShow()]};this.callParent([Ext.apply(e,t)])},getHideSlideShow:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("options","hide_slide_show"),name:"hide_slide_show"})},getDisableSlideShow:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("options","disable_slide_show"),name:"disable_slide_show"})}}),Ext.define("SYNO.SDS.VideoStation2.Setting.GeneralPanel.SubtitleSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={title:_VST("options","subtitle"),collapsible:!0,labelWidth:250,items:[this.getDiscoverSubtitle(),this.getConvertSimplifiedToTraditional()]};this.callParent([Ext.apply(e,t)])},getDiscoverSubtitle:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("options","enable_discover"),name:"enable_discover"})},getConvertSimplifiedToTraditional:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("options","chs_cht"),name:"convert_simplified_to_traditional"})}}),Ext.define("SYNO.SDS.VideoStation2.Setting.GeneralPanel.ChromecastSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={title:_VST("controller","chromecast_mode"),collapsible:!0,labelWidth:250,items:[this.getAc3Passthrough()]};this.callParent([Ext.apply(e,t)])},getAc3Passthrough:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("options","pass_through_ac3_chromecast"),name:"enable_ac3_passthrough"})}}),Ext.define("SYNO.SDS.VideoStation2.Setting.GeneralPanel.StatusDotSet",{extend:"SYNO.SDS.VideoStation2.FieldSet",constructor:function(t){var e={title:_VST("common","watch_status"),collapsible:!0,labelWidth:250,items:[this.getShowWatchStatusDot()]};this.callParent([Ext.apply(e,t)])},getShowWatchStatusDot:function(){return new SYNO.SDS.VideoStation2.Checkbox({boxLabel:_VST("options","show_unwatched_dot"),name:"show_unwatched_dot"})}});Ext.define("SYNO.SDS.VideoStation2.LibraryController",{statics:{instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.LibraryController.instance)||(SYNO.SDS.VideoStation2.LibraryController.instance=new SYNO.SDS.VideoStation2.LibraryController),SYNO.SDS.VideoStation2.LibraryController.instance}},extend:"Ext.Component",constructor:function(){this.callParent(arguments)},loadLibrary:function(){SYNO.SDS.VideoStation2.Library.get().loadLibrary()},waitToActivateLibrary:function(t){SYNO.SDS.VideoStation2.Library.get().getLibraryStore().addListener("load",function(){SYNO.SDS.VideoStation2.Library.get().activate(t)},this,{single:!0})}}),Ext.define("SYNO.SDS.VideoStation2.EnableGrid",{extend:"SYNO.SDS.VideoStation2.GridPanel",pageSize:50,constructor:function(t){this.pageSize=t.pageSize||this.pageSize,this.callParent([Ext.apply(this.getConfig(),t)]),this.addClass("enable-grid"),this.mon(this.getStore(),"beforeload",this.onBeforeLoad,this)},confirm:Ext.emptyFn,getStore:Ext.emptyFn,getColumns:Ext.emptyFn,saveChanges:Ext.emptyFn,getPagingToolbar:function(){return this._paging=this._paging||new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:this.pageSize,store:this.getStore(),displayInfo:!0}),this._paging},getConfig:function(){return{store:this.getStore(),border:!1,flex:1,viewConfig:{scrollDelay:!1,borderHeight:0,cacheSize:50,forceFit:!0},stripeRows:!0,enableColLock:!1,enableColumnMove:!1,enableColumnHide:!1,enableHdMenu:!1,enableColumnResize:!0,selModel:new Ext.grid.RowSelectionModel({singleSelect:!0}),cm:this.getColumns(),bbar:this.getPagingToolbar()}},saveChangesAndLoadStore:function(t){this.saveChanges({scope:this,fn:function(){this.getStore().commitChanges(),this.getStore().load(t)}})},onBeforeLoad:function(t,e){if(!this.isDirty())return!0;var i=function(i){"yes"===i?this.saveChangesAndLoadStore(e):(t.rejectChanges(),t.load(e))};return this.confirm("",_T("share","share_save_chg_before_reload"),i,this),!1},isDirty:function(){return!Ext.isEmpty(this.getStore().getModifiedRecords())}}),Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryPermissionDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(t){this.callback=t.callback||{};var e={title:_VST("library","permission"),width:500,height:580,minWidth:300,minHeight:280,resizable:!0,layout:"fit",items:[this.getGridPanel(t)],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",text:_T("common","cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(e,t)])},getGridPanel:function(t){return this._grid=this._grid||new SYNO.SDS.VideoStation2.Setting.LibraryPermissionGrid({library_id:t.library_id,permission:t.permission}),this._grid},onApply:function(){SYNO.SDS.VideoStation2.Util.applyCallback(Ext.apply(this.callback,{args:[this.getGridPanel().getChanges()]})),this.close()},onCancel:function(){if(!this.getGridPanel().isDirty())return void this.close();var t=function(t){"yes"===t&&this.close()};this.getMsgBox().confirm("",_T("common","confirm_lostchange"),t,this)}}),Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryPermissionGrid",{extend:"SYNO.SDS.VideoStation2.EnableGrid",constructor:function(t){this.library_id=t.library_id,this.changes=t.permission;var e={plugins:[this.getBrowseColumn()]};this.callParent([Ext.apply(e,t)]),this.mon(this.getStore(),"load",this.applyLocalChanges,this)},confirm:function(t,e,i,o){SYNO.SDS.VideoStation2.SettingController.get().confirm(t,e,i,o)},getStore:function(){return this._store=this._store||new Ext.data.JsonStore({proxy:new Ext.data.HttpProxy({url:SYNO.SDS.VideoStation2.Util.getCGIURL("library_manage.cgi"),listeners:{beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),autoLoad:!0,root:"data.users",totalProperty:"data.total",baseParams:{action:"list_permission",id:this.library_id},fields:[{name:"name",type:"string"},{name:"uid",type:"int"},{name:"is_admin",type:"boolean",defaulValue:!1},{name:"browse",type:"boolean",defaulValue:!1}]}),this._store},getColumns:function(){return this._cm=this._cm||new Ext.grid.ColumnModel({defaults:{align:"center",sortable:!1},columns:[{align:"left",header:_T("common","name"),dataIndex:"name",id:"name"},this.getBrowseColumn()]}),this._cm},saveChanges:function(t){this.changes=this.getChanges(),SYNO.SDS.VideoStation2.Util.applyCallback(t)},getBrowseColumn:function(){return this._browse_column=this._browse_column||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("common","browse"),dataIndex:"browse",id:"browse",width:150,ignoreKey:"is_admin"}),this._browse_column},getStoreChanges:function(){var t={};return Ext.each(this.getStore().getModifiedRecords(),function(e){var i=e.get("uid");t[i]=t[i]||{},t[i].browse=e.get("browse")}),t},getChanges:function(){return Ext.apply(this.changes||{},this.getStoreChanges())},applyLocalChanges:function(t,e,i){Ext.isObject(this.changes)&&(t.each(function(t){var e=t.get("uid");Ext.isDefined(this.changes[e])&&t.set("browse",this.changes[e].browse)},this),t.commitChanges())}}),Ext.define("SYNO.SDS.VideoStation2.LibraryDialog",{extend:"SYNO.SDS.VideoStation2.AddEditDialog",cgi:"library_manage.cgi",constructor:function(t){this.library=SYNO.Util.copy(t.library),this.callback=t.callback||{};var e={resizable:!1};this.callParent([Ext.apply(e,t)])},onOpen:function(){if(this.callParent(arguments),!this.isAddMode()){var t=this.getFormPanel().getForm();t.findField("title").setValue(this.library.title),t.findField("type").setValue(this.library.type),t.findField("is_public").setValue(this.library.is_public?1:0),this.original_values=t.getValues()}},getFormConfig:function(){return{trackResetOnLoad:!0,border:!1,labelWidth:180,hideLabels:!1,items:[{xtype:"syno_vs_textfield",itemId:"title",fieldLabel:_T("common","name"),allowBlank:!1,maxLength:50},{xtype:"syno_vs_radiogroup",itemId:"type",fieldLabel:_VST("type","tile"),hideLabel:!1,columns:1,items:[{boxLabel:_VST("type","movie"),inputValue:SYNO.SDS.VideoStation2.Constant.MOVIE,name:"type",checked:!0},{boxLabel:_VST("type","tv_show"),inputValue:SYNO.SDS.VideoStation2.Constant.TVSHOW,name:"type",checked:!1},{boxLabel:_VST("type","others"),inputValue:SYNO.SDS.VideoStation2.Constant.HOME_VIDEO,name:"type",checked:!1}]},{xtype:"syno_vs_radiogroup",itemId:"is_public",fieldLabel:_VST("library","permission_title"),hideLabel:!1,columns:1,items:[{boxLabel:_VST("library","public"),inputValue:1,name:"is_public",checked:!0},{boxLabel:_VST("library","private"),inputValue:0,name:"is_public",checked:!1}],listeners:{scope:this,change:function(t,e){this.getPermissionButton().setDisabled(1===e.inputValue)}}},{xtype:"syno_compositefield",items:[this.getPermissionButton()]}]}},getPermissionButton:function(){return this._permission_btn=this._permission_btn||new SYNO.SDS.VideoStation2.Button({btnStyle:"red",itemId:"permissionButton",disabled:!0,text:_VST("library","permission"),handler:this.openPermissionDialog.createDelegate(this)}),this._permission_btn},openPermissionDialog:function(){var t=Ext.isObject(this.library)?this.library.id:0,e=SYNO.SDS.VideoStation2.SettingController.get(),i=new SYNO.SDS.VideoStation2.Setting.LibraryPermissionDialog({owner:e.getActiveWindow(),library_id:t,permission:this.permission,callback:{scope:this,fn:function(t){this.permission=this.permission||{},Ext.apply(this.permission,t)}}});e.openDialog(i)},isDirty:function(){return!!Ext.isObject(this.library)&&(Ext.isObject(this.permission)||!SYNO.ux.Utils.checkObjectConsistency(this.getFormPanel().getForm().getValues(),this.original_values))},isValid:function(){return this.getFormPanel().getForm().isValid()},getInvalidError:function(){return _T("error","error_bad_field")},getParameter:function(){var t=this.getFormPanel().getForm(),e={title:t.findField("title").getValue(),is_public:t.findField("is_public").getValue().inputValue,type:t.findField("type").getValue().inputValue,permission:Ext.encode(this.permission||{})};return Ext.isObject(this.library)&&!this.isAddMode()&&Ext.apply(e,{id:this.library.id,old_type:this.library.type,old_is_public:this.library.is_public?1:0,old_title:this.library.title}),e}}),Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryPanel",{extend:"SYNO.ux.Panel",constructor:function(t){var e={title:_VST("library","title"),cls:"library-panel",autoFlexcroll:!0,layout:"accordion",layoutConfig:{animate:!1,activeOnTop:!1,fill:!1,hideCollapseTool:!0,titleCollapse:!0},tbar:this.getToolbar(),items:[this.getItems()]};this.callParent([Ext.apply(e,t)]),this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_HEIGHT_CHANGE),this.bindAllEvents(),this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.refreshLibrary,this),this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,this.onFolderSelectionChange,this),this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_LIBRARY_SELECTION_CHANGE,this.onLibrarySelectionChange,this)},getToolbar:function(){return this._tbar=this._tbar||new SYNO.ux.Toolbar({items:[new SYNO.SDS.VideoStation2.ActionButton({cls:"add-l",tooltip:_VST("library","create"),scope:this,handler:this.addLibrary}),this.getReindexButton(),this.getSearchInfoButton(),this.getExportButton()]}),this._tbar},getItems:function(){return SYNO.SDS.VideoStation2.Library.get().getAllLibraries().map(function(t){return new SYNO.SDS.VideoStation2.Setting.FolderPanel({library:t})})},getReindexButton:function(){return this._reindex=this._reindex||new SYNO.SDS.VideoStation2.ActionButton({cls:"reindex",tooltip:_VST("action","reindex_no_update"),scope:this,disabled:!0,handler:this.doReindex}),this._reindex},getSearchInfoButton:function(){return this._search=this._search||new SYNO.SDS.VideoStation2.ActionButton({cls:"search-info",tooltip:_VST("action","reindex_with_update"),scope:this,disabled:!0,handler:this.doSearchInfo}),this._search},getExportButton:function(){return this._export=this._export||new SYNO.SDS.VideoStation2.ActionButton({cls:"export",tooltip:_VST("action","export_metadata"),scope:this,handler:this.exportMetadata}),this._export},bindAllEvents:function(){this.items.each(function(t){this.relayEvents(t,[SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_HEIGHT_CHANGE,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_LIBRARY_SELECTION_CHANGE]),t.relayEvents(this,[SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_REINDEX,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_SEARCH_INFO,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_RELOAD_FOLDER])},this)},refreshLibrary:function(){this.removeAll(),this.add(this.getItems()),this.bindAllEvents(),this.doLayout()},onLibrarySelectionChange:function(t){this.active_library=SYNO.Util.copy(t),this.getExportButton().setDisabled(!Ext.isObject(this.active_library))},onFolderSelectionChange:function(t){this.getReindexButton().setDisabled(!Ext.isObject(t)),this.getSearchInfoButton().setDisabled(!Ext.isObject(t)),this.getExportButton().setDisabled(Ext.isObject(t))},addLibrary:function(){var t=SYNO.SDS.VideoStation2.SettingController.get(),e=new SYNO.SDS.VideoStation2.LibraryDialog({owner:t.getActiveWindow(),mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_ADD,callback:{fn:function(){SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()}}});t.openDialog(e)},doReindex:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_REINDEX,this.active_library)},doSearchInfo:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_SEARCH_INFO,this.active_library)},doReloadCurrentLibrary:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_RELOAD_FOLDER,this.active_library)},exportMetadata:function(){var t=function(){SYNO.SDS.VideoStation2.SettingController.get().exportMetadata(this.active_library||{},{fn:this.doReloadCurrentLibrary,scope:this})};SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("action","settings"),_VST("library","export_metadata_desc"),t,this)}}),Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event",{statics:{EVENT_HEIGHT_CHANGE:"heightchange",EVENT_DO_REINDEX:"doreindex",EVENT_DO_SEARCH_INFO:"dosearchinfo",EVENT_DO_RELOAD_FOLDER:"doreloadfolder",EVENT_FOLDER_CHANGE:"folderchange",EVENT_FOLDER_SELECTION_CHANGE:"folderselectionchange",EVENT_LIBRARY_SELECTION_CHANGE:"libraryselectionchange",EVENT_EDIT_FOLDER:"editfolder",EVENT_DELETE_FOLDER:"deletefolder"}}),Ext.define("SYNO.SDS.VideoStation2.Setting.FolderPanel",{extend:"SYNO.SDS.VideoStation2.AccordionPanel",statics:{ACTION_ADD_FOLDER:{cls:"add-folder",qtip:_VST("videofolder","add"),fn:"addFolder"},ACTION_EDIT_LIBRARY:{cls:"edit",qtip:_VST("library","edit"),fn:"editLibrary"},ACTION_DELETE_LIBRARY:{cls:"delete",qtip:_VST("library","delete"),fn:"deleteLibrary"}},header:!1,headerAsText:!1,title:null,constructor:function(t){this.library=SYNO.Util.copy(t.library),this.dataview=new SYNO.SDS.VideoStation2.Setting.FolderDataView({store:this.getStore()});var e={cls:"folder-panel",headerCfg:this.getHeaderConfig(),items:[this.dataview],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,expand:this.notifyHeightChange,collapse:this.onPanelCollapse}};this.callParent([Ext.apply(e,t)]),this.relayEvents(this.dataview,[SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE]),this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_CHANGE,this.loadData,this),this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,this.onFolderSelectionChange,this),this.mon(this.dataview,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_EDIT_FOLDER,this.editFolder,this),this.mon(this.dataview,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DELETE_FOLDER,this.deleteFolder,this)},getHeaderConfig:function(){var t={tag:"td",align:"left",cn:[{tag:"div",cls:String.format("{0} icon",this.library.type||"")},{tag:"div",cls:"title",html:Ext.util.Format.htmlEncode(this.library.title)}]},e=[SYNO.Util.copy(SYNO.SDS.VideoStation2.Setting.FolderPanel.ACTION_ADD_FOLDER)];return this.library.id>0&&Array.prototype.push.apply(e,[SYNO.Util.copy(SYNO.SDS.VideoStation2.Setting.FolderPanel.ACTION_EDIT_LIBRARY),SYNO.Util.copy(SYNO.SDS.VideoStation2.Setting.FolderPanel.ACTION_DELETE_LIBRARY)]),e=e.map(function(t){return{tag:"div","ext:qtip":Ext.util.Format.htmlEncode(t.qtip),cls:String.format("action {0}",t.cls),fnname:t.fn}}),{tag:"div",cls:"x-panel-header",cn:[{tag:"table",cls:"x-toolbar-ct",cn:[{tag:"tbody",cn:[{tag:"tr",cn:[t,{tag:"td",align:"right",cn:e}]}]}]}]}},getStoreParameter:function(){var t={action:"list",section:this.library.type};return this.library.id>0&&Ext.apply(t,{library_id:this.library.id}),t},getStore:function(){return this._store=this._store||new Ext.data.JsonStore({autoLoad:!1,autoDestroy:!0,idProperty:"path",root:"data.folders",baseParams:this.getStoreParameter(),fields:["exist","path","preferlang","status","share","subpath","search_metadata"],proxy:new Ext.data.HttpProxy({url:SYNO.SDS.VideoStation2.Util.getCGIURL("folder_manage.cgi"),listeners:{scope:this,beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),listeners:{scope:this,load:this.onFolderLoad}}),this._store},toggleCollapse:function(t){var e=Ext.fly(t.getTarget());e.hasClass("action")?this[e.getAttribute("fnname")]():this.callParent(arguments)},addFolder:function(){SYNO.SDS.VideoStation2.SettingController.get().launchFolderDialog(!0,this.library,{fn:this.loadData,scope:this})},editFolder:function(t){var e=SYNO.SDS.VideoStation2.SettingController.get(),i=new SYNO.SDS.VideoStation2.FolderDialog({owner:e.getActiveWindow(),library:this.library,folder:t,mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_EDIT,callback:{scope:this,fn:this.notifyFolderChange}});e.openDialog(i)},editLibrary:function(){var t=SYNO.SDS.VideoStation2.SettingController.get(),e=new SYNO.SDS.VideoStation2.LibraryDialog({owner:t.getActiveWindow(),library:this.library,mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_EDIT,callback:{scope:this,fn:this.afterEditLibrary}});t.openDialog(e)},deleteFolder:function(t){var e=function(){SYNO.SDS.VideoStation2.SettingController.get().deleteFolder(SYNO.Util.copy(t),{fn:this.notifyFolderChange,scope:this})};SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("action","settings"),_VST("videofolder","delete_confirm"),e,this)},deleteLibrary:function(){var t=function(){SYNO.SDS.VideoStation2.SettingController.get().deleteLibrary(this.library,{fn:this.afterDeleteLibrary,scope:this})};SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("action","settings"),_VST("library","delete_confirm"),t,this)},afterEditLibrary:function(t){var e=t.params,i=SYNO.SDS.VideoStation2.LibraryStore,o=SYNO.SDS.VideoStation2.Library.get().cursor,n=i.convertOPID({type:e.old_type,id:e.id}),a=i.convertOPID({type:e.type,id:e.id});n!==a&&n===o&&SYNO.SDS.VideoStation2.LibraryController.get().waitToActivateLibrary(a),SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()},afterDeleteLibrary:function(t){var e=t.params,i=SYNO.SDS.VideoStation2.Library.get().cursor;SYNO.SDS.VideoStation2.LibraryStore.convertOPID({type:e.type,id:e.id})===i&&SYNO.SDS.VideoStation2.Controller.intoHomePage(),SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()},reindexRequest:function(t){if(!Ext.isObject(this.active_folder))return void SYNO.Debug.error("no folder selection");SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("folder_manage.cgi"),params:{action:t,share:this.active_folder.share,subpath:this.active_folder.subpath},loading_text:_T("common","loading"),callback:{fn:this.loadData,scope:this}})},doReindex:function(t){SYNO.ux.Utils.checkObjectConsistency(this.library,t)&&this.reindexRequest("reindex-noupdate")},doSearchInfo:function(t){SYNO.ux.Utils.checkObjectConsistency(this.library,t)&&this.reindexRequest("reindex-update")},doReloadFolder:function(t){SYNO.ux.Utils.checkObjectConsistency(this.library,t)&&this.loadData()},onPanelCollapse:function(){this.dataview.clearSelections(),this.notifyHeightChange()},notifyHeightChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_HEIGHT_CHANGE)},notifyFolderChange:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_CHANGE)},onFolderLoad:function(t,e,i){this.collapsed||this.notifyHeightChange()},onActivate:function(){this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_REINDEX,this.doReindex,this),this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_SEARCH_INFO,this.doSearchInfo,this),this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_RELOAD_FOLDER,this.doReloadFolder,this),this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_LIBRARY_SELECTION_CHANGE,this.library),this.loadData()},onDeactivate:function(){this.mun(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_REINDEX,this.doReindex,this),this.mun(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_SEARCH_INFO,this.doSearchInfo,this),this.mun(this,SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DO_RELOAD_FOLDER,this.doReloadFolder,this),this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,null)},onFolderSelectionChange:function(t){this.active_folder=SYNO.Util.copy(t)},loadData:function(){this.getStore().load()}}),Ext.define("SYNO.SDS.VideoStation2.Setting.FolderDataView",{extend:"Ext.DataView",constructor:function(t){var e={cls:"folder-dataview",tpl:this.getTpl(),itemSelector:"div.item-wrap",overClass:"x-view-over",singleSelect:!0,listeners:{scope:this,selectionchange:this.onSelectionChange}};this.callParent([Ext.apply(e,t)])},getTpl:function(){var t=Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(_VST("videofolder","edit"))),e=Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(_VST("videofolder","delete")));return new Ext.XTemplate('<tpl for=".">','<div class="item-wrap">','<div class="select-mark"></div>','<table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">','<div class="text-wrapper sds-ellipsis">','<span class="path">{path}</span>{[this.getStatusSpan(values)]}',"</div>","</td>",'<td align="right">','<div class="action-wrapper">',String.format('<div ext:qtip="{0}" class="action edit"></div><div ext:qtip="{1}", class="action delete"></div>',t,e),"</div>","</td>","</tr></tbody></table>","</div>","</tpl>",{compiled:!0,getStatusSpan:this.getStatusSpan.createDelegate(this)})},getStatusSpan:function(t){if(Ext.isEmpty(t.status))return"";var e="indexing"===t.status?_VST("reindex","indexing")+"...":_VST("library","metadata_exporting");return String.format('<span class="status">({0})</span>',e)},onClick:function(t,e,i){var o=Ext.fly(e),n=t.getTarget(this.itemSelector,this.getTemplateTarget()),a=this.getRecord(n);o.hasClass("delete")?this.deleteFolder(a):o.hasClass("edit")?this.editFolder(a):this.callParent(arguments)},onSelectionChange:function(t,e){Ext.isEmpty(e)?this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,null):this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_FOLDER_SELECTION_CHANGE,t.getRecord(e[0]).data)},editFolder:function(t){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_EDIT_FOLDER,t.data)},deleteFolder:function(t){this.fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryPanel.Event.EVENT_DELETE_FOLDER,t.data)}}),Ext.define("SYNO.SDS.VideoStation2.CertificateProxy",{extend:"SYNO.API.Proxy",statics:{translateCertificate:function(t){return t.map(function(t){return{value:t,display:Ext.isEmpty(t)?_VST("parental_control","empty_rating"):t}})}},constructor:function(t){this.callParent([t])},onRequestAPI:function(t,e,i,o,n,a,S,s,r){e.certificate=SYNO.SDS.VideoStation2.CertificateProxy.translateCertificate(e.certificate),this.callParent(arguments)}}),Ext.define("SYNO.SDS.VideoStation2.Stores.certificate",{extend:"SYNO.SDS.VideoStation2.Stores",proxyClass:"SYNO.SDS.VideoStation2.CertificateProxy",synoAPI:"SYNO.VideoStation2.ParentalControl",synoMethod:"list_certificate",baseConfigs:{baseParams:{sort_direction:"asc",limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT},reader:{id:"value",root:"certificate",totalProperty:"total",fields:["value","display"]}}}),Ext.define("SYNO.SDS.VideoStation2.CertificateSelector",{extend:"SYNO.SDS.VideoStation2.SuperBox",_type:null,constructor:function(t){this._type=t.type;var e={valueField:"value",displayField:"display",triggerAction:"all",mode:"remote",allowQueryAll:!0,editable:!0,grow:!0,queryParam:"match",minChars:1,typeAhead:!0,allowAddNewData:!0,valueDelimiter:"|",store:this.getStore()};this.callParent([Ext.apply(e,t)])},getStore:function(t){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.certificate({listeners:{scope:this,beforeload:this.onBeforeLoadStore}}),this._store},onBeforeLoadStore:function(t,e){var i=e.params;Ext.apply(i,{type:this._type})},getApiValue:function(){return this.disabled?null:this.getValueEx().map(function(t){return t.value})}}),Ext.define("SYNO.SDS.VideoStation2.Stores.User",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.ParentalControl",synoMethod:"list_user",baseConfigs:{baseParams:{offset:0,limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT},reader:{id:"uid",root:"user",totalProperty:"total",fields:["uid","name"]}}}),Ext.define("SYNO.SDS.VideoStation2.Setting.ParentalControlDialog",{extend:"SYNO.SDS.VideoStation2.AddEditDialog",statics:{EVENT_APPLY_SUCCESS:"apply_success",FOUR_TYPE:[SYNO.SDS.VideoStation2.Constant.MOVIE,SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE,SYNO.SDS.VideoStation2.Constant.HOME_VIDEO,SYNO.SDS.VideoStation2.Constant.TV_RECORDING]},constructor:function(t){var e={cls:"parental-control-setting",width:700,height:500,minWidth:500,minHeight:300,listeners:{scope:this,afterrender:this.initEnableCheckGroup}};this.isAddMode()||(this._user=t.user),this.callParent([Ext.apply(e,t)]),this.loadSetting()},initEnableCheckGroup:function(){new SYNO.ux.Utils.EnableCheckGroup(this.getFormPanel().getForm(),"enabled",SYNO.SDS.VideoStation2.Setting.ParentalControlDialog.FOUR_TYPE.concat("pin"))},isDirty:function(){return!!this.isAddMode()||!SYNO.ux.Utils.checkObjectConsistency(this.getAllValues(),this.ori_values)},isValid:function(){return this.getFormPanel().getForm().isValid()&&Ext.isNumber(this.getUserValue())},getFormConfig:function(){return{trackResetOnLoad:!0,border:!1,items:[this.getEnableCheckbox(),this.getUserField()].concat(SYNO.SDS.VideoStation2.Setting.ParentalControlDialog.FOUR_TYPE.map(function(t){return this.createCertificateSelector(t)},this)).concat(this.getPinCodeField()).concat(this.getDescriptionField())}},getInvalidError:function(){return _T("error","error_bad_field")},onApply:function(){return this.isValid()?this.isDirty()?(this.setStatusBusy({text:_T("common","loading")}),void SYNO.SDS.VideoStation2.OP.get().setParentalControl(this.getAllValues(),{scope:this,success:this.onSuccess,failure:this.onFailure})):void this.close():void SYNO.SDS.VideoStation2.SettingController.get().alert(this.title,this.getInvalidError())},getAllValues:function(){var t=this.getFormPanel().getForm(),e=t.findField("enabled").getValue(),i={user:this.getUserValue(),enabled:e};if(!e)return i;var o={};return Ext.each(SYNO.SDS.VideoStation2.Setting.ParentalControlDialog.FOUR_TYPE,function(e){var i=t.findField(e).getApiValue();Ext.isArray(i)&&(o[e]=i)},this),i.pin=t.findField("pin").getValue().toString(),i.whitelist=o,i},getEnableCheckbox:function(){return this._enabled=this._enabled||new SYNO.SDS.VideoStation2.Checkbox({name:"enabled",boxLabel:_VST("common","enabled")}),this._enabled},getUserValue:function(){return this.isAddMode()?this.getUserCombobox().getValue():this._user.uid},getUserField:function(){return this.isAddMode()?this.getUserCombobox():this.getUserDisplayField()},getUserDisplayField:function(){return this._user_display=this._user_display||new SYNO.SDS.VideoStation2.DisplayField({name:"user",fieldLabel:_T("common","user"),
indent:1,value:this._user.name}),this._user_display},getUserStore:function(){return this._user_store=this._user_store||new SYNO.SDS.VideoStation2.Stores.User({}),this._user_store},getUserCombobox:function(){return this._user_combo=this._user_combo||new SYNO.SDS.VideoStation2.ComboBox({name:"user",fieldLabel:_T("common","user"),indent:1,allowBlank:!1,forceSelection:!0,displayField:"name",mode:"remote",pageSize:300,valueField:"uid",queryParam:"match",editable:!0,typeAhead:!0,minChars:1,store:this.getUserStore()}),this._user_combo},getTypeLabel:function(t){switch(t){case SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:return _VST("type","tv_show");case SYNO.SDS.VideoStation2.Constant.TV_RECORDING:return _VST("type","tv_recorder");default:return _VST("type",t)}},createCertificateSelector:function(t){return new SYNO.SDS.VideoStation2.CertificateSelector({name:t,type:t,fieldLabel:this.getTypeLabel(t),indent:1,listeners:{change:{scope:this,fn:this.doLayout,buffer:100}}})},getPinCodeField:function(){return this._pin=this._pin||new SYNO.SDS.VideoStation2.TextField({name:"pin",minLength:4,maxlength:4,maxLength:4,maskRe:new RegExp("[0-9]"),validator:function(t){return!(!Ext.isNumber(parseInt(t,10))||4!==t.length)||_VST("parental_control","pin_invalid_tip")},fieldLabel:_VST("parental_control","pin_code"),indent:1}),this._pin},getDescriptionField:function(){return this._desc=this._desc||new SYNO.SDS.VideoStation2.DisplayField({cls:"setting-desc",fieldLabel:"",indent:1,htmlEncode:!1,value:String.format('<span class="syno-ux-note">{0}: </span>{1}',Ext.util.Format.htmlEncode(_T("common","note")),Ext.util.Format.htmlEncode(_VST("parental_control","setting_description")))}),this._desc},loadSetting:function(){if(this.isAddMode())return void this.getFormPanel().getForm().findField("enabled").setValue(!0);SYNO.SDS.VideoStation2.OP.get().getParentalControl({user:this._user.uid},{scope:this,success:this.fillValue})},fillValue:function(t,e,i){var o=this.getFormPanel().getForm();o.findField("enabled").setValue(t.enabled),o.findField("pin").setValue(t.pin),Ext.iterate(t.whitelist,function(t,e){o.findField(t).setValueEx(SYNO.SDS.VideoStation2.CertificateProxy.translateCertificate(e))}),this.ori_values=this.getAllValues()},onSuccess:function(){this.clearStatusBusy(),this.fireEvent(SYNO.SDS.VideoStation2.Setting.ParentalControlDialog.EVENT_APPLY_SUCCESS),this.close()},onFailure:function(t,e,i){this.clearStatusBusy(),SYNO.SDS.VideoStation2.OP.defaultFailureCallback(t,e,i)}}),Ext.define("SYNO.SDS.VideoStation2.Stores.ParentalControlUser",{extend:"SYNO.SDS.VideoStation2.Stores",synoAPI:"SYNO.VideoStation2.ParentalControl",synoMethod:"list",baseConfigs:{baseParams:{offset:0,limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT},reader:{id:"uid",root:"user",totalProperty:"total",fields:["uid","name","enabled"]}}}),Ext.define("SYNO.SDS.VideoStation2.Setting.ParentalControlEvent",{singleton:!0,EVENT_CREATE_SETTING:"create_setting",EVENT_EDIT_SETTING:"edit_setting",EVENT_DELETE_SETTING:"delete_setting"}),Ext.define("SYNO.SDS.VideoStation2.Setting.ParentalControlPanel",{extend:"SYNO.ux.Panel",constructor:function(t){var e={title:_VST("parental_control","title"),cls:"parental-control-panel",autoFlexcroll:!0,layout:"fit",tbar:this.getToolbar(),items:[this.getDataview()],listeners:{scope:this,activate:this.loadData}};this.callParent([Ext.apply(e,t)]),this.mon(this.getDataview(),SYNO.SDS.VideoStation2.Setting.ParentalControlEvent.EVENT_CREATE_SETTING,this.createSetting,this),this.mon(this.getDataview(),SYNO.SDS.VideoStation2.Setting.ParentalControlEvent.EVENT_EDIT_SETTING,this.editSetting,this),this.mon(this.getDataview(),SYNO.SDS.VideoStation2.Setting.ParentalControlEvent.EVENT_DELETE_SETTING,this.deleteSetting,this)},getToolbar:function(){return this._tbar=this._tbar||new SYNO.ux.Toolbar({items:[new SYNO.SDS.VideoStation2.ActionButton({cls:"add-l",tooltip:_VST("parental_control","new_setting"),scope:this,handler:this.createSetting}),{xtype:"tbseparator"}]}),this._tbar},getDataview:function(){return this._dataview=this._dataview||new SYNO.SDS.VideoStation2.Setting.ParentalControl.UserView({store:this.getStore()}),this._dataview},createSetting:function(){var t=SYNO.SDS.VideoStation2.SettingController.get(),e=new SYNO.SDS.VideoStation2.Setting.ParentalControlDialog({owner:t.getActiveWindow(),mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_ADD});this.mon(e,SYNO.SDS.VideoStation2.Setting.ParentalControlDialog.EVENT_APPLY_SUCCESS,this.loadData,this),t.openDialog(e)},editSetting:function(t){var e=SYNO.SDS.VideoStation2.SettingController.get(),i=new SYNO.SDS.VideoStation2.Setting.ParentalControlDialog({owner:e.getActiveWindow(),mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_EDIT,user:t});this.mon(i,SYNO.SDS.VideoStation2.Setting.ParentalControlDialog.EVENT_APPLY_SUCCESS,this.loadData,this),e.openDialog(i)},deleteSetting:function(t){SYNO.SDS.VideoStation2.SettingController.get().confirmPromise(_VST("parental_control","title"),_VST("parental_control","delete_confirm")).then(function(){return SYNO.SDS.VideoStation2.PromiseOP.get().deleteParentalControl({user:t.uid})}).then(function(){this.loadData()}.bind(this))},getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.ParentalControlUser({}),this._store},loadData:function(){this.getStore().load()}}),Ext.define("SYNO.SDS.VideoStation2.Setting.ParentalControl.UserView",{extend:"Ext.DataView",statics:{EMPTY_TEMPLATE:['<div class="empty-wrapper"><div class="inner">','<table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left" class="icon">','<div class="icon-empty"></div>',"</td>",'<td class="description">',"<div>{0}</div>","</td>","</tr></tbody></table>","</div></div>"].join("")},constructor:function(t){var e=String.format(SYNO.SDS.VideoStation2.Setting.ParentalControl.UserView.EMPTY_TEMPLATE,Ext.util.Format.htmlEncode(_VST("parental_control","empty_description"))),i={cls:"user-dataview",tpl:this.getTpl(),itemSelector:"div.item-wrap",overClass:"x-view-over",emptyText:e,singleSelect:!1};this.callParent([Ext.apply(i,t)])},getTpl:function(){var t=Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(_VST("common","edit"))),e=Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(_VST("common","delete")));return new Ext.XTemplate('<tpl for=".">','<div class="item-wrap {[this.getEnabledStatusCls(values)]}">','<table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left" class="user">','<div class="status-icon"></div>','<div class="name sds-ellipsis">{name:htmlEncode}</div>',"</td>",'<td align="right" class="status">',"<div>{[this.getEnabledStatusText(values)]}</div>","</td>",'<td align="right" class="action-wrapper">',"<div>",String.format('<div ext:qtip="{0}" class="action edit"></div><div ext:qtip="{1}", class="action delete"></div>',t,e),"</div>","</td>","</tr></tbody></table>","</div>","</tpl>",{compiled:!0,getEnabledStatusCls:this.getEnabledStatusCls.bind(this),getEnabledStatusText:this.getEnabledStatusText.bind(this)})},getEnabledStatusCls:function(t){return!0===t.enabled?"":"disabled"},getEnabledStatusText:function(t){return String.format('<span class="status">{0}</span>',Ext.util.Format.htmlEncode(_VST("common",!0===t.enabled?"enabled":"disabled")))},onClick:function(t,e,i){var o=t.getTarget(this.itemSelector,this.getTemplateTarget()),n=Ext.fly(e);if(!o)return void(n.hasClass("icon-empty")?this.createSetting():this.callParent(arguments));var a=this.getRecord(o);n.hasClass("delete")?this.deleteSetting(a):n.hasClass("edit")?this.editSetting(a):this.callParent(arguments)},createSetting:function(){this.fireEvent(SYNO.SDS.VideoStation2.Setting.ParentalControlEvent.EVENT_CREATE_SETTING)},editSetting:function(t){this.fireEvent(SYNO.SDS.VideoStation2.Setting.ParentalControlEvent.EVENT_EDIT_SETTING,t.data)},deleteSetting:function(t){this.fireEvent(SYNO.SDS.VideoStation2.Setting.ParentalControlEvent.EVENT_DELETE_SETTING,t.data)}}),Ext.define("SYNO.SDS.VideoStation2.Setting.PrivilegePanel",{extend:"SYNO.SDS.VideoStation2.EnableGrid",constructor:function(t){var e={title:_VST("privilege","title"),plugins:this.getEnableColumns(),listeners:{scope:this,activate:this.onActivate}};this.callParent([Ext.apply(e,t)])},onActivate:function(){this.getStore().load()},confirm:function(t,e,i,o){SYNO.SDS.VideoStation2.SettingController.get().confirm(t,e,i,o)},getStore:function(){return this._store=this._store||new Ext.data.JsonStore({proxy:new Ext.data.HttpProxy({url:SYNO.SDS.VideoStation2.Util.getCGIURL("privilege_manage.cgi"),listeners:{beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),autoLoad:!1,root:"data.users",totalProperty:"data.total",baseParams:{action:"list"},fields:[{name:"name",type:"string"},{name:"uid",type:"int"},{name:"is_admin",type:"boolean",defaulValue:!1},{name:"dtv",type:"boolean",defaulValue:!1},{name:"renderer",type:"boolean",defaulValue:!1},{name:"sharing",type:"boolean",defaulValue:!1},{name:"offline_conversion",type:"boolean",defaulValue:!1}]}),this._store},getColumns:function(){return this._cm=this._cm||new Ext.grid.ColumnModel({defaults:{align:"center",sortable:!1},columns:[{align:"left",header:_T("common","name"),dataIndex:"name",id:"name"}].concat(this.getEnableColumns())}),this._cm},getEnableColumns:function(){var t=SYNO.SDS.VideoStation2.Util.hideDTVUI()?[]:[this.getDTVColumn()];return t=t.concat([this.getRendererColumn(),this.getSharingColumn()]),(SYNO.SDS.VideoStation2.Capability.get().ableToTranscode()||SYNO.SDS.VideoStation2.Capability.get().ableToHardwareTranscode())&&t.push(this.getOfflineConversionColumn()),t},saveChanges:function(t){SYNO.SDS.VideoStation2.SettingController.get().sendRequest({url:SYNO.SDS.VideoStation2.Util.getCGIURL("privilege_manage.cgi"),params:{action:"save",privilege:Ext.encode(this.getChanges()||{})},callback:t})},rejectChanges:function(){this.getStore().rejectChanges()},getDTVColumn:function(){return this._dtv=this._dtv||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("privilege","dtv_control"),dataIndex:"dtv",id:"dtv",width:150,ignoreKey:"is_admin"}),this._dtv},getRendererColumn:function(){return this._renderer=this._renderer||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("privilege","renderer_control"),dataIndex:"renderer",id:"renderer",width:200,ignoreKey:"is_admin"}),this._renderer},getSharingColumn:function(){return this._sharing=this._sharing||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("privilege","public_sharing"),dataIndex:"sharing",id:"sharing",width:150,ignoreKey:"is_admin"}),this._sharing},getOfflineConversionColumn:function(){return this._offline_conversion=this._offline_conversion||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("offline_conversion","title"),dataIndex:"offline_conversion",id:"offline_conversion",width:150,ignoreKey:"is_admin"}),this._offline_conversion},getChanges:function(){if(this.isDirty()){var t={};return Ext.each(this.getStore().getModifiedRecords(),function(e){var i=e.get("uid");t[i]=t[i]||{},Ext.each(["dtv","renderer","sharing","offline_conversion"],function(o){t[i][o]=e.get(o)})}),t}}}),Ext.define("SYNO.SDS.VideoStation2.Setting.Dialog",{extend:"SYNO.SDS.VideoStation2.Dialog",initActiveTab:0,constructor:function(t){var e={title:_VST("action","settings"),layout:"fit",width:730,height:580,minWidth:640,minHeight:440,items:[this.getTabPanel(t)],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",text:_T("common","cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(e,t)])},getTabPanel:function(t){return this._tab_panel=this._tab_panel||new SYNO.SDS.VideoStation2.Setting.TabPanel({activeTab:(t||{}).initActiveTab||this.initActiveTab}),this._tab_panel},onApply:function(){var t=this.getTabPanel(),e=t.getActiveTab();t.isActiveTabDirty()&&Ext.isFunction(e.saveChanges)?e.saveChanges({scope:this,fn:this.close}):this.close()},onCancel:function(){this.confirmLostChange({scope:this,fn:this.close})},confirmLostChange:function(t){if(!this.getTabPanel().isActiveTabDirty())return void SYNO.SDS.VideoStation2.Util.applyCallback(t);var e=function(e){"yes"===e&&SYNO.SDS.VideoStation2.Util.applyCallback(t)};SYNO.SDS.VideoStation2.SettingController.get().confirm(this.title,_T("common","confirm_lostchange"),e,this)}}),Ext.define("SYNO.SDS.VideoStation2.Setting.TabPanel",{extend:"SYNO.SDS.VideoStation2.TabPanel",constructor:function(t){this.callParent([Ext.apply(this.getConfig(),t)])},getConfig:function(){var t=[],e=["getLibrarySettingPanel","getParentalControlPanel","getDTVSettingPanel","getPrivilegePanel","getAdvancedSettingPanel","getGeneralPanel"];return Ext.each(e,function(e){var i=this[e]();Ext.isObject(i)&&t.push(i)},this),{activeTab:0,items:t,listeners:{scope:this,beforetabchange:this.onBeforeTabChange}}},getLibrarySettingPanel:function(){return _S("is_admin")?(this._library=this._library||new SYNO.SDS.VideoStation2.Setting.LibraryPanel({}),this._library):null},getParentalControlPanel:function(){return _S("is_admin")?(this._parental=this._parental||new SYNO.SDS.VideoStation2.Setting.ParentalControlPanel({}),this._parental):null},getDTVSettingPanel:function(){return!_S("is_admin")||SYNO.SDS.VideoStation2.Util.hideDTVUI()?null:(this._dtv=this._dtv||new SYNO.SDS.VideoStation2.Setting.DTVPanel({}),this._dtv)},getPrivilegePanel:function(){return _S("is_admin")?(this._privilege=this._privilege||new SYNO.SDS.VideoStation2.Setting.PrivilegePanel({}),this._privilege):null},getAdvancedSettingPanel:function(){return _S("is_admin")?(this._advanced=this._advanced||new SYNO.SDS.VideoStation2.Setting.AdvancedPanel({}),this._advanced):null},getGeneralPanel:function(){return this._general=this._general||new SYNO.SDS.VideoStation2.Setting.GeneralPanel({}),this._general},onBeforeTabChange:function(t,e,i){return!this.isActiveTabDirty()||(this.ownerCt.confirmLostChange({fn:function(){Ext.isFunction(i.rejectChanges)&&i.rejectChanges(),t.setActiveTab(e)}}),!1)},isActiveTabDirty:function(){var t=this.getActiveTab();return Ext.isObject(t)&&Ext.isFunction(t.isDirty)&&t.isDirty()}}),Ext.define("SYNO.SDS.VideoStation2.CreateScheduleDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",onScheduleCreate:Ext.emptyFn,tuner:null,channel:null,program:null,constructor:function(t){var e=t.program||this.program,i={layout:"fit",title:e?_VST("action","repeat_record"):_VST("schedule","user_define_schedule"),width:550,height:500,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.close})],items:[this.panel=new SYNO.SDS.VideoStation2.CreateScheduleDialog.Panel(t)]};this.callParent([Ext.apply(i,t)])},onOKBtn:function(){this.panel.isValid()&&(this.setStatusBusy(),SYNO.SDS.VideoStation2.OP.get()[this.program?"createRepeatRecording":"createUserDefinedRecording"](this.panel.getValues(),{success:this.onCreateRequest,failure:this.onRequestFail,scope:this}))},onCreateRequest:function(){this.clearStatusBusy(),Ext.isFunction(this.onScheduleCreate)&&this.onScheduleCreate(),this.close()},onRequestFail:function(t,e,i){this.clearStatusBusy();var o=SYNO.SDS.VideoStation2.Error.getAPIErrorString(t);this.getMsgBox().alert(this.title,o,function(){if(SYNO.SDS.VideoStation2.Error.DTV_INDEX_FOLDER_NOT_FOUND===t.code){var e=new SYNO.SDS.VideoStation2.Setting.Dialog({owner:this,initActiveTab:"dtv_settings"});SYNO.SDS.VideoStation2.SettingController.get().openDialog(e)}},this)}}),Ext.define("SYNO.SDS.VideoStation2.CreateScheduleDialog.Panel",{extend:"SYNO.SDS.VideoStation2.FormPanel",tuner:null,channel:null,program:null,constructor:function(t){var e={defaults:{anchor:"100%"},updateFormForScrollbar:!0,items:[this.getChannelTitleConfig(t),this.getProgramFields(t),this.getRepeatCheckboxConfig(t),this.getRepeatFields(t)]};this.callParent([Ext.apply(e,t)])},isValid:function(){return this.getForm().isValid()},setValues:function(t){Ext.isDefined(t.end_date)&&("1"===t.end_date?t.end_date="never":(t.end_date_day=t.end_date,t.end_date="day")),this.getForm().setValues(t),Ext.isDefined(t.start_date)&&this.confineRepeatDay(this.startDayField),Ext.isDefined(t.duration)&&this.syncDuration(this.durationField),Ext.isDefined(t.is_weekly)&&this.weekdayStatusField.setReadOnly(!t.is_weekly)},getValues:function(){var t=this.getForm().getValues();return t.is_repeating="true"===t.is_repeating,t.tuner_id=this.tuner,t.is_repeating&&(delete t.is_weekly,t.end_date="never"===t.end_date?"1":SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.end_date_day),Ext.isArray(t.weekday_status)?t.weekday_status=t.weekday_status.map(function(t){return parseInt(t,10)}):t.weekday_status=[parseInt(t.weekday_status,10)],delete t.end_date_day),this.program?(t.schedule_id={channel_id:this.channel.id,start_time:parseInt(t.start_time,10)},delete t.is_repeating,delete t.start_date):(t.channel_id=this.channel.id,t.start_date=SYNO.SDS.VideoStation2.Util.getYMDFormatedDate(t.start_date),t.start_date=t.start_date+" "+t.start_time,t.schedule_info={channel_name:this.channel.title,description:t.description,duration:SYNO.SDS.VideoStation2.DTVUtil.durationParser(t.duration)/60,title:t.title}),delete t.start_time,delete t.duration,delete t.description,delete t.title,delete t.end_time,t},getChannelTitleConfig:function(t){return[{xtype:"syno_vs_displayfield",value:(t.channel||this.channel).title,itemId:"display_channel_name",fieldLabel:_VST("schedule","channel")}]},getProgramFields:function(t){if(!this.programFields){var e=t.program||this.program,i=!!e,o=SYNO.SDS.VideoStation2.DTV.get().getDSMDate(),n=i?SYNO.SDS.VideoStation2.DTV.get().getDSMDate(e.start_time):null,a=function(t){var e=t.match(/^(\d{2}):(\d{2})$/);return e?parseInt(e[1],10)>23?_VST("schedule","hour_exceed"):!(parseInt(e[2],10)>59)||_VST("schedule","minute_exceed"):String.format(_VST("schedule","format_error"),"hh:mm")};this.programFields=[new SYNO.SDS.VideoStation2[i?"DisplayField":"TextField"]({name:"title",itemId:"title",fieldLabel:_VST("programguide","title"),allowBlank:!1,validator:SYNO.SDS.VideoStation2.Util.lengthValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.DVB_PROGRAM_NAME],!0),value:i?e.title:""}),new SYNO.SDS.VideoStation2.TextField({name:"description",itemId:"description",fieldLabel:_VST("programguide","description"),validator:SYNO.SDS.VideoStation2.Util.lengthValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.VIDEO_METADATA_SUMMARY],!0),value:i?e.description:"",hidden:i}),new SYNO.ux.CompositeField({fieldLabel:_T("common","start"),itemId:"start_date_time",hidden:i,items:[this.startDayField=new SYNO.SDS.VideoStation2.DateField({name:"start_date",itemId:"start_date",hideLabel:!0,editable:!1,flex:1,format:SYNO.SDS.DateTimeUtils?void 0:"Y-m-d",minValue:i?n:o,value:i?n:o,validator:function(t){return!!i||(t=SYNO.SDS.DateTimeUtils?Date.parseDate(t,SYNO.SDS.DateTimeUtils.GetDateFormat()):Date.parseDate(t,this.format),t.valueOf()>=Date.parseDate(o.format("Ymd"),"Ymd").valueOf()||_VST("repeat","repeat_endday_error"))},listeners:{scope:this,change:this.confineRepeatDayAndSet}}),this.startTimeField=new SYNO.SDS.VideoStation2.TextField({xtype:"syno_vs_textfield",name:"start_time",itemId:"start_time",hideLabel:!0,allowBlank:!1,flex:1,value:i?e.start_time:o.format("H:i"),validator:i?null:a,listeners:{scope:this,change:this.syncDuration}})]}),this.endTimeField=new SYNO.SDS.VideoStation2.TextField({xtype:"syno_vs_textfield",itemId:"end_time",name:"end_time",fieldLabel:String.format("{0} (hh:mm)",_VST("schedule","end")),value:o.add(Date.MINUTE,30).format("H:i"),validator:i?null:function(t){var e=a(t);return!0!==e?e:this.startTimeField.getValue()!==t||_VST("schedule","time_conflict")}.createDelegate(this),hidden:i,listeners:{scope:this,change:this.syncDuration}}),this.durationField=new SYNO.SDS.VideoStation2.TextField({name:"duration",itemId:"duration",fieldLabel:String.format("{0} (hh:mm)",_VST("schedule","duration")),value:i?e.duration:"00:30",validator:i?null:function(t){var e=a(t);return!0!==e?e:"00:00"!==t},hidden:i,listeners:{scope:this,change:this.syncDuration}})]}return this.programFields},getRepeatCheckboxConfig:function(t){var e=t.program||this.program,i=!!e;return[{xtype:"syno_vs_checkbox",name:"is_repeating",itemId:"is_repeating",boxLabel:_VST("action","repeat_record"),listeners:{scope:this,check:function(t,e){this.getRepeatFields().each(function(t){t.setDisabled(!e)}),this.endDateDayField.setDisabled(!this.endDateRadio.getValue()||!e),e&&this.weekdayStatusField.isOnlySetOneDay()&&this.confineRepeatDayAndSet(this.startDayField)}},checked:i,hidden:i}]},getRepeatFields:function(t){if(!this.repeatFields){var e=t.program||this.program,i=!!e,o=SYNO.SDS.VideoStation2.DTV.get().getDSMDate(),n=i?SYNO.SDS.VideoStation2.DTV.get().getDSMDate(e.start_time):null;this.repeatFields=[new SYNO.SDS.VideoStation2.ComboBox({name:"is_weekly",itemId:"is_weekly",fieldLabel:_VST("repeat","repeat"),displayField:"display",valueField:"value",indent:i?0:1,value:!0,disabled:!i,store:this.getRepeatWeeklyStore(),listeners:{scope:this,select:function(t){t.getValue()?(this.weekdayStatusField.setReadOnly(!1),this.weekdayStatusField.removeAllItems()):(this.weekdayStatusField.setValue([0,1,2,3,4,5,6]),this.weekdayStatusField.setReadOnly(!0))}}}),this.weekdayStatusField=new SYNO.SDS.VideoStation2.CreateScheduleDialog.WeekdayStatus({name:"weekday_status",itemId:"weekday_status",fieldLabel:_VST("repeat","repeat_data"),indent:i?0:1,mustHaveDay:i?n.getDay():o.getDay(),disabled:!i,listeners:{scope:this,valuechanged:this.doLayout}}),new SYNO.ux.CompositeField({fieldLabel:_VST("repeat","end_day"),itemId:"end_date_never",indent:i?0:1,disabled:!i,items:[this.neverEndDateRadio=new SYNO.SDS.VideoStation2.Radio({name:"end_date",itemId:"end_date",inputValue:"never",boxLabel:_VST("repeat","repeat_never"),checked:!0})]}),new SYNO.ux.CompositeField({indent:i?0:1,disabled:!i,items:[this.endDateRadio=new SYNO.SDS.VideoStation2.Radio({name:"end_date",itemId:"end_date",inputValue:"day",boxLabel:_VST("repeat","repeat_on"),listeners:{scope:this,check:function(t,e){this.endDateDayField.setDisabled(!e)}}}),this.endDateDayField=new SYNO.SDS.VideoStation2.DateField({name:"end_date_day",itemId:"end_date_day",hideLabel:!0,editable:!1,format:SYNO.SDS.DateTimeUtils?void 0:"Y-m-d",disabled:!0,minValue:i?n:o,value:i?n:o,validator:function(t){return t=SYNO.SDS.DateTimeUtils?Date.parseDate(t,SYNO.SDS.DateTimeUtils.GetDateFormat()):Date.parseDate(t,this.endDateDayField.format),t.valueOf()>=this.startDayField.getValue().valueOf()||_VST("repeat","repeat_endday_error")}.createDelegate(this)})]})]}return this.repeatFields},getRepeatWeeklyStore:function(){return this.repeatWeeklyStore=this.weeklyStore||new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:[[!0,_VST("repeat","repeat_weekly")],[!1,_VST("repeat","repeat_daily")]]}),this.repeatWeeklyStore},syncDuration:function(t){if(Ext.isEmpty(this.startTimeField.getActiveError())&&Ext.isEmpty(this.endTimeField.getActiveError())&&Ext.isEmpty(this.durationField.getActiveError())){var e,i,o;e=Date.parseDate(this.startTimeField.getValue(),"H:i"),"duration"===t.itemId?(o=Date.parseDate(this.durationField.getValue(),"H:i"),i=e.add(Date.HOUR,o.getHours()).add(Date.MINUTE,o.getMinutes()),this.endTimeField.setValue(i.format("H:i"))):(i=Date.parseDate(this.endTimeField.getValue(),"H:i"),i.valueOf()<e.valueOf()&&(i=i.add(Date.DAY,1)),o=Date.parseDuration(i.getElapsed(e)/1e3),o=new Date(0,0,0,o.hours||0,o.minutes||0),this.durationField.setValue(o.format("H:i")))}},confineRepeatDayAndSet:function(t){this.confineRepeatDay(t),this.weekdayStatusField.setValue(t.getValue().getDay())},confineRepeatDay:function(t){Ext.isEmpty(t.getActiveError())&&this.weekdayStatusField.setMustHaveDay(t.getValue().getDay())}}),Ext.define("SYNO.SDS.VideoStation2.CreateScheduleDialog.WeekdayStatus",{extend:"SYNO.SDS.VideoStation2.SuperBox",mustHaveDay:null,constructor:function(t){var e={valueField:"value",displayField:"display",triggerAction:"all",mode:"local",minChars:1,allowQueryAll:!0,editable:!1,grow:!0,typeAhead:!0,allowAddNewData:!0,addNewDataOnBlur:!0,value:t.mustHaveDay,store:this.getStore()};this.callParent([Ext.apply(e,t)]),this.mon(this,"beforeremoveitem",this.onBeforeRemoveItem,this)},getStore:function(){if(!this.store){var t=Array.apply(null,{length:7}).map(function(t,e){return[e,SYNO.SDS.VideoStation2.DTVUtil.getWeekdayString(e)]});this.store=new Ext.data.ArrayStore({autoDestroy:!0,fields:["value","display"],data:t})}return this.store},getValue:function(){var t=[];return this.items.each(function(e){t.push(e.value)}),t.join(this.valueDelimiter)},setValue:function(t){if(!this.readOnly){this.isSettingValue=!0;var e=Ext.isNumber(t)?[t]:[t.join(this.valueDelimiter)],i=this.callParent(e);return this.isSettingValue=!1,i}},setMustHaveDay:function(t){this.mustHaveDay=t},onBeforeRemoveItem:function(t,e){return this.isSettingValue||this.mustHaveDay!==e},isOnlySetOneDay:function(){return 1===this.items.length}}),Ext.define("SYNO.SDS.VideoStation2.SignalMenu",{extend:"SYNO.ux.Menu",tuners:[],ITEM_HEIGHT:34,constructor:function(t){var e={cls:"syno-vs2-signal-panel",items:[this.getPanel()],defaultOffsets:[34,0],listeners:{scope:this,beforeshow:function(){var t=this.getItems(),e=t.length*this.ITEM_HEIGHT;this.getPanel().loadData(t),this.getPanel().getDataView().setHeight(e),this.setHeight(e)}}};this.callParent([Ext.apply(e,t)])},getItems:function(){var t=[];return Ext.each(this.tuners,function(e){var i=e.get("signal");if(!Ext.isNumber(i)||i<=0)return!0;i=Ext.min([100,20*Math.ceil(i/20)]),t.push([e.get("tuner_id"),e.get("title"),i])},this),t},setupTuner:function(t){Ext.isArray(t)&&(this.tuners=t)},getPanel:function(){return this.panel?this.panel:(this.panel=new SYNO.SDS.VideoStation2.SignalPanel,this.panel)}}),Ext.define("SYNO.SDS.VideoStation2.SignalPanel",{extend:"SYNO.ux.Panel",constructor:function(t){var e={width:190,layout:"fit",autoHeight:!0,items:this.getDataView()};this.callParent([Ext.apply(e,t)])},getDataView:function(){return this.dataview?this.dataview:(this.dataview=new Ext.DataView({itemSelector:"div.item",emptyText:"No tuner",itemId:"dataview",cls:"syno-vs2-dtv-signalpanel-dataview",store:this.getStore(),tpl:new Ext.XTemplate('<tpl for=".">','<div class="item">','<div class="title">{values.title}</div>','<div class="image-{values.signal}"></div>',"</div>","</tpl>",{compiled:!0,disableFormats:!0})}),this.dataview)},getStore:function(){return this.store?this.store:(this.store=new Ext.data.ArrayStore({data:[],idIndex:0,autoDestroy:!0,fields:["tuner_id","title","signal"]}),this.addManagedComponent(this.store),this.store)},loadData:function(t){this.getStore().loadData(t,!1)}}),Ext.define("SYNO.SDS.VideoStation2.StreamingDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(t){t=t||{},this.currentTunerID=t.currentTunerID,this.callParent([this.fillConfig(t)])},fillConfig:function(t){var e={width:600,height:_S("is_admin")?300:250,minWidth:300,minHeight:250,title:_VST("programguide","broadcast_streaming"),layout:"fit",items:[this.getFormPanel()],buttons:[{xtype:"syno_vs_button",text:_VST("action","play"),btnStyle:"blue",hidden:!SYNO.SDS.VideoStation2.Capability.get().ableToPlayDTV(),scope:this,handler:this.onPlayStreaming},{xtype:"syno_vs_button",text:_VST("streaming","streaming_stop"),btnStyle:"red",hidden:!SYNO.SDS.VideoStation2.Capability.get().ableToControlDTV(),scope:this,handler:this.onStopStreaming},{xtype:"syno_vs_button",text:_T("common","close"),scope:this,handler:this.close}],keys:[{key:27,scope:this,handler:this.close}]};return Ext.apply(e,t)},show:function(){this.setStatusBusy({text:_T("common","loading")}),this.basePort=9025,SYNO.SDS.VideoStation2.OP.get().listTuner({additional:["channel_status"],limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT},{scope:this,success:this.getTunerListDone}),this.callParent(arguments)},getTunerListDone:function(t,e,i){if(!t.tuner||0===t.tuner.length)return void this.clearStatusBusy();var o=this.formPanel.tunerCombo.getStore(),n=[];Ext.each(t.tuner,function(t,e,i){t&&t.additional&&t.additional.channel_status&&!Ext.isEmpty(t.additional.channel_status.streaming_id)&&(Ext.isDefined(this.currentTunerID)||(this.currentTunerID=t.tuner_id),n.push([t.tuner_id,t.title]))},this);var a=this.basePort;Ext.isDefined(this.currentTunerID)&&(a=this.currentTunerID%16+a);var S=String.format(_VST("streaming","streaming_description"),a);this.formPanel.getForm().findField("description").setValue(S),o.loadData(n,!1),o.sort("display","ASC"),Ext.isDefined(this.currentTunerID)?this.formPanel.tunerCombo.setValue(this.currentTunerID):this.formPanel.tunerCombo.setValue(0),SYNO.SDS.VideoStation2.OP.get().getDTVChannel({tuner_id:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},{scope:this,success:this.getChannelDone})},getChannelDone:function(t,e,i){t&&!Ext.isEmpty(t.streaming_id)?SYNO.SDS.VideoStation2.OP.get().getDTVChannelInfo({channel_id:[t.streaming_id],tuner_id:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},{scope:this,success:this.getChannelInfoDone}):this.clearStatusBusy()},getChannelInfoDone:function(t,e,i){var o=this.formPanel.form.findField("channel_name");this.ChannelName=t.channel[0].title,o.setValue(Ext.util.Format.htmlEncode(t.channel[0].title)),SYNO.SDS.VideoStation2.OP.get().getDTVStatistic({},{scope:this,success:this.getStatistic})},getStatistic:function(t,e,i){var o=this.formPanel.getForm(),n=o.findField("watchnumber"),a=Ext.isDefined(this.currentTunerID)?this.currentTunerID:0;Ext.each(t.statistic,function(t,e,i){if(a===t.tuner_id)return void n.setValue(t.broadcasting_count)},this),this.setupStreamURL()},setupStreamURL:function(){var t=this.formPanel.getForm(),e=t.findField("url"),i=window.location.port,o=window.location.protocol,n=o+"//"+window.location.hostname;this.clearStatusBusy(),n+=Ext.isEmpty(i)?"":":"+i,n+="/VideoStation/livestreaming/"+(Ext.isDefined(this.currentTunerID)?this.currentTunerID:0),e.setValue(n),e.selectText(0,e.length)},onStopStreaming:function(){this.setStatusBusy({text:_T("common","loading")}),SYNO.SDS.VideoStation2.OP.get().stopDTVStreaming({tuner_id:Ext.isDefined(this.currentTunerID)?this.currentTunerID:0},{scope:this,success:this.onStopStreamingDone})},onStopStreamingDone:function(t,e,i){this.clearStatusBusy(),this.close()},onPlayStreaming:function(){SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayerWithDTV({tuner:this.currentTunerID})},getFormPanel:function(){return this.formPanel||(this.formPanel=new SYNO.SDS.VideoStation2.StreamingFormpanel({module:this})),this.formPanel}}),Ext.define("SYNO.SDS.VideoStation2.StreamingFormpanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){Ext.apply(this,t||{}),this.module=t.module,this.callParent([this.fillConfig(t)])},fillConfig:function(t){return Ext.apply({frame:!1,border:!1,labelWidth:160,trackResetOnLoad:!0,defaults:{anchor:"100%"},items:[this.tunerCombo=new SYNO.SDS.VideoStation2.ComboBox({fieldLabel:_VST("dongle","tuner2"),name:"tuner",triggerAction:"all",resizable:!1,store:this.createTunerStore(),editable:!1,displayField:"display",valueField:"value",value:"no_dongle",mode:"local",listeners:{scope:this,select:this.onChangeTuner}}),{xtype:"syno_vs_displayfield",itemId:"channel_name",name:"channel_name",htmlEncode:!1,fieldLabel:_VST("schedule","channel")},{xtype:"syno_vs_displayfield",itemId:"watchnumber",name:"watchnumber",fieldLabel:_VST("streaming","streaming_watch")},{xtype:"syno_vs_textfield",itemId:"url",name:"url",fieldLabel:_VST("streaming","streaming_url"),width:350,readOnly:!0,cls:"selectabletext allowDefCtxMenu"},{xtype:"syno_vs_displayfield",name:"description",value:String.format(_VST("streaming","streaming_description"),"9025~9040"),hidden:!_S("is_admin")}]},t)},createTunerStore:function(){this.defTunerValue=["no_dongle",_VST("error","no_dtv_dongle")];var t=new Ext.data.ArrayStore({autoDestroy:!0,id:0,fields:["value","display"],
data:[this.defTunerValue]});return this.addManagedComponent(t),t},onChangeTuner:function(t,e,i){this.module.setStatusBusy({text:_T("common","loading")}),this.module.currentTunerID=e.data.value;var o=this.module.basePort;Ext.isDefined(this.module.currentTunerID)&&(o=this.module.currentTunerID%16+o);var n=String.format(_VST("streaming","streaming_description"),o);this.getForm().findField("description").setValue(n),SYNO.SDS.VideoStation2.OP.get().getDTVChannel({tuner_id:Ext.isDefined(this.module.currentTunerID)?this.module.currentTunerID:0},{scope:this.module,success:this.module.getChannelDone})}}),Ext.define("SYNO.SDS.VideoStation2.DTVController",{statics:{signalMenu:null,getRecordingActions:function(){return[SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CREATE,SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CANCEL,SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CREATE_REPEAT,SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CREATE_USERDEFINE]},loadDTV:function(){SYNO.SDS.VideoStation2.DTV.get().loadDTV()},doRecordingAction:function(t,e,i,o,n){switch(t){case SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CREATE:return SYNO.SDS.VideoStation2.DTVController.createRecording(e,i,o,n);case SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CANCEL:return SYNO.SDS.VideoStation2.DTVController.cancelRecording(e,i,o,n);case SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CREATE_REPEAT:return SYNO.SDS.VideoStation2.DTVController.createRepeatRecording(e,i,o,n);case SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CREATE_USERDEFINE:return SYNO.SDS.VideoStation2.DTVController.createUserDefinedRecording(e,i,n);default:SYNO.Debug.error(String.format("unknown record action {0}",t))}},createRecording:function(t,e,i,o){SYNO.SDS.VideoStation2.OP.get().createRecording({tuner_id:t,schedule_id:[{channel_id:e.id,start_time:i.start_time}]},{success:o,failure:function(t,e,i){var o=SYNO.SDS.VideoStation2.Error.getAPIErrorString(t);SYNO.SDS.VideoStation2.Window.getMsgBox().alert(this.title,o,function(){if(SYNO.SDS.VideoStation2.Error.DTV_INDEX_FOLDER_NOT_FOUND===t.code){var e=new SYNO.SDS.VideoStation2.Setting.Dialog({initActiveTab:"dtv_settings"});SYNO.SDS.VideoStation2.SettingController.get().openDialog(e)}},this)}})},cancelRecording:function(t,e,i,o){SYNO.SDS.VideoStation2.OP.get().deleteSchedule({tuner_id:t,schedule_id:[{channel_id:e.id,start_time:i.start_time}]},{success:o})},createRepeatRecording:function(t,e,i,o){new SYNO.SDS.VideoStation2.CreateScheduleDialog({tuner:t,channel:e,program:i,onScheduleCreate:o}).open()},createUserDefinedRecording:function(t,e,i){new SYNO.SDS.VideoStation2.CreateScheduleDialog({tuner:t,channel:e,onScheduleCreate:i}).open()},showSignalMenu:function(t){var e=SYNO.SDS.VideoStation2.DTVController.getSignalMenu();e.setupTuner(SYNO.SDS.VideoStation2.DTV.get().getTuner()),e.showAt([t.getX()-89,t.getY()+30])},getSignalMenu:function(){return SYNO.SDS.VideoStation2.DTVController.signalMenu||(SYNO.SDS.VideoStation2.DTVController.signalMenu=new SYNO.SDS.VideoStation2.SignalMenu),SYNO.SDS.VideoStation2.DTVController.signalMenu},showStreamDialog:function(){(new SYNO.SDS.VideoStation2.StreamingDialog).show()}}}),Ext.define("SYNO.SDS.VideoStation2.FilterController",{singleton:!0,togggleFilter:function(t,e){SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()!==SYNO.SDS.VideoStation2.Category.CATEGORY_ALL&&SYNO.SDS.VideoStation2.VideoListController.toAllCategory(),SYNO.SDS.VideoStation2.Filter.get().toggleFilter(t,e)}}),Ext.define("SYNO.SDS.VideoStation2.HistoryController",{statics:{instance:null,EVENT_HISTORYCONTROLLER_INITED:"history_controller_inited",get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.HistoryController.instance)||(SYNO.SDS.VideoStation2.HistoryController.instance=new SYNO.SDS.VideoStation2.HistoryController),SYNO.SDS.VideoStation2.HistoryController.instance}},extend:"Ext.Component",constructor:function(){this.callParent(arguments),this.restore_order=[SYNO.SDS.VideoStation2.Constant.CATEGORY,SYNO.SDS.VideoStation2.Constant.LIBRARY,SYNO.SDS.VideoStation2.Constant.PLAYLIST,SYNO.SDS.VideoStation2.Constant.RECORDING_SPECIFIC,SYNO.SDS.VideoStation2.Constant.FOLDER,SYNO.SDS.VideoStation2.Constant.DTV,SYNO.SDS.VideoStation2.Constant.FILTER,SYNO.SDS.VideoStation2.Constant.TVSHOW,SYNO.SDS.VideoStation2.Constant.VIDEO],this.mon(SYNO.SDS.VideoStation2.Hash.get(),SYNO.SDS.VideoStation2.Hash.EVENT_HASH_CHANGED,this.onHashChanged,this),this.currentHash=location.hash.substr(location.hash.indexOf("!")+1),Ext.EventManager.addListener(window,"hashchange",this.onWindowHashChange,this)},init:function(){""===location.hash.substr(2)?this.toDefaultPage():this.onWindowHashChange(),this.fireEvent(SYNO.SDS.VideoStation2.HistoryController.EVENT_HISTORYCONTROLLER_INITED)},loadByURL:function(){if(this.currentHash){var t=SYNO.SDS.VideoStation2.Hash.get();if(!t.setOptionsByURL(this.currentHash))return void this.toDefaultPage();for(var e=0;e<this.restore_order.length;e++)if(SYNO.SDS.VideoStation2.Constant.LIBRARY!==this.restore_order[e]||t.getOptions().hasOwnProperty(SYNO.SDS.VideoStation2.Constant.LIBRARY))try{this.restoreSubject(this.restore_order[e])}catch(e){t.resetData(),this.toDefaultPage();break}else SYNO.SDS.VideoStation2.Controller.intoHomePage()}},toDefaultPage:function(){this.onHashChanged(!0),SYNO.SDS.VideoStation2.Controller.intoHomePage()},restoreSubject:function(t){var e=SYNO.SDS.VideoStation2.Hash.get().getOptions();if(e.hasOwnProperty(t))switch(t){case SYNO.SDS.VideoStation2.Constant.CATEGORY:SYNO.SDS.VideoStation2.Category.get().selectCategory(e[t]);break;case SYNO.SDS.VideoStation2.Constant.LIBRARY:SYNO.SDS.VideoStation2.Library.get().getLibraryByOPID(e[t]).type!==SYNO.SDS.VideoStation2.Constant.PLAYLIST&&e.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.PAGE)&&SYNO.SDS.VideoStation2.View.get().setPage(parseInt(e[SYNO.SDS.VideoStation2.Constant.PAGE],10),!0),SYNO.SDS.VideoStation2.Controller.switchLibrary(e[t]);break;case SYNO.SDS.VideoStation2.Constant.PLAYLIST:SYNO.SDS.VideoStation2.Library.get().getLibraryByOPID(e[SYNO.SDS.VideoStation2.Constant.LIBRARY]).type===SYNO.SDS.VideoStation2.Constant.PLAYLIST&&e.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.PAGE)&&SYNO.SDS.VideoStation2.View.get().setPage(e[SYNO.SDS.VideoStation2.Constant.PAGE],!0);var i=e[t];SYNO.SDS.VideoStation2.Controller.intoPosterView(t,i.id,i.title);break;case SYNO.SDS.VideoStation2.Constant.RECORDING_SPECIFIC:SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL===e[SYNO.SDS.VideoStation2.Constant.CATEGORY]?SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.CHANNEL,null,e[t]):SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM===e[SYNO.SDS.VideoStation2.Constant.CATEGORY]&&SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.PROGRAM,null,e[t]);break;case SYNO.SDS.VideoStation2.Constant.FOLDER:if(t===e[SYNO.SDS.VideoStation2.Constant.CATEGORY]){var o=SYNO.SDS.VideoStation2.Folder.get();o.resetData(),Ext.each(e[t],function(e,i,n){if(i===n.length-1)return SYNO.SDS.VideoStation2.Controller.intoPosterView(t,e.id,e.pathTitle),!1;o.selectFolder(e.id,e.pathTitle)})}break;case SYNO.SDS.VideoStation2.Constant.DTV:SYNO.SDS.VideoStation2.Controller.switchDTV(e[t]);break;case SYNO.SDS.VideoStation2.Constant.TVSHOW:if(e.hasOwnProperty(SYNO.SDS.VideoStation2.Constant.SEASON)){var n=e[t];n.hasOwnProperty("library_id")&&SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary("tvshow-"+n.library_id),SYNO.SDS.VideoStation2.TVShow.get().setDefaultSeason(e[SYNO.SDS.VideoStation2.Constant.SEASON]),SYNO.SDS.VideoStation2.Controller.intoTVShow({id:n.id})}break;case SYNO.SDS.VideoStation2.Constant.VIDEO:SYNO.SDS.VideoStation2.Controller.intoVideoDetail(e[t]);break;case SYNO.SDS.VideoStation2.Constant.FILTER:var a=null,S=function(t,e,i){SYNO.SDS.VideoStation2.FilterController.togggleFilter(a,{key:t,value:t})},s=e[t];for(var r in s)if(s.hasOwnProperty(r)){if(r===SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD){SYNO.SDS.VideoStation2.Controller.setFilter(r,s[r]);continue}a=r,Ext.each(s[r],S)}}},onHashChanged:function(t){var e=SYNO.SDS.VideoStation2.Hash.get().getPath();this.currentHash=e;var i=location.hash.substr(2),o=!1;if(""===location.hash)o=!0;else{if(i===e)return;o=t}window.history[o?"replaceState":"pushState"]({},"","#!"+e)},onWindowHashChange:function(){if(location.hash){if(!Ext.isEmpty(SYNO.SDS.WindowMgr.getActiveAppWindow().modalWin)||!Ext.isEmpty(SYNO.SDS.AppMgr.getByAppName("SYNO.VideoController2.Application")))return void this.onHashChanged();this.currentHash=location.hash.substr(2),SYNO.SDS.VideoStation2.Hash.get().disarm(),this.mun(SYNO.SDS.VideoStation2.Hash.get(),SYNO.SDS.VideoStation2.Hash.EVENT_HASH_CHANGED,this.onHashChanged,this),this.loadByURL(),this.mon(SYNO.SDS.VideoStation2.Hash.get(),SYNO.SDS.VideoStation2.Hash.EVENT_HASH_CHANGED,this.onHashChanged,this),SYNO.SDS.VideoStation2.Hash.get().arm()}}}),Ext.define("SYNO.SDS.VideoStation2.LNBDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",tuner:null,satellite:null,lnb:null,onLNBEdit:Ext.emptyFn,constructor:function(t){var e=t.lnb||this.lnb,i=t.satellite||this.satellite,o={layout:"fit",title:i,width:690,height:580,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:e?_T("common","alt_edit"):_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancel})],listeners:{scope:this,afterrender:this.onAfterRender},items:[this.panel=new SYNO.SDS.VideoStation2.LNBDialog.Panel({owner:this,lnb:e})]};this.callParent([Ext.apply(o,t)]),this.mon(this.panel,SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_REQUEST_DEFAULT_TRANSPONDER,this.onRequestDefaultTransponder,this)},maybeApplyLNB:function(){var t=this.panel.getValues();if(!t.lnb)return void this.maybeApplyTransponder();this.lnb?SYNO.SDS.VideoStation2.OP.get().editLNB(Ext.apply({tuner_id:this.tuner,satellite_name:this.satellite,original_lnb_name:this.lnb.name},t.lnb),{scope:this,success:this.onApplyLNB,failure:this.onRequestFail}):SYNO.SDS.VideoStation2.OP.get().createLNB(Ext.apply({tuner_id:this.tuner,satellite_name:this.satellite},t.lnb),{scope:this,success:this.onApplyLNB,failure:this.onRequestFail})},maybeApplyTransponder:function(){var t=this.panel.getValues();if(!t.transponder)return void this.onLNBEditSuccess();SYNO.SDS.VideoStation2.OP.get().editTransponder({tuner_id:this.tuner,satellite_name:this.satellite,lnb_name:this.lnb.name,tp:t.transponder},{scope:this,success:this.onLNBEditSuccess,failure:this.onRequestFail})},onOKBtn:function(){this.panel.isValid()&&this.panel.isDirty()&&(this.setStatusBusy(),this.maybeApplyLNB())},onCancel:function(){if(!this.lnb||!this.panel.isDirty())return void this.close();this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(t){"yes"===t&&this.close()},this)},onAfterRender:function(){this.setStatusBusy(),this.lnb?SYNO.SDS.VideoStation2.OP.get().getTransponder({tuner_id:this.tuner,satellite_name:this.satellite,lnb_name:this.lnb.name},{scope:this,success:this.onTransponderLoad,failure:this.onRequestFail}):SYNO.SDS.VideoStation2.OP.get().getDefaultTransponder({tuner_id:this.tuner,satellite_name:this.satellite,profile:"CUSTOMIZE"},{scope:this,success:this.onDefaultTransponderLoad,failure:this.onRequestFail})},onRequestDefaultTransponder:function(){this.setStatusBusy(),SYNO.SDS.VideoStation2.OP.get().getDefaultTransponder({tuner_id:this.tuner,satellite_name:this.satellite,profile:this.lnb.is_default?this.lnb.name:"CUSTOMIZE"},{scope:this,success:this.onDefaultTransponderLoad,failure:this.onRequestFail})},onTransponderLoad:function(t,e,i){this.clearStatusBusy(),this.panel.fireEvent(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_TRANSPONDER_LOAD,t.tp)},onDefaultTransponderLoad:function(t,e,i){this.clearStatusBusy(),this.panel.fireEvent(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_DEFAULT_TRANSPONDER_LOAD,t.tp)},onApplyLNB:function(t,e,i){this.lnb=this.lnb||{},this.lnb.name=e.lnb_name,this.maybeApplyTransponder()},onLNBEditSuccess:function(){this.clearStatusBusy(),Ext.isFunction(this.onLNBEdit)&&this.onLNBEdit(this.lnb.name),this.close()},onRequestFail:function(t,e,i){this.clearStatusBusy(),this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(t)})}}),Ext.define("SYNO.SDS.VideoStation2.LNBDialog.Panel",{extend:"SYNO.SDS.VideoStation2.TabPanel",constructor:function(t){var e={activeTab:0,items:[this.lnbPanel=new SYNO.SDS.VideoStation2.LNBDialog.LNBPanel({lnb:t.lnb,owner:t.owner,itemId:"lnb"}),this.transponderPanel=new SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel({owner:t.owner,itemId:"transponder"})]};this.callParent([Ext.apply(e,t)]),this.relayEvents(this.transponderPanel,[SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_REQUEST_DEFAULT_TRANSPONDER]),this.transponderPanel.relayEvents(this,[SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_TRANSPONDER_LOAD,SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_DEFAULT_TRANSPONDER_LOAD])},isValid:function(){var t,e=!0;return this.items.each(function(i){(t=i.isValid())||this.setActiveTab(i),e=t&&e},this),e},isDirty:function(){var t=!1;return this.items.each(function(e){return!(t=t||e.isDirty())},this),t},getValues:function(){var t={};return this.items.each(function(e){e.isDirty()&&(t[e.itemId]=e.getValues())},this),t}}),Ext.define("SYNO.SDS.VideoStation2.LNBDialog.LNBPanel",{statics:{PROFILE:[["C-BAND","C-BAND",5150,0,0],["C-MULTI","C-MULTI",5150,5750,0],["DBS","DBS","11250",0,0],["ENHANCED","ENHANCED",9750,0,0],["STANDARD","STANDARD",1e4,0,0],["UNIVERSAL","UNIVERSAL",9750,10600,11700],["CUSTOMIZE",_T("common","customize"),0,0,0]],DISEQC:[[0],[1],[2],[3]]},extend:"SYNO.SDS.VideoStation2.FormPanel",lnb:null,constructor:function(t){var e=t.lnb||this.lnb,i=this.getProfileStore(e),o=e?i.getById(e.profile):i.getAt(0),n={title:"LNB",defaults:{anchor:"100%"},updateFormForScrollbar:!0,items:[{xtype:"syno_vs_fieldset",itemId:"lnb",title:"LNB",items:[{xtype:"syno_vs_textfield",fieldLabel:_VST("dtvsscan","lnb_name"),name:"lnb_name",itemId:"lnb_name",allowBlank:!1,readOnly:!!e&&e.is_default,validator:SYNO.SDS.VideoStation2.DTVUtil.lengthAndEmptyValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.DVB_LNB_NAME],!0),value:e?e.name:""}]},{xtype:"syno_vs_fieldset",itemId:"general_settings",title:_VST("dtvsscan","general_setting"),items:[{xtype:"syno_vs_combobox",fieldLabel:_VST("dtvsscan","lnb_type"),name:"profile",itemId:"profile",displayField:"display",valueField:"profile",allowBlank:!1,readOnly:!!e&&e.is_default,value:o.id,store:i,listeners:{scope:this,select:this.onProfileSelect}},{xtype:"syno_vs_numberfield",fieldLabel:"Low Band (MHZ)",name:"low",itemId:"low",allowBlank:!1,allowDecimals:!1,allowNegative:!1,readOnly:!!e&&e.is_default,disabled:"CUSTOMIZE"!==o.id,value:o.get("low"),validator:SYNO.SDS.VideoStation2.DTVUtil.bandwidthValidator},{xtype:"syno_vs_numberfield",fieldLabel:"High Band (MHZ)",name:"high",itemId:"high",allowBlank:!1,allowDecimals:!1,allowNegative:!1,readOnly:!!e&&e.is_default,disabled:"CUSTOMIZE"!==o.id,value:o.get("high"),validator:SYNO.SDS.VideoStation2.DTVUtil.bandwidthValidator},{xtype:"syno_vs_numberfield",fieldLabel:String.format("{0} (MHZ)",_VST("dtvsscan","switch")),name:"switch",itemId:"switch",allowBlank:!1,allowDecimals:!1,allowNegative:!1,readOnly:!!e&&e.is_default,disabled:"CUSTOMIZE"!==o.id,value:o.get("switch"),validator:SYNO.SDS.VideoStation2.DTVUtil.bandwidthValidator}]},{xtype:"syno_vs_fieldset",itemId:"advance_setttings",title:_VST("dtvsscan","adv_setting"),items:[{xtype:"syno_vs_checkbox",boxLabel:_VST("dtvsscan","use_diseqc"),name:"enable_diseqc",itemId:"enable_diseqc",checked:!!e&&e.enable_diseqc},{xtype:"syno_vs_combobox",fieldLabel:"DiSEqC",name:"diseqc",itemId:"diseqc",displayField:"value",valueField:"value",allowBlank:!1,indent:1,disabled:!e||!e.enable_diseqc,value:e?e.diseqc:0,store:this.getDiSEqCStore()}]}]};this.callParent([Ext.apply(n,t)]),this.initEnableCheckGroup()},initEnableCheckGroup:function(){return[new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enable_diseqc",["diseqc"])]},getProfileStore:function(t){if(!this.profileStore&&(this.profileStore=new Ext.data.ArrayStore({autoDestroy:!0,idIndex:0,fields:["profile","display","low","high","switch"],data:SYNO.SDS.VideoStation2.LNBDialog.LNBPanel.PROFILE}),t&&"CUSTOMIZE"===t.profile)){var e=this.profileStore.getById("CUSTOMIZE");e.data.low=t.low,e.data.high=t.high,e.data.switch=t.switch}return this.profileStore},getDiSEqCStore:function(){return this.diseqcStore=this.diseqcStore||new Ext.data.ArrayStore({autoDestroy:!0,idIndex:0,fields:["value"],data:SYNO.SDS.VideoStation2.LNBDialog.LNBPanel.DISEQC}),this.diseqcStore},isValid:function(){return this.getForm().isValid()},isDirty:function(){return this.getForm().isDirty()},getValues:function(){return this.getForm().getFieldValues()},onProfileSelect:function(t){var e=this.getProfileStore(),i=e.getById(t.getValue());this.getForm().setValues(i.data),this.getForm().findField("low").setDisabled("CUSTOMIZE"!==i.id),this.getForm().findField("high").setDisabled("CUSTOMIZE"!==i.id),this.getForm().findField("switch").setDisabled("CUSTOMIZE"!==i.id)}}),Ext.define("SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel",{statics:{POLARISATION:[["H"],["V"]],EVENT_TRANSPONDER_LOAD:"transponderload",EVENT_DEFAULT_TRANSPONDER_LOAD:"defaulttransponderload",EVENT_REQUEST_DEFAULT_TRANSPONDER:"requestdefaulttransponder",convertTransponderID:function(t){return String.format("{0}-{1}-{2}",t.freq,t.sr,t.pol)}},extend:"SYNO.SDS.VideoStation2.EditorGridPanel",constructor:function(t){var e={title:_VST("dtvsscan","transponder"),enableHdMenu:!1,enableColumnMove:!1,tbar:new SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar,viewConfig:{trackResetOnLoad:!1},plugins:[this.getCheckedColumn()],store:this.getStore(),colModel:new Ext.grid.ColumnModel({columns:[this.getCheckedColumn(),{header:String.format("{0} (MHz)",_VST("video_info","frequency")),dataIndex:"freq",sortable:!0,editable:!0,editor:new SYNO.SDS.VideoStation2.NumberField({allowBlank:!1,allowDecimals:!1,allowNegative:!1,validator:SYNO.SDS.VideoStation2.DTVUtil.bandwidthValidator})},{header:String.format("{0} (Ksym/s)",_VST("dtvsscan","symbol_rate")),dataIndex:"sr",editable:!0,editor:new SYNO.SDS.VideoStation2.NumberField({allowBlank:!1,allowDecimals:!1,allowNegative:!1})},{header:_VST("dtvsscan","polarisation"),dataIndex:"pol",editable:!0,editor:new SYNO.SDS.VideoStation2.ComboBox({displayField:"value",valueField:"value",allowBlank:!1,store:this.getPolarisationStore()})}]}),selModel:new Ext.grid.RowSelectionModel({listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,validateedit:this.onValidateEdit,activate:this.onActivate}};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_TRANSPONDER_LOAD),this.addEvents(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_DEFAULT_TRANSPONDER_LOAD),this.addEvents(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_REQUEST_DEFAULT_TRANSPONDER),this.mon(this,SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_TRANSPONDER_LOAD,this.onTransponderLoad,this),this.mon(this,SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_DEFAULT_TRANSPONDER_LOAD,this.onDefaultTransponderLoad,this),this.mon(this.getTopToolbar(),SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_ACTION,this.onTransponderAction,this)},getCheckedColumn:function(){return this.checkedColumn=this.checkedColumn||new SYNO.SDS.VideoStation2.EnableColumn({dataIndex:"checked",width:50,align:"center",menuDisabled:!0,enableFastSelectAll:!0}),this.checkedColumn},getStore:function(){return this.store=this.store||new Ext.data.JsonStore({autoDestroy:!0,fields:["freq","sr","pol","checked",{name:"tpid",type:"string",convert:function(t,e){return SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.convertTransponderID(e)}}],sortInfo:{field:"freq",direction:"asc"}}),this.store},getPolarisationStore:function(){return this.polarisationStore=this.polarisationStore||new Ext.data.ArrayStore({autoDestroy:!0,idIndex:0,fields:["value"],data:SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.POLARISATION}),this.polarisationStore},askConfirmDelete:function(t){this.owner.getMsgBox().confirmDelete("",_VST("dtvsscan","delete_cfrmrm"),function(e){"yes"===e&&t.call(this)},this)},buildRecordFromData:function(t){return new(this.getStore().recordType)(Ext.apply(t,{tpid:SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.convertTransponderID(t)}))},addTransponder:function(){var t=this.getStore(),e={freq:0,sr:0,pol:"H",checked:!0},i=this.buildRecordFromData(e),o=t.findExact("tpid",i.get("tpid"));-1!==o?this.startEditing(o,1):(t.addSorted(i),i.markDirty(),this.getView().refresh(),this.startEditing(t.indexOf(i),1))},deleteTransponder:function(){this.getSelectionModel().getSelected()&&this.askConfirmDelete(this.doDeleteTransponder)},doDeleteTransponder:function(){var t=this.getSelectionModel().getSelected();t&&this.getStore().remove(t)},loadDefaultTransponder:function(){this.fireEvent(SYNO.SDS.VideoStation2.LNBDialog.TransponderPanel.EVENT_REQUEST_DEFAULT_TRANSPONDER)},isValid:function(){return!0},isDirty:function(){return!SYNO.ux.Utils.checkObjectConsistency(this.oriValue,this.getValues())},getValues:function(){var t=this.getStore();return t.sort("freq","ASC"),t.data.items.map(function(t){return{freq:t.data.freq,sr:t.data.sr,pol:t.data.pol,checked:t.data.checked}})},onActivate:function(){this.getView().refresh()},onTransponderLoad:function(t){this.getStore().loadData(t),this.oriValue=this.getValues()},onDefaultTransponderLoad:function(t){this.getStore().loadData(t)},onRowSelectionChange:function(t){this.getTopToolbar().fireEvent(SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_CHANGE,(t.getSelected()||{}).data)},onValidateEdit:function(t){var e=SYNO.Util.copy(t.record.data),i=this.getStore();e[t.field]=t.value;var o=this.buildRecordFromData(e);if(-1!==i.findExact("tpid",o.get("tpid")))return!1;t.record.set("tpid",o.get("tpid")),t.record.commit()},onTransponderAction:function(t){switch(t){case SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_ADD:return this.addTransponder();case SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_DELETE:return this.deleteTransponder();case SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_LOAD_DEFAULT:return this.loadDefaultTransponder()}}}),Ext.define("SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar",{statics:{EVENT_TRANSPONDER_ACTION:"transponderaction",EVENT_TRANSPONDER_CHANGE:"transponderchange",ACTION_ADD:"add",ACTION_DELETE:"delete",ACTION_LOAD_DEFAULT:"loaddefault"},extend:"SYNO.ux.Toolbar",constructor:function(t){var e={items:[this.addBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","add"),itemId:SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_ADD,scope:this,handler:this.onTransponderAction}),this.deleteBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","delete"),itemId:SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_DELETE,scope:this,handler:this.onTransponderAction,disabled:!0}),this.loadDefaultBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("dtvsscan","apply_default"),itemId:SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.ACTION_LOAD_DEFAULT,scope:this,handler:this.onTransponderAction})]};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_ACTION),this.addEvents(SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_CHANGE),this.mon(this,SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_CHANGE,this.onTransponderChange,this)},onTransponderAction:function(t){this.fireEvent(SYNO.SDS.VideoStation2.LNBDialog.TransponderToolbar.EVENT_TRANSPONDER_ACTION,t.itemId)},onTransponderChange:function(t){this.deleteBtn.setDisabled(!t)}}),Ext.define("SYNO.SDS.VideoStation2.SatelliteDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",onSatelliteEdit:Ext.emptyFn,tuner:null,satellite:null,constructor:function(t){var e=t.satellite||this.satellite,i={layout:"fit",title:e?_VST("dtvsscan","edit_satellite"):_VST("dtvsscan","add_satellite"),width:400,height:130,buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:e?_T("common","alt_edit"):_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancel})],items:[this.panel=new SYNO.SDS.VideoStation2.SatelliteDialog.Panel(t)]};this.callParent([Ext.apply(i,t)])},onOKBtn:function(){if(this.panel.isValid()){if(!this.panel.isDirty())return void this.close();this.setStatusBusy(),this.satellite?SYNO.SDS.VideoStation2.OP.get().editSatellite(Ext.apply({tuner_id:this.tuner,original_satellite_name:this.satellite},this.panel.getValues()),{scope:this,success:this.onRequestSuccess,failure:this.onRequestFail}):SYNO.SDS.VideoStation2.OP.get().createSatellite(Ext.apply({tuner_id:this.tuner},this.panel.getValues()),{scope:this,success:this.onRequestSuccess,failure:this.onRequestFail})}},onCancel:function(){if(!this.satellite||!this.panel.isDirty())return void this.close();this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(t){"yes"===t&&this.close()},this)},onRequestSuccess:function(t,e,i){this.clearStatusBusy(),Ext.isFunction(this.onSatelliteEdit)&&this.onSatelliteEdit(t.satellite_name),this.close()},onRequestFail:function(t,e,i){this.clearStatusBusy(),this.setStatusError({text:SYNO.SDS.VideoStation2.Error.getAPIErrorString(t)})}}),Ext.define("SYNO.SDS.VideoStation2.SatelliteDialog.Panel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e={defaults:{anchor:"100%"},updateFormForScrollbar:!0,items:[{xtype:"syno_vs_textfield",fieldLabel:_VST("dtvsscan","satellite_name"),name:"satellite_name",itemId:"satellite_name",allowBlank:!1,value:t.satellite||"",validator:SYNO.SDS.VideoStation2.DTVUtil.lengthAndEmptyValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.DVB_SATELLITE_NAME],!0)}]};this.callParent([Ext.apply(e,t)])},isValid:function(){return this.getForm().isValid()},isDirty:function(){return this.getForm().isDirty()},getValues:function(){return this.getForm().getValues()}}),Ext.define("SYNO.SDS.VideoStation2.ChannelScanDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",scan_done:null,tuner:null,onChannelScaned:Ext.emptyFn,constructor:function(t){var e=t.tuner||this.tuner;switch(e.type){case SYNO.SDS.VideoStation2.Constant.TUNER_TYPE.TYPE_QPSK:this.panel=new SYNO.SDS.VideoStation2.ChannelScanDialog.SatellitePanel({owner:this,tuner:e});break;case SYNO.SDS.VideoStation2.Constant.TUNER_TYPE.TYPE_QAM:case SYNO.SDS.VideoStation2.Constant.TUNER_TYPE.TYPE_OFDM:case SYNO.SDS.VideoStation2.Constant.TUNER_TYPE.TYPE_ATSC:this.panel=new SYNO.SDS.VideoStation2.ChannelScanDialog.DTVPanel({owner:this,tuner:e});break;case SYNO.SDS.VideoStation2.Constant.TUNER_TYPE.TYPE_HDHOMERUN:this.panel=new SYNO.SDS.VideoStation2.ChannelScanDialog.HDHomeRunPanel({owner:this,tuner:e});break;default:SYNO.Assert(!1,String.format("unknown tuner type {0}",e.type))}var i={layout:"fit",width:650,height:240,cls:"channel-scan-dialog",title:_VST("action","channelscan"),buttons:[this.scanBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","scan"),btnStyle:"blue",scope:this,handler:this.onScanBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancelBtn})],items:[this.panel],listeners:{scope:this,show:{fn:this.onDialogShow,single:!0}}};this.callParent([Ext.apply(i,t)]),this.mon(this.panel,SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING,this.onPanelLoading,this),this.mon(this.panel,SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED,this.onPanelLoaded,this),this.mon(this.panel,SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOAD_ERROR,this.onPanelLoadError,this)},startScan:function(){this.scan_done=!1,SYNO.SDS.VideoStation2.Util.maskLoadingMsg(this,_VST("action","scanning"),!0),this.clearPollingTask(!0),SYNO.SDS.VideoStation2.OP.get()[this.panel.getOperation(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_START)](Ext.apply({tuner_id:this.tuner.tuner_id},this.panel.getValues()),{scope:this,success:this.onStartScan,failure:this.onRequestFail})},clearPollingTask:function(t,e){this.pollingTask&&(t&&(e&&SYNO.SDS.VideoStation2.Util.maskLoadingMsg(this,_T("common","saving"),!0),SYNO.SDS.VideoStation2.OP.get()[this.panel.getOperation(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STOP)]({tuner_id:this.tuner.tuner_id},{scope:this,success:e?this.onRequestSuccess:Ext.emptyFn,failure:e?this.onRequestFail:Ext.emptyFn})),this.pollingTask.stop(),this.pollingTask.remove(),this.pollingTask=null)},onStartScan:function(){this.pollingTask=SYNO.SDS.VideoStation2.OP.pollingRequest(this.panel.getOperation(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STATUS),{tuner_id:this.tuner.tuner_id},{scope:this,success:this.onPollingScanStatus,failure:this.onPollingFail},5e3),this.getMsgBox().show({title:_VST("action","scanning"),progress:!0,closable:!0,hideDlg:!1,width:310,minWidth:250,buttons:Ext.MessageBox.CANCEL,fn:this.onCloseScanProgress,scope:this})},onPollingScanStatus:function(t,e,i){var o=this.panel.getProgressMsg(t),n=this.getMsgBox().updateProgress(t.progress/100,"",o);this.scan_done=t.is_done,t.is_done&&(n.fbButtons.cancel.setText(_T("common","close")),n.setTitle(_VST("dtv","title_scan_done")),this.clearPollingTask())},onCloseScanProgress:function(t){if(this.scan_done&&Ext.isFunction(this.onChannelScaned)&&this.onChannelScaned(),this.scan_done=null,this.pollingTask)return void this.clearPollingTask(!0,!0);this.close()},onDialogShow:function(){this.panel.loadConfig()},onScanBtn:function(){this.panel.isValid()&&(Ext.isEmpty(this.panel.getOriConfig())?this.startScan():this.getMsgBox().confirm(this.title,_VST("action","rescan_message"),function(t){"yes"===t&&this.startScan()},this))},onCancelBtn:function(){this.clearPollingTask(!0),this.close()},onPanelLoading:function(){this.setStatusBusy()},onPanelLoaded:function(){this.clearStatusBusy()},onPanelLoadError:function(t){this.setStatusError({text:t||_T("common","error_system")})},onRequestSuccess:function(){SYNO.SDS.VideoStation2.Util.unmask(this)},onRequestFail:function(t,e,i){SYNO.SDS.VideoStation2.Util.unmask(this),this.getMsgBox().alert(this.title,SYNO.SDS.VideoStation2.Error.getAPIErrorString(t))},onPollingFail:function(t,e,i){this.clearPollingTask(!0),this.getMsgBox().alert(this.title,SYNO.SDS.VideoStation2.Error.getAPIErrorString(t))}}),Ext.define("SYNO.SDS.VideoStation2.ChannelScanDialog.Panel",{statics:{EVENT_LOADING:"loading",EVENT_LOADED:"loaded",EVENT_LOAD_ERROR:"loaderror",EVENT_SAT_CHANGE:"satchange",EVENT_LNB_CHANGE:"lnbchange",OP_GETINFO:"getinfo",OP_START:"start",OP_STATUS:"status",OP_STOP:"stop"},extend:"SYNO.SDS.VideoStation2.FormPanel",tuner:null,constructor:function(t){var e={defaults:{anchor:"100%"},updateFormForScrollbar:!0};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING),this.addEvents(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED),this.addEvents(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOAD_ERROR),this.addEvents(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_SAT_CHANGE),this.addEvents(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LNB_CHANGE),this.on(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_SAT_CHANGE,this.onUpdateSatelliteBtn,this),this.on(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LNB_CHANGE,this.onUpdateLnbBtn,this)},isValid:function(){return this.getForm().isValid()},getValues:function(){return this.getForm().getValues()},getOriConfig:function(){return this.oriConfig},
getOperation:function(t){switch(t){case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_GETINFO:return"getChannelScanInfo";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_START:return"startChannelScan";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STATUS:return"getChannelScanStatus";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STOP:return"stopChannelScan";default:SYNO.Assert(!1,"unknown op")}},getProgressMsg:function(t){var e=t.channel_count,i=t.channel_name;return t.is_done?String.format("{0}<br />{1}",_VST("action","scanning_finish"),String.format(_VST("action","scan_finish_show"),e)):0!==e&&!i||"(null)"===i||"null"===i?String.format("{0}<br />{1}",_VST("action","unknown_channel"),String.format(_VST("action","scan_total_show"),e)):String.format("{0}<br />{1}",i,String.format(_VST("action","scan_total_show"),e))},getTunerTitleFieldConfig:function(t){var e=t.tuner||this.tuner;return[{xtype:"syno_vs_displayfield",fieldLabel:_VST("dongle","tuner2"),name:"tuner",itemId:"tuner",value:e.title}]},getCountryCombo:function(){return this.countryCombo=this.countryCombo||new SYNO.SDS.VideoStation2.ComboBox({fieldLabel:_VST("dtvtscan","country"),name:"country",itemId:"country",displayField:"value",valueField:"value",emptyText:_VST("action","select_country"),allowBlank:!1,store:this.getCountryStore(),listeners:{scope:this,select:this.onCountryComboSelect}}),this.countryCombo},getRegionCombo:function(){return this.regionCombo=this.regionCombo||new SYNO.SDS.VideoStation2.ComboBox({fieldLabel:_VST("dtvtscan","region"),name:"region",itemId:"region",displayField:"value",valueField:"value",emptyText:_VST("action","select_region"),allowBlank:!1,store:this.getRegionStore()}),this.regionCombo},getSatelliteField:function(){return this.satelliteField=this.satelliteField||new SYNO.ux.CompositeField({fieldLabel:_VST("dtvsscan","satellite"),itemId:"satellite",items:[this.getSatelliteCombo(),new SYNO.SDS.VideoStation2.Button({text:_T("common","add"),itemId:"add_sat_btn",scope:this,handler:this.onAddSatelliteBtn}),new SYNO.SDS.VideoStation2.Button({text:_T("common","alt_edit"),itemId:"edit_sat_btn",disabled:!0,scope:this,handler:this.onEditSatelliteBtn}),new SYNO.SDS.VideoStation2.Button({text:_T("common","delete"),itemId:"del_sat_btn",disabled:!0,scope:this,handler:this.onDeleteSatelliteBtn})]}),this.satelliteField},getSatelliteCombo:function(){return this.satelliteCombo=this.satelliteCombo||new SYNO.SDS.VideoStation2.ComboBox({name:"satellite_name",itemId:"satellite_name",displayField:"name",valueField:"name",emptyText:_VST("dtvsscan","pls_select_satellite"),allowBlank:!1,flex:1,store:this.getSatelliteStore(),listeners:{scope:this,select:this.onSatelliteComboSelect}}),this.satelliteCombo},getLNBField:function(){return this.lnbField=this.lnbField||new SYNO.ux.CompositeField({fieldLabel:"LNB",itemId:"lnb",items:[this.getLNBCombo(),new SYNO.SDS.VideoStation2.Button({text:_T("common","add"),itemId:"add_lnb_btn",disabled:!0,scope:this,handler:this.onAddLNBBtn}),new SYNO.SDS.VideoStation2.Button({text:_T("common","alt_edit"),itemId:"edit_lnb_btn",disabled:!0,scope:this,handler:this.onEditLNBBtn}),new SYNO.SDS.VideoStation2.Button({text:_T("common","delete"),itemId:"del_lnb_btn",disabled:!0,scope:this,handler:this.onDeleteLNBBtn})]}),this.lnbField},getLNBCombo:function(){return this.lnbCombo=this.lnbCombo||new SYNO.SDS.VideoStation2.ComboBox({name:"lnb_name",itemId:"lnb_name",displayField:"name",valueField:"name",emptyText:_VST("dtvsscan","pls_select_lnb"),allowBlank:!1,flex:1,store:this.getLNBStore(),listeners:{scope:this,select:this.onLNBComboSelect}}),this.lnbCombo},createOptionStore:function(){return new Ext.data.ArrayStore({autoDestroy:!0,idIndex:0,fields:["value"]})},getCountryStore:function(){return this.countryStore=this.countryStore||this.createOptionStore(),this.countryStore},getRegionStore:function(){return this.regionStore=this.regionStore||this.createOptionStore(),this.regionStore},getSatelliteStore:function(){return this.satelliteStore=this.satelliteStore||new Ext.data.JsonStore({autoDestroy:!0,id:"name",fields:["name","is_default"]}),this.satelliteStore},getLNBStore:function(){return this.lnbStore=this.lnbStore||new Ext.data.JsonStore({autoDestroy:!0,id:"name",fields:["name","is_default","diseqc","enable_diseqc","high","low","profile","switch","tp_count"]}),this.lnbStore},requestConfig:function(){SYNO.SDS.VideoStation2.OP.get()[this.getOperation(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_GETINFO)]({tuner_id:this.tuner.tuner_id},{scope:this,success:this.onConfigLoad,failure:this.onRequestFail})},requestCountry:function(){SYNO.SDS.VideoStation2.OP.get().getChannelScanCountry({tuner_id:this.tuner.tuner_id},{scope:this,success:this.onCountryLoad,failure:this.onRequestFail})},requestRegion:function(t){SYNO.SDS.VideoStation2.OP.get().getChannelScanRegion({tuner_id:this.tuner.tuner_id,country:t},{scope:this,success:this.onRegionLoad,failure:this.onRequestFail})},requestSatellite:function(){SYNO.SDS.VideoStation2.OP.get().getSatelliteScanSatellite({tuner_id:this.tuner.tuner_id},{scope:this,success:this.onSatelliteLoad,failure:this.onRequestFail})},requestLNB:function(t){SYNO.SDS.VideoStation2.OP.get().getSatelliteScanLNB({tuner_id:this.tuner.tuner_id,satellite_name:t},{scope:this,success:this.onLNBLoad,failure:this.onRequestFail})},loadConfig:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING),this.requestConfig()},onRequestFail:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED),this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOAD_ERROR)},onCountryComboSelect:function(t){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING),this.requestRegion(t.getValue())},onSatelliteComboSelect:function(t,e){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING),this.requestLNB(t.getValue()),this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_SAT_CHANGE,e)},onLNBComboSelect:function(t,e){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LNB_CHANGE,e)},onConfigLoad:function(t,e,i){this.oriConfig=t},onUpdateSatelliteBtn:function(t){var e=this.getComponent("satellite").innerCt;Ext.isEmpty(t)||t.get("is_default")?(e.getComponent("edit_sat_btn").disable(),e.getComponent("del_sat_btn").disable(),this.getComponent("lnb").innerCt.getComponent("add_lnb_btn")[Ext.isEmpty(t)?"disable":"enable"]()):(e.getComponent("edit_sat_btn").enable(),e.getComponent("del_sat_btn").enable(),this.getComponent("lnb").innerCt.getComponent("add_lnb_btn").enable())},onUpdateLnbBtn:function(t){var e=this.getComponent("lnb").innerCt;Ext.isEmpty(t)||t.get("is_default")?(e.getComponent("edit_lnb_btn").disable(),e.getComponent("del_lnb_btn").disable()):(e.getComponent("edit_lnb_btn").enable(),e.getComponent("del_lnb_btn").enable())},onCountryLoad:Ext.emptyFn,onRegionLoad:Ext.emptyFn,onSatelliteLoad:Ext.emptyFn,onLNBLoad:Ext.emptyFn,onAddSatelliteBtn:Ext.emptyFn,onEditSatelliteBtn:Ext.emptyFn,onDeleteSatelliteBtn:Ext.emptyFn,onAddLNBBtn:Ext.emptyFn,onEditLNBBtn:Ext.emptyFn,onDeleteLNBBtn:Ext.emptyFn}),Ext.define("SYNO.SDS.VideoStation2.ChannelScanDialog.DTVPanel",{extend:"SYNO.SDS.VideoStation2.ChannelScanDialog.Panel",constructor:function(t){var e={items:[this.getTunerTitleFieldConfig(t),this.getCountryCombo(),this.getRegionCombo()]};this.callParent([Ext.apply(e,t)])},onConfigLoad:function(t,e,i){this.callParent(arguments),!t||Ext.isEmpty(t.select_country)||Ext.isEmpty(t.select_region)||(this.getCountryStore().loadData([[t.select_country]]),this.getCountryCombo().setValue(t.select_country),this.getRegionStore().loadData([[t.select_region]]),this.getRegionCombo().setValue(t.select_region)),this.requestCountry()},onCountryLoad:function(t,e,i){var o=this.getCountryStore(),n=this.getCountryCombo(),a=n.getValue();return t&&t.country?(t.country.sort(),o.loadData(t.country.map(function(t){return[t]})),o.getById(a)||(n.clearValue(),a=null),Ext.isEmpty(a)?void this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED):void this.requestRegion(a)):(o.clearData(),n.clearValue(),void this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED))},onRegionLoad:function(t,e,i){var o=this.getRegionStore(),n=this.getRegionCombo(),a=n.getValue();if(this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED),!t||!t.region)return o.clearData(),void n.clearValue();o.loadData(t.region.map(function(t){return[t]})),o.getById(a)||(n.clearValue(),a=null),!a&&o.getCount()&&n.setValue(o.getAt(0).get(n.valueField))}}),Ext.define("SYNO.SDS.VideoStation2.ChannelScanDialog.HDHomeRunPanel",{extend:"SYNO.SDS.VideoStation2.ChannelScanDialog.DTVPanel",constructor:function(t){this.callParent(arguments)},getRegionCombo:function(){return this.regionCombo=this.regionCombo||new SYNO.SDS.VideoStation2.ComboBox({fieldLabel:_VST("dtvtscan","model"),name:"region",itemId:"region",displayField:"value",valueField:"value",emptyText:_VST("dtvtscan","pls_select_model"),allowBlank:!1,store:this.getRegionStore()}),this.regionCombo},getProgressMsg:function(t){var e=this.callParent(arguments);return 50<=t.progress&&100>t.progress&&(e=_VST("dtvtscan","scan_epging")),e}}),Ext.define("SYNO.SDS.VideoStation2.ChannelScanDialog.SatellitePanel",{extend:"SYNO.SDS.VideoStation2.ChannelScanDialog.Panel",constructor:function(t){var e={items:[this.getTunerTitleFieldConfig(t),this.getSatelliteField(),this.getLNBField()]};this.callParent([Ext.apply(e,t)])},askConfirmDelete:function(t){this.owner.getMsgBox().confirmDelete("",_VST("dtvsscan","delete_cfrmrm"),function(e){"yes"===e&&t.call(this)},this)},doDeleteSatellite:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING),SYNO.SDS.VideoStation2.OP.get().deleteSatellite({tuner_id:this.tuner.tuner_id,satellite_name:this.getSatelliteCombo().getValue()},{scope:this,success:this.onSatelliteDelete,failure:this.onRequestFail})},doDeleteLNB:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADING),SYNO.SDS.VideoStation2.OP.get().deleteLNB({tuner_id:this.tuner.tuner_id,satellite_name:this.getSatelliteCombo().getValue(),lnb_name:this.getLNBCombo().getValue()},{scope:this,success:this.onLNBDelete,failure:this.onRequestFail})},getOperation:function(t){switch(t){case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_GETINFO:return"getSatelliteScanInfo";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_START:return"startSatelliteScan";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STATUS:return"getSatelliteScanStatus";case SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.OP_STOP:return"stopSatelliteScan";default:SYNO.Assert(!1,"unknown op")}},onConfigLoad:function(t,e,i){this.callParent(arguments),!t||Ext.isEmpty(t.select_satellite)||Ext.isEmpty(t.select_lnb)||(this.getSatelliteStore().loadData([{name:t.select_satellite}]),this.getSatelliteCombo().setValue(t.select_satellite),this.getLNBStore().loadData([{name:t.select_lnb}]),this.getLNBCombo().setValue(t.select_lnb)),this.requestSatellite()},onSatelliteLoad:function(t,e,i){var o=this.getSatelliteStore(),n=this.getSatelliteCombo(),a=n.getValue();return t&&t.satellite?(o.loadData(t.satellite),o.getById(a)?this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_SAT_CHANGE,o.getById(a)):(this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_SAT_CHANGE,null),this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LNB_CHANGE,null),n.clearValue(),a=null),Ext.isEmpty(a)?void this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED):void this.requestLNB(a)):(o.clearData(),n.clearValue(),void this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED))},onLNBLoad:function(t,e,i){var o,n=this.getLNBStore(),a=this.getLNBCombo(),S=a.getValue();if(this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED),!t||!t.lnb)return n.clearData(),void a.clearValue();n.loadData(t.lnb),n.getById(S)||(a.clearValue(),S=null),!S&&n.getCount()?(o=n.getAt(0),a.setValue(o.get(a.valueField))):o=n.getAt(n.findExact("name",S)),this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LNB_CHANGE,o)},onAddSatelliteBtn:function(){new SYNO.SDS.VideoStation2.SatelliteDialog({tuner:this.tuner.tuner_id,onSatelliteEdit:this.onSatelliteEdit.createDelegate(this)}).open()},onEditSatelliteBtn:function(){new SYNO.SDS.VideoStation2.SatelliteDialog({tuner:this.tuner.tuner_id,satellite:this.getSatelliteCombo().getValue(),onSatelliteEdit:this.onSatelliteEdit.createDelegate(this)}).open()},onDeleteSatelliteBtn:function(){this.askConfirmDelete(this.doDeleteSatellite)},onAddLNBBtn:function(){new SYNO.SDS.VideoStation2.LNBDialog({tuner:this.tuner.tuner_id,satellite:this.getSatelliteCombo().getValue(),onLNBEdit:this.onLNBEdit.createDelegate(this)}).open()},onEditLNBBtn:function(){var t=this.getLNBCombo().getValue(),e=this.getLNBStore().getById(t);new SYNO.SDS.VideoStation2.LNBDialog({tuner:this.tuner.tuner_id,satellite:this.getSatelliteCombo().getValue(),lnb:e.data,onLNBEdit:this.onLNBEdit.createDelegate(this)}).open()},onDeleteLNBBtn:function(){this.askConfirmDelete(this.doDeleteLNB)},onSatelliteEdit:function(t){this.getSatelliteCombo().setValue(t),this.requestSatellite()},onSatelliteDelete:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED),this.getLNBStore().clearData(),this.getLNBCombo().clearValue(),this.requestSatellite()},onLNBEdit:function(t){this.getLNBCombo().setValue(t),this.requestLNB(this.getSatelliteCombo().getValue())},onLNBDelete:function(){this.fireEvent(SYNO.SDS.VideoStation2.ChannelScanDialog.Panel.EVENT_LOADED),this.requestLNB(this.getSatelliteCombo().getValue())}}),Ext.define("SYNO.SDS.VideoStation2.EditChannelDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",tuner:null,onChannelEdited:Ext.emptyFn,constructor:function(t){var e={layout:"fit",width:500,height:600,cls:"edit-channel-dialog",title:_VST("action","channeledit"),buttons:[this.okBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","ok"),btnStyle:"blue",scope:this,handler:this.onOKBtn}),this.cancelBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","cancel"),scope:this,handler:this.onCancelBtn})],items:[this.panel=new SYNO.SDS.VideoStation2.EditChannelDialog.Panel({owner:this,store:this.getStore()})],listeners:{scope:this,beforedestroy:this.onBeforeDestroy,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},getStore:function(){return this.store=this.store||new SYNO.SDS.VideoStation2.Stores.channel,this.store},getValues:function(){return this.getStore().data.items.map(function(t){return{id:t.get("id"),title:t.get("title"),is_scrambled:t.get("is_scrambled")}})},onBeforeDestroy:function(){this.getStore().destroy()},onAfterRender:function(){this.setStatusBusy(),SYNO.SDS.VideoStation2.OP.get().listChannel({offset:0,limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT,tuner_id:this.tuner},{scope:this,success:this.onListLoaded,failure:this.onRequestFail})},onListEdited:function(){Ext.isFunction(this.onChannelEdited)&&this.onChannelEdited(),this.close()},onListLoaded:function(t,e,i){this.clearStatusBusy(),this.getStore().loadData(t.channel),this.oriValues=this.getValues()},onRequestFail:function(){this.clearStatusBusy(),this.setStatusError()},onOKBtn:function(){var t=this.getValues();if(SYNO.ux.Utils.checkObjectConsistency(t,this.oriValues))return void this.onChannelEdited();this.setStatusBusy(),SYNO.SDS.VideoStation2.OP.get().editChannel({tuner_id:this.tuner,channel:t},{scope:this,success:this.onListEdited,failure:this.onRequestFail})},onCancelBtn:function(){var t=this.getValues();if(SYNO.ux.Utils.checkObjectConsistency(t,this.oriValues))return void this.close();this.getMsgBox().confirm(this.title,_T("common","confirm_lostchange"),function(t){"yes"===t&&this.close()},this)}}),Ext.define("SYNO.SDS.VideoStation2.EditChannelDialog.Panel",{extend:"SYNO.SDS.VideoStation2.EditorGridPanel",constructor:function(t){var e={enableHdMenu:!1,enableColumnMove:!1,enableDragDrop:!0,ddGroup:Ext.id(),tbar:new SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar,bbar:new SYNO.SDS.VideoStation2.EditChannelDialog.Bottombar,viewConfig:{trackResetOnLoad:!1},colModel:new Ext.grid.ColumnModel({columns:[{header:_VST("schedule","channel"),dataIndex:"title",editable:!0,renderer:function(t,e,i){var o=i.get("is_scrambled");return t=Ext.util.Format.htmlEncode(t),o?'<div class="syno-vs-channel-encrypted"></div>'+t:t},editor:new SYNO.SDS.VideoStation2.TextField({validator:SYNO.SDS.VideoStation2.Util.lengthValidator.createDelegate(this,[SYNO.SDS.VideoStation2.Constant.MAX_LENGTH.DVB_CHANNEL_NAME],!0),allowBlank:!1})}]}),selModel:new Ext.grid.RowSelectionModel({listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,afterrender:{fn:this.onAfterRender,single:!0},beforedestroy:this.onBeforeDestroy}};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.EditChannelDialog.Panel.EVENT_ACTION_DELETE),this.mon(this.getTopToolbar(),SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_ACTION_DELETE,this.onActionDelete,this)},doActionDelete:function(){this.getSelectionModel().getSelections().each(function(t){this.store.remove(t)},this)},onAfterRender:function(){this.dropTarget=new Ext.dd.DropTarget(this.getEl(),{ddGroup:this.ddGroup,notifyDrop:this.onDrop.createDelegate(this)})},onBeforeDestroy:function(){this.dropTarget&&this.dropTarget.destroy()},onRowSelectionChange:function(t){var e=t.getSelections();this.getTopToolbar().fireEvent(SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_SELECTION_CHANGE,e)},onActionDelete:function(){this.owner.getMsgBox().confirmDelete("",_VST("action","remove_confirm"),function(t){"yes"===t&&this.doActionDelete()},this)},onDrop:function(t,e,i){var o=this.getView(),n=o.findRowIndex(e.getTarget());if(Ext.isNumber(n)){var a=i.selections;a.each(function(t){this.store.indexOf(t)<=n&&--n,this.store.remove(t)},this),this.store.insert(n+1,a),this.getSelectionModel().selectRecords(a)}}}),Ext.define("SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar",{statics:{EVENT_SELECTION_CHANGE:"selectionchange",EVENT_ACTION_DELETE:"actiondelete"},extend:"SYNO.ux.Toolbar",constructor:function(t){var e={items:[this.deleteBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","delete"),scope:this,handler:this.onDeleteBtn,disabled:!0})]};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_SELECTION_CHANGE),this.addEvents(SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_ACTION_DELETE),this.mon(this,SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_SELECTION_CHANGE,this.onSelectionChange,this)},onDeleteBtn:function(){this.fireEvent(SYNO.SDS.VideoStation2.EditChannelDialog.Toolbar.EVENT_ACTION_DELETE)},onSelectionChange:function(t){this.deleteBtn.setDisabled(0===t.length)}}),Ext.define("SYNO.SDS.VideoStation2.EditChannelDialog.Bottombar",{extend:"SYNO.ux.Toolbar",constructor:function(t){var e={items:[{xtype:"tbtext",text:String.format('<span class="note">{0}:</span>{1}',_VST("common","hint"),_VST("action","drag_drop_channels"))}]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.EditScheduleDialog",{extend:"SYNO.SDS.VideoStation2.CreateScheduleDialog",onScheduleEdit:Ext.emptyFn,schedule:null,constructor:function(t){var e=t.schedule||this.schedule,i={channel:{id:e.channel_id,title:e.channel_name},listeners:{scope:this,show:this.onDialogShow}};e.is_userdefine||(i.program={title:e.title,description:e.description,start_time:e.start_time,duration:e.duration}),this.callParent([Ext.apply(i,t)])},onDialogShow:function(){this.setStatusBusy();var t={tuner_id:this.tuner};this.schedule.is_userdefine?t.start_time=this.schedule.start_time:t.schedule_id={start_time:this.schedule.start_time,channel_id:this.channel.id},SYNO.SDS.VideoStation2.OP.get()[this.schedule.is_userdefine?"getUserDefinedScheduleInfo":"getRepeatScheduleInfo"](t,{scope:this,success:this.onLoadSchedule,failure:this.onRequestFail})},onOKBtn:function(){if(this.panel.isValid()){this.setStatusBusy();var t=this.panel.getValues();this.schedule.is_userdefine&&Ext.apply(t,this.oriParams),SYNO.SDS.VideoStation2.OP.get()[this.schedule.is_userdefine?"editUserDefinedSchedule":"editRepeatSchedule"](t,{success:this.onEditRequest,failure:this.onRequestFail,scope:this})}},onEditRequest:function(){this.clearStatusBusy(),Ext.isFunction(this.onScheduleEdit)&&this.onScheduleEdit(),this.close()},onLoadSchedule:function(t,e,i){this.clearStatusBusy();var o=t.start_date.match(/^(\d{4}-\d{2}-\d{2}) (\d{2}:\d{2})$/),n={title:t.title,description:t.description,start_date:o[1]};this.schedule.is_userdefine&&(n.start_time=o[2],n.duration=SYNO.SDS.VideoStation2.DTVUtil.durationFormatter(60*t.duration).substr(0,5),n.is_repeating=t.is_repeating,this.oriParams={original_start_time:t.start_time}),this.schedule.is_userdefine&&!n.is_repeating||(n.is_weekly=SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WEEKLY_SCHEDULE===SYNO.SDS.VideoStation2.DTVUtil.getScheduleStatus(this.schedule.status),n.end_date=t.end_date,n.weekday_status=t.weekday_status),this.panel.setValues(n)}}),Ext.define("SYNO.SDS.VideoStation2.LiveStreamingDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",tuner:null,channel:null,onLiveStreaming:Ext.emptyFn,constructor:function(t){var e=Ext.isNumber(t.tuner)?t.tuner:this.tuner,i={layout:"fit",width:650,height:280,cls:"live-streaming-dialog",title:_VST("action","live_stream"),buttons:[this.playBtn=new SYNO.SDS.VideoStation2.Button({text:_VST("action","play"),btnStyle:"blue",hidden:!SYNO.SDS.VideoStation2.Capability.get().ableToPlayDTV(),scope:this,handler:this.onPlayBtn}),this.closeBtn=new SYNO.SDS.VideoStation2.Button({text:_T("common","close"),scope:this,handler:this.onCloseBtn})],items:[this.panel=new SYNO.SDS.VideoStation2.LiveStreamingDialog.Panel({tuner:e})],listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(i,t)])},onAfterRender:function(){this.setStatusBusy(),SYNO.SDS.VideoStation2.OP.get().liveStreaming({channel_id:this.channel,tuner_id:this.tuner},{scope:this,success:function(){this.clearStatusBusy(),SYNO.SDS.VideoStation2.View.get().fireEvent(SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH)},failure:this.onRequestFail})},onRequestFail:function(){this.clearStatusBusy(),this.setStatusError()},onPlayBtn:function(){SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayerWithDTV({tuner:this.tuner})},onCloseBtn:function(){Ext.isFunction(this.onLiveStreaming)&&this.onLiveStreaming(),this.close()}}),Ext.define("SYNO.SDS.VideoStation2.LiveStreamingDialog.Panel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e={defaults:{anchor:"100%"},updateFormForScrollbar:!0,items:[{xtype:"syno_vs_displayfield",hideLabel:!0,itemId:"desc_status",value:_VST("streaming","streaming_open_ok_2")},{xtype:"syno_vs_textfield",fieldLabel:_VST("streaming","streaming_url"),itemId:"url",value:SYNO.SDS.VideoStation2.DTVUtil.getStreamingURL(t.tuner),cls:"selectabletext",readOnly:!0,selectOnFocus:!0},{xtype:"syno_vs_displayfield",hideLabel:!0,itemId:"desc_tip",value:String.format(_VST("streaming","streaming_description"),SYNO.SDS.VideoStation2.DTVUtil.getTunerPort(t.tuner)),hidden:!_S("is_admin")}]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.ChannelPanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){var e={tbar:new SYNO.SDS.VideoStation2.ChannelPanel.Toolbar,cls:"channel-panel",layout:"border",width:200,items:[this.filter=new SYNO.SDS.VideoStation2.ChannelPanel.Filter({store:this.getStore(),margins:"0 12 12 12",itemId:"filter",region:"north"}),this.dataview=new SYNO.SDS.VideoStation2.ChannelPanel.DataView({store:this.getStore(),itemId:"list",region:"center"})],listeners:{scope:this,beforedestroy:this.onBeforeDestroy}};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},getStore:function(){return this.store=this.store||new SYNO.SDS.VideoStation2.Stores.channel,this.store},resetListRequest:function(){this.listRequest&&(SYNO.SDS.VideoStation2.OP.abort(this.listRequest),this.listRequest=null)},loadList:function(){this.resetListRequest(),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.listRequest=SYNO.SDS.VideoStation2.OP.get().listChannel({offset:0,limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT,tuner_id:SYNO.SDS.VideoStation2.DTV.get().getCurrentID()},{scope:this,success:this.onListLoaded,failure:this.onRequestFail})},onBeforeDestroy:function(){this.getStore().destroy(),this.resetListRequest()},onActivate:function(){this.callParent(arguments),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this),SYNO.SDS.VideoStation2.Filter.get().hasKeyword()||this.onViewRefresh()},onDeactivate:function(){this.callParent(arguments),this.resetListRequest(),this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this)},onListLoaded:function(t,e,i){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);var o=this.getStore();if(o.loadData(t.channel),this.expand(),SYNO.SDS.VideoStation2.Filter.get().hasKeyword())return void SYNO.SDS.VideoStation2.Channel.get().clearChannel();var n=SYNO.SDS.VideoStation2.Channel.get().getCurrentID();if(n&&!o.getById(n)&&(SYNO.SDS.VideoStation2.Channel.get().clearChannel(),n=null),!n&&o.getCount()){var a=o.getAt(0);SYNO.SDS.VideoStation2.Channel.get().selectChannel(a.id,a.get("title"))}},onRequestFail:function(t,e,i){this.collapse(),SYNO.SDS.VideoStation2.Error.DTV_CHANNEL_FILE_NOT_FOUND===t.code?this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_CHANNEL_SCAN):(this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),SYNO.SDS.VideoStation2.OP.defaultFailureCallback(t,e,i))},onViewRefresh:function(){switch(SYNO.SDS.VideoStation2.View.get().getView()){case SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE:this.collapse();break;case SYNO.SDS.VideoStation2.View.VIEW_DTV:this.loadList()}}}),Ext.define("SYNO.SDS.VideoStation2.ChannelPanel.Toolbar",{extend:"SYNO.ux.Toolbar",constructor:function(t){var e={cls:"channel-toolbar",items:[{xtype:"tbtext",text:_VST("schedule","channel")},"->",this.scanBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"scan",tooltip:_VST("action","channelscan"),scope:this,handler:this.onScanBtn}),{xtype:"tbspacer",width:12},this.editBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"edit",tooltip:_VST("action","channeledit"),scope:this,handler:this.onEditBtn})]};this.callParent([Ext.apply(e,t)])},onEditBtn:function(){new SYNO.SDS.VideoStation2.EditChannelDialog({tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentID(),onChannelEdited:SYNO.SDS.VideoStation2.Controller.refreshView}).open()},onScanBtn:function(){new SYNO.SDS.VideoStation2.ChannelScanDialog({tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentDTV(),onChannelScaned:SYNO.SDS.VideoStation2.Controller.refreshView}).open()}}),Ext.define("SYNO.SDS.VideoStation2.ChannelPanel.Filter",{extend:"SYNO.SDS.VideoStation2.TextFilter",constructor:function(t){var e={localFilter:!0,localFilterField:"title"};this.callParent([Ext.apply(e,t)]),this.mon(this,"render",function(t){t.container.addClass("channel-filter")})}}),Ext.define("SYNO.SDS.VideoStation2.ChannelPanel.DataView",{extend:"SYNO.ux.FleXcroll.DataView",constructor:function(t){var e={cls:"channel-list",tpl:this.getTpl(),itemSelector:"div.item-wrap",listeners:{scope:this,click:this.onChannelClick}};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE,this.onChannelChange,this),this.mon(this.store,"datachanged",this.onChannelChange,this),this.mon(this.store,"load",this.onChannelChange,this)},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div ext:qtip="{[this.doubleEncode(values.title)]}" class="item-wrap','<tpl if="this.isSelected(id)"> x-view-selected</tpl>','">','<tpl if="values.is_scrambled"><div class="x-view-scrambled"></div></tpl>','<tpl if="!values.is_scrambled && values.is_streaming"><div class="x-view-streaming"></div></tpl>',"{title:htmlEncode}","</div>","</tpl>",{isSelected:function(t){return t===SYNO.SDS.VideoStation2.Channel.get().getCurrentID()},doubleEncode:function(t){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(t))}})},onChannelClick:function(t,e,i,o){var n=this.store.getAt(e);SYNO.SDS.VideoStation2.Filter.get().clearAllFilter(),SYNO.SDS.VideoStation2.Channel.get().selectChannel(n.id,n.get("title"))},onChannelChange:function(){this.getNodes().each(function(t){Ext.fly(t).removeClass("x-view-selected")});var t=SYNO.SDS.VideoStation2.Channel.get().getCurrentID();if(t){var e=this.store.getById(t);if(e){var i=this.getNode(e);i&&Ext.fly(i).addClass("x-view-selected")}}}}),Ext.define("SYNO.SDS.VideoStation2.ViewCardPanel",{extend:"SYNO.ux.Panel",views:null,constructor:function(t){var e=t.views||this.views,i={activeItem:null,layout:"card",items:Object.values(e)};this.callParent([Ext.apply(i,t)]),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOTUNER),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_CHANNEL_SCAN),this.mon(this,"activate",this.onActivate,this),this.mon(this,"deactivate",this.onDeactivate,this),this.items.each(function(t){this.mon(t,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,function(e,i){t===this.layout.activeItem&&this.onViewLoading(e,i)},this),this.mon(t,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,function(){t===this.layout.activeItem&&this.onViewLoaded()},this),this.mon(t,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,function(e){t===this.layout.activeItem&&this.onViewNoVideo(e)},this),this.mon(t,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOTUNER,function(e){t===this.layout.activeItem&&this.onViewNoTuner(e)},this),this.mon(t,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_CHANNEL_SCAN,function(){t===this.layout.activeItem&&this.onViewChannelScan()},this)},this)},loadView:function(){var t=this.getItemByView();if(!t)return void this.clearActiveItem();var e=this.layout.activeItem;e!==t?this.layout.setActiveItem(t):e&&e.fireEvent("activate")},getItemByView:function(){var t=SYNO.SDS.VideoStation2.View.get().getView();return this.views[t]},clearActiveItem:function(){var t=this.layout.activeItem;if(t){if(t.hide(),!t.hidden)return!1;t.fireEvent("deactivate",t),this.layout.activeItem=null}},onActivate:function(){this.loadView()},onDeactivate:function(){var t=this.layout.activeItem;if(t){if(t.hide(),!t.hidden)return!1;t.fireEvent("deactivate",t),this.layout.activeItem=null}},onViewLoading:function(t,e){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,t,e)},onViewLoaded:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},onViewNoVideo:function(t){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,t)},onViewNoTuner:function(t){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOTUNER,t)},onViewChannelScan:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_CHANNEL_SCAN)}}),Ext.define("SYNO.SDS.VideoStation2.ViewDTV",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){var e={cls:"view-dtv",tbar:new SYNO.SDS.VideoStation2.ViewDTV.Toolbar,layout:"border",items:[this.dateSelector=new SYNO.SDS.VideoStation2.ViewDTV.DateSelector({store:this.getStore(),itemId:"date",region:"north"}),this.panel=new SYNO.SDS.VideoStation2.ViewDTV.Panel({store:this.getStore(),itemId:"program",region:"center"})],listeners:{beforedestroy:this.onBeforeDestroy}};this.callParent([Ext.apply(e,t)]),
this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.mon(this.panel,SYNO.SDS.VideoStation2.ViewDTV.Panel.EVENT_PROGRAM_CHANGE,this.onProgramChange,this),this.mon(this.getTopToolbar(),SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_RECORDING_ACTION,this.onRecordingAction,this),this.mon(this.getTopToolbar(),SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_UPDATE_PROGRAM_GUIDE,this.onUpdateProgramGuide,this)},getStore:function(){return this.store=this.store||new SYNO.SDS.VideoStation2.Stores.program,this.store},loadChannel:function(){var t=SYNO.SDS.VideoStation2.Channel.get().getCurrentID();return t||SYNO.SDS.VideoStation2.Filter.get().hasKeyword()?(this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.clearRequests(),t?void(this.programRequest=SYNO.SDS.VideoStation2.OP.get().listProgram({tuner_id:SYNO.SDS.VideoStation2.DTV.get().getCurrentID(),channel_id:t,date:SYNO.SDS.VideoStation2.Channel.get().getCurrentDate().format("Ymd"),offset:0,limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT},{scope:this,success:this.onListProgram,failure:this.onRequestFail})):void(this.programRequest=SYNO.SDS.VideoStation2.OP.get().searchProgram(Ext.apply({tuner_id:SYNO.SDS.VideoStation2.DTV.get().getCurrentID(),offset:0,limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT},SYNO.SDS.VideoStation2.Filter.get().getKeywordOption()),{scope:this,success:this.onSearchProgram,failure:this.onRequestFail}))):void this.getStore().loadData([])},onListProgram:function(t,e,i){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.programRequest=null,SYNO.SDS.VideoStation2.Channel.get().setRemainDays(t.remaining_day);var o=SYNO.SDS.VideoStation2.Channel.get().getCurrentID(),n=SYNO.SDS.VideoStation2.Channel.get().getCurrentTitle();t.program=t.program.map(function(t){return Ext.apply(t,{id:String.format("{0}-{1}",o,t.start_time),channel_id:o,channel_name:n})}),this.getStore().loadData(t.program)},onSearchProgram:function(t,e,i){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.programRequest=null,t.result=t.result.map(function(t){return Ext.apply(t,{id:String.format("{0}-{1}",t.channel_id,t.start_time),start_date_time:t.start})}),this.getStore().loadData(t.result)},onStartPollingTunerInfo:function(){this.updateProgramGuideRequest=null,this.pollingTask=SYNO.SDS.VideoStation2.OP.pollingRequest("getTunerInfo",{tuner_id:SYNO.SDS.VideoStation2.DTV.get().getCurrentID()},{scope:this,success:this.onPollingTunerInfo,failure:this.onRequestFail},5e3)},clearRequests:function(){this.programRequest&&(SYNO.SDS.VideoStation2.OP.abort(this.programRequest),this.programRequest=null),this.updateProgramGuideRequest&&(SYNO.SDS.VideoStation2.OP.abort(this.updateProgramGuideRequest),this.updateProgramGuideRequest=null),this.pollingTask&&(this.pollingTask.stop(),this.pollingTask.remove(),this.pollingTask=null)},onBeforeDestroy:function(){this.getStore().destroy()},onActivate:function(){this.callParent(arguments),this.mon(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE,this.loadChannel,this),this.mon(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_DATE_CHANGE,this.loadChannel,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.loadChannel,this),this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadChannel,this),this.loadChannel()},onDeactivate:function(){this.callParent(arguments),this.mun(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE,this.loadChannel,this),this.mun(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_DATE_CHANGE,this.loadChannel,this),this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.loadChannel,this),this.mun(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadChannel,this),this.clearRequests()},onProgramChange:function(t){this.getTopToolbar().fireEvent(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_PROGRAM_CHANGE,t)},onRecordingAction:function(t,e){var i={id:SYNO.SDS.VideoStation2.Channel.get().getCurrentID(),title:SYNO.SDS.VideoStation2.Channel.get().getCurrentTitle()};SYNO.SDS.VideoStation2.DTVController.doRecordingAction(t,SYNO.SDS.VideoStation2.DTV.get().getCurrentID(),i,e,SYNO.SDS.VideoStation2.Controller.refreshViewInfo)},onUpdateProgramGuide:function(){this.clearRequests(),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,this,_VST("programguide","updating_epg")),this.updateProgramGuideRequest=SYNO.SDS.VideoStation2.OP.get().updateProgramGuide({channel_id:SYNO.SDS.VideoStation2.Channel.get().getCurrentID(),tuner_id:SYNO.SDS.VideoStation2.DTV.get().getCurrentID()},{scope:this,success:this.onStartPollingTunerInfo,failure:this.onRequestFail})},onPollingTunerInfo:function(t,e,i){t&&t.tuner&&"ready"===t.tuner.status&&(this.clearRequests(),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),SYNO.SDS.VideoStation2.Controller.refreshViewInfo())},onRequestFail:function(t,e,i){this.clearRequests(),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);var o=SYNO.SDS.VideoStation2.Error.getAPIErrorString(t);SYNO.SDS.VideoStation2.Window.getMsgBox().alert("",o),this.getStore().removeAll()}}),Ext.define("SYNO.SDS.VideoStation2.ViewDTV.Toolbar",{statics:{EVENT_PROGRAM_CHANGE:"programchange",EVENT_RECORDING_ACTION:"recordingaction",EVENT_UPDATE_PROGRAM_GUIDE:"updateprogramguide"},extend:"SYNO.ux.Toolbar",constructor:function(t){var e=SYNO.SDS.VideoStation2.DTVController.getRecordingActions().map(function(t){return new Ext.Action({text:SYNO.SDS.VideoStation2.Util.getRecordingActionString(t),itemId:t,scope:this,handler:this.onRecordingAction})},this),i={cls:"dtv-navbar",items:[this.recordingBtn=new SYNO.SDS.VideoStation2.MenuActionButton({cls:"recording",tooltip:_VST("action","record"),disabled:!0,menu:new SYNO.SDS.VideoStation2.DropdownMenu({items:e,noicon:!0})}),{xtype:"tbspacer",width:12},this.streamingBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"watched",tooltip:_VST("programguide","broadcast_streaming"),scope:this,handler:this.onStreamingBtn,disabled:!0}),{xtype:"tbspacer",width:12},this.updateProgramGuideBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"refresh",tooltip:_VST("programguide","update_epg"),scope:this,handler:this.onUpdateProgramGuideBtn,disabled:!0})]};this.callParent([Ext.apply(i,t)]),this.addEvents(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_PROGRAM_CHANGE),this.addEvents(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_RECORDING_ACTION),this.addEvents(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_UPDATE_PROGRAM_GUIDE),this.mon(SYNO.SDS.VideoStation2.Channel.get(),SYNO.SDS.VideoStation2.Channel.EVENT_CHANNEL_CHANGE,this.changeChannelState,this),this.mon(this,SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_PROGRAM_CHANGE,this.changeProgramState,this)},changeChannelState:function(){var t=SYNO.SDS.VideoStation2.Channel.get().getCurrentID();this.recordingBtn.setDisabled(!t),this.streamingBtn.setDisabled(!t),this.updateProgramGuideBtn.setDisabled(!t)},changeProgramState:function(t){this.program=t,Ext.isObject(t)||(t={});var e=this.recordingBtn.menu,i=SYNO.SDS.VideoStation2.DTVUtil.getProgramStatus(t.status);e.items.each(function(t){switch(t.itemId){case SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CREATE:case SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CREATE_REPEAT:t.setDisabled(Ext.isEmpty(i)||i!==SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_NONE&&i!==SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_STREAMING);break;case SYNO.SDS.VideoStation2.Constant.RECORDING_ACTION_KEY.RECORDING_CANCEL:t.setDisabled(Ext.isEmpty(i)||i!==SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_SCHEDULED&&i!==SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_RECORDING)}})},onStreamingBtn:function(){new SYNO.SDS.VideoStation2.LiveStreamingDialog({tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentID(),channel:SYNO.SDS.VideoStation2.Channel.get().getCurrentID(),onLiveStreaming:SYNO.SDS.VideoStation2.Controller.refreshViewInfo}).open()},onUpdateProgramGuideBtn:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_UPDATE_PROGRAM_GUIDE)},onRecordingAction:function(t){this.fireEvent(SYNO.SDS.VideoStation2.ViewDTV.Toolbar.EVENT_RECORDING_ACTION,t.itemId,this.program)}}),Ext.define("SYNO.SDS.VideoStation2.ViewDTV.DateButton",{extend:"SYNO.SDS.VideoStation2.ActionButton",statics:{EVENT_TEXT_CHANGE:"textchange"},constructor:function(t){var e={cls:"dtv-date",menu:new SYNO.ux.DateMenu({hideOnClick:!1,focusOnSelect:!1}),menuAlign:"t-b?"};this.callParent([Ext.apply(e,t)]),this.menu.addClass("syno-vs2-datefield-menu syno-ux-datefield-menu"),this.mon(this.menu,"select",this.onMenuSelect,this),this.mon(this.menu,"show",this.onMenuShow,this),this.mon(this.menu,"hide",this.onMenuHide,this)},setText:function(t){var e=this.callParent(arguments);return this.fireEvent(SYNO.SDS.VideoStation2.ViewDTV.DateButton.EVENT_TEXT_CHANGE),e},setValue:function(t){if(!t)return void this.setText("");SYNO.SDS.VideoStation2.Channel.get().selectDate(t),this.menu.picker.setValue(t),this.setText(String.format("{0} ({1})",SYNO.SDS.DateTimeFormatter?SYNO.SDS.DateTimeFormatter(t,{type:"monthdate"}):t.format("m/d"),SYNO.SDS.VideoStation2.DTVUtil.getWeekdayString(t.getDay())))},setMinMaxDate:function(t,e){this.menu.picker.minDate=t,this.menu.picker.maxDate=e},onMenuSelect:function(t,e){this.setValue(e),this.menu.hide()},onMenuShow:function(){this.focus()},onMenuHide:function(){this.focus(!1,60)}}),Ext.define("SYNO.SDS.VideoStation2.ViewDTV.DateSelector",{extend:"SYNO.ux.Panel",constructor:function(t){var e=t.store,i={cls:"date-selector",layout:"hbox",height:36,layoutConfig:{align:"middle",pack:"center"},items:[this.prevBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"calendar_back",scope:this,handler:this.onPrevBtn}),new Ext.BoxComponent({width:80,height:36}),this.dateBtn=new SYNO.SDS.VideoStation2.ViewDTV.DateButton({}),new Ext.BoxComponent({width:80,height:36}),this.nextBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"calendar_next",scope:this,handler:this.onNextBtn})]};this.callParent([Ext.apply(i,t)]),this.mon(e,"load",this.onLoadStore,this),this.mon(this.dateBtn,SYNO.SDS.VideoStation2.ViewDTV.DateButton.EVENT_TEXT_CHANGE,this.doLayout,this)},onLoadStore:function(t){if(SYNO.SDS.VideoStation2.Filter.get().hasKeyword())return void this.items.each(function(t){t.hide()});this.items.each(function(t){t.show()});var e=SYNO.SDS.VideoStation2.Channel.get().getRemainDays();if(!Ext.isNumber(e))return this.dateBtn.setValue(null),void this.items.each(function(t){t.disable()});this.items.each(function(t){t.enable()});var i=SYNO.SDS.VideoStation2.Channel.get().getCurrentDate(),o=Date.parseDate(SYNO.SDS.VideoStation2.DTV.get().getDSMDate().format("Ymd"),"Ymd"),n=o.add(Date.DAY,e-1);this.dateBtn.setValue(i),this.dateBtn.setMinMaxDate(o,n),this.prevBtn.setDisabled(i.valueOf()===o.valueOf()),this.nextBtn.setDisabled(i.valueOf()===n.valueOf())},onPrevBtn:function(){var t=SYNO.SDS.VideoStation2.Channel.get().getCurrentDate().add(Date.DAY,-1);SYNO.SDS.VideoStation2.Channel.get().selectDate(t)},onNextBtn:function(){var t=SYNO.SDS.VideoStation2.Channel.get().getCurrentDate().add(Date.DAY,1);SYNO.SDS.VideoStation2.Channel.get().selectDate(t)}}),Ext.define("SYNO.SDS.VideoStation2.ViewDTV.Panel",{statics:{EVENT_PROGRAM_CHANGE:"programchange"},extend:"SYNO.SDS.VideoStation2.GridPanel",constructor:function(t){var e=function(t,e,i){switch(e.attr=String.format('ext:qtip="{0}"',Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(t))),SYNO.SDS.VideoStation2.DTVUtil.getProgramStatus(i.get("status"))){case SYNO.SDS.VideoStation2.Constant.PROGRAM_STATUS.STATUS_PASS:e.css+="pass "}return Ext.util.Format.htmlEncode(t)},i={cls:"dtv-grid",enableHdMenu:!1,enableColumnMove:!1,viewConfig:{trackResetOnLoad:!1},colModel:new Ext.grid.ColumnModel({columns:[{dataIndex:"status",id:"status",width:50,fixed:!0,resizable:!1,renderer:SYNO.SDS.VideoStation2.DTVUtil.programStatusIconRenderer},{header:_VST("schedule","channel"),dataIndex:"channel_name",id:"channel_name",renderer:e,hidden:!0},{header:_VST("schedule","schedule"),dataIndex:"schedule",id:"schedule",renderer:e},{header:_VST("programguide","title"),dataIndex:"title",id:"title",renderer:e},{header:_VST("programguide","description"),dataIndex:"description",id:"description",renderer:e},{header:_T("common","start"),dataIndex:"start_date_time",id:"start_date_time",renderer:function(t){var i=SYNO.SDS.VideoStation2.Util.parseLazyDate(t,"/"),o=new Date(i.year,i.month-1,i.day,i.hour,i.minute,i.second);return t=String.format("{0} ({1})",SYNO.SDS.DateTimeFormatter?SYNO.SDS.DateTimeFormatter(o,{type:"datetime"}):o.format("Y/m/d H:i"),SYNO.SDS.VideoStation2.DTVUtil.getWeekdayString(o.getDay())),e.apply(this,arguments)},hidden:!0},{header:_VST("schedule","duration"),dataIndex:"duration",id:"duration",renderer:function(t){return t=SYNO.SDS.VideoStation2.DTVUtil.durationFormatter(t),e.apply(this,arguments)},hidden:!0}]}),selModel:new Ext.grid.RowSelectionModel({singleSelect:!0,listeners:{scope:this,selectionchange:this.onRowSelectionChange}})};this.callParent([Ext.apply(i,t)]),this.mon(this.store,"load",this.onLoadStore,this),this.addEvents(SYNO.SDS.VideoStation2.ViewDTV.Panel.EVENT_PROGRAM_CHANGE)},onLoadStore:function(){var t=SYNO.SDS.VideoStation2.Filter.get().hasKeyword(),e=this.getColumnModel();e.setHidden(e.getIndexById("schedule"),t),e.setHidden(e.getIndexById("channel_name"),!t),e.setHidden(e.getIndexById("start_date_time"),!t),e.setHidden(e.getIndexById("duration"),!t),this.onRowSelectionChange(this.getSelectionModel())},onRowSelectionChange:function(t){this.fireEvent(SYNO.SDS.VideoStation2.ViewDTV.Panel.EVENT_PROGRAM_CHANGE,(t.getSelected()||{}).data)}}),Ext.define("SYNO.SDS.VideoStation2.ViewSchedule",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this._toolbar=new SYNO.SDS.VideoStation2.ViewSchedule.Toolbar;var e={cls:"view-schedule",layout:"fit",tbar:this._toolbar,items:[this.panel=new SYNO.SDS.VideoStation2.ViewSchedule.Panel({store:this.getStore()})],listeners:{scope:this,beforedestroy:this.onBeforeDestroy}};this.callParent([Ext.apply(e,t)]),this.mon(this.panel,SYNO.SDS.VideoStation2.ViewSchedule.Panel.EVENT_SCHEDULE_CHANGE,this.onScheduleChange,this),this.mon(this._toolbar,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_ACTION,this.onScheduleAction,this),this.mon(this._toolbar,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_LOADED,this.onTunerComboLoad,this),this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,this.onDTVReload,this),this.panel.relayEvents(this._toolbar,[SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_CHANGE])},getStore:function(){return this.store=this.store||new SYNO.SDS.VideoStation2.Stores.schedule({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onLoadStore}}),this.store},editSchedule:function(t){if(t){new SYNO.SDS.VideoStation2.EditScheduleDialog({tuner:this.getCurrentTuner(),schedule:t,onScheduleEdit:SYNO.SDS.VideoStation2.Controller.refreshView}).open()}},deleteSchedule:function(t){if(t&&Ext.isNumber(t.status)){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING);var e=SYNO.SDS.VideoStation2.DTVUtil.isScheduleStatusRepeatSchedule(t.status),i={tuner_id:this.getCurrentTuner()};t.is_userdefine?Ext.apply(i,{start_time:[t.start_time]}):Ext.apply(i,{schedule_id:[{channel_id:t.channel_id,start_time:t.start_time}]}),SYNO.SDS.VideoStation2.OP.get()[t.is_userdefine?"deleteUserDefinedSchedule":e?"deleteRepeatSchedule":"deleteSchedule"](i,{scope:this,success:this.onRequestSuccess,failure:this.onRequestFail})}},deletePassSchedule:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),SYNO.SDS.VideoStation2.OP.get().deletePassSchedule({tuner_id:this.getCurrentTuner()},{scope:this,success:this.onRequestSuccess,failure:this.onRequestFail})},getCurrentTuner:function(){return this._toolbar.getCurrentTuner()},onActivate:function(){this._toolbar.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.ACTION_LOAD_TUNER),this._toolbar.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.ACTION_ADJUST_COMBO)},onBeforeDestroy:function(){this.getStore().destroy()},onBeforeLoadStore:function(t,e){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),e.params.tuner_id=this.getCurrentTuner()},onLoadStore:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},onScheduleChange:function(t){this.getTopToolbar().fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_CHANGE,t)},onScheduleAction:function(t){var e=this.panel.getSelectedSchedule();switch(t){case SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_EDIT:return this.editSchedule(e);case SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_DELETE:return this.deleteSchedule(e);case SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_DELETE_PASS:return this.deletePassSchedule()}},onRequestSuccess:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),SYNO.SDS.VideoStation2.Controller.refreshView()},onRequestFail:function(t,e,i){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED);var o=SYNO.SDS.VideoStation2.Error.getAPIErrorString(t);SYNO.SDS.VideoStation2.Window.getMsgBox().alert("",o)},onTunerComboLoad:function(t){t.length<=0&&this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOTUNER,this)},onDTVReload:function(t,e){var i=SYNO.SDS.VideoStation2.View.get().getView(),o=this._toolbar,n=o.tunerCombo,a=n.getValue(),S=!1;i===SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE&&(n.store.removeAll(),Ext.iterate(e,function(t){t.get("tuner_id")===a&&(S=!0),n.store.add(t)}),S||(e.length<=0?(n.clearValue(),o._current_tuner=null,Ext.isEmpty(a)||(this.panel.store.removeAll(),o.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_LOADED,e))):(n.setValue(e[0].get("tuner_id")),this._toolbar.onTunerSelect(this._toolbar.tunerCombo,e[0]),o.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_LOADED,e))))}}),Ext.define("SYNO.SDS.VideoStation2.ViewSchedule.Toolbar",{extend:"SYNO.ux.Toolbar",statics:{ACTION_LOAD_TUNER:"loadtuner",ACTION_ADJUST_COMBO:"adjustcombo",SCHEDULE_EDIT:"scheduleedit",SCHEDULE_DELETE:"scheduledelete",SCHEDULE_DELETE_PASS:"scheduledeletepass",EVENT_SCHEDULE_ACTION:"scheduleaction",EVENT_TUNER_LOADED:"tunerload",EVENT_SCHEDULE_CHANGE:"schedulechange",EVENT_TUNER_CHANGE:"tunerchange",COMBOBOX_WRAP_WIDTH:300},constructor:function(t){var e={cls:"schedule-navbar",items:[this.cancelBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"stop_recording",itemId:SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_DELETE,tooltip:_VST("action","cancel_recording"),scope:this,handler:this.onScheduleAction,disabled:!0}),{xtype:"tbspacer",width:12},this.editBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"edit",itemId:SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_EDIT,tooltip:_VST("action","edit_repeat_schedule"),scope:this,handler:this.onScheduleAction,disabled:!0}),{xtype:"tbspacer",width:12},this.deletePassBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"refresh",itemId:SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.SCHEDULE_DELETE_PASS,tooltip:_VST("action","clear_pass_task"),scope:this,handler:this.onScheduleAction}),"->",new Ext.BoxComponent({cls:"dongle"}),{xtype:"tbspacer",width:8},this.tunerCombo=new SYNO.SDS.VideoStation2.ComboBox({width:SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.COMBOBOX_WRAP_WIDTH,store:new SYNO.SDS.VideoStation2.DTVStore({appWindow:SYNO.SDS.VideoStation2.Window,autoDestroy:!0,listeners:{scope:this,load:function(t,e,i){this.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_LOADED,e)}}}),valueField:"tuner_id",displayField:"title",listeners:{select:this.onTunerSelect,scope:this}})]};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_ACTION),this.addEvents(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_CHANGE),this.addEvents(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_LOADED),this.mon(this,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_CHANGE,this.changeActionState,this),this.mon(this,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.ACTION_LOAD_TUNER,this.loadTuner,this),this.mon(this,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.ACTION_ADJUST_COMBO,this.adjustCombo,this)},changeActionState:function(t){var e=SYNO.SDS.VideoStation2.DTVUtil.getScheduleStatus((t||{}).status);this.cancelBtn.setDisabled(!t),this.editBtn.setDisabled(e!==SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WEEKLY_SCHEDULE&&e!==SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_DAILY_SCHEDULE&&(e!==SYNO.SDS.VideoStation2.Constant.SCHEDULE_STATUS.STATUS_WAIT||!(t||{}).is_userdefine))},onScheduleAction:function(t){this.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_SCHEDULE_ACTION,t.itemId)},onTunerSelect:function(t,e){var i=e.get("tuner_id");i!==this._current_tuner&&(this._current_tuner=i,this.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_CHANGE))},loadTuner:function(){this.tunerCombo.getStore().load({callback:function(t){Ext.isEmpty(t)||(this._current_tuner=t[0].get("tuner_id"),this.tunerCombo.setValue(this._current_tuner),this.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_CHANGE))},scope:this})},adjustCombo:function(){this.tunerCombo.wrap.setWidth(SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.COMBOBOX_WRAP_WIDTH)},getCurrentTuner:function(){return this._current_tuner}}),Ext.define("SYNO.SDS.VideoStation2.ViewSchedule.Panel",{statics:{EVENT_SCHEDULE_CHANGE:"schedulechange"},extend:"SYNO.SDS.VideoStation2.GridPanel",pageSize:30,constructor:function(t){var e={enableHdMenu:!1,enableColumnMove:!1,cls:"schedule-grid",viewConfig:{trackResetOnLoad:!1},bbar:this._paging=new SYNO.SDS.VideoStation2.PagingToolbar({pageSize:this.pageSize,store:t.store,displayInfo:!0,showRefreshBtn:!0}),colModel:new Ext.grid.ColumnModel({columns:[{dataIndex:"status",width:50,fixed:!0,resizable:!1,renderer:SYNO.SDS.VideoStation2.DTVUtil.scheduleStatusIconRenderer},{header:_VST("schedule","channel"),dataIndex:"channel_name"},{header:_VST("programguide","title"),dataIndex:"title"},{header:_VST("programguide","description"),dataIndex:"description"},{header:_VST("video_info","record_time"),dataIndex:"start_date",renderer:function(t){if(SYNO.SDS.DateTimeFormatter){var e=SYNO.SDS.VideoStation2.Util.parseLazyDate(t,"/"),i=new Date(e.year,e.month-1,e.day,e.hour,e.minute,e.second);return SYNO.SDS.DateTimeFormatter(i,{type:"datetime"})}return t}},{header:_VST("schedule","duration"),dataIndex:"duration",renderer:function(t){return SYNO.SDS.VideoStation2.DTVUtil.durationFormatter(60*t)}},{header:_VST("common","status"),dataIndex:"status",renderer:SYNO.SDS.VideoStation2.DTVUtil.getScheduleStatusString}]}),selModel:new Ext.grid.RowSelectionModel({singleSelect:!0,listeners:{scope:this,selectionchange:this.onRowSelectionChange}}),listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.ViewSchedule.Panel.EVENT_SCHEDULE_CHANGE),this.mon(this,SYNO.SDS.VideoStation2.ViewSchedule.Toolbar.EVENT_TUNER_CHANGE,this.onTunerChanged,this)},getSelectedSchedule:function(){return(this.getSelectionModel().getSelected()||{}).data},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this),this._paging.bindStore(this.store)},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.onViewRefresh,this),this._paging.bindStore(null)},onViewRefresh:function(){this._paging.doRefresh()},onRowSelectionChange:function(t){this.fireEvent(SYNO.SDS.VideoStation2.ViewSchedule.Panel.EVENT_SCHEDULE_CHANGE,(t.getSelected()||{}).data)},onTunerChanged:function(){this._paging.moveFirst()}}),Ext.define("SYNO.SDS.VideoStation2.DTVNavigationPanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){var e={layout:"border",cls:"dtv-navigation",items:[this.channelPanel=new SYNO.SDS.VideoStation2.ChannelPanel({region:"west",collapsed:!0}),this.cardPanel=new SYNO.SDS.VideoStation2.DTVNavigationCardPanel({region:"center"})]};this.callParent([Ext.apply(e,t)]),this.items.each(function(t){this.relayEvents(t,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOTUNER,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_CHANNEL_SCAN])},this)},getItemByView:function(){return this.cardPanel.getItemByView()}}),Ext.define("SYNO.SDS.VideoStation2.DTVNavigationCardPanel",{extend:"SYNO.SDS.VideoStation2.ViewCardPanel",constructor:function(t){var e={};e[SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE]=new SYNO.SDS.VideoStation2.ViewSchedule({itemId:"schedule"}),e[SYNO.SDS.VideoStation2.View.VIEW_DTV]=new SYNO.SDS.VideoStation2.ViewDTV({itemId:"dtv"});var i={views:e};this.callParent([Ext.apply(i,t)])}}),Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryVisibilityDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(t){this.callback=t.callback||{};var e={title:_VST("library","edit"),width:400,height:580,minWidth:300,minHeight:280,resizable:!0,layout:"fit",items:[this.getGridPanel(t)],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",text:_T("common","cancel"),scope:this,handler:this.onCancel}],listeners:{afterrender:{fn:function(){this.getGridPanel().fireEvent(SYNO.SDS.VideoStation2.Setting.LibraryVisibilityGrid.EVENT_LOAD_LIBRARY)},scope:this}}};this.callParent([Ext.apply(e,t)])},getGridPanel:function(t){return this._grid=this._grid||new SYNO.SDS.VideoStation2.Setting.LibraryVisibilityGrid({}),this._grid},getVisibilityChange:function(){var t=[];return Ext.iterate(this.getGridPanel().getChanges()||{},function(e,i,o){t.push({id:parseInt(e.split("-")[1],10),type:e.split("-")[0],visible:i})}),t},onApply:function(){var t=this.getVisibilityChange();if(Ext.isEmpty(t))return void this.close();SYNO.SDS.VideoStation2.OP.get().setLibraryVisibility({visibility:t},{scope:this,success:function(){this.close(),SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()}})},onCancel:function(){if(Ext.isEmpty(this.getVisibilityChange()))return void this.close();SYNO.SDS.VideoStation2.SettingController.get().confirmAction(_VST("library","edit"),_T("common","confirm_lostchange"),this.close,this)}}),Ext.define("SYNO.SDS.VideoStation2.Setting.LibraryVisibilityGrid",{extend:"SYNO.SDS.VideoStation2.EnableGrid",statics:{EVENT_LOAD_LIBRARY:"loadlibrary"},constructor:function(t){this._changes={};var e={autoExpandColumn:"title",plugins:[this.getVisibilityColumn()]};this.callParent([Ext.apply(e,t)]),this.mon(this.getStore(),"load",this.applyLocalChanges,this),this.mon(this,SYNO.SDS.VideoStation2.Setting.LibraryVisibilityGrid.EVENT_LOAD_LIBRARY,this.loadLibrary,this)},confirm:function(t,e,i,o){SYNO.SDS.VideoStation2.SettingController.get().confirm(t,e,i,o)},getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.LibraryStore({appWindow:SYNO.SDS.VideoStation2.Window}),this._store},getColumns:function(){return this._cm=this._cm||new Ext.grid.ColumnModel({defaults:{align:"center",sortable:!1},columns:[{align:"left",header:_VST("library","title"),dataIndex:"title",id:"title"},this.getVisibilityColumn()]}),this._cm},saveChanges:function(t){this._changes=this.getChanges(),SYNO.SDS.VideoStation2.Util.applyCallback(t)},getVisibilityColumn:function(){return this._visibility_column=this._visibility_column||new SYNO.SDS.VideoStation2.EnableColumn({header:_VST("library","visible"),dataIndex:"visible",width:150,id:"visible"}),this._visibility_column},getStoreChanges:function(){var t={};return Ext.each(this.getStore().getModifiedRecords(),function(e){t[e.get("opid")]=e.get("visible")}),t},getChanges:function(){return Ext.apply(this._changes||{},this.getStoreChanges())},applyLocalChanges:function(t,e,i){Ext.isObject(this._changes)&&(t.each(function(t){var e=t.get("opid");Ext.isDefined(this._changes[e])&&t.set("visible",this._changes[e])},this),t.commitChanges())},loadLibrary:function(){this.getPagingToolbar().moveFirst()}}),Ext.define("SYNO.SDS.VideoStation2.MainList",{extend:"SYNO.ux.Panel",statics:{LIBRARY_PANEL_MIN_HEIGHT:150},constructor:function(t){var e={cls:"main-list",width:200,layout:"vbox",layoutConfig:{align:"stretch",pack:"start"},items:[this._library=new SYNO.SDS.VideoStation2.LibraryPanel({}),this._dtv=new SYNO.SDS.VideoStation2.DTVPanel({})],listeners:{resize:this.adjustLayout,scope:this}};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DISABLE_DTV,this.showHideDTVPanel,this),this.mon(this._library,SYNO.SDS.VideoStation2.MainList.Event.LIBRARY_PANEL_RESIZE,this.adjustLayout,this),this.mon(this._dtv,SYNO.SDS.VideoStation2.MainList.Event.DTV_PANEL_RESIZE,this.adjustLayout,this)},adjustLayout:function(){var t=this.getEl().select(".library-panel .contentwrapper").elements[0],e=this.getEl().select(".dtv-panel .contentwrapper").elements[0];if(Ext.isDefined(t)){var i=this.getHeight(),o=t.getHeight(),n=e?e.getHeight():0;if(Ext.isDefined(e)&&this._dtv.isVisible())if(i>=o+n)this._library.setHeight(o),this._dtv.setHeight(n);else{var a=Ext.max([i-n,SYNO.SDS.VideoStation2.MainList.LIBRARY_PANEL_MIN_HEIGHT]),S=i-a;this._library.setHeight(a),this._dtv.setHeight(S)}else this._library.setHeight(i);this.doLayout()}},showHideDTVPanel:function(t){this._dtv[t?"hide":"show"](),this.adjustLayout()}}),Ext.define("SYNO.SDS.VideoStation2.LibraryPanel",{extend:"SYNO.ux.Panel",constructor:function(t){var e={cls:"library-panel",layout:"fit",items:[this.getDataview()]};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.onLibraryLoad,this),this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChanged,this)},getDataview:function(){return Ext.isObject(this.dataview)||(this.dataview=new SYNO.SDS.VideoStation2.ListDataView({type:"library",store:SYNO.SDS.VideoStation2.Library.get().getLibraryStore(),listeners:{selectionchange:{buffer:100,scope:this,fn:this.onLibrarySelected}}})),this.dataview},selectToCurrentLibrary:function(){var t=this.dataview.getStore(),e=t.findExact("opid",SYNO.SDS.VideoStation2.Library.get().cursor);-1!==e&&this.dataview.select(t.getAt(e),!1,!0)},onLibraryLoad:function(){this.fireEvent(SYNO.SDS.VideoStation2.MainList.Event.LIBRARY_PANEL_RESIZE),this.selectToCurrentLibrary()},onLibraryChanged:function(){SYNO.SDS.VideoStation2.Library.get().isDeactivated()?this.dataview.clearSelections():this.selectToCurrentLibrary()},onLibrarySelected:function(t,e){if(0!==e.length){var i=this.getDataview().getRecord(e[0]);SYNO.SDS.VideoStation2.Controller.switchLibrary(i.get("opid"))}}}),Ext.define("SYNO.SDS.VideoStation2.DTVPanel",{extend:"SYNO.ux.Panel",blNeedRefresh:!0,constructor:function(t){var e={cls:"dtv-panel",layout:"fit",items:[this.getDataview()]};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,this.onDTVLoad,this),this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_CHANGED,this.onDTVChanged,this)},getDataview:function(){return Ext.isObject(this.dataview)||(this.dataview=new SYNO.SDS.VideoStation2.ListDataView({prepend_separator:!0,type:"dtv",store:SYNO.SDS.VideoStation2.DTV.get().getDTVStore(),listeners:{selectionchange:{buffer:100,scope:this,fn:this.onDTVSelected}}})),this.dataview},
selectToCurrentDTV:function(t){var e=this.dataview.getStore(),i=e.getById(SYNO.SDS.VideoStation2.DTV.get().getCurrentID());i||(i=e.getAt(0)),this.blNeedRefresh=t,this.dataview.select(i,!0,!0)},onDTVLoad:function(t,e){this.fireEvent(SYNO.SDS.VideoStation2.MainList.Event.DTV_PANEL_RESIZE);var i=SYNO.SDS.VideoStation2.View.get().getView(),o=this.body.select(".signal-icon"),n=this.body.select(".streaming-icon"),a=0,S=0;Ext.each(e,function(t){var e=t.get("signal"),i=t.get("additional").channel_status;Ext.isNumber(e)&&e>0&&a++,Ext.isEmpty(i.streaming_id)||S++},this),a>0&&o.removeClass("hide"),S>0&&n.removeClass("hide"),i!==SYNO.SDS.VideoStation2.View.VIEW_DTV&&i!==SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE||this.selectToCurrentDTV(t)},onDTVChanged:function(){Ext.isNumber(SYNO.SDS.VideoStation2.DTV.get().getCurrentID())?this.selectToCurrentDTV(!0):this.dataview.clearSelections()},onDTVSelected:function(t,e){if(0===e.length||!this.blNeedRefresh)return void(this.blNeedRefresh=!0);var i=this.getDataview().getRecord(e[0]);SYNO.SDS.VideoStation2.Controller.switchDTV(i.get("tuner_id"))}}),Ext.define("SYNO.SDS.VideoStation2.ListDataView",{extend:"SYNO.ux.FleXcroll.DataView",type:"",prepend_separator:!1,onContainerClick:Ext.emptyFn,constructor:function(t){this.prepend_separator=(t||{}).prepend_separator||!1,this.type=(t||{}).type||"library";var e={itemSelector:"dl.list-template",trackOver:!1,selectedClass:"selected",overClass:"over",hideHeaders:!0,singleSelect:!0,cls:"dataview",tpl:this.getListTpl()};this.callParent([Ext.apply(e,t)])},onClick:function(t,e,i){var o=Ext.fly(e);if(o.hasClass("add")){var n=t.getTarget(this.itemSelector,this.getTemplateTarget()),a=this.getRecord(n);this.addFolderToLibrary(a)}else o.hasClass("add-library")?this.addLibrary():o.hasClass("edit-visibility")?this.editLibraryVisibility():o.hasClass("signal-icon")?SYNO.SDS.VideoStation2.DTVController.showSignalMenu(o):o.hasClass("streaming-icon")?SYNO.SDS.VideoStation2.DTVController.showStreamDialog():this.callParent(arguments)},onKeyUp:function(t){t.shiftKey=!1,this.callParent(arguments)},onKeyDown:function(t){t.shiftKey=!1,this.callParent(arguments)},onKeyRight:function(t){t.shiftKey=!1,this.callParent(arguments)},onKeyLeft:function(t){t.shiftKey=!1,this.callParent(arguments)},addFolderToLibrary:function(t){SYNO.SDS.VideoStation2.SettingController.get().launchFolderDialog(!0,t.data)},addLibrary:function(){var t=SYNO.SDS.VideoStation2.SettingController.get(),e=new SYNO.SDS.VideoStation2.LibraryDialog({owner:t.getActiveWindow(),mode:SYNO.SDS.VideoStation2.AddEditDialog.MODE_ADD,callback:{fn:function(){SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()}}});t.openDialog(e)},editLibraryVisibility:function(){var t=SYNO.SDS.VideoStation2.SettingController.get(),e=new SYNO.SDS.VideoStation2.Setting.LibraryVisibilityDialog({owner:t.getActiveWindow()});t.openDialog(e)},getListTpl:function(){var t="library"===this.type,e=['<dl class="title">',t?'{[this.getAddLibraryIcon(values)]}<div class="edit-visibility"></div>':"{[this.getDTVIcon()]}",'<dt><div>{[_VST("',this.type,'", "title")]}</div></dt>',"</dl>"].join(""),i=['<tpl for=".">','<dl class="list-template {[this.getHideDLClass(values.visible)]}" style="{[this.getItemDisplayStyle(values.display)]}">',t?"{[this.getAddFolderIcon(values)]}":"",'<dt><table cellspacing="0"><tbody><tr>','<td><div class="icon {[this.getIconClass(values)]}"></div></td>','<td><div class="text sds-ellipsis" ext:qtip="{[this.doubleEncode(values.title)]}">',"{title:htmlEncode}","</div></td>","</tr><tbody></table></dt>","</dl>","</tpl>"].join("");return new Ext.XTemplate(this.prepend_separator?'<div class="main-list-separator-margin"></div><div class="main-list-separator"></div>':"",e,i,'<div class="x-clear"></div>',{compiled:!0,getItemDisplayStyle:function(t){return Ext.isEmpty(t)?"":"display: "+t+";"},doubleEncode:function(t){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(t))},getIconClass:function(e){return t?e.type:e.tuner_id>=0?"dtv":"schedule"},getAddLibraryIcon:function(t){return _S("is_admin")?'<div class="add-library"></div>':""},getHideDLClass:function(e){return t&&!e?"x-hide-display":""},getDTVIcon:function(){return'<div class="signal-icon hide"></div><div class="streaming-icon hide"></div>'},getAddFolderIcon:function(t){var e=-1!==[SYNO.SDS.VideoStation2.Constant.MOVIE,SYNO.SDS.VideoStation2.Constant.TVSHOW,SYNO.SDS.VideoStation2.Constant.HOME_VIDEO].indexOf(t.type);return _S("is_admin")&&e?'<div class="icon add"></div>':""}})}}),Ext.define("SYNO.SDS.VideoStation2.MainList.Event",{singleton:!0,LIBRARY_PANEL_RESIZE:"librarypanelresize",DTV_PANEL_RESIZE:"dtvpanelresize"}),Ext.define("SYNO.SDS.VideoStation2.DetailActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(t){var e={cls:"detail-action-bar",items:[new SYNO.SDS.VideoStation2.DetailActionBar.SelectPlayer,new SYNO.SDS.VideoStation2.DetailActionBar.MoreAction]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.DetailActionBar.SelectPlayer",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(t){var e={cls:"device",tooltip:_VST("controller","tooltip_player"),noicon:!0,disabled:!0,menuBeforeShow:{scope:this,fn:this.refreshPlayerItem}};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.Player.get(),SYNO.SDS.VideoStation2.Player.EVENT_PLAYER_LOAD,this.onPlayerLoad,this)},refreshPlayerItem:function(t){t.removeAll();var e=SYNO.SDS.VideoStation2.Player.get().getAllPlayers(),i=e.map(function(t){return new Ext.menu.Item({text:t.title,scope:this,itemId:t.id,handler:this.onPlayerItemClick})},this);t.add(i)},onPlayerLoad:function(){this.setDisabled(Ext.isEmpty(SYNO.SDS.VideoStation2.Player.get().getAllPlayers()))},onPlayerItemClick:function(t){SYNO.SDS.VideoStation2.PlaybackController.selectPlayer(t.itemId),this[SYNO.SDS.VideoStation2.File.get().hasMultipleFile()?"chooseFileToPlay":"playVideo"]()},chooseFileToPlay:function(){var t=function(t){SYNO.SDS.VideoStation2.Controller.switchFile(t.id),this.playVideo()}.createDelegate(this),e={id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Video.get().getCurrentType()};SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(e,t,!0)},playVideo:function(){SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayer({file_id:SYNO.SDS.VideoStation2.File.get().getCurrentID(),video_id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),video_type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),subtitle_id:SYNO.SDS.VideoStation2.File.get().getSubtitle(),audiotrack_id:SYNO.SDS.VideoStation2.File.get().getAudiotrack()},{fn:SYNO.SDS.VideoStation2.Controller.refreshViewInfo,args:[SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO]},!1)}}),Ext.define("SYNO.SDS.VideoStation2.DetailActionBar.MoreAction",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(t){var e={cls:"more",tooltip:_VST("action","start"),menu:new SYNO.SDS.VideoStation2.DropdownMenu({noicon:!0})};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.File.get(),SYNO.SDS.VideoStation2.File.EVENT_FILE_LOAD,this.onFileLoad,this),this.mon(SYNO.SDS.VideoStation2.Capability.get(),SYNO.SDS.VideoStation2.Capability.EVENT_CAPABILITY_READY,this.onCapabilityReady,this,{single:!0})},onFileLoad:function(){var t=this.menu.getComponent(SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA);t&&t.setVisible(SYNO.SDS.VideoStation2.File.get().hasMultipleFile())},onCapabilityReady:function(){this.menu.removeAll(),this.menu.addItem(this.getActions())},getActions:function(){return SYNO.SDS.VideoStation2.ActionUtil.getAvailableVideoActions().filter(function(t){return-1===[SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING,SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO].indexOf(t)}).map(function(t){return new Ext.Action({text:SYNO.SDS.VideoStation2.Util.getVideoActionString(t),itemId:t,scope:this,handler:this.doVideoAction})},this)},doVideoAction:function(t){var e=Ext.emptyFn;switch(t.itemId){case SYNO.SDS.VideoStation2.VideoActionController.ACTION_CORRECT_METADATA:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_FILE:e=SYNO.SDS.VideoStation2.Controller.refreshView;break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SEARCH_SUBTITLE:e=function(){SYNO.SDS.VideoStation2.Controller.refreshViewInfo(SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.SUBTITLE)};break;case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED:case SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED:e=function(){SYNO.SDS.VideoStation2.Controller.refreshViewInfo(SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO)};break;default:e=Ext.emptyFn}var i=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();delete i.file,SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(t.itemId,[i],e)}}),Ext.define("SYNO.SDS.VideoStation2.SortMenuActionButton",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(t){var e=SYNO.SDS.VideoStation2.Sort.getAllSorts().map(function(t){var e="title"===t?_VST("common",t):_VST("classification",t);return new Ext.Action({text:String.format(_VST("sort","sort_by"),e),scope:this,itemId:t,handler:this.onSortTypeClick})},this);e=e.concat(SYNO.SDS.VideoStation2.Sort.getAllDirections().map(function(t){return new Ext.Action({text:_VST("sort","order_"+t),scope:this,itemId:t,handler:this.onSortDirClick})},this));var i={cls:"sort",tooltip:_VST("action","sort"),menu:new SYNO.SDS.VideoStation2.DropdownMenu({items:e})};this.callParent([Ext.apply(i,t)]),this.onLoadSort(),this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.adjustSortMenu,this),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.adjustSortMenu,this),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CLEARED,this.adjustSortMenu,this),this.mon(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.onLoadSort,this)},adjustSortMenu:function(){var t=SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST,e=SYNO.SDS.VideoStation2.Category.get().isCurrentRecordingSpecific(),i=this.menu.getComponent(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_ADDED),o=this.menu.getComponent(SYNO.SDS.VideoStation2.Sort.SORT_RECENTLY_RELEASED);i.setDisabled(t||e),o.setDisabled(e)},onLoadSort:function(){var t=[SYNO.SDS.VideoStation2.Sort.get().getCurrentSort(),SYNO.SDS.VideoStation2.Sort.get().getCurrentSortDir()];this.menu.items.each(function(e){e.removeClass("checked"),-1!==t.indexOf(e.itemId)&&e.addClass("checked")},this)},onSortTypeClick:function(t){SYNO.SDS.VideoStation2.VideoListController.toSortType(t.itemId)},onSortDirClick:function(t){SYNO.SDS.VideoStation2.VideoListController.toSortDirection(t.itemId)}}),Ext.define("SYNO.SDS.VideoStation2.TimeLine",{extend:"Ext.util.Observable",statics:{EVENT_TIMELINE_LOAD:"timelineload",EVENT_ON_MENU_CLICK:"onmenuclick",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.TimeLine.instance)||(SYNO.SDS.VideoStation2.TimeLine.instance=new SYNO.SDS.VideoStation2.TimeLine),SYNO.SDS.VideoStation2.TimeLine.instance}},constructor:function(){this.callParent(arguments)},loadTimeLine:function(t){this.dates=t,this.fireEvent(SYNO.SDS.VideoStation2.TimeLine.EVENT_TIMELINE_LOAD)},getDate:function(){return this.dates},onMenuClick:function(t){this.fireEvent(SYNO.SDS.VideoStation2.TimeLine.EVENT_ON_MENU_CLICK,t)},dates:[]}),Ext.define("SYNO.SDS.VideoStation2.TimeLineButton",{extend:"SYNO.SDS.VideoStation2.ActionButton",constructor:function(t){var e={cls:"calendar",tooltip:_VST("date","title"),menu:new SYNO.SDS.VideoStation2.DropdownMenu({autoFlexcroll:!0,items:[],resetWidthForFlexcroll:Ext.emptyFn,listeners:{scope:this,beforeshow:function(t){t.doLayout()}}})};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.TimeLine.get(),SYNO.SDS.VideoStation2.TimeLine.EVENT_TIMELINE_LOAD,this.loadMenu,this)},loadMenu:function(){this.menu.removeAll();var t=function(t,e){-1===t.indexOf(e)&&t.push(e)},e=SYNO.SDS.VideoStation2.TimeLine.get().getDate().reduce(function(e,i){var o=SYNO.SDS.VideoStation2.Util.parseLazyDate(i);return t(e,o.year.toString()),t(e,String.format("{0}-{1}",o.year,o.month)),e},[]);if(0!==e.length){var i=e.map(function(t){return this.getMenuAction(t)},this);this.menu.addItem(i),this.toggleMenuItem(e[0])}},onMenuClick:function(t){if(!t.hasMonth)return this.toggleMenuItem(t.itemId),!1;SYNO.SDS.VideoStation2.TimeLine.get().onMenuClick(t.itemId)},toggleMenuItem:function(t){var e=SYNO.SDS.VideoStation2.Util.parseLazyDate(t).year;this.menu.items.each(function(t){t.hasMonth&&(t.year===e?t.show():t.hide())},this),this.menu.doLayout()},toMonthName:function(t){var e=["jan","feb","mar","apr","may","jun","jul","aug","sep","oct","nov","dec"];return _JSLIBSTR("extlang",e[t])},getMenuAction:function(t){var e=SYNO.SDS.VideoStation2.Util.parseLazyDate(t),i=-1!==t.indexOf("-"),o=i?this.toMonthName(e.month-1):t,n=i?"syno-vs-time-line-month":"syno-vs-time-line-year";return new Ext.Action({text:o,itemId:t,cls:n,hasMonth:i,year:e.year,scope:this,handler:this.onMenuClick})}}),Ext.define("SYNO.SDS.VideoStation2.NavigationToolbarPath",{extend:"SYNO.SDS.VideoStation2.TransparentButton",path:null,constructor:function(t){this.callParent(arguments),this.setPath(this.path),this.addClass("nav-toolbar-path"),this.mon(this,"click",this.onPathClick)},setPath:function(t){this.path=t,this.setText(this.path.value)},onPathClick:function(){switch(Ext.isDefined(this.path.folder)&&(SYNO.SDS.VideoStation2.Hash.get().unUpdatePath(SYNO.SDS.VideoStation2.Constant.FOLDER),SYNO.SDS.VideoStation2.Folder.get().thrinkFolderStackTo(this.path.folder)),this.path.view){case SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE:SYNO.SDS.VideoStation2.Controller.intoHomePage(!0);break;case SYNO.SDS.VideoStation2.View.VIEW_POSTER:Ext.isDefined(this.path.recording_specific)?SYNO.SDS.VideoStation2.Controller.intoPosterView(this.path.recording_specific,null,this.path.value):SYNO.SDS.VideoStation2.Controller.intoPosterView();break;case SYNO.SDS.VideoStation2.View.VIEW_DETAIL:SYNO.SDS.VideoStation2.Controller.intoVideoDetail();break;case SYNO.SDS.VideoStation2.View.VIEW_TVSHOW:SYNO.SDS.VideoStation2.Controller.intoTVShow();break;case SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST:SYNO.SDS.VideoStation2.Controller.intoPlaylistView()}SYNO.SDS.VideoStation2.Hash.get().updatePath(SYNO.SDS.VideoStation2.Constant.FOLDER)}}),Ext.define("SYNO.SDS.VideoStation2.NavigationToolbarFilter",{extend:"SYNO.SDS.VideoStation2.TransparentButton",category:null,constructor:function(t){this.callParent(arguments),this.setCategory(this.category),this.addClass("nav-toolbar-filter"),this.mon(this,"afterrender",this.onAfterRender,this)},setCategory:function(t){this.category=t;var e=SYNO.SDS.VideoStation2.Util.getFilterCategoryString(t);this.setText(e)},onAfterRender:function(){var t=this.getEl(),e=t.createChild({tag:"div",cls:"filter-cancel"},t.down("em"));this.mon(e,"click",this.onFilterClick,this)},onFilterClick:function(){SYNO.SDS.VideoStation2.Filter.get().clearFilter(this.category)}}),Ext.define("SYNO.SDS.VideoStation2.NavigationLeftContainer",{extend:"Ext.Container",constructor:function(t){var e={cls:"left-container",items:[this.categoryBar=new SYNO.SDS.VideoStation2.NavigationBar.CategoryBar,this.pathBar=new SYNO.SDS.VideoStation2.NavigationBar.PathBar]};this.callParent([Ext.apply(e,t)]),this.relayEvents(this.categoryBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]),this.relayEvents(this.pathBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]),this._active=this.categoryBar,this.mon(SYNO.SDS.VideoStation2.Navigation.get(),SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_TYPE_CHANGED,this.switchType,this),this.switchType()},getActiveWidth:function(){return this._active.getResizeEl()?this._active.getWidth():0},switchType:function(){switch(SYNO.SDS.VideoStation2.Navigation.get().getCurrentType()){case SYNO.SDS.VideoStation2.Navigation.TYPE_CATEGORY:this._active=this.categoryBar,this._deactive=this.pathBar;break;default:this._deactive=this.categoryBar,this._active=this.pathBar}this._active.show(),this._deactive.hide(),this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR)}}),Ext.define("SYNO.SDS.VideoStation2.NavigationBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(t){var e={cls:"main-navbar",items:[this.leftContainer=new SYNO.SDS.VideoStation2.NavigationLeftContainer,"->",this.actionBar=new SYNO.SDS.VideoStation2.NavigationBar.ActionBar],listeners:{afterlayout:this.adjustToolbarSize,scope:this}};this.callParent([Ext.apply(e,t)]),this.mon(this.leftContainer,SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR,this.adjustToolbarSize,this),this.mon(this.actionBar,SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR,this.adjustToolbarSize,this)},adjustToolbarSize:function(){var t=this.getEl();if(t){var e=t.getWidth()-t.getPadding("lr"),i=this.actionBar.container.getWidth(),o=e-i;this.leftContainer.setWidth(o),this.leftContainer.setWidth(Ext.min([this.leftContainer.getActiveWidth(),o]))}}}),Ext.define("SYNO.SDS.VideoStation2.NavigationBar.Event",{statics:{EVENT_ADJUST_TOOLBAR:"adjusttoolbar"}}),Ext.define("SYNO.SDS.VideoStation2.NavigationBar.CategoryBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(t){var e={cls:"navbar-categorybar",items:[this.categoryBtn=new SYNO.SDS.VideoStation2.NavigationBar.CategoryButton,this.filterBar=new SYNO.SDS.VideoStation2.NavigationBar.FilterBar]};this.callParent([Ext.apply(e,t)]),this.relayEvents(this.filterBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.changeFilterState,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.changeFilterState,this),this.changeFilterState()},changeFilterState:function(){var t=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_ALL,e=SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE;this.categoryBtn.setVisible(!e),this.filterBar.setVisible(t||e),this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR)},hide:function(){this.callParent(arguments),this.categoryBtn.menu.hide()}}),Ext.define("SYNO.SDS.VideoStation2.NavigationBar.FilterBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(t){var e={cls:"navbar-filterbar",items:[]};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadFilter,this),this.loadFilter()},loadFilter:function(){this.removeAll();var t=SYNO.SDS.VideoStation2.Filter.get().getFilterOption();Ext.apply(t,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption()),this.add(Object.keys(t).map(function(t){return new SYNO.SDS.VideoStation2.NavigationToolbarFilter({category:t})})),this.doLayout(),this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR)}}),Ext.define("SYNO.SDS.VideoStation2.NavigationBar.PathBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(t){var e={cls:"navbar-pathbar",items:[]};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.Navigation.get(),SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_PATH_CHANGED,this.loadPath,this),this.mon(SYNO.SDS.VideoStation2.Navigation.get(),SYNO.SDS.VideoStation2.Navigation.EVENT_NAVIGATION_GOBACK,this.goback,this),this.loadPath()},loadPath:function(){this.removeAll();var t=SYNO.SDS.VideoStation2.Navigation.get().getCurrentPath();t&&(this.add(t.map(function(t){return new SYNO.SDS.VideoStation2.NavigationToolbarPath({path:t})})),this.doLayout(),this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR))},goback:function(){this.hidden||this.items.length<=1||this.items.get(this.items.length-2).fireEvent("click")}}),Ext.define("SYNO.SDS.VideoStation2.NavigationBar.ActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(t){var e={cls:"navbar-actionbar",items:[this.detailActionBar=new SYNO.SDS.VideoStation2.DetailActionBar,this.listActionBar=new SYNO.SDS.VideoStation2.NavigationBar.ListActionBar]};this.callParent([Ext.apply(e,t)]),this.relayEvents(this.detailActionBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]),this.relayEvents(this.listActionBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]),this.mon(SYNO.SDS.VideoStation2.BrowsingAction.get(),SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED,this.switchAction,this),this.switchAction()},switchAction:function(){switch(SYNO.SDS.VideoStation2.BrowsingAction.get().getCurrentAction()){case SYNO.SDS.VideoStation2.BrowsingAction.ACTION_NONE:this.detailActionBar.hide(),this.listActionBar.hide();break;case SYNO.SDS.VideoStation2.BrowsingAction.ACTION_DETAIL:this.detailActionBar.show(),this.listActionBar.hide();break;default:this.detailActionBar.hide(),this.listActionBar.show()}this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR)}}),Ext.define("SYNO.SDS.VideoStation2.NavigationBar.ListActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(t){var e=SYNO.SDS.VideoStation2.View.getAllTypes().map(function(t){return new Ext.Action({text:_VST("common","mode_"+t),scope:this,itemId:t,handler:this.onViewTypeClick})},this),i={cls:"navbar-list-actionbar",items:[this.selectModeBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"select_mode",tooltip:_VST("common","selection_mode"),enableToggle:!0,scope:this,toggleHandler:this.onSelectModeToggle}),this.selectActionBar=new SYNO.SDS.VideoStation2.NavigationBar.SelectActionBar,this.viewTypeBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"view_list",menu:new SYNO.SDS.VideoStation2.DropdownMenu({items:e})}),this.timeLineBtn=new SYNO.SDS.VideoStation2.TimeLineButton({}),this.sortBtn=new SYNO.SDS.VideoStation2.SortMenuActionButton,this.editBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"edit",tooltip:_VST("action","edit_metadata"),scope:this,handler:this.onEditClick})]};this.callParent([Ext.apply(i,t)]),this.relayEvents(this.selectActionBar,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR]),this.mon(SYNO.SDS.VideoStation2.BrowsingAction.get(),SYNO.SDS.VideoStation2.BrowsingAction.EVENT_BROWSING_ACTION_CHANGED,this.switchAction,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.onViewChange,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEWTYPE_CHANGED,this.onViewTypeChange,this),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChange,this),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CLEARED,this.onCategoryChange,this),this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChange,this),this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECT_MODE_CHANGED,this.onVideoSelectModeChange,this)},switchAction:function(){switch(SYNO.SDS.VideoStation2.BrowsingAction.get().getCurrentAction()){case SYNO.SDS.VideoStation2.BrowsingAction.ACTION_SELECT:this.selectActionBar.show();break;default:this.selectActionBar.hide()}},loadViewType:function(){var t=SYNO.SDS.VideoStation2.View.get().getViewType(),e=SYNO.SDS.VideoStation2.View.getAllTypes().map(function(t){return"view_"+t});this.viewTypeBtn.removeClass(e),this.viewTypeBtn.addClass("view_"+t),this.viewTypeBtn.setTooltip(_VST("common","mode_"+t)),this.viewTypeBtn.menu.getComponent(SYNO.SDS.VideoStation2.View.TYPE_TILE).setVisible(SYNO.SDS.VideoStation2.View.get().getView()!==SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST),this.viewTypeBtn.menu.items.each(function(e){e.removeClass("checked"),e.itemId===t&&e.addClass("checked")})},changeSortBtnState:function(){SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST?this.sortBtn.setDisabled(SYNO.SDS.VideoStation2.View.get().getView()!==SYNO.SDS.VideoStation2.View.VIEW_POSTER):this.sortBtn.setDisabled(SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_TVSHOW||!SYNO.SDS.VideoStation2.Category.isSortAdjustableCategory(SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()));var t=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory(),e=t===SYNO.SDS.VideoStation2.Category.CATEGORY_TIME_LINE;this.sortBtn.setVisible(!e)},changeSelectModeBtnState:function(){var t=SYNO.SDS.VideoStation2.View.get().getView(),e=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory(),i=SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.TVSHOW&&t===SYNO.SDS.VideoStation2.View.VIEW_POSTER&&e!==SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER,o=t===SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST,n=SYNO.SDS.VideoStation2.Category.isRecordingSpecificCategory(e)&&!SYNO.SDS.VideoStation2.RecordingSpecific.get().isSet(),a=e===SYNO.SDS.VideoStation2.Category.CATEGORY_TIME_LINE;this.selectModeBtn.setVisible(!(i||o||n||a)),this.selectModeBtn.toggle(SYNO.SDS.VideoStation2.Video.get().isInSelectMode())},changeTimeLineButton:function(){var t=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory(),e=t===SYNO.SDS.VideoStation2.Category.CATEGORY_TIME_LINE;this.timeLineBtn.setVisible(e)},changeViewTypeState:function(){var t=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory(),e=t===SYNO.SDS.VideoStation2.Category.CATEGORY_TIME_LINE;this.viewTypeBtn.setVisible(!e)},changeEditBtnState:function(){this.editBtn.setVisible(SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_TVSHOW&&!SYNO.SDS.VideoStation2.Video.get().isInSelectMode()&&_S("is_admin")),this.fireEvent(SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR)},onViewChange:function(){this.loadViewType(),this.changeSortBtnState(),this.changeSelectModeBtnState(),this.changeEditBtnState()},onViewTypeChange:function(){this.loadViewType()},onVideoSelectModeChange:function(){this.changeSelectModeBtnState(),this.changeEditBtnState()},onLibraryChange:function(){this.changeSortBtnState(),this.changeSelectModeBtnState(),this.changeTimeLineButton()},onCategoryChange:function(){this.changeSortBtnState(),this.changeSelectModeBtnState(),this.changeViewTypeState(),this.changeTimeLineButton()},onViewTypeClick:function(t){SYNO.SDS.VideoStation2.View.get().setViewType(t.itemId)},onSelectModeToggle:function(t,e){SYNO.SDS.VideoStation2.VideoListController.toSelectMode(e,!0)},onEditClick:function(){SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_METADATA,[{id:SYNO.SDS.VideoStation2.TVShow.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Constant.TVSHOW,mapper_id:SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow().mapper_id,library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID()}],SYNO.SDS.VideoStation2.Controller.refreshViewInfo)},hide:function(){this.callParent(arguments),this.viewTypeBtn.menu.hide(),this.sortBtn.menu.hide()}}),Ext.define("SYNO.SDS.VideoStation2.NavigationBar.SelectActionBar",{extend:"SYNO.SDS.VideoStation2.NavigationToolbar",constructor:function(t){var e={scope:this,handler:this.onVideoAction},i={cls:"navbar-select-actionbar",hideMode:"custom",items:[new SYNO.SDS.VideoStation2.MenuActionButton({cls:"select_collection",tooltip:_VST("playlist","title"),menuBeforeShow:{scope:this,fn:this.onBeforeSelectPlaylistShow}}),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_share",tooltip:_VST("advanced","public_sharing"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING},e)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_view",tooltip:_VST("action","set_watched"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_WATCHED},e)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_view_off",tooltip:_VST("action","set_unwatched"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_SET_UNWATCHED},e)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_edit",tooltip:_VST("action","edit_metadata"),hidden:!_S("is_admin"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_MULTIPLE_EPISODE_METADATA},e)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_delete",tooltip:_VST("action","del_video"),hidden:!_S("is_admin"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO},e)),new SYNO.SDS.VideoStation2.ActionButton(Ext.apply({cls:"select_transcoding",tooltip:_VST("offline_conversion","action"),itemId:SYNO.SDS.VideoStation2.VideoActionController.ACTION_OFFLINE_CONVERSION},e))],listeners:{scope:this}};this.callParent([Ext.apply(i,t)]),this.mon(SYNO.SDS.VideoStation2.Video.get(),SYNO.SDS.VideoStation2.Video.EVENT_VIDEO_SELECTION_CHANGED,this.onVideoSelectionChange,this),this.mon(SYNO.SDS.VideoStation2.Capability.get(),SYNO.SDS.VideoStation2.Capability.EVENT_CAPABILITY_READY,this.onCapabilityReady,this,{single:!0}),this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.toggleMultipleTVShowEditBtn,this),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.toggleMultipleTVShowEditBtn,this),this.onVideoSelectionChange()},toggleMultipleTVShowEditBtn:function(){var t=this.getComponent(SYNO.SDS.VideoStation2.VideoActionController.ACTION_EDIT_MULTIPLE_EPISODE_METADATA);_S("is_admin")&&SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType()===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE&&SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()!==SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER?t.show():t.hide()},recalculateWidth:function(){this.getEl()&&this.setWidth(this.items.items.reduce(function(t,e){return t+e.container.getWidth()},0))},onCapabilityReady:function(){this.getComponent(SYNO.SDS.VideoStation2.VideoActionController.ACTION_PUBLIC_SHARING).setVisible(SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing()),this.getComponent(SYNO.SDS.VideoStation2.VideoActionController.ACTION_OFFLINE_CONVERSION).setVisible(SYNO.SDS.VideoStation2.Capability.get().ableToControlOfflineConversion())},onVideoSelectionChange:function(){var t=SYNO.SDS.VideoStation2.Video.get().isVideoSelectionEmpty();this.items.each(function(e){e.setDisabled(t)})},onBeforeSelectPlaylistShow:function(t){t.removeAll();var e=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection(),i={},o=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID();e.each(function(t){t.playlists&&t.playlists.each(function(t){i[t.id]=(i[t.id]||0)+1})});var n=function(t){return i[t.id]===e.length?"checked":""},a=function(t){return o===t.id},S=SYNO.SDS.VideoStation2.PlaylistController.createPlaylistActions({clsFn:n,hideOnClickFn:a,createPlaylistFn:this.onCreatePlaylist,clickPlaylistFn:this.onPlaylistClick},this);t.add(S)},onVideoAction:function(t){var e=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection();if(0!==e.length){var i=t.itemId===SYNO.SDS.VideoStation2.VideoActionController.ACTION_DEL_VIDEO,o=i?function(){SYNO.SDS.VideoStation2.Video.get().clearVideoSelection(),SYNO.SDS.VideoStation2.Video.get().leaveSelectMode(),SYNO.SDS.VideoStation2.Controller.refreshView()}:SYNO.SDS.VideoStation2.Controller.refreshView;SYNO.SDS.VideoStation2.VideoActionController.doVideoAction(t.itemId,e,o)}},onCreatePlaylist:function(){var t=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection()
;SYNO.SDS.VideoStation2.VideoActionController.createPlaylist(t,SYNO.SDS.VideoStation2.Controller.refreshView)},onPlaylistClick:function(t){var e=SYNO.SDS.VideoStation2.Video.get().getCurrentVideoSelection(),i=SYNO.SDS.VideoStation2.Playlist.get().getPlaylistByID(parseInt(t.itemId,10)),o=!t.getEl().hasClass("checked"),n=Ext.emptyFn;n=o||i.id!==SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()?this.onPlaylistAddRemove.createDelegate(this,[o,t]):function(){SYNO.SDS.VideoStation2.Video.get().clearVideoSelection(),SYNO.SDS.VideoStation2.Controller.refreshView()},SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist(e,i.id,o,n)},onPlaylistAddRemove:function(t,e){e&&!e.isDestroyed&&e.getEl()[t?"addClass":"removeClass"]("checked"),SYNO.SDS.VideoStation2.Controller.refreshView()},onShow:function(){this.callParent(arguments),this.removeClass("hide"),this.addClass("show"),this.recalculateWidth(),this.fireEvent.defer(500,this,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR])},onHide:function(){this.callParent(arguments),this.addClass("hide"),this.removeClass("show"),this.setWidth(0),this.fireEvent.defer(500,this,[SYNO.SDS.VideoStation2.NavigationBar.Event.EVENT_ADJUST_TOOLBAR])}}),Ext.define("SYNO.SDS.VideoStation2.NavigationBar.CategoryButton",{extend:"SYNO.SDS.VideoStation2.TransparentButton",constructor:function(t){var e=SYNO.SDS.VideoStation2.Category.getAllCategories().map(function(t){return new Ext.Action({text:_VST("classification",t),scope:this,itemId:t,handler:this.onCategoryClick})},this),i={cls:"category-button",menu:new SYNO.SDS.VideoStation2.DropdownMenu({noicon:!0,items:e})};this.callParent([Ext.apply(i,t)]),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.loadCategory,this),this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChange,this),this.loadCategory()},loadCategory:function(){var t=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory(),e=this.menu.getComponent(t);this.setText(e.text)},onLibraryChange:function(){var t=SYNO.SDS.VideoStation2.Library.get().getCurrentType();this.menu.items.each(function(e){var i=SYNO.SDS.VideoStation2.Category.isAvilableCategoryWithType(t,e.itemId);e.setVisible(i)},this),this.adjustReleasedText(t)},adjustReleasedText:function(t){var e=this.menu.getComponent(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED),i=SYNO.SDS.VideoStation2.Controller.getClassificationString(SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED,t),o=[e];this.getText()===e.text&&o.push(this),Ext.each(o,function(t){t.setText(i)})},onCategoryClick:function(t){switch(t.itemId){case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_ADDED:SYNO.SDS.VideoStation2.VideoListController.toRecentlyAddedCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED:SYNO.SDS.VideoStation2.VideoListController.toRecentlyWatchCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_RELEASED:SYNO.SDS.VideoStation2.VideoListController.toRecentlyReleasedCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_ALL:SYNO.SDS.VideoStation2.VideoListController.toAllCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER:SYNO.SDS.VideoStation2.VideoListController.toFolderCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL:SYNO.SDS.VideoStation2.VideoListController.toChannelCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM:SYNO.SDS.VideoStation2.VideoListController.toProgramCategory();break;case SYNO.SDS.VideoStation2.Category.CATEGORY_TIME_LINE:SYNO.SDS.VideoStation2.VideoListController.toTimeLineCategory()}}}),Ext.define("SYNO.SDS.VideoStation2.PlayerOption",{extend:"Ext.util.Observable",statics:{EVENT_PLAYBACK_SETTING_LOAD:"playbacksettingload"},constructor:function(t){this.callParent(arguments)},loadData:function(){var t=SYNO.SDS.VideoStation2.File.get().getCurrentID();return SYNO.SDS.VideoStation2.PromiseOP.all([SYNO.SDS.VideoStation2.PromiseOP.getStoreLoad(this.getSubtitleStore(),{id:t},{empty_on_error:!0}),SYNO.SDS.VideoStation2.PromiseOP.getStoreLoad(this.getAudiotrackStore(),{id:t},{empty_on_error:!0}),SYNO.SDS.VideoStation2.PromiseOP.get().getPlaybackSetting({id:t})],function(t){var e=SYNO.SDS.VideoStation2.File.get().checkSetting(t[2]);this.fireEvent(SYNO.SDS.VideoStation2.PlayerOption.EVENT_PLAYBACK_SETTING_LOAD,e)}.bind(this))},loadSubtitle:function(t){this.getSubtitleStore().load({params:{id:SYNO.SDS.VideoStation2.File.get().getCurrentID()},callback:t.fn,scope:t.scope})},clearData:function(){this.getSubtitleStore().removeAll(),this.getAudiotrackStore().removeAll()},getSubtitleStore:function(){return this._subtitle=this._subtitle||new SYNO.SDS.VideoStation2.PlayerOption.SubtitleStore,this._subtitle},getAudiotrackStore:function(){return this._audiotrack=this._audiotrack||new SYNO.SDS.VideoStation2.PlayerOption.AudiotrackStore,this._audiotrack},getSubtitleData:function(){var t=[];return this.getSubtitleStore().each(function(e){"srt"===e.get("format")&&t.push(SYNO.Util.copy(e.data))}),t.sort(function(t,e){return(t.embedded?2:0)+(t.display<e.display?0:1)+("none"===t.id?-100:0)-((e.embedded?2:0)+(t.display>e.display?0:1)+("none"===e.id?-100:0))}),t},getAudiotrackData:function(){var t=[];return this.getAudiotrackStore().each(function(e){t.push(SYNO.Util.copy(e.data))}),t}}),Ext.define("SYNO.SDS.VideoStation2.PlayerOption.SubtitleStore",{extend:"SYNO.API.Store",statics:{NO_SUBTITLE_OBJECT:{embedded:!1,format:"srt",id:"none",lang:"",title:_T("video_player","no_subtitle")}},constructor:function(t){var e={appWindow:SYNO.SDS.VideoStation2.Window,api:"SYNO.VideoStation2.Subtitle",method:"list",version:3,baseParams:{image_based:!1},reader:new Ext.data.JsonReader({root:"subtitle",fields:[{name:"id",type:"string"},"embedded","format","lang","title",{name:"display",type:"string",convert:this.convertDisplay}]}),listeners:{scope:this,load:this.onStoreLoad}};this.callParent([Ext.apply(e,t)])},convertDisplay:function(t,e){var i=e.lang.toLowerCase();if(!1===e.embedded)return String.format("{0}{1}",Ext.isEmpty(e.title)?_VST("options","external_subtitle"):e.title,i.length>0?" - "+i:"");var o=e.title||i||String.format("Subtitle Track #{0}",e.id),n=e.format.toLowerCase();return"srt"!==n&&(o+=String.format(" ({0})",n)),o},onStoreLoad:function(t,e){var i=t.reader.readRecords({subtitle:[SYNO.SDS.VideoStation2.PlayerOption.SubtitleStore.NO_SUBTITLE_OBJECT]}).records[0];Ext.isObject(i)&&t.insert(0,i)}}),Ext.define("SYNO.SDS.VideoStation2.PlayerOption.AudiotrackStore",{extend:"SYNO.API.Store",constructor:function(t){var e={appWindow:SYNO.SDS.VideoStation2.Window,api:"SYNO.VideoStation2.File",method:"get_track_info",version:1,reader:new Ext.data.JsonReader({root:"audio",fields:["id","channel","codec","language","track",{name:"display",type:"string",convert:this.convertDisplay}]})};this.callParent([Ext.apply(e,t)])},convertDisplay:function(t,e){var i=e.language.length>0?" - "+e.language:"";return String.format("#{0}{1} ({2})",e.track,i,e.codec)}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetailInfoArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this._panel=new SYNO.SDS.VideoStation2.ViewDetailPanel({}),this.player_option=new SYNO.SDS.VideoStation2.PlayerOption({}),this.dropdown_menu=new SYNO.SDS.VideoStation2.DropdownMenu({noicon:!0,listeners:{scope:this,hide:this.onMenuHide}});var e={cls:"info-area",items:[this._panel]};this.callParent([Ext.apply(e,t)]),this.relayEvents(this._panel,[SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_RESIZED,SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_BEFORE_ANIMATION]),this._panel.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,"resize"]),this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.onVideoLoad,this),this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.LOAD_PLAYER_OPTION,this.loadPlayerOption,this),this.mon(this,SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_SELECT_SUBTITLE,this.selectSubtitle,this),this.mon(this,SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_SELECT_AUDIOTRACK,this.selectAudiotrack,this),this.mon(this._panel,SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_INFO_UPDATE,this.onInfoUpdate,this),this.mon(this._panel,SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_EXPAND_SUBTITLE,this.expandSubtitle,this),this.mon(this._panel,SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_EXPAND_AUDIOTRACK,this.expandAudiotrack,this),this.mon(this.player_option,SYNO.SDS.VideoStation2.PlayerOption.EVENT_PLAYBACK_SETTING_LOAD,this.selectPreferredPlaybackSetting,this)},onDeactivate:function(){this.getEl().select(".subtitle").each(function(t){t.update(Ext.util.Format.htmlEncode(_T("video_player","no_subtitle")))}),SYNO.SDS.VideoStation2.Controller.resetSubtitleAndAudiotrack()},onVideoLoad:function(t){this.loadBackdrop(t),this._panel.onVideoLoad(t)},onInfoUpdate:function(){this.doLayout(),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_INFO_UPDATE)},loadBackdrop:function(t){var e=SYNO.SDS.VideoStation2.Video.get().getCurrentType(),i=e===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE?t.tvshow_backdrop_mtime||"":t.additional&&t.additional.backdrop_mtime||"",o=SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:e===SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE?t.tvshow_mapper_id:t.mapper_id,mtime:i});SYNO.SDS.VideoStation2.Controller.setBackdrop(o)},loadPlayerOption:function(){this.player_option.clearData(),this.player_option.loadData()},getMenuOption:function(t,e){return t.map(function(t){return{xtype:"menuitem",scope:this,itemId:t.id.toString(),text:Ext.util.Format.htmlEncode(t.display),handler:function(t){this.fireEvent(e,t.itemId,t.text)}}},this)},getSubtitleOption:function(){return this.getMenuOption(this.player_option.getSubtitleData(),SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_SELECT_SUBTITLE)},getAudiotrackOption:function(){return this.getMenuOption(this.player_option.getAudiotrackData(),SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_SELECT_AUDIOTRACK)},selectFirstSubtitle:function(){var t=this.player_option.getSubtitleData(),e=t[Ext.min([t.length-1,1])];Ext.isObject(e)&&this.selectSubtitle(e.id.toString(),Ext.util.Format.htmlEncode(e.display))},selectPreferredItem:function(t,e,i,o){var n=e.filter(function(e){return e.id===t.toString()})[0];Ext.isObject(n)&&Ext.isFunction(i)?i(n.id.toString(),Ext.util.Format.htmlEncode(n.display)):Ext.isFunction(o)&&o()},selectPreferredPlaybackSetting:function(t){this.selectPreferredItem(t.subtitle_id,this.player_option.getSubtitleData(),this.selectSubtitle.bind(this),this.selectFirstSubtitle.bind(this)),this.selectPreferredItem(t.audio_track,this.player_option.getAudiotrackData(),this.selectAudiotrack.bind(this))},selectSubtitle:function(t,e){this.getEl().select(".subtitle").each(function(t){t.update(e)}),SYNO.SDS.VideoStation2.PlaybackController.selectSubtitle(t)},selectAudiotrack:function(t,e){this.getEl().select(".audiotrack").each(function(t){t.update(e)}),SYNO.SDS.VideoStation2.PlaybackController.selectAudiotrack(parseInt(t,10))},onMenuHide:function(){this.getEl().select(".dropdown-arrow").each(function(t){t.removeClass("expanded")})},expandSubtitle:function(t){this.dropdown_menu.removeAll(),this.dropdown_menu.add(this.getSubtitleOption()),this.dropdown_menu.showAt([t[0],t[1]+24])},expandAudiotrack:function(t){var e=this.getAudiotrackOption();if(Ext.isEmpty(e))return!1;this.dropdown_menu.removeAll(),this.dropdown_menu.add(e),this.dropdown_menu.showAt([t[0],t[1]+24])},reloadSubtitle:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.player_option.loadSubtitle({fn:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},scope:this})},reloadSubtitleAndAudioTrack:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.player_option.loadData().then(function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)}.bind(this))},getPanelHeight:function(){return this._panel.getHeight()}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event",{statics:{EVENT_EXPAND_SUBTITLE:"expandsubtitle",EVENT_EXPAND_AUDIOTRACK:"expandaudiotrack",EVENT_SELECT_SUBTITLE:"selectsubtitle",EVENT_SELECT_AUDIOTRACK:"selectaudiotrack"}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetailPanel",{extend:"Ext.Panel",statics:{EVENT_SUMMARY_BEFORE_ANIMATION:"summarybeforeanimation",EVENT_SUMMARY_RESIZED:"summaryresized",EVENT_SUMMARY_TOGGLE:"summarytoggle",EVENT_INFO_UPDATE:"infoupdate"},constructor:function(t){var e={tpl:this.getTpl(),cls:"detail-tpl-panel",is_summary_expanded:!1,listeners:{scope:this,afterrender:this.onAfterRender,resize:this.onResizeEvent}};this.callParent([Ext.apply(e,t)]),this.mon(this,SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_TOGGLE,this.updateSummaryViewAndButton,this)},onAfterRender:function(){this.mon(this.getEl(),"click",this.onPanelClick,this)},onResizeEvent:function(){this.updateSummaryViewAndButton(this.is_summary_expanded)},onVideoLoad:function(t){this._video=SYNO.Util.copy(t),this.update(t),this.toggleSummary(this.is_summary_expanded),this.applyViewMoreButtonAction(),this.fireEvent(SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_INFO_UPDATE)},onPanelClick:function(t,e,i){var o=Ext.fly(e,"syno-vs-info-area-click-target");o.hasClass("filter")?this.onFilterItemClick(e):o.hasClass("reference")?this.onReferenceItemClick(o):o.hasClass("subtitle")?(o.addClass("expanded"),this.fireEvent(SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_EXPAND_SUBTITLE,o.getXY())):o.hasClass("audiotrack")?!1!==this.fireEvent(SYNO.SDS.VideoStation2.ViewDetailInfoArea.Event.EVENT_EXPAND_AUDIOTRACK,o.getXY())&&o.addClass("expanded"):o.hasClass("rating")&&this.onStarClick(o)},onStarClick:function(t){if(_S("is_admin")){var e=SYNO.SDS.VideoStation2.Video.get(),i={success:function(){SYNO.SDS.VideoStation2.Controller.refreshViewInfo(SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO)}};SYNO.SDS.VideoStation2.OP.get().setVideoRating({id:e.getCurrentID(),rating:this.getRatingFromElement(t)},i,e.getCurrentType())}},getRatingFromElement:function(t){for(var e=1;e<=5;e++)if(t.hasClass("star_"+e))return 20*e},onFilterItemClick:function(t){var e=Ext.fly(t).getAttribute("data-filter"),i=Ext.util.Format.htmlDecode(t.innerHTML);SYNO.SDS.VideoStation2.Controller.setFilter(e,{key:i,value:i})},onReferenceItemClick:function(t){window.open(t.getAttribute("url"))},getDomBySelector:function(t){var e=this.getEl();if(e){var i=e.select(t).elements[0];if(i)return i}},applyViewMoreButtonAction:function(){var t=this.getDomBySelector(".view-btn");t&&Ext.fly(t).on("click",this.toggleSummary,this)},toggleSummary:function(t){this.is_summary_expanded=Ext.isBoolean(t)?t:!this.is_summary_expanded,this.fireEvent(SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_TOGGLE,this.is_summary_expanded)},updateSummaryViewAndButton:function(t){var e=this.getDomBySelector(".view-btn"),i=this.getDomBySelector(".summary"),o=this.getDomBySelector(".summary-wrapper"),n=this.getDomBySelector(".summary-overflow");if(e&&i&&o&&n){if(Ext.fly(i).getHeight()<=72)Ext.fly(e).addClass("hide");else{var a=Ext.fly(e);a.removeClass("hide"),a.removeClass(t?"all":"less"),a.addClass(t?"less":"all"),a.update(Ext.util.Format.htmlEncode(t?_VST("action","view_less"):_VST("action","view_all"))),a=null}var S=t?Ext.fly(i).getHeight():72,s=Ext.fly(o),r=this.getHeight()+S-s.getHeight();s.setStyle("height",String.format("{0}px",S)),s=null;var l=Ext.fly(n);l.setStyle("max-height",String.format("{0}px",S)),l=null,this.fireEvent(SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_BEFORE_ANIMATION,r),this.fireEvent.defer(400,this,[SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_RESIZED])}},getAudioDiv:function(t){if(""!==t.audio_codec){var e=t.audio_codec.toLowerCase(),i="",o="";return-1!==e.indexOf("aac")?i="aac":o=e.toUpperCase(),String.format('<td><div class="audio {0}">{1}</div></td>',i,o)}},getAudioChannelDiv:function(t){if(0!==t.channel){var e='<td><div class="audio-channel">{0}</div></td>',i=parseInt(t.channel,10)||0;switch(i){case 1:return String.format(e,"MONO");case 2:return String.format(e,"STEREO");case 6:return String.format(e,"5.1");case 8:return String.format(e,"7.1");default:return String.format(e,i.toFixed(1))}}},getResolutionText:function(t){var e,i;t.display_x>=t.display_y?(e=t.display_x,i=t.display_y):(e=t.display_y,i=t.display_x);var o=function(t){var o=(-1==t.x_from||e>t.x_from)&&(-1==t.x_to||e<=t.x_to)&&(-1==t.y_to||i<=t.y_to),n=(-1==t.y_from||i>t.y_from)&&(-1==t.y_to||i<=t.y_to)&&(-1==t.x_to||e<=t.x_to);return o||n},n="SD";return Ext.iterate(SYNO.SDS.VideoStation2.Constant.RESOLUTION_DEFINITION,function(t,e,i){if(o(e))return n=t,!1}),n},getDateRatingTpl:function(t){var e,i;if(t.record_date){var o=(t.record_date||" ").split(" ");e=o[0],i=o[1]}else e=t.original_available||"0";return SYNO.SDS.DateTimeFormatter&&"0"!==e&&(e=SYNO.SDS.DateTimeFormatter(Date.parseDate(e,"Y-m-d"),{type:"date"})),e=i?String.format("{0} {1}",e,i):e,['<table cellspacing="0"><tbody><tr>',String.format('<td><div class="year">{0}</div></td>',"0"===e?_VST("metadata","unknown"):e),SYNO.SDS.VideoStation2.ViewDetailUtil.getRatingTpl(t),"</tr></tbody></table>"].join("")},getDateRatingAndCodecTpl:function(t){SYNO.Assert(Ext.isObject(t.default_file),"file not exist");var e=this.getDateRatingTpl(t),i=t.default_file;return['<div class="info-bar"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">',e,"</td>",'<td align="right">',['<table cellspacing="0"><tbody><tr>',String.format('<td><div class="resolution">{0}</div></td>',this.getResolutionText(i)),this.getAudioDiv(i),this.getAudioChannelDiv(i),"</tr></tbody></table>"].join(""),"</td>","</tr></tbody></table></div>"].join("")},getSeasonEpisodeTpl:function(t){return["season","episode"].map(function(e){var i=t[e];return!Ext.isNumber(i)||i<=0?"":String.format('<div class="info">{0}: <div class="item">{1}</div></div>',Ext.util.Format.htmlEncode(_VST(e,e+"_title")),i)}).join("")},genAdditionalValueTpl:function(t){var e=_VST(t,"title"),i=['<tpl if="this.hasValue(values.additional.{0})">','<div class="info tag">',e,": ",'<tpl for="values.additional.{0}">','<tpl if="xindex &gt; 1">, </tpl><div class="item filter" data-filter="',t,'">{.:htmlEncode}</div>',"</tpl>","</div>","</tpl>"].join("");return String.format(i,t)},getDurationTpl:function(t){return SYNO.Assert(Ext.isObject(t.default_file),"file not exist"),['<div class="info">',Ext.util.Format.htmlEncode(_VST("duration","title")+": "),'<div class="item">',Ext.util.Format.htmlEncode(t.default_file.duration),"</div>","</div>"].join("")},getTitleAndCertificateTpl:function(t){var e=String.format('<div class="title">{0}</div>',Ext.util.Format.htmlEncode(t.title));return Ext.isEmpty(t.certificate)?e:['<div class="title-bar"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">',e,"</td>",'<td align="right" class="certificate-wrapper">',String.format('<div class="certificate">{0}</div>',Ext.util.Format.htmlEncode(t.certificate)),"</td>","</tr></tbody></table></div>"].join("")},getReferenceTpl:function(){return['<tpl if="this.hasValue(values.reference)">','<div class="info tag">',String.format("{0}: ",Ext.util.Format.htmlEncode(_VST("imdb","reference"))),'<tpl for="values.reference">','<tpl if="xindex &gt; 1">, </tpl><div class="item reference" url="{url:htmlEncode}">{title:htmlEncode}</div>',"</tpl>","</div>","</tpl>"].join("")},getSubtitleTpl:function(){return['<div class="info">',String.format("{0}: ",Ext.util.Format.htmlEncode(_VST("options","subtitle"))),String.format('<div class="dropdown-arrow subtitle">{0}</div>',Ext.util.Format.htmlEncode(_T("video_player","no_subtitle"))),"</div>"].join("")},getAudiotrackTpl:function(){return['<div class="info">',String.format("{0}: ",Ext.util.Format.htmlEncode(_VST("options","audio_track"))),String.format('<div class="dropdown-arrow audiotrack">{0}</div>',Ext.util.Format.htmlEncode(_VST("offline_conversion","default_audio_track"))),"</div>"].join("")},getTpl:function(){return new Ext.XTemplate('<tpl for=".">',"{[this.getTitleAndCertificate(values)]}",'<tpl if="this.hasTagline(values)"><div class="tagline">{values.tagline:htmlEncode}</div></tpl>',"{[this.getDateRatingAndCodec(values)]}",this.genAdditionalValueTpl("genre"),"{[this.getSeasonEpisode(values)]}","{[this.getDuration(values)]}",this.genAdditionalValueTpl("actor"),this.genAdditionalValueTpl("writer"),this.genAdditionalValueTpl("director"),this.getReferenceTpl(),'<tpl if="this.isSingleFile(values)">',"{[this.getSubtitle()]}","{[this.getAudiotrack()]}","</tpl>",'<tpl if="this.hasValue(values.additional && values.additional.summary)">',String.format('<div class="summary-title">{0}</div>',Ext.util.Format.htmlEncode(_VST("summary","title"))),'<div class="summary-wrapper">','<div class="summary-overflow">','<div class="summary">{values.additional.summary:htmlEncode}</div>',"</div>","</div>",'<div class="info-separator"></div>','<div class="view-btn all">{[_VST("action", "view_all")]}</div>',"</tpl>","</tpl>",'<div class="x-clear"></div>',{hasTagline:function(t){return!Ext.isEmpty(t.tagline)},hasValue:function(t){return!Ext.isEmpty(t)},isSingleFile:function(t){return Ext.isObject(t)&&Ext.isObject(t.additional)&&Ext.isArray(t.additional.file)&&1===t.additional.file.length},getTitleAndCertificate:this.getTitleAndCertificateTpl.createDelegate(this),getSeasonEpisode:this.getSeasonEpisodeTpl.createDelegate(this),getDuration:this.getDurationTpl.createDelegate(this),getDateRatingAndCodec:this.getDateRatingAndCodecTpl.createDelegate(this),getSubtitle:this.getSubtitleTpl.createDelegate(this),getAudiotrack:this.getAudiotrackTpl.createDelegate(this)})}}),Ext.define("SYNO.SDS.VideoStation2.VideoStatusBar",{extend:"Ext.Toolbar",constructor:function(t){this.watched_status=new Ext.Toolbar.TextItem({text:_VST("advanced","unwatched"),cls:"watched-status"}),this.video_action=new SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction;var e={cls:"video-status-bar",items:[this.watched_status,"->",this.video_action]};this.callParent([Ext.apply(e,t)]),this.video_action.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD]),this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.onVideoLoad,this),this.mon(this.video_action,SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction.EVENT_SHARING_UPDATE,this.doLayout,this)},onVideoLoad:function(t){this.updateVideoActionStatus(t),this.updateWatchedStatus(t)},updateVideoActionStatus:function(t){var e=t.additional&&t.additional.collection||[],i=e.map(function(t){return t.id});this.video_action.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,i)},updateWatchedStatus:function(t){var e=t.additional&&t.additional.watched_ratio,i=SYNO.SDS.VideoStation2.Constant.CLASS.UNWATCHED;this.watched_status[SYNO.SDS.VideoStation2.Util.isUnwatched(e)?"addClass":"removeClass"](i)}}),Ext.define("SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction",{extend:"Ext.Container",statics:{EVENT_SHARING_UPDATE:"sharingupdate"},constructor:function(t){this.favorite=new SYNO.SDS.VideoStation2.ActionButton({cls:"favorite",tooltip:_VST("playlist","favorite"),handler:this.togglePlaylistAddRemove.createDelegate(this,[-1])}),this.watchlist=new SYNO.SDS.VideoStation2.ActionButton({cls:"watchlist",tooltip:_VST("playlist","watchlist"),handler:this.togglePlaylistAddRemove.createDelegate(this,[-2])}),this.playlist=new SYNO.SDS.VideoStation2.MenuActionButton({cls:"playlist",tooltip:_VST("playlist","title"),menuBeforeShow:{fn:this.refreshPlaylistItem,scope:this}}),this.sharing=new SYNO.SDS.VideoStation2.ActionButton({cls:"public-sharing",tooltip:_VST("advanced","public_sharing"),hidden:!0,scope:this,handler:this.onSharingButtonClick});var e={layout:"hbox",layoutConfig:{type:"hbox",align:"top",pack:"end",defaultMargins:{top:0,right:0,bottom:0,left:8}},cls:"video-action",items:[this.favorite,this.watchlist,this.playlist,this.sharing]};this.callParent([Ext.apply(e,t)]),this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,this.updateSharingStatus,this),this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,this.updatePlaylistStatus,this)},updateSharingStatus:function(t){this.sharing.setVisible(SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing()),this.sharing.toggle(t||!1),this.fireEvent(SYNO.SDS.VideoStation2.VideoStatusBar.VideoAction.EVENT_SHARING_UPDATE)},updatePlaylistStatus:function(t){this.current_playlists=t||[];var e={favorite:!1,watchlist:!1,playlist:!1};Ext.each(this.current_playlists,function(t){t>0?e.playlist=!0:-1===t?e.favorite=!0:-2===t&&(e.watchlist=!0)}),Ext.iterate(e,function(t,e,i){this[t].toggle(e)},this)},onSharingButtonClick:function(){var t=function(t){this.updateSharingStatus(t)}.createDelegate(this),e=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();SYNO.SDS.VideoStation2.VideoActionController.publicSharing([e],t)},refreshPlaylistItem:function(t){var e=SYNO.SDS.VideoStation2.Playlist.get().getCurrentID(),i=this.current_playlists,o=SYNO.SDS.VideoStation2.PlaylistController.createPlaylistActions({clsFn:function(t){return Ext.isArray(i)&&-1!==i.indexOf(t.id)?"checked":""},hideOnClickFn:function(t){return e===t.id},filterPlaylistFn:function(t){return t.id>0&&t.type===SYNO.SDS.VideoStation2.Constant.PLAYLIST_TYPE.ORIGINAL},createPlaylistFn:this.createPlaylistHandler,clickPlaylistFn:this.playlistItemClickHandler},this);t.removeAll(),t.add(o)},createPlaylistHandler:function(){var t=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo(),e=function(t){-1===this.current_playlists.indexOf(t.id)&&this.current_playlists.push(t.id),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,this.current_playlists)}.createDelegate(this);SYNO.SDS.VideoStation2.VideoActionController.createPlaylist([t],e)},playlistItemClickHandler:function(t){var e=parseInt(t.itemId,10),i=function(){t&&!t.isDestroyed&&t.getEl()[-1!==this.current_playlists.indexOf(e)?"addClass":"removeClass"]("checked")}.createDelegate(this);this.togglePlaylistAddRemove(e,i)},togglePlaylistAddRemove:function(t,e){var i=-1===this.current_playlists.indexOf(t),o=Ext.emptyFn;o=i||t!==SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()?function(){var o=i?this.current_playlists.concat(t):this.current_playlists.filter(function(e){return e!==t});this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.PLAYLIST_CHANGE,o),Ext.isFunction(e)&&e()}.createDelegate(this):SYNO.SDS.VideoStation2.Controller.goback;var n=SYNO.SDS.VideoStation2.Video.get().getCurrentVideo();SYNO.SDS.VideoStation2.PlaylistController.setVideoWithPlaylist([n],t,i,o)}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetail",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this.action_area=new SYNO.SDS.VideoStation2.ViewDetailActionArea({region:"west"}),this.info_area=new SYNO.SDS.VideoStation2.ViewDetailInfoArea({region:"center"});var e={layout:"border",bodyCssClass:"view-detail-panel-body",cls:"view-detail",items:[this.action_area,this.info_area]};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD),this.addEvents(SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_RESIZED),this.action_area.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]),this.info_area.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]),this.relayEvents(this.info_area,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_RESIZED]),this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.onVideoDetailLoad,this),this.mon(this.action_area,SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,this.onVideoDetailLoad,this),this.mon(this.action_area,SYNO.SDS.VideoStation2.ViewDetail.Event.EVENT_PLAY_VIDEO,this.playVideo,this),this.mon(this.info_area,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_INFO_UPDATE,this.onInfoResize,this),this.mon(this.info_area,SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_BEFORE_ANIMATION,this.onInfoResize,this)},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.refreshAll,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this),this.loadFullData({load_path:!1,load_file:!0})},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.refreshAll,this),this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this)},onVideoDetailLoad:function(){this.detailLoadCount=this.detailLoadCount+1,2===this.detailLoadCount&&(this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.info_area.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.LOAD_PLAYER_OPTION))},onInfoResize:function(t){this.setHeight(Ext.max([440,t||this.info_area.getPanelHeight()]))},refreshAll:function(){var t=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()!==SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER;this.loadFullData({load_path:t,load_file:!0})},loadFullData:function(t){this.detailLoadCount=0,this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),SYNO.SDS.VideoStation2.PlaybackController.loadPlayer(),this.loadVideoData(t)},refreshInfo:function(t){var e=SYNO.SDS.VideoStation2.Constant.REFRESH_INFO;switch(t){case e.VIDEO:this.loadVideoOnly(),this.loadSubtitleAndAudioTrack();break;case e.SUBTITLE:this.loadSubtitleOnly()}},loadVideoOnly:function(){this.loadVideoData({load_path:!1,load_file:!1})},loadSubtitleOnly:function(){SYNO.SDS.VideoStation2.File.get().hasMultipleFile()||this.info_area.reloadSubtitle()},loadSubtitleAndAudioTrack:function(){SYNO.SDS.VideoStation2.File.get().hasMultipleFile()||this.info_area.reloadSubtitleAndAudioTrack()},playVideo:function(){SYNO.SDS.VideoStation2.PlaybackController.selectPlayer(SYNO.SDS.VideoStation2.Constant.PLAYER_STREAMING),SYNO.SDS.VideoStation2.PlaybackController.launchVideoPlayer({file_id:SYNO.SDS.VideoStation2.File.get().getCurrentID(),video_id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),video_type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),subtitle_id:SYNO.SDS.VideoStation2.File.get().getSubtitle(),audiotrack_id:SYNO.SDS.VideoStation2.File.get().getAudiotrack()},{fn:SYNO.SDS.VideoStation2.Controller.refreshViewInfo,args:[SYNO.SDS.VideoStation2.Constant.REFRESH_INFO.VIDEO]},!1)},loadVideoData:function(t){var e=SYNO.SDS.VideoStation2.Video.get().getCurrentType(),i={id:[SYNO.SDS.VideoStation2.Video.get().getCurrentID()],additional:SYNO.SDS.VideoStation2.Constant.ADDITIONAL_DICT[e]},o={success:function(i,o,n){if(Ext.isEmpty(i[SYNO.SDS.VideoStation2.Util.getVideoRoot(e)]))return this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),void SYNO.SDS.VideoStation2.Controller.goback();this.action_area.fireEvent(SYNO.SDS.VideoStation2.ViewDetailActionArea.EVENT_LOAD_SHARING);var a=i[SYNO.SDS.VideoStation2.Util.getVideoRoot(e)][0];if(SYNO.SDS.VideoStation2.ViewDetailUtil.processVideoData(a),t.load_path&&(a.type=a.type||e,a.pathTitle=a.pathTitle||this.getPathTitle(a),SYNO.SDS.VideoStation2.Controller.updateVideoInfo(a)),t.load_file){SYNO.SDS.VideoStation2.Controller.loadFile(a.additional.file);var S=SYNO.SDS.VideoStation2.File.get().getPreSelectFile();SYNO.SDS.VideoStation2.Controller.switchFile(null!==S?S:a.default_file.id)}this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,a)},failure:function(){this.detailLoadCount=2,this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),SYNO.SDS.VideoStation2.Controller.goback()},scope:this};SYNO.SDS.VideoStation2.OP.get().getInfo(i,o,e)},getPathTitle:function(t){
if(t.type!=SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE)return t.title;return Ext.isEmpty(SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow())?SYNO.SDS.VideoStation2.Util.getPathTitleForOfflineEpisode(t):SYNO.SDS.VideoStation2.Util.getPathTitleForEpisode(t.episode,t.tagline)}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetail.Event",{statics:{EVENT_PLAY_VIDEO:"playvideo"}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetailActionArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",statics:{EVENT_LOAD_SHARING:"loadsharing"},constructor:function(t){this.image=new SYNO.SDS.VideoStation2.ViewDetailImage({region:"north"}),this.video_status_bar=new SYNO.SDS.VideoStation2.VideoStatusBar({region:"center"});var e={layout:"border",cls:"action-area",items:[this.image,this.video_status_bar]};this.callParent([Ext.apply(e,t)]),this.mon(this,SYNO.SDS.VideoStation2.ViewDetailActionArea.EVENT_LOAD_SHARING,this.loadSharing,this),this.relayEvents(this.image,[SYNO.SDS.VideoStation2.ViewDetail.Event.EVENT_PLAY_VIDEO]),this.image.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]),this.video_status_bar.relayEvents(this,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD])},loadSharing:function(){if(!SYNO.SDS.VideoStation2.Capability.get().ableToControlSharing())return void this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,!1);var t={video_id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),video_type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),need_url:!1},e={success:function(t,e,i){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.SHARING_STATUS_LOAD,!!t.enable)},scope:this};SYNO.SDS.VideoStation2.OP.get().getPublicSharing(t,e)}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetailImage",{extend:"Ext.Container",constructor:function(t){var e={cls:"image",overCls:"over",items:[new Ext.Container({cls:"border"}),new SYNO.SDS.VideoStation2.ActionButton({cls:"play",tooltip:_VST("action","play"),scope:this,handler:this.onPlayButtonClick}),this.getProgress(),this.getFileIndicator()]};this.callParent([Ext.apply(e,t)]),this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.loadImage,this)},getFileIndicator:function(){return this._file_indicator=this._file_indicator||new SYNO.SDS.VideoStation2.ViewDetailActionArea.FileIndicator({}),this._file_indicator},getProgress:function(){return this._progress=this._progress||new Ext.Container({tpl:new Ext.XTemplate('<tpl for=".">',"{[SYNO.SDS.VideoStation2.Util.getWatchStatusDiv(values)]}","</tpl>")}),this._progress},chooseFileToPlay:function(){var t=function(t){SYNO.SDS.VideoStation2.Controller.switchFile(t.id),this.playVideo()}.createDelegate(this),e={id:SYNO.SDS.VideoStation2.Video.get().getCurrentID(),type:SYNO.SDS.VideoStation2.Video.get().getCurrentType()};SYNO.SDS.VideoStation2.VideoActionController.getOneVideoFileInfo(e,t,!0)},playVideo:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewDetail.Event.EVENT_PLAY_VIDEO)},onPlayButtonClick:function(){this[SYNO.SDS.VideoStation2.File.get().hasMultipleFile()?"chooseFileToPlay":"playVideo"]()},loadImage:function(t){this.getProgress().update(t);var e=SYNO.SDS.VideoStation2.Util.getImageURL({type:SYNO.SDS.VideoStation2.Video.get().getCurrentType(),id:t.id,mtime:t.additional&&t.additional.poster_mtime||""});this.getEl().setStyle("background-image",String.format("url({0})",e))}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetailActionArea.FileIndicator",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(t){var e={cls:"file-indicator",hidden:!0,menu:new SYNO.SDS.VideoStation2.DropdownMenu({cls:"file-list",noicon:!0,listeners:{scope:this,beforeshow:this.refreshFileItem}})};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.File.get(),SYNO.SDS.VideoStation2.File.EVENT_FILE_LOAD,this.onFileLoaded,this)},onFileLoaded:function(){this.files=SYNO.SDS.VideoStation2.File.get().getAllFiles()||[];var t=this.files.length>99?"99+":this.files.length.toString();this.setText(t),this.setVisible(this.files.length>1)},refreshFileItem:function(t){t.removeAll();var e=this.files.map(function(t){return new Ext.menu.Item({text:SYNO.SDS.VideoStation2.Util.extractFileName(t.sharepath)})},this);t.add(e)}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetailRecommendationArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){var e={cls:"recommendation-area"};this.callParent([Ext.apply(e,t)])},onActivate:function(){this.mon(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.loadSlidingView,this)},onDeactivate:function(){this.mun(this,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.loadSlidingView,this)},loadSlidingView:function(){this.sliding_view&&this.mun(this.sliding_view,"afterrender",this.onAfterRenderSlidingView,this),this.removeAll(!0);var t=SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.TVSHOW?SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE:SYNO.SDS.VideoStation2.Library.get().getCurrentType();this.sliding_view=new SYNO.SDS.VideoStation2.RecommendationSlidingView[t]({decorator:{libraryType:SYNO.SDS.VideoStation2.Library.get().getCurrentType(),libraryId:SYNO.SDS.VideoStation2.Library.get().getCurrentID(),videoType:t,title:_VST("title","recommendation_video"),hiddenIcon:!0}}),this.add(this.sliding_view),this.doLayout(),this.mon(this.sliding_view,"afterrender",this.onAfterRenderSlidingView,this),this.sliding_view.relayEvents(this,["resize"]),this.sliding_view.onActivate()},onAfterRenderSlidingView:function(){this.setHeight(this.sliding_view.getHeight())}}),Ext.define("SYNO.SDS.VideoStation2.RecommendationSlidingView",{extend:"SYNO.SDS.VideoStation2.PreloadSlidingView",isPoster:function(){return!1},isDisableVideoAction:function(){return!1},isGetIntoTVShow:function(){return!1},getVideoListProxySetting:function(t){return{videolist:[]}},getTotal:function(){return Ext.min([this.callParent(),SYNO.SDS.VideoStation2.Constant.MAX_NUMBER_OF_RECOMMENDATION[this.videoType]])}}),Ext.define("SYNO.SDS.VideoStation2.RecommendationSlidingView.movie",{extend:"SYNO.SDS.VideoStation2.RecommendationSlidingView",getBaseStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.movie({synoAPI:"SYNO.VideoStation2.AcrossLibrary",synoMethod:"list_movie",baseParams:{policy:"tmdb_similar"},listeners:{scope:this,beforeload:this.onBeforeLoadBaseStore,load:this.onAfterLoadBaseStore}}),this._store},isPoster:function(){return!0},getBaseStoreParams:function(){return{library_id:[this.libraryId],limit:SYNO.SDS.VideoStation2.Constant.MAX_NUMBER_OF_RECOMMENDATION[this.videoType],id:SYNO.SDS.VideoStation2.Video.get().getCurrentID()}}}),Ext.define("SYNO.SDS.VideoStation2.RecommendationSlidingView.tvshow_episode",{extend:"SYNO.SDS.VideoStation2.RecommendationSlidingView",onAfterLoadBaseStore:function(t){var e=t.getById(SYNO.SDS.VideoStation2.Video.get().getCurrentID());t.filterBy(function(t){return t.get("season")===SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason()&&t.get("episode")>e.get("episode")&&t.id!==e.id}),t.singleSort("episode"),this.callParent()},getDataViewDecorator:function(t){return Ext.apply(t,{getTitle:SYNO.SDS.VideoStation2.Util.getTVShowEpisodeTitle,getDescription:SYNO.SDS.VideoStation2.Util.getTVShowEpisodeDescription}),this.callParent([t])},getBaseStoreParams:function(){return{library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID(),tvshow_id:SYNO.SDS.VideoStation2.TVShow.get().getCurrentID()}}}),Ext.define("SYNO.SDS.VideoStation2.RecommendationSlidingView.home_video",{extend:"SYNO.SDS.VideoStation2.RecommendationSlidingView",onAfterLoadBaseStore:function(t){var e=t.indexOfId(SYNO.SDS.VideoStation2.Video.get().getCurrentID());0<e-7&&t.remove(t.getRange(0,e-8)),e=t.indexOfId(SYNO.SDS.VideoStation2.Video.get().getCurrentID()),t.getCount()-1>e+3&&t.remove(t.getRange(e+4,t.getCount()-1)),t.remove(t.getById(SYNO.SDS.VideoStation2.Video.get().getCurrentID())),this.callParent()},getBaseStoreParams:function(){return{limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT,library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID(),sort_by:"date",sort_direction:"desc"}}}),Ext.define("SYNO.SDS.VideoStation2.RecommendationSlidingView.tv_record",{extend:"SYNO.SDS.VideoStation2.RecommendationSlidingView",onAfterLoadBaseStore:function(t){var e=t.indexOfId(SYNO.SDS.VideoStation2.Video.get().getCurrentID());0<e-7&&t.remove(t.getRange(0,e-8)),e=t.indexOfId(SYNO.SDS.VideoStation2.Video.get().getCurrentID()),t.getCount()-1>e+3&&t.remove(t.getRange(e+4,t.getCount()-1)),t.remove(t.getById(SYNO.SDS.VideoStation2.Video.get().getCurrentID())),this.callParent()},getBaseStoreParams:function(){return{limit:SYNO.SDS.VideoStation2.Constant.STORE_UNLIMIT,sort_by:"added",sort_direction:"desc"}}}),Ext.define("SYNO.SDS.VideoStation2.RecommendationSlidingView.playlist",{extend:"SYNO.SDS.VideoStation2.RowSlidingDataView",constructor:function(t){delete t.decorator.videoType,this.callParent([t])},setupView:function(){this.total=0,this.callParent(arguments)},getVideoListProxySetting:function(t){return{videolist:[]}},isPoster:function(){return!0},onTitleClick:Ext.emptyFn,getTotal:function(){return this.total},getDataViewDecorator:function(t){var e=this;return Ext.apply(t,{getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.playlistvideolist({listeners:{scope:e,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore}}),this._store},onBeforeLoadStore:function(t,e){var i=e.params;Ext.apply(i,SYNO.SDS.VideoStation2.Sort.get().getSortOption()),Ext.apply(i,{id:SYNO.SDS.VideoStation2.Playlist.get().getCurrentID()})},onAfterLoadStore:function(t){this.total=t.getTotalCount(),!1!==this.fireEvent(SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_AFTER_LOAD)&&this.fireEvent(SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_ACTIVE_NEARBY)},getImageURL:function(t){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(t)}}),t}}),Ext.define("SYNO.SDS.VideoStation2.ViewDetailOuter",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this.detail_area=new SYNO.SDS.VideoStation2.ViewDetail,this.recommendation_area=new SYNO.SDS.VideoStation2.ViewDetailRecommendationArea;var e={cls:"view-detail-outer",layout:"border",items:[this.detail_container=new Ext.Container({cls:"view-detail-container",region:"center",autoFlexcroll:!0,items:[this.detail_area,this.recommendation_area]}),this.backBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"back",handler:this.onBackBtnClick,scope:this}),this.nextBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"next",handler:this.onNextBtnClick,scope:this})],listeners:{scope:this,resize:this.onResizeEvent}};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.relayEvents(this.detail_area,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED]),this.detail_area.relayEvents(this,["activate","deactivate"]),this.recommendation_area.relayEvents(this,["activate","deactivate"]),this.recommendation_area.relayEvents(this.detail_area,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD]),this.detail_container.relayEvents(this.detail_area,[SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_RESIZED]),this.detail_container.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD),this.detail_container.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.ViewDetailPanel.EVENT_SUMMARY_RESIZED),this.mon(this.detail_area,SYNO.SDS.VideoStation2.Constant.EVENT.VIDEO_LOAD,this.updatePrevNextBtn,this)},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.refreshAll,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this),this.updatePrevNextBtn()},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.refreshAll,this),this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this)},onResizeEvent:function(){var t=this.getInnerWidth()>68?this.getInnerWidth()-68:this.getInnerWidth();this.detail_area.setWidth(t),this.recommendation_area.setWidth(t)},refreshAll:function(){this.updatePrevNextBtn()},refreshInfo:function(t){var e=SYNO.SDS.VideoStation2.Constant.REFRESH_INFO;switch(t){case e.NEXT_PREV_BTN:this.updatePrevNextBtn()}},updatePrevNextBtn:function(){this.prevVideo=SYNO.SDS.VideoStation2.Video.get().getPrevFromVideolist(),this.nextVideo=SYNO.SDS.VideoStation2.Video.get().getNextFromVideolist(),this.backBtn.setDisabled(!this.prevVideo),this.nextBtn.setDisabled(!this.nextVideo)},onBackBtnClick:function(){this.prevVideo&&SYNO.SDS.VideoStation2.Controller.intoVideoDetail(this.prevVideo)},onNextBtnClick:function(){this.nextVideo&&SYNO.SDS.VideoStation2.Controller.intoVideoDetail(this.nextVideo)}}),Ext.define("SYNO.SDS.VideoStation2.RotateElement",{extend:"Ext.Container",collapsedCls:"collapse",constructor:function(t){var e={cls:"rotate-sliding-element",items:[this.poster=new SYNO.SDS.VideoStation2.RotateElement.Poster({video:t.video}),this.backdrop=new SYNO.SDS.VideoStation2.RotateElement.Backdrop({video:t.video})],listeners:{scope:this,afterrender:this.onAfterRenderFn}};this.callParent([Ext.apply(e,t)])},onAfterRenderFn:function(t){this.collapse()},collapse:function(){this._collapsed=!0;var t=this.getEl();t&&t.addClass(this.collapsedCls)},expand:function(){this._collapsed=!1;var t=this.getEl();t&&t.removeClass(this.collapsedCls)}}),Ext.define("SYNO.SDS.VideoStation2.RotateElement.Poster",{extend:"Ext.BoxComponent",constructor:function(t){var e={cls:"poster",listeners:{scope:this,afterrender:this.onAfterRenderFn}};this.callParent([Ext.apply(e,t)])},onAfterRenderFn:function(){var t=this.video,e=SYNO.SDS.VideoStation2.Constant.MOVIE,i=SYNO.SDS.VideoStation2.Util.getImageURL({type:e,id:t.id,mtime:t.additional&&t.additional.poster_mtime||""});this.addClass("loading"),this.getEl().set({url:i},!0)}}),Ext.define("SYNO.SDS.VideoStation2.RotateElement.Backdrop",{extend:"Ext.BoxComponent",constructor:function(t){var e={tpl:this.getTpl(),cls:"backdrop",listeners:{scope:this,afterrender:this.onAfterRender}};this.callParent([Ext.apply(e,t)])},onAfterRender:function(t){this.update(this.video)},getImageURL:function(t){var e=t.additional&&t.additional.backdrop_mtime||"";return Ext.util.Format.htmlEncode(SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:t.mapper_id,mtime:e}))},getTitleDateDivTpl:function(t){var e=t.original_available||t.record_date||0,i=t.title;return 0!==e&&(i=String.format("{0}({1})",i,e.split("-")[0])),String.format('<div class="title" ext:qtip="{0}">{1}</div>',Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(i)),Ext.util.Format.htmlEncode(i))},getTaglineDivTpl:function(t){return Ext.isEmpty(t.tagline)?"":String.format('<div class="tagline">{0}</div>',Ext.util.Format.htmlEncode(t.tagline))},getCertifiateTpl:function(t){return Ext.isEmpty(t.certificate)?"":['<div class="certificate-wrapper">',String.format('<div class="certificate">{0}</div>',Ext.util.Format.htmlEncode(t.certificate)),"</div>"].join("")},getRatingAndDurationCertificateTpl:function(t){return['<div class="info-bar"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">',['<table cellspacing="0"><tbody><tr>',SYNO.SDS.VideoStation2.ViewDetailUtil.getRatingTpl(t),"</tr></tbody></table>"].join(""),"</td>",'<td align="right">',['<table cellspacing="0"><tbody><tr>',String.format("<td>{0}</td>",this.getDurationTpl(t)),String.format("<td>{0}</td>",this.getCertifiateTpl(t)),"</tr></tbody></table>"].join(""),"</td>","</tr></tbody></table></div>"].join("")},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="background-backdrop loading" url="{[this.getImageURL(values)]}"><div class="background-backdrop-gradient"></div></div>','<div class="detail-info-area">',"{[this.getTitleDateDiv(values)]}","{[this.getTaglineDiv(values)]}","{[this.getRatingAndDurationCertificate(values)]}","</div>","</tpl>",'<div class="x-clear"></div>',{getImageURL:this.getImageURL.createDelegate(this),getTitleDateDiv:this.getTitleDateDivTpl.createDelegate(this),getTaglineDiv:this.getTaglineDivTpl.createDelegate(this),getRatingAndDurationCertificate:this.getRatingAndDurationCertificateTpl.createDelegate(this)})},getDurationTpl:function(t){return SYNO.Assert(Ext.isObject(t.default_file),"file not exist"),['<div class="duration">',Ext.util.Format.htmlEncode(t.default_file.duration),"</div>"].join("")}}),Ext.define("SYNO.SDS.VideoStation2.WindowSize",{statics:{EVENT_SIZE_MODE_CHANGE:"size_mode_change",NORMAIL_SIZE:"normal_size",LARGE_SIZE:"large_size",instance:null,get:function(){return Ext.isObject(SYNO.SDS.VideoStation2.WindowSize.instance)||(SYNO.SDS.VideoStation2.WindowSize.instance=new SYNO.SDS.VideoStation2.WindowSize),SYNO.SDS.VideoStation2.WindowSize.instance}},extend:"Ext.util.Observable",constructor:function(){this.callParent(arguments)},setSizeMode:function(t){SYNO.Assert(t===SYNO.SDS.VideoStation2.WindowSize.NORMAIL_SIZE||t===SYNO.SDS.VideoStation2.WindowSize.LARGE_SIZE,String.format("{0} setSizeMode failed",t));var e=this.size_mode;this.size_mode=t,e!=this.size_mode&&this.fireEvent(SYNO.SDS.VideoStation2.WindowSize.EVENT_SIZE_MODE_CHANGE)},isLargeSizeMode:function(){return this.size_mode===SYNO.SDS.VideoStation2.WindowSize.LARGE_SIZE},size_mode:null}),Ext.define("SYNO.SDS.VideoStation2.RotateSlidingView",{extend:"Ext.Container",constructor:function(t){this.dataView=new SYNO.SDS.VideoStation2.RotateDataView;var e={cls:"rotate-sliding-view",items:[this.dataView],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};this.callParent([Ext.apply(e,t)]),this.dataView.relayEvents(this,["activate","deactivate"])},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadView,this),this.loadView()},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadView,this)},loadView:function(){this[SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","hide_slide_show")?"hide":"show"]()}}),Ext.define("SYNO.SDS.VideoStation2.RotateDataView",{extend:"Ext.Container",statics:{EVENT_LOAD_FAILED:"load_fail",CONSTANT:{WIDTH_EXPAND_ELEMENT:754,WIDTH_COLLAPSE_ELEMENT:60,GAP:2,WIDTH_EXPAND_ELEMENT_LARGE:1200,WIDTH_COLLAPSE_ELEMENT_LARGE:96,LOADED_VIDEO_COUNT:20}},_enableAutoRotateAndTransition:!0,constructor:function(t){this.allElement=new Ext.CompositeElementLite,this.loader=SYNO.SDS.VideoStation2.ImageLoadManager.get(),this.isActivate=!1;var e={cls:"rotate-data-view",hideParent:!0,listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,afterrender:this.onAfterRenderFn}};this.callParent([Ext.apply(e,t)]),this.mon(this,SYNO.SDS.VideoStation2.RotateDataView.EVENT_LOAD_FAILED,this.onLoadFailed,this),this.mon(SYNO.SDS.VideoStation2.WindowSize.get(),SYNO.SDS.VideoStation2.WindowSize.EVENT_SIZE_MODE_CHANGE,this.onSizeModeChange,this)},restartRotateTask:function(){this.getAutoRotateTask().stop(),this._enableAutoRotateAndTransition&&this.getAutoRotateTask().restart(!1)},onActivate:function(){SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","hide_slide_show")||(this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.applyAutoRotateTask,this),this.isActivate=!0,this.afterEffect(),this.loadImage(),this.applyAutoRotateTask())},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.applyAutoRotateTask,this),this.isActivate=!1,this.getAutoRotateTask().stop()},applyAutoRotateTask:function(){this._enableAutoRotateAndTransition=!SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","disable_slide_show"),this.restartRotateTask()},onAfterRenderFn:function(t){var e=SYNO.SDS.VideoStation2.RotateDataView.CONSTANT,i=(2*e.LOADED_VIDEO_COUNT-1)*(e.WIDTH_COLLAPSE_ELEMENT_LARGE+e.GAP)+(e.WIDTH_EXPAND_ELEMENT_LARGE+e.GAP);this.setWidth(i),this.getStore().load(),this.mon(this.getEl(),"click",this.onDataViewClick,this)},onSizeModeChange:function(){this.setupOffset(),this.isActivate&&this.isVisible()&&this.afterEffect()},onLoadFailed:function(){this.mun(SYNO.SDS.VideoStation2.WindowSize.get(),SYNO.SDS.VideoStation2.WindowSize.EVENT_SIZE_MODE_CHANGE,this.onSizeModeChange,this),this.hide()},onDataViewClick:function(t){var e=t.getTarget("div.rotate-sliding-element",this.getEl());if(e){var i=this.allElement.indexOf(e),o=this.getStore().getAt(i%this.getStore().getCount());if(!e.hasClassName("collapse"))return void this.intoVideoDatail(i,e,o);this.select(i),this.restartRotateTask()}},setupOffset:function(){var t=SYNO.SDS.VideoStation2.RotateDataView.CONSTANT,e=SYNO.SDS.VideoStation2.WindowSize.get().isLargeSizeMode(),i=e?t.WIDTH_EXPAND_ELEMENT_LARGE:t.WIDTH_EXPAND_ELEMENT,o=e?t.WIDTH_COLLAPSE_ELEMENT_LARGE:t.WIDTH_COLLAPSE_ELEMENT;this.width_expand=i+t.GAP,this.width_collapse=o+t.GAP,this.shift_offset=o/2+t.GAP},getStore:function(){return this._store=this._store||new SYNO.API.Store({proxy:new SYNO.API.Proxy({api:"SYNO.VideoStation2.AcrossLibrary",method:"list_movie",version:1,listeners:{scope:this,beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),api:"SYNO.VideoStation2.AcrossLibrary",method:"list_movie",version:1,baseParams:{additional:["poster_mtime","summary"]},reader:new Ext.data.JsonReader({id:"id",root:"movie",totalProperty:"total",fields:["id","mapper_id","library_id","title","tagline","certificate","rating","original_available","metadata_locked","additional","type","path","sharepath","file_count","last_watched","create_time"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:function(){this.fireEvent(SYNO.SDS.VideoStation2.RotateDataView.EVENT_LOAD_FAILED)}}}),this._store},onBeforeLoadStore:function(t,e){this.removeAll(!0),this.allElement.clear();var i=e.params;Ext.apply(i,{policy:"top_rating",limit:SYNO.SDS.VideoStation2.RotateDataView.CONSTANT.LOADED_VIDEO_COUNT,additional:["summary","poster_mtime","backdrop_mtime","file"]}),Ext.applyIf(i,t.baseParams)},onAfterLoadStore:function(t){if(0===t.getCount())return void this.fireEvent(SYNO.SDS.VideoStation2.RotateDataView.EVENT_LOAD_FAILED);this.videos=[],t.each(function(t){var e=t.data;SYNO.SDS.VideoStation2.ViewDetailUtil.processVideoData(e),this.videos.push(e)},this);var e=function(t){this.add(new SYNO.SDS.VideoStation2.RotateElement({video:t}))};Ext.each(this.videos,e,this),Ext.each(this.videos,e,this),this.doLayout(),this.allElement.fill(Ext.query("div.rotate-sliding-element",this.getEl().dom)),this.loadImage(),this.setupOffset(),this.cursor=0,this.getAt(this.cursor).expand(),this.afterEffect()},getAt:function(t){var e=this.allElement.getCount();return SYNO.Assert(Ext.isNumber(t)&&t<2*e-1&&t>-e,String.format("unexpceted index {0}",t)),SYNO.Assert(Ext.isNumber(e)&&e>0,String.format("unexpceted count {0}",e)),t=(t+e)%e,this.items.itemAt(t)},select:function(t){var e=this.allElement.getCount();SYNO.Assert(Ext.isNumber(t)&&t<e&&t>=0,String.format("unexpceted index {0}",t)),Ext.isEmpty(this.cursor)||this.getAt(this.cursor).collapse(),this.getAt(t).expand();var i=this.cursor;this.cursor=t,this.updateElementPosition(i)},updateElementPosition:function(t){this.beforeEffect(t),this.delayAfterEffect()},beforeEffect:function(t){var e=this.getAt(this.cursor).getPosition(!0)[0],i=this.getAt(t).getPosition(!0)[0];if(this.items.each(function(t,e){t.removeClass(["mask-element"]),this._enableAutoRotateAndTransition&&t.addClass(["transition-effect"]),e!=this.cursor&&t.addClass(["mask-element"])},this),e>0){var o=e-i,n=1+Math.floor((o-this.width_expand)/this.width_collapse),a=n*this.width_collapse;this.items.each(function(t,o){var n=t.getPosition(!0)[0],S=a;i<n&&n<=e&&(S+=this.width_expand-this.width_collapse),t.setPosition(n-S,0)},this)}else this.items.each(function(e,i){var o=e.getPosition(!0)[0],n=this.width_collapse;i===t&&(n+=this.width_expand-this.width_collapse),e.setPosition(o+n,0)},this)},afterEffect:function(){this.items.each(function(t,e){t.removeClass(["transition-effect"]);var i,o=e-this.cursor;o<-2?o=this.allElement.getCount()+o:o>this.allElement.getCount()-3&&(o-=this.allElement.getCount()),t.getEl().setStyle("z-index",o+3),0===o?t.setPosition(this.shift_offset,0):-1===o||-2===o?(i=o*this.width_collapse+this.shift_offset,t.setPosition(i,0),t.addClass("mask-element")):(i=this.width_expand+(o-1)*this.width_collapse+this.shift_offset,t.setPosition(i,0),t.addClass("mask-element"))},this)},delayAfterEffect:function(){this.delayAffectEffectTask=this.delayAffectEffectTask||new Ext.util.DelayedTask(this.afterEffect,this),this.delayAffectEffectTask.cancel(),this.delayAffectEffectTask.delay(1e3)},getVideoData:function(t){return{id:this.getVideoID(t),type:this.getVideoType(),pathTitle:this.getVideoTitle(t),mapper_id:this.getVideoMapperID(t),library_id:this.getLibraryID(t)}},getLibraryID:function(t){return t.get("library_id")},getVideoType:function(){return SYNO.SDS.VideoStation2.Constant.MOVIE},getVideoID:function(t){return t.get("id")},getVideoMapperID:function(t){return t.get("mapper_id")},getVideoTitle:function(t){return t.get("title")},intoVideoDatail:function(t,e,i){var o=this.getStore().getRange().map(function(t){return this.getVideoData(t)},this),n={videolist:o},a=String.format("{0}-{1}",this.getVideoType(),this.getLibraryID(i));SYNO.SDS.VideoStation2.Controller.switchLibraryTemporary(a),SYNO.SDS.VideoStation2.Controller.intoVideoDetail(this.getVideoData(i),new SYNO.SDS.VideoStation2.VideoListProxy(n))},selectNext:function(){if(!Ext.isEmpty(this.cursor)&&0!==this.allElement.getCount()){var t=(this.cursor+1)%this.allElement.getCount();this.select(t)}},getAutoRotateTask:function(){return this._autoRotateTask=this._autoRotateTask||this.addTask({interval:8e3,scope:this,run:this.selectNext}),this._autoRotateTask},loadImage:function(){this.allElement.each(function(t){var e=Ext.fly(t).select(".loading");Ext.each(e.elements,this.loader.appendJob,this.loader)},this)}}),Ext.define("SYNO.SDS.VideoStation2.ViewHomePage",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){var e={cls:"view-home-page",autoFlexcroll:!0,layout:"anchor",items:[this.rotateSlidingView=new SYNO.SDS.VideoStation2.RotateSlidingView,this.librarySlidingView=new SYNO.SDS.VideoStation2.ViewHomePage.LibrarySlidingView]};this.callParent([Ext.apply(e,t)]),this.relayEvents(this.librarySlidingView,[SYNO.SDS.VideoStation2.ViewHomePage.LibrarySlidingView.EVENT_SLIDINGVIEW_TOGGLE,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO]),this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.ViewHomePage.LibrarySlidingView.EVENT_SLIDINGVIEW_TOGGLE)}}),Ext.define("SYNO.SDS.VideoStation2.ViewHomePage.LibrarySlidingView",{statics:{EVENT_SLIDINGVIEW_TOGGLE:"slidingviewtoggle"},extend:"SYNO.ux.Panel",constructor:function(t){this.callParent([this.fillConfig(t)]),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING)},fillConfig:function(t){var e={cls:"library-sliding-view",layout:"anchor",items:[],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};return Ext.apply(e,t),e},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.loadView,this),this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadView,this),this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.loadView,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadAllLibrary,this),this.loadView()},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.loadView,this),this.mun(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.loadView,this),this.mun(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,this.loadView,this),this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH,this.loadAllLibrary,this),this.items.each(function(t){t.onDeactivate()},this)},loadView:function(){this.getStore().load()},getStore:function(){return this._store=this._store||new SYNO.API.Store({proxy:new SYNO.API.Proxy({api:"SYNO.VideoStation2.AcrossLibrary",method:"list_library",version:1,listeners:{scope:this,beforeload:SYNO.SDS.VideoStation2.Util.onProxyBeforeLoad}}),api:"SYNO.VideoStation2.AcrossLibrary",method:"list_library",version:1,baseParams:{policy:"recently_added"},reader:new Ext.data.JsonReader({id:"id",root:"library",totalProperty:"total",fields:["id","is_public","title","type","visible"]}),listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore,exception:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,this)}}}),this._store},onBeforeLoadStore:function(){this.removeAll(!0),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,this)},onAfterLoadStore:function(t,e){if(this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),!this.hidden){if(0===t.getCount())return void this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO,this);Ext.each(e,function(t){if(!1===t.get("visible"))return!0;var e=t.get("type"),i=t.get("id"),o={libraryType:e,libraryId:i,videoType:e,title:t.get("title"),iconCls:0===i?e:"library"},n=new SYNO.SDS.VideoStation2.HomePageSlidingView({decorator:o});this.mon(n,SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_SHOWHIDE_TOGGLE,function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewHomePage.LibrarySlidingView.EVENT_SLIDINGVIEW_TOGGLE)},this,{buffer:100}),this.add(n)},this),this.doLayout(),this.loadAllLibrary()}},loadAllLibrary:function(){this.items.each(function(t){t.onActivate()},this)}}),Ext.define("SYNO.SDS.VideoStation2.HomePageSlidingView",{extend:"SYNO.SDS.VideoStation2.RowSlidingDataView",setupView:function(){this.total=0,this.callParent(arguments)},isPoster:function(){return this.libraryType===SYNO.SDS.VideoStation2.Constant.MOVIE||this.libraryType===SYNO.SDS.VideoStation2.Constant.TVSHOW},onTitleClick:function(){var t=String.format("{0}-{1}",this.libraryType,this.libraryId);SYNO.SDS.VideoStation2.Controller.switchLibrary(t)},getTotal:function(){return this.total},getDataViewDecorator:function(t){var e=this;return Ext.apply(t,{getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores[e.libraryType]({listeners:{scope:e,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore}}),this._store},onBeforeLoadStore:function(t,e){var i=e.params;Ext.apply(i,SYNO.SDS.VideoStation2.Sort.get().getSortOption()),Ext.apply(i,SYNO.SDS.VideoStation2.Filter.get().getKeywordOption()),Ext.apply(i,{library_id:this.libraryId}),t.lastParams=i},onAfterLoadStore:function(t){this.total=t.getTotalCount(),!1!==this.fireEvent(SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_AFTER_LOAD)&&this.fireEvent(SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_ACTIVE_NEARBY)},getImageURL:function(t){return SYNO.SDS.VideoStation2.Util.getImageURLByRecord(t,e.libraryType)}}),t},getVideoListProxySetting:function(t){var e=function(e){return e.map(function(e){return t.getVideoData(e)})};return{baseParams:SYNO.SDS.VideoStation2.VideoListProxy.copyStoreParams(t.getStore().lastParams),totalCount:t.getStore().getTotalCount(),toVideos:e,
videolist:e(t.getStore().getRange())}}}),Ext.define("SYNO.SDS.VideoStation2.ViewPlaylist",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this.dataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"Playlist",listeners:{scope:this,click:this.onViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn,resize:this.onResizeEvent}});var e={cls:"view-playlist",layout:"fit",items:[this.dataview],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING)},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),SYNO.SDS.VideoStation2.PlaylistController.loadPlaylists(),this.callParent(arguments)},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,this.onPlaylistLoaded,this),this.callParent(arguments)},onPlaylistLoaded:function(){this.dataview.getDataviewStore().loadData(SYNO.SDS.VideoStation2.Playlist.get().getCurrentPlaylists()),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},onViewItemClick:function(t,e,i,o){var n=t.getRecord(i);SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.PLAYLIST,n.get("id"),n.get("playlist_title"))},onResizeEvent:function(t,e,i,o,n,a){this.updatePlaylistMargin(e)},updatePlaylistMargin:function(t){SYNO.SDS.VideoStation2.Util.Styles.updateMarginBySelector(".syno-vs2-win .view-playlist .thumb-dataview .thumb-wrap.square","margin-right",t,204,10)}}),Ext.define("SYNO.SDS.VideoStation2.ViewTimeLine",{statics:{EVENT_SLIDINGVIEW_TOGGLE:"slidingviewtoggle",EVENT_RAND_LOAD_BACKGROUND_IMAGE:"randloadbackgroundimage",ELEMENT_HEIGHT:236,MIN_NUMBER_OF_GROUP:5,VISIBLE_ITEM_BUFFER:3},extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this.viewLoader=new SYNO.SDS.VideoStation2.ViewTimeLine.Loader({});var e={cls:"view-time-line",autoFlexcroll:!0,layout:"anchor",items:[],listeners:{scope:this,buffer:200,flexcroll:this.onFlexcroll}};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.TimeLine.get(),SYNO.SDS.VideoStation2.TimeLine.EVENT_ON_MENU_CLICK,this.onMenuClickScrollTo,this),this.mon(this,SYNO.SDS.VideoStation2.ViewTimeLine.EVENT_RAND_LOAD_BACKGROUND_IMAGE,this.loadBackgroundImage,this),this.updateScrollBarEventNames.push(SYNO.SDS.VideoStation2.ViewTimeLine.EVENT_SLIDINGVIEW_TOGGLE)},onActivate:function(){this.loadView()},onDeactivate:function(){this.viewLoader.clear()},loadView:function(){this.getStore().load()},getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.time_line({listeners:{scope:this,beforeload:this.onBeforeLoadStore,load:this.onAfterLoadStore}}),this._store},onBeforeLoadStore:function(t,e){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,this),this.removeAll(!0);var i=e.params;Ext.apply(i,{library_id:SYNO.SDS.VideoStation2.Library.get().getCurrentID()})},onAfterLoadStore:function(t,e){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),SYNO.SDS.VideoStation2.TimeLine.get().loadTimeLine(e.map(function(t){return t.get("date")}));var i=[];Ext.each(e,function(t){var e=t.get("date"),o=SYNO.SDS.VideoStation2.Util.parseLazyDate(e),n=t.get("id"),a=i[i.length-1];Ext.isDefined(a)&&a.ids.length<SYNO.SDS.VideoStation2.ViewTimeLine.MIN_NUMBER_OF_GROUP&&a.from_time.year===o.year&&a.from_time.month===o.month?(a.dates.push(e),a.ids=a.ids.concat(n)):i.push({dates:[e],ids:n,from_time:o})},this),Ext.each(i,function(t,e){var i=t.dates.reverse().map(function(t){return SYNO.SDS.DateTimeFormatter?SYNO.SDS.DateTimeFormatter(Date.parseDate(t,"Y-m-d"),{type:"date"}):t.split("-").join("/")}),o=i.length>1?String.format("{0} - {1}",i[0],i.pop()):i[0],n={decorator:{libraryType:SYNO.SDS.VideoStation2.Constant.HOME_VIDEO,libraryId:SYNO.SDS.VideoStation2.Library.get().getCurrentID(),videoType:SYNO.SDS.VideoStation2.Constant.HOME_VIDEO,title:o,hiddenIcon:!0,expandPagingBtn:!0},ids:t.ids.reverse(),from_time:t.from_time},a=new SYNO.SDS.VideoStation2.TimeLineSlidingView(n);this.mon(a,SYNO.SDS.VideoStation2.RowSlidingDataView.EVENT_SHOWHIDE_TOGGLE,function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewTimeLine.EVENT_SLIDINGVIEW_TOGGLE)},this,{buffer:100}),0===e&&this.mon(a.getBaseStore(),"load",function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewTimeLine.EVENT_RAND_LOAD_BACKGROUND_IMAGE,a)},this,{single:!0}),this.add(a)},this),this.doLayout(),this.items.each(function(t){this.viewLoader.appendJob(t)},this)},onMenuClickScrollTo:function(t){var e=SYNO.SDS.VideoStation2.Util.parseLazyDate(t),i=e.year,o=e.month,n=-1!==t.indexOf("-");this.items.each(function(t){var e=t.getYear(),a=t.getMonth();if(i===e&&(!n||o===a))return this.fireEvent(SYNO.SDS.VideoStation2.ViewTimeLine.EVENT_RAND_LOAD_BACKGROUND_IMAGE,t),this.fleXcrollTo(t.getEl()),!1},this)},loadBackgroundImage:function(t){var e=t.getBaseStore(),i=e.getCount();if(0!==i){var o=e.getAt(Math.min(Math.floor(Math.random()*i),i-1)),n=SYNO.SDS.VideoStation2.Util.getImageURLByRecord(o,SYNO.SDS.VideoStation2.Constant.HOME_VIDEO);SYNO.SDS.VideoStation2.Controller.setBackdrop(n)}},onFlexcroll:function(t,e){var i=this.getHeight();if(0!==i){var o=e.scrollTop,n=o+i,a=Math.max(Math.floor(o/SYNO.SDS.VideoStation2.ViewTimeLine.ELEMENT_HEIGHT)-SYNO.SDS.VideoStation2.ViewTimeLine.VISIBLE_ITEM_BUFFER,0),S=Math.min(Math.ceil(n/SYNO.SDS.VideoStation2.ViewTimeLine.ELEMENT_HEIGHT)+SYNO.SDS.VideoStation2.ViewTimeLine.VISIBLE_ITEM_BUFFER,this.items.length-1);this.items.each(function(t,e){var i=a<=e&&e<=S,o=t.baseStoreLoaded;t.slideview[i?"show":"hide"](),!o&&i&&this.viewLoader.insertJob(t)},this)}}}),Ext.define("SYNO.SDS.VideoStation2.TimeLineSlidingView",{extend:"SYNO.SDS.VideoStation2.PreloadSlidingView",getPagingIDS:function(t,e){return this.ids.slice(t,t+e)},getYear:function(){return this.from_time.year},getMonth:function(){return this.from_time.month},getBaseStore:function(){return this._baseStore=this._baseStore||new SYNO.SDS.VideoStation2.Stores.home_video({synoMethod:"getinfo",listeners:{scope:this,beforeload:this.onBeforeLoadBaseStore,load:this.onAfterLoadBaseStore}}),this._baseStore},getDataViewDecorator:function(t){var e=this;return Ext.apply(t,{getDescription:function(t){if(!Ext.isString(t.record_date)||Ext.isEmpty(t.record_date)||"0"===t.record_date)return"";var e;return SYNO.SDS.DateTimeFormatter?(e=Date.parseDate(t.record_date,"Y-m-d H:i:s"),String.format("{0} {1}",SYNO.SDS.DateTimeFormatter(e,{type:"monthdate"}),SYNO.SDS.DateTimeFormatter(e,{type:"time"}))):(e=SYNO.SDS.VideoStation2.Util.parseLazyDate(t.record_date),String.format("{0}/{1} {2}:{3}",e.month,e.day,("00"+e.hour).slice(-2),("00"+e.minute).slice(-2)))},onActionPlayClick:function(t,i,o){var n=function(){this.getBaseStore().load()};this.onActionPlayClickImp(t,i,o,n.bind(e))}}),this.callParent([t])},setupView:function(){this.callParent(arguments),this.show()},getBaseStoreParams:function(){return{library_id:[this.libraryId],id:this.ids}},isPoster:function(){return!1},getVideoListProxySetting:function(t){return{videolist:function(e){return e.map(function(e){return t.getVideoData(e)})}(this.getBaseStore().getRange())}}}),Ext.define("SYNO.SDS.VideoStation2.ViewTimeLine.Loader",{extend:"Ext.Component",MAX_CONCURRENT:3,jobs:null,preemptJobs:null,constructor:function(){this.callParent(arguments),this.jobs=[],this.preemptJobs=[],this.delayedPreemptJob=new Ext.util.DelayedTask(this.preemptJob,this),this.running=0},clear:function(){this.jobs=[],this.preemptJobs=[],this.running=0},appendJob:function(t){-1===this.jobs.indexOf(t)&&(this.jobs.push(t),this.dispatch())},insertJob:function(t){-1===this.preemptJobs.indexOf(t)&&(this.preemptJobs.push(t),this.delayedPreemptJob.delay(100))},preemptJob:function(){Ext.each(this.preemptJobs,function(t){this.jobs.remove(t)},this),this.jobs.unshift.apply(this.jobs,this.preemptJobs),this.preemptJobs=[],this.dispatch()},dispatch:function(){for(;this.MAX_CONCURRENT>this.running;){var t=this.jobs.shift();if(!t)break;!0!==t.baseStoreLoaded&&(t.baseStoreLoaded=!0,this.running++,this.mon(t.getBaseStore(),"load",this.finalizedViewLoad,this,{single:!0}),this.mon(t.getBaseStore(),"exception",this.finalizedViewLoad,this,{single:!0}),t.onActivate())}},finalizedViewLoad:function(){this.running--,this.dispatch.defer(0,this)}}),Ext.define("SYNO.SDS.VideoStation2.ViewPoster",{extend:"SYNO.ux.Panel",constructor:function(t){this.callParent([this.fillConfig(t)]),this.items.each(function(t){this.relayEvents(t,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_NOVIDEO])},this)},fillConfig:function(t){this.dataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"Common",listeners:{scope:this,click:this.onViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn}},{resizeEvantCallback:{scope:this,fn:this.onDataviewResizeEvent}}),this.folderDataView=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"Byfolder",listeners:{scope:this,click:this.onFolderViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn}},{resizeEvantCallback:{scope:this,fn:this.onSquareDataviewResizeEvent}}),this.byChannelDataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"RecordingSpecific",listeners:{scope:this,click:this.onChannelViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,beforeselect:function(){return!1},contextmenu:Ext.emptyFn}},{decoration:{specialTVRecordType:SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL},resizeEvantCallback:{scope:this,fn:this.onSquareDataviewResizeEvent}}),this.byProgramDataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"RecordingSpecific",listeners:{scope:this,click:this.onProgramViewItemClick,dblclick:Ext.emptyFn,beforeselect:function(){return!1},contextmenu:Ext.emptyFn}},{decoration:{specialTVRecordType:SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM},resizeEvantCallback:{scope:this,fn:this.onSquareDataviewResizeEvent}}),this.playlistPosterDataview=new SYNO.SDS.VideoStation2.SwitchableDataView({decorator:"PlaylistPoster",listeners:{scope:this,click:this.onPlaylistViewItemClick,dblclick:Ext.emptyFn,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn}},{resizeEvantCallback:{scope:this,fn:this.onDataviewResizeEvent}}),this.byTimeLineDataview=new SYNO.SDS.VideoStation2.ViewTimeLine({});var e={layout:"card",cls:"view-poster-panel",items:[this.dataview,this.folderDataView,this.byChannelDataview,this.byProgramDataview,this.playlistPosterDataview,this.byTimeLineDataview],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};return Ext.apply(e,t),e},onViewItemClick:function(t,e,i,o){var n=t.getRecord(i),a=function(e){return e.map(function(e){return t.getVideoData(e)})},S={baseParams:SYNO.SDS.VideoStation2.VideoListProxy.copyStoreParams(t.getStore().lastOptions.params),totalCount:t.getStore().getTotalCount(),toVideos:a,videolist:a(t.getStore().getRange())};switch(SYNO.SDS.VideoStation2.Library.get().getCurrentType()){case SYNO.SDS.VideoStation2.Constant.TVSHOW:SYNO.SDS.VideoStation2.Controller.intoTVShow(n.data);break;default:SYNO.SDS.VideoStation2.Controller.intoVideoDetail(t.getVideoData(n),new SYNO.SDS.VideoStation2.VideoListProxy(S))}},onPlaylistViewItemClick:function(t,e,i,o){var n=t.getRecord(i),a=function(e){return e.map(function(e){return t.getVideoData(e)})},S={baseParams:SYNO.SDS.VideoStation2.VideoListProxy.copyStoreParams(t.getStore().lastOptions.params),totalCount:t.getStore().getTotalCount(),toVideos:a,videolist:a(t.getStore().getRange())};SYNO.SDS.VideoStation2.Controller.intoVideoDetail(t.getVideoData(n),new SYNO.SDS.VideoStation2.VideoListProxy(S))},onFolderViewItemClick:function(t,e,i,o){var n=t.getRecord(i);if(n.get("type")===SYNO.SDS.VideoStation2.Constant.FOLDER)return void SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.FOLDER,n.get("id"),n.get("title"));if((n.get("additional")||{}).metadata){var a=function(e){return e.map(function(e){if("file"===e.get("type")&&(e.get("additional")||{}).metadata)return t.getVideoData(e)}).filter(function(t){return Ext.isObject(t)})},S={baseParams:SYNO.SDS.VideoStation2.VideoListProxy.copyStoreParams(t.getStore().lastOptions.params),totalCount:t.getStore().getTotalCount(),toVideos:a,videolist:a(t.getStore().getRange())};SYNO.SDS.VideoStation2.Controller.intoVideoDetail(t.getVideoData(n),new SYNO.SDS.VideoStation2.VideoListProxy(S))}},onChannelViewItemClick:function(t,e,i,o){var n=t.getRecord(i);SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.CHANNEL,null,n.get("title"))},onProgramViewItemClick:function(t,e,i,o){var n=t.getRecord(i);SYNO.SDS.VideoStation2.Controller.intoPosterView(SYNO.SDS.VideoStation2.Constant.PROGRAM,null,n.get("title"))},onCategoryChange:function(t,e){if(SYNO.SDS.VideoStation2.Category.isSpecialCategory(t)||SYNO.SDS.VideoStation2.Category.isSpecialCategory(e))return void this.activateCurrentDataView();this.onSortChanged()},onSortChanged:function(){this.dataview!==this.layout.activeItem&&this.byChannelDataview!==this.layout.activeItem&&this.byProgramDataview!==this.layout.activeItem&&this.playlistPosterDataview!==this.layout.activeItem||this.layout.activeItem.resetPaging()},onFilterChange:function(){this.dataview===this.layout.activeItem&&this.dataview.resetPaging()},onRecordingSpecificSet:function(){this.dataview!==this.layout.activeItem&&this.activateCurrentDataView()},onRecordingSpecificClear:function(){this.dataview===this.layout.activeItem&&this.activateCurrentDataView()},activateCurrentDataView:function(){var t,e=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory(),i=SYNO.SDS.VideoStation2.RecordingSpecific.get().isSet();t=SYNO.SDS.VideoStation2.Constant.PLAYLIST===SYNO.SDS.VideoStation2.Library.get().getCurrentType()?this.playlistPosterDataview:SYNO.SDS.VideoStation2.Category.CATEGORY_FOLDER===e?this.folderDataView:SYNO.SDS.VideoStation2.Category.CATEGORY_BY_CHANNEL===e?i?this.dataview:this.byChannelDataview:SYNO.SDS.VideoStation2.Category.CATEGORY_BY_PROGRAM===e?i?this.dataview:this.byProgramDataview:SYNO.SDS.VideoStation2.Category.CATEGORY_TIME_LINE===e?this.byTimeLineDataview:this.dataview;var o=this.layout.activeItem;SYNO.Assert(t,String.format("unexpceted dataView in view_poster")),o!==t?this.layout.setActiveItem(t):o&&o.fireEvent("activate")},clearActiveItem:function(){var t=this.layout.activeItem;if(t){if(t.hide(),!t.hidden)return!1;t.fireEvent("deactivate",t),this.layout.activeItem=null}},onActivate:function(){this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChange,this),this.mon(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.onSortChanged,this),this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this),this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET,this.onRecordingSpecificSet,this),this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR,this.onRecordingSpecificClear,this),this.activateCurrentDataView(),SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.TVSHOW?this.dataview.items.each(function(t){t.enableSelectMode=!1,t.hideAction()}):this.dataview.items.each(function(t){t.enableSelectMode=!0,t.showAction()})},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onCategoryChange,this),this.mun(SYNO.SDS.VideoStation2.Sort.get(),SYNO.SDS.VideoStation2.Sort.EVENT_SORT_CHANGED,this.onSortChanged,this),this.mun(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this),this.mun(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET,this.onRecordingSpecificSet,this),this.mun(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR,this.onRecordingSpecificClear,this),this.clearActiveItem()},onDataviewResizeEvent:function(t,e,i,o,n,a){this.updatePosterMargin(e),this.updateLandscapeMargin(e)},onSquareDataviewResizeEvent:function(t,e,i,o,n,a){this.updatePosterMargin(e),this.updateLandscapeMargin(e),this.updateSquareMargin(e)},updatePosterMargin:function(t){SYNO.SDS.VideoStation2.Util.Styles.updateMarginBySelector(".syno-vs2-win .view-poster-panel .thumb-dataview .thumb-wrap.poster","margin-right",t,120,10)},updateLandscapeMargin:function(t){SYNO.SDS.VideoStation2.Util.Styles.updateMarginBySelector(".syno-vs2-win .view-poster-panel .thumb-dataview .thumb-wrap.landscape","margin-right",t,180,10)},updateSquareMargin:function(t){SYNO.SDS.VideoStation2.Util.Styles.updateMarginBySelector(".syno-vs2-win .view-poster-panel .thumb-dataview .thumb-wrap.square","margin-right",t,204,10)}}),Ext.define("SYNO.SDS.VideoStation2.ViewTVShow",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this.detail_area=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea,this.season_area=new SYNO.SDS.VideoStation2.ViewTVShow.SeasonArea({region:"center"});var e={cls:"view-tvshow",layout:"border",items:[this.detail_area,this.season_area],listeners:{scope:this,resize:this.adjustAreaSize,afterlayout:this.onAfterLayout}};this.callParent([Ext.apply(e,t)]),this.relayEvents(this.season_area,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED]),this.mon(this.detail_area,"afterrender",this.onDetailAreaAfterRender,this),this.mon(this.season_area,"flexcroll",this.onDataviewScrolled,this),this.mon(this.detail_area.season_bar,SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar.EVENT_SEASON_CLICK,this.onSeasonClick,this)},adjustAreaSize:function(t,e,i){e=this.getInnerWidth(),e>56&&(e-=56),this.detail_area.setWidth(e),this.season_area.getAllDataViews().each(function(t){t.getEl().setStyle("padding-top",this.detail_area.getHeight()+"px")},this),this.updateEpisodeMargin(e)},onAfterLayout:function(t){var e=t.getEl().query(".flexcrollactive")[0];this.adjustDetailAreaAlign(e)},onDataviewScrolled:function(t){var e=t.getEl().dom;this.adjustDetailAreaAlign(e,!0)},adjustDetailAreaAlign:function(t,e){if(t&&t.fleXdata&&(!1!==t.fleXdata.scrollPosition[1][0]||e)){var i=this.getEl();if(i){var o=t.fleXdata.scrollPosition[1][0]||0,n=Ext.max([0,this.detail_area.getHeight()-this.detail_area.getBottomScrollMargin()]),a=o>n;this.detail_area[a?"addClass":"removeClass"]("block-background");var S=a?n:o;this.detail_area.getEl().alignTo(i,"tl-tl",[i.getPadding("l"),i.getPadding("t")-S])}}},onDetailAreaMouseWheel:function(t){this.season_area.updateDataviewScroll(t)},onDetailAreaAfterRender:function(){this.mon(this.detail_area.getEl(),"mousewheel",this.onDetailAreaMouseWheel,this)},onSeasonClick:function(t){var e=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this.season_area.prepareSeason(e,t)},onActivate:function(){this.adjustAreaSize(),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this),this.refreshInfo()},onDeactivate:function(){this.mun(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_REFRESH_INFO,this.refreshInfo,this)},loadBackdrop:function(){var t=SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow(),e=SYNO.SDS.VideoStation2.Util.getBackdropURL({mapper_id:t.mapper_id,mtime:t.additional&&t.additional.backdrop_mtime||""});SYNO.SDS.VideoStation2.Controller.setBackdrop(e)},refreshInfo:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),SYNO.SDS.VideoStation2.OP.get().getInfo({id:[SYNO.SDS.VideoStation2.TVShow.get().getCurrentID()],additional:["poster_mtime","summary","backdrop_mtime"]},{scope:this,success:this.onInfoLoad,failure:this.onInfoLoadFail},SYNO.SDS.VideoStation2.Constant.TVSHOW)},onInfoLoad:function(t,e,i){if(Ext.isEmpty(t.tvshow))return void this.onInfoLoadFail();SYNO.SDS.VideoStation2.TVShow.get().updateTVShow(t.tvshow[0]),SYNO.SDS.VideoStation2.Controller.updatePath(),this.loadBackdrop(),this.detail_area.reloadInfo(),this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED)},onInfoLoadFail:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),SYNO.SDS.VideoStation2.Controller.goback()},updateEpisodeMargin:function(t){SYNO.SDS.VideoStation2.Util.Styles.updateMarginBySelector(".syno-vs2-win .view-tvshow .thumb-dataview .thumb-wrap.landscape","margin-right",t,180,7)}}),Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this.image=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Image({region:"west"}),this.info_area=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.InfoArea({region:"center"}),this.season_bar=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar({region:"south"});var e={cls:"detail-area",floating:!0,shadow:!1,layout:"border",height:480,items:[this.image,this.info_area,this.season_bar]};this.callParent([Ext.apply(e,t)])},getBottomScrollMargin:function(){if(!this.season_bar.getEl())return 0;var t=parseInt(this.season_bar.getEl().getMargins("b"),10);return this.season_bar.getHeight()+t},onActivate:function(){this.image.loadImage(),this.season_bar.loadSeasons()},reloadInfo:function(){this.image.loadImage(),this.info_area.loadSummary()}}),Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Image",{extend:"Ext.Container",constructor:function(t){var e={cls:"image",margins:"0 30 0 0"};this.callParent([Ext.apply(e,t)])},loadImage:function(){var t=SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow(),e=SYNO.SDS.VideoStation2.Util.getImageURL({type:SYNO.SDS.VideoStation2.Constant.TVSHOW,id:t.id,mtime:t.additional&&t.additional.poster_mtime||""});this.getEl().setStyle("background-image",String.format("url({0})",e))}}),Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.InfoArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this.dataview=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Dataview;var e={cls:"info-area",autoFlexcroll:!0,height:50,items:[this.dataview]};this.callParent([Ext.apply(e,t)])},loadSummary:function(){this.dataview.loadSummary()}}),Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.Dataview",{extend:"Ext.DataView",constructor:function(t){var e={tpl:this.getTpl(),cls:"tvshow-dataview",store:this.getStore(),singleSelect:!0,listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate}};this.callParent([Ext.apply(e,t)])},onActivate:function(){this.bindStore(this.getStore()),this.loadSummary()},onDeactivate:function(){this.bindStore(null)},loadSummary:function(){this.getStore().loadData([SYNO.SDS.VideoStation2.TVShow.get().getCurrentTVShow()])},getStore:function(){return this.store=this.store||new Ext.data.JsonStore({id:"id",fields:["id","title","mapper_id","metadata_locked","original_available","sort_title","additional"]}),this.store},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="title">{values.title:htmlEncode}</div>','<div class="info tag">{[_VST("original_available", "title")]}: {[this.getFormatedDate(values)]}</div>',String.format('<div class="summary-title">{0}</div>',Ext.util.Format.htmlEncode(_VST("summary","title"))),'<div class="summary">{values.additional.summary:htmlEncode}</div>',"</tpl>",'<div class="x-clear"></div>',{getFormatedDate:function(t){var e,i=t.original_available;return SYNO.SDS.DateTimeFormatter&&(e=Date.parseDate(i,"Y-m-d"))&&(i=SYNO.SDS.DateTimeFormatter(e,{type:"date"})),i}})}}),Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar",{statics:{EVENT_SEASON_CLICK:"seasonclick"},extend:"Ext.Container",constructor:function(t){this.season_list=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList,this.season_action=new SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction({region:"east"});var e={cls:"season-bar",layout:"border",margins:"20 0 10 0",listeners:{scope:this,afterlayout:this.fixSelectPosition},items:[{xtype:"tbtext",text:_VST("season","season_title"),cls:"season-label",region:"west",margins:"0 6 0 18"},{xtype:"container",cls:"season-viewport",region:"center",items:[this.season_list]},this.season_action]};this.callParent([Ext.apply(e,t)]),this.mon(this.season_action,SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK,this.onScrollBtnClick,this),this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_AVAIL_SEASONS_LOADED,this.loadSeasons,this),this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this)},loadSeasons:function(){var t=this.season_list.getEl(),e=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SELECTOR_WIDTH,i=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SEASON_MARGIN;t&&t.setLeft(-e),this.season_list.removeAll();var o=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();if(o){this.season_select=new SYNO.SDS.VideoStation2.ActionButton({cls:"season-select",x:e+i/2,floating:!0}),this.season_list.add(this.season_select),o.each(function(t){this.season_list.add(new SYNO.SDS.VideoStation2.ActionButton({cls:"season-item",text:t||_VST("season","specials"),itemId:t.toString(),margins:"10 16 10 16",enableToggle:!0,toggleGroup:"season-item",handler:this.onSeasonClick,scope:this}))},this),this.season_list.doLayout();var n=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();Ext.isNumber(n)?(this.scrollToButton(n,!0),this.moveSelectToButton(n)):this.scrollToButton(o[0])}},moveSelectToButton:function(t){if(Ext.isNumber(t)){var e=this.season_list.getComponent(t.toString());if(e){e.toggle(!0);var i=e.getEl().getOffsetsTo(this.season_list.getEl()),o=this.season_select.getEl();o.setLeftTop.apply(o,i),this.season_select.setWidth(e.getWidth())}}},scrollToButton:function(t,e){if(Ext.isNumber(t)){if(e){var i=this.getMaxVisibleSeasonCount(),o=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();if(i>=o.length)t=o[0];else{var n=Math.floor(o.indexOf(t)-i/2);t=o[n>=0?n:0]}}var a=this.season_list.getComponent(t.toString()),S=this.season_list.getEl(),s=a.getEl(),r=s.getOffsetsTo(S)[0],l=a.margins.left;S.setLeft(-(r-l)),this.currentScroll=t,this.season_action.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_CHANGED,this.currentScroll)}},fixSelectPosition:function(){var t=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this.moveSelectToButton(t)},getMaxVisibleSeasonCount:function(){var t=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SELECTOR_WIDTH,e=SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList.SEASON_MARGIN,i=this.season_list.ownerCt.getWidth();return Math.floor(i/(t+e))},onSeasonChanged:function(){var t=SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason();this.moveSelectToButton(t)},onSeasonClick:function(t){t.toggle(!1);var e=parseInt(t.itemId,10);SYNO.SDS.VideoStation2.TVShow.get().getCurrentSeason()!==e?this.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonBar.EVENT_SEASON_CLICK,parseInt(t.itemId,10)):t.toggle(!0)},onScrollBtnClick:function(t){var e=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons(),i=e.indexOf(this.currentScroll)+t;i<=-1||i>=e.length||this.scrollToButton(e[i])}}),Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonList",{statics:{SELECTOR_WIDTH:28,SEASON_MARGIN:32},extend:"Ext.Container",constructor:function(t){var e={layout:"hbox",cls:"season-list",layoutConfig:{align:"top"},items:[]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction",{statics:{EVENT_SCROLL_BTN_CLICK:"scrollbtnclick",EVENT_SCROLL_CHANGED:"scrollchanged"},extend:"Ext.Container",constructor:function(t){var e={layout:"hbox",margins:"0 4 0 0",layoutConfig:{align:"top"},cls:"season-action",width:62,items:[new SYNO.SDS.VideoStation2.ActionButton({cls:"season-item back",margins:"10 7 10 0",handler:this.scrollLeft,scope:this}),new SYNO.SDS.VideoStation2.ActionButton({cls:"season-item next",margins:"10 0 10 7",handler:this.scrollRight,scope:this})]};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK),this.addEvents(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_CHANGED),this.mon(this,SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_CHANGED,this.onScrollChange,this)},scrollLeft:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK,-1)},scrollRight:function(){this.fireEvent(SYNO.SDS.VideoStation2.ViewTVShow.DetailArea.SeasonAction.EVENT_SCROLL_BTN_CLICK,1)},onScrollChange:function(t){var e=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();this.items.items[0].setDisabled(t===e[0]),this.items.items[1].setDisabled(t===e[e.length-1])}}),Ext.define("SYNO.SDS.VideoStation2.ViewTVShow.SeasonArea",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",constructor:function(t){this.callParent([this.fillConfig(t)]),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),this.addEvents(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.relayEvents(this.slideview,[SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING,SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED])},fillConfig:function(t){this.slideview=new SYNO.SDS.VideoStation2.SlidableDataView({getView:this.getSwitchableView.createDelegate(this),dataViewMargin:20});var e={layout:"fit",cls:"view-tvshow-panel",items:[this.slideview]};return Ext.apply(e,t),e},updateDataviewScroll:function(t){var e=this.slideview.getCenterView().getActiveView(),i=null;if(e&&(i=e.getEl())){var o=i.hasClass("flexcrollactive")?i.dom:i.query(".flexcrollactive")[0];o&&o.fleXcroll.scrollContent(0,-120*t.getWheelDelta())}},onViewItemClick:function(t,e,i,o){var n=t.getRecord(i),a=t.getStore().data.items.map(function(t){return this.getVideoData(t)},t),S={videolist:a};SYNO.SDS.VideoStation2.Controller.intoVideoDetail(t.getVideoData(n),new SYNO.SDS.VideoStation2.VideoListProxy(S))},onFlexcroll:function(t){this.slideview.getCenterView().getActiveView()===t&&this.fireEvent("flexcroll",t)},onSeasonChanged:function(t,e){if(null===t)return void this.prepareSeason(t,e);var i=this.slideview.getCenterView().getActiveView(),o=null,n=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();n.indexOf(e)<n.indexOf(t)?(o=this.slideview.getLeftView().getActiveView(),this.slideview.getLeftView().filterStore(),this.syncScroll(i,o),this.slideview.intoLeft(!0)):(o=this.slideview.getRightView().getActiveView(),this.slideview.getRightView().filterStore(),this.syncScroll(i,o),this.slideview.intoRight(!0)),this.slideview.getCenterView().getActiveView().onVideoSelectionChange()},onSeasonPrepared:function(){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADED),SYNO.SDS.VideoStation2.TVShow.get().selectSeason(this.preparingSeason),this.preparingStore&&(this.mun(this.preparingStore,"load",this.onSeasonPrepared,this),this.preparingStore=null)},syncScroll:function(t,e){var i=t.getEl().dom,o=e.getEl().dom;o.fleXcroll&&o.fleXcroll.setScrollPos(0,i.fleXdata.scrollPosition[1][0]||0,!1)},prepareSeason:function(t,e){this.fireEvent(SYNO.SDS.VideoStation2.Constant.EVENT.VIEW_LOADING),this.preparingStore&&(this.mun(this.preparingStore,"load",this.onSeasonPrepared,this),this.preparingStore=null),this.preparingSeason=e
;var i,o=SYNO.SDS.VideoStation2.SlidableDataView.POSITION;if(Ext.isNumber(t)){var n=SYNO.SDS.VideoStation2.TVShow.get().getAvailableSeasons();n.indexOf(e)<n.indexOf(t)?(this.slideview.prepareView(o.left),i=this.slideview.getLeftView()):(this.slideview.prepareView(o.right),i=this.slideview.getRightView())}else i=this.slideview.getCenterView();i.isNeedLoadStore()?(this.preparingStore=i.getDataviewStore(),this.mon(this.preparingStore,"load",this.onSeasonPrepared,this,{delay:100,single:!0})):this.onSeasonPrepared()},getSwitchableView:function(t){var e={decorator:"Season",listeners:{scope:this,click:this.onViewItemClick,dblclick:Ext.emptyFn,flexcroll:this.onFlexcroll,selectionchange:Ext.emptyFn,contextmenu:Ext.emptyFn}};return new SYNO.SDS.VideoStation2.SwitchableDataView(e,t)},getAllDataViews:function(){var t=[];return t=t.concat(this.slideview.getLeftView().items.items),t=t.concat(this.slideview.getCenterView().items.items),t=t.concat(this.slideview.getRightView().items.items)},onActivate:function(){this.callParent(arguments),this.mon(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this)},onDeactivate:function(){this.callParent(arguments),this.mun(SYNO.SDS.VideoStation2.TVShow.get(),SYNO.SDS.VideoStation2.TVShow.EVENT_SEASON_CHANGED,this.onSeasonChanged,this),this.slideview.items.each(function(t){t.clearLoadedInfo(),t.fireEvent("deactivate",t)})}}),Ext.define("SYNO.SDS.VideoStation2.NavigationPanel",{extend:"SYNO.SDS.VideoStation2.ViewCardPanel",constructor:function(t){var e={};e[SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE]=new SYNO.SDS.VideoStation2.ViewHomePage({itemId:"homepage"}),e[SYNO.SDS.VideoStation2.View.VIEW_PLAYLIST]=new SYNO.SDS.VideoStation2.ViewPlaylist({itemId:"playlist"}),e[SYNO.SDS.VideoStation2.View.VIEW_POSTER]=new SYNO.SDS.VideoStation2.ViewPoster({itemId:"poster"}),e[SYNO.SDS.VideoStation2.View.VIEW_DETAIL]=new SYNO.SDS.VideoStation2.ViewDetailOuter({itemId:"detail"}),e[SYNO.SDS.VideoStation2.View.VIEW_TVSHOW]=new SYNO.SDS.VideoStation2.ViewTVShow({itemId:"tvshow"});var i={views:e,tbar:new SYNO.SDS.VideoStation2.NavigationBar,listeners:{scope:this,afterrender:this.insertBackgroundPosterEl}};this.callParent([Ext.apply(i,t)])},insertBackgroundPosterEl:function(t){t.getEl().insertFirst({tag:"div",cls:"background-poster",cn:[{tag:"div",cls:"background-poster-gradient"}]})}}),Ext.define("SYNO.SDS.VideoStation2.MainPanel",{extend:"SYNO.ux.Panel",constructor:function(t){var e={cls:"main-panel",border:!1,layout:"border",items:[new SYNO.SDS.VideoStation2.MainList({region:"west"}),new SYNO.SDS.VideoStation2.MainCardPanel({region:"center"})]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.MainCardPanel",{extend:"SYNO.SDS.VideoStation2.ViewCardPanel",constructor:function(t){var e={cls:"main-card-panel",views:{navigation:new SYNO.SDS.VideoStation2.NavigationPanel({itemId:"navigation"}),dtv:new SYNO.SDS.VideoStation2.DTVNavigationPanel({itemId:"dtv"})},listeners:{scope:this,afterrender:this.insertBackgroundPanel,afterlayout:this.onPanelLayout,beforedestroy:this.onBeforeDestroy}};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.loadView,this),this.onActivate()},insertBackgroundPanel:function(t){this._no_video_panel?this._no_video_panel.render(t.getEl()):this._no_video_panel=new SYNO.SDS.VideoStation2.NoVideoPanelWrapper({renderTo:t.getEl()})},onPanelLayout:function(){this._no_video_panel.doLayout()},onBeforeDestroy:function(){this._no_video_panel.destory(),this._no_video_panel=null},getItemByView:function(){var t;return this.items.each(function(e){if(e.getItemByView())return t=e,!1},this),t},onViewLoading:function(t,e){this._no_video_panel.hide(),t&&SYNO.SDS.VideoStation2.Util.unmask(t),e?SYNO.SDS.VideoStation2.Util.maskLoadingMsg(this,e,!0):SYNO.SDS.VideoStation2.Util.maskLoading(this,!0)},onViewLoaded:function(){SYNO.SDS.VideoStation2.Util.unmask(this)},onViewNoVideo:function(t){var e=SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_HOMEPAGE,i=SYNO.SDS.VideoStation2.Filter.get().hasKeyword();if(e&&!i)return this._no_video_panel.show(),void this._no_video_panel.doLayout();var o=SYNO.SDS.VideoStation2.Library.get().getCurrentType(),n=o!==SYNO.SDS.VideoStation2.Constant.TV_RECORDING&&o!==SYNO.SDS.VideoStation2.Constant.PLAYLIST,a=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory()===SYNO.SDS.VideoStation2.Category.CATEGORY_RECENTLY_WATCHED,S=!SYNO.SDS.VideoStation2.Filter.get().isFilterEmpty();!_S("is_admin")||i||S||a||!n?SYNO.SDS.VideoStation2.Util.maskInfo(t,_VST("common","no_video_item"),null,!0):this.onViewNoVideoTip()},onViewNoVideoTip:function(){var t=SYNO.SDS.VideoStation2.Library.get().getCurrentType();SYNO.SDS.VideoStation2.PromiseOP.get().listIndexFolder({target:{id:SYNO.SDS.VideoStation2.Library.get().getCurrentID(),type:t}}).then(function(e){e.folder.some(function(t){return"indexing"===t.status})?SYNO.SDS.VideoStation2.Util.maskInfo(this,_VST("reindex","indexing"),null):e.folder.length>0?SYNO.SDS.VideoStation2.Util.maskInfo(this,_VST("common","no_video_item"),null,!0):SYNO.SDS.VideoStation2.Util.maskInfo(this,_VST("tip","click_create_folder"),this.launchAddFolderDialog.bind(this,t))}.bind(this))},onViewChannelScan:function(){_S("is_admin")||SYNO.SDS.VideoStation2.Capability.get().ableToControlDTV()?SYNO.SDS.VideoStation2.Util.maskInfo(this,_VST("error","dtv_channeltable_not_found"),this.launchScanChannelDialog,!0):SYNO.SDS.VideoStation2.Util.maskInfo(this,_VST("error","dtv_no_function"),null,!0)},onViewNoTuner:function(){SYNO.SDS.VideoStation2.Util.maskInfo(this,String.format(_VST("error","dtv_request_dongle2"),'<a target="_blank" style="color:#FFFFFF; text-decoration: underline;" href="https://www.synology.com/en-global/compatibility?search_by=category&category=usb_tv_dongles&p=1">Synology website</a>'),Ext.emptyFn,!1)},launchAddFolderDialog:function(t){var e=new SYNO.SDS.VideoStation2.Setting.Dialog({initActiveTab:t===SYNO.SDS.VideoStation2.Constant.TV_RECORDING?"dtv_settings":0});SYNO.SDS.VideoStation2.SettingController.get().openDialog(e)},launchScanChannelDialog:function(){new SYNO.SDS.VideoStation2.ChannelScanDialog({tuner:SYNO.SDS.VideoStation2.DTV.get().getCurrentDTV(),onChannelScaned:SYNO.SDS.VideoStation2.Controller.refreshView}).open()}}),Ext.define("SYNO.SDS.VideoStation2.NoVideoPanelWrapper",{extend:"Ext.Container",constructor:function(t){var e={cls:"no-video-panel",layout:"fit",hidden:!0,items:[new SYNO.SDS.VideoStation2.NoVideoPanel({})]};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.NoVideoPanel",{extend:"Ext.Container",constructor:function(t){var e={cls:"inner",html:this.getContent()};this.callParent([Ext.apply(e,t)])},getContent:function(){var t=_S("is_admin")?_VST("common","homepage_no_video_admin"):_VST("common","homepage_no_video");return['<div class="empty-icon"></div>',String.format('<div class="description">{0}</div>',Ext.util.Format.htmlEncode(t))].join("")}}),Ext.define("SYNO.SDS.VideoStation2.AccountButton",{extend:"SYNO.SDS.VideoStation2.TransparentButton",constructor:function(t){var e={cls:"account",text:_S("user"),menu:new SYNO.SDS.VideoStation2.DropdownMenu({noicon:!0,items:[new Ext.Action({text:_VST("common","about"),handler:function(){SYNO.SDS.VideoStation2.Window.showAboutWindow()}}),new Ext.Action({text:_T("common","logout"),handler:function(){SYNO.SDS.Utils.Logout.logout(!0)}})]}),menuAlign:"tr-br"};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu",{extend:"SYNO.SDS.VideoStation2.CompositeMenu",constructor:function(t){var e={cls:"filter-menu",items:[this.panel=new SYNO.SDS.VideoStation2.FilterMenu.Panel({owner:this})]};this.callParent([Ext.apply(e,t)]),this.relayEvents(this.panel,[SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU]),this.mon(this.panel,SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU,this.onCloseMenu,this),this.mon(this.panel,SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT,this.doLayout,this)},show:function(t,e,i){this.alignTarget&&(t=this.alignTarget.getEl()||t),this.callParent(arguments)},onCloseMenu:function(){this.hide()}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.Panel",{extend:"SYNO.ux.Panel",constructor:function(t){var e={tbar:new SYNO.SDS.VideoStation2.FilterMenu.Toolbar,layout:"accordion",cls:"filter-menu-panel",layoutConfig:{titleCollapse:!1,animate:!0,activeOnTop:!1},items:[this.commonOptions=[new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:t.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_ACTOR}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:t.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DIRECTOR}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:t.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_GENRE}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:t.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_WRITER}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:t.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_CERTIFICATE}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:t.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_YEAR,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_YEAR}),new SYNO.SDS.VideoStation2.FilterMenu.RatingOption({owner:t.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_RATING})],this.tvRecordingOptions=[new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:t.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_DATE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DATE}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:t.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_CHANNEL_NAME}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:t.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_TITLE,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_TITLE})],new SYNO.SDS.VideoStation2.FilterMenu.ResolutionOption({owner:t.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION}),new SYNO.SDS.VideoStation2.FilterMenu.WatchedStatusOption({owner:t.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS}),new SYNO.SDS.VideoStation2.FilterMenu.FileCountOption({owner:t.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT}),new SYNO.SDS.VideoStation2.FilterMenu.Option({owner:t.owner,category:SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_CONTAINER}),new SYNO.SDS.VideoStation2.FilterMenu.DurationOption({owner:t.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_DURATION}),new SYNO.SDS.VideoStation2.FilterMenu.KeywordOption({owner:t.owner,itemId:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD})],listeners:{scope:this,activate:this.onActivate}};this.callParent([Ext.apply(e,t)]),this.relayEvents(this.getTopToolbar(),[SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU]),this.items.each(function(t){this.relayEvents(t,[SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT])},this),this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.onLibraryChanged,this),this.onLibraryChanged()},onActivate:function(){this.layout.activeItem&&this.layout.activeItem.fireEvent("activate")},onLibraryChanged:function(){var t=SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.TV_RECORDING;if(this.commonOptions.each(function(e){e.setVisible(!t)}),this.tvRecordingOptions.each(function(e){e.setVisible(t)}),this.rendered){this.items.each(function(t){t.collapse(!1)});var e=this[t?"tvRecordingOptions":"commonOptions"][0];e.expand(!1);var i=e.header.getHeight();e.items.each(function(t){i+=t.getOuterSize().height}),e.setHeight(i),this.doLayout()}else this.ownerCt&&this.ownerCt.render()}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.Toolbar",{extend:"SYNO.ux.Toolbar",statics:{EVENT_CLOSE_MENU:"closemenu"},constructor:function(t){var e={cls:"filter-menu-toolbar",items:[{xtype:"tbtext",text:_VST("filter","title")},"->",this.createSmartPlaylistBtn=new SYNO.SDS.VideoStation2.FilterMenu.ActionButton({cls:"list_add",scope:this,handler:this.onCreateSmartPlaylist,tooltip:_VST("playlist","action_save_as_smart"),disabled:!0}),{xtype:"tbseparator"},new SYNO.SDS.VideoStation2.FilterMenu.ActionButton({cls:"erase_s",tooltip:_VST("filter","clean_filter"),scope:this,handler:this.onClearAllFilter})]};this.callParent([Ext.apply(e,t)]),this.addEvents(SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU),this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this)},onFilterChange:function(){var t=SYNO.SDS.VideoStation2.Filter.get().isFilterEmpty(),e=SYNO.SDS.VideoStation2.Filter.get().hasKeyword();this.createSmartPlaylistBtn.setDisabled(t&&!e)},onClearAllFilter:function(){SYNO.SDS.VideoStation2.Filter.get().clearAllFilter()},onCreateSmartPlaylist:function(){this.fireEvent(SYNO.SDS.VideoStation2.FilterMenu.Toolbar.EVENT_CLOSE_MENU),SYNO.SDS.VideoStation2.PlaylistActionController.createSmartPlaylist()}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.ActionButton",{extend:"SYNO.SDS.VideoStation2.ActionButton",constructor:function(){this.callParent(arguments),this.addClass("filter-action-button")}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.Option",{extend:"SYNO.SDS.VideoStation2.AccordionPanel",statics:{EVENT_UPDATE_LAYOUT:"updatelayout"},category:null,local:!1,constructor:function(t){var e=t.category||this.category,i={cls:"filter-menu-option",items:[this.filterField=new SYNO.SDS.VideoStation2.FilterMenu.OptionFilter({width:256,store:this.getStore()}),this.detailPanel=new SYNO.SDS.VideoStation2.FilterMenu.OptionDetail({store:this.getStore(),category:e})],listeners:{scope:this,beforedestroy:this.onBeforeDestroy,afterrender:this.onAfterRender,activate:this.onActivate,collapse:this.updateTitle,expand:this.updateTitle}};this.callParent([Ext.apply(i,t)]),this.addEvents(SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT),this.updateTitle()},getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.filter({listeners:{scope:this,beforeload:this.onBeforeLoadStore}}),this._store},updateTitle:function(){var t=SYNO.SDS.VideoStation2.Util.getFilterCategoryString(this.category);if(this.setTitle('<span class="filter-category-title">'+t+"</span>"),this.collapsed){var e=SYNO.SDS.VideoStation2.Filter.get().getFilter(this.category);e&&(e=e.map(function(t){return Ext.util.Format.htmlEncode(t.key)}).join(", "),this.setTitle(['<div class="filter-cancel"></div>','<div class="filter-detail">','<span class="filter-title">',t," : </span>",e,"</div>"].join("")))}},toggleCollapse:function(){this.collapsed&&this.callParent(arguments)},onBeforeLoadStore:function(t,e){var i=e.params,o=SYNO.SDS.VideoStation2.Library.get().getCurrentVideoType();Ext.apply(i,{type:o,category:this.category,library_id:[SYNO.SDS.VideoStation2.Library.get().getCurrentID()]}),Ext.apply(i,SYNO.SDS.VideoStation2.Filter.get().getFilterOption()),delete i[this.category]},onAfterRender:function(){this.mon(this.header,"click",this.onHeaderClick,this),this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this)},onBeforeDestroy:function(){this.getStore().destroy()},onHeaderClick:function(t,e){if(Ext.fly(e).hasClass("filter-cancel"))return void SYNO.SDS.VideoStation2.Filter.get().clearFilter(this.category);this.toggleCollapse()},onFilterChange:function(t){t===this.category?this.updateTitle():this.collapsed||this.local||this.owner.hidden||this.getStore().load()},onActivate:function(){this.owner.hidden||(this.local?this.detailPanel.updateScrollbar():this.getStore().load())}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.RatingOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_RATING,local:!0,constructor:function(t){this.callParent(arguments)},getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_RATING}),this._store}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.ResolutionOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_RESOLUTION,local:!0,constructor:function(t){this.callParent(arguments)},getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_RESOLUTION}),this._store}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.WatchedStatusOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_WATCHED_STATUS,local:!0,constructor:function(t){this.callParent(arguments)},getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_WATCHED_STATUS}),this._store}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.FileCountOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_FILE_COUNT,local:!0,constructor:function(t){this.callParent(arguments)},getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_FILE_COUNT}),this._store}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.DurationOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_DURATION,local:!0,constructor:function(t){this.callParent(arguments)},getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter({data:SYNO.SDS.VideoStation2.Filter.DATA_DURATION}),this._store}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.KeywordOption",{extend:"SYNO.SDS.VideoStation2.FilterMenu.Option",category:SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,local:!0,constructor:function(t){var e={hideCollapseTool:!0};this.callParent([Ext.apply(e,t)])},getStore:function(){return this._store=this._store||new SYNO.SDS.VideoStation2.Stores.localfilter,this._store},toggleCollapse:function(){},updateTitle:function(){this.setVisible(SYNO.SDS.VideoStation2.Filter.get().hasKeyword()),this.fireEvent(SYNO.SDS.VideoStation2.FilterMenu.Option.EVENT_UPDATE_LAYOUT);var t=SYNO.SDS.VideoStation2.Util.getFilterCategoryString(this.category),e=SYNO.SDS.VideoStation2.Filter.get().getKeyword();this.setTitle(['<div class="filter-cancel"></div>','<div class="filter-detail">','<span class="filter-title">',t," : </span>",Ext.util.Format.htmlEncode(e),"</div>"].join(""))}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.OptionFilter",{extend:"SYNO.SDS.VideoStation2.TextFilter",constructor:function(t){var e={localFilter:!0,localFilterField:"key"};this.callParent([Ext.apply(e,t)]),this.mon(this,"render",function(t){t.container.addClass("filter-menu-searchfield")})}}),Ext.define("SYNO.SDS.VideoStation2.FilterMenu.OptionDetail",{statics:{EVENT_FIELD_CHANGE:"fieldchange",EVENT_FIELD_VISIBLE_CHANGE:"fieldvisiblechange"},category:null,extend:"SYNO.SDS.Utils.DataView.LazyDataView",constructor:function(t){var e={height:176,cls:"filter-menu-detail",tpl:this.getTpl(),itemSelector:"div.item-wrap",listeners:{scope:this,click:this.onOptionClick}};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this),this.mon(this.store,"datachanged",this.onFilterChange.createDelegate(this,[this.category]),this),this.mon(this.store,"load",this.onFilterChange.createDelegate(this,[this.category]),this)},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div ext:qtip="{[this.doubleEncode(values.key)]}" class="item-wrap','<tpl if="this.isSelected(key)"> x-view-selected</tpl>','">','<div class="checkbox"></div>{key:htmlEncode}',"</div>","</tpl>",{isSelected:this.isSelected.createDelegate(this),doubleEncode:function(t){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(t))}})},isSelected:function(t){var e=SYNO.SDS.VideoStation2.Filter.get().getFilter(this.category);if(!e)return!1;var i=!1;return e.each(function(e){if(e.key===t)return i=!0,!1}),i},onOptionClick:function(t,e,i,o){var n=this.store.getAt(e);SYNO.SDS.VideoStation2.FilterController.togggleFilter(this.category,n.data)},onFilterChange:function(t){if(this.category===t){this.getNodes().each(function(t){Ext.fly(t).removeClass("x-view-selected")});var e=SYNO.SDS.VideoStation2.Filter.get().getFilter(t);e&&e.each(function(t){var e=this.store.getById(t.key);if(e){var i=this.getNode(e);i&&Ext.fly(i).addClass("x-view-selected")}},this)}}}),Ext.define("SYNO.SDS.VideoStation2.FilterButton",{extend:"SYNO.SDS.VideoStation2.MenuActionButton",constructor:function(t){var e={cls:"filter",tooltip:_VST("filter","title"),menu:new SYNO.SDS.VideoStation2.FilterMenu({})};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.changeFilterState,this),this.mon(SYNO.SDS.VideoStation2.Folder.get(),SYNO.SDS.VideoStation2.Folder.EVENT_FOLDER_CHANGED,this.changeFilterState,this),this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_CHANGED,this.changeFilterState,this),this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_SET,this.changeFilterState,this),this.mon(SYNO.SDS.VideoStation2.RecordingSpecific.get(),SYNO.SDS.VideoStation2.RecordingSpecific.EVENT_RECORDING_SPECIFIC_CLEAR,this.changeFilterState,this)},changeFilterState:function(){var t=SYNO.SDS.VideoStation2.View.get().getView()===SYNO.SDS.VideoStation2.View.VIEW_POSTER,e=SYNO.SDS.VideoStation2.Folder.get().isSet(),i=SYNO.SDS.VideoStation2.Playlist.get().isSet(),o=SYNO.SDS.VideoStation2.RecordingSpecific.get().isSet();this.setVisible(t&&!i&&!e&&!o)}}),Ext.define("SYNO.SDS.VideoStation2.MainSearchField",{extend:"SYNO.SDS.VideoStation2.SearchField",constructor:function(t){var e={width:214,listeners:{scope:this,keypress:this.onSearchFieldKeypress}};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.Filter.get(),SYNO.SDS.VideoStation2.Filter.EVENT_FILTER_CHANGE,this.onFilterChange,this),this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_CHANGED,this.changeSearchState,this),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.changeSearchState,this),this.changeSearchState()},changeSearchState:function(){var t=SYNO.SDS.VideoStation2.View.get().getView();this.setDisabled(SYNO.SDS.VideoStation2.Library.get().getCurrentType()===SYNO.SDS.VideoStation2.Constant.PLAYLIST||t===SYNO.SDS.VideoStation2.View.VIEW_SCHEDULE)},onSearchFieldKeypress:function(t,e){if(e.getKey()===Ext.EventObject.ENTER){var i=t.getValue().trim();SYNO.SDS.VideoStation2.Filter.get().getKeyword()!==i&&SYNO.SDS.VideoStation2.Controller.setFilter(SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD,i)}},onFilterChange:function(t){t===SYNO.SDS.VideoStation2.Filter.FILTER_KEYWORD&&this.rendered&&this.setValue(SYNO.SDS.VideoStation2.Filter.get().getKeyword())}}),Ext.define("SYNO.SDS.VideoStation2.NotificationPanel",{extend:"SYNO.SDS.VideoStation2.FormPanel",constructor:function(t){var e={title:_VST("notification","title")};this.callParent([Ext.apply(e,t)])}}),Ext.define("SYNO.SDS.VideoStation2.OfflineConversionStatusDataView",{extend:"SYNO.SDS.Utils.DataView.LazyDataView",statics:{EVENT_RELOAD:"reload",EVENT_ON_DELETE:"on_delete",STATUS_WAIT:"wait",STATUS_PROCESS:"process",STATUS_ERROR:"error",STATUS_STOP:"stop",STATUS_DONE:"done"},constructor:function(t){var e={tpl:this.getTpl(),cls:"offline-conversion-status-dataview",itemSelector:"div.offline-conversion-wrap",overClass:"x-view-over",singleSelect:!0,trackResetOnLoad:!1};this.callParent([Ext.apply(e,t)])},getTpl:function(){return new Ext.XTemplate('<tpl for=".">','<div class="offline-conversion-wrap">','<div class="thumb" style="background-image: url({[this.getImageURL(values.setting.additional.video)]})"></div>','<div class="info">','<div class="title-wrap"><table class="x-toolbar-ct" cellspacing="0"><tbody><tr>','<td align="left">','<div class="title sds-ellipsis" ext:qtip="{[this.getDoubleEncodeTitle(values.setting.additional.video)]}">{[this.getEncodeTitle(values.setting.additional.video)]}</div>',"</td>",'<td align="right">','<div class="status status-{values.status.state}">{[this.getStatus(values)]}</div>',"{[this.getErrorIcon(values)]}","</td>","</tr></tbody></table></div>",'<div class="setting-wrap">','<div class="owner-name sds-ellipsis" ext:qtip="{[this.getDoubleEncode(values.status.owner_name)]}" >{values.status.owner_name:htmlEncode}</div>','<div class="sep"></div>','<div class="video-profile sds-ellipsis" ext:qtip="{[this.getVideoProfiles(values)]}">{[this.getVideoProfiles(values)]}</div>','<div class="sep"></div>','<div class="audio-track sds-ellipsis" ext:qtip="{[this.getAudioTrack(values)]}">{[this.getAudioTrack(values)]}</div>','<div class="progress">{[this.getProgress(values)]}%</div>',"</div>",'<div class="progress-bar-wrap">','<div class="blue-bar"></div>','<div class="grey-bar" style="width:{[this.getInverseProgress(values)]}%"></div>',"</div>","</div>",'<div class="action {[this.getRestartStopAction(values)]}"></div>','<div class="action delete"></div>',"</div>","</tpl>",'<div class="x-clear"></div>',{getImageURL:this.getImageURL.createDelegate(this),getEncodeTitle:this.getEncodeTitle.createDelegate(this),getErrorIcon:this.getErrorIcon.createDelegate(this),getDoubleEncodeTitle:this.getDoubleEncodeTitle.createDelegate(this),getDoubleEncode:this.getDoubleEncode.createDelegate(this),getStatus:this.getStatus.createDelegate(this),getVideoProfiles:this.getVideoProfiles.createDelegate(this),getAudioTrack:this.getAudioTrack.createDelegate(this),getProgress:this.getProgress.createDelegate(this),getRestartStopAction:this.getRestartStopAction.createDelegate(this),getInverseProgress:this.getInverseProgress.createDelegate(this)})},getImageURL:function(t){return SYNO.SDS.VideoStation2.Util.getImageURL({type:t.type,id:t.id,mtime:t.additional?t.additional.poster_mtime||"":""})},getEncodeTitle:function(t){return SYNO.SDS.VideoStation2.Constant.TVSHOW_EPISODE!==t.type?Ext.util.Format.htmlEncode(t.title):Ext.util.Format.htmlEncode(SYNO.SDS.VideoStation2.Util.getPathTitleForOfflineEpisode(t))},getDoubleEncodeTitle:function(t){return Ext.util.Format.htmlEncode(this.getEncodeTitle(t))},getDoubleEncode:function(t){return Ext.util.Format.htmlEncode(Ext.util.Format.htmlEncode(t))},getTimeLeftString:function(t){return[Math.floor(t/3600),("00"+Math.floor(t%3600/60)).substr(-2),("00"+Math.floor(t%60)).substr(-2)].join(":")},getStatus:function(t){switch(t.status.state){case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_WAIT:return _VST("offline_conversion","status_wait");case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_PROCESS:return this.getTimeLeftString(t.status.time_left);case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_ERROR:return _VST("offline_conversion","status_error");case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_STOP:return _VST("offline_conversion","status_stop");case SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_DONE:return _VST("offline_conversion","status_done")}return""},getVideoProfiles:function(t){return SYNO.SDS.VideoStation2.OfflineConversionUtil.videoProfileToString(t.setting.video_profile)},getAudioTrack:function(t){var e=t.setting.audio_id;return e<0?_VST("offline_conversion","default_audio_track"):String.format("#{0}",e)},getErrorIcon:function(t){if(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_ERROR!=t.status.state)return"";var e=this.getErrorMessage(t.status.error);return String.format('<div class="error-icon" ext:qtip="{0}"></div>',Ext.util.Format.htmlEncode(e))},getErrorMessage:function(t){switch(t){case 100:return _VST("controller","in_transcoding");case 101:case 102:return _T("error","error_error_system");case 103:return _VST("controller","unsupported_audio_codec");case 104:return String.format(_VST("controller","unsupported_format"));case 105:return _VST("controller","need_change_mem_layout");case 106:return _VST("controller","unsupported_hardware_transcode_format");case 107:return _VST("controller","out_of_transcoding_resolution_capability");case 108:return _VST("controller","out_of_transcoding_framerate_capability");case 109:return _VST("controller","out_of_transcoding_profile_capability");case 110:return _T("error","error_error_system");case 111:return _VST("controller","system_daemon_not_running");case 112:return _VST("error","record_quota_reached");default:return _T("error","error_error_system")}},getProgress:function(t){return(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_PROCESS===t.status.state||SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_DONE===t.status.state)&&t.status.progress?Math.floor(1e4*t.status.progress)/100:0},getRestartStopAction:function(t){var e="";return SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_WAIT===t.status.state||SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_PROCESS===t.status.state||SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_DONE===t.status.state?e="stop":SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_ERROR!==t.status.state&&SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_STOP!==t.status.state||(e="restart"),SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_DONE===t.status.state&&(e+=" x-item-disabled"),e},getInverseProgress:function(t){return 100-this.getProgress(t)},onRequestSuccess:function(){this.fireEvent(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.EVENT_RELOAD)},onDeleteTask:function(t){var e=SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.STATUS_DONE!==t.data.status.state;this.fireEvent(SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.EVENT_ON_DELETE,t,e)},onRestartTask:function(t){SYNO.SDS.VideoStation2.OP.get().restartOfflineConversionTask({id:[t.id]},{scope:this,success:this.onRequestSuccess})},onStopTask:function(t){SYNO.SDS.VideoStation2.OP.get().stopOfflineConversionTask({id:[t.id]},{scope:this,success:this.onRequestSuccess})},onClick:function(t,e,i){var o=Ext.fly(e);if(o){var n,a,S;if(a=t.getTarget(this.itemSelector,this.getTemplateTarget()))if(n=this.indexOf(a),S=this.store.getAt(n),o.hasClass("delete"))this.onDeleteTask(S);else if(o.hasClass("restart"))this.onRestartTask(S);else if(o.hasClass("stop")&&!o.hasClass("x-item-disabled"))this.onStopTask(S);else if(o.hasClass("thumb")){var s=S.data.setting.additional.video;s.pathTitle=this.getEncodeTitle(s),SYNO.SDS.VideoStation2.Controller.intoVideoDetailFromOfflineVideo(s)}else this.callParent(arguments)}}}),Ext.define("SYNO.SDS.VideoStation2.OfflineConversionStatusPanel",{extend:"SYNO.SDS.VideoStation2.ActivablePanel",statics:{EVENT_DELETE_CONFIRM:"delete_confirm"},constructor:function(t){var e={title:_VST("offline_conversion","title"),autoFlexcroll:!0,layout:"fit",cls:"offline-conversion-status-panel",items:[this.getDataView()]};this.callParent([Ext.apply(e,t)]),this.mon(this.getDataView(),SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.EVENT_RELOAD,this.onReloadDataView,this),this.mon(this.getDataView(),SYNO.SDS.VideoStation2.OfflineConversionStatusDataView.EVENT_ON_DELETE,this.onDeleteTask,this)},onActivate:function(){this.getReloadTask().restart(!0)},onDeactivate:function(){this.getReloadTask().stop()},onReloadDataView:function(){this.getReloadTask().stop(),this.getReloadTask().restart(!0)},onDeleteTask:function(t,e){var i={fn:function(){
SYNO.SDS.VideoStation2.OP.get().deleteOfflineConversionTask({id:[t.id]},{scope:this,success:this.onReloadDataView})},scope:this};if(e)return void this.fireEvent(SYNO.SDS.VideoStation2.OfflineConversionStatusPanel.EVENT_DELETE_CONFIRM,_VST("action","remove_confirm"),i);SYNO.SDS.VideoStation2.Util.applyCallback(i)},getStore:function(){return this._store=this._store||new SYNO.API.Store({proxy:new SYNO.API.Proxy({api:"SYNO.VideoStation.OfflineConversion",method:"list",version:1,listeners:{scope:this,beforeload:function(t,e){var i=t.activeRequest.read;i&&Ext.Ajax.abort(i)}}}),api:"SYNO.VideoStation.OfflineConversion",method:"list",version:1,baseParams:{additional:["video"]},reader:new Ext.data.JsonReader({root:"task",totalProperty:"total",fields:["id","setting","status"]}),listeners:{scope:this,exception:function(){this.getReloadTask().stop()}}}),this._store},getDataView:function(){return this._dataView=this._dataView||new SYNO.SDS.VideoStation2.OfflineConversionStatusDataView({store:this.getStore()}),this._dataView},getReloadTask:function(){return this._reloadTask=this._reloadTask||this.addTask({interval:5e3,run:this.getStore().load,scope:this.getStore()}),this._reloadTask}}),Ext.define("SYNO.SDS.VideoStation2.NotificationDialog",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(t){var e={title:_VST("offline_conversion","title"),layout:"fit",width:480,height:580,minWidth:480,minHeight:280,resizable:!1,draggable:!1,cls:"notification-dialog",items:[this.getOfflineConversionPanel()],buttons:[{xtype:"syno_vs_button",btnStyle:"blue",text:_T("common","ok"),scope:this,handler:this.onApply},{xtype:"syno_vs_button",text:_T("common","cancel"),scope:this,handler:this.onCancel}]};this.callParent([Ext.apply(e,t)]),this.on("show",this.onActivate,this),this.on("hide",this.onDeactivate,this),this.mon(this.getOfflineConversionPanel(),SYNO.SDS.VideoStation2.OfflineConversionStatusPanel.EVENT_DELETE_CONFIRM,this.onDeleteConfirm,this)},onActivate:function(){this.mon(Ext.getDoc(),"mousedown",this.onMouseDown,this),this.getOfflineConversionPanel().fireEvent("activate"),this.callParent(arguments)},onDeactivate:function(){this.mun(Ext.getDoc(),"mousedown",this.onMouseDown,this),this.getOfflineConversionPanel().fireEvent("deactivate"),this.callParent(arguments)},onApply:function(){this.hide()},onCancel:function(){this.hide()},onMouseDown:function(t){this.isVisible()&&(t.within(this.el)||this.confirmDialog&&t.within(this.confirmDialog.el)||this.hide())},getTabPanel:function(){var t=[this.getNotificationPanel()];return SYNO.SDS.VideoStation2.Capability.get().ableToControlOfflineConversion()&&t.push(this.getOfflineConversionPanel()),this._tabPanel=this._tabPanel||new SYNO.SDS.VideoStation2.TabPanel({activeTab:0,items:t}),this._tabPanel},getNotificationPanel:function(){return this._notification=this._notification||new SYNO.SDS.VideoStation2.NotificationPanel,this._notification},getOfflineConversionPanel:function(){return this._offlineConversion=this._offlineConversion||new SYNO.SDS.VideoStation2.OfflineConversionStatusPanel,this._offlineConversion},onDeleteConfirm:function(t,e){this.confirmDialog=this.getMsgBox().confirm(this.title,t,function(t){"yes"===t&&SYNO.SDS.VideoStation2.Util.applyCallback(e)},this)}}),Ext.define("SYNO.SDS.VideoStation2.MainToolbar",{statics:{spacerConfig:function(t){return{xtype:"tbspacer",width:t}}},extend:"SYNO.ux.Toolbar",constructor:function(t){var e={cls:"main-toolbar",items:this.getItems()};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.Capability.get(),SYNO.SDS.VideoStation2.Capability.EVENT_CAPABILITY_READY,this.onCapabilityReady,this,{single:!0})},getItems:function(){return[new SYNO.ux.Button({cls:"logo",handler:SYNO.SDS.VideoStation2.Controller.intoHomePage}),SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(26),new SYNO.SDS.VideoStation2.ActionButton({cls:"home",tooltip:_VST("common","homepage"),handler:SYNO.SDS.VideoStation2.Controller.intoHomePage}),SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(12),new SYNO.SDS.VideoStation2.MainSearchField({}),SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(8),new SYNO.SDS.VideoStation2.FilterButton({hidden:!0}),"->",new SYNO.SDS.VideoStation2.AccountButton,SYNO.SDS.VideoStation2.MainToolbar.spacerConfig(16),{xtype:"tbseparator"},new SYNO.SDS.VideoStation2.ActionButton({cls:"help",tooltip:_T("common","alt_help"),handler:SYNO.SDS.VideoStation2.Util.launchHelp}),this.notificationBtn=new SYNO.SDS.VideoStation2.ActionButton({cls:"offline-conversion-queue",tooltip:_VST("offline_conversion","title"),handler:this.launchNotification,scope:this,hidden:!0}),new SYNO.SDS.VideoStation2.ActionButton({cls:"setting",tooltip:_VST("action","settings"),scope:this,handler:this.launchSetting})]},launchSetting:function(){var t=new SYNO.SDS.VideoStation2.Setting.Dialog;SYNO.SDS.VideoStation2.SettingController.get().openDialog(t)},launchNotification:function(){var t=this.getNotificationDialog();t.isVisible()?t.hide():t.show()},getNotificationDialog:function(){return this.notificationDialog||(this.notificationDialog=new SYNO.SDS.VideoStation2.NotificationDialog({listeners:{scope:this,show:function(){this.notificationBtn.addClass("x-btn-click")},hide:function(){this.notificationBtn.removeClass("x-btn-click")}}}),this.addManagedComponent(this.notificationDialog)),this.notificationDialog},onCapabilityReady:function(){this.notificationBtn.setVisible(SYNO.SDS.VideoStation2.Capability.get().ableToControlOfflineConversion())}}),Ext.define("SYNO.SDS.VideoStation2.Wizard",{extend:"SYNO.SDS.VideoStation2.Dialog",constructor:function(t){this.tabPanel=new SYNO.SDS.VideoStation2.Wizard.TabPanel;var e={width:724,height:510,resizable:!1,header:!1,draggable:!1,elements:"body",fbar:!1,cls:"syno-vs2-wizard",layout:"fit",items:[this.tabPanel],listeners:{scope:this,afterrender:this.addSkipBtn}};this.callParent([Ext.apply(e,t)]),this.mon(this.tabPanel,SYNO.SDS.VideoStation2.Wizard.TabPanel.EVENT_WIZARD_CLOSE,this.closeDialog,this)},fillPadding:Ext.emptyFn,afterShow:function(){this.callParent(arguments),Ext.Element.data(SYNO.SDS.VideoStation2.Window.el.dom,"mask").addClass("syno-vs2-wizard-mask"),SYNO.SDS.VideoStation2.Window.setMaskOpacity(.5)},closeDialog:function(){SYNO.SDS.UserSettings.setProperty("SYNO.SDS.VideoStation.AppInstance","hide_vs2_wizard",!0),this.close()},addSkipBtn:function(){this.getEl().createChild({cls:"skip-btn",html:_VST("record","skip")}).on("click",this.closeDialog,this)}}),Ext.define("SYNO.SDS.VideoStation2.Wizard.TabPanel",{statics:{EVENT_WIZARD_CLOSE:"wizard_close",HEADER_ITEM_WIDTH:106},extend:"SYNO.SDS.VideoStation2.TabPanel",constructor:function(t){var e=[],i=["getWizardWelcome","getWizardVideo","getWizardTranscoding","getWizardDTV","getWizardSettings","getWizardFinal"];Ext.each(i,function(t){var i=this[t]();Ext.isObject(i)&&e.push(i)},this);var o={cls:"wizard-tab-panel",itemTpl:this.getTabTpl(),bbar:new SYNO.ux.Toolbar({cls:"wizard-bottom-tool-bar",items:[this.getPrevButton(),"->",this.getNextButton()]}),activeTab:0,items:e,listeners:{scope:this,tabchange:this.onTabChange}};this.callParent([Ext.apply(o,t)])},getWizardWelcome:function(){return this._wizardWelcome=this._wizardWelcome||new SYNO.SDS.VideoStation2.Wizard.Welcome,this._wizardWelcome},getWizardVideo:function(){return this._wizardVideo=this._wizardVideo||new SYNO.SDS.VideoStation2.Wizard.Video,this._wizardVideo},getWizardTranscoding:function(){return SYNO.SDS.VideoStation2.Capability.get().ableToTranscode()?(this._wizardTranscoding=this._wizardTranscoding||new SYNO.SDS.VideoStation2.Wizard.Transcoding,this._wizardTranscoding):null},getWizardDTV:function(){return this._wizardDTV=this._wizardDTV||new SYNO.SDS.VideoStation2.Wizard.DTV,this._wizardDTV},getWizardSettings:function(){return this._wizardSettings=this._wizardSettings||new SYNO.SDS.VideoStation2.Wizard.Settings,this._wizardSettings},getWizardFinal:function(){return this._wizardFinal=this._wizardFinal||new SYNO.SDS.VideoStation2.Wizard.Final,this._wizardFinal},getTabTpl:function(){var t=new Ext.Template('<li class="{cls}" role="tab" id="{id}" aria-label="{text}" aria-expanded="false" aria-selected="false"><a class="x-tab-strip-close"></a>','<div class="x-tab-right" tabIndex="-1" aria-labelledby="{id}">','<div class="x-tab-left icon"></div>','<span class="x-tab-strip-inner"><span class="x-tab-strip-text {iconCls}">{text}</span></span>',"</div>","</li>");return t.disableFormats=!0,t.compile(),t},getPrevButton:function(){return this._prev_btn=this._prev_btn||new SYNO.ux.Button({cls:"action prev",hidden:!0,scope:this,handler:this.goPrevious}),this._prev_btn},getNextButton:function(){return this._next_btn=this._next_btn||new SYNO.ux.Button({cls:"action next",scope:this,handler:this.goNext}),this._next_btn},goPrevious:function(){this.changePage(function(t){return SYNO.Assert(0<t,String.format("goPrevious index {0} error",t)),--t})},goNext:function(){this.changePage(function(t){return SYNO.Assert(0<=t&&t<this.items.length,String.format("goNext index {0} error",t)),++t})},changePage:function(t){var e=this.getCurrentIndex();if(e=t.apply(this,[e]),this.items.length<=e)return void this.fireEvent(SYNO.SDS.VideoStation2.Wizard.TabPanel.EVENT_WIZARD_CLOSE);this.setActiveTab(e)},onTabChange:function(){var t=this.getCurrentIndex(),e=0===t,i=this.items.length-1===t;this.getPrevButton()[e?"hide":"show"](),this.getNextButton()[i?"addClass":"removeClass"]("done");var o=this.getHeaderIndicator();o.getEl().alignTo(this.header,"bl-bl",[(t-1)*SYNO.SDS.VideoStation2.Wizard.TabPanel.HEADER_ITEM_WIDTH,0]),o[e||i?"removeClass":"addClass"]("show")},getCurrentIndex:function(){return this.items.indexOf(this.getLayout().activeItem)},getHeaderIndicator:function(){return this._headerIndicator=this._headerIndicator||new Ext.BoxComponent({renderTo:this.getEl(),cls:"header-indicator"}),this._headerIndicator}}),Ext.define("SYNO.SDS.VideoStation2.Wizard.ItemBase",{extend:"Ext.Container",constructor:function(t){var e=Ext.isString(t.cls)?t.cls+" wizard-base":"wizard-base";t.cls=e;var i=Ext.isString(t.tabCls)?t.tabCls+" tab-wrapper":"tab-wrapper";t.tabCls=i;var o={layout:"border",items:[this.getMessageItem(),this.getPictureItem()],listeners:{scope:this,activate:this.onActivate,deactivate:this.onDeactivate,beforedestroy:this.onDeactivate}};this.callParent([Ext.apply(o,t)])},getMessageItem:function(){return this._messageItem=this._messageItem||new Ext.BoxComponent({cls:"message",region:"north",html:this.getMessageCfg()}),this._messageItem},getPictureItem:function(){return this._pictureItem=this._pictureItem||new Ext.BoxComponent({cls:"picture",region:"center",html:this.getPictureCfg()}),this._pictureItem},getMessageCfg:Ext.emptyFn,getPictureCfg:Ext.emptyFn,onActivate:Ext.emptyFn,onDeactivate:Ext.emptyFn,createTopWindowElement:function(t){var e=Ext.isString(t.cls)?t.cls+" syno-wizard-highlight-item":"syno-wizard-highlight-item";return t.cls=e,new Ext.BoxComponent(Ext.apply({renderTo:SYNO.SDS.VideoStation2.Window.getEl()},t))}}),Ext.define("SYNO.SDS.VideoStation2.Wizard.Welcome",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(t){var e={tabCls:"wizard-no-icon",cls:"syno-vs2-wizard-welcome"};this.callParent([Ext.apply(e,t)])},getMessageCfg:function(t){return _VST("tip","welcome_desc")},getPictureCfg:function(){return['<div class="wizard-welcome-picture">',"</div>"].join()}}),Ext.define("SYNO.SDS.VideoStation2.Wizard.Video",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(t){var e={title:_VST("video_info","video"),tabCls:"wizard-video-icon",cls:"syno-vs2-wizard-video"};this.callParent([Ext.apply(e,t)])},getMessageCfg:function(){return _VST("tip","videostation_desc")},getPictureCfg:function(){var t=[{cls:"create-library",desc:_VST("tip","ceatre_customize_library")},{cls:"customize-library-vidibility",desc:_VST("tip","customize_library_vidibility")},{cls:"add-video-folder",desc:_VST("tip","add_video_folder")}],e=-1===["cht","chs","rus","jpn","krn"].indexOf(_S("lang"))?"":"normal-lang",i=['<div class="action-wrapper {0}">','<div class="action-icon {1}"></div>','<div class="dash">&nbsp;-&nbsp;</div>','<div class="desc">{2}</div>',"</div>"].join("");return t.map(function(t){return String.format(i,e,t.cls,t.desc)}).join("")},onActivate:function(){this.arrow=this.createTopWindowElement({cls:"video-arrow"}),this.library=this.createTopWindowElement({cls:"video-library",html:String.format('<div class="text">{0}</div>',_VST("library","title"))}),this.playlist=this.createTopWindowElement({cls:"video-playlist",html:String.format('<div class="text">{0}</div>',_VST("playlist","title"))})},onDeactivate:function(){this.arrow&&this.arrow.destroy(),this.library&&this.library.destroy(),this.playlist&&this.playlist.destroy()}}),Ext.define("SYNO.SDS.VideoStation2.Wizard.Transcoding",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(t){var e={title:_VST("tip","transcode_title"),tabCls:"wizard-transcoding-icon",cls:"syno-vs2-wizard-transcoding"};this.callParent([Ext.apply(e,t)])},getMessageCfg:function(){var t=[{title:_VST("tip","online_transcoding_title"),desc:String.format(_VST("tip","online_transcoding_simple_desc"),"")},{title:_VST("offline_conversion","title"),desc:String.format(_VST("tip","offline_transcoding_desc"),"")},{title:_VST("tip","transcoding_queue_title"),desc:String.format(_VST("tip","transcoding_queue_desc"),"")}],e=['<div class="transcoding-message-wrapper">','<span class="title">{0}</span>',"<span>&nbsp;{1}</span>","</div>"].join("");return t.map(function(t){return String.format(e,t.title,t.desc)}).join("")},getPictureCfg:function(){return['<div class="wizard-transcoding-picture">',"</div>"].join("")}}),Ext.define("SYNO.SDS.VideoStation2.Wizard.DTV",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(t){var e={title:_VST("dtv","title"),tabCls:"wizard-dtv-icon",cls:"syno-vs2-wizard-dtv"};this.callParent([Ext.apply(e,t)])},getMessageCfg:function(){return[_VST("tip","dtv_live_stream"),_VST("tip","dtv_recording"),_VST("tip","dtv_enable")].map(function(t){return String.format("<span>{0}</span>",t)}).join("")},getPictureCfg:function(){return['<div class="wizard-dtv-picture">',"</div>"].join("")}}),Ext.define("SYNO.SDS.VideoStation2.Wizard.Settings",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(t){var e={title:_VST("action","settings"),tabCls:"wizard-setting-icon",cls:"syno-vs2-wizard-settings"};this.callParent([Ext.apply(e,t)])},getMessageCfg:function(){return _VST("tip","setting_desc")},getPictureCfg:function(){var t=[{iconCls:"privilege",desc:_VST("privilege","title")},{iconCls:"sharing",desc:_VST("helptoc","sharing")},{iconCls:"dtv",desc:_VST("dtv","title")},{iconCls:"video",desc:_VST("tip","video_title")}],e=['<div class="settings-icon-wrapper">','<div class="settings-icon {0}"></div>','<div class="title">{1}</div>',"</div>"].join("");return t.map(function(t,i){var o="";return 0!==i&&(o+='<div class="spacer"></div>'),o+=String.format(e,t.iconCls,t.desc)}).join("")},onActivate:function(){this.arrow=this.createTopWindowElement({cls:"setting-arrow"}),this.setting=this.createTopWindowElement({cls:"setting-setting-icon"})},onDeactivate:function(){this.arrow&&this.arrow.destroy(),this.setting&&this.setting.destroy()}}),Ext.define("SYNO.SDS.VideoStation2.Wizard.Final",{extend:"SYNO.SDS.VideoStation2.Wizard.ItemBase",constructor:function(t){var e={tabCls:"wizard-no-icon",cls:"syno-vs2-wizard-final"};this.callParent([Ext.apply(e,t)])},getMessageCfg:function(){return _VST("tip","enjoy_videostation")},getPictureCfg:function(){return['<div class="wizard-final-picture">',"</div>"].join("")}}),Ext.define("SYNO.SDS.VideoStation.AppInstance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.VideoStation2.MainWindow"}),Ext.define("SYNO.SDS.VideoStation2.MainWindow",{extend:"SYNO.SDS.AppWindow",isBeta:!1,aboutTitleColor:"#D13B3B",constructor:function(t){SYNO.SDS.VideoStation2.Window=this;var e={cls:"syno-vs2-win",layout:"fit",height:580,width:1080,minHeight:480,minWidth:1080,tbar:new SYNO.SDS.VideoStation2.MainToolbar,items:[new SYNO.SDS.VideoStation2.MainPanel],listeners:{scope:this,beforerender:this.onBeforeRenderFn,resize:this.onResizeFn}};this.callParent([Ext.apply(e,t)]),this.mon(SYNO.SDS.VideoStation2.View.get(),SYNO.SDS.VideoStation2.View.EVENT_VIEW_CHANGED,this.onShowHideBackground,this),this.mon(SYNO.SDS.VideoStation2.Category.get(),SYNO.SDS.VideoStation2.Category.EVENT_CATEGORY_CHANGED,this.onShowHideBackground,this),this.initSequence()},initSequence:function(){SYNO.SDS.VideoStation2.Util.maskLoading(this,!0),this.checkCapability().then(function(){return Promise.all([this.loadLibrary(),this.loadPlaylists(),this.loadDTV()])}.bind(this)).then(function(){return SYNO.SDS.VideoStation2.Util.unmask(this),this.initHistoryController()}.bind(this)).then(this.launchWizard.bind(this))},checkCapability:function(){return SYNO.SDS.VideoStation2.PromiseOP.get().getVideoStationInfo({}).then(function(t){SYNO.SDS.VideoStation2.Capability.get().loadCapability(t),SYNO.SDS.VideoStation2.DTV.get().setDTVDisabled(!t.is_dtv_enabled),SYNO.SDS.VideoStation2.DTV.get().setTimezoneOffset(t.timezone_offset)})},loadLibrary:function(){return new Promise(function(t,e){this.mon(SYNO.SDS.VideoStation2.Library.get(),SYNO.SDS.VideoStation2.Library.EVENT_LIBRARY_LOAD,t,this,{single:!0}),SYNO.SDS.VideoStation2.LibraryController.get().loadLibrary()}.bind(this))},loadPlaylists:function(){return new Promise(function(t,e){this.mon(SYNO.SDS.VideoStation2.Playlist.get(),SYNO.SDS.VideoStation2.Playlist.EVENT_PLAYLIST_LOADED,t,this,{single:!0}),SYNO.SDS.VideoStation2.PlaylistController.loadPlaylists()}.bind(this))},loadDTV:function(){return new Promise(function(t,e){this.mon(SYNO.SDS.VideoStation2.DTV.get(),SYNO.SDS.VideoStation2.DTV.EVENT_DTV_LOAD,t,this,{single:!0}),SYNO.SDS.VideoStation2.DTVController.loadDTV()}.bind(this))},initHistoryController:function(){return new Promise(function(t,e){this.mon(SYNO.SDS.VideoStation2.HistoryController.get(),SYNO.SDS.VideoStation2.HistoryController.EVENT_HISTORYCONTROLLER_INITED,t,this,{single:!0}),SYNO.SDS.VideoStation2.HistoryController.get().init()}.bind(this))},getMsgBox:function(t){if(!this.msgBox||this.msgBox.isDestroyed){var e=t&&t.owner||this;e=e.isDestroyed?null:e,this.msgBox=new SYNO.SDS.VideoStation2.MessageBox({owner:e})}return this.callParent(arguments)},showAboutWindow:function(){return this.aboutWindow&&!this.aboutWindow.isDestroyed||(this.aboutWindow=new SYNO.SDS.VideoStation2.AboutWindow({owner:this,aboutHeader:this.aboutHeader,pkgColor:this.aboutTitleColor||"#0086E5"})),this.callParent(arguments)},onShowHideBackground:function(){var t=this.getEl();if(t){var e=SYNO.SDS.VideoStation2.View.get().getView(),i=SYNO.SDS.VideoStation2.Category.get().getCurrentCategory();t[e===SYNO.SDS.VideoStation2.View.VIEW_TVSHOW||e===SYNO.SDS.VideoStation2.View.VIEW_DETAIL||e===SYNO.SDS.VideoStation2.View.VIEW_POSTER&&i===SYNO.SDS.VideoStation2.Category.CATEGORY_TIME_LINE?"addClass":"removeClass"]("with-background")}},onBeforeRenderFn:function(){this.mon(SYNO.SDS.VideoStation2.WindowSize.get(),SYNO.SDS.VideoStation2.WindowSize.EVENT_SIZE_MODE_CHANGE,this.onSizeModeChange,this)},onResizeFn:function(t,e,i){if(e&&i){var o=e>=1760?SYNO.SDS.VideoStation2.WindowSize.LARGE_SIZE:SYNO.SDS.VideoStation2.WindowSize.NORMAIL_SIZE;SYNO.SDS.VideoStation2.WindowSize.get().setSizeMode(o)}},onSizeModeChange:function(){SYNO.SDS.VideoStation2.WindowSize.get().isLargeSizeMode()?this.addClass("syno-vs2-large-size"):this.removeClass("syno-vs2-large-size")},launchWizard:function(){if(_S("is_admin")&&!0!==SYNO.SDS.UserSettings.getProperty("SYNO.SDS.VideoStation.AppInstance","hide_vs2_wizard")){new SYNO.SDS.VideoStation2.Wizard({owner:this}).open()}}});
