#!/bin/sh

SYS_CLASS_DVB="/sys/class/dvb"
IS_FIRST_DONGLE="yes"
USB_DEV_MAPPING="/usr/syno/etc.defaults/usb.map"

getContent()
{
	local FILENAME=$1

	if [ ! -e ${FILENAME} ]; then
		echo "file not found"
		return;
	fi
	
	local CONTENT=`cat ${FILENAME}`
	echo ${CONTENT}
}

getVendorFromVID()
{
	local VendorID=$1

	local RET=`cat ${USB_DEV_MAPPING} | grep "^${VendorID}" | awk -F'  ' '{print $2}'`

	echo ${RET}
}

getProductFromVIDPID()
{
	local VendorID=$1
	local ProductID=$2
	local TEMP="./temp.txt"
	local REP='$1'
	local REP2='$2'

	awk "/^${VendorID}/,(/^[0-9a-z]/&&!/${VendorID}/)" /usr/syno/etc.defaults/usb.map | grep -v "^[0-9a-z]" > ${TEMP}
	RET=`awk -F'  ' "${REP}==${ProductID} {print ${REP2}}" ${TEMP}`
	rm ${TEMP}
	echo "${RET}"
}

getREVFromVIDPID()
{
	local VendorID=$1
	local ProductID=$2
	local SN=$3
	local REP=`/bin/cat /proc/bus/usb/devices | grep -B 30 "SerialNumber=${SN}"  | grep "Vendor=${VendorID} ProdID=${ProductID}" | tail -n 1 | awk -F"=" '{print $4}'`
	echo "${REP}"
}

echo "{"
echo "\"dvb_dongles\": ["
if [ -d ${SYS_CLASS_DVB} ]; then
	DVB_DONGLES=`ls ${SYS_CLASS_DVB} | grep frontend0`
	for DONGLE in ${DVB_DONGLES}; do
		if [ "yes" == ${IS_FIRST_DONGLE} ]; then
			IS_FIRST_DONGLE="no"
		else
			echo ","
		fi
		DVB_INFO_LINK="${SYS_CLASS_DVB}/${DONGLE}"
		if [ -d ${DVB_INFO_LINK}/device ]; then
			DVB_INFO_BASE="${SYS_CLASS_DVB}/${DONGLE}/device"
		else
			DVB_INFO_BASE="${SYS_CLASS_DVB}/${DONGLE}/../.."
		fi
		[ ! -e ${DVB_INFO_BASE}/bInterfaceClass     ] || DVB_INFO_BASE="${DVB_INFO_BASE}/../"

		VID="unknown"
		PID="unknown"
		MANUFACTURER="unknown"
		PRODUCT="unknown"
		REV="unknown"
		DONGLEPRODUCT="unknown"

		[ ! -e ${DVB_INFO_BASE}/idVendor     ] || VID=`getContent ${DVB_INFO_BASE}/idVendor`
		[ ! -e ${DVB_INFO_BASE}/idProduct    ] || PID=`getContent ${DVB_INFO_BASE}/idProduct`
		[ ! -e ${DVB_INFO_BASE}/serial       ] || SN=`getContent ${DVB_INFO_BASE}/serial`
		REV=`getREVFromVIDPID ${VID} ${PID} ${SN}`
		MANUFACTURER=`getVendorFromVID ${VID}`
		PRODUCT=`getProductFromVIDPID  ${VID} ${PID}`
		[ ! -e ${DVB_INFO_BASE}/product      ] || DONGLEPRODUCT=`getContent ${DVB_INFO_BASE}/product`
		echo "{"
		echo "    \"vid\":\"${VID}\","
		echo "    \"pid\":\"${PID}\","
		echo "    \"rev\":\"${REV}\","
		echo "    \"manufacturer\":\"${MANUFACTURER}\","
		echo "    \"product\":\"${PRODUCT}\","
		echo "    \"dongle_product\":\"${DONGLEPRODUCT}\""
		echo "}"
	done
fi

echo "]"
echo "}"

