#!/bin/bash
ScriptDir=$(dirname `readlink -f $0`)
. $ScriptDir/../pkg_util.sh

dump_content()
{
	local file=$1 out=$2
	cat > "$out" <<EOF
[{
	"step_title": "$(pkg_get_string $file wizard wp_wizard_msql_password_title)",
	"items": [{
		"type": "password",
		"desc": "$(pkg_get_string $file wizard wp_wizard_msql_password_desc)",
		"subitems": [{
			"key": "pkgwizard_mysql_password",
			"desc": "$(pkg_get_string $file wizard wp_wizard_msql_password_label)"
		}]
	}]
}]
EOF
}

for lan in $UISTRING_PATH/*; do
	lan=$(basename "$lan")
	file="$UISTRING_PATH/$lan/strings"

	if [ ! -r "$file" ]; then
		continue;
	fi

	dump_content $file ${WIZARD_UIFILES}/install_uifile_$lan
	ln ${WIZARD_UIFILES}/install_uifile_$lan ${WIZARD_UIFILES}/upgrade_uifile_$lan
	if [ "$lan" = "enu" ]; then
		cp ${WIZARD_UIFILES}/install_uifile_$lan ${WIZARD_UIFILES}/install_uifile
		ln ${WIZARD_UIFILES}/install_uifile ${WIZARD_UIFILES}/upgrade_uifile
	fi
done
