#!/bin/bash

# define main function
MAIN_INSTALL="main_install"
MAIN_UPGRADE="main_upgrade"
MAIN_UNINST="main_uninst"
# define each page's name
PAGE_MARIADB5="page_mariadb5"
PAGE_MARIADB10="page_mariadb10"
PAGE_RESTORE="page_restore"
PAGE_DB="page_db"
PAGE_UNINST="page_uninst"
DEFAULT="enu"
# set out file name
OUTPUT_INSTALL="install_uifile"
OUTPUT_UPGRADE="upgrade_uifile"
OUTPUT_UNINST="uninstall_uifile"
INIT_DB_NAME="" # need to be overwrited
INIT_DB_USER="" # need to be overwrited
INFO_FILE="" # need to be overwrited
BACKUP_PATH="" # need to be overwrited
# here to define what page is necessary for each stage: install, upgrade, and uninstall
PAGE_INST="$PAGE_MARIADB5 $PAGE_RESTORE $PAGE_MARIADB10 $PAGE_DB $MAIN_INSTALL"
PAGE_UPGRADE="$PAGE_MARIADB5 $PAGE_MARIADB10 $PAGE_DB $MAIN_UPGRADE"
PAGE_UNINST="$PAGE_UNINST $MAIN_UNINST"
MIGRATE_DB_VERSION="-1"

MainCreate()
{
	local output="$1"
	local pages="$2"
	local main_function="$3"
	local lan
	for dir in lang/*; do
		lan=$(basename "$dir")
		cat "wizard_common" "wizard_customized" > "${output}_${lan}.sh"
		CustomWizCreate "${output}_${lan}.sh"
		cat "lang/$lan" $pages "$main_function" >> "${output}_${lan}.sh"
	done
	chmod +x "${output}"*.sh
	cp -a "${output}_${DEFAULT}.sh" "${output}.sh"
}

NeedMigrateDB()
{
	local version="$1"
	if [ -z "$version" ] || [ "$version" -le "$MIGRATE_DB_VERSION" ]; then
		return 0
	fi
	return 1
}

CustomHasRunWebsiteSetup()
{
	local path="$1"
	[ -s "$path/$CONF_FILE" ]
}

CustomWizCreate()
{
	:
}

CustomSetBackupPath()
{
	BACKUP_PATH="$(CustomGetBackupPkgPath)"
}

CustomMainInstall()
{
	:
}

CustomGetValueFromMetaFile()
{
	local key="$1"
	local backup_info="/var/packages/.$PKG_DIR.conf"
	local syno_conf="/var/packages/$PKG_NAME/synology.conf"
	local record_file=""

	if [ -s "$INFO_FILE" ]; then
		record_file="$INFO_FILE"
	elif [ -s "$backup_info" ]; then
		record_file="$backup_info"
	elif [ -s "$syno_conf" ]; then
		record_file="$syno_conf"
	fi
	get_key_value "$record_file" "$key"
}

CustomGetBackupPrefix()
{
	local backup_prefix="/$(readlink /var/services/web | cut -d/ -f2)/@appstore/.$PKG_DIR"
	echo "$backup_prefix"
}

CustomGetBackupPkgPath()
{
	local backup_pkg_path="$(CustomGetBackupPrefix)/$PKG_DIR"
	echo "$backup_pkg_path"
}

# we define pages in fuction not in global variables,
# because functions in wizard steps will be merged after calling MainCreate.
CustomSetPages()
{
	NEW_INSTALL_PAGES="$(PageM10),$(PageDB)"
	RESTORE_PAGES="$(PageRestore),$(PageM10),$(PageDB)"
	MIGRATE_PAGES="$(PageM5),$(PageRestore),$(PageM10),$(PageDB)"
}

CustomParseDBConf()
{
	:
}

CustomGetDBName()
{
	:
}

CustomGetDBUser()
{
	:
}

CustomGetDBPass()
{
	:
}

CustomPageActivate()
{
	:
}
#!/bin/bash

PKG_NAME="WordPress"
PKG_DIR="wordpress"
WEBSITE_ROOT="/var/services/web/$PKG_DIR"
CONF_FILE="wp-config.php"
MIGRATE_DB_VERSION="0134"
CONFIG_SAMPLE="wp-config-sample-0121.php"
INIT_DB_NAME="wordpress"
INIT_DB_USER="wordpress_user"
INFO_FILE="/usr/syno/etc/packages/$PKG_NAME/$PKG_DIR.conf"

CustomWizCreate()
{
	local output="$1"
	echo "WP_CONF_FILE='" >> "${output}"
	cat "$CONFIG_SAMPLE" | openssl enc -A -base64 >> "${output}"
	echo "'" >> "${output}"
}

CustomSetBackupPath()
{
	BACKUP_PATH="$(CustomGetBackupPrefix)"
}

CustomMainInstall()
{
	if [ -d "$BACKUP_PATH" ]; then
		GEN_WP_CONF "$BACKUP_PATH"
	fi
}

GEN_WP_CONF()
{
	local path="$1"
	# before 0122, no version value record
	local version=$(get_key_value "$INFO_FILE" "version")
	if [ ! -s "$path/$CONF_FILE" ] && [ -z "$version" ]; then
		# We need to add back the wp-config.php
		echo "$WP_CONF_FILE" | openssl enc -base64 -d > "$path/$CONF_FILE"
		sed -i "s|'DB_NAME',.*|'DB_NAME','wordpressblog');|g" "$path/$CONF_FILE"
		sed -i "s|'DB_USER',.*|'DB_USER','wordpress');|g" "$path/$CONF_FILE"
		sed -i "s|'DB_PASSWORD',.*|'DB_PASSWORD','');|g" "$path/$CONF_FILE"
	fi
}


CustomParseDBConf()
{
	local path="$1"
	local db_info="$2"
	local grep_info="$3"
	local info_output=$(CustomGetValueFromMetaFile "$db_info")

	if [ -z "$info_output" ] && [ -s "$path/$CONF_FILE" ]; then
		info_output=$(grep "$grep_info" "$path/$CONF_FILE" | cut -d\' -f4 | UnQuotePHP)
	fi

	echo "$info_output"
}

CustomGetDBName()
{
	local db_name=$(CustomParseDBConf "$1" "db_name" "DB_NAME")
	if [ -z "$db_name" ]; then
		db_name="$pkgwizard_db_name"
	fi
	echo "$db_name"
}

CustomGetDBUser()
{
	local db_user=$(CustomParseDBConf "$1" "db_user" "DB_USER")
	if [ -z "$db_user" ]; then
		db_user="$pkgwizard_db_user_account"
	fi
	echo "$db_user"

}

CustomGetDBPass()
{
	CustomParseDBConf "$1" "db_pass" "DB_PASSWORD"
}

UnQuotePHP()
{
	sed -e "s|\\\\'|'|g" -e 's|\\\\|\\|g'
}
WP_CONF_FILE='
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'
wizard_db_settings="Skonfiguruj bazę danych WordPress"
wizard_db_name_desc="Wprowadź nazwę bazy danych WordPress."
wizard_db_name_label="Nazwa bazy danych"
wizard_m10_desc="Wprowadź poświadczenia administratora MariaDB 10, aby kontynuować konfigurację bazy danych WordPress."
wizard_admin_acc="Konto"
wizard_admin_pass="Hasło"
wizard_set_db_desc="Utwórz nowe odrębne konto bazy danych dla WordPress, aby użyć istniejących/nowych danych."
wizard_set_data_title="Konfiguruj WordPress"
wizard_found_backup="Wybierz metodę importu danych."
wizard_decide_restore="WordPress — baza danych już istnieje.<br>Wybierz dowolną z następujących akcji:"
wizard_restore="Użyj istniejących danych"
wizard_create_new="Czysta instalacja (wszystkie istniejące dane, w tym pliki konfiguracyjne i baza danych, zostaną usunięte)."
wizard_db_user_account_desc="Konto użytkownika bazy danych"
wizard_db_user_password_desc="Hasło użytkownika bazy danych"
wizard_migrate_note="Najnowsza wersja WordPress obsługuje tylko aplikację MariaDB 10.<br>System wykrył jedynie istniejąca bazę danych MariaDB 5.<br>W kolejnym kroku nastąpi migracja bazy danych z MariaDB 5 do MariaDB 10.<br><br>Wprowadź poświadczenia administratora MariaDB 5, aby kontynuować instalację."
wizard_migrate_title="Migruj bazę danych WordPress"
wizard_remove_msql_title="Usuń bazę danych WordPress"
wizard_remove_msql_desc="Po usunięciu bazy danych WordPress wszystkie dane zostaną usunięte."
wizard_msql_password_desc_remove="Wprowadź poświadczenia administratora bazy danych, aby usunąć bazę danych WordPress."
wizard_admin_acc="Konto"
wizard_admin_pass="Hasło"
PageUninst()
{
cat << EOF
{
	"step_title": "$wizard_remove_msql_title",
	"items": [{
		"type": "multiselect",
		"desc": "$wizard_remove_msql_desc",
		"subitems": [{
			"key": "pkgwizard_remove_mysql",
			"desc": "$wizard_remove_msql_title"
		}]
	}, {
		"type": "textfield",
		"desc": "$wizard_msql_password_desc_remove",
		"subitems": [{
			"key": "wizard_m10_acc",
			"desc": "$wizard_admin_acc",
			"defaultValue": "root"
		}]
	}, {
		"type": "password",
		"subitems": [{
			"indent": 1,
			"key": "wizard_m10_pass",
			"desc": "$wizard_admin_pass"
		}]
	}]
}
EOF
}
main()
{
	local uninst_page="$(PageUninst)"
	echo "[$uninst_page]" > "${SYNOPKG_TEMP_LOGFILE}"

	return 0
}

main "$@"
main()
{
	local uninst_page="$(PageUninst)"
	echo "[$uninst_page]" > "${SYNOPKG_TEMP_LOGFILE}"

	return 0
}

main "$@"
