10 REM Ten-Tec RX-320 test program
20 LNVOL=25		' Line-out volume
30 '
40 AMMODE=ASC("0"):CWMODE=ASC("3"):USBMODE=ASC("1"):LSBMODE=ASC("2") ' modes defined
50 DIM FILTERS(34)	' array to hold filter list
60 GOSUB 1360		' preload filters[] array
70 D$=CHR$(13)		' carriage return defined
80 SPKVOL=30		' speaker volume
90 MODE=AMMODE		' detection mode
100 RADIOFREQ=.93	' tuned frequency
110 FILTER=0     	' filter number from filter list
120 CWBFO=0
130 '
140 OPEN "com1:1200,n,8,1,rs,ds" AS #2
150 ' main routine
160 CLS
170 GOSUB 320
180 GOSUB 1030
190 GOSUB 440
200 GOSUB 1130
210 C$=INKEY$ : IF C$="" GOTO 210
220 IF C$="1" THEN GOSUB 570:GOTO 150:ELSE
230 IF C$="2" THEN GOSUB 770:GOTO 150:ELSE
240 IF C$="3" THEN GOSUB 590:GOTO 150:ELSE
250 IF C$="4" THEN GOSUB 890:GOTO 150:ELSE
260 IF C$="5" THEN GOSUB 940:GOTO 150:ELSE
270 IF C$="6" THEN GOSUB 990:GOTO 150:ELSE
280 IF C$="7" THEN GOSUB 1260:GOTO 150:ELSE
290 IF C$="8" THEN GOTO 310
300 GOTO 150
310 CLOSE:END
320 ' Tuning Factor Calculations
330 IF MODE=AMMODE THEN MCOR=0 
340 IF MODE=CWMODE THEN MCOR=-1
350 IF MODE=USBMODE THEN MCOR = 1
360 IF MODE=LSBMODE THEN MCOR= -1
370 FCOR = FILTERS[FILTER]/2+200
380            ADJFREQ=RADIOFREQ-.00125+(MCOR*((FCOR+CWBFO)/1000000!))
390		CTVAL=INT(ADJFREQ*400!)
400		FTVAL=INT(((ADJFREQ*400!)-CTVAL)*2500!*5.46)
410		CTVAL=CTVAL+18000
420            BTVAL=INT((FCOR+CWBFO+8000)*2.73)
430 RETURN
440 ' Menu
450 'CLS
460 LOCATE 1,15: PRINT "Ten-Tec RX-320 PC RADIO Interface Demonstration"
470 LOCATE 4,20: PRINT "       1 .. Frequency "
480 LOCATE 5,20: PRINT "       2 .. Filter"
490 LOCATE 6,20: PRINT "       3 .. Mode"
500 LOCATE 7,20: PRINT "       4 .. Speaker Volume"
510 LOCATE 8,20: PRINT "       5 .. Line Out Volume"
520 LOCATE 9,20: PRINT "       6 .. Bfo"
530 LOCATE 10,20: PRINT"       7 .. Query DSP Revision #"
540 LOCATE 11,20: PRINT"       8 .. Quit The Program"
550 LOCATE 16,25: PRINT"      Make Selection "
560 RETURN
570 LOCATE 16,25: INPUT "Enter Frequency (MHz) ";RADIOFREQ
580 RETURN
590 CLS:
600 GOSUB 730
610 LOCATE  4,25: PRINT "Currently in ";MD$
620 LOCATE  6,25: PRINT "1 .. AM Mode"
630 LOCATE  8,25: PRINT "2 .. USB Mode"
640 LOCATE 10,25: PRINT "3 .. LSB Mode
650 LOCATE 12,25: PRINT "4 .. CW Mode"
660 LOCATE 16,25: PRINT "Select New Mode"
670 C$=INKEY$:IF C$="" GOTO 670
680 IF C$="1" THEN MODE=AMMODE
690 IF C$="2" THEN MODE=USBMODE
700 IF C$="3" THEN MODE=LSBMODE
710 IF C$="4" THEN MODE=CWMODE
720 RETURN
730 ' convert MODE code to text name of mode
740 IF MODE=AMMODE THEN MD$="AM MODE" : IF MODE=LSBMODE THEN MD$="LSB MODE"
750 IF MODE=USBMODE THEN MD$="USB MODE" : IF MODE=CWMODE THEN MD$="CW MODE"
760 RETURN
770 ' FILTER SELECTION SUBROUTINE
780 CLS:
790 FOR N=0 TO 10
800 LOCATE N+1,20: PRINT N;" ";FILTERS[N]
810 LOCATE N+1,40: PRINT N+11;" ";FILTERS[N+11]
820 LOCATE N+1,60: PRINT N+22;" ";FILTERS[N+22]
830 NEXT N
840 LOCATE 12,60: PRINT 33;" ";FILTERS[33]
850 LOCATE 16,25 : INPUT "Enter Fileter Number (0-33) ";FILTER
860 IF FILTER <0 GOTO 850 
870 IF FILTER >33 GOTO 850
880 RETURN
890 ' SPEAKER VOLUME
900 LOCATE 16,25:INPUT "Speaker Volume Setting (0-63) (soft->loud) ";SPKVOL
910 IF SPKVOL<0 GOTO 900
920 IF SPKVOL>63 GOTO 900
930 RETURN
940 ' LINE OUT VOLUME
950 LOCATE 16,25: INPUT "Line Out Volume Setting (0-63) (soft->loud) ";LNVOL
960 IF LNVOL<0 GOTO 950
970 IF LNVOL>63 GOTO 950
980 RETURN
990 LOCATE 16,25: INPUT "Enter Bfo Frequency (0-2000Hz) ";CWBFO
1000 IF CWBFO<0 GOTO 990
1010 IF CWBFO>2000 GOTO 990
1020 RETURN
1030 'SUBROUTINE TO FORMAT CALCULATED PARAMETERS AND SEND TO RADIO
1040 NH=INT(CTVAL/256):NL=CTVAL-NH*256
1050 FH=INT(FTVAL/256):FL=FTVAL-FH*256
1060 BH=INT(BTVAL/256):BL=BTVAL-BH*256
1070 C$="W"+CHR$(FILTER)+D$:PRINT #2,C$;
1080 C$="N"+CHR$(NH)+CHR$(NL)+CHR$(FH)+CHR$(FL)+CHR$(BH)+CHR$(BL)+D$:PRINT #2,C$;
1090 C$="A"+CHR$(127)+CHR$(63-LNVOL)+D$:PRINT #2,C$;
1100 C$="V"+CHR$(127)+CHR$(63-SPKVOL)+D$:PRINT #2,C$;
1110 C$="M"+CHR$(MODE)+D$:PRINT #2,C$;ELSE
1120 RETURN
1130 'display current settings
1140 GOSUB 730
1150 LOCATE 20,2 : PRINT "Freq= ";RADIOFREQ
1160 LOCATE 21,2 : PRINT "Mode= ";MD$
1170 LOCATE 22,2 : PRINT "Filt= ";FILTERS(FILTER)
1180 LOCATE 20,25: PRINT "spkr= ";SPKVOL
1190 LOCATE 21,25: PRINT "Line= ";LNVOL
1200 LOCATE 22,25: PRINT " Bfo= ";CWBFO
1210 LOCATE 20,45: PRINT "Coarse Tune Factor= ";CTVAL
1220 LOCATE 21,45: PRINT "  Fine Tune Factor= ";FTVAL
1230 IF MODE=AMMODE THEN BTVAL=0	' btval is ignored by RX-320 in AM MODE
1240 LOCATE 22,45: PRINT "   Bfo Tune Factor= ";BTVAL
1250 RETURN
1260 ' Get DSP VERSION #
1270 IF LOC(2)<>0 THEN INPUT#2,C$			' read port first to empty any old data
1280 C$="?"+D$:PRINT#2,C$;
1290 GOSUB 1430
1300 IF LOC(2)=<7 THEN GOTO 1300			
1310 VER$=INPUT$(LOC(2),2)
1320 LOCATE 16,26: PRINT "DSP REPORTS ";VER$
1330 LOCATE 18,26 : PRINT "Press Any Key To Continue"
1340 C$=INKEY$:IF C$="" GOTO 1330
1350 RETURN
1360 ' load filter array
1370 FOR N=0 TO 33 STEP 1
1380 READ FILTERS(N)
1390 NEXT N
1400 RETURN
1410 DATA 6000,5700,5400,5100,4800,4500,4200,3900,3600,3300,3000,2850,2700,2550,2400,2250,2100,1950,1800
1420 DATA 1650,1500,1350,1200,1050, 900, 750, 675, 600, 525, 450, 375, 330, 300,8000
1430 ' DELAY ROUTINE
1440 FOR D=1 TO 20000
1450 NEXT D
1460 RETURN
