#include <afxwin.h>

#ifndef _CMAINWIN_
#define _CMAINWIN_

// This is the main Derived window class.
class CMainWin:public CFrameWnd
{
	CDC m_memDC;
    BOOL TopMostWindow;
public:
	CMainWin();
	void CMainWin::HamCallTest();

	int CMainWin:: decode_response(char *string);
	void CMainWin::OnViewCallLookup();

	void CMainWin::WakeUpRadio();
	void CMainWin::ActivateRadioMode();
	void CMainWin::OpenLogFile();
	void CMainWin::CloseLogFile();
	void CMainWin::AddToLogWindowOut(CString dstring);
	void CMainWin::AddToLogWindowIn(CString dstring);
	int CMainWin::GetCommPortCount();

	void CMainWin::UpdateHamBandRegisters(double freq);
	void CMainWin::SetTxEnableState(BOOL state);
	void CMainWin::SetTxLoopState(BOOL state);
	void CMainWin::SetTxFilter(int index);
	void CMainWin::SetAdaptiveFilterStates(BOOL bNRstate,BOOL bANstate);
	void CMainWin::SetSquelch(char s_units);
	void CMainWin::SetKeyerSpeed(int iSpeed, int iWeighting);
	void CMainWin::SetKeyerState(BOOL state);
	void CMainWin::SetAuxTxHang(unsigned int ihang);
	void CMainWin::ShowRemoteTuneSelection();
	void CMainWin::SetCWQSK(int setting);

	void SetCWSidetoneVolume(int vol);
	void OnTxOpsPanelChanged();
	void CMainWin::SelectTxAudio(char select);
	void CMainWin::SetVoxGain(int setting);
	void CMainWin::SetAntiVox(int setting);
	void CMainWin::SetVoxHang(int setting);
	void CMainWin::SetManualTxState(BOOL bSet); 
	void CMainWin::SetVoxState(BOOL bSet);
	void CMainWin::SetMonitor(int setting);
 
	void InitializeTXOpsWindow();
	void CMainWin::ViewTransmitOptions();
	void CMainWin::OnMonitorQueryFwd();
	void CMainWin::OnMonitorQueryRef();
	void CMainWin::OnMonitorQuerySMeter();
	void CMainWin::OnMonitorQueryEnvelope();
	void CMainWin::SetRFGain(int attn);
	void CMainWin::OnMonitorWindowManualSend();

	int CMainWin::FilterTextToFilterNumber(const char* text);
	void CMainWin::CheckFilterHighlite(int filter);

	void CMainWin::OnClearMonitorWindow();
	void CMainWin::UpdateClearMonitorWindow(CCmdUI *pCmdUI);
	void CMainWin::SetAttnState(BOOL bSet);
	void CMainWin::SetMonitorState(BOOL bSet);
	void CMainWin::SetTuneState(BOOL bSet);

	void CMainWin::OnMonitorQueryEPort();
    void CMainWin::UpdateMonitorControls(CCmdUI *pCmdUI);
	void CMainWin::IncreasePower();
	void CMainWin::DecreasePower();


	afx_msg void OnSysColorChange();
	int CMainWin::BandwidthToFilterTable(int bw);
	int CMainWin::FilterBandwidth(int index);

	afx_msg void OnSize(UINT nType,int cx,int cy);
	void CMainWin::OnViewMonitorBar();
	void CMainWin::OnRunSpurCheck();

	void CMainWin::ReceiverHelp();
	void CMainWin::TroubleShootingHelp();
	void CMainWin::NormalizeRadio();
	void CMainWin::WindowOnTop();
	void CMainWin::WindowNotOnTop();
	void CMainWin::KillSplashShowRadio();
	void CMainWin::UpdateTopMostSelection(CCmdUI *pCmdUI);
	void CMainWin::ToggleTopMostSelection();
	void CMainWin::OnAbout();
	void CMainWin::SetAuxCodecVolume(int v);
	void CMainWin::OnSwlPanelChanged();
	void CMainWin::ShowTimeDialog();
	void CMainWin::OnTimeFreqChange();
 	void CMainWin::SetOutputPower(int power);

	void CMainWin::AddToDataOutWindow(CString dstring);
	void CMainWin::AddToDataInWindow(CString dstring);
	void CMainWin::SetCWSpotVolume(int vol);
	void FreeStationMemory();

	// Keyboard Related Handlers
	void KeyTuneUp();
	void KeyTuneDown();

	void IncreaseStep();
	void DecreaseStep();
    void IncreaseVolume();
    void DecreaseVolume();
	
    void UserOptions();
    void InterfaceOptions();
	void AccessStationMemories();
	LRESULT CMainWin::OnMemorySelect(WPARAM wParam,LPARAM lParam);
	// Radio Commands & Related Misc
	void SaveOperatingStatus();
    void GetOperatingStatus();
	void CMainWin::InitializeRadio();
	void CMainWin::SetRadioVolume(char vol);
	void CMainWin::SetRadioFilter(int filter);
	void SetMode(char rxmode,char txmode);
	void SetTxMode(char rxode,char txmode);
    void SetFilter(int number);

	void SetAgcMode(char iMode);

    void FreqToRadio(double Freq);
	void SendToRadio(char *comstring,int length);
	void SetRadioFrequencies();
	void SetTxFrequencies();

    void MuteAudio();
	LRESULT CMainWin::OnVolumeMove(WPARAM nID,LPARAM setting);
	void CMainWin::OnLookupCall();
	void CMainWin::LoadHamCallSupport();


	// Misc System related
	void CMainWin::InitializeCommPort();
	void LoadNewIcon(LPCSTR nNewIcon);
	HICON GetClassIcon();
	void SetClassIcon(HICON hIconID);
	void CMainWin::RecallMemFile();
 	// General & Misc Message Handlers
	afx_msg LRESULT OnCommNotify(WPARAM wParam,LPARAM lParam);
	BOOL CMainWin::OnEraseBkgnd(CDC* pDC);
	afx_msg int CMainWin::OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void CMainWin::OnClose();
	afx_msg void OnTimer(UINT TimerID);
    afx_msg void	OnUpdateFreqDisplay();
	afx_msg	void	OnPaint();
	afx_msg void 	OnVScroll(UINT SBCode, UINT Pos,CScrollBar *SB);
	afx_msg void	OnExit();
    BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest,UINT message);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void CMainWin::HandleFileOpen();
    afx_msg void CMainWin::HandleFileSaveAs();
	afx_msg void CMainWin::UseComm1();	
	afx_msg void CMainWin::UseComm2();
	afx_msg void CMainWin::UseComm3();
	afx_msg void OnActivate(UINT nState,CWnd* pOtherWnd,BOOL bMinimized);
	void OnMemRecall();
	void PreloadStations();
	static int FrequencyToIndex(double tfreq);	// Is Current Frequency in List???
	afx_msg void TuneToWWV();
	void CMainWin::AddStation();
	void SetFocusToMain();
	void ProgTuneUp(double FreqDelta);
	void ProgTuneDown(double FreqDelta);


	void CMainWin::OnViewShortWave();
	void CMainWin::UpdateViewShortWave(CCmdUI *pCmdUI);
	void ProgramRadio(double NewFreq,char NewMode,int NewStep=NULL,int NewFilter=NULL);
	afx_msg void OnSysCommand( UINT nID, LPARAM lParam );
	void CMainWin::OnViewSweepPanel();
	void CMainWin::UpdateViewSweepPanel(CCmdUI *pCmdUI);
	void CMainWin::OnViewStationPanel();
	void CMainWin::UpdateViewStationPanel(CCmdUI *pCmdUI);

	afx_msg void OnUpdateFileOpen(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSaveAs(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileClose(CCmdUI* pCmdUI);
 	void OpenFile();
	void SaveAsFile();
	void SaveFile();
	void UpdateFileName();
	void CloseFile();
	void OnViewControlBar();
	afx_msg void UpdateViewControlBar(CCmdUI *pCmdUI);
	void CMainWin::UpdateMenuFileSave(CCmdUI *pCmdUI);
	void CMainWin::UpdateMenuFileClose(CCmdUI *pCmdUI);
	void CMainWin::UpdateMenuFileSaveAs(CCmdUI *pCmdUI);
	void CMainWin::UpdateLookupCall(CCmdUI *pCmdUI);

	void CMainWin::SMeterTrigger();
	void CMainWin::SpectrumSweep();
	void CMainWin::SignalLevel(double sFreq,unsigned Sig);

	void CMainWin::StopSpectrumSweep();
	void CMainWin::OnSweepClickFrequency();

	void CMainWin::ClearSpectrumArray();
	void CMainWin::ShowTimedMessageWindow(const char* msg);
	void CMainWin::RemoveTimedMessageWindow();
	void CMainWin::GetDSPVersion();
	void SetModeAM();
    void SetModeCW();
    void SetModeLSB();
    void SetModeUSB();
	void SetModeFM();
	int load_band_definitions();
	void FreeBandListMemory();

	void CMainWin::UpdateASCIIDataFile();
	void CMainWin::CheckASCIIDataFile();


protected:
	

	DECLARE_MESSAGE_MAP()
};

#endif // CmainWin