// CNumericEdit Class Header File
// A Special Edit Class Derived From CEdit class that allows only numeric 
// Data to be entered.

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.

#include "stdafx.h"
#include "cnum_ed.h"
#include <ctype.h>

IMPLEMENT_DYNAMIC(CNumericEdit,CEdit)

// CNumeric Edit MEssage Map
BEGIN_MESSAGE_MAP(CNumericEdit, CEdit)
	ON_WM_CHAR()
	ON_WM_SETFOCUS()
END_MESSAGE_MAP()

void CNumericEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	if(nChar=='\r')
	{
		SetFocusToParent();
		GetParent()->SendMessage(WM_COMMAND,GetDlgCtrlID(),(LPARAM) 0);

	}
	

	if(isalpha(nChar))
	{ 
    CString tstring;
	GetWindowText(tstring);
	if(nChar=='k' || nChar=='K' || nChar=='m' || nChar=='M') 
		{
		float tval;
		if(nChar=='k' || nChar=='K') (tval=(float) (atof(tstring)*1000.0));		
		if(nChar=='m' || nChar=='M') (tval=(float) (atof(tstring)*1.0e6));		
		SetNumeric(tval);
  		SetFocusToParent();
		GetParent()->SendMessage(WM_COMMAND,GetDlgCtrlID(),(LPARAM) 0);
		return;
		}	


	}

	CEdit::OnChar(nChar,nRepCnt,nFlags);
}


afx_msg void CNumericEdit::OnSetFocus(CWnd* pOldWnd)
{
	CEdit::OnSetFocus(pOldWnd);
}	


void CNumericEdit::SetNumeric(double dNum)
{
char vstring[12];
if(dNum >=1000.00) 
{
	sprintf(vstring,"%01.3f K",dNum/1000);
	SetWindowText(vstring);
	return;
}	

	else
{	

 
	sprintf(vstring,"%01.0f",dNum);
	SetWindowText(vstring);
}

}
                                          
double CNumericEdit::GetNumeric()
{
CString str;
GetWindowText(str);
double dNum=atof((const char*) str);
if (strpbrk("kK",(const char*) str)) dNum=dNum*1000;
if(strpbrk("mM",(const char*) str)) dNum=dNum*1e6;
return dNum;
}



void CNumericEdit::SetFocusToParent()
{
	GetParent()->SetFocus();
}
