// editstat.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
#include "tttrx.h"
#include "editstat.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern filter MasterFilterList_TX550[];

/////////////////////////////////////////////////////////////////////////////
// CEditStationDialog dialog


CEditStationDialog::CEditStationDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CEditStationDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditStationDialog)
	m_StationAddress = _T("");
	m_StationCountry = _T("");
	m_StationFrequency = 0.0f;
	m_StationLanguage = _T("");
	m_StationMode = _T("");
	m_StationName = _T("");
	m_StationFilter = "";
	//}}AFX_DATA_INIT
}


void CEditStationDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditStationDialog)
	DDX_Text(pDX, IDC_STATIONADDRESS, m_StationAddress);
	DDX_Text(pDX, IDC_STATIONCOUNTRY, m_StationCountry);
	DDX_Text(pDX, IDC_STATIONFREQUENCY, m_StationFrequency);
	DDV_MinMaxFloat(pDX, m_StationFrequency,0.1, 30.0);
	DDX_Text(pDX, IDC_STATIONLANGUAGE, m_StationLanguage);
	DDX_CBString(pDX, IDC_STATIONMODE, m_StationMode);
	DDX_Text(pDX, IDC_STATIONNAME, m_StationName);
	DDX_CBString(pDX, IDC_STATIONFILTER, m_StationFilter);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CEditStationDialog, CDialog)
	//{{AFX_MSG_MAP(CEditStationDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CEditStationDialog message handlers

BOOL CEditStationDialog::OnInitDialog()
{
int index;
	CDialog::OnInitDialog();

	CComboBox *lbptr = (CComboBox *) GetDlgItem(IDC_STATIONFILTER);

for(index=1;index<35;index++)
{

lbptr->AddString(MasterFilterList_TX550[index].name);
}
	lbptr->SetCurSel(lbptr->FindString(-1,m_StationFilter));
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
