
// Encoder.cpp
// Rotary Encoder implementation

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "resource.h"
#include "Encoder.h"
#include <math.h>
BEGIN_MESSAGE_MAP(CEncoder,CWnd)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_TIMER()
	ON_WM_MOUSEMOVE()
	ON_WM_SETCURSOR()
	ON_WM_RBUTTONDOWN()
END_MESSAGE_MAP()



CEncoder::CEncoder()
{
	RedDensity=100;
	m_Alpha=0;
	m_DelayTime=150;
	m_RepeatTime=10;
	m_Delta=45;	// step angle
	m_KnobActive=TRUE;
	m_ThumbKnob=TRUE;
}

CEncoder::Create(CRect sizepos,CWnd *PWnd,UINT nID,int steps=8,COLORREF backcolor=RGB(64,64,64))
{

m_hCursorCW=AfxGetApp()->LoadCursor(IDC_RIGHTARROW);
m_hCursorCCW=AfxGetApp()->LoadCursor(IDC_LEFTARROW);
//Create Window and Save Parameters that will be needed later
m_ControlID=nID;
m_Delta=360/steps;
WindowSize=CRect(0,0,sizepos.right-sizepos.left,sizepos.bottom-sizepos.top);
CWnd::Create(NULL,NULL,WS_CHILD|WS_VISIBLE,sizepos,PWnd,nID,NULL);
// Create a Device Context and Bitmap for the knob core. This will be used later
// to create the full knob. This method helps to speed-up the knob drawing process

CWindowDC cDC(this);
memDC1.CreateCompatibleDC(&cDC);
bmKnob1.CreateCompatibleBitmap(&cDC,WindowSize.right-WindowSize.left,
                            WindowSize.bottom-WindowSize.top);
memDC1.SelectObject(&bmKnob1);
memDC1.SetBkMode(OPAQUE);


brush1.CreateSolidBrush(RGB(160,160,164));
brush2.CreateSolidBrush(RGB(128,128,128));
brush3.CreateSolidBrush(RGB(128,128,128));
backbrush.CreateSolidBrush(backcolor);


LinePen1.CreatePen(PS_SOLID,1,RGB(128,128,128));
LinePen2.CreatePen(PS_SOLID,1,RGB(150,150,0));
LinePen3.CreatePen(PS_SOLID,1,RGB(128,128,128));

LinePen4.CreatePen(PS_SOLID,1,RGB(130,130,130));
LinePen5.CreatePen(PS_SOLID,1,RGB(0,0,0));

LinePen6.CreatePen(PS_SOLID,1,RGB(255,255,255));


// Draw the knob core without the finger hole
CRect rcClip;
rcClip=WindowSize;


CBrush* pOldBrush=memDC1.SelectObject(&brush1);
// Fill background of window with color

memDC1.SelectObject(&backbrush);
memDC1.PatBlt(rcClip.left,rcClip.top,rcClip.Width(),rcClip.Height(),PATCOPY);
// Draw Main Knob                     
rcClip.InflateRect(-2,-2);
memDC1.SelectObject(&brush2);
memDC1.SelectObject(&LinePen5);
memDC1.Ellipse(rcClip);

rcClip.InflateRect(-1,-1);
memDC1.SelectObject(&LinePen4);
memDC1.Ellipse(rcClip);

rcClip.InflateRect(-1,-1);
memDC1.SelectObject(&LinePen3);
memDC1.Ellipse(rcClip);

// Draw Highlight/Shadow area around knob
rcClip.InflateRect(1,1);
memDC1.SelectObject(&LinePen6);
memDC1.Arc(rcClip,CPoint(rcClip.right+1,rcClip.top),CPoint(rcClip.left,rcClip.bottom+1));
memDC1.SelectObject(&LinePen5);
memDC1.Arc(rcClip,CPoint(rcClip.left,rcClip.bottom),CPoint(rcClip.right,rcClip.top));

// Restore old brush
memDC1.SelectObject(pOldBrush);


return TRUE;

}


afx_msg void CEncoder::OnPaint()
{

CPaintDC pDC(this);

CBitmap	bmKnob;
CDC memDC;
CRect rcClip;
rcClip=WindowSize;

memDC.CreateCompatibleDC(&pDC);
bmKnob.CreateDiscardableBitmap(&pDC,WindowSize.right-WindowSize.left,
                            WindowSize.bottom-WindowSize.top);

memDC.SelectObject(&bmKnob);
memDC.BitBlt(0,0,WindowSize.right-WindowSize.left,
				WindowSize.bottom-WindowSize.top,&memDC1,0,0,SRCCOPY);

CBrush* pOldBrush=memDC.SelectObject(&brush2);

if(m_ThumbKnob)
{
	CRect thumb(LocateIndicator(35,m_Alpha));
	memDC.SelectObject(&LinePen5);

	memDC.Ellipse(thumb);
	// Unselect brush out of device context
	thumb.InflateRect(-1,-1);
	memDC.SelectObject(&LinePen4);
	memDC.Ellipse(thumb);

	thumb.InflateRect(-1,-1);
	memDC.SelectObject(&brush2);
	memDC.SelectObject(&LinePen1);
	memDC.Ellipse(thumb);
 
	thumb.InflateRect(+2,+2);
	CPoint ArcPoint1(thumb.right,thumb.top);
	CPoint ArcPoint2(thumb.left,thumb.bottom);

	memDC.SelectObject(&LinePen6);
	memDC.Arc(thumb,ArcPoint1,ArcPoint2);
	memDC.SelectObject(&LinePen5);
	memDC.Arc(thumb,ArcPoint2,ArcPoint1);

	thumb.InflateRect(-4,-4);
	CPoint ArcPoint3(thumb.right,thumb.top);
	CPoint ArcPoint4(thumb.left,thumb.bottom);

	memDC.SelectObject(&LinePen5);
	memDC.Arc(thumb,ArcPoint3,ArcPoint4);
	memDC.SelectObject(&LinePen6);
	memDC.Arc(thumb,ArcPoint4,ArcPoint3);




	memDC.SelectObject(pOldBrush);
}

pDC.BitBlt(0,0,WindowSize.right-WindowSize.left,
				WindowSize.bottom-WindowSize.top,&memDC,0,0,SRCCOPY);
memDC.DeleteDC();


}
	

afx_msg void CEncoder::OnLButtonDown(UINT flags,CPoint point)
{ 
if(m_KnobActive==FALSE) return;

switch(PointToQuadrant(point))
	{
	case 1: m_Rotation=CLOCKWISE;
		GetOwner()->SendMessage(ID_TEST,(WPARAM) m_ControlID,(LPARAM) CLOCKWISE);
		break;
	case 2: m_Rotation=CLOCKWISE;
		GetOwner()->SendMessage(ID_TEST,(WPARAM) m_ControlID,(LPARAM) CLOCKWISE);
		break;
	case 3: m_Rotation=COUNTERCLOCKWISE;
		GetOwner()->SendMessage(ID_TEST,(WPARAM) m_ControlID,(LPARAM) COUNTERCLOCKWISE);
		break;
	case 4: m_Rotation=COUNTERCLOCKWISE;
		GetOwner()->SendMessage(ID_TEST,(WPARAM) m_ControlID,(LPARAM) COUNTERCLOCKWISE);
 		break;
	default: return;
		break;

	}			
		
SetCapture();
m_MouseState=MOUSE_IN;

SetTimer(ID_TIMER_DELAY,m_DelayTime,NULL);
}


CRect CEncoder::LocateIndicator(int radius, double angle)
{
int cx,cy;           
int wh,ww;		// 1/2 indicator size
int rad;
// locate the center the knob
CPoint center((WindowSize.bottom-WindowSize.top)/2,
			(WindowSize.right-WindowSize.left)/2);
    wh=(WindowSize.bottom-WindowSize.top)/8;
	ww=(WindowSize.right-WindowSize.left)/8;
	rad=(int) ((WindowSize.right-WindowSize.left)*0.375)-5;
 	cx=	center.x-(int)(rad*sin(angle/57.296)),
 	cy=	center.y-(int)(rad*cos(angle/57.296));
 	return CRect(cx-ww,cy-wh,cx+ww,cy+wh);	
}
 
 


afx_msg void CEncoder::OnTimer(UINT timerID)
{
if(m_KnobActive==FALSE) return;

 if(timerID==ID_TIMER_DELAY)
 	{
 	KillTimer(ID_TIMER_DELAY);
 	SetTimer(ID_TIMER_REPEAT,m_RepeatTime,NULL);
 	}
if(m_MouseState==MOUSE_OUT) return;

	switch(m_Rotation)
	{
	case CLOCKWISE:
	GetOwner()->SendMessage(ID_TEST,(WPARAM) m_ControlID,(LPARAM) CLOCKWISE);
    break;
	case COUNTERCLOCKWISE:
	GetOwner()->SendMessage(ID_TEST,(WPARAM) m_ControlID,(LPARAM) COUNTERCLOCKWISE);
	break;
	}                   
}

afx_msg void CEncoder::OnLButtonUp(UINT flags,CPoint point)
{
KillTimer(ID_TIMER_DELAY);
KillTimer(ID_TIMER_REPEAT); 	
Invalidate(FALSE);
ReleaseCapture();
}


afx_msg void CEncoder::OnMouseMove(UINT nFlags, CPoint point)
{
CRect rect;
GetClientRect(rect);
int OldRotation=m_Rotation;
if(rect.PtInRect(point)) m_MouseState=MOUSE_IN;
else m_MouseState=MOUSE_OUT;
switch(PointToQuadrant(point))
{
	case 1: m_Rotation=CLOCKWISE;break;
	case 2: m_Rotation=CLOCKWISE;break;
	case 3: m_Rotation=COUNTERCLOCKWISE;break;
	case 4: m_Rotation=COUNTERCLOCKWISE;break;
}
if ((m_Rotation!=OldRotation) && (m_Rotation==COUNTERCLOCKWISE)) SetCursor(m_hCursorCCW);
if ((m_Rotation!=OldRotation) && (m_Rotation==CLOCKWISE)) SetCursor(m_hCursorCW);

}


afx_msg void CEncoder::OnRButtonDown(UINT flags,CPoint point)
{ 
//MessageBox("THIS IS AN RB ENC");
GetOwner()->SendMessage(IDM_STEPREQUEST,(WPARAM) m_ControlID,(LPARAM) CLOCKWISE);
}





afx_msg void CEncoder::OnLButtonDblClk(UINT nFlags,CPoint point)
{
OnLButtonDown(nFlags,point);
}


afx_msg void CEncoder::OnRButtonDblClk(UINT nFlags,CPoint point)
{
OnRButtonDown(nFlags,point);
}



void CEncoder::SetRates(int Delay,int Repeat)
{
m_DelayTime=Delay;
m_RepeatTime=Repeat;
}

void CEncoder::MoveEncoder(UINT direction)
{
if(m_KnobActive==FALSE) return;

 switch(direction)
 {
 case COUNTERCLOCKWISE:
 m_Alpha=m_Alpha+m_Delta;
 if(m_Alpha>360) m_Alpha=m_Alpha-360;
 Invalidate(FALSE);
 break;
 case CLOCKWISE:
 m_Alpha=m_Alpha-m_Delta;
 if(m_Alpha<0) m_Alpha=m_Alpha+360;
 Invalidate(FALSE);
 break;
 }
}


void CEncoder::SetEncoderState(BOOL state)
{
 m_KnobActive=state;
 return;
}
  
BOOL CEncoder::GetEncoderState()
{
 return m_KnobActive;

}


int CEncoder::PointToQuadrant(CPoint point)
{  
// determine the quadrant that the cursor is in
//    II| I
//  ....|......
//      |
//  III |  IV
int centerx=(WindowSize.right-WindowSize.left)/2;
int centery=(WindowSize.bottom-WindowSize.top)/2;
CRect QuadrantI(centerx,WindowSize.top,WindowSize.right,centery);
CRect QuadrantII(WindowSize.left,WindowSize.top,centerx,centery);
CRect QuadrantIII(WindowSize.left,centery,centerx,WindowSize.bottom);
CRect QuadrantIV(centerx,centery,WindowSize.right,WindowSize.bottom);

if (QuadrantI.PtInRect(point)) return 1;
if (QuadrantII.PtInRect(point)) return 2;
if (QuadrantIII.PtInRect(point)) return 3;
if (QuadrantIV.PtInRect(point)) return 4;
return 0;
}


BOOL CEncoder::OnSetCursor(CWnd* pWnd, UINT nHitTest,UINT message)
{
if(m_MouseState==MOUSE_IN && m_Rotation==CLOCKWISE) 
{
SetCursor(m_hCursorCW);
return TRUE;
}

if(m_MouseState==MOUSE_IN && m_Rotation==COUNTERCLOCKWISE) 
{                                                           
SetCursor(m_hCursorCCW);
return TRUE;
}
return FALSE;
}
