// Encoder.H 
// Rotary Encoder header file
//
#ifndef _ENCODER_H_
#define _ENCODER_H_

#include <afxwin.h>


#define ID_TIMER_DELAY 800
#define ID_TIMER_REPEAT 801
#define ID_TEST		350
#define IDM_STEPREQUEST		365
#define MOUSE_IN 1   

#define MOUSE_OUT 2

#define CLOCKWISE 3
#define COUNTERCLOCKWISE 4

class CEncoder:public CWnd
{
HCURSOR m_hCursorCW;
HCURSOR m_hCursorCCW;

CRect WindowSize;
char RedDensity;
CBitmap bmKnob1;	// bitmap to store knob drawing into
CDC memDC1;
CBrush brush1,brush2,brush3,backbrush;
CPen LinePen1,LinePen2,LinePen3,LinePen4,LinePen5,LinePen6;
BOOL m_KnobActive;
UINT m_ControlID;
public:
BOOL m_ThumbKnob;
	CEncoder();
	afx_msg void OnPaint();
    BOOL Create(CRect sizepos,CWnd *PWnd,UINT nID,int steps,COLORREF backcolor);
	afx_msg void OnLButtonDown(UINT flags,CPoint where);
	afx_msg void OnLButtonUp(UINT flags,CPoint where);
	afx_msg void OnRButtonDown(UINT flags,CPoint where);
	afx_msg void OnMouseMove(UINT nFlags,CPoint point);
	afx_msg void OnTimer(UINT timerID);
	afx_msg void OnRButtonDblClk(UINT nFlags,CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags,CPoint point);
	afx_msg void MoveEncoder(UINT direction);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest,UINT message);

	void SetRates(int Delay,int Repeat);
	void SetEncoderState(BOOL state);
	BOOL GetEncoderState();

protected:
	CRect LocateIndicator(int radius, double angle);
	short m_MouseState;
	short m_Rotation;
	int m_Alpha,m_DelayTime,m_RepeatTime,m_Delta;
	int PointToQuadrant(CPoint point);

	DECLARE_MESSAGE_MAP()    

};
#endif

	