// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and Microsoft
// QuickHelp documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

/////////////////////////////////////////////////////////////////////////////
// Miscellaneous System/Screen metrics

class CEtc
{
public:
	CEtc();
	~CEtc();
	void UpdateSysColors();

	// System metrics
	int     cxVScroll, cyHScroll;
	int     cxIcon, cyIcon;

	// Device metrics for screen
	int     cxPixelsPerInch, cyPixelsPerInch;
	int     cySysFont;

	// Solid brushes with convenient gray colors and system colors
	HBRUSH  hbrLtGray, hbrDkGray;
	HBRUSH  hbrBtnHilite, hbrBtnFace, hbrBtnShadow;

	// Color values of system colors used for CToolBar
	COLORREF    clrBtnFace, clrBtnShadow, clrBtnHilite;
	COLORREF    clrBtnText, clrWindowFrame;

	BOOL    bWin32s;            // TRUE if Win32s

// Implementation
protected:
	void SafeDelete(HGDIOBJ hObject);
};

extern CEtc g_etc;

