// filterbu.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
//#include "bbtrx1.h"
#include "stdafx.h"
#include "tttrx.h"
#include "filterbu.h"
#include "FilterDl.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern filter MasterFilterList_TX550[];

/////////////////////////////////////////////////////////////////////////////
// CFilterButtn

CFilterButton::CFilterButton()
{
FilterIndex=0;
}

CFilterButton::~CFilterButton()
{
}

BEGIN_MESSAGE_MAP(CFilterButton, CBiStateButton)
	//{{AFX_MSG_MAP(CFilterButton)
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilterButtn message handlers


void CFilterButton::OnRButtonDown(UINT nFlags, CPoint point)
{
char str[32];
double bw;
CString wintext;
GetWindowText(wintext);
sprintf(str,"Assign Filter to Selected Button.");

EnableWindow(FALSE);	// disable to show which button is being set
CFilterDlg FilterDialog;

FilterDialog.m_NoticeText=(const char *) str;
FilterDialog.m_FilterSelect=FilterIndex;
if(FilterDialog.DoModal()==IDOK)
{
	int itempic = FilterDialog.m_FilterSelect;

    bw=atof(MasterFilterList_TX550[itempic+1].name);
    if(bw<10) sprintf(str,"%1.2f",bw);
    else sprintf(str,"%3.0f",bw);

	FilterIndex=itempic+1;
	SetWindowText(str);
}
	EnableWindow(TRUE);	// re-enable to show which button is being set

}



void CFilterButton::ProgramFilterButton(int index)
{
char str[32];
double bw;

    bw=atof(MasterFilterList_TX550[index].name);
    if(bw<10) sprintf(str,"%1.2f",bw);
    else sprintf(str,"%3.0f",bw);

	FilterIndex=index;
	SetWindowText(str);
	
}	

