// filterpa.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
#include "tttrx.h"
#include "filterpa.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFilterPanel

CFilterPanel::CFilterPanel()
{
}

CFilterPanel::~CFilterPanel()
{
}

BEGIN_MESSAGE_MAP(CFilterPanel, CWnd)
	//{{AFX_MSG_MAP(CFilterPanel)
	ON_WM_CREATE()
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilterPanel message handlers


int CFilterPanel::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
 	CRect FPICBoxCrect(5,5,lpCreateStruct->cx-8,lpCreateStruct->cy-120);
	FilterPicBox.Create(FPICBoxCrect,this,ID_FILTERPIC_BOX);
	
	return 0;
}


BOOL CFilterPanel::OnEraseBkgnd(CDC* pDC)
{
	CBrush* pOldBrush=(CBrush*) pDC->SelectStockObject(LTGRAY_BRUSH);
	CPen* pOldPen=(CPen*) pDC->SelectStockObject(NULL_PEN);

	CBrush brushDarkGray(RGB(128,128,128));


	pDC->SetBkMode(OPAQUE);
	pDC->SetBkColor(RGB(192,192,192));

// get the area that needs to be erased
	CRect rcClip;									
	GetClientRect(rcClip);


// Fill client area witrh solid color first

	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(GRAY_BRUSH));
	pDC->FillRect(rcClip,(CBrush*) pDC->SelectStockObject(GRAY_BRUSH));

// Unselect brush out of device context

pDC->SelectObject(pOldBrush);
pDC->SelectObject(pOldPen);

return TRUE;	
}




void CFilterPanel::SetFilterBandwidth(int width)
{
	FilterPicBox.SetBandwidth(width);
}


afx_msg void CFilterPanel::SetFilterCenter(int Value)
{
FilterPicBox.SetCenter(Value);
return;
}
