// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


// CFreqDisplay File
// A Special Class Derived From CWnd class that displays numeric data and provides for
// editing of that data using a CEdit control during periods of editing




#include "stdafx.h"
#include "freqdisp.h"
#include <ctype.h>
#include <math.h>
IMPLEMENT_DYNAMIC(CFreqDisplay,CWnd)

// CNumeric Edit MEssage Map
BEGIN_MESSAGE_MAP(CFreqDisplay, CWnd)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_WM_KILLFOCUS()
//	ON_WM_SETFOCUS()
	ON_EN_KILLFOCUS(999,KillEditBox)
	ON_WM_CTLCOLOR()
	ON_EN_SETFOCUS(999,FocusOnFrequencyBox)
	ON_COMMAND(999,PassMessage)	
	ON_WM_CHAR()
END_MESSAGE_MAP()



CFreqDisplay::CFreqDisplay()
{
}


BOOL CFreqDisplay::Create(CRect sizepos, CWnd *PWnd,UINT nID,double initialfrequency=0.00)
{                   
m_ParentWnd=PWnd;
m_dFrequency=initialfrequency;
m_WindowRect=CRect(0,0,sizepos.right-sizepos.left,sizepos.bottom-sizepos.top);
m_WindowID=nID;

return CWnd::Create(NULL,NULL,WS_CLIPSIBLINGS|WS_CHILD|WS_VISIBLE,sizepos,PWnd,nID,NULL);
} 

afx_msg int CFreqDisplay::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	TextColor=RGB(255,255,0);
	CRect EdRect=m_WindowRect;
	EdRect.InflateRect(0,0);

	m_pFreqEditBox.Create(ES_LEFT|WS_CHILD,EdRect,this,999);
	return 0;
}



afx_msg void CFreqDisplay::OnPaint()
{

CBitmap Display;
CBrush brushFaceColor(RGB(0,0,0));
CBrush brushBodyColor(RGB(192,192,192));
CBrush brushBorderColor(RGB(0,0,0));


CPen penIndicatorColor(PS_SOLID,1,RGB(200,0,0));

CPen penShadowColor(PS_SOLID,1,RGB(128,128,128));
CPen penMediumShadowColor(PS_SOLID,1,RGB(63,63,63));

CPen penMediumHighlightColor(PS_SOLID,1,RGB(192,192,192));
CPen penHighlightColor(PS_SOLID,1,RGB(255,255,255));


CPaintDC cDC(this);
CDC memDC;

memDC.CreateCompatibleDC(&cDC); 

memDC.SelectObject(m_FreqFont);


CSize WindSize = memDC.GetTextExtent("00.000.00000",12);// m_WindowRect;

CRect rcClip= CRect(m_WindowRect.left,m_WindowRect.top,m_WindowRect.left+WindSize.cx,m_WindowRect.top+WindSize.cy);

Display.CreateDiscardableBitmap(&cDC,rcClip.right-rcClip.left,
								rcClip.bottom-rcClip.top);
memDC.SelectObject(&Display);

CBrush* pOldBrush=memDC.SelectObject(&brushBodyColor);

memDC.SetBkMode(TRANSPARENT);
// get the area that needs to be erased
CPoint wSize=(rcClip.Width(),rcClip.Height());
CRect rcFront(rcClip.left+5,rcClip.top+5,rcClip.right-5,rcClip.bottom-(wSize.x/3));

memDC.FillRect(rcClip,&brushFaceColor);

	CRect tRect=rcClip;//m_WindowRect;
	tRect.InflateRect(-2,-2);
	char tstr[16];
	sprintf(tstr,"%09.6f",m_dFrequency);
	memDC.SetTextColor(TextColor);
	memDC.DrawText(tstr,strlen(tstr),rcClip,DT_LEFT|DT_SINGLELINE|DT_VCENTER);


cDC.BitBlt(0,0,rcClip.right,rcClip.bottom,&memDC,0,0,SRCCOPY);


return;
}



void CFreqDisplay::SetFrequency(double freq)
{
m_pFreqEditBox.ShowWindow(SW_HIDE);
m_dFrequency=freq;
Invalidate();
}

void CFreqDisplay::OnLButtonDown(UINT nFlags,CPoint point)
{
SetFocus();

m_pFreqEditBox.ShowWindow(SW_SHOW);

char tstr[16];
sprintf(tstr,"%09.6f",m_dFrequency);
m_pFreqEditBox.SetWindowText(tstr);
m_pFreqEditBox.SetFont(m_FreqFont);
m_pFreqEditBox.SetFocus();
}

afx_msg void CFreqDisplay::FocusOnFrequencyBox()
{
 GetDescendantWindow(999,FALSE)->PostMessage(EM_SETSEL,0,MAKELONG(0,-1));
}

afx_msg void CFreqDisplay::OnSetFocus(CWnd* pOldWnd)
{
#ifdef MESSAGE_TESTING
MessageBox("CFreqDisplay Gaining Focus","WINDOW",MB_OK);
#endif
}

afx_msg void CFreqDisplay::OnKillFocus(CWnd* pNewWnd)
{

#ifdef MESSAGE_TESTING
MessageBox("CFreqDisplay Losing Focus","WINDOW",MB_OK);
#endif
Invalidate();
}

afx_msg void CFreqDisplay::KillEditBox()
{
#ifdef MESSAGE_TESTING
MessageBox("FreqEditBox losing Focus","WINDOW",MB_OK);
#endif
m_dFrequency=m_pFreqEditBox.GetNumeric();

m_pFreqEditBox.ShowWindow(SW_HIDE);


Invalidate();
PassMessage();
}


HBRUSH CFreqDisplay::OnCtlColor(CDC* pDC,CWnd* pWnd, UINT nCtlColor)
{
	pDC->SetBkMode(TRANSPARENT);

		pDC->SetTextColor(RGB(255,255,0));
		pDC->SetBkColor(RGB(192,192,192));
		return (HBRUSH) GetStockObject(BLACK_BRUSH);
}


void CFreqDisplay::PassMessage()
{
#ifdef MESSAGE_TESTING
		MessageBox("PASS MESSAGE","MESSAGE",MB_OK);
#endif
		GetParent()->SetFocus();
		GetParent()->SendMessage(WM_COMMAND,m_WindowID,(LPARAM) 0);
}



afx_msg void CFreqDisplay::SetWindowText(const char* lpszString)
{
m_pFreqEditBox.ShowWindow(SW_HIDE);

m_dFrequency=atof(lpszString);
Invalidate();
}

double CFreqDisplay::GetFrequency()
{
return m_dFrequency;
}

afx_msg void CFreqDisplay::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
OnLButtonDown(0,0);
m_pFreqEditBox.PostMessage(WM_CHAR,nChar,nRepCnt);

return;
}




void CFreqDisplay::SetFont(CFont* pFont)
{
m_FreqFont=pFont;

TRACE("SetFont in FreqDisp\n");
return;
}




void CFreqDisplay::SetColor(COLORREF color)
{
TextColor=color;
Invalidate();
}
