// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "meter.h"
#include "math.h"
#include "resource.h"
#define NumberOfCycle 3


#define LINEAR_FACTOR 206

BEGIN_MESSAGE_MAP(CMeter, CWnd)
   ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_CREATE()
END_MESSAGE_MAP()                

CMeter::CMeter()
{
m_SMeter_Setting=10;
m_PeakSetting=10;
m_SMeter_Maximum=120;
m_SMeter_Minimum=1;

m_Fwd_Setting=0;
m_Fwd_Maximum=120;
m_Fwd_Minimum=0;

m_Ref_Setting=0;
m_Ref_Maximum=120;
m_Ref_Minimum=0;

m_SWR_Setting=0;
m_SWR_Maximum=120;
m_SWR_Minimum=0;

}
        

CMeter::Create(CRect sizepos, CWnd *PWnd,UINT nID,int minscale=0,int maxscale=100 )
{                   
m_SMeter_Minimum=minscale;
m_SMeter_Maximum=maxscale;
m_WindowSize=CRect(0,0,sizepos.right-sizepos.left,sizepos.bottom-sizepos.top);
 return CWnd::Create(NULL,NULL,WS_CHILD|WS_VISIBLE,sizepos,PWnd,nID,NULL);
} 



afx_msg void CMeter::OnPaint()
{
char buff[32];
CBitmap Meter;
CBitmap MeterFace;
int IPointX,IPkPointX;
int temp,range,tempPk;
int lower_meter;
int upper_meter;


switch(m_DisplayMode)
{
case FORWARD_DISPLAY:
	MeterFace.LoadBitmap(IDB_METERFACE_FWD);
	break;
case REFLECTED_DISPLAY:
	MeterFace.LoadBitmap(IDB_METERFACE_REF);
	break;
case SWR_DISPLAY:
	MeterFace.LoadBitmap(IDB_METERFACE_SWR);
	break;	
case SMETER_DISPLAY:
	MeterFace.LoadBitmap(IDB_METERFACE);
	break;
}							



CBrush brushFaceColor(RGB(0,0,0));
CBrush brushBodyColor(RGB(0,0,0));
CBrush brushBorderColor(RGB(128,128,128));

CPen penIndicatorColor(PS_SOLID,3,RGB(192,0,0));
CPen penPeakIndicatorColor(PS_SOLID,3,RGB(0,192,0));
CPen penOverloadIndicatorColor(PS_SOLID,3,RGB(255,0,0));
CPen penShadowColor(PS_SOLID,1,RGB(128,128,128));
CPen penMediumShadowColor(PS_SOLID,1,RGB(63,63,63));
CPen penMediumHighlightColor(PS_SOLID,1,RGB(192,192,192));
CPen penHighlightColor(PS_SOLID,1,RGB(192,192,192));
CPen penGridColor(PS_SOLID,1,RGB(255,255,255));

CPaintDC cDC(this);
CDC memDC;
memDC.CreateCompatibleDC(&cDC); 
CBitmap* pOldBitmap = memDC.SelectObject(&MeterFace);
CFont* pOldFont=memDC.SelectObject(&m_TinyFont);
CRect rcClip=m_WindowSize;
memDC.SelectObject(&Meter);
CBrush* pOldBrush=memDC.SelectObject(&brushBodyColor);
memDC.SetBkMode(TRANSPARENT);
// get the area
CPoint wSize=(rcClip.Width(),rcClip.Height());
CRect rcFront(rcClip.left+5,rcClip.top+5,rcClip.right-5,rcClip.bottom-(wSize.x/3));
CRect MeterArea(rcClip.left+3,rcClip.top+3,rcClip.right-4,rcClip.bottom-3);
memDC.SelectObject(&penGridColor);
memDC.SetTextColor(RGB(255,255,0));
int meterheight=MeterArea.bottom-MeterArea.top;
int meterwidth=MeterArea.right-MeterArea.left-5;
int tick=0;
CSize csSize;

switch(m_DisplayMode)
{
case SMETER_DISPLAY:
	range=(int)(m_SMeter_Maximum-m_SMeter_Minimum);
	if(m_PeakSetting<m_SMeter_Setting) m_PeakSetting=m_SMeter_Setting;
	m_SMeter_Setting+=1; // protection against zero related errors
	m_PeakSetting+=1;

#define KNEE 0x900	// controls where meter switches scales
	lower_meter= (int)(meterwidth*0.667);
	upper_meter= (int)(meterwidth*0.333);
	
	if(m_SMeter_Setting<=KNEE)
	{
	temp=((float)((m_SMeter_Setting)/(float)KNEE))*lower_meter;
	tempPk=((float)((m_PeakSetting)/(float)KNEE))*lower_meter;
    }
	else
	{
	temp=lower_meter+((float)( ((m_SMeter_Setting-KNEE)/(float)(m_SMeter_Maximum-KNEE)))*2.0)*upper_meter;
	tempPk=lower_meter+((float)( ((m_PeakSetting-KNEE)/(float)(m_SMeter_Maximum-KNEE)))*2.0)*upper_meter;
	}



	IPointX=3+(int)(temp);
	IPkPointX=3+(int)(tempPk);
	cDC.BitBlt(0,0,wSize.x,wSize.y,&memDC,0,0,SRCCOPY);
	sprintf(buff,"%2.2f ~ %d",(float)(m_SMeter_Setting/256.0),IPointX);

	memDC.SelectObject(&penPeakIndicatorColor);		// peak indicator color
	if(IPkPointX>0 && IPkPointX<rcClip.right-2)
	{
	memDC.MoveTo(IPkPointX,rcClip.top+meterheight/2);
	memDC.LineTo(IPkPointX,rcClip.top+(meterheight*.60));
	}

	memDC.SelectObject(&penIndicatorColor);		// normal color if in range
	if(IPointX>0 && IPointX<rcClip.right-2)
	{
	memDC.MoveTo(IPointX,rcClip.top+meterheight/2);
	memDC.LineTo(IPointX,rcClip.top+(meterheight*.75));
	}

	memDC.SetTextColor(RGB(64,64,255));

break;
case FORWARD_DISPLAY:
	IPointX=15+(int)((m_Fwd_Setting)*meterwidth/(m_Fwd_Maximum-m_Fwd_Minimum));
	cDC.BitBlt(0,0,wSize.x,wSize.y,&memDC,0,0,SRCCOPY);
	memDC.SelectObject(&penIndicatorColor);		// normal color if in range
	sprintf(buff,"%d",m_Fwd_Setting);
	if(IPointX>0 && IPointX<rcClip.right-2)
	{
	memDC.MoveTo(IPointX,rcClip.bottom-5);
	memDC.LineTo(IPointX,rcClip.top+3+meterheight/2);
	}
	memDC.SetTextColor(RGB(64,64,255));
	memDC.DrawText(buff,-1,CRect(rcClip.left,rcClip.top+5,rcClip.right-10,rcClip.top+20),DT_SINGLELINE|DT_RIGHT);
break;	
case REFLECTED_DISPLAY:
	IPointX=15+(int)((m_Ref_Setting)*meterwidth/(m_Ref_Maximum-m_Ref_Minimum));
	cDC.BitBlt(0,0,wSize.x,wSize.y,&memDC,0,0,SRCCOPY);
	memDC.SelectObject(&penIndicatorColor);		// normal color if in range
	sprintf(buff,"%d",m_Ref_Setting);
	if(IPointX>0 && IPointX<rcClip.right-2)
	{
	memDC.MoveTo(IPointX,rcClip.bottom-5);
	memDC.LineTo(IPointX,rcClip.top+3+meterheight/2);
	}
	memDC.SetTextColor(RGB(64,64,255));
	memDC.DrawText(buff,-1,CRect(rcClip.left,rcClip.top+5,rcClip.right-10,rcClip.top+20),DT_SINGLELINE|DT_RIGHT);
break;	
case SWR_DISPLAY:
	IPointX=3+(int)((m_SWR_Setting/10)*meterwidth/(m_SWR_Maximum-m_SWR_Minimum));
	cDC.BitBlt(0,0,wSize.x,wSize.y,&memDC,0,0,SRCCOPY);
	memDC.SelectObject(&penIndicatorColor);		// normal color if in range
	sprintf(buff,"%2.2f : 1",(float)(m_SWR_Setting/100.0));
	if(IPointX>0 && IPointX<rcClip.right-2)
	{
	memDC.MoveTo(IPointX,rcClip.bottom-5);
	memDC.LineTo(IPointX,rcClip.top+3+meterheight/2);
	}
	memDC.SetTextColor(RGB(64,64,255));
	memDC.DrawText(buff,-1,CRect(rcClip.left,rcClip.top+5,rcClip.right,rcClip.top+20),DT_SINGLELINE|DT_CENTER);
break;	

}

// Shadow layer
memDC.SelectObject(&penShadowColor);
memDC.MoveTo(rcClip.left,rcClip.bottom-1);
memDC.LineTo(rcClip.left,rcClip.top);
memDC.LineTo(rcClip.right-1,rcClip.top);

memDC.SelectObject(&penMediumShadowColor);
memDC.MoveTo(rcClip.left+1,rcClip.bottom-2);
memDC.LineTo(rcClip.left+1,rcClip.top+1);
memDC.LineTo(rcClip.right-1,rcClip.top+1);

memDC.SelectObject(&penMediumHighlightColor);
memDC.MoveTo(rcClip.right-2,rcClip.top+1);
memDC.LineTo(rcClip.right-2,rcClip.bottom-2);
memDC.LineTo(rcClip.left+1,rcClip.bottom-2);

memDC.SelectObject(&penHighlightColor);
memDC.MoveTo(rcClip.right-1,rcClip.top);
memDC.LineTo(rcClip.right-1,rcClip.bottom-1);
memDC.LineTo(rcClip.left,rcClip.bottom-1);




cDC.BitBlt(0,0,rcClip.right,rcClip.bottom,&memDC,0,0,SRCCOPY);
memDC.SelectObject(pOldFont);
memDC.SelectObject(pOldBitmap);
return;
}


afx_msg void CMeter::SetIndicator(long int Value,int m_MeterMode)
{
m_DisplayMode=m_MeterMode;
switch(m_DisplayMode)
	{
	case SMETER_DISPLAY:
		if(Value>1) m_SMeter_Setting=Value;
		else m_SMeter_Setting=1;
	break;
	case FORWARD_DISPLAY:
		m_Fwd_Setting=Value;
	break;
	case REFLECTED_DISPLAY:
		m_Ref_Setting=Value;
	break;
	case SWR_DISPLAY:
		m_SWR_Setting=Value;
	break;
	}

Invalidate(FALSE);
return;
}

afx_msg void CMeter::SetPeakIndicator(long int Value,int m_MeterMode)
{
m_DisplayMode=m_MeterMode;
switch(m_DisplayMode)
	{
	case SMETER_DISPLAY:
		if(Value>1) m_PeakSetting=Value;
		else m_PeakSetting=1;
	break;
	}
Invalidate(FALSE);
return;
}



void CMeter::SetMeterLimits(int min,long int max,int m_MeterMode)
{
m_DisplayMode=m_MeterMode;
switch(m_DisplayMode)
	{
	case SMETER_DISPLAY:
		m_SMeter_Minimum=min;
		m_SMeter_Maximum=max;
	break;
	case FORWARD_DISPLAY:
		m_Fwd_Maximum=max;
		m_Fwd_Minimum=min;
	break;                                                                                                     
	case REFLECTED_DISPLAY:
		m_Ref_Maximum=max;
		m_Ref_Minimum=min;
	break;
	case SWR_DISPLAY:
		m_SWR_Maximum=max;
		m_SWR_Minimum=min;
	break;
	}

Invalidate(FALSE);
}

         
afx_msg void CMeter::OnLButtonDown(UINT nFlags,CPoint point)         
{
 CWnd::OnLButtonDown(nFlags,point);
}

         

int CMeter::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    m_TinyFont.CreateFont(14,0,0,0,FW_DONTCARE,0,0,0,ANSI_CHARSET,
    					OUT_DEVICE_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
    					DEFAULT_PITCH|FF_DONTCARE,"Arial");

	return 0;
}         
         
         
         