// repbutto.cpp : implementation file

// Ten-Tec Graphic Interface Radio Control Program
// Pegasus Control GUI (c) 1999,2000 Ten-Tec Inc.
// The source code contained in this file and associated files is copyright Ten-Tec, Inc.


#include "stdafx.h"
#include "tttrx.h"
#include "repbutto.h"              

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define DELAY_TIME	200
#define REPEAT_TIME	100


/////////////////////////////////////////////////////////////////////////////
// CRepButton                

CRepButton::CRepButton()
{
}

CRepButton::~CRepButton()
{
KillTimer(REP_TIMER_DELAY);
KillTimer(REP_TIMER_REPEAT);
}


BEGIN_MESSAGE_MAP(CRepButton, CButton)
	//{{AFX_MSG_MAP(CRepButton)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_TIMER()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CRepButton message handlers
void CRepButton::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	CRepButton::OnLButtonDown(nFlags, point);
}

void CRepButton::OnLButtonDown(UINT nFlags, CPoint point) 
{
	m_MouseState=TRUE;
	GetOwner()->SendMessage(MSG_RB_FREQ,(WPARAM) GetDlgCtrlID() ,(LPARAM) 3);
	SetTimer(REP_TIMER_DELAY,DELAY_TIME,NULL);

	CButton::OnLButtonDown(nFlags, point);
}

void CRepButton::OnLButtonUp(UINT nFlags, CPoint point) 
{
	KillTimer(REP_TIMER_DELAY);
	KillTimer(REP_TIMER_REPEAT);	
	SetFocusToParent();
	CButton::OnLButtonUp(nFlags, point);
}

void CRepButton::OnTimer(UINT nIDEvent) 
{
	if(m_MouseState==TRUE)
	{
	switch(nIDEvent)
	{
	case REP_TIMER_DELAY:
		KillTimer(REP_TIMER_DELAY);
		SetTimer(REP_TIMER_REPEAT,REPEAT_TIME,NULL);
	GetOwner()->SendMessage(MSG_RB_FREQ,(WPARAM) GetDlgCtrlID() ,(LPARAM) 3);
		break;
	case REP_TIMER_REPEAT:
	GetOwner()->SendMessage(MSG_RB_FREQ,(WPARAM) GetDlgCtrlID() ,(LPARAM) 3);
	break;
	}	
			
	} //end of main IF

}



void CRepButton::OnMouseMove(UINT nFlags,CPoint point)
{
CRect WndRect;
GetClientRect(WndRect);
if(WndRect.PtInRect(point)==0) m_MouseState=FALSE;
else m_MouseState=TRUE;
}


void CRepButton::SetFocusToParent()
{
	GetParent()->SetFocus();
}